#version unofficial MegaPov 0.6;

#ifndef (ISOSURF_INC)
  #declare ISOSURF_INC = 0 ;
  
  #include "enter"
  #include "metrics.inc"
  #include "text.inc"

  #macro WhiteWoodBlock (W, H, L, Rad, Tr, Rot)
    #local func1 = function { "rounded_box", <Rad, W/2, H/2, L/2> }
    #local func2 = function { pigment { PWhiteWood rotate Rot translate Tr } }
    isosurface {
      function { func1(x, y, z) + (Rad/2)*(func2(x, y, z)-0.75) }
      contained_by {
        box { <-W/2-Rad/8, -H/2-Rad/8, -L/2-Rad/8>, <W/2+Rad/8, H/2+Rad/8, L/2+Rad/8> }
      }
      threshold 0
      //eval
      max_gradient Rad*6
      accuracy 0.005
    }
  #end
  
  #macro DarkWoodBlock (W, H, L, Rad, Tr, Rot)
    #local func1 = function { "rounded_box", <Rad, W/2, H/2, L/2> }
    #local func2 = function { pigment { PDarkWood rotate Rot translate Tr } }
    /*#local mini = 2; #local maxi = -1;
    #local i=0; #while (i < 2)
      #local j=0; #while (j < 2)
        #local k=0; #while (k < 2)
          #local tmp = eval_pattern ( function { func2(x, y, z) }, <i, j, k> );
          #if (tmp < mini) #local mini = tmp; #end
          #if (tmp > maxi) #local maxi = tmp; #end
          #local k = k + 0.1 ;
        #end
        #local j = j + 0.1 ;
      #end
      #local i = i + 0.1 ;
    #end
    #debug concat ("min: ", str (mini, 4, 4), ", max: ", str (maxi, 4, 4), "\n")*/
    isosurface {
      function { func1(x, y, z) + (Rad)*(func2(x, y, z)-0.33) }
      contained_by {
        box { <-W/2-Rad, -H/2-Rad, -L/2-Rad>, <W/2+Rad, H/2+Rad, L/2+Rad> }
      }
      threshold 0
      max_gradient Rad*25
      //eval
      method 2
      accuracy 0.005
    }
  #end
  
  #macro RoundedBox (W, H, L, R)
    #if (HighQuality)
      #local Func = function { "rounded_box", <R, W/2, H/2, L/2> }
      isosurface {
        function { Func(x, y, z) }
        contained_by { box { -<W, H, L>/2, <W, H, L>/2 } }
      }
    #else
      box { -<W, H, L>/2, <W, H, L>/2 }
    #end
  #end
  
  #include "leave"
#end