#version unofficial MegaPov 0.6;

#ifndef (LANTERN_INC)
  #declare LANTERN_INC = 0 ;
  
  #ifndef (HighQuality)
    #declare HighQuality = on ;
  #end
  
  #include "enter"
  #include "metrics.inc"
  #include "text.inc"
  
  #local Side = union {
    box { <-6.5, 0.5, -6.9>*cm, <6.5, 4, -6.1>*cm }
    box { <-6.5, 20.5, -6.9>*cm, <6.5, 22, -6.1>*cm }
    box { <-6.5, 0.5, -6.9>*cm, <-4.5, 22, -6.1>*cm }
    box { <6.5, 0.5, -6.9>*cm, <4.5, 22, -6.1>*cm }
    
    cylinder { <-4.5, 4, -6.9>*cm, <-4.5, 4, -6.1>*cm, 1.5*cm }
    cylinder { <4.5, 4, -6.9>*cm, <4.5, 4, -6.1>*cm, 1.5*cm }
    cylinder { <-4.5, 20.5, -6.9>*cm, <-4.5, 20.5, -6.1>*cm, 1.5*cm }
    cylinder { <4.5, 20.5, -6.9>*cm, <4.5, 20.5, -6.1>*cm, 1.5*cm }
  }

  #declare Lantern = union {
    box { <-7.5, 0, -7.5>*cm, <7.5, 1, 7.5>*cm }
    box { <-7.5, 21.5, -7.5>*cm, <7.5, 22.5, 7.5>*cm }
    cylinder { <-6.5, 0.5, -6.5>*cm, <-6.5, 22, -6.5>*cm, 1*cm }
    cylinder { <6.5, 0.5, -6.5>*cm, <6.5, 22, -6.5>*cm, 1*cm }
    cylinder { <6.5, 0.5, 6.5>*cm, <6.5, 22, 6.5>*cm, 1*cm }
    cylinder { <-6.5, 0.5, 6.5>*cm, <-6.5, 22, 6.5>*cm, 1*cm }
    object { Side }
    object { Side rotate 90*y }
    object { Side rotate 180*y }
    object { Side rotate -90*y }
    box { <2.5, 10, -6>*cm, <5, 14, -6.9>*cm }
    cylinder { <3.5, 12, -6.5>*cm, <3.5, 12, -8>*cm, 3*mm }
    torus { 1*cm, 3*mm rotate 90*z scale <1, 1, 0.5> translate <3.5, 12, -8.5>*cm }
    
    difference {
      box { <-6.7, 0.5, -6.7>*cm, <6.7, 22, 6.7>*cm }
      box { <-6.3, 0.4, -6.3>*cm, <6.3, 22.2, 6.3>*cm }
      pigment { color rgbf 1 }
      hollow
      interior {
        media {
          scattering { 1, rgb <255, 254, 187>/(150*cm) }
          method 3
          intervals 1
          samples 3, 1000
        }
        ior 1.5
      }
      //finish { reflection 0.1 specular 0.1 }
    }
    intersection {
      #local H = 3 ;
      box { <-6.51, -0.01, -6.51>, <6.51, H+0.01, 6.51> }
      cylinder { <-7, H-(42.25+H*H)/(2*H), 0>, <7, H-(42.25+H*H)/(2*H), 0>, (42.25+H*H)/(2*H) }
      cylinder { <0, H-(42.25+H*H)/(2*H), -7>, <0, H-(42.25+H*H)/(2*H), 7>, (42.25+H*H)/(2*H) }
      translate 22.5*y
      scale 1*cm
    }
    sphere {
      0, 2*cm scale <1, 0.5, 1>
      translate 25.5*cm*y
    }
    sphere { 27*cm*y, 1*cm }
    torus { 5*cm, 5*mm translate 5*cm*x scale <0.67, 1, 1> rotate -20*z translate 27*cm*y }
    #if (!included)
      light_source {
        10*cm*y
        rgb <1.1, 1.05, 0.8>*2
        fade_distance 10*cm
        fade_power 2
      }
    #end
    texture { DarkMetal }
  }
  
  #if (!included)
    #declare Radiosity = on ;
    global_settings {
      assumed_gamma 1
      #if (Radiosity)
        ini_option "+QR"
        radiosity {
          #if (HighQuality)
            pretrace_start 0.08
            pretrace_end 0.02
            count 100
            nearest_count 20
            error_bound 1
            always_sample no
            //normal on
          #end
          media on
          recursion_limit 3
          adc_bailout 0.01/5
        }
      #end
    }
    camera {
      up y
      right (image_width/image_height)*x
      location 50*cm*y-1*m*z
      look_at  30*cm*y
      angle 40
    }
    #if (!Radiosity)
      light_source {
        <1000, 1000, -1000>*m
        color rgb 1
      }
      light_source {
        <0, 1000, 1000>*m
        color rgb 1.5
      }
    #end
    light_source {
      <-1000, 1000, -1000>*m
      color rgb 1/4
    }

    cylinder {
      -y, 0, 2*m
      pigment {
        checker
        color rgb 0.25
        color rgb 0.50
        scale 20*cm
      }
      finish {
        diffuse 0.5
        reflection 0.25
        reflection_blur 0.05
        reflection_samples 1
      }
      rotate 30*y
    }
    
    object {
      Lantern
      rotate 30*y
    }
  #end
  
  #include "leave"
#end