#version unofficial MegaPov 0.6;

#ifndef (PLATE_INC)
  #declare PLATE_INC = 0 ;
  
  #ifndef (HighQuality)
    #declare HighQuality = on ;
  #end
  
  #include "enter"
  #include "metrics.inc"
  #include "text.inc"
  #include "isosurf.inc"
  #include "cedar.map"

  #declare Plate = difference {
    object { RoundedBox(0.75, 1, 0.5, 0.1) scale <30, 30, 1>*cm translate 15*cm*y }
    cylinder { -1*cm*z, 1*cm*z, 1.5*cm scale <1, 1.5, 1> translate -6*cm*x+24*cm*y }
    texture {
      pigment {
        wood
        color_map { M_Cedar }
        turbulence 0.15
        scale 2*cm
      }
      normal {
        wood 0.1
        turbulence 0.15
        scale 2*cm
      }
      finish {
        brilliance 1.2
        specular 0.01
        roughness 0.2
      }
      rotate 70*x
      translate 20*cm*y
    }
    SplashPaint (0.3)
    Dirty (1*cm, 4)
    #macro Rotate (A)
      rotate A*z translate <8*cos(A*pi/180), 10*sin(A*pi/180)+15, -0.5>*cm
    #end
    texture {
      pigment {
        average
        pigment_map {
          [ 1 PaintSpot (0, 4) Rotate (45) ]
          [ 1 PaintSpot (1, 4) Rotate (10) ]
          [ 1 PaintSpot (<1, 0, 0>, 4) Rotate (-10) ]
          [ 1 PaintSpot (<0, 1, 0>, 4) Rotate (-45) ]
          [ 1 PaintSpot (<0, 0, 1>, 4) Rotate (-90) ]
        }
      }
      finish { diffuse 0.99 }
    }
    Dirty(1*cm, 1)
  }
  
  #if (!included)
    global_settings {
      assumed_gamma 1
    }
    camera {
      up y
      right (image_width/image_height)*x
      location 110*cm*y-2*m*z
      look_at  60*cm*y
      angle 40
      //angle 5
    }
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    light_source {
      <-1000, 1000, -1000>*m
      color rgb 1/4
    }
    light_source {
      <0, 1000, 1000>*m
      color rgb 1.5
    }
    
    cylinder {
      -y, 0, 2*m
      pigment {
        checker
        color rgb 0.25
        color rgb 0.50
        scale 20*cm
      }
      finish {
        diffuse 0.5
        reflection 0.25
        reflection_blur 0.05
        reflection_samples 1
      }
      rotate 30*y
    }
    
    object {
      Plate
//      rotate 30*y
    }
  #end
  
  #include "leave"
#end
