#version unofficial MegaPov 0.6;

#ifndef (STABLE_INC)
  #declare STABLE_INC = 0 ;
  
  #ifndef (HighQuality)
    #declare HighQuality = on ;
  #end
  
  #include "enter"
  #include "metrics.inc"
  #include "text.inc"
  #include "isosurf.inc"
  #include "bottle.inc"
  #include "glass.inc"
  #include "paintbrush.inc"
  #include "paintbrush2.inc"
  #include "plate.inc"
  #include "timbal.inc"

  #local Foot = union {
    cone { 0, 2*cm, 65*cm*y, 3*cm }
    #if (!HighQuality)
      box { <-3, 56, -3>*cm, <3, 68, 3>*cm }
    #else
      object {
        WhiteWoodBlock (6, 6, 12, 0.5, 0, 0)
        texture {
          pigment { PWhiteWood }
          finish { FWhiteWood }
        }
        Dirty (1, 3)
        rotate 90*x
        translate 62*y
        scale 1*cm
      }
    #end
    texture {
      WhiteWood()
      rotate 90*x
    }
    Dirty (1*cm, 3)
  }
  
  
  #declare SmallTable = union {
    #if (!HighQuality)
      box {
        <-35, 67, -30>*cm, <35, 70, 30>*cm
        texture {
          WhiteWood()
          rotate 90*y
          translate 68.5*cm*y
        }
        SplashPaint(0.25)
        Dirty(1, 3)
      }
    #else
      #local Tr = <rand (Seed), rand (Seed), rand (Seed)>;
      #local Rot = <rand (Seed)-0.5, rand (Seed)-0.5, rand (Seed)*360>;
      object {
        WhiteWoodBlock (19, 3, 70, 0.75, Tr, Rot)
        texture {
          pigment { PWhiteWood rotate Rot translate Tr }
          finish { FWhiteWood }
        }
        SplashPaint(0.25)
        Dirty(1, 3)
        rotate 90*y
        translate 68.5*y-20*z+(rand (Seed)-0.5)*5*x
        scale 1*cm
      }
      #local Tr = <rand (Seed), rand (Seed), rand (Seed)>;
      #local Rot = <rand (Seed)-0.5, rand (Seed)-0.5, rand (Seed)*360>;
      object {
        WhiteWoodBlock (19, 3, 70, 0.75, Tr, Rot)
        texture {
          pigment { PWhiteWood rotate Rot translate Tr }
          finish { FWhiteWood }
        }
        SplashPaint(0.25)
        Dirty(1, 3)
        rotate 90*y
        translate 68.5*y+(rand (Seed)-0.5)*5*x
        scale 1*cm
      }
      #local Tr = <rand (Seed), rand (Seed), rand (Seed)>;
      #local Rot = <rand (Seed)-0.5, rand (Seed)-0.5, rand (Seed)*360>;
      object {
        WhiteWoodBlock (19, 3, 70, 0.75, Tr, Rot)
        texture {
          pigment { PWhiteWood rotate Rot translate Tr }
          finish { FWhiteWood }
        }
        SplashPaint(0.25)
        Dirty(1, 3)
        rotate 90*y
        translate 68.5*y+20*z+(rand (Seed)-0.5)*5*x
        scale 1*cm
      }
    #end
    #if (!HighQuality)
      box {
        <-32, 57, -27>*cm, <32, 68, 27>*cm
        texture {
          WhiteWood()
          rotate 90*y
          translate 62*cm*y
        }
        Dirty (1*cm, 3)
      }
    #else
      #local Tr = <rand (Seed), rand (Seed), rand (Seed)>;
      #local Rot = <rand (Seed)-0.5, rand (Seed)-0.5, rand (Seed)*360>;
      object {
        WhiteWoodBlock (4, 11, 64, 0.2, Tr, Rot)
        texture {
          pigment { PWhiteWood rotate Rot translate Tr }
          finish { FWhiteWood }
        }
        Dirty (1, 3)
        rotate 90*y
        translate 62.5*y-25*z
        scale 1*cm
      }
      box {
        <-32, -5.5, -2>*cm, <32, 5.5, 2>*cm
        texture { WhiteWood() rotate 90*y }
        Dirty (1*cm, 3)
        translate 62.5*cm*y+25*cm*z
      }
      box {
        <-2, -5.5, -27>*cm, <2, 5.5, 27>*cm
        texture { WhiteWood() }
        Dirty (1*cm, 3)
        translate 62.5*cm*y-30*cm*x
      }
      box {
        <-2, -5.5, -27>*cm, <2, 5.5, 27>*cm
        texture { WhiteWood() }
        Dirty (1*cm, 3)
        translate 62.5*cm*y+30*cm*x
      }
    #end
    object { 
      Foot
      translate -65*cm*y
      rotate x-2*z
      translate 65*cm*y
      translate <-30, 0,-25>*cm
    }
    object { 
      Foot
      translate -65*cm*y
      rotate -2*x-z
      translate 65*cm*y
      translate < 30, 0,-25>*cm 
    }
    object {
      Foot
      translate -65*cm*y
      rotate 2*x+z
      translate 65*cm*y
      translate <-30, 0, 25>*cm
    }
    object {
      Foot
      translate -65*cm*y
      rotate -x+2*z
      translate 65*cm*y
      translate < 30, 0, 25>*cm
    }
    
    object {
      Plate
      rotate 16*x
      translate -3*cm*x-9.5*cm*z
      rotate -30*y
      translate <30, 0, -25>*cm
    }

    object {
      Timbal
      translate <10, 70, 5>*cm
    }
    
    union {             // bowl
      merge {
        difference {
          sphere { 0, 8*cm }
          sphere { 0, 7.5*cm }
          plane { -y, 0 }
          scale <1, 0.75, 1>
          translate 6*cm*y
        }
        torus { 7.75*cm, 0.25*cm translate 6*cm*y }
        torus { 3*cm, 1*cm translate 1*cm*y }
        material { MRedGlass }
      }
      difference {
        #local FWater = finish { reflection 0.05 diffuse 0.1 blinn 0.25 facets 0.3 }
        #local PWater = pigment { color rgbf 0.9 }
        sphere { 0, 7.5001*cm pigment { PWater } finish { FWater } }
        plane { -y, 2*cm pigment { PWater } finish { FWater } normal { bumps 1 scale 1*cm } }
        interior { ior 1.33 fade_distance 10*cm fade_power 10000 fade_color rgb 0.3 }
        scale <1, 0.75, 1>
        translate 6*cm*y
      }
      photons { target refraction on ignore_photons }
      translate <26, 70, -6>*cm
    }
   
    object {
      PaintBrush
      rotate 50*y
      translate <20, 70, -15>*cm
    }
    object {
      PaintBrush2
      rotate 20*y
      translate <16, 70, -10>*cm
    }
    
    object {
      Glass
      rotate -150*y
      translate <15, 70, -20>*cm
    }
    
    object {
      Bottle
      translate <20, 70, 10>*cm
    }
    
    pigment { color rgb <0.50, 0.34, 0.15> }
  }
  
  #if (!included)
    global_settings {
      assumed_gamma 1
      max_trace_level 10
      photons {
        spacing 1*mm
        autostop 0
      }
    }
    camera {
      up y
      right (image_width/image_height)*x
      location 110*cm*y-2*m*z
      look_at  60*cm*y
      angle 40
      //angle 20
    }
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    light_source {
      <-1000, 1000, -1000>*m
      color rgb 1/4
    }
    light_source {
      <0, 1000, 1000>*m
      color rgb 1.5
    }
    
    cylinder {
      -y, 0, 2*m
      pigment {
        checker
        color rgb 0.25
        color rgb 0.50
        scale 20*cm
      }
      finish {
        diffuse 0.5
        reflection 0.25
        reflection_blur 0.05
        reflection_samples 1        
      }
      rotate 30*y
    }
    
    object {
      SmallTable
      //Foot
      rotate 30*y
      //rotate 90*y
      //translate 40*cm*x+40*cm*y
    }
  #end
  
  #include "leave"
#end