#version unofficial MegaPov 0.6;

#ifndef (TIMBAL_INC)
  #declare TIMBAL_INC = 0 ;
  
  #ifndef (HighQuality)
    #declare HighQuality = on ;
  #end
  
  #include "enter"
  #include "metrics.inc"
  #include "text.inc"

  #local Radius = function { sqrt (x*x+z*z) + noise3d (x, y, z)/2 }
  #declare Timbal = isoblob {
    threshold 0.01
    
    function { -if (Radius (x, z, y)-3, Radius (x, z, y)-3.1, 2.9-Radius (x, z, y)) + 0.01 } // Main body
    function { ((-Radius (x, z, y)+3) & (if (z-0.1, 0.2-z, z) + noise3d (x, z, y)/2)) + 0.01 } // bottom
    function { max ((0.2 - sqrt (sqr (Radius (x, z-0.3, y) - 3) + sqr (z-0.3))) + 0.01, 0) } //rim
    
    cylinder { 0.1*y, 8*y, 3.5, strength 1 function 1 }
    cylinder { -0.1*y, 0.3*y, 3.5, strength 1 function 2 }
    cylinder { 7.7*y, 8.3*y, 3.5, strength 1 function 3 }
    
    scale 1*cm
    material { MSilver }
  }
  
  #if (!included)
    global_settings {
      assumed_gamma 1
    }
    camera {
      up y
      right (image_width/image_height)*x
      location 20*cm*y-50*cm*z
      look_at  10*cm*y
      angle 40
    }
    light_source {
      110*cm*y-3*m*z
      color rgb 0.25
      shadowless
    }
    
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    light_source {
      <-1000, 1000, -1000>*m
      color rgb 1/4
    }
    light_source {
      <0, 1000, 1000>*m
      color rgb 1.5
    }
    
    cylinder {
      -y, 0, 2*m
      pigment {
        checker
        color rgb 0.25
        color rgb 0.50
        scale 20*cm
      }
      finish {
        diffuse 0.5
        reflection 0.25
        reflection_blur 0.05
        reflection_samples 1
      }
      rotate 30*y
    }
    
    object {
      Timbal
      rotate 30*y
    }
  #end
  
  #include "leave"
#end
