#version unofficial MegaPov 0.6;

#ifndef (PAINTBRUSH_INC)
  #declare PAINTBRUSH_INC = 0 ;
  
  #ifndef (HighQuality)
    #declare HighQuality = on ;
  #end
  
  #include "enter"
  #include "metrics.inc"
  #include "text.inc"

  #declare PaintBrush = union {
    object {
      #include "brush.inc"
      rotate -90*x
      scale <1.5, 3, 1.5>*mm
      pigment {
        bozo
        color_map {
          [ 0.45 rgb <0.8, 0.4, 0.1>/16 ]
          [ 0.50 rgb <0.8, 0.5, 0.1>/8 ]
          [ 0.55 rgb <0.8, 0.4, 0.1>/16 ]
        }
        scale <1*mm, 1*cm, 1*mm>
      }
      normal {
        bozo 0.1
        scale <1*mm, 1*cm, 1*mm>
      }
      translate 17.9*cm*y
    }
    difference {
      cone { 14.2*cm*y, 4*mm, 18*cm*y, 3*mm }
      torus { 4.2*mm, 1*mm translate 14.4*cm*y }
      torus { 4*mm, 1*mm translate 14.8*cm*y }
      material { MSilver }
    }
    union {
      cone { 3*mm*y, 3*mm, 14.3*cm*y, 3.9*mm }
      sphere { 3*mm*y, 3*mm }
      texture { TLightWood rotate 90*x }
    }
    translate -3*mm*y
    rotate -89.5*z
    translate 3*mm*y
  }
  
  #if (!included)
    global_settings {
      assumed_gamma 1
    }
    camera {
      up y
      right (image_width/image_height)*x
      location 10*cm*y-50*cm*z
      look_at  0*cm*y
      angle 20
    }
    light_source {
      110*cm*y-3*m*z
      color rgb 0.25
      shadowless
    }
    
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    light_source {
      <-1000, 1000, -1000>*m
      color rgb 1/4
    }
    light_source {
      <0, 1000, 1000>*m
      color rgb 1.5
    }
    
    cylinder {
      -y, 0, 2*m
      pigment {
        checker
        color rgb 0.25
        color rgb 0.50
        scale 20*cm
      }
      finish {
        diffuse 0.5
        reflection 0.25
        reflection_blur 0.05
        reflection_samples 10
      }
      rotate 30*y
    }
    
    object {
      PaintBrush
      translate -12*cm*x
      rotate 30*y
    }
  #end
  
  #include "leave"
#end
