#declare CBott  = camera { location <  0, -5,  1> look_at <0, 0, 1> }
#declare CTop   = camera { location <  0, 30,  0> look_at <0, 0, 0> }
#declare CLeft  = camera { location <  0,  3,-30> look_at <0, 3,-5> }
#declare CRight = camera { location <  0,  0, 10> look_at <0, 0, 0> }
#declare CBack  = camera { location <-20,  5,  0> look_at <0, 0, 0> }
#declare CFront = camera { location < 20,  5,  0> look_at <0, 0, 0> }
#declare CCool  = camera { location < 25,  5,-15> look_at <0, 0, 0> }

#declare TPurple = texture { pigment { rgb <0.5, 0.33, 0.5> } }
#declare TYellow = texture { pigment { rgb <1, 0.6, 0> } }
#declare TWhite  = texture { pigment { rgb <1, 1, 1> } }
#declare TEye    = texture { pigment { rgb <1, 1, 1> } }
#declare TSkin   = texture { pigment { rgb <1, 0.6, 0.4> } }
#declare THair   = texture { pigment { rgb <1, 1, 0> } }
#declare TRope   = texture { pigment { rgb <1, 0, 0> } }
#declare TPants  = texture { pigment { rgb <0.8, 0.4, 0.4> } }
#declare TTop    = texture { pigment { rgb <0.3, 0.3, 0.3> } }
#declare TBrown  = texture { 
  pigment { rgb <0.5, 0.3, 0.2> }
  normal { wrinkles 1 turbulence 2 frequency 1 }
}

#include "MaxxHead.inc"   // 198 patches
#include "MaxxBody.inc"   // 596 patches
#include "JulieHead.inc"  // 640 patches
#include "JulieBody.inc"  // 425 patches

light_source {
  <0, 10, 330>
  color rgb <8,0,0>
  spotlight
  point_at <-60, 10, 130>
  radius 5
  tightness 50
  falloff 8
}

light_source {
  <100, 200, -100>
  color rgb <1,1,1>
  spotlight
  point_at <0, 0, 0>
  radius 3
  tightness 50
  falloff 5
}

camera { CCool }


// Characters

object {
  MaxxHead
  rotate <0, 0, -40>
  translate <5.4, 5.4, -1>
}

object {
  MaxxBody
  scale <7, 7, 7>
  rotate <0, -90, 0>
  translate <0, 1, 2>
} 

union {
  object { JulieHead }
  object { JulieBody }
  scale <0.55, 0.55, 0.55>
  rotate <0, -105, 0>
  translate <-1.0, 2.7, -8.5>
}


// Background

box {
  <-40, -5, -30>
  < 30, -6,  40>
  texture {
    pigment { rgb <0.3, 0.3, 0.3> }
    normal { marble turbulence 2 scale 8 }
  }
}

box {
  <-60, -50, -30>
  <-61, 100, 300> 
  texture {
    pigment { rgb <0.1, 0.1, 0.1> }
    normal { wrinkles 0.5 scale 50 }
  }
}

union {
  text {
    ttf "comicbd.ttf",
    "LEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE ",
    0.1, 0
    rotate <0, -90, 0>
    scale <8, 8, 8>
    translate <-60, 40, -20>
  }
  text {
    ttf "comicbd.ttf",
    "SE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLE",
    0.1, 0
    rotate <0, -90, 0>
    scale <8, 8, 8>
    translate <-60, 30, -20>
  }
  text {
    ttf "comicbd.ttf",
    "PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE",
    0.1, 0
    rotate <0, -90, 0>
    scale <8, 8, 8>
    translate <-60, 20, -20>
  }
  text {
    ttf "comicbd.ttf",
    "ASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PLEASE PL",
    0.1, 0
    rotate <0, -90, 0>
    scale <8, 8, 8>
    translate <-60, 10, -20>
  }
  text {
    ttf "comicbd.ttf",
    "                                DONT LEAVE",
    0.1, 0
    rotate <0, -90, 0>
    scale <8, 8, 8>
    translate <-60, 0, -20>
  }
  texture { pigment { rgb <0.2, 0.2, 0.2> } }
}
