// A bike shed. Copyright 2000 M. D. Mackey

#include "corrugatediron.inc"

#declare bspost_texture=
texture{
  finish{ambient 0 diffuse 0.8 phong 0.6 phong_size 90}
  pigment{color rgb <0.2,0.5,0.2>}
}

#declare bsrail_texture=
texture{
  finish{ambient 0 diffuse 0.6 phong 1.0 phong_size 50}
  pigment{color Gray70}
}

#declare bswall_texture=
texture{
  finish{ambient 0 diffuse 0.6 phong 1.0 phong_size 50}
  pigment{color Gray70}
}

#declare rail=
intersection {
  difference {
    cylinder{ <-0.005,0,0> <0.005,0,0> 0.6 }
    cylinder{ <-0.006,0,0> <0.006,0,0> 0.59 }
  }
  box{ <-0.006,0,0> <0.006,0.61,0.61>}
}

#declare bikepost= // bike post, rails in -z direction
union {
  cylinder{ <0,0,0> <0,1,0> 0.06 }
  cylinder{ <0,1,0> <0,1.05,0> 0.08 }
  object { rail translate x*0.05}
  object { rail translate -x*0.05}
  rotate y*180
  texture {bsrail_texture}
}
  

#declare pheight=2.5;
#declare pwidth=0.07;
#declare sheight=0.3;
#declare swidth=0.03;

#declare bikeshedpost= // front left post, rotate as appropriate
union {
  cylinder { <0,0,0> <0,pheight,0> pwidth}
  cylinder { <0,0,0> <0,sheight*sqrt(2),0> swidth rotate -45*z translate 2.2*y}
  cylinder { <0,0,0> <0,sheight*sqrt(2),0> swidth rotate 45*x translate 2.2*y}
  texture {bspost_texture}
}

#declare shedwidth=6;
#declare sheddepth=2;
#declare pshear=-0.05;

#declare light_width=shedwidth/2*0.6;
#declare light_delta=shedwidth/2*0.2;
#declare slight=
union {
  object { 
    light_source {
      <light_delta,0,0>
      color White*0.6
      area_light <light_width, 0, 0>, <0, 0, 0>, 5, 1
      adaptive 1
      jitter
      fade_distance 2
      fade_power 1
      looks_like {
	cylinder{
	  <0,0,0>,<light_width,0,0>,0.04
	  pigment{color White}
	  finish{ambient <1/ambient_red,1/ambient_green,1/ambient_blue>*10}
	}
      }
    }
  }
  object {
    intersection {
      cylinder{<0,0,0> <0,light_width,0> 1.0 }
      box { <0,0,-1> <1,light_width,1>}
    }
    hollow
    texture {
      pigment{ color rgbf <1,1,1,1>}
      finish{ ambient 0 diffuse 1 specular 0 phong 0}
    }
    interior {
      media {
	emission rgb <1,1,1>*8
	intervals 10
	samples 1,10
	ratio 0.9
	variance 1.0/512
	confidence 0.99
	density {
	  cylindrical
	  color_map{
	    [0 Black]                 // Black is transparent
	    [1 White]
	  }
	}
      }
    }
    rotate -z*90
    scale <1.1,0.2,0.2>
    translate x*(light_delta-0.05*light_width)
  }
}


#declare bikeshed=
union {
  object { bikeshedpost }
  object { bikeshedpost rotate y*90 translate sheddepth*z}
  object { bikeshedpost rotate y*180 translate <shedwidth,0,sheddepth>}
  object { bikeshedpost rotate y*270 translate <shedwidth,0,0>}
  object { //back brace
    box{ 
      <0,pheight/2,sheddepth-pwidth> <shedwidth,pheight/2+pwidth,sheddepth>
    }
    texture {bspost_texture}
  }
  union { //roof
    difference { 
      box{ 
	<-pwidth,0,-pwidth> <shedwidth+pwidth,pwidth,sheddepth+pwidth> 
      }
      box{ 
	<pwidth,-0.01,pwidth> <shedwidth-pwidth,pwidth+0.01,sheddepth-pwidth> 
      }
      translate y*pheight
      texture {bspost_texture}
    }
    object {  
      corrugated_iron_sheet(40,0.07,0.005)
      scale <shedwidth+2*pwidth,1,sheddepth+2*pwidth+0.2>
      translate z*(-pwidth-0.2)
      translate x*(-pwidth)
      translate y*(pheight+pwidth)
      texture{bswall_texture}
    }
  }
  object { // back wall
    corrugated_iron_sheet(40,0.071372,0.005)
    scale <shedwidth+2*pwidth,1,pheight>
    rotate -x*90
    translate z*(sheddepth+0.05)
    translate x*(-pwidth)
    texture{bswall_texture}
  }
#ifndef (fastbikeshedlights)
  object {
    slight
    translate <0,pheight,0.05>
  }
  object {
    slight
    translate <shedwidth/2,pheight,0.05>
  }
#end
  matrix <
    1, 0, 0,
    0, 1, 0,
    0, pshear, 1,
    0, 0, 0>
}

#declare bikeshedwithrails=
union{
  object{bikeshed}
  #local nposts=8;
  #local cnp=nposts;
  #while (cnp>0)
    object {
     bikepost
     translate x*((cnp-0.5)*shedwidth/(nposts))
     translate z*(sheddepth-0.3)
    }
    #local cnp=cnp-1;
  #end
}
  
