// A macro for a corrugated iron sheet. Copyright 2000 M. D. Mackey

#macro corrugated_iron_segment(majorradius,sheetthickness)
#local ciseg=
intersection {
  difference {
    cylinder { <0,0,0> <0,0,1> majorradius+sheetthickness/2}
    cylinder { <0,0,-0.01> <0,0,1.01> majorradius-sheetthickness/2}
  }
  box { <-majorradius-sheetthickness/2,-majorradius-sheetthickness/2,-0.02> <0,0,1.02>}
}
union{
  object{ ciseg}
  object{ ciseg rotate z*180 translate -y*(majorradius*2)}
  rotate z*45
}
#end

#macro corrugated_iron_sheet(segments,majorradius,sheetthickness)
#local nseg=segments;
union{
/*
  box{ 
    <0,0,0> <1,majorradius,1> 
    texture {pigment{color rgbf <1,0,0,0.7>}}
  }
*/
  #while (nseg>0)
  object{
    corrugated_iron_segment(majorradius,sheetthickness)
    scale <1/(sqrt(2)*majorradius*2),1,1>
    scale <1/segments,1,1>
    translate x*(nseg-1)/segments
    translate y*majorradius
  }
  #local nseg=nseg-1;
  #end
}
#end
  

