// A gutter made of sections. Copyright 2000 M. D. Mackey

#declare gutterrsd=5131;
#declare gutterrd=seed(hedgersd);

#macro guttersection(topwidth,basewidth,height,gcurve)
#local mycyl=
cylinder { 
  <0 0 0> <0 0 1> gcurve
}
   
union{
  box{ <-topwidth+gcurve,0,0>  <-gcurve,height,1>}
  box{ <-topwidth,0,0>  <-topwidth+gcurve,height-gcurve,1>}
  box{ <-gcurve,height-gcurve,0>  <0,2*gcurve,1>}
  difference {
    box{ <-gcurve,2*gcurve,0>  <gcurve,0,1>}
    object{ mycyl scale <1,1,1.1> translate <gcurve,2*gcurve,-0.01> }
  }
  box{ <gcurve,gcurve,0>  <basewidth-gcurve,0,1>}
  object { mycyl translate <-gcurve,height-gcurve,0>}
  object { mycyl translate <-topwidth+gcurve,height-gcurve,0>}
  object { mycyl translate <basewidth-gcurve,0,0>}
}
#end 

#macro gutter(nsections,gjitter,topwidth,basewidth,height,gcurve)
union {
  #local ns=nsections;
  #while (ns>0)
    object {
      guttersection(topwidth,basewidth,height,gcurve)
      scale <1,1,1/nsections>
      scale <1+rand(gutterrd)*gjitter-gjitter/2,1+rand(gutterrd)*gjitter-gjitter/2,0.999>
      translate z*(ns-1)/nsections
      translate <rand(gutterrd)*gjitter-gjitter/2,rand(gutterrd)*gjitter-gjitter/2,0>
    }
    #local ns=ns-1;
  #end
}
#end
