// A lamp post macro. Copyright 2000 M. D. Mackey

#declare useglow=1;

#declare glow=
object {
  sphere{<0,0,0> 1}
  hollow
  texture { 
    pigment{ color rgbf <1,1,1,1>}
    finish{ ambient 0 diffuse 1 specular 0 phong 0}
  }
  interior {
    media {
      emission rgb <1,1,0.6>*0.2
      //scattering{2, rgb<1,1,0.6> extinction .05 }
      intervals 10
      ratio 0.9
      variance 1.0/128
      confidence 0.9
      density {
        spherical
	color_map{
	  [0 Black]                 // Black is transparent
	  [0.6 White*0.5]
	  [1 White*0.5]
	}
      }
    }
  }
}

#macro roughroundedbox(end1,end2,bradius,nscale,nheight) 
#declare delta=(end2-end1)/2;
#declare ndelta=delta+nheight;
#declare boxF=function { "rounded_box" <bradius,delta.x,delta.y,delta.z> }
  // creates a rounded box from <-delta> to <+delta>
  isosurface {
    function { boxF(x,y,z) - noise3d(x*nscale,y*nscale,z*nscale)*nheight }
    threshold 0
    sign 1
    method 2
    eval
    accuracy 0.01
    contained_by{box -6*ndelta/5 6*ndelta/5}
    translate delta
    translate end1
  }
#end
  

#macro lamppost(postwidth,postheight,crossbarlength,globeradius,posttexture,lighttexture,postlight)

#ifdef (useglow)
#declare lsrc=
union {
  object {
    postlight
    scale globeradius
  }
  object {
    glow
    scale globeradius*3
  }
}
#else
#declare lsrc=
object {
  light_source {<0,0,0> color White}
}
#end

union {
  union {
    object{
      roughroundedbox ( <-postwidth/2,0,-postwidth/2> <postwidth/2,postheight,postwidth/2>,postwidth/10,100,0.003)
    }
    object{
      roughroundedbox ( <-crossbarlength/2,postheight,-postwidth/2> <crossbarlength/2,postheight+postwidth,postwidth/2>, postwidth/10, 90, 0.003)
    }
    object {
      roughroundedbox ( <-postwidth/2,postheight,-crossbarlength/2> <postwidth/2,postheight+postwidth,crossbarlength/2>, postwidth/10, 80, 0.003)
    }
    cylinder { <-crossbarlength/2+globeradius/10,postheight+postwidth,0>
	       <-crossbarlength/2+globeradius/10,postheight+postwidth+globeradius/10,0>
	       globeradius/10 }
    cylinder { <crossbarlength/2-globeradius/10,postheight+postwidth,0>
	       <crossbarlength/2-globeradius/10,postheight+postwidth+globeradius/10,0>
	       globeradius/10 }
    cylinder { <0,postheight+postwidth,-crossbarlength/2+globeradius/10>
	       <0,postheight+postwidth+globeradius/10,-crossbarlength/2+globeradius/10>
	       globeradius/10 }
    cylinder { <0,postheight+postwidth,crossbarlength/2-globeradius/10>
	       <0,postheight+postwidth+globeradius/10,crossbarlength/2-globeradius/10>
	       globeradius/10 }
    texture {posttexture}
  }
  sphere { 
    <-crossbarlength/2+globeradius/10,postheight+postwidth+globeradius/10+globeradius,0> globeradius
    texture {lighttexture}
    no_shadow
  }
  sphere { 
    <+crossbarlength/2-globeradius/10,postheight+postwidth+globeradius/10+globeradius,0> globeradius
    texture {lighttexture}
    no_shadow
  }
  sphere { 
    <0,postheight+postwidth+globeradius/10+globeradius,-crossbarlength/2+globeradius/10> globeradius
    texture {lighttexture}
    no_shadow
  }
  sphere { 
    <0,postheight+postwidth+globeradius/10+globeradius,+crossbarlength/2-globeradius/10> globeradius
    texture {lighttexture}
    no_shadow
  }
  object {
    lsrc
    translate <-crossbarlength/2+globeradius/10,postheight+postwidth+globeradius/10+globeradius,0>
  }
  object {
    lsrc
    translate <+crossbarlength/2-globeradius/10,postheight+postwidth+globeradius/10+globeradius,0>
  }
  object {
    lsrc
    translate <0,postheight+postwidth+globeradius/10+globeradius,-crossbarlength/2+globeradius/10>
  }
  object {
    lsrc
    translate <0,postheight+postwidth+globeradius/10+globeradius,+crossbarlength/2-globeradius/10>
  }
}  
#end
