// The main car park scene. Copyright 2000 M. D. Mackey

#version unofficial MegaPov 0.5;
#default{
  finish{ambient 0 diffuse 1}
}
#declare ambient_red=0.2;
#declare ambient_green=0.2;
#declare ambient_blue=0.4;
#global_settings{
  ambient_light rgb<ambient_red,ambient_green,ambient_blue> 
  max_trace_level 15
  assumed_gamma 1.0
}

#declare moonlight=0.3;

#include "colors.inc"
#include "textures.inc"

/* Uncomment these for a fast preview
#declare fasthedge=1;
#declare fastberryhedge=1;
#declare fasttree1=1;
#declare fasttree2=1;
#declare fasthedge2=1;
#declare fasttree3=1;
#declare fastlights=1;
#declare fastbikeshedlights=1;
*/

// Comment these to remove objects
#declare showhedge=1;
#declare showhedge2=1;
#declare showhedge1a=1;
#declare showweeds=1;
#declare showtree1=1;
#declare showtree2=1;
#declare showtree2a=1;
//#declare showtree3=1;
#declare showtree3a=1;
#declare showtree3b=1;

#declare showcar1=1;
#declare showcar2=1;
#declare showcar3=1;
#declare showbikes=1;
#declare showsplash=1;
#declare showdolphin=1;
#declare waterdolphin=1;
#declare showwake=1;
#declare showdolphin2=1;
#declare showstars=1;
#declare showleaflitter=1;
#declare showcat=1;

#ifdef (showleaflitter)
  #include "randompile.inc"
  #include "leaves.inc"
#end
#include "starsspheres.inc"
#ifdef (showdolphin)
  #include "dolphin.inc"
#else
#ifdef (showdolphin2)
  #include "dolphin.inc"
#end
#end
#include "splash.inc"
#include "hedgetree.inc"
#include "hedgeberrytree.inc"
#include "hedgetree2.inc"
#include "hedge.inc"
#include "mytree1.inc"
#include "mytree2.inc"
#include "mytree3.inc"
#include "gutter.inc"
#include "lamppost.inc"
#include "bikeshed.inc"
#ifdef (showcar1)
#include "my_roadster.inc"
#end
#ifdef (showcar2)
#include "my_toyota.inc"
#end
#ifdef (showcar3)
#include "my_sedan.inc"
#end
#ifdef (showbikes)
#include "my_bicycle.inc"
#end
#ifdef (showcat)
#include "my_cat.inc"
#end

#declare rsd=5131;
#declare rd=seed(rsd);

#ifdef (waterdolphin)
#declare dolphintexture=
texture {
  pigment {
    color rgbf <0.9,0.99,0.9,0.85>
  }
  normal {
    waves 0.4
    scale 100
    frequency 100
  }
  finish {
    reflection 0.2
    ambient 0
    diffuse 0
    specular 1
    roughness 0.001
  }
}
#else
#declare dolphintexture=
texture{pigment{color White} finish{specular 0.6 diffuse 0.6}}
#end

#declare dolphininterior=
interior {
  ior 1.33
  fade_distance 5
  fade_power 2
}


#declare baseposttex=texture{
  pigment{color <0.2,0.8,0.2>}
  finish{ ambient 0.1 diffuse 0.6 specular 0.1 roughness 0.1}
}

#declare rust=
texture {
  pigment {
    granite
    color_map {
      [0.0 rgb <0.89, 0.51, 0.28>]
      [0.4 rgb <0.70, 0.13, 0.00>]
      [0.5 rgb <0.69, 0.41, 0.08>]
      [0.6 rgb <0.49, 0.31, 0.28>]
      [1.0 rgb <0.89, 0.51, 0.28>]
    }
    scale 1.2
  }
  finish{ ambient 0.1 diffuse 0.6 specular 0}
}

#declare posttex=texture {
  bozo
  texture_map{
    [0.65 baseposttex]
    [0.75 rust]
    [1.0 rust]
  }
  scale <0.05,0.15,0.06>
  translate y*6
}
  
#declare lighttex=texture{
  pigment{
    bozo
    color_map {
      [0.6 color rgb <1,1,0.6>]
      [1.0 color rgb <0.9,0.9,0.5>]
    }
    scale 0.2
  }
  finish{ambient <1/ambient_red,1/ambient_green,1/ambient_blue>*1.0 diffuse 0 specular 0 phong 0}
}
texture{
  pigment {
    granite
    color_map {
      [0.8 color rgbf <1,1,1,1>]
      [1.0 color rgbf <0,0,0,0>]
    }
    scale 0.1
  } 
}

#declare postlight=light_source{
  <0,0,0> color rgb <1,1,0.6>*0.35
  area_light <1,0,0> <0,0,1>, 3, 3
  adaptive 0
  jitter 
  circular
  orient
  fade_distance 5
  fade_power 2
}

#ifdef (fastlights)
#declare LampPost=
union {
  box { <0,0,0> <0.2,2.5,0.2> pigment{ color Green}}
  object { 
    light_source {
      <0,0,0>
      color rgb <1,1,0.6>*1.4
      fade_distance 5
      fade_power 2
      translate <0.1,3,0.1>
    }
  }
}
#else
#declare LampPost=
object {
  lamppost(0.1,2.0,0.6,0.2,posttex,lighttex,postlight)
}
#end


//-----Filter  Dark T_Cracks
#declare T_Crack2 =
texture {
pigment
 {granite
  turbulence 0.8
  color_map
   {[0.0, 0.5   color Clear color Clear]
    [0.5, 0.54   color Clear color Black]
    [0.54, 1.0 color Clear color Clear]
   }
 }
}

#declare concrete =
texture {
 pigment { 
   granite 
   turbulence 1
   color_map {
     [0.60  color Gray75 ]
     [0.92  color Gray55 ]
     [1.00  color Brown  ] 
   }
 }
 finish{ambient 0 diffuse 1 specular 0}
 normal{bumps 0.2 scale 0.15}
 scale <.1,.1,.1>
}
texture {T_Crack2 scale 8}

#declare dirttexture=
texture {
  pigment {
   granite
   turbulence 1
   color_map {
     [0.20  color <0.44,0.24,0.24>*0.7 ]
     [0.92  color Gray50 ]
     [1.00  color Gray15  ]
   }
 }
 normal{
   average
   normal_map {
     [1.0 granite]
     [1.0 bumps]
   }
 }
 finish{ambient 0 diffuse 1 specular 0.1 roughness 1}
 scale <.15,.15,.18>
}

#declare tarmac =
texture {
  pigment {
    granite
    turbulence 1
    color_map {
      [0.10  color Gray05 ]
      [0.60  color Gray10 ]
      [0.93  color Gray25 ]
      [1.00  color Gray45  ]
    }
  }
  normal{
    average
    normal_map {
      [1.0 granite scale 0.4]
      [0.5 bozo scale 3]
    }
  }
  finish{ambient 0 diffuse 1 specular 0.07 roughness 1}
  scale <.15,.15,.15>
}

#declare oilytarmac = 
texture {
  pigment {
    granite
    turbulence 1
    color_map {
      [0.05  color Black ]
      [0.60  color Gray05 ]
      [1.00  color Gray15  ]
    }
  }
  //pigment{color Green}
  normal{granite 0.3}
  finish{ambient 0 diffuse 0.5 specular 0.2 roughness 0.001}
  scale <.1,.1,.1>
}

#declare tosscale=1.0;
#declare tarmac_with_oil_spots=
texture {
  bozo
  scale tosscale
  texture_map {
    [0.82 tarmac scale 1/tosscale]
    [0.85 oilytarmac scale 1/tosscale]
    [1.0 oilytarmac scale 1/tosscale]
    [1.0 pigment{color Green} scale 1/tosscale]
  }
  translate 14.0*y
  translate 0.4*z
}

#declare roadpaint =
texture {
  pigment {
   granite
   turbulence 1
   color_map {
     [0.60 color Gray80]
     [0.90 color Gray50]
     [1.0 color Gray15]
   }
 }
 normal{granite scale 0.1}
 finish{ambient 0 diffuse 1 specular 0.3 roughness 0.1}
}

#declare linegap=2.5;
#declare roadlines= // lined road, assumes 2.5m gap
texture{
  gradient z
  scale linegap
  texture_map {
    [0.020 roadpaint scale 1/linegap]
    [0.030 tarmac_with_oil_spots scale 1/linegap]
    [1.0 tarmac_with_oil_spots scale 1/linegap]
  }
}

#declare roadlines2= // lined road crossbars, assumes 2.5 gap
texture{
  gradient z
  scale linegap 
  texture_map {
    [0.10 roadpaint scale 1/linegap]
    [0.105 tarmac_with_oil_spots scale 1/linegap]
    [0.895 tarmac_with_oil_spots scale 1/linegap]
    [0.90 tarmac_with_oil_spots scale 1/linegap]
    [1.0 roadpaint scale 1/linegap]
  }
}

#declare linelength=4.0;
#declare roadtexture= // texture for whole road, including parking
		      // stripes. Assumes road is 12 units wide, lines 'linelength' units long
		      // and 'linegap' apart
texture {
  gradient x
  translate -z*20
  scale 10
  turbulence <0.002,0.002,0.002>
  omega 0.95
  octaves 10
  texture_map {
    [(6-linelength-0.04)/10 tarmac scale 1/10]
    [(6-linelength-0.04)/10 roadlines2 scale 1/10]
    [(6-linelength)/10 roadlines2 scale 1/10]
    [(6-linelength)/10 roadlines scale 1/10]
  }
}
    

#declare Direction=1.2;
//#declare Direction=7;
camera {
        location        <2.0,2.0,-7>
        direction       <0,0,Direction>
        up              <0,1,0>
        right           <1.3333,0,0 >
        sky             <0,1,0>
        look_at         <0,1,7>
	//look_at	<2.0,0.0,-6>
}


#ifdef (showstars)
starrysky(Direction,30000)
//starrysky(Direction,5000)
#end

//cloud layer 1

#declare Clouds=
pigment {
  bozo
  turbulence .4
  omega .7
  color_map {
    [0 color rgbt <1, 1, 1, 1>]
    [0.4 color rgbt <1, 1, 1.2, 0.9>]
    [.6 color rgbt < 1, 1, 1.3,.7>]
    [1 color rgbt <.9, .9, 1.2, .2>*0.5]
  }
  scale 0.1
}

#declare OrangeClouds=
pigment {
  bozo
  turbulence .4
  omega .7
  color_map {
    [0 color rgbt <1, 1, 1, 1>]
    [0.4 color rgbt <1, 1, 1.2, 0.9>]
    [.6 color rgbt < 2.8, 2.0, 0.5,.7>]
    [1 color rgbt <3.5, 2.6, .2, .1>]
  }
  scale 0.1
}

plane {
  y, 900
  texture {
    pigment {
      gradient x
      translate -0.39*x
      scale 10
      pigment_map {
        [0 Clouds]
        [0.40 Clouds]
	[0.5 OrangeClouds]
      }
    }
    finish {ambient <1/ambient_red,1/ambient_green,1/ambient_blue>*0.10 diffuse 0}
    scale 3000
    translate <-500,900,-10000>
  }
  hollow
}

background{color rgb <0.8,0.8,1.0>*0.001}

light_source { // Moon
  <-4000,10000,-9000> color rgb <0.3,0.3,0.4>*moonlight
  area_light <200,0,0> <0,0,200>, 3, 3
  adaptive 0
  jitter
  circular
  orient
  looks_like {
    sphere {
      <0,0,0> 200
      texture {
	pigment{color White}
        finish{ambient <1/ambient_red,1/ambient_green,1/ambient_blue>*<0.9,0.9,1.1>}
      }
    }
  }
}

fog {
  distance 40
  color Black
  fog_type 2
  fog_offset 3
  fog_alt 2
  turbulence 0.2
  turb_depth 0.3
}

/*
media {
  intervals 10
  scattering { 1, rgb 0.02}
  samples 1, 10
  confidence 0.9999
  variance 1/1000
  ratio 0.9
  density {
    bozo
    scale 5
  }
}
*/
  
object { // right hand dirt
  box {
    <6,-1,-20> <30,0.08,40>
    texture{dirttexture}
  }
}

object { // left hand dirt
  box {
    <-6,-1,-20> <-60,0.08,34>
    texture{dirttexture}
  }
}

object { // back dirt
  box {
    <-60,-1,40> <60,0.08,400>
    texture{dirttexture}
  }
}

object { // road
  union {
    box {  // main road surface
      <-6,-1,-20> <6,0,40>
      texture{roadtexture}
    }
    object {
//#macro gutter(nsections,gjitter,topwidth,basewidth,height,gcurve)
      gutter(20,0.10,1,1.7,1,0.2)
      scale <0.12,0.1,54>
      translate <-5.9,-0.01,-20>
      texture{concrete}
    }
    object {
      gutter(23,0.10,1,1.7,1,0.2)
      scale <-0.12,0.1,60>
      translate <5.9,-0.01,-20>
      texture{concrete}
    }
    object { // road end
      box { 
	<-6,-1,34> <-34,0,40>
      }
      texture{tarmac}
    }
    object {
      gutter(9,0.10,1,1.7,1,0.2)
      scale <0.12,0.1,40>
      rotate 90*y
      translate <-34,-0.01,39.9>
      texture{concrete}
    }
  }
}

#ifdef (showsplash) // splash in road
  #declare F=function{
     pigment{
       ripples
       color_map { [0 rgb 1] [1 rgb 0] }
     }
  }
  
  #declare Water=
  union {
    isosurface {
      function { y - F(x,y,z)*(1/(1.8*x*x+1.8*z*z+0.30)+1/(0.3*x*x+0.3*z*z+9)) }
      threshold 0
      sign 1
      method 2
      max_gradient 4.8
      //eval
      accuracy 0.01
      contained_by{box <-8,-0.05,-8> <8,1.35,8>}
    }

//splash(numspheres, splashradius, maxheight, slope, maxsize, wobble, falloff)
    blob {
      splash(2000,0.27,1.5,0.3,0.2,0.1,0.5)
      threshold 0.6
      translate y*0.9
      texture{tarmac}
    }

  }

  object {
    Water
    scale 0.4
    translate <2,-0.01,-0.09>
    texture{roadtexture}
    //texture{pigment{color White}}
  }
#end

#declare wakeposition=<4,0,4>;
#ifdef (showwake)  // wake from second dolphin
  #declare Wake=
  object {
    isosurface {
      function { (x+z) & (-x+z) & (y-0.3*(sin(5*(abs(x)+z)-pi/2)+1)/(1+0.9*(4*((x-1)^2)+(z-1)^2)))}
  //    function { abs(x) & y - sin(abs(x)+z)/(1+0.1*(x^2+z^2)) }
  //    function {y + 0.4*sin(x)}
	    threshold 0
	    sign 1
	    method 2
 	    // eval
	    max_gradient 1.5
	    accuracy 0.01
	    //contained_by{sphere 0,10}
	    contained_by{box{<-7,-0.05,-10><7,0.4,0>}}
    }
    //object{box{<-7,-0.05,-10><7,0.5,0>} pigment {rgbf <0.7,0.9,0.9,0.9>}}
    scale <1,1,1.6>
  }


  object {
    Wake
    rotate y*160
    scale 0.7
    translate wakeposition
    texture{roadtexture}
    //texture{pigment{color Green}}
  }

#end

#ifdef (showdolphin) // dolphin leaping
  object {
    Dolphin
    scale 0.7
    rotate z*20
    translate <-0.3,1.1,-0.3>
    texture{dolphintexture}
    interior{dolphininterior}
  }
#end

#ifdef (showdolphin2) // 'underwater' dolphin
  object {
    Dolphin
    scale 0.7
    translate x*0.6
    rotate -y*110
    translate -0.7*y
    translate wakeposition
    texture{dolphintexture}
    interior{dolphininterior}
  }
#end


#ifdef (showcat) // cat in background
  object {
    my_cat
    scale 0.4
    rotate -y*105
    translate <4.1,0,16.5>
  }
#end


/*
object { // human sized cylinder for scale purposes
  cylinder { <0,0,0> <0,1.8,0> 0.25}
  translate z*16
  translate x*4
  pigment{color White}
  finish{ambient 0 diffuse 1 specular 0 phong 0}
}
*/

#ifdef (showcar1)
object { // car 1
  my_roadster
  scale 2.4
  translate <-6,0,7>
}
#end


#ifdef (showcar2)
object { // car 2
  my_toyota
  scale 2.4
  translate <-5.8,0,25>
}
#end


#ifdef (showcar3)
object { // car 3
  my_sedan
  scale 2.4
  translate <1.4,0,20>
}
#end


union { // bike shed
  object{ bikeshedwithrails}
#ifdef (showbikes)
  object {
    my_bicycle(color rgb <0.2,0.2,1.0>)
    scale 1.8
    rotate -86*y
    translate 1.38*x
    translate 0.02*y
    translate -0.3*z
  }
  object {
    my_bicycle(color rgb <0.8,0.5,0.3>)
    scale 1.8
    rotate 30*x
    rotate -5*y
    translate 3.2*x
    translate -0.10*y
    translate 1.1*z
  }
#end
  translate <-3,0,41>
}

/* Too slow!
object {
  LampPost
  translate <-6.8,0,-15>
}

replace with light_source below */

light_source{
  <0,0,0> color rgb <1,1,0.6>*1.4
#ifndef (fastlights)
  area_light <1,0,0> <0,0,1>, 3, 3
  adaptive 0
  jitter
  circular
  orient
#end
  fade_distance 5
  fade_power 2
  translate <-6.8,3,-15>
}


object {
  LampPost
  translate <-6.8,0,5>
}

object {
  LampPost
  rotate y*90
  translate <-6.8,0,25>
}
  
#ifdef (showhedge)
//macro Hedge(HedgeTree,length,treesize,sizestd,treedist,diststd,transversestd)
// Left hand hedge
union {
  Hedge(HedgeBerryTree,50,0.1,0.2,1.5,0.2,0.1)
  rotate -y*90
  translate <-7.5,0,-20>
}
#end

#ifdef (showweeds)
// Left hand weeds
union {
  Hedge(HedgeTree,50,0.03,0.2,1,1,0.5)
  rotate -y*90
  translate <-6.6,0,-20>
}
#end

#ifdef (showtree1)
// Left hand far tree
object {
  MyTree1
  scale 0.2 
  translate <-10,0,30>
}
#end

#ifdef (showtree2)
// Other Left hand far tree
object {
  MyTree2
  scale 0.18 
  rotate y*155
  translate <-10,0,44>
}
#end

#ifdef (showtree2a)
// Other Other Left hand far tree
object {
  MyTree2
  scale 0.18 
  rotate y*55
  translate <-25,0,43>
}
#end

#ifdef (showtree3)
// Right hand far tree
object {
  MyTree3
  scale 0.25 
  rotate y*220
  translate <15,0,16>
}
#end

#ifdef (showtree3a)
// Back far tree
object {
  MyTree3
  rotate 90*y
  scale 0.2 
  translate <5,0,55>
}
#end

#ifdef (showtree3b)
// Side left tree (mostly offscreen)
object {
  MyTree3
  rotate 130*y
  scale 0.25 
  translate <-20,0,15>
}
#end

#ifdef (showhedge2)
// Right hand hedge
union {
  Hedge(HedgeTree2,60,0.09,0.2,1.5,0.2,0.1)
  rotate -y*90
  translate <7.5,-0.4,-20>
}
#end

// Right hand weeds
#ifdef (showweeds)
union {
  Hedge(HedgeTree,60,0.03,0.2,1,1,0.5)
  rotate -y*90
  translate <6.7,0,-20>
}
#end

#ifdef (showhedge1a)
// Back hedges
union {
  Hedge(HedgeTree,20,0.15,0.2,2,0.2,0.1)
  translate <-24,0,42>
}
union {
  Hedge(HedgeTree,4,0.15,0.2,2,0.2,0.1)
  translate <3,0,42>
}
#end

#ifdef (showleaflitter)
// randompile(npile,psize,spread,sharpness,nobjects,objectarray,probarray)
union { // leaf pile in RH edge
  randompile(200,<4,2,30>,2,1.0,nLeaves,LeafArray,LeafProbs)
  scale 0.1
  translate <5.6,0,16>
}
union { // leaf pile in front of shed
  randompile(200,<24,3,5>,2,0.8,nLeaves,LeafArray,LeafProbs)
  scale 0.1
  translate <2.5,0,38>
}
union { // general leaf scatter across road
  scatterobjects(100,<12,0,60>*12,nLeaves2,LeafArray2,LeafProbs2)
  scale 1/12
  translate <-6,0,-20>
}
union { // general leaf scatter along LH gutter
  scatterobjects(300,<0.5,0,60>*12,nLeaves2,LeafArray2,LeafProbs2)
  scale 1/12
  translate <-6,0,-20>
}
union { // general leaf scatter along RH gutter
  scatterobjects(300,<0.5,0,60>*12,nLeaves2,LeafArray2,LeafProbs2)
  scale 1/12
  translate <5.5,0,-20>
}
union { // general leaf scatter along RH dirt
  scatterobjects(300,<1.0,0,60>*12,nLeaves2,LeafArray2,LeafProbs2)
  scale 1/12
  translate <6,0.08,-20>
}
#end
