// A macro to generate a random pile or a random
// scatter of objects. The 'randompile' macro in particular
// looks quite good with the right parameters.
// Copyright 2000 M. D. Mackey

#declare orsd=3141;
#declare ord=seed(orsd);

#macro randomobject(nobjects,objectarray,probarray)
#local rn=rand(ord);
//#render concat("randomobject rn=",str(rn,0,3),"\n")
#local n=nobjects-1;
#while (n>=0) 
  #local rn=rn-probarray[n];
//  #render concat("n=",str(n,0,3)," rn=",str(rn,0,3),"\n")
  #if (rn<0)
//    #render concat("randomobject choosing object ",str(n,0,0),"\n")
    object{objectarray[n]}
    #local n=0;
  #end
  #local n=n-1;
#end
#end

#macro randompile(npile,psize,spread,sharpness,nobjects,objectarray,probarray)
#render concat("\nrandompile ")
#while (npile>0)
  #local ns=spread;
  #local sr=0.0;
  #while (ns>0)
    #local sr=sr+rand(ord);
    #local ns=ns-1;
  #end
  #local sr=2*(sr/spread)-1;
  #local dir=rand(ord);
  #local dirx=cos(radians(360*dir))*sr;
  #local diry=sin(radians(360*dir))*sr;
  #local oheight=rand(ord)*psize.y*sharpness/(10*sr*sr+sharpness);
  //#render concat("randompile height ",str(oheight,0,3),"\n")
  object {
    randomobject(nobjects,objectarray,probarray)
    translate oheight*y
    translate <dirx,0,diry>*psize
  }
  #local npile=npile-1;
#end
#end

#macro scatterobjects(nscatter,sv,nobjects,objectarray,probarray)
#render concat("\nrandomscatter ")
#while (nscatter>0)
  object {
    randomobject(nobjects,objectarray,probarray)
    translate <rand(ord),rand(ord),rand(ord)>*sv
  }
  #local nscatter=nscatter-1;
#end
#end
