/*
 *	"Earthrise"
 *
 *	Entry for the IRTC round "Contrast"
 *	Copyright 2000 Mark Wagner
 *	Rendered using POV-Ray 3.1e
 *  Render time: 19 seconds with original moon image map
 *				 152 seconds with large moon image map
 *				 132 seconds with simplified earth
 */
 
/*
 "The vast loneliness of the moon up here is awe-inspiring, and it makes you
  realize just what you have back there on Earth.  The Earth from here is a 
  grand oasis in the big vastness of space" -- Jim Lovell, Apollo 8 astronaut
*/

/* Earth image maps are available from 
	http://www.lancs.ac.uk/postgrad/thomasc1/render/planets/earth.htm
	in the file earthpng.zip
	
	Earth land map and sea map derived from original Earth map by Constantine Thomas.
	Cloudmap provided by James Hastings-Trew.
	Cloudmap transparency coding by Kari Kivisalo.
	
	Lunar image map and bump map by James Hastings-Trew
	Available from http://www.jht.cjb.net/
*/

#version 3.1;

global_settings{assumed_gamma 1.8}

#declare cm = 1/10000000;	/* 1 POV unit = 100 km */
#include "units.inc"		/* www.geocities.com/Rengaw03/Pov-Ray.html */

#declare Nebula = off;


/* Background starfield */
#declare galaxy_seed = 3141592;
#declare options_only = on;

#include "galaxy.inc"		/* Chris Colefax's Galaxy Include File */

#declare galaxy_bgnebula = off;
#declare galaxy_nebula_sphere = off;
#declare galaxy_bgstars = off;
#declare star_count = 600;
object{
	#include "galaxy.sf"
	rotate y*5
	rotate z*10
}


/* The Earth */
sphere{
	<0,0,0>, 6370*km
	/* Ocean */
	texture{ 
		pigment{rgb <.1,.1,.45>}
//		pigment {image_map {png "earth-seas.png" map_type 1 interpolate 2}}
		finish {ambient 0 diffuse 1.25 specular 0.2 roughness 0.01}
	}
	/* Land */
	texture{
		pigment {image_map {png "earth-land.png" map_type 1 interpolate 2 transmit 58, 1.0}}
		finish {ambient 0 diffuse 1.25 }
	}
	/* Clouds */
	texture{
		pigment{
			image_map {png "earth-clouds2.png" map_type 1 interpolate 2
				#declare T = 0.5;
				transmit 0, 1
				#declare n=1;//0;
				#while (n<256)
					transmit n, 1-pow(n/(256-1),T)
					#declare n=n+1;
				#end
			}
		}
		finish {ambient 0 diffuse 1.5}//diffuse 1.25}
		rotate y*.5*360
	}
	texture{
		pigment{rgbt <.2,.2,1.0,.68>}
		finish{ambient 0}
	}
	rotate y*.25*360
	scale 2.0 //1.2
}

/* The Moon */
sphere{
	<0,0,0>, 1738*km
	pigment{
		image_map{
			png "large moon.png"
			map_type 1 
			interpolate 2
		}
	}
	normal{
		bump_map{
			png "moonbump.png"
			map_type 1
			interpolate 2
			bump_size 2
		}
	}
	finish{ambient 1 diffuse 0}
	rotate x*45
	rotate y*-90
	translate vnormalize(<1,.3,.4>)*200*1000*km
	translate y*-1880*km
}


camera{location vnormalize(<1,.3,.4>)*200*1000*km look_at 0}
light_source{ x*93*1000*1000*miles, 1 rotate z*50 rotate y*-70} /* The Sun */
//light_source{ x*93*1000*1000*miles, 1 rotate y*-70} /* The Sun */

//light_source{ <-1,0,-.4>*93*1000*1000*miles, 1}
//camera{location <0,7000,0>*km look_at (vnormalize(<1,.3,.4>)*200*1000*km-y*2100*km) angle 2}