
#version unofficial Megapov 0.6


// ----------------   nature vs. rectangles   30.Dec.2000    ------------------------
// ----------------     norbert-werner.kern@t-online.de      ------------------------


global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  3
  }
}



#include "colors.inc"
#include "textures.inc"





background { color <0.498,0.600,0.949> } 

camera {  
  location  <   -458.000,    -224.000,      20.000>
  direction <        0.0,         0.0,      1.1547> 
  sky       <    0.00000,     0.00000,     1.00000> 
  up        <        0.0,         0.0,         1.0> 
  right     <    1.33333,         0.0,         0.0> 
  look_at   <   -220.000,     154.000,      30.000>  
}




light_source
{
  0*x 
  color rgb <7.92, 8.00, 7.76>
  translate <-7760, -2080, 11730>   
}



light_source {   
  <-458.000,    -224.000,      20.000>
  color rgb <0.45, 0.42, 0.4>
  shadowless
}



// sky
sky_sphere {
   pigment {
      gradient z
      color_map {
         [0.0 color SkyBlue]
         [0.1 color SkyBlue]
         [0.5 color Blue]
      }
   }
}
   
sphere {0, 1 hollow
   pigment {
      bozo
      turbulence 0.8
      octaves 3
      lambda 4
      color_map {
         [0.0 0.4 color rgbf 1 color rgbf 1]
         [0.8 color rgbf <1, 1, 1, 0.8>]
         [1.0 color rgbf <1, 1, 1, 0.4>]
      }
      scale <0.1667, 1, 0.1667>
   }
   finish {ambient 1 diffuse 0}
   scale <25000, 25000, 2500>
}


//---------------------------------------------------------------------


//   buildings
#include "galerie.inc"
#include "finnisch.inc"  
#include "museum.inc" 
#include "stuttgart.inc"
#include "chartres.inc"  

//   add-ons to "galerie"
#include "galerie-neues.inc"
#include "galerie-vorhang.inc"
#include "galerie-dachneu.inc" 

//   plates on plane
#include "plattenflche.inc"  

//   trees
#include "galerie-bume.inc" 

//   RNA
#include "rna-statue.inc" 

//   water molecules 
#include "galerie-water.inc" 

//   people / animals
#include "frau1.inc"
#include "leute-shapes.inc"    
#include "manonbike1.inc"     
#include "bike.inc"
#include "mouse-steps.inc"   
#include "cat.inc"



















