#version unofficial Megapov 0.6

//  Platte

#declare Material1d = texture {      //Betonplatten     
         pigment
         {
            granite
            color_map
            {
               [ 0.0     rgbft <0.537,0.562,0.499, 0.0, 0.0> ]
               [ 0.25    rgbft <0.630,0.655,0.593, 0.0, 0.0> ]
               [ 0.5     rgbft <0.537,0.562,0.499, 0.0, 0.0> ]
               [ 0.75    rgbft <0.630,0.655,0.593, 0.0, 0.0> ]
               [ 1.0     rgbft <0.537,0.562,0.499, 0.0, 0.0> ]
            }
            frequency 2
            ramp_wave
         }      
         normal
         {
            crackle , 1
            warp
            {
               turbulence <0.5, 0.5, 0.5>

               omega 0.5
               lambda 2
            } 
         }  scale x*0.5 scale y*0.5
         finish
         {
            ambient 0
            diffuse 0.175
            specular 0.08
            roughness 1
            //reflection 0.05
         }
     }      

#declare Material1c = texture {      //Betonplattenfugen     
                                 pigment { color rgbft <0.036,0.036,0.032, 0.0, 0.0> }
                                 finish  { ambient 0 diffuse 0.25 specular 0.03 roughness 1 }   
                              }
                              
                              
#declare Dreck1 =        //Dreck-Box
   material 
   {   
      texture
      {      
         pigment
         {
            bozo
            color_map
            {
               [ 0.0     rgbft <0.516, 0.488, 0.453, 0.672, 0.0> ]
               [ 0.1     rgbft <0.556, 0.488, 0.405, 0.832, 0.0> ]
               [ 0.2     rgbft <0.505, 0.534, 0.480, 0.959, 0.0> ]
               [ 0.5     rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
               [ 1.0     rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
            }
            turbulence 100
            octaves 10
            lambda 2.5
            ramp_wave
         }  scale x*1600 scale y*1825 scale z*20000    
         finish
         {
            ambient 0.0
            diffuse 0.2
         }
      }
   }

                                                                  

     // Plattenfugen

difference { 
  box { 
    <-1, -1, -1>, <1, 1, 1>
    scale <463.9, 533.6, 1.5>
    translate  <-69.1, 214.4, -1.5>
  }
  box { 
    <-1, -1, -1>, <1, 1, 1>
    scale <57.5, 105.1, 4.0>
    translate  <-475.5, -214.1+3.6, -2>
  }
  texture { Material1c }
}




difference {
  box { 
    <-1, -1, -1>, <1, 1, 1>
    scale <463.9, 533.6, 1.8>
    translate  <-69.1, 214.4, -1.67>
  }
  box { 
    <-1, -1, -1>, <1, 1, 1>
    scale <57.5, 105.1, 4.0>
    translate  <-475.5, -214.1+3.6, -2>
  }
  material { Dreck1 }
}      


      // Berechnung


#declare Plattenlaenge=14.1;
#declare Plattenfeld=14.44;
#declare Winkelfaktor=1;  
#declare Tiefenfaktor=0.2;


#declare platten = array[64][73][3] // 64 Platten  in X-Richtung, 73 nach Y und 3 Zufallszahlen fr x-Winkel, y-Winkel und z-Tiefe 
#declare Rndm = seed(20);


#declare Xmax=64;
#declare Ymax=73;
#declare Zmax=3;
#declare xf=0; #while (xf<Xmax)
  #declare yf=0; #while (yf<Ymax) 
    #declare zf=0; #while (zf<Zmax)
      #declare platten[xf][yf][zf]=rand(Rndm)-0.5;
    #declare zf=zf+1; #end 
  #declare yf=yf+1; #end
#declare xf=xf+1; #end      



#macro platte (xf, yf)
    box { 
    <-1, -1, -1>, <1, 1, 1>
    scale <Plattenlaenge/2, Plattenlaenge/2, 1.0>
    rotate -x*platten[xf][yf][0]*Winkelfaktor
    rotate y*platten[xf][yf][1]*Winkelfaktor
    rotate z*platten[xf][yf][0]*platten[xf][yf][1]*Winkelfaktor*7.5
    translate  <-540.5+xf*Plattenfeld, 736.5+3.6-yf*Plattenfeld, -0.8+platten[xf][yf][2]*Tiefenfaktor> // x+1 -> nach rechts; y+1 -> nach oben
    texture { Material1d }                                                                         
    }
#end  



#declare xf=0; 
#while (xf<Xmax)
  #declare yf=0; 
  #if (xf<9) #declare Ymax=59; 
    #else #declare Ymax=73; #end 
  #while (yf<Ymax) 
    platte (xf, yf)
  #declare yf=yf+1; #end
#declare xf=xf+1; #end
