#version unofficial Megapov 0.6


#include "golds.inc"

#declare rnastatex1 = texture    
      {      
         pigment
         {
            color rgb <0.659, 0.659, 0.659>
         }      
         normal
         {
            bumps , -2
            scale  <0.3, 0.001, 0.003>
         }      
         finish
         {
            ambient 0.2
            diffuse 0.7
            brilliance 8.0
            specular 0.8
            roughness 0.1
            reflection 0.15
         }
      }


#declare rnastatex2 = texture       
      {      
         pigment
         {
            color rgb <0.75, 0.75, 0.75>
         }      
         normal
         {
            wrinkles , 0.08
            scale  <0.051, 30.0, 0.051>
         }      
         finish
         {
            ambient 0.2
            diffuse 0.6
            brilliance 2.0
            specular 0.7
            roughness 0.082
            reflection 0.32
         }
      }



union { 
  sphere { 
    <0,0,0>,1
    texture {
      rnastatex2
    }
    scale 0.72
    translate  <-398.2, -111.8, 0.35>
  }
  sphere { 
    <0,0,0>,1
    texture {
      rnastatex2
    }
    scale 0.72
    translate  <-381.8, -111.8, 0.35>
  }
  sphere { 
    <0,0,0>,1
    texture {
      rnastatex2
    }
    scale 0.72
    translate  <-381.8, -128.2, 0.35>
  }
  sphere { 
    <0,0,0>,1
    texture {
      rnastatex2
    }
    scale 0.72
    translate  <-398.2, -128.2, 0.35>
  }
  box { 
    <-1, -1, -1>, <1, 1, 1>
    texture {
      rnastatex1
    }
    scale <10.0, 10.0, 0.4>
    translate  <-390.0, -120.0, 0.2>
  }   
}     



#declare Rsize=0.039;

#declare Imax=2000;
#declare Cp=array[Imax][3]
#declare I=0; #while (I<Imax)
  #declare J=0; #while (J<3)
    #declare Cp[I][J]=0;
  #declare J=J+1; #end
#declare I=I+1; #end

#macro Spdr (Center)
  sphere { <Cp[Center][0]*0.2-390,Cp[Center][1]*0.2-120,Cp[Center][2]*-0.2+4.4> Rsize
    texture {T_Gold_1C}  
    }
#end

#macro Cydr (Cpt, Cpe)
  cylinder { <Cp[Cpt][0]*0.2-390,Cp[Cpt][1]*0.2-120,Cp[Cpt][2]*-0.2+4.4> <Cp[Cpe][0]*0.2-390,Cp[Cpe][1]*0.2-120,Cp[Cpe][2]*-0.2+4.4> Rsize
    texture {T_Gold_1C}
    }
#end

#macro Acosc (Rc,Dy,Ac)
  #declare Ac=acos(Rc);
  #if (Dy<0) #declare Ac=2*pi-Ac; #end
  #if (Ac=0) #declare Ac=2*pi; #end
#end

#declare I=0; #while (I<6)
  #declare Pe=1+I;
  #declare Cp[Pe][0]=Cp[0][0]+2*cos(pi/3*I);
  #declare Cp[Pe][1]=Cp[0][1]+2*sin(pi/3*I);
  #declare Cp[Pe][2]=0.015*(pow(Cp[Pe][0],2)+pow(Cp[Pe][1],2));
  Spdr (Pe)
  Cydr (Pe,0)
  Cydr (Pe,Pe-1)
#declare I=I+1; #end
  Cydr (6,1)

#declare Ap=0;
#declare As=0;
#declare Al=0;
#declare Ae=0;
#declare Ad=0;
#declare Rndm = seed(10);

#macro Spculc (N,P,Pe)
  #declare Rs=sqrt(pow(Cp[P][0]-Cp[N][0],2)+pow(Cp[P][1]-Cp[N][1],2))/4;
  Acosc((Cp[P][0]-Cp[N][0])/4/Rs,Cp[P][1]-Cp[N][1],Ap)
  #declare Re=sqrt(pow(Cp[N+1][0]-Cp[N][0],2)+pow(Cp[N+1][1]-Cp[N][1],2))/4;
  Acosc((Cp[N+1][0]-Cp[N][0])/4/Re,Cp[N+1][1]-Cp[N][1],Ae)
  Acosc(Rs,1,As)
  Acosc(Re,1,Al)
  #if (rand(Rndm)>0.5) #declare Ad=rand(Rndm); #end
  #if (Ae-Ap<0) #declare Ap=Ap-2*pi; #end
  #if (Ae-Ap-As-Al-Ad>0)
    #declare I=0; #while (I<int((Ae-Ap-As-Al-Ad)*3/pi)+1)
      #declare Pe=P+1+I;
      #declare Cp[Pe][0]=Cp[N][0]+2*cos(Ap+As+Ad+pi/3*I);
      #declare Cp[Pe][1]=Cp[N][1]+2*sin(Ap+As+Ad+pi/3*I);
      #declare Cp[Pe][2]=0.015*(pow(Cp[Pe][0],2)+pow(Cp[Pe][1],2));
      Spdr (Pe)
      Cydr (Pe,Pe-1)
      Cydr (Pe,N)
    #declare I=I+1; #end
    #declare Ad=0;
  #else
    #if (Ae-Ap-As-Al>0)
      #declare I=0; #while (I<int((Ae-Ap-As-Al)*3/pi)+1)
        #declare Pe=P+1+I;
        #declare Cp[Pe][0]=Cp[N][0]+2*cos(Ap+As+pi/3*I);
        #declare Cp[Pe][1]=Cp[N][1]+2*sin(Ap+As+pi/3*I);
        #declare Cp[Pe][2]=0.015*(pow(Cp[Pe][0],2)+pow(Cp[Pe][1],2));
      Spdr (Pe)
      Cydr (Pe,Pe-1)
      Cydr (Pe,N)
      #declare I=I+1; #end
    #end
  #end
  Cydr (Pe,N+1)
#end

#declare Ps=6;
#declare Jd=1; #while (Jd<1000)
  Spculc (Jd,Ps,Pe)
  #declare Ps=Pe;
#declare Jd=Jd+1; #end   


 


#declare Rmaterial6 = texture {
    finish {
        ambient 0.01
        diffuse 0.3
        specular 0.5 roughness 0.02
        reflection 0.13
    }
    pigment { rgb <0.000, 1.000, 0.502> }
}

#declare Rmaterial5 = texture {
    finish {
        ambient 0.01
        diffuse 0.3
        specular 0.5 roughness 0.02
        reflection 0.2
    }
    pigment { rgb <1.000, 1.000, 1.000> }
}

#declare Rmaterial4 = texture {
    finish {
        ambient 0.01
        diffuse 0.3
        specular 0.5 roughness 0.02
        reflection 0.2
    }
    pigment { rgb <0.561, 0.561, 1.000> }
}

#declare Rmaterial3 = texture {
    finish {
        ambient 0.01
        diffuse 0.3
        specular 0.5 roughness 0.02
        reflection 0.2
    }
    pigment { rgb <0.573, 0.573, 0.573> }
}

#declare Rmaterial2 = texture {
    finish {
        ambient 0.01
        diffuse 0.3
        specular 0.5 roughness 0.02
        reflection 0.2
    }
    pigment { rgb <0.937, 0.000, 0.000> }
}

#declare Rmaterial1 = texture {
    finish {
        ambient 0.01
        diffuse 0.3
        specular 0.5 roughness 0.02
        reflection 0.2
    }
    pigment { rgb <1.000, 0.502, 0.000> }
}

#declare Rmaterial0 = texture {
    finish {
        ambient 0.01
        diffuse 0.3
        specular 0.5 roughness 0.02
        reflection 0.2
    }
    pigment { rgb <1.000, 0.780, 0.000> }
}


#include "rna-galerie.inc"
 
object { rna scale 0.5 rotate <-13.4, -128, 78.5> translate  <-387.0, -114.5, 27.2>}
      
