#include "branch_texture.inc"
#include "maketree.pov" // tree & leaf macro

#declare dofile=true;    // true creates a tree file ; false otherwise
#declare dotexture=true;  // true creates a textured tree (with the texture following the branch); false otherwise
#declare ftname="lcherry.inc" // file name for tree
#declare fvname="lcfoliage.inc" // file name for foliage
#declare ffname="lcleaf.inc" // file name for leaf
#declare txtTree=texture{branch_texture} // Bark texture

#declare rsd=4444;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves

#declare level0=8;      // recursion level
#declare nseg0=24;       // initial number of branch segments (decreases by one times reduction factor at each level)
#declare rseg0=1;       //segment reduction factor
//#declare nb=3;          // max number of branches per level
#declare nb_array = array[level0] { 4, 3, 2, 2, 2, 2, 3, 3 }

#declare dotop=true;   // if true, generates an extra branch on top of trunk (sometimes necessary to give more verticality)

#declare lb0=25;        // initial branch length
#declare rb0=3.5;       // initial branch radius
#declare ab0=45;        // initial branch angle (x angle between the trunk and the first branch)
#declare qlb=.65;       // branch length decrease ratio (1=constant length)
#declare qlb_array = array[level0] {  .75, .75, .85, .85, .95, 1.00, 1.00, 1.05 }
#declare qrb=0.55;       // branch radius decrease ratio (1=constant radius)
#declare qab=1.10;       // branch angle decrease ratio (1=constant angle)
#declare stdax=10;      // stdev of x angle (angle x = ax+(0.5-rand)*stdax)
#declare stday=10;      // stdev of y angle (angle y = ay+(0.5-rand)*stday)

#declare branchproba=1; // probability of branch apparition 
//#declare jb=0.25;        // secondary branches start after this ratio of branch length
#declare jb_array = array[level0] { .5, .5, .5, .7, .7, .5, .5, .6 }

#declare fgnarl=0.30;    // gnarledness factor - keep it low <0.8
#declare stdlseg=0.25;     // stddev of branch segment length (0...1) (adds more randomness to branch length)

#declare twigproba=0.1; // probability to have a twig on a trunk segment

#declare v0=<0,2,0>;    // initial direction - change to give an initial orientation
#declare pos0=<0,0,0>;  // initial trunk position (no need to change this one)

//-----------------------------------------
// constraints parameters
//-----------------------------------------
#declare vpush_array = 
                array[level0+1] {  <0,0,0>, <0,-1,0>, <0,-1,0>, <0,-1,0>, <0,1,0>, <0,1,0>, <0,1,0>, <0,1,0>, <0,1,0> }
//#declare fpush=0.6;       // force of push   
#declare fpush_array = array[level0+1] {  0, 2.5, 1.5, 1.0, .25, .25, .25, .5, .75 }
#declare aboveground=5; // constrains the branches above this level 
#declare belowsky=140;  // constrains the branches below this level 

//-----------------------------------------
// root parameters
//-----------------------------------------
#declare rootproba=0;   // probability of root 0=no root ; 1=all [nb] roots
#declare nroot=5;      // number of roots;
#declare vroot=<1,-.5,0>; // initial direction of root 
#declare yroot=<0,0.75,0>;   // initial position of root above ground

//-----------------------------------------
// leaf position parameters
//-----------------------------------------
#declare leafproba=0;   // probability of leaf 0=no leaf ; 1=leaf on each segment
#declare leaflevel=1;   // level where the leaves start to appear
#declare alz0=100;       // max z angle for leaf
#declare alx0=-10;      // start x angle for leaf
#declare stdalx=40;     // std x angle for leaf
#declare stdlsize=0.1;     // stddev of leaf size 0=constant size; size = leafsize*(1+stdlsize*rand)

//-----------------------------------------
// leaf structure parameters
//-----------------------------------------
#declare txtLeaf=texture{pigment { rgb 0 }} // Leaf texture
#declare lsize=0.8;     // leaf size
#declare seg=5;        // nb of leaf segments and stalk segments : increase to smooth
#declare ll=3;          // leaf length
#declare wl=.2;          // leaf width 
#declare fl=0.05;        // depth of leaf fold
#declare lpow=1;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=100;        // leaf bending angle : the leaf bends backward until this angle
#declare apow=1;        // curve power, how slow the leaf bends
#declare ndents=0;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=1;      // number of lobes (individual leaves)
#declare alobes=110;    // angle made by all the lobes
#declare qlobes=0.7;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)                               
#declare ls=1;          // stalk length (0=no stalk)
#declare ws=0.012;        // width of stalk
#declare as=10;         // stalk bending angle : the stalk bends forward
//-----------------------------------------
// end of parameters
//=========================================

#declare branches =
object{
        #if (leafproba>0)
        #declare Leaf=object{MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
                 ndents,nlobes,alobes,qlobes,ls,ws,as,dofile,ffname)
                 #if (dotexture=false)  // no texture applied to tree segments, so the leaf texture must be used for the individual leaf
                        texture{txtLeaf}
                 #end
        } 
        
        #end              
        MakeTree()
        
        #if (dotexture = true) // texture is already applied to tree so that we can safely apply the leaf texture to the leaves
                texture {txtLeaf}
        #else

                texture {branch_texture} // apply tree texture  regardless of the tree structure
        #end
        
        rotate y*45
}