// Nostalgia Scene File
// (POV-Ray ver 3.1g)
// By S.Nishimura


#include "coordinate_color.mcr.inc"


global_settings { assumed_gamma 2.2 }


camera { location < 40, 160, -200 >
	 look_at < 0, 50, -10 >
	 angle 50
}

light_source { < 200,340,-200 > color rgb 1 fade_distance 400 fade_power 1 }


//**********************************************************************************
coordinate_color(  8, 0.81, 0.50, 1, 1 )
coordinate_color( 16, 0.73, 0.30, 1, 2 )
coordinate_color(  0, 0.75, 0.40, 1, 3 )
coordinate_color( -8, 0.70, 0.35, 1, 4 )
#declare M_media =
media { emission 0.04 // absorption 0.04 
        intervals 40
        samples 1, 1
        confidence 0.9
        variance 0.1
        density { bozo
                  turbulence 0.33
                  octaves 8
                  lambda 4
                  omega 0.6
                  color_map { [ 0.0 rgb < 0, 0, 0 > ]
                              [ 0.1 rgb < R1, G1, B1 > ]
                              [ 0.4 rgb < R2, G2, B2 > ]
                              [ 0.7 rgb < R3, G3, B3 > ]
                              [ 0.9 rgb < R4, G4, B4 > ]
                              [ 1.0 rgb < 0, 0, 0 > ] }
                  rotate 10*y
                  scale 80*12 }
}
//
sphere { 0 120 hollow pigment { color rgbf < 1, 1, 1, 1 > } interior { media { M_media } } }
//**********************************************************************************
#include "FaceR02c.dat.inc"
//----------------------------------------------------------------------------------
coordinate_color( 90, 0.8, 0.9, 1, 1 )
#local Face =
union {
 object { dxfobj0 }
 object { dxfobj1 }
 object { dxfobj2 }
 object { dxfobj3 }
 object { dxfobj4 }
 pigment { color rgbt < R1, G1, B1, 0.2 > }
}
//**********************************************************************************
#include "curved_surface.mcr.inc"
//----------------------------------------------------------------------------------
// curved surface functions
#macro Surface_func(Ss,Se,Px,Py,Pz,Func_type)
 #switch(Func_type)
 #case(0) #local Sc=4; #local Px=Sc*Ss; #local Pz=Sc*Se;
          #local Rp=(pow(.2*Px,2)+pow(.2*Pz,2));
          #local Py=Sc/sqrt(Rp)*sin(pi*sqrt(Rp)); #break
 #end
#end
//----------------------------------------------------------------------------------
// curved surface definition (initialize)
coordinate_color( 60, 0.9, 0.6, 3, 1 )
#local T_tri =
 texture { 
  pigment { ripples
            color_map { [ 0.0 rgbt < R1, G1, B1, 0.4 > ]
                        [ 0.5 rgbt < R2, G2, B2, 0.3 > ] 
                        [ 1.0 rgbt < R3, G3, B3, 0.2 > ] } }
 finish { reflection 0 ambient 0.4 phong 0.2 brilliance 0.5 diffuse 0.5 }
}
// curved surface object
#local Millinery =
object { Surface_tri4m(-pi,pi*1.1,pi/12,-pi,pi,pi/12,0)
 texture { T_tri }
 scale < 1, 0.5, 1 >*4 rotate < 18.4, 0, 0 > translate < 0, 98, 17.4 >
}
//**********************************************************************************
#include "BlossomP02b.def.inc"
//----------------------------------------------------------------------------------
union {
 object { Face }
 object { Blossom rotate < -35, 0, -65 > translate < 22.2, 80, -18 > }
 object { Millinery }
translate -2*y
}
//**********************************************************************************
// locuse of uniform velocity motion
#macro Uvm_locus(P0,Lr,Func_type)
 #local Sp=-pi; #local Ep=pi*0.9; #local Ap=pi/8;
#while(Sp<Ep)
 #switch (Func_type)
  #case(0) #local Mv=radians(90); #local Mh=18/11*cos(Sp)+1-sin(Sp); #break
  #case(1) #local Mv=radians(90); #local Mh=1/6*Sp; #break
  #case(2) #local Mv=radians(90); #local Mh=-4/12*pow(Sp,2); #break
  #case(3) #local Mv=radians(90); #local Mh=-4/12*pow(Sp,2); #break
 #end
#if ( 0 = mod(Sp, Ap*2)) 
 object { Locus_seg rotate <-45,0,90-degrees(Mv)> rotate (-degrees(Mh))*y translate P0 }
#else
 object { Locus_seg rotate < 45,0,90-degrees(Mv)> rotate (-degrees(Mh))*y translate P0 }
#end
// next stage value
 #local P0=P0+<Lr*sin(Mv)*cos(Mh),Lr*cos(Mv),Lr*sin(Mv)*sin(Mh)>;
 #local Sp=Sp+Ap;
#end // while end
#end // macro end
//----------------------------------------------------------------------------------
// Locus definition
#local Sr=1;
#local Locus_seg = sphere { 0, Sr }
//
coordinate_color( 270, 0.9, 0.6, 1, 1 )
#local T_locus =
 texture {
  pigment { color rgb < R1, G1, B1 > }
   finish { specular 0.8
            roughness 0.01
            reflection 0.8
            phong 1.0
            phong_size 180 }
}
//----------------------------------------------------------------------------------
// nekles
#local Lr=Sr*2;
union {
 #local P0=< -4, 0, -2 >;
 Uvm_locus(P0,Lr,0)
 Uvm_locus(P0,Lr,1)
 #local P0=< -4, 0, -2 >;
 Uvm_locus(P0,Lr,2)
 Uvm_locus(P0,Lr,3)
 texture { T_locus }
 rotate -90*x scale 6 translate < -70, 40, 40 >
}
//**********************************************************************************
// pendant
coordinate_color( 70, 0.7, 0.5, 1, 1 )
coordinate_color( 30, 0.7, 0.8, 1, 4 )
union{
sphere { 0, 1 clipped_by { plane { z, -0.85 } }
 pigment { marble
           turbulence 1.8
           color_map { [0.0 rgb < R1,   G1, B1   > ]
                       [0.8 rgb < R1/2, G1, B1/2 > ]
                       [1.0 rgb < R1/4, G1, B1/4 > ] }
           scale 0.3 }
 normal { bump_map { png "peony" map_type 0 once
                                   interpolate 2
                                   use_color
                                   bump_size 5 }
          scale < 4/3, 1, 1 >
          translate < -(4/3)/2,-1/2, 0 > }
 translate 0.85*z }
torus { 0.53, 0.02 sturm
 pigment { color rgb < R4, G4, B4 > }
 finish { metallic
          ambient 0.2
          diffuse 0.7
          brilliance 6
          reflection 0.25
          phong 0.75
          phong_size 80 }
 rotate -90*x }
rotate 45*x scale 60 translate < 70, 0, 0 >
}
//**********************************************************************************
// space line functions
#macro Line_func(Tp,P0,Func_type)
 #switch(Func_type)
 #case(0) #if(0<Tp) #local Rr=50/sqrt(Tp+1.6e-1); #else #local Rr=50/sqrt(-Tp+1.6e-1); #end
          #if(0<=Tp) #local Px=Rr*cos(Tp); #else #local Px=-Rr*cos(Tp);#end
          #local Py=Rr*sin(Tp); #local Pz=0*Rr*Tp/15; #break
 #case(1) #local Rr=30*((1+0.5*cos(5*Tp))*(1-cos(5*Tp))+0.1);
          #local Px=Rr*cos(Tp); #local Py=Rr*sin(Tp); #local Pz=0; #break
 #case(2) #local Rr=40*sin(1.11*Tp);
          #local Px=Rr*cos(0.5*Tp); #local Py=40*cos(1.11*Tp); #local Pz=Rr*sin(0.5*Tp); #break
 #case(3) #local Rr=40;
          #local Px=Rr*cos(Tp)*sin(Tp/20); #local Py=Rr*cos(Tp/20); #local Pz=Rr*sin(Tp)*sin(Tp/20); #break
 #end
 #local P0=< Px,Py,Pz >;
#end
//----------------------------------------------------------------------------------
// space line macro
#macro Space_line(Lw,Ts,Te,Ta,Func_type)
 #local P0=< 0, 0, 0 >;
 
 #local Tp=Ts; #while(Tp<Te)
 Line_func(Tp   ,P0,Func_type) #local P1=P0;
 Line_func(Tp+Ta,P0,Func_type) #local P2=P0;
 #local D1=P1+(P2-P1)/3; #local D2=P1+(P2-P1)*2/3;
 sphere { P1, Lw } cylinder { P1, D1, Lw }
 Line_func(Tp+Ta*2,P0,Func_type) #local P3=P0;
 #local D3=P2+(P3-P2)/3; #local D4=P2+(P3-P2)*2/3;
 #local D5=D2+(D3-D2)/3; #local D6=D2+(D3-D2)*2/3;
 sphere { D1, Lw } cylinder { D1, D5, Lw }
 sphere { D5, Lw } cylinder { D5, D6, Lw }
 sphere { D6, Lw } cylinder { D6, D4, Lw }
 sphere { D4, Lw } cylinder { D4, P3, Lw }

 #local Tp=Tp+Ta*2; #end
#end
//----------------------------------------------------------------------------------
// space line object
#local F_cyl = finish { metallic specular 0.3 roughness 0.1 diffuse 0.7 reflection 0.2 }
coordinate_color( 270, 0.9, 0.6, 3, 1 )
union {
 union { Space_line(1,-pi*1, pi*1, pi/32,1) pigment { color rgb < R2, G2, B2 > } finish { F_cyl } }
 union { Space_line(1,-pi*10,pi*10,pi/24,2) pigment { color rgb < R3, G3, B3 > } finish { F_cyl } }
 union { Space_line(1,-pi*0, pi*20,pi/24,3) pigment { color rgb < R1, G1, B1 > } finish { F_cyl } }
translate < -100, -40, 20 >
}
//**********************************************************************************
#macro Ipow(Zp,Np)
 #local Rzp=sqrt(pow(Zp.x,2)+pow(Zp.y,2));
 #if(Rzp=0) #local Hzp=0; #else
 #if(Zp.y/Rzp>=0) #local Sg=1; #else #local Sg=-1; #end
 #local Hzp=Sg*acos(Zp.x/Rzp); #end
 #local Zp=< pow(Rzp,Np)*cos(Np*Hzp), pow(Rzp,Np)*sin(Np*Hzp) >;
#end
//----------------------------------------------------------------------------------
#macro Mandel_fractal(Sr,Er,Si,Ei,Az,Ii,En)
#local Lr=Az/sqrt(2);

#local Px=Sr; #while(Px<Er)
 #local Pz=Si; #while(Pz<Ei)
  #local Z0=< 0, 0 >; #local C0=< Px, Pz >;
  #local Sn=1; #while(Sn<En+1)
   Ipow(Z0,Ii) #local Zn=Z0+C0; #local Z0=Zn; #local Py=Sn/En;
   #if(vlength(Zn)>2) #local Sn=En; #end
  #local Sn=Sn+1; #end
  #if(Py>(En-1)/En) cylinder { < Px, 0, Pz-0.4 >, < Px, Py, Pz-0.4 >, Lr } #end 
 #local Pz=Pz+Az; #end
#local Px=Px+Az; #end

#end // macro end 
//----------------------------------------------------------------------------------
#include "KaiBz01a.txt.inc"
coordinate_color( 30, 0.5, 0.7, 2, 1 )
union {
 union { Mandel_fractal( -1.5,1.5,-1.4,1.6,3/60,7,30 )
  pigment { wood
            turbulence < 0.6, 1.0, 0.3 >
            color_map { [ 0.0 rgb < R1, G1, B1 > ]
                        [ 1.0 rgb < R2, G2, B2 > ] }
            scale 0.3 }
  scale 50 }
 object { Text_kai pigment { color rgb 1 } translate < 0, 0.74*50/13+1e-13, -1.54 > scale 13 }
rotate -20*x scale < 0.5, 0.2, 0.5 > translate < 70, 60, 70 > }  
//**********************************************************************************


// Signature
/*
#include "Sealreverse.sgn.inc"
object { Sealing
         rotate < -degrees(atan2(-110,sqrt(pow(40,2)+pow(190,2)))), 180+degrees(atan2(40,-190)), 0 >
         translate < -128, -68, -20 > }
*/