//WL0 and waterScale can be defined prior to calling this include file.
#ifdef(Water_Inc_Temp)
   // do nothing, already loaded.
#else
   #declare Water_Inc_Temp = version;
   #ifdef(View_POV_Include_Stack)
      #debug "including water.inc\n"
   #end



   #ifndef (WL0)
       #declare WL0=0;
   #end
   #ifndef (waterScale)
       #declare waterScale=1;
   #end

   #declare Water=
   material{texture{pigment{color rgbf <1, 1, 1, 1>} 
                    finish{phong 1 phong_size 90 diffuse 0 
                           //conserve_energy
                           //reflection_min .1
                           //reflection_max .9
                           //reflection_falloff 2
                           reflection 0.5
                          } 
                    normal{ripples scale 3000*waterScale frequency 5000/waterScale}
                   }
            interior{ior 1.33
                     media{absorption<0.1,0.05,0.05>/waterScale
                           samples 2, 2
                          }
                    }
           }

   #declare waterPlane=
   union{plane{y,WL0 material{Water}}
         plane{y,WL0-100*waterScale pigment{color rgb 0.4}}
        }


   #ifndef(Colors_Inc_Temp) // if not called as an include file
       #include "colors.inc"  // make a scene
       #include "skies.inc"

       background { color rgb <0.8,0.8,1>}
       sky_sphere{S_Cloud5}
       object{waterPlane}
       light_source{10000*z // the moon
                    color rgb 0.5
                    rotate -3*x rotate -15*y
                   }
       sphere{10000*z,10000/25 // and this is what the moon looks like....
              texture{pigment{White} finish{ambient 1}}
              rotate -3*x rotate -15*y
              no_shadow
             }

       // Camera (Latitude,Longitude,Radius = 30,45,0)
       camera {location <2,1,-10>
               look_at  <0,0,0>
               angle 26
//               translate 0.03*<4,0,2> // left picture for stereo view
       }

       // Lights:
       light_source{<-10,133.366,-103.366>  // Latitude,Longitude,Radius: 45,0,146.182
                    color rgb <1,1,1> }
//       light_source{<99.6367,103.091,-63.2988>  // Latitude,Longitude,Radius: 30,120,146.182
//                    color rgb <1,1,1> }
//       light_source{<-73.2988,156.598,-36.5456>  // Latitude,Longitude,Radius: 60,-120,146.182
//                    color rgb <1,1,1> }
   #end


#end
