 /********************
 * The Measurements *
********************/
#declare bug_head_rad = 0.0013;
#declare bug_head_length = 0.002;
#declare bug_thorax_length = 0.01;
#declare bug_thorax_rad = 0.0010;
#declare bug_abdomen_length = 0.02;
#declare bug_abdomen_rad = 0.0012;
#declare bug_eye_length = 0.0004;
#declare bug_eye_rad = 0.0008;
#declare bug_nose_length = 0.008;
#declare bug_nose_top_rad = 0.0003;
#declare bug_nose_end_rad = 0.0002;
#declare bug_wing_length = 0.005;
#declare bug_wing_width = 0.0025;
#declare bug_leg_height = 0.015;
#declare bug_leg_rad = 0.0007;
#declare bug_leg_spread = 0.02;

#declare bug_length = bug_head_length+bug_thorax_length+bug_abdomen_length;
#declare bug_centre_height = 0.008;
#declare bug_bulge = 1.2;
/*
#declare bug_head_rad = 0.003;
#declare bug_head_length = 0.008;
#declare bug_thorax_length = 0.01;
#declare bug_thorax_rad = 0.0036;
#declare bug_abdomen_length = 0.02;
#declare bug_abdomen_rad = 0.004;
#declare bug_eye_length = 0.0007;
#declare bug_eye_rad = 0.002;
#declare bug_nose_length = 0.011;
#declare bug_nose_top_rad = 0.0005;
#declare bug_nose_end_rad = 0.0002;
#declare bug_wing_length = 0.025;
#declare bug_wing_width = 0.004;
#declare bug_leg_height = 0.012;
#declare bug_leg_rad = 0.0003;
#declare bug_leg_spread = 0.014;

#declare bug_length = bug_head_length+bug_thorax_length+bug_abdomen_length;
#declare bug_centre_height = 0.01;
#declare bug_bulge = 1.2;
*/

 /************
 * Textures *
************/
#declare bug_eye_dent =
	normal {
		leopard 0.6
		scale 1/pi
		translate <100,100,100>
	}

#declare bug_eye_tex =
	texture {
		pigment {
			rgb 1
		}
		normal {
			bug_eye_dent
			scale 0.1
		}
		finish {
			ambient rgb <0.0,0.03,0.0>
			diffuse 0.3
			reflection 0.4
			specular 1 roughness 0.004
		}
	}

#declare bug_general_tex =	
	texture {
		pigment {
			rgb <1, 0.9, 0.3>//1
		}
		normal {
			spotted 0.04
			scale <1,0.0001,0.0001>
		}
		finish {
			ambient rgb <0.03, 0.1, 0.1>//<0.14, 0.35, 0.35>//<0.2,0.3,0.4>//
			diffuse 0.8//0.4//0.5//
			reflection 0.1
			specular 1 roughness 0.004
		}
	}
	
#declare bug_spotted_tex =
	texture {
		pigment {
			spotted
			colour_map {
				[0.3 rgbt <2,0.4,0,0> ]//<0,1,2,0>]//
				[0.6 rgbt <0,0,1,1> ]//<0,2,1,1>]//
			}
			scale 0.001
		}
		finish {
			ambient 0.7
			diffuse 0.6
		}
	}
	
#declare bug_wing_tex =
	texture {
		pigment { rgbt <1,1,1,0.8> }
		normal {
			crackle -0.1
			scale 0.003
			poly_wave 0.8
		}
		finish {
			diffuse 0//.9
			ambient 1
			specular 0.8 roughness 0.001
			irid {
				0.7
				thickness 0.15
				//turbulence 0.01
			}
		}
	}
/*
#declare bug_eye_dent =
	normal {
		leopard 0.6
		scale 1/pi
		translate <100,100,100>
	}

#declare bug_eye_tex =
	texture {
		pigment {
			rgb 1
		}
		normal {
			bug_eye_dent
			scale 0.1
		}
		finish {
			ambient rgb <0.0,0.03,0.0>
			diffuse 0.3
			reflection 0.4
			specular 1 roughness 0.004
		}
	}

#declare bug_general_tex =	
	texture {
		pigment {
			rgb 1
		}
		normal {
			spotted 0.04
			scale <1,0.0001,0.0001>
		}
		finish {
			ambient rgb <0.0, 0.04, 0.2>
			diffuse 0.8
			reflection 0.1
			specular 1 roughness 0.004
		}
	}
	
#declare bug_wing_tex =
	texture {
		pigment { rgbt <1,1,1,0.8> }
		normal {
			crackle -0.1
			scale 0.003
			poly_wave 0.8
		}
		finish {
			diffuse 0.9
			ambient 0.1
			specular 0.8 roughness 0.001
			irid {
				0.7
				thickness 0.15
				//turbulence 0.01
			}
		}
	}
*/

 /***********
 * Abdomen *
***********/
#declare abdomen =
	union {
		sphere {
			<0,0,0>, 1
			scale <bug_abdomen_length/2,bug_abdomen_rad,bug_abdomen_rad>*bug_bulge
			translate <-bug_length/2+bug_abdomen_length/2,bug_centre_height,0>
		}
		texture {
			bug_general_tex
		}
		texture {
			bug_spotted_tex
		}
	}


 /**********
 * Thorax *
**********/
#declare thorax =
	union {
		sphere {
			<0,0,0>, 1
			scale <bug_thorax_length/2,bug_thorax_rad,bug_thorax_rad>*bug_bulge
			translate <bug_length/2-bug_head_length-bug_thorax_length/2,bug_centre_height,0>
		}
		texture {
			bug_general_tex
		}
	}
	

 /********
 * Head *
********/
#declare head =
	union {
		union {
			//main head
			sphere {
				<0,0,0>, 1
				scale <bug_head_length/2,bug_head_rad,bug_head_rad>*bug_bulge
				translate <bug_length/2-bug_head_length/2,bug_centre_height,0>
			}
			//nose thing
			/*cone {
				<bug_head_length/2-bug_nose_top_rad+(bug_bulge-1)*bug_head_length/2,0,0>, bug_nose_top_rad, <bug_head_length/2-bug_nose_end_rad+(bug_bulge-1)*bug_head_length/2,-bug_nose_length,0>, bug_nose_end_rad
				rotate <0,0,20>
				translate <bug_length/2-bug_head_length/2,bug_centre_height,0>
			}*/
		
			texture { bug_general_tex	}
		}

		//eyes
		sphere {
			<0,0,0>, 1

			texture { bug_eye_tex }

			scale <bug_eye_length,bug_eye_rad,bug_eye_rad>*bug_bulge
			translate <bug_head_length/2,0,0>
			rotate <0,0,20>
			rotate <0,45,0>
			translate <bug_length/2-bug_head_length/2,bug_centre_height,0>
		}
		sphere {
			<0,0,0>, 1

			texture { bug_eye_tex }

			scale <bug_eye_length,bug_eye_rad,bug_eye_rad>*bug_bulge
			translate <bug_head_length/2,0,0>
			rotate <0,0,20>
			rotate <0,-45,0>
			translate <bug_length/2-bug_head_length/2,bug_centre_height,0>
		}
	}
	
	
 /*********
 * Wings *
*********/
#declare wings =
	union {
		disc {
			<0,0,1>, y, 1
			scale <bug_wing_width,1,bug_wing_length>
			rotate <-30,-10,-20>
			translate <bug_length/2-bug_head_length-bug_thorax_length/3,bug_centre_height+bug_thorax_rad,0>
		}
		disc {
			<0,0,1>, y, 1
			scale <bug_wing_width,1,bug_wing_length>
			rotate <-30,-50,-10>
			translate <bug_length/2-bug_head_length-bug_thorax_length/2,bug_centre_height+bug_thorax_rad,0>
		}
		disc {
			<0,0,1>, y, 1
			scale <bug_wing_width,1,bug_wing_length>
			rotate <-30,-10,-20>
			scale <1,1,-1>
			translate <bug_length/2-bug_head_length-bug_thorax_length/3,bug_centre_height+bug_thorax_rad,0>
		}
		disc {
			<0,0,1>, y, 1
			scale <bug_wing_width,1,bug_wing_length>
			rotate <-30,-50,-10>
			scale <1,1,-1>
			translate <bug_length/2-bug_head_length-bug_thorax_length/2,bug_centre_height+bug_thorax_rad,0>
		}
		texture { bug_wing_tex }
	}


 /********
 * Legs *
********/
#declare leg =
	union {
		cylinder { <0,bug_centre_height,0>, <0,bug_leg_height,-bug_leg_spread*2/3>, bug_leg_rad }
		cylinder { <0,bug_leg_height,-bug_leg_spread*2/3>, <0,0,-bug_leg_spread>, bug_leg_rad }
	}

#declare legs =
	union {
		object { leg translate <0,0,-bug_thorax_rad> rotate <0,-20,0> }
		object { leg translate <0,0,-bug_thorax_rad> rotate <0,10,0> }
		object { leg translate <0,0,-bug_thorax_rad> rotate <0,40,0> }
		object { leg translate <0,0,-bug_thorax_rad> rotate <0,-20,0> scale <1,1,-1> }
		object { leg translate <0,0,-bug_thorax_rad> rotate <0,10,0> scale <1,1,-1> }
		object { leg translate <0,0,-bug_thorax_rad> rotate <0,40,0> scale <1,1,-1> }
		
		texture { bug_general_tex	}

		translate <bug_length/2-bug_head_length-bug_thorax_length/2,0,0>
	}


 /**********************************
 * Everything in it's right place *
**********************************/
#declare bug =
	union {
		object { abdomen }
		object { thorax }
		object { head }
		object { wings }
		object { legs }
		translate -<bug_length/2-bug_head_length-bug_thorax_length/2,0,0>
	}


#ifndef ( final_image )
	//do a test render of the bug
	camera {
		right x*4/3
		up y
		direction z
		
		location <1,0.5,-0.7>*0.1+0.01*y
		look_at <0,0.01,0>//<0,bug_centre_height,-bug_length/2>//
		angle 50
	}
	
	light_source {
		<-1000,1000,1000>
		rgb 1
	}
	
	/*light_source {
		<1000,-1000,1000>
		rgb 0.3
	}*/

	#declare sunset_layer1 =
	  //blue
	  pigment {
	    gradient y
	    cubic_wave //use a cubic wave to avoid mach banding.
	    colour_map {
	      [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
	      [1.00 rgbt <0.0, 0.0, 1.0, 0.8>]
	    }
	  }
	
	#declare sunset_layer2 =
	  //green
	  pigment {
	    boxed
	    scale <1, 0.7, 1>
	    pigment_map {
	      [0.0 rgbt <0.0, 0.0, 0.0, 1.0>]
	      [0.000000000001
	        gradient y
	        cubic_wave
	        colour_map {
	          [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
	          [1.00 rgbt <0.0, 1.0, 0.0, 1.0>]
	        }
	      ]
	    }
	  }
	
	#declare sunset_layer3 =
	  //red
	  pigment {
	    boxed
	    scale <1, 0.6, 1>
	    pigment_map {
	      [0.0 rgbt <0.0, 0.0, 0.0, 1.0>]
	      [0.000000000001
	        gradient y
	        cubic_wave
	        colour_map {
	          [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
	          [1.00 rgbt <1.0, 0.0, 0.0, 1.0>]
	        }
	      ]
	    }
	  }
	
	sky_sphere {
	  pigment { sunset_layer1 }
	  pigment { sunset_layer2 }
	  pigment { sunset_layer3 }
	  scale 1.8
	}
	
	plane {
		y, 0
		no_shadow
		texture {
			pigment { rgb 1 }
			finish {
				diffuse 0.8//0.5
				ambient 0.2//0.1
				//reflection 0.4
			}
		}
	}
	
	object {
		bug
		rotate 90*y
	}
#end



