 /********************
 * The Measurements *
********************/
#declare can_height = 0.15;
#declare can_bevel = 0.01;
#declare can_top = 0.006;
#declare can_radius = 0.05;
#declare can_curve_radius = 0.003;
#declare can_chrome_out_height = 0.004;
#declare can_chrome_in_height = 0.005;
#declare can_chrome_out_rad = 0.0005;
#declare can_chrome_top_rad = 0.003;

 /*************
 * Main body *
*************/
#declare can_body =
	difference {
		union {
			#declare temp = can_curve_radius/sqrt(2);
			cylinder {
				<0,-can_height/2+can_bevel,0>, <0,can_height/2-can_bevel-can_top+can_curve_radius-temp*2,0>, can_radius
				open
			}
			torus {
				can_radius-can_curve_radius, can_curve_radius
				translate <0,can_height/2-can_bevel-can_top+can_curve_radius-temp*2,0>
			}
			torus {
				can_radius-can_curve_radius, can_curve_radius
				translate <0,-can_height/2+can_bevel,0>
			}
			cone {
				<0,can_height/2-can_bevel-can_top+can_curve_radius-temp,0>, can_radius-can_curve_radius+temp, <0,can_height/2-can_top,0>, can_radius-can_bevel
			}
			cone {
				<0,-can_height/2+can_bevel-temp,0>, can_radius-can_curve_radius+temp, <0,-can_height/2+temp,0>, can_radius-can_bevel+temp
			}
			torus { //there's an error here, but it's close enough (you can't see the bottom of the can!)
				can_radius-can_bevel, can_curve_radius
				translate <0,-can_height/2+can_curve_radius,0>
			}
			cylinder {
				<0,can_height/2-can_top,0>, <0,can_height/2-can_chrome_out_height,0>, can_radius-can_bevel
			}
			difference {
				//create a cunning curve up to the "neck"
				cone { //the thing to cut out of
					<0,can_height/2-can_top + can_curve_radius*tan(radians(22.5)),0>, can_radius-can_bevel+can_curve_radius, <0,can_height/2-can_top + can_curve_radius*tan(radians(22.5))-0.01,0>, can_radius-can_bevel+can_curve_radius-0.01
				}
				torus { //position so it touches the edge of the top cylinder and cone, but doesn't cut into them.
					can_radius-can_bevel+can_curve_radius, can_curve_radius
					translate <0,can_height/2-can_top + can_curve_radius*tan(radians(22.5)),0>
				}
			}
		}
		//cut a hole out of the top, for the chrome bit
		cylinder {
			<0,can_height/2,0>, <0,can_height/2-can_chrome_out_height-0.02,0>, can_radius-can_bevel-can_chrome_out_rad/2
		}
		
		texture {
/*			pigment {
				rgb 0.2
			}*/
			pigment {
				image_map {
					gif "canlabel.gif"
					interpolate 2
					map_type 2
				}
				translate <0,-0.5,0>
				scale can_height-0.015
				//rotate <0,-120,0>
			}
			finish {
				diffuse 0.8
				ambient 0.1
				reflection 0.1
				specular 1.0 roughness 0.02 
			}
		}
	}


 /**************
 * Chrome top *
**************/
#declare can_chrome =
	union {
		torus {
			can_radius-can_bevel, can_chrome_out_rad
			scale <1,(can_chrome_out_height/2)/can_chrome_out_rad,1>
			translate <0,can_height/2-can_chrome_out_height/2,0>
		}
		cylinder {
			<0,can_height/2-can_chrome_out_height/2,0>, <0,can_height/2-can_chrome_out_height-0.02,0>, can_radius-can_bevel-can_chrome_out_rad
			open
		}
		sphere {
			<0,0,0>, can_radius-can_bevel-can_chrome_out_rad
			scale <1,can_chrome_top_rad/(can_radius-can_bevel-can_chrome_out_rad),1>
			translate <0,can_height/2-can_chrome_in_height-can_chrome_top_rad,0>
		}

		texture {
			pigment { rgb 0.1 }//0.4 }
			finish {
				diffuse 0.6
				ambient rgb <0.3, 0.4, 0.6>
				reflection 0.9
				specular 1.0 roughness 0.02 
			}
			normal {
				bump_map {
					gif "ringpull.gif"
					map_type 0
					once
					interpolate 4
					bump_size 3
				}
				translate <-0.5,-0.6,0>
				rotate <90,0,0> //put it on the x,z plane
				scale 0.08
			}
		}
	}


 /**********************************
 * Everything in it's right place *
**********************************/
#declare can =
	union {
		object { can_body }
		object { can_chrome }
	}


#ifndef ( final_image )
	//do a test render of the can
	camera {
		right x*4/3
		up y
		direction z
		
		location <1,1,-1>*0.15
		look_at <0,0,0>
		angle 50
	}
	
	light_source {
		<-1000,1000,-1000>
		rgb 1
	}
	
	light_source {
		<1000,-1000,1000>
		rgb 1
	}

	#declare sunset_layer1 =
	  //blue
	  pigment {
	    gradient y
	    cubic_wave //use a cubic wave to avoid mach banding.
	    colour_map {
	      [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
	      [1.00 rgbt <0.0, 0.0, 1.0, 0.8>]
	    }
	  }
	
	#declare sunset_layer2 =
	  //green
	  pigment {
	    boxed
	    scale <1, 0.7, 1>
	    pigment_map {
	      [0.0 rgbt <0.0, 0.0, 0.0, 1.0>]
	      [0.000000000001
	        gradient y
	        cubic_wave
	        colour_map {
	          [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
	          [1.00 rgbt <0.0, 1.0, 0.0, 1.0>]
	        }
	      ]
	    }
	  }
	
	#declare sunset_layer3 =
	  //red
	  pigment {
	    boxed
	    scale <1, 0.6, 1>
	    pigment_map {
	      [0.0 rgbt <0.0, 0.0, 0.0, 1.0>]
	      [0.000000000001
	        gradient y
	        cubic_wave
	        colour_map {
	          [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
	          [1.00 rgbt <1.0, 0.0, 0.0, 1.0>]
	        }
	      ]
	    }
	  }
	
	sky_sphere {
	  pigment { sunset_layer1 }
	  pigment { sunset_layer2 }
	  pigment { sunset_layer3 }
	  scale 1.8
	}
	
	object {
		can
	}
#end



