 /********************
 * The Measurements *
********************/
//courtesy of NASA's website
#declare fuel_tank_height				= 47;
#declare fuel_tank_rad					= 4.2;
#declare fuel_tank_cone_height	= 12;
#declare fuel_tank_Y_offset			= 9.14/2;

#declare booster_height					= 45.4;
#declare booster_rad						= 1.85;
#declare booster_cone_height		= 6;
#declare booster_Y_offset				= -9.14/2-(47-45.4)/2;

#declare shuttle_height					= 37.23;
#declare shuttle_width					= 23.79;
#declare shuttle_nose_height		= 8;
#declare shuttle_engine_height	= 2;
#declare shuttle_cockpit_height	= 7;
#declare shuttle_bulge_height		= 4;
#declare shuttle_bay_rad				= 2.3;
#declare shuttle_bulge_rad			= 1.2;
#declare shuttle_nose_width			= 2.8;
#declare shuttle_nose_depth			= 1.4;
#declare shuttle_wing_back			= -shuttle_height/2+3;
#declare shuttle_wing_front1		= 5;
#declare shuttle_wing_kink1			= -shuttle_height/2+7;
#declare shuttle_wing_front2		= shuttle_height/2+4;
#declare shuttle_wing_kink2			= -2;
#declare shuttle_kink2_width		= (shuttle_width/2)*(shuttle_wing_front1-shuttle_wing_kink2)/(shuttle_wing_front1-shuttle_wing_kink1);
#declare shuttle_wing_dist			= shuttle_bulge_rad;
#declare shuttle_Y_offset				= -6;


 /*************
 * Fuel Tank *
*************/
#declare fuel_tank =
	union {
		intersection {
			sphere {
				<0,-1,0>, 1
			}
			plane {
				-y, 1
			}
			scale <fuel_tank_rad,fuel_tank_cone_height,fuel_tank_rad>
			translate <0,fuel_tank_height/2,0>
		}
		cylinder {
			<0,-fuel_tank_height/2,0>, <0,fuel_tank_height/2-fuel_tank_cone_height,0>, fuel_tank_rad
		}
		
		texture {
			pigment { rgb <0.7,0.2,0.2> }
			finish {
				ambient 0.3
				diffuse 0.7
			}
		}
	}
         
         
 /***********
 * Booster *
***********/
#declare booster =
	union {
		cone {
			<0,booster_height/2-booster_cone_height,0>, booster_rad, <0,booster_height/2,0>, 0
		}
		cylinder {
			<0,-booster_height/2,0>, <0,booster_height/2-booster_cone_height,0>, booster_rad
		}
		
		texture {
			pigment { rgb 1 }
			finish {
				ambient 0.3
				diffuse 0.7
				specular 1 roughness 0.004
			}
		}
	}


 /***********
 * Shuttle *
***********/
#declare bs = 1.0;
#declare bc = 1.5;
#declare shuttle =
	union {
		intersection {
			triangle { <0,shuttle_wing_front2,shuttle_wing_dist>, <-shuttle_kink2_width,shuttle_wing_kink2,shuttle_wing_dist>, <shuttle_kink2_width,shuttle_wing_kink2,shuttle_wing_dist> }
			plane { y, shuttle_height/2-5 }
		}
		triangle { <0,shuttle_wing_front1,shuttle_wing_dist>, <-shuttle_width/2,shuttle_wing_kink1,shuttle_wing_dist>, <shuttle_width/2,shuttle_wing_kink1,shuttle_wing_dist> }
		polygon { 4, <-shuttle_width/2,shuttle_wing_kink1,shuttle_wing_dist>, <shuttle_width/2,shuttle_wing_kink1,shuttle_wing_dist>,
								<shuttle_width/2,shuttle_wing_back,shuttle_wing_dist>, <-shuttle_width/2,shuttle_wing_back,shuttle_wing_dist> }
		blob {
			cylinder { <0,shuttle_height/2-shuttle_nose_height,shuttle_bay_rad>, <0,-shuttle_height/2+shuttle_engine_height,shuttle_bay_rad>, shuttle_bay_rad*bc, 1 }
			sphere { <0,0,0>, bs, 1 scale <shuttle_bay_rad,shuttle_cockpit_height,shuttle_bay_rad> translate <0,shuttle_height/2-shuttle_nose_height,shuttle_bay_rad> }
			cylinder { <-shuttle_bay_rad+shuttle_bulge_rad/2,shuttle_height/2-shuttle_nose_height,shuttle_bulge_rad>, <-shuttle_bay_rad+shuttle_bulge_rad/2,-shuttle_height/2+shuttle_engine_height,shuttle_bulge_rad>, shuttle_bulge_rad*bc, 1 }
			sphere { <0,0,0>, bs, 1 scale <shuttle_bulge_rad,shuttle_bulge_height,shuttle_bulge_rad> translate <-shuttle_bay_rad+shuttle_bulge_rad/2,shuttle_height/2-shuttle_nose_height,shuttle_bulge_rad> }
			cylinder { <shuttle_bay_rad-shuttle_bulge_rad/2,shuttle_height/2-shuttle_nose_height,shuttle_bulge_rad>, <shuttle_bay_rad-shuttle_bulge_rad/2,-shuttle_height/2+shuttle_engine_height,shuttle_bulge_rad>, shuttle_bulge_rad*bc, 1 }
			sphere { <0,0,0>, bs, 1 scale <shuttle_bulge_rad,shuttle_bulge_height,shuttle_bulge_rad> translate <shuttle_bay_rad-shuttle_bulge_rad/2,shuttle_height/2-shuttle_nose_height,shuttle_bulge_rad> }
			sphere { <0,0,0>, bs, 1 scale <shuttle_nose_width,shuttle_nose_height*2/3,shuttle_nose_depth> translate <0,shuttle_height/2-shuttle_nose_height*2/3,shuttle_nose_depth> }
			threshold 0.5
		}
		
		texture {
			pigment { rgb 1 }
			finish {
				ambient 0.3
				diffuse 0.7
				specular 1 roughness 0.004
			}
		}
	}

   
 /*************************
 * everything altogether *
*************************/
#declare rocket =
	union {
		object { fuel_tank translate <0,fuel_tank_Y_offset,0> }
		object { booster translate <-booster_rad-fuel_tank_rad,booster_Y_offset,0> }
		object { booster translate <booster_rad+fuel_tank_rad,booster_Y_offset,0> }
		object { shuttle translate <0,shuttle_Y_offset,fuel_tank_rad> }
	}




#ifndef ( final_image )
	//do a test render of the rocket
	camera {
		right x*4/3
		up y
		direction z
		
		location <0,0,-400>
		angle 12
	}
	
	light_source {
		<-1000,1000,-1000>
		rgb 1
	}
	
	object {
		rocket
		rotate 180*y
		rotate <0,0,0>
	}
#end



