#version unofficial Megapov 0.6;  
//EMAIL: castlewrks@aol.com
//NAME: Robert J Becraft
//TOPIC: Contrasts
//COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//TITLE: Saving Ms. Wiggins
//COUNTRY: USA
//WEBPAGE: http://user.aol.com/castlewrks
//         http://www.angelfire.com/md2/castlewrks
//RENDERER USED: MegaPOV 0.6a
//TOOLS USED: IView32 (JPG conversion), PSP (copyright/UVMap editing), POSER, UVMapper, OBJ2POV
//RENDER TIME:  8 minutes, 82.6Meg of memory
//HARDWARE USED: Pentium 433
//IMAGE DESCRIPTION:
//  This image is titled "Saving Ms. Wiggins" for no other reason than to attribute some kind
//  of story-line with the picture.  Ms. Wiggins was apparently kidnapped by the attrocious POVRomans
//  and Sargent Lewis was sent in with the only thing they like more than naked women, a box of
//  gold.  His mission was to buy back Ms. Wiggins and therefore restore her dignity and freedom.
//  The scene represents the point at which he is in negotiation with the chief POVRoman figurehead, 
//  an indignant Ms. Wiggins reposes on her mount in the background.
//
//  Contrast-wise, the following is represented in this render:
//  Black/White of the background mountains
//  New Soldier/Old Soldier
//  Real Figures/POV Primative Figure
//  Clothed/Naked
//  Rich (Sargent Lewis)/Poor (POVRoman)
//  Smooth terrain (Foreground)/ rough terrain (background)
//  Man/Woman
//  Unarmed/Armed
//  Mounted/Unmounted
//  Soft ground/Hard ground implied by rock vs sand
// 
//  That's a round 10, there are more, try and find them.
//
//DESCRIPTION OF HOW THIS IMAGE WAS CREATED:
// Creation of this image required me to do several things I've never done before...
// 1) Using POSER, figure out how to create a figure
// 2) Using POSER, import things that others had done to enhance the standard figures
// 3) Using POSER, export a figure in a format that could be picked up by another tool
// 4) Using UVMapper, move UVMap areas around to un-overlay them
// 5) Using UVMapper, reexport the OBJ file
// 6) Convert the OBJ file to a POV format using OBJ2POV
// 7) Using PSP, paint the new areas of the UVmap for the objects, Created my own camo
// 8) Used MEGAPOV to correctly map the UVMaps onto the objects they represented.
// 9) Standard POV objects were used to create the background
//
// The original design called for all the figures to be POSER figures... however, by luck, I had
// used one of my POV figures to represent the Roman figure that I had not yet developed... the more
// I looked at this picture the more I felt it added to the contrasts being built throughout the 
// render.
                                         
#include "kolors.inc"   // ken's kolor file
#include "stones1.inc"
#include "glass.inc"
#include "woods.inc"
#include "metals.inc"
#include "textures.inc"
//#include "..\POV\med\brick.inc"

//#declare T_MixBrick=texture{T_MixBrick scale .0325}
//#declare T_RedBrick=texture{T_RedBrick scale .0325}  
//#declare T_WhiteBrick=texture{T_WhiteBrick scale .0650} 
//#declare T_Lumpy=texture{T_Lumpy scale .5 translate<0,0,-1000>}

//#declare SkyOff=off  // uncomment to turn off
//#declare HillsOff=off 
//#declare ObjectsOff=off  
//#declare MenOff=off   // turns men on or off
 

camera {
    location <0,3,-10> look_at <0,1,10> //    
 //  location <125,100,-100> look_at <0,10,-10>  //
 //   location <-4,4,-80> look_at <0,10,-10>     // view from across bridge                 
 //   location <-18,4,-30> look_at <0,10,-10>    // inner gate view
 //   location <0,4,-55> look_at <0,1,-30>       // drawbridge view
 //   location <-28,250,-60> look_at <0,1,-30>   // view from up high
}
//light_source{<0,38,0> color White*2} // light up top center

light_source{<0,300,-150> color White}  // BIG light  
light_source{<-20,10,-50> color Wheat shadowless}   

#ifndef(SkyOff)
                           
#include "..\POV\med\cloud.inc"       

fog {                                                 // White ground fog
  distance 25
  colour rgb<0.52, 0.62, 0.72>
  fog_type 2
  fog_offset 5
  fog_alt 3
  turbulence 1.0
  turb_depth 3.0
}
#end // ifndef(SkyOff)


#declare GroundC = 
  texture {
  pigment { granite
  color_map {
    [0.1 color Clear]
    [0.5 color Clear]
    [0.7 color MediumForestGreen]
    [0.9 color DarkGreen] } } 
  finish {
    ambient   0.30
    diffuse   0.50
    brilliance   1.00
    phong   0.1
    phong_size  10.00
  }
  normal { bumps 0.2 }
  scale <.1,.1,.1> }

#declare GroundC2 = 
  texture {
  pigment { granite
  color_map {
    [0.1 color Wheat]
    [0.3 color Wheat5]
    [0.6 color Gray60]
    [0.75 color Wheat4]
    [0.9 color Wheat3]
    [1.0 color Tan]
     } } 
  finish {
    ambient   0.20
    diffuse   0.80
    brilliance   1.00
    phong   0.1
    phong_size  30.00
  }
  normal { bumps .5 }
  scale <1,.051,1> }
    

//cylinder{<0,0,0><0,.001,0> 5000 texture{pigment{color Khaki}}}
  object {   //   Castle base
                height_field { png  "castII.png" }
                texture { GroundC2 rotate<0,0,10> }
                 scale < 400, 25, 300 >   translate < -200, 0, -150>
                 rotate<0,180,0> translate<-20,0,140>
  }
  object {   //   Castle base
                height_field { png  "castII.png" }
                texture { GroundC }
                 scale < 400, 25.04, 300 >   translate < -200, 0, -150>
                 rotate<0,180,0> translate<-20,0,140>
  }        
  
  object {   //   Castle Approach
                height_field { png  "castII.png" }
                texture{pigment{color Wheat1} normal {bumps .005}}
               // texture { pigment {image_map { gif "..\graphics\plants05.gif" } scale .000251 rotate<90,0,0> } }
                 scale < 500, 2, 400 >   translate < -250, 0, -200>
                 rotate<0,110,0> translate<30,0,140>
  }
  object {   //   Castle Approach
                height_field { png  "castII.png" }
                texture{pigment{color White} normal {bumps .025}}
               // texture { pigment {image_map { gif "..\graphics\plants05.gif" } scale .000251 rotate<90,0,0> } }
                 scale < 50, 4.1, 50 >   translate < -25, 0, -25>
                 rotate<0,-130,0> translate<34,0,23>
  }                                                                
  object {   //   Castle Approach
                height_field { png  "castII.png" }
                texture{pigment{color White} normal {bumps .025}}
                 scale < 50, 4.6, 50 >   translate < -25, 0, -25>
                 rotate<0,-170,0> translate<-17,0,21>
  }                                    
  
  object {   //   Castle Approach
                height_field { png  "castII.png" }
                texture { GroundC2 rotate<0,0,60> scale .61 }
                 scale < 425, 15, 425 >   translate < -212.5, 0, -212.5>
                 rotate<0,-55,0> translate<95,0,140>
  }    
//**************************
// Now for a watery plain
  plane {
               < 0,.08,0 >, 0
                texture {
                  pigment { color rgb< 0.0, 0.1, 0.2 > }
                  normal { bumps 0.2  scale < .5, 0.3, 0.3 > }
                  finish { phong 1  reflection 0.5  ambient 0.1  diffuse 0.2 }
                 } 
         translate<0,.20,0>
  }  

//Modern Soldier
#declare OBJuvPOVmaxX =  .13289;
#declare OBJuvPOVminX = -.23555;
#declare OBJuvPOVmaxY =  .75510001;
#declare OBJuvPOVminY =  0;
#declare OBJuvPOVmaxZ =  .1021;
#declare OBJuvPOVminZ = -.13056999;  
#declare OBJuvPOV_Texture = texture
{
    pigment
    {
        image_map
        {
            png "soldier1_text.png"
        }
    }
} 

#declare OBJuvPOV_Texture_OBJuvPOVpants = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVbelt = texture {pigment{color Gray10}} //OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVbuckle = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVshirt = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVskin = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVlashes = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVtongue = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVteeth = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyeBrows = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVlips = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVinnerMouth = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVpupil = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOViris = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyeBall = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVnails = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVsocks = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVshoes = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVsouls = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVlaces = texture {OBJuvPOV_Texture}

#declare Soldier2 =
union
{
    #include "soldier2.inc"
    scale 2.5
}
object {Soldier2 rotate<0,-80,0> translate<-.5,1.6,-7>}


//_________________________________

// - HORSE

#declare OBJuvPOVmaxX =  .12608;
#declare OBJuvPOVminX = -.16743;
#declare OBJuvPOVmaxY =  .81857;
#declare OBJuvPOVminY =  0;
#declare OBJuvPOVmaxZ =  .69004;
#declare OBJuvPOVminZ = -.45517;

#declare OBJuvPOV_Texture = texture
{
    pigment
    {
        image_map
        {
            png "rosegrey2.png"
        }
    }
}
#declare OBJuvPOV_Texture_OBJuvPOVhide = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVmane = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVhooves = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVnose = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVinnerEar = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyeBall = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVtail = texture {OBJuvPOV_Texture}
#declare Horse1 =
union
{
    #include "Horse1.inc"
    scale 2.5
}
object {Horse1 rotate<0,80,0> translate<1.3,1.6,-6.25>}
                                       
//____________________________________
// SLAVE

#declare OBJuvPOVmaxX =  .06061;
#declare OBJuvPOVminX = -.16743;
#declare OBJuvPOVmaxY =  .5995;
#declare OBJuvPOVminY =  0;
#declare OBJuvPOVmaxZ =  .10516;
#declare OBJuvPOVminZ = -.42975;

#declare OBJuvPOV_Texture = texture
{
    pigment
    {
        image_map
        {
            png "Slave1_text.png"
        }
    }
}
#declare OBJuvPOV_Texture_OBJuvPOVskin = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVnipples = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVlips = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyeBrows = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVinnerMouth = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVtongue = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVteeth = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVlashes = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVpupils = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOViris = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyeBall = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVfingerNails = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVtoeNails = texture {OBJuvPOV_Texture}
#declare Slave1 =
union
{
    #include "Slave1.inc"
    scale 2.5
}
object {Slave1 rotate<0,-25,0> translate<1.15,1.85,-5.9>}
                                       
                                       

//------------------------------------

#include "..\pov\med\horse.inc"  
#include "..\pov\roman\romsold.inc"

object{SolSpear rotate<0,90,0> translate<.5,1.65,-7>}

//cylinder{<0,0,0><0,25,0> .025 texture{pigment{color White}}} // <0,0,0>
                                                                           
#macro Contents(OC,SS,RXM,RYM,RZM)

//union{
 //  #declare OC=100;
   #declare CO=1; 
   #declare RS=seed(SS);
   #while (CO<=OC)
      #declare R1=int(rand(RS)*8)+1;
      #declare RX=rand(RS)*RXM-RXM/2;
      #declare RZ=rand(RS)*RZM-RZM/2;
      #declare RY=rand(RS)*RYM/2+RYM/3*2;
      #declare ROX=rand(RS)*360;
      #declare ROY=rand(RS)*360;
      #declare ROZ=rand(RS)*360;
      #declare ROD=rand(RS)*(.250-max(abs(RX),abs(RZ)))/2;
      #declare ROH=rand(RS)*(.250-max(abs(RX),abs(RZ)));
      #declare ROW=rand(RS)*(.250-max(abs(RX),abs(RZ)));
      
      cylinder{<0,0,0><0,.0045,0> .025 texture{pigment{color Gold1} 
       finish{F_MetalA}
       } 
       rotate<ROX,ROY,ROZ> translate<RX,RY,RZ>}
      
     #declare CO=CO+1;
   #end
  bounded_by { box { <-RXM/2,0,-RZM/2>, <RXM/2,max(RYM,.1)*20,RZM/2> } }
  clipped_by { bounded_by }  
  texture{pigment{color Gold1}}
//}
#end // Crate Contents    

#declare Chest=union{
   difference{
      box{<-.25,0,-.15><.25,.25,.15>}
      box{<-.22,.01,-.12><.22,.251,.12>}
   }
   difference{
      box{<-.25,0,-.15><.25,.05,.15>}  // lid
      box{<-.22,-.01,-.12><.22,.04,.12>}
      rotate<90,0,0> 
      translate<0,.4,.15>
   }
   texture{pigment{color DarkBrown}}
}

#declare Gold_Chest=union{
  object{Chest}
  union{Contents(300,92,.44,.1,.3) translate<0,.09,0>} 
}

object{Gold_Chest rotate<0,10,0> translate<-.85,1.6,-7.5>}
                                                                           