// ClothRay example: nappe.pov
// Christophe Bouffartigue (tofbouf@free.fr)

#version unofficial MegaPov 0.6;

#include "clothutil.inc"

#macro WriteClothFile(nomfile, n1, n2, nlng, ks, ht)

	#debug "\nWriting new .cth file\n"
	#fopen file nomfile write
	#write(file, n1, ",", n2, ",", nlng, ",", ks, ",\n")

	#local l1 = .9*nlng*(n1-1);
	#local l2 = nlng*(n2-1);
	#local st = seed(1234);
	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#local tempx = -l1/2 + i*nlng*.9;
			#local tempy = -l2/2 + j*nlng;
            #local tempz = ht + (-1+2*rand(st))*nlng*0.01;
			#write(file, tempx, ",", tempy, ",", tempz, ", 0.0, 0.0, 0.0,\n")
			#local j=j+1;
		#end
		#local i=i+1;
	#end

	#fclose file
#end



/* write initial file */
#macro WriteInitialRideau()
WriteClothFile("rideau.cth", 61, 80, 100/80, 40, -3)

	#fopen file "rideau.cth" append

	#write(file, 79, ", 0.0, 0.0, 0.0,\n")
	#write(file, 10*80+79, ", 0.0, 0.0, 0.0,\n")
	#write(file, 20*80+79, ", 0.0, 0.0, 0.0,\n")
	#write(file, 30*80+79, ", 0.0, 0.0, 0.0,\n")
	#write(file, 40*80+79, ", 0.0, 0.0, 0.0,\n")
	#write(file, 50*80+79, ", 0.0, 0.0, 0.0,\n")
	#write(file, 60*80+79, ", 0.0, 0.0, 0.0,\n")

	#fclose file

#end


/* pull the curtain */
#macro DecaleRideau(dx, mindx)

#debug "\nPulling the curtain\n"

#declare Points[60][79] = Points[60][79] + dx*x;

#if (Points[60][79].x < (Points[0][79].x + 6*mindx))
	#declare Points[60][79] = Points[0][79] + 6*mindx*x;
#end
#local i = 50;
#while (i > 9)
	#if (Points[i][79].x > (Points[i+10][79].x - mindx))
		#debug "\nMoving other points\n"
		#declare Points[i][79] = Points[i+10][79] - mindx*x;
	#end
	#local i=i-10;
#end

#end

/* save changes */
#macro ReWriteRideau()

	#debug "\nRe-Writing .cth file\n"

	#fopen file "rideau.cth" write
	#write(file, 61, ",", 80, ",", 100/80, ",", 40, ",\n")
	
	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#local tempx = Points[i][j].x;
			#local tempy = Points[i][j].y;
            #local tempz = Points[i][j].z;
			#local vx = Vel[i][j].x;
			#local vy = Vel[i][j].y;
            #local vz = Vel[i][j].z;
			#write(file, tempx, ",", tempy, ",", tempz, ", ", vx, ",", vy, ",", vz, ",\n")
			#local j=j+1;
		#end
		#local i=i+1;
	#end

	#write(file, 79, ", 0.0, 0.0, 0.0,\n")
	#write(file, 10*80+79, ", 0.0, 0.0, 0.0,\n")
	#write(file, 20*80+79, ", 0.0, 0.0, 0.0,\n")
	#write(file, 30*80+79, ", 0.0, 0.0, 0.0,\n")
	#write(file, 40*80+79, ", 0.0, 0.0, 0.0,\n")
	#write(file, 50*80+79, ", 0.0, 0.0, 0.0,\n")
	#write(file, 60*80+79, ", 0.0, 0.0, 0.0,\n")

	#fclose file
#end


#macro ReadAllClothFile(nomfile)

	#debug "Reading ALL cloth file...\n"

	#fopen file nomfile read
	#declare n1=0;
	#declare n2=0;
	#local temp=0;
	#local tempx=0;
	#local tempy=0;
	#local tempz=0;
	#read(file, n1, n2, temp, temp)

	#declare Points = array[n1][n2]
	#declare Vel = array[n1][n2]

	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#read(file, tempx, tempy, tempz, vx, vy, vz)
			#declare Points[i][j] = <tempx, tempy, tempz>;
			#declare Vel[i][j] = <vx, vy, vz>;
			#local j=j+1;
		#end
		#local i=i+1;
	#end
	#fclose file
#end


#declare Mur = union {
	plane { -z, 0 }
	plane {x, (-1-(50*60)/80) }
}

//WriteInitialRideau()

//ReadAllClothFile("rideau.cth")
//DecaleRideau(-2, 5)
//ReWriteRideau()

//#declare vect = clothsim(Mur, -.3*y, 0*x, 1.0, .90, .1, 2000, "rideau.cth", "rideau.cth");

//ReadClothFile("rideau.cth")


#declare Rideau = mesh {
//	DrawTriangles(Points, n1, n2, on, off, "rideau_s.msh")
//	DrawSmoothTriangles(Points, n1, n2, on, on, "rideau_s.msh")
//	DrawDoubleSmoothTriangles(Points, n1, n2, .01, on, <.01/1.8, .01/1.8>, off, "rideau_s.msh")
	#include "rideau_s.msh"
	uv_mapping
	texture {
		pigment {
//			checker
			color rgb <.75, .85, 1> //, color rgb <.55, .7, 1>
		}
		normal {
			quilted .01 control0 1 control1 1
			scale <1, 3, 1>
		}
		scale <.01, .01, 1>
	}
}

camera {location <20, 75, -140> right x*3 up y*4 angle 35 look_at 60*y-15*x }

light_source { <-10, 100, -100>, color rgb .5 shadowless }

light_source { <50, 150, -100>*3, color rgb 1.2
	spotlight
	radius 20
	falloff 30
	tightness 2
	point_at 30*y
}


object { Rideau scale <.6, 1, .6> translate 60*y }
object { Mur 
	pigment { rgb .85 }
}

// floor
plane { y, 0
	pigment { color rgb .8 }
	finish { ambient .3 diffuse .7 }
}


