#version unofficial megapov 0.6;

#include "colors.inc"
#include "woods.inc"
#include "metals.inc"

#declare test_lit_inc = off;

// Lit qui rentre presque dans <80, 100, 180>

#declare T_VieuxPlastoc = texture {
	pigment { color rgb<.9, .9, .85> }
	normal { average
		normal_map {
			[1 dents scale .5]
			[1 dents scale .5 translate 100]
			[1 dents scale .5 translate 200]
		}
	}
	finish { specular .3 roughness .1 brilliance .8 }
}

#declare T_Fer = texture {
	pigment { color rgb .4 }
	normal { average
		normal_map {
			[1 dents  .8 scale .1]
			[1 dents  .8 scale .08 translate 100]
			[1 dents -.8 scale .05 translate 200]
		}
	}
	finish { specular .3 roughness .05 reflection .2 reflect_metallic brilliance 2 }
}

#declare T_Rouille = texture {
	pigment {
		bumps
		turbulence 1
		color_map {
			[0 rgbt 1]
			[.6 rgbt 1]
            [.6 rgb <1,.4,.2>]
			[.9 rgb <.9,.7,.3>]
		}
		scale .3
	}
	normal { bumps normal_map { [0.6 bumps 0] [0.6 bumps .5 scale .02 ] } }
	finish { specular .1 roughness .05 }
}


#declare T_VieuxFer = texture {
	pigment_pattern {
		wrinkles
		warp { turbulence .2 octaves 2 lambda 3 }
		scale .5
		warp { turbulence .2 octaves 2 lambda 3 }
		scale 15
	}
	texture_map {
		[0.5 T_Fer]
		[0.85 T_Rouille]
	}
}


#declare T_Matelas = texture {
	pigment {
		gradient x
		scale 15.01
		color_map {
			[.5 color rgb 1 ]
			[.5 color rgb <.6, .8 ,1> ]
		}
	}
/*	normal {
		quilted .02 control0 1 control1 1
		translate -.8*y
		scale <2, 1000, .5>
		warp { turbulence .2 octaves 2 }
	}*/
}
texture {
	pigment {
		wrinkles
		scale 10
		color_map {
			[0.2 rgbt 1]
			[1.0 rgbt <.4, .25, .1, .4>]
		}
	}
}

#declare PiedLit = union {
	superellipsoid { <1, .2> translate y scale <2, .25, 2> texture {T_VieuxPlastoc} }
	cylinder { .25*y, 45*y, 2 }
	superellipsoid { <1, .5> scale <2.5, .7, 2.5> translate 40*y }
	superellipsoid { <1, .5> scale <2.5, .7, 2.5> translate 45*y }
}


#declare Sommier = union {
	box { <0, 40, -0.4>, <80, 45, 0.4> }
	box { <0, 40, -0.4>, <80, 40.4, 2> }

	box { <0, 40, 180.4>, <80, 45, 179.6> }
	box { <0, 40, 180.4>, <80, 40.4, 178> }

	box { <-0.3, 40, 0>, <0.1, 45, 180> }
	box { <-0.3, 40, 0>, <2, 40.5, 180> }

	box { <80.3, 40, 0>, <79.9, 45, 180> }
	box { <80.3, 40, 0>, <78, 40.5, 180> }
}


#declare Montant = union {
	cylinder { 45*y, 60*y, 1.3 }
	cylinder { 45*y, 60*y, 1.3 translate 80*x }
	intersection {
		torus { 30, 1.3 }
		box { <-31.5, -1.5, 0>, <0, 1.5, 31.5> }
		rotate -x*90
		translate <30, 60, 0>
	}
	intersection {
		torus { 30, 1.3 }
		box { <0, -1.5, 0>, <31.5, 1.5, 31.5> }
		rotate -x*90
		translate <80-30, 60, 0>
	}
	cylinder { <30, 60+30, 0>, <80-30, 60+30, 0>, 1.3 }

    #local tempy = (45+.33*(15+30*sin(acos((30-10)/30)))); 
	cylinder { <10, 45, 0>, <10, 60+30*sin(acos((30-10)/30)), 0>, .55 }
	superellipsoid { <1, .2> scale <1, .5, 1> translate tempy*y +10*x }
	superellipsoid { <1, .2> scale <1, .5, 1> translate (45+.66*(15+30*sin(acos((30-10)/30))))*y +10*x }
	cylinder { <20, 45, 0>, <20, 60+30*sin(acos((30-20)/30)), 0>, .55 }
	superellipsoid { <1, .2> scale <1, .5, 1> translate tempy*y +20*x }
	superellipsoid { <1, .2> scale <1, .5, 1> translate (45+.66*(15+30*sin(acos((30-20)/30))))*y +20*x }
	cylinder { <30, 45, 0>, <30, 90, 0>, .55 }
	superellipsoid { <1, .2> scale <1, .5, 1> translate tempy*y +30*x }
	superellipsoid { <1, .2> scale <1, .5, 1> translate (45+.66*45)*y +30*x }
	cylinder { <40, 45, 0>, <40, 90, 0>, .55 }
	superellipsoid { <1, .2> scale <1, .5, 1> translate tempy*y +40*x }
	superellipsoid { <1, .2> scale <1, .5, 1> translate (45+.66*45)*y +40*x }
	cylinder { <50, 45, 0>, <50, 90, 0>, .55 }
	superellipsoid { <1, .2> scale <1, .5, 1> translate tempy*y +50*x }
	superellipsoid { <1, .2> scale <1, .5, 1> translate (45+.66*45)*y +50*x }
	cylinder { <60, 45, 0>, <60, 60+30*sin(acos((60-50)/30)), 0>, .55 }
	superellipsoid { <1, .2> scale <1, .5, 1> translate tempy*y +60*x }
	superellipsoid { <1, .2> scale <1, .5, 1> translate (45+.66*(15+30*sin(acos((60-50)/30))))*y +60*x }
	cylinder { <70, 45, 0>, <70, 60+30*sin(acos((70-50)/30)), 0>, .55 }
	superellipsoid { <1, .2> scale <1, .5, 1> translate tempy*y +70*x }
	superellipsoid { <1, .2> scale <1, .5, 1> translate (45+.66*(15+30*sin(acos((70-50)/30))))*y +70*x }
}


/*
#declare Matelas = superellipsoid { <.1, .1>
	translate <1,1,1>
	scale <40, 8, 89>
	texture { T_Matelas }
}
*/


#macro Rayon(R, d)

#local A = (R*R/(d*d))+1;
#local B = -2*R*R/(d*d);
#local det = B*B - 4*A;
#local rac = (-B - sqrt(det))/(2*A);
#local gamma = acos(rac);

	abs(R)/sin(gamma)

#end



#declare Matelas = union {
	intersection {
		box { -1, 1 }
		union 
		{
			#local Rc = 1/sin(radians(3));
			#local Dz = Rc*(1-cos(radians(3)));
			box { <-1, -1.01, -(1-Dz)>, <1, 1.01, (1-Dz)> }
			intersection {
				cylinder { -x, x, Rc translate (-Rc+1)*z }
				box {<-1, -1, 0>, 1}
			}
			intersection {
				cylinder { -x, x, Rc translate (Rc-1)*z }
				box {-1, <1, 1, 0>}
			}
		}
		union 
		{
			#local Rc = 1/sin(radians(4));
			#local Dx = Rc*(1-cos(radians(4)));
			box { <-(1-Dx), -1.01, -1>, <(1-Dx), 1.01, 1> }
			intersection {
				cylinder { -1.2*z, 1.2*z, Rc translate (-Rc+1)*x }
				box {<0, -1, -1>, 1}
			}
			intersection {
				cylinder { -1.2*z, 1.2*z, Rc translate (Rc-1)*x }
				box {-1, <0, 1, 1>}
			}
		}
		translate <1,1,1>
		scale <42, 8, 89>
	}
	#local coin1 = (<-(1-Dx), 1, -(1-Dz)> + <1,1,1>)*<42, 8, 89>;
	#local coin2 = (< (1-Dx), 1,  (1-Dz)> + <1,1,1>)*<42, 8, 89>;
	cylinder { <coin1.x, coin1.y, coin1.z>, <coin1.x, coin1.y, coin2.z>, .6 }
	cylinder { <coin1.x, coin1.y, coin1.z>, <coin2.x, coin1.y, coin1.z>, .6 }
	cylinder { <coin1.x, coin1.y, coin2.z>, <coin2.x, coin1.y, coin2.z>, .6 }
	cylinder { <coin2.x, coin1.y, coin1.z>, <coin2.x, coin1.y, coin2.z>, .6 }
	sphere {<coin1.x, coin1.y, coin1.z>, .6}
	sphere {<coin2.x, coin1.y, coin1.z>, .6}
	sphere {<coin1.x, coin1.y, coin2.z>, .6}
	sphere {<coin2.x, coin1.y, coin2.z>, .6}
	translate -x
	texture { T_Matelas }
}

#declare Lit = union {
	object { Sommier }
	object { PiedLit translate <0, 0, 0> }
	object { PiedLit translate <80, 0, 0> }
	object { PiedLit translate <0, 0, 180> }
	object { PiedLit translate <80, 0, 180> }
	object { Montant }
	object { Montant translate <0, 0, 180>}
	object { Matelas translate 40.5*y + z }
	texture { T_VieuxFer }
}


//============================
// SCENE DE TEST
//============================

#if (test_lit_inc)

//===================================
//	LIGHTS
//===================================

light_source { <300, 400, 10> color rgb<1, .95, .85>*2
	spotlight
	radius 10
	falloff 20
	point_at <40, 30, 90>
}

light_source { <-90, 30, -70>, color rgb<.85,.90,1>*.60 shadowless }


//===================================
//	CAMERA
//===================================

camera {
	location <250, 130, -70>
	right x*5
	up y*3
	angle 40
	look_at <40, 50, 90>
}

plane { y, 0
	texture { T_Wood21 scale 250 }
}

plane { -z, 0
	texture { pigment { rgb .75 } }
	translate 185*z
}

plane { x, 0
	texture { pigment { rgb .75 } }
	translate -100*x
}

//fog { fog_type 1 color rgb 0 distance 3000 }

object { Lit }


#macro WriteClothFile(nomfile, n1, n2, nlng, ks)

	#fopen file nomfile write
	#local tempx=0;
	#local tempy=0;
	#local tempz=0;
	#write(file, n1, ",", n2, ",", nlng, ",", ks, ",\n")

	#local l1 = nlng*(n1-1);
	#local l2 = nlng*(n2-1);
	#local h = 12+100*sin(radians(60));
	#local st = seed(1234);
	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#local tempx = -l1/2 + i*nlng;
			#local tempz = -l2/2 + j*nlng;
			#local vtemp = vaxis_rotate(<tempx, 0, tempz>, x, -55);
			#local vtemp = vaxis_rotate(vtemp, z, tempx*.5);
			#local vtemp = vtemp + h*y + 70*z + 40*x;
			#write(file, vtemp.x, ",", vtemp.y, ",", vtemp.z, ", 0.0, 0.0, 0.0\n")
			#local j=j+1;
		#end
		#local i=i+1;
	#end
	#fclose file
#end


#include "clothutil.inc"

//  WriteClothFile(nomfile, n1, n2, nlng, ks)
// WriteClothFile("drap.cth", 80, 100, 200/100, 20)
//              clothsim(Obj, Grav, Wind, firc_air, fric_obj, damp, dt, nbi, file);
// #declare vect = clothsim(Matelas, <0,-.9,0>, <0,0,0>, 0, 0, .90, .05, 1000, "drap.cth", "drap.cth");


#declare n1 = 0;
#declare n2 = 0;

//ReadClothMesh("drap.cth")

//#debug concat("\nn1 = ", str(n1, 4, 0))
//#debug concat("\nn2 = ", str(n2, 4, 0))

#declare Drap = mesh {
//	DrawSmoothTriangles(Points, n1, n2, on, on, "drap_s.msh")
	#include "drap_s.msh"
	uv_mapping
	pigment { checker color rgb<1, .5, .2>, color rgb <1, .8, .4> scale <1/10, 1/8, 1/12>}
}

object { Drap scale <1.05, 1, 1.05> translate 40.5*y + z
	translate 1.5*y-1.5*x
}

#end
