#version unofficial megapov 0.6;

#declare test_oillamp_inc = off;


#declare T_Bronze1 = texture {
	pigment { color rgb <.7, .5, .1> }
	normal { dents scale .3 }
	finish { reflection_min 0 reflection_max .6 specular .7 roughness .005 }
}

#declare T_Bronze2 = texture {
	pigment { color rgb <.6, .3, .1> }
	normal { dents scale .3 }
	finish { reflection_min 0 reflection_max .2 specular .3 roughness .02 }
}

#declare T_Bronze = texture {
	wrinkles
	scale 2
	texture_map {
		[.3 T_Bronze1 scale .5 ]
		[.8 T_Bronze2 scale .5 ]
	}
}

#declare M_OL_Glass = material {
	texture { pigment { color rgbf <1, 1, .95, .97> } finish { specular .3 roughness .01 metallic } }
	interior { ior 1.3 }
}

#declare OL_Body = union {
	intersection {
		torus { 4.5, .5 translate .02*y }
		box { <-5, 0, -5>, <5, .52, 5> }
	}
	torus { 4.5, .2  translate .6*y }
	union {
		sphere { 0, 6 }
		cylinder { -.2*y, .2*y, 6.1 }
		torus { 6*cos(radians(30)), .1 translate 6*sin(radians(30))*y }
		torus { 6*cos(radians(30)), .1 translate -6*sin(radians(30))*y }
		translate 6*cos(asin(4.5/6))*y scale <1, 5/6, 1> translate .7*y
	}
	union {
		torus { 3, .3 }
		difference {
			cylinder { 0*y, 2*y, 3 }
			cylinder { -.1*y, 2.1*y, 2.8 }
			cylinder { y+2.9*x, y+3.1*x, .3 }
		}
		union {
			cylinder { y+2.9*x, y+4*x, .2 }
			cylinder { -y, y, .1 rotate 0*x translate 4*x+y }
			cylinder { -y, y, .1 rotate 60*x translate 4*x+y }
			cylinder { -y, y, .1 rotate -60*x translate 4*x+y }
			torus { 1, .15 rotate z*90 translate 4*x+y }
		}
		torus { 3, .2 translate 2*y }
		union {
			difference {
				cylinder { 0, 4*y, 3 }
				cylinder { 0, 4*y, 2.95 }
				#local i = 0;
				#while (i<8)
					box { <-.25, 1, -3.01>, <.25, 3, 3.01> rotate i*180*y/8 }
					#local i=i+1;
				#end
			}
			cylinder {0, 4*y, 2.9 }
			torus { 3, .1 translate 3.9*y }
			difference {
				sphere { 0, 6.1 scale <1, 5.5/6, 1> }
				sphere { 0, 6.0 scale <1, 5.5/6, 1> }
				box { <-6.2, -3.7, -6.2>, 6.2 }
				#local i = 0;
				#while (i<8)
					box { <-.25, -6, -6.2>, <.25, -3.4, 6.2> rotate z*10 rotate i*180*y/8 }
					box { <-.25, -6, -6.2>, <.25, -3.4, 6.2> rotate -z*10 rotate i*180*y/8 }
					#local i=i+1;
				#end
				translate (4 + 5.5*cos(asin(3/6)))*y
			}
			translate 2*y
		}
		translate (.7 + 5*cos(asin(4.5/6)) + 5*cos(asin(3/6)))*y
	}
	texture { T_Bronze }
}

#declare Ht_OL_Body = .7 + 5*cos(asin(4.5/6)) + 5*cos(asin(3/6)) + 6;

#declare OL_Glass = difference {
	merge {
		sphere { 0, 6 scale <1, 5.5/6, 1> }
		cone { 0, 3, 15*y, 2.7 }
	}
	merge {
		sphere { 0, 5.95 scale <1, 5.5/6, 1> }
		cone { 0, 2.95, 15.01*y, 2.65 }
	}
	translate 5.5*cos(asin(3/6))*y
	material { M_OL_Glass }
	no_shadow
}


#declare OilLamp = union {
	object { OL_Body }
	object { OL_Glass translate Ht_OL_Body*y }
}


#if (test_oillamp_inc)

global_settings { max_trace_level 30 adc_bailout .05 }

camera { location -45*z + 40*y + 40*x angle 40 look_at 15*y }

plane { y, 0 pigment { rgb .9 } }

background { color rgb <.6, .5, .3> }

// light_source { <2, 1, -1>*100 color rgb 1 media_interaction off media_attenuation off }

union {
	object {OilLamp}
	light_source { (Ht_OL_Body+3)*y color rgb <1,1,.8>*1.5
		area_light 5*x, 5*z, 8, 8 orient circular jitter adaptive 2
	}
}

glow {
	location (Ht_OL_Body-1)*y
	size 2
	fade_power 1
	type 0
	color rgb <1,1,.6>*.45
	scale <2, 1.5, 2>
	warp { turbulence .4 }
}

glow {
	location (Ht_OL_Body-1)*y
	size 1
	fade_power 1
	type 0
	color rgb <1,1,.6>*.2
	scale <1, 1.5, 1>
	warp { turbulence .4 }
}


global_settings {
	ini_option "+QR"
	radiosity{
		count 60
		nearest_count 4
		error_bound .1
		recursion_limit 1
		brightness 1.0

		pretrace_start  .1
		pretrace_end  .01

		low_error_factor .5
		gray_threshold 0.2
		minimum_reuse 0.015
		normal on

		max_sample 1
		adc_bailout 0.1
	}
}

//light_source { -30*z + 10*y + 10*x color rgb .5 shadowless }


#end
