// dmave.pov
// IRTC Jan-Feb 2001: Worship

#declare Media = 1;
#declare Atmospheric = 0;
#declare Attenuate = 0;

// starfield
#declare star_scale = 0.5;
#declare star_count = 10000;
#include "Galaxy.sf"
// milky way
#declare galaxy_declare_only = true;
#include "Galaxy.bg"
sky_sphere {
	pigment { BGMilkyWay
		rotate <0,-180,0>
		rotate <0,0,45>
		rotate <0,-10,0>
	}
}

camera {
	location <0,5,0>
	look_at <0,7,10>
}

background { rgb <0,0,0> }

#declare Light = <1.2,1.1,0.8>*0.3;
#declare bulb = sphere { <0,0,0>, 0.02
	texture {
		pigment { rgb <1.2,1.1,0.8> }
		finish { ambient 1 }
	}
}

light_source { <-12,2,20>, rgb Light
	looks_like { bulb }
	#if (Attenuate)
		media_attenuation on
	#end
}
light_source { <-1,3.5,20>, rgb Light
	looks_like { bulb }
	#if (Attenuate)
		media_attenuation on
	#end
}
light_source { <10,5,22>, rgb Light
	looks_like { bulb }
	#if (Attenuate)
		media_attenuation on
	#end
}

// moon
light_source { <-7.5,14,25>, rgb Light/3
	looks_like {
		box { <0,0,0>, <1,1,0.01>
			texture {
				pigment {
					image_map { gif "moon.gif"
						transmit 152, 1
					}
				}
				finish { ambient 0.8 }
			}
			translate <-0.5,-0.5,0>
			scale <1.75,1.75,1>
		}
	}
}

// people
#declare Person = sphere { <0,0,0>, 0.5
	scale <0.5,3.6,0.7>
	texture {
		pigment { rgb <0.4,0.3,0.25> }
	}
}

#declare Seed1 = seed(7322);
#declare NumPeople = 20;
#declare i = 0;
#while (i < NumPeople)
	object { Person
		translate <-15 + i*30/NumPeople + rand(Seed1), (i*i/NumPeople/NumPeople)*4, 21 + (i*i/NumPeople/NumPeople)*10 + rand(Seed1)>
	}
	object { Person
		translate <-14.5 + i*30/NumPeople + rand(Seed1), (i*i/NumPeople/NumPeople)*4, 19 + (i*i/NumPeople/NumPeople)*10 + rand(Seed1)>
	}
	#declare i = i + 1;
#end

#declare Cross = union {
	cylinder { <0,0,0>, <0,1.5,0>, 0.05 }
	cylinder { <-0.5,0.95,0>, <0.5,0.95,0>, 0.05 }
	texture {
		pigment { rgb <1,0.9,0.8> }
		finish {
			reflection 0.4
			metallic
		}
	}
}

object {
	Cross
	scale 2
	rotate <5,2,15>
	translate <-4,2,21>
}

object {
	Cross
	scale 2.5
	rotate <-5,42,10>
	translate <9,5,21>
}

/*
plane { y, 0
	texture {
		pigment { rgb <0.5,1,0.7> }
	}
}
*/

height_field { gif "valley2.gif"
	smooth
	texture {
		pigment { bozo
			pigment_map {
				[0.0 rgb <0.8,1,0.6>]
				[0.2 rgb <0.8,1,0.6>]
				[0.2 rgb <0.5,1,0.7>]
				[0.5 rgb <0.5,1,0.7>]
				[0.9 rgb <0.3,0.8,0.5>]
				[1.0 rgb <0.1,0.5,0.2>]
			}
			scale 0.001
			turbulence 0.8
		}
		normal { granite 0.2
		}
	}
	scale <70,55,70>
	translate <-15,0,18>
}

// tree
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "..\TheLaboratory\tree3.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.2 }
	}
	scale 9
	translate <-3,3,25>
}

// boxed media
#if (Media)
box { <-20,0,17.5>, <20,20,20.5>
	texture {
		pigment { rgbf <1,1,1,1> }
	}
	hollow
	interior {
		media {
			absorption rgb <0.2,0.16,0.0>
			scattering { 2, rgb <1,1,1>*0.35 } // *0.4
			density { crackle
				turbulence 1
				omega 0.4
				scale <10,3,3>
			}
		}
		media {
			absorption rgb <0.2,0.16,0.0>
			scattering { 2, rgb <1,1,1>*0.175 } // *0.2
			density { crackle
				turbulence 1
				omega 0.3
				scale <1.5,1,1>
			}
		}
	}
}
#end

// atmospheric media
#if (Atmospheric)
media {
	absorption rgb <0.1,0.2,0.1>
	scattering { 2, rgb <1,1,1>*1.8 }
	//density { bozo	
	//}
}
#end