
// Persistence of Vision Ray Tracer Scene Description File
// File: banners.inc
// Vers: 3
// Date: 02/28/98
// Auth: Bob Franke
//


#version 3.1;

#include "colors.inc"

/*
global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------

camera
{
  location  <4,15,-50>
  direction 2*z
  right     4/3*x
  look_at   <4, 10,  0.0>}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-25, -15, -50>
}

//plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}


// ----------------------------------------

*/

#declare patch1=
bicubic_patch
{
  type 1 
  flatness 0.1 
  u_steps 3 // # of triangles to subdivide (1-5)
  v_steps 3 // # of triangles to subdivide (1-5)

  <0, 1.00, 0> <.5/3, 1.00, -.25>  <1/3, 1.00, .25> <.5, 1.00, 0>
  <0, .667, 0> <.5/3, .667, -.25>  <1/3, .667, .25> <.5, .667, 0>
  <0, .333, 0> <.5/3, .333, -.25>  <1/3, .333, .25> <.5, .333, 0>
  <0, 0, 0>    <.5/3, 0, -.25>     <1/3, 0, .25>    <.5, 0, 0>
}

#declare bannerRing=
torus{6/12, 1.5/12
  rotate<0,0,90>
  pigment{Brown*.75 }
}


#declare flagStaff=
union{
  merge{
    sphere{<-6/12,20.5,0>, 5/12}
    cylinder{<-6/12,20.5,0>,<8,20.5,0>, 3/12}
    pigment{Brown }
  }
  object{ bannerRing translate<.25,20.25,0>}
  object{ bannerRing translate<1.3,20.25,0>}
  object{ bannerRing translate<2.6,20.25,0>}
  object{ bannerRing translate<3.9,20.25,0>}
  object{ bannerRing translate<4.75,20.25,0>}

}



#declare banner=
union{
  union{
    object{patch1}
    object{patch1 translate<.5,0,0>}
       texture{
        pigment{ image_map{
                    gif "banner.gif"
                    once
                    interpolate 2
                    map_type 0
                 }
        }
    }
    scale<5,20,4>
  }
  flagStaff
}


#declare banner2=
union{
  union{
    object{patch1}
    object{patch1 translate<.5,0,0>}
       texture{
        pigment{ image_map{
                    gif "banner2.gif"
                    once
                    interpolate 2
                    map_type 0
                 }
        }
    }
    scale<5,20,4>
  }
  flagStaff
}



//banner
