// Persistence of Vision Ray Tracer Scene Description File
// File: falsidol.pov
// Vers: 3.1
// Desc: for the IRTC
// Date: 2/27/01
// Auth: Bob Franke
//
              
       
#version 3.1;

#declare useMedia=true;
#declare useMiddleLights=true;
#declare useTopLights=true;
#declare useLwrLights=true;
#declare useVault2Lights=true;
#declare useAisleLights=true;

#include "colors.inc"
#include "finish.inc"
#include "textures.inc"
#include "stones1.inc"
#include "golds.inc"
#include "lamp2.inc" 
#include "banner.inc"


global_settings{
   assumed_gamma 2.2
}


// ----------------------------------------
camera{
   location  <-12, 8, -60>*1.25
   direction 1.5*z
   right     4/3*x
   look_at   <0.0, 17  0.0>
}
     
 #declare centerMediaLight=  
   light_source { <0, 90, 0> colour Blue*4/1.5 + White*.25/1.5
     media_interaction off
     fade_distance 20 fade_power 4 
   }
   
  #declare centerLight= 
      light_source { <0, 85, 0> colour White*.15+Blue*.5 fade_distance 20 fade_power 3}
 
  

#if (useMedia)
   media {
     intervals 15
     scattering { 1, rgb<0.008, 0.008, 0.008>}
     samples 1, 10
     confidence 0.9999
     variance 1/1000
     ratio 0.9
   }
     

   light_source {<-31, 70,-34>  colour rgb<1.3, 1.3, 1.3>*3
     spotlight
     point_at <3,0,4.5>
     radius 6.5-1
     falloff 9
     tightness 10 //10
     media_attenuation off
   }

#else


   light_source { <-30, 70,-34> colour rgb<2,2,2>
     spotlight
     point_at <4,0,8>
     radius 6
     falloff 11
   }
#end


background { color SkyBlue*.2 } 
 
#declare goldTexture= 
texture{
  pigment{rgb<1.00, 0.875, 0.575>}  
  finish{Dull}
}  

#declare NBglass =
texture {
    pigment { rgbf <0.98, 1.0, 0.99, 0.5>*1.6 }
    finish {
        ambient 0.1
        diffuse 0.1
        reflection .25
        ior 1.5
        specular 1
        roughness .001
    }
}

#version 3.1;

#declare NBoldglass=
texture { 
    NBglass
    pigment { rgbf <0.95, 1, 0.95, 0.5>*1.6 }
}


#declare T_Grnt20 =
texture {
pigment
  {granite
   turbulence 0.0
   color_map
    {[0.0, 0.3 color White*.25 color White]
     [0.3, 0.4 color White color White]
     [0.4, 0.6 color White color White]
     [0.6, 1.0 color White color White]
    }
  }
   scale <1, 2, 2> rotate <0, 0, -30>
  finish {
   ambient 0.2
   crand 0.05
  }
}


#declare T_Grnt20r =
texture {
pigment
  {granite
   turbulence 0.0
   color_map
    {[0.0, 0.3 color Salmon*.25 color White]
     [0.3, 0.4 color White color White]
     [0.4, 0.6 color White color White]
     [0.6, 1.0 color White color White]
    }
  }
   scale <1, 2, 2> rotate <0, 0, -30>
  finish {
   ambient 0.2
   crand 0.05
  }
  }

 

#declare T_Stone18 =
texture{pigment{color SeaGreen}finish{ambient 0.3 diffuse 0.6 crand 0.03}}
texture{T_Grnt22 scale <1.5, 0.7, 0.5> rotate <0, 0, 40> }
texture{T_Grnt20a scale <2.5, 2, 0.5> rotate <0, 0, -50> scale 1}
texture{T_Crack4 scale <0.7, 1, 1> rotate <10, 0, -20> finish{phong 1.0 
phong_size 90} scale <1,1,1> } 

#declare dollarTexture =
texture{pigment{color SeaGreen*2}finish{ambient 0.3 diffuse 0.6 crand 0.03}}
texture{T_Grnt22 scale <1.5, 0.7, 0.5> rotate <0, 0, 40> }
texture{T_Grnt20a scale <2.5, 2, 0.5> rotate <0, 0, -50> scale 1}
texture{T_Crack4 scale <0.7, 1, 1> rotate <10, 0, -20> finish{phong 1.0 
phong_size 90} scale <1,1,1> } 


#declare leaf=
union{
  box{<0,0,.6>,<.3,2.5,-.6> }
  difference{
    cylinder{<1,2.5,.6>,<1,2.5,-.6>, .7 }  
    cylinder{<1,2.5,.75>,<1,2.5,-.75>, .4 }  
    box{<.5,-2.5,2>,<3,2.5,-2>} 
  }  
}



#declare railing=
union{
   box{<-16,3,-16>,<-3,3.15,-15>}
   box{<-16,3.15,-15.9>,<-3,3.30,-15.1>}
   box{<-3,3.3,-16+.10>,<-3.8,3.7,-15-.1>}
   box{<-16,3.3,-16+.10>,<-15.2,3.7,-15-.1>}

   box{<-3,3.3,-16+.10>,<-3.8,3.7,-15-.1> translate<-6.1,0,0>}
   box{<-3,3.3,-16+.10>,<-3.8,3.7,-15-.1> translate<-3.05,0,0>}
   box{<-16,3.3,-16+.10>,<-15.2,3.7,-15-.1> translate<3.05,0,0>}

   sphere{<0,0,0> ,1.0 scale<.35,1,.35> translate<-15.6,4.5,-15.5>}
   sphere{<0,0,0> ,1.0 scale<.35,1,.35> translate<-3.4,4.5,-15.5>}
   sphere{<0,0,0> ,1.0 scale<.35,1,.35> translate<-6.45,4.5,-15.5>}
   sphere{<0,0,0> ,1.0 scale<.35,1,.35> translate<-9.5,4.5,-15.5>}
   sphere{<0,0,0> ,1.0 scale<.35,1,.35> translate<-12.55,4.5,-15.5>}

   box{<-3,5.3,-16+.10>,<-3.8,5.7,-15-.1> translate<-6.1,0,0>}
   box{<-3,5.3,-16+.10>,<-3.8,5.7,-15-.1> translate<-3.05,0,0>}
   box{<-16,5.3,-16+.10>,<-15.2,5.7,-15-.1> translate<3.05,0,0>}

   box{<-16,5.3,-16+.10>,<-15.2,5.7,-15-.1>}
   box{<-3,5.3,-16+.10>,<-3.8,5.7,-15-.1>}

   box{<-16,5.85,-16+.1>,<-3,5.7,-15-.1>}
   box{<-16,6,-16>,<-3,6-.15,-15>}
}


#declare railingPair =
union{
   object{railing}
   object{railing translate<19,0,0>}
   texture{
//    T_Grnt20 scale 2 translate<10,15,8>
     T_Stone12 scale 7 finish {ambient 0.2  crand 0.1} translate<10,15,8>
   }
}



#declare steps=
union{
   superellipsoid{
     <0.075,  0.05>
     rotate<0,90,0>
     scale<3,.53,3>
     texture{ T_Stone12 scale 7  finish {ambient 0.2  crand 0.2}
translate<-20,-50,0>}
     translate <0,.5,-18>
   }


   superellipsoid{
     <0.075,  0.05>
     rotate<0,90,0>


     scale<3,.53,3>
     texture{ T_Stone12 scale 7  finish {ambient 0.2  crand 0.2}
translate<-10,-5,0>}
     translate <0,1.48,-16.5>
   }
   superellipsoid{
     <0.05,  0.05>
     rotate<0,90,0>
     texture{ T_Stone12 scale 7  finish {ambient 0.2  crand 0.2}
translate<10,5,0>}
     scale<3,.53,3>
     translate <0,2.465,-15>

   }
}



   #declare stoneCracks =
   pigment {
     marble
     turbulence .5
     color_map {
       [0.0 rgbf <1,1,1,1>]
       [0.985 rgbf <1,1,1,1>]
       [0.985 rgbf <.1,.1,.1,0>]
       [1.0 rgbf <0,0,0,0>]
     }
   }



#declare dollars=
union{
     text { ttf "timrom.ttf" "$" 1, 0  scale<3,2.5,1>translate<-15,.75,-16.125>}
     text { ttf "timrom.ttf" "$" 1, 0  scale<3,2.5,1>translate<-5,.75,-16.125>}
     text { ttf "timrom.ttf" "$" 1, 0  scale<3,2.5,1>translate<-8.333,.75,-16.125>}
     text { ttf "timrom.ttf" "$" 1, 0  scale<3,2.5,1>translate<-11.666,.75, -16.125>}

     text { ttf "timrom.ttf" "$" 1, 0  scale<3,2.5,1>translate<15-1.25,.75, -16.125>}
     text { ttf "timrom.ttf" "$" 1, 0  scale<3,2.5,1>translate<5-1.25,.75, -16.125>}
     text { ttf "timrom.ttf" "$" 1, 0 scale<3,2.5,1>translate<8.333-1.25,.75, -16.125>}
     text { ttf "timrom.ttf" "$" 1, 0 scale<3,2.5,1>translate<11.666-1.25,.75, -16.125>}  
     texture{dollarTexture}
}


#declare T_Grnt16 =
texture {
pigment
  {granite
   turbulence 0.6
   color_map
    {[0.000, 0.316   color rgbf <0.910, 0.788, 0.788, 0.000>
                     color rgbf <0.922, 0.914, 0.871, 0.000>]
     [0.316, 0.453   color rgbf <0.922, 0.914, 0.871, 0.000>
                     color rgbf <0.894, 0.867, 0.780, 0.000>]
     [0.453, 0.624   color rgbf <0.894, 0.867, 0.780, 0.000>
                     color rgbf <0.784, 0.788, 0.788, 0.000>]
     [0.624, 0.726   color rgbf <0.784, 0.788, 0.788, 0.000>
                     color rgbf <0.851, 0.812, 0.741, 0.000>]
     [0.726, 0.863   color rgbf <0.851, 0.812, 0.741, 0.000>
                     color rgbf <0.647, 0.655, 0.655, 0.000>]
     [0.863, 1.001   color rgbf <0.647, 0.655, 0.655, 0.000>
                     color rgbf <0.910, 0.788, 0.788, 0.000>]
    }
  }
  }


#declare goldTile=
union{
   box{<-1,.04985,-1>,<1,-1/12,1> pigment{Black}}
   box{<-1,.05,-1>,<1,-1/12,1> scale<.96,1,.93>
     texture { T_Gold_1A  finish{ambient 0.2}
     normal {bumps 0.025 scale .01}
     }
   }
}


#declare goldPath=
union{
   #declare xx=-3;
   #declare zz= 0;
   #while (zz > -75)
     #while (xx < 4)
       object{goldTile translate<xx,0,zz>}
       #declare xx=xx+2;
     #end
     #declare xx=-3;
     #declare zz=zz-2;
   #end
}





#declare altar =
union{
   union{
     superellipsoid{
       <0.01,  0.005>
       translate<0,1,0>
       scale<16,1.5,16>
       rotate<0,90,0>


     }
     object{dollars}
     object{dollars rotate<0,90,0>}
     object{dollars rotate<0,180,0>}
     object{dollars rotate<0,-90,0>}



     texture{
        T_Stone12 scale 7  finish {ambient 0.6  crand 0.1 }
     }
   }


   box{<-15.9,3,-15.9>,<15.9,3.01,15.9>
     texture{
       T_Stone12 scale 40  finish {ambient 0.4  crand 0.1} rotate<90,0,0>  }
     }
   }

   object{steps}
   object{steps rotate<0,90,0>}
   object{steps rotate<0,180,0>}
   object{steps rotate<0,-90,0>}

   object{railingPair}
   object{railingPair rotate<0,90,0>}
   object{railingPair rotate<0,180,0>}
   object{railingPair rotate<0,-90,0>}


   union{
     difference{
       box{<-7,3,-4>,<7,8,4> }
       box{<-6,4,-3.75>,<-.5,7,-5> }
       box{<6,4,-3.75>,<.5,7,-5> }
       texture{T_Stone18  scale 3  finish{ ambient 0.2 crand 0.05}  }
     }
     box{<-7.5,8,-4.5>,<7.5,8.25,4.5> 
       texture{T_Stone18  scale 3  
       finish {ambient 0.2 crand 0.05} translate<-5,10,0>} 
     }   
       
     box{<-7.75,8.25,-4.75>,<7.75,8.5,4.75> texture{T_Stone18  scale 3
        finish { ambient 0.2 crand 0.05} translate<5,-10,0>}
     }

   text { ttf "timrom.ttf" ".COM" 1, 0
     scale<5,5,2>*1.2 translate<-7.75,8.6, 0>
     texture{T_Gold_1A  scale 6  finish{ ambient 0.3 }}
     normal {bumps 0.1 scale .1}
   } 

   text { ttf "timrom.ttf" "." 1, 0
     scale<10,10,2.05>*1.2 translate<-7.75,8.6, 0>
     texture{T_Gold_1A scale 6  finish{ ambient 0.3 }}
     normal {bumps 0.1 scale .1}
   }
}


object{altar rotate<0,0,0>}




#declare R1 = seed(345);
#declare xdim = -40;
#declare zdim = 245;
#declare xstep = 1;
#while(zdim > -70)
   #while(xdim < 80)
     box{<-1,0,-1>,<1,-.25,1>
       texture{T_Grnt20 scale .75
         finish{ambient 0.1}
         translate<rand(R1)*100,rand(R1)*100,rand(R1)*100> rotate<0,rand(R1)*360,0>
       }
       translate<xdim+xstep,0,zdim>
     }
     #declare xdim = xdim+4;
   #end
   #declare xstep=xstep*-1;
   #declare xdim = -50;
   #declare zdim=zdim-2;
#end


#declare xdim = -42;
#declare zdim = 245;
#declare xstep = 1;
#while(zdim > -70)
   #while(xdim < 82)
      box{<-1,0,-1>,<1,-.25,1>
        texture{T_Stone18 scale 1.5
          finish{ambient 0.1}
          translate<rand(R1)*100,rand(R1)*100,rand(R1)*100> rotate<0,rand(R1)*360,0>
        }
        translate<xdim+xstep,0,zdim>
      }
      #declare xdim = xdim+4;
   #end
   #declare xstep=xstep*-1;
   #declare xdim = -52;
   #declare zdim=zdim-2;
#end


object{goldPath}
object{goldPath rotate<0,90,0>}
object{goldPath rotate<0,180,0>}
object{goldPath rotate<0,-90,0>}




#declare graniteMult=0.9
#declare granite1 =
texture {
pigment
  {granite
   turbulence 0.6
   color_map
    {[0.000, 0.154   color rgb <0.800, 0.651, 0.557>*graniteMult
                     color rgb <0.996, 0.835, 0.737>*graniteMult]
     [0.154, 0.308   color rgb <0.996, 0.835, 0.737>*graniteMult
                     color rgb <0.800, 0.651, 0.557>*graniteMult]
     [0.308, 0.444   color rgb <0.800, 0.651, 0.557>*graniteMult
                     color rgb <0.694, 0.624, 0.604>*graniteMult]
     [0.444, 0.615   color rgb <0.694, 0.624, 0.604>*graniteMult
                     color rgb <0.800, 0.651, 0.557>*graniteMult]
     [0.615, 0.812   color rgb <0.800, 0.651, 0.557>*graniteMult
                     color rgb <0.725, 0.655, 0.651>*graniteMult]
     [0.812, 1.001   color rgb <0.725, 0.655, 0.651>*graniteMult
                     color rgb <0.800, 0.651, 0.557>*graniteMult]
    }
  }
  finish{ambient 0.2 crand .05}
  }


#declare granite1 = texture {
  pigment {
    granite
    turbulence 0.70
    color_map {
      [0.00 color rgb <0.86, 0.82, 0.67>]
      [0.50 color rgb <0.91, 0.87, 0.71>]
      [1.00 color rgb <0.86, 0.84, 0.59>]
    }
  }
/*normal {
    bumps 0.10
    scale <0.20, 0.20, 0.20>/20
  }*/ 
  finish{crand 0.15}                                  
}

#declare granite2Mult=0.75
#declare granite2 =
texture {
pigment
  {granite
   turbulence 0.6
   color_map
    {[0.000, 0.154   color rgb <0.800, 0.651, 0.557>*granite2Mult
                     color rgb <0.996, 0.835, 0.737>*granite2Mult]
     [0.154, 0.308   color rgb <0.996, 0.835, 0.737>*granite2Mult
                     color rgb <0.800, 0.651, 0.557>*granite2Mult]
     [0.308, 0.444   color rgb <0.800, 0.651, 0.557>*granite2Mult
                     color rgb <0.694, 0.624, 0.604>*granite2Mult]
     [0.444, 0.615   color rgb <0.694, 0.624, 0.604>*granite2Mult
                     color rgb <0.800, 0.651, 0.557>*granite2Mult]
     [0.615, 0.812   color rgb <0.800, 0.651, 0.557>*granite2Mult
                     color rgb <0.725, 0.655, 0.651>*granite2Mult]
     [0.812, 1.001   color rgb <0.725, 0.655, 0.651>*granite2Mult
                     color rgb <0.800, 0.651, 0.557>*granite2Mult]
    }
  }
  finish{ambient 0.2 crand .2}
  }                
  
  #declare granite2 = texture{granite1}





// ----------------------------------------
#declare rib_1 =
object{
   torus { 34.64, 1.0-.25 rotate<90,0,0>}
   clipped_by{plane{y,0 inverse}}
   texture{granite2 scale .1}
}


#declare rib_2=
object{
   torus { 29.728, 1-.25 rotate<90,0,0>}
   clipped_by{plane{y,0 inverse}}
   texture{granite2 scale .1}
}


#declare rib_3=
object{
   torus { 17.163, 1-.25 rotate<90,90,0>}
   translate<0,1,0>
   clipped_by{plane{y,0 inverse}}
   texture{granite2 scale .1}
}


#declare dome=
  difference{
    sphere{<0,0,0>, 35.64-.25}
    sphere{<0,0,0>, 35.6-.25}
    cylinder{<0,-0,-50>,<0,-0,50>,30.52+.05 }
    cylinder{<-50,1,0>,<50,1,0>,17.56+.25 }
    box{<-50,0,-50>,<50,-50,50> }
    box{<-50,50,-18.41>,<50,-50,-50>}
    box{<-50,50,18.41>,<50,-50,50>}
    texture{granite1}
 }

#declare vaultSection=
union{
   object{dome}
   object{rib_1 rotate<0,30,0>}
   object{rib_1 rotate<0,-30,0>}
   object{rib_2 translate<0,0,17.91392>}
   object{rib_3 translate<-29.728,0,0>}
   object{rib_3 translate<29.728,0,0>} 
}

#declare vaultSection2= 
union{ 
  difference{
     union{
       object{dome}
       object{rib_1 rotate<0,30,0>}
       object{rib_1 rotate<0,-30,0>}
       object{rib_2 translate<0,0,17.91392>}
       object{rib_3 translate<-29.728,0,0>}
       object{rib_3 translate<29.728,0,0>} 
     }
     box{<-50,-10,50>,<3.5,15,-50>}  
     scale .6
  }    
  #if (useVault2Lights)
    #if (useMedia)
      light_source { <0, -5, 0> colour White*1.7/1.7 + Red*.5/1.75 fade_distance 20 fade_power 3 media_interaction off media_attenuation off}  
    #else  
      light_source { <0, -5, 0> colour White*.4 + Red*.1 fade_distance 20 fade_power 3 }  
    #end   
  #end  

}  
  

#declare backColumn=
union{
  #declare yy=0;
  #while (yy<180+30)
    cylinder{<3,0,0>,<3,20,0>,1 rotate<0,yy,0>}
    #declare yy=yy+30;
  #end
  texture{granite1}
}


#declare column=
difference{
   union{
     #declare yy=0;
     #while (yy<360)
       cylinder{<3,0,0>,<3,20,0>,1 rotate<0,yy,0>}
       cylinder{<3,0,0>,<3,1,0>,3.5 rotate<0,yy,0>}
       cylinder{<3,0,0>,<3,2,0>,2 rotate<0,yy,0>}
       cone{<3,2,0>,2.0 <3,3,0>, 1.0 rotate<0,yy,0>}
       cylinder{<3,19.25,0>,<3,20,0>,2.0 rotate<0,yy,0>}
       cylinder{<3,19.25,0>,<3,18.5,0>,1.5 rotate<0,yy,0>}
       cylinder{<3,18.5,0>,<3,17.75,0>,2.0 rotate<0,yy,0>}  
       object{leaf translate<4.6,17.125,0>   rotate<0,yy,0>}
       object{leaf rotate<0,0,-17> translate<4.0,16.5,0>   rotate<0,yy+15,0>}
       #declare yy=yy+30;
     #end
   }
   box{<-5,-10,0>,<5,40,8>}
   texture{granite1}
}


#declare arch1=
merge{ 
   difference{ 
     torus { 25, 1 rotate<0,0,90> translate<0,20,10.0861>}   
     box{<-5,20,40>,<5,-20,-27>}
     box{<-5,50,40>,<5,-20,0>}   
   } 
   #declare xx=0
   union{
     #while (xx < 70)  
       sphere{<0,0,24.2>, .4 scale<1,1.5,1> rotate<xx*-1,0,0> }  
       #declare xx=xx+3;
     #end  
     translate<0,20,-10.0861>
     texture{T_Gold_1A  finish{ ambient 0.3 crand .05}}
   }    

   difference{
     torus { 25, 1 rotate<0,0,90> translate<0,20,-10.0861>}
     box{<-5,20,-40>,<5,-20,27>}
     box{<-5,50,-40>,<5,-20,0>}
   }
   texture{granite1}
}


#declare arch2=
merge{
   difference{
     torus { 25.4019, 1 rotate<0,0,90> translate<-1.5,20,10.0861>}
     box{<-5,20,40>,<5,-20,-27>}
     box{<-5,50,40>,<5,-20,0>}
   }                    
   union{
     #declare xx=0
     union{
       #while (xx < 70)  
         sphere{<0,0,24.4019+.2>, .4 scale<1,1.5,1> rotate<xx*-1,0,0> }  
         #declare xx=xx+3;
       #end  
       translate<-1.5,20,-10.0861>
     }    
     #declare xx=0
     union{
       #while (xx < 67)  
         sphere{<0,0,-24.4019-.2>, .4 scale<1,1.5,1> rotate<xx,0,0>}  
         #declare xx=xx+3;
       #end  
       translate<-1.5,20,10.0861>
     }  
     texture{T_Gold_1A  finish{ ambient 0.3 crand .05}}
   } 
   
   
   difference{
     torus { 25.4019, 1 rotate<0,0,90> translate<-1.5,20,-10.0861>}
     box{<-5,20,-40>,<5,-20,27>}
     box{<-5,50,-40>,<5,-20,0>}
   }
    texture{granite1}
}


#declare arch3=
merge{
   difference{
     torus { 26.5, 1 rotate<0,0,90> translate<-2.5981,20,10.0861>}
     box{<-5,20,40>,<5,-20,-27>}
     box{<-5,50,40>,<5,-20,0>}
   }   
   
   union{                        
     #declare xx=0;
     union{
       #while (xx < 70)  
         sphere{<0,0,25.5+.2>, .4 scale<1,1.5,1> rotate<xx*-1,0,0> }  
         #declare xx=xx+3;
       #end  
       translate<-2.5981,20,-10.0861>
     }
   
     #declare xx=0;
     union{
       #while (xx < 67)  
         sphere{<0,0,-25.5-.2>, .4 scale<1,1.5,1> rotate<xx,0,0> }  
         #declare xx=xx+3;
       #end  
       translate<-2.5981,20,10.0861>
     } 
    texture{T_Gold_1A  finish{ ambient 0.3 crand .05}}
   }  

   difference{
     torus { 26.5, 1 rotate<0,0,90> translate<-2.5981,20,-10.0861>}
     box{<-5,20,-40>,<5,-20,27>}
     box{<-5,50,-40>,<5,-20,0>}
   }
    texture{granite1}
}
#declare arch4=
merge{
   difference{
     torus { 28, 1 rotate<0,0,90> translate<-3,20,10.0861>}
     box{<-5,20,40>,<5,-20,-27>}
     box{<-5,50,40>,<5,-20,0>}
   }   
   union{
     #declare xx=0;
     union{
       #while (xx < 70)  
         sphere{<-.4,0,27+.2>, .4 scale<1,1.5,1> rotate<xx*-1,0,0>}  
         #declare xx=xx+3;
       #end  
       translate<-3,20,-10.0861>
     }    
     #declare xx=0;
     union{
       #while (xx < 67)  
         sphere{<-.4,0,-27-.2>, .4 scale<1,1.5,1> rotate<xx,0,0> }  
         #declare xx=xx+3;
       #end  
       translate<-3,20,10.0861>
     }   
     texture{T_Gold_1A  finish{ ambient 0.3 crand .05}}
   }  
   difference{
     torus { 28, 1 rotate<0,0,90> translate<-3,20,-10.0861>}
     box{<-5,20,-40>,<5,-20,27>}
     box{<-5,50,-40>,<5,-20,0>}
   }
    texture{granite1}
}
  

  
#declare topArch= 
union{

  #if (useTopLights)
    #if (useMedia)
      light_source { <0, 70, 0> colour White*2/1.5 fade_distance 20 fade_power 3  media_interaction off media_attenuation off}
    #else  
      light_source { <0, 70, 0> colour White*.5 fade_distance 20 fade_power 4   }
    #end  
  #end                                                                        
 
  difference{
    box{<3.5,58,17.91392>,<-3.5,90,-17.91392> texture{brick texture{pigment{color rgb <0.86, 0.84, 0.59>*.7}}, texture{granite1} scale .5} }
    cylinder{<-20,70,0>,<2.25,70,0>,7 texture{granite1}} 
    box{<-20,58,7>,<2.25,70,-7> texture{granite1}}
    cylinder{<-20,70,0>,<20,70,0>,5 texture{granite1}} 
    box{<-20,58,-5>,<20,70,5> texture{granite1}}

  }  
}
   
#declare middleArch=
union{
   cylinder{<-3,48.6-52.5,0>,<-3,0,0>,.625  }
   cylinder{<-3,48.6-52.5,-8>,<-3,0,-8>,.625  } 


   difference{
     cylinder{<-3.7,0,-4>,<-2.7,0,-4>,4.125}
     cylinder{<-3.9,0,-4>,<0,0,-4>,3.250}
     box{<-4,0,1>,<0,45-52.5,-10>}
     #declare rr=-15;
     #while(rr>-180)
       box{<-3.55,0,0>,<-4,2/12,5> rotate<rr,0,0> translate<0,0,-4>}
       box{<-4,0,0>,<0,3/12,3.35> rotate<rr,0,0> translate<0,0,-4>}
       #declare rr=rr-15;
     #end
   } 
   translate<0,52.5,0>
}

#declare wallSection=
union{  

  #if (useMiddleLights)
    #if (useMedia)
      light_source { <1, 56, 0> colour White*4/1.5 fade_distance 16 fade_power 4  media_interaction off media_attenuation off}
    #else  
      light_source { <1, 56, 0> colour White*.5 fade_distance 16 fade_power 4   }
    #end      
  #end  
  
  #if (useLwrLights)
    object{lightFixture  rotate<0,180,0> translate<(-36.75/12)-3.5,28,-17.91392>}
  #end
  
  object{topArch} 
  merge{
    cylinder{<-3.5,58,-17.91392>,<-3.5,58,17.91392>,.6 }
    difference{
      cylinder{<-3.5,48,-17.91392>,<-3.5,48,17.91392>,.6 }
      #declare zz=-18;
      #while (zz < 18)
        box{<-5,46,-.1+zz>,<-3.9,50,.1+zz> }
        #declare zz=zz+.75;
      #end
    }
    cylinder{<-3.5-.5,37,-17.91392-.6>,<-3.5-.5,60,-17.91392-.6>,.6 }
    cylinder{<-3.5-.5,37,-17.91392+.6>,<-3.5-.5,60,-17.91392+.6>,.6 }
    cylinder{<-3.5-1.0,37,-17.91392>,<-3.5-1.0,60,-17.91392>,.4 }


    cone{<-3.5,30,17.91392>,.001 <-3.5,37,17.91392-.75>,.65 }
    cone{<-3.5,30,17.91392>,.001 <-3.5,37,17.91392+.75>,.65 }
    cone{<-3.5,30,17.91392>,.001 <-3.5-1.15,37.05,17.913920>,.65 }
    cylinder{<-3.50,36.9,-17.91392>,<-3.50,37.5,-17.91392>,2.25 }
    cylinder{<-3.50,60,-17.91392>,<-3.50,59.25,-17.91392>,2.25 }


    object{middleArch }
    object{middleArch translate<0,0,8>}
    object{middleArch translate<0,0,16>}
    object{middleArch translate<0,0,-8>}


    difference{
      box{<3.5,20,17.91392>,<-3.5,48,-17.91392>  }
      difference{
        cylinder{<5,0,0>,<-5,0,0>,29 translate<0,20,10.0861>}
        box{<8,0,20>,<-8,60,.001>}
      }
      difference{
        cylinder{<5,0,0>,<-5,0,0>,29 translate<0,20,-10.0861>}
        box{<8,0,-20>,<-8,60,-.1001>}
      }                                         
      texture{brick texture{pigment{color rgb <0.86, 0.84, 0.59>*.7}}, texture{granite1} scale .5}
    }  


    difference{
      box{<3.5,48,17.91392>,<-3.5,58,-17.91392>}
      box{<0,52.5,16>,<-10,48.6,-16>}
      box{<2.625,48.5,17.91392+3>,<-3,57.5,-17.91392-3>}
      cylinder{<0,52.5,-4>,<-10,52.5,-4>,4.0}
      cylinder{<0,52.5,-12>,<-10,52.5,-12>,4.0}
      cylinder{<0,52.5,12>,<-10,52.5,12>,4.0}
      cylinder{<0,52.5,4>,<-10,52.5,4>,4.0} 
    }
    texture{granite1}  
  } 
}


box{<-40,58,240+70>,<40,90,241+70> texture{granite1}}

#declare arch=
union{
     object{wallSection }
     object{column translate<0,0,17.91392> }
     object{column rotate<0,180,0> translate<0,0,-17.91392> }
     object{arch1}
     object{arch2}
     object{arch3}
     object{arch4}

     object{arch2 translate<3,0,0>}
     object{arch3 translate<2.5981*2,0,0>}
     object{arch4 translate<6,0,0>}
}

#declare aisleSection=
union{    
  difference{
    cylinder{<-3.6,33,0>,<2.5,33,0>, 9}
    cylinder{<-4,33,0>,<4,33,0>, 7}
    box{<-4,33,10>,<4,0,-10>}         
    #declare xx=15; 
    #while (xx<180)
       box{<-3.5,+.15,0>,<-5,-.15,-10> rotate<xx,0,0> translate<0,33,0>}
       #declare xx=xx+15;
    #end
     texture{granite1 }
  } 
 
  difference{ 
    box{<-3.5,0,-10.7484>,<2.5,50,10.7484>  }    
    cylinder{<-4,33,0>,<4,33,0>, 7 texture{granite1}}
    box{<-4,33,-7>,<4,15,7> texture{granite1}}
    texture{brick texture{pigment{color rgb <0.86, 0.84, 0.59>*.7}}, texture{granite1} scale .5}
  }  
                                    
  difference{                                  
    cylinder{<-.5-.51,31,3.33>,<.5-.51,31,3.33>, 3.67} 
    cylinder{<-1-.51,31,3.33>,<1-.51,31,3.33>, 2.67 } 
    box{<-2-.51,31,10>,<2-.51,20,-5> } 
    texture{granite1}
  }
  difference{                                  
    cylinder{<-.5-.51,31,-3.33>,<.5-.51,31,-3.33>, 3.67} 
    cylinder{<-1-.51,31,-3.33>,<1-.51,31,-3.33>, 2.67 } 
    box{<-2-.51,31,-10>,<2-.51,20,5> } 
    texture{granite1}
  } 
  box{<-.5-.51,15,-7>,<.5-.51,31,-6> texture{granite1}}
  box{<-.5-.51,15,7>,<.5-.51,31,6> texture{granite1}}
  box{<-.5-.51,15,.5>,<.5-.51,31,-.5> texture{granite1}}  
      
  difference{    
    cylinder{<-.5-.51,36.5,0>,<.5-.51,36.5,0>, 3.8 } 
    cylinder{<-.8-.51,1.6,0>,<.8-.51,1.6,0>, 1.3 translate<0,36.5,0>} 
    cylinder{<-.8-.51,1.6,0>,<.8-.51,1.6,0>, 1.3 rotate<120,0,0> translate<0,36.5,0>} 
    cylinder{<-.8-.51,1.6,0>,<.8-.51,1.6,0>, 1.3 rotate<240,0,0> translate<0,36.5,0>} 
    texture{granite1}
  }
  box{<-5,13,-10.7484>,<3.5,15,10.7484> texture{granite1}}    
  box{<-3.55,15,-10.7484>,<3.5,14,10.7484> texture{granite1}}    
 
  cylinder{<-3.75,15,-10.7484-.5>,<-3.75,33,-10.7484-.5>, .5 texture{granite1} } 
  cylinder{<-3.75,15,-10.7484+.5>,<-3.75,33,-10.7484+.5>, .5 texture{granite1}} 
  cylinder{<-4.5,15,-10.7484>,<-4.5,33,-10.7484>, .5  texture{granite1}} 
  cylinder{<-3.5,32.25,-10.7484>,<-3.5,33,-10.7484>, 2 texture{granite1}} 
   
  box{<-.50,40,-8>,<-.52,13,8> texture{NBoldglass}}  
}


//union{
#declare xx=-1;
#while (xx< 10)
  object{vaultSection scale<1.04,1,1> translate<0,60,35.82784*xx>}
  object{arch translate<35,0,35.82784*xx>}
  object{arch rotate<0,180,0>translate<-35,0,35.82784*xx>} 
  object{banner2 translate<35-3.5-8,25,35.82784*xx>}
  object{banner rotate<0,180,0> translate<-35+3.5+8,25,35.82784*xx>}
  #if (useMedia)
    object{centerMediaLight translate<0,0,35.82784*xx>}
  #else 
    object{centerLight translate<0,0,35.82784*xx>}
  #end 
  

    #if (useMedia)
      light_source { <0, 60,(35.82784*xx) > colour White*.25/1.5  fade_distance 25 fade_power 3 media_interaction off}  
    #else  
      light_source { <0, 60, (35.82784*xx)> colour White*.15  fade_distance 25 fade_power 3 }  
    #end     
  #declare xx=xx+1;
#end  


union{
      difference{
      box{<3.5,48,17.91392+18>,<-3.5,58,-17.91392-18>}
      box{<0,52.5,16+8+8>,<-10,48.6,-16-8-8>}
      box{<2.625,48.5,17.91392+23>,<-3,57.5,-17.91392-23>}
      cylinder{<0,52.5,-4>,<-10,52.5,-4>,4.0}
      cylinder{<0,52.5,-12>,<-10,52.5,-12>,4.0} 
      cylinder{<0,52.5,-20>,<-10,52.5,-20>,4.0} 
      cylinder{<0,52.5,-28>,<-10,52.5,-28>,4.0} 
      
      
      
      
      cylinder{<0,52.5,28>,<-10,52.5,28>,4.0}
      cylinder{<0,52.5,20>,<-10,52.5,20>,4.0}
      cylinder{<0,52.5,12>,<-10,52.5,12>,4.0}
      cylinder{<0,52.5,4>,<-10,52.5,4>,4.0} 
    }  

    object{middleArch }
    object{middleArch translate<0,0,8>}
    object{middleArch translate<0,0,-8>} 
    object{middleArch translate<0,0,16>}
    object{middleArch translate<0,0,-16>}
    object{middleArch translate<0,0,-24>}
    object{middleArch translate<0,0,24>}
    rotate<0,-90,0> 
    scale<.95,1,1>
    translate<0,0,241+70>
       texture{granite1} 
}


#include "backwall.inc"   
object{TheBackWall}

  union{
    difference{
      box{<3.5,0,40>,<-3.5,48,-40>  }
      difference{
        cylinder{<5,0,0>,<-5,0,0>,29 translate<0,20,10.0861>}
        box{<8,0,200>,<-8,70,.001>}
      }
      difference{
        cylinder{<5,0,0>,<-5,0,0>,29 translate<0,20,-10.0861>}
        box{<8,0,-200>,<-8,60,-.1001>}
      }  
      box{<5,0,17.91392>,<-5,20,-17.91392>}                                                                               
      texture{brick texture{pigment{color rgb <0.86, 0.84, 0.59>*.7}}, texture{granite1} scale .5}
      scale<1/1.5,1,1>
    } 
       
     cylinder{<-3.5,58,-40>,<-3.5,58,40>,.6 }
  
     object{backColumn translate<0,0,17.91392> }
     object{backColumn rotate<0,180,0> translate<0,0,-17.91392> }

      
     object{arch1}
     object{arch2}
     object{arch3}
     object{arch4}

     object{arch2 translate<3,0,0>}
     object{arch3 translate<2.5981*2,0,0>}
     object{arch4 translate<6,0,0>}

      rotate<0,-90,0>
      translate<0,0,240+70+3.5>
      scale<1.25,1,1>
    }

                                                                   

#declare xx=-2;
#while (xx< 16)  
  object{aisleSection  translate<38.5+15.239+15.239+7,0,35.82784*xx*.6>} 
  object{vaultSection2  translate<38.5+15.239,33,35.82784*xx*.6>}
   
  object{aisleSection  translate<38.5+15.239+15.239+7,0,0> rotate<0,180,0> translate<0,0,35.82784*xx*.6>} 
  object{vaultSection2 translate<38.5+15.239,33,0> rotate<0,180,0> translate<0,0,35.82784*xx*.6>} 
  #declare xx=xx+1;
#end     

#declare xx=-32   
#while(xx<32)   
  #if (useMiddleLights)
    #if (useMedia)    

      light_source { <xx,56,311> colour White*4/1.5 fade_distance 16 fade_power 4  media_interaction off media_attenuation off}
    #else  
      light_source { <xx,56,311> colour White*.5 fade_distance 16 fade_power 4   }
    #end      
  #end       
  #declare xx=xx+16
#end 

#include "F:\pov3.1\worship\man6.inc"
object{man translate<0,0.336740,0> rotate<0,10,0> scale 16.5 translate<0,3,-10>}   
     
light_source { <0, 40, -48> colour White*.75 fade_distance 40 media_interaction off fade_power 2 shadowless   }
light_source { <0, 40, -48> colour White*.75 fade_distance 40  media_interaction off fade_power 2}  



  





