//  Persistence of Vision Raytracer V3.1
//  World definition file.
//  Made by Txemi Jendrix inspiriens
//  Webpage: http://home.dencity.com/tji
//  e-mail: tji@euskalnet.net  
//
//  Contains 3 lights, 16 materials and 33 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 02/18/2001    (18.02.2001)
//



global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

fog {
  fog_type 2    // Ground Fog
  distance     300000.0
  color <0.333333,0.015686,0.335294,0.0,0.0>
  up           <0,0,1>
  fog_offset   0.0
  fog_alt     5000.0 
}

#include "camaras.inc"
camera {camera01}

//
// *******  L I G H T S *******
//
    
light_source {   // Spotlight Spotlight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    20.615  // outer radius (in deg)
    radius     1.238  // inner radius
    tightness  0.000
  fade_distance  150.0
  fade_power 2.0
  translate  <0.0, -5.46252, 228.70533>
}
    

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.9999
  fade_distance  175.0
  fade_power 2.0
  translate  <-3.559206, -215.534229, 36.610388>
}


//
// ********  MATERIALS  *******
//

#include "godsaiIRTC.inc"

//
// ********  OBJECTS  *******
//                 

/////////////  Los orantes // The prayers

#include "worshipman02.inc"

#declare Radius = 78.00;

#declare Nr = 0;      // start
#declare EndNr = 26;  // end
#while (Nr< EndNr) 
 object{def_object 
        translate<Radius,0,0> 
         rotate<0,0,Nr* 360/EndNr>} 
 #declare Nr = Nr + 1;  // next Nr_minor
#end // --------------- end of loop1 --------- 

#declare Radius1 = 120.00;

#declare Nr1 = 0;      // start
#declare EndNr1 = 39;  // end
#while (Nr1< EndNr1) 
 object{def_object 
        translate<Radius1,0,0> 
         rotate<0,0,Nr1* 360/EndNr1>} 
 #declare Nr1 = Nr1 + 1;  // next Nr_minor
#end // --------------- end of loop2 --------- 

#declare Radius2 = 190.00;

#declare Nr2 = 0;      // start
#declare EndNr2 = 30;  // end
#while (Nr2< EndNr2) 
 object{def_object 
        translate<Radius2,0,0> 
         rotate<0,0,Nr2* 360/EndNr2>} 
 #declare Nr2 = Nr2 + 1;  // next Nr_minor
#end // --------------- end of loop3 --------- 

#declare Radius3 = 230.00;

#declare Nr3 = 0;      // start
#declare EndNr3 = 40;  // end
#while (Nr3< EndNr3) 
 object{def_object 
        translate<Radius3,0,0> 
         rotate<0,0,Nr3* 360/EndNr3>} 
 #declare Nr3 = Nr3 + 1;  // next Nr_minor
#end // --------------- end of loop4 --------- 
  
 

///////////// La piramide // The pyramid  
 

#include "piramid.inc"
object {piramide}

//////////// El ojo de Dios // The eye  of God
 
#include "godsai.inc"
union { // ojodios
  object { ceja }
  object { ninia }
  object { pestanias }
  object { blanco }
  object { triangulo }
  sphere { // lagrima
    <0,0,0>,1
    material {
      lagrima_txt
    }
    scale 0.0075
    translate  <0.049369, -0.057996, 0.067311>
  }
  // All transformations fixed
  scale 23.0
  translate  46.489945*z
}
 

///////////// El suelo // The ground

plane { 
  z,0
  material {
    suelo_txt
  }
}
 
//////////// El resplandor del ojo de Dios // The glow in the eye of God

#declare camera_angle = 30.075000;
#declare camera_sky =  <0.000000, 0.000000, 1.000000>;
#declare camera_location = <9.26757, -190.659, 7.40717>;
#declare camera_look_at = <22.3916, -3.88911, 29.1786>;
#declare effect_location = <0.000, 4.476, 48.894>;
#declare effect_scale = <1.000, 1.000, 1.000>;
#declare effect_rotate = <0.000, 0.000, 0.000>;
#declare effect_brightness = 2.000;
#declare effect_intensity = 1.000000;
#declare effect_type = "Diamond"
#declare effect_colour = <255, 255, 0>;
#declare source_colour = <1.000000, 1.000000, 0.501961>;
#declare effect_always_on_top = 0;
#declare options_only= true;
#include "Lens.inc"  

#declare spots_type = 2;
#include "LnsEfcts.inc" 
                
                  
/////////    F I N    //  T H E   E N D