#version unofficial MegaPov 0.5;
  
#local UseRadiosity = 1;	// 1 - with radiosity, 0 - w/o radiosity
#local FastRadiosity = 0;	// 1 - fast, 0 - high quality
#local ViewType = 2;		// 0 - front, 1 - top view, 2 - angle view 
  
camera {
	#switch(ViewType)
	#case(0)
		location <0, 1, -4> 
		look_at  <0, 1, 0>
		#break
	#case(1)
		location <0, 2, 0>
		look_at  <0, 0, 0>       
		#break
	#case(2)             
		location <-2.5, 7, -4>
		look_at  <-0, 0, -0.5>
	#end
} 
          
#if(UseRadiosity)
	global_settings{
		ini_option "+QR"
    	radiosity{
        	pretrace_start 0.16
        	pretrace_end   0.01 
        	#if(FastRadiosity)
        		count 30
        	#else
				count 300
        	#end
        	nearest_count 4      
        	error_bound 0.04      
        	recursion_limit 1    
        	low_error_factor 1  
        	gray_threshold 0.5  
        	minimum_reuse 0.015 
        	brightness 1.2      
        	adc_bailout 0.005  
    	}
	}   
	sky_sphere{pigment{color rgb 1}} 
	light_source {<0, 8, -14> color rgb 0.4} 
#else
	light_source {<0, 8, -14> color rgb 1.5}
#end  

#include "bfly.inc"
 
object{Butterfly rotate -y*90 translate <-3.5, 0, 1.1> no_shadow} 
object{Butterfly rotate -y*90 translate <-3.5, 0, -1.1> no_shadow}
 
object{Butterfly rotate -y*90 translate <6, 0, 1.1> no_shadow} 
object{Butterfly rotate -y*90 translate <6, 0, -1.1> no_shadow}

#include "spider.inc"
object{Spider translate x*0.5 no_shadow}  

#include "ants.inc"
 
object{Ant translate<-4.314, 0, 1.1 - 0.24> no_shadow}
object{Ant translate<-4.314, 0, 1.1 + 0.32> no_shadow}

object{Ant translate<-4.314, 0, -1.1 - 0.24> no_shadow}
object{Ant translate<-4.314, 0, -1.1 + 0.32> no_shadow}

object{Ant translate<-4.314 + 9.5, 0, 1.1 - 0.24> no_shadow}
object{Ant translate<-4.314 + 9.5, 0, 1.1 + 0.32> no_shadow} 

object{Ant translate<-4.314 + 9.5, 0, -1.1 - 0.24> no_shadow}
object{Ant translate<-4.314 + 9.5, 0, -1.1 + 0.32> no_shadow}

object{AntRow translate <-3, 0, -3.6> no_shadow}
union{Crowd(15, 5) rotate y*90 translate <-1.8, 0, -4> no_shadow}
object{AntRow translate <-4, 0, 3.6> no_shadow}
union{Crowd(25, 15) rotate -y*90 translate <5.5, 0, 4> no_shadow}      
       
plane{
	y,0 
	texture{      
	    pigment{color rgb <0.9, 0.75, 0.65>}
		finish{ambient 0 diffuse 0.78 brilliance 0.4} 
		normal{
		    granite
		    slope_map {
                [0    <0.2, 0.2>]   
                [0.45 <0, 0.6>]   
                [0.5  <0.6, 0.6>]   
                [0.55 <0.6, 0>]   
                [1    <0.2, 0.2>]   
            }
            scale 0.6
		} 
	}
}  
