#local Bald = 0;			// 1 - bald
#local darkNum = 250;
#local fairNum = 150;

#macro Hair(Object, Count, Center, Height, HairColor)
	#local R0 = 0.005;
	#local way = 0;
	#local theta = 0;    
	#local lseed = seed(1000);
	#local realHeight = Height/5 + ((4 * Height)/5 * rand(lseed));
	#while (theta < pi)
		#local way = way + 2 * pi * sin(theta);
		#local theta = theta + (pi / Count);
	#end
	#local part = way / Count;
	#local theta = pi / Count;
	#local last = 0;
	#while (theta < pi)
		#local way = 2 * pi * sin(theta);
		#local startangle = -2 * pi * last / way;
		#local stepangle = 2 * pi * part / way;
		#local way = way + last;
		#while (way >= part)
			#local way = way - part;
			#local startangle = startangle + stepangle;
			#local PointInRange = Center + <sin(theta) * cos(startangle), sin(theta) * sin(startangle), cos(theta)>;
			#local Normal = <0, 0, 0>;
			#local P0 = trace(Object, PointInRange, Center - PointInRange, Normal);
			cone { P0 R0 P0 + realHeight * Normal 0 texture{HairColor}}
		#end
		#local last = way;
		#local theta = theta + (pi / Count);
	#end
#end  

#declare DarkHair = texture {
	pigment {color rgb <1.1, 0.6, 0.1>}
	finish{phong 0.2}
}

#declare FairHair = texture {
	pigment { color rgb <1.3, 0.9, 0.5>}
	finish{phong 0.2}
}  

#declare BodyDarkHair = texture {
	pigment {color rgb <1.1, 0.4, 0.1>}
	finish{phong 0.2}
}

#declare BodyFairHair = texture {
	pigment { color rgb <1.1, 0.7, 0.3>}
	finish{phong 0.2}
}

#declare LegTexture = texture {
	pigment{ 
        gradient x     
        color_map{
            [0.0 color rgb <0.4, 0.25, 0.15>]
            [0.3 0.45 color rgb <0.4, 0.25, 0.15> color rgb <0.5, 0.35, 0.25>] 
            [0.45 0.5 color rgb <0.5, 0.35, 0.25> color rgb <0.5, 0.35, 0.25>]
        }
    }    
    finish {phong 0.1 diffuse 0.8}
    normal{wrinkles 1 scale <0.06, 0.1, 0.1>}
} 

#declare HeadTexture = texture {
	pigment{color rgb <0.4, 0.25, 0.15>}
    finish {phong 0.1 diffuse 0.8}
    normal{wrinkles 1 scale <0.06, 0.1, 0.1>}
} 

#declare EyesTexture = texture {
	pigment{color rgb 0.1}
    finish{ambient 0 diffuse 0.8 phong 1 phong_size 40}
}

#declare CrownTexture = texture {
	pigment{color rgb <1, 0.6, 0.2>}
    finish {phong 1 phong_size 80 diffuse 0.8 reflection 0.1}
}

#declare BackTexture = texture {
	pigment{ 
        gradient x     
        color_map{
            [0.0 0.2 color rgb <0.4, 0.25, 0.15> color rgb <0.4, 0.25, 0.15>]
            [0.2 0.5 color rgb <0.4, 0.25, 0.15> color rgb <0.5, 0.35, 0.25>] 
            [0.5 0.8 color rgb <0.5, 0.35, 0.25> color rgb <0.4, 0.25, 0.15>]
        }
        frequency 3
    }    
    finish {phong 0.1 diffuse 0.8}
    normal{wrinkles 1 scale <0.06, 0.1, 0.1>}
}

#declare Sphere = sphere{
    0, 0.5  
    texture{LegTexture}
}

#declare Sphere1 = object{Sphere scale<1.3, 0.25, 0.25>}
#declare Part1 = union{
     object{Sphere1} 
     #if(Bald != 1) 
     	union{Hair(Sphere1, darkNum, <-0.5, 0, 0>, 0.14, DarkHair)} 
     	union{Hair(Sphere1, fairNum, <-0.5, 0, 0>, 0.16, FairHair)}
     	union{Hair(Sphere1, darkNum, <-0.25, 0, 0>, 0.12, DarkHair)} 
     	union{Hair(Sphere1, fairNum, <-0.25, 0, 0>, 0.14, FairHair)}
     	union{Hair(Sphere1, darkNum, <0, 0, 0>, 0.1, DarkHair)}   
     	union{Hair(Sphere1, fairNum, <0, 0, 0>, 0.12, FairHair)}  
     	union{Hair(Sphere1, darkNum, <0.25, 0, 0>, 0.12, DarkHair)} 
     	union{Hair(Sphere1, fairNum, <0.25, 0, 0>, 0.14, FairHair)} 
     	union{Hair(Sphere1, darkNum, <0.5, 0, 0>, 0.14, DarkHair)} 
     	union{Hair(Sphere1, fairNum, <0.5, 0, 0>, 0.16, FairHair)}
    #end
}         

#declare Sphere2 = object{Sphere scale<1.1, 0.25, 0.25>} 
#declare Part2 = union{
     object{Sphere2} 
     #if(Bald != 1)
		union{Hair(Sphere2, darkNum, <-0.4, 0, 0>, 0.1, DarkHair)} 
     	union{Hair(Sphere2, fairNum, <-0.4, 0, 0>, 0.12, FairHair)} 
     	union{Hair(Sphere2, darkNum, <-0.2, 0, 0>, 0.06, DarkHair)}   
     	union{Hair(Sphere2, fairNum, <-0.2, 0, 0>, 0.08, FairHair)}
     	union{Hair(Sphere2, darkNum, <0, 0, 0>, 0.06, DarkHair)}   
     	union{Hair(Sphere2, fairNum, <0, 0, 0>, 0.08, FairHair)}  
     	union{Hair(Sphere2, darkNum, <0.2, 0, 0>, 0.06, DarkHair)}   
     	union{Hair(Sphere2, fairNum, <0.2, 0, 0>, 0.08, FairHair)}
     	union{Hair(Sphere2, darkNum, <0.4, 0, 0>, 0.1, DarkHair)} 
     	union{Hair(Sphere2, fairNum, <0.4, 0, 0>, 0.12, FairHair)} 
	#end
}

#declare Sphere3 = object{Sphere scale<0.8, 0.2, 0.2>}
#declare Part3 = union{
     object{Sphere3}
     #if(Bald != 1)
		union{Hair(Sphere3, darkNum, <-0.35, 0, 0>, 0.12, DarkHair)} 
     	union{Hair(Sphere3, fairNum, <-0.35, 0, 0>, 0.14, FairHair)} 
     	union{Hair(Sphere3, darkNum, <-0.15, 0, 0>, 0.1, DarkHair)} 
     	union{Hair(Sphere3, fairNum, <-0.15, 0, 0>, 0.12, FairHair)}
     	union{Hair(Sphere3, darkNum, <0, 0, 0>, 0.06, DarkHair)}   
     	union{Hair(Sphere3, fairNum, <0, 0, 0>, 0.08, FairHair)} 
     	union{Hair(Sphere3, darkNum, <0.15, 0, 0>, 0.1, DarkHair)} 
     	union{Hair(Sphere3, fairNum, <0.15, 0, 0>, 0.12, FairHair)}
     	union{Hair(Sphere3, darkNum, <0.35, 0, 0>, 0.1, DarkHair)}
     	union{Hair(Sphere3, fairNum, <0.35, 0, 0>, 0.12, FairHair)}     
	#end   
}  

#declare Sphere4 = object{Sphere scale<0.8, 0.2, 0.2>}
#declare Part4 = union{
     object{Sphere4}
     #if(Bald != 1)
     	union{Hair(Sphere4, darkNum, <-0.35, 0, 0>, 0.12, DarkHair)} 
     	union{Hair(Sphere4, fairNum, <-0.35, 0, 0>, 0.14, FairHair)} 
     	union{Hair(Sphere3, darkNum, <-0.15, 0, 0>, 0.1, DarkHair)} 
     	union{Hair(Sphere3, fairNum, <-0.15, 0, 0>, 0.12, FairHair)}
     	union{Hair(Sphere4, darkNum, <0, 0, 0>, 0.05, DarkHair)}   
     	union{Hair(Sphere4, fairNum, <0, 0, 0>, 0.06, FairHair)} 
     	union{Hair(Sphere4, darkNum, <0.15, 0, 0>, 0.06, DarkHair)} 
     	union{Hair(Sphere4, fairNum, <0.15, 0, 0>, 0.07, FairHair)}
     	union{Hair(Sphere4, darkNum, <0.35, 0, 0>, 0.06, DarkHair)}
     	union{Hair(Sphere4, fairNum, <0.35, 0, 0>, 0.08, FairHair)}
	#end  
}

#declare Sphere5 = object{Sphere scale<0.6, 0.2, 0.2>} 
#declare Part5 = union{
     object{Sphere5}  
     #if(Bald != 1)
     	union{Hair(Sphere5, darkNum, <-0.15, 0, 0>, 0.12, DarkHair)} 
     	union{Hair(Sphere5, fairNum, <-0.15, 0, 0>, 0.14, FairHair)}
     	union{Hair(Sphere5, darkNum, <0, 0, 0>, 0.08, DarkHair)}   
     	union{Hair(Sphere5, fairNum, <0, 0, 0>, 0.1, FairHair)}
     	union{Hair(Sphere5, darkNum, <0.15, 0, 0>, 0.1, DarkHair)}
     	union{Hair(Sphere5, fairNum, <0.15, 0, 0>, 0.1, FairHair)}
     #end
}
    
#declare Trans1 = transform {translate -x*0.5*1.3 rotate -z*60}
#declare Trans2 = transform {translate -x*0.5*1.1 rotate z*70 translate -x*1.3/2}  
#declare Trans3 = transform {translate -x*0.5*0.8 rotate z*40 translate -x*1.1/2}  
#declare Trans4 = transform {translate -x*0.5*0.8 rotate -z*20 translate -x*0.8/2}
#declare Trans5 = transform {translate -x*0.5*0.6 rotate -z*30 translate -x*0.8/2}
            
#declare Leg1 = union {              
    object{Part1 transform{Trans1}}
    object{Part2 transform{Trans2} transform{Trans1}}
    object{Part3 transform{Trans3} transform{Trans2} transform{Trans1}} 
    object{Part4 transform{Trans4} transform{Trans3} transform{Trans2} transform{Trans1}} 
    object{Part5 transform{Trans5} transform{Trans4} transform{Trans3} transform{Trans2} transform{Trans1}}
    translate y*0.2                   
}      

#declare Sphere1 = object{Sphere scale<0.3, 0.08, 0.08>}
#declare Part1 = union{
	object{Sphere1} 
    #if(Bald != 1) 
    	union{Hair(Sphere1, 100, <-0.08, 0, 0>, 0.07, DarkHair)} 
     	union{Hair(Sphere1, 50, <-0.08, 0, 0>, 0.09, FairHair)}
     	union{Hair(Sphere1, 100, <0, 0, 0>, 0.05, DarkHair)}   
     	union{Hair(Sphere1, 50, <0, 0, 0>, 0.07, FairHair)}  
     	union{Hair(Sphere1, 100, <0.08, 0, 0>, 0.06, DarkHair)} 
     	union{Hair(Sphere1, 50, <0.08, 0, 0>, 0.08, FairHair)}
	#end
} 

#declare Trans1 = transform {translate -x*0.5*0.3 rotate -z*30}
#declare Trans2 = transform {translate -x*0.5*0.3 rotate z*60 translate -x*0.3/2}   
#declare Trans3 = transform {translate -x*0.5*0.3 rotate z*30 translate -x*0.3/2} 
#declare Trans4 = transform {translate -x*0.5*0.3 rotate z*25 translate -x*0.3/2}

#declare Leg2 = union {              
    object{Part1 transform{Trans1}}
    object{Part1 transform{Trans2} transform{Trans1}}
    object{Part1 transform{Trans3} transform{Trans2} transform{Trans1}} 
    object{Part1 transform{Trans4} transform{Trans3} transform{Trans2} transform{Trans1}}
    translate y*0.2                   
}   

#declare Sphere1 = object{Sphere scale<1, 0.25, 0.25>}
#declare Part1 = union{
     object{Sphere1} 
     #if(Bald != 1) 
     	union{Hair(Sphere1, darkNum, <-0.4, 0, 0>, 0.14, DarkHair)} 
     	union{Hair(Sphere1, fairNum, <-0.4, 0, 0>, 0.16, FairHair)}
     	union{Hair(Sphere1, darkNum, <-0.2, 0, 0>, 0.12, DarkHair)} 
     	union{Hair(Sphere1, fairNum, <-0.2, 0, 0>, 0.14, FairHair)}
     	union{Hair(Sphere1, darkNum, <0, 0, 0>, 0.1, DarkHair)}   
     	union{Hair(Sphere1, fairNum, <0, 0, 0>, 0.12, FairHair)}  
     	union{Hair(Sphere1, darkNum, <0.2, 0, 0>, 0.12, DarkHair)} 
     	union{Hair(Sphere1, fairNum, <0.2, 0, 0>, 0.14, FairHair)} 
     	union{Hair(Sphere1, darkNum, <0.4, 0, 0>, 0.14, DarkHair)} 
     	union{Hair(Sphere1, fairNum, <0.4, 0, 0>, 0.16, FairHair)}
	#end
}         

#declare Sphere2 = object{Sphere scale<1, 0.25, 0.25>} 
#declare Part2 = union{
     object{Sphere2} 
     #if(Bald != 1)
		union{Hair(Sphere2, darkNum, <-0.4, 0, 0>, 0.1, DarkHair)} 
     	union{Hair(Sphere2, fairNum, <-0.4, 0, 0>, 0.12, FairHair)} 
     	union{Hair(Sphere2, darkNum, <-0.2, 0, 0>, 0.06, DarkHair)}   
     	union{Hair(Sphere2, fairNum, <-0.2, 0, 0>, 0.08, FairHair)}
     	union{Hair(Sphere2, darkNum, <0, 0, 0>, 0.06, DarkHair)}   
     	union{Hair(Sphere2, fairNum, <0, 0, 0>, 0.08, FairHair)}  
     	union{Hair(Sphere2, darkNum, <0.2, 0, 0>, 0.06, DarkHair)}   
     	union{Hair(Sphere2, fairNum, <0.2, 0, 0>, 0.08, FairHair)}
     	union{Hair(Sphere2, darkNum, <0.4, 0, 0>, 0.1, DarkHair)} 
     	union{Hair(Sphere2, fairNum, <0.4, 0, 0>, 0.12, FairHair)} 
	#end
}

#declare Sphere3 = object{Sphere scale<0.8, 0.2, 0.2>}
#declare Part3 = union{
     object{Sphere3}
     #if(Bald != 1)
		union{Hair(Sphere3, darkNum, <-0.35, 0, 0>, 0.12, DarkHair)} 
     	union{Hair(Sphere3, fairNum, <-0.35, 0, 0>, 0.14, FairHair)} 
     	union{Hair(Sphere3, darkNum, <-0.15, 0, 0>, 0.1, DarkHair)} 
     	union{Hair(Sphere3, fairNum, <-0.15, 0, 0>, 0.12, FairHair)}
     	union{Hair(Sphere3, darkNum, <0, 0, 0>, 0.06, DarkHair)}   
     	union{Hair(Sphere3, fairNum, <0, 0, 0>, 0.08, FairHair)} 
     	union{Hair(Sphere3, darkNum, <0.15, 0, 0>, 0.1, DarkHair)} 
     	union{Hair(Sphere3, fairNum, <0.15, 0, 0>, 0.12, FairHair)}
     	union{Hair(Sphere3, darkNum, <0.35, 0, 0>, 0.1, DarkHair)}
     	union{Hair(Sphere3, fairNum, <0.35, 0, 0>, 0.12, FairHair)}     
	#end   
}  

#declare Sphere4 = object{Sphere scale<0.8, 0.2, 0.2>}
#declare Part4 = union{
     object{Sphere4}
     #if(Bald != 1)
     	union{Hair(Sphere4, darkNum, <-0.35, 0, 0>, 0.12, DarkHair)} 
     	union{Hair(Sphere4, fairNum, <-0.35, 0, 0>, 0.14, FairHair)} 
     	union{Hair(Sphere3, darkNum, <-0.15, 0, 0>, 0.1, DarkHair)} 
     	union{Hair(Sphere3, fairNum, <-0.15, 0, 0>, 0.12, FairHair)}
     	union{Hair(Sphere4, darkNum, <0, 0, 0>, 0.05, DarkHair)}   
     	union{Hair(Sphere4, fairNum, <0, 0, 0>, 0.06, FairHair)} 
     	union{Hair(Sphere4, darkNum, <0.15, 0, 0>, 0.06, DarkHair)} 
     	union{Hair(Sphere4, fairNum, <0.15, 0, 0>, 0.07, FairHair)}
     	union{Hair(Sphere4, darkNum, <0.35, 0, 0>, 0.06, DarkHair)}
     	union{Hair(Sphere4, fairNum, <0.35, 0, 0>, 0.08, FairHair)}
	#end  
}
    
#declare Trans1 = transform {translate -x*0.5*1 rotate -z*60}
#declare Trans2 = transform {translate -x*0.5*1 rotate z*70 translate -x*1/2}  
#declare Trans3 = transform {translate -x*0.5*0.8 rotate z*40 translate -x*1/2}  
#declare Trans4 = transform {translate -x*0.5*0.8 rotate -z*20 translate -x*0.8/2}
            
#declare Leg3 = union {              
    object{Part1 transform{Trans1}}
    object{Part2 transform{Trans2} transform{Trans1}}
    object{Part3 transform{Trans3} transform{Trans2} transform{Trans1}} 
    object{Part4 transform{Trans4} transform{Trans3} transform{Trans2} transform{Trans1}} 
    rotate -z*3
    translate y*0.2                   
}                                                    

#declare Head = union {
	sphere{0, 1 scale <0.8, 0.5, 0.6>}
	// eyes                          
	sphere{0, 0.05 translate <-0.63, 0.3, 0.1> texture{EyesTexture}}
	sphere{0, 0.05 translate <-0.63, 0.3, -0.1> texture{EyesTexture}}
}

#declare Back = merge{
	sphere{0, 1}
	difference{
		sphere{0, 1 scale <1.1, 1, 1>}
		plane{x, 0}
	}                               
	scale<1, 0.5, 0.6>
}           

#declare Crown = union {
	difference {
		cone{0, 0.2, <0, 0.8, 0>, 0.3} 
		cone{<0, -0.01, 0>, 0.19, <0, 0.81, 0>, 0.29}  
		#local num = 6;
		#local cnt = 0;
		#while (cnt < num)
			intersection{plane{x, 0 rotate -z*6} plane{-x, 0 rotate z*6} translate y*0.2 rotate y*30*cnt} 
			#local cnt = cnt + 1;
		#end
	}
	#local num = 12;
	#local cnt = 0;
	#while (cnt < num)
		sphere{0, 0.03 translate<0, 0.8, 0.3> rotate<0, 15 + 30 * cnt, 0>}
		#local cnt = cnt + 1;
	#end 
	
	difference { 
		union {
			#local num = 12;
			#local cnt = 0;
			#while (cnt < num)
				sphere{0, 0.03 translate<0, 0.1, 0.2> rotate<0, 15 + 30 * cnt, 0>}
				#local cnt = cnt + 1;
			#end   
		}     
		cone{0, 0.2, <0, 0.8, 0>, 0.3}
	}
	
	texture{CrownTexture}
}

#declare Body = union {
	union{
		object{Head texture{HeadTexture}} 
		object{Crown translate <-0.2, 0.44, 0>}
		#if(Bald != 1)
			union{Hair(Head, 4000, <0.15, 0, 0>, 0.16, BodyDarkHair)}
			union{Hair(Head, 4000, <0.15, 0, 0>, 0.18, BodyFairHair)}
		#end
	}
	union {   
		object{Back texture{BackTexture}}
		#if(Bald != 1)
			union{Hair(Back, 5000, <0.15, 0, 0>, 0.18, BodyDarkHair)}
			union{Hair(Back, 5000, <0.15, 0, 0>, 0.20, BodyFairHair)}
		#end
		translate <1.1, 0.2, 0>
	}
	
	translate <0.3, 0.4, 0> 
}
                 
#declare Spider = union {

	// front-left                 
    object{
        Leg1 
        rotate -y*30
        translate -z*0.5 
    }  
    
    // front-left
    object{
        Leg2 
        rotate -y*10
        translate <-0.35, 0.4, -0.2>
    } 
    
    // back-left
    object{
        Leg1 
        rotate -y*140
        translate <0.8, 0, -0.5>
    } 
    
    // left1
    object{
        Leg3 
        rotate -y*75
        translate <0.22, 0, -0.5>
    } 
    
    // left2
    object{
        Leg3 
        rotate -y*115
        translate <0.46, 0, -0.5>
    }
    
     
    // front-right
    object{
        Leg1 
        rotate y*30
        translate z*0.5 
    }          
    
    // back-right
    object{
        Leg1 
        rotate y*140
        translate <0.8, 0, 0.5>
    }
    
    // front-right
    object{
        Leg2 
        rotate y*10
        translate <-0.35, 0.4, 0.2>
    } 
    
    // right1
    object{
        Leg3 
        rotate y*70
        translate <0.22, 0, 0.5>
    } 
    
    // right2
    object{
        Leg3 
        rotate y*105
        translate <0.46, 0, 0.5>
    }
    
    object{Body}    
}  
