
#macro Hair(Object, Count, Center, Height, HairColor)
	#local R0 = 0.001;
	#local way = 0;
	#local theta = 0;    
	#local lseed = seed(1000);
	#local realHeight = Height/5 + ((4 * Height)/5 * rand(lseed));
	#while (theta < pi)
		#local way = way + 2 * pi * sin(theta);
		#local theta = theta + (pi / Count);
	#end
	#local part = way / Count;
	#local theta = pi / Count;
	#local last = 0;
	#while (theta < pi)
		#local way = 2 * pi * sin(theta);
		#local startangle = -2 * pi * last / way;
		#local stepangle = 2 * pi * part / way;
		#local way = way + last;
		#while (way >= part)
			#local way = way - part;
			#local startangle = startangle + stepangle;
			#local PointInRange = Center + <sin(theta) * cos(startangle), sin(theta) * sin(startangle), cos(theta)>;
			#local Normal = <0, 0, 0>;
			#local P0 = trace(Object, PointInRange, Center - PointInRange, Normal);
			cone { P0 R0 P0 + realHeight * Normal 0 texture{HairColor} no_shadow}
		#end
		#local last = way;
		#local theta = theta + (pi / Count);
	#end
#end  

#declare FairHair = texture {
	pigment { color rgb 0.8}
	finish{ambient 0.1 diffuse 0.8 phong 0}
} 

#declare Center = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0023, -0.0002, 0.0000> <-0.0023, -0.0002, 0.0013> <-0.0013, -0.0001, 0.0023> <-0.0000, 0.0000, 0.0023>
		<-0.0598, 0.2900, 0.0000> <-0.0598, 0.2900, 0.0013> <-0.0534, 0.2907, 0.0061> <-0.0521, 0.2908, 0.0061>
		<-0.1573, 0.6736, 0.0000> <-0.1573, 0.6736, 0.0097> <-0.1496, 0.6748, 0.0132> <-0.1399, 0.6759, 0.0132>
		<-0.1938, 0.9672, 0.0000> <-0.1938, 0.9672, 0.0097> <-0.1834, 0.9684, 0.0151> <-0.1738, 0.9694, 0.0151>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0023, -0.0002, 0.0000> <-0.0598, 0.2900, 0.0000> <-0.1573, 0.6736, 0.0000> <-0.1938, 0.9672, 0.0000>
		<-0.0023, -0.0002, -0.0013> <-0.0598, 0.2900, -0.0013> <-0.1573, 0.6735, -0.0097> <-0.1938, 0.9671, -0.0097>
		<-0.0012, -0.0001, -0.0023> <-0.0534, 0.2907, -0.0061> <-0.1496, 0.6747, -0.0132> <-0.1834, 0.9682, -0.0151>
		<0.0000, -0.0000, -0.0023> <-0.0521, 0.2908, -0.0061> <-0.1399, 0.6758, -0.0132> <-0.1738, 0.9693, -0.0151>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.0000, -0.0023> <-0.0521, 0.2908, -0.0061> <-0.1399, 0.6758, -0.0132> <-0.1738, 0.9693, -0.0151>
		<0.0013, 0.0001, -0.0023> <-0.0509, 0.2909, -0.0061> <-0.1302, 0.6768, -0.0132> <-0.1641, 0.9703, -0.0151>
		<0.0023, 0.0002, -0.0013> <-0.0445, 0.2916, -0.0013> <-0.1225, 0.6780, -0.0097> <-0.1537, 0.9715, -0.0097>
		<0.0023, 0.0002, 0.0000> <-0.0445, 0.2916, 0.0000> <-0.1225, 0.6781, 0.0000> <-0.1537, 0.9715, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0023, 0.0002, 0.0000> <-0.0445, 0.2916, 0.0000> <-0.1225, 0.6781, 0.0000> <-0.1537, 0.9715, 0.0000>
		<0.0023, 0.0002, 0.0013> <-0.0445, 0.2916, 0.0013> <-0.1225, 0.6781, 0.0097> <-0.1537, 0.9716, 0.0097>
		<0.0012, 0.0001, 0.0023> <-0.0509, 0.2909, 0.0061> <-0.1302, 0.6769, 0.0132> <-0.1641, 0.9705, 0.0151>
		<-0.0000, 0.0000, 0.0023> <-0.0521, 0.2908, 0.0061> <-0.1399, 0.6759, 0.0132> <-0.1738, 0.9694, 0.0151>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1938, 0.9672, 0.0000> <-0.1938, 0.9672, 0.0097> <-0.1834, 0.9684, 0.0151> <-0.1738, 0.9694, 0.0151>
		<-0.2290, 1.2503, 0.0000> <-0.2290, 1.2504, 0.0097> <-0.2161, 1.2512, 0.0169> <-0.2064, 1.2522, 0.0169>
		<-0.2519, 1.6320, 0.0000> <-0.2519, 1.6320, 0.0094> <-0.2413, 1.6327, 0.0150> <-0.2318, 1.6327, 0.0150>
		<-0.2407, 1.9171, 0.0000> <-0.2407, 1.9172, 0.0094> <-0.2306, 1.9172, 0.0146> <-0.2211, 1.9172, 0.0146>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1938, 0.9672, 0.0000> <-0.2290, 1.2503, 0.0000> <-0.2519, 1.6320, 0.0000> <-0.2407, 1.9171, 0.0000>
		<-0.1938, 0.9671, -0.0097> <-0.2290, 1.2503, -0.0097> <-0.2519, 1.6320, -0.0094> <-0.2407, 1.9171, -0.0094>
		<-0.1834, 0.9682, -0.0151> <-0.2160, 1.2510, -0.0169> <-0.2412, 1.6326, -0.0150> <-0.2306, 1.9171, -0.0146>
		<-0.1738, 0.9693, -0.0151> <-0.2064, 1.2521, -0.0169> <-0.2318, 1.6326, -0.0150> <-0.2211, 1.9171, -0.0146>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1738, 0.9693, -0.0151> <-0.2064, 1.2521, -0.0169> <-0.2318, 1.6326, -0.0150> <-0.2211, 1.9171, -0.0146>
		<-0.1641, 0.9703, -0.0151> <-0.1967, 1.2531, -0.0169> <-0.2224, 1.6326, -0.0150> <-0.2117, 1.9171, -0.0146>
		<-0.1537, 0.9715, -0.0097> <-0.1837, 1.2539, -0.0097> <-0.2118, 1.6332, -0.0094> <-0.2016, 1.9171, -0.0094>
		<-0.1537, 0.9715, 0.0000> <-0.1837, 1.2540, 0.0000> <-0.2118, 1.6333, 0.0000> <-0.2016, 1.9171, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1537, 0.9715, 0.0000> <-0.1837, 1.2540, 0.0000> <-0.2118, 1.6333, 0.0000> <-0.2016, 1.9171, 0.0000>
		<-0.1537, 0.9716, 0.0097> <-0.1837, 1.2540, 0.0097> <-0.2118, 1.6333, 0.0094> <-0.2016, 1.9172, 0.0094>
		<-0.1641, 0.9705, 0.0151> <-0.1967, 1.2533, 0.0169> <-0.2224, 1.6327, 0.0150> <-0.2117, 1.9172, 0.0146>
		<-0.1738, 0.9694, 0.0151> <-0.2064, 1.2522, 0.0169> <-0.2318, 1.6327, 0.0150> <-0.2211, 1.9172, 0.0146>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2407, 1.9171, 0.0000> <-0.2407, 1.9172, 0.0094> <-0.2306, 1.9172, 0.0146> <-0.2211, 1.9172, 0.0146>
		<-0.2292, 2.2091, 0.0000> <-0.2292, 2.2091, 0.0094> <-0.2196, 2.2082, 0.0142> <-0.2102, 2.2082, 0.0142>
		<-0.1767, 2.5970, 0.0000> <-0.1767, 2.5970, 0.0082> <-0.1652, 2.5960, 0.0147> <-0.1571, 2.5947, 0.0147>
		<-0.1187, 2.8834, 0.0000> <-0.1187, 2.8834, 0.0082> <-0.1100, 2.8820, 0.0127> <-0.1020, 2.8807, 0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2407, 1.9171, 0.0000> <-0.2292, 2.2091, 0.0000> <-0.1767, 2.5970, 0.0000> <-0.1187, 2.8834, 0.0000>
		<-0.2407, 1.9171, -0.0094> <-0.2292, 2.2090, -0.0094> <-0.1767, 2.5970, -0.0082> <-0.1187, 2.8833, -0.0082>
		<-0.2306, 1.9171, -0.0146> <-0.2196, 2.2081, -0.0142> <-0.1652, 2.5959, -0.0147> <-0.1100, 2.8819, -0.0127>
		<-0.2211, 1.9171, -0.0146> <-0.2102, 2.2081, -0.0142> <-0.1571, 2.5946, -0.0147> <-0.1020, 2.8806, -0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2211, 1.9171, -0.0146> <-0.2102, 2.2081, -0.0142> <-0.1571, 2.5946, -0.0147> <-0.1020, 2.8806, -0.0127>
		<-0.2117, 1.9171, -0.0146> <-0.2008, 2.2081, -0.0142> <-0.1491, 2.5933, -0.0147> <-0.0939, 2.8792, -0.0127>
		<-0.2016, 1.9171, -0.0094> <-0.1912, 2.2072, -0.0094> <-0.1376, 2.5923, -0.0082> <-0.0852, 2.8778, -0.0082>
		<-0.2016, 1.9171, 0.0000> <-0.1912, 2.2073, 0.0000> <-0.1376, 2.5923, 0.0000> <-0.0852, 2.8779, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2016, 1.9171, 0.0000> <-0.1912, 2.2073, 0.0000> <-0.1376, 2.5923, 0.0000> <-0.0852, 2.8779, 0.0000>
		<-0.2016, 1.9172, 0.0094> <-0.1912, 2.2073, 0.0094> <-0.1376, 2.5923, 0.0082> <-0.0852, 2.8779, 0.0082>
		<-0.2117, 1.9172, 0.0146> <-0.2008, 2.2082, 0.0142> <-0.1491, 2.5934, 0.0147> <-0.0939, 2.8793, 0.0127>
		<-0.2211, 1.9172, 0.0146> <-0.2102, 2.2082, 0.0142> <-0.1571, 2.5947, 0.0147> <-0.1020, 2.8807, 0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1414, 3.8051, 0.0000> <0.0634, 3.5286, 0.0000> <-0.0617, 3.1650, 0.0000> <-0.1187, 2.8834, 0.0000>
		<0.1414, 3.8051, 0.0008> <0.0634, 3.5286, 0.0008> <-0.0617, 3.1650, 0.0082> <-0.1187, 2.8834, 0.0082>
		<0.1421, 3.8049, 0.0016> <0.0686, 3.5277, 0.0049> <-0.0557, 3.1636, 0.0107> <-0.1100, 2.8820, 0.0127>
		<0.1429, 3.8047, 0.0016> <0.0695, 3.5275, 0.0049> <-0.0476, 3.1623, 0.0107> <-0.1020, 2.8807, 0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1414, 3.8051, 0.0000> <0.1414, 3.8051, -0.0008> <0.1421, 3.8049, -0.0016> <0.1429, 3.8047, -0.0016>
		<0.0634, 3.5286, 0.0000> <0.0634, 3.5286, -0.0008> <0.0686, 3.5277, -0.0049> <0.0694, 3.5274, -0.0049>
		<-0.0617, 3.1650, 0.0000> <-0.0617, 3.1649, -0.0082> <-0.0557, 3.1635, -0.0107> <-0.0477, 3.1622, -0.0107>
		<-0.1187, 2.8834, 0.0000> <-0.1187, 2.8833, -0.0082> <-0.1100, 2.8819, -0.0127> <-0.1020, 2.8806, -0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1429, 3.8047, -0.0016> <0.1437, 3.8044, -0.0016> <0.1444, 3.8042, -0.0008> <0.1444, 3.8042, 0.0000>
		<0.0694, 3.5274, -0.0049> <0.0703, 3.5272, -0.0049> <0.0755, 3.5263, -0.0008> <0.0755, 3.5263, 0.0000>
		<-0.0477, 3.1622, -0.0107> <-0.0396, 3.1609, -0.0107> <-0.0336, 3.1594, -0.0082> <-0.0336, 3.1595, 0.0000>
		<-0.1020, 2.8806, -0.0127> <-0.0939, 2.8792, -0.0127> <-0.0852, 2.8778, -0.0082> <-0.0852, 2.8779, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1444, 3.8042, 0.0000> <0.1444, 3.8042, 0.0008> <0.1437, 3.8044, 0.0016> <0.1429, 3.8047, 0.0016>
		<0.0755, 3.5263, 0.0000> <0.0755, 3.5263, 0.0008> <0.0703, 3.5272, 0.0049> <0.0695, 3.5275, 0.0049>
		<-0.0336, 3.1595, 0.0000> <-0.0336, 3.1595, 0.0082> <-0.0396, 3.1609, 0.0107> <-0.0476, 3.1623, 0.0107>
		<-0.0852, 2.8779, 0.0000> <-0.0852, 2.8779, 0.0082> <-0.0939, 2.8793, 0.0127> <-0.1020, 2.8807, 0.0127>
	}
	
	pigment { rgb <0.96, 0.94, 0.92>}
	finish {ambient 0 diffuse 0.85 phong 0.2}
} 

#declare Right = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1518, 3.8143, 0.0000> <0.1358, 3.7583, 0.0000> <0.1143, 3.6837, 0.0000> <0.0983, 3.6278, 0.0000>
		<0.1518, 3.8143, 0.0000> <0.1986, 3.6822, 0.0000> <0.1932, 3.6635, 0.0000> <0.1772, 3.6076, 0.0000>
		<0.1518, 3.8143, 0.0000> <0.1986, 3.6822, 0.0000> <0.2513, 3.6743, 0.0000> <0.2824, 3.5806, 0.0000>
		<0.1518, 3.8143, 0.0000> <0.2147, 3.7381, 0.0000> <0.3302, 3.6541, 0.0000> <0.3613, 3.5604, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1170, 0.6198, 0.0000> <-0.1301, 0.6884, 0.0000> <-0.1475, 0.7800, 0.0000> <-0.1606, 0.8487, 0.0000>
		<-0.0467, 0.6918, 0.0000> <-0.0598, 0.7605, 0.0000> <-0.0428, 0.9161, 0.0000> <-0.0558, 0.9848, 0.0000>
		<0.0761, 0.7680, 0.0000> <0.1311, 0.8907, 0.0000> <0.0624, 1.0335, 0.0000> <0.0838, 1.1662, 0.0000>
		<0.1173, 0.8599, 0.0000> <0.1722, 0.9826, 0.0000> <0.1672, 1.1695, 0.0000> <0.1886, 1.3023, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1170, 0.6198, 0.0000> <-0.0467, 0.6918, 0.0000> <0.0761, 0.7680, 0.0000> <0.1173, 0.8599, 0.0000>
		<-0.1170, 0.6198, 0.0000> <-0.0598, 0.7605, 0.0000> <-0.0072, 0.7647, 0.0000> <0.0339, 0.8565, 0.0000>
		<-0.1170, 0.6198, 0.0000> <-0.0598, 0.7605, 0.0000> <-0.0642, 0.7834, 0.0000> <-0.0772, 0.8521, 0.0000>
		<-0.1170, 0.6198, 0.0000> <-0.1301, 0.6884, 0.0000> <-0.1475, 0.7800, 0.0000> <-0.1606, 0.8487, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2148, 1.5102, 0.0000> <-0.2132, 1.4473, 0.0000> <-0.2119, 1.3634, 0.0000> <-0.2068, 1.3007, 0.0000>
		<-0.0936, 1.5102, 0.0000> <-0.0919, 1.4473, 0.0000> <-0.0942, 1.3838, 0.0000> <-0.0891, 1.3211, 0.0000>
		<0.0681, 1.5102, 0.0000> <0.0697, 1.4678, 0.0000> <0.0690, 1.3908, 0.0000> <0.0679, 1.3484, 0.0000>
		<0.1894, 1.5102, 0.0000> <0.1910, 1.4678, 0.0000> <0.1868, 1.4112, 0.0000> <0.1857, 1.3688, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2148, 1.5102, 0.0000> <-0.0936, 1.5102, 0.0000> <0.0681, 1.5102, 0.0000> <0.1894, 1.5102, 0.0000>
		<-0.2180, 1.6337, 0.0000> <-0.0968, 1.6337, 0.0000> <0.0641, 1.6181, 0.0000> <0.1853, 1.6181, 0.0000>
		<-0.2263, 1.7983, 0.0000> <-0.1094, 1.7826, 0.0000> <0.0544, 1.7772, 0.0000> <0.1713, 1.7615, 0.0000>
		<-0.2229, 1.9217, 0.0000> <-0.1060, 1.9060, 0.0000> <0.0499, 1.8851, 0.0000> <0.1668, 1.8694, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2229, 1.9217, 0.0000> <-0.1060, 1.9060, 0.0000> <0.0499, 1.8851, 0.0000> <0.1668, 1.8694, 0.0000>
		<-0.2197, 2.0365, 0.0000> <-0.1028, 2.0208, 0.0000> <0.0476, 1.9389, 0.0000> <0.1645, 1.9232, 0.0000>
		<-0.2064, 2.1893, 0.0000> <-0.0984, 2.1130, 0.0000> <0.0589, 2.0714, 0.0000> <0.1668, 1.9951, 0.0000>
		<-0.1929, 2.3033, 0.0000> <-0.0850, 2.2270, 0.0000> <0.0589, 2.1253, 0.0000> <0.1668, 2.0489, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1668, 2.0489, 0.0000> <0.1802, 2.1589, 0.0000> <0.1982, 2.3056, 0.0000> <0.2117, 2.4156, 0.0000>
		<0.0589, 2.1253, 0.0000> <0.0723, 2.2353, 0.0000> <0.0854, 2.3071, 0.0000> <0.0989, 2.4171, 0.0000>
		<-0.0850, 2.2270, 0.0000> <-0.0808, 2.2630, 0.0000> <-0.0578, 2.3834, 0.0000> <-0.0515, 2.4191, 0.0000>
		<-0.1929, 2.3033, 0.0000> <-0.1887, 2.3393, 0.0000> <-0.1705, 2.3849, 0.0000> <-0.1642, 2.4206, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0983, 3.6278, 0.0000> <0.0713, 3.5335, 0.0000> <0.0355, 3.4078, 0.0000> <0.0085, 3.3135, 0.0000>
		<0.1772, 3.6076, 0.0000> <0.1502, 3.5133, 0.0000> <0.1306, 3.4009, 0.0000> <0.1036, 3.3066, 0.0000>
		<0.2824, 3.5806, 0.0000> <0.3081, 3.5031, 0.0000> <0.2412, 3.3784, 0.0000> <0.2304, 3.2974, 0.0000>
		<0.3613, 3.5604, 0.0000> <0.3870, 3.4829, 0.0000> <0.3363, 3.3715, 0.0000> <0.3256, 3.2905, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1642, 2.4206, 0.0000> <-0.0515, 2.4191, 0.0000> <0.0989, 2.4171, 0.0000> <0.2117, 2.4156, 0.0000>
		<-0.1571, 2.4611, 0.0000> <-0.0443, 2.4596, 0.0000> <0.0507, 2.4827, 0.0000> <0.1634, 2.4812, 0.0000>
		<-0.1530, 2.5158, 0.0000> <-0.0933, 2.5391, 0.0000> <0.0348, 2.5180, 0.0000> <0.0836, 2.5596, 0.0000>
		<-0.1482, 2.5566, 0.0000> <-0.0884, 2.5799, 0.0000> <0.0021, 2.5925, 0.0000> <0.0509, 2.6341, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2068, 1.3007, 0.0000> <-0.1840, 1.2072, 0.0000> <-0.1535, 1.0826, 0.0000> <-0.1307, 0.9891, 0.0000>
		<-0.1957, 1.1648, 0.0000> <-0.1728, 1.0714, 0.0000> <-0.0577, 1.1765, 0.0000> <-0.0349, 1.0831, 0.0000>
		<-0.1745, 0.9843, 0.0000> <-0.0697, 1.1204, 0.0000> <-0.0119, 1.0723, 0.0000> <0.0928, 1.2083, 0.0000>
		<-0.1606, 0.8487, 0.0000> <-0.0558, 0.9848, 0.0000> <0.0838, 1.1662, 0.0000> <0.1886, 1.3023, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2068, 1.3007, 0.0000> <-0.1957, 1.1648, 0.0000> <-0.1745, 0.9843, 0.0000> <-0.1606, 0.8487, 0.0000>
		<-0.0891, 1.3211, 0.0000> <-0.0779, 1.1853, 0.0000> <-0.1655, 1.0264, 0.0000> <-0.1516, 0.8908, 0.0000>
		<0.0679, 1.3484, 0.0000> <-0.0270, 1.2345, 0.0000> <-0.0448, 1.0609, 0.0000> <-0.1397, 0.9470, 0.0000>
		<0.1857, 1.3688, 0.0000> <0.0908, 1.2549, 0.0000> <-0.0358, 1.1030, 0.0000> <-0.1307, 0.9891, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2068, 1.3007, 0.0000> <-0.1840, 1.2072, 0.0000> <-0.1535, 1.0826, 0.0000> <-0.1307, 0.9891, 0.0000>
		<-0.2068, 1.3007, 0.0000> <-0.1728, 1.0714, 0.0000> <-0.1625, 1.0405, 0.0000> <-0.1397, 0.9470, 0.0000>
		<-0.2068, 1.3007, 0.0000> <-0.1728, 1.0714, 0.0000> <-0.1655, 1.0264, 0.0000> <-0.1516, 0.8908, 0.0000>
		<-0.2068, 1.3007, 0.0000> <-0.1957, 1.1648, 0.0000> <-0.1745, 0.9843, 0.0000> <-0.1606, 0.8487, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2068, 1.3007, 0.0000> <-0.1840, 1.2072, 0.0000> <-0.1535, 1.0826, 0.0000> <-0.1307, 0.9891, 0.0000>
		<-0.2068, 1.3007, 0.0000> <-0.0662, 1.2277, 0.0000> <-0.0586, 1.1965, 0.0000> <-0.0358, 1.1030, 0.0000>
		<-0.2068, 1.3007, 0.0000> <-0.0662, 1.2277, 0.0000> <-0.0270, 1.2345, 0.0000> <0.0908, 1.2549, 0.0000>
		<-0.2068, 1.3007, 0.0000> <-0.0891, 1.3211, 0.0000> <0.0679, 1.3484, 0.0000> <0.1857, 1.3688, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1886, 1.3023, 0.0000> <0.0838, 1.1662, 0.0000> <-0.0558, 0.9848, 0.0000> <-0.1606, 0.8487, 0.0000>
		<0.1886, 1.3023, 0.0000> <0.0624, 1.0335, 0.0000> <0.0275, 0.9881, 0.0000> <-0.0772, 0.8521, 0.0000>
		<0.1886, 1.3023, 0.0000> <0.0624, 1.0335, 0.0000> <0.0888, 0.9792, 0.0000> <0.0339, 0.8565, 0.0000>
		<0.1886, 1.3023, 0.0000> <0.1672, 1.1695, 0.0000> <0.1722, 0.9826, 0.0000> <0.1173, 0.8599, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1886, 1.3023, 0.0000> <0.0928, 1.2083, 0.0000> <-0.0349, 1.0831, 0.0000> <-0.1307, 0.9891, 0.0000>
		<0.1672, 1.1695, 0.0000> <0.0714, 1.0756, 0.0000> <-0.0439, 1.0409, 0.0000> <-0.1397, 0.9470, 0.0000>
		<0.1722, 0.9826, 0.0000> <0.0888, 0.9792, 0.0000> <-0.0683, 0.8942, 0.0000> <-0.1516, 0.8908, 0.0000>
		<0.1173, 0.8599, 0.0000> <0.0339, 0.8565, 0.0000> <-0.0772, 0.8521, 0.0000> <-0.1606, 0.8487, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1886, 1.3023, 0.0000> <0.0838, 1.1662, 0.0000> <-0.0558, 0.9848, 0.0000> <-0.1606, 0.8487, 0.0000>
		<0.1886, 1.3023, 0.0000> <-0.0119, 1.0723, 0.0000> <-0.0469, 1.0269, 0.0000> <-0.1516, 0.8908, 0.0000>
		<0.1886, 1.3023, 0.0000> <-0.0119, 1.0723, 0.0000> <-0.0439, 1.0409, 0.0000> <-0.1397, 0.9470, 0.0000>
		<0.1886, 1.3023, 0.0000> <0.0928, 1.2083, 0.0000> <-0.0349, 1.0831, 0.0000> <-0.1307, 0.9891, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2565, 2.9019, 0.0000> <0.1949, 2.8216, 0.0000> <0.1279, 2.6999, 0.0000> <0.0509, 2.6341, 0.0000>
		<0.2565, 2.9019, 0.0000> <0.1814, 2.6757, 0.0000> <0.1607, 2.6253, 0.0000> <0.0836, 2.5596, 0.0000>
		<0.2565, 2.9019, 0.0000> <0.1814, 2.6757, 0.0000> <0.1769, 2.6271, 0.0000> <0.1634, 2.4812, 0.0000>
		<0.2565, 2.9019, 0.0000> <0.2431, 2.7560, 0.0000> <0.2251, 2.5615, 0.0000> <0.2117, 2.4156, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2565, 2.9019, 0.0000> <0.2009, 2.8521, 0.0000> <0.1312, 2.7803, 0.0000> <0.0712, 2.7358, 0.0000>
		<0.2431, 2.7560, 0.0000> <0.1875, 2.7062, 0.0000> <0.1251, 2.7498, 0.0000> <0.0651, 2.7053, 0.0000>
		<0.2251, 2.5615, 0.0000> <0.1769, 2.6271, 0.0000> <0.0711, 2.5881, 0.0000> <0.0384, 2.6626, 0.0000>
		<0.2117, 2.4156, 0.0000> <0.1634, 2.4812, 0.0000> <0.0836, 2.5596, 0.0000> <0.0509, 2.6341, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2565, 2.9019, 0.0000> <0.1949, 2.8216, 0.0000> <0.1279, 2.6999, 0.0000> <0.0509, 2.6341, 0.0000>
		<0.2565, 2.9019, 0.0000> <0.1392, 2.7717, 0.0000> <0.1155, 2.7284, 0.0000> <0.0384, 2.6626, 0.0000>
		<0.2565, 2.9019, 0.0000> <0.1392, 2.7717, 0.0000> <0.1251, 2.7498, 0.0000> <0.0651, 2.7053, 0.0000>
		<0.2565, 2.9019, 0.0000> <0.2009, 2.8521, 0.0000> <0.1312, 2.7803, 0.0000> <0.0712, 2.7358, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1482, 2.5566, 0.0000> <-0.1189, 2.7231, 0.0000> <-0.0800, 2.9450, 0.0000> <-0.0508, 3.1115, 0.0000>
		<-0.1482, 2.5566, 0.0000> <-0.1025, 2.7488, 0.0000> <-0.0928, 2.8042, 0.0000> <-0.0635, 2.9707, 0.0000>
		<-0.1482, 2.5566, 0.0000> <-0.1025, 2.7488, 0.0000> <-0.0970, 2.7573, 0.0000> <-0.0806, 2.7830, 0.0000>
		<-0.1482, 2.5566, 0.0000> <-0.1317, 2.5823, 0.0000> <-0.1098, 2.6166, 0.0000> <-0.0933, 2.6422, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1482, 2.5566, 0.0000> <-0.0884, 2.5799, 0.0000> <0.0021, 2.5925, 0.0000> <0.0509, 2.6341, 0.0000>
		<-0.1317, 2.5823, 0.0000> <-0.0720, 2.6056, 0.0000> <-0.0103, 2.6210, 0.0000> <0.0384, 2.6626, 0.0000>
		<-0.1098, 2.6166, 0.0000> <-0.0604, 2.6446, 0.0000> <0.0195, 2.6714, 0.0000> <0.0651, 2.7053, 0.0000>
		<-0.0933, 2.6422, 0.0000> <-0.0440, 2.6703, 0.0000> <0.0256, 2.7019, 0.0000> <0.0712, 2.7358, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0508, 3.1115, 0.0000> <-0.0330, 3.1721, 0.0000> <-0.0093, 3.2529, 0.0000> <0.0085, 3.3135, 0.0000>
		<-0.0508, 3.1115, 0.0000> <0.0043, 3.1547, 0.0000> <0.0102, 3.1749, 0.0000> <0.0280, 3.2355, 0.0000>
		<-0.0508, 3.1115, 0.0000> <0.0043, 3.1547, 0.0000> <0.0167, 3.1489, 0.0000> <0.0539, 3.1314, 0.0000>
		<-0.0508, 3.1115, 0.0000> <-0.0135, 3.0941, 0.0000> <0.0361, 3.0708, 0.0000> <0.0734, 3.0534, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0508, 3.1115, 0.0000> <-0.0135, 3.0941, 0.0000> <0.0361, 3.0708, 0.0000> <0.0734, 3.0534, 0.0000>
		<-0.0330, 3.1721, 0.0000> <0.0043, 3.1547, 0.0000> <0.1118, 3.1419, 0.0000> <0.1490, 3.1245, 0.0000>
		<-0.0093, 3.2529, 0.0000> <0.0858, 3.2460, 0.0000> <0.1548, 3.2263, 0.0000> <0.2499, 3.2194, 0.0000>
		<0.0085, 3.3135, 0.0000> <0.1036, 3.3066, 0.0000> <0.2304, 3.2974, 0.0000> <0.3256, 3.2905, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0508, 3.1115, 0.0000> <-0.0135, 3.0941, 0.0000> <0.0361, 3.0708, 0.0000> <0.0734, 3.0534, 0.0000>
		<-0.0635, 2.9707, 0.0000> <-0.0263, 2.9533, 0.0000> <0.0380, 2.9880, 0.0000> <0.0752, 2.9706, 0.0000>
		<-0.0806, 2.7830, 0.0000> <-0.0287, 2.8235, 0.0000> <0.0258, 2.8196, 0.0000> <0.0777, 2.8602, 0.0000>
		<-0.0933, 2.6422, 0.0000> <-0.0415, 2.6828, 0.0000> <0.0277, 2.7368, 0.0000> <0.0795, 2.7773, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2566, 2.9617, 0.0000> <0.2555, 3.0072, 0.0000> <0.2437, 3.0688, 0.0000> <0.2530, 3.1133, 0.0000>
		<0.2016, 2.9892, 0.0000> <0.2005, 3.0347, 0.0000> <0.2555, 3.1250, 0.0000> <0.2648, 3.1695, 0.0000>
		<0.1283, 3.0259, 0.0000> <0.2040, 3.0970, 0.0000> <0.2281, 3.1662, 0.0000> <0.3038, 3.2373, 0.0000>
		<0.0734, 3.0534, 0.0000> <0.1490, 3.1245, 0.0000> <0.2499, 3.2194, 0.0000> <0.3256, 3.2905, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2566, 2.9617, 0.0000> <0.2016, 2.9892, 0.0000> <0.1283, 3.0259, 0.0000> <0.0734, 3.0534, 0.0000>
		<0.2566, 2.9617, 0.0000> <0.2005, 3.0347, 0.0000> <0.1822, 3.0439, 0.0000> <0.1273, 3.0714, 0.0000>
		<0.2566, 2.9617, 0.0000> <0.2005, 3.0347, 0.0000> <0.1898, 3.0508, 0.0000> <0.1991, 3.0953, 0.0000>
		<0.2566, 2.9617, 0.0000> <0.2555, 3.0072, 0.0000> <0.2437, 3.0688, 0.0000> <0.2530, 3.1133, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2566, 2.9617, 0.0000> <0.2035, 2.9064, 0.0000> <0.1326, 2.8327, 0.0000> <0.0795, 2.7773, 0.0000>
		<0.2555, 3.0072, 0.0000> <0.2024, 2.9519, 0.0000> <0.1308, 2.9155, 0.0000> <0.0777, 2.8602, 0.0000>
		<0.2437, 3.0688, 0.0000> <0.1898, 3.0508, 0.0000> <0.1291, 2.9886, 0.0000> <0.0752, 2.9706, 0.0000>
		<0.2530, 3.1133, 0.0000> <0.1991, 3.0953, 0.0000> <0.1273, 3.0714, 0.0000> <0.0734, 3.0534, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2566, 2.9617, 0.0000> <0.2035, 2.9064, 0.0000> <0.1326, 2.8327, 0.0000> <0.0795, 2.7773, 0.0000>
		<0.2566, 2.9617, 0.0000> <0.1485, 2.9339, 0.0000> <0.1308, 2.9155, 0.0000> <0.0777, 2.8602, 0.0000>
		<0.2566, 2.9617, 0.0000> <0.1485, 2.9339, 0.0000> <0.1302, 2.9431, 0.0000> <0.0752, 2.9706, 0.0000>
		<0.2566, 2.9617, 0.0000> <0.2016, 2.9892, 0.0000> <0.1283, 3.0259, 0.0000> <0.0734, 3.0534, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3256, 3.2905, 0.0000> <0.2499, 3.2194, 0.0000> <0.1490, 3.1245, 0.0000> <0.0734, 3.0534, 0.0000>
		<0.3256, 3.2905, 0.0000> <0.2281, 3.1662, 0.0000> <0.2029, 3.1425, 0.0000> <0.1273, 3.0714, 0.0000>
		<0.3256, 3.2905, 0.0000> <0.2281, 3.1662, 0.0000> <0.2109, 3.1515, 0.0000> <0.1991, 3.0953, 0.0000>
		<0.3256, 3.2905, 0.0000> <0.3038, 3.2373, 0.0000> <0.2648, 3.1695, 0.0000> <0.2530, 3.1133, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3256, 3.2905, 0.0000> <0.2304, 3.2974, 0.0000> <0.1036, 3.3066, 0.0000> <0.0085, 3.3135, 0.0000>
		<0.3038, 3.2373, 0.0000> <0.2087, 3.2442, 0.0000> <0.1231, 3.2286, 0.0000> <0.0280, 3.2355, 0.0000>
		<0.2648, 3.1695, 0.0000> <0.2109, 3.1515, 0.0000> <0.1078, 3.1494, 0.0000> <0.0539, 3.1314, 0.0000>
		<0.2530, 3.1133, 0.0000> <0.1991, 3.0953, 0.0000> <0.1273, 3.0714, 0.0000> <0.0734, 3.0534, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3256, 3.2905, 0.0000> <0.2499, 3.2194, 0.0000> <0.1490, 3.1245, 0.0000> <0.0734, 3.0534, 0.0000>
		<0.3256, 3.2905, 0.0000> <0.1548, 3.2263, 0.0000> <0.1296, 3.2026, 0.0000> <0.0539, 3.1314, 0.0000>
		<0.3256, 3.2905, 0.0000> <0.1548, 3.2263, 0.0000> <0.1231, 3.2286, 0.0000> <0.0280, 3.2355, 0.0000>
		<0.3256, 3.2905, 0.0000> <0.2304, 3.2974, 0.0000> <0.1036, 3.3066, 0.0000> <0.0085, 3.3135, 0.0000>
	}
	
    texture{      
	    pigment{
	        gradient y
	        color_map{
	            [0.0 0.6 color rgb <0.96, 0.94, 0.92> color rgb <0.96, 0.94, 0.92>] 
	            [0.6 0.8 color rgb <0.96, 0.94, 0.92> color rgb <0.26, 0.24, 0.22>]
	            [0.8 1.0 color rgb <0.26, 0.24, 0.22> color rgb <0.26, 0.24, 0.22>]
	        }
	        rotate -z*30
	        turbulence 0.3
	        scale 2      
	        translate y*1.65
	    }
		finish{ambient 0 diffuse 0.8 phong 0.1}
		normal{
		    onion
		    slope_map {
                [0 <0.5, 0.5>]   
                [0.2 <1, 0>]   
                [0.8  <1, 0>]   
                [1    <0.5, -0.5>]   
            } 
            turbulence 0.03           
            frequency 25
            scale <0.3, 1, 0.1>
            translate <-1, 15, 0>
		}  
	}
}

#declare Left = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4394, 0.9192, 0.0000> <-0.5030, 1.0400, 0.0000> <-0.4912, 1.2335, 0.0000> <-0.5142, 1.3681, 0.0000>
		<-0.3600, 0.9376, 0.0000> <-0.4236, 1.0584, 0.0000> <-0.3993, 1.2128, 0.0000> <-0.4222, 1.3474, 0.0000>
		<-0.2542, 0.9622, 0.0000> <-0.2664, 1.0574, 0.0000> <-0.2918, 1.2241, 0.0000> <-0.2996, 1.3198, 0.0000>
		<-0.1748, 0.9806, 0.0000> <-0.1870, 1.0759, 0.0000> <-0.1998, 1.2034, 0.0000> <-0.2076, 1.2991, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4394, 0.9192, 0.0000> <-0.3600, 0.9376, 0.0000> <-0.2542, 0.9622, 0.0000> <-0.1748, 0.9806, 0.0000>
		<-0.4394, 0.9192, 0.0000> <-0.2988, 0.8215, 0.0000> <-0.2402, 0.8537, 0.0000> <-0.1608, 0.8721, 0.0000>
		<-0.4394, 0.9192, 0.0000> <-0.2988, 0.8215, 0.0000> <-0.2323, 0.8179, 0.0000> <-0.1365, 0.7282, 0.0000>
		<-0.4394, 0.9192, 0.0000> <-0.3782, 0.8030, 0.0000> <-0.2159, 0.7097, 0.0000> <-0.1201, 0.6200, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5142, 1.3681, 0.0000> <-0.5249, 1.4310, 0.0000> <-0.5452, 1.5141, 0.0000> <-0.5515, 1.5777, 0.0000>
		<-0.4222, 1.3474, 0.0000> <-0.4329, 1.4103, 0.0000> <-0.4452, 1.4940, 0.0000> <-0.4515, 1.5575, 0.0000>
		<-0.2996, 1.3198, 0.0000> <-0.3048, 1.3831, 0.0000> <-0.3168, 1.4671, 0.0000> <-0.3181, 1.5306, 0.0000>
		<-0.2076, 1.2991, 0.0000> <-0.2128, 1.3624, 0.0000> <-0.2168, 1.4470, 0.0000> <-0.2181, 1.5105, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5515, 1.5777, 0.0000> <-0.5632, 1.6940, 0.0000> <-0.5841, 1.8502, 0.0000> <-0.5740, 1.9666, 0.0000>
		<-0.4515, 1.5575, 0.0000> <-0.4631, 1.6738, 0.0000> <-0.4780, 1.8366, 0.0000> <-0.4679, 1.9530, 0.0000>
		<-0.3181, 1.5306, 0.0000> <-0.3207, 1.6538, 0.0000> <-0.3305, 1.8117, 0.0000> <-0.3264, 1.9348, 0.0000>
		<-0.2181, 1.5105, 0.0000> <-0.2206, 1.6337, 0.0000> <-0.2244, 1.7981, 0.0000> <-0.2203, 1.9212, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5740, 1.9666, 0.0000> <-0.5615, 2.1105, 0.0000> <-0.4997, 2.2955, 0.0000> <-0.4767, 2.4380, 0.0000>
		<-0.4679, 1.9530, 0.0000> <-0.4554, 2.0969, 0.0000> <-0.4143, 2.2538, 0.0000> <-0.3913, 2.3963, 0.0000>
		<-0.3264, 1.9348, 0.0000> <-0.3227, 2.0484, 0.0000> <-0.2886, 2.2276, 0.0000> <-0.2773, 2.3407, 0.0000>
		<-0.2203, 1.9212, 0.0000> <-0.2166, 2.0348, 0.0000> <-0.2031, 2.1859, 0.0000> <-0.1919, 2.2989, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4767, 2.4380, 0.0000> <-0.4638, 2.5181, 0.0000> <-0.4687, 2.6276, 0.0000> <-0.4543, 2.7074, 0.0000>
		<-0.3913, 2.3963, 0.0000> <-0.3783, 2.4764, 0.0000> <-0.3797, 2.5804, 0.0000> <-0.3653, 2.6602, 0.0000>
		<-0.2773, 2.3407, 0.0000> <-0.2698, 2.4163, 0.0000> <-0.2578, 2.5220, 0.0000> <-0.2468, 2.5972, 0.0000>
		<-0.1919, 2.2989, 0.0000> <-0.1844, 2.3746, 0.0000> <-0.1689, 2.4748, 0.0000> <-0.1579, 2.5500, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3794, 2.9768, 0.0000> <-0.3524, 3.0650, 0.0000> <-0.3083, 3.1801, 0.0000> <-0.2821, 3.2686, 0.0000>
		<-0.3071, 2.8833, 0.0000> <-0.2801, 2.9715, 0.0000> <-0.2386, 3.1329, 0.0000> <-0.2125, 3.2214, 0.0000>
		<-0.2107, 2.7587, 0.0000> <-0.1849, 2.8927, 0.0000> <-0.1494, 3.0254, 0.0000> <-0.1196, 3.1585, 0.0000>
		<-0.1384, 2.6652, 0.0000> <-0.1126, 2.7992, 0.0000> <-0.0797, 2.9782, 0.0000> <-0.0499, 3.1113, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3794, 2.9768, 0.0000> <-0.3071, 2.8833, 0.0000> <-0.2107, 2.7587, 0.0000> <-0.1384, 2.6652, 0.0000>
		<-0.4040, 2.8966, 0.0000> <-0.3317, 2.8031, 0.0000> <-0.2173, 2.7242, 0.0000> <-0.1450, 2.6308, 0.0000>
		<-0.4394, 2.7899, 0.0000> <-0.3504, 2.7427, 0.0000> <-0.2417, 2.6319, 0.0000> <-0.1528, 2.5847, 0.0000>
		<-0.4543, 2.7074, 0.0000> <-0.3653, 2.6602, 0.0000> <-0.2468, 2.5972, 0.0000> <-0.1579, 2.5500, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0801, 3.7175, 0.0000> <-0.0270, 3.6912, 0.0000> <0.0439, 3.6561, 0.0000> <0.0971, 3.6298, 0.0000>
		<-0.1512, 3.6492, 0.0000> <-0.0980, 3.6229, 0.0000> <0.0168, 3.5619, 0.0000> <0.0700, 3.5356, 0.0000>
		<-0.2043, 3.5231, 0.0000> <-0.1287, 3.4878, 0.0000> <-0.0415, 3.4452, 0.0000> <0.0341, 3.4099, 0.0000>
		<-0.2448, 3.4332, 0.0000> <-0.1691, 3.3979, 0.0000> <-0.0683, 3.3509, 0.0000> <0.0073, 3.3156, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0801, 3.7175, 0.0000> <-0.0260, 3.7696, 0.0000> <0.0817, 3.7850, 0.0000> <0.1510, 3.8139, 0.0000>
		<-0.0801, 3.7175, 0.0000> <0.0272, 3.7433, 0.0000> <0.0655, 3.7298, 0.0000> <0.1348, 3.7587, 0.0000>
		<-0.0801, 3.7175, 0.0000> <0.0272, 3.7433, 0.0000> <0.0599, 3.7114, 0.0000> <0.1131, 3.6851, 0.0000>
		<-0.0801, 3.7175, 0.0000> <-0.0270, 3.6912, 0.0000> <0.0439, 3.6561, 0.0000> <0.0971, 3.6298, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2448, 3.4332, 0.0000> <-0.1691, 3.3979, 0.0000> <-0.0683, 3.3509, 0.0000> <0.0073, 3.3156, 0.0000>
		<-0.2655, 3.3870, 0.0000> <-0.1899, 3.3518, 0.0000> <-0.0856, 3.2896, 0.0000> <-0.0100, 3.2543, 0.0000>
		<-0.2678, 3.3172, 0.0000> <-0.1981, 3.2700, 0.0000> <-0.1057, 3.2206, 0.0000> <-0.0360, 3.1734, 0.0000>
		<-0.2821, 3.2686, 0.0000> <-0.2125, 3.2214, 0.0000> <-0.1196, 3.1585, 0.0000> <-0.0499, 3.1113, 0.0000>
	}
	
	texture{      
	    pigment{
	        gradient y
	        color_map{
	            [0.0 0.6 color rgb <0.96, 0.94, 0.92> color rgb <0.96, 0.94, 0.92>] 
	            [0.6 0.8 color rgb <0.96, 0.94, 0.92> color rgb <0.26, 0.24, 0.22>]
	            [0.8 1.0 color rgb <0.26, 0.24, 0.22> color rgb <0.26, 0.24, 0.22>]
	        }
	        rotate -z*30
	        turbulence 0.3
	        scale 2      
	        translate y*1.65
	    }
		finish{ambient 0 diffuse 0.8 phong 0.1}
		normal{
		    onion
		    slope_map {
                [0 <0.5, 0.5>]   
                [0.2 <1, 0>]   
                [0.8  <1, 0>]   
                [1    <0.5, -0.5>]   
            } 
            turbulence 0.03           
            frequency 20
            scale <0.26, 1, 0.1>
            translate <1.5, 15, 0>
		}  
	}
} 

#declare Fix = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1099, 0.6554, 0.0000> <-0.0972, 0.6567, 0.0000> <-0.0788, 0.6654, 0.0000> <-0.0674, 0.6595, 0.0000>
		<-0.1099, 0.6554, -0.0057> <-0.0972, 0.6567, -0.0057> <-0.0788, 0.6654, -0.0216> <-0.0674, 0.6595, -0.0216>
		<-0.1194, 0.6537, -0.0113> <-0.1192, 0.6527, -0.0207> <-0.1046, 0.6593, -0.0356> <-0.1031, 0.6531, -0.0426>
		<-0.1250, 0.6527, -0.0113> <-0.1248, 0.6517, -0.0207> <-0.1259, 0.6555, -0.0356> <-0.1244, 0.6493, -0.0426>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1099, 0.6554, 0.0000> <-0.1099, 0.6554, 0.0057> <-0.1194, 0.6537, 0.0113> <-0.1250, 0.6527, 0.0113>
		<-0.0972, 0.6567, 0.0000> <-0.0972, 0.6567, 0.0057> <-0.1192, 0.6527, 0.0207> <-0.1248, 0.6517, 0.0207>
		<-0.0788, 0.6654, 0.0000> <-0.0788, 0.6654, 0.0216> <-0.1046, 0.6593, 0.0356> <-0.1259, 0.6555, 0.0356>
		<-0.0674, 0.6595, 0.0000> <-0.0674, 0.6595, 0.0216> <-0.1031, 0.6531, 0.0426> <-0.1244, 0.6493, 0.0426>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0674, 0.6595, 0.0000> <-0.0563, 0.6539, 0.0000> <-0.0474, 0.6358, 0.0000> <-0.0469, 0.6234, 0.0000>
		<-0.0674, 0.6595, -0.0216> <-0.0563, 0.6539, -0.0216> <-0.0474, 0.6358, -0.0271> <-0.0469, 0.6234, -0.0271>
		<-0.1031, 0.6531, -0.0426> <-0.1011, 0.6448, -0.0520> <-0.0904, 0.6277, -0.0595> <-0.0881, 0.6152, -0.0583>
		<-0.1244, 0.6493, -0.0426> <-0.1224, 0.6409, -0.0520> <-0.1172, 0.6235, -0.0595> <-0.1149, 0.6111, -0.0583>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0674, 0.6595, 0.0000> <-0.0674, 0.6595, 0.0216> <-0.1031, 0.6531, 0.0426> <-0.1244, 0.6493, 0.0426>
		<-0.0563, 0.6539, 0.0000> <-0.0563, 0.6539, 0.0216> <-0.1011, 0.6448, 0.0520> <-0.1224, 0.6409, 0.0520>
		<-0.0474, 0.6358, 0.0000> <-0.0474, 0.6358, 0.0271> <-0.0904, 0.6277, 0.0595> <-0.1172, 0.6235, 0.0595>
		<-0.0469, 0.6234, 0.0000> <-0.0469, 0.6234, 0.0271> <-0.0881, 0.6152, 0.0583> <-0.1149, 0.6111, 0.0583>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0469, 0.6234, 0.0000> <-0.0463, 0.6087, 0.0000> <-0.0672, 0.5916, 0.0000> <-0.0638, 0.5773, 0.0000>
		<-0.0469, 0.6234, -0.0271> <-0.0463, 0.6087, -0.0271> <-0.0672, 0.5916, -0.0174> <-0.0638, 0.5773, -0.0174>
		<-0.0881, 0.6152, -0.0583> <-0.0856, 0.6010, -0.0568> <-0.0949, 0.5865, -0.0347> <-0.0927, 0.5721, -0.0345>
		<-0.1149, 0.6111, -0.0583> <-0.1124, 0.5968, -0.0568> <-0.1121, 0.5834, -0.0347> <-0.1099, 0.5690, -0.0345>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0469, 0.6234, 0.0000> <-0.0469, 0.6234, 0.0271> <-0.0881, 0.6152, 0.0583> <-0.1149, 0.6111, 0.0583>
		<-0.0463, 0.6087, 0.0000> <-0.0463, 0.6087, 0.0271> <-0.0856, 0.6010, 0.0568> <-0.1124, 0.5968, 0.0568>
		<-0.0672, 0.5916, 0.0000> <-0.0672, 0.5916, 0.0174> <-0.0949, 0.5865, 0.0347> <-0.1121, 0.5834, 0.0347>
		<-0.0638, 0.5773, 0.0000> <-0.0638, 0.5773, 0.0174> <-0.0927, 0.5721, 0.0345> <-0.1099, 0.5690, 0.0345>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0638, 0.5773, 0.0000> <-0.0597, 0.5596, 0.0000> <-0.0292, 0.5483, 0.0000> <-0.0251, 0.5306, 0.0000>
		<-0.0638, 0.5773, -0.0174> <-0.0597, 0.5596, -0.0174> <-0.0292, 0.5483, -0.0285> <-0.0251, 0.5306, -0.0285>
		<-0.0927, 0.5721, -0.0345> <-0.0901, 0.5551, -0.0341> <-0.0754, 0.5389, -0.0558> <-0.0724, 0.5220, -0.0564>
		<-0.1099, 0.5690, -0.0345> <-0.1073, 0.5520, -0.0341> <-0.1035, 0.5338, -0.0558> <-0.1005, 0.5170, -0.0564>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0638, 0.5773, 0.0000> <-0.0638, 0.5773, 0.0174> <-0.0927, 0.5721, 0.0345> <-0.1099, 0.5690, 0.0345>
		<-0.0597, 0.5596, 0.0000> <-0.0597, 0.5596, 0.0174> <-0.0901, 0.5551, 0.0341> <-0.1073, 0.5520, 0.0341>
		<-0.0292, 0.5483, 0.0000> <-0.0292, 0.5483, 0.0285> <-0.0754, 0.5389, 0.0558> <-0.1035, 0.5338, 0.0558>
		<-0.0251, 0.5306, 0.0000> <-0.0251, 0.5306, 0.0285> <-0.0724, 0.5220, 0.0564> <-0.1005, 0.5170, 0.0564>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0251, 0.5306, 0.0000> <0.0022, 0.4131, 0.0000> <0.0274, 0.2537, 0.0000> <0.0390, 0.1337, 0.0000>
		<-0.0251, 0.5306, -0.0285> <0.0022, 0.4131, -0.0285> <0.0274, 0.2537, -0.0258> <0.0390, 0.1337, -0.0258>
		<-0.0724, 0.5220, -0.0564> <-0.0510, 0.4034, -0.0608> <-0.0251, 0.2444, -0.0583> <-0.0037, 0.1260, -0.0509>
		<-0.1005, 0.5170, -0.0564> <-0.0791, 0.3984, -0.0608> <-0.0504, 0.2399, -0.0583> <-0.0290, 0.1214, -0.0509>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0251, 0.5306, 0.0000> <-0.0251, 0.5306, 0.0285> <-0.0724, 0.5220, 0.0564> <-0.1005, 0.5170, 0.0564>
		<0.0022, 0.4131, 0.0000> <0.0022, 0.4131, 0.0285> <-0.0510, 0.4034, 0.0608> <-0.0791, 0.3984, 0.0608>
		<0.0274, 0.2537, 0.0000> <0.0274, 0.2537, 0.0258> <-0.0251, 0.2444, 0.0583> <-0.0504, 0.2399, 0.0583>
		<0.0390, 0.1337, 0.0000> <0.0390, 0.1337, 0.0258> <-0.0037, 0.1260, 0.0509> <-0.0290, 0.1214, 0.0509>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0390, 0.1337, 0.0000> <0.0407, 0.1165, 0.0000> <0.0149, 0.0968, 0.0000> <0.0184, 0.0798, 0.0000>
		<0.0390, 0.1337, -0.0258> <0.0407, 0.1165, -0.0258> <0.0149, 0.0968, -0.0146> <0.0184, 0.0798, -0.0146>
		<-0.0037, 0.1260, -0.0509> <-0.0008, 0.1101, -0.0500> <-0.0087, 0.0914, -0.0284> <-0.0059, 0.0754, -0.0290>
		<-0.0290, 0.1214, -0.0509> <-0.0262, 0.1055, -0.0500> <-0.0232, 0.0888, -0.0284> <-0.0203, 0.0728, -0.0290>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0390, 0.1337, 0.0000> <0.0390, 0.1337, 0.0258> <-0.0037, 0.1260, 0.0509> <-0.0290, 0.1214, 0.0509>
		<0.0407, 0.1165, 0.0000> <0.0407, 0.1165, 0.0258> <-0.0008, 0.1101, 0.0500> <-0.0262, 0.1055, 0.0500>
		<0.0149, 0.0968, 0.0000> <0.0149, 0.0968, 0.0146> <-0.0091, 0.0913, 0.0284> <-0.0235, 0.0887, 0.0284>
		<0.0184, 0.0798, 0.0000> <0.0184, 0.0798, 0.0146> <-0.0059, 0.0754, 0.0290> <-0.0203, 0.0728, 0.0290>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0184, 0.0798, 0.0000> <0.0218, 0.0633, 0.0000> <0.0518, 0.0559, 0.0000> <0.0584, 0.0404, 0.0000>
		<0.0184, 0.0798, -0.0146> <0.0218, 0.0633, -0.0146> <0.0512, 0.0558, -0.0271> <0.0578, 0.0403, -0.0271>
		<-0.0059, 0.0754, -0.0290> <-0.0027, 0.0581, -0.0296> <0.0126, 0.0434, -0.0517> <0.0157, 0.0263, -0.0546>
		<-0.0203, 0.0728, -0.0290> <-0.0171, 0.0555, -0.0296> <-0.0140, 0.0379, -0.0517> <-0.0109, 0.0208, -0.0546>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0184, 0.0798, 0.0000> <0.0184, 0.0798, 0.0146> <-0.0059, 0.0754, 0.0290> <-0.0203, 0.0728, 0.0290>
		<0.0218, 0.0633, 0.0000> <0.0218, 0.0633, 0.0146> <-0.0023, 0.0582, 0.0296> <-0.0167, 0.0555, 0.0296>
		<0.0518, 0.0559, 0.0000> <0.0524, 0.0560, 0.0265> <0.0144, 0.0437, 0.0517> <-0.0115, 0.0384, 0.0517>
		<0.0584, 0.0404, 0.0000> <0.0590, 0.0406, 0.0265> <0.0175, 0.0266, 0.0546> <-0.0084, 0.0212, 0.0546>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0584, 0.0404, 0.0000> <0.0635, 0.0283, 0.0000> <0.0632, 0.0057, 0.0000> <0.0536, -0.0034, 0.0000>
		<0.0578, 0.0403, -0.0271> <0.0629, 0.0282, -0.0271> <0.0632, 0.0057, -0.0221> <0.0536, -0.0034, -0.0221>
		<0.0157, 0.0263, -0.0546> <0.0176, 0.0155, -0.0564> <0.0159, -0.0036, -0.0526> <0.0171, -0.0100, -0.0436>
		<-0.0109, 0.0208, -0.0546> <-0.0089, 0.0100, -0.0564> <-0.0058, -0.0075, -0.0526> <-0.0046, -0.0139, -0.0436>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0584, 0.0404, 0.0000> <0.0590, 0.0406, 0.0265> <0.0175, 0.0266, 0.0546> <-0.0084, 0.0212, 0.0546>
		<0.0635, 0.0283, 0.0000> <0.0641, 0.0284, 0.0265> <0.0195, 0.0158, 0.0564> <-0.0065, 0.0104, 0.0564>
		<0.0632, 0.0057, 0.0000> <0.0632, 0.0057, 0.0221> <0.0163, -0.0035, 0.0526> <-0.0054, -0.0074, 0.0526>
		<0.0536, -0.0034, 0.0000> <0.0536, -0.0034, 0.0221> <0.0171, -0.0100, 0.0436> <-0.0046, -0.0139, 0.0436>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0536, -0.0034, 0.0000> <0.0412, -0.0153, 0.0000> <0.0147, -0.0129, 0.0000> <-0.0020, -0.0170, 0.0000>
		<0.0536, -0.0034, -0.0221> <0.0412, -0.0153, -0.0221> <0.0147, -0.0129, -0.0007> <-0.0020, -0.0170, -0.0007>
		<0.0171, -0.0100, -0.0436> <0.0184, -0.0174, -0.0334> <-0.0034, -0.0162, -0.0141> <-0.0033, -0.0173, -0.0015>
		<-0.0046, -0.0139, -0.0436> <-0.0033, -0.0213, -0.0334> <-0.0042, -0.0163, -0.0141> <-0.0040, -0.0174, -0.0015>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0536, -0.0034, 0.0000> <0.0536, -0.0034, 0.0221> <0.0171, -0.0100, 0.0436> <-0.0046, -0.0139, 0.0436>
		<0.0412, -0.0153, 0.0000> <0.0412, -0.0153, 0.0221> <0.0180, -0.0174, 0.0334> <-0.0038, -0.0214, 0.0334>
		<0.0147, -0.0129, 0.0000> <0.0147, -0.0129, 0.0007> <-0.0034, -0.0162, 0.0141> <-0.0042, -0.0163, 0.0141>
		<-0.0020, -0.0170, 0.0000> <-0.0020, -0.0170, 0.0007> <-0.0033, -0.0173, 0.0015> <-0.0040, -0.0174, 0.0015>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1250, 0.6527, 0.0113> <-0.1306, 0.6517, 0.0113> <-0.1400, 0.6500, 0.0057> <-0.1400, 0.6500, 0.0000>
		<-0.1248, 0.6517, 0.0207> <-0.1304, 0.6507, 0.0207> <-0.1524, 0.6467, 0.0057> <-0.1524, 0.6467, 0.0000>
		<-0.1259, 0.6555, 0.0356> <-0.1471, 0.6516, 0.0356> <-0.1723, 0.6481, 0.0216> <-0.1723, 0.6481, 0.0000>
		<-0.1244, 0.6493, 0.0426> <-0.1456, 0.6454, 0.0426> <-0.1813, 0.6390, 0.0216> <-0.1813, 0.6390, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1400, 0.6500, 0.0000> <-0.1400, 0.6500, -0.0057> <-0.1306, 0.6517, -0.0113> <-0.1250, 0.6527, -0.0113>
		<-0.1524, 0.6467, 0.0000> <-0.1524, 0.6467, -0.0057> <-0.1304, 0.6507, -0.0207> <-0.1248, 0.6517, -0.0207>
		<-0.1723, 0.6481, 0.0000> <-0.1723, 0.6481, -0.0216> <-0.1471, 0.6516, -0.0356> <-0.1259, 0.6555, -0.0356>
		<-0.1813, 0.6390, 0.0000> <-0.1813, 0.6390, -0.0216> <-0.1456, 0.6454, -0.0426> <-0.1244, 0.6493, -0.0426>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1244, 0.6493, 0.0426> <-0.1456, 0.6454, 0.0426> <-0.1813, 0.6390, 0.0216> <-0.1813, 0.6390, 0.0000>
		<-0.1224, 0.6409, 0.0520> <-0.1436, 0.6371, 0.0520> <-0.1894, 0.6308, 0.0216> <-0.1894, 0.6308, 0.0000>
		<-0.1172, 0.6235, 0.0595> <-0.1452, 0.6192, 0.0595> <-0.1921, 0.6123, 0.0283> <-0.1921, 0.6123, 0.0000>
		<-0.1149, 0.6111, 0.0583> <-0.1429, 0.6067, 0.0583> <-0.1885, 0.6014, 0.0283> <-0.1885, 0.6014, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1813, 0.6390, 0.0000> <-0.1813, 0.6390, -0.0216> <-0.1456, 0.6454, -0.0426> <-0.1244, 0.6493, -0.0426>
		<-0.1894, 0.6308, 0.0000> <-0.1894, 0.6308, -0.0216> <-0.1436, 0.6371, -0.0520> <-0.1224, 0.6409, -0.0520>
		<-0.1921, 0.6123, 0.0000> <-0.1921, 0.6123, -0.0283> <-0.1452, 0.6192, -0.0595> <-0.1172, 0.6235, -0.0595>
		<-0.1885, 0.6014, 0.0000> <-0.1885, 0.6014, -0.0283> <-0.1429, 0.6067, -0.0583> <-0.1149, 0.6111, -0.0583>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1149, 0.6111, 0.0583> <-0.1429, 0.6067, 0.0583> <-0.1885, 0.6014, 0.0283> <-0.1885, 0.6014, 0.0000>
		<-0.1124, 0.5968, 0.0568> <-0.1403, 0.5924, 0.0568> <-0.1837, 0.5865, 0.0283> <-0.1837, 0.5865, 0.0000>
		<-0.1121, 0.5834, 0.0347> <-0.1292, 0.5803, 0.0347> <-0.1587, 0.5761, 0.0174> <-0.1587, 0.5761, 0.0000>
		<-0.1099, 0.5690, 0.0345> <-0.1270, 0.5659, 0.0345> <-0.1559, 0.5607, 0.0174> <-0.1559, 0.5607, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1885, 0.6014, 0.0000> <-0.1885, 0.6014, -0.0283> <-0.1429, 0.6067, -0.0583> <-0.1149, 0.6111, -0.0583>
		<-0.1837, 0.5865, 0.0000> <-0.1837, 0.5865, -0.0283> <-0.1403, 0.5924, -0.0568> <-0.1124, 0.5968, -0.0568>
		<-0.1587, 0.5761, 0.0000> <-0.1587, 0.5761, -0.0174> <-0.1292, 0.5803, -0.0347> <-0.1121, 0.5834, -0.0347>
		<-0.1559, 0.5607, 0.0000> <-0.1559, 0.5607, -0.0174> <-0.1270, 0.5659, -0.0345> <-0.1099, 0.5690, -0.0345>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1099, 0.5690, 0.0345> <-0.1270, 0.5659, 0.0345> <-0.1559, 0.5607, 0.0174> <-0.1559, 0.5607, 0.0000>
		<-0.1073, 0.5520, 0.0341> <-0.1244, 0.5489, 0.0341> <-0.1528, 0.5434, 0.0174> <-0.1528, 0.5434, 0.0000>
		<-0.1035, 0.5338, 0.0558> <-0.1304, 0.5290, 0.0558> <-0.1732, 0.5216, 0.0274> <-0.1732, 0.5216, 0.0000>
		<-0.1005, 0.5170, 0.0564> <-0.1274, 0.5121, 0.0564> <-0.1710, 0.5042, 0.0274> <-0.1710, 0.5042, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1559, 0.5607, 0.0000> <-0.1559, 0.5607, -0.0174> <-0.1270, 0.5659, -0.0345> <-0.1099, 0.5690, -0.0345>
		<-0.1528, 0.5434, 0.0000> <-0.1528, 0.5434, -0.0174> <-0.1244, 0.5489, -0.0341> <-0.1073, 0.5520, -0.0341>
		<-0.1732, 0.5216, 0.0000> <-0.1732, 0.5216, -0.0274> <-0.1304, 0.5290, -0.0558> <-0.1035, 0.5338, -0.0558>
		<-0.1710, 0.5042, 0.0000> <-0.1710, 0.5042, -0.0274> <-0.1274, 0.5121, -0.0564> <-0.1005, 0.5170, -0.0564>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1005, 0.5170, 0.0564> <-0.1274, 0.5121, 0.0564> <-0.1710, 0.5042, 0.0274> <-0.1710, 0.5042, 0.0000>
		<-0.0791, 0.3984, 0.0608> <-0.1060, 0.3935, 0.0608> <-0.1554, 0.3846, 0.0274> <-0.1554, 0.3846, 0.0000>
		<-0.0504, 0.2399, 0.0583> <-0.0758, 0.2353, 0.0583> <-0.1269, 0.2259, 0.0258> <-0.1269, 0.2259, 0.0000>
		<-0.0290, 0.1214, 0.0509> <-0.0544, 0.1168, 0.0509> <-0.0971, 0.1091, 0.0258> <-0.0971, 0.1091, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1710, 0.5042, 0.0000> <-0.1710, 0.5042, -0.0274> <-0.1274, 0.5121, -0.0564> <-0.1005, 0.5170, -0.0564>
		<-0.1554, 0.3846, 0.0000> <-0.1554, 0.3846, -0.0274> <-0.1060, 0.3935, -0.0608> <-0.0791, 0.3984, -0.0608>
		<-0.1269, 0.2259, 0.0000> <-0.1269, 0.2259, -0.0258> <-0.0758, 0.2353, -0.0583> <-0.0504, 0.2399, -0.0583>
		<-0.0971, 0.1091, 0.0000> <-0.0971, 0.1091, -0.0258> <-0.0544, 0.1168, -0.0509> <-0.0290, 0.1214, -0.0509>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0290, 0.1214, 0.0509> <-0.0544, 0.1168, 0.0509> <-0.0971, 0.1091, 0.0258> <-0.0971, 0.1091, 0.0000>
		<-0.0262, 0.1055, 0.0500> <-0.0515, 0.1009, 0.0500> <-0.0928, 0.0923, 0.0258> <-0.0928, 0.0923, 0.0000>
		<-0.0235, 0.0887, 0.0284> <-0.0380, 0.0861, 0.0284> <-0.0620, 0.0829, 0.0146> <-0.0620, 0.0829, 0.0000>
		<-0.0203, 0.0728, 0.0290> <-0.0347, 0.0702, 0.0290> <-0.0590, 0.0658, 0.0146> <-0.0590, 0.0658, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0971, 0.1091, 0.0000> <-0.0971, 0.1091, -0.0258> <-0.0544, 0.1168, -0.0509> <-0.0290, 0.1214, -0.0509>
		<-0.0928, 0.0923, 0.0000> <-0.0928, 0.0923, -0.0258> <-0.0515, 0.1009, -0.0500> <-0.0262, 0.1055, -0.0500>
		<-0.0620, 0.0829, 0.0000> <-0.0620, 0.0829, -0.0146> <-0.0376, 0.0862, -0.0284> <-0.0232, 0.0888, -0.0284>
		<-0.0590, 0.0658, 0.0000> <-0.0590, 0.0658, -0.0146> <-0.0347, 0.0702, -0.0290> <-0.0203, 0.0728, -0.0290>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0203, 0.0728, 0.0290> <-0.0347, 0.0702, 0.0290> <-0.0590, 0.0658, 0.0146> <-0.0590, 0.0658, 0.0000>
		<-0.0167, 0.0555, 0.0296> <-0.0311, 0.0529, 0.0296> <-0.0559, 0.0488, 0.0146> <-0.0559, 0.0488, 0.0000>
		<-0.0115, 0.0384, 0.0517> <-0.0380, 0.0329, 0.0517> <-0.0782, 0.0294, 0.0270> <-0.0788, 0.0293, 0.0000>
		<-0.0084, 0.0212, 0.0546> <-0.0349, 0.0158, 0.0546> <-0.0789, 0.0121, 0.0270> <-0.0796, 0.0120, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0590, 0.0658, 0.0000> <-0.0590, 0.0658, -0.0146> <-0.0347, 0.0702, -0.0290> <-0.0203, 0.0728, -0.0290>
		<-0.0559, 0.0488, 0.0000> <-0.0559, 0.0488, -0.0146> <-0.0316, 0.0529, -0.0296> <-0.0171, 0.0555, -0.0296>
		<-0.0788, 0.0293, 0.0000> <-0.0794, 0.0291, -0.0264> <-0.0399, 0.0325, -0.0517> <-0.0140, 0.0379, -0.0517>
		<-0.0796, 0.0120, 0.0000> <-0.0801, 0.0119, -0.0264> <-0.0368, 0.0154, -0.0546> <-0.0109, 0.0208, -0.0546>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0084, 0.0212, 0.0546> <-0.0349, 0.0158, 0.0546> <-0.0789, 0.0121, 0.0270> <-0.0796, 0.0120, 0.0000>
		<-0.0065, 0.0104, 0.0564> <-0.0330, 0.0050, 0.0564> <-0.0795, 0.0001, 0.0270> <-0.0801, -0.0000, 0.0000>
		<-0.0054, -0.0074, 0.0526> <-0.0271, -0.0113, 0.0526> <-0.0740, -0.0199, 0.0221> <-0.0740, -0.0199, 0.0000>
		<-0.0046, -0.0139, 0.0436> <-0.0263, -0.0178, 0.0436> <-0.0629, -0.0244, 0.0221> <-0.0629, -0.0244, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0796, 0.0120, 0.0000> <-0.0801, 0.0119, -0.0264> <-0.0368, 0.0154, -0.0546> <-0.0109, 0.0208, -0.0546>
		<-0.0801, -0.0000, 0.0000> <-0.0807, -0.0001, -0.0264> <-0.0348, 0.0047, -0.0564> <-0.0089, 0.0100, -0.0564>
		<-0.0740, -0.0199, 0.0000> <-0.0740, -0.0199, -0.0221> <-0.0275, -0.0114, -0.0526> <-0.0058, -0.0075, -0.0526>
		<-0.0629, -0.0244, 0.0000> <-0.0629, -0.0244, -0.0221> <-0.0263, -0.0178, -0.0436> <-0.0046, -0.0139, -0.0436>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0046, -0.0139, 0.0436> <-0.0263, -0.0178, 0.0436> <-0.0629, -0.0244, 0.0221> <-0.0629, -0.0244, 0.0000>
		<-0.0038, -0.0214, 0.0334> <-0.0255, -0.0253, 0.0334> <-0.0469, -0.0309, 0.0221> <-0.0469, -0.0309, 0.0000>
		<-0.0042, -0.0163, 0.0141> <-0.0049, -0.0165, 0.0141> <-0.0230, -0.0198, 0.0007> <-0.0230, -0.0198, 0.0000>
		<-0.0040, -0.0174, 0.0015> <-0.0047, -0.0175, 0.0015> <-0.0060, -0.0177, 0.0007> <-0.0060, -0.0177, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0629, -0.0244, 0.0000> <-0.0629, -0.0244, -0.0221> <-0.0263, -0.0178, -0.0436> <-0.0046, -0.0139, -0.0436>
		<-0.0469, -0.0309, 0.0000> <-0.0469, -0.0309, -0.0221> <-0.0250, -0.0252, -0.0334> <-0.0033, -0.0213, -0.0334>
		<-0.0230, -0.0198, 0.0000> <-0.0230, -0.0198, -0.0007> <-0.0049, -0.0165, -0.0141> <-0.0042, -0.0163, -0.0141>
		<-0.0060, -0.0177, 0.0000> <-0.0060, -0.0177, -0.0007> <-0.0047, -0.0175, -0.0015> <-0.0040, -0.0174, -0.0015>
	}
	pigment {color rgb <0.6, 0.55, 0.55>}
	finish {ambient 0.1 diffuse 0.7 phong 0.1}
	normal {crackle 0.5 scale <0.08, 0.04, 0.08>}
}

#declare Rope = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0270, 0.1375, 0.0000> <0.0340, 0.1218, 0.0000> <0.0487, 0.1022, 0.0000> <0.0503, 0.0850, 0.0000>
		<0.0270, 0.1375, -0.0212> <0.0340, 0.1218, -0.0212> <0.0487, 0.1022, -0.0263> <0.0503, 0.0850, -0.0263>
		<-0.0089, 0.1313, -0.0409> <-0.0061, 0.1148, -0.0438> <0.0028, 0.0939, -0.0517> <0.0057, 0.0773, -0.0507>
		<-0.0298, 0.1276, -0.0409> <-0.0269, 0.1112, -0.0438> <-0.0232, 0.0894, -0.0517> <-0.0203, 0.0727, -0.0507>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0270, 0.1375, 0.0000> <0.0270, 0.1375, 0.0212> <-0.0089, 0.1313, 0.0409> <-0.0298, 0.1276, 0.0409>
		<0.0340, 0.1218, 0.0000> <0.0340, 0.1218, 0.0212> <-0.0061, 0.1148, 0.0438> <-0.0269, 0.1112, 0.0438>
		<0.0487, 0.1022, 0.0000> <0.0487, 0.1022, 0.0263> <0.0028, 0.0939, 0.0517> <-0.0232, 0.0894, 0.0517>
		<0.0503, 0.0850, 0.0000> <0.0503, 0.0850, 0.0263> <0.0057, 0.0773, 0.0507> <-0.0203, 0.0727, 0.0507>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0503, 0.0850, 0.0000> <0.0518, 0.0685, 0.0000> <0.0407, 0.0475, 0.0000> <0.0366, 0.0314, 0.0000>
		<0.0503, 0.0850, -0.0263> <0.0518, 0.0685, -0.0263> <0.0407, 0.0475, -0.0180> <0.0366, 0.0314, -0.0180>
		<0.0057, 0.0773, -0.0507> <0.0084, 0.0616, -0.0498> <0.0035, 0.0410, -0.0395> <0.0061, 0.0261, -0.0347>
		<-0.0203, 0.0727, -0.0507> <-0.0175, 0.0571, -0.0498> <-0.0142, 0.0379, -0.0395> <-0.0116, 0.0230, -0.0347>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0503, 0.0850, 0.0000> <0.0503, 0.0850, 0.0263> <0.0057, 0.0773, 0.0507> <-0.0203, 0.0727, 0.0507>
		<0.0518, 0.0685, 0.0000> <0.0518, 0.0685, 0.0263> <0.0084, 0.0616, 0.0498> <-0.0175, 0.0571, 0.0498>
		<0.0407, 0.0475, 0.0000> <0.0407, 0.0475, 0.0180> <0.0035, 0.0410, 0.0395> <-0.0142, 0.0379, 0.0395>
		<0.0366, 0.0314, 0.0000> <0.0366, 0.0314, 0.0180> <0.0061, 0.0261, 0.0347> <-0.0116, 0.0230, 0.0347>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0298, 0.1276, 0.0409> <-0.0507, 0.1240, 0.0409> <-0.0866, 0.1177, 0.0212> <-0.0866, 0.1177, 0.0000>
		<-0.0269, 0.1112, 0.0438> <-0.0478, 0.1075, 0.0438> <-0.0879, 0.1005, 0.0212> <-0.0879, 0.1005, 0.0000>
		<-0.0232, 0.0894, 0.0517> <-0.0491, 0.0849, 0.0517> <-0.0951, 0.0771, 0.0263> <-0.0951, 0.0771, 0.0000>
		<-0.0203, 0.0727, 0.0507> <-0.0462, 0.0682, 0.0507> <-0.0908, 0.0605, 0.0263> <-0.0908, 0.0605, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0866, 0.1177, 0.0000> <-0.0866, 0.1177, -0.0212> <-0.0507, 0.1240, -0.0409> <-0.0298, 0.1276, -0.0409>
		<-0.0879, 0.1005, 0.0000> <-0.0879, 0.1005, -0.0212> <-0.0478, 0.1075, -0.0438> <-0.0269, 0.1112, -0.0438>
		<-0.0951, 0.0771, 0.0000> <-0.0951, 0.0771, -0.0263> <-0.0491, 0.0849, -0.0517> <-0.0232, 0.0894, -0.0517>
		<-0.0908, 0.0605, 0.0000> <-0.0908, 0.0605, -0.0263> <-0.0462, 0.0682, -0.0507> <-0.0203, 0.0727, -0.0507>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0203, 0.0727, 0.0507> <-0.0462, 0.0682, 0.0507> <-0.0908, 0.0605, 0.0263> <-0.0908, 0.0605, 0.0000>
		<-0.0175, 0.0571, 0.0498> <-0.0435, 0.0526, 0.0498> <-0.0866, 0.0444, 0.0263> <-0.0866, 0.0444, 0.0000>
		<-0.0142, 0.0379, 0.0395> <-0.0319, 0.0348, 0.0395> <-0.0691, 0.0284, 0.0180> <-0.0691, 0.0284, 0.0000>
		<-0.0116, 0.0230, 0.0347> <-0.0293, 0.0199, 0.0347> <-0.0598, 0.0146, 0.0180> <-0.0598, 0.0146, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0908, 0.0605, 0.0000> <-0.0908, 0.0605, -0.0263> <-0.0462, 0.0682, -0.0507> <-0.0203, 0.0727, -0.0507>
		<-0.0866, 0.0444, 0.0000> <-0.0866, 0.0444, -0.0263> <-0.0435, 0.0526, -0.0498> <-0.0175, 0.0571, -0.0498>
		<-0.0691, 0.0284, 0.0000> <-0.0691, 0.0284, -0.0180> <-0.0319, 0.0348, -0.0395> <-0.0142, 0.0379, -0.0395>
		<-0.0598, 0.0146, 0.0000> <-0.0598, 0.0146, -0.0180> <-0.0293, 0.0199, -0.0347> <-0.0116, 0.0230, -0.0347>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0622, 0.6320, -0.0059> <-0.0553, 0.6162, -0.0059> <-0.0407, 0.5965, -0.0059> <-0.0392, 0.5794, -0.0059>
		<-0.0622, 0.6320, -0.0271> <-0.0553, 0.6162, -0.0271> <-0.0407, 0.5965, -0.0322> <-0.0392, 0.5794, -0.0322>
		<-0.0981, 0.6260, -0.0467> <-0.0954, 0.6095, -0.0497> <-0.0867, 0.5886, -0.0576> <-0.0839, 0.5719, -0.0566>
		<-0.1191, 0.6225, -0.0467> <-0.1163, 0.6060, -0.0497> <-0.1126, 0.5842, -0.0576> <-0.1098, 0.5675, -0.0566>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0622, 0.6320, -0.0059> <-0.0622, 0.6320, 0.0153> <-0.0981, 0.6260, 0.0350> <-0.1191, 0.6225, 0.0350>
		<-0.0553, 0.6162, -0.0059> <-0.0553, 0.6162, 0.0153> <-0.0954, 0.6095, 0.0380> <-0.1163, 0.6060, 0.0380>
		<-0.0407, 0.5965, -0.0059> <-0.0407, 0.5965, 0.0204> <-0.0867, 0.5886, 0.0459> <-0.1126, 0.5842, 0.0459>
		<-0.0392, 0.5794, -0.0059> <-0.0392, 0.5794, 0.0204> <-0.0839, 0.5719, 0.0449> <-0.1098, 0.5675, 0.0449>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0392, 0.5794, -0.0059> <-0.0378, 0.5628, -0.0059> <-0.0490, 0.5419, -0.0059> <-0.0532, 0.5258, -0.0059>
		<-0.0392, 0.5794, -0.0322> <-0.0378, 0.5628, -0.0322> <-0.0490, 0.5419, -0.0239> <-0.0532, 0.5258, -0.0239>
		<-0.0839, 0.5719, -0.0566> <-0.0812, 0.5562, -0.0557> <-0.0862, 0.5357, -0.0454> <-0.0837, 0.5207, -0.0406>
		<-0.1098, 0.5675, -0.0566> <-0.1072, 0.5519, -0.0557> <-0.1040, 0.5327, -0.0454> <-0.1015, 0.5177, -0.0406>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0392, 0.5794, -0.0059> <-0.0392, 0.5794, 0.0204> <-0.0839, 0.5719, 0.0449> <-0.1098, 0.5675, 0.0449>
		<-0.0378, 0.5628, -0.0059> <-0.0378, 0.5628, 0.0204> <-0.0812, 0.5562, 0.0439> <-0.1072, 0.5519, 0.0439>
		<-0.0490, 0.5419, -0.0059> <-0.0490, 0.5419, 0.0121> <-0.0862, 0.5357, 0.0336> <-0.1040, 0.5327, 0.0336>
		<-0.0532, 0.5258, -0.0059> <-0.0532, 0.5258, 0.0121> <-0.0837, 0.5207, 0.0288> <-0.1015, 0.5177, 0.0288>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1191, 0.6225, 0.0350> <-0.1400, 0.6190, 0.0350> <-0.1759, 0.6129, 0.0153> <-0.1759, 0.6129, -0.0059>
		<-0.1163, 0.6060, 0.0380> <-0.1372, 0.6025, 0.0380> <-0.1773, 0.5957, 0.0153> <-0.1773, 0.5957, -0.0059>
		<-0.1126, 0.5842, 0.0459> <-0.1386, 0.5799, 0.0459> <-0.1847, 0.5724, 0.0204> <-0.1847, 0.5724, -0.0059>
		<-0.1098, 0.5675, 0.0449> <-0.1358, 0.5632, 0.0449> <-0.1804, 0.5557, 0.0204> <-0.1804, 0.5557, -0.0059>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1759, 0.6129, -0.0059> <-0.1759, 0.6129, -0.0271> <-0.1400, 0.6190, -0.0467> <-0.1191, 0.6225, -0.0467>
		<-0.1773, 0.5957, -0.0059> <-0.1773, 0.5957, -0.0271> <-0.1372, 0.6025, -0.0497> <-0.1163, 0.6060, -0.0497>
		<-0.1847, 0.5724, -0.0059> <-0.1847, 0.5724, -0.0322> <-0.1386, 0.5799, -0.0576> <-0.1126, 0.5842, -0.0576>
		<-0.1804, 0.5557, -0.0059> <-0.1804, 0.5557, -0.0322> <-0.1358, 0.5632, -0.0566> <-0.1098, 0.5675, -0.0566>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1098, 0.5675, 0.0449> <-0.1358, 0.5632, 0.0449> <-0.1804, 0.5557, 0.0204> <-0.1804, 0.5557, -0.0059>
		<-0.1072, 0.5519, 0.0439> <-0.1332, 0.5475, 0.0439> <-0.1763, 0.5396, 0.0204> <-0.1763, 0.5396, -0.0059>
		<-0.1040, 0.5327, 0.0336> <-0.1217, 0.5297, 0.0336> <-0.1589, 0.5234, 0.0121> <-0.1589, 0.5234, -0.0059>
		<-0.1015, 0.5177, 0.0288> <-0.1192, 0.5148, 0.0288> <-0.1497, 0.5096, 0.0121> <-0.1497, 0.5096, -0.0059>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1804, 0.5557, -0.0059> <-0.1804, 0.5557, -0.0322> <-0.1358, 0.5632, -0.0566> <-0.1098, 0.5675, -0.0566>
		<-0.1763, 0.5396, -0.0059> <-0.1763, 0.5396, -0.0322> <-0.1332, 0.5475, -0.0557> <-0.1072, 0.5519, -0.0557>
		<-0.1589, 0.5234, -0.0059> <-0.1589, 0.5234, -0.0239> <-0.1217, 0.5297, -0.0454> <-0.1040, 0.5327, -0.0454>
		<-0.1497, 0.5096, -0.0059> <-0.1497, 0.5096, -0.0239> <-0.1192, 0.5148, -0.0406> <-0.1015, 0.5177, -0.0406>
	}
	pigment {color rgb <0.9, 0.8, 0.8>}
	finish {ambient 0.1 diffuse 0.7 phong 0.1}
	normal {bumps bump_size 0.3 scale 0.01}
}

#declare Sphere1 = sphere{0, 0.16 scale <1, 0.3, 0.3> texture{FairHair}}
#declare Part1 = union{
	Hair(Sphere1, 200, <0, 0, 0>, 0.45, FairHair) 
    Hair(Sphere1, 200, <-0.08, 0, 0>, 0.45, FairHair) 
    Hair(Sphere1, 200, <0.08, 0, 0>, 0.45, FairHair)
    
    rotate z*8
    rotate z*90
    translate <-0.14, 0.76, 0>
} 

#declare Feather1 = union {
	object{Center}
	object{Left}
	object{Right} 
	object{Fix}
	object{Rope}
	object{Part1}
}




