
#macro Hair(Object, Count, Center, Height, HairColor)
	#local R0 = 0.001;
	#local way = 0;
	#local theta = 0;    
	#local lseed = seed(1000);
	#local realHeight = Height/5 + ((4 * Height)/5 * rand(lseed));
	#while (theta < pi)
		#local way = way + 2 * pi * sin(theta);
		#local theta = theta + (pi / Count);
	#end
	#local part = way / Count;
	#local theta = pi / Count;
	#local last = 0;
	#while (theta < pi)
		#local way = 2 * pi * sin(theta);
		#local startangle = -2 * pi * last / way;
		#local stepangle = 2 * pi * part / way;
		#local way = way + last;
		#while (way >= part)
			#local way = way - part;
			#local startangle = startangle + stepangle;
			#local PointInRange = Center + <sin(theta) * cos(startangle), sin(theta) * sin(startangle), cos(theta)>;
			#local Normal = <0, 0, 0>;
			#local P0 = trace(Object, PointInRange, Center - PointInRange, Normal);
			cone { P0 R0 P0 + realHeight * Normal 0 texture{HairColor} no_shadow}
		#end
		#local last = way;
		#local theta = theta + (pi / Count);
	#end
#end  

#declare FairHair = texture {
	pigment { color rgb 0.8}
	finish{ambient 0.1 diffuse 0.8 phong 0}
} 

#declare Center = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0023, -0.0002, 0.0000> <-0.0023, -0.0002, 0.0013> <-0.0013, -0.0001, 0.0023> <-0.0000, 0.0000, 0.0023>
		<-0.0598, 0.2900, 0.0000> <-0.0598, 0.2900, 0.0013> <-0.0534, 0.2907, 0.0061> <-0.0521, 0.2908, 0.0061>
		<-0.1573, 0.6736, 0.0000> <-0.1573, 0.6736, 0.0097> <-0.1496, 0.6748, 0.0132> <-0.1399, 0.6759, 0.0132>
		<-0.1938, 0.9672, 0.0000> <-0.1938, 0.9672, 0.0097> <-0.1834, 0.9684, 0.0151> <-0.1738, 0.9694, 0.0151>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0023, -0.0002, 0.0000> <-0.0598, 0.2900, 0.0000> <-0.1573, 0.6736, 0.0000> <-0.1938, 0.9672, 0.0000>
		<-0.0023, -0.0002, -0.0013> <-0.0598, 0.2900, -0.0013> <-0.1573, 0.6735, -0.0097> <-0.1938, 0.9671, -0.0097>
		<-0.0012, -0.0001, -0.0023> <-0.0534, 0.2907, -0.0061> <-0.1496, 0.6747, -0.0132> <-0.1834, 0.9682, -0.0151>
		<0.0000, -0.0000, -0.0023> <-0.0521, 0.2908, -0.0061> <-0.1399, 0.6758, -0.0132> <-0.1738, 0.9693, -0.0151>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.0000, -0.0023> <-0.0521, 0.2908, -0.0061> <-0.1399, 0.6758, -0.0132> <-0.1738, 0.9693, -0.0151>
		<0.0013, 0.0001, -0.0023> <-0.0509, 0.2909, -0.0061> <-0.1302, 0.6768, -0.0132> <-0.1641, 0.9703, -0.0151>
		<0.0023, 0.0002, -0.0013> <-0.0445, 0.2916, -0.0013> <-0.1225, 0.6780, -0.0097> <-0.1537, 0.9715, -0.0097>
		<0.0023, 0.0002, 0.0000> <-0.0445, 0.2916, 0.0000> <-0.1225, 0.6781, 0.0000> <-0.1537, 0.9715, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0023, 0.0002, 0.0000> <-0.0445, 0.2916, 0.0000> <-0.1225, 0.6781, 0.0000> <-0.1537, 0.9715, 0.0000>
		<0.0023, 0.0002, 0.0013> <-0.0445, 0.2916, 0.0013> <-0.1225, 0.6781, 0.0097> <-0.1537, 0.9716, 0.0097>
		<0.0012, 0.0001, 0.0023> <-0.0509, 0.2909, 0.0061> <-0.1302, 0.6769, 0.0132> <-0.1641, 0.9705, 0.0151>
		<-0.0000, 0.0000, 0.0023> <-0.0521, 0.2908, 0.0061> <-0.1399, 0.6759, 0.0132> <-0.1738, 0.9694, 0.0151>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1938, 0.9672, 0.0000> <-0.1938, 0.9672, 0.0097> <-0.1834, 0.9684, 0.0151> <-0.1738, 0.9694, 0.0151>
		<-0.2290, 1.2503, 0.0000> <-0.2290, 1.2504, 0.0097> <-0.2161, 1.2512, 0.0169> <-0.2064, 1.2522, 0.0169>
		<-0.2519, 1.6320, 0.0000> <-0.2519, 1.6320, 0.0094> <-0.2413, 1.6327, 0.0150> <-0.2318, 1.6327, 0.0150>
		<-0.2407, 1.9171, 0.0000> <-0.2407, 1.9172, 0.0094> <-0.2306, 1.9172, 0.0146> <-0.2211, 1.9172, 0.0146>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1938, 0.9672, 0.0000> <-0.2290, 1.2503, 0.0000> <-0.2519, 1.6320, 0.0000> <-0.2407, 1.9171, 0.0000>
		<-0.1938, 0.9671, -0.0097> <-0.2290, 1.2503, -0.0097> <-0.2519, 1.6320, -0.0094> <-0.2407, 1.9171, -0.0094>
		<-0.1834, 0.9682, -0.0151> <-0.2160, 1.2510, -0.0169> <-0.2412, 1.6326, -0.0150> <-0.2306, 1.9171, -0.0146>
		<-0.1738, 0.9693, -0.0151> <-0.2064, 1.2521, -0.0169> <-0.2318, 1.6326, -0.0150> <-0.2211, 1.9171, -0.0146>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1738, 0.9693, -0.0151> <-0.2064, 1.2521, -0.0169> <-0.2318, 1.6326, -0.0150> <-0.2211, 1.9171, -0.0146>
		<-0.1641, 0.9703, -0.0151> <-0.1967, 1.2531, -0.0169> <-0.2224, 1.6326, -0.0150> <-0.2117, 1.9171, -0.0146>
		<-0.1537, 0.9715, -0.0097> <-0.1837, 1.2539, -0.0097> <-0.2118, 1.6332, -0.0094> <-0.2016, 1.9171, -0.0094>
		<-0.1537, 0.9715, 0.0000> <-0.1837, 1.2540, 0.0000> <-0.2118, 1.6333, 0.0000> <-0.2016, 1.9171, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1537, 0.9715, 0.0000> <-0.1837, 1.2540, 0.0000> <-0.2118, 1.6333, 0.0000> <-0.2016, 1.9171, 0.0000>
		<-0.1537, 0.9716, 0.0097> <-0.1837, 1.2540, 0.0097> <-0.2118, 1.6333, 0.0094> <-0.2016, 1.9172, 0.0094>
		<-0.1641, 0.9705, 0.0151> <-0.1967, 1.2533, 0.0169> <-0.2224, 1.6327, 0.0150> <-0.2117, 1.9172, 0.0146>
		<-0.1738, 0.9694, 0.0151> <-0.2064, 1.2522, 0.0169> <-0.2318, 1.6327, 0.0150> <-0.2211, 1.9172, 0.0146>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2407, 1.9171, 0.0000> <-0.2407, 1.9172, 0.0094> <-0.2306, 1.9172, 0.0146> <-0.2211, 1.9172, 0.0146>
		<-0.2292, 2.2091, 0.0000> <-0.2292, 2.2091, 0.0094> <-0.2196, 2.2082, 0.0142> <-0.2102, 2.2082, 0.0142>
		<-0.1767, 2.5970, 0.0000> <-0.1767, 2.5970, 0.0082> <-0.1652, 2.5960, 0.0147> <-0.1571, 2.5947, 0.0147>
		<-0.1187, 2.8834, 0.0000> <-0.1187, 2.8834, 0.0082> <-0.1100, 2.8820, 0.0127> <-0.1020, 2.8807, 0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2407, 1.9171, 0.0000> <-0.2292, 2.2091, 0.0000> <-0.1767, 2.5970, 0.0000> <-0.1187, 2.8834, 0.0000>
		<-0.2407, 1.9171, -0.0094> <-0.2292, 2.2090, -0.0094> <-0.1767, 2.5970, -0.0082> <-0.1187, 2.8833, -0.0082>
		<-0.2306, 1.9171, -0.0146> <-0.2196, 2.2081, -0.0142> <-0.1652, 2.5959, -0.0147> <-0.1100, 2.8819, -0.0127>
		<-0.2211, 1.9171, -0.0146> <-0.2102, 2.2081, -0.0142> <-0.1571, 2.5946, -0.0147> <-0.1020, 2.8806, -0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2211, 1.9171, -0.0146> <-0.2102, 2.2081, -0.0142> <-0.1571, 2.5946, -0.0147> <-0.1020, 2.8806, -0.0127>
		<-0.2117, 1.9171, -0.0146> <-0.2008, 2.2081, -0.0142> <-0.1491, 2.5933, -0.0147> <-0.0939, 2.8792, -0.0127>
		<-0.2016, 1.9171, -0.0094> <-0.1912, 2.2072, -0.0094> <-0.1376, 2.5923, -0.0082> <-0.0852, 2.8778, -0.0082>
		<-0.2016, 1.9171, 0.0000> <-0.1912, 2.2073, 0.0000> <-0.1376, 2.5923, 0.0000> <-0.0852, 2.8779, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2016, 1.9171, 0.0000> <-0.1912, 2.2073, 0.0000> <-0.1376, 2.5923, 0.0000> <-0.0852, 2.8779, 0.0000>
		<-0.2016, 1.9172, 0.0094> <-0.1912, 2.2073, 0.0094> <-0.1376, 2.5923, 0.0082> <-0.0852, 2.8779, 0.0082>
		<-0.2117, 1.9172, 0.0146> <-0.2008, 2.2082, 0.0142> <-0.1491, 2.5934, 0.0147> <-0.0939, 2.8793, 0.0127>
		<-0.2211, 1.9172, 0.0146> <-0.2102, 2.2082, 0.0142> <-0.1571, 2.5947, 0.0147> <-0.1020, 2.8807, 0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1414, 3.8051, 0.0000> <0.0634, 3.5286, 0.0000> <-0.0617, 3.1650, 0.0000> <-0.1187, 2.8834, 0.0000>
		<0.1414, 3.8051, 0.0008> <0.0634, 3.5286, 0.0008> <-0.0617, 3.1650, 0.0082> <-0.1187, 2.8834, 0.0082>
		<0.1421, 3.8049, 0.0016> <0.0686, 3.5277, 0.0049> <-0.0557, 3.1636, 0.0107> <-0.1100, 2.8820, 0.0127>
		<0.1429, 3.8047, 0.0016> <0.0695, 3.5275, 0.0049> <-0.0476, 3.1623, 0.0107> <-0.1020, 2.8807, 0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1414, 3.8051, 0.0000> <0.1414, 3.8051, -0.0008> <0.1421, 3.8049, -0.0016> <0.1429, 3.8047, -0.0016>
		<0.0634, 3.5286, 0.0000> <0.0634, 3.5286, -0.0008> <0.0686, 3.5277, -0.0049> <0.0694, 3.5274, -0.0049>
		<-0.0617, 3.1650, 0.0000> <-0.0617, 3.1649, -0.0082> <-0.0557, 3.1635, -0.0107> <-0.0477, 3.1622, -0.0107>
		<-0.1187, 2.8834, 0.0000> <-0.1187, 2.8833, -0.0082> <-0.1100, 2.8819, -0.0127> <-0.1020, 2.8806, -0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1429, 3.8047, -0.0016> <0.1437, 3.8044, -0.0016> <0.1444, 3.8042, -0.0008> <0.1444, 3.8042, 0.0000>
		<0.0694, 3.5274, -0.0049> <0.0703, 3.5272, -0.0049> <0.0755, 3.5263, -0.0008> <0.0755, 3.5263, 0.0000>
		<-0.0477, 3.1622, -0.0107> <-0.0396, 3.1609, -0.0107> <-0.0336, 3.1594, -0.0082> <-0.0336, 3.1595, 0.0000>
		<-0.1020, 2.8806, -0.0127> <-0.0939, 2.8792, -0.0127> <-0.0852, 2.8778, -0.0082> <-0.0852, 2.8779, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1444, 3.8042, 0.0000> <0.1444, 3.8042, 0.0008> <0.1437, 3.8044, 0.0016> <0.1429, 3.8047, 0.0016>
		<0.0755, 3.5263, 0.0000> <0.0755, 3.5263, 0.0008> <0.0703, 3.5272, 0.0049> <0.0695, 3.5275, 0.0049>
		<-0.0336, 3.1595, 0.0000> <-0.0336, 3.1595, 0.0082> <-0.0396, 3.1609, 0.0107> <-0.0476, 3.1623, 0.0107>
		<-0.0852, 2.8779, 0.0000> <-0.0852, 2.8779, 0.0082> <-0.0939, 2.8793, 0.0127> <-0.1020, 2.8807, 0.0127>
	}
	
	pigment { rgb <0.96, 0.94, 0.92>}
	finish {ambient 0 diffuse 0.85 phong 0.2}
} 

#declare Right = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1518, 3.8143, 0.0000> <0.1358, 3.7583, 0.0000> <0.1143, 3.6837, 0.0000> <0.0983, 3.6278, 0.0000>
		<0.1518, 3.8143, 0.0000> <0.1915, 3.7016, 0.0000> <0.1861, 3.6829, 0.0000> <0.1701, 3.6270, 0.0000>
		<0.1518, 3.8143, 0.0000> <0.1915, 3.7016, 0.0000> <0.2387, 3.7007, 0.0000> <0.2657, 3.6259, 0.0000>
		<0.1518, 3.8143, 0.0000> <0.2075, 3.7575, 0.0000> <0.3105, 3.6999, 0.0000> <0.3375, 3.6251, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1170, 0.6198, 0.0000> <-0.1421, 0.7939, 0.0000> <-0.1756, 1.0260, 0.0000> <-0.2007, 1.2002, 0.0000>
		<-0.0467, 0.6918, 0.0000> <-0.0718, 0.8659, 0.0000> <-0.0564, 1.1982, 0.0000> <-0.0815, 1.3723, 0.0000>
		<0.0909, 0.7628, 0.0000> <0.1631, 1.0284, 0.0000> <0.0537, 1.3276, 0.0000> <0.0775, 1.6018, 0.0000>
		<0.1173, 0.8599, 0.0000> <0.1895, 1.1255, 0.0000> <0.1729, 1.4997, 0.0000> <0.1967, 1.7740, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1170, 0.6198, 0.0000> <-0.0467, 0.6918, 0.0000> <0.0909, 0.7628, 0.0000> <0.1173, 0.8599, 0.0000>
		<-0.1170, 0.6198, 0.0000> <-0.0718, 0.8659, 0.0000> <-0.0045, 0.8648, 0.0000> <0.0219, 0.9620, 0.0000>
		<-0.1170, 0.6198, 0.0000> <-0.0718, 0.8659, 0.0000> <-0.0802, 0.9240, 0.0000> <-0.1053, 1.0981, 0.0000>
		<-0.1170, 0.6198, 0.0000> <-0.1421, 0.7939, 0.0000> <-0.1756, 1.0260, 0.0000> <-0.2007, 1.2002, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2216, 1.7621, 0.0000> <-0.2223, 1.7247, 0.0000> <-0.2218, 1.6749, 0.0000> <-0.2204, 1.6376, 0.0000>
		<-0.0963, 1.8111, 0.0000> <-0.0969, 1.7737, 0.0000> <-0.0959, 1.7321, 0.0000> <-0.0945, 1.6948, 0.0000>
		<0.0709, 1.8764, 0.0000> <0.0706, 1.8472, 0.0000> <0.0724, 1.8002, 0.0000> <0.0734, 1.7710, 0.0000>
		<0.1962, 1.9254, 0.0000> <0.1960, 1.8962, 0.0000> <0.1983, 1.8574, 0.0000> <0.1993, 1.8282, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2216, 1.7621, 0.0000> <-0.0963, 1.8111, 0.0000> <0.0709, 1.8764, 0.0000> <0.1962, 1.9254, 0.0000>
		<-0.2200, 1.8621, 0.0000> <-0.0946, 1.9111, 0.0000> <0.0711, 1.9025, 0.0000> <0.1964, 1.9515, 0.0000>
		<-0.2180, 1.9954, 0.0000> <-0.0939, 1.9705, 0.0000> <0.0751, 2.0112, 0.0000> <0.1992, 1.9863, 0.0000>
		<-0.2127, 2.0953, 0.0000> <-0.0886, 2.0704, 0.0000> <0.0768, 2.0372, 0.0000> <0.2008, 2.0123, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2127, 2.0953, 0.0000> <-0.0886, 2.0704, 0.0000> <0.0768, 2.0372, 0.0000> <0.2008, 2.0123, 0.0000>
		<-0.2093, 2.1579, 0.0000> <-0.0853, 2.1330, 0.0000> <0.0796, 2.0809, 0.0000> <0.2036, 2.0560, 0.0000>
		<-0.2007, 2.2411, 0.0000> <-0.0795, 2.1975, 0.0000> <0.0868, 2.1578, 0.0000> <0.2080, 2.1142, 0.0000>
		<-0.1929, 2.3033, 0.0000> <-0.0718, 2.2597, 0.0000> <0.0898, 2.2015, 0.0000> <0.2110, 2.1578, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2110, 2.1578, 0.0000> <0.2153, 2.2372, 0.0000> <0.2210, 2.3430, 0.0000> <0.2253, 2.4224, 0.0000>
		<0.0898, 2.2015, 0.0000> <0.0941, 2.2809, 0.0000> <0.1066, 2.3816, 0.0000> <0.1109, 2.4609, 0.0000>
		<-0.0718, 2.2597, 0.0000> <-0.0625, 2.3342, 0.0000> <-0.0527, 2.4380, 0.0000> <-0.0417, 2.5123, 0.0000>
		<-0.1929, 2.3033, 0.0000> <-0.1837, 2.3778, 0.0000> <-0.1671, 2.4766, 0.0000> <-0.1561, 2.5508, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0983, 3.6278, 0.0000> <0.0713, 3.5335, 0.0000> <0.0355, 3.4078, 0.0000> <0.0085, 3.3135, 0.0000>
		<0.1701, 3.6270, 0.0000> <0.1431, 3.5327, 0.0000> <0.1367, 3.3968, 0.0000> <0.1098, 3.3025, 0.0000>
		<0.2657, 3.6259, 0.0000> <0.3013, 3.5276, 0.0000> <0.2422, 3.3923, 0.0000> <0.2447, 3.2879, 0.0000>
		<0.3375, 3.6251, 0.0000> <0.3730, 3.5268, 0.0000> <0.3434, 3.3813, 0.0000> <0.3460, 3.2769, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1561, 2.5508, 0.0000> <-0.0417, 2.5123, 0.0000> <0.1109, 2.4609, 0.0000> <0.2253, 2.4224, 0.0000>
		<-0.1428, 2.6404, 0.0000> <-0.0284, 2.6019, 0.0000> <0.1223, 2.5492, 0.0000> <0.2367, 2.5107, 0.0000>
		<-0.1252, 2.7599, 0.0000> <-0.0126, 2.7200, 0.0000> <0.1393, 2.6682, 0.0000> <0.2519, 2.6284, 0.0000>
		<-0.1120, 2.8494, 0.0000> <0.0006, 2.8096, 0.0000> <0.1508, 2.7565, 0.0000> <0.2634, 2.7167, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1561, 2.5508, 0.0000> <-0.0417, 2.5123, 0.0000> <0.1109, 2.4609, 0.0000> <0.2253, 2.4224, 0.0000>
		<-0.1428, 2.6404, 0.0000> <-0.0284, 2.6019, 0.0000> <0.1223, 2.5492, 0.0000> <0.2367, 2.5107, 0.0000>
		<-0.1252, 2.7599, 0.0000> <-0.0126, 2.7200, 0.0000> <0.1393, 2.6682, 0.0000> <0.2519, 2.6284, 0.0000>
		<-0.1120, 2.8494, 0.0000> <0.0006, 2.8096, 0.0000> <0.1508, 2.7565, 0.0000> <0.2634, 2.7167, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2204, 1.6376, 0.0000> <-0.2112, 1.6028, 0.0000> <-0.1989, 1.5565, 0.0000> <-0.1897, 1.5218, 0.0000>
		<-0.2155, 1.5063, 0.0000> <-0.2063, 1.4716, 0.0000> <-0.0830, 1.6322, 0.0000> <-0.0738, 1.5974, 0.0000>
		<-0.2066, 1.3314, 0.0000> <-0.0874, 1.5035, 0.0000> <-0.0384, 1.5262, 0.0000> <0.0808, 1.6983, 0.0000>
		<-0.2007, 1.2002, 0.0000> <-0.0815, 1.3723, 0.0000> <0.0775, 1.6018, 0.0000> <0.1967, 1.7740, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2204, 1.6376, 0.0000> <-0.2155, 1.5063, 0.0000> <-0.2066, 1.3314, 0.0000> <-0.2007, 1.2002, 0.0000>
		<-0.0945, 1.6948, 0.0000> <-0.0896, 1.5635, 0.0000> <-0.2033, 1.4279, 0.0000> <-0.1974, 1.2966, 0.0000>
		<0.0734, 1.7710, 0.0000> <-0.0433, 1.6791, 0.0000> <-0.0763, 1.5172, 0.0000> <-0.1930, 1.4253, 0.0000>
		<0.1993, 1.8282, 0.0000> <0.0826, 1.7363, 0.0000> <-0.0730, 1.6137, 0.0000> <-0.1897, 1.5218, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2204, 1.6376, 0.0000> <-0.2112, 1.6028, 0.0000> <-0.1989, 1.5565, 0.0000> <-0.1897, 1.5218, 0.0000>
		<-0.2204, 1.6376, 0.0000> <-0.2063, 1.4716, 0.0000> <-0.2022, 1.4600, 0.0000> <-0.1930, 1.4253, 0.0000>
		<-0.2204, 1.6376, 0.0000> <-0.2063, 1.4716, 0.0000> <-0.2033, 1.4279, 0.0000> <-0.1974, 1.2966, 0.0000>
		<-0.2204, 1.6376, 0.0000> <-0.2155, 1.5063, 0.0000> <-0.2066, 1.3314, 0.0000> <-0.2007, 1.2002, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2204, 1.6376, 0.0000> <-0.2112, 1.6028, 0.0000> <-0.1989, 1.5565, 0.0000> <-0.1897, 1.5218, 0.0000>
		<-0.2204, 1.6376, 0.0000> <-0.0853, 1.6600, 0.0000> <-0.0822, 1.6485, 0.0000> <-0.0730, 1.6137, 0.0000>
		<-0.2204, 1.6376, 0.0000> <-0.0853, 1.6600, 0.0000> <-0.0433, 1.6791, 0.0000> <0.0826, 1.7363, 0.0000>
		<-0.2204, 1.6376, 0.0000> <-0.0945, 1.6948, 0.0000> <0.0734, 1.7710, 0.0000> <0.1993, 1.8282, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1967, 1.7740, 0.0000> <0.0775, 1.6018, 0.0000> <-0.0815, 1.3723, 0.0000> <-0.2007, 1.2002, 0.0000>
		<0.1967, 1.7740, 0.0000> <0.0537, 1.3276, 0.0000> <0.0139, 1.2702, 0.0000> <-0.1053, 1.0981, 0.0000>
		<0.1967, 1.7740, 0.0000> <0.0537, 1.3276, 0.0000> <0.0941, 1.2276, 0.0000> <0.0219, 0.9620, 0.0000>
		<0.1967, 1.7740, 0.0000> <0.1729, 1.4997, 0.0000> <0.1895, 1.1255, 0.0000> <0.1173, 0.8599, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1967, 1.7740, 0.0000> <0.0808, 1.6983, 0.0000> <-0.0738, 1.5974, 0.0000> <-0.1897, 1.5218, 0.0000>
		<0.1729, 1.4997, 0.0000> <0.0570, 1.4241, 0.0000> <-0.0771, 1.5010, 0.0000> <-0.1930, 1.4253, 0.0000>
		<0.1895, 1.1255, 0.0000> <0.0941, 1.2276, 0.0000> <-0.1020, 1.1946, 0.0000> <-0.1974, 1.2966, 0.0000>
		<0.1173, 0.8599, 0.0000> <0.0219, 0.9620, 0.0000> <-0.1053, 1.0981, 0.0000> <-0.2007, 1.2002, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1967, 1.7740, 0.0000> <0.0775, 1.6018, 0.0000> <-0.0815, 1.3723, 0.0000> <-0.2007, 1.2002, 0.0000>
		<0.1967, 1.7740, 0.0000> <-0.0384, 1.5262, 0.0000> <-0.0782, 1.4688, 0.0000> <-0.1974, 1.2966, 0.0000>
		<0.1967, 1.7740, 0.0000> <-0.0384, 1.5262, 0.0000> <-0.0771, 1.5010, 0.0000> <-0.1930, 1.4253, 0.0000>
		<0.1967, 1.7740, 0.0000> <0.0808, 1.6983, 0.0000> <-0.0738, 1.5974, 0.0000> <-0.1897, 1.5218, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2634, 2.7167, 0.0000> <0.2756, 2.8071, 0.0000> <0.2908, 2.9278, 0.0000> <0.3041, 3.0180, 0.0000>
		<0.1508, 2.7565, 0.0000> <0.1630, 2.8469, 0.0000> <0.1829, 2.9491, 0.0000> <0.1962, 3.0394, 0.0000>
		<0.0006, 2.8096, 0.0000> <0.0175, 2.8816, 0.0000> <0.0337, 2.9963, 0.0000> <0.0523, 3.0679, 0.0000>
		<-0.1120, 2.8494, 0.0000> <-0.0951, 2.9214, 0.0000> <-0.0742, 3.0177, 0.0000> <-0.0556, 3.0892, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2634, 2.7167, 0.0000> <0.2756, 2.8071, 0.0000> <0.2908, 2.9278, 0.0000> <0.3041, 3.0180, 0.0000>
		<0.1508, 2.7565, 0.0000> <0.1630, 2.8469, 0.0000> <0.1829, 2.9491, 0.0000> <0.1962, 3.0394, 0.0000>
		<0.0006, 2.8096, 0.0000> <0.0175, 2.8816, 0.0000> <0.0337, 2.9963, 0.0000> <0.0523, 3.0679, 0.0000>
		<-0.1120, 2.8494, 0.0000> <-0.0951, 2.9214, 0.0000> <-0.0742, 3.0177, 0.0000> <-0.0556, 3.0892, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3460, 3.2769, 0.0000> <0.2447, 3.2879, 0.0000> <0.1098, 3.3025, 0.0000> <0.0085, 3.3135, 0.0000>
		<0.3334, 3.1992, 0.0000> <0.2322, 3.2102, 0.0000> <0.0905, 3.2352, 0.0000> <-0.0107, 3.2462, 0.0000>
		<0.3156, 3.0958, 0.0000> <0.2077, 3.1172, 0.0000> <0.0699, 3.1356, 0.0000> <-0.0380, 3.1570, 0.0000>
		<0.3041, 3.0180, 0.0000> <0.1962, 3.0394, 0.0000> <0.0523, 3.0679, 0.0000> <-0.0556, 3.0892, 0.0000>
	}
	
    texture{      
	    pigment{
	        gradient y
	        color_map{
	            [0.0 0.6 color rgb <0.96, 0.94, 0.92> color rgb <0.96, 0.94, 0.92>] 
	            [0.6 0.8 color rgb <0.96, 0.94, 0.92> color rgb <0.26, 0.24, 0.22>]
	            [0.8 1.0 color rgb <0.26, 0.24, 0.22> color rgb <0.26, 0.24, 0.22>]
	        }
	        rotate -z*30
	        turbulence 0.3
	        scale 2      
	        translate y*1.65
	    }
		finish{ambient 0 diffuse 0.8 phong 0.1}
		normal{
		    onion
		    slope_map {
                [0 <0.5, 0.5>]   
                [0.2 <1, 0>]   
                [0.8  <1, 0>]   
                [1    <0.5, -0.5>]   
            } 
            turbulence 0.03           
            frequency 25
            scale <0.3, 1, 0.1>
            translate <-1, 15, 0>
		}  
	}
}

#declare Left = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3418, 0.8355, 0.0000> <-0.4080, 0.9553, 0.0000> <-0.4468, 1.1376, 0.0000> <-0.4793, 1.2705, 0.0000>
		<-0.2917, 0.8791, 0.0000> <-0.3579, 0.9989, 0.0000> <-0.3652, 1.1462, 0.0000> <-0.3978, 1.2791, 0.0000>
		<-0.2249, 0.9371, 0.0000> <-0.2372, 1.0324, 0.0000> <-0.2813, 1.1948, 0.0000> <-0.2891, 1.2905, 0.0000>
		<-0.1748, 0.9806, 0.0000> <-0.1870, 1.0759, 0.0000> <-0.1998, 1.2034, 0.0000> <-0.2076, 1.2991, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3418, 0.8355, 0.0000> <-0.2917, 0.8791, 0.0000> <-0.2249, 0.9371, 0.0000> <-0.1748, 0.9806, 0.0000>
		<-0.3418, 0.8355, 0.0000> <-0.2469, 0.7979, 0.0000> <-0.2109, 0.8286, 0.0000> <-0.1608, 0.8721, 0.0000>
		<-0.3418, 0.8355, 0.0000> <-0.2469, 0.7979, 0.0000> <-0.2030, 0.7929, 0.0000> <-0.1365, 0.7282, 0.0000>
		<-0.3418, 0.8355, 0.0000> <-0.2970, 0.7543, 0.0000> <-0.1866, 0.6847, 0.0000> <-0.1201, 0.6200, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4793, 1.2705, 0.0000> <-0.5015, 1.3609, 0.0000> <-0.5148, 1.4850, 0.0000> <-0.5237, 1.5777, 0.0000>
		<-0.3978, 1.2791, 0.0000> <-0.4200, 1.3695, 0.0000> <-0.4231, 1.4648, 0.0000> <-0.4320, 1.5575, 0.0000>
		<-0.2891, 1.2905, 0.0000> <-0.2943, 1.3538, 0.0000> <-0.3085, 1.4671, 0.0000> <-0.3098, 1.5306, 0.0000>
		<-0.2076, 1.2991, 0.0000> <-0.2128, 1.3624, 0.0000> <-0.2168, 1.4470, 0.0000> <-0.2181, 1.5105, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5237, 1.5777, 0.0000> <-0.5348, 1.6940, 0.0000> <-0.5514, 1.8499, 0.0000> <-0.5461, 1.9666, 0.0000>
		<-0.4320, 1.5575, 0.0000> <-0.4432, 1.6738, 0.0000> <-0.4537, 1.8362, 0.0000> <-0.4484, 1.9530, 0.0000>
		<-0.3098, 1.5306, 0.0000> <-0.3123, 1.6538, 0.0000> <-0.3222, 1.8117, 0.0000> <-0.3181, 1.9348, 0.0000>
		<-0.2181, 1.5105, 0.0000> <-0.2206, 1.6337, 0.0000> <-0.2244, 1.7981, 0.0000> <-0.2203, 1.9212, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5461, 1.9666, 0.0000> <-0.5394, 2.1154, 0.0000> <-0.5099, 2.3124, 0.0000> <-0.4837, 2.4589, 0.0000>
		<-0.4484, 1.9530, 0.0000> <-0.4416, 2.1017, 0.0000> <-0.4224, 2.2644, 0.0000> <-0.3961, 2.4109, 0.0000>
		<-0.3181, 1.9348, 0.0000> <-0.3143, 2.0484, 0.0000> <-0.2907, 2.2339, 0.0000> <-0.2794, 2.3469, 0.0000>
		<-0.2203, 1.9212, 0.0000> <-0.2166, 2.0348, 0.0000> <-0.2031, 2.1859, 0.0000> <-0.1919, 2.2989, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4837, 2.4589, 0.0000> <-0.4655, 2.5602, 0.0000> <-0.4226, 2.6910, 0.0000> <-0.3985, 2.7910, 0.0000>
		<-0.3961, 2.4109, 0.0000> <-0.3780, 2.5122, 0.0000> <-0.3504, 2.6187, 0.0000> <-0.3263, 2.7187, 0.0000>
		<-0.2794, 2.3469, 0.0000> <-0.2719, 2.4226, 0.0000> <-0.2410, 2.5471, 0.0000> <-0.2301, 2.6223, 0.0000>
		<-0.1919, 2.2989, 0.0000> <-0.1844, 2.3746, 0.0000> <-0.1689, 2.4748, 0.0000> <-0.1579, 2.5500, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3307, 3.0953, 0.0000> <-0.3167, 3.1558, 0.0000> <-0.3019, 3.2376, 0.0000> <-0.2821, 3.2965, 0.0000>
		<-0.2730, 2.9662, 0.0000> <-0.2590, 3.0268, 0.0000> <-0.2322, 3.1821, 0.0000> <-0.2125, 3.2410, 0.0000>
		<-0.1961, 2.7942, 0.0000> <-0.1703, 2.9282, 0.0000> <-0.1494, 3.0337, 0.0000> <-0.1196, 3.1669, 0.0000>
		<-0.1384, 2.6652, 0.0000> <-0.1126, 2.7992, 0.0000> <-0.0797, 2.9782, 0.0000> <-0.0499, 3.1113, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3307, 3.0953, 0.0000> <-0.2730, 2.9662, 0.0000> <-0.1961, 2.7942, 0.0000> <-0.1384, 2.6652, 0.0000>
		<-0.3516, 3.0041, 0.0000> <-0.2940, 2.8751, 0.0000> <-0.2027, 2.7598, 0.0000> <-0.1450, 2.6308, 0.0000>
		<-0.3766, 2.8820, 0.0000> <-0.3045, 2.8096, 0.0000> <-0.2250, 2.6570, 0.0000> <-0.1528, 2.5847, 0.0000>
		<-0.3985, 2.7910, 0.0000> <-0.3263, 2.7187, 0.0000> <-0.2301, 2.6223, 0.0000> <-0.1579, 2.5500, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0383, 3.7454, 0.0000> <0.0023, 3.7107, 0.0000> <0.0565, 3.6645, 0.0000> <0.0971, 3.6298, 0.0000>
		<-0.0967, 3.6971, 0.0000> <-0.0560, 3.6624, 0.0000> <0.0293, 3.5703, 0.0000> <0.0700, 3.5356, 0.0000>
		<-0.1459, 3.6043, 0.0000> <-0.0891, 3.5377, 0.0000> <-0.0227, 3.4766, 0.0000> <0.0341, 3.4099, 0.0000>
		<-0.1820, 3.5378, 0.0000> <-0.1252, 3.4711, 0.0000> <-0.0495, 3.3822, 0.0000> <0.0073, 3.3156, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0383, 3.7454, 0.0000> <0.0082, 3.7840, 0.0000> <0.0942, 3.7933, 0.0000> <0.1510, 3.8139, 0.0000>
		<-0.0383, 3.7454, 0.0000> <0.0488, 3.7493, 0.0000> <0.0780, 3.7381, 0.0000> <0.1348, 3.7587, 0.0000>
		<-0.0383, 3.7454, 0.0000> <0.0488, 3.7493, 0.0000> <0.0724, 3.7198, 0.0000> <0.1131, 3.6851, 0.0000>
		<-0.0383, 3.7454, 0.0000> <0.0023, 3.7107, 0.0000> <0.0565, 3.6645, 0.0000> <0.0971, 3.6298, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1820, 3.5378, 0.0000> <-0.1252, 3.4711, 0.0000> <-0.0495, 3.3822, 0.0000> <0.0073, 3.3156, 0.0000>
		<-0.2194, 3.4689, 0.0000> <-0.1626, 3.4022, 0.0000> <-0.0668, 3.3210, 0.0000> <-0.0100, 3.2543, 0.0000>
		<-0.2572, 3.3708, 0.0000> <-0.1875, 3.3152, 0.0000> <-0.1057, 3.2290, 0.0000> <-0.0360, 3.1734, 0.0000>
		<-0.2821, 3.2965, 0.0000> <-0.2125, 3.2410, 0.0000> <-0.1196, 3.1669, 0.0000> <-0.0499, 3.1113, 0.0000>
	}
	
	texture{      
	    pigment{
	        gradient y
	        color_map{
	            [0.0 0.6 color rgb <0.96, 0.94, 0.92> color rgb <0.96, 0.94, 0.92>] 
	            [0.6 0.8 color rgb <0.96, 0.94, 0.92> color rgb <0.26, 0.24, 0.22>]
	            [0.8 1.0 color rgb <0.26, 0.24, 0.22> color rgb <0.26, 0.24, 0.22>]
	        }
	        rotate -z*30
	        turbulence 0.3
	        scale 2      
	        translate y*1.65
	    }
		finish{ambient 0 diffuse 0.8 phong 0.1}
		normal{
		    onion
		    slope_map {
                [0 <0.5, 0.5>]   
                [0.2 <1, 0>]   
                [0.8  <1, 0>]   
                [1    <0.5, -0.5>]   
            } 
            turbulence 0.03           
            frequency 20
            scale <0.26, 1, 0.1>
            translate <1.5, 15, 0>
		}  
	}
} 

#declare Fix = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1099, 0.6554, 0.0000> <-0.0972, 0.6567, 0.0000> <-0.0788, 0.6654, 0.0000> <-0.0674, 0.6595, 0.0000>
		<-0.1099, 0.6554, -0.0057> <-0.0972, 0.6567, -0.0057> <-0.0788, 0.6654, -0.0216> <-0.0674, 0.6595, -0.0216>
		<-0.1194, 0.6537, -0.0113> <-0.1192, 0.6527, -0.0207> <-0.1046, 0.6593, -0.0356> <-0.1031, 0.6531, -0.0426>
		<-0.1250, 0.6527, -0.0113> <-0.1248, 0.6517, -0.0207> <-0.1259, 0.6555, -0.0356> <-0.1244, 0.6493, -0.0426>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1099, 0.6554, 0.0000> <-0.1099, 0.6554, 0.0057> <-0.1194, 0.6537, 0.0113> <-0.1250, 0.6527, 0.0113>
		<-0.0972, 0.6567, 0.0000> <-0.0972, 0.6567, 0.0057> <-0.1192, 0.6527, 0.0207> <-0.1248, 0.6517, 0.0207>
		<-0.0788, 0.6654, 0.0000> <-0.0788, 0.6654, 0.0216> <-0.1046, 0.6593, 0.0356> <-0.1259, 0.6555, 0.0356>
		<-0.0674, 0.6595, 0.0000> <-0.0674, 0.6595, 0.0216> <-0.1031, 0.6531, 0.0426> <-0.1244, 0.6493, 0.0426>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0674, 0.6595, 0.0000> <-0.0563, 0.6539, 0.0000> <-0.0474, 0.6358, 0.0000> <-0.0469, 0.6234, 0.0000>
		<-0.0674, 0.6595, -0.0216> <-0.0563, 0.6539, -0.0216> <-0.0474, 0.6358, -0.0271> <-0.0469, 0.6234, -0.0271>
		<-0.1031, 0.6531, -0.0426> <-0.1011, 0.6448, -0.0520> <-0.0904, 0.6277, -0.0595> <-0.0881, 0.6152, -0.0583>
		<-0.1244, 0.6493, -0.0426> <-0.1224, 0.6409, -0.0520> <-0.1172, 0.6235, -0.0595> <-0.1149, 0.6111, -0.0583>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0674, 0.6595, 0.0000> <-0.0674, 0.6595, 0.0216> <-0.1031, 0.6531, 0.0426> <-0.1244, 0.6493, 0.0426>
		<-0.0563, 0.6539, 0.0000> <-0.0563, 0.6539, 0.0216> <-0.1011, 0.6448, 0.0520> <-0.1224, 0.6409, 0.0520>
		<-0.0474, 0.6358, 0.0000> <-0.0474, 0.6358, 0.0271> <-0.0904, 0.6277, 0.0595> <-0.1172, 0.6235, 0.0595>
		<-0.0469, 0.6234, 0.0000> <-0.0469, 0.6234, 0.0271> <-0.0881, 0.6152, 0.0583> <-0.1149, 0.6111, 0.0583>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0469, 0.6234, 0.0000> <-0.0463, 0.6087, 0.0000> <-0.0672, 0.5916, 0.0000> <-0.0638, 0.5773, 0.0000>
		<-0.0469, 0.6234, -0.0271> <-0.0463, 0.6087, -0.0271> <-0.0672, 0.5916, -0.0174> <-0.0638, 0.5773, -0.0174>
		<-0.0881, 0.6152, -0.0583> <-0.0856, 0.6010, -0.0568> <-0.0949, 0.5865, -0.0347> <-0.0927, 0.5721, -0.0345>
		<-0.1149, 0.6111, -0.0583> <-0.1124, 0.5968, -0.0568> <-0.1121, 0.5834, -0.0347> <-0.1099, 0.5690, -0.0345>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0469, 0.6234, 0.0000> <-0.0469, 0.6234, 0.0271> <-0.0881, 0.6152, 0.0583> <-0.1149, 0.6111, 0.0583>
		<-0.0463, 0.6087, 0.0000> <-0.0463, 0.6087, 0.0271> <-0.0856, 0.6010, 0.0568> <-0.1124, 0.5968, 0.0568>
		<-0.0672, 0.5916, 0.0000> <-0.0672, 0.5916, 0.0174> <-0.0949, 0.5865, 0.0347> <-0.1121, 0.5834, 0.0347>
		<-0.0638, 0.5773, 0.0000> <-0.0638, 0.5773, 0.0174> <-0.0927, 0.5721, 0.0345> <-0.1099, 0.5690, 0.0345>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0638, 0.5773, 0.0000> <-0.0597, 0.5596, 0.0000> <-0.0292, 0.5483, 0.0000> <-0.0251, 0.5306, 0.0000>
		<-0.0638, 0.5773, -0.0174> <-0.0597, 0.5596, -0.0174> <-0.0292, 0.5483, -0.0285> <-0.0251, 0.5306, -0.0285>
		<-0.0927, 0.5721, -0.0345> <-0.0901, 0.5551, -0.0341> <-0.0754, 0.5389, -0.0558> <-0.0724, 0.5220, -0.0564>
		<-0.1099, 0.5690, -0.0345> <-0.1073, 0.5520, -0.0341> <-0.1035, 0.5338, -0.0558> <-0.1005, 0.5170, -0.0564>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0638, 0.5773, 0.0000> <-0.0638, 0.5773, 0.0174> <-0.0927, 0.5721, 0.0345> <-0.1099, 0.5690, 0.0345>
		<-0.0597, 0.5596, 0.0000> <-0.0597, 0.5596, 0.0174> <-0.0901, 0.5551, 0.0341> <-0.1073, 0.5520, 0.0341>
		<-0.0292, 0.5483, 0.0000> <-0.0292, 0.5483, 0.0285> <-0.0754, 0.5389, 0.0558> <-0.1035, 0.5338, 0.0558>
		<-0.0251, 0.5306, 0.0000> <-0.0251, 0.5306, 0.0285> <-0.0724, 0.5220, 0.0564> <-0.1005, 0.5170, 0.0564>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0251, 0.5306, 0.0000> <0.0022, 0.4131, 0.0000> <0.0274, 0.2537, 0.0000> <0.0390, 0.1337, 0.0000>
		<-0.0251, 0.5306, -0.0285> <0.0022, 0.4131, -0.0285> <0.0274, 0.2537, -0.0258> <0.0390, 0.1337, -0.0258>
		<-0.0724, 0.5220, -0.0564> <-0.0510, 0.4034, -0.0608> <-0.0251, 0.2444, -0.0583> <-0.0037, 0.1260, -0.0509>
		<-0.1005, 0.5170, -0.0564> <-0.0791, 0.3984, -0.0608> <-0.0504, 0.2399, -0.0583> <-0.0290, 0.1214, -0.0509>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0251, 0.5306, 0.0000> <-0.0251, 0.5306, 0.0285> <-0.0724, 0.5220, 0.0564> <-0.1005, 0.5170, 0.0564>
		<0.0022, 0.4131, 0.0000> <0.0022, 0.4131, 0.0285> <-0.0510, 0.4034, 0.0608> <-0.0791, 0.3984, 0.0608>
		<0.0274, 0.2537, 0.0000> <0.0274, 0.2537, 0.0258> <-0.0251, 0.2444, 0.0583> <-0.0504, 0.2399, 0.0583>
		<0.0390, 0.1337, 0.0000> <0.0390, 0.1337, 0.0258> <-0.0037, 0.1260, 0.0509> <-0.0290, 0.1214, 0.0509>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0390, 0.1337, 0.0000> <0.0407, 0.1165, 0.0000> <0.0149, 0.0968, 0.0000> <0.0184, 0.0798, 0.0000>
		<0.0390, 0.1337, -0.0258> <0.0407, 0.1165, -0.0258> <0.0149, 0.0968, -0.0146> <0.0184, 0.0798, -0.0146>
		<-0.0037, 0.1260, -0.0509> <-0.0008, 0.1101, -0.0500> <-0.0087, 0.0914, -0.0284> <-0.0059, 0.0754, -0.0290>
		<-0.0290, 0.1214, -0.0509> <-0.0262, 0.1055, -0.0500> <-0.0232, 0.0888, -0.0284> <-0.0203, 0.0728, -0.0290>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0390, 0.1337, 0.0000> <0.0390, 0.1337, 0.0258> <-0.0037, 0.1260, 0.0509> <-0.0290, 0.1214, 0.0509>
		<0.0407, 0.1165, 0.0000> <0.0407, 0.1165, 0.0258> <-0.0008, 0.1101, 0.0500> <-0.0262, 0.1055, 0.0500>
		<0.0149, 0.0968, 0.0000> <0.0149, 0.0968, 0.0146> <-0.0091, 0.0913, 0.0284> <-0.0235, 0.0887, 0.0284>
		<0.0184, 0.0798, 0.0000> <0.0184, 0.0798, 0.0146> <-0.0059, 0.0754, 0.0290> <-0.0203, 0.0728, 0.0290>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0184, 0.0798, 0.0000> <0.0218, 0.0633, 0.0000> <0.0518, 0.0559, 0.0000> <0.0584, 0.0404, 0.0000>
		<0.0184, 0.0798, -0.0146> <0.0218, 0.0633, -0.0146> <0.0512, 0.0558, -0.0271> <0.0578, 0.0403, -0.0271>
		<-0.0059, 0.0754, -0.0290> <-0.0027, 0.0581, -0.0296> <0.0126, 0.0434, -0.0517> <0.0157, 0.0263, -0.0546>
		<-0.0203, 0.0728, -0.0290> <-0.0171, 0.0555, -0.0296> <-0.0140, 0.0379, -0.0517> <-0.0109, 0.0208, -0.0546>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0184, 0.0798, 0.0000> <0.0184, 0.0798, 0.0146> <-0.0059, 0.0754, 0.0290> <-0.0203, 0.0728, 0.0290>
		<0.0218, 0.0633, 0.0000> <0.0218, 0.0633, 0.0146> <-0.0023, 0.0582, 0.0296> <-0.0167, 0.0555, 0.0296>
		<0.0518, 0.0559, 0.0000> <0.0524, 0.0560, 0.0265> <0.0144, 0.0437, 0.0517> <-0.0115, 0.0384, 0.0517>
		<0.0584, 0.0404, 0.0000> <0.0590, 0.0406, 0.0265> <0.0175, 0.0266, 0.0546> <-0.0084, 0.0212, 0.0546>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0584, 0.0404, 0.0000> <0.0635, 0.0283, 0.0000> <0.0632, 0.0057, 0.0000> <0.0536, -0.0034, 0.0000>
		<0.0578, 0.0403, -0.0271> <0.0629, 0.0282, -0.0271> <0.0632, 0.0057, -0.0221> <0.0536, -0.0034, -0.0221>
		<0.0157, 0.0263, -0.0546> <0.0176, 0.0155, -0.0564> <0.0159, -0.0036, -0.0526> <0.0171, -0.0100, -0.0436>
		<-0.0109, 0.0208, -0.0546> <-0.0089, 0.0100, -0.0564> <-0.0058, -0.0075, -0.0526> <-0.0046, -0.0139, -0.0436>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0584, 0.0404, 0.0000> <0.0590, 0.0406, 0.0265> <0.0175, 0.0266, 0.0546> <-0.0084, 0.0212, 0.0546>
		<0.0635, 0.0283, 0.0000> <0.0641, 0.0284, 0.0265> <0.0195, 0.0158, 0.0564> <-0.0065, 0.0104, 0.0564>
		<0.0632, 0.0057, 0.0000> <0.0632, 0.0057, 0.0221> <0.0163, -0.0035, 0.0526> <-0.0054, -0.0074, 0.0526>
		<0.0536, -0.0034, 0.0000> <0.0536, -0.0034, 0.0221> <0.0171, -0.0100, 0.0436> <-0.0046, -0.0139, 0.0436>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0536, -0.0034, 0.0000> <0.0412, -0.0153, 0.0000> <0.0147, -0.0129, 0.0000> <-0.0020, -0.0170, 0.0000>
		<0.0536, -0.0034, -0.0221> <0.0412, -0.0153, -0.0221> <0.0147, -0.0129, -0.0007> <-0.0020, -0.0170, -0.0007>
		<0.0171, -0.0100, -0.0436> <0.0184, -0.0174, -0.0334> <-0.0034, -0.0162, -0.0141> <-0.0033, -0.0173, -0.0015>
		<-0.0046, -0.0139, -0.0436> <-0.0033, -0.0213, -0.0334> <-0.0042, -0.0163, -0.0141> <-0.0040, -0.0174, -0.0015>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0536, -0.0034, 0.0000> <0.0536, -0.0034, 0.0221> <0.0171, -0.0100, 0.0436> <-0.0046, -0.0139, 0.0436>
		<0.0412, -0.0153, 0.0000> <0.0412, -0.0153, 0.0221> <0.0180, -0.0174, 0.0334> <-0.0038, -0.0214, 0.0334>
		<0.0147, -0.0129, 0.0000> <0.0147, -0.0129, 0.0007> <-0.0034, -0.0162, 0.0141> <-0.0042, -0.0163, 0.0141>
		<-0.0020, -0.0170, 0.0000> <-0.0020, -0.0170, 0.0007> <-0.0033, -0.0173, 0.0015> <-0.0040, -0.0174, 0.0015>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1250, 0.6527, 0.0113> <-0.1306, 0.6517, 0.0113> <-0.1400, 0.6500, 0.0057> <-0.1400, 0.6500, 0.0000>
		<-0.1248, 0.6517, 0.0207> <-0.1304, 0.6507, 0.0207> <-0.1524, 0.6467, 0.0057> <-0.1524, 0.6467, 0.0000>
		<-0.1259, 0.6555, 0.0356> <-0.1471, 0.6516, 0.0356> <-0.1723, 0.6481, 0.0216> <-0.1723, 0.6481, 0.0000>
		<-0.1244, 0.6493, 0.0426> <-0.1456, 0.6454, 0.0426> <-0.1813, 0.6390, 0.0216> <-0.1813, 0.6390, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1400, 0.6500, 0.0000> <-0.1400, 0.6500, -0.0057> <-0.1306, 0.6517, -0.0113> <-0.1250, 0.6527, -0.0113>
		<-0.1524, 0.6467, 0.0000> <-0.1524, 0.6467, -0.0057> <-0.1304, 0.6507, -0.0207> <-0.1248, 0.6517, -0.0207>
		<-0.1723, 0.6481, 0.0000> <-0.1723, 0.6481, -0.0216> <-0.1471, 0.6516, -0.0356> <-0.1259, 0.6555, -0.0356>
		<-0.1813, 0.6390, 0.0000> <-0.1813, 0.6390, -0.0216> <-0.1456, 0.6454, -0.0426> <-0.1244, 0.6493, -0.0426>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1244, 0.6493, 0.0426> <-0.1456, 0.6454, 0.0426> <-0.1813, 0.6390, 0.0216> <-0.1813, 0.6390, 0.0000>
		<-0.1224, 0.6409, 0.0520> <-0.1436, 0.6371, 0.0520> <-0.1894, 0.6308, 0.0216> <-0.1894, 0.6308, 0.0000>
		<-0.1172, 0.6235, 0.0595> <-0.1452, 0.6192, 0.0595> <-0.1921, 0.6123, 0.0283> <-0.1921, 0.6123, 0.0000>
		<-0.1149, 0.6111, 0.0583> <-0.1429, 0.6067, 0.0583> <-0.1885, 0.6014, 0.0283> <-0.1885, 0.6014, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1813, 0.6390, 0.0000> <-0.1813, 0.6390, -0.0216> <-0.1456, 0.6454, -0.0426> <-0.1244, 0.6493, -0.0426>
		<-0.1894, 0.6308, 0.0000> <-0.1894, 0.6308, -0.0216> <-0.1436, 0.6371, -0.0520> <-0.1224, 0.6409, -0.0520>
		<-0.1921, 0.6123, 0.0000> <-0.1921, 0.6123, -0.0283> <-0.1452, 0.6192, -0.0595> <-0.1172, 0.6235, -0.0595>
		<-0.1885, 0.6014, 0.0000> <-0.1885, 0.6014, -0.0283> <-0.1429, 0.6067, -0.0583> <-0.1149, 0.6111, -0.0583>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1149, 0.6111, 0.0583> <-0.1429, 0.6067, 0.0583> <-0.1885, 0.6014, 0.0283> <-0.1885, 0.6014, 0.0000>
		<-0.1124, 0.5968, 0.0568> <-0.1403, 0.5924, 0.0568> <-0.1837, 0.5865, 0.0283> <-0.1837, 0.5865, 0.0000>
		<-0.1121, 0.5834, 0.0347> <-0.1292, 0.5803, 0.0347> <-0.1587, 0.5761, 0.0174> <-0.1587, 0.5761, 0.0000>
		<-0.1099, 0.5690, 0.0345> <-0.1270, 0.5659, 0.0345> <-0.1559, 0.5607, 0.0174> <-0.1559, 0.5607, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1885, 0.6014, 0.0000> <-0.1885, 0.6014, -0.0283> <-0.1429, 0.6067, -0.0583> <-0.1149, 0.6111, -0.0583>
		<-0.1837, 0.5865, 0.0000> <-0.1837, 0.5865, -0.0283> <-0.1403, 0.5924, -0.0568> <-0.1124, 0.5968, -0.0568>
		<-0.1587, 0.5761, 0.0000> <-0.1587, 0.5761, -0.0174> <-0.1292, 0.5803, -0.0347> <-0.1121, 0.5834, -0.0347>
		<-0.1559, 0.5607, 0.0000> <-0.1559, 0.5607, -0.0174> <-0.1270, 0.5659, -0.0345> <-0.1099, 0.5690, -0.0345>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1099, 0.5690, 0.0345> <-0.1270, 0.5659, 0.0345> <-0.1559, 0.5607, 0.0174> <-0.1559, 0.5607, 0.0000>
		<-0.1073, 0.5520, 0.0341> <-0.1244, 0.5489, 0.0341> <-0.1528, 0.5434, 0.0174> <-0.1528, 0.5434, 0.0000>
		<-0.1035, 0.5338, 0.0558> <-0.1304, 0.5290, 0.0558> <-0.1732, 0.5216, 0.0274> <-0.1732, 0.5216, 0.0000>
		<-0.1005, 0.5170, 0.0564> <-0.1274, 0.5121, 0.0564> <-0.1710, 0.5042, 0.0274> <-0.1710, 0.5042, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1559, 0.5607, 0.0000> <-0.1559, 0.5607, -0.0174> <-0.1270, 0.5659, -0.0345> <-0.1099, 0.5690, -0.0345>
		<-0.1528, 0.5434, 0.0000> <-0.1528, 0.5434, -0.0174> <-0.1244, 0.5489, -0.0341> <-0.1073, 0.5520, -0.0341>
		<-0.1732, 0.5216, 0.0000> <-0.1732, 0.5216, -0.0274> <-0.1304, 0.5290, -0.0558> <-0.1035, 0.5338, -0.0558>
		<-0.1710, 0.5042, 0.0000> <-0.1710, 0.5042, -0.0274> <-0.1274, 0.5121, -0.0564> <-0.1005, 0.5170, -0.0564>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1005, 0.5170, 0.0564> <-0.1274, 0.5121, 0.0564> <-0.1710, 0.5042, 0.0274> <-0.1710, 0.5042, 0.0000>
		<-0.0791, 0.3984, 0.0608> <-0.1060, 0.3935, 0.0608> <-0.1554, 0.3846, 0.0274> <-0.1554, 0.3846, 0.0000>
		<-0.0504, 0.2399, 0.0583> <-0.0758, 0.2353, 0.0583> <-0.1269, 0.2259, 0.0258> <-0.1269, 0.2259, 0.0000>
		<-0.0290, 0.1214, 0.0509> <-0.0544, 0.1168, 0.0509> <-0.0971, 0.1091, 0.0258> <-0.0971, 0.1091, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1710, 0.5042, 0.0000> <-0.1710, 0.5042, -0.0274> <-0.1274, 0.5121, -0.0564> <-0.1005, 0.5170, -0.0564>
		<-0.1554, 0.3846, 0.0000> <-0.1554, 0.3846, -0.0274> <-0.1060, 0.3935, -0.0608> <-0.0791, 0.3984, -0.0608>
		<-0.1269, 0.2259, 0.0000> <-0.1269, 0.2259, -0.0258> <-0.0758, 0.2353, -0.0583> <-0.0504, 0.2399, -0.0583>
		<-0.0971, 0.1091, 0.0000> <-0.0971, 0.1091, -0.0258> <-0.0544, 0.1168, -0.0509> <-0.0290, 0.1214, -0.0509>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0290, 0.1214, 0.0509> <-0.0544, 0.1168, 0.0509> <-0.0971, 0.1091, 0.0258> <-0.0971, 0.1091, 0.0000>
		<-0.0262, 0.1055, 0.0500> <-0.0515, 0.1009, 0.0500> <-0.0928, 0.0923, 0.0258> <-0.0928, 0.0923, 0.0000>
		<-0.0235, 0.0887, 0.0284> <-0.0380, 0.0861, 0.0284> <-0.0620, 0.0829, 0.0146> <-0.0620, 0.0829, 0.0000>
		<-0.0203, 0.0728, 0.0290> <-0.0347, 0.0702, 0.0290> <-0.0590, 0.0658, 0.0146> <-0.0590, 0.0658, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0971, 0.1091, 0.0000> <-0.0971, 0.1091, -0.0258> <-0.0544, 0.1168, -0.0509> <-0.0290, 0.1214, -0.0509>
		<-0.0928, 0.0923, 0.0000> <-0.0928, 0.0923, -0.0258> <-0.0515, 0.1009, -0.0500> <-0.0262, 0.1055, -0.0500>
		<-0.0620, 0.0829, 0.0000> <-0.0620, 0.0829, -0.0146> <-0.0376, 0.0862, -0.0284> <-0.0232, 0.0888, -0.0284>
		<-0.0590, 0.0658, 0.0000> <-0.0590, 0.0658, -0.0146> <-0.0347, 0.0702, -0.0290> <-0.0203, 0.0728, -0.0290>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0203, 0.0728, 0.0290> <-0.0347, 0.0702, 0.0290> <-0.0590, 0.0658, 0.0146> <-0.0590, 0.0658, 0.0000>
		<-0.0167, 0.0555, 0.0296> <-0.0311, 0.0529, 0.0296> <-0.0559, 0.0488, 0.0146> <-0.0559, 0.0488, 0.0000>
		<-0.0115, 0.0384, 0.0517> <-0.0380, 0.0329, 0.0517> <-0.0782, 0.0294, 0.0270> <-0.0788, 0.0293, 0.0000>
		<-0.0084, 0.0212, 0.0546> <-0.0349, 0.0158, 0.0546> <-0.0789, 0.0121, 0.0270> <-0.0796, 0.0120, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0590, 0.0658, 0.0000> <-0.0590, 0.0658, -0.0146> <-0.0347, 0.0702, -0.0290> <-0.0203, 0.0728, -0.0290>
		<-0.0559, 0.0488, 0.0000> <-0.0559, 0.0488, -0.0146> <-0.0316, 0.0529, -0.0296> <-0.0171, 0.0555, -0.0296>
		<-0.0788, 0.0293, 0.0000> <-0.0794, 0.0291, -0.0264> <-0.0399, 0.0325, -0.0517> <-0.0140, 0.0379, -0.0517>
		<-0.0796, 0.0120, 0.0000> <-0.0801, 0.0119, -0.0264> <-0.0368, 0.0154, -0.0546> <-0.0109, 0.0208, -0.0546>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0084, 0.0212, 0.0546> <-0.0349, 0.0158, 0.0546> <-0.0789, 0.0121, 0.0270> <-0.0796, 0.0120, 0.0000>
		<-0.0065, 0.0104, 0.0564> <-0.0330, 0.0050, 0.0564> <-0.0795, 0.0001, 0.0270> <-0.0801, -0.0000, 0.0000>
		<-0.0054, -0.0074, 0.0526> <-0.0271, -0.0113, 0.0526> <-0.0740, -0.0199, 0.0221> <-0.0740, -0.0199, 0.0000>
		<-0.0046, -0.0139, 0.0436> <-0.0263, -0.0178, 0.0436> <-0.0629, -0.0244, 0.0221> <-0.0629, -0.0244, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0796, 0.0120, 0.0000> <-0.0801, 0.0119, -0.0264> <-0.0368, 0.0154, -0.0546> <-0.0109, 0.0208, -0.0546>
		<-0.0801, -0.0000, 0.0000> <-0.0807, -0.0001, -0.0264> <-0.0348, 0.0047, -0.0564> <-0.0089, 0.0100, -0.0564>
		<-0.0740, -0.0199, 0.0000> <-0.0740, -0.0199, -0.0221> <-0.0275, -0.0114, -0.0526> <-0.0058, -0.0075, -0.0526>
		<-0.0629, -0.0244, 0.0000> <-0.0629, -0.0244, -0.0221> <-0.0263, -0.0178, -0.0436> <-0.0046, -0.0139, -0.0436>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0046, -0.0139, 0.0436> <-0.0263, -0.0178, 0.0436> <-0.0629, -0.0244, 0.0221> <-0.0629, -0.0244, 0.0000>
		<-0.0038, -0.0214, 0.0334> <-0.0255, -0.0253, 0.0334> <-0.0469, -0.0309, 0.0221> <-0.0469, -0.0309, 0.0000>
		<-0.0042, -0.0163, 0.0141> <-0.0049, -0.0165, 0.0141> <-0.0230, -0.0198, 0.0007> <-0.0230, -0.0198, 0.0000>
		<-0.0040, -0.0174, 0.0015> <-0.0047, -0.0175, 0.0015> <-0.0060, -0.0177, 0.0007> <-0.0060, -0.0177, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0629, -0.0244, 0.0000> <-0.0629, -0.0244, -0.0221> <-0.0263, -0.0178, -0.0436> <-0.0046, -0.0139, -0.0436>
		<-0.0469, -0.0309, 0.0000> <-0.0469, -0.0309, -0.0221> <-0.0250, -0.0252, -0.0334> <-0.0033, -0.0213, -0.0334>
		<-0.0230, -0.0198, 0.0000> <-0.0230, -0.0198, -0.0007> <-0.0049, -0.0165, -0.0141> <-0.0042, -0.0163, -0.0141>
		<-0.0060, -0.0177, 0.0000> <-0.0060, -0.0177, -0.0007> <-0.0047, -0.0175, -0.0015> <-0.0040, -0.0174, -0.0015>
	}
	pigment {color rgb <0.6, 0.55, 0.55>}
	finish {ambient 0.1 diffuse 0.7 phong 0.1}
	normal {crackle 0.5 scale <0.08, 0.04, 0.08>}
}

#declare Rope = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0270, 0.1375, 0.0000> <0.0340, 0.1218, 0.0000> <0.0487, 0.1022, 0.0000> <0.0503, 0.0850, 0.0000>
		<0.0270, 0.1375, -0.0212> <0.0340, 0.1218, -0.0212> <0.0487, 0.1022, -0.0263> <0.0503, 0.0850, -0.0263>
		<-0.0089, 0.1313, -0.0409> <-0.0061, 0.1148, -0.0438> <0.0028, 0.0939, -0.0517> <0.0057, 0.0773, -0.0507>
		<-0.0298, 0.1276, -0.0409> <-0.0269, 0.1112, -0.0438> <-0.0232, 0.0894, -0.0517> <-0.0203, 0.0727, -0.0507>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0270, 0.1375, 0.0000> <0.0270, 0.1375, 0.0212> <-0.0089, 0.1313, 0.0409> <-0.0298, 0.1276, 0.0409>
		<0.0340, 0.1218, 0.0000> <0.0340, 0.1218, 0.0212> <-0.0061, 0.1148, 0.0438> <-0.0269, 0.1112, 0.0438>
		<0.0487, 0.1022, 0.0000> <0.0487, 0.1022, 0.0263> <0.0028, 0.0939, 0.0517> <-0.0232, 0.0894, 0.0517>
		<0.0503, 0.0850, 0.0000> <0.0503, 0.0850, 0.0263> <0.0057, 0.0773, 0.0507> <-0.0203, 0.0727, 0.0507>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0503, 0.0850, 0.0000> <0.0518, 0.0685, 0.0000> <0.0407, 0.0475, 0.0000> <0.0366, 0.0314, 0.0000>
		<0.0503, 0.0850, -0.0263> <0.0518, 0.0685, -0.0263> <0.0407, 0.0475, -0.0180> <0.0366, 0.0314, -0.0180>
		<0.0057, 0.0773, -0.0507> <0.0084, 0.0616, -0.0498> <0.0035, 0.0410, -0.0395> <0.0061, 0.0261, -0.0347>
		<-0.0203, 0.0727, -0.0507> <-0.0175, 0.0571, -0.0498> <-0.0142, 0.0379, -0.0395> <-0.0116, 0.0230, -0.0347>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0503, 0.0850, 0.0000> <0.0503, 0.0850, 0.0263> <0.0057, 0.0773, 0.0507> <-0.0203, 0.0727, 0.0507>
		<0.0518, 0.0685, 0.0000> <0.0518, 0.0685, 0.0263> <0.0084, 0.0616, 0.0498> <-0.0175, 0.0571, 0.0498>
		<0.0407, 0.0475, 0.0000> <0.0407, 0.0475, 0.0180> <0.0035, 0.0410, 0.0395> <-0.0142, 0.0379, 0.0395>
		<0.0366, 0.0314, 0.0000> <0.0366, 0.0314, 0.0180> <0.0061, 0.0261, 0.0347> <-0.0116, 0.0230, 0.0347>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0298, 0.1276, 0.0409> <-0.0507, 0.1240, 0.0409> <-0.0866, 0.1177, 0.0212> <-0.0866, 0.1177, 0.0000>
		<-0.0269, 0.1112, 0.0438> <-0.0478, 0.1075, 0.0438> <-0.0879, 0.1005, 0.0212> <-0.0879, 0.1005, 0.0000>
		<-0.0232, 0.0894, 0.0517> <-0.0491, 0.0849, 0.0517> <-0.0951, 0.0771, 0.0263> <-0.0951, 0.0771, 0.0000>
		<-0.0203, 0.0727, 0.0507> <-0.0462, 0.0682, 0.0507> <-0.0908, 0.0605, 0.0263> <-0.0908, 0.0605, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0866, 0.1177, 0.0000> <-0.0866, 0.1177, -0.0212> <-0.0507, 0.1240, -0.0409> <-0.0298, 0.1276, -0.0409>
		<-0.0879, 0.1005, 0.0000> <-0.0879, 0.1005, -0.0212> <-0.0478, 0.1075, -0.0438> <-0.0269, 0.1112, -0.0438>
		<-0.0951, 0.0771, 0.0000> <-0.0951, 0.0771, -0.0263> <-0.0491, 0.0849, -0.0517> <-0.0232, 0.0894, -0.0517>
		<-0.0908, 0.0605, 0.0000> <-0.0908, 0.0605, -0.0263> <-0.0462, 0.0682, -0.0507> <-0.0203, 0.0727, -0.0507>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0203, 0.0727, 0.0507> <-0.0462, 0.0682, 0.0507> <-0.0908, 0.0605, 0.0263> <-0.0908, 0.0605, 0.0000>
		<-0.0175, 0.0571, 0.0498> <-0.0435, 0.0526, 0.0498> <-0.0866, 0.0444, 0.0263> <-0.0866, 0.0444, 0.0000>
		<-0.0142, 0.0379, 0.0395> <-0.0319, 0.0348, 0.0395> <-0.0691, 0.0284, 0.0180> <-0.0691, 0.0284, 0.0000>
		<-0.0116, 0.0230, 0.0347> <-0.0293, 0.0199, 0.0347> <-0.0598, 0.0146, 0.0180> <-0.0598, 0.0146, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0908, 0.0605, 0.0000> <-0.0908, 0.0605, -0.0263> <-0.0462, 0.0682, -0.0507> <-0.0203, 0.0727, -0.0507>
		<-0.0866, 0.0444, 0.0000> <-0.0866, 0.0444, -0.0263> <-0.0435, 0.0526, -0.0498> <-0.0175, 0.0571, -0.0498>
		<-0.0691, 0.0284, 0.0000> <-0.0691, 0.0284, -0.0180> <-0.0319, 0.0348, -0.0395> <-0.0142, 0.0379, -0.0395>
		<-0.0598, 0.0146, 0.0000> <-0.0598, 0.0146, -0.0180> <-0.0293, 0.0199, -0.0347> <-0.0116, 0.0230, -0.0347>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0622, 0.6320, -0.0059> <-0.0553, 0.6162, -0.0059> <-0.0407, 0.5965, -0.0059> <-0.0392, 0.5794, -0.0059>
		<-0.0622, 0.6320, -0.0271> <-0.0553, 0.6162, -0.0271> <-0.0407, 0.5965, -0.0322> <-0.0392, 0.5794, -0.0322>
		<-0.0981, 0.6260, -0.0467> <-0.0954, 0.6095, -0.0497> <-0.0867, 0.5886, -0.0576> <-0.0839, 0.5719, -0.0566>
		<-0.1191, 0.6225, -0.0467> <-0.1163, 0.6060, -0.0497> <-0.1126, 0.5842, -0.0576> <-0.1098, 0.5675, -0.0566>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0622, 0.6320, -0.0059> <-0.0622, 0.6320, 0.0153> <-0.0981, 0.6260, 0.0350> <-0.1191, 0.6225, 0.0350>
		<-0.0553, 0.6162, -0.0059> <-0.0553, 0.6162, 0.0153> <-0.0954, 0.6095, 0.0380> <-0.1163, 0.6060, 0.0380>
		<-0.0407, 0.5965, -0.0059> <-0.0407, 0.5965, 0.0204> <-0.0867, 0.5886, 0.0459> <-0.1126, 0.5842, 0.0459>
		<-0.0392, 0.5794, -0.0059> <-0.0392, 0.5794, 0.0204> <-0.0839, 0.5719, 0.0449> <-0.1098, 0.5675, 0.0449>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0392, 0.5794, -0.0059> <-0.0378, 0.5628, -0.0059> <-0.0490, 0.5419, -0.0059> <-0.0532, 0.5258, -0.0059>
		<-0.0392, 0.5794, -0.0322> <-0.0378, 0.5628, -0.0322> <-0.0490, 0.5419, -0.0239> <-0.0532, 0.5258, -0.0239>
		<-0.0839, 0.5719, -0.0566> <-0.0812, 0.5562, -0.0557> <-0.0862, 0.5357, -0.0454> <-0.0837, 0.5207, -0.0406>
		<-0.1098, 0.5675, -0.0566> <-0.1072, 0.5519, -0.0557> <-0.1040, 0.5327, -0.0454> <-0.1015, 0.5177, -0.0406>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0392, 0.5794, -0.0059> <-0.0392, 0.5794, 0.0204> <-0.0839, 0.5719, 0.0449> <-0.1098, 0.5675, 0.0449>
		<-0.0378, 0.5628, -0.0059> <-0.0378, 0.5628, 0.0204> <-0.0812, 0.5562, 0.0439> <-0.1072, 0.5519, 0.0439>
		<-0.0490, 0.5419, -0.0059> <-0.0490, 0.5419, 0.0121> <-0.0862, 0.5357, 0.0336> <-0.1040, 0.5327, 0.0336>
		<-0.0532, 0.5258, -0.0059> <-0.0532, 0.5258, 0.0121> <-0.0837, 0.5207, 0.0288> <-0.1015, 0.5177, 0.0288>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1191, 0.6225, 0.0350> <-0.1400, 0.6190, 0.0350> <-0.1759, 0.6129, 0.0153> <-0.1759, 0.6129, -0.0059>
		<-0.1163, 0.6060, 0.0380> <-0.1372, 0.6025, 0.0380> <-0.1773, 0.5957, 0.0153> <-0.1773, 0.5957, -0.0059>
		<-0.1126, 0.5842, 0.0459> <-0.1386, 0.5799, 0.0459> <-0.1847, 0.5724, 0.0204> <-0.1847, 0.5724, -0.0059>
		<-0.1098, 0.5675, 0.0449> <-0.1358, 0.5632, 0.0449> <-0.1804, 0.5557, 0.0204> <-0.1804, 0.5557, -0.0059>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1759, 0.6129, -0.0059> <-0.1759, 0.6129, -0.0271> <-0.1400, 0.6190, -0.0467> <-0.1191, 0.6225, -0.0467>
		<-0.1773, 0.5957, -0.0059> <-0.1773, 0.5957, -0.0271> <-0.1372, 0.6025, -0.0497> <-0.1163, 0.6060, -0.0497>
		<-0.1847, 0.5724, -0.0059> <-0.1847, 0.5724, -0.0322> <-0.1386, 0.5799, -0.0576> <-0.1126, 0.5842, -0.0576>
		<-0.1804, 0.5557, -0.0059> <-0.1804, 0.5557, -0.0322> <-0.1358, 0.5632, -0.0566> <-0.1098, 0.5675, -0.0566>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1098, 0.5675, 0.0449> <-0.1358, 0.5632, 0.0449> <-0.1804, 0.5557, 0.0204> <-0.1804, 0.5557, -0.0059>
		<-0.1072, 0.5519, 0.0439> <-0.1332, 0.5475, 0.0439> <-0.1763, 0.5396, 0.0204> <-0.1763, 0.5396, -0.0059>
		<-0.1040, 0.5327, 0.0336> <-0.1217, 0.5297, 0.0336> <-0.1589, 0.5234, 0.0121> <-0.1589, 0.5234, -0.0059>
		<-0.1015, 0.5177, 0.0288> <-0.1192, 0.5148, 0.0288> <-0.1497, 0.5096, 0.0121> <-0.1497, 0.5096, -0.0059>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1804, 0.5557, -0.0059> <-0.1804, 0.5557, -0.0322> <-0.1358, 0.5632, -0.0566> <-0.1098, 0.5675, -0.0566>
		<-0.1763, 0.5396, -0.0059> <-0.1763, 0.5396, -0.0322> <-0.1332, 0.5475, -0.0557> <-0.1072, 0.5519, -0.0557>
		<-0.1589, 0.5234, -0.0059> <-0.1589, 0.5234, -0.0239> <-0.1217, 0.5297, -0.0454> <-0.1040, 0.5327, -0.0454>
		<-0.1497, 0.5096, -0.0059> <-0.1497, 0.5096, -0.0239> <-0.1192, 0.5148, -0.0406> <-0.1015, 0.5177, -0.0406>
	}
	pigment {color rgb <0.9, 0.8, 0.8>}
	finish {ambient 0.1 diffuse 0.7 phong 0.1}
	normal {bumps bump_size 0.3 scale 0.01}
}

#declare Sphere1 = sphere{0, 0.16 scale <1, 0.3, 0.3> texture{FairHair}}
#declare Part1 = union{
	Hair(Sphere1, 200, <0, 0, 0>, 0.45, FairHair) 
    Hair(Sphere1, 200, <-0.08, 0, 0>, 0.45, FairHair) 
    Hair(Sphere1, 200, <0.08, 0, 0>, 0.45, FairHair)
    
    rotate z*8
    rotate z*90
    translate <-0.14, 0.76, 0>
} 

#declare Feather3 = union {
	object{Center}
	object{Left}
	object{Right} 
	object{Fix}
	object{Rope}
	object{Part1}
}




