
#macro Hair(Object, Count, Center, Height, HairColor)
	#local R0 = 0.001;
	#local way = 0;
	#local theta = 0;    
	#local lseed = seed(1000);
	#local realHeight = Height/5 + ((4 * Height)/5 * rand(lseed));
	#while (theta < pi)
		#local way = way + 2 * pi * sin(theta);
		#local theta = theta + (pi / Count);
	#end
	#local part = way / Count;
	#local theta = pi / Count;
	#local last = 0;
	#while (theta < pi)
		#local way = 2 * pi * sin(theta);
		#local startangle = -2 * pi * last / way;
		#local stepangle = 2 * pi * part / way;
		#local way = way + last;
		#while (way >= part)
			#local way = way - part;
			#local startangle = startangle + stepangle;
			#local PointInRange = Center + <sin(theta) * cos(startangle), sin(theta) * sin(startangle), cos(theta)>;
			#local Normal = <0, 0, 0>;
			#local P0 = trace(Object, PointInRange, Center - PointInRange, Normal);
			cone { P0 R0 P0 + realHeight * Normal 0 texture{HairColor} no_shadow}
		#end
		#local last = way;
		#local theta = theta + (pi / Count);
	#end
#end  

#declare FairHair = texture {
	pigment { color rgb 0.8}
	finish{ambient 0.1 diffuse 0.8 phong 0}
} 

#declare Center = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0023, -0.0002, 0.0000> <-0.0023, -0.0002, 0.0013> <-0.0013, -0.0001, 0.0023> <-0.0000, 0.0000, 0.0023>
		<-0.0598, 0.2900, 0.0000> <-0.0598, 0.2900, 0.0013> <-0.0534, 0.2907, 0.0061> <-0.0521, 0.2908, 0.0061>
		<-0.1573, 0.6736, 0.0000> <-0.1573, 0.6736, 0.0097> <-0.1496, 0.6748, 0.0132> <-0.1399, 0.6759, 0.0132>
		<-0.1938, 0.9672, 0.0000> <-0.1938, 0.9672, 0.0097> <-0.1834, 0.9684, 0.0151> <-0.1738, 0.9694, 0.0151>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0023, -0.0002, 0.0000> <-0.0598, 0.2900, 0.0000> <-0.1573, 0.6736, 0.0000> <-0.1938, 0.9672, 0.0000>
		<-0.0023, -0.0002, -0.0013> <-0.0598, 0.2900, -0.0013> <-0.1573, 0.6735, -0.0097> <-0.1938, 0.9671, -0.0097>
		<-0.0012, -0.0001, -0.0023> <-0.0534, 0.2907, -0.0061> <-0.1496, 0.6747, -0.0132> <-0.1834, 0.9682, -0.0151>
		<0.0000, -0.0000, -0.0023> <-0.0521, 0.2908, -0.0061> <-0.1399, 0.6758, -0.0132> <-0.1738, 0.9693, -0.0151>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.0000, -0.0023> <-0.0521, 0.2908, -0.0061> <-0.1399, 0.6758, -0.0132> <-0.1738, 0.9693, -0.0151>
		<0.0013, 0.0001, -0.0023> <-0.0509, 0.2909, -0.0061> <-0.1302, 0.6768, -0.0132> <-0.1641, 0.9703, -0.0151>
		<0.0023, 0.0002, -0.0013> <-0.0445, 0.2916, -0.0013> <-0.1225, 0.6780, -0.0097> <-0.1537, 0.9715, -0.0097>
		<0.0023, 0.0002, 0.0000> <-0.0445, 0.2916, 0.0000> <-0.1225, 0.6781, 0.0000> <-0.1537, 0.9715, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0023, 0.0002, 0.0000> <-0.0445, 0.2916, 0.0000> <-0.1225, 0.6781, 0.0000> <-0.1537, 0.9715, 0.0000>
		<0.0023, 0.0002, 0.0013> <-0.0445, 0.2916, 0.0013> <-0.1225, 0.6781, 0.0097> <-0.1537, 0.9716, 0.0097>
		<0.0012, 0.0001, 0.0023> <-0.0509, 0.2909, 0.0061> <-0.1302, 0.6769, 0.0132> <-0.1641, 0.9705, 0.0151>
		<-0.0000, 0.0000, 0.0023> <-0.0521, 0.2908, 0.0061> <-0.1399, 0.6759, 0.0132> <-0.1738, 0.9694, 0.0151>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1938, 0.9672, 0.0000> <-0.1938, 0.9672, 0.0097> <-0.1834, 0.9684, 0.0151> <-0.1738, 0.9694, 0.0151>
		<-0.2290, 1.2503, 0.0000> <-0.2290, 1.2504, 0.0097> <-0.2161, 1.2512, 0.0169> <-0.2064, 1.2522, 0.0169>
		<-0.2519, 1.6320, 0.0000> <-0.2519, 1.6320, 0.0094> <-0.2413, 1.6327, 0.0150> <-0.2318, 1.6327, 0.0150>
		<-0.2407, 1.9171, 0.0000> <-0.2407, 1.9172, 0.0094> <-0.2306, 1.9172, 0.0146> <-0.2211, 1.9172, 0.0146>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1938, 0.9672, 0.0000> <-0.2290, 1.2503, 0.0000> <-0.2519, 1.6320, 0.0000> <-0.2407, 1.9171, 0.0000>
		<-0.1938, 0.9671, -0.0097> <-0.2290, 1.2503, -0.0097> <-0.2519, 1.6320, -0.0094> <-0.2407, 1.9171, -0.0094>
		<-0.1834, 0.9682, -0.0151> <-0.2160, 1.2510, -0.0169> <-0.2412, 1.6326, -0.0150> <-0.2306, 1.9171, -0.0146>
		<-0.1738, 0.9693, -0.0151> <-0.2064, 1.2521, -0.0169> <-0.2318, 1.6326, -0.0150> <-0.2211, 1.9171, -0.0146>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1738, 0.9693, -0.0151> <-0.2064, 1.2521, -0.0169> <-0.2318, 1.6326, -0.0150> <-0.2211, 1.9171, -0.0146>
		<-0.1641, 0.9703, -0.0151> <-0.1967, 1.2531, -0.0169> <-0.2224, 1.6326, -0.0150> <-0.2117, 1.9171, -0.0146>
		<-0.1537, 0.9715, -0.0097> <-0.1837, 1.2539, -0.0097> <-0.2118, 1.6332, -0.0094> <-0.2016, 1.9171, -0.0094>
		<-0.1537, 0.9715, 0.0000> <-0.1837, 1.2540, 0.0000> <-0.2118, 1.6333, 0.0000> <-0.2016, 1.9171, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1537, 0.9715, 0.0000> <-0.1837, 1.2540, 0.0000> <-0.2118, 1.6333, 0.0000> <-0.2016, 1.9171, 0.0000>
		<-0.1537, 0.9716, 0.0097> <-0.1837, 1.2540, 0.0097> <-0.2118, 1.6333, 0.0094> <-0.2016, 1.9172, 0.0094>
		<-0.1641, 0.9705, 0.0151> <-0.1967, 1.2533, 0.0169> <-0.2224, 1.6327, 0.0150> <-0.2117, 1.9172, 0.0146>
		<-0.1738, 0.9694, 0.0151> <-0.2064, 1.2522, 0.0169> <-0.2318, 1.6327, 0.0150> <-0.2211, 1.9172, 0.0146>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2407, 1.9171, 0.0000> <-0.2407, 1.9172, 0.0094> <-0.2306, 1.9172, 0.0146> <-0.2211, 1.9172, 0.0146>
		<-0.2292, 2.2091, 0.0000> <-0.2292, 2.2091, 0.0094> <-0.2196, 2.2082, 0.0142> <-0.2102, 2.2082, 0.0142>
		<-0.1767, 2.5970, 0.0000> <-0.1767, 2.5970, 0.0082> <-0.1652, 2.5960, 0.0147> <-0.1571, 2.5947, 0.0147>
		<-0.1187, 2.8834, 0.0000> <-0.1187, 2.8834, 0.0082> <-0.1100, 2.8820, 0.0127> <-0.1020, 2.8807, 0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2407, 1.9171, 0.0000> <-0.2292, 2.2091, 0.0000> <-0.1767, 2.5970, 0.0000> <-0.1187, 2.8834, 0.0000>
		<-0.2407, 1.9171, -0.0094> <-0.2292, 2.2090, -0.0094> <-0.1767, 2.5970, -0.0082> <-0.1187, 2.8833, -0.0082>
		<-0.2306, 1.9171, -0.0146> <-0.2196, 2.2081, -0.0142> <-0.1652, 2.5959, -0.0147> <-0.1100, 2.8819, -0.0127>
		<-0.2211, 1.9171, -0.0146> <-0.2102, 2.2081, -0.0142> <-0.1571, 2.5946, -0.0147> <-0.1020, 2.8806, -0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2211, 1.9171, -0.0146> <-0.2102, 2.2081, -0.0142> <-0.1571, 2.5946, -0.0147> <-0.1020, 2.8806, -0.0127>
		<-0.2117, 1.9171, -0.0146> <-0.2008, 2.2081, -0.0142> <-0.1491, 2.5933, -0.0147> <-0.0939, 2.8792, -0.0127>
		<-0.2016, 1.9171, -0.0094> <-0.1912, 2.2072, -0.0094> <-0.1376, 2.5923, -0.0082> <-0.0852, 2.8778, -0.0082>
		<-0.2016, 1.9171, 0.0000> <-0.1912, 2.2073, 0.0000> <-0.1376, 2.5923, 0.0000> <-0.0852, 2.8779, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2016, 1.9171, 0.0000> <-0.1912, 2.2073, 0.0000> <-0.1376, 2.5923, 0.0000> <-0.0852, 2.8779, 0.0000>
		<-0.2016, 1.9172, 0.0094> <-0.1912, 2.2073, 0.0094> <-0.1376, 2.5923, 0.0082> <-0.0852, 2.8779, 0.0082>
		<-0.2117, 1.9172, 0.0146> <-0.2008, 2.2082, 0.0142> <-0.1491, 2.5934, 0.0147> <-0.0939, 2.8793, 0.0127>
		<-0.2211, 1.9172, 0.0146> <-0.2102, 2.2082, 0.0142> <-0.1571, 2.5947, 0.0147> <-0.1020, 2.8807, 0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1414, 3.8051, 0.0000> <0.0634, 3.5286, 0.0000> <-0.0617, 3.1650, 0.0000> <-0.1187, 2.8834, 0.0000>
		<0.1414, 3.8051, 0.0008> <0.0634, 3.5286, 0.0008> <-0.0617, 3.1650, 0.0082> <-0.1187, 2.8834, 0.0082>
		<0.1421, 3.8049, 0.0016> <0.0686, 3.5277, 0.0049> <-0.0557, 3.1636, 0.0107> <-0.1100, 2.8820, 0.0127>
		<0.1429, 3.8047, 0.0016> <0.0695, 3.5275, 0.0049> <-0.0476, 3.1623, 0.0107> <-0.1020, 2.8807, 0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1414, 3.8051, 0.0000> <0.1414, 3.8051, -0.0008> <0.1421, 3.8049, -0.0016> <0.1429, 3.8047, -0.0016>
		<0.0634, 3.5286, 0.0000> <0.0634, 3.5286, -0.0008> <0.0686, 3.5277, -0.0049> <0.0694, 3.5274, -0.0049>
		<-0.0617, 3.1650, 0.0000> <-0.0617, 3.1649, -0.0082> <-0.0557, 3.1635, -0.0107> <-0.0477, 3.1622, -0.0107>
		<-0.1187, 2.8834, 0.0000> <-0.1187, 2.8833, -0.0082> <-0.1100, 2.8819, -0.0127> <-0.1020, 2.8806, -0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1429, 3.8047, -0.0016> <0.1437, 3.8044, -0.0016> <0.1444, 3.8042, -0.0008> <0.1444, 3.8042, 0.0000>
		<0.0694, 3.5274, -0.0049> <0.0703, 3.5272, -0.0049> <0.0755, 3.5263, -0.0008> <0.0755, 3.5263, 0.0000>
		<-0.0477, 3.1622, -0.0107> <-0.0396, 3.1609, -0.0107> <-0.0336, 3.1594, -0.0082> <-0.0336, 3.1595, 0.0000>
		<-0.1020, 2.8806, -0.0127> <-0.0939, 2.8792, -0.0127> <-0.0852, 2.8778, -0.0082> <-0.0852, 2.8779, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1444, 3.8042, 0.0000> <0.1444, 3.8042, 0.0008> <0.1437, 3.8044, 0.0016> <0.1429, 3.8047, 0.0016>
		<0.0755, 3.5263, 0.0000> <0.0755, 3.5263, 0.0008> <0.0703, 3.5272, 0.0049> <0.0695, 3.5275, 0.0049>
		<-0.0336, 3.1595, 0.0000> <-0.0336, 3.1595, 0.0082> <-0.0396, 3.1609, 0.0107> <-0.0476, 3.1623, 0.0107>
		<-0.0852, 2.8779, 0.0000> <-0.0852, 2.8779, 0.0082> <-0.0939, 2.8793, 0.0127> <-0.1020, 2.8807, 0.0127>
	}
	
	pigment { rgb <0.96, 0.94, 0.92>}
	finish {ambient 0 diffuse 0.85 phong 0.2}
} 

#declare Right = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1518, 3.8143, 0.0000> <0.1358, 3.7583, 0.0000> <0.1143, 3.6837, 0.0000> <0.0983, 3.6278, 0.0000>
		<0.1518, 3.8143, 0.0000> <0.1798, 3.7010, 0.0000> <0.1744, 3.6823, 0.0000> <0.1584, 3.6264, 0.0000>
		<0.1518, 3.8143, 0.0000> <0.1798, 3.7010, 0.0000> <0.2253, 3.6956, 0.0000> <0.2385, 3.6245, 0.0000>
		<0.1518, 3.8143, 0.0000> <0.1958, 3.7569, 0.0000> <0.2853, 3.6942, 0.0000> <0.2986, 3.6231, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2148, 1.5102, 0.0000> <-0.2132, 1.4467, 0.0000> <-0.2092, 1.3619, 0.0000> <-0.2068, 1.2984, 0.0000>
		<-0.1103, 1.5541, 0.0000> <-0.1087, 1.4906, 0.0000> <-0.0943, 1.3838, 0.0000> <-0.0918, 1.3202, 0.0000>
		<0.0291, 1.6127, 0.0000> <0.0390, 1.5267, 0.0000> <0.0618, 1.4359, 0.0000> <0.0614, 1.3493, 0.0000>
		<0.1336, 1.6566, 0.0000> <0.1436, 1.5706, 0.0000> <0.1768, 1.4578, 0.0000> <0.1764, 1.3712, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2148, 1.5102, 0.0000> <-0.1103, 1.5541, 0.0000> <0.0291, 1.6127, 0.0000> <0.1336, 1.6566, 0.0000>
		<-0.2180, 1.6337, 0.0000> <-0.1135, 1.6776, 0.0000> <0.0215, 1.6783, 0.0000> <0.1261, 1.7222, 0.0000>
		<-0.2247, 1.7983, 0.0000> <-0.1224, 1.7847, 0.0000> <0.0173, 1.8239, 0.0000> <0.1195, 1.8103, 0.0000>
		<-0.2229, 1.9217, 0.0000> <-0.1206, 1.9081, 0.0000> <0.0157, 1.8900, 0.0000> <0.1180, 1.8764, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2229, 1.9217, 0.0000> <-0.1206, 1.9081, 0.0000> <0.0157, 1.8900, 0.0000> <0.1180, 1.8764, 0.0000>
		<-0.2223, 1.9633, 0.0000> <-0.1200, 1.9497, 0.0000> <0.0147, 1.9355, 0.0000> <0.1169, 1.9219, 0.0000>
		<-0.2109, 2.0180, 0.0000> <-0.1113, 2.0086, 0.0000> <0.0233, 1.9919, 0.0000> <0.1229, 1.9825, 0.0000>
		<-0.2069, 2.0594, 0.0000> <-0.1073, 2.0500, 0.0000> <0.0254, 2.0374, 0.0000> <0.1250, 2.0280, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1250, 2.0280, 0.0000> <0.1363, 2.0878, 0.0000> <0.1515, 2.1676, 0.0000> <0.1629, 2.2274, 0.0000>
		<0.0254, 2.0374, 0.0000> <0.0368, 2.0973, 0.0000> <0.0426, 2.1461, 0.0000> <0.0539, 2.2059, 0.0000>
		<-0.1073, 2.0500, 0.0000> <-0.1045, 2.0788, 0.0000> <-0.0926, 2.1483, 0.0000> <-0.0913, 2.1772, 0.0000>
		<-0.2069, 2.0594, 0.0000> <-0.2041, 2.0882, 0.0000> <-0.2015, 2.1268, 0.0000> <-0.2002, 2.1557, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0983, 3.6278, 0.0000> <0.0713, 3.5335, 0.0000> <0.0355, 3.4078, 0.0000> <0.0085, 3.3135, 0.0000>
		<0.1584, 3.6264, 0.0000> <0.1314, 3.5321, 0.0000> <0.1159, 3.3570, 0.0000> <0.0890, 3.2627, 0.0000>
		<0.2385, 3.6245, 0.0000> <0.2649, 3.4831, 0.0000> <0.2028, 3.3386, 0.0000> <0.1963, 3.1949, 0.0000>
		<0.2986, 3.6231, 0.0000> <0.3250, 3.4817, 0.0000> <0.2833, 3.2878, 0.0000> <0.2768, 3.1441, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2002, 2.1557, 0.0000> <-0.0913, 2.1772, 0.0000> <0.0539, 2.2059, 0.0000> <0.1629, 2.2274, 0.0000>
		<-0.1989, 2.1871, 0.0000> <-0.0899, 2.2086, 0.0000> <0.0162, 2.2369, 0.0000> <0.1251, 2.2585, 0.0000>
		<-0.1988, 2.2290, 0.0000> <-0.1282, 2.2501, 0.0000> <0.0078, 2.2437, 0.0000> <0.0646, 2.2905, 0.0000>
		<-0.1981, 2.2603, 0.0000> <-0.1276, 2.2815, 0.0000> <-0.0198, 2.2840, 0.0000> <0.0370, 2.3309, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2068, 1.2984, 0.0000> <-0.1990, 1.2192, 0.0000> <-0.1905, 1.1134, 0.0000> <-0.1808, 1.0344, 0.0000>
		<-0.0918, 1.3202, 0.0000> <-0.0841, 1.2410, 0.0000> <-0.0972, 1.0862, 0.0000> <-0.0876, 1.0072, 0.0000>
		<0.0614, 1.3493, 0.0000> <0.0608, 1.2204, 0.0000> <0.0846, 1.0908, 0.0000> <0.0368, 0.9710, 0.0000>
		<0.1764, 1.3712, 0.0000> <0.1757, 1.2423, 0.0000> <0.1779, 1.0637, 0.0000> <0.1301, 0.9439, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1799, 2.5721, 0.0000> <0.1327, 2.5302, 0.0000> <0.0723, 2.4713, 0.0000> <0.0225, 2.4326, 0.0000>
		<0.1799, 2.5721, 0.0000> <0.0898, 2.4579, 0.0000> <0.0767, 2.4407, 0.0000> <0.0268, 2.4021, 0.0000>
		<0.1799, 2.5721, 0.0000> <0.0898, 2.4579, 0.0000> <0.0844, 2.4098, 0.0000> <0.0195, 2.3563, 0.0000>
		<0.1799, 2.5721, 0.0000> <0.1370, 2.4997, 0.0000> <0.1018, 2.3844, 0.0000> <0.0370, 2.3309, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1799, 2.5721, 0.0000> <0.1748, 2.4687, 0.0000> <0.1680, 2.3308, 0.0000> <0.1629, 2.2274, 0.0000>
		<0.1327, 2.5302, 0.0000> <0.1276, 2.4268, 0.0000> <0.1302, 2.3619, 0.0000> <0.1251, 2.2585, 0.0000>
		<0.0723, 2.4713, 0.0000> <0.0767, 2.4407, 0.0000> <0.0472, 2.3160, 0.0000> <0.0646, 2.2905, 0.0000>
		<0.0225, 2.4326, 0.0000> <0.0268, 2.4021, 0.0000> <0.0195, 2.3563, 0.0000> <0.0370, 2.3309, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1799, 2.5721, 0.0000> <0.1370, 2.4997, 0.0000> <0.1018, 2.3844, 0.0000> <0.0370, 2.3309, 0.0000>
		<0.1799, 2.5721, 0.0000> <0.1319, 2.3963, 0.0000> <0.1295, 2.3441, 0.0000> <0.0646, 2.2905, 0.0000>
		<0.1799, 2.5721, 0.0000> <0.1319, 2.3963, 0.0000> <0.1302, 2.3619, 0.0000> <0.1251, 2.2585, 0.0000>
		<0.1799, 2.5721, 0.0000> <0.1748, 2.4687, 0.0000> <0.1680, 2.3308, 0.0000> <0.1629, 2.2274, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1981, 2.2603, 0.0000> <-0.1769, 2.4049, 0.0000> <-0.1486, 2.5976, 0.0000> <-0.1274, 2.7421, 0.0000>
		<-0.1981, 2.2603, 0.0000> <-0.1618, 2.4222, 0.0000> <-0.1548, 2.4704, 0.0000> <-0.1336, 2.6149, 0.0000>
		<-0.1981, 2.2603, 0.0000> <-0.1618, 2.4222, 0.0000> <-0.1568, 2.4280, 0.0000> <-0.1418, 2.4453, 0.0000>
		<-0.1981, 2.2603, 0.0000> <-0.1830, 2.2777, 0.0000> <-0.1630, 2.3008, 0.0000> <-0.1479, 2.3181, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1981, 2.2603, 0.0000> <-0.1276, 2.2815, 0.0000> <-0.0198, 2.2840, 0.0000> <0.0370, 2.3309, 0.0000>
		<-0.1830, 2.2777, 0.0000> <-0.1125, 2.2988, 0.0000> <-0.0373, 2.3095, 0.0000> <0.0195, 2.3563, 0.0000>
		<-0.1630, 2.3008, 0.0000> <-0.1119, 2.3351, 0.0000> <-0.0219, 2.3644, 0.0000> <0.0268, 2.4021, 0.0000>
		<-0.1479, 2.3181, 0.0000> <-0.0968, 2.3525, 0.0000> <-0.0262, 2.3949, 0.0000> <0.0225, 2.4326, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1274, 2.7421, 0.0000> <-0.0866, 2.9135, 0.0000> <-0.0323, 3.1421, 0.0000> <0.0085, 3.3135, 0.0000>
		<-0.1274, 2.7421, 0.0000> <-0.0452, 2.9170, 0.0000> <-0.0316, 2.9741, 0.0000> <0.0092, 3.1456, 0.0000>
		<-0.1274, 2.7421, 0.0000> <-0.0452, 2.9170, 0.0000> <-0.0314, 2.9182, 0.0000> <0.0100, 2.9217, 0.0000>
		<-0.1274, 2.7421, 0.0000> <-0.0860, 2.7456, 0.0000> <-0.0308, 2.7502, 0.0000> <0.0106, 2.7537, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1274, 2.7421, 0.0000> <-0.0860, 2.7456, 0.0000> <-0.0308, 2.7502, 0.0000> <0.0106, 2.7537, 0.0000>
		<-0.0866, 2.9135, 0.0000> <-0.0452, 2.9170, 0.0000> <0.0490, 2.8674, 0.0000> <0.0905, 2.8708, 0.0000>
		<-0.0323, 3.1421, 0.0000> <0.0482, 3.0913, 0.0000> <0.1165, 3.0778, 0.0000> <0.1969, 3.0270, 0.0000>
		<0.0085, 3.3135, 0.0000> <0.0890, 3.2627, 0.0000> <0.1963, 3.1949, 0.0000> <0.2768, 3.1441, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1274, 2.7421, 0.0000> <-0.0860, 2.7456, 0.0000> <-0.0308, 2.7502, 0.0000> <0.0106, 2.7537, 0.0000>
		<-0.1336, 2.6149, 0.0000> <-0.0922, 2.6184, 0.0000> <-0.0282, 2.6678, 0.0000> <0.0132, 2.6713, 0.0000>
		<-0.1418, 2.4453, 0.0000> <-0.0916, 2.4935, 0.0000> <-0.0335, 2.5131, 0.0000> <0.0166, 2.5613, 0.0000>
		<-0.1479, 2.3181, 0.0000> <-0.0978, 2.3663, 0.0000> <-0.0310, 2.4306, 0.0000> <0.0191, 2.4788, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1799, 2.6272, 0.0000> <0.1914, 2.7019, 0.0000> <0.2043, 2.8020, 0.0000> <0.2182, 2.8763, 0.0000>
		<0.1291, 2.6652, 0.0000> <0.1406, 2.7399, 0.0000> <0.2194, 2.8828, 0.0000> <0.2333, 2.9572, 0.0000>
		<0.0614, 2.7158, 0.0000> <0.1413, 2.8329, 0.0000> <0.1794, 2.9467, 0.0000> <0.2592, 3.0638, 0.0000>
		<0.0106, 2.7537, 0.0000> <0.0905, 2.8708, 0.0000> <0.1969, 3.0270, 0.0000> <0.2768, 3.1441, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1799, 2.6272, 0.0000> <0.1291, 2.6652, 0.0000> <0.0614, 2.7158, 0.0000> <0.0106, 2.7537, 0.0000>
		<0.1799, 2.6272, 0.0000> <0.1406, 2.7399, 0.0000> <0.1237, 2.7526, 0.0000> <0.0729, 2.7905, 0.0000>
		<0.1799, 2.6272, 0.0000> <0.1406, 2.7399, 0.0000> <0.1420, 2.7652, 0.0000> <0.1559, 2.8396, 0.0000>
		<0.1799, 2.6272, 0.0000> <0.1914, 2.7019, 0.0000> <0.2043, 2.8020, 0.0000> <0.2182, 2.8763, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1799, 2.6272, 0.0000> <0.1317, 2.5827, 0.0000> <0.0674, 2.5233, 0.0000> <0.0191, 2.4788, 0.0000>
		<0.1914, 2.7019, 0.0000> <0.1432, 2.6574, 0.0000> <0.0648, 2.6058, 0.0000> <0.0166, 2.5613, 0.0000>
		<0.2043, 2.8020, 0.0000> <0.1420, 2.7652, 0.0000> <0.0755, 2.7080, 0.0000> <0.0132, 2.6713, 0.0000>
		<0.2182, 2.8763, 0.0000> <0.1559, 2.8396, 0.0000> <0.0729, 2.7905, 0.0000> <0.0106, 2.7537, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1799, 2.6272, 0.0000> <0.1317, 2.5827, 0.0000> <0.0674, 2.5233, 0.0000> <0.0191, 2.4788, 0.0000>
		<0.1799, 2.6272, 0.0000> <0.0809, 2.6206, 0.0000> <0.0648, 2.6058, 0.0000> <0.0166, 2.5613, 0.0000>
		<0.1799, 2.6272, 0.0000> <0.0809, 2.6206, 0.0000> <0.0640, 2.6333, 0.0000> <0.0132, 2.6713, 0.0000>
		<0.1799, 2.6272, 0.0000> <0.1291, 2.6652, 0.0000> <0.0614, 2.7158, 0.0000> <0.0106, 2.7537, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2768, 3.1441, 0.0000> <0.1969, 3.0270, 0.0000> <0.0905, 2.8708, 0.0000> <0.0106, 2.7537, 0.0000>
		<0.2768, 3.1441, 0.0000> <0.1794, 2.9467, 0.0000> <0.1527, 2.9076, 0.0000> <0.0729, 2.7905, 0.0000>
		<0.2768, 3.1441, 0.0000> <0.1794, 2.9467, 0.0000> <0.1711, 2.9204, 0.0000> <0.1559, 2.8396, 0.0000>
		<0.2768, 3.1441, 0.0000> <0.2592, 3.0638, 0.0000> <0.2333, 2.9572, 0.0000> <0.2182, 2.8763, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2768, 3.1441, 0.0000> <0.1963, 3.1949, 0.0000> <0.0890, 3.2627, 0.0000> <0.0085, 3.3135, 0.0000>
		<0.2592, 3.0638, 0.0000> <0.1787, 3.1146, 0.0000> <0.0896, 3.0948, 0.0000> <0.0092, 3.1456, 0.0000>
		<0.2333, 2.9572, 0.0000> <0.1711, 2.9204, 0.0000> <0.0723, 2.9584, 0.0000> <0.0100, 2.9217, 0.0000>
		<0.2182, 2.8763, 0.0000> <0.1559, 2.8396, 0.0000> <0.0729, 2.7905, 0.0000> <0.0106, 2.7537, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2768, 3.1441, 0.0000> <0.1969, 3.0270, 0.0000> <0.0905, 2.8708, 0.0000> <0.0106, 2.7537, 0.0000>
		<0.2768, 3.1441, 0.0000> <0.1165, 3.0778, 0.0000> <0.0898, 3.0388, 0.0000> <0.0100, 2.9217, 0.0000>
		<0.2768, 3.1441, 0.0000> <0.1165, 3.0778, 0.0000> <0.0896, 3.0948, 0.0000> <0.0092, 3.1456, 0.0000>
		<0.2768, 3.1441, 0.0000> <0.1963, 3.1949, 0.0000> <0.0890, 3.2627, 0.0000> <0.0085, 3.3135, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1235, 0.6192, 0.0000> <-0.0474, 0.7166, 0.0000> <0.0843, 0.8291, 0.0000> <0.1301, 0.9439, 0.0000>
		<-0.1235, 0.6192, 0.0000> <-0.0646, 0.8412, 0.0000> <-0.0090, 0.8562, 0.0000> <0.0368, 0.9710, 0.0000>
		<-0.1235, 0.6192, 0.0000> <-0.0646, 0.8412, 0.0000> <-0.0723, 0.8824, 0.0000> <-0.0876, 1.0072, 0.0000>
		<-0.1235, 0.6192, 0.0000> <-0.1407, 0.7438, 0.0000> <-0.1655, 0.9096, 0.0000> <-0.1808, 1.0344, 0.0000>
	}
	
    texture{      
	    pigment{
	        gradient y
	        color_map{
	            [0.0 0.6 color rgb <0.96, 0.94, 0.92> color rgb <0.96, 0.94, 0.92>] 
	            [0.6 0.8 color rgb <0.96, 0.94, 0.92> color rgb <0.26, 0.24, 0.22>]
	            [0.8 1.0 color rgb <0.26, 0.24, 0.22> color rgb <0.26, 0.24, 0.22>]
	        }
	        rotate -z*30
	        turbulence 0.3
	        scale 2      
	        translate y*1.65
	    }
		finish{ambient 0 diffuse 0.8 phong 0.1}
		normal{
		    onion
		    slope_map {
                [0 <0.5, 0.5>]   
                [0.2 <1, 0>]   
                [0.8  <1, 0>]   
                [1    <0.5, -0.5>]   
            } 
            turbulence 0.03           
            frequency 25
            scale <0.3, 1, 0.1>
            translate <-1, 15, 0>
		}  
	}
}

#declare Left = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3627, 0.8076, 0.0000> <-0.4360, 0.9163, 0.0000> <-0.4899, 1.0875, 0.0000> <-0.5211, 1.2148, 0.0000>
		<-0.3063, 0.8595, 0.0000> <-0.3796, 0.9682, 0.0000> <-0.3959, 1.1128, 0.0000> <-0.4271, 1.2401, 0.0000>
		<-0.2312, 0.9287, 0.0000> <-0.2434, 1.0240, 0.0000> <-0.2938, 1.1781, 0.0000> <-0.3017, 1.2738, 0.0000>
		<-0.1748, 0.9806, 0.0000> <-0.1870, 1.0759, 0.0000> <-0.1998, 1.2034, 0.0000> <-0.2076, 1.2991, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3627, 0.8076, 0.0000> <-0.3063, 0.8595, 0.0000> <-0.2312, 0.9287, 0.0000> <-0.1748, 0.9806, 0.0000>
		<-0.3627, 0.8076, 0.0000> <-0.2549, 0.7833, 0.0000> <-0.2172, 0.8202, 0.0000> <-0.1608, 0.8721, 0.0000>
		<-0.3627, 0.8076, 0.0000> <-0.2549, 0.7833, 0.0000> <-0.2093, 0.7845, 0.0000> <-0.1365, 0.7282, 0.0000>
		<-0.3627, 0.8076, 0.0000> <-0.3113, 0.7314, 0.0000> <-0.1929, 0.6763, 0.0000> <-0.1201, 0.6200, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5211, 1.2148, 0.0000> <-0.5472, 1.3209, 0.0000> <-0.5530, 1.4684, 0.0000> <-0.5515, 1.5777, 0.0000>
		<-0.4271, 1.2401, 0.0000> <-0.4531, 1.3462, 0.0000> <-0.4529, 1.4483, 0.0000> <-0.4515, 1.5575, 0.0000>
		<-0.3017, 1.2738, 0.0000> <-0.3069, 1.3371, 0.0000> <-0.3168, 1.4671, 0.0000> <-0.3181, 1.5306, 0.0000>
		<-0.2076, 1.2991, 0.0000> <-0.2128, 1.3624, 0.0000> <-0.2168, 1.4470, 0.0000> <-0.2181, 1.5105, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5515, 1.5777, 0.0000> <-0.5500, 1.6950, 0.0000> <-0.5233, 1.8499, 0.0000> <-0.5113, 1.9666, 0.0000>
		<-0.4515, 1.5575, 0.0000> <-0.4500, 1.6748, 0.0000> <-0.4360, 1.8363, 0.0000> <-0.4240, 1.9530, 0.0000>
		<-0.3181, 1.5306, 0.0000> <-0.3207, 1.6538, 0.0000> <-0.3117, 1.8117, 0.0000> <-0.3076, 1.9348, 0.0000>
		<-0.2181, 1.5105, 0.0000> <-0.2206, 1.6337, 0.0000> <-0.2244, 1.7981, 0.0000> <-0.2203, 1.9212, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5113, 1.9666, 0.0000> <-0.4967, 2.1080, 0.0000> <-0.4802, 2.2969, 0.0000> <-0.4628, 2.4380, 0.0000>
		<-0.4240, 1.9530, 0.0000> <-0.4094, 2.0944, 0.0000> <-0.3990, 2.2552, 0.0000> <-0.3815, 2.3963, 0.0000>
		<-0.3076, 1.9348, 0.0000> <-0.3039, 2.0484, 0.0000> <-0.2844, 2.2276, 0.0000> <-0.2732, 2.3407, 0.0000>
		<-0.2203, 1.9212, 0.0000> <-0.2166, 2.0348, 0.0000> <-0.2031, 2.1859, 0.0000> <-0.1919, 2.2989, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4628, 2.4380, 0.0000> <-0.4527, 2.5193, 0.0000> <-0.4350, 2.6270, 0.0000> <-0.4194, 2.7074, 0.0000>
		<-0.3815, 2.3963, 0.0000> <-0.3714, 2.4775, 0.0000> <-0.3565, 2.5798, 0.0000> <-0.3409, 2.6602, 0.0000>
		<-0.2732, 2.3407, 0.0000> <-0.2656, 2.4163, 0.0000> <-0.2473, 2.5220, 0.0000> <-0.2363, 2.5972, 0.0000>
		<-0.1919, 2.2989, 0.0000> <-0.1844, 2.3746, 0.0000> <-0.1689, 2.4748, 0.0000> <-0.1579, 2.5500, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3585, 2.9768, 0.0000> <-0.3361, 3.0630, 0.0000> <-0.3024, 3.1769, 0.0000> <-0.2752, 3.2617, 0.0000>
		<-0.2925, 2.8833, 0.0000> <-0.2701, 2.9695, 0.0000> <-0.2348, 3.1318, 0.0000> <-0.2076, 3.2166, 0.0000>
		<-0.2044, 2.7587, 0.0000> <-0.1787, 2.8927, 0.0000> <-0.1473, 3.0233, 0.0000> <-0.1175, 3.1564, 0.0000>
		<-0.1384, 2.6652, 0.0000> <-0.1126, 2.7992, 0.0000> <-0.0797, 2.9782, 0.0000> <-0.0499, 3.1113, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3585, 2.9768, 0.0000> <-0.2925, 2.8833, 0.0000> <-0.2044, 2.7587, 0.0000> <-0.1384, 2.6652, 0.0000>
		<-0.3794, 2.8966, 0.0000> <-0.3134, 2.8031, 0.0000> <-0.2111, 2.7242, 0.0000> <-0.1450, 2.6308, 0.0000>
		<-0.4037, 2.7888, 0.0000> <-0.3252, 2.7415, 0.0000> <-0.2313, 2.6319, 0.0000> <-0.1528, 2.5847, 0.0000>
		<-0.4194, 2.7074, 0.0000> <-0.3409, 2.6602, 0.0000> <-0.2363, 2.5972, 0.0000> <-0.1579, 2.5500, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0801, 3.7175, 0.0000> <-0.0270, 3.6912, 0.0000> <0.0439, 3.6561, 0.0000> <0.0971, 3.6298, 0.0000>
		<-0.1440, 3.6515, 0.0000> <-0.0908, 3.6251, 0.0000> <0.0168, 3.5619, 0.0000> <0.0700, 3.5356, 0.0000>
		<-0.1738, 3.5246, 0.0000> <-0.1086, 3.4873, 0.0000> <-0.0311, 3.4473, 0.0000> <0.0341, 3.4099, 0.0000>
		<-0.2099, 3.4402, 0.0000> <-0.1447, 3.4028, 0.0000> <-0.0578, 3.3530, 0.0000> <0.0073, 3.3156, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0801, 3.7175, 0.0000> <-0.0280, 3.7716, 0.0000> <0.0817, 3.7850, 0.0000> <0.1510, 3.8139, 0.0000>
		<-0.0801, 3.7175, 0.0000> <0.0252, 3.7453, 0.0000> <0.0655, 3.7298, 0.0000> <0.1348, 3.7587, 0.0000>
		<-0.0801, 3.7175, 0.0000> <0.0252, 3.7453, 0.0000> <0.0599, 3.7114, 0.0000> <0.1131, 3.6851, 0.0000>
		<-0.0801, 3.7175, 0.0000> <-0.0270, 3.6912, 0.0000> <0.0439, 3.6561, 0.0000> <0.0971, 3.6298, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2099, 3.4402, 0.0000> <-0.1447, 3.4028, 0.0000> <-0.0578, 3.3530, 0.0000> <0.0073, 3.3156, 0.0000>
		<-0.2323, 3.3878, 0.0000> <-0.1672, 3.3504, 0.0000> <-0.0752, 3.2917, 0.0000> <-0.0100, 3.2543, 0.0000>
		<-0.2578, 3.3160, 0.0000> <-0.1902, 3.2709, 0.0000> <-0.1036, 3.2185, 0.0000> <-0.0360, 3.1734, 0.0000>
		<-0.2752, 3.2617, 0.0000> <-0.2076, 3.2166, 0.0000> <-0.1175, 3.1564, 0.0000> <-0.0499, 3.1113, 0.0000>
	}
	
	texture{      
	    pigment{
	        gradient y
	        color_map{
	            [0.0 0.6 color rgb <0.96, 0.94, 0.92> color rgb <0.96, 0.94, 0.92>] 
	            [0.6 0.8 color rgb <0.96, 0.94, 0.92> color rgb <0.26, 0.24, 0.22>]
	            [0.8 1.0 color rgb <0.26, 0.24, 0.22> color rgb <0.26, 0.24, 0.22>]
	        }
	        rotate -z*30
	        turbulence 0.3
	        scale 2      
	        translate y*1.65
	    }
		finish{ambient 0 diffuse 0.8 phong 0.1}
		normal{
		    onion
		    slope_map {
                [0 <0.5, 0.5>]   
                [0.2 <1, 0>]   
                [0.8  <1, 0>]   
                [1    <0.5, -0.5>]   
            } 
            turbulence 0.03           
            frequency 20
            scale <0.26, 1, 0.1>
            translate <1.5, 15, 0>
		}  
	}
} 

#declare Fix = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1099, 0.6554, 0.0000> <-0.0972, 0.6567, 0.0000> <-0.0788, 0.6654, 0.0000> <-0.0674, 0.6595, 0.0000>
		<-0.1099, 0.6554, -0.0057> <-0.0972, 0.6567, -0.0057> <-0.0788, 0.6654, -0.0216> <-0.0674, 0.6595, -0.0216>
		<-0.1194, 0.6537, -0.0113> <-0.1192, 0.6527, -0.0207> <-0.1046, 0.6593, -0.0356> <-0.1031, 0.6531, -0.0426>
		<-0.1250, 0.6527, -0.0113> <-0.1248, 0.6517, -0.0207> <-0.1259, 0.6555, -0.0356> <-0.1244, 0.6493, -0.0426>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1099, 0.6554, 0.0000> <-0.1099, 0.6554, 0.0057> <-0.1194, 0.6537, 0.0113> <-0.1250, 0.6527, 0.0113>
		<-0.0972, 0.6567, 0.0000> <-0.0972, 0.6567, 0.0057> <-0.1192, 0.6527, 0.0207> <-0.1248, 0.6517, 0.0207>
		<-0.0788, 0.6654, 0.0000> <-0.0788, 0.6654, 0.0216> <-0.1046, 0.6593, 0.0356> <-0.1259, 0.6555, 0.0356>
		<-0.0674, 0.6595, 0.0000> <-0.0674, 0.6595, 0.0216> <-0.1031, 0.6531, 0.0426> <-0.1244, 0.6493, 0.0426>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0674, 0.6595, 0.0000> <-0.0563, 0.6539, 0.0000> <-0.0474, 0.6358, 0.0000> <-0.0469, 0.6234, 0.0000>
		<-0.0674, 0.6595, -0.0216> <-0.0563, 0.6539, -0.0216> <-0.0474, 0.6358, -0.0271> <-0.0469, 0.6234, -0.0271>
		<-0.1031, 0.6531, -0.0426> <-0.1011, 0.6448, -0.0520> <-0.0904, 0.6277, -0.0595> <-0.0881, 0.6152, -0.0583>
		<-0.1244, 0.6493, -0.0426> <-0.1224, 0.6409, -0.0520> <-0.1172, 0.6235, -0.0595> <-0.1149, 0.6111, -0.0583>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0674, 0.6595, 0.0000> <-0.0674, 0.6595, 0.0216> <-0.1031, 0.6531, 0.0426> <-0.1244, 0.6493, 0.0426>
		<-0.0563, 0.6539, 0.0000> <-0.0563, 0.6539, 0.0216> <-0.1011, 0.6448, 0.0520> <-0.1224, 0.6409, 0.0520>
		<-0.0474, 0.6358, 0.0000> <-0.0474, 0.6358, 0.0271> <-0.0904, 0.6277, 0.0595> <-0.1172, 0.6235, 0.0595>
		<-0.0469, 0.6234, 0.0000> <-0.0469, 0.6234, 0.0271> <-0.0881, 0.6152, 0.0583> <-0.1149, 0.6111, 0.0583>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0469, 0.6234, 0.0000> <-0.0463, 0.6087, 0.0000> <-0.0672, 0.5916, 0.0000> <-0.0638, 0.5773, 0.0000>
		<-0.0469, 0.6234, -0.0271> <-0.0463, 0.6087, -0.0271> <-0.0672, 0.5916, -0.0174> <-0.0638, 0.5773, -0.0174>
		<-0.0881, 0.6152, -0.0583> <-0.0856, 0.6010, -0.0568> <-0.0949, 0.5865, -0.0347> <-0.0927, 0.5721, -0.0345>
		<-0.1149, 0.6111, -0.0583> <-0.1124, 0.5968, -0.0568> <-0.1121, 0.5834, -0.0347> <-0.1099, 0.5690, -0.0345>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0469, 0.6234, 0.0000> <-0.0469, 0.6234, 0.0271> <-0.0881, 0.6152, 0.0583> <-0.1149, 0.6111, 0.0583>
		<-0.0463, 0.6087, 0.0000> <-0.0463, 0.6087, 0.0271> <-0.0856, 0.6010, 0.0568> <-0.1124, 0.5968, 0.0568>
		<-0.0672, 0.5916, 0.0000> <-0.0672, 0.5916, 0.0174> <-0.0949, 0.5865, 0.0347> <-0.1121, 0.5834, 0.0347>
		<-0.0638, 0.5773, 0.0000> <-0.0638, 0.5773, 0.0174> <-0.0927, 0.5721, 0.0345> <-0.1099, 0.5690, 0.0345>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0638, 0.5773, 0.0000> <-0.0597, 0.5596, 0.0000> <-0.0292, 0.5483, 0.0000> <-0.0251, 0.5306, 0.0000>
		<-0.0638, 0.5773, -0.0174> <-0.0597, 0.5596, -0.0174> <-0.0292, 0.5483, -0.0285> <-0.0251, 0.5306, -0.0285>
		<-0.0927, 0.5721, -0.0345> <-0.0901, 0.5551, -0.0341> <-0.0754, 0.5389, -0.0558> <-0.0724, 0.5220, -0.0564>
		<-0.1099, 0.5690, -0.0345> <-0.1073, 0.5520, -0.0341> <-0.1035, 0.5338, -0.0558> <-0.1005, 0.5170, -0.0564>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0638, 0.5773, 0.0000> <-0.0638, 0.5773, 0.0174> <-0.0927, 0.5721, 0.0345> <-0.1099, 0.5690, 0.0345>
		<-0.0597, 0.5596, 0.0000> <-0.0597, 0.5596, 0.0174> <-0.0901, 0.5551, 0.0341> <-0.1073, 0.5520, 0.0341>
		<-0.0292, 0.5483, 0.0000> <-0.0292, 0.5483, 0.0285> <-0.0754, 0.5389, 0.0558> <-0.1035, 0.5338, 0.0558>
		<-0.0251, 0.5306, 0.0000> <-0.0251, 0.5306, 0.0285> <-0.0724, 0.5220, 0.0564> <-0.1005, 0.5170, 0.0564>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0251, 0.5306, 0.0000> <0.0022, 0.4131, 0.0000> <0.0274, 0.2537, 0.0000> <0.0390, 0.1337, 0.0000>
		<-0.0251, 0.5306, -0.0285> <0.0022, 0.4131, -0.0285> <0.0274, 0.2537, -0.0258> <0.0390, 0.1337, -0.0258>
		<-0.0724, 0.5220, -0.0564> <-0.0510, 0.4034, -0.0608> <-0.0251, 0.2444, -0.0583> <-0.0037, 0.1260, -0.0509>
		<-0.1005, 0.5170, -0.0564> <-0.0791, 0.3984, -0.0608> <-0.0504, 0.2399, -0.0583> <-0.0290, 0.1214, -0.0509>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0251, 0.5306, 0.0000> <-0.0251, 0.5306, 0.0285> <-0.0724, 0.5220, 0.0564> <-0.1005, 0.5170, 0.0564>
		<0.0022, 0.4131, 0.0000> <0.0022, 0.4131, 0.0285> <-0.0510, 0.4034, 0.0608> <-0.0791, 0.3984, 0.0608>
		<0.0274, 0.2537, 0.0000> <0.0274, 0.2537, 0.0258> <-0.0251, 0.2444, 0.0583> <-0.0504, 0.2399, 0.0583>
		<0.0390, 0.1337, 0.0000> <0.0390, 0.1337, 0.0258> <-0.0037, 0.1260, 0.0509> <-0.0290, 0.1214, 0.0509>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0390, 0.1337, 0.0000> <0.0407, 0.1165, 0.0000> <0.0149, 0.0968, 0.0000> <0.0184, 0.0798, 0.0000>
		<0.0390, 0.1337, -0.0258> <0.0407, 0.1165, -0.0258> <0.0149, 0.0968, -0.0146> <0.0184, 0.0798, -0.0146>
		<-0.0037, 0.1260, -0.0509> <-0.0008, 0.1101, -0.0500> <-0.0087, 0.0914, -0.0284> <-0.0059, 0.0754, -0.0290>
		<-0.0290, 0.1214, -0.0509> <-0.0262, 0.1055, -0.0500> <-0.0232, 0.0888, -0.0284> <-0.0203, 0.0728, -0.0290>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0390, 0.1337, 0.0000> <0.0390, 0.1337, 0.0258> <-0.0037, 0.1260, 0.0509> <-0.0290, 0.1214, 0.0509>
		<0.0407, 0.1165, 0.0000> <0.0407, 0.1165, 0.0258> <-0.0008, 0.1101, 0.0500> <-0.0262, 0.1055, 0.0500>
		<0.0149, 0.0968, 0.0000> <0.0149, 0.0968, 0.0146> <-0.0091, 0.0913, 0.0284> <-0.0235, 0.0887, 0.0284>
		<0.0184, 0.0798, 0.0000> <0.0184, 0.0798, 0.0146> <-0.0059, 0.0754, 0.0290> <-0.0203, 0.0728, 0.0290>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0184, 0.0798, 0.0000> <0.0218, 0.0633, 0.0000> <0.0518, 0.0559, 0.0000> <0.0584, 0.0404, 0.0000>
		<0.0184, 0.0798, -0.0146> <0.0218, 0.0633, -0.0146> <0.0512, 0.0558, -0.0271> <0.0578, 0.0403, -0.0271>
		<-0.0059, 0.0754, -0.0290> <-0.0027, 0.0581, -0.0296> <0.0126, 0.0434, -0.0517> <0.0157, 0.0263, -0.0546>
		<-0.0203, 0.0728, -0.0290> <-0.0171, 0.0555, -0.0296> <-0.0140, 0.0379, -0.0517> <-0.0109, 0.0208, -0.0546>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0184, 0.0798, 0.0000> <0.0184, 0.0798, 0.0146> <-0.0059, 0.0754, 0.0290> <-0.0203, 0.0728, 0.0290>
		<0.0218, 0.0633, 0.0000> <0.0218, 0.0633, 0.0146> <-0.0023, 0.0582, 0.0296> <-0.0167, 0.0555, 0.0296>
		<0.0518, 0.0559, 0.0000> <0.0524, 0.0560, 0.0265> <0.0144, 0.0437, 0.0517> <-0.0115, 0.0384, 0.0517>
		<0.0584, 0.0404, 0.0000> <0.0590, 0.0406, 0.0265> <0.0175, 0.0266, 0.0546> <-0.0084, 0.0212, 0.0546>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0584, 0.0404, 0.0000> <0.0635, 0.0283, 0.0000> <0.0632, 0.0057, 0.0000> <0.0536, -0.0034, 0.0000>
		<0.0578, 0.0403, -0.0271> <0.0629, 0.0282, -0.0271> <0.0632, 0.0057, -0.0221> <0.0536, -0.0034, -0.0221>
		<0.0157, 0.0263, -0.0546> <0.0176, 0.0155, -0.0564> <0.0159, -0.0036, -0.0526> <0.0171, -0.0100, -0.0436>
		<-0.0109, 0.0208, -0.0546> <-0.0089, 0.0100, -0.0564> <-0.0058, -0.0075, -0.0526> <-0.0046, -0.0139, -0.0436>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0584, 0.0404, 0.0000> <0.0590, 0.0406, 0.0265> <0.0175, 0.0266, 0.0546> <-0.0084, 0.0212, 0.0546>
		<0.0635, 0.0283, 0.0000> <0.0641, 0.0284, 0.0265> <0.0195, 0.0158, 0.0564> <-0.0065, 0.0104, 0.0564>
		<0.0632, 0.0057, 0.0000> <0.0632, 0.0057, 0.0221> <0.0163, -0.0035, 0.0526> <-0.0054, -0.0074, 0.0526>
		<0.0536, -0.0034, 0.0000> <0.0536, -0.0034, 0.0221> <0.0171, -0.0100, 0.0436> <-0.0046, -0.0139, 0.0436>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0536, -0.0034, 0.0000> <0.0412, -0.0153, 0.0000> <0.0147, -0.0129, 0.0000> <-0.0020, -0.0170, 0.0000>
		<0.0536, -0.0034, -0.0221> <0.0412, -0.0153, -0.0221> <0.0147, -0.0129, -0.0007> <-0.0020, -0.0170, -0.0007>
		<0.0171, -0.0100, -0.0436> <0.0184, -0.0174, -0.0334> <-0.0034, -0.0162, -0.0141> <-0.0033, -0.0173, -0.0015>
		<-0.0046, -0.0139, -0.0436> <-0.0033, -0.0213, -0.0334> <-0.0042, -0.0163, -0.0141> <-0.0040, -0.0174, -0.0015>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0536, -0.0034, 0.0000> <0.0536, -0.0034, 0.0221> <0.0171, -0.0100, 0.0436> <-0.0046, -0.0139, 0.0436>
		<0.0412, -0.0153, 0.0000> <0.0412, -0.0153, 0.0221> <0.0180, -0.0174, 0.0334> <-0.0038, -0.0214, 0.0334>
		<0.0147, -0.0129, 0.0000> <0.0147, -0.0129, 0.0007> <-0.0034, -0.0162, 0.0141> <-0.0042, -0.0163, 0.0141>
		<-0.0020, -0.0170, 0.0000> <-0.0020, -0.0170, 0.0007> <-0.0033, -0.0173, 0.0015> <-0.0040, -0.0174, 0.0015>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1250, 0.6527, 0.0113> <-0.1306, 0.6517, 0.0113> <-0.1400, 0.6500, 0.0057> <-0.1400, 0.6500, 0.0000>
		<-0.1248, 0.6517, 0.0207> <-0.1304, 0.6507, 0.0207> <-0.1524, 0.6467, 0.0057> <-0.1524, 0.6467, 0.0000>
		<-0.1259, 0.6555, 0.0356> <-0.1471, 0.6516, 0.0356> <-0.1723, 0.6481, 0.0216> <-0.1723, 0.6481, 0.0000>
		<-0.1244, 0.6493, 0.0426> <-0.1456, 0.6454, 0.0426> <-0.1813, 0.6390, 0.0216> <-0.1813, 0.6390, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1400, 0.6500, 0.0000> <-0.1400, 0.6500, -0.0057> <-0.1306, 0.6517, -0.0113> <-0.1250, 0.6527, -0.0113>
		<-0.1524, 0.6467, 0.0000> <-0.1524, 0.6467, -0.0057> <-0.1304, 0.6507, -0.0207> <-0.1248, 0.6517, -0.0207>
		<-0.1723, 0.6481, 0.0000> <-0.1723, 0.6481, -0.0216> <-0.1471, 0.6516, -0.0356> <-0.1259, 0.6555, -0.0356>
		<-0.1813, 0.6390, 0.0000> <-0.1813, 0.6390, -0.0216> <-0.1456, 0.6454, -0.0426> <-0.1244, 0.6493, -0.0426>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1244, 0.6493, 0.0426> <-0.1456, 0.6454, 0.0426> <-0.1813, 0.6390, 0.0216> <-0.1813, 0.6390, 0.0000>
		<-0.1224, 0.6409, 0.0520> <-0.1436, 0.6371, 0.0520> <-0.1894, 0.6308, 0.0216> <-0.1894, 0.6308, 0.0000>
		<-0.1172, 0.6235, 0.0595> <-0.1452, 0.6192, 0.0595> <-0.1921, 0.6123, 0.0283> <-0.1921, 0.6123, 0.0000>
		<-0.1149, 0.6111, 0.0583> <-0.1429, 0.6067, 0.0583> <-0.1885, 0.6014, 0.0283> <-0.1885, 0.6014, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1813, 0.6390, 0.0000> <-0.1813, 0.6390, -0.0216> <-0.1456, 0.6454, -0.0426> <-0.1244, 0.6493, -0.0426>
		<-0.1894, 0.6308, 0.0000> <-0.1894, 0.6308, -0.0216> <-0.1436, 0.6371, -0.0520> <-0.1224, 0.6409, -0.0520>
		<-0.1921, 0.6123, 0.0000> <-0.1921, 0.6123, -0.0283> <-0.1452, 0.6192, -0.0595> <-0.1172, 0.6235, -0.0595>
		<-0.1885, 0.6014, 0.0000> <-0.1885, 0.6014, -0.0283> <-0.1429, 0.6067, -0.0583> <-0.1149, 0.6111, -0.0583>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1149, 0.6111, 0.0583> <-0.1429, 0.6067, 0.0583> <-0.1885, 0.6014, 0.0283> <-0.1885, 0.6014, 0.0000>
		<-0.1124, 0.5968, 0.0568> <-0.1403, 0.5924, 0.0568> <-0.1837, 0.5865, 0.0283> <-0.1837, 0.5865, 0.0000>
		<-0.1121, 0.5834, 0.0347> <-0.1292, 0.5803, 0.0347> <-0.1587, 0.5761, 0.0174> <-0.1587, 0.5761, 0.0000>
		<-0.1099, 0.5690, 0.0345> <-0.1270, 0.5659, 0.0345> <-0.1559, 0.5607, 0.0174> <-0.1559, 0.5607, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1885, 0.6014, 0.0000> <-0.1885, 0.6014, -0.0283> <-0.1429, 0.6067, -0.0583> <-0.1149, 0.6111, -0.0583>
		<-0.1837, 0.5865, 0.0000> <-0.1837, 0.5865, -0.0283> <-0.1403, 0.5924, -0.0568> <-0.1124, 0.5968, -0.0568>
		<-0.1587, 0.5761, 0.0000> <-0.1587, 0.5761, -0.0174> <-0.1292, 0.5803, -0.0347> <-0.1121, 0.5834, -0.0347>
		<-0.1559, 0.5607, 0.0000> <-0.1559, 0.5607, -0.0174> <-0.1270, 0.5659, -0.0345> <-0.1099, 0.5690, -0.0345>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1099, 0.5690, 0.0345> <-0.1270, 0.5659, 0.0345> <-0.1559, 0.5607, 0.0174> <-0.1559, 0.5607, 0.0000>
		<-0.1073, 0.5520, 0.0341> <-0.1244, 0.5489, 0.0341> <-0.1528, 0.5434, 0.0174> <-0.1528, 0.5434, 0.0000>
		<-0.1035, 0.5338, 0.0558> <-0.1304, 0.5290, 0.0558> <-0.1732, 0.5216, 0.0274> <-0.1732, 0.5216, 0.0000>
		<-0.1005, 0.5170, 0.0564> <-0.1274, 0.5121, 0.0564> <-0.1710, 0.5042, 0.0274> <-0.1710, 0.5042, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1559, 0.5607, 0.0000> <-0.1559, 0.5607, -0.0174> <-0.1270, 0.5659, -0.0345> <-0.1099, 0.5690, -0.0345>
		<-0.1528, 0.5434, 0.0000> <-0.1528, 0.5434, -0.0174> <-0.1244, 0.5489, -0.0341> <-0.1073, 0.5520, -0.0341>
		<-0.1732, 0.5216, 0.0000> <-0.1732, 0.5216, -0.0274> <-0.1304, 0.5290, -0.0558> <-0.1035, 0.5338, -0.0558>
		<-0.1710, 0.5042, 0.0000> <-0.1710, 0.5042, -0.0274> <-0.1274, 0.5121, -0.0564> <-0.1005, 0.5170, -0.0564>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1005, 0.5170, 0.0564> <-0.1274, 0.5121, 0.0564> <-0.1710, 0.5042, 0.0274> <-0.1710, 0.5042, 0.0000>
		<-0.0791, 0.3984, 0.0608> <-0.1060, 0.3935, 0.0608> <-0.1554, 0.3846, 0.0274> <-0.1554, 0.3846, 0.0000>
		<-0.0504, 0.2399, 0.0583> <-0.0758, 0.2353, 0.0583> <-0.1269, 0.2259, 0.0258> <-0.1269, 0.2259, 0.0000>
		<-0.0290, 0.1214, 0.0509> <-0.0544, 0.1168, 0.0509> <-0.0971, 0.1091, 0.0258> <-0.0971, 0.1091, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1710, 0.5042, 0.0000> <-0.1710, 0.5042, -0.0274> <-0.1274, 0.5121, -0.0564> <-0.1005, 0.5170, -0.0564>
		<-0.1554, 0.3846, 0.0000> <-0.1554, 0.3846, -0.0274> <-0.1060, 0.3935, -0.0608> <-0.0791, 0.3984, -0.0608>
		<-0.1269, 0.2259, 0.0000> <-0.1269, 0.2259, -0.0258> <-0.0758, 0.2353, -0.0583> <-0.0504, 0.2399, -0.0583>
		<-0.0971, 0.1091, 0.0000> <-0.0971, 0.1091, -0.0258> <-0.0544, 0.1168, -0.0509> <-0.0290, 0.1214, -0.0509>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0290, 0.1214, 0.0509> <-0.0544, 0.1168, 0.0509> <-0.0971, 0.1091, 0.0258> <-0.0971, 0.1091, 0.0000>
		<-0.0262, 0.1055, 0.0500> <-0.0515, 0.1009, 0.0500> <-0.0928, 0.0923, 0.0258> <-0.0928, 0.0923, 0.0000>
		<-0.0235, 0.0887, 0.0284> <-0.0380, 0.0861, 0.0284> <-0.0620, 0.0829, 0.0146> <-0.0620, 0.0829, 0.0000>
		<-0.0203, 0.0728, 0.0290> <-0.0347, 0.0702, 0.0290> <-0.0590, 0.0658, 0.0146> <-0.0590, 0.0658, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0971, 0.1091, 0.0000> <-0.0971, 0.1091, -0.0258> <-0.0544, 0.1168, -0.0509> <-0.0290, 0.1214, -0.0509>
		<-0.0928, 0.0923, 0.0000> <-0.0928, 0.0923, -0.0258> <-0.0515, 0.1009, -0.0500> <-0.0262, 0.1055, -0.0500>
		<-0.0620, 0.0829, 0.0000> <-0.0620, 0.0829, -0.0146> <-0.0376, 0.0862, -0.0284> <-0.0232, 0.0888, -0.0284>
		<-0.0590, 0.0658, 0.0000> <-0.0590, 0.0658, -0.0146> <-0.0347, 0.0702, -0.0290> <-0.0203, 0.0728, -0.0290>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0203, 0.0728, 0.0290> <-0.0347, 0.0702, 0.0290> <-0.0590, 0.0658, 0.0146> <-0.0590, 0.0658, 0.0000>
		<-0.0167, 0.0555, 0.0296> <-0.0311, 0.0529, 0.0296> <-0.0559, 0.0488, 0.0146> <-0.0559, 0.0488, 0.0000>
		<-0.0115, 0.0384, 0.0517> <-0.0380, 0.0329, 0.0517> <-0.0782, 0.0294, 0.0270> <-0.0788, 0.0293, 0.0000>
		<-0.0084, 0.0212, 0.0546> <-0.0349, 0.0158, 0.0546> <-0.0789, 0.0121, 0.0270> <-0.0796, 0.0120, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0590, 0.0658, 0.0000> <-0.0590, 0.0658, -0.0146> <-0.0347, 0.0702, -0.0290> <-0.0203, 0.0728, -0.0290>
		<-0.0559, 0.0488, 0.0000> <-0.0559, 0.0488, -0.0146> <-0.0316, 0.0529, -0.0296> <-0.0171, 0.0555, -0.0296>
		<-0.0788, 0.0293, 0.0000> <-0.0794, 0.0291, -0.0264> <-0.0399, 0.0325, -0.0517> <-0.0140, 0.0379, -0.0517>
		<-0.0796, 0.0120, 0.0000> <-0.0801, 0.0119, -0.0264> <-0.0368, 0.0154, -0.0546> <-0.0109, 0.0208, -0.0546>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0084, 0.0212, 0.0546> <-0.0349, 0.0158, 0.0546> <-0.0789, 0.0121, 0.0270> <-0.0796, 0.0120, 0.0000>
		<-0.0065, 0.0104, 0.0564> <-0.0330, 0.0050, 0.0564> <-0.0795, 0.0001, 0.0270> <-0.0801, -0.0000, 0.0000>
		<-0.0054, -0.0074, 0.0526> <-0.0271, -0.0113, 0.0526> <-0.0740, -0.0199, 0.0221> <-0.0740, -0.0199, 0.0000>
		<-0.0046, -0.0139, 0.0436> <-0.0263, -0.0178, 0.0436> <-0.0629, -0.0244, 0.0221> <-0.0629, -0.0244, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0796, 0.0120, 0.0000> <-0.0801, 0.0119, -0.0264> <-0.0368, 0.0154, -0.0546> <-0.0109, 0.0208, -0.0546>
		<-0.0801, -0.0000, 0.0000> <-0.0807, -0.0001, -0.0264> <-0.0348, 0.0047, -0.0564> <-0.0089, 0.0100, -0.0564>
		<-0.0740, -0.0199, 0.0000> <-0.0740, -0.0199, -0.0221> <-0.0275, -0.0114, -0.0526> <-0.0058, -0.0075, -0.0526>
		<-0.0629, -0.0244, 0.0000> <-0.0629, -0.0244, -0.0221> <-0.0263, -0.0178, -0.0436> <-0.0046, -0.0139, -0.0436>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0046, -0.0139, 0.0436> <-0.0263, -0.0178, 0.0436> <-0.0629, -0.0244, 0.0221> <-0.0629, -0.0244, 0.0000>
		<-0.0038, -0.0214, 0.0334> <-0.0255, -0.0253, 0.0334> <-0.0469, -0.0309, 0.0221> <-0.0469, -0.0309, 0.0000>
		<-0.0042, -0.0163, 0.0141> <-0.0049, -0.0165, 0.0141> <-0.0230, -0.0198, 0.0007> <-0.0230, -0.0198, 0.0000>
		<-0.0040, -0.0174, 0.0015> <-0.0047, -0.0175, 0.0015> <-0.0060, -0.0177, 0.0007> <-0.0060, -0.0177, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0629, -0.0244, 0.0000> <-0.0629, -0.0244, -0.0221> <-0.0263, -0.0178, -0.0436> <-0.0046, -0.0139, -0.0436>
		<-0.0469, -0.0309, 0.0000> <-0.0469, -0.0309, -0.0221> <-0.0250, -0.0252, -0.0334> <-0.0033, -0.0213, -0.0334>
		<-0.0230, -0.0198, 0.0000> <-0.0230, -0.0198, -0.0007> <-0.0049, -0.0165, -0.0141> <-0.0042, -0.0163, -0.0141>
		<-0.0060, -0.0177, 0.0000> <-0.0060, -0.0177, -0.0007> <-0.0047, -0.0175, -0.0015> <-0.0040, -0.0174, -0.0015>
	}
	pigment {color rgb <0.6, 0.55, 0.55>}
	finish {ambient 0.1 diffuse 0.7 phong 0.1}
	normal {crackle 0.5 scale <0.08, 0.04, 0.08>}
}

#declare Rope = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0270, 0.1375, 0.0000> <0.0340, 0.1218, 0.0000> <0.0487, 0.1022, 0.0000> <0.0503, 0.0850, 0.0000>
		<0.0270, 0.1375, -0.0212> <0.0340, 0.1218, -0.0212> <0.0487, 0.1022, -0.0263> <0.0503, 0.0850, -0.0263>
		<-0.0089, 0.1313, -0.0409> <-0.0061, 0.1148, -0.0438> <0.0028, 0.0939, -0.0517> <0.0057, 0.0773, -0.0507>
		<-0.0298, 0.1276, -0.0409> <-0.0269, 0.1112, -0.0438> <-0.0232, 0.0894, -0.0517> <-0.0203, 0.0727, -0.0507>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0270, 0.1375, 0.0000> <0.0270, 0.1375, 0.0212> <-0.0089, 0.1313, 0.0409> <-0.0298, 0.1276, 0.0409>
		<0.0340, 0.1218, 0.0000> <0.0340, 0.1218, 0.0212> <-0.0061, 0.1148, 0.0438> <-0.0269, 0.1112, 0.0438>
		<0.0487, 0.1022, 0.0000> <0.0487, 0.1022, 0.0263> <0.0028, 0.0939, 0.0517> <-0.0232, 0.0894, 0.0517>
		<0.0503, 0.0850, 0.0000> <0.0503, 0.0850, 0.0263> <0.0057, 0.0773, 0.0507> <-0.0203, 0.0727, 0.0507>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0503, 0.0850, 0.0000> <0.0518, 0.0685, 0.0000> <0.0407, 0.0475, 0.0000> <0.0366, 0.0314, 0.0000>
		<0.0503, 0.0850, -0.0263> <0.0518, 0.0685, -0.0263> <0.0407, 0.0475, -0.0180> <0.0366, 0.0314, -0.0180>
		<0.0057, 0.0773, -0.0507> <0.0084, 0.0616, -0.0498> <0.0035, 0.0410, -0.0395> <0.0061, 0.0261, -0.0347>
		<-0.0203, 0.0727, -0.0507> <-0.0175, 0.0571, -0.0498> <-0.0142, 0.0379, -0.0395> <-0.0116, 0.0230, -0.0347>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0503, 0.0850, 0.0000> <0.0503, 0.0850, 0.0263> <0.0057, 0.0773, 0.0507> <-0.0203, 0.0727, 0.0507>
		<0.0518, 0.0685, 0.0000> <0.0518, 0.0685, 0.0263> <0.0084, 0.0616, 0.0498> <-0.0175, 0.0571, 0.0498>
		<0.0407, 0.0475, 0.0000> <0.0407, 0.0475, 0.0180> <0.0035, 0.0410, 0.0395> <-0.0142, 0.0379, 0.0395>
		<0.0366, 0.0314, 0.0000> <0.0366, 0.0314, 0.0180> <0.0061, 0.0261, 0.0347> <-0.0116, 0.0230, 0.0347>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0298, 0.1276, 0.0409> <-0.0507, 0.1240, 0.0409> <-0.0866, 0.1177, 0.0212> <-0.0866, 0.1177, 0.0000>
		<-0.0269, 0.1112, 0.0438> <-0.0478, 0.1075, 0.0438> <-0.0879, 0.1005, 0.0212> <-0.0879, 0.1005, 0.0000>
		<-0.0232, 0.0894, 0.0517> <-0.0491, 0.0849, 0.0517> <-0.0951, 0.0771, 0.0263> <-0.0951, 0.0771, 0.0000>
		<-0.0203, 0.0727, 0.0507> <-0.0462, 0.0682, 0.0507> <-0.0908, 0.0605, 0.0263> <-0.0908, 0.0605, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0866, 0.1177, 0.0000> <-0.0866, 0.1177, -0.0212> <-0.0507, 0.1240, -0.0409> <-0.0298, 0.1276, -0.0409>
		<-0.0879, 0.1005, 0.0000> <-0.0879, 0.1005, -0.0212> <-0.0478, 0.1075, -0.0438> <-0.0269, 0.1112, -0.0438>
		<-0.0951, 0.0771, 0.0000> <-0.0951, 0.0771, -0.0263> <-0.0491, 0.0849, -0.0517> <-0.0232, 0.0894, -0.0517>
		<-0.0908, 0.0605, 0.0000> <-0.0908, 0.0605, -0.0263> <-0.0462, 0.0682, -0.0507> <-0.0203, 0.0727, -0.0507>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0203, 0.0727, 0.0507> <-0.0462, 0.0682, 0.0507> <-0.0908, 0.0605, 0.0263> <-0.0908, 0.0605, 0.0000>
		<-0.0175, 0.0571, 0.0498> <-0.0435, 0.0526, 0.0498> <-0.0866, 0.0444, 0.0263> <-0.0866, 0.0444, 0.0000>
		<-0.0142, 0.0379, 0.0395> <-0.0319, 0.0348, 0.0395> <-0.0691, 0.0284, 0.0180> <-0.0691, 0.0284, 0.0000>
		<-0.0116, 0.0230, 0.0347> <-0.0293, 0.0199, 0.0347> <-0.0598, 0.0146, 0.0180> <-0.0598, 0.0146, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0908, 0.0605, 0.0000> <-0.0908, 0.0605, -0.0263> <-0.0462, 0.0682, -0.0507> <-0.0203, 0.0727, -0.0507>
		<-0.0866, 0.0444, 0.0000> <-0.0866, 0.0444, -0.0263> <-0.0435, 0.0526, -0.0498> <-0.0175, 0.0571, -0.0498>
		<-0.0691, 0.0284, 0.0000> <-0.0691, 0.0284, -0.0180> <-0.0319, 0.0348, -0.0395> <-0.0142, 0.0379, -0.0395>
		<-0.0598, 0.0146, 0.0000> <-0.0598, 0.0146, -0.0180> <-0.0293, 0.0199, -0.0347> <-0.0116, 0.0230, -0.0347>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0622, 0.6320, -0.0059> <-0.0553, 0.6162, -0.0059> <-0.0407, 0.5965, -0.0059> <-0.0392, 0.5794, -0.0059>
		<-0.0622, 0.6320, -0.0271> <-0.0553, 0.6162, -0.0271> <-0.0407, 0.5965, -0.0322> <-0.0392, 0.5794, -0.0322>
		<-0.0981, 0.6260, -0.0467> <-0.0954, 0.6095, -0.0497> <-0.0867, 0.5886, -0.0576> <-0.0839, 0.5719, -0.0566>
		<-0.1191, 0.6225, -0.0467> <-0.1163, 0.6060, -0.0497> <-0.1126, 0.5842, -0.0576> <-0.1098, 0.5675, -0.0566>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0622, 0.6320, -0.0059> <-0.0622, 0.6320, 0.0153> <-0.0981, 0.6260, 0.0350> <-0.1191, 0.6225, 0.0350>
		<-0.0553, 0.6162, -0.0059> <-0.0553, 0.6162, 0.0153> <-0.0954, 0.6095, 0.0380> <-0.1163, 0.6060, 0.0380>
		<-0.0407, 0.5965, -0.0059> <-0.0407, 0.5965, 0.0204> <-0.0867, 0.5886, 0.0459> <-0.1126, 0.5842, 0.0459>
		<-0.0392, 0.5794, -0.0059> <-0.0392, 0.5794, 0.0204> <-0.0839, 0.5719, 0.0449> <-0.1098, 0.5675, 0.0449>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0392, 0.5794, -0.0059> <-0.0378, 0.5628, -0.0059> <-0.0490, 0.5419, -0.0059> <-0.0532, 0.5258, -0.0059>
		<-0.0392, 0.5794, -0.0322> <-0.0378, 0.5628, -0.0322> <-0.0490, 0.5419, -0.0239> <-0.0532, 0.5258, -0.0239>
		<-0.0839, 0.5719, -0.0566> <-0.0812, 0.5562, -0.0557> <-0.0862, 0.5357, -0.0454> <-0.0837, 0.5207, -0.0406>
		<-0.1098, 0.5675, -0.0566> <-0.1072, 0.5519, -0.0557> <-0.1040, 0.5327, -0.0454> <-0.1015, 0.5177, -0.0406>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0392, 0.5794, -0.0059> <-0.0392, 0.5794, 0.0204> <-0.0839, 0.5719, 0.0449> <-0.1098, 0.5675, 0.0449>
		<-0.0378, 0.5628, -0.0059> <-0.0378, 0.5628, 0.0204> <-0.0812, 0.5562, 0.0439> <-0.1072, 0.5519, 0.0439>
		<-0.0490, 0.5419, -0.0059> <-0.0490, 0.5419, 0.0121> <-0.0862, 0.5357, 0.0336> <-0.1040, 0.5327, 0.0336>
		<-0.0532, 0.5258, -0.0059> <-0.0532, 0.5258, 0.0121> <-0.0837, 0.5207, 0.0288> <-0.1015, 0.5177, 0.0288>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1191, 0.6225, 0.0350> <-0.1400, 0.6190, 0.0350> <-0.1759, 0.6129, 0.0153> <-0.1759, 0.6129, -0.0059>
		<-0.1163, 0.6060, 0.0380> <-0.1372, 0.6025, 0.0380> <-0.1773, 0.5957, 0.0153> <-0.1773, 0.5957, -0.0059>
		<-0.1126, 0.5842, 0.0459> <-0.1386, 0.5799, 0.0459> <-0.1847, 0.5724, 0.0204> <-0.1847, 0.5724, -0.0059>
		<-0.1098, 0.5675, 0.0449> <-0.1358, 0.5632, 0.0449> <-0.1804, 0.5557, 0.0204> <-0.1804, 0.5557, -0.0059>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1759, 0.6129, -0.0059> <-0.1759, 0.6129, -0.0271> <-0.1400, 0.6190, -0.0467> <-0.1191, 0.6225, -0.0467>
		<-0.1773, 0.5957, -0.0059> <-0.1773, 0.5957, -0.0271> <-0.1372, 0.6025, -0.0497> <-0.1163, 0.6060, -0.0497>
		<-0.1847, 0.5724, -0.0059> <-0.1847, 0.5724, -0.0322> <-0.1386, 0.5799, -0.0576> <-0.1126, 0.5842, -0.0576>
		<-0.1804, 0.5557, -0.0059> <-0.1804, 0.5557, -0.0322> <-0.1358, 0.5632, -0.0566> <-0.1098, 0.5675, -0.0566>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1098, 0.5675, 0.0449> <-0.1358, 0.5632, 0.0449> <-0.1804, 0.5557, 0.0204> <-0.1804, 0.5557, -0.0059>
		<-0.1072, 0.5519, 0.0439> <-0.1332, 0.5475, 0.0439> <-0.1763, 0.5396, 0.0204> <-0.1763, 0.5396, -0.0059>
		<-0.1040, 0.5327, 0.0336> <-0.1217, 0.5297, 0.0336> <-0.1589, 0.5234, 0.0121> <-0.1589, 0.5234, -0.0059>
		<-0.1015, 0.5177, 0.0288> <-0.1192, 0.5148, 0.0288> <-0.1497, 0.5096, 0.0121> <-0.1497, 0.5096, -0.0059>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1804, 0.5557, -0.0059> <-0.1804, 0.5557, -0.0322> <-0.1358, 0.5632, -0.0566> <-0.1098, 0.5675, -0.0566>
		<-0.1763, 0.5396, -0.0059> <-0.1763, 0.5396, -0.0322> <-0.1332, 0.5475, -0.0557> <-0.1072, 0.5519, -0.0557>
		<-0.1589, 0.5234, -0.0059> <-0.1589, 0.5234, -0.0239> <-0.1217, 0.5297, -0.0454> <-0.1040, 0.5327, -0.0454>
		<-0.1497, 0.5096, -0.0059> <-0.1497, 0.5096, -0.0239> <-0.1192, 0.5148, -0.0406> <-0.1015, 0.5177, -0.0406>
	}
	pigment {color rgb <0.9, 0.8, 0.8>}
	finish {ambient 0.1 diffuse 0.7 phong 0.1}
	normal {bumps bump_size 0.3 scale 0.01}
}

#declare Sphere1 = sphere{0, 0.16 scale <1, 0.3, 0.3> texture{FairHair}}
#declare Part1 = union{
	Hair(Sphere1, 200, <0, 0, 0>, 0.4, FairHair) 
    Hair(Sphere1, 200, <-0.08, 0, 0>, 0.4, FairHair) 
    Hair(Sphere1, 200, <0.08, 0, 0>, 0.4, FairHair)
    
    rotate z*8
    rotate z*90
    translate <-0.14, 0.76, 0>
} 

#declare Feather4 = union {
	object{Center}
	object{Left}
	object{Right} 
	object{Fix}
	object{Rope}
	object{Part1}
}




