#version unofficial MegaPov 0.7;

camera {
    location <0, 3, -20> 
	look_at  <0, 3, 0>
}

light_source {<-20, 20, -11> color rgb <1, 0.8, 0.8>*1.5}

cylinder{
    <-1, 0, 0>, <1, 0, 0>, 1
    hollow
    pigment{
	    gradient y 
	    color_map {
	        [0.0 color rgb <0.74, 0.71, 0.7>/1.4]
	        [0.7 color rgb <0.54, 0.51, 0.5>/1.4]
	    }
	} 
	finish{ambient 1}
	normal{bumps 0.4 scale 0.00001}
	
	scale 800
    translate <0, -300, -200>
}

#include "face.inc"
object{Face rotate<5, 0, 0> translate <4, -8, 0>}                                       

#include "headress.inc"
object{Headdress}  
 
#include "pipe.inc"
object{Pipe translate<0.4, -1.9, -0.6>}  


#declare  S = function {x*x + z*z - 1}

#declare Smoke = isosurface {
    function {S(x,y,z) + noise3d(x*4,y*6,z*4)*2.5}
    method 1
    accuracy 0.0001
    contained_by{sphere{0,6}}
    pigment {rgbft <1, 1, 1, 1, 0.05>}
    finish{ambient 1 diffuse 0 phong 0} 
    no_shadow
}  

object{
    Smoke 
    scale <0.4, 10, 0.0001> 
    translate <-11, 59, -0.6>
}
 
#declare Totem = height_field {
    png "totem.png"
    smooth  
    water_level 0.1
    texture{
        pigment {rgb 0.8} 
        finish{ambient 0.12 diffuse 0.6 phong 0}
    } 
    texture{ 
        pigment{
        image_map {
		       png "pattern1.png" 
			   map_type 0	
			   once  
			   filter 1, 1
			   interpolate 2	
			}
        }          
        finish{ambient 0.2 diffuse 0.6 phong 0}
        rotate x*90
    } 
    no_shadow

    scale <5, 0.5, 20> 
    scale 2
}               

object{
    Totem 
    rotate <-90, -20, 0>    
    translate <-14, -13, 10>  
} 
