global_settings {
	assumed_gamma 2.2
  adc_bailout 0.0
  max_trace_level 100
}


#include "person.inc"


#declare dir = <3,24,5>;




/*sphere {
	<0,8,0>, 2
	texture {
		pigment { rgb <1, 0.8, 0.82> }
		finish {
			diffuse 2.0
			ambient <0.2,0.25,0.3>
			specular 1 roughness 0.01
			reflection 0.1
		}
	}
}*/
object {
	person
	texture {
		pigment { rgb <1, 0.8, 0.82> }
		finish {
			diffuse 2.0
			ambient <0.2,0.25,0.3>
			specular 1 roughness 0.01
			reflection 0.1
		}
	}
	scale 1.6
	translate <0,-5,0>
	translate (5 / dir.y)*dir
}

union {
	#declare lz = -24;
	#while ( lz < 15 )
		#declare lx = -20;
		#while ( lx < 24 )
			#if ( lx > 1 | lx < -1 | lz > 1 | lz < -1 )
				object { person translate <lx, 0, lz> }
			#end
			#declare lx = lx + 4;
		#end
		#declare lz = lz + 3;
	#end

	no_shadow
	
	texture {
		pigment { rgb <0.82, 1, 0.8> }//<1, 0.8, 0.82> }
		finish {
			diffuse 2.0
			ambient 0.2*<0.2,0.25,0.3>
			specular 2 roughness 0.01
			reflection 0.15
		}
	}
	
/*	texture {
		pigment { rgb <0.9, 1.0, 0.7> }
		finish {
			//metallic
			diffuse 2.0
			ambient <0.2,0.25,0.3>
			specular 2 roughness 0.2//0.01
//			reflection 0.05
		}
	}*/
	scale 1.6
	translate <0,-5,0>
	translate (5 / dir.y)*dir
}


plane {
	y, 0
	
	texture {
		pigment { rgb <1.0, 0.97, 0.92> }
		finish {
			diffuse 0.8
			ambient 0.2
			specular 0.5 roughness 0.005
//			reflection 0.3
		}
	}
}


plane {
	-y, 0
	
	texture {
		pigment {
			spherical
			turbulence 1.5
			colour_map {
				[0.01 rgbt 0]//-10]
				[0.01 rgbt 1]//-5]
			}
			scale 0.7*<2.5,2,2>
			translate <-1,0,0>//.8>
		}
		finish {
			diffuse 0.0
			ambient 0.0
		}
	}
	
	translate 1.5*dir
}


cylinder {
	-0.1*dir, 3.1*dir, 8
	pigment { rgbt 1 } //no shadows from media
	hollow on
	interior {
		media {
		  scattering {
		    1, rgb 5//0.05
		    extinction 0.0002//8
		  }
		
		  intervals 20//20
		  samples 1, 20//20
		  confidence 0.99
		  variance 1.0/256.0
		  
		  density {
		  	gradient y
		  	colour_map {
		  		[0 rgb 0]
		  		[1 rgb 3]
		  	}
		  	scale 36
		  }
		}
	}
}


//low powered light for media
light_source {
	3*dir,
	rgb 0.01
}

//light for worshipper
light_source {
	1.5*dir,
	rgb 1
	spotlight
	radius 5
	falloff 10//6
	//tightness Tightness
	point_at <-1,0,0>
	media_interaction off
}

//lights for everyone else
light_source {
	2*<-30,15,-15>,
	rgb 0.15
	media_interaction off
}

/*light_source {
	<0,30,16>,
	rgb 0.1
	media_interaction off
	fade_distance 30
	fade_power 3
}*/

light_source {
	<30,30,-40>,
	rgb 0.2
	media_interaction off
}


background { rgb 0.3 }


camera {
	orthographic

	right			x*20*16/9
	up				y*20
	direction	z

	location 2*<-10,9,10> + 6*y
	look_at <0,6,0>
	translate <-2,0,-3>	
	translate 4*vnormalize(<9/sqrt(2),10*sqrt(2),-9/sqrt(2)>)
} 
 

/*camera {
	right			x*4/3
	up				y
	direction	z*1

	location <0,6,-30>
	look_at <0,8,0>	
}*/ 
 
 
 




