// Persistence of Vision Ray Tracer Scene Description File
// File: beker.pov
// Vers: 3.1
// Desc: First price beker 
// Date: 12 feb 2001
// Auth: Roef Mahlmann
//

#version 3.1

#include "colors.inc"
#include "metals.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera{
  location  <0.0, 0.09, -0.25>  look_at   <0.0, 0.09,  0.0>
}

sky_sphere{
  pigment{
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source{
  0*x             // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------
plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

#declare R1=0.03;       // onderste schijf
#declare H11=0.000;     // hoogte onder
#declare H12=0.005;     // hoogte boven
#declare R2=0.02;       // tweede schijf
#declare H21=0.02;      // hoogte onderkant schijf 2
#declare H22=0.025;     // hoogte bovenkant schijf 2
#declare H31=0.055;     // hoogte torus
#declare R4=0.02;       // derde schijf onder kelk
#declare H41=0.085;     // hoogte
#declare H42=0.090;     // hoogte
#declare H5=0.085;       // hoogte kelk

#declare beker=
union{
  cylinder{<0,H11,0><0,H12,0>,R1}          // schijf 1
  cone{<0,H12,0>,R1<0,H21,0>,R2}           // onderste stuk voet
  difference{                              //ribbels in de voet
    union{
      #declare Z1=0;            // teller voor de ronde
      #while (Z1<180)
        torus{0.028,0.004 
          rotate<90,Z1,0>
          translate<0,H11-0.01,0>
        pigment {color Yellow}
        } 
        #declare Z1=Z1+30;
      #end
    }
    box{<-10,H11,-10><10,-10,10>}
  }
 
  cylinder{<0,H21,0><0,H22,0>,R2}          // schijf 2
  difference{
    cylinder{<0,H22,0><0,H41,0>,R2}
    torus{0.06,0.05
      translate<0,H31,0>
    }
  }
  cylinder{<0,H41,0><0,H42,0>,R4}        // schijf 2
  difference{                            // hele kelk
    sphere{<0,0,0>,0.06}
    box{<-10,0,-10><10,10,10>}
    translate<0,H42+0.055,0>
  }
    
  // ribbels in kelk
  difference{
    union{
      #declare Z1=0;            // teller voor de ronde
      #while (Z1<180)
        torus{0.050,0.01 
          rotate<90,Z1,0>
          translate<0,H41+0.055,0>
         } 
        #declare Z1=Z1+15;
      #end
    }
    box{<-10,H42+0.055,-10><10,H42+10,10>}
  }        
  texture{T_Silver_4D}
}

object{beker}
