// Persistence of Vision Ray Tracer Scene Description File
// File: hand.pov
// Vers: 3.1
// Desc: Just a hand
// Date: 19 feb 2001
// Auth: Roef Mahlmann
//

#version 3.1

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0.1, 0.2, -0.0>
  look_at   <0.1, 0.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------
plane
{
  y, -1
  texture
  {
    pigment {checker color rgb 1 color blue 1 scale 0.5}
    finish {reflection 0.2}
  }
}


//plane{y, 0 pigment {checker color Yellow color Green}}
 
#declare huid =   texture{
    pigment{color rgb<0.95,0.56,0.49>}
    normal { bumps 0.4 scale 0.0001 }
}

#declare hand=
union{
  sphere{<0,0,0>,0.03}                    //pols
  cone{<0,0,0>,0.03<0.05,0,0>0.04 scale<1,0.4,1>}
  sphere{<0.05,0,0>,0.04 scale<1,0.4,1>}  //middenhand
  
  union{                                  //pink        
    union{  
      union{                                  
        union{                                      //top
          sphere{<0.021,0,0>0.007}
          cone{<0,0,0>,0.008 <0.021,0,0>,0.007}
          sphere{<0,0,0>0.008}
          rotate< 0, 0, -5>
          translate<0.023,0,0>
        }
        cone{<0,0,0>,0.009 <0.023,0,0>,0.008}       //midden
        sphere{<0,0,0>,0.009}
        rotate< 0, 0, -10>
        translate<0.020,0,0>
      }
      cone{<0,0,0>,0.009 <0.020,0,0>,0.009}         //eerste kootje
      sphere{<0,0,0>,0.009}
    }
    rotate<0,-4,0>  
    translate<0.065,0,0.03>
  }    
  union{                                  //ring
    union{  
      union{                                  
        union{                                      //top
          sphere{<0.023,0,0>0.008}
          cone{<0,0,0>,0.009 <0.023,0,0>,0.008}
          sphere{<0,0,0>0.009}
          rotate< 0, 0, -5>
          translate<0.032,0,0>
        }
        cone{<0,0,0>,0.010 <0.032,0,0>,0.009}       //midden
        sphere{<0,0,0>,0.010}
        rotate< 0, 0, -10>
        translate<0.033,0,0>
      }
      cone{<0,0,0>,0.011 <0.033,0,0>,0.010}         //eerste kootje
      sphere{<0,0,0>,0.011}
    }
    rotate<0,-2,0>  
    translate<0.07,0,0.015>
  }    
  union{                                  //middel
    union{  
      union{                                  
        union{                                      //top
          sphere{<0.023,0,0>0.008}
          cone{<0,0,0>,0.009 <0.023,0,0>,0.008}
          sphere{<0,0,0>0.009}
          rotate< 0, 0, -5>
          translate<0.032,0,0>
        }
        cone{<0,0,0>,0.010 <0.032,0,0>,0.009}       //midden
        sphere{<0,0,0>,0.010}
        rotate< 0, 0, -10>
        translate<0.040,0,0>
      }
      cone{<0,0,0>,0.011 <0.040,0,0>,0.010}         //eerste kootje
      sphere{<0,0,0>,0.011}
    }
    rotate<0,0,0>  
    translate<0.07,0,0>
  }    
  union{                                  //wijs
    union{  
      union{                                  
        union{                                      //top
          sphere{<0.020,0,0>0.008}
          cone{<0,0,0>,0.009 <0.020,0,0>,0.008}
          sphere{<0,0,0>0.009}
          rotate< 0, 0, -5>
          translate<0.028,0,0>
        }
        cone{<0,0,0>,0.010 <0.028,0,0>,0.009}       //midden
        sphere{<0,0,0>,0.010}
        rotate< 0, 0, -10>
        translate<0.036,0,0>
      }
      cone{<0,0,0>,0.011 <0.036,0,0>,0.010}         //eerste kootje
      sphere{<0,0,0>,0.011}
    }
    rotate<0,2,0>  
    translate<0.07,0,-0.015>
  }    
  union{                                  //duim
    union{  
      union{                                  
        union{                                      //top
          sphere{<0.026,0,0>0.010}
          cone{<0,0,0>,0.011 <0.026,0,0>,0.010}
          sphere{<0,0,0>0.011}
          rotate<0 , -10, 0>
          translate<0.038,0,0>
        }
        cone{<0,0,0>,0.012 <0.038,0,0>,0.011}       //midden
        sphere{<0,0,0>,0.012}
        rotate< 0, -20, 0>
        translate<0.036,0,0>
      }
      cone{<0,0,0>,0.010 <0.036,0,0>,0.012}         //eerste kootje = middenhand
      sphere{<0,0,0>,0.010}
    }
    rotate<0,35,0>  
    translate<0.02,0,-0.01>
  }    
  texture{huid}
}
object{hand}

