// Persistence of Vision Ray Tracer Scene Description File
// File: hounor.pov
// Vers: 3.1
// Desc: complete scene
// Date: 1 feb 2001
// Auth: Roef Mahlmann
//
//
//           +y
//           | /+Z
//           |/           sizes in meters
//           |---> +X

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "beker.pov"
#include "hand.pov"

#declare huid =   texture{
    pigment{color rgb<0.95,0.56,0.49>}
    normal { bumps 0.4 scale 0.0001 }
}     

camera {
  location <0.23, 1.9, -1.15>
  look_at  <0, 2.5, 0>
}

light_source { <2,4,-3> color White}

sky_sphere {           // borrowd from skysph.pov
  pigment {
    gradient y
    color_map {
      [0.75  color CornflowerBlue]
      [1.00  color MidnightBlue]
    }
    scale 2
    translate <-1, -1, -1>
  }
  pigment {
    bozo
    turbulence 0.6
    octaves 7
    omega .49876
    lambda 2.5432
    color_map {
      [0.0 color rgbf<.75, .75, .75, 0.1>]
      [0.4 color rgbf<.9, .9, .9, .9>]
      [0.7 color rgbf<1, 1, 1, 1>]
    }
    scale 6/10
    scale <1, 0.3, 0.3>
  }
  pigment {
    bozo
    turbulence 0.6
    octaves 8
    omega .5123
    lambda 2.56578
    color_map {
      [0.0 color rgbf<.375, .375, .375, 0.2>]
      [0.4 color rgbf<.45, .45, .45, .9>]
      [0.6 color rgbf<0.5, 0.5, 0.5, 1>]
    }
    scale 6/10
    scale <1, 0.3, 0.3>
  }
}


plane{y, 0 pigment {checker color rgb<0.1,0.9,0.1> color Green}}

#declare arm=
union{
  cone{<0,0,0>,0.07<0.3,0,0.05>,0.04}
  sphere{<0.3,0,0.05>,0.04}
  cone{<0.3,0,0.05>,0.04<0.5,0,0>,0.03}
}

#declare pop=
union{
  object{arm rotate<90,0,90> translate< 0.13,1.5,0>}
  object{arm rotate<-90,0,90>translate<-0.13,1.5,0>}
  object{hand translate<0.3,0,0> rotate<80,0,90>translate<0.13,1.7,0>}
  object{hand translate<0.3,0,0> rotate<80,0,90>translate<0.13,1.7,0>scale<-1,1,1>}
  cylinder{<0,0,0><0,1.40,0>,0.22} //lijf
  sphere{<0,1.40,0>,0.22}          //schouders
  sphere{<0,1.70,0>,0.10}          //hoofd
}

#declare Dd=0.5;
object{pop texture{huid}}
object{pop scale<1.0,1.01,1.0>translate<0,0,Dd>rotate<0,40,0>texture{huid}}
object{pop scale<1.0,1.00,1.0>translate<0,0,Dd>rotate<0,80,0>texture{huid}}
object{pop scale<1.0,0.90,1.0>translate<0,0,Dd>rotate<0,120,0>texture{huid}}
object{pop scale<1.0,1.02,1.0>translate<0,0,Dd>rotate<0,160,0>texture{huid}}
object{pop scale<1.0,1.00,1.0>translate<0,0,Dd>rotate<0,200,0>texture{huid}}
object{pop scale<1.0,0.95,1.0>translate<0,0,Dd>rotate<0,240,0>texture{huid}}
object{pop scale<1.0,0.93,1.0>translate<0,0,Dd>rotate<0,280,0>texture{huid}}
object{pop scale<1.0,1.00,1.0>translate<0,0,Dd>rotate<0,320,0>texture{huid}}
object{pop scale<1.0,1.05,1.0>translate<0,0,Dd>rotate<0,360,0>texture{huid}}
#declare Dd=1.0;
object{pop scale<1.0,1.0,1.0>translate<0,0,Dd>rotate<0,20,0>texture{huid}}
object{pop scale<1.0,1.0,1.0>translate<0,0,Dd>rotate<0,50,0>texture{huid}}
object{pop scale<1.0,1.0,1.0>translate<0,0,Dd>rotate<0, 80,0>texture{huid}}
object{pop scale<1.0,1.0,1.0>translate<0,0,Dd>rotate<0,110,0>texture{huid}}
object{pop scale<1.0,1.0,1.0>translate<0,0,Dd>rotate<0,140,0>texture{huid}}
object{pop scale<1.0,1.0,1.0>translate<0,0,Dd>rotate<0,170,0>texture{huid}}
object{pop scale<1.0,1.0,1.0>translate<0,0,Dd>rotate<0,200,0>texture{huid}}
object{pop scale<1.0,1.0,1.0>translate<0,0,Dd>rotate<0,230,0>texture{huid}}
object{pop scale<1.0,1.0,1.0>translate<0,0,Dd>rotate<0,260,0>texture{huid}}
object{pop scale<1.0,1.0,1.0>translate<0,0,Dd>rotate<0,290,0>texture{huid}}
object{pop scale<1.0,1.0,1.0>translate<0,0,Dd>rotate<0,320,0>texture{huid}}
object{pop scale<1.0,1.0,1.0>translate<0,0,Dd>rotate<0,350,0>texture{huid}}

          
object{beker scale<4,4,4>translate<0,2.3,0>}
