//****************************************************************************
//
// Author: Ali Lakhia
// File:   misc.inc
// Date:   January 24th, 2001
//
//***************************************************************************/

//////////////////////////////////////////////////////////////////////////////
// Building Stuff
//////////////////////////////////////////////////////////////////////////////

// Initialize random seeds
#declare building_dimensions = seed(0);
#declare building_placement = seed(5);
#declare building_color = seed(10);
#declare window_dimensions = seed(15);
#declare window_placement = seed(20);
#declare window_color = seed(25);
#declare window_glow = seed(30);

// Macro for creating a single building
#macro random_building(areaX, areaY, bldW, bldH, bldL)
  #local bldX = rand(building_placement)*areaX;
  #local bldZ = rand(building_placement)*areaY;
  #local bldWidth = rand(building_dimensions)*bldW + 2;
  #local bldHeight = rand(building_dimensions)*bldH + 1;
  #local bldLength = rand(building_dimensions)*bldL + 1;
  #local winX = rand(window_placement);
  #local winY = rand(window_placement);
  #local winHeight = rand(window_dimensions)*0.6 + 0.15;
  #local winWidth = rand(window_dimensions)*0.4 + 0.1;
  difference {
    box {
      <bldX, 0, bldZ>,
      <bldX + bldWidth, bldHeight, bldZ + bldLength>
      no_shadow
      pigment {
        rgb <rand(building_color)*0.33 + 0.1,
             rand(building_color)*0.2 + 0.1,
             rand(building_color)*0.2 + 0.05>
      }
    }
    #while (winX + winWidth < bldWidth)
      #while (winY + winHeight < bldHeight)
        #local win_color = rand(window_color)*0.9 + 0.05;
        #local win_amb = rand(window_glow)*rand(window_glow)*rand(window_glow);
        box {
          <bldX + winX, winY, bldZ + bldLength/2>,
          <bldX + winX + winWidth, winY + winHeight, bldZ - 1>
          pigment {
            rgb <win_color,
                 rand(building_color)*0.2 + win_color,
                 rand(building_color)*0.2 + win_color>
          }
          finish { ambient rgb win_color*win_amb }
        }
        #local winY = winY + 1.2*winHeight + rand(window_placement)*winHeight;
      #end
      #local winX = winX + 1.1*winWidth + rand(window_placement)*winWidth;
      #local winY = rand(window_placement);
      #local winHeight = rand(window_dimensions)*0.6 + 0.15;
      #local winWidth = rand(window_dimensions)*0.4 + 0.1;
    #end
  }
#end

// Macro for creating several buildings
#macro random_buildings(num, areaX, areaY, bldW, bldH, bldL)
  #local counter = 0;
  #while (counter < num)
    random_building(areaX, areaY, bldW, bldH, bldL)
    #local counter = counter + 1;
  #end
#end

//////////////////////////////////////////////////////////////////////////////
// Miscellaneous
//////////////////////////////////////////////////////////////////////////////

// Sky sphere
#declare Mecca_sky_sphere = sky_sphere
{
  pigment {
    gradient y
    color_map {
      [ 0.0 color rgb <0.45, 0.478, 0.549> ]               // Dark blue
      [ 0.5 color rgb <0.764, 0.671, 0.725> ]              // Dawn pink
      [ 0.8 color MidnightBlue ]
      [ 1.0 color rgb <0.45, 0.478, 0.549> ]               // Dark blue
    }
    scale 0.8
    translate -1                        // Comment out for bluish sky
    rotate 10*z
  }
  pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
      [0.0 0.5 color rgbt <0.85, 0.85, 0.85, 0.6>
               color rgbt <0.75, 0.75, 0.75, 0.65>]
      [0.5 0.8 color rgbt <0.75, 0.75, 0.75, 0.75>
               color rgbt <1, 1, 1, 1>]
      [0.8 1.0 color rgbt <1, 1, 1, 1>
               color rgbt <1, 1, 1, 1>]
    }
    scale <0.2, 0.05, 0.2>
  }
}

// Macro to create halo around light source
#macro Create_halo(halo_color, halo_str, halo_size)
  sphere {
    0, 1
    texture {
      pigment { Clear } 
      finish { ambient 0 diffuse 0 }
    }
    interior {
      media {
        emission halo_str*0.5
        intervals 10 samples 1, 5
        confidence 0.9999
        variance 1/10
        density {
          spherical
          turbulence 0.1
          color_map {
            [0.0 Black]
            [1.0 color halo_color*halo_str]
          }
        }
      }
    }
    hollow 
    no_shadow
    scale halo_size
  }
#end


//////////////////////////////////////////////////////////////////////////////
// Kaaba Stuff
//////////////////////////////////////////////////////////////////////////////

// Draw kaaba's round top, with cavity in middle
#declare Kaaba_top = difference 
{
  union
  {
    sphere {
      <0.05, 0, 0.05>,
      0.05
    }
    sphere {
      <0.05, 0, 2.55>,
      0.05
    }
    sphere {
      <2.55, 0, 0.05>,
      0.05
    }
    sphere {
      <2.55, 0, 2.55>,
      0.05
    }
    cylinder {
      <0.05, 0, 0.05>
      <0.05, 0, 2.55>,
      0.05
    }
    cylinder {
      <0.05, 0, 0.05>
      <2.55, 0, 0.05>,
      0.05
    }
    cylinder {
      <2.55, 0, 0.05>,
      <2.55, 0, 2.55>
      0.05
    }
    cylinder {
      <2.55, 0, 2.55>,
      <0.05, 0, 2.55>
      0.05
    }
    box {
      <0.05, 0, 0.05>,
      <2.55, 0.05, 2.55>
    }
    pigment { Gray05 }
  }
  box {
    <0.15, 0.01, 0.15>,
    <2.45, 0.1001, 2.45>
    pigment {
      brick Gray60, Gray90
      brick_size 0.35
      mortar 0.02
    }
    normal {
      brick -0.05
      brick_size 0.35
      mortar 0.02
    }
    finish {
      ambient 0.3
      specular 0.9
      roughness 0.005
    }
  }
}

// Draw kaaba such that origin is at ground level in center
#declare Kaaba = union
{
  box {
    0, 1
    texture {
      pigment {
        image_map {
          png "kaaba_cloth.png"
          interpolate 2
          once
        }
      }
    }
    scale <2.6, 3.2, 2.6>
  }
  box {
    0, 1
    texture {
      pigment {
        image_map {
          png "kaaba_cloth_side.png"
          interpolate 2
          once
        }
      }
    }
//    pigment { Yellow }                                      // ???? Fix
    rotate -90*y
    scale <0.0001, 3.2, 2.6>
    translate <2.6, 0, 0>
  }
  object { 
    Kaaba_top
    translate 3.2*y
  }
  finish {
    ambient 0.1
    diffuse 1
    phong 0.6
    phong_size 7
  }
  translate <-1.3, 0, -1.3>
}

// Half ring next to kaaba
#declare Half_ring = difference
{
  cylinder {
    <0, 0, 0>,
    <0, 0.4, 0>,
    1.3
  }
  cylinder {
    <0, -0.01, 0>,
    <0, 0.41, 0>,
    1.0
  }
  box {
    <0, -0.01, 1.31>,
    <1.31, 0.41, -1.31>
  }
  pigment { white_marble }
}

// Floor of Kaaba
#declare Kaaba_floor = plane 
{
  y, 0
  pigment { white_marble }            // White marble is default pigment
  finish 
  {
    ambient 0.2
    diffuse 0.8
  }
}

// Lamps to illuminate the kaaba
#declare Center_lamp = union
{
  cylinder {                            // Lamp Base
    <0, 0, 0>,
    <0, 0.08, 0>,
    0.06
    texture { T_Gold_1B }
  }
  cylinder {                            // Lamp pole
    <0, 0.08, 0>,
    <0, 1.2, 0>,
    0.02
    texture { T_Gold_1B }
  }
  cone {
    <0, 1.26, 0>,
    0.02
    <0, 1.4, 0>
    0.008
    open
    texture { T_Gold_1B }
  }
  // Light in lamp
  #if (Lights_on > 0)
    object {
      Create_halo(Lights_color, 0.6, 1.2)
      scale <1, .5, 1>
      translate 1.23*y
    }
  #end
      light_source {
        <0, 0, 0>,
        Lights_color*Lights_on/10
        looks_like {
          sphere {
            <0, 0, 0>,
            1
            scale <0.24, 0.03, 0.24>
            pigment { Gray90 }
            finish {                        // Illusion that the light glows
              ambient Lights_color*Lights_on
            }
          }
        }
      translate 1.23*y
      }
  sphere {
    <0, 0, 0>,
    1
    scale <0.248, 0.003, 0.248>
    texture { T_Gold_1B }
    translate 1.23*y
    no_shadow
  }
}