//****************************************************************************
//
// Author: Ali Lakhia
// File:   people.inc
// Date:   February 15th, 2001
//
//***************************************************************************/

// Initialize random seeds
#declare people_dimensions = seed(100);
#declare people_placement = seed(105);
#declare people_color = seed(110);
#declare people_color_diff = seed(115);
#declare people_color_head = seed(125);

// Constants
#declare person_scale = 0.08;           // Max size of person
#declare person_accurate = 1;           // More accurate people

// A single person, modelled using very simple primitives.
#declare person = union 
{
  // head
  sphere {
    0, 0.5
    pigment {                           // A shade of dark gray
      rgb (rand(people_color_head)*0.3 + 0.05) 
    }
  }
  // Draw mid-section depending on accuracy needed
  #if (person_accurate)
    // left arm
    box {
      <-1, -.5, -.8>,
      <-.8, -.35, 0.501>
    }
    // right arm
    box {
      <1, -.5, -.8>,
      <.8, -.35, 0.501>
    }
  #end
  // chest
  box {
    <-1, -.5, 0.5>,
    <1, 0.65, 1.2>
  }
  // torso
  cylinder {
    <0, 0, 0.5>
    <0, 0.5, 3.6>,
    1
    scale <1, 0.5, 1>
    translate <0, 0.65, 0>
  }
  // thighs
  box {
    <-1, -0.5, 2.8>,
    <1, 0.65+0.5/2, 3.6>
  }
  #if (person_accurate)
    // left leg
    box {
      <-1, -.5, 3.6>
      <-.7, -.2, 5>
    }
    // right leg
    box {
      <1, -.5, 3.6>
      <.7, -.2, 5>
    }
  #end
}

// Macro for creating a single row of people around the center
#macro Create_row(rad, start_percent, end_percent)
  #local arch = 2*pi*rad*start_percent;
  #local end_arch = 2*pi*rad*end_percent;
  #while (arch < end_arch)
    #local theta = arch/rad;            // theta is in radians
    #local _scale = person_scale - rand(people_dimensions)*0.03;
    #if (mod(int(degrees(abs(theta))), 45) > 1)
      #local _x = cos(theta)*rad;
      #local _z = sin(theta)*rad;
      object {
        person
        #local _color = rand(people_color)*0.2 + 0.72;
        pigment {
          rgb <_color + rand(people_color_diff)*0.04,
               _color + rand(people_color_diff)*0.04,
               _color + rand(people_color_diff)*0.04>
        }
        finish {
          ambient 0.5
          diffuse 0.5
        }
        scale _scale
        rotate (90 - degrees(theta))*y
        translate <_x, 0.5*_scale, _z>
      }
    #end
    #local arch = arch + 2.4 * _scale; // 2 * 1.2 = 2.64
  #end
#end

// Macro for creating rows of people around the center
#macro Create_people(start_rad, end_rad, start_percent, end_percent)
  #while (start_rad < end_rad)
    Create_row(start_rad, start_percent, end_percent)
    #local start_rad = start_rad + 5.28*person_scale; // 4.4 * 1.2 = 5.28
  #end
#end