

global_settings {
        
        adc_bailout 0.0039              //Value multiple reflection
        ambient_light rgb<1,1,1>        //COLOR multiplicator of local ambients
        assumed_gamma 1                 //Value or 2.2 for PC-monitor
        hf_gray_16 no                     //[Bool} 
        irid_wavelength  rgb <0.25,0.18,0.14>        // COLOR 
        //max_intersections       // Number 
        //max_trace_level         // Number 
        number_of_waves 10      // Number
        
        //+QR in command line to switch on
        radiosity { brightness 3.3      //Float
                    count 300           // Integer set to 300 in good scene
                    distance_maximum 50  // set to 1/3 of looking distance <90 
                    error_bound 0.4     // set to 0.333 for final 
                    gray_threshold 0.5 
                    low_error_factor 0.4 // set to 0.4 for final
                    minimum_reuse 0.015 
                    nearest_count 6 
                    recursion_limit 1}   // oder 2
                                
      }
      
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "stones.inc"


#declare zoom=1;

#declare kl=1300;  //Raum 13m Breit
#declare dkx=100;  // Abstand sulen in x-Richtung
#declare dkz=kl/11; // Abstand Sulen in Z

#declare kapb=12.5;  // halbe BReite Kapitel und Sulenfu


#declare hs1=5;
#declare hs2=hs1+5;
#declare hs3=hs2+1;
#declare hs3a=hs3+1;
#declare hs4=hs3a+3;
#declare hs5=hs4+1;
#declare hs6=hs5+4;


#declare hs16=180; // Hhe unter Rundbogen
#declare hs15=hs16-4;
#declare hs14=hs15-1;
#declare hs13=hs14-3;
#declare hs12=hs13-1; 
#declare hs11=hs12-4;
#declare hs10=hs11-1;
#declare hs9=hs10-3;
#declare hs8=hs9-5;
#declare hs7=hs8-10;

#declare newBrickWidth=dkz/3;
#declare newBrickHeight=hs16/6;
#declare newBrickDepth=dkx/3;
#declare newBrickMortarWidth=1;
#declare newBrickMidtone=colour rgb<0.8984,0.8281,0.7305>;
#declare newBrickHighlight=colour rgb<0.9844,0.9492,0.8984>;
#declare newBrickLowlight=colour rgb<0.7539,0.6680,0.5508>;
#declare newBrickTurbulence=0.1;
#declare newBrickNormal=normal {granite 0.1}
#include "bricks.inc" 
#include "Gurkboden.inc"
#include "Kerzenstand.inc"


  
camera {
        location <-3.88*dkx, 100, 1.1*dkz>
        //look_at <0, 170, -0>
        look_at <-5.2*dkx, 100, 2.2*dkz>
        blur_samples 20
        angle 81
       }
 
/* 
camera {
        location <-8.3*dkx, 200, 4*dkz>
        //look_at <0, 170, -0>
        look_at <-9.5*dkx, 130, 5*dkz>
        blur_samples 4
        angle 30
       }
  */
light_source { <-6.5*dkx, 100, 0.5*dkz> colour rgb<0.4,0.36,0.36> shadowless fade_distance 200 fade_power 1.5   }         // 
light_source { <-0.2*dkx, 100, 4*dkz> colour rgb<0.4,0.36,0.36>  shadowless fade_distance 300 fade_power 1.5   }

//light_source { <-200, 150, 200> colour rgb<1,1,0.9> }
//light_source { <-6.5*dkx, 150, 5*dkz> colour rgb<1,1,0.9> }
//light_source { <100, 100, 300> colour White }


#declare Lightbulb=light_source { <0,0,0> color rgb<0.996*2,0.848*2,0.504*2>    //rgb<0.953*2,0.878*2,0.671*2> 
                                  fade_distance 100 fade_power 2.4
                                  area_light <5,0,0>, <0,0,5> 4,4
                                  adaptive 1
                                  jitter 
                                
                   looks_like {sphere { <0,0,0>,3 texture { pigment {color rgb<0.965,0.925,0.8>} finish {ambient 1 diffuse 1} }  }  }           
                   }

object {Lightbulb translate <-4.5*dkx,hs16+41,2.5*dkz>} 
object {Lightbulb translate <-6.5*dkx,hs16+41,3.5*dkz>} 
object {Lightbulb translate <-6.5*dkx,hs16+41,5.5*dkz>} 
object {Lightbulb translate <-6.5*dkx,hs16+41,7.5*dkz>} 

object {Lightbulb translate <-9.5*dkx,hs16+41,1.5*dkz>} 
object {Lightbulb translate <-9.5*dkx,hs16+41,4.5*dkz>} 
object {Lightbulb translate <-9.5*dkx,hs16+41,7.5*dkz>}
object {Lightbulb translate <-9.5*dkx,hs16+41,10.5*dkz>} 





background { color White }

                                  
// Einheiten in cm                                  



                     
#declare Deck1=union {  difference { box{<0,hs16,0> <dkx/2,hs16+dkz,-dkx/2>}
                                     box{<0,hs16-1,0> <dkx,hs16+dkz+1,-dkz> rotate <0,-45,0>}
                                     torus { 1.6*dkz,0.5*dkx-kapb rotate <90,0,0> translate <0,1.6*dkz+hs16,-0.5*dkx>}
                                   }
                        difference { box{<0,hs16,0> <dkx/2,hs16+dkz,-dkz/2>}
                                     box{<0,hs16-1,0> <dkx,hs16+dkz+1,-dkz> rotate <0,45,0>}
                                     torus { 1.6*dkz,0.5*dkx-kapb rotate <0,0,90> translate <0.5*dkx,1.6*dkz+hs16,0>}
                                   }                             
                      }         
                             
            
                         
#declare Deck=union{object {Deck1}
                    object {Deck1 scale <-1,1,1>}                       
                    object {Deck1 scale <1,1,-1>}   
                    object {Deck1 scale <-1,1,-1>}  
                    scale<1,1,dkz/dkx>
                   } 
                    


#declare Fusszier=intersection {sphere{<0,0,0> 3.7 scale <1.5,1,1> translate <0,0,1>}
                                sphere{<0,0,0> 3.7 scale <1.5,1,1> translate <0,0,-1>   }
                               }
                    
#declare Sockel=union {box{<-kapb,0,-kapb> <kapb,hs1,kapb>}
                     torus {kapb-hs2+hs1+1,0.5*(hs2-hs1)+1 translate <0,hs1+0.5*(hs2-hs1)-1,0>}
                     cylinder {<0,hs2,0> <0,hs3,0> kapb-hs2+hs1+1}  
                      
                     difference{ union {cone {<0,hs3,0> kapb-hs2+hs1+1 <0,hs3a,0> 0.81*(kapb-hs2+hs1+1)} 
                                        cylinder {<0,hs3a,0> <0,hs4,0> 0.5*kapb+0.5*(hs4-hs3a)}
                                       }
                                 torus { 0.55*kapb+0.5*(hs4-hs3a),0.6*(hs4-hs3a) translate <0,hs3a+0.5*(hs4-hs3a),0>}
                                 }
                     cylinder {<0,hs4,0> <0,hs5,0> 0.5*kapb+0.5*(hs4-hs3a)}
                     torus{0.5*kapb+0.5*(hs4-hs3a),0.5*(hs6-hs5) translate<0,hs5+0.5*(hs6-hs5),0>  }
                     cylinder {<0,hs5,0> <0,hs6,0> 0.5*kapb+0.5*(hs4-hs3a)}
                     
                     object {Fusszier  rotate<0,45,0> translate <kapb-4,hs1+1,-kapb+4>}
                     object {Fusszier  rotate<0,135,0> translate <-kapb+4,hs1+1,-kapb+4>}
                     object {Fusszier  rotate<0,215,0> translate <-kapb+4,hs1+1,kapb-4>}
                     object {Fusszier  rotate<0,305,0> translate <kapb-4,hs1+1,kapb-4>}
                     }



#declare Kapitelquart=union {box {<-kapb,hs16,-kapb> <kapb,hs15,kapb>}
                             difference {box{<-kapb,0,0> <kapb,-3,4> rotate <-45,0,0> translate <0,hs15,-kapb> }
                                         box{<0,0.9*hs14,0> <3*kapb,1.1*hs15,-3*kapb> rotate<0,-45,0>} 
                                         box{<0,0.9*hs13,0> <-3*kapb,1.1*hs14,-3*kapb> rotate<0,45,0>}  
                                        }
                             
                             difference {cylinder{<-2*kapb,hs13+0.5*(hs14-hs13),-kapb+0.5*(hs14-hs13) > <2*kapb ,hs13+0.5*(hs14-hs13),-kapb+0.5*(hs14-hs13) > 0.5*(hs14-hs13) }
                                         box{<0,0.9*hs13,0> <3*kapb,1.1*hs14,-3*kapb> rotate<0,-45,0>} 
                                         box{<0,0.9*hs13,0> <-3*kapb,1.1*hs14,-3*kapb> rotate<0,45,0>}  
                                        }  
                             
                             box {<-kapb+0.5*(hs14-hs13),hs12,-kapb+0.5*(hs14-hs13)> <kapb-0.5*(hs14-hs13),hs13,kapb-0.5*(hs14-hs13)>}
                             difference {box {<-kapb+0.5*(hs14-hs13),hs11,-kapb+0.5*(hs14-hs13)> <kapb-0.5*(hs14-hs13),hs12,1>}
                                         cylinder{<-2*kapb,hs11+0.4*(hs12-hs11),-kapb+0.5*(hs14-hs13)> <2*kapb,hs11+0.4*(hs12-hs11),-kapb+0.5*(hs14-hs13)> 0.6*(hs12-hs11)}
                                         box{<0,0.9*hs11,0> <3*kapb,1.1*hs12,-3*kapb> rotate<0,-45,0>} 
                                         box{<0,0.9*hs11,0> <-3*kapb,1.1*hs12,-3*kapb> rotate<0,45,0>}  
                                        }
                             difference {box{<-0.7*kapb,0,0> <0.7*kapb,-3,4> rotate <-45,0,0> translate <0,hs11,-0.7*kapb> }
                                         box{<-1.1*kapb,hs11,-1.1*kapb> <1.1*kapb,hs12,1.1*kapb>}
                                         box{<0,0.9*hs10,0> <3*kapb,1.1*hs11,-3*kapb> rotate<0,-45,0>} 
                                         box{<0,0.9*hs10,0> <-3*kapb,1.1*hs11,-3*kapb> rotate<0,45,0>}                                         
                                        }
                             difference {cylinder{<-kapb,hs9+0.5*(hs10-hs9),-0.7*kapb+0.5*(hs10-hs9) > <kapb,hs9+0.5*(hs10-hs9),-0.7*kapb+0.5*(hs10-hs9) > 0.5*(hs10-hs9) }
                                         box{<0,0.9*hs9,0> <3*kapb,1.1*hs10,-3*kapb> rotate<0,-45,0>} 
                                         box{<0,0.9*hs9,0> <-3*kapb,1.1*hs10,-3*kapb> rotate<0,45,0>}  
                                        }
                            box{<-0.7*kapb+0.5*(hs10-hs9),hs9,-0.7*kapb+0.5*(hs10-hs9)> <0.7*kapb-0.5*(hs10-hs9),hs10,0.7*kapb-0.5*(hs10-hs9)>}                                                    
                        
                        }






#declare Kapitel1=union {object {Kapitelquart}
                        object {Kapitelquart rotate<0,90,0>}
                        object {Kapitelquart rotate<0,180,0>}
                        object {Kapitelquart rotate<0,270,0>}
                       }
                        
                        
#declare Kapitel2=union { box{<-0.7*kapb+0.5*(hs10-hs9),hs8,-0.7*kapb+0.5*(hs10-hs9)> <0.7*kapb-0.5*(hs10-hs9),hs9,0.7*kapb-0.5*(hs10-hs9)>}
                          cylinder {<-0.65*kapb+0.5*(hs10-hs9),hs8,0> <0.65*kapb-0.5*(hs10-hs9),hs8,0> 0.65*kapb-0.5*(hs10-hs9)}
                          cylinder {<-0.65*kapb+0.5*(hs10-hs9),hs8,0> <0.65*kapb-0.5*(hs10-hs9),hs8,0> 0.65*kapb-0.5*(hs10-hs9) rotate <0,90,0>}
                        }
#declare PStange=union {cone{<0,hs6,0> 0.4*kapb+0.5*(hs4-hs3a) <0,hs7,0> 0.65*kapb-0.5*(hs10-hs9)-1.5}
                        cone {<0,hs7,0> 0.65*kapb-0.5*(hs10-hs9)-1.5  <0,hs8,0> 0.65*kapb-0.5*(hs10-hs9) }
                        torus { 0.65*kapb-0.5*(hs10-hs9)-1.5, 1.5 translate <0,hs7,0>} 
                       }                                                         
                              

  
#declare Post=union { object {Sockel texture {T_Stone2}}
                      object {PStange texture {T_Stone2 scale 20}}
                      object {Kapitel2 texture {T_Stone2}}
                      object {Kapitel1 scale<1,1,dkz/dkx> texture {T_Stone2} }
                    }  


#declare Allpost=union { #declare zi=1;
                         #while (zi<11)
                         object {Post translate<-1*dkx,0,zi*dkz>}
                         object {Post translate<-2*dkx,0,zi*dkz>}
                         
                         object {Post translate<-5*dkx,0,zi*dkz>}  
                         object {Post translate<-6*dkx,0,zi*dkz>}  
                         object {Post translate<-7*dkx,0,zi*dkz>}  
                         object {Post translate<-8*dkx,0,zi*dkz>}  
                         
                         object {Post translate<-11*dkx,0,zi*dkz>}  
                         object {Post translate<-12*dkx,0,zi*dkz>}                          
               
                         #declare zi=zi+1;
                         #end 
                        
                         #declare zi=1;
                         #while (zi<11)
                         object {Post translate<-3*dkx,0,zi*dkz>}
                         object {Post translate<-4*dkx,0,zi*dkz>}
                         
                         object {Post translate<-9*dkx,0,zi*dkz>}  
                         object {Post translate<-10*dkx,0,zi*dkz>}                          
               
                         #declare zi=zi+3;
                         #end 
                        }

#declare Deckex=union {#declare xi=0;
                       #while (xi<14)
                           object {Deck translate<-xi*dkx,0,0>}
                           #declare xi=xi+1;
                       #end
                      }      
                     
#declare AllDecke=union {#declare zi=0;
                         #while (zi<12)
                           object {Deckex translate<0,0,zi*dkz>}
                           #declare zi=zi+1;
                       #end
                      }                     
                     
                     
                     


                           

#declare mauerkapitelquart=union { difference { box {<-0.7*kapb+0.5*(hs10-hs9), hs7,-0.7*kapb+0.5*(hs10-hs9) > <0.7*kapb-0.5*(hs10-hs9) ,hs7+0.5*(hs8-hs7),0>}  
                                                cylinder{<-kapb,hs7,0> <kapb,hs7,0> 5.5 scale <1,1,0.5> translate <0,0,-0.7*kapb+0.5*(hs10-hs9)+1>}
                                                box {<-30,0.9*hs7,-30> <0,1.1*hs8,30> rotate<0,45,0>}
                                                box {<30,0.9*hs7,-30> <0,1.1*hs8,30> rotate<0,-45,0>}     
                                              }  
                                   difference { cylinder{<-kapb,hs8,0> <kapb,hs8,0> 5.5 scale <1,1,0.5> translate <0,0,-0.7*kapb+0.5*(hs10-hs9)+3.75>}
                                                box {<-30,0.9*hs7,-30> <0,1.1*hs8,30> rotate<0,45,0>}
                                                box {<30,0.9*hs7,-30> <0,1.1*hs8,30> rotate<0,-45,0>}     
                                              }
                                 }               

#declare mauerkapitel=union {object {Kapitel1 scale<1,1,dkz/dkx>}
                             box{<-0.7*kapb+0.5*(hs10-hs9),hs8,-0.7*kapb+0.5*(hs10-hs9)> <0.7*kapb-0.5*(hs10-hs9),hs9,0.7*kapb-0.5*(hs10-hs9)>}   
                             object { mauerkapitelquart}
                             object { mauerkapitelquart rotate <0,90,0>} 
                             object { mauerkapitelquart rotate <0,180,0>}          
                             object { mauerkapitelquart rotate <0,270,0>}  
                            texture {T_Stone2}
                           }

#declare mauersockelquartz=union {difference {cylinder{<-dkx/2+0.8*hs1-kapb,1.5*hs1,-dkz/2-kapb> <-dkx/2+0.8*hs1-kapb,1.5*hs1,dkz/2+kapb> 0.8*hs1}       
                                              box {<0,0,-40> <40,3*hs1,40> rotate<0,45,0> translate <-dkx/2-kapb,0,-dkz/2-kapb>} 
                                              box {<0,0,-40> <40,3*hs1,40> rotate<0,-45,0> translate <-dkx/2-kapb,0,dkz/2+kapb >}             
                                             }
                                  difference {box{<-dkx/2+1*hs1-kapb,2.3*hs1+1,-dkz/2+1*hs1-kapb> <-dkx/2,3.4*hs1+1,dkz/2+kapb-1*hs1>}           
                                              cylinder{<-dkx/2+0.8*hs1-kapb,3.1*hs1+1,-dkz/2-2*kapb> <-dkx/2+0.8*hs1-kapb,3.1*hs1+1,dkz/2+2*kapb> 0.8*hs1}    
                                              box {<0,0,-40> <40,8*hs1,40> rotate<0,45,0> translate <-dkx/2-kapb,0,-dkz/2-kapb>} 
                                              box {<0,0,-40> <40,8*hs1,40> rotate<0,-45,0> translate <-dkx/2-kapb,0,dkz/2+kapb >}              
                                             }                                 
                                  difference {box{<0,0,-dkz/2+1*hs1-kapb> <4,4,dkz/2+kapb-1*hs1> rotate <0,0,-45> translate<-dkx/2+1*hs1-kapb+2.8,3.4*hs1+1,0> }                  
                                              box {<0,1,-40> <40,8*hs1,40> rotate<0,45,0> translate <-dkx/2-kapb,0,-dkz/2-kapb>}
                                              box {<0,1,-40> <40,8*hs1,40> rotate<0,-45,0> translate <-dkx/2-kapb,0,dkz/2+kapb>}              
                                             }
                                   
                                  difference {cylinder{<-dkx/2-2,3.4*hs1+1+2.5,-dkz/2-kapb> <-dkx/2-2,3.4*hs1+1+2.5,dkz/2+kapb> 2.5}           
                                              box {<0,1,-40> <40,8*hs1,40> rotate<0,45,0> translate <-dkx/2-kapb,0,-dkz/2-kapb>}
                                              box {<0,1,-40> <40,8*hs1,40> rotate<0,-45,0> translate <-dkx/2-kapb,0,dkz/2+kapb>}              
                                             }
                                                        
                           texture {T_Stone2}
                           }

#declare mauersockelquartx=union {difference {cylinder{<-dkx/2-kapb,1.5*hs1,-dkz/2+0.8*hs1-kapb> <dkx/2+kapb,1.5*hs1,-dkz/2+0.8*hs1-kapb> 0.8*hs1}
                                              box {<0,0,-20> <-40,3*hs1,20> rotate<0,45,0> translate <-dkx/2-kapb,0,-dkz/2-kapb>}
                                              box {<0,0,-20> <40,3*hs1,20> rotate<0,-45,0> translate <dkx/2+kapb,0,-dkz/2-kapb>}              
                                             }
                                  difference {box{<-dkx/2+1*hs1-kapb,2.3*hs1+1,-dkz/2+1*hs1-kapb> <dkx/2+kapb-1*hs1,3.4*hs1+1,-dkz/2>}
                                              cylinder{<-dkx/2-2*kapb,3.1*hs1+1,-dkz/2+0.8*hs1-kapb> <dkx/2+2*kapb,3.1*hs1+1,-dkz/2+0.8*hs1-kapb> 0.8*hs1}
                                              box {<0,1,-20> <-40,5*hs1,20> rotate<0,45,0> translate <-dkx/2-kapb,0,-dkz/2-kapb>}
                                              box {<0,1,-20> <40,5*hs1,20> rotate<0,-45,0> translate <dkx/2+kapb,0,-dkz/2-kapb>}              
                                             }                                 
                                  difference {box{<-dkx/2+1*hs1-kapb,0,0> <dkx/2+kapb-1*hs1,4,4> rotate <45,0,0> translate<0,3.4*hs1+1,-dkz/2+1*hs1-kapb+2.8> }                  
                                              box {<0,1,-20> <-40,5*hs1,20> rotate<0,45,0> translate <-dkx/2-kapb,0,-dkz/2-kapb>}
                                              box {<0,1,-20> <40,5*hs1,20> rotate<0,-45,0> translate <dkx/2+kapb,0,-dkz/2-kapb>}              
                                             }
                                  difference {cylinder{<-dkx/2-kapb,3.4*hs1+1+2.5,-dkz/2-2> <dkx/2+kapb,3.4*hs1+1+2.5,-dkz/2-2> 2.5}
                                              box {<0,3,-20> <-40,6*hs1,20> rotate<0,45,0> translate <-dkx/2-kapb,0,-dkz/2-kapb>}
                                              box {<0,3,-20> <40,6*hs1,20> rotate<0,-45,0> translate <dkx/2+kapb,0,-dkz/2-kapb>}              
                                             }           
                                  
                           texture {T_Stone2}
                           }

#declare Pfeiler=union { box{<-dkx/2-2,0,-dkz/2-2> <dkx/2+2,300,dkz/2+2> texture {T_newBrick}} 
                         box{<-dkx/2-kapb,0,-dkz/2-kapb> <dkx/2+kapb,hs1,dkz/2+kapb> texture {T_Stone2}} 
                         box{<-dkx/2+0.8*hs1-kapb,2.3*hs1,-dkz/2+0.8*hs1-kapb> <dkx/2+kapb-0.8*hs1,2.3*hs1+1,dkz/2-0.8*hs1+kapb> texture {T_Stone2}} 
                         object {mauersockelquartx }
                         object {mauersockelquartx scale <1,1,-1>}
                         object {mauersockelquartz }
                         object {mauersockelquartz scale <-1,1,1>} 
                         object {mauerkapitel translate <-dkx/2,0,-dkz/2>}
                         object {mauerkapitel translate <-dkx/2,0,dkz/2>}
                         object {mauerkapitel translate <dkx/2,0,-dkz/2>}
                         object {mauerkapitel translate <dkx/2,0,dkz/2>}
                       }

#declare Boden=box{<0,0,0> <-kl,-1,kl>}


#declare Fussleiste=union {box{<0,0,-kapb> <1,hs1,0>  }
                           cylinder{<0,1.5*hs1,0.8*hs1-kapb> <1,1.5*hs1,+0.8*hs1-kapb> 0.8*hs1}        //parallel x 1 einheit lang
                           box{<0,2.3*hs1,+0.8*hs1-kapb> <1,2.3*hs1+1,0-0.8*hs1+kapb>}
                           difference {box{<0,2.3*hs1+1,1*hs1-kapb> <1,3.4*hs1+1,0>}
                                       cylinder{<-dkx/2-2*kapb,3.1*hs1+1,+0.8*hs1-kapb> <dkx/2+2*kapb,3.1*hs1+1,+0.8*hs1-kapb> 0.8*hs1}
                                      }                                 
                           box{<0,0,0> <1,4,4> rotate <45,0,0> translate<0,3.4*hs1+1,+1*hs1-kapb+2.8> }
                           cylinder{<0,3.4*hs1+1+2.5,-2> <1,3.4*hs1+1+2.5,-2> 2.5}          
                                  
                           texture {T_Stone2}
                           }


#declare Raum=union{box{<0,-1,2> <-kl,2*hs16,-10>}
                    box{<-kl+2,-1,0> <-kl-10,2*hs16,kl>}
                    box{<-kl,-1,kl-2> <0,2*hs16,kl+10>}
                    box{<kl-2,-1,0> <kl+10,2*hs16,kl>}
                    #declare zi=0;
                    #while (zi<12)
                           object {mauerkapitel translate<-13*dkx,0,zi*dkz>}
                           #declare zi=zi+1;
                    #end
                    #declare zi=0;
                    #while (zi<12)
                           object {mauerkapitel translate<0*dkx,0,zi*dkz>}
                           #declare zi=zi+1;
                    #end                   
                    #declare xi=0;
                    #while (xi<14)
                           object {mauerkapitel translate<-xi*dkx,0,0>}
                           #declare xi=xi+1;
                    #end                     
                    #declare xi=0;
                    #while (xi<14)
                           object {mauerkapitel translate<-xi*dkx,0,11*dkz>}
                           #declare xi=xi+1;
                    #end                   
                    
                    object {Fussleiste translate <0,0,11*dkz> scale <-kl,1,1>}
                    object {Fussleiste scale <-kl,1,-1>}
                    object {Fussleiste rotate <0,90,0> scale <1,1,-kl>}
                    object {Fussleiste rotate <0,90,0> scale <-1,1,-kl> translate <-13*dkx,0,0>}
                   }                     

#declare Boden=union {difference{ box{<0,0,0> <-kl,-1,kl>}  
                                  box{<-4*dkx+kapb,-2,2*dkz-kapb> <-6*dkx-kapb,1,4*dkz+kapb>}
                                  box{<-4*dkx+kapb,-2,7*dkz-kapb> <-6*dkx-kapb,1,9*dkz+kapb>}
                                  box{<-7*dkx+kapb,-2,5*dkz-kapb> <-10*dkx-kapb,1,7*dkz+kapb>}
                                  texture {T_Fliese1 rotate<0,0,90>}
                                }
                      box{<-4*dkx+kapb,-1,2*dkz-kapb> <-6*dkx-kapb,0,4*dkz+kapb> rotate <0,0,-90> texture {T_Fliese2 rotate<0,0,0>} rotate <0,0,90>  }
                      box{<-4*dkx+kapb,-1,7*dkz-kapb> <-6*dkx-kapb,0,9*dkz+kapb> rotate <0,0,-90> texture {T_Fliese2 rotate<0,0,0>} rotate <0,0,90> }
                      box{<-7*dkx+kapb,-1,5*dkz-kapb> <-10*dkx-kapb,0,7*dkz+kapb> rotate <0,0,-90> texture {T_Fliese2 rotate<0,0,0>} rotate <0,0,90> }
                     }


#declare Kerzstandkomplett=union {object {kerzstand}
                                  object {Kerze translate <1+hs6,hs7-40+1,0> rotate <0,0,0>}
                                  object {Kerze translate <1+hs6,hs7-40+1,0> rotate <0,90,0>}
                                  object {Kerze translate <1+hs6,hs7-40+1,0> rotate <0,180,0>}
                                  object {Kerze translate <1+hs6,hs7-40+1,0> rotate <0,270,0>}
                                 
                                  object {Kerze translate <1+hs6/1.5,hs7-20+1,0> rotate <0,45,0> }
                                  object {Kerze translate <1+hs6/1.5,hs7-20+1,0> rotate <0,135,0> } 
                                  object {Kerze translate <1+hs6/1.5,hs7-20+1,0> rotate <0,225,0> }  
                                  object {Kerze translate <1+hs6/1.5,hs7-20+1,0> rotate <0,315,0> }         
                                  object {Kerze translate <0,hs7+10+1,0> }
                                 
                                 } 

#declare Alt1Boden=union {box {<-dkx/2-kapb+4,-1,-dkz/2-kapb+4> <dkx/2+kapb-4,hs1+2,dkz/2+kapb>}
                          cylinder { <-dkx/2+kapb,hs1,-dkz/2-kapb+4> <dkx/2-kapb,hs1,-dkz/2-kapb+4> 2}
                          cylinder { <-dkx/2-kapb+4,hs1,-dkz/2+kapb> <-dkx/2-kapb+4,hs1,dkz/2> 2}
                          cylinder { <dkx/2+kapb-4,hs1,-dkz/2+kapb> <dkx/2+kapb-4,hs1,dkz/2> 2}
                          texture {T_Stone10 scale 10 normal { bumps 1.4 scale 7 } finish {phong 0}}
                         }
#declare Alt1Post=union {cylinder {<0,hs1,0> <0,80,0> kapb*0.4 texture {T_Stone2 scale 20}}
                         torus { kapb*0.4, 1 translate <0,hs1+3,0> texture {T_Stone2}}
                         torus { kapb*0.4, 1 translate <0,hs1+3+7,0> texture {T_Stone2}}
                         difference {cylinder{<0,hs1+3,0> <0,hs1+3+7,0> kapb*0.4+0.5} 
                                     torus { kapb*0.4+3.41, 3.4 translate <0,hs1+6.5,0>}
                                     texture {T_Stone2}
                                    }
                         torus { kapb*0.4, 1 translate <0,80-12,0> texture {T_Stone2}}
                         difference {cylinder {<-0.4*kapb-1,0,0> <0.4*kapb+1,0,0> 0.4*kapb+1 scale <1,1.4,1> translate <0,80-2,0>}
                                     box {<-kapb,80-2,-kapb> <kapb,80+kapb,kapb>}
                                     texture {T_Stone2}
                                    }
                         difference {cylinder {<-0.4*kapb-1,0,0> <0.4*kapb+1,0,0> 0.4*kapb+1 scale <1,1.4,1> translate <0,80-2,0> rotate<0,90,0>}
                                     box {<-kapb,80-2,-kapb> <kapb,80+kapb,kapb> rotate<0,90,0>}
                                     texture {T_Stone2}
                                    }                       
                        }                         
#declare Alt1Aufsatz=union{box {<-0.8*dkx/2,80+4,dkz/2-30> <0.8*dkx/2, 80+4+7, dkz/2>}
                           box {<-0.8*dkx/2+2,80+4+7,dkz/2-30+2> <0.8*dkx/2-2, 80+4+7+2, dkz/2>}
                           difference {box{<-0.9*dkx/2,80+4+7+2,dkz/2-40> <0.9*dkx/2,80+4+7+2+9,dkz/2>}
                                       cylinder {<-dkx/2,80+4+7+2+3.5,0> <dkx/2,80+4+7+2+3.5,0> 6 scale <1,1,3> translate <0,0,dkz/2-30-12>}
                                       cylinder {<0,80+4+7+2+3.5,-dkz/2> <0,80+4+7+2+3.5,dkz> 6 scale <3,1,1> translate <-0.8*dkx/2-12,0,0> }
                                       cylinder {<0,80+4+7+2+3.5,-dkz/2> <0,80+4+7+2+3.5,dkz> 6 scale <3,1,1> translate <0.8*dkx/2+12,0,0> }
                                      }
                           box {<-0.9*dkx/2,80+4+7+2+9,dkz/2-35> <0.9*dkx/2,80+4+7+2+9+21,dkz/2>}
                           difference {cylinder{<-dkx/2,80+4+7+2+9+10.5,dkz/2-35> <dkx/2,80+4+7+2+9+10.5,dkz/2-35> 3.5}
                                       box {<-dkx,80+4+7+2+9,-10> <0,80+4+7+2+9+21,10> rotate <0,45,0> translate<-0.9*dkx/2,0,dkz/2-35>}
                                       box {<dkx,80+4+7+2+9,-10> <0,80+4+7+2+9+21,10> rotate <0,-45,0> translate<0.9*dkx/2,0,dkz/2-35>} 
                                      }
                           difference {cylinder{<-0.9*dkx/2,80+4+7+2+9+10.5,20> <-0.9*dkx/2,80+4+7+2+9+10.5,dkz/2> 3.5}
                                       box {<dkx,80+4+7+2+9,-10> <0,80+4+7+2+9+21,10> rotate <0,45,0> translate<-0.9*dkx/2,0,dkz/2-35>}
                                      }
                           difference {cylinder{<0.9*dkx/2,80+4+7+2+9+10.5,20> <0.9*dkx/2,80+4+7+2+9+10.5,dkz/2> 3.5}
                                       box {<-dkx,80+4+7+2+9,-10> <0,80+4+7+2+9+21,10> rotate <0,-45,0> translate<0.9*dkx/2,0,dkz/2-35>}
                                      }
                           difference {box {<-0.9*dkx/2,80+4+7+2+9+21,dkz/2-35> <0.9*dkx/2,80+4+7+2+9+21+4,dkz/2>}
                                       box {<-1*dkx/2,-1,0> <1*dkx/2,20,-20> rotate <45,0,0> translate <0,80+4+7+2+9+21,dkz/2-35>}
                                       box {<0,-1,0> <-20,20,dkz> rotate<0,0,-45> translate <-0.9*dkx/2,80+4+7+2+9+21,0>}
                                       box {<0,-1,0> <20,20,dkz> rotate<0,0,45> translate <0.9*dkx/2,80+4+7+2+9+21,0>}
                                      }                                                                                                     
                           texture {T_Stone21 scale 20}                         
                          }
                          
#declare Altarbild=union {  difference {box {<-0.7*dkx/2,126,-5> <0.7*dkx/2,1.4*dkx/2+126,0> }
                                        box {<-0.68*dkx/2,127+0.5,-6> <0.68*dkx/2,1.398*dkx/2+126,1> }
                                        translate <0, 0,dkz/2-2>
                                        texture { T_Gold_4A finish {phong 0}}
                                       } 
                           
                            height_field {  gif "altarb2.gif" smooth texture { T_Gold_4A normal { bumps 2 scale 5 } finish {phong 0}}
                                            water_level 0.1    
                                            translate <-.5, 0, > rotate <-90,0,0>
                                            scale <1.4*dkx/2, 1.4*dkx/2, 5>
                                            translate <0, 126 ,dkz/2-2>
                                         }
                            box {<0,0,0> <1,1,0.1> pigment {image_map { tga "maxernst.tga"} }   
                                 scale <1.2*dkx/2, 1.32*dkx/2,1>
                                 translate <-0.6*dkx/2,126,-0.1+dkz/2-2>
                                } 
                         }               
                         



#declare Altar1=union {object {Alt1Boden}
                       superellipsoid { <0.15,0.15>  scale <0.9*dkx/2,4,dkz/2> translate <0,80,1/2*dkz> texture {T_Stone2 scale 20}  } 
                       object {Alt1Post translate<-0.45*dkx+kapb,0,kapb>}
                       object {Alt1Post translate<0.45*dkx-kapb,0,kapb>}
                       object {Alt1Post translate<-0.45*dkx+kapb,0,dkz/2-1.5*kapb>}
                       object {Alt1Post translate<0.45*dkx-kapb,0,dkz/2-1.5*kapb>}
                       object {Alt1Aufsatz}
                       object {Altarbild}                         
                      }

#declare Alt2Post=union {box {<-7,0,-7> <7,hs1+6,7> texture {T_Stone2}} 
                         difference {box{<-6,hs1+6,-6> <6,hs1+6+8,6>}
                                     cylinder {<-8,hs1+6+4,-7> <8,hs1+6+4,-7> 3.6}
                                     cylinder {<-8,hs1+6+4,-7> <8,hs1+6+4,-7> 3.6 rotate <0,90,0>}
                                     cylinder {<-8,hs1+6+4,-7> <8,hs1+6+4,-7> 3.6 rotate <0,180,0>}
                                     cylinder {<-8,hs1+6+4,-7> <8,hs1+6+4,-7> 3.6 rotate <0,270,0>}
                                     texture {T_Stone2}
                                    }
                         superellipsoid {<0.2,0.2> scale <7,1.5,7> translate <0,hs1+6+8+1.5> texture {T_Stone2}    }
                         difference {box{<-6,hs1+6+8+3,-6> <6,hs1+6+8+3+8,6>}
                                     cylinder {<-8,hs1+6+8+3+4,-7> <8,hs1+6+8+3+4,-7> 3.6}
                                     cylinder {<-8,hs1+6+8+3+4,-7> <8,hs1+6+8+3+4,-7> 3.6 rotate <0,90,0>}
                                     cylinder {<-8,hs1+6+8+3+4,-7> <8,hs1+6+8+3+4,-7> 3.6 rotate <0,180,0>}
                                     cylinder {<-8,hs1+6+8+3+4,-7> <8,hs1+6+8+3+4,-7> 3.6 rotate <0,270,0>}
                                     texture {T_Stone2}
                                    } 
                         intersection {box {<-10,74-7-8-3,-10> <10,hs1+6+8+3+8,10>}
                                       cylinder {<-20,0,0> <20,0,0> 10 scale <1,3.3,1> translate <0,74-7-8-3,0>} 
                                       cylinder {<0,0,-20> <0,0,20> 10 scale <1,3.3,1> translate <0,74-7-8-3,0>}
                                       texture {T_Stone2 scale 20}
                                      }                                    
                         superellipsoid {<0.2,0.2> scale <11,3,11> translate <0,74-7-8-3,0> texture {T_Stone2 scale 20} } 
                    
                                      
                              
                         difference {box{<-6,74-7,-6> <6,74-7-9,6>}
                                     cylinder {<-8,74-7-4,-7> <8,74-7-4,-7> 3.6}
                                     cylinder {<-8,74-7-4,-7> <8,74-7-4,-7> 3.6 rotate <0,90,0>}
                                     cylinder {<-8,74-7-4,-7> <8,74-7-4,-7> 3.6 rotate <0,180,0>}
                                     cylinder {<-8,74-7-4,-7> <8,74-7-4,-7> 3.6 rotate <0,270,0>}
                                     texture {T_Stone2}
                                    }
                         box {<-7,74-7,-7> <7,76,7> texture {T_Stone2}} 
                        } 

#declare Alt2Aufsatz=union { superellipsoid { <0.1,0.1> scale <0.95*dkx/2,2,dkz/4> translate <0,84,dkz/2> }
                             difference  {box {<0.95*dkx/2,86,dkz/2-dkz/4> <-0.95*dkx/2,92,dkz/2>}
                                          box {<dkx,10,0> <-dkx,-20,-dkz > rotate <-20,0,0> translate <0,92,dkz/2-dkz/4>}
                                          box {<0,10,-dkz> <-40,-20,dkz> rotate <0,0,20> translate <-0.95*dkx/2,92,0>}
                                          box {<0,10,-dkz> <40,-20,dkz> rotate <0,0,-20> translate <0.95*dkx/2,92,0>}
                                         }
                            cylinder {<-0.95*dkx/2,92+1,dkz/2-dkz/4> <0.95*dkx/2,92+1,dkz/2-dkz/4> 1 }          
                            cylinder {<-0.95*dkx/2,92+1,dkz/2-dkz/4> <-0.95*dkx/2,92+1,dkz> 1 }
                            cylinder {<0.95*dkx/2,92+1,dkz/2-dkz/4> <0.95*dkx/2,92+1,dkz> 1 }
                            sphere {<0.95*dkx/2,92+1,dkz/2-dkz/4> 1}
                            sphere {<-0.95*dkx/2,92+1,dkz/2-dkz/4> 1} 
                            box {<-0.95*dkx/2,92,dkz/2-dkz/4> <0.95*dkx/2,92+2,dkz> }
                            
                         
                            height_field {  tga "skulptur2.tga" smooth
                                            water_level 0.1    
                                            translate <-.5, 0, > rotate <-90,0,0>
                                            scale <1.8*dkx/2, 1.5*dkx/2, 40>
                                            translate <0, 94 ,dkz/2+2>
                                         }
                            
                            box {<-3,94,0> <3,94+80,6> translate <0,0,dkz/2-22> }
                            box {<-23,94+60-6,0> <23,94+60,6> translate <0,0,dkz/2-22> }
                            
                            #include "Mannfleht.inc"
                            object {BlobMan scale 0.9 rotate <0,90,0> translate <28,133,30>}
                            #include "Mannkniet.inc"
                            object {BlobMan scale 0.9 rotate <0,-90,0> translate <-25,133,40>}
                           texture {T_Stone8 scale 20 normal { bumps 2 scale 5 } finish {phong 0} }
                           }
                        
#declare Altar2=union {object {Alt1Boden}
                       superellipsoid { <0.35,0.15>  scale <1.2*dkx/2,4,dkz/3> translate <0,80,1/2*dkz-20> texture {T_Stone2 scale 20}  } 
                       box {<-1.1*dkx/2,80,1/2*dkz-55> <1.1*dkx/2,75,1/2*dkz-55+2*dkz/3-10> texture {T_Stone2 }}
                       box {<-1.0*dkx/2,75,1/2*dkz-55+0.1*dkx/2> <1.0*dkx/2,74,1/2*dkz-55+2*dkz/3-10-3> texture {T_Stone2 }}
                       object {Alt2Post translate<-0.6*dkx+kapb,0,kapb>}
                       object {Alt2Post translate<0.6*dkx-kapb,0,kapb>}
                       object {Alt2Post translate<-0.6*dkx+kapb,0,dkz/2-1.5*kapb>}
                       object {Alt2Post translate<0.6*dkx-kapb,0,dkz/2-1.5*kapb>}
                       object {Alt2Aufsatz}
                       //object {Altarbild}                         
                      }

#declare DMFWood5 = 
pigment {
    wood
    turbulence 0.05
    octaves 6
    scale <0.075, .075, 1>
    color_map {
        [0.1 rgb <0.075, 0.0250, 0.01250>]
        [0.9 rgb <0.0586, 0.0156, 0.0078>]
    }
}                                               

#declare Kreuz=union {box{<-2,-30,-1> <2,15,0>}
                      box{<-15,-2,-1> <15,2,0>}
                      texture {DMFWood5}
                      }
#include "kruzifix.inc"
#declare Kruzifix=union { object {Kreuz}
                          object {BlobMan rotate <4,0,0> scale 0.3 translate <0,-0.3,-1.5>   } 
                        }



//object {Post translate <-9*dkx,0,4*dkz>}
//object {Post translate <-10*dkx,0,4*dkz>}

object {Kruzifix scale 1.5 translate <-9.5*dkx,hs9,2.5*dkz-dkz/2-2> }     
object {Allpost}
object {AllDecke texture { T_Stone2 normal { bumps 1.4 scale 7 } finish {phong 0} } }                                //
object {Raum texture {T_newBrick}} 
object {Boden }

object {Kerzstandkomplett rotate<0,-15,0> translate <-6.2*dkx ,0,1.7*dkz>  }
object {Kerzstandkomplett rotate<0,15,0> translate <-4.8*dkx ,0,5.6*dkz>  }

object {Pfeiler translate <-9.5*dkx,0,2.5*dkz>  }
object {Pfeiler translate <-9.5*dkx,0,5.5*dkz> texture {T_newBrick} }  
object {Pfeiler translate <-9.5*dkx,0,8.5*dkz> texture {T_newBrick} }
object {Pfeiler translate <-3.5*dkx,0,2.5*dkz> texture {T_newBrick} } 
object {Pfeiler translate <-3.5*dkx,0,5.5*dkz> texture {T_newBrick} } 
object {Pfeiler translate <-3.5*dkx,0,8.5*dkz> texture {T_newBrick} }

object {Altar1 translate <-9.5*dkx,0,4.5*dkz>}
object {Altar2 translate <-9.5*dkx,0,7.5*dkz>}                 