// To create height_field image

#version unofficial MegaPov 0.6;  

#declare F_Granite=
 function {pigment {granite}}

#declare BrickObj=
 isosurface {
  function {x^8+y^8+z^8 - 1 - F_Granite(x*0.2,y*0.2,z*0.1)*0.75}
  threshold 0
  //method 1
  method 2
  max_gradient 900
  //eval
  contained_by {box {-1.5,1.5}}
 }

//object {BrickObj scale <1,0.5,0.6> translate y*0.75 rotate y*45}

union {
 #declare Up=0;
 #while (Up<15)
  #declare Along=0;
  #while (Along<13)
   object {BrickObj scale <1,0.5,0.5>*0.95 translate <Along*2,0.5+Up,0>}
   #declare Along=Along+1;
  #end      
  #declare Up=Up+1;
  #declare Along=0;
  #while (Along<12)
   object {BrickObj scale <1,0.5,0.5>*0.95 translate <Along*2+1,0.5+Up,0>}
   #declare Along=Along+1;
  #end
  #declare Up=Up+1;
 #end                  
 pigment {
  gradient z
  scale 0.75
 }
 finish {ambient 1}
 translate <-13,-7.5,0>
}                  

camera {
 //
 location <0,0,-18>
 look_at <0,0,0>
 orthographic
}
