// Persistence of Vision Ray Tracer Scene Description File
// File: Worship.inc
// Vers: 3.1
// Desc: Objects for worship scene 
// Date: 5 Jan 2001 
// Auth: Gail Shaw

// 1 unit = 1 metre

#version unofficial megapov 0.6;

#include "kolors.inc"
#include "ManifestTex.inc"  
#include "macros.inc"       
#include "knot.inc"
#include "blade.inc"
#include "CurvedBlade.inc" 
#include "WaveBlade.inc"
#include "LeafBlade.inc"
#include "AxeBlade.inc"      
#include "kneeling.inc"
#include "kneelingp.inc"
#include "priest.inc"

#ifndef (Testing)
 #declare Testing=0;
 #declare Final=0;
#end     

global_settings {
  assumed_gamma 1.0 // in global_settings
}

#declare Pyramid = 
 intersection {
  plane { x, 1  rotate <  0, 0,  40>}
  plane { -x, 1  rotate <  0, 0, -40>}
  plane { z, 1  rotate <-40, 0,   0>}
  plane { -z, 1  rotate < 40, 0,   0>}
  plane { -y, 0 }
  //translate <0 ,0, 0>
 }

#declare rnd=seed(7836);

// Weapons components

// sword pieces

#declare Guard1=
 union {
  cylinder {
   <-0.1,0,0>,<0.1,0,0>,0.03
  }
  sphere {
   <-0.1,0,0>,0.03
  }
  sphere {
   <0.1,0,0>,0.03
  }
  scale <1,0.5,1>
 }
 
#declare Guard2=
 union {
  difference {
   box {
    <-0.12,-0.04,-0.015>,<0.12,0.012,0.015>
   }
   cylinder {
    <-0.12,-0.17,-0.1>,<-0.12,-0.17,0.1>,0.167
   }
   cylinder {
    <0.12,-0.17,-0.1>,<0.12,-0.17,0.1>,0.167
   }
  }
  cylinder {
   <0,-0.03,-0.015>,<0,-0.03,0.015>,0.018
  }
  cylinder {
   <-0.12,0.0045,-0.015>,<-0.12,0.0045,0.015>,0.0075
  }
  cylinder {
   <0.12,0.0045,-0.015>,<0.12,0.0045,0.015>,0.0075
  }
  cylinder {
   <-0.04,0,-0.015>,<0.04,0,-0.015>,0.003
  }
  sphere {            
   <-0.04,0,-0.015>,0.003
  }   
  sphere {            
   <0.04,0,-0.015>,0.003
  }
  cylinder {
   <-0.04,0,0.015>,<0.04,0,0.015>,0.003
  }
  sphere {            
   <-0.04,0,0.015>,0.003
  }   
  sphere {            
   <0.04,0,0.015>,0.003
  }
 }

#declare Guard3=
 union {
  difference {
   box {
    <-0.12,-0.04,-0.015>,<0.12,0.012,0.015>
   }
   cylinder {
    <-0.12,-0.17,-0.1>,<-0.12,-0.17,0.1>,0.167
   }
   cylinder {
    <0.12,-0.17,-0.1>,<0.12,-0.17,0.1>,0.167
   }
  }
  cylinder {
   <0,-0.03,-0.015>,<0,-0.03,0.015>,0.018
  }
  cylinder {
   <-0.12,0.0045,-0.015>,<-0.12,0.0045,0.015>,0.0075
  }
  cylinder {
   <0.12,0.0045,-0.015>,<0.12,0.0045,0.015>,0.0075
  }
  sphere_sweep {           
   b_spline_sphere_sweep,
   9,                      
   <-0.023,-0.0165,0>,0.005
   <-0.023,-0.0265,0>,0.005
   <-0.024,-0.0365,0>,0.005
   <-0.024,-0.05,0>,0.005
   <-0.024,-0.09,0>,0.005
   <-0.028,-0.12,0>,0.005
   <-0.033,-0.15,0>,0.005
   <-0.038,-0.16,0>,0.005
   <-0.042,-0.17,0>,0.005
  }   
  sphere_sweep {           
   b_spline_sphere_sweep,
   9,                      
   <0.023,-0.0165,0>,0.005
   <0.023,-0.0265,0>,0.005
   <0.024,-0.0365,0>,0.005
   <0.024,-0.05,0>,0.005
   <0.024,-0.09,0>,0.005
   <0.028,-0.12,0>,0.005
   <0.033,-0.15,0>,0.005
   <0.038,-0.16,0>,0.005
   <0.042,-0.17,0>,0.005
  }
 }
 
#declare Guard4=
 union {
  difference {
   box {
    <-0.12,-0.04,-0.015>,<0.12,0.012,0.015>
   }
   cylinder {
    <-0.2,-0.23,-0.1>,<-0.2,-0.23,0.1>,0.26
   }
   cylinder {
    <0.2,-0.23,-0.1>,<0.2,-0.23,0.1>,0.26
   } 
  }
  cylinder {
   <0,-0.03,-0.015>,<0,-0.03,0.015>,0.02
   scale <1.2,1,1>
  } 
  sphere {
   <0,0,0>,0.025
   scale <0.6,1,0.3>
   translate <0,-0.025,-0.01>
   texture {
    pigment {White}
    finish {ambient 0.4 specular 0.8 roughness 0.001}
   }
  }
  sphere_sweep {
   b_spline_sphere_sweep
   9,
   <-0.01,-0.028,0>,0.01
   <-0.024,-0.03,0>,0.0095
   <-0.032,-0.033,0>,0.0085
   <-0.04,-0.043,0>,0.0075
   <-0.045,-0.053,0>,0.0065
   <-0.045,-0.065,0>,0.0055
   <-0.04,-0.075,0>,0.0045
   <-0.03,-0.08,0>,0.0035
   <-0.02,-0.075,0>,0.0025
  }   
  sphere_sweep {
   b_spline_sphere_sweep
   9,
   <0.01,-0.028,0>,0.01
   <0.024,-0.03,0>,0.0095
   <0.032,-0.033,0>,0.0085
   <0.04,-0.043,0>,0.0075
   <0.045,-0.053,0>,0.0065
   <0.045,-0.065,0>,0.0055
   <0.04,-0.075,0>,0.0045
   <0.03,-0.08,0>,0.0035
   <0.02,-0.075,0>,0.0025
  }
  sphere_sweep {
   b_spline_sphere_sweep
   7,
   <-0.06,0,0>,0.0086
   <-0.07,-0.01,0>,0.0075
   <-0.08,-0.02,0>,0.0064
   <-0.085,-0.03,0>,0.0053
   <-0.085,-0.04,0>,0.0042
   <-0.085,-0.05,0>,0.0031
   <-0.07,-0.06,0>,0.002
  }
  sphere_sweep {
   b_spline_sphere_sweep
   7,
   <0.06,0,0>,0.0086
   <0.07,-0.01,0>,0.0075
   <0.08,-0.02,0>,0.0064
   <0.085,-0.03,0>,0.0053
   <0.085,-0.04,0>,0.0042
   <0.085,-0.05,0>,0.0031
   <0.07,-0.06,0>,0.002
  }
 } 
 
#declare Guard5=
 union {
  difference {
   sphere {
    <0,0,0>,0.08
   }
   sphere {
    <0,0,0>,0.07
   }
   box {
    <-0.2,0,-0.2>,<0.2,0.2,0.2>
   }
   scale <1,0.9,1>
  }
  torus {
   0.075,0.005
  }
  cylinder {
   <-0.15,0,0>,<0.15,0,0>,0.005
  }
  sphere {
   <-0.15,0,0>,0.012
  }
  sphere {
   <0.15,0,0>,0.012
  }
  object {
   HalfTorus(0.07,0.005)
   rotate x*-90
   scale <1,1.25,0.8>
   translate <0.04,0.08,0>
  }
  sphere {
   <0.04,0.07*1.25+0.08,0>,0.012
  }
 }

#declare Guard6=
 union {
  cylinder {
   <-0.075,0,0>,<0.075,0,0>,0.005
  }
  object {
   QuarterTorus(0.02,0.005)
   rotate x*-90
   rotate z*-180
   translate <-0.075,0.02,0>
  }
  sphere {
   <-0.095,0.02,0>,0.005
  }                 
  object {QuarterTorus(0.02,0.005)
   rotate x*-90
   translate <0.075,-0.02,0>
  }
  sphere {
   <0.095,-0.02,0>,0.005
  }
  object {
   HalfTorus(0.064,0.005)
   rotate x*-90
   scale <1,1.25,0.8>
   translate <0.04,0.08,0>
  }
  sphere {
   <0.04,0.064*1.25+0.08,0>,0.012
  }
 }
      
 
#declare Hilt1=
 union {
  cylinder {
   <0,0,0>,<0,0.22,0>,0.015
   pigment {Brown}
  }
  #declare i=0;
  #while (i<0.2)
   torus {
    0.015,0.001
    scale <1,5,1>
    matrix <
     1.0,0.5,0.0,
     0.0,1.0,0.0,
     0.0,0.0,1.0,
     0.0,0.0,0.0
    >
    translate y*i
   }
   torus {
    0.015,0.001
    scale <1,5,1>
    matrix <
     1.0,-0.5,0.0,
     0.0,1.0,0.0,
     0.0,0.0,1.0,
     0.0,0.0,0.0
    >
    translate y*i  
   }             
   #declare i=i+0.02;
  #end        
 } 
 
#declare Hilt2=
 union {
  cylinder {
   <0,0,0>,<0,0.22,0>,0.015
   pigment {Brown}
  }
  #declare i=0;
  #while (i<0.2)
   torus {
    0.015,0.001
    scale <1,5,1>
    matrix <
     1.0,-0.5,0.0,
     0.0,1.0,0.0,
     0.0,0.0,1.0,
     0.0,0.0,0.0
    >
    translate y*i
   }
   #declare i=i+0.015;
   torus {
    0.016,0.001
    scale <1,2,1>
    matrix <
     1.0,1.0,0.0,
     0.0,1.0,0.0,
     0.0,0.0,1.0,
     0.0,0.0,0.0
    >       
    translate y*0.05
   }
   torus {
    0.016,0.001
    scale <1,2,1>
    matrix <
     1.0,1.0,0.0,
     0.0,1.0,0.0,
     0.0,0.0,1.0,
     0.0,0.0,0.0
    >       
    translate y*0.11
   }                
   torus {
    0.016,0.001
    scale <1,2,1>
    matrix <
     1.0,1.0,0.0,
     0.0,1.0,0.0,
     0.0,0.0,1.0,
     0.0,0.0,0.0
    >       
    translate y*0.17
   }
  #end        
 } 

#declare Hilt3=
 union {
  #declare i=0;
  #while (i<0.22)
   torus {
    0.013,0.003
    translate y*i
    //pigment {rgb <i*5,0,0>}
   }
   #declare i=i+0.006;
  #end
 }
 
#declare Pommel1=
 union {
  cylinder {
   <0,-0.05,0>,<0,-0.03,0>,0.024
  }
  cylinder {
   <0,-0.05,0>,<0,0.05,0>,0.01
  }
  cylinder {
   <-0.05,0,0>,<0.05,0,0>,0.01
  }
  sphere {
   <-0.058,0,0>,0.01
  }
  sphere {
   <0.058,0,0>,0.01
  } 
  sphere {
   <0,0.058,0>,0.01
  }
  torus {
   0.05,0.01
   rotate x*90
  }
  scale 0.8 
 }
 
#declare Pommel2=
 union {
  torus {
   0.013,0.005
  }
  cone {
   <0,0,0>,0.018,<0,0.075,0>,0.001
  }
  sphere {
   <0,0.071,0>,0.0075
  }
 }
 
#declare Pommel3=
 union {
  torus {
   0.013,0.005
  }
  sphere {
   <0,0,0>,0.019
   scale <1,2,1>
   translate y*0.01
  }
  sphere {
   <0,0,0>,0.008
   scale <1,2,1>
   translate <0,0.01,-0.014>
   texture {
    pigment {White}
    finish {ambient 0.4 specular 0.6 roughness 0.001}
   }
  }
  sphere {
   <0,0,0>,0.008
   scale <1,2,1>
   translate <0,0.01,0.014>
   texture {
    pigment {White}
    finish {ambient 0.4 specular 0.6 roughness 0.001}
   }
  }
 } 
 
#declare Pommel4=
 union {
  sphere {
   <0,0.02,0>,0.02  
  }
  torus {
   0.02,0.01
   rotate x*90
   translate y*0.02
  }
 }
 
// axes, maces and hammers 
 
#declare AxeHead1=
 union {
  cylinder {
   <0,-0.04,0>,<0,0.04,0>,0.06
  }                        
  sphere {
   <0,0,0>,0.06
   scale <1,0.5,1>
   translate y*0.04
  }                 
  sphere {
   <0,0,0>,0.06
   scale <1,0.5,1>
   translate y*-0.04
  }
  cone {
   <0.05,0,0>,0.025,<0.275,0,0>,0
   scale <1,1,0.5>
  }                
  object {AxeBlade scale 0.03 rotate x*-90 translate <-0.05,0,0> texture {BladeTex rotate z*90}}
  texture {BladeTex}
 } 
 
#declare AxeHead2=     
 union {
  difference {
   union {
    cone {
     <0,0,0>,0.175,<0,0,0.01>,0.15
    }
    cone {
     <0,0,0>,0.175,<0,0,-0.01>,0.15
    }                 
   }
   cylinder {
    <0,0.25,-0.1>,<0,0.25,0.1>,0.2 
    scale <0.75,1,1>
   }
   cylinder {
    <0,-0.25,-0.1>,<0,-0.25,0.1>,0.2
    scale <0.75,1,1>
   }
  }
  cylinder {
   <0,-0.06,0>,<0,0.06,0>,0.038
  }                            
  sphere {
   <0,0,0>,0.038
   scale <1,0.75,1>
   translate y*0.06
  }
  sphere {
   <0,0,0>,0.038
   scale <1,0.75,1>
   translate y*-0.06
  }
  scale <1.2,1,1>*1.1   
 }
 
#declare MaceHead1=
 union {
  cylinder {
   <0,-0.15,0>,<0,0.14,0>,0.038
  }
  box {
   <-0.15,-0.15,-0.01>,<0.15,0.15,0.01>
   rotate z*45
   scale <0.5,1,1>
  } 
  box {
   <-0.01,-0.15,-0.15>,<0.01,0.15,0.15>
   rotate x*45
   scale <1,1,0.5>
  }
  box {
   <-0.01,-0.15,-0.15>,<0.01,0.15,0.15>
   rotate x*45
   scale <1,1,0.5>
   rotate y*45
  }           
  box {
   <-0.01,-0.15,-0.15>,<0.01,0.15,0.15>
   rotate x*45
   scale <1,1,0.5>
   rotate y*-45
  }   
 }
 
#declare MaceHead2=
 union {
  sphere {
   <0,0,0>,0.1
  }
  torus {
   0.03, 0.01
   translate y*-0.1
  }
  cone {
   <0,0.09,0>,0.02,<0,0.15,0>,0
  }  
  #declare Angle=0;
  #while (Angle<360)
   cone {
    <0,0.09,0>,0.02,<0,0.15,0>,0
    rotate z*-45
    rotate y*Angle
   }              
   #declare Angle=Angle+45;
  #end 
  #declare Angle=0;   
  #while (Angle<360)
   cone {
    <0,0.09,0>,0.02,<0,0.15,0>,0
    rotate z*-90
    rotate y*Angle
   }              
   #declare Angle=Angle+30;
  #end
  #declare Angle=0;   
  #while (Angle<360)
   cone {
    <0,0.09,0>,0.02,<0,0.15,0>,0
    rotate z*-135
    rotate y*Angle
   }              
   #declare Angle=Angle+45;
  #end
 } 
 
#declare Handle1= 
 union {
  cylinder {
   <0,0,0>,<0,1,0>,0.035
  }
  sphere {
   <0,0,0>,0.035
   scale <1,0.75,1>
   translate y*1
  }
  cylinder {
   <0,-0.01,0>,<0,0.25,0>,0.038
   texture {Leather}
  }
  sphere {
   <0,0,0>,0.06
   scale <1,0.7,1>
  }
  torus {
   0.035,0.007
   translate y*0.25
  }
 }
 
#declare Handle2=
 union {
  sphere {
   <0,0,0>,0.04
   scale <1,1.2,1>
   translate y*0.56
  }
  torus {
   0.03,0.008
   scale <1,2,1>
   translate y*0.528
  }
  cylinder {
   <0,-0.6,0>,<0,0.6,0>,0.03
  }
  sphere {
   <0,-0.61,0>,0.04
  }
  torus {
   0.03,0.01
   translate y*-0.25
  }
  cylinder {
   <1,-0.6,0>,<1,-0.25,0>,0.031
   texture {
     gradient < 1, 1, 0 >
     texture_map {
      [0.00, Leather]
      [0.25, Leather]
      [0.25, pigment {Clear}]
      [0.50, pigment {Clear}]
      [0.50, Leather]
      [0.75, Leather]
      [0.75, pigment {Clear}]
      [1.00, pigment {Clear}]
     }
     scale 0.1
   }
   translate x*1
  }
  cylinder {
   <-1,-0.6,0>,<-1,-0.25,0>,0.0312
   texture {
     gradient < 1, 1, 0 >
     texture_map {
      [0.00, Leather]
      [0.25, Leather]
      [0.25, pigment {Clear}]
      [0.50, pigment {Clear}]
      [0.50, Leather]
      [0.75, Leather]
      [0.75, pigment {Clear}]
      [1.00, pigment {Clear}]
     }
     scale 0.1
   }
   translate x*1
  }
  translate y*0.4
 }   

#declare Handle3=
 union {
  cone {
   <0,0.7,0>,0.025,<0,-0.35,0>,0.04
  }
  sphere {
   <0,-0.35,0>,0.04
  }
  torus {
   0.039,0.01
   translate y*-0.32
  }
  torus {
   0.035,0.01
   translate y*-0.06
  }
  translate y*0.3
 }

#declare Handle4=
 union {
  cylinder {
   <0,-0.5,0>,<0,0.6,0>,0.03
  }
  cylinder {
   <0,-0.485,0>,<0,-0.158,0>,0.031
   texture {Leather}
  }
  torus {
   0.03,0.01
   translate y*-0.49
  }
  torus {
   0.03,0.01
   translate y*-0.15
  }
  torus {
   0.03,0.01
   translate y*-0.135
  }
  sphere {
   <0,-0.51,0>,0.02
  }
  sphere {
   <0,-0.53,0>,0.01
  }     
  translate y*0.4
 }

// spears

#declare SpearHead1= 
 union {
  cylinder {
   <0,-0.02,0>,<0,0.075,0>,0.026
  }
  object {
   Pyramid 
   scale 0.02
   rotate y*45
   scale <1,10,0.2>
   translate y*0.07 
  }
  object {
   Pyramid 
   scale 0.018
   rotate y*45
   scale <1,7.5,0.1>
   rotate z*35
   translate <0.005,0.07,0> 
  }
  object {
   Pyramid 
   scale 0.018
   rotate y*45
   scale <1,7.5,0.1>
   rotate z*-35
   translate <-0.005,0.07,0>
  }
  texture {BladeTex}
 }

#declare SpearHead2=
 union {
  /*cylinder {
   <0,-0.02,0>,<0,0.05,0>,0.026
  }*/
  object {
   Pyramid 
   scale 0.02
   rotate y*45
   scale <1,15,0.2>
  }
  sphere_sweep {
   b_spline_sphere_sweep
   7,
   <0,0.01,0>,0.0175
   <-0.03,0.01,0>,0.015
   <-0.06,0.03,0>,0.0125
   <-0.075,0.055,0>,0.01
   <-0.075,0.08,0>,0.0075
   <-0.06,0.105,0>,0.005
   <-0.04,0.13,0>,0.001
   scale 1.5
   translate x*0.03
  } 
  sphere_sweep {
   b_spline_sphere_sweep
   7,
   <0,0.01,0>,0.0175
   <0.03,0.01,0>,0.015
   <0.06,0.03,0>,0.0125
   <0.075,0.055,0>,0.01
   <0.075,0.08,0>,0.0075
   <0.06,0.105,0>,0.005
   <0.04,0.13,0>,0.001
   scale 1.5
   translate x*-0.03
  }   
  sphere_sweep {
   b_spline_sphere_sweep
   7,
   <0,0,0>,0.0175
   <-0.03,-0.01,0>,0.015
   <-0.06,-0.03,0>,0.0125
   <-0.075,-0.05,0>,0.01
   <-0.075,-0.07,0>,0.0075
   <-0.06,-0.09,0>,0.005
   <-0.04,-0.11,0>,0.001
   scale 1.25
   translate <0.03,0.03,0>
  }
  sphere_sweep {
   b_spline_sphere_sweep
   7,
   <0,0,0>,0.0175
   <0.03,-0.01,0>,0.015
   <0.06,-0.03,0>,0.0125
   <0.075,-0.05,0>,0.01
   <0.075,-0.07,0>,0.0075
   <0.06,-0.09,0>,0.005
   <0.04,-0.11,0>,0.001
   scale 1.25
   translate <-0.03,0.03,0>
  }
 }

#declare Naginata = 
 union {
  cylinder {
   <0,0,0>,<0,1.5,0>,0.025
   texture {T_LightWood scale 0.025 }
  }
  torus {
   0.024,0.01
   translate y*0.4
   texture {T_LightWood scale 0.01}
  }
  sphere {
   <0,0,0>,0.035
   scale <1.2,0.25,1>
   translate y*1.5
  }
  torus {
   0.06,0.0085
   translate y*1.5
  }
  cylinder {
   <-0.06,1.4,0>,<0.06,1.5,0>,0.0075
  }
  cylinder {
   <0,1.4,-0.06>,<0,1.5,0.06>,0.0075
  }
  object {CurvedBlade rotate x*-90 scale <0.02,0.032,0.02> translate y*1.5}
  texture {BladeTex}
 }

/*  
#declare Warhammer = 
 union {
  cylinder {
   <0,0,0>,<0,0.5,0>,0.025
   texture {T_DarkWood}
  }
  cylinder {
   <0,-0.001,0>,<0,0.02,0>,0.026
  }
  sphere {
   <0,0,0>,0.01          
   scale <1,0.75,1>
  }
  object {
   RoundedBox(<-0.026,-0.03,-0.026>,<0.026,0.03,0.026>,0.001)
   translate y*0.5
  }
  object {HammerHead rotate x*-90 scale <0.015,0.012,0.0075>/2 translate <0.02,0.5,0>}
  object {HammerSpike rotate x*-90 scale <0.02,0.012,0.0075>/2 translate <-0.02,0.5,0>}
  sphere {
   <0.07,0.5,0>,0.015
  }    
  cone {
   <0,0.52,0>,0.02,<0,0.62,0>,0
  }
  texture {BladeTex}
 }*/

// shields

#declare WoodenShield=
 union {
  intersection {
   union {
    #declare Board=0;
    #while (Board<13)
     object {
      BevelledBox(0.051,0.7,0.04)
      translate <-0.35+Board*0.05,0,0>
      texture {T_DarkWood translate x*100*rand(rnd)}
      translate y*-0.35
     }
     #declare Board=Board+1;
    #end
   }
   cylinder {
    <0,0,-0.2>,<0,0,0.2>,0.3
   }
  }
  torus {
   0.3,0.0275
   rotate x*90
   translate z*0.025
  }                 
  difference {
   cylinder {
    <0,0,-0.0025>,<0,0,0.05>,0.3
   }
   cylinder {
    <0,0,-0.0125>,<0,0,0.15>,0.25
   }                      
  }
  #declare Angle=0;
  #while (Angle<360)
   sphere {
    <0,0.275,-0.0025>,0.015
    rotate z*Angle
   }
   #declare Angle=Angle+20;
  #end
 }

#declare RoundMetalShield=
 union {
  cylinder {
   <0,0,0>,<0,0,-0.02>,0.3
  }
  torus {
   0.3,0.01
   rotate x*90
   translate z*-0.01
   texture {T_Brass_4C}
  }
  /*cylinder {
   <0,0,-0.019>,<0,0,-0.04>,0.25
  }
  torus {
   0.25,0.01
   rotate x*90
   translate x*-0.03
  }*/
  cylinder {
   <0,0,-0.029>,<0,0,-0.06>,0.22
  }
  torus {
   0.22,0.01
   scale <1,2,1>
   rotate x*90
   translate z*-0.04   
   texture {T_Brass_4C}
  }                 
  /*cylinder {
   <0,0,-0.039>,<0,0,-0.08>,0.15
  }
  torus {
   0.15,0.01
   rotate x*90
   translate x*-0.07
  }*/                 
  cylinder {
   <0,0,-0.049>,<0,0,-0.1>,0.14
  }
  torus {
   0.14,0.01
   scale <1,2,1>
   rotate x*90
   translate z*-0.08
   texture {T_Brass_4C}
  }
  difference {
   cylinder {
    <0,0,-0.059>,<0,0,-0.12>,0.06
   }
   cylinder {
    <0,0,-0.11>,<0,0,-0.13>,0.04
   }
  }
  torus {
   0.06,0.01
   rotate x*90
   translate z*-0.11  
   texture {T_Brass_4C}
  }
  torus {
   0.04,0.005
   rotate x*90
   translate z*-0.125  
  }                 
  sphere {
   <0,0,0>,0.041
   scale <1,1,0.25>
   translate <0,0,-0.11>
   material {Ruby}
  }
  sphere {
   <0,0.26,-0.02>,0.015 
   texture {T_Brass_4C}
  }
  sphere {
   <0,-0.26,-0.02>,0.015 
   texture {T_Brass_4C}
  }    
  sphere {
   <0.18,0,-0.06>,0.015 
   texture {T_Brass_4C}
  }
  sphere {
   <-0.18,0,-0.06>,0.015 
   texture {T_Brass_4C}
  }
  sphere {
   <0,-0.10,-0.10>,0.015 
   texture {T_Brass_4C}
  }
  sphere {
   <0,0.10,-0.10>,0.015 
   texture {T_Brass_4C}
  }
 }

#declare KiteShieldBase=
 difference {  
  intersection {
   cylinder {
    <0,-3.1,0>,<0,3.1,0>,4
   }
   cylinder {
    <2.88,0,-5>,<2.88,0,5>,4.2
   }
   cylinder {
    <-2.88,0,-5>,<-2.88,0,5>,4.2
   }    
  }          
  union {
   cylinder {
    <0,-3.6,0>,<0,3.6,0>,3.9 
    texture {T_Chrome_1B}
   }
   cylinder {
    <-1.8,2.2,-5>,<-1.8,2.2,5>,2
   } 
   cylinder {
    <1.8,2.2,-5>,<1.8,2.2,5>,2
   }                       
   box {
    <-10,-10,0>,<10,10,10>
   }
  }                       
    
 }

#declare KiteShield= 
 union {
  object {
   KiteShieldBase
   texture {
    pigment { rgb <0.61,0,0.1> }
    finish {
     ambient 0.1
     brilliance 4
     diffuse 0.8
     //metallic
     specular 0.60
     roughness 1/500
     //reflection 0.5
    }             
    normal {
     bumps 0.15
     scale 0.05
    }
   }
  }
  intersection {
   object {KiteShieldBase scale 1.008}
   union {
    cylinder {
     <2.88,0,-5>,<2.88,0,5>,4.0
     inverse
    }
    cylinder {
     <-2.88,0,-5>,<-2.88,0,5>,4.0
     inverse
    }
    cylinder {
     <-1.8,2.2,-5>,<-1.8,2.2,5>,2.2
    } 
    cylinder {
     <1.8,2.2,-5>,<1.8,2.2,5>,2.2
    }
   }
   texture {T_Gold_3D}   
  }
  intersection {
   object {KiteShieldBase scale 1.008}
   intersection {
    cylinder {
     <2.88,-0.1,-5>,<2.88,-0.1,5>,3.5
    }
    cylinder {
     <-2.88,-0.1,-5>,<-2.88,-0.1,5>,3.5
    }           
    box {
     <-5,-5,-5>,<5,-0.1,5>
    }
   }
   /*texture {
    material_map {
     gif "Asheaf.gif"
      texture {pigment {Black}}*/
      texture {T_Silver_3D}
    /*}
    translate <-0.5,-0.08,0>
    scale <1.15,1.8,1>
   }*/ 
  }
  union {
   sphere {
    <0,1.05,-4>,0.07
   }                
   sphere {
    <0,-2.9,-4>,0.07
   }
   sphere {
    <-1.22,0.14,-3.81>,0.07
   }
   sphere {
    <1.22,0.14,-3.81>,0.07
   }                
   sphere {
    <0.9,0.3,-3.9>,0.07
   } 
   sphere {
    <-0.9,0.3,-3.9>,0.07
   }
   sphere {
    <0.59,0.48,-3.95>,0.07
   }
   sphere {
    <-0.59,0.48,-3.95>,0.07
   }
   sphere {
    <0.28,0.72,-3.99>,0.07
   }
   sphere {
    <-0.28,0.72,-3.99>,0.07
   }
   sphere {
    <-1.2,-0.2,-3.81>,0.07
   }
   sphere {
    <1.2,-0.2,-3.81>,0.07
   }
   sphere {
    <1.17,-0.55,-3.82>,0.07
   }
   sphere {
    <-1.17,-0.55,-3.82>,0.07
   }
   sphere {
    <1.12,-0.9,-3.84>,0.07
   }
   sphere {
    <-1.12,-0.9,-3.84>,0.07
   }
   sphere {
    <-1.04,-1.25,-3.86>,0.07
   }
   sphere {
    <1.04,-1.25,-3.86>,0.07
   }
   sphere {
    <0.93,-1.55,-3.88>,0.07
   }
   sphere {
    <-0.93,-1.55,-3.88>,0.07
   }
   sphere {
    <-0.8,-1.85,-3.9>,0.07
   }
   sphere {
    <0.8,-1.85,-3.9>,0.07
   }
   sphere {
    <-0.64,-2.15,-3.93>,0.07
   }
   sphere {
    <0.64,-2.15,-3.93>,0.07
   }	  
   sphere {
    <0.42,-2.41,-3.97>,0.07
   }
   sphere {
    <-0.42,-2.41,-3.97>,0.07
   }
   sphere {
    <0.22,-2.66,-3.98>,0.07
   }
   sphere {
    <-0.22,-2.66,-3.98>,0.07
   }
   texture {T_Chrome_2A} 
  }
  translate z*4
  scale 0.18
  translate y*0.5
 }

#declare TowerShield=
 union {
  difference {
   union {
    cylinder {
     <0,-5,0>,<0,5,0>,5
    }
    difference {
     cylinder {
      <0,-5,0>,<0,5,0>,5.02
     }
     box {
      <-2.25,-4.6,-6>,<2.25,4.6,6>
     }
     texture {T_Gold_2C}
    }
   }
   union {
    cylinder {
     <0,-5.1,0>,<0,5.1,0>,4.8
    }
    box {
     <-6,-5.1,-4.3>,<6,5.1,5.1>
    }
   }
  }
  intersection {
   difference {
    union {
     cone {
      <0,2,-5>,0,<0,4,-5>,1
     }
     cone {
      <0,2,-5>,0,<-2,2,-5>,1
     }
     cone {
      <0,2,-5>,0,<2,2,-5>,1
     }
     cone {
      <0,2,-5>,0,<0,-3,-5>,1
     }
    }
    union {
     cone {
      <0,3.3,-4.9>,0,<0,4,-4.9>,1
     }
     cone {
      <-1.2,2,-5>,0,<-2,2,-5>,1
     }
     cone {
      <1.2,2,-5>,0,<2,2,-5>,1
     }
     cone {
      <0,-1.5,-4.9>,0,<0,-3,-4.9>,1
     }
    }
   }
   difference {
    cylinder {
     <0,-5,0>,<0,5,0>,5.001
    }
    cylinder {
     <0,-5.1,0>,<0,5.1,0>,4.9
    }
   }
   texture {T_Chrome_2D}
  }
  difference {
   torus {
    0.4,0.05
    rotate z*90
   }
   box {
    <-0.1,-0.5,-0.5>,<0.1,0.5,0.05>
   }
   scale <3,1.5,1>
   translate <-1.75,0,-4.7>
   texture {Leather2}
  }
  difference {
   torus {
    0.6,0.05
    rotate z*90
   }
   box {
    <-0.1,-0.7,-0.7>,<0.1,0.7,0.05>
   }
   scale <3,1.5,1>
   translate <1.6,0,-4.73>
   texture {Leather2}
  }
  pigment {White*0.25}
  finish {
   //reflection 0.6
   specular 0.7
   roughness 0.001
   metallic
   ambient 0.1
   diffuse 0.4
  }
  normal {
   dents 0.2
   turbulence 0.1
  }
  scale 0.1
}

// arrow

#declare Arrow=
 union {
  cylinder {
   <-0.125,0,0>,<0.12,0,0>,0.005
  }
  box {
   <0,0,0>,<0.05,0.02,0.001>
   matrix <
    1.0,0.0,0.0,
    0.5,1.0,0.0,
    0.0,0.0,1.0,
    0.0,0.0,0.0
   >
   pigment {
    gradient x
    color_map {
     [0.0 White]
     [0.4 White]
     [0.42 Clear]
     [0.58 Clear]
     [0.6 White]
     [1.0 White]
    }
    scale 0.001
   }
   translate <0.05,0.004,0>
  }
  box {
   <0,0,0>,<0.05,0.02,0.001>
   matrix <
    1.0,0.0,0.0,
    0.5,1.0,0.0,
    0.0,0.0,1.0,
    0.0,0.0,0.0
   >
   pigment {
    gradient x
    color_map {
     [0.0 White]
     [0.4 White]
     [0.42 Clear]
     [0.58 Clear]
     [0.6 White]
     [1.0 White]
    }
    scale 0.001
   }
   translate <0.05,0.004,0>
   rotate x*120
  }            
  box {
   <0,0,0>,<0.05,0.02,0.001>
   matrix <
    1.0,0.0,0.0,
    0.5,1.0,0.0,
    0.0,0.0,1.0,
    0.0,0.0,0.0
   >
   pigment {
    gradient x
    color_map {
     [0.0 White]
     [0.4 White]
     [0.42 Clear]
     [0.58 Clear]
     [0.6 White]
     [1.0 White]
    }
    scale 0.001
   }
   translate <0.05,0.004,0>
   rotate x*-120
  }
  translate x*0.125
  rotate y*90
 }

#declare GoldBowl = 
 union {
  difference {
   isosurface {
    function {x^2+y^2+z^2 - 1}
    threshold 0
    method 2
    max_trace 4 
    contained_by {sphere {0,1}}
   }
   sphere {
    <0,0,0>,0.9
   }    
   box {
    <-2,0,-2>,<2,2,2>
   }
  }
  torus {
   0.95,0.05
  }
  scale 0.1
 }
  
#declare Cup=
 union {
  difference {
   sphere {
    <0,0,0>,0.05
   }
   sphere {
    <0,0,0>,0.045
   }
   box {
    <-0.1,0,-0.1>,<0.1,0.1,0.1>
   }
   scale <1,1.5,1>
  }
  difference {
   cone {
    <0,0,0>,0.05,<0,0.075,0>,0.045
   }
   cone {
    <0,-0.0001,0>,0.045,<0,0.0751,0>,0.04    
   }
  }
  torus {
   0.0425,0.0025
   translate y*0.075
  }
  cylinder {
   <0,-0.074,0>,<0,-0.205,0>,0.01
  }                              
  difference {
   cylinder {
    <0,-0.2,0>,<0,-0.208,0>,0.051
   }
   sphere {
    <0,0,0>,0.205
   }
  }
  torus {
   0.051,0.004
   translate y*-0.204
  }
  sphere {
   <0,0,0>,0.01
   scale <1,1.5,0.25>
   material {Ruby}
   translate <0,0.02,-0.0465>
  }
  sphere {
   <0,0,0>,0.01
   scale <1,1.5,0.25>
   material {Ruby}
   translate <0,0.02,0.0465>
  }                 
  sphere {
   <0,0,0>,0.01
   scale <0.25,1.5,1>
   material {Ruby}
   translate <0.0465,0.02,0>
  }
  sphere {
   <0,0,0>,0.01
   scale <0.25,1.5,1>
   material {Ruby}
   translate <-0.0465,0.02,0>
  }
 }

#declare AltarSword=
 union {
  box {
   <-0.03,0,-0.03>,<0.03,0.8,0.03>
   rotate y*45
   scale <1,1,0.2>
   texture {ShinyBladeTex}
  }
  intersection {
   box {
    <-0.03,0,-0.03>,<0.03,0.8,0.03>
    rotate y*45
    scale <1,1,0.2>*1.01
   }
   union {
    text {ttf "Glyphis2.ttf" "l" 0.35,0 scale 0.05 translate <-0.03,0.73,-0.009>}
    text {ttf "Glyphis3.ttf" "B" 0.35,0 scale 0.05 translate <-0.03,0.66,-0.009>}
    text {ttf "Glyphis3.ttf" "D" 0.35,0 scale 0.05 translate <-0.03,0.59,-0.009>}
    text {ttf "Glyphis3.ttf" "F" 0.35,0 scale 0.05 translate <-0.03,0.52,-0.009>}
    text {ttf "Glyphis3.ttf" "H" 0.35,0 scale 0.05 translate <-0.03,0.45,-0.009>}
    text {ttf "Glyphis3.ttf" "J" 0.35,0 scale 0.05 translate <-0.03,0.38,-0.009>}
    text {ttf "Glyphis3.ttf" "L" 0.35,0 scale 0.05 translate <-0.03,0.31,-0.009>}
    text {ttf "Glyphis3.ttf" "N" 0.35,0 scale 0.05 translate <-0.03,0.24,-0.009>}
    text {ttf "Glyphis3.ttf" "P" 0.35,0 scale 0.05 translate <-0.03,0.17,-0.009>}
   }
   texture {RuneTex}
  }
  object {Guard1 translate y*0.79 texture {T_Gold_4E}}
  object {Hilt1 scale <1,1,0.85> translate y*0.8 pigment {Brown*0.9}}
  object {Pommel1 translate y*1.06 texture {T_Gold_4E}} 
 }

#declare Altar = 
 union {
  difference {
   object {
    RoundedBox (<-0.5,0.05,-0.25>,<0.5,0.6,0.25>,0.01)
   }
   box {
    <-0.45,0.55,-0.2>,<0.45,0.7,0.2>
    texture {T_Chrome_3A}
   }
  }
  height_field {
   pattern 200,200 {
    hf_gray_16
    bozo
    scale 0.05
    color_map {
     [0 rgb 0]
     [1 rgb 1]
    }
   }
   scale <0.9,0.015,0.4>
   translate <-0.45,0.551,-0.2>
   texture {pigment {rgb 0.1}}
  }
  object {
   RoundedBox(<-0.6,-0.01,-0.35>,<0.6,0.1,0.35>,0.02)
  }
  height_field {
   png "Runes.png"
   scale <0.99,0.01,0.5>
   rotate x*-90
   translate <-0.495,0.05,-0.249>
   texture {
    T_Copper_2E
   }
  }
  object {
   AltarSword
   rotate y*45
   translate <-0.54,0,-0.29>
  }
  object {
   AltarSword
   rotate y*45
   translate <0.54,0,0.29>
  }
  object {
   AltarSword
   rotate y*-45
   translate <0.54,0,-0.29>
  }    
  object {
   AltarSword
   rotate y*-45
   translate <-0.54,0,0.29>
  }
  texture {
   granite 
   texture_map {
    [0.0 AltarTex]
    [0.85 AltarTex ]
    [0.85 T_Gold_4D]
    [1.0 T_Gold_4D]
   }
   scale 0.05
  }
 }
 
#declare Avatar = 
 merge {
  object {SwordBlade rotate x*90 scale <0.015,0.0235,0.015> translate y*-0.35}
  merge {
   difference {
    sphere {
     <0,0,0>,0.04
    }                
    cylinder {
     <0,0,-0.05>,<0,0,0.01>,0.02
    }
    scale <1.5,1.2,1>
    translate y*0.51
   }
   sphere {
    <0,0,0>,0.03
    scale <1.5,1.2,1>
    translate <0,0.51,-0.02>  
    material {Ruby}
   }
   cone {
    <-0.01,0,0>,0.01,<0.35,0,0>,0.003
    scale <1,2.5,1>
    rotate z*-20
    translate y*0.52
   }
   sphere {
    <0.35,0,0>,0.025
    rotate z*-20
    translate y*0.52
   }
   cone {
    <-0.01,0,0>,0.01,<0.35,0,0>,0.003
    scale <1,2.5,1>
    rotate z*-20
    translate y*0.52
    scale <-1,1,1>
   }
   sphere {
    <-0.35,0,0>,0.025
    rotate z*20
    translate y*0.52
   }
  }
  sphere {
   <0,0,0>,0.03
   scale <0.17,0.15,0.1>
   translate y*0.52
  }
  cylinder {
   <0,0.54,0>,<0,0.9,0>,0.036
   scale <1,1,0.8>
  }
  #declare i=0.55;
  #while (i<0.9)
   torus {
    0.03,0.01
    scale <1,1,0.8>
    translate y*i
   }
   #declare i=i+0.015;
  #end 
  merge {         
   difference {
    cylinder {     
     <0,0,-0.032>,<0,0,0.032>,0.07
    }
    cylinder {
     <0,0,-0.052>,<0,0,0.052>,0.05
    }
   }
   torus {
    0.07,0.032
    rotate x*-90
   }
   torus {
    0.05,0.01
    rotate x*-90
    translate z*-0.022
   }
   sphere {
    <0,0,0>,0.045
    material {Ruby}
    translate z*-0.008
   }
   scale <1,0.7,1>
   translate y*0.95
  } 
  texture {
   pigment {rgbf<1,1,0.85,0.15>}
   finish {
    specular 0.7
    roughness 0.008
    reflection 0.7
    ambient 0.65
    diffuse 0.3
   }
  }
  //texture {BladeTex}
 } 

#declare AvatarFlame=
 sphere {
  <0,0,0>,1.75
  pigment {rgbt <1,1,1,1>}
  hollow
  interior {
   media {
    emission <1,0.75,0>*3
    absorption <0,0.25,1>*8
    method 3
    samples 1,1 
    intervals 3
    density {
     spherical
     scallop_wave
     turbulence 1
     color_map  {
       [0.0 color rgb <0, 0, 0>]
       [0.25 color rgb <1,0.7,0.4>*1.5]
       [0.5 color rgb <1,0,0>*1.75]
       [0.75 color rgb <1,0.8,0.4>*2]
       [1.0 color rgb <1,1,0.7>*2.5]
     }
     //scale 2
    }
   }
  }
  scale <0.6,1.5,0.4>*0.5
 }
    
    

// architecture

#declare F_Relief=
 function {pigment {image_map {png "ColumnRelief.png" map_type 2 once} scale <1,2,1> translate y*0.25}}

#declare Column=
 union {
  /*cylinder {
   <0,-0.1,0>,<0,2.25,0>,0.2
  }*/
  isosurface {
   function {x^2+z^2-0.2^2 - F_Relief(x,y,z)*0.003}
   threshold 0
   method 2
   max_gradient 6.3
   contained_by {box {<-1,0,-1>,<1,2.25,1>}}
  }
  #if (Testing=1)
   cylinder {
    <0,1.49,0>,<0,1.51,0>,0.21
    pigment {Red}
   }
  #end
  difference {
   sphere {
    <0,0,0>,0.3
   }
   torus {
    0.3,0.1
    scale <1,2,1>
    translate y*0.225
   }
   scale <1,0.75,1>
  }
  torus {
   0.3,0.025
  }        
  torus {
   0.2,0.015
   translate y*0.225
  }
  torus {
   0.2,0.015
   translate y*2.25
  }
 }

#declare Arch=
 union {
  object {
   HalfTorus(1.25,0.2)
   rotate z*90
   translate y*2.25
  }
  difference {
   box {
    <-0.2,2.25,-1.25>,<0.2,3.75,1.25>
   }
   cylinder {
    <-0.3,2.25,0>,<0.3,2.25,0>,1.25
   }
  }
  cylinder {
   <0,2.25,-1.25>,<0,3.75,-1.25>,0.2
  }
  cylinder {
   <0,2.25,1.25>,<0,3.75,1.25>,0.2
  }  
 }

#declare Flame=
 sphere {
  <0,0,0>,1
  pigment {rgbt <1,1,1,1>}
  hollow
  interior {
   media {
    emission <1,0.75,0>*5
    absorption <0,0.25,1>*10
    method 3
    samples 1,1 
    intervals 3
    density {
     spherical
     scallop_wave
     turbulence 0.5
     color_map  {
       [0.0 color rgb <0, 0, 0>]
       [0.25 color rgb <1,0.7,0.4>*2.5]
       [0.5 color rgb <1,0,0>*2.75]
       [0.75 color rgb <1,0.8,0.4>*3]
       [1.0 color rgb <1,1,0.7>*3.5]
     }
     //scale 2
    }
   }
  }
  scale <0.6,1.5,0.4>*0.06
 }

#declare Lamp=
 union {
  torus {
   0.1,0.02
  }
  torus {
   0.08,0.02
   translate y*0.02
  }
  torus {
   0.06,0.02
   translate y*0.04
  }                
  torus {
   0.04,0.02
   translate y*0.06
  }                
  torus {
   0.02,0.02
   translate y*0.08
  }                
  cylinder {
   <0,0.09,0>,<0,1.1,0>,0.02
  }
  difference {
   sphere {
    <0,0,0>,0.12
   }
   sphere {
    <0,0,0>,0.115
   }               
   box {
    <-0.2,0,-0.2>,<0.2,0.2,0.2>
   }
   scale <1,0.5,1>
   translate y*1.15
  }
  torus {
   0.02,0.01
   translate y*1.09
  }
  object {Flame scale <1,1.2,1> translate y*1.15}
  object {Flame scale 0.75*<1,1.2,1> translate <0.04,1.15,0.04>}
  object {Flame scale 0.75*<1,1.2,1> translate <-0.03,1.15,0.035>}
  object {Flame scale 0.75*<1,1.2,1> translate <0.041,1.15,-0.04>}
  object {Flame scale 0.75*<1,1.2,1> translate <-0.035,1.15,-0.038>}
  light_source {
   <0,1.2,0>
   rgb<1,1,0.8>*0.1
   #if (Final=1)
    area_light <0,0,0.05>, <0,0.05,0> 2,2
    adaptive 1
    orient
   #end
   fade_distance 6
   fade_power 2
  }
  texture {BladeTex}
 }

#declare C_COLS = 20;
#declare C_ROWS = 20;

#declare C_FIELD = array[20][20]{
{160,66,33,66,33,66,33,66,33,66,33,66,33,66,33,66,33,66,33,130},
{72,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,9},
{144,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,132},
{72,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,9},
{144,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,132},
{72,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,9},
{144,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,132},
{72,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,9},
{144,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,132},
{72,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,9},
{144,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,132},
{72,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,9},
{144,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,132},
{72,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,9},
{144,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,132},
{72,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,9},
{144,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,132},
{72,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,9},
{144,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,68,17,132},
{40,18,36,18,36,18,36,18,36,18,36,18,36,18,36,18,36,18,36,10}}

#declare Knots=
 object {
  knots()
  rotate x*-90
  translate <-0.25,-0.75,0>
  scale <0.075,0.075,0.05>
 }

// test
/*
camera {
 location <0.5,1.7,-6>
 look_at <0,0.9,0>
 angle 30
}

light_source {
 <2,10,-2>
 White
}

object {Avatar translate y*1}

//object {Cup texture {T_Silver_4D} scale 2 translate y*1}

//object {Lamp texture {BladeTex}}
  
//for reflection

box {
 <-5,-5,0>,<-6,5,-10>
 pigment {Tan5}
}

box {
 <5,-5,0>,<6,5,-10>
 pigment {Tan5}
} 

box {
 <5,-5,-10>,<-5,5,-11>
 pigment {Tan5}
}

box {
 <2,-3,-9.99>,<-2,2.5,-10.5>
 pigment {VeryDarkBrown}
}

sphere {
 <0,4,-8>,0.5
 pigment {Yellow}
}

plane {
 z,10
 hollow
 pigment {
  checker White*0.8, White*0.4 scale 0.5
 }
} 
*/