#version unofficial Megapov 0.7;


//////////////////////////////////////


#include "textures.inc"

#declare PSWL_FOLG = texture {
    finish {
        ambient 0.05
        diffuse 0.85
        phong 0.03
        phong_size 1.0
    }
    pigment { rgb <0.204, 0.337, 0.063> }
}

#declare PSWL_BARK = texture {
    finish {
        ambient 0.05
        diffuse 0.85
        phong 0.03
        phong_size 1.0
    }
    pigment { rgb <0.349, 0.263, 0.231> }
}

//   Object    CenterX    CenterY    CenterZ    LengthX    LengthY    LengthZ
// ---------- ---------- ---------- ---------- ---------- ---------- ----------
// PWL0048F         3.66       1.33      16.35      11.88      14.42      16.59
// PWL0048B         3.74       1.15      14.97      11.24      13.65      19.25
// PWL0047F        -7.09      -4.89      13.03       8.10      10.51      11.28
// PWL0047B        -5.85      -4.05      12.03       9.54      11.25      13.35
// PWL0046F        -7.30       2.27      21.53      12.99      13.26      16.85
// PWL0046B        -7.40       2.44      21.69      12.32      11.88      16.58
// PWL0045F         1.27       5.05      23.09      12.49      10.62      12.41
// PWL0045B         1.37       4.73      22.03      10.25       9.92      14.26
// PWL0044F         2.63       8.51      24.22       8.13       7.12      14.66
// PWL0044B         2.20       7.08      23.13       8.72       7.80      16.46
// PWL0043F        -8.04       9.46      22.42       9.50       7.40       8.99
// PWL0043B        -7.46       8.53      22.50      10.36       9.31       8.85
// PWL0042F        -8.94       3.95      23.36       9.39       6.21       6.62
// PWL0042B        -7.75       3.99      22.39      10.91       4.00       8.60
// PWL0041F        -5.49      -1.63      26.82      15.49       9.99      13.04
// PWL0041B        -5.85      -1.26      25.73      14.51      10.40      15.28
// PWL0040F        -8.22       4.23      31.13      12.77      10.99      16.50
// PWL0040B        -8.11       4.43      30.02      11.51       9.09      18.34
// PWL0039F        -8.54       8.01      28.96       9.89       7.31      17.26
// PWL0039B        -7.80       7.76      29.20      10.90       6.44      16.72
// PWL0038F        -2.72      -1.15      30.78       9.11      10.23      15.56
// PWL0038B        -3.05      -0.43      29.71       8.13      10.09      17.72
// PWL0037F        -4.22       5.29      32.84       7.83       8.18      11.72
// PWL0037B        -3.87       4.65      19.34       7.34       8.47      38.67
// PWL0035F         7.72      -6.28      12.07       9.69       8.18      10.15
// PWL0035B         6.32      -5.69      11.26      10.86       9.37      11.85
// PWL0034F         2.09      -7.56       9.91       2.63       7.19       6.57
// PWL0034B         1.55      -5.97       9.23       1.27       9.85       7.75
// PWL0033F        -1.06     -10.79      24.70      10.54      10.38      10.82
// PWL0033B        -1.51      -9.60      24.31       9.26      12.10      11.62
// PWL0032F         6.43      -6.80      29.17       6.95       6.57       8.86
// PWL0032B         4.57      -4.77      16.70       9.18       9.61      33.41
// PWL0030F        -6.50       5.11      22.92      11.13       6.50      16.70
// PWL0030B        -6.30       3.80      21.82      10.49       8.94      18.56
// PWL0029F        -9.53       0.84      20.72       8.53      15.10      12.29
// PWL0029B        -8.23       1.24      19.74      11.02      14.36      14.39
// PWL0028F        -0.80      -8.93      17.60       9.83      11.22       8.81
// PWL0028B        -0.74      -7.47      17.17       9.32      13.74       9.29
// PWL0027F        -4.19      -2.77      36.30       7.40       7.08       4.28
// PWL0027B        -4.15      -2.38      36.50       5.37       6.93       3.91
// PWL0026F        -5.97       3.61      36.78       5.18       5.60       8.60
// PWL0026B        -5.61       3.71      37.14       3.68       5.31       7.94
// PWL0025F        -3.79      -0.47      37.80       3.77       5.39       6.58
// PWL0025B        -4.45      -0.70      37.75       2.99       4.24       6.40
// PWL0024F        -7.24       1.09      37.34       2.93       2.97       7.30
// PWL0024B        -3.92       0.44      20.50       7.66       2.57      41.00
// PWL0023F        -6.11       6.37       9.28      10.90       8.34      12.14
// PWL0023B        -5.20       5.84       9.52      11.76       9.38      11.50
// PWL0022F         0.92      -6.12      16.92       6.97      12.23      18.17
// PWL0022B         0.77      -5.07      15.59       4.83      12.64      20.45
// PWL0021F         5.57      -1.45      14.69      13.02      12.76      19.53
// PWL0021B         5.81      -1.25      14.84      12.00      10.84      19.29
// PWL0020F         8.03       3.47      16.56       9.52       9.81      10.77
// PWL0020B         6.73       3.51      15.44      12.17       8.54      12.92
// PWL0019F        -1.75       7.84      13.10       4.37       6.37       5.27
// PWL0019B        -1.06       6.15      12.37       3.55       8.68       6.77
// PWL0018F         2.82      10.07      12.99      12.41      10.50       5.21
// PWL0018B         3.33       8.53      12.30      11.37      13.44       6.62
// PWL0017F         3.49       5.62      20.79      15.24       7.61      13.41
// PWL0017B         3.98       5.35      19.85      14.30       6.24      15.33
// PWL0016F        -2.76       1.03      21.57      13.12      16.12      15.64
// PWL0016B        -3.03       0.99      20.75      12.66      15.42      17.12
// PWL0015F         1.49      -3.91      21.27      12.92      12.60      13.19
// PWL0015B         1.70      -3.62      20.00      11.29      11.86      15.58
// PWL0014F         7.18       1.28      32.26       9.08      11.46      16.89
// PWL0014B         6.21       1.25      31.19      10.32      10.49      18.82
// PWL0013F         5.21       7.86      26.20       7.39       7.34       6.43
// PWL0013B         4.73       7.46      25.56       7.38       6.75       7.57
// PWL0012F        -3.20       5.16      31.45       8.21      12.29      15.17
// PWL0012B        -2.71       5.26      30.42       7.60      10.45      17.28
// PWL0011F         7.78       2.86      35.34       9.66      12.94      12.24
// PWL0011B         6.66       2.48      34.37      11.31      11.95      13.89
// PWL0010F         1.86      -1.36      35.39       8.35      11.00      12.39
// PWL0010B         1.98      -0.76      34.46       6.65      11.23      14.07
// PWL0009F         4.80       8.22      31.04       4.90       5.56       3.62
// PWL0009B         4.00       7.38      30.15       6.00       5.12       5.45
// PWL0008F        -0.63      11.11      32.09       4.21       8.36       6.14
// PWL0008B        -0.33       9.82      31.30       2.76      10.00       7.76
// PWL0007F        -3.96       9.53      37.78       7.57      10.97       6.92
// PWL0007B        -3.22       9.99      37.12       8.85       9.49       8.10
// PWL0006F         1.77      10.49      37.19      11.46       5.68       5.50
// PWL0006B         2.09       9.03      36.50      10.52       7.08       6.87
// PWL0005F         3.21      -0.07      37.44       9.08       7.80       5.74
// PWL0005B         3.37       0.87      36.70       7.52       9.30       7.27
// PWL0004F         1.11       6.51      37.06       1.99       0.85       0.56
// PWL0004B         1.21       6.16      37.00       0.38       0.50       0.62
// PWL0003F         1.79       5.25      36.98       2.19       0.90       0.69
// PWL0003B         1.53       5.74      37.03       0.36       0.42       0.68
// PWL0002F         0.77       6.38      37.02       1.25       1.57       0.52
// PWL0002B         1.10       5.98      37.01       0.58       0.15       0.63
// PWL0001F         1.45       6.55      38.33       2.69       2.55       4.99
// PWL0001B         0.71       3.51      20.42       1.71       6.95      40.85



#declare busch4 = union {

/* Object 'PWL0001B' */
union {
	smooth_triangle { <0.5080, 0.4073, 1.8288>, <-1.000, -0.022, 0.016>, <0.5723, 0.3910, 0.0000>, <-0.994, -0.107, -0.034>, <0.5570, 0.5328, 0.0000>, <-0.977, -0.212, -0.029> }
	smooth_triangle { <0.5080, 0.4073, 1.8288>, <-1.000, -0.022, 0.016>, <0.5570, 0.5328, 0.0000>, <-0.977, -0.212, -0.029>, <0.5103, 0.5176, 1.8288>, <-0.918, -0.389, 0.072> }
	smooth_triangle { <0.5103, 0.5176, 1.8288>, <-0.918, -0.389, 0.072>, <0.5570, 0.5328, 0.0000>, <-0.977, -0.212, -0.029>, <0.4804, 0.6550, 0.0000>, <-0.718, -0.695, -0.036> }
	smooth_triangle { <0.5103, 0.5176, 1.8288>, <-0.918, -0.389, 0.072>, <0.4804, 0.6550, 0.0000>, <-0.718, -0.695, -0.036>, <0.4295, 0.6023, 1.8288>, <-0.674, -0.733, 0.093> }
	smooth_triangle { <0.4295, 0.6023, 1.8288>, <-0.674, -0.733, 0.093>, <0.4804, 0.6550, 0.0000>, <-0.718, -0.695, -0.036>, <0.3607, 0.7342, 0.0000>, <-0.437, -0.899, -0.038> }
	smooth_triangle { <0.4295, 0.6023, 1.8288>, <-0.674, -0.733, 0.093>, <0.3607, 0.7342, 0.0000>, <-0.437, -0.899, -0.038>, <0.3430, 0.6693, 1.8288>, <-0.385, -0.917, 0.102> }
	smooth_triangle { <0.3430, 0.6693, 1.8288>, <-0.385, -0.917, 0.102>, <0.3607, 0.7342, 0.0000>, <-0.437, -0.899, -0.038>, <0.2226, 0.7493, 0.0000>, <-0.045, -0.998, -0.032> }
	smooth_triangle { <0.3430, 0.6693, 1.8288>, <-0.385, -0.917, 0.102>, <0.2226, 0.7493, 0.0000>, <-0.045, -0.998, -0.032>, <0.2115, 0.6950, 1.8288>, <0.001, -0.996, 0.094> }
	smooth_triangle { <0.2115, 0.6950, 1.8288>, <0.001, -0.996, 0.094>, <0.2226, 0.7493, 0.0000>, <-0.045, -0.998, -0.032>, <0.0825, 0.7256, 0.0000>, <0.329, -0.944, -0.033> }
	smooth_triangle { <0.2115, 0.6950, 1.8288>, <0.001, -0.996, 0.094>, <0.0825, 0.7256, 0.0000>, <0.329, -0.944, -0.033>, <0.1127, 0.6675, 1.8288>, <0.357, -0.932, 0.067> }
	smooth_triangle { <0.1127, 0.6675, 1.8288>, <0.357, -0.932, 0.067>, <0.0825, 0.7256, 0.0000>, <0.329, -0.944, -0.033>, <-0.0319, 0.6527, 0.0000>, <0.596, -0.802, -0.028> }
	smooth_triangle { <0.1127, 0.6675, 1.8288>, <0.357, -0.932, 0.067>, <-0.0319, 0.6527, 0.0000>, <0.596, -0.802, -0.028>, <-0.0031, 0.6205, 1.8288>, <0.683, -0.730, 0.026> }
	smooth_triangle { <-0.0031, 0.6205, 1.8288>, <0.683, -0.730, 0.026>, <-0.0319, 0.6527, 0.0000>, <0.596, -0.802, -0.028>, <-0.1139, 0.5336, 0.0000>, <0.895, -0.445, -0.025> }
	smooth_triangle { <-0.0031, 0.6205, 1.8288>, <0.683, -0.730, 0.026>, <-0.1139, 0.5336, 0.0000>, <0.895, -0.445, -0.025>, <-0.0748, 0.5058, 1.8288>, <0.937, -0.349, -0.027> }
	smooth_triangle { <-0.0748, 0.5058, 1.8288>, <0.937, -0.349, -0.027>, <-0.1139, 0.5336, 0.0000>, <0.895, -0.445, -0.025>, <-0.1449, 0.3953, 0.0000>, <0.999, -0.002, -0.033> }
	smooth_triangle { <-0.0748, 0.5058, 1.8288>, <0.937, -0.349, -0.027>, <-0.1449, 0.3953, 0.0000>, <0.999, -0.002, -0.033>, <-0.0774, 0.4069, 1.8288>, <0.997, 0.023, -0.071> }
	smooth_triangle { <-0.0774, 0.4069, 1.8288>, <0.997, 0.023, -0.071>, <-0.1449, 0.3953, 0.0000>, <0.999, -0.002, -0.033>, <-0.1091, 0.2499, 0.0000>, <0.951, 0.308, -0.033> }
	smooth_triangle { <-0.0774, 0.4069, 1.8288>, <0.997, 0.023, -0.071>, <-0.1091, 0.2499, 0.0000>, <0.951, 0.308, -0.033>, <-0.0618, 0.2847, 1.8288>, <0.908, 0.402, -0.116> }
	smooth_triangle { <-0.0618, 0.2847, 1.8288>, <0.908, 0.402, -0.116>, <-0.1091, 0.2499, 0.0000>, <0.951, 0.308, -0.033>, <-0.0358, 0.1365, 0.0000>, <0.737, 0.675, -0.035> }
	smooth_triangle { <-0.0618, 0.2847, 1.8288>, <0.908, 0.402, -0.116>, <-0.0358, 0.1365, 0.0000>, <0.737, 0.675, -0.035>, <0.0087, 0.1860, 1.8288>, <0.706, 0.695, -0.135> }
	smooth_triangle { <0.0087, 0.1860, 1.8288>, <0.706, 0.695, -0.135>, <-0.0358, 0.1365, 0.0000>, <0.737, 0.675, -0.035>, <0.0802, 0.0672, 0.0000>, <0.458, 0.889, -0.031> }
	smooth_triangle { <0.0087, 0.1860, 1.8288>, <0.706, 0.695, -0.135>, <0.0802, 0.0672, 0.0000>, <0.458, 0.889, -0.031>, <0.1093, 0.1098, 1.8288>, <0.355, 0.924, -0.143> }
	smooth_triangle { <0.1093, 0.1098, 1.8288>, <0.355, 0.924, -0.143>, <0.0802, 0.0672, 0.0000>, <0.458, 0.889, -0.031>, <0.2224, 0.0327, 0.0000>, <0.032, 0.999, -0.035> }
	smooth_triangle { <0.1093, 0.1098, 1.8288>, <0.355, 0.924, -0.143>, <0.2224, 0.0327, 0.0000>, <0.032, 0.999, -0.035>, <0.2172, 0.1030, 1.8288>, <-0.051, 0.990, -0.133> }
	smooth_triangle { <0.2172, 0.1030, 1.8288>, <-0.051, 0.990, -0.133>, <0.2224, 0.0327, 0.0000>, <0.032, 0.999, -0.035>, <0.3617, 0.0618, 0.0000>, <-0.332, 0.942, -0.038> }
	smooth_triangle { <0.2172, 0.1030, 1.8288>, <-0.051, 0.990, -0.133>, <0.3617, 0.0618, 0.0000>, <-0.332, 0.942, -0.038>, <0.3253, 0.1219, 1.8288>, <-0.382, 0.917, -0.111> }
	smooth_triangle { <0.3253, 0.1219, 1.8288>, <-0.382, 0.917, -0.111>, <0.3617, 0.0618, 0.0000>, <-0.332, 0.942, -0.038>, <0.4735, 0.1451, 0.0000>, <-0.694, 0.719, -0.040> }
	smooth_triangle { <0.3253, 0.1219, 1.8288>, <-0.382, 0.917, -0.111>, <0.4735, 0.1451, 0.0000>, <-0.694, 0.719, -0.040>, <0.4168, 0.1916, 1.8288>, <-0.719, 0.692, -0.061> }
	smooth_triangle { <0.4168, 0.1916, 1.8288>, <-0.719, 0.692, -0.061>, <0.4735, 0.1451, 0.0000>, <-0.694, 0.719, -0.040>, <0.5457, 0.2608, 0.0000>, <-0.884, 0.467, -0.034> }
	smooth_triangle { <0.4168, 0.1916, 1.8288>, <-0.719, 0.692, -0.061>, <0.5457, 0.2608, 0.0000>, <-0.884, 0.467, -0.034>, <0.4930, 0.2826, 1.8288>, <-0.915, 0.403, -0.022> }
	smooth_triangle { <0.4930, 0.2826, 1.8288>, <-0.915, 0.403, -0.022>, <0.5457, 0.2608, 0.0000>, <-0.884, 0.467, -0.034>, <0.5723, 0.3910, 0.0000>, <-0.987, 0.160, -0.033> }
	smooth_triangle { <0.4930, 0.2826, 1.8288>, <-0.915, 0.403, -0.022>, <0.5723, 0.3910, 0.0000>, <-0.987, 0.160, -0.033>, <0.5080, 0.4073, 1.8288>, <-0.983, 0.183, 0.028> }
	smooth_triangle { <0.9166, 1.2051, 5.4119>, <-0.966, -0.230, 0.117>, <0.5080, 0.4073, 1.8288>, <-1.000, -0.022, 0.016>, <0.5103, 0.5176, 1.8288>, <-0.918, -0.389, 0.072> }
	smooth_triangle { <0.9166, 1.2051, 5.4119>, <-0.966, -0.230, 0.117>, <0.5103, 0.5176, 1.8288>, <-0.918, -0.389, 0.072>, <0.8814, 1.2986, 5.4119>, <-0.866, -0.479, 0.141> }
	smooth_triangle { <0.8814, 1.2986, 5.4119>, <-0.866, -0.479, 0.141>, <0.5103, 0.5176, 1.8288>, <-0.918, -0.389, 0.072>, <0.4295, 0.6023, 1.8288>, <-0.674, -0.733, 0.093> }
	smooth_triangle { <0.8814, 1.2986, 5.4119>, <-0.866, -0.479, 0.141>, <0.4295, 0.6023, 1.8288>, <-0.674, -0.733, 0.093>, <0.8182, 1.3867, 5.4119>, <-0.692, -0.701, 0.175> }
	smooth_triangle { <0.8182, 1.3867, 5.4119>, <-0.692, -0.701, 0.175>, <0.4295, 0.6023, 1.8288>, <-0.674, -0.733, 0.093>, <0.3430, 0.6693, 1.8288>, <-0.385, -0.917, 0.102> }
	smooth_triangle { <0.8182, 1.3867, 5.4119>, <-0.692, -0.701, 0.175>, <0.3430, 0.6693, 1.8288>, <-0.385, -0.917, 0.102>, <0.7495, 1.4316, 5.4119>, <-0.441, -0.877, 0.193> }
	smooth_triangle { <0.7495, 1.4316, 5.4119>, <-0.441, -0.877, 0.193>, <0.3430, 0.6693, 1.8288>, <-0.385, -0.917, 0.102>, <0.2115, 0.6950, 1.8288>, <0.001, -0.996, 0.094> }
	smooth_triangle { <0.7495, 1.4316, 5.4119>, <-0.441, -0.877, 0.193>, <0.2115, 0.6950, 1.8288>, <0.001, -0.996, 0.094>, <0.6409, 1.4691, 5.4119>, <0.017, -0.983, 0.184> }
	smooth_triangle { <0.6409, 1.4691, 5.4119>, <0.017, -0.983, 0.184>, <0.2115, 0.6950, 1.8288>, <0.001, -0.996, 0.094>, <0.1127, 0.6675, 1.8288>, <0.357, -0.932, 0.067> }
	smooth_triangle { <0.6409, 1.4691, 5.4119>, <0.017, -0.983, 0.184>, <0.1127, 0.6675, 1.8288>, <0.357, -0.932, 0.067>, <0.5212, 1.4303, 5.4119>, <0.431, -0.892, 0.139> }
	smooth_triangle { <0.5212, 1.4303, 5.4119>, <0.431, -0.892, 0.139>, <0.1127, 0.6675, 1.8288>, <0.357, -0.932, 0.067>, <-0.0031, 0.6205, 1.8288>, <0.683, -0.730, 0.026> }
	smooth_triangle { <0.5212, 1.4303, 5.4119>, <0.431, -0.892, 0.139>, <-0.0031, 0.6205, 1.8288>, <0.683, -0.730, 0.026>, <0.4591, 1.3741, 5.4119>, <0.717, -0.692, 0.078> }
	smooth_triangle { <0.4591, 1.3741, 5.4119>, <0.717, -0.692, 0.078>, <-0.0031, 0.6205, 1.8288>, <0.683, -0.730, 0.026>, <-0.0748, 0.5058, 1.8288>, <0.937, -0.349, -0.027> }
	smooth_triangle { <0.4591, 1.3741, 5.4119>, <0.717, -0.692, 0.078>, <-0.0748, 0.5058, 1.8288>, <0.937, -0.349, -0.027>, <0.3912, 1.3010, 5.4119>, <0.893, -0.449, 0.018> }
	smooth_triangle { <0.3912, 1.3010, 5.4119>, <0.893, -0.449, 0.018>, <-0.0748, 0.5058, 1.8288>, <0.937, -0.349, -0.027>, <-0.0774, 0.4069, 1.8288>, <0.997, 0.023, -0.071> }
	smooth_triangle { <0.3912, 1.3010, 5.4119>, <0.893, -0.449, 0.018>, <-0.0774, 0.4069, 1.8288>, <0.997, 0.023, -0.071>, <0.3541, 1.1838, 5.4119>, <0.996, 0.027, -0.081> }
	smooth_triangle { <0.3541, 1.1838, 5.4119>, <0.996, 0.027, -0.081>, <-0.0774, 0.4069, 1.8288>, <0.997, 0.023, -0.071>, <-0.0618, 0.2847, 1.8288>, <0.908, 0.402, -0.116> }
	smooth_triangle { <0.3541, 1.1838, 5.4119>, <0.996, 0.027, -0.081>, <-0.0618, 0.2847, 1.8288>, <0.908, 0.402, -0.116>, <0.4004, 1.0838, 5.4119>, <0.896, 0.418, -0.150> }
	smooth_triangle { <0.4004, 1.0838, 5.4119>, <0.896, 0.418, -0.150>, <-0.0618, 0.2847, 1.8288>, <0.908, 0.402, -0.116>, <0.0087, 0.1860, 1.8288>, <0.706, 0.695, -0.135> }
	smooth_triangle { <0.4004, 1.0838, 5.4119>, <0.896, 0.418, -0.150>, <0.0087, 0.1860, 1.8288>, <0.706, 0.695, -0.135>, <0.4559, 0.9923, 5.4119>, <0.689, 0.699, -0.191> }
	smooth_triangle { <0.4559, 0.9923, 5.4119>, <0.689, 0.699, -0.191>, <0.0087, 0.1860, 1.8288>, <0.706, 0.695, -0.135>, <0.1093, 0.1098, 1.8288>, <0.355, 0.924, -0.143> }
	smooth_triangle { <0.4559, 0.9923, 5.4119>, <0.689, 0.699, -0.191>, <0.1093, 0.1098, 1.8288>, <0.355, 0.924, -0.143>, <0.5295, 0.9475, 5.4119>, <0.326, 0.922, -0.210> }
	smooth_triangle { <0.5295, 0.9475, 5.4119>, <0.326, 0.922, -0.210>, <0.1093, 0.1098, 1.8288>, <0.355, 0.924, -0.143>, <0.2172, 0.1030, 1.8288>, <-0.051, 0.990, -0.133> }
	smooth_triangle { <0.5295, 0.9475, 5.4119>, <0.326, 0.922, -0.210>, <0.2172, 0.1030, 1.8288>, <-0.051, 0.990, -0.133>, <0.6375, 0.9340, 5.4119>, <0.008, 0.980, -0.201> }
	smooth_triangle { <0.6375, 0.9340, 5.4119>, <0.008, 0.980, -0.201>, <0.2172, 0.1030, 1.8288>, <-0.051, 0.990, -0.133>, <0.3253, 0.1219, 1.8288>, <-0.382, 0.917, -0.111> }
	smooth_triangle { <0.6375, 0.9340, 5.4119>, <0.008, 0.980, -0.201>, <0.3253, 0.1219, 1.8288>, <-0.382, 0.917, -0.111>, <0.7519, 0.9417, 5.4119>, <-0.399, 0.903, -0.157> }
	smooth_triangle { <0.7519, 0.9417, 5.4119>, <-0.399, 0.903, -0.157>, <0.3253, 0.1219, 1.8288>, <-0.382, 0.917, -0.111>, <0.4168, 0.1916, 1.8288>, <-0.719, 0.692, -0.061> }
	smooth_triangle { <0.7519, 0.9417, 5.4119>, <-0.399, 0.903, -0.157>, <0.4168, 0.1916, 1.8288>, <-0.719, 0.692, -0.061>, <0.8220, 1.0090, 5.4119>, <-0.693, 0.714, -0.098> }
	smooth_triangle { <0.8220, 1.0090, 5.4119>, <-0.693, 0.714, -0.098>, <0.4168, 0.1916, 1.8288>, <-0.719, 0.692, -0.061>, <0.4930, 0.2826, 1.8288>, <-0.915, 0.403, -0.022> }
	smooth_triangle { <0.8220, 1.0090, 5.4119>, <-0.693, 0.714, -0.098>, <0.4930, 0.2826, 1.8288>, <-0.915, 0.403, -0.022>, <0.8762, 1.0797, 5.4119>, <-0.902, 0.430, -0.028> }
	smooth_triangle { <0.8762, 1.0797, 5.4119>, <-0.902, 0.430, -0.028>, <0.4930, 0.2826, 1.8288>, <-0.915, 0.403, -0.022>, <0.5080, 0.4073, 1.8288>, <-0.983, 0.183, 0.028> }
	smooth_triangle { <0.8762, 1.0797, 5.4119>, <-0.902, 0.430, -0.028>, <0.5080, 0.4073, 1.8288>, <-0.983, 0.183, 0.028>, <0.9166, 1.2051, 5.4119>, <-0.962, 0.272, -0.010> }
	smooth_triangle { <0.9420, 1.8156, 9.0138>, <-0.945, -0.321, 0.065>, <0.9166, 1.2051, 5.4119>, <-0.966, -0.230, 0.117>, <0.8814, 1.2986, 5.4119>, <-0.866, -0.479, 0.141> }
	smooth_triangle { <0.9420, 1.8156, 9.0138>, <-0.945, -0.321, 0.065>, <0.8814, 1.2986, 5.4119>, <-0.866, -0.479, 0.141>, <0.9112, 1.9115, 9.0138>, <-0.906, -0.414, 0.083> }
	smooth_triangle { <0.9112, 1.9115, 9.0138>, <-0.906, -0.414, 0.083>, <0.8814, 1.2986, 5.4119>, <-0.866, -0.479, 0.141>, <0.8182, 1.3867, 5.4119>, <-0.692, -0.701, 0.175> }
	smooth_triangle { <0.9112, 1.9115, 9.0138>, <-0.906, -0.414, 0.083>, <0.8182, 1.3867, 5.4119>, <-0.692, -0.701, 0.175>, <0.8504, 1.9972, 9.0138>, <-0.732, -0.670, 0.120> }
	smooth_triangle { <0.8504, 1.9972, 9.0138>, <-0.732, -0.670, 0.120>, <0.8182, 1.3867, 5.4119>, <-0.692, -0.701, 0.175>, <0.7495, 1.4316, 5.4119>, <-0.441, -0.877, 0.193> }
	smooth_triangle { <0.8504, 1.9972, 9.0138>, <-0.732, -0.670, 0.120>, <0.7495, 1.4316, 5.4119>, <-0.441, -0.877, 0.193>, <0.7872, 2.0589, 9.0138>, <-0.441, -0.885, 0.146> }
	smooth_triangle { <0.7872, 2.0589, 9.0138>, <-0.441, -0.885, 0.146>, <0.7495, 1.4316, 5.4119>, <-0.441, -0.877, 0.193>, <0.6409, 1.4691, 5.4119>, <0.017, -0.983, 0.184> }
	smooth_triangle { <0.7872, 2.0589, 9.0138>, <-0.441, -0.885, 0.146>, <0.6409, 1.4691, 5.4119>, <0.017, -0.983, 0.184>, <0.6785, 2.0738, 9.0138>, <0.036, -0.988, 0.150> }
	smooth_triangle { <0.6785, 2.0738, 9.0138>, <0.036, -0.988, 0.150>, <0.6409, 1.4691, 5.4119>, <0.017, -0.983, 0.184>, <0.5212, 1.4303, 5.4119>, <0.431, -0.892, 0.139> }
	smooth_triangle { <0.6785, 2.0738, 9.0138>, <0.036, -0.988, 0.150>, <0.5212, 1.4303, 5.4119>, <0.431, -0.892, 0.139>, <0.6034, 2.0574, 9.0138>, <0.448, -0.886, 0.122> }
	smooth_triangle { <0.6034, 2.0574, 9.0138>, <0.448, -0.886, 0.122>, <0.5212, 1.4303, 5.4119>, <0.431, -0.892, 0.139>, <0.4591, 1.3741, 5.4119>, <0.717, -0.692, 0.078> }
	smooth_triangle { <0.6034, 2.0574, 9.0138>, <0.448, -0.886, 0.122>, <0.4591, 1.3741, 5.4119>, <0.717, -0.692, 0.078>, <0.5185, 1.9875, 9.0138>, <0.699, -0.710, 0.087> }
	smooth_triangle { <0.5185, 1.9875, 9.0138>, <0.699, -0.710, 0.087>, <0.4591, 1.3741, 5.4119>, <0.717, -0.692, 0.078>, <0.3912, 1.3010, 5.4119>, <0.893, -0.449, 0.018> }
	smooth_triangle { <0.5185, 1.9875, 9.0138>, <0.699, -0.710, 0.087>, <0.3912, 1.3010, 5.4119>, <0.893, -0.449, 0.018>, <0.4709, 1.9251, 9.0138>, <0.896, -0.443, 0.038> }
	smooth_triangle { <0.4709, 1.9251, 9.0138>, <0.896, -0.443, 0.038>, <0.3912, 1.3010, 5.4119>, <0.893, -0.449, 0.018>, <0.3541, 1.1838, 5.4119>, <0.996, 0.027, -0.081> }
	smooth_triangle { <0.4709, 1.9251, 9.0138>, <0.896, -0.443, 0.038>, <0.3541, 1.1838, 5.4119>, <0.996, 0.027, -0.081>, <0.4515, 1.8288, 9.0138>, <0.999, -0.002, -0.035> }
	smooth_triangle { <0.4515, 1.8288, 9.0138>, <0.999, -0.002, -0.035>, <0.3541, 1.1838, 5.4119>, <0.996, 0.027, -0.081>, <0.4004, 1.0838, 5.4119>, <0.896, 0.418, -0.150> }
	smooth_triangle { <0.4515, 1.8288, 9.0138>, <0.999, -0.002, -0.035>, <0.4004, 1.0838, 5.4119>, <0.896, 0.418, -0.150>, <0.4552, 1.7339, 9.0138>, <0.931, 0.355, -0.089> }
	smooth_triangle { <0.4552, 1.7339, 9.0138>, <0.931, 0.355, -0.089>, <0.4004, 1.0838, 5.4119>, <0.896, 0.418, -0.150>, <0.4559, 0.9923, 5.4119>, <0.689, 0.699, -0.191> }
	smooth_triangle { <0.4552, 1.7339, 9.0138>, <0.931, 0.355, -0.089>, <0.4559, 0.9923, 5.4119>, <0.689, 0.699, -0.191>, <0.5160, 1.6618, 9.0138>, <0.661, 0.736, -0.145> }
	smooth_triangle { <0.5160, 1.6618, 9.0138>, <0.661, 0.736, -0.145>, <0.4559, 0.9923, 5.4119>, <0.689, 0.699, -0.191>, <0.5295, 0.9475, 5.4119>, <0.326, 0.922, -0.210> }
	smooth_triangle { <0.5160, 1.6618, 9.0138>, <0.661, 0.736, -0.145>, <0.5295, 0.9475, 5.4119>, <0.326, 0.922, -0.210>, <0.5929, 1.6059, 9.0138>, <0.373, 0.913, -0.165> }
	smooth_triangle { <0.5929, 1.6059, 9.0138>, <0.373, 0.913, -0.165>, <0.5295, 0.9475, 5.4119>, <0.326, 0.922, -0.210>, <0.6375, 0.9340, 5.4119>, <0.008, 0.980, -0.201> }
	smooth_triangle { <0.5929, 1.6059, 9.0138>, <0.373, 0.913, -0.165>, <0.6375, 0.9340, 5.4119>, <0.008, 0.980, -0.201>, <0.6822, 1.5961, 9.0138>, <-0.003, 0.986, -0.165> }
	smooth_triangle { <0.6822, 1.5961, 9.0138>, <-0.003, 0.986, -0.165>, <0.6375, 0.9340, 5.4119>, <0.008, 0.980, -0.201>, <0.7519, 0.9417, 5.4119>, <-0.399, 0.903, -0.157> }
	smooth_triangle { <0.6822, 1.5961, 9.0138>, <-0.003, 0.986, -0.165>, <0.7519, 0.9417, 5.4119>, <-0.399, 0.903, -0.157>, <0.7850, 1.6138, 9.0138>, <-0.315, 0.938, -0.148> }
	smooth_triangle { <0.7850, 1.6138, 9.0138>, <-0.315, 0.938, -0.148>, <0.7519, 0.9417, 5.4119>, <-0.399, 0.903, -0.157>, <0.8220, 1.0090, 5.4119>, <-0.693, 0.714, -0.098> }
	smooth_triangle { <0.7850, 1.6138, 9.0138>, <-0.315, 0.938, -0.148>, <0.8220, 1.0090, 5.4119>, <-0.693, 0.714, -0.098>, <0.8657, 1.6455, 9.0138>, <-0.653, 0.750, -0.108> }
	smooth_triangle { <0.8657, 1.6455, 9.0138>, <-0.653, 0.750, -0.108>, <0.8220, 1.0090, 5.4119>, <-0.693, 0.714, -0.098>, <0.8762, 1.0797, 5.4119>, <-0.902, 0.430, -0.028> }
	smooth_triangle { <0.8657, 1.6455, 9.0138>, <-0.653, 0.750, -0.108>, <0.8762, 1.0797, 5.4119>, <-0.902, 0.430, -0.028>, <0.9240, 1.7277, 9.0138>, <-0.908, 0.416, -0.050> }
	smooth_triangle { <0.9240, 1.7277, 9.0138>, <-0.908, 0.416, -0.050>, <0.8762, 1.0797, 5.4119>, <-0.902, 0.430, -0.028>, <0.9166, 1.2051, 5.4119>, <-0.962, 0.272, -0.010> }
	smooth_triangle { <0.9240, 1.7277, 9.0138>, <-0.908, 0.416, -0.050>, <0.9166, 1.2051, 5.4119>, <-0.962, 0.272, -0.010>, <0.9420, 1.8156, 9.0138>, <-0.983, 0.185, -0.009> }
	smooth_triangle { <1.0234, 2.2816, 12.2304>, <-0.985, -0.164, 0.058>, <0.9420, 1.8156, 9.0138>, <-0.945, -0.321, 0.065>, <0.9112, 1.9115, 9.0138>, <-0.906, -0.414, 0.083> }
	smooth_triangle { <1.0234, 2.2816, 12.2304>, <-0.985, -0.164, 0.058>, <0.9112, 1.9115, 9.0138>, <-0.906, -0.414, 0.083>, <1.0162, 2.3593, 12.2304>, <-0.924, -0.369, 0.096> }
	smooth_triangle { <1.0162, 2.3593, 12.2304>, <-0.924, -0.369, 0.096>, <0.9112, 1.9115, 9.0138>, <-0.906, -0.414, 0.083>, <0.8504, 1.9972, 9.0138>, <-0.732, -0.670, 0.120> }
	smooth_triangle { <1.0162, 2.3593, 12.2304>, <-0.924, -0.369, 0.096>, <0.8504, 1.9972, 9.0138>, <-0.732, -0.670, 0.120>, <0.9600, 2.4362, 12.2304>, <-0.716, -0.683, 0.144> }
	smooth_triangle { <0.9600, 2.4362, 12.2304>, <-0.716, -0.683, 0.144>, <0.8504, 1.9972, 9.0138>, <-0.732, -0.670, 0.120>, <0.7872, 2.0589, 9.0138>, <-0.441, -0.885, 0.146> }
	smooth_triangle { <0.9600, 2.4362, 12.2304>, <-0.716, -0.683, 0.144>, <0.7872, 2.0589, 9.0138>, <-0.441, -0.885, 0.146>, <0.8882, 2.4873, 12.2304>, <-0.402, -0.900, 0.169> }
	smooth_triangle { <0.8882, 2.4873, 12.2304>, <-0.402, -0.900, 0.169>, <0.7872, 2.0589, 9.0138>, <-0.441, -0.885, 0.146>, <0.6785, 2.0738, 9.0138>, <0.036, -0.988, 0.150> }
	smooth_triangle { <0.8882, 2.4873, 12.2304>, <-0.402, -0.900, 0.169>, <0.6785, 2.0738, 9.0138>, <0.036, -0.988, 0.150>, <0.8133, 2.5064, 12.2304>, <0.008, -0.986, 0.168> }
	smooth_triangle { <0.8133, 2.5064, 12.2304>, <0.008, -0.986, 0.168>, <0.6785, 2.0738, 9.0138>, <0.036, -0.988, 0.150>, <0.6034, 2.0574, 9.0138>, <0.448, -0.886, 0.122> }
	smooth_triangle { <0.8133, 2.5064, 12.2304>, <0.008, -0.986, 0.168>, <0.6034, 2.0574, 9.0138>, <0.448, -0.886, 0.122>, <0.7384, 2.4864, 12.2304>, <0.444, -0.886, 0.132> }
	smooth_triangle { <0.7384, 2.4864, 12.2304>, <0.444, -0.886, 0.132>, <0.6034, 2.0574, 9.0138>, <0.448, -0.886, 0.122>, <0.5185, 1.9875, 9.0138>, <0.699, -0.710, 0.087> }
	smooth_triangle { <0.7384, 2.4864, 12.2304>, <0.444, -0.886, 0.132>, <0.5185, 1.9875, 9.0138>, <0.699, -0.710, 0.087>, <0.6686, 2.4361, 12.2304>, <0.656, -0.748, 0.100> }
	smooth_triangle { <0.6686, 2.4361, 12.2304>, <0.656, -0.748, 0.100>, <0.5185, 1.9875, 9.0138>, <0.699, -0.710, 0.087>, <0.4709, 1.9251, 9.0138>, <0.896, -0.443, 0.038> }
	smooth_triangle { <0.6686, 2.4361, 12.2304>, <0.656, -0.748, 0.100>, <0.4709, 1.9251, 9.0138>, <0.896, -0.443, 0.038>, <0.6081, 2.3711, 12.2304>, <0.910, -0.413, 0.030> }
	smooth_triangle { <0.6081, 2.3711, 12.2304>, <0.910, -0.413, 0.030>, <0.4709, 1.9251, 9.0138>, <0.896, -0.443, 0.038>, <0.4515, 1.8288, 9.0138>, <0.999, -0.002, -0.035> }
	smooth_triangle { <0.6081, 2.3711, 12.2304>, <0.910, -0.413, 0.030>, <0.4515, 1.8288, 9.0138>, <0.999, -0.002, -0.035>, <0.5992, 2.2931, 12.2304>, <0.999, 0.002, -0.050> }
	smooth_triangle { <0.5992, 2.2931, 12.2304>, <0.999, 0.002, -0.050>, <0.4515, 1.8288, 9.0138>, <0.999, -0.002, -0.035>, <0.4552, 1.7339, 9.0138>, <0.931, 0.355, -0.089> }
	smooth_triangle { <0.5992, 2.2931, 12.2304>, <0.999, 0.002, -0.050>, <0.4552, 1.7339, 9.0138>, <0.931, 0.355, -0.089>, <0.6158, 2.1954, 12.2304>, <0.892, 0.434, -0.123> }
	smooth_triangle { <0.6158, 2.1954, 12.2304>, <0.892, 0.434, -0.123>, <0.4552, 1.7339, 9.0138>, <0.931, 0.355, -0.089>, <0.5160, 1.6618, 9.0138>, <0.661, 0.736, -0.145> }
	smooth_triangle { <0.6158, 2.1954, 12.2304>, <0.892, 0.434, -0.123>, <0.5160, 1.6618, 9.0138>, <0.661, 0.736, -0.145>, <0.6662, 2.1388, 12.2304>, <0.714, 0.682, -0.158> }
	smooth_triangle { <0.6662, 2.1388, 12.2304>, <0.714, 0.682, -0.158>, <0.5160, 1.6618, 9.0138>, <0.661, 0.736, -0.145>, <0.5929, 1.6059, 9.0138>, <0.373, 0.913, -0.165> }
	smooth_triangle { <0.6662, 2.1388, 12.2304>, <0.714, 0.682, -0.158>, <0.5929, 1.6059, 9.0138>, <0.373, 0.913, -0.165>, <0.7256, 2.0864, 12.2304>, <0.374, 0.909, -0.185> }
	smooth_triangle { <0.7256, 2.0864, 12.2304>, <0.374, 0.909, -0.185>, <0.5929, 1.6059, 9.0138>, <0.373, 0.913, -0.165>, <0.6822, 1.5961, 9.0138>, <-0.003, 0.986, -0.165> }
	smooth_triangle { <0.7256, 2.0864, 12.2304>, <0.374, 0.909, -0.185>, <0.6822, 1.5961, 9.0138>, <-0.003, 0.986, -0.165>, <0.8073, 2.0724, 12.2304>, <0.042, 0.982, -0.183> }
	smooth_triangle { <0.8073, 2.0724, 12.2304>, <0.042, 0.982, -0.183>, <0.6822, 1.5961, 9.0138>, <-0.003, 0.986, -0.165>, <0.7850, 1.6138, 9.0138>, <-0.315, 0.938, -0.148> }
	smooth_triangle { <0.8073, 2.0724, 12.2304>, <0.042, 0.982, -0.183>, <0.7850, 1.6138, 9.0138>, <-0.315, 0.938, -0.148>, <0.8994, 2.0814, 12.2304>, <-0.372, 0.915, -0.156> }
	smooth_triangle { <0.8994, 2.0814, 12.2304>, <-0.372, 0.915, -0.156>, <0.7850, 1.6138, 9.0138>, <-0.315, 0.938, -0.148>, <0.8657, 1.6455, 9.0138>, <-0.653, 0.750, -0.108> }
	smooth_triangle { <0.8994, 2.0814, 12.2304>, <-0.372, 0.915, -0.156>, <0.8657, 1.6455, 9.0138>, <-0.653, 0.750, -0.108>, <0.9643, 2.1373, 12.2304>, <-0.714, 0.693, -0.106> }
	smooth_triangle { <0.9643, 2.1373, 12.2304>, <-0.714, 0.693, -0.106>, <0.8657, 1.6455, 9.0138>, <-0.653, 0.750, -0.108>, <0.9240, 1.7277, 9.0138>, <-0.908, 0.416, -0.050> }
	smooth_triangle { <0.9643, 2.1373, 12.2304>, <-0.714, 0.693, -0.106>, <0.9240, 1.7277, 9.0138>, <-0.908, 0.416, -0.050>, <1.0111, 2.2019, 12.2304>, <-0.919, 0.393, -0.043> }
	smooth_triangle { <1.0111, 2.2019, 12.2304>, <-0.919, 0.393, -0.043>, <0.9240, 1.7277, 9.0138>, <-0.908, 0.416, -0.050>, <0.9420, 1.8156, 9.0138>, <-0.983, 0.185, -0.009> }
	smooth_triangle { <1.0111, 2.2019, 12.2304>, <-0.919, 0.393, -0.043>, <0.9420, 1.8156, 9.0138>, <-0.983, 0.185, -0.009>, <1.0234, 2.2816, 12.2304>, <-0.990, 0.144, 0.008> }
	smooth_triangle { <1.1544, 2.9662, 15.4049>, <-0.981, -0.177, 0.075>, <1.0234, 2.2816, 12.2304>, <-0.985, -0.164, 0.058>, <1.0162, 2.3593, 12.2304>, <-0.924, -0.369, 0.096> }
	smooth_triangle { <1.1544, 2.9662, 15.4049>, <-0.981, -0.177, 0.075>, <1.0162, 2.3593, 12.2304>, <-0.924, -0.369, 0.096>, <1.1381, 3.0384, 15.4049>, <-0.908, -0.401, 0.117> }
	smooth_triangle { <1.1381, 3.0384, 15.4049>, <-0.908, -0.401, 0.117>, <1.0162, 2.3593, 12.2304>, <-0.924, -0.369, 0.096>, <0.9600, 2.4362, 12.2304>, <-0.716, -0.683, 0.144> }
	smooth_triangle { <1.1381, 3.0384, 15.4049>, <-0.908, -0.401, 0.117>, <0.9600, 2.4362, 12.2304>, <-0.716, -0.683, 0.144>, <1.0892, 3.1089, 15.4049>, <-0.719, -0.675, 0.165> }
	smooth_triangle { <1.0892, 3.1089, 15.4049>, <-0.719, -0.675, 0.165>, <0.9600, 2.4362, 12.2304>, <-0.716, -0.683, 0.144>, <0.8882, 2.4873, 12.2304>, <-0.402, -0.900, 0.169> }
	smooth_triangle { <1.0892, 3.1089, 15.4049>, <-0.719, -0.675, 0.165>, <0.8882, 2.4873, 12.2304>, <-0.402, -0.900, 0.169>, <1.0371, 3.1482, 15.4049>, <-0.384, -0.903, 0.193> }
	smooth_triangle { <1.0371, 3.1482, 15.4049>, <-0.384, -0.903, 0.193>, <0.8882, 2.4873, 12.2304>, <-0.402, -0.900, 0.169>, <0.8133, 2.5064, 12.2304>, <0.008, -0.986, 0.168> }
	smooth_triangle { <1.0371, 3.1482, 15.4049>, <-0.384, -0.903, 0.193>, <0.8133, 2.5064, 12.2304>, <0.008, -0.986, 0.168>, <0.9623, 3.1631, 15.4049>, <0.020, -0.982, 0.190> }
	smooth_triangle { <0.9623, 3.1631, 15.4049>, <0.020, -0.982, 0.190>, <0.8133, 2.5064, 12.2304>, <0.008, -0.986, 0.168>, <0.7384, 2.4864, 12.2304>, <0.444, -0.886, 0.132> }
	smooth_triangle { <0.9623, 3.1631, 15.4049>, <0.020, -0.982, 0.190>, <0.7384, 2.4864, 12.2304>, <0.444, -0.886, 0.132>, <0.8973, 3.1416, 15.4049>, <0.400, -0.903, 0.157> }
	smooth_triangle { <0.8973, 3.1416, 15.4049>, <0.400, -0.903, 0.157>, <0.7384, 2.4864, 12.2304>, <0.444, -0.886, 0.132>, <0.6686, 2.4361, 12.2304>, <0.656, -0.748, 0.100> }
	smooth_triangle { <0.8973, 3.1416, 15.4049>, <0.400, -0.903, 0.157>, <0.6686, 2.4361, 12.2304>, <0.656, -0.748, 0.100>, <0.8354, 3.1072, 15.4049>, <0.674, -0.730, 0.108> }
	smooth_triangle { <0.8354, 3.1072, 15.4049>, <0.674, -0.730, 0.108>, <0.6686, 2.4361, 12.2304>, <0.656, -0.748, 0.100>, <0.6081, 2.3711, 12.2304>, <0.910, -0.413, 0.030> }
	smooth_triangle { <0.8354, 3.1072, 15.4049>, <0.674, -0.730, 0.108>, <0.6081, 2.3711, 12.2304>, <0.910, -0.413, 0.030>, <0.7831, 3.0360, 15.4049>, <0.938, -0.346, 0.014> }
	smooth_triangle { <0.7831, 3.0360, 15.4049>, <0.938, -0.346, 0.014>, <0.6081, 2.3711, 12.2304>, <0.910, -0.413, 0.030>, <0.5992, 2.2931, 12.2304>, <0.999, 0.002, -0.050> }
	smooth_triangle { <0.7831, 3.0360, 15.4049>, <0.938, -0.346, 0.014>, <0.5992, 2.2931, 12.2304>, <0.999, 0.002, -0.050>, <0.7734, 2.9658, 15.4049>, <0.998, -0.006, -0.057> }
	smooth_triangle { <0.7734, 2.9658, 15.4049>, <0.998, -0.006, -0.057>, <0.5992, 2.2931, 12.2304>, <0.999, 0.002, -0.050>, <0.6158, 2.1954, 12.2304>, <0.892, 0.434, -0.123> }
	smooth_triangle { <0.7734, 2.9658, 15.4049>, <0.998, -0.006, -0.057>, <0.6158, 2.1954, 12.2304>, <0.892, 0.434, -0.123>, <0.7903, 2.8936, 15.4049>, <0.908, 0.396, -0.133> }
	smooth_triangle { <0.7903, 2.8936, 15.4049>, <0.908, 0.396, -0.133>, <0.6158, 2.1954, 12.2304>, <0.892, 0.434, -0.123>, <0.6662, 2.1388, 12.2304>, <0.714, 0.682, -0.158> }
	smooth_triangle { <0.7903, 2.8936, 15.4049>, <0.908, 0.396, -0.133>, <0.6662, 2.1388, 12.2304>, <0.714, 0.682, -0.158>, <0.8241, 2.8282, 15.4049>, <0.712, 0.678, -0.181> }
	smooth_triangle { <0.8241, 2.8282, 15.4049>, <0.712, 0.678, -0.181>, <0.6662, 2.1388, 12.2304>, <0.714, 0.682, -0.158>, <0.7256, 2.0864, 12.2304>, <0.374, 0.909, -0.185> }
	smooth_triangle { <0.8241, 2.8282, 15.4049>, <0.712, 0.678, -0.181>, <0.7256, 2.0864, 12.2304>, <0.374, 0.909, -0.185>, <0.8889, 2.7969, 15.4049>, <0.383, 0.900, -0.210> }
	smooth_triangle { <0.8889, 2.7969, 15.4049>, <0.383, 0.900, -0.210>, <0.7256, 2.0864, 12.2304>, <0.374, 0.909, -0.185>, <0.8073, 2.0724, 12.2304>, <0.042, 0.982, -0.183> }
	smooth_triangle { <0.8889, 2.7969, 15.4049>, <0.383, 0.900, -0.210>, <0.8073, 2.0724, 12.2304>, <0.042, 0.982, -0.183>, <0.9648, 2.7745, 15.4049>, <-0.009, 0.978, -0.207> }
	smooth_triangle { <0.9648, 2.7745, 15.4049>, <-0.009, 0.978, -0.207>, <0.8073, 2.0724, 12.2304>, <0.042, 0.982, -0.183>, <0.8994, 2.0814, 12.2304>, <-0.372, 0.915, -0.156> }
	smooth_triangle { <0.9648, 2.7745, 15.4049>, <-0.009, 0.978, -0.207>, <0.8994, 2.0814, 12.2304>, <-0.372, 0.915, -0.156>, <1.0278, 2.7954, 15.4049>, <-0.414, 0.894, -0.170> }
	smooth_triangle { <1.0278, 2.7954, 15.4049>, <-0.414, 0.894, -0.170>, <0.8994, 2.0814, 12.2304>, <-0.372, 0.915, -0.156>, <0.9643, 2.1373, 12.2304>, <-0.714, 0.693, -0.106> }
	smooth_triangle { <1.0278, 2.7954, 15.4049>, <-0.414, 0.894, -0.170>, <0.9643, 2.1373, 12.2304>, <-0.714, 0.693, -0.106>, <1.0984, 2.8368, 15.4049>, <-0.671, 0.731, -0.123> }
	smooth_triangle { <1.0984, 2.8368, 15.4049>, <-0.671, 0.731, -0.123>, <0.9643, 2.1373, 12.2304>, <-0.714, 0.693, -0.106>, <1.0111, 2.2019, 12.2304>, <-0.919, 0.393, -0.043> }
	smooth_triangle { <1.0984, 2.8368, 15.4049>, <-0.671, 0.731, -0.123>, <1.0111, 2.2019, 12.2304>, <-0.919, 0.393, -0.043>, <1.1457, 2.8974, 15.4049>, <-0.926, 0.376, -0.039> }
	smooth_triangle { <1.1457, 2.8974, 15.4049>, <-0.926, 0.376, -0.039>, <1.0111, 2.2019, 12.2304>, <-0.919, 0.393, -0.043>, <1.0234, 2.2816, 12.2304>, <-0.990, 0.144, 0.008> }
	smooth_triangle { <1.1457, 2.8974, 15.4049>, <-0.926, 0.376, -0.039>, <1.0234, 2.2816, 12.2304>, <-0.990, 0.144, 0.008>, <1.1544, 2.9662, 15.4049>, <-0.991, 0.131, 0.013> }
	smooth_triangle { <1.2797, 3.5776, 18.5939>, <-0.975, -0.214, 0.057>, <1.1544, 2.9662, 15.4049>, <-0.981, -0.177, 0.075>, <1.1381, 3.0384, 15.4049>, <-0.908, -0.401, 0.117> }
	smooth_triangle { <1.2797, 3.5776, 18.5939>, <-0.975, -0.214, 0.057>, <1.1381, 3.0384, 15.4049>, <-0.908, -0.401, 0.117>, <1.2657, 3.6422, 18.5939>, <-0.930, -0.360, 0.071> }
	smooth_triangle { <1.2657, 3.6422, 18.5939>, <-0.930, -0.360, 0.071>, <1.1381, 3.0384, 15.4049>, <-0.908, -0.401, 0.117>, <1.0892, 3.1089, 15.4049>, <-0.719, -0.675, 0.165> }
	smooth_triangle { <1.2657, 3.6422, 18.5939>, <-0.930, -0.360, 0.071>, <1.0892, 3.1089, 15.4049>, <-0.719, -0.675, 0.165>, <1.2374, 3.6929, 18.5939>, <-0.712, -0.691, 0.125> }
	smooth_triangle { <1.2374, 3.6929, 18.5939>, <-0.712, -0.691, 0.125>, <1.0892, 3.1089, 15.4049>, <-0.719, -0.675, 0.165>, <1.0371, 3.1482, 15.4049>, <-0.384, -0.903, 0.193> }
	smooth_triangle { <1.2374, 3.6929, 18.5939>, <-0.712, -0.691, 0.125>, <1.0371, 3.1482, 15.4049>, <-0.384, -0.903, 0.193>, <1.1797, 3.7227, 18.5939>, <-0.391, -0.907, 0.158> }
	smooth_triangle { <1.1797, 3.7227, 18.5939>, <-0.391, -0.907, 0.158>, <1.0371, 3.1482, 15.4049>, <-0.384, -0.903, 0.193>, <0.9623, 3.1631, 15.4049>, <0.020, -0.982, 0.190> }
	smooth_triangle { <1.1797, 3.7227, 18.5939>, <-0.391, -0.907, 0.158>, <0.9623, 3.1631, 15.4049>, <0.020, -0.982, 0.190>, <1.1170, 3.7484, 18.5939>, <-0.019, -0.986, 0.165> }
	smooth_triangle { <1.1170, 3.7484, 18.5939>, <-0.019, -0.986, 0.165>, <0.9623, 3.1631, 15.4049>, <0.020, -0.982, 0.190>, <0.8973, 3.1416, 15.4049>, <0.400, -0.903, 0.157> }
	smooth_triangle { <1.1170, 3.7484, 18.5939>, <-0.019, -0.986, 0.165>, <0.8973, 3.1416, 15.4049>, <0.400, -0.903, 0.157>, <1.0580, 3.7350, 18.5939>, <0.414, -0.899, 0.142> }
	smooth_triangle { <1.0580, 3.7350, 18.5939>, <0.414, -0.899, 0.142>, <0.8973, 3.1416, 15.4049>, <0.400, -0.903, 0.157>, <0.8354, 3.1072, 15.4049>, <0.674, -0.730, 0.108> }
	smooth_triangle { <1.0580, 3.7350, 18.5939>, <0.414, -0.899, 0.142>, <0.8354, 3.1072, 15.4049>, <0.674, -0.730, 0.108>, <1.0077, 3.6875, 18.5939>, <0.766, -0.637, 0.090> }
	smooth_triangle { <1.0077, 3.6875, 18.5939>, <0.766, -0.637, 0.090>, <0.8354, 3.1072, 15.4049>, <0.674, -0.730, 0.108>, <0.7831, 3.0360, 15.4049>, <0.938, -0.346, 0.014> }
	smooth_triangle { <1.0077, 3.6875, 18.5939>, <0.766, -0.637, 0.090>, <0.7831, 3.0360, 15.4049>, <0.938, -0.346, 0.014>, <0.9815, 3.6354, 18.5939>, <0.908, -0.416, 0.049> }
	smooth_triangle { <0.9815, 3.6354, 18.5939>, <0.908, -0.416, 0.049>, <0.7831, 3.0360, 15.4049>, <0.938, -0.346, 0.014>, <0.7734, 2.9658, 15.4049>, <0.998, -0.006, -0.057> }
	smooth_triangle { <0.9815, 3.6354, 18.5939>, <0.908, -0.416, 0.049>, <0.7734, 2.9658, 15.4049>, <0.998, -0.006, -0.057>, <0.9568, 3.5760, 18.5939>, <1.000, -0.002, -0.024> }
	smooth_triangle { <0.9568, 3.5760, 18.5939>, <1.000, -0.002, -0.024>, <0.7734, 2.9658, 15.4049>, <0.998, -0.006, -0.057>, <0.7903, 2.8936, 15.4049>, <0.908, 0.396, -0.133> }
	smooth_triangle { <0.9568, 3.5760, 18.5939>, <1.000, -0.002, -0.024>, <0.7903, 2.8936, 15.4049>, <0.908, 0.396, -0.133>, <0.9752, 3.5229, 18.5939>, <0.920, 0.380, -0.091> }
	smooth_triangle { <0.9752, 3.5229, 18.5939>, <0.920, 0.380, -0.091>, <0.7903, 2.8936, 15.4049>, <0.908, 0.396, -0.133>, <0.8241, 2.8282, 15.4049>, <0.712, 0.678, -0.181> }
	smooth_triangle { <0.9752, 3.5229, 18.5939>, <0.920, 0.380, -0.091>, <0.8241, 2.8282, 15.4049>, <0.712, 0.678, -0.181>, <1.0054, 3.4721, 18.5939>, <0.736, 0.663, -0.137> }
	smooth_triangle { <1.0054, 3.4721, 18.5939>, <0.736, 0.663, -0.137>, <0.8241, 2.8282, 15.4049>, <0.712, 0.678, -0.181>, <0.8889, 2.7969, 15.4049>, <0.383, 0.900, -0.210> }
	smooth_triangle { <1.0054, 3.4721, 18.5939>, <0.736, 0.663, -0.137>, <0.8889, 2.7969, 15.4049>, <0.383, 0.900, -0.210>, <1.0536, 3.4250, 18.5939>, <0.425, 0.889, -0.172> }
	smooth_triangle { <1.0536, 3.4250, 18.5939>, <0.425, 0.889, -0.172>, <0.8889, 2.7969, 15.4049>, <0.383, 0.900, -0.210>, <0.9648, 2.7745, 15.4049>, <-0.009, 0.978, -0.207> }
	smooth_triangle { <1.0536, 3.4250, 18.5939>, <0.425, 0.889, -0.172>, <0.9648, 2.7745, 15.4049>, <-0.009, 0.978, -0.207>, <1.1295, 3.4170, 18.5939>, <-0.068, 0.981, -0.180> }
	smooth_triangle { <1.1295, 3.4170, 18.5939>, <-0.068, 0.981, -0.180>, <0.9648, 2.7745, 15.4049>, <-0.009, 0.978, -0.207>, <1.0278, 2.7954, 15.4049>, <-0.414, 0.894, -0.170> }
	smooth_triangle { <1.1295, 3.4170, 18.5939>, <-0.068, 0.981, -0.180>, <1.0278, 2.7954, 15.4049>, <-0.414, 0.894, -0.170>, <1.1817, 3.4270, 18.5939>, <-0.369, 0.915, -0.163> }
	smooth_triangle { <1.1817, 3.4270, 18.5939>, <-0.369, 0.915, -0.163>, <1.0278, 2.7954, 15.4049>, <-0.414, 0.894, -0.170>, <1.0984, 2.8368, 15.4049>, <-0.671, 0.731, -0.123> }
	smooth_triangle { <1.1817, 3.4270, 18.5939>, <-0.369, 0.915, -0.163>, <1.0984, 2.8368, 15.4049>, <-0.671, 0.731, -0.123>, <1.2442, 3.4725, 18.5939>, <-0.714, 0.690, -0.119> }
	smooth_triangle { <1.2442, 3.4725, 18.5939>, <-0.714, 0.690, -0.119>, <1.0984, 2.8368, 15.4049>, <-0.671, 0.731, -0.123>, <1.1457, 2.8974, 15.4049>, <-0.926, 0.376, -0.039> }
	smooth_triangle { <1.2442, 3.4725, 18.5939>, <-0.714, 0.690, -0.119>, <1.1457, 2.8974, 15.4049>, <-0.926, 0.376, -0.039>, <1.2702, 3.5116, 18.5939>, <-0.925, 0.377, -0.059> }
	smooth_triangle { <1.2702, 3.5116, 18.5939>, <-0.925, 0.377, -0.059>, <1.1457, 2.8974, 15.4049>, <-0.926, 0.376, -0.039>, <1.1544, 2.9662, 15.4049>, <-0.991, 0.131, 0.013> }
	smooth_triangle { <1.2702, 3.5116, 18.5939>, <-0.925, 0.377, -0.059>, <1.1544, 2.9662, 15.4049>, <-0.991, 0.131, 0.013>, <1.2797, 3.5776, 18.5939>, <-0.987, 0.157, -0.030> }
	smooth_triangle { <1.2016, 4.1010, 21.8017>, <-0.983, -0.182, 0.001>, <1.2797, 3.5776, 18.5939>, <-0.975, -0.214, 0.057>, <1.2657, 3.6422, 18.5939>, <-0.930, -0.360, 0.071> }
	smooth_triangle { <1.2016, 4.1010, 21.8017>, <-0.983, -0.182, 0.001>, <1.2657, 3.6422, 18.5939>, <-0.930, -0.360, 0.071>, <1.1927, 4.1538, 21.8017>, <-0.943, -0.331, 0.023> }
	smooth_triangle { <1.1927, 4.1538, 21.8017>, <-0.943, -0.331, 0.023>, <1.2657, 3.6422, 18.5939>, <-0.930, -0.360, 0.071>, <1.2374, 3.6929, 18.5939>, <-0.712, -0.691, 0.125> }
	smooth_triangle { <1.1927, 4.1538, 21.8017>, <-0.943, -0.331, 0.023>, <1.2374, 3.6929, 18.5939>, <-0.712, -0.691, 0.125>, <1.1639, 4.2067, 21.8017>, <-0.686, -0.722, 0.090> }
	smooth_triangle { <1.1639, 4.2067, 21.8017>, <-0.686, -0.722, 0.090>, <1.2374, 3.6929, 18.5939>, <-0.712, -0.691, 0.125>, <1.1797, 3.7227, 18.5939>, <-0.391, -0.907, 0.158> }
	smooth_triangle { <1.1639, 4.2067, 21.8017>, <-0.686, -0.722, 0.090>, <1.1797, 3.7227, 18.5939>, <-0.391, -0.907, 0.158>, <1.1128, 4.2351, 21.8017>, <-0.339, -0.931, 0.131> }
	smooth_triangle { <1.1128, 4.2351, 21.8017>, <-0.339, -0.931, 0.131>, <1.1797, 3.7227, 18.5939>, <-0.391, -0.907, 0.158>, <1.1170, 3.7484, 18.5939>, <-0.019, -0.986, 0.165> }
	smooth_triangle { <1.1128, 4.2351, 21.8017>, <-0.339, -0.931, 0.131>, <1.1170, 3.7484, 18.5939>, <-0.019, -0.986, 0.165>, <1.0708, 4.2397, 21.8017>, <-0.002, -0.989, 0.147> }
	smooth_triangle { <1.0708, 4.2397, 21.8017>, <-0.002, -0.989, 0.147>, <1.1170, 3.7484, 18.5939>, <-0.019, -0.986, 0.165>, <1.0580, 3.7350, 18.5939>, <0.414, -0.899, 0.142> }
	smooth_triangle { <1.0708, 4.2397, 21.8017>, <-0.002, -0.989, 0.147>, <1.0580, 3.7350, 18.5939>, <0.414, -0.899, 0.142>, <1.0174, 4.2333, 21.8017>, <0.395, -0.907, 0.144> }
	smooth_triangle { <1.0174, 4.2333, 21.8017>, <0.395, -0.907, 0.144>, <1.0580, 3.7350, 18.5939>, <0.414, -0.899, 0.142>, <1.0077, 3.6875, 18.5939>, <0.766, -0.637, 0.090> }
	smooth_triangle { <1.0174, 4.2333, 21.8017>, <0.395, -0.907, 0.144>, <1.0077, 3.6875, 18.5939>, <0.766, -0.637, 0.090>, <0.9642, 4.1968, 21.8017>, <0.670, -0.732, 0.125> }
	smooth_triangle { <0.9642, 4.1968, 21.8017>, <0.670, -0.732, 0.125>, <1.0077, 3.6875, 18.5939>, <0.766, -0.637, 0.090>, <0.9815, 3.6354, 18.5939>, <0.908, -0.416, 0.049> }
	smooth_triangle { <0.9642, 4.1968, 21.8017>, <0.670, -0.732, 0.125>, <0.9815, 3.6354, 18.5939>, <0.908, -0.416, 0.049>, <0.9350, 4.1636, 21.8017>, <0.890, -0.447, 0.086> }
	smooth_triangle { <0.9350, 4.1636, 21.8017>, <0.890, -0.447, 0.086>, <0.9815, 3.6354, 18.5939>, <0.908, -0.416, 0.049>, <0.9568, 3.5760, 18.5939>, <1.000, -0.002, -0.024> }
	smooth_triangle { <0.9350, 4.1636, 21.8017>, <0.890, -0.447, 0.086>, <0.9568, 3.5760, 18.5939>, <1.000, -0.002, -0.024>, <0.9277, 4.1054, 21.8017>, <0.999, 0.034, 0.012> }
	smooth_triangle { <0.9277, 4.1054, 21.8017>, <0.999, 0.034, 0.012>, <0.9568, 3.5760, 18.5939>, <1.000, -0.002, -0.024>, <0.9752, 3.5229, 18.5939>, <0.920, 0.380, -0.091> }
	smooth_triangle { <0.9277, 4.1054, 21.8017>, <0.999, 0.034, 0.012>, <0.9752, 3.5229, 18.5939>, <0.920, 0.380, -0.091>, <0.9339, 4.0606, 21.8017>, <0.932, 0.360, -0.040> }
	smooth_triangle { <0.9339, 4.0606, 21.8017>, <0.932, 0.360, -0.040>, <0.9752, 3.5229, 18.5939>, <0.920, 0.380, -0.091>, <1.0054, 3.4721, 18.5939>, <0.736, 0.663, -0.137> }
	smooth_triangle { <0.9339, 4.0606, 21.8017>, <0.932, 0.360, -0.040>, <1.0054, 3.4721, 18.5939>, <0.736, 0.663, -0.137>, <0.9660, 4.0158, 21.8017>, <0.707, 0.700, -0.101> }
	smooth_triangle { <0.9660, 4.0158, 21.8017>, <0.707, 0.700, -0.101>, <1.0054, 3.4721, 18.5939>, <0.736, 0.663, -0.137>, <1.0536, 3.4250, 18.5939>, <0.425, 0.889, -0.172> }
	smooth_triangle { <0.9660, 4.0158, 21.8017>, <0.707, 0.700, -0.101>, <1.0536, 3.4250, 18.5939>, <0.425, 0.889, -0.172>, <1.0139, 3.9813, 21.8017>, <0.355, 0.923, -0.145> }
	smooth_triangle { <1.0139, 3.9813, 21.8017>, <0.355, 0.923, -0.145>, <1.0536, 3.4250, 18.5939>, <0.425, 0.889, -0.172>, <1.1295, 3.4170, 18.5939>, <-0.068, 0.981, -0.180> }
	smooth_triangle { <1.0139, 3.9813, 21.8017>, <0.355, 0.923, -0.145>, <1.1295, 3.4170, 18.5939>, <-0.068, 0.981, -0.180>, <1.0714, 3.9771, 21.8017>, <-0.024, 0.986, -0.164> }
	smooth_triangle { <1.0714, 3.9771, 21.8017>, <-0.024, 0.986, -0.164>, <1.1295, 3.4170, 18.5939>, <-0.068, 0.981, -0.180>, <1.1817, 3.4270, 18.5939>, <-0.369, 0.915, -0.163> }
	smooth_triangle { <1.0714, 3.9771, 21.8017>, <-0.024, 0.986, -0.164>, <1.1817, 3.4270, 18.5939>, <-0.369, 0.915, -0.163>, <1.1205, 3.9836, 21.8017>, <-0.413, 0.897, -0.161> }
	smooth_triangle { <1.1205, 3.9836, 21.8017>, <-0.413, 0.897, -0.161>, <1.1817, 3.4270, 18.5939>, <-0.369, 0.915, -0.163>, <1.2442, 3.4725, 18.5939>, <-0.714, 0.690, -0.119> }
	smooth_triangle { <1.1205, 3.9836, 21.8017>, <-0.413, 0.897, -0.161>, <1.2442, 3.4725, 18.5939>, <-0.714, 0.690, -0.119>, <1.1589, 4.0147, 21.8017>, <-0.664, 0.735, -0.140> }
	smooth_triangle { <1.1589, 4.0147, 21.8017>, <-0.664, 0.735, -0.140>, <1.2442, 3.4725, 18.5939>, <-0.714, 0.690, -0.119>, <1.2702, 3.5116, 18.5939>, <-0.925, 0.377, -0.059> }
	smooth_triangle { <1.1589, 4.0147, 21.8017>, <-0.664, 0.735, -0.140>, <1.2702, 3.5116, 18.5939>, <-0.925, 0.377, -0.059>, <1.1921, 4.0509, 21.8017>, <-0.908, 0.408, -0.094> }
	smooth_triangle { <1.1921, 4.0509, 21.8017>, <-0.908, 0.408, -0.094>, <1.2702, 3.5116, 18.5939>, <-0.925, 0.377, -0.059>, <1.2797, 3.5776, 18.5939>, <-0.987, 0.157, -0.030> }
	smooth_triangle { <1.1921, 4.0509, 21.8017>, <-0.908, 0.408, -0.094>, <1.2797, 3.5776, 18.5939>, <-0.987, 0.157, -0.030>, <1.2016, 4.1010, 21.8017>, <-0.979, 0.192, -0.064> }
	smooth_triangle { <1.0911, 4.5411, 24.6126>, <-0.984, -0.177, 0.002>, <1.2016, 4.1010, 21.8017>, <-0.983, -0.182, 0.001>, <1.1927, 4.1538, 21.8017>, <-0.943, -0.331, 0.023> }
	smooth_triangle { <1.0911, 4.5411, 24.6126>, <-0.984, -0.177, 0.002>, <1.1927, 4.1538, 21.8017>, <-0.943, -0.331, 0.023>, <1.0841, 4.5792, 24.6126>, <-0.916, -0.400, 0.038> }
	smooth_triangle { <1.0841, 4.5792, 24.6126>, <-0.916, -0.400, 0.038>, <1.1927, 4.1538, 21.8017>, <-0.943, -0.331, 0.023>, <1.1639, 4.2067, 21.8017>, <-0.686, -0.722, 0.090> }
	smooth_triangle { <1.0841, 4.5792, 24.6126>, <-0.916, -0.400, 0.038>, <1.1639, 4.2067, 21.8017>, <-0.686, -0.722, 0.090>, <1.0523, 4.6204, 24.6126>, <-0.660, -0.746, 0.087> }
	smooth_triangle { <1.0523, 4.6204, 24.6126>, <-0.660, -0.746, 0.087>, <1.1639, 4.2067, 21.8017>, <-0.686, -0.722, 0.090>, <1.1128, 4.2351, 21.8017>, <-0.339, -0.931, 0.131> }
	smooth_triangle { <1.0523, 4.6204, 24.6126>, <-0.660, -0.746, 0.087>, <1.1128, 4.2351, 21.8017>, <-0.339, -0.931, 0.131>, <1.0171, 4.6384, 24.6126>, <-0.326, -0.939, 0.113> }
	smooth_triangle { <1.0171, 4.6384, 24.6126>, <-0.326, -0.939, 0.113>, <1.1128, 4.2351, 21.8017>, <-0.339, -0.931, 0.131>, <1.0708, 4.2397, 21.8017>, <-0.002, -0.989, 0.147> }
	smooth_triangle { <1.0171, 4.6384, 24.6126>, <-0.326, -0.939, 0.113>, <1.0708, 4.2397, 21.8017>, <-0.002, -0.989, 0.147>, <0.9756, 4.6492, 24.6126>, <-0.023, -0.992, 0.122> }
	smooth_triangle { <0.9756, 4.6492, 24.6126>, <-0.023, -0.992, 0.122>, <1.0708, 4.2397, 21.8017>, <-0.002, -0.989, 0.147>, <1.0174, 4.2333, 21.8017>, <0.395, -0.907, 0.144> }
	smooth_triangle { <0.9756, 4.6492, 24.6126>, <-0.023, -0.992, 0.122>, <1.0174, 4.2333, 21.8017>, <0.395, -0.907, 0.144>, <0.9351, 4.6382, 24.6126>, <0.347, -0.930, 0.117> }
	smooth_triangle { <0.9351, 4.6382, 24.6126>, <0.347, -0.930, 0.117>, <1.0174, 4.2333, 21.8017>, <0.395, -0.907, 0.144>, <0.9642, 4.1968, 21.8017>, <0.670, -0.732, 0.125> }
	smooth_triangle { <0.9351, 4.6382, 24.6126>, <0.347, -0.930, 0.117>, <0.9642, 4.1968, 21.8017>, <0.670, -0.732, 0.125>, <0.8968, 4.6201, 24.6126>, <0.644, -0.759, 0.095> }
	smooth_triangle { <0.8968, 4.6201, 24.6126>, <0.644, -0.759, 0.095>, <0.9642, 4.1968, 21.8017>, <0.670, -0.732, 0.125>, <0.9350, 4.1636, 21.8017>, <0.890, -0.447, 0.086> }
	smooth_triangle { <0.8968, 4.6201, 24.6126>, <0.644, -0.759, 0.095>, <0.9350, 4.1636, 21.8017>, <0.890, -0.447, 0.086>, <0.8628, 4.5800, 24.6126>, <0.908, -0.415, 0.051> }
	smooth_triangle { <0.8628, 4.5800, 24.6126>, <0.908, -0.415, 0.051>, <0.9350, 4.1636, 21.8017>, <0.890, -0.447, 0.086>, <0.9277, 4.1054, 21.8017>, <0.999, 0.034, 0.012> }
	smooth_triangle { <0.8628, 4.5800, 24.6126>, <0.908, -0.415, 0.051>, <0.9277, 4.1054, 21.8017>, <0.999, 0.034, 0.012>, <0.8554, 4.5307, 24.6126>, <1.000, -0.010, -0.001> }
	smooth_triangle { <0.8554, 4.5307, 24.6126>, <1.000, -0.010, -0.001>, <0.9277, 4.1054, 21.8017>, <0.999, 0.034, 0.012>, <0.9339, 4.0606, 21.8017>, <0.932, 0.360, -0.040> }
	smooth_triangle { <0.8554, 4.5307, 24.6126>, <1.000, -0.010, -0.001>, <0.9339, 4.0606, 21.8017>, <0.932, 0.360, -0.040>, <0.8624, 4.4880, 24.6126>, <0.895, 0.442, -0.062> }
	smooth_triangle { <0.8624, 4.4880, 24.6126>, <0.895, 0.442, -0.062>, <0.9339, 4.0606, 21.8017>, <0.932, 0.360, -0.040>, <0.9660, 4.0158, 21.8017>, <0.707, 0.700, -0.101> }
	smooth_triangle { <0.8624, 4.4880, 24.6126>, <0.895, 0.442, -0.062>, <0.9660, 4.0158, 21.8017>, <0.707, 0.700, -0.101>, <0.8898, 4.4583, 24.6126>, <0.719, 0.688, -0.095> }
	smooth_triangle { <0.8898, 4.4583, 24.6126>, <0.719, 0.688, -0.095>, <0.9660, 4.0158, 21.8017>, <0.707, 0.700, -0.101>, <1.0139, 3.9813, 21.8017>, <0.355, 0.923, -0.145> }
	smooth_triangle { <0.8898, 4.4583, 24.6126>, <0.719, 0.688, -0.095>, <1.0139, 3.9813, 21.8017>, <0.355, 0.923, -0.145>, <0.9285, 4.4258, 24.6126>, <0.351, 0.928, -0.127> }
	smooth_triangle { <0.9285, 4.4258, 24.6126>, <0.351, 0.928, -0.127>, <1.0139, 3.9813, 21.8017>, <0.355, 0.923, -0.145>, <1.0714, 3.9771, 21.8017>, <-0.024, 0.986, -0.164> }
	smooth_triangle { <0.9285, 4.4258, 24.6126>, <0.351, 0.928, -0.127>, <1.0714, 3.9771, 21.8017>, <-0.024, 0.986, -0.164>, <0.9684, 4.4193, 24.6126>, <-0.035, 0.990, -0.138> }
	smooth_triangle { <0.9684, 4.4193, 24.6126>, <-0.035, 0.990, -0.138>, <1.0714, 3.9771, 21.8017>, <-0.024, 0.986, -0.164>, <1.1205, 3.9836, 21.8017>, <-0.413, 0.897, -0.161> }
	smooth_triangle { <0.9684, 4.4193, 24.6126>, <-0.035, 0.990, -0.138>, <1.1205, 3.9836, 21.8017>, <-0.413, 0.897, -0.161>, <1.0127, 4.4344, 24.6126>, <-0.353, 0.926, -0.131> }
	smooth_triangle { <1.0127, 4.4344, 24.6126>, <-0.353, 0.926, -0.131>, <1.1205, 3.9836, 21.8017>, <-0.413, 0.897, -0.161>, <1.1589, 4.0147, 21.8017>, <-0.664, 0.735, -0.140> }
	smooth_triangle { <1.0127, 4.4344, 24.6126>, <-0.353, 0.926, -0.131>, <1.1589, 4.0147, 21.8017>, <-0.664, 0.735, -0.140>, <1.0557, 4.4525, 24.6126>, <-0.646, 0.756, -0.110> }
	smooth_triangle { <1.0557, 4.4525, 24.6126>, <-0.646, 0.756, -0.110>, <1.1589, 4.0147, 21.8017>, <-0.664, 0.735, -0.140>, <1.1921, 4.0509, 21.8017>, <-0.908, 0.408, -0.094> }
	smooth_triangle { <1.0557, 4.4525, 24.6126>, <-0.646, 0.756, -0.110>, <1.1921, 4.0509, 21.8017>, <-0.908, 0.408, -0.094>, <1.0819, 4.4964, 24.6126>, <-0.936, 0.347, -0.060> }
	smooth_triangle { <1.0819, 4.4964, 24.6126>, <-0.936, 0.347, -0.060>, <1.1921, 4.0509, 21.8017>, <-0.908, 0.408, -0.094>, <1.2016, 4.1010, 21.8017>, <-0.979, 0.192, -0.064> }
	smooth_triangle { <1.0819, 4.4964, 24.6126>, <-0.936, 0.347, -0.060>, <1.2016, 4.1010, 21.8017>, <-0.979, 0.192, -0.064>, <1.0911, 4.5411, 24.6126>, <-0.964, 0.262, -0.038> }
	smooth_triangle { <1.1206, 4.8373, 27.4408>, <-0.966, -0.256, 0.026>, <1.0911, 4.5411, 24.6126>, <-0.984, -0.177, 0.002>, <1.0841, 4.5792, 24.6126>, <-0.916, -0.400, 0.038> }
	smooth_triangle { <1.1206, 4.8373, 27.4408>, <-0.966, -0.256, 0.026>, <1.0841, 4.5792, 24.6126>, <-0.916, -0.400, 0.038>, <1.1109, 4.8691, 27.4408>, <-0.923, -0.383, 0.035> }
	smooth_triangle { <1.1109, 4.8691, 27.4408>, <-0.923, -0.383, 0.035>, <1.0841, 4.5792, 24.6126>, <-0.916, -0.400, 0.038>, <1.0523, 4.6204, 24.6126>, <-0.660, -0.746, 0.087> }
	smooth_triangle { <1.1109, 4.8691, 27.4408>, <-0.923, -0.383, 0.035>, <1.0523, 4.6204, 24.6126>, <-0.660, -0.746, 0.087>, <1.0931, 4.9014, 27.4408>, <-0.666, -0.743, 0.070> }
	smooth_triangle { <1.0931, 4.9014, 27.4408>, <-0.666, -0.743, 0.070>, <1.0523, 4.6204, 24.6126>, <-0.660, -0.746, 0.087>, <1.0171, 4.6384, 24.6126>, <-0.326, -0.939, 0.113> }
	smooth_triangle { <1.0931, 4.9014, 27.4408>, <-0.666, -0.743, 0.070>, <1.0171, 4.6384, 24.6126>, <-0.326, -0.939, 0.113>, <1.0567, 4.9186, 27.4408>, <-0.382, -0.920, 0.087> }
	smooth_triangle { <1.0567, 4.9186, 27.4408>, <-0.382, -0.920, 0.087>, <1.0171, 4.6384, 24.6126>, <-0.326, -0.939, 0.113>, <0.9756, 4.6492, 24.6126>, <-0.023, -0.992, 0.122> }
	smooth_triangle { <1.0567, 4.9186, 27.4408>, <-0.382, -0.920, 0.087>, <0.9756, 4.6492, 24.6126>, <-0.023, -0.992, 0.122>, <1.0270, 4.9270, 27.4408>, <-0.057, -0.994, 0.093> }
	smooth_triangle { <1.0270, 4.9270, 27.4408>, <-0.057, -0.994, 0.093>, <0.9756, 4.6492, 24.6126>, <-0.023, -0.992, 0.122>, <0.9351, 4.6382, 24.6126>, <0.347, -0.930, 0.117> }
	smooth_triangle { <1.0270, 4.9270, 27.4408>, <-0.057, -0.994, 0.093>, <0.9351, 4.6382, 24.6126>, <0.347, -0.930, 0.117>, <0.9878, 4.9220, 27.4408>, <0.402, -0.912, 0.083> }
	smooth_triangle { <0.9878, 4.9220, 27.4408>, <0.402, -0.912, 0.083>, <0.9351, 4.6382, 24.6126>, <0.347, -0.930, 0.117>, <0.8968, 4.6201, 24.6126>, <0.644, -0.759, 0.095> }
	smooth_triangle { <0.9878, 4.9220, 27.4408>, <0.402, -0.912, 0.083>, <0.8968, 4.6201, 24.6126>, <0.644, -0.759, 0.095>, <0.9635, 4.8993, 27.4408>, <0.690, -0.721, 0.062> }
	smooth_triangle { <0.9635, 4.8993, 27.4408>, <0.690, -0.721, 0.062>, <0.8968, 4.6201, 24.6126>, <0.644, -0.759, 0.095>, <0.8628, 4.5800, 24.6126>, <0.908, -0.415, 0.051> }
	smooth_triangle { <0.9635, 4.8993, 27.4408>, <0.690, -0.721, 0.062>, <0.8628, 4.5800, 24.6126>, <0.908, -0.415, 0.051>, <0.9402, 4.8740, 27.4408>, <0.912, -0.409, 0.028> }
	smooth_triangle { <0.9402, 4.8740, 27.4408>, <0.912, -0.409, 0.028>, <0.8628, 4.5800, 24.6126>, <0.908, -0.415, 0.051>, <0.8554, 4.5307, 24.6126>, <1.000, -0.010, -0.001> }
	smooth_triangle { <0.9402, 4.8740, 27.4408>, <0.912, -0.409, 0.028>, <0.8554, 4.5307, 24.6126>, <1.000, -0.010, -0.001>, <0.9325, 4.8403, 27.4408>, <1.000, 0.023, -0.017> }
	smooth_triangle { <0.9325, 4.8403, 27.4408>, <1.000, 0.023, -0.017>, <0.8554, 4.5307, 24.6126>, <1.000, -0.010, -0.001>, <0.8624, 4.4880, 24.6126>, <0.895, 0.442, -0.062> }
	smooth_triangle { <0.9325, 4.8403, 27.4408>, <1.000, 0.023, -0.017>, <0.8624, 4.4880, 24.6126>, <0.895, 0.442, -0.062>, <0.9446, 4.8038, 27.4408>, <0.923, 0.381, -0.052> }
	smooth_triangle { <0.9446, 4.8038, 27.4408>, <0.923, 0.381, -0.052>, <0.8624, 4.4880, 24.6126>, <0.895, 0.442, -0.062>, <0.8898, 4.4583, 24.6126>, <0.719, 0.688, -0.095> }
	smooth_triangle { <0.9446, 4.8038, 27.4408>, <0.923, 0.381, -0.052>, <0.8898, 4.4583, 24.6126>, <0.719, 0.688, -0.095>, <0.9590, 4.7696, 27.4408>, <0.710, 0.700, -0.083> }
	smooth_triangle { <0.9590, 4.7696, 27.4408>, <0.710, 0.700, -0.083>, <0.8898, 4.4583, 24.6126>, <0.719, 0.688, -0.095>, <0.9285, 4.4258, 24.6126>, <0.351, 0.928, -0.127> }
	smooth_triangle { <0.9590, 4.7696, 27.4408>, <0.710, 0.700, -0.083>, <0.9285, 4.4258, 24.6126>, <0.351, 0.928, -0.127>, <0.9894, 4.7574, 27.4408>, <0.349, 0.931, -0.105> }
	smooth_triangle { <0.9894, 4.7574, 27.4408>, <0.349, 0.931, -0.105>, <0.9285, 4.4258, 24.6126>, <0.351, 0.928, -0.127>, <0.9684, 4.4193, 24.6126>, <-0.035, 0.990, -0.138> }
	smooth_triangle { <0.9894, 4.7574, 27.4408>, <0.349, 0.931, -0.105>, <0.9684, 4.4193, 24.6126>, <-0.035, 0.990, -0.138>, <1.0254, 4.7481, 27.4408>, <0.042, 0.993, -0.108> }
	smooth_triangle { <1.0254, 4.7481, 27.4408>, <0.042, 0.993, -0.108>, <0.9684, 4.4193, 24.6126>, <-0.035, 0.990, -0.138>, <1.0127, 4.4344, 24.6126>, <-0.353, 0.926, -0.131> }
	smooth_triangle { <1.0254, 4.7481, 27.4408>, <0.042, 0.993, -0.108>, <1.0127, 4.4344, 24.6126>, <-0.353, 0.926, -0.131>, <1.0568, 4.7496, 27.4408>, <-0.306, 0.947, -0.102> }
	smooth_triangle { <1.0568, 4.7496, 27.4408>, <-0.306, 0.947, -0.102>, <1.0127, 4.4344, 24.6126>, <-0.353, 0.926, -0.131>, <1.0557, 4.4525, 24.6126>, <-0.646, 0.756, -0.110> }
	smooth_triangle { <1.0568, 4.7496, 27.4408>, <-0.306, 0.947, -0.102>, <1.0557, 4.4525, 24.6126>, <-0.646, 0.756, -0.110>, <1.0897, 4.7698, 27.4408>, <-0.728, 0.681, -0.074> }
	smooth_triangle { <1.0897, 4.7698, 27.4408>, <-0.728, 0.681, -0.074>, <1.0557, 4.4525, 24.6126>, <-0.646, 0.756, -0.110>, <1.0819, 4.4964, 24.6126>, <-0.936, 0.347, -0.060> }
	smooth_triangle { <1.0897, 4.7698, 27.4408>, <-0.728, 0.681, -0.074>, <1.0819, 4.4964, 24.6126>, <-0.936, 0.347, -0.060>, <1.1083, 4.8071, 27.4408>, <-0.914, 0.402, -0.044> }
	smooth_triangle { <1.1083, 4.8071, 27.4408>, <-0.914, 0.402, -0.044>, <1.0819, 4.4964, 24.6126>, <-0.936, 0.347, -0.060>, <1.0911, 4.5411, 24.6126>, <-0.964, 0.262, -0.038> }
	smooth_triangle { <1.1083, 4.8071, 27.4408>, <-0.914, 0.402, -0.044>, <1.0911, 4.5411, 24.6126>, <-0.964, 0.262, -0.038>, <1.1206, 4.8373, 27.4408>, <-0.947, 0.318, -0.040> }
	smooth_triangle { <1.0676, 5.1131, 30.2721>, <-0.985, -0.168, 0.027>, <1.1206, 4.8373, 27.4408>, <-0.966, -0.256, 0.026>, <1.1109, 4.8691, 27.4408>, <-0.923, -0.383, 0.035> }
	smooth_triangle { <1.0676, 5.1131, 30.2721>, <-0.985, -0.168, 0.027>, <1.1109, 4.8691, 27.4408>, <-0.923, -0.383, 0.035>, <1.0649, 5.1383, 30.2721>, <-0.916, -0.395, 0.065> }
	smooth_triangle { <1.0649, 5.1383, 30.2721>, <-0.916, -0.395, 0.065>, <1.1109, 4.8691, 27.4408>, <-0.923, -0.383, 0.035>, <1.0931, 4.9014, 27.4408>, <-0.666, -0.743, 0.070> }
	smooth_triangle { <1.0649, 5.1383, 30.2721>, <-0.916, -0.395, 0.065>, <1.0931, 4.9014, 27.4408>, <-0.666, -0.743, 0.070>, <1.0486, 5.1588, 30.2721>, <-0.703, -0.705, 0.098> }
	smooth_triangle { <1.0486, 5.1588, 30.2721>, <-0.703, -0.705, 0.098>, <1.0931, 4.9014, 27.4408>, <-0.666, -0.743, 0.070>, <1.0567, 4.9186, 27.4408>, <-0.382, -0.920, 0.087> }
	smooth_triangle { <1.0486, 5.1588, 30.2721>, <-0.703, -0.705, 0.098>, <1.0567, 4.9186, 27.4408>, <-0.382, -0.920, 0.087>, <1.0262, 5.1768, 30.2721>, <-0.458, -0.882, 0.112> }
	smooth_triangle { <1.0262, 5.1768, 30.2721>, <-0.458, -0.882, 0.112>, <1.0567, 4.9186, 27.4408>, <-0.382, -0.920, 0.087>, <1.0270, 4.9270, 27.4408>, <-0.057, -0.994, 0.093> }
	smooth_triangle { <1.0262, 5.1768, 30.2721>, <-0.458, -0.882, 0.112>, <1.0270, 4.9270, 27.4408>, <-0.057, -0.994, 0.093>, <0.9992, 5.1854, 30.2721>, <-0.026, -0.993, 0.113> }
	smooth_triangle { <0.9992, 5.1854, 30.2721>, <-0.026, -0.993, 0.113>, <1.0270, 4.9270, 27.4408>, <-0.057, -0.994, 0.093>, <0.9878, 4.9220, 27.4408>, <0.402, -0.912, 0.083> }
	smooth_triangle { <0.9992, 5.1854, 30.2721>, <-0.026, -0.993, 0.113>, <0.9878, 4.9220, 27.4408>, <0.402, -0.912, 0.083>, <0.9720, 5.1771, 30.2721>, <0.421, -0.902, 0.091> }
	smooth_triangle { <0.9720, 5.1771, 30.2721>, <0.421, -0.902, 0.091>, <0.9878, 4.9220, 27.4408>, <0.402, -0.912, 0.083>, <0.9635, 4.8993, 27.4408>, <0.690, -0.721, 0.062> }
	smooth_triangle { <0.9720, 5.1771, 30.2721>, <0.421, -0.902, 0.091>, <0.9635, 4.8993, 27.4408>, <0.690, -0.721, 0.062>, <0.9503, 5.1635, 30.2721>, <0.718, -0.694, 0.055> }
	smooth_triangle { <0.9503, 5.1635, 30.2721>, <0.718, -0.694, 0.055>, <0.9635, 4.8993, 27.4408>, <0.690, -0.721, 0.062>, <0.9402, 4.8740, 27.4408>, <0.912, -0.409, 0.028> }
	smooth_triangle { <0.9503, 5.1635, 30.2721>, <0.718, -0.694, 0.055>, <0.9402, 4.8740, 27.4408>, <0.912, -0.409, 0.028>, <0.9377, 5.1373, 30.2721>, <0.934, -0.356, 0.009> }
	smooth_triangle { <0.9377, 5.1373, 30.2721>, <0.934, -0.356, 0.009>, <0.9402, 4.8740, 27.4408>, <0.912, -0.409, 0.028>, <0.9325, 4.8403, 27.4408>, <1.000, 0.023, -0.017> }
	smooth_triangle { <0.9377, 5.1373, 30.2721>, <0.934, -0.356, 0.009>, <0.9325, 4.8403, 27.4408>, <1.000, 0.023, -0.017>, <0.9325, 5.1138, 30.2721>, <0.999, -0.004, -0.035> }
	smooth_triangle { <0.9325, 5.1138, 30.2721>, <0.999, -0.004, -0.035>, <0.9325, 4.8403, 27.4408>, <1.000, 0.023, -0.017>, <0.9446, 4.8038, 27.4408>, <0.923, 0.381, -0.052> }
	smooth_triangle { <0.9325, 5.1138, 30.2721>, <0.999, -0.004, -0.035>, <0.9446, 4.8038, 27.4408>, <0.923, 0.381, -0.052>, <0.9369, 5.0894, 30.2721>, <0.937, 0.341, -0.075> }
	smooth_triangle { <0.9369, 5.0894, 30.2721>, <0.937, 0.341, -0.075>, <0.9446, 4.8038, 27.4408>, <0.923, 0.381, -0.052>, <0.9590, 4.7696, 27.4408>, <0.710, 0.700, -0.083> }
	smooth_triangle { <0.9369, 5.0894, 30.2721>, <0.937, 0.341, -0.075>, <0.9590, 4.7696, 27.4408>, <0.710, 0.700, -0.083>, <0.9528, 5.0675, 30.2721>, <0.672, 0.731, -0.116> }
	smooth_triangle { <0.9528, 5.0675, 30.2721>, <0.672, 0.731, -0.116>, <0.9590, 4.7696, 27.4408>, <0.710, 0.700, -0.083>, <0.9894, 4.7574, 27.4408>, <0.349, 0.931, -0.105> }
	smooth_triangle { <0.9528, 5.0675, 30.2721>, <0.672, 0.731, -0.116>, <0.9894, 4.7574, 27.4408>, <0.349, 0.931, -0.105>, <0.9732, 5.0493, 30.2721>, <0.424, 0.897, -0.128> }
	smooth_triangle { <0.9732, 5.0493, 30.2721>, <0.424, 0.897, -0.128>, <0.9894, 4.7574, 27.4408>, <0.349, 0.931, -0.105>, <1.0254, 4.7481, 27.4408>, <0.042, 0.993, -0.108> }
	smooth_triangle { <0.9732, 5.0493, 30.2721>, <0.424, 0.897, -0.128>, <1.0254, 4.7481, 27.4408>, <0.042, 0.993, -0.108>, <1.0009, 5.0446, 30.2721>, <0.000, 0.992, -0.128> }
	smooth_triangle { <1.0009, 5.0446, 30.2721>, <0.000, 0.992, -0.128>, <1.0254, 4.7481, 27.4408>, <0.042, 0.993, -0.108>, <1.0568, 4.7496, 27.4408>, <-0.306, 0.947, -0.102> }
	smooth_triangle { <1.0009, 5.0446, 30.2721>, <0.000, 0.992, -0.128>, <1.0568, 4.7496, 27.4408>, <-0.306, 0.947, -0.102>, <1.0307, 5.0531, 30.2721>, <-0.389, 0.915, -0.108> }
	smooth_triangle { <1.0307, 5.0531, 30.2721>, <-0.389, 0.915, -0.108>, <1.0568, 4.7496, 27.4408>, <-0.306, 0.947, -0.102>, <1.0897, 4.7698, 27.4408>, <-0.728, 0.681, -0.074> }
	smooth_triangle { <1.0307, 5.0531, 30.2721>, <-0.389, 0.915, -0.108>, <1.0897, 4.7698, 27.4408>, <-0.728, 0.681, -0.074>, <1.0472, 5.0634, 30.2721>, <-0.709, 0.701, -0.074> }
	smooth_triangle { <1.0472, 5.0634, 30.2721>, <-0.709, 0.701, -0.074>, <1.0897, 4.7698, 27.4408>, <-0.728, 0.681, -0.074>, <1.1083, 4.8071, 27.4408>, <-0.914, 0.402, -0.044> }
	smooth_triangle { <1.0472, 5.0634, 30.2721>, <-0.709, 0.701, -0.074>, <1.1083, 4.8071, 27.4408>, <-0.914, 0.402, -0.044>, <1.0624, 5.0866, 30.2721>, <-0.910, 0.412, -0.031> }
	smooth_triangle { <1.0624, 5.0866, 30.2721>, <-0.910, 0.412, -0.031>, <1.1083, 4.8071, 27.4408>, <-0.914, 0.402, -0.044>, <1.1206, 4.8373, 27.4408>, <-0.947, 0.318, -0.040> }
	smooth_triangle { <1.0624, 5.0866, 30.2721>, <-0.910, 0.412, -0.031>, <1.1206, 4.8373, 27.4408>, <-0.947, 0.318, -0.040>, <1.0676, 5.1131, 30.2721>, <-0.980, 0.199, 0.008> }
	smooth_triangle { <1.2386, 5.5058, 33.0831>, <-0.955, -0.282, 0.093>, <1.0676, 5.1131, 30.2721>, <-0.985, -0.168, 0.027>, <1.0649, 5.1383, 30.2721>, <-0.916, -0.395, 0.065> }
	smooth_triangle { <1.2386, 5.5058, 33.0831>, <-0.955, -0.282, 0.093>, <1.0649, 5.1383, 30.2721>, <-0.916, -0.395, 0.065>, <1.2315, 5.5236, 33.0831>, <-0.903, -0.417, 0.107> }
	smooth_triangle { <1.2315, 5.5236, 33.0831>, <-0.903, -0.417, 0.107>, <1.0649, 5.1383, 30.2721>, <-0.916, -0.395, 0.065>, <1.0486, 5.1588, 30.2721>, <-0.703, -0.705, 0.098> }
	smooth_triangle { <1.2315, 5.5236, 33.0831>, <-0.903, -0.417, 0.107>, <1.0486, 5.1588, 30.2721>, <-0.703, -0.705, 0.098>, <1.2246, 5.5377, 33.0831>, <-0.760, -0.637, 0.128> }
	smooth_triangle { <1.2246, 5.5377, 33.0831>, <-0.760, -0.637, 0.128>, <1.0486, 5.1588, 30.2721>, <-0.703, -0.705, 0.098>, <1.0262, 5.1768, 30.2721>, <-0.458, -0.882, 0.112> }
	smooth_triangle { <1.2246, 5.5377, 33.0831>, <-0.760, -0.637, 0.128>, <1.0262, 5.1768, 30.2721>, <-0.458, -0.882, 0.112>, <1.2089, 5.5491, 33.0831>, <-0.422, -0.896, 0.141> }
	smooth_triangle { <1.2089, 5.5491, 33.0831>, <-0.422, -0.896, 0.141>, <1.0262, 5.1768, 30.2721>, <-0.458, -0.882, 0.112>, <0.9992, 5.1854, 30.2721>, <-0.026, -0.993, 0.113> }
	smooth_triangle { <1.2089, 5.5491, 33.0831>, <-0.422, -0.896, 0.141>, <0.9992, 5.1854, 30.2721>, <-0.026, -0.993, 0.113>, <1.1921, 5.5535, 33.0831>, <-0.023, -0.992, 0.128> }
	smooth_triangle { <1.1921, 5.5535, 33.0831>, <-0.023, -0.992, 0.128>, <0.9992, 5.1854, 30.2721>, <-0.026, -0.993, 0.113>, <0.9720, 5.1771, 30.2721>, <0.421, -0.902, 0.091> }
	smooth_triangle { <1.1921, 5.5535, 33.0831>, <-0.023, -0.992, 0.128>, <0.9720, 5.1771, 30.2721>, <0.421, -0.902, 0.091>, <1.1731, 5.5505, 33.0831>, <0.411, -0.907, 0.089> }
	smooth_triangle { <1.1731, 5.5505, 33.0831>, <0.411, -0.907, 0.089>, <0.9720, 5.1771, 30.2721>, <0.421, -0.902, 0.091>, <0.9503, 5.1635, 30.2721>, <0.718, -0.694, 0.055> }
	smooth_triangle { <1.1731, 5.5505, 33.0831>, <0.411, -0.907, 0.089>, <0.9503, 5.1635, 30.2721>, <0.718, -0.694, 0.055>, <1.1594, 5.5407, 33.0831>, <0.723, -0.690, 0.039> }
	smooth_triangle { <1.1594, 5.5407, 33.0831>, <0.723, -0.690, 0.039>, <0.9503, 5.1635, 30.2721>, <0.718, -0.694, 0.055>, <0.9377, 5.1373, 30.2721>, <0.934, -0.356, 0.009> }
	smooth_triangle { <1.1594, 5.5407, 33.0831>, <0.723, -0.690, 0.039>, <0.9377, 5.1373, 30.2721>, <0.934, -0.356, 0.009>, <1.1493, 5.5269, 33.0831>, <0.892, -0.452, -0.004> }
	smooth_triangle { <1.1493, 5.5269, 33.0831>, <0.892, -0.452, -0.004>, <0.9377, 5.1373, 30.2721>, <0.934, -0.356, 0.009>, <0.9325, 5.1138, 30.2721>, <0.999, -0.004, -0.035> }
	smooth_triangle { <1.1493, 5.5269, 33.0831>, <0.892, -0.452, -0.004>, <0.9325, 5.1138, 30.2721>, <0.999, -0.004, -0.035>, <1.1446, 5.5094, 33.0831>, <0.997, -0.037, -0.067> }
	smooth_triangle { <1.1446, 5.5094, 33.0831>, <0.997, -0.037, -0.067>, <0.9325, 5.1138, 30.2721>, <0.999, -0.004, -0.035>, <0.9369, 5.0894, 30.2721>, <0.937, 0.341, -0.075> }
	smooth_triangle { <1.1446, 5.5094, 33.0831>, <0.997, -0.037, -0.067>, <0.9369, 5.0894, 30.2721>, <0.937, 0.341, -0.075>, <1.1465, 5.4874, 33.0831>, <0.909, 0.399, -0.121> }
	smooth_triangle { <1.1465, 5.4874, 33.0831>, <0.909, 0.399, -0.121>, <0.9369, 5.0894, 30.2721>, <0.937, 0.341, -0.075>, <0.9528, 5.0675, 30.2721>, <0.672, 0.731, -0.116> }
	smooth_triangle { <1.1465, 5.4874, 33.0831>, <0.909, 0.399, -0.121>, <0.9528, 5.0675, 30.2721>, <0.672, 0.731, -0.116>, <1.1586, 5.4765, 33.0831>, <0.661, 0.735, -0.150> }
	smooth_triangle { <1.1586, 5.4765, 33.0831>, <0.661, 0.735, -0.150>, <0.9528, 5.0675, 30.2721>, <0.672, 0.731, -0.116>, <0.9732, 5.0493, 30.2721>, <0.424, 0.897, -0.128> }
	smooth_triangle { <1.1586, 5.4765, 33.0831>, <0.661, 0.735, -0.150>, <0.9732, 5.0493, 30.2721>, <0.424, 0.897, -0.128>, <1.1733, 5.4663, 33.0831>, <0.378, 0.912, -0.156> }
	smooth_triangle { <1.1733, 5.4663, 33.0831>, <0.378, 0.912, -0.156>, <0.9732, 5.0493, 30.2721>, <0.424, 0.897, -0.128>, <1.0009, 5.0446, 30.2721>, <0.000, 0.992, -0.128> }
	smooth_triangle { <1.1733, 5.4663, 33.0831>, <0.378, 0.912, -0.156>, <1.0009, 5.0446, 30.2721>, <0.000, 0.992, -0.128>, <1.1912, 5.4615, 33.0831>, <0.028, 0.989, -0.143> }
	smooth_triangle { <1.1912, 5.4615, 33.0831>, <0.028, 0.989, -0.143>, <1.0009, 5.0446, 30.2721>, <0.000, 0.992, -0.128>, <1.0307, 5.0531, 30.2721>, <-0.389, 0.915, -0.108> }
	smooth_triangle { <1.1912, 5.4615, 33.0831>, <0.028, 0.989, -0.143>, <1.0307, 5.0531, 30.2721>, <-0.389, 0.915, -0.108>, <1.2088, 5.4649, 33.0831>, <-0.368, 0.923, -0.109> }
	smooth_triangle { <1.2088, 5.4649, 33.0831>, <-0.368, 0.923, -0.109>, <1.0307, 5.0531, 30.2721>, <-0.389, 0.915, -0.108>, <1.0472, 5.0634, 30.2721>, <-0.709, 0.701, -0.074> }
	smooth_triangle { <1.2088, 5.4649, 33.0831>, <-0.368, 0.923, -0.109>, <1.0472, 5.0634, 30.2721>, <-0.709, 0.701, -0.074>, <1.2247, 5.4744, 33.0831>, <-0.704, 0.707, -0.059> }
	smooth_triangle { <1.2247, 5.4744, 33.0831>, <-0.704, 0.707, -0.059>, <1.0472, 5.0634, 30.2721>, <-0.709, 0.701, -0.074>, <1.0624, 5.0866, 30.2721>, <-0.910, 0.412, -0.031> }
	smooth_triangle { <1.2247, 5.4744, 33.0831>, <-0.704, 0.707, -0.059>, <1.0624, 5.0866, 30.2721>, <-0.910, 0.412, -0.031>, <1.2350, 5.4890, 33.0831>, <-0.907, 0.422, -0.006> }
	smooth_triangle { <1.2350, 5.4890, 33.0831>, <-0.907, 0.422, -0.006>, <1.0624, 5.0866, 30.2721>, <-0.910, 0.412, -0.031>, <1.0676, 5.1131, 30.2721>, <-0.980, 0.199, 0.008> }
	smooth_triangle { <1.2350, 5.4890, 33.0831>, <-0.907, 0.422, -0.006>, <1.0676, 5.1131, 30.2721>, <-0.980, 0.199, 0.008>, <1.2386, 5.5058, 33.0831>, <-0.982, 0.187, 0.029> }
	smooth_triangle { <1.3639, 5.8255, 35.4963>, <-0.946, -0.311, 0.091>, <1.2386, 5.5058, 33.0831>, <-0.955, -0.282, 0.093>, <1.2315, 5.5236, 33.0831>, <-0.903, -0.417, 0.107> }
	smooth_triangle { <1.3639, 5.8255, 35.4963>, <-0.946, -0.311, 0.091>, <1.2315, 5.5236, 33.0831>, <-0.903, -0.417, 0.107>, <1.3616, 5.8347, 35.4963>, <-0.915, -0.391, 0.100> }
	smooth_triangle { <1.3616, 5.8347, 35.4963>, <-0.915, -0.391, 0.100>, <1.2315, 5.5236, 33.0831>, <-0.903, -0.417, 0.107>, <1.2246, 5.5377, 33.0831>, <-0.760, -0.637, 0.128> }
	smooth_triangle { <1.3616, 5.8347, 35.4963>, <-0.915, -0.391, 0.100>, <1.2246, 5.5377, 33.0831>, <-0.760, -0.637, 0.128>, <1.3564, 5.8441, 35.4963>, <-0.678, -0.723, 0.129> }
	smooth_triangle { <1.3564, 5.8441, 35.4963>, <-0.678, -0.723, 0.129>, <1.2246, 5.5377, 33.0831>, <-0.760, -0.637, 0.128>, <1.2089, 5.5491, 33.0831>, <-0.422, -0.896, 0.141> }
	smooth_triangle { <1.3564, 5.8441, 35.4963>, <-0.678, -0.723, 0.129>, <1.2089, 5.5491, 33.0831>, <-0.422, -0.896, 0.141>, <1.3454, 5.8511, 35.4963>, <-0.342, -0.930, 0.136> }
	smooth_triangle { <1.3454, 5.8511, 35.4963>, <-0.342, -0.930, 0.136>, <1.2089, 5.5491, 33.0831>, <-0.422, -0.896, 0.141>, <1.1921, 5.5535, 33.0831>, <-0.023, -0.992, 0.128> }
	smooth_triangle { <1.3454, 5.8511, 35.4963>, <-0.342, -0.930, 0.136>, <1.1921, 5.5535, 33.0831>, <-0.023, -0.992, 0.128>, <1.3351, 5.8536, 35.4963>, <0.113, -0.987, 0.115> }
	smooth_triangle { <1.3351, 5.8536, 35.4963>, <0.113, -0.987, 0.115>, <1.1921, 5.5535, 33.0831>, <-0.023, -0.992, 0.128>, <1.1731, 5.5505, 33.0831>, <0.411, -0.907, 0.089> }
	smooth_triangle { <1.3351, 5.8536, 35.4963>, <0.113, -0.987, 0.115>, <1.1731, 5.5505, 33.0831>, <0.411, -0.907, 0.089>, <1.3262, 5.8496, 35.4963>, <0.523, -0.849, 0.072> }
	smooth_triangle { <1.3262, 5.8496, 35.4963>, <0.523, -0.849, 0.072>, <1.1731, 5.5505, 33.0831>, <0.411, -0.907, 0.089>, <1.1594, 5.5407, 33.0831>, <0.723, -0.690, 0.039> }
	smooth_triangle { <1.3262, 5.8496, 35.4963>, <0.523, -0.849, 0.072>, <1.1594, 5.5407, 33.0831>, <0.723, -0.690, 0.039>, <1.3177, 5.8437, 35.4963>, <0.697, -0.716, 0.045> }
	smooth_triangle { <1.3177, 5.8437, 35.4963>, <0.697, -0.716, 0.045>, <1.1594, 5.5407, 33.0831>, <0.723, -0.690, 0.039>, <1.1493, 5.5269, 33.0831>, <0.892, -0.452, -0.004> }
	smooth_triangle { <1.3177, 5.8437, 35.4963>, <0.697, -0.716, 0.045>, <1.1493, 5.5269, 33.0831>, <0.892, -0.452, -0.004>, <1.3103, 5.8365, 35.4963>, <0.933, -0.359, -0.017> }
	smooth_triangle { <1.3103, 5.8365, 35.4963>, <0.933, -0.359, -0.017>, <1.1493, 5.5269, 33.0831>, <0.892, -0.452, -0.004>, <1.1446, 5.5094, 33.0831>, <0.997, -0.037, -0.067> }
	smooth_triangle { <1.3103, 5.8365, 35.4963>, <0.933, -0.359, -0.017>, <1.1446, 5.5094, 33.0831>, <0.997, -0.037, -0.067>, <1.3098, 5.8247, 35.4963>, <0.997, 0.020, -0.071> }
	smooth_triangle { <1.3098, 5.8247, 35.4963>, <0.997, 0.020, -0.071>, <1.1446, 5.5094, 33.0831>, <0.997, -0.037, -0.067>, <1.1465, 5.4874, 33.0831>, <0.909, 0.399, -0.121> }
	smooth_triangle { <1.3098, 5.8247, 35.4963>, <0.997, 0.020, -0.071>, <1.1465, 5.4874, 33.0831>, <0.909, 0.399, -0.121>, <1.3100, 5.8145, 35.4963>, <0.880, 0.460, -0.121> }
	smooth_triangle { <1.3100, 5.8145, 35.4963>, <0.880, 0.460, -0.121>, <1.1465, 5.4874, 33.0831>, <0.909, 0.399, -0.121>, <1.1586, 5.4765, 33.0831>, <0.661, 0.735, -0.150> }
	smooth_triangle { <1.3100, 5.8145, 35.4963>, <0.880, 0.460, -0.121>, <1.1586, 5.4765, 33.0831>, <0.661, 0.735, -0.150>, <1.3160, 5.8053, 35.4963>, <0.625, 0.767, -0.146> }
	smooth_triangle { <1.3160, 5.8053, 35.4963>, <0.625, 0.767, -0.146>, <1.1586, 5.4765, 33.0831>, <0.661, 0.735, -0.150>, <1.1733, 5.4663, 33.0831>, <0.378, 0.912, -0.156> }
	smooth_triangle { <1.3160, 5.8053, 35.4963>, <0.625, 0.767, -0.146>, <1.1733, 5.4663, 33.0831>, <0.378, 0.912, -0.156>, <1.3270, 5.7999, 35.4963>, <0.331, 0.932, -0.150> }
	smooth_triangle { <1.3270, 5.7999, 35.4963>, <0.331, 0.932, -0.150>, <1.1733, 5.4663, 33.0831>, <0.378, 0.912, -0.156>, <1.1912, 5.4615, 33.0831>, <0.028, 0.989, -0.143> }
	smooth_triangle { <1.3270, 5.7999, 35.4963>, <0.331, 0.932, -0.150>, <1.1912, 5.4615, 33.0831>, <0.028, 0.989, -0.143>, <1.3364, 5.7969, 35.4963>, <-0.049, 0.990, -0.135> }
	smooth_triangle { <1.3364, 5.7969, 35.4963>, <-0.049, 0.990, -0.135>, <1.1912, 5.4615, 33.0831>, <0.028, 0.989, -0.143>, <1.2088, 5.4649, 33.0831>, <-0.368, 0.923, -0.109> }
	smooth_triangle { <1.3364, 5.7969, 35.4963>, <-0.049, 0.990, -0.135>, <1.2088, 5.4649, 33.0831>, <-0.368, 0.923, -0.109>, <1.3473, 5.7998, 35.4963>, <-0.480, 0.872, -0.094> }
	smooth_triangle { <1.3473, 5.7998, 35.4963>, <-0.480, 0.872, -0.094>, <1.2088, 5.4649, 33.0831>, <-0.368, 0.923, -0.109>, <1.2247, 5.4744, 33.0831>, <-0.704, 0.707, -0.059> }
	smooth_triangle { <1.3473, 5.7998, 35.4963>, <-0.480, 0.872, -0.094>, <1.2247, 5.4744, 33.0831>, <-0.704, 0.707, -0.059>, <1.3555, 5.8069, 35.4963>, <-0.732, 0.679, -0.053> }
	smooth_triangle { <1.3555, 5.8069, 35.4963>, <-0.732, 0.679, -0.053>, <1.2247, 5.4744, 33.0831>, <-0.704, 0.707, -0.059>, <1.2350, 5.4890, 33.0831>, <-0.907, 0.422, -0.006> }
	smooth_triangle { <1.3555, 5.8069, 35.4963>, <-0.732, 0.679, -0.053>, <1.2350, 5.4890, 33.0831>, <-0.907, 0.422, -0.006>, <1.3623, 5.8139, 35.4963>, <-0.931, 0.364, 0.000> }
	smooth_triangle { <1.3623, 5.8139, 35.4963>, <-0.931, 0.364, 0.000>, <1.2350, 5.4890, 33.0831>, <-0.907, 0.422, -0.006>, <1.2386, 5.5058, 33.0831>, <-0.982, 0.187, 0.029> }
	smooth_triangle { <1.3623, 5.8139, 35.4963>, <-0.931, 0.364, 0.000>, <1.2386, 5.5058, 33.0831>, <-0.982, 0.187, 0.029>, <1.3639, 5.8255, 35.4963>, <-0.990, 0.139, 0.033> }
	triangle { <1.3632, 5.8258, 35.4963>, <1.3639, 5.8255, 35.4963>, <1.3616, 5.8347, 35.4963> }
	triangle { <1.3632, 5.8258, 35.4963>, <1.3616, 5.8347, 35.4963>, <1.3553, 5.8458, 35.4963> }
	triangle { <1.3616, 5.8347, 35.4963>, <1.3564, 5.8441, 35.4963>, <1.3553, 5.8458, 35.4963> }
	triangle { <1.3553, 5.8458, 35.4963>, <1.3564, 5.8441, 35.4963>, <1.3454, 5.8511, 35.4963> }
	triangle { <1.3553, 5.8458, 35.4963>, <1.3454, 5.8511, 35.4963>, <1.3355, 5.8541, 35.4963> }
	triangle { <1.3454, 5.8511, 35.4963>, <1.3351, 5.8536, 35.4963>, <1.3355, 5.8541, 35.4963> }
	triangle { <1.3355, 5.8541, 35.4963>, <1.3351, 5.8536, 35.4963>, <1.3262, 5.8496, 35.4963> }
	triangle { <1.3355, 5.8541, 35.4963>, <1.3262, 5.8496, 35.4963>, <1.3172, 5.8442, 35.4963> }
	triangle { <1.3262, 5.8496, 35.4963>, <1.3177, 5.8437, 35.4963>, <1.3172, 5.8442, 35.4963> }
	triangle { <1.3172, 5.8442, 35.4963>, <1.3177, 5.8437, 35.4963>, <1.3103, 5.8365, 35.4963> }
	triangle { <1.3172, 5.8442, 35.4963>, <1.3103, 5.8365, 35.4963>, <1.3094, 5.8259, 35.4963> }
	triangle { <1.3103, 5.8365, 35.4963>, <1.3098, 5.8247, 35.4963>, <1.3094, 5.8259, 35.4963> }
	triangle { <1.3094, 5.8259, 35.4963>, <1.3098, 5.8247, 35.4963>, <1.3100, 5.8145, 35.4963> }
	triangle { <1.3094, 5.8259, 35.4963>, <1.3100, 5.8145, 35.4963>, <1.3178, 5.8064, 35.4963> }
	triangle { <1.3100, 5.8145, 35.4963>, <1.3160, 5.8053, 35.4963>, <1.3178, 5.8064, 35.4963> }
	triangle { <1.3178, 5.8064, 35.4963>, <1.3160, 5.8053, 35.4963>, <1.3270, 5.7999, 35.4963> }
	triangle { <1.3178, 5.8064, 35.4963>, <1.3270, 5.7999, 35.4963>, <1.3363, 5.7978, 35.4963> }
	triangle { <1.3270, 5.7999, 35.4963>, <1.3364, 5.7969, 35.4963>, <1.3363, 5.7978, 35.4963> }
	triangle { <1.3363, 5.7978, 35.4963>, <1.3364, 5.7969, 35.4963>, <1.3473, 5.7998, 35.4963> }
	triangle { <1.3363, 5.7978, 35.4963>, <1.3473, 5.7998, 35.4963>, <1.3560, 5.8048, 35.4963> }
	triangle { <1.3473, 5.7998, 35.4963>, <1.3555, 5.8069, 35.4963>, <1.3560, 5.8048, 35.4963> }
	triangle { <1.3560, 5.8048, 35.4963>, <1.3555, 5.8069, 35.4963>, <1.3623, 5.8139, 35.4963> }
	triangle { <1.3560, 5.8048, 35.4963>, <1.3623, 5.8139, 35.4963>, <1.3632, 5.8258, 35.4963> }
	triangle { <1.3623, 5.8139, 35.4963>, <1.3639, 5.8255, 35.4963>, <1.3632, 5.8258, 35.4963> }
	triangle { <1.3586, 5.8399, 35.4963>, <1.3632, 5.8258, 35.4963>, <1.3553, 5.8458, 35.4963> }
	triangle { <1.3586, 5.8399, 35.4963>, <1.3553, 5.8458, 35.4963>, <1.3370, 5.8535, 35.4963> }
	triangle { <1.3370, 5.8535, 35.4963>, <1.3553, 5.8458, 35.4963>, <1.3355, 5.8541, 35.4963> }
	triangle { <1.3370, 5.8535, 35.4963>, <1.3355, 5.8541, 35.4963>, <1.3172, 5.8442, 35.4963> }
	triangle { <1.3370, 5.8535, 35.4963>, <1.3172, 5.8442, 35.4963>, <1.3117, 5.8380, 35.4963> }
	triangle { <1.3117, 5.8380, 35.4963>, <1.3172, 5.8442, 35.4963>, <1.3094, 5.8259, 35.4963> }
	triangle { <1.3117, 5.8380, 35.4963>, <1.3094, 5.8259, 35.4963>, <1.3123, 5.8107, 35.4963> }
	triangle { <1.3123, 5.8107, 35.4963>, <1.3094, 5.8259, 35.4963>, <1.3178, 5.8064, 35.4963> }
	triangle { <1.3123, 5.8107, 35.4963>, <1.3178, 5.8064, 35.4963>, <1.3374, 5.7973, 35.4963> }
	triangle { <1.3374, 5.7973, 35.4963>, <1.3178, 5.8064, 35.4963>, <1.3363, 5.7978, 35.4963> }
	triangle { <1.3374, 5.7973, 35.4963>, <1.3363, 5.7978, 35.4963>, <1.3560, 5.8048, 35.4963> }
	triangle { <1.3374, 5.7973, 35.4963>, <1.3560, 5.8048, 35.4963>, <1.3609, 5.8120, 35.4963> }
	triangle { <1.3609, 5.8120, 35.4963>, <1.3560, 5.8048, 35.4963>, <1.3632, 5.8258, 35.4963> }
	triangle { <1.3609, 5.8120, 35.4963>, <1.3632, 5.8258, 35.4963>, <1.3586, 5.8399, 35.4963> }
	smooth_triangle { <1.3904, 5.9098, 36.7116>, <-0.065, -0.994, 0.086>, <1.3586, 5.8399, 35.4963>, <-0.533, -0.844, 0.063>, <1.3370, 5.8535, 35.4963>, <0.060, -0.997, 0.046> }
	smooth_triangle { <1.3904, 5.9098, 36.7116>, <-0.065, -0.994, 0.086>, <1.3370, 5.8535, 35.4963>, <0.060, -0.997, 0.046>, <1.3654, 5.9055, 36.7128>, <-0.097, -0.989, 0.111> }
	smooth_triangle { <1.3654, 5.9055, 36.7128>, <0.261, -0.961, 0.089>, <1.3370, 5.8535, 35.4963>, <0.060, -0.997, 0.046>, <1.3117, 5.8380, 35.4963>, <0.877, -0.480, -0.005> }
	smooth_triangle { <1.3654, 5.9055, 36.7128>, <-0.234, -0.964, 0.124>, <1.3117, 5.8380, 35.4963>, <-0.765, -0.640, 0.069>, <1.3491, 5.9249, 36.7116>, <-0.958, -0.275, 0.082> }
	smooth_triangle { <1.3491, 5.9249, 36.7116>, <0.999, 0.021, -0.032>, <1.3117, 5.8380, 35.4963>, <0.877, -0.480, -0.005>, <1.3123, 5.8107, 35.4963>, <0.850, 0.520, -0.087> }
	smooth_triangle { <1.3491, 5.9249, 36.7116>, <-0.958, -0.275, 0.082>, <1.3123, 5.8107, 35.4963>, <-0.940, 0.342, -0.004>, <1.3577, 5.9487, 36.7093>, <-0.725, 0.687, -0.060> }
	smooth_triangle { <1.3577, 5.9487, 36.7093>, <0.041, 0.990, -0.133>, <1.3123, 5.8107, 35.4963>, <0.850, 0.520, -0.087>, <1.3374, 5.7973, 35.4963>, <-0.086, 0.989, -0.119> }
	smooth_triangle { <1.3577, 5.9487, 36.7093>, <-0.569, 0.818, -0.080>, <1.3374, 5.7973, 35.4963>, <-0.086, 0.989, -0.119>, <1.3827, 5.9530, 36.7082>, <0.096, 0.985, -0.143> }
	smooth_triangle { <1.3827, 5.9530, 36.7082>, <-0.263, 0.957, -0.126>, <1.3374, 5.7973, 35.4963>, <-0.086, 0.989, -0.119>, <1.3609, 5.8120, 35.4963>, <-0.894, 0.447, -0.029> }
	smooth_triangle { <1.3827, 5.9530, 36.7082>, <0.233, 0.961, -0.147>, <1.3609, 5.8120, 35.4963>, <0.765, 0.638, -0.088>, <1.3991, 5.9336, 36.7093>, <0.957, 0.275, -0.089> }
	smooth_triangle { <1.3991, 5.9336, 36.7093>, <-0.996, -0.084, 0.040>, <1.3609, 5.8120, 35.4963>, <-0.894, 0.447, -0.029>, <1.3586, 5.8399, 35.4963>, <-0.996, -0.084, 0.040> }
	smooth_triangle { <1.3991, 5.9336, 36.7093>, <0.957, 0.275, -0.089>, <1.3586, 5.8399, 35.4963>, <0.939, -0.343, -0.005>, <1.3904, 5.9098, 36.7116>, <0.937, -0.349, -0.003> }
	smooth_triangle { <1.4636, 6.0996, 37.9147>, <0.168, -0.963, 0.209>, <1.3904, 5.9098, 36.7116>, <-0.065, -0.994, 0.086>, <1.3654, 5.9055, 36.7128>, <-0.097, -0.989, 0.111> }
	smooth_triangle { <1.4636, 6.0996, 37.9147>, <0.168, -0.963, 0.209>, <1.3654, 5.9055, 36.7128>, <-0.097, -0.989, 0.111>, <1.4385, 6.0958, 37.9168>, <-0.325, -0.907, 0.269> }
	smooth_triangle { <1.4385, 6.0958, 37.9168>, <-0.325, -0.907, 0.269>, <1.3654, 5.9055, 36.7128>, <-0.234, -0.964, 0.124>, <1.3491, 5.9249, 36.7116>, <-0.958, -0.275, 0.082> }
	smooth_triangle { <1.4385, 6.0958, 37.9168>, <-0.325, -0.907, 0.269>, <1.3491, 5.9249, 36.7116>, <-0.958, -0.275, 0.082>, <1.4225, 6.1154, 37.9147>, <-0.978, -0.160, 0.137> }
	smooth_triangle { <1.4225, 6.1154, 37.9147>, <-0.978, -0.160, 0.137>, <1.3491, 5.9249, 36.7116>, <-0.958, -0.275, 0.082>, <1.3577, 5.9487, 36.7093>, <-0.725, 0.687, -0.060> }
	smooth_triangle { <1.4225, 6.1154, 37.9147>, <-0.978, -0.160, 0.137>, <1.3577, 5.9487, 36.7093>, <-0.725, 0.687, -0.060>, <1.4316, 6.1388, 37.9104>, <-0.653, 0.746, -0.132> }
	smooth_triangle { <1.4316, 6.1388, 37.9104>, <-0.653, 0.746, -0.132>, <1.3577, 5.9487, 36.7093>, <-0.569, 0.818, -0.080>, <1.3827, 5.9530, 36.7082>, <0.096, 0.985, -0.143> }
	smooth_triangle { <1.4316, 6.1388, 37.9104>, <-0.653, 0.746, -0.132>, <1.3827, 5.9530, 36.7082>, <0.096, 0.985, -0.143>, <1.4566, 6.1425, 37.9083>, <0.325, 0.907, -0.268> }
	smooth_triangle { <1.4566, 6.1425, 37.9083>, <0.325, 0.907, -0.268>, <1.3827, 5.9530, 36.7082>, <0.233, 0.961, -0.147>, <1.3991, 5.9336, 36.7093>, <0.957, 0.275, -0.089> }
	smooth_triangle { <1.4566, 6.1425, 37.9083>, <0.325, 0.907, -0.268>, <1.3991, 5.9336, 36.7093>, <0.957, 0.275, -0.089>, <1.4726, 6.1229, 37.9104>, <0.978, 0.160, -0.136> }
	smooth_triangle { <1.4726, 6.1229, 37.9104>, <0.978, 0.160, -0.136>, <1.3991, 5.9336, 36.7093>, <0.957, 0.275, -0.089>, <1.3904, 5.9098, 36.7116>, <0.937, -0.349, -0.003> }
	smooth_triangle { <1.4726, 6.1229, 37.9104>, <0.978, 0.160, -0.136>, <1.3904, 5.9098, 36.7116>, <0.937, -0.349, -0.003>, <1.4636, 6.0996, 37.9147>, <0.949, -0.314, 0.017> }
	smooth_triangle { <1.5325, 6.3890, 38.6750>, <0.259, -0.916, 0.307>, <1.4636, 6.0996, 37.9147>, <0.168, -0.963, 0.209>, <1.4385, 6.0958, 37.9168>, <-0.325, -0.907, 0.269> }
	smooth_triangle { <1.5325, 6.3890, 38.6750>, <0.259, -0.916, 0.307>, <1.4385, 6.0958, 37.9168>, <-0.325, -0.907, 0.269>, <1.5084, 6.3824, 38.6796>, <-0.166, -0.932, 0.323> }
	smooth_triangle { <1.5084, 6.3824, 38.6796>, <-0.347, -0.885, 0.311>, <1.4385, 6.0958, 37.9168>, <-0.325, -0.907, 0.269>, <1.4225, 6.1154, 37.9147>, <-0.978, -0.160, 0.137> }
	smooth_triangle { <1.5084, 6.3824, 38.6796>, <-0.347, -0.885, 0.311>, <1.4225, 6.1154, 37.9147>, <-0.978, -0.160, 0.137>, <1.4896, 6.3989, 38.6750>, <-0.938, -0.328, 0.110> }
	smooth_triangle { <1.4896, 6.3989, 38.6750>, <-0.986, -0.149, 0.072>, <1.4225, 6.1154, 37.9147>, <-0.978, -0.160, 0.137>, <1.4316, 6.1388, 37.9104>, <-0.653, 0.746, -0.132> }
	smooth_triangle { <1.4896, 6.3989, 38.6750>, <-0.986, -0.149, 0.072>, <1.4316, 6.1388, 37.9104>, <-0.653, 0.746, -0.132>, <1.4949, 6.4220, 38.6658>, <-0.768, 0.604, -0.212> }
	smooth_triangle { <1.4949, 6.4220, 38.6658>, <-0.635, 0.736, -0.235>, <1.4316, 6.1388, 37.9104>, <-0.653, 0.746, -0.132>, <1.4566, 6.1425, 37.9083>, <0.325, 0.907, -0.268> }
	smooth_triangle { <1.4949, 6.4220, 38.6658>, <-0.635, 0.736, -0.235>, <1.4566, 6.1425, 37.9083>, <0.325, 0.907, -0.268>, <1.5190, 6.4286, 38.6612>, <0.167, 0.933, -0.320> }
	smooth_triangle { <1.5190, 6.4286, 38.6612>, <0.348, 0.887, -0.304>, <1.4566, 6.1425, 37.9083>, <0.325, 0.907, -0.268>, <1.4726, 6.1229, 37.9104>, <0.978, 0.160, -0.136> }
	smooth_triangle { <1.5190, 6.4286, 38.6612>, <0.348, 0.887, -0.304>, <1.4726, 6.1229, 37.9104>, <0.978, 0.160, -0.136>, <1.5378, 6.4121, 38.6658>, <0.938, 0.329, -0.107> }
	smooth_triangle { <1.5378, 6.4121, 38.6658>, <0.986, 0.151, -0.065>, <1.4726, 6.1229, 37.9104>, <0.978, 0.160, -0.136>, <1.4636, 6.0996, 37.9147>, <0.949, -0.314, 0.017> }
	smooth_triangle { <1.5378, 6.4121, 38.6658>, <0.986, 0.151, -0.065>, <1.4636, 6.0996, 37.9147>, <0.949, -0.314, 0.017>, <1.5325, 6.3890, 38.6750>, <0.998, -0.054, 0.038> }
	smooth_triangle { <1.4851, 6.6053, 39.4581>, <0.577, -0.786, 0.221>, <1.5325, 6.3890, 38.6750>, <0.259, -0.916, 0.307>, <1.5084, 6.3824, 38.6796>, <-0.166, -0.932, 0.323> }
	smooth_triangle { <1.4851, 6.6053, 39.4581>, <0.577, -0.786, 0.221>, <1.5084, 6.3824, 38.6796>, <0.443, -0.854, 0.272>, <1.4669, 6.5879, 39.4615>, <0.472, -0.859, 0.197> }
	smooth_triangle { <1.4669, 6.5879, 39.4615>, <-0.415, -0.898, 0.149>, <1.5084, 6.3824, 38.6796>, <-0.347, -0.885, 0.311>, <1.4896, 6.3989, 38.6750>, <-0.938, -0.328, 0.110> }
	smooth_triangle { <1.4669, 6.5879, 39.4615>, <0.043, -0.979, 0.198>, <1.4896, 6.3989, 38.6750>, <-0.554, -0.799, 0.234>, <1.4425, 6.5944, 39.4581>, <-0.521, -0.850, 0.077> }
	smooth_triangle { <1.4425, 6.5944, 39.4581>, <-0.991, -0.114, -0.066>, <1.4896, 6.3989, 38.6750>, <-0.986, -0.149, 0.072>, <1.4949, 6.4220, 38.6658>, <-0.768, 0.604, -0.212> }
	smooth_triangle { <1.4425, 6.5944, 39.4581>, <-0.839, -0.544, 0.021>, <1.4949, 6.4220, 38.6658>, <-0.998, 0.054, -0.040>, <1.4364, 6.6181, 39.4515>, <-0.993, 0.010, -0.120> }
	smooth_triangle { <1.4364, 6.6181, 39.4515>, <-0.576, 0.790, -0.210>, <1.4949, 6.4220, 38.6658>, <-0.635, 0.736, -0.235>, <1.5190, 6.4286, 38.6612>, <0.167, 0.933, -0.320> }
	smooth_triangle { <1.4364, 6.6181, 39.4515>, <-0.883, 0.438, -0.171>, <1.5190, 6.4286, 38.6612>, <-0.443, 0.854, -0.274>, <1.4547, 6.6354, 39.4482>, <-0.472, 0.859, -0.198> }
	smooth_triangle { <1.4547, 6.6354, 39.4482>, <0.414, 0.900, -0.138>, <1.5190, 6.4286, 38.6612>, <0.348, 0.887, -0.304>, <1.5378, 6.4121, 38.6658>, <0.938, 0.329, -0.107> }
	smooth_triangle { <1.4547, 6.6354, 39.4482>, <-0.044, 0.981, -0.187>, <1.5378, 6.4121, 38.6658>, <0.554, 0.798, -0.236>, <1.4790, 6.6290, 39.4515>, <0.521, 0.850, -0.079> }
	smooth_triangle { <1.4790, 6.6290, 39.4515>, <0.990, 0.118, 0.076>, <1.5378, 6.4121, 38.6658>, <0.986, 0.151, -0.065>, <1.5325, 6.3890, 38.6750>, <0.998, -0.054, 0.038> }
	smooth_triangle { <1.4790, 6.6290, 39.4515>, <0.837, 0.546, -0.011>, <1.5325, 6.3890, 38.6750>, <0.998, -0.054, 0.038>, <1.4851, 6.6053, 39.4581>, <0.878, 0.478, 0.030> }
	smooth_triangle { <1.3851, 6.6888, 40.2608>, <0.912, -0.283, 0.296>, <1.4851, 6.6053, 39.4581>, <0.577, -0.786, 0.221>, <1.4669, 6.5879, 39.4615>, <0.472, -0.859, 0.197> }
	smooth_triangle { <1.3851, 6.6888, 40.2608>, <0.912, -0.283, 0.296>, <1.4669, 6.5879, 39.4615>, <0.841, -0.513, 0.172>, <1.3833, 6.6636, 40.2626>, <0.880, -0.311, 0.360> }
	smooth_triangle { <1.3833, 6.6636, 40.2626>, <0.215, -0.971, 0.103>, <1.4669, 6.5879, 39.4615>, <0.043, -0.979, 0.198>, <1.4425, 6.5944, 39.4581>, <-0.521, -0.850, 0.077> }
	smooth_triangle { <1.3833, 6.6636, 40.2626>, <0.632, -0.735, 0.247>, <1.4425, 6.5944, 39.4581>, <-0.036, -0.990, 0.138>, <1.3606, 6.6523, 40.2608>, <0.198, -0.978, 0.065> }
	smooth_triangle { <1.3606, 6.6523, 40.2608>, <-0.710, -0.681, -0.181>, <1.4425, 6.5944, 39.4581>, <-0.839, -0.544, 0.021>, <1.4364, 6.6181, 39.4515>, <-0.993, 0.010, -0.120> }
	smooth_triangle { <1.3606, 6.6523, 40.2608>, <-0.286, -0.956, -0.071>, <1.4364, 6.6181, 39.4515>, <-0.878, -0.478, -0.037>, <1.3398, 6.6663, 40.2571>, <-0.681, -0.670, -0.297> }
	smooth_triangle { <1.3398, 6.6663, 40.2571>, <-0.919, 0.286, -0.271>, <1.4364, 6.6181, 39.4515>, <-0.883, 0.438, -0.171>, <1.4547, 6.6354, 39.4482>, <-0.472, 0.859, -0.198> }
	smooth_triangle { <1.3398, 6.6663, 40.2571>, <-0.927, -0.215, -0.306>, <1.4547, 6.6354, 39.4482>, <-0.840, 0.513, -0.178>, <1.3416, 6.6915, 40.2552>, <-0.879, 0.318, -0.355> }
	smooth_triangle { <1.3416, 6.6915, 40.2552>, <-0.219, 0.974, -0.067>, <1.4547, 6.6354, 39.4482>, <-0.044, 0.981, -0.187>, <1.4790, 6.6290, 39.4515>, <0.521, 0.850, -0.079> }
	smooth_triangle { <1.3416, 6.6915, 40.2552>, <-0.643, 0.736, -0.211>, <1.4790, 6.6290, 39.4515>, <0.037, 0.989, -0.146>, <1.3642, 6.7028, 40.2571>, <-0.196, 0.979, -0.054> }
	smooth_triangle { <1.3642, 6.7028, 40.2571>, <0.704, 0.679, 0.210>, <1.4790, 6.6290, 39.4515>, <0.837, 0.546, -0.011>, <1.4851, 6.6053, 39.4581>, <0.878, 0.478, 0.030> }
	smooth_triangle { <1.3642, 6.7028, 40.2571>, <0.278, 0.954, 0.110>, <1.4851, 6.6053, 39.4581>, <0.878, 0.478, 0.030>, <1.3851, 6.6888, 40.2608>, <0.250, 0.955, 0.161> }
	smooth_triangle { <1.1561, 6.6253, 40.6061>, <0.618, 0.487, 0.617>, <1.3851, 6.6888, 40.2608>, <0.912, -0.283, 0.296>, <1.3833, 6.6636, 40.2626>, <0.880, -0.311, 0.360> }
	smooth_triangle { <1.1561, 6.6253, 40.6061>, <0.434, 0.726, 0.534>, <1.3833, 6.6636, 40.2626>, <0.881, 0.241, 0.408>, <1.1737, 6.6083, 40.6130>, <0.684, 0.255, 0.684> }
	smooth_triangle { <1.1737, 6.6083, 40.6130>, <0.709, -0.512, 0.486>, <1.3833, 6.6636, 40.2626>, <0.632, -0.735, 0.247>, <1.3606, 6.6523, 40.2608>, <0.198, -0.978, 0.065> }
	smooth_triangle { <1.1737, 6.6083, 40.6130>, <0.749, -0.007, 0.663>, <1.3606, 6.6523, 40.2608>, <0.638, -0.731, 0.243>, <1.1713, 6.5840, 40.6061>, <0.619, -0.693, 0.369> }
	smooth_triangle { <1.1713, 6.5840, 40.6061>, <0.068, -0.990, -0.124>, <1.3606, 6.6523, 40.2608>, <-0.286, -0.956, -0.071>, <1.3398, 6.6663, 40.2571>, <-0.681, -0.670, -0.297> }
	smooth_triangle { <1.1713, 6.5840, 40.6061>, <0.452, -0.861, 0.233>, <1.3398, 6.6663, 40.2571>, <-0.241, -0.955, -0.174>, <1.1513, 6.5767, 40.5922>, <-0.068, -0.947, -0.313> }
	smooth_triangle { <1.1513, 6.5767, 40.5922>, <-0.637, -0.491, -0.594>, <1.3398, 6.6663, 40.2571>, <-0.927, -0.215, -0.306>, <1.3416, 6.6915, 40.2552>, <-0.879, 0.318, -0.355> }
	smooth_triangle { <1.1513, 6.5767, 40.5922>, <-0.295, -0.860, -0.415>, <1.3416, 6.6915, 40.2552>, <-0.875, -0.232, -0.426>, <1.1338, 6.5936, 40.5852>, <-0.690, -0.256, -0.677> }
	smooth_triangle { <1.1338, 6.5936, 40.5852>, <-0.728, 0.517, -0.450>, <1.3416, 6.6915, 40.2552>, <-0.643, 0.736, -0.211>, <1.3642, 6.7028, 40.2571>, <-0.196, 0.979, -0.054> }
	smooth_triangle { <1.1338, 6.5936, 40.5852>, <-0.768, 0.003, -0.640>, <1.3642, 6.7028, 40.2571>, <-0.627, 0.740, -0.244>, <1.1362, 6.6180, 40.5922>, <-0.627, 0.690, -0.363> }
	smooth_triangle { <1.1362, 6.6180, 40.5922>, <-0.084, 0.984, 0.158>, <1.3642, 6.7028, 40.2571>, <0.278, 0.954, 0.110>, <1.3851, 6.6888, 40.2608>, <0.250, 0.955, 0.161> }
	smooth_triangle { <1.1362, 6.6180, 40.5922>, <-0.473, 0.856, -0.209>, <1.3851, 6.6888, 40.2608>, <0.250, 0.955, 0.161>, <1.1561, 6.6253, 40.6061>, <-0.321, 0.946, -0.038> }
	smooth_triangle { <0.8412, 6.5186, 40.8455>, <0.292, 0.639, 0.711>, <1.1561, 6.6253, 40.6061>, <0.434, 0.726, 0.534>, <1.1737, 6.6083, 40.6130>, <0.684, 0.255, 0.684> }
	smooth_triangle { <0.8412, 6.5186, 40.8455>, <0.579, -0.292, 0.761>, <1.1737, 6.6083, 40.6130>, <0.749, -0.007, 0.663>, <1.1713, 6.5840, 40.6061>, <0.619, -0.693, 0.369> }
	smooth_triangle { <0.8412, 6.5186, 40.8455>, <0.243, -0.963, 0.118>, <1.1713, 6.5840, 40.6061>, <0.452, -0.861, 0.233>, <1.1513, 6.5767, 40.5922>, <-0.068, -0.947, -0.313> }
	smooth_triangle { <0.8412, 6.5186, 40.8455>, <-0.403, -0.684, -0.608>, <1.1513, 6.5767, 40.5922>, <-0.295, -0.860, -0.415>, <1.1338, 6.5936, 40.5852>, <-0.690, -0.256, -0.677> }
	smooth_triangle { <0.8412, 6.5186, 40.8455>, <-0.697, 0.268, -0.665>, <1.1338, 6.5936, 40.5852>, <-0.768, 0.003, -0.640>, <1.1362, 6.6180, 40.5922>, <-0.627, 0.690, -0.363> }
	smooth_triangle { <0.8412, 6.5186, 40.8455>, <-0.350, 0.937, 0.002>, <1.1362, 6.6180, 40.5922>, <-0.473, 0.856, -0.209>, <1.1561, 6.6253, 40.6061>, <0.201, 0.880, 0.430> }
	smooth_triangle { <1.1981, 6.7664, 39.7248>, <0.719, 0.202, 0.665>, <1.4778, 6.6278, 39.4646>, <0.719, 0.202, 0.665>, <1.4754, 6.6045, 39.4743>, <0.647, -0.110, 0.754> }
	smooth_triangle { <1.1981, 6.7664, 39.7248>, <0.719, 0.202, 0.665>, <1.4754, 6.6045, 39.4743>, <0.647, -0.110, 0.754>, <1.1956, 6.7431, 39.7345>, <0.479, -0.448, 0.754> }
	smooth_triangle { <1.1956, 6.7431, 39.7345>, <0.479, -0.448, 0.754>, <1.4754, 6.6045, 39.4743>, <0.647, -0.110, 0.754>, <1.4583, 6.5884, 39.4646>, <0.040, -0.863, 0.503> }
	smooth_triangle { <1.1956, 6.7431, 39.7345>, <0.479, -0.448, 0.754>, <1.4583, 6.5884, 39.4646>, <0.040, -0.863, 0.503>, <1.1786, 6.7270, 39.7248>, <-0.232, -0.940, 0.251> }
	smooth_triangle { <1.1786, 6.7270, 39.7248>, <-0.232, -0.940, 0.251>, <1.4583, 6.5884, 39.4646>, <0.040, -0.863, 0.503>, <1.4437, 6.5956, 39.4450>, <-0.607, -0.754, -0.251> }
	smooth_triangle { <1.1786, 6.7270, 39.7248>, <-0.232, -0.940, 0.251>, <1.4437, 6.5956, 39.4450>, <-0.607, -0.754, -0.251>, <1.1640, 6.7342, 39.7052>, <-0.711, -0.491, -0.503> }
	smooth_triangle { <1.1640, 6.7342, 39.7052>, <-0.711, -0.491, -0.503>, <1.4437, 6.5956, 39.4450>, <-0.607, -0.754, -0.251>, <1.4462, 6.6189, 39.4353>, <-0.647, 0.110, -0.754> }
	smooth_triangle { <1.1640, 6.7342, 39.7052>, <-0.711, -0.491, -0.503>, <1.4462, 6.6189, 39.4353>, <-0.647, 0.110, -0.754>, <1.1665, 6.7575, 39.6955>, <-0.479, 0.448, -0.754> }
	smooth_triangle { <1.1665, 6.7575, 39.6955>, <-0.479, 0.448, -0.754>, <1.4462, 6.6189, 39.4353>, <-0.647, 0.110, -0.754>, <1.4633, 6.6350, 39.4450>, <-0.040, 0.863, -0.503> }
	smooth_triangle { <1.1665, 6.7575, 39.6955>, <-0.479, 0.448, -0.754>, <1.4633, 6.6350, 39.4450>, <-0.040, 0.863, -0.503>, <1.1835, 6.7736, 39.7052>, <0.232, 0.940, -0.251> }
	smooth_triangle { <1.1835, 6.7736, 39.7052>, <0.232, 0.940, -0.251>, <1.4633, 6.6350, 39.4450>, <-0.040, 0.863, -0.503>, <1.4778, 6.6278, 39.4646>, <0.444, 0.896, 0.000> }
	smooth_triangle { <1.1835, 6.7736, 39.7052>, <0.232, 0.940, -0.251>, <1.4778, 6.6278, 39.4646>, <0.444, 0.896, 0.000>, <1.1981, 6.7664, 39.7248>, <0.444, 0.896, 0.000> }
	smooth_triangle { <1.4797, 6.9622, 39.6611>, <0.504, -0.411, 0.760>, <1.4828, 6.6058, 39.4659>, <0.504, -0.411, 0.760>, <1.4609, 6.5995, 39.4771>, <0.193, -0.470, 0.861> }
	smooth_triangle { <1.4797, 6.9622, 39.6611>, <0.504, -0.411, 0.760>, <1.4609, 6.5995, 39.4771>, <0.193, -0.470, 0.861>, <1.4578, 6.9560, 39.6722>, <-0.185, -0.473, 0.861> }
	smooth_triangle { <1.4578, 6.9560, 39.6722>, <-0.185, -0.473, 0.861>, <1.4609, 6.5995, 39.4771>, <0.193, -0.470, 0.861>, <1.4388, 6.6054, 39.4659>, <-0.753, -0.321, 0.574> }
	smooth_triangle { <1.4578, 6.9560, 39.6722>, <-0.185, -0.473, 0.861>, <1.4388, 6.6054, 39.4659>, <-0.753, -0.321, 0.574>, <1.4357, 6.9619, 39.6611>, <-0.943, -0.165, 0.287> }
	smooth_triangle { <1.4357, 6.9619, 39.6611>, <-0.943, -0.165, 0.287>, <1.4388, 6.6054, 39.4659>, <-0.753, -0.321, 0.574>, <1.4387, 6.6176, 39.4437>, <-0.946, 0.149, -0.287> }
	smooth_triangle { <1.4357, 6.9619, 39.6611>, <-0.943, -0.165, 0.287>, <1.4387, 6.6176, 39.4437>, <-0.946, 0.149, -0.287>, <1.4356, 6.9741, 39.6388>, <-0.759, 0.308, -0.574> }
	smooth_triangle { <1.4356, 6.9741, 39.6388>, <-0.759, 0.308, -0.574>, <1.4387, 6.6176, 39.4437>, <-0.946, 0.149, -0.287>, <1.4607, 6.6239, 39.4325>, <-0.193, 0.470, -0.861> }
	smooth_triangle { <1.4356, 6.9741, 39.6388>, <-0.759, 0.308, -0.574>, <1.4607, 6.6239, 39.4325>, <-0.193, 0.470, -0.861>, <1.4575, 6.9803, 39.6277>, <0.185, 0.473, -0.861> }
	smooth_triangle { <1.4575, 6.9803, 39.6277>, <0.185, 0.473, -0.861>, <1.4607, 6.6239, 39.4325>, <-0.193, 0.470, -0.861>, <1.4827, 6.6180, 39.4437>, <0.753, 0.321, -0.574> }
	smooth_triangle { <1.4575, 6.9803, 39.6277>, <0.185, 0.473, -0.861>, <1.4827, 6.6180, 39.4437>, <0.753, 0.321, -0.574>, <1.4796, 6.9744, 39.6388>, <0.943, 0.165, -0.287> }
	smooth_triangle { <1.4796, 6.9744, 39.6388>, <0.943, 0.165, -0.287>, <1.4827, 6.6180, 39.4437>, <0.753, 0.321, -0.574>, <1.4828, 6.6058, 39.4659>, <1.000, 0.009, 0.000> }
	smooth_triangle { <1.4796, 6.9744, 39.6388>, <0.943, 0.165, -0.287>, <1.4828, 6.6058, 39.4659>, <1.000, 0.009, 0.000>, <1.4797, 6.9622, 39.6611>, <1.000, 0.009, 0.000> }
	smooth_triangle { <1.5120, 6.4519, 39.8258>, <-0.785, 0.490, 0.379>, <1.4360, 6.6126, 39.4604>, <-0.785, 0.490, 0.379>, <1.4510, 6.6323, 39.4659>, <-0.548, 0.718, 0.429> }
	smooth_triangle { <1.5120, 6.4519, 39.8258>, <-0.785, 0.490, 0.379>, <1.4510, 6.6323, 39.4659>, <-0.548, 0.718, 0.429>, <1.5270, 6.4717, 39.8314>, <-0.207, 0.879, 0.429> }
	smooth_triangle { <1.5270, 6.4717, 39.8314>, <-0.207, 0.879, 0.429>, <1.4510, 6.6323, 39.4659>, <-0.548, 0.718, 0.429>, <1.4758, 6.6314, 39.4604>, <0.432, 0.855, 0.286> }
	smooth_triangle { <1.5270, 6.4717, 39.8314>, <-0.207, 0.879, 0.429>, <1.4758, 6.6314, 39.4604>, <0.432, 0.855, 0.286>, <1.5517, 6.4707, 39.8258>, <0.728, 0.670, 0.143> }
	smooth_triangle { <1.5517, 6.4707, 39.8258>, <0.728, 0.670, 0.143>, <1.4758, 6.6314, 39.4604>, <0.432, 0.855, 0.286>, <1.4856, 6.6108, 39.4493>, <0.980, 0.138, -0.143> }
	smooth_triangle { <1.5517, 6.4707, 39.8258>, <0.728, 0.670, 0.143>, <1.4856, 6.6108, 39.4493>, <0.980, 0.138, -0.143>, <1.5615, 6.4501, 39.8147>, <0.935, -0.209, -0.286> }
	smooth_triangle { <1.5615, 6.4501, 39.8147>, <0.935, -0.209, -0.286>, <1.4856, 6.6108, 39.4493>, <0.980, 0.138, -0.143>, <1.4706, 6.5910, 39.4437>, <0.548, -0.718, -0.429> }
	smooth_triangle { <1.5615, 6.4501, 39.8147>, <0.935, -0.209, -0.286>, <1.4706, 6.5910, 39.4437>, <0.548, -0.718, -0.429>, <1.5465, 6.4304, 39.8092>, <0.207, -0.879, -0.429> }
	smooth_triangle { <1.5465, 6.4304, 39.8092>, <0.207, -0.879, -0.429>, <1.4706, 6.5910, 39.4437>, <0.548, -0.718, -0.429>, <1.4458, 6.5920, 39.4493>, <-0.432, -0.855, -0.286> }
	smooth_triangle { <1.5465, 6.4304, 39.8092>, <0.207, -0.879, -0.429>, <1.4458, 6.5920, 39.4493>, <-0.432, -0.855, -0.286>, <1.5217, 6.4313, 39.8147>, <-0.728, -0.670, -0.143> }
	smooth_triangle { <1.5217, 6.4313, 39.8147>, <-0.728, -0.670, -0.143>, <1.4458, 6.5920, 39.4493>, <-0.432, -0.855, -0.286>, <1.4360, 6.6126, 39.4604>, <-0.904, -0.427, 0.000> }
	smooth_triangle { <1.5217, 6.4313, 39.8147>, <-0.728, -0.670, -0.143>, <1.4360, 6.6126, 39.4604>, <-0.904, -0.427, 0.000>, <1.5120, 6.4519, 39.8258>, <-0.904, -0.427, 0.000> }

	texture { PSWL_BARK }
}

/* Object 'PWL0001F' */
union {
	smooth_triangle { <1.4063, 5.8922, 36.1005>, <-0.281, 0.959, -0.039>, <1.9110, 6.0439, 35.8313>, <-0.278, 0.960, 0.020>, <2.4258, 6.1882, 36.0435>, <-0.281, 0.959, -0.039> }
	smooth_triangle { <2.4258, 6.1882, 36.0435>, <-0.281, 0.959, -0.039>, <1.9189, 6.0657, 36.3103>, <-0.283, 0.954, -0.098>, <1.4063, 5.8922, 36.1005>, <-0.281, 0.959, -0.039> }
	smooth_triangle { <1.3601, 5.9806, 36.7065>, <-0.957, -0.250, 0.146>, <1.2341, 6.3986, 36.4663>, <-0.964, -0.259, 0.056>, <1.1184, 6.8670, 36.6383>, <-0.957, -0.250, 0.146> }
	smooth_triangle { <1.1184, 6.8670, 36.6383>, <-0.957, -0.250, 0.146>, <1.2705, 6.4986, 36.8735>, <-0.942, -0.239, 0.235>, <1.3601, 5.9806, 36.7065>, <-0.957, -0.250, 0.146> }
	smooth_triangle { <1.4626, 6.0360, 37.3065>, <-0.226, 0.973, -0.048>, <1.9294, 6.1095, 37.0367>, <-0.233, 0.962, -0.140>, <2.4377, 6.2580, 37.2118>, <-0.226, 0.973, -0.048> }
	smooth_triangle { <2.4377, 6.2580, 37.2118>, <-0.226, 0.973, -0.048>, <1.9387, 6.1337, 37.4915>, <-0.218, 0.975, 0.045>, <1.4626, 6.0360, 37.3065>, <-0.226, 0.973, -0.048> }
	smooth_triangle { <1.4034, 6.1490, 37.9105>, <-0.551, -0.799, 0.241>, <0.8468, 6.4334, 37.6037>, <-0.549, -0.794, 0.260>, <0.3316, 6.8741, 37.8615>, <-0.551, -0.799, 0.241> }
	smooth_triangle { <0.3316, 6.8741, 37.8615>, <-0.551, -0.799, 0.241>, <0.8991, 6.5686, 38.1711>, <-0.553, -0.803, 0.222>, <1.4034, 6.1490, 37.9105>, <-0.551, -0.799, 0.241> }
	smooth_triangle { <1.5337, 6.2583, 38.2884>, <0.049, 0.924, -0.378>, <2.1329, 6.1153, 37.9841>, <0.052, 0.939, -0.339>, <2.7938, 6.1616, 38.2150>, <0.049, 0.924, -0.378> }
	smooth_triangle { <2.7938, 6.1616, 38.2150>, <0.049, 0.924, -0.378>, <2.1821, 6.3283, 38.5113>, <0.045, 0.908, -0.417>, <1.5337, 6.2583, 38.2884>, <0.049, 0.924, -0.378> }
	smooth_triangle { <1.4796, 6.4448, 38.6585>, <-0.768, -0.590, 0.251>, <1.1550, 6.7866, 38.3130>, <-0.766, -0.637, 0.089>, <0.8332, 7.1903, 38.4332>, <-0.768, -0.590, 0.251> }
	smooth_triangle { <0.8332, 7.1903, 38.4332>, <-0.768, -0.590, 0.251>, <1.1876, 6.9277, 38.7461>, <-0.748, -0.526, 0.406>, <1.4796, 6.4448, 38.6585>, <-0.768, -0.590, 0.251> }
	smooth_triangle { <1.5213, 6.5488, 39.0543>, <-0.767, 0.603, -0.220>, <1.8580, 6.8092, 38.7787>, <-0.741, 0.547, -0.389>, <2.1494, 7.2915, 38.9015>, <-0.767, 0.603, -0.220> }
	smooth_triangle { <2.1494, 7.2915, 38.9015>, <-0.767, 0.603, -0.220>, <1.8279, 6.9267, 39.2056>, <-0.767, 0.640, -0.043>, <1.5213, 6.5488, 39.0543>, <-0.767, 0.603, -0.220> }
	smooth_triangle { <1.4084, 6.6018, 39.4538>, <0.175, -0.954, 0.245>, <0.9322, 6.4527, 39.2244>, <0.174, -0.951, 0.257>, <0.4128, 6.4148, 39.4359>, <0.175, -0.954, 0.245> }
	smooth_triangle { <0.4128, 6.4148, 39.4359>, <0.175, -0.954, 0.245>, <0.9044, 6.5611, 39.6672>, <0.176, -0.957, 0.232>, <1.4084, 6.6018, 39.4538>, <0.175, -0.954, 0.245> }
	smooth_triangle { <1.4391, 6.6903, 39.8565>, <-0.848, 0.508, -0.153>, <1.8179, 7.2229, 39.5570>, <-0.845, 0.507, -0.168>, <2.1226, 7.8276, 39.8469>, <-0.848, 0.508, -0.153> }
	smooth_triangle { <2.1226, 7.8276, 39.8469>, <-0.848, 0.508, -0.153>, <1.7419, 7.2738, 40.1480>, <-0.850, 0.509, -0.137>, <1.4391, 6.6903, 39.8565>, <-0.848, 0.508, -0.153> }
	smooth_triangle { <1.3097, 6.6719, 40.2529>, <0.091, -0.988, 0.126>, <0.7020, 6.6171, 39.9050>, <0.110, -0.993, -0.036>, <0.1034, 6.5429, 40.1160>, <0.091, -0.988, 0.126> }
	smooth_triangle { <0.1034, 6.5429, 40.1160>, <0.091, -0.988, 0.126>, <0.6109, 6.6781, 40.4451>, <0.070, -0.956, 0.285>, <1.3097, 6.6719, 40.2529>, <0.091, -0.988, 0.126> }
	smooth_triangle { <1.2247, 6.6792, 40.4175>, <-0.642, -0.652, -0.403>, <1.0035, 7.0918, 40.0993>, <-0.643, -0.653, -0.399>, <0.5839, 7.4456, 40.1969>, <-0.642, -0.652, -0.403> }
	smooth_triangle { <0.5839, 7.4456, 40.1969>, <-0.642, -0.652, -0.403>, <0.8122, 7.0216, 40.5170>, <-0.639, -0.652, -0.407>, <1.2247, 6.6792, 40.4175>, <-0.642, -0.652, -0.403> }
	smooth_triangle { <1.1276, 6.5617, 40.5743>, <0.627, -0.669, 0.400>, <1.0484, 6.2927, 40.2302>, <0.649, -0.665, 0.370>, <0.7005, 5.9184, 40.1674>, <0.627, -0.669, 0.400> }
	smooth_triangle { <0.7005, 5.9184, 40.1674>, <0.627, -0.669, 0.400>, <0.7634, 6.1882, 40.5017>, <0.604, -0.672, 0.429>, <1.1276, 6.5617, 40.5743>, <0.627, -0.669, 0.400> }
	smooth_triangle { <0.9533, 6.5792, 40.6996>, <-0.149, -0.876, -0.460>, <0.7155, 6.7643, 40.3740>, <-0.214, -0.908, -0.360>, <0.2291, 6.8977, 40.3270>, <-0.149, -0.876, -0.460> }
	smooth_triangle { <0.2291, 6.8977, 40.3270>, <-0.149, -0.876, -0.460>, <0.4179, 6.6865, 40.6167>, <-0.081, -0.830, -0.552>, <0.9533, 6.5792, 40.6996>, <-0.149, -0.876, -0.460> }
	smooth_triangle { <0.8256, 6.4717, 40.8254>, <0.677, -0.467, 0.569>, <0.8468, 5.9379, 40.3744>, <0.660, -0.469, 0.587>, <0.4306, 5.2775, 40.3142>, <0.677, -0.467, 0.569> }
	smooth_triangle { <0.4306, 5.2775, 40.3142>, <0.677, -0.467, 0.569>, <0.4310, 5.8340, 40.7835>, <0.693, -0.465, 0.551>, <0.8256, 6.4717, 40.8254>, <0.677, -0.467, 0.569> }
	smooth_triangle { <1.3403, 6.7304, 39.5794>, <-0.626, 0.160, -0.763>, <1.6578, 7.0902, 39.3952>, <-0.624, 0.159, -0.765>, <1.6844, 7.6089, 39.4814>, <-0.626, 0.160, -0.763> }
	smooth_triangle { <1.6844, 7.6089, 39.4814>, <-0.626, 0.160, -0.763>, <1.3628, 7.2363, 39.6681>, <-0.629, 0.161, -0.761>, <1.3403, 6.7304, 39.5794>, <-0.626, 0.160, -0.763> }
	smooth_triangle { <1.1425, 6.7369, 39.6807>, <-0.063, -0.903, 0.424>, <0.9335, 6.5693, 39.2278>, <0.030, -0.942, 0.334>, <0.4906, 6.5099, 39.1006>, <-0.063, -0.903, 0.424> }
	smooth_triangle { <0.4906, 6.5099, 39.1006>, <-0.063, -0.903, 0.424>, <0.6507, 6.7094, 39.4838>, <-0.155, -0.848, 0.506>, <1.1425, 6.7369, 39.6807>, <-0.063, -0.903, 0.424> }
	smooth_triangle { <1.5117, 6.7948, 39.5444>, <-0.174, 0.416, -0.893>, <2.1352, 6.5880, 39.3316>, <-0.173, 0.402, -0.899>, <2.7718, 6.9105, 39.3532>, <-0.174, 0.416, -0.893> }
	smooth_triangle { <2.7718, 6.9105, 39.3532>, <-0.174, 0.416, -0.893>, <2.1306, 7.1115, 39.5762>, <-0.174, 0.429, -0.886>, <1.5117, 6.7948, 39.5444>, <-0.174, 0.416, -0.893> }
	smooth_triangle { <1.4096, 6.9789, 39.6295>, <-0.432, -0.483, 0.762>, <0.8912, 6.8708, 39.2690>, <-0.433, -0.477, 0.765>, <0.3540, 7.2156, 39.1802>, <-0.432, -0.483, 0.762> }
	smooth_triangle { <0.3540, 7.2156, 39.1802>, <-0.432, -0.483, 0.762>, <0.8873, 7.3185, 39.5506>, <-0.432, -0.489, 0.758>, <1.4096, 6.9789, 39.6295>, <-0.432, -0.483, 0.762> }
	smooth_triangle { <1.4915, 6.4824, 39.6176>, <0.977, -0.062, -0.206>, <1.3783, 6.0013, 39.1261>, <0.986, -0.091, -0.138>, <1.3254, 5.3720, 39.1639>, <0.977, -0.062, -0.206> }
	smooth_triangle { <1.3254, 5.3720, 39.1639>, <0.977, -0.062, -0.206>, <1.4715, 5.8041, 39.6270>, <0.961, -0.032, -0.273>, <1.4915, 6.4824, 39.6176>, <0.977, -0.062, -0.206> }
	smooth_triangle { <1.5864, 6.4392, 39.8048>, <0.284, 0.939, 0.193>, <1.9653, 6.4079, 39.4881>, <0.303, 0.913, 0.273>, <2.4189, 6.2404, 39.5443>, <0.284, 0.939, 0.193> }
	smooth_triangle { <2.4189, 6.2404, 39.5443>, <0.284, 0.939, 0.193>, <2.0100, 6.3133, 39.8856>, <0.264, 0.958, 0.111>, <1.5864, 6.4392, 39.8048>, <0.284, 0.939, 0.193> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0002B' */
union {
	smooth_triangle { <0.8455, 6.0552, 37.3155>, <0.720, 0.369, 0.588>, <1.3874, 5.9491, 36.7191>, <0.720, 0.369, 0.588>, <1.3924, 5.9257, 36.7277>, <0.743, 0.047, 0.667> }
	smooth_triangle { <0.8455, 6.0552, 37.3155>, <0.720, 0.369, 0.588>, <1.3924, 5.9257, 36.7277>, <0.743, 0.047, 0.667>, <0.8504, 6.0318, 37.3241>, <0.671, -0.324, 0.667> }
	smooth_triangle { <0.8504, 6.0318, 37.3241>, <0.671, -0.324, 0.667>, <1.3924, 5.9257, 36.7277>, <0.743, 0.047, 0.667>, <1.3790, 5.9059, 36.7191>, <0.326, -0.834, 0.445> }
	smooth_triangle { <0.8504, 6.0318, 37.3241>, <0.671, -0.324, 0.667>, <1.3790, 5.9059, 36.7191>, <0.326, -0.834, 0.445>, <0.8370, 6.0120, 37.3155>, <0.054, -0.973, 0.222> }
	smooth_triangle { <0.8370, 6.0120, 37.3155>, <0.054, -0.973, 0.222>, <1.3790, 5.9059, 36.7191>, <0.326, -0.834, 0.445>, <1.3607, 5.9095, 36.7018>, <-0.417, -0.881, -0.222> }
	smooth_triangle { <0.8370, 6.0120, 37.3155>, <0.054, -0.973, 0.222>, <1.3607, 5.9095, 36.7018>, <-0.417, -0.881, -0.222>, <0.8187, 6.0156, 37.2982>, <-0.617, -0.650, -0.445> }
	smooth_triangle { <0.8187, 6.0156, 37.2982>, <-0.617, -0.650, -0.445>, <1.3607, 5.9095, 36.7018>, <-0.417, -0.881, -0.222>, <1.3558, 5.9328, 36.6932>, <-0.743, -0.047, -0.667> }
	smooth_triangle { <0.8187, 6.0156, 37.2982>, <-0.617, -0.650, -0.445>, <1.3558, 5.9328, 36.6932>, <-0.743, -0.047, -0.667>, <0.8138, 6.0390, 37.2896>, <-0.671, 0.324, -0.667> }
	smooth_triangle { <0.8138, 6.0390, 37.2896>, <-0.671, 0.324, -0.667>, <1.3558, 5.9328, 36.6932>, <-0.743, -0.047, -0.667>, <1.3691, 5.9526, 36.7018>, <-0.326, 0.834, -0.445> }
	smooth_triangle { <0.8138, 6.0390, 37.2896>, <-0.671, 0.324, -0.667>, <1.3691, 5.9526, 36.7018>, <-0.326, 0.834, -0.445>, <0.8272, 6.0588, 37.2982>, <-0.054, 0.973, -0.222> }
	smooth_triangle { <0.8272, 6.0588, 37.2982>, <-0.054, 0.973, -0.222>, <1.3691, 5.9526, 36.7018>, <-0.326, 0.834, -0.445>, <1.3874, 5.9491, 36.7191>, <0.192, 0.981, 0.000> }
	smooth_triangle { <0.8272, 6.0588, 37.2982>, <-0.054, 0.973, -0.222>, <1.3874, 5.9491, 36.7191>, <0.192, 0.981, 0.000>, <0.8455, 6.0552, 37.3155>, <0.192, 0.981, 0.000> }

	texture { PSWL_BARK }
}

/* Object 'PWL0002F' */
union {
	smooth_triangle { <1.1132, 6.0347, 37.0086>, <-0.720, 0.139, -0.680>, <1.3938, 6.5566, 36.8180>, <-0.720, 0.139, -0.680>, <1.3320, 7.1619, 37.0068>, <-0.720, 0.139, -0.680> }
	smooth_triangle { <1.3320, 7.1619, 37.0068>, <-0.720, 0.139, -0.680>, <1.0485, 6.6242, 37.1975>, <-0.720, 0.139, -0.680>, <1.1132, 6.0347, 37.0086>, <-0.720, 0.139, -0.680> }
	smooth_triangle { <0.7948, 6.0113, 37.2773>, <0.286, -0.886, 0.364>, <0.6449, 5.7698, 36.8979>, <0.180, -0.861, 0.477>, <0.1442, 5.5894, 36.7611>, <0.286, -0.886, 0.364> }
	smooth_triangle { <0.1442, 5.5894, 36.7611>, <0.286, -0.886, 0.364>, <0.3859, 5.8206, 37.2257>, <0.385, -0.891, 0.243>, <0.7948, 6.0113, 37.2773>, <0.286, -0.886, 0.364> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0003B' */
union {
	smooth_triangle { <1.6687, 5.5451, 37.3639>, <-0.826, 0.204, 0.526>, <1.3507, 5.9228, 36.7182>, <-0.826, 0.204, 0.526>, <1.3611, 5.9447, 36.7259>, <-0.647, 0.475, 0.596> }
	smooth_triangle { <1.6687, 5.5451, 37.3639>, <-0.826, 0.204, 0.526>, <1.3611, 5.9447, 36.7259>, <-0.647, 0.475, 0.596>, <1.6790, 5.5670, 37.3716>, <-0.358, 0.718, 0.596> }
	smooth_triangle { <1.6790, 5.5670, 37.3716>, <-0.358, 0.718, 0.596>, <1.3611, 5.9447, 36.7259>, <-0.647, 0.475, 0.596>, <1.3844, 5.9511, 36.7182>, <0.243, 0.885, 0.398> }
	smooth_triangle { <1.6790, 5.5670, 37.3716>, <-0.358, 0.718, 0.596>, <1.3844, 5.9511, 36.7182>, <0.243, 0.885, 0.398>, <1.7023, 5.5734, 37.3639>, <0.555, 0.807, 0.199> }
	smooth_triangle { <1.7023, 5.5734, 37.3639>, <0.555, 0.807, 0.199>, <1.3844, 5.9511, 36.7182>, <0.243, 0.885, 0.398>, <1.3974, 5.9357, 36.7028>, <0.890, 0.410, -0.199> }
	smooth_triangle { <1.7023, 5.5734, 37.3639>, <0.555, 0.807, 0.199>, <1.3974, 5.9357, 36.7028>, <0.890, 0.410, -0.199>, <1.7153, 5.5580, 37.3484>, <0.913, 0.089, -0.398> }
	smooth_triangle { <1.7153, 5.5580, 37.3484>, <0.913, 0.089, -0.398>, <1.3974, 5.9357, 36.7028>, <0.890, 0.410, -0.199>, <1.3871, 5.9138, 36.6950>, <0.647, -0.475, -0.596> }
	smooth_triangle { <1.7153, 5.5580, 37.3484>, <0.913, 0.089, -0.398>, <1.3871, 5.9138, 36.6950>, <0.647, -0.475, -0.596>, <1.7050, 5.5361, 37.3407>, <0.358, -0.718, -0.596> }
	smooth_triangle { <1.7050, 5.5361, 37.3407>, <0.358, -0.718, -0.596>, <1.3871, 5.9138, 36.6950>, <0.647, -0.475, -0.596>, <1.3637, 5.9074, 36.7028>, <-0.243, -0.885, -0.398> }
	smooth_triangle { <1.7050, 5.5361, 37.3407>, <0.358, -0.718, -0.596>, <1.3637, 5.9074, 36.7028>, <-0.243, -0.885, -0.398>, <1.6817, 5.5297, 37.3484>, <-0.555, -0.807, -0.199> }
	smooth_triangle { <1.6817, 5.5297, 37.3484>, <-0.555, -0.807, -0.199>, <1.3637, 5.9074, 36.7028>, <-0.243, -0.885, -0.398>, <1.3507, 5.9228, 36.7182>, <-0.765, -0.644, 0.000> }
	smooth_triangle { <1.6817, 5.5297, 37.3484>, <-0.555, -0.807, -0.199>, <1.3507, 5.9228, 36.7182>, <-0.765, -0.644, 0.000>, <1.6687, 5.5451, 37.3639>, <-0.765, -0.644, 0.000> }

	texture { PSWL_BARK }
}

/* Object 'PWL0003F' */
union {
	smooth_triangle { <1.4978, 5.7008, 37.0275>, <0.624, -0.462, -0.631>, <0.9928, 5.3881, 36.7494>, <0.631, -0.470, -0.618>, <0.6975, 4.8003, 36.8948>, <0.624, -0.462, -0.631> }
	smooth_triangle { <0.6975, 4.8003, 36.8948>, <0.624, -0.462, -0.631>, <1.2186, 5.1199, 37.1690>, <0.617, -0.453, -0.644>, <1.4978, 5.7008, 37.0275>, <0.624, -0.462, -0.631> }
	smooth_triangle { <1.7370, 5.5429, 37.3289>, <0.403, 0.821, 0.404>, <2.1738, 5.5871, 36.7542>, <0.378, 0.855, 0.353>, <2.8845, 5.3221, 36.6347>, <0.403, 0.821, 0.404> }
	smooth_triangle { <2.8845, 5.3221, 36.6347>, <0.403, 0.821, 0.404>, <2.4703, 5.2350, 37.1733>, <0.425, 0.783, 0.454>, <1.7370, 5.5429, 37.3289>, <0.403, 0.821, 0.404> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0004B' */
union {
	smooth_triangle { <1.0678, 6.3901, 37.3064>, <0.772, -0.214, 0.599>, <1.3973, 5.9347, 36.7193>, <0.772, -0.214, 0.599>, <1.3848, 5.9144, 36.7280>, <0.569, -0.464, 0.679> }
	smooth_triangle { <1.0678, 6.3901, 37.3064>, <0.772, -0.214, 0.599>, <1.3848, 5.9144, 36.7280>, <0.569, -0.464, 0.679>, <1.0554, 6.3698, 37.3152>, <0.263, -0.686, 0.679> }
	smooth_triangle { <1.0554, 6.3698, 37.3152>, <0.263, -0.686, 0.679>, <1.3848, 5.9144, 36.7280>, <0.569, -0.464, 0.679>, <1.3616, 5.9089, 36.7193>, <-0.335, -0.826, 0.453> }
	smooth_triangle { <1.0554, 6.3698, 37.3152>, <0.263, -0.686, 0.679>, <1.3616, 5.9089, 36.7193>, <-0.335, -0.826, 0.453>, <1.0322, 6.3644, 37.3064>, <-0.627, -0.745, 0.226> }
	smooth_triangle { <1.0322, 6.3644, 37.3064>, <-0.627, -0.745, 0.226>, <1.3616, 5.9089, 36.7193>, <-0.335, -0.826, 0.453>, <1.3509, 5.9238, 36.7017>, <-0.904, -0.362, -0.226> }
	smooth_triangle { <1.0322, 6.3644, 37.3064>, <-0.627, -0.745, 0.226>, <1.3509, 5.9238, 36.7017>, <-0.904, -0.362, -0.226>, <1.0214, 6.3792, 37.2888>, <-0.890, -0.060, -0.453> }
	smooth_triangle { <1.0214, 6.3792, 37.2888>, <-0.890, -0.060, -0.453>, <1.3509, 5.9238, 36.7017>, <-0.904, -0.362, -0.226>, <1.3633, 5.9441, 36.6929>, <-0.569, 0.464, -0.679> }
	smooth_triangle { <1.0214, 6.3792, 37.2888>, <-0.890, -0.060, -0.453>, <1.3633, 5.9441, 36.6929>, <-0.569, 0.464, -0.679>, <1.0339, 6.3996, 37.2800>, <-0.263, 0.685, -0.679> }
	smooth_triangle { <1.0339, 6.3996, 37.2800>, <-0.263, 0.685, -0.679>, <1.3633, 5.9441, 36.6929>, <-0.569, 0.464, -0.679>, <1.3865, 5.9496, 36.7017>, <0.335, 0.826, -0.453> }
	smooth_triangle { <1.0339, 6.3996, 37.2800>, <-0.263, 0.685, -0.679>, <1.3865, 5.9496, 36.7017>, <0.335, 0.826, -0.453>, <1.0571, 6.4050, 37.2888>, <0.627, 0.745, -0.226> }
	smooth_triangle { <1.0571, 6.4050, 37.2888>, <0.627, 0.745, -0.226>, <1.3865, 5.9496, 36.7017>, <0.335, 0.826, -0.453>, <1.3973, 5.9347, 36.7193>, <0.810, 0.586, 0.000> }
	smooth_triangle { <1.0571, 6.4050, 37.2888>, <0.627, 0.745, -0.226>, <1.3973, 5.9347, 36.7193>, <0.810, 0.586, 0.000>, <1.0678, 6.3901, 37.3064>, <0.810, 0.586, 0.000> }

	texture { PSWL_BARK }
}

/* Object 'PWL0004F' */
union {
	smooth_triangle { <1.2495, 6.1918, 36.9995>, <-0.518, 0.508, -0.688>, <1.7778, 6.4056, 36.7773>, <-0.498, 0.481, -0.721>, <2.1007, 6.9303, 36.9043>, <-0.518, 0.508, -0.688> }
	smooth_triangle { <2.1007, 6.9303, 36.9043>, <-0.518, 0.508, -0.688>, <1.5707, 6.6919, 37.1447>, <-0.537, 0.534, -0.653>, <1.2495, 6.1918, 36.9995>, <-0.518, 0.508, -0.688> }
	smooth_triangle { <0.9960, 6.3689, 37.2825>, <0.063, -0.783, 0.618>, <0.6638, 6.0858, 37.0142>, <-0.002, -0.687, 0.727>, <0.1139, 6.0824, 37.0099>, <0.063, -0.783, 0.618> }
	smooth_triangle { <0.1139, 6.0824, 37.0099>, <0.063, -0.783, 0.618>, <0.4910, 6.3247, 37.3350>, <0.127, -0.860, 0.494>, <0.9960, 6.3689, 37.2825>, <0.063, -0.783, 0.618> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0005B' */
union {
	smooth_triangle { <1.3440, 4.4990, 34.3493>, <-0.608, 0.574, 0.548>, <1.1674, 5.5132, 33.0912>, <-0.607, 0.573, 0.550>, <1.1873, 5.5266, 33.0992>, <-0.328, 0.715, 0.618> }
	smooth_triangle { <1.3440, 4.4990, 34.3493>, <-0.608, 0.574, 0.548>, <1.1873, 5.5266, 33.0992>, <-0.328, 0.715, 0.618>, <1.3640, 4.5124, 34.3573>, <0.056, 0.781, 0.622> }
	smooth_triangle { <1.3640, 4.5124, 34.3573>, <0.056, 0.781, 0.622>, <1.1873, 5.5266, 33.0992>, <-0.328, 0.715, 0.618>, <1.2107, 5.5207, 33.0912>, <0.647, 0.644, 0.408> }
	smooth_triangle { <1.3640, 4.5124, 34.3573>, <0.056, 0.781, 0.622>, <1.2107, 5.5207, 33.0912>, <0.647, 0.644, 0.408>, <1.3874, 4.5065, 34.3493>, <0.887, 0.412, 0.207> }
	smooth_triangle { <1.3874, 4.5065, 34.3493>, <0.887, 0.412, 0.207>, <1.2107, 5.5207, 33.0912>, <0.647, 0.644, 0.408>, <1.2141, 5.5013, 33.0751>, <0.975, -0.071, -0.210> }
	smooth_triangle { <1.3874, 4.5065, 34.3493>, <0.887, 0.412, 0.207>, <1.2141, 5.5013, 33.0751>, <0.975, -0.071, -0.210>, <1.3908, 4.4872, 34.3332>, <0.832, -0.369, -0.415> }
	smooth_triangle { <1.3908, 4.4872, 34.3332>, <0.832, -0.369, -0.415>, <1.2141, 5.5013, 33.0751>, <0.975, -0.071, -0.210>, <1.1941, 5.4879, 33.0670>, <0.328, -0.715, -0.618> }
	smooth_triangle { <1.3908, 4.4872, 34.3332>, <0.832, -0.369, -0.415>, <1.1941, 5.4879, 33.0670>, <0.328, -0.715, -0.618>, <1.3708, 4.4737, 34.3251>, <-0.056, -0.781, -0.622> }
	smooth_triangle { <1.3708, 4.4737, 34.3251>, <-0.056, -0.781, -0.622>, <1.1941, 5.4879, 33.0670>, <0.328, -0.715, -0.618>, <1.1707, 5.4938, 33.0751>, <-0.647, -0.644, -0.408> }
	smooth_triangle { <1.3708, 4.4737, 34.3251>, <-0.056, -0.781, -0.622>, <1.1707, 5.4938, 33.0751>, <-0.647, -0.644, -0.408>, <1.3474, 4.4796, 34.3332>, <-0.887, -0.412, -0.207> }
	smooth_triangle { <1.3474, 4.4796, 34.3332>, <-0.887, -0.412, -0.207>, <1.1707, 5.4938, 33.0751>, <-0.647, -0.644, -0.408>, <1.1674, 5.5132, 33.0912>, <-0.981, -0.194, 0.002> }
	smooth_triangle { <1.3474, 4.4796, 34.3332>, <-0.887, -0.412, -0.207>, <1.1674, 5.5132, 33.0912>, <-0.981, -0.194, 0.002>, <1.3440, 4.4990, 34.3493>, <-0.985, -0.172, 0.000> }
	smooth_triangle { <1.7247, 3.0415, 36.2678>, <-0.639, 0.542, 0.546>, <1.1674, 5.5132, 33.0912>, <-0.607, 0.573, 0.550>, <1.1873, 5.5266, 33.0992>, <-0.328, 0.715, 0.618> }
	smooth_triangle { <1.7247, 3.0415, 36.2678>, <-0.639, 0.542, 0.546>, <1.1873, 5.5266, 33.0992>, <-0.328, 0.715, 0.618>, <1.7435, 3.0567, 36.2756>, <-0.188, 0.752, 0.632> }
	smooth_triangle { <1.7435, 3.0567, 36.2756>, <-0.188, 0.752, 0.632>, <1.1873, 5.5266, 33.0992>, <-0.328, 0.715, 0.618>, <1.2107, 5.5207, 33.0912>, <0.647, 0.644, 0.408> }
	smooth_triangle { <1.7435, 3.0567, 36.2756>, <-0.188, 0.752, 0.632>, <1.2107, 5.5207, 33.0912>, <0.647, 0.644, 0.408>, <1.7673, 3.0526, 36.2678>, <0.746, 0.585, 0.316> }
	smooth_triangle { <1.7673, 3.0526, 36.2678>, <0.746, 0.585, 0.316>, <1.2107, 5.5207, 33.0912>, <0.647, 0.644, 0.408>, <1.2141, 5.5013, 33.0751>, <0.975, -0.071, -0.210> }
	smooth_triangle { <1.7673, 3.0526, 36.2678>, <0.746, 0.585, 0.316>, <1.2141, 5.5013, 33.0751>, <0.975, -0.071, -0.210>, <1.7723, 3.0333, 36.2521>, <0.934, -0.166, -0.316> }
	smooth_triangle { <1.7723, 3.0333, 36.2521>, <0.934, -0.166, -0.316>, <1.2141, 5.5013, 33.0751>, <0.975, -0.071, -0.210>, <1.1941, 5.4879, 33.0670>, <0.328, -0.715, -0.618> }
	smooth_triangle { <1.7723, 3.0333, 36.2521>, <0.934, -0.166, -0.316>, <1.1941, 5.4879, 33.0670>, <0.328, -0.715, -0.618>, <1.7536, 3.0181, 36.2443>, <0.188, -0.752, -0.632> }
	smooth_triangle { <1.7536, 3.0181, 36.2443>, <0.188, -0.752, -0.632>, <1.1941, 5.4879, 33.0670>, <0.328, -0.715, -0.618>, <1.1707, 5.4938, 33.0751>, <-0.647, -0.644, -0.408> }
	smooth_triangle { <1.7536, 3.0181, 36.2443>, <0.188, -0.752, -0.632>, <1.1707, 5.4938, 33.0751>, <-0.647, -0.644, -0.408>, <1.7298, 3.0222, 36.2521>, <-0.746, -0.585, -0.317> }
	smooth_triangle { <1.7298, 3.0222, 36.2521>, <-0.746, -0.585, -0.317>, <1.1707, 5.4938, 33.0751>, <-0.647, -0.644, -0.408>, <1.1674, 5.5132, 33.0912>, <-0.981, -0.194, 0.002> }
	smooth_triangle { <1.7298, 3.0222, 36.2521>, <-0.746, -0.585, -0.317>, <1.1674, 5.5132, 33.0912>, <-0.981, -0.194, 0.002>, <1.7247, 3.0415, 36.2678>, <-0.967, -0.255, -0.003> }
	smooth_triangle { <2.1387, 1.5458, 38.1492>, <-0.648, 0.481, 0.590>, <1.7247, 3.0415, 36.2678>, <-0.639, 0.542, 0.546>, <1.7435, 3.0567, 36.2756>, <-0.188, 0.752, 0.632> }
	smooth_triangle { <2.1387, 1.5458, 38.1492>, <-0.648, 0.481, 0.590>, <1.7435, 3.0567, 36.2756>, <-0.188, 0.752, 0.632>, <2.1573, 1.5611, 38.1573>, <-0.154, 0.650, 0.744> }
	smooth_triangle { <2.1573, 1.5611, 38.1573>, <-0.154, 0.650, 0.744>, <1.7435, 3.0567, 36.2756>, <-0.188, 0.752, 0.632>, <1.7673, 3.0526, 36.2678>, <0.746, 0.585, 0.316> }
	smooth_triangle { <2.1573, 1.5611, 38.1573>, <-0.154, 0.650, 0.744>, <1.7673, 3.0526, 36.2678>, <0.746, 0.585, 0.316>, <2.1811, 1.5575, 38.1492>, <0.782, 0.433, 0.448> }
	smooth_triangle { <2.1811, 1.5575, 38.1492>, <0.782, 0.433, 0.448>, <1.7673, 3.0526, 36.2678>, <0.746, 0.585, 0.316>, <1.7723, 3.0333, 36.2521>, <0.934, -0.166, -0.316> }
	smooth_triangle { <2.1811, 1.5575, 38.1492>, <0.782, 0.433, 0.448>, <1.7723, 3.0333, 36.2521>, <0.934, -0.166, -0.316>, <2.1864, 1.5386, 38.1330>, <0.930, -0.217, -0.296> }
	smooth_triangle { <2.1864, 1.5386, 38.1330>, <0.930, -0.217, -0.296>, <1.7723, 3.0333, 36.2521>, <0.934, -0.166, -0.316>, <1.7536, 3.0181, 36.2443>, <0.188, -0.752, -0.632> }
	smooth_triangle { <2.1864, 1.5386, 38.1330>, <0.930, -0.217, -0.296>, <1.7536, 3.0181, 36.2443>, <0.188, -0.752, -0.632>, <2.1678, 1.5233, 38.1250>, <0.154, -0.649, -0.745> }
	smooth_triangle { <2.1678, 1.5233, 38.1250>, <0.154, -0.649, -0.745>, <1.7536, 3.0181, 36.2443>, <0.188, -0.752, -0.632>, <1.7298, 3.0222, 36.2521>, <-0.746, -0.585, -0.317> }
	smooth_triangle { <2.1678, 1.5233, 38.1250>, <0.154, -0.649, -0.745>, <1.7298, 3.0222, 36.2521>, <-0.746, -0.585, -0.317>, <2.1440, 1.5269, 38.1330>, <-0.782, -0.431, -0.449> }
	smooth_triangle { <2.1440, 1.5269, 38.1330>, <-0.782, -0.431, -0.449>, <1.7298, 3.0222, 36.2521>, <-0.746, -0.585, -0.317>, <1.7247, 3.0415, 36.2678>, <-0.967, -0.255, -0.003> }
	smooth_triangle { <2.1440, 1.5269, 38.1330>, <-0.782, -0.431, -0.449>, <1.7247, 3.0415, 36.2678>, <-0.967, -0.255, -0.003>, <2.1387, 1.5458, 38.1492>, <-0.992, -0.102, -0.075> }
	smooth_triangle { <2.0748, 0.1425, 38.9635>, <-0.702, 0.442, 0.559>, <2.1387, 1.5458, 38.1492>, <-0.648, 0.481, 0.590>, <2.1573, 1.5611, 38.1573>, <-0.154, 0.650, 0.744> }
	smooth_triangle { <2.0748, 0.1425, 38.9635>, <-0.702, 0.442, 0.559>, <2.1573, 1.5611, 38.1573>, <-0.154, 0.650, 0.744>, <2.0971, 0.1478, 38.9745>, <0.092, 0.455, 0.886> }
	smooth_triangle { <2.0971, 0.1478, 38.9745>, <0.092, 0.455, 0.886>, <2.1573, 1.5611, 38.1573>, <-0.154, 0.650, 0.744>, <2.1811, 1.5575, 38.1492>, <0.782, 0.433, 0.448> }
	smooth_triangle { <2.0971, 0.1478, 38.9745>, <0.092, 0.455, 0.886>, <2.1811, 1.5575, 38.1492>, <0.782, 0.433, 0.448>, <2.1188, 0.1404, 38.9635>, <0.893, 0.083, 0.441> }
	smooth_triangle { <2.1188, 0.1404, 38.9635>, <0.893, 0.083, 0.441>, <2.1811, 1.5575, 38.1492>, <0.782, 0.433, 0.448>, <2.1864, 1.5386, 38.1330>, <0.930, -0.217, -0.296> }
	smooth_triangle { <2.1188, 0.1404, 38.9635>, <0.893, 0.083, 0.441>, <2.1864, 1.5386, 38.1330>, <0.930, -0.217, -0.296>, <2.1182, 0.1278, 38.9415>, <0.803, -0.385, -0.455> }
	smooth_triangle { <2.1182, 0.1278, 38.9415>, <0.803, -0.385, -0.455>, <2.1864, 1.5386, 38.1330>, <0.930, -0.217, -0.296>, <2.1678, 1.5233, 38.1250>, <0.154, -0.649, -0.745> }
	smooth_triangle { <2.1182, 0.1278, 38.9415>, <0.803, -0.385, -0.455>, <2.1678, 1.5233, 38.1250>, <0.154, -0.649, -0.745>, <2.0959, 0.1225, 38.9305>, <-0.094, -0.465, -0.880> }
	smooth_triangle { <2.0959, 0.1225, 38.9305>, <-0.094, -0.465, -0.880>, <2.1678, 1.5233, 38.1250>, <0.154, -0.649, -0.745>, <2.1440, 1.5269, 38.1330>, <-0.782, -0.431, -0.449> }
	smooth_triangle { <2.0959, 0.1225, 38.9305>, <-0.094, -0.465, -0.880>, <2.1440, 1.5269, 38.1330>, <-0.782, -0.431, -0.449>, <2.0742, 0.1298, 38.9415>, <-0.895, -0.094, -0.437> }
	smooth_triangle { <2.0742, 0.1298, 38.9415>, <-0.895, -0.094, -0.437>, <2.1440, 1.5269, 38.1330>, <-0.782, -0.431, -0.449>, <2.1387, 1.5458, 38.1492>, <-0.992, -0.102, -0.075> }
	smooth_triangle { <2.0742, 0.1298, 38.9415>, <-0.895, -0.094, -0.437>, <2.1387, 1.5458, 38.1492>, <-0.992, -0.102, -0.075>, <2.0748, 0.1425, 38.9635>, <-0.999, 0.046, 0.001> }
	smooth_triangle { <1.6184, -1.2791, 39.5958>, <-0.477, 0.475, 0.740>, <2.0748, 0.1425, 38.9635>, <-0.702, 0.442, 0.559>, <2.0971, 0.1478, 38.9745>, <0.092, 0.455, 0.886> }
	smooth_triangle { <1.6184, -1.2791, 39.5958>, <0.483, 0.202, 0.852>, <2.0971, 0.1478, 38.9745>, <0.092, 0.455, 0.886>, <2.1188, 0.1404, 38.9635>, <0.893, 0.083, 0.441> }
	smooth_triangle { <1.6184, -1.2791, 39.5958>, <0.950, -0.286, 0.127>, <2.1188, 0.1404, 38.9635>, <0.893, 0.083, 0.441>, <2.1182, 0.1278, 38.9415>, <0.803, -0.385, -0.455> }
	smooth_triangle { <1.6184, -1.2791, 39.5958>, <0.470, -0.510, -0.721>, <2.1182, 0.1278, 38.9415>, <0.803, -0.385, -0.455>, <2.0959, 0.1225, 38.9305>, <-0.094, -0.465, -0.880> }
	smooth_triangle { <1.6184, -1.2791, 39.5958>, <-0.492, -0.238, -0.838>, <2.0959, 0.1225, 38.9305>, <-0.094, -0.465, -0.880>, <2.0742, 0.1298, 38.9415>, <-0.895, -0.094, -0.437> }
	smooth_triangle { <1.6184, -1.2791, 39.5958>, <-0.961, 0.252, -0.109>, <2.0742, 0.1298, 38.9415>, <-0.895, -0.094, -0.437>, <2.0748, 0.1425, 38.9635>, <-0.702, 0.442, 0.559> }
	smooth_triangle { <2.2285, 1.9263, 36.4093>, <-0.495, -0.118, 0.861>, <1.7279, 3.0296, 36.2726>, <-0.514, -0.076, 0.854>, <1.7473, 3.0400, 36.2852>, <-0.306, 0.092, 0.947> }
	smooth_triangle { <2.2285, 1.9263, 36.4093>, <-0.495, -0.118, 0.861>, <1.7473, 3.0400, 36.2852>, <-0.306, 0.092, 0.947>, <2.2479, 1.9367, 36.4219>, <0.127, 0.178, 0.976> }
	smooth_triangle { <2.2479, 1.9367, 36.4219>, <0.127, 0.178, 0.976>, <1.7473, 3.0400, 36.2852>, <-0.217, 0.165, 0.962>, <1.7680, 3.0478, 36.2726>, <0.505, 0.587, 0.632> }
	smooth_triangle { <2.2479, 1.9367, 36.4219>, <0.127, 0.178, 0.976>, <1.7680, 3.0478, 36.2726>, <0.505, 0.587, 0.632>, <2.2685, 1.9445, 36.4093>, <0.845, 0.424, 0.325> }
	smooth_triangle { <2.2685, 1.9445, 36.4093>, <0.845, 0.424, 0.325>, <1.7680, 3.0478, 36.2726>, <0.605, 0.568, 0.558>, <1.7691, 3.0452, 36.2473>, <0.810, 0.491, -0.321> }
	smooth_triangle { <2.2685, 1.9445, 36.4093>, <0.845, 0.424, 0.325>, <1.7691, 3.0452, 36.2473>, <0.810, 0.491, -0.321>, <2.2697, 1.9419, 36.3841>, <0.719, 0.245, -0.651> }
	smooth_triangle { <2.2697, 1.9419, 36.3841>, <0.719, 0.245, -0.651>, <1.7691, 3.0452, 36.2473>, <0.820, 0.400, -0.408>, <1.7497, 3.0348, 36.2347>, <0.306, -0.093, -0.947> }
	smooth_triangle { <2.2697, 1.9419, 36.3841>, <0.719, 0.245, -0.651>, <1.7497, 3.0348, 36.2347>, <0.306, -0.093, -0.947>, <2.2503, 1.9315, 36.3715>, <-0.127, -0.178, -0.976> }
	smooth_triangle { <2.2503, 1.9315, 36.3715>, <-0.127, -0.178, -0.976>, <1.7497, 3.0348, 36.2347>, <0.217, -0.166, -0.962>, <1.7291, 3.0270, 36.2473>, <-0.506, -0.587, -0.632> }
	smooth_triangle { <2.2503, 1.9315, 36.3715>, <-0.127, -0.178, -0.976>, <1.7291, 3.0270, 36.2473>, <-0.506, -0.587, -0.632>, <2.2296, 1.9237, 36.3841>, <-0.845, -0.424, -0.325> }
	smooth_triangle { <2.2296, 1.9237, 36.3841>, <-0.845, -0.424, -0.325>, <1.7291, 3.0270, 36.2473>, <-0.605, -0.569, -0.558>, <1.7279, 3.0296, 36.2726>, <-0.797, -0.604, -0.018> }
	smooth_triangle { <2.2296, 1.9237, 36.3841>, <-0.845, -0.424, -0.325>, <1.7279, 3.0296, 36.2726>, <-0.797, -0.604, -0.018>, <2.2285, 1.9263, 36.4093>, <-0.911, -0.413, 0.000> }
	smooth_triangle { <4.0921, 0.9758, 37.6739>, <-0.618, -0.165, 0.769>, <1.7279, 3.0296, 36.2726>, <-0.514, -0.076, 0.854>, <1.7473, 3.0400, 36.2852>, <-0.306, 0.092, 0.947> }
	smooth_triangle { <4.0921, 0.9758, 37.6739>, <-0.618, -0.165, 0.769>, <1.7473, 3.0400, 36.2852>, <-0.544, -0.127, 0.829>, <4.0961, 0.9984, 37.6848>, <-0.556, 0.101, 0.825> }
	smooth_triangle { <4.0961, 0.9984, 37.6848>, <-0.078, 0.682, 0.727>, <1.7473, 3.0400, 36.2852>, <-0.217, 0.165, 0.962>, <1.7680, 3.0478, 36.2726>, <0.505, 0.587, 0.632> }
	smooth_triangle { <4.0961, 0.9984, 37.6848>, <-0.369, 0.365, 0.854>, <1.7680, 3.0478, 36.2726>, <0.374, 0.580, 0.724>, <4.1120, 1.0150, 37.6739>, <0.136, 0.901, 0.412> }
	smooth_triangle { <4.1120, 1.0150, 37.6739>, <0.437, 0.871, 0.224>, <1.7680, 3.0478, 36.2726>, <0.505, 0.587, 0.632>, <1.7691, 3.0452, 36.2473>, <0.810, 0.491, -0.321> }
	smooth_triangle { <4.1120, 1.0150, 37.6739>, <0.274, 0.906, 0.323>, <1.7691, 3.0452, 36.2473>, <0.797, 0.604, 0.018>, <4.1237, 1.0091, 37.6522>, <0.555, 0.757, -0.344> }
	smooth_triangle { <4.1237, 1.0091, 37.6522>, <0.618, 0.164, -0.769>, <1.7691, 3.0452, 36.2473>, <0.820, 0.400, -0.408>, <1.7497, 3.0348, 36.2347>, <0.306, -0.093, -0.947> }
	smooth_triangle { <4.1237, 1.0091, 37.6522>, <0.646, 0.532, -0.547>, <1.7497, 3.0348, 36.2347>, <0.544, 0.127, -0.830>, <4.1197, 0.9865, 37.6414>, <0.556, -0.101, -0.825> }
	smooth_triangle { <4.1197, 0.9865, 37.6414>, <0.077, -0.682, -0.727>, <1.7497, 3.0348, 36.2347>, <0.217, -0.166, -0.962>, <1.7291, 3.0270, 36.2473>, <-0.506, -0.587, -0.632> }
	smooth_triangle { <4.1197, 0.9865, 37.6414>, <0.369, -0.365, -0.854>, <1.7291, 3.0270, 36.2473>, <-0.374, -0.579, -0.724>, <4.1039, 0.9698, 37.6522>, <-0.136, -0.901, -0.413> }
	smooth_triangle { <4.1039, 0.9698, 37.6522>, <-0.438, -0.871, -0.224>, <1.7291, 3.0270, 36.2473>, <-0.506, -0.587, -0.632>, <1.7279, 3.0296, 36.2726>, <-0.797, -0.604, -0.018> }
	smooth_triangle { <4.1039, 0.9698, 37.6522>, <-0.275, -0.906, -0.323>, <1.7279, 3.0296, 36.2726>, <-0.797, -0.604, -0.018>, <4.0921, 0.9758, 37.6739>, <-0.353, -0.936, 0.002> }
	smooth_triangle { <5.6031, 0.7321, 39.0145>, <-0.650, -0.345, 0.677>, <4.0921, 0.9758, 37.6739>, <-0.618, -0.165, 0.769>, <4.0961, 0.9984, 37.6848>, <-0.556, 0.101, 0.825> }
	smooth_triangle { <5.6031, 0.7321, 39.0145>, <-0.588, -0.570, 0.573>, <4.0961, 0.9984, 37.6848>, <-0.653, -0.288, 0.700>, <5.5983, 0.7552, 39.0240>, <-0.647, 0.103, 0.756> }
	smooth_triangle { <5.5983, 0.7552, 39.0240>, <-0.452, 0.636, 0.626>, <4.0961, 0.9984, 37.6848>, <-0.369, 0.365, 0.854>, <4.1120, 1.0150, 37.6739>, <-0.004, 0.871, 0.491> }
	smooth_triangle { <5.5983, 0.7552, 39.0240>, <-0.615, 0.255, 0.746>, <4.1120, 1.0150, 37.6739>, <-0.180, 0.814, 0.553>, <5.6100, 0.7756, 39.0145>, <-0.090, 0.957, 0.277> }
	smooth_triangle { <5.6100, 0.7756, 39.0145>, <-0.090, 0.957, 0.277>, <4.1120, 1.0150, 37.6739>, <0.136, 0.901, 0.412>, <4.1237, 1.0091, 37.6522>, <0.555, 0.757, -0.344> }
	smooth_triangle { <5.6100, 0.7756, 39.0145>, <-0.090, 0.957, 0.277>, <4.1237, 1.0091, 37.6522>, <0.352, 0.936, -0.002>, <5.6266, 0.7729, 38.9954>, <0.464, 0.803, -0.374> }
	smooth_triangle { <5.6266, 0.7729, 38.9954>, <0.655, 0.344, -0.672>, <4.1237, 1.0091, 37.6522>, <0.646, 0.532, -0.547>, <4.1197, 0.9865, 37.6414>, <0.556, -0.101, -0.825> }
	smooth_triangle { <5.6266, 0.7729, 38.9954>, <0.533, 0.704, -0.470>, <4.1197, 0.9865, 37.6414>, <0.653, 0.288, -0.700>, <5.6314, 0.7499, 38.9859>, <0.655, -0.104, -0.749> }
	smooth_triangle { <5.6314, 0.7499, 38.9859>, <0.457, -0.636, -0.622>, <4.1197, 0.9865, 37.6414>, <0.369, -0.365, -0.854>, <4.1039, 0.9698, 37.6522>, <0.003, -0.871, -0.492> }
	smooth_triangle { <5.6314, 0.7499, 38.9859>, <0.622, -0.256, -0.740>, <4.1039, 0.9698, 37.6522>, <0.179, -0.814, -0.553>, <5.6197, 0.7295, 38.9954>, <0.097, -0.958, -0.271> }
	smooth_triangle { <5.6197, 0.7295, 38.9954>, <0.097, -0.958, -0.271>, <4.1039, 0.9698, 37.6522>, <-0.136, -0.901, -0.413>, <4.0921, 0.9758, 37.6739>, <-0.353, -0.936, 0.002> }
	smooth_triangle { <5.6197, 0.7295, 38.9954>, <0.097, -0.958, -0.271>, <4.0921, 0.9758, 37.6739>, <-0.353, -0.936, 0.002>, <5.6031, 0.7321, 39.0145>, <-0.158, -0.987, -0.001> }
	smooth_triangle { <7.1290, 0.5234, 40.3405>, <-0.626, -0.406, 0.665>, <5.6031, 0.7321, 39.0145>, <-0.588, -0.570, 0.573>, <5.5983, 0.7552, 39.0240>, <-0.647, 0.103, 0.756> }
	smooth_triangle { <7.1290, 0.5234, 40.3405>, <-0.474, 0.582, 0.661>, <5.5983, 0.7552, 39.0240>, <-0.615, 0.255, 0.746>, <5.6100, 0.7756, 39.0145>, <-0.090, 0.957, 0.277> }
	smooth_triangle { <7.1290, 0.5234, 40.3405>, <0.165, 0.986, 0.007>, <5.6100, 0.7756, 39.0145>, <-0.090, 0.957, 0.277>, <5.6266, 0.7729, 38.9954>, <0.464, 0.803, -0.374> }
	smooth_triangle { <7.1290, 0.5234, 40.3405>, <0.651, 0.403, -0.644>, <5.6266, 0.7729, 38.9954>, <0.533, 0.704, -0.470>, <5.6314, 0.7499, 38.9859>, <0.655, -0.104, -0.749> }
	smooth_triangle { <7.1290, 0.5234, 40.3405>, <0.498, -0.585, -0.640>, <5.6314, 0.7499, 38.9859>, <0.622, -0.256, -0.740>, <5.6197, 0.7295, 38.9954>, <0.097, -0.958, -0.271> }
	smooth_triangle { <7.1290, 0.5234, 40.3405>, <-0.141, -0.990, 0.014>, <5.6197, 0.7295, 38.9954>, <0.097, -0.958, -0.271>, <5.6031, 0.7321, 39.0145>, <-0.537, -0.680, 0.500> }
	smooth_triangle { <1.3249, 3.0147, 37.4032>, <0.752, 0.582, 0.309>, <1.7580, 3.0605, 36.2645>, <0.752, 0.582, 0.309>, <1.7721, 3.0399, 36.2690>, <0.892, 0.284, 0.351> }
	smooth_triangle { <1.3249, 3.0147, 37.4032>, <0.752, 0.582, 0.309>, <1.7721, 3.0399, 36.2690>, <0.892, 0.284, 0.351>, <1.3390, 2.9940, 37.4078>, <0.932, -0.091, 0.351> }
	smooth_triangle { <1.3390, 2.9940, 37.4078>, <0.932, -0.091, 0.351>, <1.7721, 3.0399, 36.2690>, <0.892, 0.284, 0.351>, <1.7626, 3.0168, 36.2645>, <0.688, -0.687, 0.234> }
	smooth_triangle { <1.3390, 2.9940, 37.4078>, <0.932, -0.091, 0.351>, <1.7626, 3.0168, 36.2645>, <0.688, -0.687, 0.234>, <1.3295, 2.9709, 37.4032>, <0.403, -0.907, 0.117> }
	smooth_triangle { <1.3295, 2.9709, 37.4032>, <0.403, -0.907, 0.117>, <1.7626, 3.0168, 36.2645>, <0.688, -0.687, 0.234>, <1.7390, 3.0143, 36.2554>, <-0.205, -0.972, -0.117> }
	smooth_triangle { <1.3295, 2.9709, 37.4032>, <0.403, -0.907, 0.117>, <1.7390, 3.0143, 36.2554>, <-0.205, -0.972, -0.117>, <1.3059, 2.9684, 37.3942>, <-0.528, -0.816, -0.234> }
	smooth_triangle { <1.3059, 2.9684, 37.3942>, <-0.528, -0.816, -0.234>, <1.7390, 3.0143, 36.2554>, <-0.205, -0.972, -0.117>, <1.7249, 3.0349, 36.2509>, <-0.892, -0.284, -0.351> }
	smooth_triangle { <1.3059, 2.9684, 37.3942>, <-0.528, -0.816, -0.234>, <1.7249, 3.0349, 36.2509>, <-0.892, -0.284, -0.351>, <1.2918, 2.9891, 37.3896>, <-0.932, 0.091, -0.351> }
	smooth_triangle { <1.2918, 2.9891, 37.3896>, <-0.932, 0.091, -0.351>, <1.7249, 3.0349, 36.2509>, <-0.892, -0.284, -0.351>, <1.7344, 3.0580, 36.2554>, <-0.688, 0.687, -0.234> }
	smooth_triangle { <1.2918, 2.9891, 37.3896>, <-0.932, 0.091, -0.351>, <1.7344, 3.0580, 36.2554>, <-0.688, 0.687, -0.234>, <1.3013, 3.0122, 37.3942>, <-0.403, 0.907, -0.117> }
	smooth_triangle { <1.3013, 3.0122, 37.3942>, <-0.403, 0.907, -0.117>, <1.7344, 3.0580, 36.2554>, <-0.688, 0.687, -0.234>, <1.7580, 3.0605, 36.2645>, <-0.105, 0.994, 0.000> }
	smooth_triangle { <1.3013, 3.0122, 37.3942>, <-0.403, 0.907, -0.117>, <1.7580, 3.0605, 36.2645>, <-0.105, 0.994, 0.000>, <1.3249, 3.0147, 37.4032>, <-0.105, 0.994, 0.000> }
	smooth_triangle { <1.1649, 2.0855, 36.7502>, <-0.259, 0.546, 0.797>, <1.7321, 3.0528, 36.2716>, <-0.312, 0.450, 0.837>, <1.7536, 3.0460, 36.2833>, <-0.025, 0.336, 0.941> }
	smooth_triangle { <1.1649, 2.0855, 36.7502>, <-0.259, 0.546, 0.797>, <1.7536, 3.0460, 36.2833>, <-0.025, 0.336, 0.941>, <1.1864, 2.0786, 36.7618>, <0.358, 0.237, 0.903> }
	smooth_triangle { <1.1864, 2.0786, 36.7618>, <0.358, 0.237, 0.903>, <1.7536, 3.0460, 36.2833>, <-0.025, 0.336, 0.941>, <1.7700, 3.0306, 36.2716>, <0.763, -0.187, 0.618> }
	smooth_triangle { <1.1864, 2.0786, 36.7618>, <0.358, 0.237, 0.903>, <1.7700, 3.0306, 36.2716>, <0.763, -0.187, 0.618>, <1.2029, 2.0632, 36.7502>, <0.880, -0.367, 0.301> }
	smooth_triangle { <1.2029, 2.0632, 36.7502>, <0.880, -0.367, 0.301>, <1.7700, 3.0306, 36.2716>, <0.763, -0.187, 0.618>, <1.7650, 3.0220, 36.2483>, <0.789, -0.523, -0.322> }
	smooth_triangle { <1.2029, 2.0632, 36.7502>, <0.880, -0.367, 0.301>, <1.7650, 3.0220, 36.2483>, <0.789, -0.523, -0.322>, <1.1978, 2.0546, 36.7268>, <0.522, -0.604, -0.602> }
	smooth_triangle { <1.1978, 2.0546, 36.7268>, <0.522, -0.604, -0.602>, <1.7650, 3.0220, 36.2483>, <0.789, -0.523, -0.322>, <1.7435, 3.0288, 36.2366>, <0.025, -0.336, -0.941> }
	smooth_triangle { <1.1978, 2.0546, 36.7268>, <0.522, -0.604, -0.602>, <1.7435, 3.0288, 36.2366>, <0.025, -0.336, -0.941>, <1.1763, 2.0614, 36.7151>, <-0.358, -0.237, -0.903> }
	smooth_triangle { <1.1763, 2.0614, 36.7151>, <-0.358, -0.237, -0.903>, <1.7435, 3.0288, 36.2366>, <0.025, -0.336, -0.941>, <1.7270, 3.0442, 36.2483>, <-0.763, 0.187, -0.618> }
	smooth_triangle { <1.1763, 2.0614, 36.7151>, <-0.358, -0.237, -0.903>, <1.7270, 3.0442, 36.2483>, <-0.763, 0.187, -0.618>, <1.1599, 2.0769, 36.7268>, <-0.880, 0.367, -0.301> }
	smooth_triangle { <1.1599, 2.0769, 36.7268>, <-0.880, 0.367, -0.301>, <1.7270, 3.0442, 36.2483>, <-0.763, 0.187, -0.618>, <1.7321, 3.0528, 36.2716>, <-0.885, 0.465, 0.009> }
	smooth_triangle { <1.1599, 2.0769, 36.7268>, <-0.880, 0.367, -0.301>, <1.7321, 3.0528, 36.2716>, <-0.885, 0.465, 0.009>, <1.1649, 2.0855, 36.7502>, <-0.863, 0.506, 0.000> }
	smooth_triangle { <0.2353, -0.1682, 36.9421>, <-0.435, 0.229, 0.871>, <1.7321, 3.0528, 36.2716>, <-0.312, 0.450, 0.837>, <1.7536, 3.0460, 36.2833>, <-0.025, 0.336, 0.941> }
	smooth_triangle { <0.2353, -0.1682, 36.9421>, <-0.435, 0.229, 0.871>, <1.7536, 3.0460, 36.2833>, <-0.025, 0.336, 0.941>, <0.2560, -0.1757, 36.9547>, <0.010, -0.014, 1.000> }
	smooth_triangle { <0.2560, -0.1757, 36.9547>, <0.010, -0.014, 1.000>, <1.7536, 3.0460, 36.2833>, <-0.025, 0.336, 0.941>, <1.7700, 3.0306, 36.2716>, <0.763, -0.187, 0.618> }
	smooth_triangle { <0.2560, -0.1757, 36.9547>, <0.010, -0.014, 1.000>, <1.7700, 3.0306, 36.2716>, <0.763, -0.187, 0.618>, <0.2759, -0.1850, 36.9421>, <0.817, -0.304, 0.490> }
	smooth_triangle { <0.2759, -0.1850, 36.9421>, <0.817, -0.304, 0.490>, <1.7700, 3.0306, 36.2716>, <0.763, -0.187, 0.618>, <1.7650, 3.0220, 36.2483>, <0.789, -0.523, -0.322> }
	smooth_triangle { <0.2759, -0.1850, 36.9421>, <0.817, -0.304, 0.490>, <1.7650, 3.0220, 36.2483>, <0.789, -0.523, -0.322>, <0.2752, -0.1868, 36.9167>, <0.813, -0.291, -0.504> }
	smooth_triangle { <0.2752, -0.1868, 36.9167>, <0.813, -0.291, -0.504>, <1.7650, 3.0220, 36.2483>, <0.789, -0.523, -0.322>, <1.7435, 3.0288, 36.2366>, <0.025, -0.336, -0.941> }
	smooth_triangle { <0.2752, -0.1868, 36.9167>, <0.813, -0.291, -0.504>, <1.7435, 3.0288, 36.2366>, <0.025, -0.336, -0.941>, <0.2545, -0.1794, 36.9041>, <-0.010, 0.014, -1.000> }
	smooth_triangle { <0.2545, -0.1794, 36.9041>, <-0.010, 0.014, -1.000>, <1.7435, 3.0288, 36.2366>, <0.025, -0.336, -0.941>, <1.7270, 3.0442, 36.2483>, <-0.763, 0.187, -0.618> }
	smooth_triangle { <0.2545, -0.1794, 36.9041>, <-0.010, 0.014, -1.000>, <1.7270, 3.0442, 36.2483>, <-0.763, 0.187, -0.618>, <0.2345, -0.1701, 36.9167>, <-0.817, 0.304, -0.490> }
	smooth_triangle { <0.2345, -0.1701, 36.9167>, <-0.817, 0.304, -0.490>, <1.7270, 3.0442, 36.2483>, <-0.763, 0.187, -0.618>, <1.7321, 3.0528, 36.2716>, <-0.885, 0.465, 0.009> }
	smooth_triangle { <0.2345, -0.1701, 36.9167>, <-0.817, 0.304, -0.490>, <1.7321, 3.0528, 36.2716>, <-0.885, 0.465, 0.009>, <0.2353, -0.1682, 36.9421>, <-0.962, 0.273, 0.004> }
	smooth_triangle { <-0.1646, -2.1417, 36.6204>, <-0.729, -0.102, 0.677>, <0.2353, -0.1682, 36.9421>, <-0.435, 0.229, 0.871>, <0.2560, -0.1757, 36.9547>, <0.010, -0.014, 1.000> }
	smooth_triangle { <-0.1646, -2.1417, 36.6204>, <-0.729, -0.102, 0.677>, <0.2560, -0.1757, 36.9547>, <0.010, -0.014, 1.000>, <-0.1434, -2.1480, 36.6330>, <0.043, -0.356, 0.933> }
	smooth_triangle { <-0.1434, -2.1480, 36.6330>, <0.043, -0.356, 0.933>, <0.2560, -0.1757, 36.9547>, <0.010, -0.014, 1.000>, <0.2759, -0.1850, 36.9421>, <0.817, -0.304, 0.490> }
	smooth_triangle { <-0.1434, -2.1480, 36.6330>, <0.043, -0.356, 0.933>, <0.2759, -0.1850, 36.9421>, <0.817, -0.304, 0.490>, <-0.1214, -2.1504, 36.6204>, <0.874, -0.322, 0.365> }
	smooth_triangle { <-0.1214, -2.1504, 36.6204>, <0.874, -0.322, 0.365>, <0.2759, -0.1850, 36.9421>, <0.817, -0.304, 0.490>, <0.2752, -0.1868, 36.9167>, <0.813, -0.291, -0.504> }
	smooth_triangle { <-0.1214, -2.1504, 36.6204>, <0.874, -0.322, 0.365>, <0.2752, -0.1868, 36.9167>, <0.813, -0.291, -0.504>, <-0.1206, -2.1465, 36.5953>, <0.827, 0.029, -0.561> }
	smooth_triangle { <-0.1206, -2.1465, 36.5953>, <0.827, 0.029, -0.561>, <0.2752, -0.1868, 36.9167>, <0.813, -0.291, -0.504>, <0.2545, -0.1794, 36.9041>, <-0.010, 0.014, -1.000> }
	smooth_triangle { <-0.1206, -2.1465, 36.5953>, <0.827, 0.029, -0.561>, <0.2545, -0.1794, 36.9041>, <-0.010, 0.014, -1.000>, <-0.1418, -2.1402, 36.5828>, <-0.045, 0.348, -0.936> }
	smooth_triangle { <-0.1418, -2.1402, 36.5828>, <-0.045, 0.348, -0.936>, <0.2545, -0.1794, 36.9041>, <-0.010, 0.014, -1.000>, <0.2345, -0.1701, 36.9167>, <-0.817, 0.304, -0.490> }
	smooth_triangle { <-0.1418, -2.1402, 36.5828>, <-0.045, 0.348, -0.936>, <0.2345, -0.1701, 36.9167>, <-0.817, 0.304, -0.490>, <-0.1638, -2.1378, 36.5953>, <-0.876, 0.313, -0.368> }
	smooth_triangle { <-0.1638, -2.1378, 36.5953>, <-0.876, 0.313, -0.368>, <0.2345, -0.1701, 36.9167>, <-0.817, 0.304, -0.490>, <0.2353, -0.1682, 36.9421>, <-0.962, 0.273, 0.004> }
	smooth_triangle { <-0.1638, -2.1378, 36.5953>, <-0.876, 0.313, -0.368>, <0.2353, -0.1682, 36.9421>, <-0.962, 0.273, 0.004>, <-0.1646, -2.1417, 36.6204>, <-0.980, 0.199, 0.000> }
	smooth_triangle { <-0.3915, -3.7776, 35.4252>, <-0.578, -0.432, 0.692>, <-0.1646, -2.1417, 36.6204>, <-0.729, -0.102, 0.677>, <-0.1434, -2.1480, 36.6330>, <0.043, -0.356, 0.933> }
	smooth_triangle { <-0.3915, -3.7776, 35.4252>, <0.386, -0.591, 0.709>, <-0.1434, -2.1480, 36.6330>, <0.043, -0.356, 0.933>, <-0.1214, -2.1504, 36.6204>, <0.874, -0.322, 0.365> }
	smooth_triangle { <-0.3915, -3.7776, 35.4252>, <0.985, -0.175, 0.007>, <-0.1214, -2.1504, 36.6204>, <0.874, -0.322, 0.365>, <-0.1206, -2.1465, 36.5953>, <0.827, 0.029, -0.561> }
	smooth_triangle { <-0.3915, -3.7776, 35.4252>, <0.577, 0.406, -0.708>, <-0.1206, -2.1465, 36.5953>, <0.827, 0.029, -0.561>, <-0.1418, -2.1402, 36.5828>, <-0.045, 0.348, -0.936> }
	smooth_triangle { <-0.3915, -3.7776, 35.4252>, <-0.394, 0.566, -0.725>, <-0.1418, -2.1402, 36.5828>, <-0.045, 0.348, -0.936>, <-0.1638, -2.1378, 36.5953>, <-0.876, 0.313, -0.368> }
	smooth_triangle { <-0.3915, -3.7776, 35.4252>, <-0.989, 0.145, -0.019>, <-0.1638, -2.1378, 36.5953>, <-0.876, 0.313, -0.368>, <-0.1646, -2.1417, 36.6204>, <-0.729, -0.102, 0.677> }

	texture { PSWL_BARK }
}

/* Object 'PWL0005F' */
union {
	smooth_triangle { <1.5077, 3.7476, 35.2972>, <0.299, -0.733, -0.611>, <0.8711, 3.7149, 35.0343>, <0.295, -0.722, -0.626>, <0.3091, 3.3271, 35.2163>, <0.299, -0.733, -0.611> }
	smooth_triangle { <0.3091, 3.3271, 35.2163>, <0.299, -0.733, -0.611>, <0.9603, 3.3742, 35.4871>, <0.301, -0.745, -0.595>, <1.5077, 3.7476, 35.2972>, <0.299, -0.733, -0.611> }
	smooth_triangle { <1.8005, 3.0354, 36.2481>, <0.157, 0.816, 0.557>, <2.3589, 3.1747, 35.8846>, <0.157, 0.818, 0.554>, <3.0193, 2.9894, 35.9711>, <0.157, 0.816, 0.557> }
	smooth_triangle { <3.0193, 2.9894, 35.9711>, <0.157, 0.816, 0.557>, <2.4441, 2.8494, 36.3374>, <0.158, 0.814, 0.559>, <1.8005, 3.0354, 36.2481>, <0.157, 0.816, 0.557> }
	smooth_triangle { <1.9234, 2.2533, 37.1786>, <0.791, -0.438, -0.428>, <1.5655, 1.9796, 36.7151>, <0.799, -0.514, -0.313>, <1.2542, 1.4924, 36.7211>, <0.791, -0.438, -0.428> }
	smooth_triangle { <1.2542, 1.4924, 36.7211>, <0.791, -0.438, -0.428>, <1.6406, 1.7084, 37.1325>, <0.767, -0.353, -0.535>, <1.9234, 2.2533, 37.1786>, <0.791, -0.438, -0.428> }
	smooth_triangle { <2.2150, 1.5504, 38.1361>, <-0.053, 0.746, 0.664>, <2.8239, 1.8530, 37.8427>, <-0.054, 0.749, 0.660>, <3.5617, 1.7612, 38.0073>, <-0.053, 0.746, 0.664> }
	smooth_triangle { <3.5617, 1.7612, 38.0073>, <-0.053, 0.746, 0.664>, <2.9346, 1.4531, 38.3003>, <-0.052, 0.742, 0.669>, <2.2150, 1.5504, 38.1361>, <-0.053, 0.746, 0.664> }
	smooth_triangle { <2.0767, 0.8370, 38.5397>, <0.130, -0.519, -0.845>, <1.4738, 1.0533, 38.2981>, <0.128, -0.559, -0.819>, <0.8313, 0.7987, 38.3718>, <0.130, -0.519, -0.845> }
	smooth_triangle { <0.8313, 0.7987, 38.3718>, <0.130, -0.519, -0.845>, <1.4511, 0.5691, 38.5918>, <0.132, -0.477, -0.869>, <2.0767, 0.8370, 38.5397>, <0.130, -0.519, -0.845> }
	smooth_triangle { <2.1291, 0.1129, 38.9166>, <0.787, 0.218, 0.577>, <2.4206, 0.1393, 38.5639>, <0.765, 0.088, 0.639>, <2.6996, -0.2770, 38.2869>, <0.787, 0.218, 0.577> }
	smooth_triangle { <2.6996, -0.2770, 38.2869>, <0.787, 0.218, 0.577>, <2.4024, -0.2484, 38.7343>, <0.792, 0.345, 0.504>, <2.1291, 0.1129, 38.9166>, <0.787, 0.218, 0.577> }
	smooth_triangle { <1.8090, -0.5814, 39.2539>, <0.405, -0.604, -0.686>, <1.2607, -0.4550, 38.8049>, <0.402, -0.627, -0.667>, <0.5065, -0.8352, 38.7077>, <0.405, -0.604, -0.686> }
	smooth_triangle { <0.5065, -0.8352, 38.7077>, <0.405, -0.604, -0.686>, <1.0727, -0.9686, 39.1461>, <0.408, -0.581, -0.704>, <1.8090, -0.5814, 39.2539>, <0.405, -0.604, -0.686> }
	smooth_triangle { <1.6661, -1.2927, 39.5762>, <0.412, 0.150, 0.899>, <2.1187, -1.2199, 39.3519>, <0.415, 0.170, 0.894>, <2.4635, -1.5190, 39.2485>, <0.412, 0.150, 0.899> }
	smooth_triangle { <2.4635, -1.5190, 39.2485>, <0.412, 0.150, 0.899>, <1.9994, -1.5936, 39.4688>, <0.408, 0.129, 0.904>, <1.6661, -1.2927, 39.5762>, <0.412, 0.150, 0.899> }
	smooth_triangle { <1.9503, 2.4636, 36.3271>, <0.068, -0.094, -0.993>, <1.2698, 2.4627, 36.2825>, <0.065, -0.087, -0.994>, <0.8062, 1.9409, 36.2978>, <0.068, -0.094, -0.993> }
	smooth_triangle { <0.8062, 1.9409, 36.2978>, <0.068, -0.094, -0.993>, <1.5026, 1.9496, 36.3471>, <0.071, -0.101, -0.992>, <1.9503, 2.4636, 36.3271>, <0.068, -0.094, -0.993> }
	smooth_triangle { <2.2977, 1.9557, 36.3931>, <0.009, 0.146, 0.989>, <2.7964, 2.5194, 36.3089>, <0.014, 0.136, 0.991>, <3.5713, 2.5218, 36.2979>, <0.009, 0.146, 0.989> }
	smooth_triangle { <3.5713, 2.5218, 36.2979>, <0.009, 0.146, 0.989>, <3.0544, 1.9508, 36.3903>, <0.005, 0.156, 0.988>, <2.2977, 1.9557, 36.3931>, <0.009, 0.146, 0.989> }
	smooth_triangle { <3.1643, 1.4143, 37.0142>, <0.517, 0.121, -0.847>, <2.7664, 0.9435, 36.6861>, <0.558, 0.102, -0.823>, <2.8207, 0.2245, 36.6338>, <0.517, 0.121, -0.847> }
	smooth_triangle { <2.8207, 0.2245, 36.6338>, <0.517, 0.121, -0.847>, <3.2384, 0.7044, 36.9398>, <0.475, 0.141, -0.869>, <3.1643, 1.4143, 37.0142>, <0.517, 0.121, -0.847> }
	smooth_triangle { <4.1424, 1.0152, 37.6294>, <-0.108, 0.871, 0.479>, <4.3601, 1.3904, 37.0227>, <-0.074, 0.860, 0.505>, <4.9864, 1.5724, 36.8049>, <-0.108, 0.871, 0.479> }
	smooth_triangle { <4.9864, 1.5724, 36.8049>, <-0.108, 0.871, 0.479>, <4.7383, 1.1988, 37.4574>, <-0.141, 0.881, 0.451>, <4.1424, 1.0152, 37.6294>, <-0.108, 0.871, 0.479> }
	smooth_triangle { <4.8645, 0.8208, 38.3212>, <0.579, 0.229, -0.783>, <4.6902, 0.3160, 38.0426>, <0.584, 0.228, -0.779>, <4.9312, -0.2700, 38.0514>, <0.579, 0.229, -0.783> }
	smooth_triangle { <4.9312, -0.2700, 38.0514>, <0.579, 0.229, -0.783>, <5.1068, 0.2497, 38.3312>, <0.573, 0.230, -0.786>, <4.8645, 0.8208, 38.3212>, <0.579, 0.229, -0.783> }
	smooth_triangle { <5.6304, 0.8029, 38.9964>, <-0.551, 0.302, 0.778>, <5.6006, 1.2974, 38.7757>, <-0.572, 0.305, 0.761>, <5.9234, 1.7499, 38.8367>, <-0.551, 0.302, 0.778> }
	smooth_triangle { <5.9234, 1.7499, 38.8367>, <-0.551, 0.302, 0.778>, <5.9572, 1.2407, 39.0504>, <-0.530, 0.298, 0.794>, <5.6304, 0.8029, 38.9964>, <-0.551, 0.302, 0.778> }
	smooth_triangle { <6.3731, 0.5857, 39.6620>, <0.602, 0.173, -0.779>, <6.2125, 0.1429, 39.4320>, <0.623, 0.171, -0.763>, <6.3951, -0.3653, 39.4674>, <0.602, 0.173, -0.779> }
	smooth_triangle { <6.3951, -0.3653, 39.4674>, <0.602, 0.173, -0.779>, <6.5633, 0.0896, 39.6912>, <0.581, 0.176, -0.794>, <6.3731, 0.5857, 39.6620>, <0.602, 0.173, -0.779> }
	smooth_triangle { <7.1607, 0.5539, 40.3104>, <-0.359, 0.818, 0.450>, <7.2939, 0.8559, 39.8777>, <-0.344, 0.816, 0.464>, <7.7481, 1.1186, 39.7517>, <-0.359, 0.818, 0.450> }
	smooth_triangle { <7.7481, 1.1186, 39.7517>, <-0.359, 0.818, 0.450>, <7.5973, 0.8102, 40.2031>, <-0.374, 0.819, 0.435>, <7.1607, 0.5539, 40.3104>, <-0.359, 0.818, 0.450> }
	smooth_triangle { <1.5041, 3.0591, 36.8205>, <-0.762, -0.545, -0.349>, <1.3785, 3.4491, 36.5671>, <-0.703, -0.532, -0.471>, <1.0246, 3.8264, 36.6690>, <-0.762, -0.545, -0.349> }
	smooth_triangle { <1.0246, 3.8264, 36.6690>, <-0.762, -0.545, -0.349>, <1.2163, 3.4319, 36.9474>, <-0.807, -0.548, -0.221>, <1.5041, 3.0591, 36.8205>, <-0.762, -0.545, -0.349> }
	smooth_triangle { <1.2767, 2.9585, 37.3827>, <0.572, -0.785, 0.239>, <1.0277, 2.6569, 37.0277>, <0.556, -0.784, 0.276>, <0.5313, 2.3212, 37.0735>, <0.572, -0.785, 0.239> }
	smooth_triangle { <0.5313, 2.3212, 37.0735>, <0.572, -0.785, 0.239>, <0.8232, 2.6352, 37.4452>, <0.587, -0.784, 0.202>, <1.2767, 2.9585, 37.3827>, <0.572, -0.785, 0.239> }
	smooth_triangle { <1.4187, 2.5707, 36.4787>, <0.170, -0.537, -0.826>, <1.0565, 2.9641, 36.1889>, <0.229, -0.432, -0.872>, <0.4289, 2.9335, 36.0390>, <0.170, -0.537, -0.826> }
	smooth_triangle { <0.4289, 2.9335, 36.0390>, <0.170, -0.537, -0.826>, <0.8197, 2.5601, 36.4032>, <0.108, -0.634, -0.766>, <1.4187, 2.5707, 36.4787>, <0.170, -0.537, -0.826> }
	smooth_triangle { <1.2251, 2.0405, 36.7306>, <0.335, 0.252, 0.908>, <1.8179, 1.9383, 36.5620>, <0.299, 0.192, 0.935>, <2.1734, 1.3995, 36.5589>, <0.335, 0.252, 0.908> }
	smooth_triangle { <2.1734, 1.3995, 36.5589>, <0.335, 0.252, 0.908>, <1.5752, 1.5243, 36.7665>, <0.369, 0.311, 0.876>, <1.2251, 2.0405, 36.7306>, <0.335, 0.252, 0.908> }
	smooth_triangle { <0.6815, 0.9583, 36.7972>, <0.608, -0.337, -0.719>, <0.4266, 1.2733, 36.3978>, <0.558, -0.440, -0.703>, <-0.0063, 1.1834, 36.1105>, <0.608, -0.337, -0.719> }
	smooth_triangle { <-0.0063, 1.1834, 36.1105>, <0.608, -0.337, -0.719>, <0.2562, 0.8599, 36.4479>, <0.649, -0.230, -0.725>, <0.6815, 0.9583, 36.7972>, <0.608, -0.337, -0.719> }
	smooth_triangle { <0.3016, -0.1981, 36.9130>, <0.294, -0.098, 0.951>, <0.8096, -0.1779, 36.7781>, <0.259, -0.176, 0.950>, <1.1591, -0.5772, 36.6089>, <0.294, -0.098, 0.951> }
	smooth_triangle { <1.1591, -0.5772, 36.6089>, <0.294, -0.098, 0.951>, <0.6402, -0.5891, 36.7881>, <0.327, -0.019, 0.945>, <0.3016, -0.1981, 36.9130>, <0.294, -0.098, 0.951> }
	smooth_triangle { <0.0058, -1.1486, 36.7565>, <0.261, 0.131, -0.956>, <-0.5894, -0.6818, 36.6449>, <0.254, 0.093, -0.963>, <-1.3280, -0.8264, 36.4361>, <0.261, 0.131, -0.956> }
	smooth_triangle { <-1.3280, -0.8264, 36.4361>, <0.261, 0.131, -0.956>, <-0.7132, -1.2938, 36.5272>, <0.269, 0.168, -0.948>, <0.0058, -1.1486, 36.7565>, <0.261, 0.131, -0.956> }
	smooth_triangle { <-0.0941, -2.1504, 36.5865>, <0.385, -0.129, 0.914>, <0.5977, -1.9221, 36.3334>, <0.382, -0.147, 0.912>, <1.1819, -2.3167, 36.0250>, <0.385, -0.129, 0.914> }
	smooth_triangle { <1.1819, -2.3167, 36.0250>, <0.385, -0.129, 0.914>, <0.4717, -2.5447, 36.2984>, <0.388, -0.112, 0.915>, <-0.0941, -2.1504, 36.5865>, <0.385, -0.129, 0.914> }
	smooth_triangle { <-0.2963, -2.9480, 35.9739>, <0.832, 0.061, -0.552>, <-0.5395, -2.6334, 35.6367>, <0.830, 0.046, -0.556>, <-0.8507, -2.7037, 35.1660>, <0.832, 0.061, -0.552> }
	smooth_triangle { <-0.8507, -2.7037, 35.1660>, <0.832, 0.061, -0.552>, <-0.5994, -3.0200, 35.5037>, <0.833, 0.076, -0.548>, <-0.2963, -2.9480, 35.9739>, <0.832, 0.061, -0.552> }
	smooth_triangle { <-0.3586, -3.7774, 35.3832>, <0.736, -0.358, 0.575>, <-0.0150, -3.5849, 35.0970>, <0.707, -0.441, 0.552>, <0.2792, -3.7734, 34.5696>, <0.736, -0.358, 0.575> }
	smooth_triangle { <0.2792, -3.7734, 34.5696>, <0.736, -0.358, 0.575>, <-0.0754, -3.9759, 34.9304>, <0.758, -0.271, 0.593>, <-0.3586, -3.7774, 35.3832>, <0.736, -0.358, 0.575> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0006B' */
union {
	smooth_triangle { <1.4751, 6.7460, 34.0970>, <0.378, -0.627, 0.681>, <1.2106, 5.4950, 33.0931>, <0.378, -0.631, 0.678>, <1.1875, 5.4919, 33.1031>, <0.085, -0.652, 0.753> }
	smooth_triangle { <1.4751, 6.7460, 34.0970>, <0.378, -0.627, 0.681>, <1.1875, 5.4919, 33.1031>, <0.085, -0.652, 0.753>, <1.4520, 6.7429, 34.1070>, <-0.310, -0.554, 0.772> }
	smooth_triangle { <1.4520, 6.7429, 34.1070>, <-0.310, -0.554, 0.772>, <1.1875, 5.4919, 33.1031>, <0.085, -0.652, 0.753>, <1.1676, 5.5041, 33.0931>, <-0.816, -0.305, 0.492> }
	smooth_triangle { <1.4520, 6.7429, 34.1070>, <-0.310, -0.554, 0.772>, <1.1676, 5.5041, 33.0931>, <-0.816, -0.305, 0.492>, <1.4321, 6.7551, 34.0970>, <-0.966, -0.002, 0.257> }
	smooth_triangle { <1.4321, 6.7551, 34.0970>, <-0.966, -0.002, 0.257>, <1.1676, 5.5041, 33.0931>, <-0.816, -0.305, 0.492>, <1.1708, 5.5195, 33.0731>, <-0.901, 0.347, -0.262> }
	smooth_triangle { <1.4321, 6.7551, 34.0970>, <-0.966, -0.002, 0.257>, <1.1708, 5.5195, 33.0731>, <-0.901, 0.347, -0.262>, <1.4353, 6.7704, 34.0770>, <-0.656, 0.552, -0.515> }
	smooth_triangle { <1.4353, 6.7704, 34.0770>, <-0.656, 0.552, -0.515>, <1.1708, 5.5195, 33.0731>, <-0.901, 0.347, -0.262>, <1.1940, 5.5226, 33.0631>, <-0.085, 0.652, -0.753> }
	smooth_triangle { <1.4353, 6.7704, 34.0770>, <-0.656, 0.552, -0.515>, <1.1940, 5.5226, 33.0631>, <-0.085, 0.652, -0.753>, <1.4585, 6.7736, 34.0670>, <0.310, 0.554, -0.772> }
	smooth_triangle { <1.4585, 6.7736, 34.0670>, <0.310, 0.554, -0.772>, <1.1940, 5.5226, 33.0631>, <-0.085, 0.652, -0.753>, <1.2139, 5.5104, 33.0731>, <0.816, 0.305, -0.492> }
	smooth_triangle { <1.4585, 6.7736, 34.0670>, <0.310, 0.554, -0.772>, <1.2139, 5.5104, 33.0731>, <0.816, 0.305, -0.492>, <1.4784, 6.7613, 34.0770>, <0.966, 0.002, -0.257> }
	smooth_triangle { <1.4784, 6.7613, 34.0770>, <0.966, 0.002, -0.257>, <1.2139, 5.5104, 33.0731>, <0.816, 0.305, -0.492>, <1.2106, 5.4950, 33.0931>, <0.990, -0.138, 0.003> }
	smooth_triangle { <1.4784, 6.7613, 34.0770>, <0.966, 0.002, -0.257>, <1.2106, 5.4950, 33.0931>, <0.990, -0.138, 0.003>, <1.4751, 6.7460, 34.0970>, <0.978, -0.207, 0.000> }
	smooth_triangle { <1.4030, 8.4905, 35.8025>, <0.475, -0.568, 0.672>, <1.2106, 5.4950, 33.0931>, <0.378, -0.631, 0.678>, <1.1875, 5.4919, 33.1031>, <0.085, -0.652, 0.753> }
	smooth_triangle { <1.4030, 8.4905, 35.8025>, <0.475, -0.568, 0.672>, <1.1875, 5.4919, 33.1031>, <0.085, -0.652, 0.753>, <1.3814, 8.4806, 35.8116>, <0.027, -0.639, 0.769> }
	smooth_triangle { <1.3814, 8.4806, 35.8116>, <-0.122, -0.658, 0.743>, <1.1875, 5.4919, 33.1031>, <0.085, -0.652, 0.753>, <1.1676, 5.5041, 33.0931>, <-0.816, -0.305, 0.492> }
	smooth_triangle { <1.3814, 8.4806, 35.8116>, <0.027, -0.639, 0.769>, <1.1676, 5.5041, 33.0931>, <-0.816, -0.305, 0.492>, <1.3591, 8.4886, 35.8025>, <-0.846, -0.402, 0.350> }
	smooth_triangle { <1.3591, 8.4886, 35.8025>, <-0.918, -0.306, 0.254>, <1.1676, 5.5041, 33.0931>, <-0.816, -0.305, 0.492>, <1.1708, 5.5195, 33.0731>, <-0.901, 0.347, -0.262> }
	smooth_triangle { <1.3591, 8.4886, 35.8025>, <-0.918, -0.306, 0.254>, <1.1708, 5.5195, 33.0731>, <-0.901, 0.347, -0.262>, <1.3583, 8.5063, 35.7844>, <-0.874, 0.241, -0.423> }
	smooth_triangle { <1.3583, 8.5063, 35.7844>, <-0.795, 0.356, -0.492>, <1.1708, 5.5195, 33.0731>, <-0.901, 0.347, -0.262>, <1.1940, 5.5226, 33.0631>, <-0.085, 0.652, -0.753> }
	smooth_triangle { <1.3583, 8.5063, 35.7844>, <-0.795, 0.356, -0.492>, <1.1940, 5.5226, 33.0631>, <-0.085, 0.652, -0.753>, <1.3799, 8.5162, 35.7753>, <-0.027, 0.639, -0.769> }
	smooth_triangle { <1.3799, 8.5162, 35.7753>, <0.122, 0.659, -0.742>, <1.1940, 5.5226, 33.0631>, <-0.085, 0.652, -0.753>, <1.2139, 5.5104, 33.0731>, <0.816, 0.305, -0.492> }
	smooth_triangle { <1.3799, 8.5162, 35.7753>, <-0.027, 0.639, -0.769>, <1.2139, 5.5104, 33.0731>, <0.816, 0.305, -0.492>, <1.4022, 8.5082, 35.7844>, <0.846, 0.402, -0.350> }
	smooth_triangle { <1.4022, 8.5082, 35.7844>, <0.917, 0.307, -0.253>, <1.2139, 5.5104, 33.0731>, <0.816, 0.305, -0.492>, <1.2106, 5.4950, 33.0931>, <0.990, -0.138, 0.003> }
	smooth_triangle { <1.4022, 8.5082, 35.7844>, <0.917, 0.307, -0.253>, <1.2106, 5.4950, 33.0931>, <0.990, -0.138, 0.003>, <1.4030, 8.4905, 35.8025>, <0.985, 0.169, 0.031> }
	smooth_triangle { <0.8107, 10.2568, 37.3839>, <0.587, -0.347, 0.731>, <1.4030, 8.4905, 35.8025>, <0.475, -0.568, 0.672>, <1.3814, 8.4806, 35.8116>, <0.027, -0.639, 0.769> }
	smooth_triangle { <0.8107, 10.2568, 37.3839>, <0.587, -0.347, 0.731>, <1.3814, 8.4806, 35.8116>, <0.344, -0.566, 0.749>, <0.7924, 10.2420, 37.3935>, <0.338, -0.489, 0.804> }
	smooth_triangle { <0.7924, 10.2420, 37.3935>, <-0.338, -0.736, 0.587>, <1.3814, 8.4806, 35.8116>, <-0.122, -0.658, 0.743>, <1.3591, 8.4886, 35.8025>, <-0.846, -0.402, 0.350> }
	smooth_triangle { <0.7924, 10.2420, 37.3935>, <0.053, -0.650, 0.758>, <1.3591, 8.4886, 35.8025>, <-0.415, -0.650, 0.636>, <0.7690, 10.2428, 37.3839>, <-0.528, -0.755, 0.389> }
	smooth_triangle { <0.7690, 10.2428, 37.3839>, <-0.915, -0.377, -0.142>, <1.3591, 8.4886, 35.8025>, <-0.918, -0.306, 0.254>, <1.3583, 8.5063, 35.7844>, <-0.874, 0.241, -0.423> }
	smooth_triangle { <0.7690, 10.2428, 37.3839>, <-0.763, -0.621, 0.180>, <1.3583, 8.5063, 35.7844>, <-0.985, -0.169, -0.032>, <0.7637, 10.2584, 37.3645>, <-0.869, -0.267, -0.417> }
	smooth_triangle { <0.7637, 10.2584, 37.3645>, <-0.588, 0.348, -0.731>, <1.3583, 8.5063, 35.7844>, <-0.795, 0.356, -0.492>, <1.3799, 8.5162, 35.7753>, <-0.027, 0.639, -0.769> }
	smooth_triangle { <0.7637, 10.2584, 37.3645>, <-0.817, 0.029, -0.576>, <1.3799, 8.5162, 35.7753>, <-0.344, 0.566, -0.750>, <0.7819, 10.2732, 37.3549>, <-0.338, 0.489, -0.804> }
	smooth_triangle { <0.7819, 10.2732, 37.3549>, <0.337, 0.737, -0.586>, <1.3799, 8.5162, 35.7753>, <0.122, 0.659, -0.742>, <1.4022, 8.5082, 35.7844>, <0.846, 0.402, -0.350> }
	smooth_triangle { <0.7819, 10.2732, 37.3549>, <-0.054, 0.652, -0.756>, <1.4022, 8.5082, 35.7844>, <0.416, 0.650, -0.636>, <0.8054, 10.2724, 37.3645>, <0.529, 0.755, -0.388> }
	smooth_triangle { <0.8054, 10.2724, 37.3645>, <0.915, 0.377, 0.143>, <1.4022, 8.5082, 35.7844>, <0.917, 0.307, -0.253>, <1.4030, 8.4905, 35.8025>, <0.985, 0.169, 0.031> }
	smooth_triangle { <0.8054, 10.2724, 37.3645>, <0.762, 0.623, -0.178>, <1.4030, 8.4905, 35.8025>, <0.985, 0.169, 0.031>, <0.8107, 10.2568, 37.3839>, <0.815, 0.573, 0.092> }
	smooth_triangle { <-0.1978, 11.1403, 38.3197>, <0.678, -0.038, 0.734>, <0.8107, 10.2568, 37.3839>, <0.587, -0.347, 0.731>, <0.7924, 10.2420, 37.3935>, <0.338, -0.489, 0.804> }
	smooth_triangle { <-0.1978, 11.1403, 38.3197>, <0.697, 0.224, 0.681>, <0.7924, 10.2420, 37.3935>, <0.657, -0.173, 0.734>, <-0.2067, 11.1189, 38.3301>, <0.512, -0.431, 0.743> }
	smooth_triangle { <-0.2067, 11.1189, 38.3301>, <0.027, -0.817, 0.576>, <0.7924, 10.2420, 37.3935>, <0.053, -0.650, 0.758>, <0.7690, 10.2428, 37.3839>, <-0.528, -0.755, 0.389> }
	smooth_triangle { <-0.2067, 11.1189, 38.3301>, <0.368, -0.559, 0.743>, <0.7690, 10.2428, 37.3839>, <-0.163, -0.753, 0.637>, <-0.2266, 11.1070, 38.3197>, <-0.224, -0.931, 0.287> }
	smooth_triangle { <-0.2266, 11.1070, 38.3197>, <-0.631, -0.761, -0.152>, <0.7690, 10.2428, 37.3839>, <-0.763, -0.621, 0.180>, <0.7637, 10.2584, 37.3645>, <-0.869, -0.267, -0.417> }
	smooth_triangle { <-0.2266, 11.1070, 38.3197>, <-0.370, -0.913, 0.173>, <0.7637, 10.2584, 37.3645>, <-0.813, -0.574, -0.093>, <-0.2376, 11.1166, 38.2989>, <-0.741, -0.497, -0.452> }
	smooth_triangle { <-0.2376, 11.1166, 38.2989>, <-0.683, 0.043, -0.729>, <0.7637, 10.2584, 37.3645>, <-0.817, 0.029, -0.576>, <0.7819, 10.2732, 37.3549>, <-0.338, 0.489, -0.804> }
	smooth_triangle { <-0.2376, 11.1166, 38.2989>, <-0.745, -0.362, -0.560>, <0.7819, 10.2732, 37.3549>, <-0.656, 0.173, -0.735>, <-0.2288, 11.1380, 38.2885>, <-0.519, 0.436, -0.735> }
	smooth_triangle { <-0.2288, 11.1380, 38.2885>, <-0.031, 0.821, -0.570>, <0.7819, 10.2732, 37.3549>, <-0.054, 0.652, -0.756>, <0.8054, 10.2724, 37.3645>, <0.529, 0.755, -0.388> }
	smooth_triangle { <-0.2288, 11.1380, 38.2885>, <-0.375, 0.564, -0.736>, <0.8054, 10.2724, 37.3645>, <0.164, 0.753, -0.637>, <-0.2088, 11.1498, 38.2989>, <0.217, 0.935, -0.280> }
	smooth_triangle { <-0.2088, 11.1498, 38.2989>, <0.626, 0.764, 0.156>, <0.8054, 10.2724, 37.3645>, <0.762, 0.623, -0.178>, <0.8107, 10.2568, 37.3839>, <0.815, 0.573, 0.092> }
	smooth_triangle { <-0.2088, 11.1498, 38.2989>, <0.364, 0.917, -0.166>, <0.8107, 10.2568, 37.3839>, <0.815, 0.573, 0.092>, <-0.1978, 11.1403, 38.3197>, <0.658, 0.753, -0.003> }
	smooth_triangle { <-1.2965, 11.4011, 39.4943>, <0.729, 0.034, 0.683>, <-0.1978, 11.1403, 38.3197>, <0.697, 0.224, 0.681>, <-0.2067, 11.1189, 38.3301>, <0.512, -0.431, 0.743> }
	smooth_triangle { <-1.2965, 11.4011, 39.4943>, <0.277, -0.837, 0.471>, <-0.2067, 11.1189, 38.3301>, <0.368, -0.559, 0.743>, <-0.2266, 11.1070, 38.3197>, <-0.224, -0.931, 0.287> }
	smooth_triangle { <-1.2965, 11.4011, 39.4943>, <-0.458, -0.869, -0.190>, <-0.2266, 11.1070, 38.3197>, <-0.370, -0.913, 0.173>, <-0.2376, 11.1166, 38.2989>, <-0.741, -0.497, -0.452> }
	smooth_triangle { <-1.2965, 11.4011, 39.4943>, <-0.755, -0.019, -0.655>, <-0.2376, 11.1166, 38.2989>, <-0.745, -0.362, -0.560>, <-0.2288, 11.1380, 38.2885>, <-0.519, 0.436, -0.735> }
	smooth_triangle { <-1.2965, 11.4011, 39.4943>, <-0.300, 0.845, -0.442>, <-0.2288, 11.1380, 38.2885>, <-0.375, 0.564, -0.736>, <-0.2088, 11.1498, 38.2989>, <0.217, 0.935, -0.280> }
	smooth_triangle { <-1.2965, 11.4011, 39.4943>, <0.429, 0.877, 0.215>, <-0.2088, 11.1498, 38.2989>, <0.364, 0.917, -0.166>, <-0.1978, 11.1403, 38.3197>, <0.708, 0.369, 0.602> }
	smooth_triangle { <1.7547, 9.6575, 35.8541>, <0.469, -0.178, 0.865>, <1.4016, 8.4915, 35.8061>, <0.434, -0.281, 0.856>, <1.3804, 8.4974, 35.8188>, <0.149, -0.128, 0.981> }
	smooth_triangle { <1.7547, 9.6575, 35.8541>, <0.469, -0.178, 0.865>, <1.3804, 8.4974, 35.8188>, <0.149, -0.128, 0.981>, <1.7335, 9.6634, 35.8668>, <-0.192, 0.018, 0.981> }
	smooth_triangle { <1.7335, 9.6634, 35.8668>, <-0.192, 0.018, 0.981>, <1.3804, 8.4974, 35.8188>, <0.149, -0.128, 0.981>, <1.3595, 8.5043, 35.8061>, <-0.674, 0.336, 0.658> }
	smooth_triangle { <1.7335, 9.6634, 35.8668>, <-0.192, 0.018, 0.981>, <1.3595, 8.5043, 35.8061>, <-0.674, 0.336, 0.658>, <1.7126, 9.6703, 35.8541>, <-0.908, 0.262, 0.327> }
	smooth_triangle { <1.7126, 9.6703, 35.8541>, <-0.908, 0.262, 0.327>, <1.3595, 8.5043, 35.8061>, <-0.674, 0.336, 0.658>, <1.3597, 8.5053, 35.7807>, <-0.824, 0.464, -0.324> }
	smooth_triangle { <1.7126, 9.6703, 35.8541>, <-0.908, 0.262, 0.327>, <1.3597, 8.5053, 35.7807>, <-0.824, 0.464, -0.324>, <1.7128, 9.6712, 35.8287>, <-0.716, 0.244, -0.654> }
	smooth_triangle { <1.7128, 9.6712, 35.8287>, <-0.716, 0.244, -0.654>, <1.3597, 8.5053, 35.7807>, <-0.824, 0.464, -0.324>, <1.3809, 8.4994, 35.7680>, <-0.149, 0.128, -0.981> }
	smooth_triangle { <1.7128, 9.6712, 35.8287>, <-0.716, 0.244, -0.654>, <1.3809, 8.4994, 35.7680>, <-0.149, 0.128, -0.981>, <1.7340, 9.6653, 35.8160>, <0.192, -0.018, -0.981> }
	smooth_triangle { <1.7340, 9.6653, 35.8160>, <0.192, -0.018, -0.981>, <1.3809, 8.4994, 35.7680>, <-0.149, 0.128, -0.981>, <1.4018, 8.4925, 35.7807>, <0.674, -0.336, -0.658> }
	smooth_triangle { <1.7340, 9.6653, 35.8160>, <0.192, -0.018, -0.981>, <1.4018, 8.4925, 35.7807>, <0.674, -0.336, -0.658>, <1.7549, 9.6585, 35.8287>, <0.908, -0.262, -0.327> }
	smooth_triangle { <1.7549, 9.6585, 35.8287>, <0.908, -0.262, -0.327>, <1.4018, 8.4925, 35.7807>, <0.674, -0.336, -0.658>, <1.4016, 8.4915, 35.8061>, <0.879, -0.477, -0.002> }
	smooth_triangle { <1.7549, 9.6585, 35.8287>, <0.908, -0.262, -0.327>, <1.4016, 8.4915, 35.8061>, <0.879, -0.477, -0.002>, <1.7547, 9.6575, 35.8541>, <0.957, -0.290, 0.000> }
	smooth_triangle { <3.6524, 11.1645, 35.9628>, <0.385, -0.348, 0.855>, <1.4016, 8.4915, 35.8061>, <0.434, -0.281, 0.856>, <1.3804, 8.4974, 35.8188>, <0.149, -0.128, 0.981> }
	smooth_triangle { <3.6524, 11.1645, 35.9628>, <0.385, -0.348, 0.855>, <1.3804, 8.4974, 35.8188>, <0.149, -0.128, 0.981>, <3.6383, 11.1814, 35.9755>, <0.046, 0.027, 0.999> }
	smooth_triangle { <3.6383, 11.1814, 35.9755>, <0.046, 0.027, 0.999>, <1.3804, 8.4974, 35.8188>, <0.149, -0.128, 0.981>, <1.3595, 8.5043, 35.8061>, <-0.674, 0.336, 0.658> }
	smooth_triangle { <3.6383, 11.1814, 35.9755>, <0.046, 0.027, 0.999>, <1.3595, 8.5043, 35.8061>, <-0.674, 0.336, 0.658>, <3.6250, 11.1989, 35.9628>, <-0.518, 0.692, 0.503> }
	smooth_triangle { <3.6250, 11.1989, 35.9628>, <-0.518, 0.692, 0.503>, <1.3595, 8.5043, 35.8061>, <-0.674, 0.336, 0.658>, <1.3597, 8.5053, 35.7807>, <-0.824, 0.464, -0.324> }
	smooth_triangle { <3.6250, 11.1989, 35.9628>, <-0.518, 0.692, 0.503>, <1.3597, 8.5053, 35.7807>, <-0.824, 0.464, -0.324>, <3.6259, 11.1996, 35.9374>, <-0.564, 0.661, -0.496> }
	smooth_triangle { <3.6259, 11.1996, 35.9374>, <-0.564, 0.661, -0.496>, <1.3597, 8.5053, 35.7807>, <-0.824, 0.464, -0.324>, <1.3809, 8.4994, 35.7680>, <-0.149, 0.128, -0.981> }
	smooth_triangle { <3.6259, 11.1996, 35.9374>, <-0.564, 0.661, -0.496>, <1.3809, 8.4994, 35.7680>, <-0.149, 0.128, -0.981>, <3.6400, 11.1828, 35.9247>, <-0.046, -0.027, -0.999> }
	smooth_triangle { <3.6400, 11.1828, 35.9247>, <-0.046, -0.027, -0.999>, <1.3809, 8.4994, 35.7680>, <-0.149, 0.128, -0.981>, <1.4018, 8.4925, 35.7807>, <0.674, -0.336, -0.658> }
	smooth_triangle { <3.6400, 11.1828, 35.9247>, <-0.046, -0.027, -0.999>, <1.4018, 8.4925, 35.7807>, <0.674, -0.336, -0.658>, <3.6533, 11.1652, 35.9374>, <0.518, -0.692, -0.503> }
	smooth_triangle { <3.6533, 11.1652, 35.9374>, <0.518, -0.692, -0.503>, <1.4018, 8.4925, 35.7807>, <0.674, -0.336, -0.658>, <1.4016, 8.4915, 35.8061>, <0.879, -0.477, -0.002> }
	smooth_triangle { <3.6533, 11.1652, 35.9374>, <0.518, -0.692, -0.503>, <1.4016, 8.4915, 35.8061>, <0.879, -0.477, -0.002>, <3.6524, 11.1645, 35.9628>, <0.596, -0.803, 0.001> }
	smooth_triangle { <5.3695, 12.1586, 35.5237>, <0.334, -0.583, 0.741>, <3.6524, 11.1645, 35.9628>, <0.385, -0.348, 0.855>, <3.6383, 11.1814, 35.9755>, <0.046, 0.027, 0.999> }
	smooth_triangle { <5.3695, 12.1586, 35.5237>, <0.334, -0.583, 0.741>, <3.6383, 11.1814, 35.9755>, <0.046, 0.027, 0.999>, <5.3609, 12.1790, 35.5361>, <0.083, 0.189, 0.978> }
	smooth_triangle { <5.3609, 12.1790, 35.5361>, <0.083, 0.189, 0.978>, <3.6383, 11.1814, 35.9755>, <0.046, 0.027, 0.999>, <3.6250, 11.1989, 35.9628>, <-0.518, 0.692, 0.503> }
	smooth_triangle { <5.3609, 12.1790, 35.5361>, <0.083, 0.189, 0.978>, <3.6250, 11.1989, 35.9628>, <-0.518, 0.692, 0.503>, <5.3475, 12.1967, 35.5237>, <-0.305, 0.877, 0.372> }
	smooth_triangle { <5.3475, 12.1967, 35.5237>, <-0.305, 0.877, 0.372>, <3.6250, 11.1989, 35.9628>, <-0.518, 0.692, 0.503>, <3.6259, 11.1996, 35.9374>, <-0.564, 0.661, -0.496> }
	smooth_triangle { <5.3475, 12.1967, 35.5237>, <-0.305, 0.877, 0.372>, <3.6259, 11.1996, 35.9374>, <-0.564, 0.661, -0.496>, <5.3427, 12.1939, 35.4989>, <-0.384, 0.688, -0.616> }
	smooth_triangle { <5.3427, 12.1939, 35.4989>, <-0.384, 0.688, -0.616>, <3.6259, 11.1996, 35.9374>, <-0.564, 0.661, -0.496>, <3.6400, 11.1828, 35.9247>, <-0.046, -0.027, -0.999> }
	smooth_triangle { <5.3427, 12.1939, 35.4989>, <-0.384, 0.688, -0.616>, <3.6400, 11.1828, 35.9247>, <-0.046, -0.027, -0.999>, <5.3514, 12.1735, 35.4865>, <-0.075, -0.185, -0.980> }
	smooth_triangle { <5.3514, 12.1735, 35.4865>, <-0.075, -0.185, -0.980>, <3.6400, 11.1828, 35.9247>, <-0.046, -0.027, -0.999>, <3.6533, 11.1652, 35.9374>, <0.518, -0.692, -0.503> }
	smooth_triangle { <5.3514, 12.1735, 35.4865>, <-0.075, -0.185, -0.980>, <3.6533, 11.1652, 35.9374>, <0.518, -0.692, -0.503>, <5.3648, 12.1558, 35.4989>, <0.313, -0.873, -0.374> }
	smooth_triangle { <5.3648, 12.1558, 35.4989>, <0.313, -0.873, -0.374>, <3.6533, 11.1652, 35.9374>, <0.518, -0.692, -0.503>, <3.6524, 11.1645, 35.9628>, <0.596, -0.803, 0.001> }
	smooth_triangle { <5.3648, 12.1558, 35.4989>, <0.313, -0.873, -0.374>, <3.6524, 11.1645, 35.9628>, <0.596, -0.803, 0.001>, <5.3695, 12.1586, 35.5237>, <0.501, -0.865, 0.000> }
	smooth_triangle { <7.3430, 12.5740, 35.3594>, <0.171, -0.438, 0.883>, <5.3695, 12.1586, 35.5237>, <0.334, -0.583, 0.741>, <5.3609, 12.1790, 35.5361>, <0.083, 0.189, 0.978> }
	smooth_triangle { <7.3430, 12.5740, 35.3594>, <-0.030, 0.550, 0.834>, <5.3609, 12.1790, 35.5361>, <0.083, 0.189, 0.978>, <5.3475, 12.1967, 35.5237>, <-0.305, 0.877, 0.372> }
	smooth_triangle { <7.3430, 12.5740, 35.3594>, <-0.185, 0.981, -0.055>, <5.3475, 12.1967, 35.5237>, <-0.305, 0.877, 0.372>, <5.3427, 12.1939, 35.4989>, <-0.384, 0.688, -0.616> }
	smooth_triangle { <7.3430, 12.5740, 35.3594>, <-0.141, 0.447, -0.883>, <5.3427, 12.1939, 35.4989>, <-0.384, 0.688, -0.616>, <5.3514, 12.1735, 35.4865>, <-0.075, -0.185, -0.980> }
	smooth_triangle { <7.3430, 12.5740, 35.3594>, <0.060, -0.539, -0.840>, <5.3514, 12.1735, 35.4865>, <-0.075, -0.185, -0.980>, <5.3648, 12.1558, 35.4989>, <0.313, -0.873, -0.374> }
	smooth_triangle { <7.3430, 12.5740, 35.3594>, <0.215, -0.975, 0.051>, <5.3648, 12.1558, 35.4989>, <0.313, -0.873, -0.374>, <5.3695, 12.1586, 35.5237>, <0.334, -0.583, 0.741> }
	smooth_triangle { <2.1536, 9.1081, 36.5131>, <-0.070, -0.706, 0.704>, <1.3890, 8.4767, 35.8038>, <-0.094, -0.726, 0.682>, <1.3693, 8.4890, 35.8141>, <-0.349, -0.520, 0.780> }
	smooth_triangle { <2.1536, 9.1081, 36.5131>, <-0.070, -0.706, 0.704>, <1.3693, 8.4890, 35.8141>, <-0.349, -0.520, 0.780>, <2.1339, 9.1204, 36.5234>, <-0.561, -0.218, 0.799> }
	smooth_triangle { <2.1339, 9.1204, 36.5234>, <-0.561, -0.218, 0.799>, <1.3693, 8.4890, 35.8141>, <-0.349, -0.520, 0.780>, <1.3609, 8.5107, 35.8038>, <-0.778, 0.346, 0.525> }
	smooth_triangle { <2.1339, 9.1204, 36.5234>, <-0.561, -0.218, 0.799>, <1.3609, 8.5107, 35.8038>, <-0.778, 0.346, 0.525>, <2.1256, 9.1421, 36.5131>, <-0.748, 0.607, 0.266> }
	smooth_triangle { <2.1256, 9.1421, 36.5131>, <-0.748, 0.607, 0.266>, <1.3609, 8.5107, 35.8038>, <-0.778, 0.346, 0.525>, <1.3723, 8.5201, 35.7831>, <-0.429, 0.867, -0.255> }
	smooth_triangle { <2.1256, 9.1421, 36.5131>, <-0.748, 0.607, 0.266>, <1.3723, 8.5201, 35.7831>, <-0.429, 0.867, -0.255>, <2.1370, 9.1515, 36.4924>, <-0.188, 0.825, -0.532> }
	smooth_triangle { <2.1370, 9.1515, 36.4924>, <-0.188, 0.825, -0.532>, <1.3723, 8.5201, 35.7831>, <-0.429, 0.867, -0.255>, <1.3920, 8.5078, 35.7728>, <0.349, 0.520, -0.780> }
	smooth_triangle { <2.1370, 9.1515, 36.4924>, <-0.188, 0.825, -0.532>, <1.3920, 8.5078, 35.7728>, <0.349, 0.520, -0.780>, <2.1567, 9.1392, 36.4821>, <0.561, 0.218, -0.799> }
	smooth_triangle { <2.1567, 9.1392, 36.4821>, <0.561, 0.218, -0.799>, <1.3920, 8.5078, 35.7728>, <0.349, 0.520, -0.780>, <1.4004, 8.4861, 35.7831>, <0.778, -0.346, -0.525> }
	smooth_triangle { <2.1567, 9.1392, 36.4821>, <0.561, 0.218, -0.799>, <1.4004, 8.4861, 35.7831>, <0.778, -0.346, -0.525>, <2.1650, 9.1175, 36.4924>, <0.749, -0.607, -0.266> }
	smooth_triangle { <2.1650, 9.1175, 36.4924>, <0.749, -0.607, -0.266>, <1.4004, 8.4861, 35.7831>, <0.778, -0.346, -0.525>, <1.3890, 8.4767, 35.8038>, <0.616, -0.788, -0.003> }
	smooth_triangle { <2.1650, 9.1175, 36.4924>, <0.749, -0.607, -0.266>, <1.3890, 8.4767, 35.8038>, <0.616, -0.788, -0.003>, <2.1536, 9.1081, 36.5131>, <0.637, -0.771, 0.000> }
	smooth_triangle { <3.6707, 10.1535, 38.1063>, <-0.239, -0.787, 0.569>, <1.3890, 8.4767, 35.8038>, <-0.094, -0.726, 0.682>, <1.3693, 8.4890, 35.8141>, <-0.349, -0.520, 0.780> }
	smooth_triangle { <3.6707, 10.1535, 38.1063>, <-0.239, -0.787, 0.569>, <1.3693, 8.4890, 35.8141>, <-0.349, -0.520, 0.780>, <3.6514, 10.1669, 38.1160>, <-0.528, -0.286, 0.800> }
	smooth_triangle { <3.6514, 10.1669, 38.1160>, <-0.528, -0.286, 0.800>, <1.3693, 8.4890, 35.8141>, <-0.349, -0.520, 0.780>, <1.3609, 8.5107, 35.8038>, <-0.778, 0.346, 0.525> }
	smooth_triangle { <3.6514, 10.1669, 38.1160>, <-0.528, -0.286, 0.800>, <1.3609, 8.5107, 35.8038>, <-0.778, 0.346, 0.525>, <3.6457, 10.1898, 38.1063>, <-0.536, 0.619, 0.574> }
	smooth_triangle { <3.6457, 10.1898, 38.1063>, <-0.428, 0.692, 0.582>, <1.3609, 8.5107, 35.8038>, <-0.778, 0.346, 0.525>, <1.3723, 8.5201, 35.7831>, <-0.429, 0.867, -0.255> }
	smooth_triangle { <3.6457, 10.1898, 38.1063>, <-0.428, 0.692, 0.582>, <1.3723, 8.5201, 35.7831>, <-0.429, 0.867, -0.255>, <3.6594, 10.1992, 38.0871>, <0.110, 0.966, -0.233> }
	smooth_triangle { <3.6594, 10.1992, 38.0871>, <0.101, 0.919, -0.382>, <1.3723, 8.5201, 35.7831>, <-0.429, 0.867, -0.255>, <1.3920, 8.5078, 35.7728>, <0.349, 0.520, -0.780> }
	smooth_triangle { <3.6594, 10.1992, 38.0871>, <0.101, 0.919, -0.382>, <1.3920, 8.5078, 35.7728>, <0.349, 0.520, -0.780>, <3.6787, 10.1858, 38.0775>, <0.526, 0.285, -0.801> }
	smooth_triangle { <3.6787, 10.1858, 38.0775>, <0.526, 0.285, -0.801>, <1.3920, 8.5078, 35.7728>, <0.349, 0.520, -0.780>, <1.4004, 8.4861, 35.7831>, <0.778, -0.346, -0.525> }
	smooth_triangle { <3.6787, 10.1858, 38.0775>, <0.526, 0.285, -0.801>, <1.4004, 8.4861, 35.7831>, <0.778, -0.346, -0.525>, <3.6844, 10.1630, 38.0871>, <0.534, -0.620, -0.575> }
	smooth_triangle { <3.6844, 10.1630, 38.0871>, <0.424, -0.692, -0.584>, <1.4004, 8.4861, 35.7831>, <0.778, -0.346, -0.525>, <1.3890, 8.4767, 35.8038>, <0.616, -0.788, -0.003> }
	smooth_triangle { <3.6844, 10.1630, 38.0871>, <0.424, -0.692, -0.584>, <1.3890, 8.4767, 35.8038>, <0.616, -0.788, -0.003>, <3.6707, 10.1535, 38.1063>, <0.046, -0.982, -0.185> }
	smooth_triangle { <5.4648, 9.5152, 38.7700>, <-0.465, -0.701, 0.540>, <3.6707, 10.1535, 38.1063>, <-0.239, -0.787, 0.569>, <3.6514, 10.1669, 38.1160>, <-0.562, -0.406, 0.720> }
	smooth_triangle { <5.4648, 9.5152, 38.7700>, <-0.465, -0.701, 0.540>, <3.6514, 10.1669, 38.1160>, <-0.528, -0.286, 0.800>, <5.4683, 9.5373, 38.7820>, <-0.381, 0.189, 0.905> }
	smooth_triangle { <5.4683, 9.5373, 38.7820>, <-0.381, 0.189, 0.905>, <3.6514, 10.1669, 38.1160>, <-0.513, -0.139, 0.847>, <3.6457, 10.1898, 38.1063>, <-0.428, 0.692, 0.582> }
	smooth_triangle { <5.4683, 9.5373, 38.7820>, <-0.381, 0.189, 0.905>, <3.6457, 10.1898, 38.1063>, <-0.428, 0.692, 0.582>, <5.4795, 9.5566, 38.7700>, <0.057, 0.893, 0.447> }
	smooth_triangle { <5.4795, 9.5566, 38.7700>, <0.057, 0.893, 0.447>, <3.6457, 10.1898, 38.1063>, <-0.327, 0.786, 0.525>, <3.6594, 10.1992, 38.0871>, <0.082, 0.996, 0.043> }
	smooth_triangle { <5.4795, 9.5566, 38.7700>, <0.057, 0.893, 0.447>, <3.6594, 10.1992, 38.0871>, <0.110, 0.966, -0.233>, <5.4873, 9.5539, 38.7460>, <0.459, 0.775, -0.433> }
	smooth_triangle { <5.4873, 9.5539, 38.7460>, <0.459, 0.775, -0.433>, <3.6594, 10.1992, 38.0871>, <0.110, 0.966, -0.233>, <3.6787, 10.1858, 38.0775>, <0.562, 0.406, -0.721> }
	smooth_triangle { <5.4873, 9.5539, 38.7460>, <0.459, 0.775, -0.433>, <3.6787, 10.1858, 38.0775>, <0.526, 0.285, -0.801>, <5.4839, 9.5318, 38.7340>, <0.387, -0.193, -0.902> }
	smooth_triangle { <5.4839, 9.5318, 38.7340>, <0.387, -0.193, -0.902>, <3.6787, 10.1858, 38.0775>, <0.512, 0.138, -0.848>, <3.6844, 10.1630, 38.0871>, <0.424, -0.692, -0.584> }
	smooth_triangle { <5.4839, 9.5318, 38.7340>, <0.387, -0.193, -0.902>, <3.6844, 10.1630, 38.0871>, <0.424, -0.692, -0.584>, <5.4726, 9.5124, 38.7460>, <-0.052, -0.894, -0.445> }
	smooth_triangle { <5.4726, 9.5124, 38.7460>, <-0.052, -0.894, -0.445>, <3.6844, 10.1630, 38.0871>, <0.322, -0.786, -0.528>, <3.6707, 10.1535, 38.1063>, <0.046, -0.982, -0.185> }
	smooth_triangle { <5.4726, 9.5124, 38.7460>, <-0.052, -0.894, -0.445>, <3.6707, 10.1535, 38.1063>, <0.046, -0.982, -0.185>, <5.4648, 9.5152, 38.7700>, <-0.335, -0.942, 0.000> }
	smooth_triangle { <7.1077, 9.1766, 39.9151>, <-0.580, -0.330, 0.744>, <5.4648, 9.5152, 38.7700>, <-0.465, -0.701, 0.540>, <5.4683, 9.5373, 38.7820>, <-0.381, 0.189, 0.905> }
	smooth_triangle { <7.1077, 9.1766, 39.9151>, <-0.336, 0.634, 0.697>, <5.4683, 9.5373, 38.7820>, <-0.381, 0.189, 0.905>, <5.4795, 9.5566, 38.7700>, <0.057, 0.893, 0.447> }
	smooth_triangle { <7.1077, 9.1766, 39.9151>, <0.258, 0.966, -0.036>, <5.4795, 9.5566, 38.7700>, <0.057, 0.893, 0.447>, <5.4873, 9.5539, 38.7460>, <0.459, 0.775, -0.433> }
	smooth_triangle { <7.1077, 9.1766, 39.9151>, <0.606, 0.321, -0.728>, <5.4873, 9.5539, 38.7460>, <0.459, 0.775, -0.433>, <5.4839, 9.5318, 38.7340>, <0.387, -0.193, -0.902> }
	smooth_triangle { <7.1077, 9.1766, 39.9151>, <0.361, -0.639, -0.679>, <5.4839, 9.5318, 38.7340>, <0.387, -0.193, -0.902>, <5.4726, 9.5124, 38.7460>, <-0.052, -0.894, -0.445> }
	smooth_triangle { <7.1077, 9.1766, 39.9151>, <-0.229, -0.972, 0.051>, <5.4726, 9.5124, 38.7460>, <-0.052, -0.894, -0.445>, <5.4648, 9.5152, 38.7700>, <-0.465, -0.701, 0.540> }
	smooth_triangle { <0.9503, 9.6358, 35.8845>, <0.485, 0.134, 0.864>, <1.4014, 8.5058, 35.8061>, <0.511, 0.066, 0.857>, <1.3813, 8.4969, 35.8188>, <0.259, -0.083, 0.962> }
	smooth_triangle { <0.9503, 9.6358, 35.8845>, <0.485, 0.134, 0.864>, <1.3813, 8.4969, 35.8188>, <0.259, -0.083, 0.962>, <0.9302, 9.6269, 35.8972>, <-0.152, -0.129, 0.980> }
	smooth_triangle { <0.9302, 9.6269, 35.8972>, <-0.152, -0.129, 0.980>, <1.3813, 8.4969, 35.8188>, <0.259, -0.083, 0.962>, <1.3605, 8.4895, 35.8061>, <-0.612, -0.461, 0.643> }
	smooth_triangle { <0.9302, 9.6269, 35.8972>, <-0.152, -0.129, 0.980>, <1.3605, 8.4895, 35.8061>, <-0.612, -0.461, 0.643>, <0.9094, 9.6195, 35.8845>, <-0.870, -0.370, 0.327> }
	smooth_triangle { <0.9094, 9.6195, 35.8845>, <-0.870, -0.370, 0.327>, <1.3605, 8.4895, 35.8061>, <-0.612, -0.461, 0.643>, <1.3599, 8.4910, 35.7808>, <-0.869, -0.376, -0.321> }
	smooth_triangle { <0.9094, 9.6195, 35.8845>, <-0.870, -0.370, 0.327>, <1.3599, 8.4910, 35.7808>, <-0.869, -0.376, -0.321>, <0.9088, 9.6210, 35.8591>, <-0.718, -0.241, -0.653> }
	smooth_triangle { <0.9088, 9.6210, 35.8591>, <-0.718, -0.241, -0.653>, <1.3599, 8.4910, 35.7808>, <-0.869, -0.376, -0.321>, <1.3800, 8.4999, 35.7681>, <-0.259, 0.083, -0.962> }
	smooth_triangle { <0.9088, 9.6210, 35.8591>, <-0.718, -0.241, -0.653>, <1.3800, 8.4999, 35.7681>, <-0.259, 0.083, -0.962>, <0.9290, 9.6299, 35.8465>, <0.152, 0.129, -0.980> }
	smooth_triangle { <0.9290, 9.6299, 35.8465>, <0.152, 0.129, -0.980>, <1.3800, 8.4999, 35.7681>, <-0.259, 0.083, -0.962>, <1.4008, 8.5073, 35.7808>, <0.612, 0.460, -0.643> }
	smooth_triangle { <0.9290, 9.6299, 35.8465>, <0.152, 0.129, -0.980>, <1.4008, 8.5073, 35.7808>, <0.612, 0.460, -0.643>, <0.9497, 9.6373, 35.8591>, <0.870, 0.370, -0.327> }
	smooth_triangle { <0.9497, 9.6373, 35.8591>, <0.870, 0.370, -0.327>, <1.4008, 8.5073, 35.7808>, <0.612, 0.460, -0.643>, <1.4014, 8.5058, 35.8061>, <0.887, 0.462, -0.008> }
	smooth_triangle { <0.9497, 9.6373, 35.8591>, <0.870, 0.370, -0.327>, <1.4014, 8.5058, 35.8061>, <0.887, 0.462, -0.008>, <0.9503, 9.6358, 35.8845>, <0.929, 0.371, 0.000> }
	smooth_triangle { <-0.4280, 11.3345, 36.9638>, <0.630, -0.028, 0.776>, <1.4014, 8.5058, 35.8061>, <0.511, 0.066, 0.857>, <1.3813, 8.4969, 35.8188>, <0.259, -0.083, 0.962> }
	smooth_triangle { <-0.4280, 11.3345, 36.9638>, <0.630, -0.028, 0.776>, <1.3813, 8.4969, 35.8188>, <0.259, -0.083, 0.962>, <-0.4416, 11.3163, 36.9752>, <0.378, -0.354, 0.855> }
	smooth_triangle { <-0.4416, 11.3163, 36.9752>, <0.248, -0.487, 0.838>, <1.3813, 8.4969, 35.8188>, <0.259, -0.083, 0.962>, <1.3605, 8.4895, 35.8061>, <-0.612, -0.461, 0.643> }
	smooth_triangle { <-0.4416, 11.3163, 36.9752>, <0.248, -0.487, 0.838>, <1.3605, 8.4895, 35.8061>, <-0.612, -0.461, 0.643>, <-0.4622, 11.3068, 36.9638>, <-0.346, -0.872, 0.346> }
	smooth_triangle { <-0.4622, 11.3068, 36.9638>, <-0.676, -0.711, 0.193>, <1.3605, 8.4895, 35.8061>, <-0.612, -0.461, 0.643>, <1.3599, 8.4910, 35.7808>, <-0.869, -0.376, -0.321> }
	smooth_triangle { <-0.4622, 11.3068, 36.9638>, <-0.676, -0.711, 0.193>, <1.3599, 8.4910, 35.7808>, <-0.869, -0.376, -0.321>, <-0.4693, 11.3155, 36.9410>, <-0.705, -0.487, -0.515> }
	smooth_triangle { <-0.4693, 11.3155, 36.9410>, <-0.747, -0.319, -0.583>, <1.3599, 8.4910, 35.7808>, <-0.869, -0.376, -0.321>, <1.3800, 8.4999, 35.7681>, <-0.259, 0.083, -0.962> }
	smooth_triangle { <-0.4693, 11.3155, 36.9410>, <-0.747, -0.319, -0.583>, <1.3800, 8.4999, 35.7681>, <-0.259, 0.083, -0.962>, <-0.4558, 11.3338, 36.9296>, <-0.378, 0.356, -0.855> }
	smooth_triangle { <-0.4558, 11.3338, 36.9296>, <-0.249, 0.489, -0.836>, <1.3800, 8.4999, 35.7681>, <-0.259, 0.083, -0.962>, <1.4008, 8.5073, 35.7808>, <0.612, 0.460, -0.643> }
	smooth_triangle { <-0.4558, 11.3338, 36.9296>, <-0.249, 0.489, -0.836>, <1.4008, 8.5073, 35.7808>, <0.612, 0.460, -0.643>, <-0.4351, 11.3433, 36.9410>, <0.347, 0.871, -0.347> }
	smooth_triangle { <-0.4351, 11.3433, 36.9410>, <0.675, 0.712, -0.193>, <1.4008, 8.5073, 35.7808>, <0.612, 0.460, -0.643>, <1.4014, 8.5058, 35.8061>, <0.887, 0.462, -0.008> }
	smooth_triangle { <-0.4351, 11.3433, 36.9410>, <0.675, 0.712, -0.193>, <1.4014, 8.5058, 35.8061>, <0.887, 0.462, -0.008>, <-0.4280, 11.3345, 36.9638>, <0.525, 0.849, 0.054> }
	smooth_triangle { <-1.7307, 11.6384, 38.4977>, <0.742, 0.192, 0.642>, <-0.4280, 11.3345, 36.9638>, <0.630, -0.028, 0.776>, <-0.4416, 11.3163, 36.9752>, <0.378, -0.354, 0.855> }
	smooth_triangle { <-1.7307, 11.6384, 38.4977>, <0.681, 0.454, 0.574>, <-0.4416, 11.3163, 36.9752>, <0.716, 0.089, 0.693>, <-1.7262, 11.6148, 38.5060>, <0.714, -0.163, 0.681> }
	smooth_triangle { <-1.7262, 11.6148, 38.5060>, <0.433, -0.741, 0.513>, <-0.4416, 11.3163, 36.9752>, <0.248, -0.487, 0.838>, <-0.4622, 11.3068, 36.9638>, <0.024, -0.881, 0.472> }
	smooth_triangle { <-1.7262, 11.6148, 38.5060>, <0.657, -0.359, 0.663>, <-0.4622, 11.3068, 36.9638>, <0.189, -0.743, 0.642>, <-1.7404, 11.5955, 38.4977>, <0.192, -0.931, 0.310> }
	smooth_triangle { <-1.7404, 11.5955, 38.4977>, <-0.277, -0.957, -0.090>, <-0.4622, 11.3068, 36.9638>, <-0.516, -0.819, 0.250>, <-0.4693, 11.3155, 36.9410>, <-0.651, -0.613, -0.449> }
	smooth_triangle { <-1.7404, 11.5955, 38.4977>, <0.054, -0.977, 0.208>, <-0.4693, 11.3155, 36.9410>, <-0.524, -0.850, -0.056>, <-1.7591, 11.5997, 38.4811>, <-0.525, -0.768, -0.367> }
	smooth_triangle { <-1.7591, 11.5997, 38.4811>, <-0.748, -0.189, -0.636>, <-0.4693, 11.3155, 36.9410>, <-0.762, -0.131, -0.634>, <-0.4558, 11.3338, 36.9296>, <-0.378, 0.356, -0.855> }
	smooth_triangle { <-1.7591, 11.5997, 38.4811>, <-0.630, -0.617, -0.472>, <-0.4558, 11.3338, 36.9296>, <-0.716, -0.087, -0.693>, <-1.7636, 11.6233, 38.4728>, <-0.719, 0.164, -0.675> }
	smooth_triangle { <-1.7636, 11.6233, 38.4728>, <-0.436, 0.742, -0.510>, <-0.4558, 11.3338, 36.9296>, <-0.249, 0.489, -0.836>, <-0.4351, 11.3433, 36.9410>, <-0.023, 0.881, -0.473> }
	smooth_triangle { <-1.7636, 11.6233, 38.4728>, <-0.661, 0.360, -0.658>, <-0.4351, 11.3433, 36.9410>, <-0.186, 0.742, -0.644>, <-1.7494, 11.6426, 38.4811>, <-0.196, 0.932, -0.305> }
	smooth_triangle { <-1.7494, 11.6426, 38.4811>, <0.273, 0.957, 0.094>, <-0.4351, 11.3433, 36.9410>, <0.515, 0.820, -0.249>, <-0.4280, 11.3345, 36.9638>, <0.525, 0.849, 0.054> }
	smooth_triangle { <-1.7494, 11.6426, 38.4811>, <-0.058, 0.977, -0.204>, <-0.4280, 11.3345, 36.9638>, <0.525, 0.849, 0.054>, <-1.7307, 11.6384, 38.4977>, <0.224, 0.975, -0.003> }
	smooth_triangle { <-3.1725, 11.7418, 39.9302>, <0.668, 0.355, 0.654>, <-1.7307, 11.6384, 38.4977>, <0.681, 0.454, 0.574>, <-1.7262, 11.6148, 38.5060>, <0.714, -0.163, 0.681> }
	smooth_triangle { <-3.1725, 11.7418, 39.9302>, <0.512, -0.630, 0.584>, <-1.7262, 11.6148, 38.5060>, <0.657, -0.359, 0.663>, <-1.7404, 11.5955, 38.4977>, <0.192, -0.931, 0.310> }
	smooth_triangle { <-3.1725, 11.7418, 39.9302>, <-0.168, -0.984, -0.060>, <-1.7404, 11.5955, 38.4977>, <0.054, -0.977, 0.208>, <-1.7591, 11.5997, 38.4811>, <-0.525, -0.768, -0.367> }
	smooth_triangle { <-3.1725, 11.7418, 39.9302>, <-0.691, -0.353, -0.631>, <-1.7591, 11.5997, 38.4811>, <-0.630, -0.617, -0.472>, <-1.7636, 11.6233, 38.4728>, <-0.719, 0.164, -0.675> }
	smooth_triangle { <-3.1725, 11.7418, 39.9302>, <-0.534, 0.633, -0.560>, <-1.7636, 11.6233, 38.4728>, <-0.661, 0.360, -0.658>, <-1.7494, 11.6426, 38.4811>, <-0.196, 0.932, -0.305> }
	smooth_triangle { <-3.1725, 11.7418, 39.9302>, <0.146, 0.986, 0.083>, <-1.7494, 11.6426, 38.4811>, <-0.058, 0.977, -0.204>, <-1.7307, 11.6384, 38.4977>, <0.595, 0.637, 0.490> }

	texture { PSWL_BARK }
}

/* Object 'PWL0006F' */
union {
	smooth_triangle { <1.4598, 7.6523, 34.9176>, <-0.618, 0.604, -0.503>, <1.9001, 7.7358, 34.4914>, <-0.619, 0.585, -0.525>, <2.3386, 8.1558, 34.4425>, <-0.618, 0.604, -0.503> }
	smooth_triangle { <2.3386, 8.1558, 34.4425>, <-0.618, 0.604, -0.503>, <1.8865, 8.0524, 34.8884>, <-0.617, 0.623, -0.481>, <1.4598, 7.6523, 34.9176>, <-0.618, 0.604, -0.503> }
	smooth_triangle { <1.3389, 8.5207, 35.7689>, <-0.621, -0.490, 0.612>, <0.8194, 8.5413, 35.2826>, <-0.619, -0.453, 0.642>, <0.2623, 9.0948, 35.1364>, <-0.621, -0.490, 0.612> }
	smooth_triangle { <0.2623, 9.0948, 35.1364>, <-0.621, -0.490, 0.612>, <0.7981, 9.0387, 35.6595>, <-0.622, -0.526, 0.580>, <1.3389, 8.5207, 35.7689>, <-0.621, -0.490, 0.612> }
	smooth_triangle { <1.1145, 9.4125, 36.5569>, <-0.793, 0.281, -0.541>, <1.4225, 9.5901, 36.1470>, <-0.813, 0.370, -0.451>, <1.6553, 10.0221, 36.0815>, <-0.793, 0.281, -0.541> }
	smooth_triangle { <1.6553, 10.0221, 36.0815>, <-0.793, 0.281, -0.541>, <1.3245, 9.8808, 36.4425>, <-0.760, 0.188, -0.622>, <1.1145, 9.4125, 36.5569>, <-0.793, 0.281, -0.541> }
	smooth_triangle { <0.7357, 10.2518, 37.3613>, <-0.110, -0.662, 0.741>, <0.1299, 9.9478, 36.9733>, <-0.096, -0.706, 0.702>, <-0.6485, 10.0954, 37.0157>, <-0.110, -0.662, 0.741> }
	smooth_triangle { <-0.6485, 10.0954, 37.0157>, <-0.110, -0.662, 0.741>, <-0.0317, 10.4268, 37.3773>, <-0.124, -0.617, 0.777>, <0.7357, 10.2518, 37.3613>, <-0.110, -0.662, 0.741> }
	smooth_triangle { <0.2924, 10.7355, 37.8104>, <-0.832, -0.224, -0.507>, <0.4972, 11.0083, 37.3879>, <-0.789, -0.266, -0.554>, <0.4349, 11.5253, 37.2280>, <-0.832, -0.224, -0.507> }
	smooth_triangle { <0.4349, 11.5253, 37.2280>, <-0.832, -0.224, -0.507>, <0.2498, 11.2226, 37.6995>, <-0.871, -0.180, -0.457>, <0.2924, 10.7355, 37.8104>, <-0.832, -0.224, -0.507> }
	smooth_triangle { <-0.2581, 11.0963, 38.2958>, <0.262, -0.634, 0.727>, <-0.5820, 10.5318, 37.9397>, <0.234, -0.611, 0.756>, <-1.2897, 10.2756, 37.9515>, <0.262, -0.634, 0.727> }
	smooth_triangle { <-1.2897, 10.2756, 37.9515>, <0.262, -0.634, 0.727>, <-0.9380, 10.8403, 38.3373>, <0.290, -0.656, 0.697>, <-0.2581, 11.0963, 38.2958>, <0.262, -0.634, 0.727> }
	smooth_triangle { <-0.7232, 11.3059, 38.9000>, <-0.597, 0.463, -0.655>, <-0.0855, 11.7776, 38.6498>, <-0.599, 0.464, -0.652>, <0.1526, 12.3683, 38.8518>, <-0.597, 0.463, -0.655> }
	smooth_triangle { <0.1526, 12.3683, 38.8518>, <-0.597, 0.463, -0.655>, <-0.4986, 11.8826, 39.1005>, <-0.595, 0.461, -0.658>, <-0.7232, 11.3059, 38.9000>, <-0.597, 0.463, -0.655> }
	smooth_triangle { <-1.3384, 11.3762, 39.4727>, <0.333, -0.871, 0.362>, <-1.5642, 11.1273, 39.1240>, <0.293, -0.858, 0.422>, <-2.0738, 10.9370, 39.0913>, <0.333, -0.871, 0.362> }
	smooth_triangle { <-2.0738, 10.9370, 39.0913>, <0.333, -0.871, 0.362>, <-1.8192, 11.1762, 39.4799>, <0.370, -0.880, 0.299>, <-1.3384, 11.3762, 39.4727>, <0.333, -0.871, 0.362> }
	smooth_triangle { <1.5904, 9.0730, 35.7765>, <-0.688, 0.360, -0.630>, <1.8721, 8.7357, 35.2356>, <-0.648, 0.447, -0.616>, <2.3138, 8.8907, 34.8833>, <-0.688, 0.360, -0.630> }
	smooth_triangle { <2.3138, 8.8907, 34.8833>, <-0.688, 0.360, -0.630>, <2.0228, 9.2336, 35.3563>, <-0.721, 0.270, -0.639>, <1.5904, 9.0730, 35.7765>, <-0.688, 0.360, -0.630> }
	smooth_triangle { <1.6880, 9.6792, 35.8182>, <-0.466, -0.060, 0.882>, <1.2082, 9.6034, 35.5521>, <-0.472, -0.088, 0.877>, <0.8439, 9.9524, 35.3907>, <-0.466, -0.060, 0.882> }
	smooth_triangle { <0.8439, 9.9524, 35.3907>, <-0.466, -0.060, 0.882>, <1.3358, 10.0249, 35.6485>, <-0.460, -0.033, 0.887>, <1.6880, 9.6792, 35.8182>, <-0.466, -0.060, 0.882> }
	smooth_triangle { <2.7197, 10.3818, 35.8912>, <-0.029, 0.086, -0.996>, <2.8605, 9.8208, 35.8363>, <-0.022, 0.092, -0.996>, <3.3884, 9.5489, 35.7997>, <-0.029, 0.086, -0.996> }
	smooth_triangle { <3.3884, 9.5489, 35.7997>, <-0.029, 0.086, -0.996>, <3.2383, 10.1217, 35.8512>, <-0.037, 0.080, -0.996>, <2.7197, 10.3818, 35.8912>, <-0.029, 0.086, -0.996> }
	smooth_triangle { <3.6071, 11.2232, 35.9389>, <-0.214, 0.098, 0.972>, <3.1138, 11.4740, 35.8012>, <-0.226, 0.088, 0.970>, <2.9784, 12.0282, 35.7192>, <-0.214, 0.098, 0.972> }
	smooth_triangle { <2.9784, 12.0282, 35.7192>, <-0.214, 0.098, 0.972>, <3.4807, 11.7662, 35.8526>, <-0.203, 0.107, 0.973>, <3.6071, 11.2232, 35.9389>, <-0.214, 0.098, 0.972> }
	smooth_triangle { <4.5204, 11.6333, 35.7158>, <-0.326, 0.143, -0.934>, <4.5444, 11.0077, 35.6152>, <-0.336, 0.137, -0.932>, <5.0201, 10.6254, 35.3874>, <-0.326, 0.143, -0.934> }
	smooth_triangle { <5.0201, 10.6254, 35.3874>, <-0.326, 0.143, -0.934>, <4.9903, 11.2659, 35.4989>, <-0.317, 0.148, -0.937>, <4.5204, 11.6333, 35.7158>, <-0.326, 0.143, -0.934> }
	smooth_triangle { <5.3276, 12.2177, 35.4936>, <0.036, 0.412, 0.910>, <4.7884, 12.5431, 35.3626>, <0.021, 0.404, 0.915>, <4.6914, 13.1428, 35.1002>, <0.036, 0.412, 0.910> }
	smooth_triangle { <4.6914, 13.1428, 35.1002>, <0.036, 0.412, 0.910>, <5.2377, 12.8033, 35.2271>, <0.050, 0.420, 0.906>, <5.3276, 12.2177, 35.4936>, <0.036, 0.412, 0.910> }
	smooth_triangle { <6.3631, 12.3366, 35.4010>, <-0.138, 0.631, -0.763>, <6.2274, 11.8205, 34.9416>, <0.000, 0.665, -0.747>, <6.6851, 11.4208, 34.5861>, <-0.138, 0.631, -0.763> }
	smooth_triangle { <6.6851, 11.4208, 34.5861>, <-0.138, 0.631, -0.763>, <6.7942, 11.9370, 34.9416>, <-0.273, 0.584, -0.764>, <6.3631, 12.3366, 35.4010>, <-0.138, 0.631, -0.763> }
	smooth_triangle { <7.3148, 12.6114, 35.3339>, <-0.195, 0.446, 0.873>, <6.8156, 12.9146, 35.0661>, <-0.199, 0.444, 0.874>, <6.7756, 13.3278, 34.8471>, <-0.195, 0.446, 0.873> }
	smooth_triangle { <6.7756, 13.3278, 34.8471>, <-0.195, 0.446, 0.873>, <7.2820, 13.0143, 35.1195>, <-0.192, 0.449, 0.873>, <7.3148, 12.6114, 35.3339>, <-0.195, 0.446, 0.873> }
	smooth_triangle { <1.8041, 8.7867, 36.1281>, <0.181, 0.743, -0.644>, <2.0679, 8.4121, 35.7727>, <0.177, 0.740, -0.649>, <2.6103, 8.2506, 35.7363>, <0.181, 0.743, -0.644> }
	smooth_triangle { <2.6103, 8.2506, 35.7363>, <0.181, 0.743, -0.644>, <2.3335, 8.6314, 36.1003>, <0.185, 0.746, -0.640>, <1.8041, 8.7867, 36.1281>, <0.181, 0.743, -0.644> }
	smooth_triangle { <2.1117, 9.1712, 36.5021>, <-0.455, -0.355, 0.817>, <1.6704, 9.4306, 36.3689>, <-0.455, -0.356, 0.816>, <1.4973, 9.9293, 36.4896>, <-0.455, -0.355, 0.817> }
	smooth_triangle { <1.4973, 9.9293, 36.4896>, <-0.455, -0.355, 0.817>, <1.9473, 9.6593, 36.6227>, <-0.455, -0.355, 0.817>, <2.1117, 9.1712, 36.5021>, <-0.455, -0.355, 0.817> }
	smooth_triangle { <2.9461, 9.6267, 37.2780>, <0.156, 0.762, -0.629>, <3.3076, 9.1654, 36.7506>, <0.226, 0.805, -0.549>, <4.0278, 8.9307, 36.7036>, <0.156, 0.762, -0.629> }
	smooth_triangle { <4.0278, 8.9307, 36.7036>, <0.156, 0.762, -0.629>, <3.6978, 9.4341, 37.1734>, <0.084, 0.709, -0.700>, <2.9461, 9.6267, 37.2780>, <0.156, 0.762, -0.629> }
	smooth_triangle { <3.6453, 10.2243, 38.0841>, <-0.674, -0.084, 0.734>, <3.2464, 10.6747, 37.7290>, <-0.736, -0.128, 0.665>, <3.1732, 11.3701, 37.7819>, <-0.674, -0.084, 0.734> }
	smooth_triangle { <3.1732, 11.3701, 37.7819>, <-0.674, -0.084, 0.734>, <3.6123, 10.9266, 38.0942>, <-0.605, -0.040, 0.795>, <3.6453, 10.2243, 38.0841>, <-0.674, -0.084, 0.734> }
	smooth_triangle { <4.5629, 9.8086, 38.4030>, <0.353, 0.385, -0.853>, <4.2312, 9.3957, 38.1084>, <0.265, 0.410, -0.873>, <4.3955, 8.7918, 37.8744>, <0.353, 0.385, -0.853> }
	smooth_triangle { <4.3955, 8.7918, 37.8744>, <0.353, 0.385, -0.853>, <4.7122, 9.2252, 38.2299>, <0.438, 0.357, -0.825>, <4.5629, 9.8086, 38.4030>, <0.353, 0.385, -0.853> }
	smooth_triangle { <5.4996, 9.5575, 38.7160>, <0.004, 0.877, 0.481>, <5.5454, 9.9257, 38.0265>, <-0.021, 0.882, 0.470>, <6.0853, 10.1298, 37.6673>, <0.004, 0.877, 0.481> }
	smooth_triangle { <6.0853, 10.1298, 37.6673>, <0.004, 0.877, 0.481>, <6.0405, 9.7502, 38.3428>, <0.029, 0.871, 0.491>, <5.4996, 9.5575, 38.7160>, <0.004, 0.877, 0.481> }
	smooth_triangle { <6.2840, 9.3086, 39.3125>, <0.592, 0.285, -0.754>, <6.0175, 8.9149, 38.9927>, <0.481, 0.333, -0.811>, <6.1349, 8.4211, 38.8595>, <0.592, 0.285, -0.754> }
	smooth_triangle { <6.1349, 8.4211, 38.8595>, <0.592, 0.285, -0.754>, <6.3822, 8.8349, 39.2512>, <0.693, 0.232, -0.683>, <6.2840, 9.3086, 39.3125>, <0.592, 0.285, -0.754> }
	smooth_triangle { <7.1286, 9.2245, 39.9043>, <-0.479, 0.385, 0.789>, <7.1424, 9.6867, 39.6793>, <-0.501, 0.391, 0.772>, <7.5044, 10.0865, 39.7117>, <-0.479, 0.385, 0.789> }
	smooth_triangle { <7.5044, 10.0865, 39.7117>, <-0.479, 0.385, 0.789>, <7.4892, 9.6107, 39.9273>, <-0.457, 0.379, 0.804>, <7.1286, 9.2245, 39.9043>, <-0.479, 0.385, 0.789> }
	smooth_triangle { <1.1982, 9.0823, 35.8075>, <-0.485, -0.057, -0.873>, <1.7795, 9.0433, 35.4760>, <-0.496, -0.024, -0.868>, <2.1745, 9.5116, 35.2371>, <-0.485, -0.057, -0.873> }
	smooth_triangle { <2.1745, 9.5116, 35.2371>, <-0.485, -0.057, -0.873>, <1.5789, 9.5459, 35.5548>, <-0.473, -0.090, -0.877>, <1.1982, 9.0823, 35.8075>, <-0.485, -0.057, -0.873> }
	smooth_triangle { <0.8936, 9.6166, 35.8342>, <-0.667, -0.228, 0.709>, <0.6342, 9.2839, 35.4786>, <-0.662, -0.241, 0.709>, <0.1898, 9.3867, 35.0984>, <-0.667, -0.228, 0.709> }
	smooth_triangle { <0.1898, 9.3867, 35.0984>, <-0.667, -0.228, 0.709>, <0.4589, 9.7232, 35.4552>, <-0.671, -0.215, 0.709>, <0.8936, 9.6166, 35.8342>, <-0.667, -0.228, 0.709> }
	smooth_triangle { <0.2673, 10.5149, 36.3864>, <-0.648, -0.056, -0.760>, <0.7578, 10.7937, 35.8933>, <-0.719, 0.039, -0.693>, <0.9421, 11.4745, 35.7404>, <-0.648, -0.056, -0.760> }
	smooth_triangle { <0.9421, 11.4745, 35.7404>, <-0.648, -0.056, -0.760>, <0.4147, 11.2160, 36.1545>, <-0.564, -0.150, -0.812>, <0.2673, 10.5149, 36.3864>, <-0.648, -0.056, -0.760> }
	smooth_triangle { <-0.4885, 11.3143, 36.9185>, <-0.282, -0.767, 0.576>, <-0.7279, 11.0728, 36.4984>, <-0.312, -0.736, 0.601>, <-1.2129, 11.1183, 36.3023>, <-0.282, -0.767, 0.576> }
	smooth_triangle { <-1.2129, 11.1183, 36.3023>, <-0.282, -0.767, 0.576>, <-0.9544, 11.3517, 36.7593>, <-0.252, -0.797, 0.549>, <-0.4885, 11.3143, 36.9185>, <-0.282, -0.767, 0.576> }
	smooth_triangle { <-1.0957, 11.5246, 37.7118>, <-0.711, -0.105, -0.695>, <-0.9073, 12.0088, 37.4562>, <-0.690, -0.109, -0.715>, <-1.0729, 12.5884, 37.5275>, <-0.711, -0.105, -0.695> }
	smooth_triangle { <-1.0729, 12.5884, 37.5275>, <-0.711, -0.105, -0.695>, <-1.2504, 12.0867, 37.7955>, <-0.732, -0.101, -0.674>, <-1.0957, 11.5246, 37.7118>, <-0.711, -0.105, -0.695> }
	smooth_triangle { <-1.7801, 11.5866, 38.4659>, <0.411, -0.784, 0.466>, <-2.0344, 11.1853, 37.9622>, <0.465, -0.792, 0.396>, <-2.5913, 10.8395, 37.9247>, <0.411, -0.784, 0.466> }
	smooth_triangle { <-2.5913, 10.8395, 37.9247>, <0.411, -0.784, 0.466>, <-2.3745, 11.2624, 38.3926>, <0.354, -0.770, 0.531>, <-1.7801, 11.5866, 38.4659>, <0.411, -0.784, 0.466> }
	smooth_triangle { <-2.4644, 11.7314, 39.1952>, <-0.690, -0.269, -0.672>, <-2.3727, 12.2158, 38.8694>, <-0.763, -0.255, -0.594>, <-2.5768, 12.7343, 38.9086>, <-0.690, -0.269, -0.672> }
	smooth_triangle { <-2.5768, 12.7343, 38.9086>, <-0.690, -0.269, -0.672>, <-2.7085, 12.2452, 39.2015>, <-0.609, -0.280, -0.742>, <-2.4644, 11.7314, 39.1952>, <-0.690, -0.269, -0.672> }
	smooth_triangle { <-3.2015, 11.7002, 39.9137>, <0.564, -0.613, 0.553>, <-3.3538, 11.1491, 39.4809>, <0.538, -0.608, 0.584>, <-3.9549, 10.6205, 39.4849>, <0.564, -0.613, 0.553> }
	smooth_triangle { <-3.9549, 10.6205, 39.4849>, <0.564, -0.613, 0.553>, <-3.7705, 11.1819, 39.9427>, <0.589, -0.618, 0.520>, <-3.2015, 11.7002, 39.9137>, <0.564, -0.613, 0.553> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0007B' */
union {
	smooth_triangle { <0.2727, 6.1590, 34.2561>, <0.794, 0.064, 0.604>, <1.2106, 5.5203, 33.0920>, <0.756, 0.089, 0.648>, <1.2058, 5.4970, 33.1009>, <0.643, -0.212, 0.736> }
	smooth_triangle { <0.2727, 6.1590, 34.2561>, <0.794, 0.064, 0.604>, <1.2058, 5.4970, 33.1009>, <0.643, -0.212, 0.736>, <0.2679, 6.1357, 34.2649>, <0.475, -0.552, 0.685> }
	smooth_triangle { <0.2679, 6.1357, 34.2649>, <0.475, -0.552, 0.685>, <1.2058, 5.4970, 33.1009>, <0.643, -0.212, 0.736>, <1.1859, 5.4840, 33.0920>, <-0.072, -0.867, 0.492> }
	smooth_triangle { <0.2679, 6.1357, 34.2649>, <0.475, -0.552, 0.685>, <1.1859, 5.4840, 33.0920>, <-0.072, -0.867, 0.492>, <0.2480, 6.1226, 34.2561>, <-0.338, -0.913, 0.228> }
	smooth_triangle { <0.2480, 6.1226, 34.2561>, <-0.338, -0.913, 0.228>, <1.1859, 5.4840, 33.0920>, <-0.072, -0.867, 0.492>, <1.1708, 5.4942, 33.0743>, <-0.715, -0.656, -0.244> }
	smooth_triangle { <0.2480, 6.1226, 34.2561>, <-0.338, -0.913, 0.228>, <1.1708, 5.4942, 33.0743>, <-0.715, -0.656, -0.244>, <0.2329, 6.1328, 34.2384>, <-0.813, -0.361, -0.457> }
	smooth_triangle { <0.2329, 6.1328, 34.2384>, <-0.813, -0.361, -0.457>, <1.1708, 5.4942, 33.0743>, <-0.715, -0.656, -0.244>, <1.1757, 5.5175, 33.0654>, <-0.643, 0.212, -0.736> }
	smooth_triangle { <0.2329, 6.1328, 34.2384>, <-0.813, -0.361, -0.457>, <1.1757, 5.5175, 33.0654>, <-0.643, 0.212, -0.736>, <0.2378, 6.1561, 34.2295>, <-0.475, 0.552, -0.685> }
	smooth_triangle { <0.2378, 6.1561, 34.2295>, <-0.475, 0.552, -0.685>, <1.1757, 5.5175, 33.0654>, <-0.643, 0.212, -0.736>, <1.1956, 5.5306, 33.0743>, <0.072, 0.867, -0.493> }
	smooth_triangle { <0.2378, 6.1561, 34.2295>, <-0.475, 0.552, -0.685>, <1.1956, 5.5306, 33.0743>, <0.072, 0.867, -0.493>, <0.2577, 6.1692, 34.2384>, <0.338, 0.913, -0.228> }
	smooth_triangle { <0.2577, 6.1692, 34.2384>, <0.338, 0.913, -0.228>, <1.1956, 5.5306, 33.0743>, <0.072, 0.867, -0.493>, <1.2106, 5.5203, 33.0920>, <0.568, 0.823, -0.001> }
	smooth_triangle { <0.2577, 6.1692, 34.2384>, <0.338, 0.913, -0.228>, <1.2106, 5.5203, 33.0920>, <0.568, 0.823, -0.001>, <0.2727, 6.1590, 34.2561>, <0.563, 0.827, 0.000> }
	smooth_triangle { <-1.4258, 7.3694, 35.5245>, <0.685, 0.129, 0.717>, <1.2106, 5.5203, 33.0920>, <0.756, 0.089, 0.648>, <1.2058, 5.4970, 33.1009>, <0.643, -0.212, 0.736> }
	smooth_triangle { <-1.4258, 7.3694, 35.5245>, <0.685, 0.129, 0.717>, <1.2058, 5.4970, 33.1009>, <0.643, -0.212, 0.736>, <-1.4332, 7.3477, 35.5353>, <0.427, -0.308, 0.850> }
	smooth_triangle { <-1.4332, 7.3477, 35.5353>, <0.427, -0.308, 0.850>, <1.2058, 5.4970, 33.1009>, <0.643, -0.212, 0.736>, <1.1859, 5.4840, 33.0920>, <-0.072, -0.867, 0.492> }
	smooth_triangle { <-1.4332, 7.3477, 35.5353>, <0.427, -0.308, 0.850>, <1.1859, 5.4840, 33.0920>, <-0.072, -0.867, 0.492>, <-1.4514, 7.3336, 35.5245>, <-0.325, -0.835, 0.445> }
	smooth_triangle { <-1.4514, 7.3336, 35.5245>, <-0.325, -0.835, 0.445>, <1.1859, 5.4840, 33.0920>, <-0.072, -0.867, 0.492>, <1.1708, 5.4942, 33.0743>, <-0.715, -0.656, -0.244> }
	smooth_triangle { <-1.4514, 7.3336, 35.5245>, <-0.325, -0.835, 0.445>, <1.1708, 5.4942, 33.0743>, <-0.715, -0.656, -0.244>, <-1.4621, 7.3413, 35.5028>, <-0.749, -0.525, -0.404> }
	smooth_triangle { <-1.4621, 7.3413, 35.5028>, <-0.749, -0.525, -0.404>, <1.1708, 5.4942, 33.0743>, <-0.715, -0.656, -0.244>, <1.1757, 5.5175, 33.0654>, <-0.643, 0.212, -0.736> }
	smooth_triangle { <-1.4621, 7.3413, 35.5028>, <-0.749, -0.525, -0.404>, <1.1757, 5.5175, 33.0654>, <-0.643, 0.212, -0.736>, <-1.4547, 7.3630, 35.4919>, <-0.427, 0.308, -0.850> }
	smooth_triangle { <-1.4547, 7.3630, 35.4919>, <-0.427, 0.308, -0.850>, <1.1757, 5.5175, 33.0654>, <-0.643, 0.212, -0.736>, <1.1956, 5.5306, 33.0743>, <0.072, 0.867, -0.493> }
	smooth_triangle { <-1.4547, 7.3630, 35.4919>, <-0.427, 0.308, -0.850>, <1.1956, 5.5306, 33.0743>, <0.072, 0.867, -0.493>, <-1.4366, 7.3771, 35.5028>, <0.325, 0.835, -0.445> }
	smooth_triangle { <-1.4366, 7.3771, 35.5028>, <0.325, 0.835, -0.445>, <1.1956, 5.5306, 33.0743>, <0.072, 0.867, -0.493>, <1.2106, 5.5203, 33.0920>, <0.568, 0.823, -0.001> }
	smooth_triangle { <-1.4366, 7.3771, 35.5028>, <0.325, 0.835, -0.445>, <1.2106, 5.5203, 33.0920>, <0.568, 0.823, -0.001>, <-1.4258, 7.3694, 35.5245>, <0.619, 0.785, -0.012> }
	smooth_triangle { <-3.1019, 8.7943, 36.5754>, <0.630, 0.134, 0.765>, <-1.4258, 7.3694, 35.5245>, <0.685, 0.129, 0.717>, <-1.4332, 7.3477, 35.5353>, <0.427, -0.308, 0.850> }
	smooth_triangle { <-3.1019, 8.7943, 36.5754>, <0.630, 0.134, 0.765>, <-1.4332, 7.3477, 35.5353>, <0.427, -0.308, 0.850>, <-3.1120, 8.7740, 36.5868>, <0.359, -0.299, 0.884> }
	smooth_triangle { <-3.1120, 8.7740, 36.5868>, <0.359, -0.299, 0.884>, <-1.4332, 7.3477, 35.5353>, <0.427, -0.308, 0.850>, <-1.4514, 7.3336, 35.5245>, <-0.325, -0.835, 0.445> }
	smooth_triangle { <-3.1120, 8.7740, 36.5868>, <0.359, -0.299, 0.884>, <-1.4514, 7.3336, 35.5245>, <-0.325, -0.835, 0.445>, <-3.1304, 8.7608, 36.5754>, <-0.380, -0.810, 0.447> }
	smooth_triangle { <-3.1304, 8.7608, 36.5754>, <-0.380, -0.810, 0.447>, <-1.4514, 7.3336, 35.5245>, <-0.325, -0.835, 0.445>, <-1.4621, 7.3413, 35.5028>, <-0.749, -0.525, -0.404> }
	smooth_triangle { <-3.1304, 8.7608, 36.5754>, <-0.380, -0.810, 0.447>, <-1.4621, 7.3413, 35.5028>, <-0.749, -0.525, -0.404>, <-3.1387, 8.7678, 36.5524>, <-0.739, -0.511, -0.438> }
	smooth_triangle { <-3.1387, 8.7678, 36.5524>, <-0.739, -0.511, -0.438>, <-1.4621, 7.3413, 35.5028>, <-0.749, -0.525, -0.404>, <-1.4547, 7.3630, 35.4919>, <-0.427, 0.308, -0.850> }
	smooth_triangle { <-3.1387, 8.7678, 36.5524>, <-0.739, -0.511, -0.438>, <-1.4547, 7.3630, 35.4919>, <-0.427, 0.308, -0.850>, <-3.1286, 8.7881, 36.5410>, <-0.359, 0.299, -0.884> }
	smooth_triangle { <-3.1286, 8.7881, 36.5410>, <-0.359, 0.299, -0.884>, <-1.4547, 7.3630, 35.4919>, <-0.427, 0.308, -0.850>, <-1.4366, 7.3771, 35.5028>, <0.325, 0.835, -0.445> }
	smooth_triangle { <-3.1286, 8.7881, 36.5410>, <-0.359, 0.299, -0.884>, <-1.4366, 7.3771, 35.5028>, <0.325, 0.835, -0.445>, <-3.1102, 8.8014, 36.5524>, <0.380, 0.810, -0.447> }
	smooth_triangle { <-3.1102, 8.8014, 36.5524>, <0.380, 0.810, -0.447>, <-1.4366, 7.3771, 35.5028>, <0.325, 0.835, -0.445>, <-1.4258, 7.3694, 35.5245>, <0.619, 0.785, -0.012> }
	smooth_triangle { <-3.1102, 8.8014, 36.5524>, <0.380, 0.810, -0.447>, <-1.4258, 7.3694, 35.5245>, <0.619, 0.785, -0.012>, <-3.1019, 8.7943, 36.5754>, <0.656, 0.755, -0.002> }
	smooth_triangle { <-4.1568, 9.7238, 37.3886>, <0.779, 0.229, 0.584>, <-3.1019, 8.7943, 36.5754>, <0.630, 0.134, 0.765>, <-3.1120, 8.7740, 36.5868>, <0.359, -0.299, 0.884> }
	smooth_triangle { <-4.1568, 9.7238, 37.3886>, <0.779, 0.229, 0.584>, <-3.1120, 8.7740, 36.5868>, <0.359, -0.299, 0.884>, <-4.1666, 9.7031, 37.3996>, <0.259, -0.373, 0.891> }
	smooth_triangle { <-4.1666, 9.7031, 37.3996>, <0.259, -0.373, 0.891>, <-3.1120, 8.7740, 36.5868>, <0.359, -0.299, 0.884>, <-3.1304, 8.7608, 36.5754>, <-0.380, -0.810, 0.447> }
	smooth_triangle { <-4.1666, 9.7031, 37.3996>, <0.259, -0.373, 0.891>, <-3.1304, 8.7608, 36.5754>, <-0.380, -0.810, 0.447>, <-4.1859, 9.6908, 37.3886>, <-0.543, -0.733, 0.410> }
	smooth_triangle { <-4.1859, 9.6908, 37.3886>, <-0.543, -0.733, 0.410>, <-3.1304, 8.7608, 36.5754>, <-0.380, -0.810, 0.447>, <-3.1387, 8.7678, 36.5524>, <-0.739, -0.511, -0.438> }
	smooth_triangle { <-4.1859, 9.6908, 37.3886>, <-0.543, -0.733, 0.410>, <-3.1387, 8.7678, 36.5524>, <-0.739, -0.511, -0.438>, <-4.1954, 9.6992, 37.3666>, <-0.804, -0.354, -0.478> }
	smooth_triangle { <-4.1954, 9.6992, 37.3666>, <-0.804, -0.354, -0.478>, <-3.1387, 8.7678, 36.5524>, <-0.739, -0.511, -0.438>, <-3.1286, 8.7881, 36.5410>, <-0.359, 0.299, -0.884> }
	smooth_triangle { <-4.1954, 9.6992, 37.3666>, <-0.804, -0.354, -0.478>, <-3.1286, 8.7881, 36.5410>, <-0.359, 0.299, -0.884>, <-4.1857, 9.7200, 37.3556>, <-0.267, 0.381, -0.885> }
	smooth_triangle { <-4.1857, 9.7200, 37.3556>, <-0.267, 0.381, -0.885>, <-3.1286, 8.7881, 36.5410>, <-0.359, 0.299, -0.884>, <-3.1102, 8.8014, 36.5524>, <0.380, 0.810, -0.447> }
	smooth_triangle { <-4.1857, 9.7200, 37.3556>, <-0.267, 0.381, -0.885>, <-3.1102, 8.8014, 36.5524>, <0.380, 0.810, -0.447>, <-4.1663, 9.7323, 37.3666>, <0.536, 0.741, -0.405> }
	smooth_triangle { <-4.1663, 9.7323, 37.3666>, <0.536, 0.741, -0.405>, <-3.1102, 8.8014, 36.5524>, <0.380, 0.810, -0.447>, <-3.1019, 8.7943, 36.5754>, <0.656, 0.755, -0.002> }
	smooth_triangle { <-4.1663, 9.7323, 37.3666>, <0.536, 0.741, -0.405>, <-3.1019, 8.7943, 36.5754>, <0.656, 0.755, -0.002>, <-4.1568, 9.7238, 37.3886>, <0.661, 0.750, 0.000> }
	smooth_triangle { <-4.9452, 11.0262, 37.9457>, <0.658, 0.087, 0.748>, <-4.1568, 9.7238, 37.3886>, <0.779, 0.229, 0.584>, <-4.1666, 9.7031, 37.3996>, <0.259, -0.373, 0.891> }
	smooth_triangle { <-4.9452, 11.0262, 37.9457>, <-0.178, -0.457, 0.872>, <-4.1666, 9.7031, 37.3996>, <0.259, -0.373, 0.891>, <-4.1859, 9.6908, 37.3886>, <-0.543, -0.733, 0.410> }
	smooth_triangle { <-4.9452, 11.0262, 37.9457>, <-0.838, -0.527, 0.141>, <-4.1859, 9.6908, 37.3886>, <-0.543, -0.733, 0.410>, <-4.1954, 9.6992, 37.3666>, <-0.804, -0.354, -0.478> }
	smooth_triangle { <-4.9452, 11.0262, 37.9457>, <-0.681, -0.058, -0.730>, <-4.1954, 9.6992, 37.3666>, <-0.804, -0.354, -0.478>, <-4.1857, 9.7200, 37.3556>, <-0.267, 0.381, -0.885> }
	smooth_triangle { <-4.9452, 11.0262, 37.9457>, <0.156, 0.487, -0.859>, <-4.1857, 9.7200, 37.3556>, <-0.267, 0.381, -0.885>, <-4.1663, 9.7323, 37.3666>, <0.536, 0.741, -0.405> }
	smooth_triangle { <-4.9452, 11.0262, 37.9457>, <0.820, 0.558, -0.125>, <-4.1663, 9.7323, 37.3666>, <0.536, 0.741, -0.405>, <-4.1568, 9.7238, 37.3886>, <0.779, 0.229, 0.584> }
	smooth_triangle { <-1.8430, 8.5029, 35.6189>, <0.492, 0.111, 0.864>, <-1.4230, 7.3621, 35.5263>, <0.490, 0.117, 0.864>, <-1.4433, 7.3536, 35.5390>, <0.192, 0.035, 0.981> }
	smooth_triangle { <-1.8430, 8.5029, 35.6189>, <0.492, 0.111, 0.864>, <-1.4433, 7.3536, 35.5390>, <0.192, 0.035, 0.981>, <-1.8633, 8.4944, 35.6315>, <-0.152, -0.135, 0.979> }
	smooth_triangle { <-1.8633, 8.4944, 35.6315>, <-0.152, -0.135, 0.979>, <-1.4433, 7.3536, 35.5390>, <0.192, 0.035, 0.981>, <-1.4643, 7.3469, 35.5263>, <-0.724, -0.204, 0.658> }
	smooth_triangle { <-1.8633, 8.4944, 35.6315>, <-0.152, -0.135, 0.979>, <-1.4643, 7.3469, 35.5263>, <-0.724, -0.204, 0.658>, <-1.8843, 8.4877, 35.6189>, <-0.878, -0.350, 0.326> }
	smooth_triangle { <-1.8843, 8.4877, 35.6189>, <-0.878, -0.350, 0.326>, <-1.4643, 7.3469, 35.5263>, <-0.724, -0.204, 0.658>, <-1.4649, 7.3487, 35.5010>, <-0.916, -0.239, -0.323> }
	smooth_triangle { <-1.8843, 8.4877, 35.6189>, <-0.878, -0.350, 0.326>, <-1.4649, 7.3487, 35.5010>, <-0.916, -0.239, -0.323>, <-1.8849, 8.4895, 35.5935>, <-0.727, -0.214, -0.653> }
	smooth_triangle { <-1.8849, 8.4895, 35.5935>, <-0.727, -0.214, -0.653>, <-1.4649, 7.3487, 35.5010>, <-0.916, -0.239, -0.323>, <-1.4446, 7.3572, 35.4883>, <-0.192, -0.035, -0.981> }
	smooth_triangle { <-1.8849, 8.4895, 35.5935>, <-0.727, -0.214, -0.653>, <-1.4446, 7.3572, 35.4883>, <-0.192, -0.035, -0.981>, <-1.8646, 8.4980, 35.5809>, <0.152, 0.135, -0.979> }
	smooth_triangle { <-1.8646, 8.4980, 35.5809>, <0.152, 0.135, -0.979>, <-1.4446, 7.3572, 35.4883>, <-0.192, -0.035, -0.981>, <-1.4237, 7.3639, 35.5010>, <0.724, 0.204, -0.658> }
	smooth_triangle { <-1.8646, 8.4980, 35.5809>, <0.152, 0.135, -0.979>, <-1.4237, 7.3639, 35.5010>, <0.724, 0.204, -0.658>, <-1.8436, 8.5047, 35.5935>, <0.878, 0.350, -0.326> }
	smooth_triangle { <-1.8436, 8.5047, 35.5935>, <0.878, 0.350, -0.326>, <-1.4237, 7.3639, 35.5010>, <0.724, 0.204, -0.658>, <-1.4230, 7.3621, 35.5263>, <0.966, 0.257, -0.006> }
	smooth_triangle { <-1.8436, 8.5047, 35.5935>, <0.878, 0.350, -0.326>, <-1.4230, 7.3621, 35.5263>, <0.966, 0.257, -0.006>, <-1.8430, 8.5029, 35.6189>, <0.938, 0.345, 0.000> }
	smooth_triangle { <-2.0283, 10.9173, 35.3661>, <0.494, 0.068, 0.867>, <-1.4230, 7.3621, 35.5263>, <0.490, 0.117, 0.864>, <-1.4433, 7.3536, 35.5390>, <0.192, 0.035, 0.981> }
	smooth_triangle { <-2.0283, 10.9173, 35.3661>, <0.494, 0.068, 0.867>, <-1.4433, 7.3536, 35.5390>, <0.192, 0.035, 0.981>, <-2.0503, 10.9169, 35.3787>, <-0.003, -0.005, 1.000> }
	smooth_triangle { <-2.0503, 10.9169, 35.3787>, <-0.003, -0.005, 1.000>, <-1.4433, 7.3536, 35.5390>, <0.192, 0.035, 0.981>, <-1.4643, 7.3469, 35.5263>, <-0.724, -0.204, 0.658> }
	smooth_triangle { <-2.0503, 10.9169, 35.3787>, <-0.003, -0.005, 1.000>, <-1.4643, 7.3469, 35.5263>, <-0.724, -0.204, 0.658>, <-2.0721, 10.9139, 35.3661>, <-0.863, -0.051, 0.503> }
	smooth_triangle { <-2.0721, 10.9139, 35.3661>, <-0.863, -0.051, 0.503>, <-1.4643, 7.3469, 35.5263>, <-0.724, -0.204, 0.658>, <-1.4649, 7.3487, 35.5010>, <-0.916, -0.239, -0.323> }
	smooth_triangle { <-2.0721, 10.9139, 35.3661>, <-0.863, -0.051, 0.503>, <-1.4649, 7.3487, 35.5010>, <-0.916, -0.239, -0.323>, <-2.0719, 10.9113, 35.3408>, <-0.863, -0.046, -0.503> }
	smooth_triangle { <-2.0719, 10.9113, 35.3408>, <-0.863, -0.046, -0.503>, <-1.4649, 7.3487, 35.5010>, <-0.916, -0.239, -0.323>, <-1.4446, 7.3572, 35.4883>, <-0.192, -0.035, -0.981> }
	smooth_triangle { <-2.0719, 10.9113, 35.3408>, <-0.863, -0.046, -0.503>, <-1.4446, 7.3572, 35.4883>, <-0.192, -0.035, -0.981>, <-2.0499, 10.9117, 35.3282>, <0.003, 0.005, -1.000> }
	smooth_triangle { <-2.0499, 10.9117, 35.3282>, <0.003, 0.005, -1.000>, <-1.4446, 7.3572, 35.4883>, <-0.192, -0.035, -0.981>, <-1.4237, 7.3639, 35.5010>, <0.724, 0.204, -0.658> }
	smooth_triangle { <-2.0499, 10.9117, 35.3282>, <0.003, 0.005, -1.000>, <-1.4237, 7.3639, 35.5010>, <0.724, 0.204, -0.658>, <-2.0281, 10.9147, 35.3408>, <0.863, 0.051, -0.503> }
	smooth_triangle { <-2.0281, 10.9147, 35.3408>, <0.863, 0.051, -0.503>, <-1.4237, 7.3639, 35.5010>, <0.724, 0.204, -0.658>, <-1.4230, 7.3621, 35.5263>, <0.966, 0.257, -0.006> }
	smooth_triangle { <-2.0281, 10.9147, 35.3408>, <0.863, 0.051, -0.503>, <-1.4230, 7.3621, 35.5263>, <0.966, 0.257, -0.006>, <-2.0283, 10.9173, 35.3661>, <1.000, 0.012, 0.002> }
	smooth_triangle { <-1.8935, 12.9402, 35.3844>, <0.667, 0.183, 0.723>, <-2.0283, 10.9173, 35.3661>, <0.494, 0.068, 0.867>, <-2.0503, 10.9169, 35.3787>, <-0.003, -0.005, 1.000> }
	smooth_triangle { <-1.8935, 12.9402, 35.3844>, <0.667, 0.183, 0.723>, <-2.0503, 10.9169, 35.3787>, <-0.003, -0.005, 1.000>, <-1.9154, 12.9415, 35.3971>, <-0.118, -0.003, 0.993> }
	smooth_triangle { <-1.9154, 12.9415, 35.3971>, <-0.118, -0.003, 0.993>, <-2.0503, 10.9169, 35.3787>, <-0.003, -0.005, 1.000>, <-2.0721, 10.9139, 35.3661>, <-0.863, -0.051, 0.503> }
	smooth_triangle { <-1.9154, 12.9415, 35.3971>, <-0.118, -0.003, 0.993>, <-2.0721, 10.9139, 35.3661>, <-0.863, -0.051, 0.503>, <-1.9374, 12.9431, 35.3844>, <-0.910, -0.137, 0.392> }
	smooth_triangle { <-1.9374, 12.9431, 35.3844>, <-0.910, -0.137, 0.392>, <-2.0721, 10.9139, 35.3661>, <-0.863, -0.051, 0.503>, <-2.0719, 10.9113, 35.3408>, <-0.863, -0.046, -0.503> }
	smooth_triangle { <-1.9374, 12.9431, 35.3844>, <-0.910, -0.137, 0.392>, <-2.0719, 10.9113, 35.3408>, <-0.863, -0.046, -0.503>, <-1.9373, 12.9433, 35.3590>, <-0.789, -0.128, -0.601> }
	smooth_triangle { <-1.9373, 12.9433, 35.3590>, <-0.789, -0.128, -0.601>, <-2.0719, 10.9113, 35.3408>, <-0.863, -0.046, -0.503>, <-2.0499, 10.9117, 35.3282>, <0.003, 0.005, -1.000> }
	smooth_triangle { <-1.9373, 12.9433, 35.3590>, <-0.789, -0.128, -0.601>, <-2.0499, 10.9117, 35.3282>, <0.003, 0.005, -1.000>, <-1.9154, 12.9420, 35.3463>, <0.117, 0.013, -0.993> }
	smooth_triangle { <-1.9154, 12.9420, 35.3463>, <0.117, 0.013, -0.993>, <-2.0499, 10.9117, 35.3282>, <0.003, 0.005, -1.000>, <-2.0281, 10.9147, 35.3408>, <0.863, 0.051, -0.503> }
	smooth_triangle { <-1.9154, 12.9420, 35.3463>, <0.117, 0.013, -0.993>, <-2.0281, 10.9147, 35.3408>, <0.863, 0.051, -0.503>, <-1.8934, 12.9404, 35.3590>, <0.909, 0.146, -0.391> }
	smooth_triangle { <-1.8934, 12.9404, 35.3590>, <0.909, 0.146, -0.391>, <-2.0281, 10.9147, 35.3408>, <0.863, 0.051, -0.503>, <-2.0283, 10.9173, 35.3661>, <1.000, 0.012, 0.002> }
	smooth_triangle { <-1.8934, 12.9404, 35.3590>, <0.909, 0.146, -0.391>, <-2.0283, 10.9173, 35.3661>, <1.000, 0.012, 0.002>, <-1.8935, 12.9402, 35.3844>, <0.998, -0.066, 0.000> }
	smooth_triangle { <-2.8732, 14.7331, 35.4217>, <0.454, 0.236, 0.859>, <-1.8935, 12.9402, 35.3844>, <0.667, 0.183, 0.723>, <-1.9154, 12.9415, 35.3971>, <-0.118, -0.003, 0.993> }
	smooth_triangle { <-2.8732, 14.7331, 35.4217>, <-0.458, -0.251, 0.852>, <-1.9154, 12.9415, 35.3971>, <-0.118, -0.003, 0.993>, <-1.9374, 12.9431, 35.3844>, <-0.910, -0.137, 0.392> }
	smooth_triangle { <-2.8732, 14.7331, 35.4217>, <-0.889, -0.459, -0.008>, <-1.9374, 12.9431, 35.3844>, <-0.910, -0.137, 0.392>, <-1.9373, 12.9433, 35.3590>, <-0.789, -0.128, -0.601> }
	smooth_triangle { <-2.8732, 14.7331, 35.4217>, <-0.463, -0.206, -0.862>, <-1.9373, 12.9433, 35.3590>, <-0.789, -0.128, -0.601>, <-1.9154, 12.9420, 35.3463>, <0.117, 0.013, -0.993> }
	smooth_triangle { <-2.8732, 14.7331, 35.4217>, <0.450, 0.281, -0.848>, <-1.9154, 12.9420, 35.3463>, <0.117, 0.013, -0.993>, <-1.8934, 12.9404, 35.3590>, <0.909, 0.146, -0.391> }
	smooth_triangle { <-2.8732, 14.7331, 35.4217>, <0.875, 0.484, 0.009>, <-1.8934, 12.9404, 35.3590>, <0.909, 0.146, -0.391>, <-1.8935, 12.9402, 35.3844>, <0.667, 0.183, 0.723> }
	smooth_triangle { <-2.5294, 7.1378, 36.0250>, <0.239, 0.565, 0.790>, <-1.4436, 7.3780, 35.5252>, <0.298, 0.577, 0.761>, <-1.4338, 7.3576, 35.5368>, <0.420, 0.290, 0.860> }
	smooth_triangle { <-2.5294, 7.1378, 36.0250>, <0.239, 0.565, 0.790>, <-1.4338, 7.3576, 35.5368>, <0.420, 0.290, 0.860>, <-2.5196, 7.1175, 36.0366>, <0.434, -0.098, 0.896> }
	smooth_triangle { <-2.5196, 7.1175, 36.0366>, <0.434, -0.098, 0.896>, <-1.4338, 7.3576, 35.5368>, <0.420, 0.290, 0.860>, <-1.4341, 7.3350, 35.5252>, <0.477, -0.667, 0.572> }
	smooth_triangle { <-2.5196, 7.1175, 36.0366>, <0.434, -0.098, 0.896>, <-1.4341, 7.3350, 35.5252>, <0.477, -0.667, 0.572>, <-2.5199, 7.0949, 36.0250>, <0.335, -0.894, 0.299> }
	smooth_triangle { <-2.5199, 7.0949, 36.0250>, <0.335, -0.894, 0.299>, <-1.4341, 7.3350, 35.5252>, <0.477, -0.667, 0.572>, <-1.4443, 7.3328, 35.5021>, <0.057, -0.956, -0.287> }
	smooth_triangle { <-2.5199, 7.0949, 36.0250>, <0.335, -0.894, 0.299>, <-1.4443, 7.3328, 35.5021>, <0.057, -0.956, -0.287>, <-2.5301, 7.0926, 36.0019>, <-0.099, -0.796, -0.597> }
	smooth_triangle { <-2.5301, 7.0926, 36.0019>, <-0.099, -0.796, -0.597>, <-1.4443, 7.3328, 35.5021>, <0.057, -0.956, -0.287>, <-1.4541, 7.3531, 35.4905>, <-0.420, -0.290, -0.860> }
	smooth_triangle { <-2.5301, 7.0926, 36.0019>, <-0.099, -0.796, -0.597>, <-1.4541, 7.3531, 35.4905>, <-0.420, -0.290, -0.860>, <-2.5399, 7.1130, 35.9903>, <-0.434, 0.098, -0.896> }
	smooth_triangle { <-2.5399, 7.1130, 35.9903>, <-0.434, 0.098, -0.896>, <-1.4541, 7.3531, 35.4905>, <-0.420, -0.290, -0.860>, <-1.4538, 7.3757, 35.5021>, <-0.477, 0.667, -0.572> }
	smooth_triangle { <-2.5399, 7.1130, 35.9903>, <-0.434, 0.098, -0.896>, <-1.4538, 7.3757, 35.5021>, <-0.477, 0.667, -0.572>, <-2.5396, 7.1356, 36.0019>, <-0.335, 0.894, -0.299> }
	smooth_triangle { <-2.5396, 7.1356, 36.0019>, <-0.335, 0.894, -0.299>, <-1.4538, 7.3757, 35.5021>, <-0.477, 0.667, -0.572>, <-1.4436, 7.3780, 35.5252>, <-0.224, 0.975, 0.000> }
	smooth_triangle { <-2.5396, 7.1356, 36.0019>, <-0.335, 0.894, -0.299>, <-1.4436, 7.3780, 35.5252>, <-0.224, 0.975, 0.000>, <-2.5294, 7.1378, 36.0250>, <-0.216, 0.976, 0.000> }
	smooth_triangle { <-4.3863, 6.6745, 37.5318>, <0.279, 0.573, 0.771>, <-1.4436, 7.3780, 35.5252>, <0.298, 0.577, 0.761>, <-1.4338, 7.3576, 35.5368>, <0.420, 0.290, 0.860> }
	smooth_triangle { <-4.3863, 6.6745, 37.5318>, <0.279, 0.573, 0.771>, <-1.4338, 7.3576, 35.5368>, <0.420, 0.290, 0.860>, <-4.3733, 6.6550, 37.5418>, <0.397, 0.097, 0.913> }
	smooth_triangle { <-4.3733, 6.6550, 37.5418>, <0.397, 0.097, 0.913>, <-1.4338, 7.3576, 35.5368>, <0.420, 0.290, 0.860>, <-1.4341, 7.3350, 35.5252>, <0.477, -0.667, 0.572> }
	smooth_triangle { <-4.3733, 6.6550, 37.5418>, <0.397, 0.097, 0.913>, <-1.4341, 7.3350, 35.5252>, <0.477, -0.667, 0.572>, <-4.3756, 6.6318, 37.5318>, <0.351, -0.804, 0.480> }
	smooth_triangle { <-4.3756, 6.6318, 37.5318>, <0.351, -0.804, 0.480>, <-1.4341, 7.3350, 35.5252>, <0.477, -0.667, 0.572>, <-1.4443, 7.3328, 35.5021>, <0.057, -0.956, -0.287> }
	smooth_triangle { <-4.3756, 6.6318, 37.5318>, <0.351, -0.804, 0.480>, <-1.4443, 7.3328, 35.5021>, <0.057, -0.956, -0.287>, <-4.3909, 6.6280, 37.5119>, <-0.047, -0.900, -0.434> }
	smooth_triangle { <-4.3909, 6.6280, 37.5119>, <-0.047, -0.900, -0.434>, <-1.4443, 7.3328, 35.5021>, <0.057, -0.956, -0.287>, <-1.4541, 7.3531, 35.4905>, <-0.420, -0.290, -0.860> }
	smooth_triangle { <-4.3909, 6.6280, 37.5119>, <-0.047, -0.900, -0.434>, <-1.4541, 7.3531, 35.4905>, <-0.420, -0.290, -0.860>, <-4.4038, 6.6474, 37.5019>, <-0.396, -0.097, -0.913> }
	smooth_triangle { <-4.4038, 6.6474, 37.5019>, <-0.396, -0.097, -0.913>, <-1.4541, 7.3531, 35.4905>, <-0.420, -0.290, -0.860>, <-1.4538, 7.3757, 35.5021>, <-0.477, 0.667, -0.572> }
	smooth_triangle { <-4.4038, 6.6474, 37.5019>, <-0.396, -0.097, -0.913>, <-1.4538, 7.3757, 35.5021>, <-0.477, 0.667, -0.572>, <-4.4015, 6.6707, 37.5119>, <-0.350, 0.804, -0.480> }
	smooth_triangle { <-4.4015, 6.6707, 37.5119>, <-0.350, 0.804, -0.480>, <-1.4538, 7.3757, 35.5021>, <-0.477, 0.667, -0.572>, <-1.4436, 7.3780, 35.5252>, <-0.224, 0.975, 0.000> }
	smooth_triangle { <-4.4015, 6.6707, 37.5119>, <-0.350, 0.804, -0.480>, <-1.4436, 7.3780, 35.5252>, <-0.224, 0.975, 0.000>, <-4.3863, 6.6745, 37.5318>, <-0.196, 0.980, -0.018> }
	smooth_triangle { <-6.3319, 6.3390, 38.0274>, <-0.029, 0.677, 0.735>, <-4.3863, 6.6745, 37.5318>, <0.279, 0.573, 0.771>, <-4.3733, 6.6550, 37.5418>, <0.397, 0.097, 0.913> }
	smooth_triangle { <-6.3319, 6.3390, 38.0274>, <-0.029, 0.677, 0.735>, <-4.3733, 6.6550, 37.5418>, <0.397, 0.097, 0.913>, <-6.3252, 6.3178, 38.0397>, <0.392, -0.021, 0.920> }
	smooth_triangle { <-6.3252, 6.3178, 38.0397>, <0.392, -0.021, 0.920>, <-4.3733, 6.6550, 37.5418>, <0.397, 0.097, 0.913>, <-4.3756, 6.6318, 37.5318>, <0.351, -0.804, 0.480> }
	smooth_triangle { <-6.3252, 6.3178, 38.0397>, <0.392, -0.021, 0.920>, <-4.3756, 6.6318, 37.5318>, <0.351, -0.804, 0.480>, <-6.3245, 6.2956, 38.0274>, <0.457, -0.829, 0.322> }
	smooth_triangle { <-6.3245, 6.2956, 38.0274>, <0.457, -0.829, 0.322>, <-4.3756, 6.6318, 37.5318>, <0.351, -0.804, 0.480>, <-4.3909, 6.6280, 37.5119>, <-0.047, -0.900, -0.434> }
	smooth_triangle { <-6.3245, 6.2956, 38.0274>, <0.457, -0.829, 0.322>, <-4.3909, 6.6280, 37.5119>, <-0.047, -0.900, -0.434>, <-6.3306, 6.2946, 38.0027>, <0.054, -0.794, -0.605> }
	smooth_triangle { <-6.3306, 6.2946, 38.0027>, <0.054, -0.794, -0.605>, <-4.3909, 6.6280, 37.5119>, <-0.047, -0.900, -0.434>, <-4.4038, 6.6474, 37.5019>, <-0.396, -0.097, -0.913> }
	smooth_triangle { <-6.3306, 6.2946, 38.0027>, <0.054, -0.794, -0.605>, <-4.4038, 6.6474, 37.5019>, <-0.396, -0.097, -0.913>, <-6.3373, 6.3158, 37.9904>, <-0.400, 0.019, -0.916> }
	smooth_triangle { <-6.3373, 6.3158, 37.9904>, <-0.400, 0.019, -0.916>, <-4.4038, 6.6474, 37.5019>, <-0.396, -0.097, -0.913>, <-4.4015, 6.6707, 37.5119>, <-0.350, 0.804, -0.480> }
	smooth_triangle { <-6.3373, 6.3158, 37.9904>, <-0.400, 0.019, -0.916>, <-4.4015, 6.6707, 37.5119>, <-0.350, 0.804, -0.480>, <-6.3380, 6.3380, 38.0027>, <-0.464, 0.827, -0.319> }
	smooth_triangle { <-6.3380, 6.3380, 38.0027>, <-0.464, 0.827, -0.319>, <-4.4015, 6.6707, 37.5119>, <-0.350, 0.804, -0.480>, <-4.3863, 6.6745, 37.5318>, <-0.196, 0.980, -0.018> }
	smooth_triangle { <-6.3380, 6.3380, 38.0027>, <-0.464, 0.827, -0.319>, <-4.3863, 6.6745, 37.5318>, <-0.196, 0.980, -0.018>, <-6.3319, 6.3390, 38.0274>, <-0.170, 0.985, 0.000> }
	smooth_triangle { <-7.6412, 5.2449, 39.1394>, <0.210, 0.556, 0.804>, <-6.3319, 6.3390, 38.0274>, <-0.029, 0.677, 0.735>, <-6.3252, 6.3178, 38.0397>, <0.392, -0.021, 0.920> }
	smooth_triangle { <-7.6412, 5.2449, 39.1394>, <0.735, -0.277, 0.618>, <-6.3252, 6.3178, 38.0397>, <0.392, -0.021, 0.920>, <-6.3245, 6.2956, 38.0274>, <0.457, -0.829, 0.322> }
	smooth_triangle { <-7.6412, 5.2449, 39.1394>, <0.528, -0.835, -0.155>, <-6.3245, 6.2956, 38.0274>, <0.457, -0.829, 0.322>, <-6.3306, 6.2946, 38.0027>, <0.054, -0.794, -0.605> }
	smooth_triangle { <-7.6412, 5.2449, 39.1394>, <-0.238, -0.567, -0.789>, <-6.3306, 6.2946, 38.0027>, <0.054, -0.794, -0.605>, <-6.3373, 6.3158, 37.9904>, <-0.400, 0.019, -0.916> }
	smooth_triangle { <-7.6412, 5.2449, 39.1394>, <-0.754, 0.265, -0.601>, <-6.3373, 6.3158, 37.9904>, <-0.400, 0.019, -0.916>, <-6.3380, 6.3380, 38.0027>, <-0.464, 0.827, -0.319> }
	smooth_triangle { <-7.6412, 5.2449, 39.1394>, <-0.550, 0.819, 0.166>, <-6.3380, 6.3380, 38.0027>, <-0.464, 0.827, -0.319>, <-6.3319, 6.3390, 38.0274>, <-0.029, 0.677, 0.735> }
	smooth_triangle { <-2.0343, 7.2784, 36.5779>, <0.658, 0.618, 0.430>, <-1.4367, 7.3789, 35.5200>, <0.675, 0.620, 0.399>, <-1.4222, 7.3590, 35.5263>, <0.771, 0.460, 0.440> }
	smooth_triangle { <-2.0343, 7.2784, 36.5779>, <0.658, 0.618, 0.430>, <-1.4222, 7.3590, 35.5263>, <0.771, 0.460, 0.440>, <-2.0198, 7.2585, 36.5842>, <0.872, -0.045, 0.488> }
	smooth_triangle { <-2.0198, 7.2585, 36.5842>, <0.872, -0.045, 0.488>, <-1.4222, 7.3590, 35.5263>, <0.868, 0.268, 0.418>, <-1.4294, 7.3355, 35.5200>, <0.814, -0.521, 0.256> }
	smooth_triangle { <-2.0198, 7.2585, 36.5842>, <0.872, -0.045, 0.488>, <-1.4294, 7.3355, 35.5200>, <0.814, -0.521, 0.256>, <-2.0270, 7.2350, 36.5779>, <0.437, -0.885, 0.163> }
	smooth_triangle { <-2.0270, 7.2350, 36.5779>, <0.437, -0.885, 0.163>, <-1.4294, 7.3355, 35.5200>, <0.697, -0.691, 0.190>, <-1.4512, 7.3318, 35.5073>, <0.038, -0.982, -0.184> }
	smooth_triangle { <-2.0270, 7.2350, 36.5779>, <0.437, -0.885, 0.163>, <-1.4512, 7.3318, 35.5073>, <0.038, -0.982, -0.184>, <-2.0487, 7.2313, 36.5653>, <-0.435, -0.840, -0.325> }
	smooth_triangle { <-2.0487, 7.2313, 36.5653>, <-0.435, -0.840, -0.325>, <-1.4512, 7.3318, 35.5073>, <-0.173, -0.958, -0.226>, <-1.4657, 7.3517, 35.5010>, <-0.772, -0.460, -0.438> }
	smooth_triangle { <-2.0487, 7.2313, 36.5653>, <-0.435, -0.840, -0.325>, <-1.4657, 7.3517, 35.5010>, <-0.772, -0.460, -0.438>, <-2.0632, 7.2512, 36.5590>, <-0.872, 0.045, -0.488> }
	smooth_triangle { <-2.0632, 7.2512, 36.5590>, <-0.872, 0.045, -0.488>, <-1.4657, 7.3517, 35.5010>, <-0.870, -0.269, -0.413>, <-1.4585, 7.3752, 35.5073>, <-0.815, 0.521, -0.254> }
	smooth_triangle { <-2.0632, 7.2512, 36.5590>, <-0.872, 0.045, -0.488>, <-1.4585, 7.3752, 35.5073>, <-0.815, 0.521, -0.254>, <-2.0560, 7.2747, 36.5653>, <-0.437, 0.885, -0.163> }
	smooth_triangle { <-2.0560, 7.2747, 36.5653>, <-0.437, 0.885, -0.163>, <-1.4585, 7.3752, 35.5073>, <-0.699, 0.690, -0.185>, <-1.4367, 7.3789, 35.5200>, <-0.425, 0.905, 0.016> }
	smooth_triangle { <-2.0560, 7.2747, 36.5653>, <-0.437, 0.885, -0.163>, <-1.4367, 7.3789, 35.5200>, <-0.425, 0.905, 0.016>, <-2.0343, 7.2784, 36.5779>, <-0.166, 0.986, 0.000> }
	smooth_triangle { <-2.3299, 6.4132, 38.8421>, <0.098, 0.956, 0.275>, <-1.4367, 7.3789, 35.5200>, <0.675, 0.620, 0.399>, <-1.4222, 7.3590, 35.5263>, <0.771, 0.460, 0.440> }
	smooth_triangle { <-2.3299, 6.4132, 38.8421>, <-0.221, 0.956, 0.196>, <-1.4222, 7.3590, 35.5263>, <0.493, 0.775, 0.397>, <-2.3053, 6.4178, 38.8467>, <0.290, 0.910, 0.295> }
	smooth_triangle { <-2.3053, 6.4178, 38.8467>, <0.890, 0.338, 0.306>, <-1.4222, 7.3590, 35.5263>, <0.868, 0.268, 0.418>, <-1.4294, 7.3355, 35.5200>, <0.814, -0.521, 0.256> }
	smooth_triangle { <-2.3053, 6.4178, 38.8467>, <0.535, 0.780, 0.325>, <-1.4294, 7.3355, 35.5200>, <0.916, -0.128, 0.381>, <-2.2879, 6.4000, 38.8421>, <0.950, 0.151, 0.274> }
	smooth_triangle { <-2.2879, 6.4000, 38.8421>, <0.789, -0.613, 0.035>, <-1.4294, 7.3355, 35.5200>, <0.697, -0.691, 0.190>, <-1.4512, 7.3318, 35.5073>, <0.038, -0.982, -0.184> }
	smooth_triangle { <-2.2879, 6.4000, 38.8421>, <0.972, -0.115, 0.206>, <-1.4512, 7.3318, 35.5073>, <0.425, -0.905, -0.017>, <-2.2950, 6.3775, 38.8327>, <0.656, -0.754, -0.019> }
	smooth_triangle { <-2.2950, 6.3775, 38.8327>, <-0.100, -0.958, -0.269>, <-1.4512, 7.3318, 35.5073>, <-0.173, -0.958, -0.226>, <-1.4657, 7.3517, 35.5010>, <-0.772, -0.460, -0.438> }
	smooth_triangle { <-2.2950, 6.3775, 38.8327>, <0.436, -0.893, -0.116>, <-1.4657, 7.3517, 35.5010>, <-0.494, -0.774, -0.397>, <-2.3195, 6.3728, 38.8280>, <-0.291, -0.911, -0.292> }
	smooth_triangle { <-2.3195, 6.3728, 38.8280>, <-0.892, -0.340, -0.299>, <-1.4657, 7.3517, 35.5010>, <-0.870, -0.269, -0.413>, <-1.4585, 7.3752, 35.5073>, <-0.815, 0.521, -0.254> }
	smooth_triangle { <-2.3195, 6.3728, 38.8280>, <-0.537, -0.781, -0.319>, <-1.4585, 7.3752, 35.5073>, <-0.916, 0.129, -0.381>, <-2.3370, 6.3907, 38.8327>, <-0.951, -0.152, -0.271> }
	smooth_triangle { <-2.3370, 6.3907, 38.8327>, <-0.792, 0.610, -0.030>, <-1.4585, 7.3752, 35.5073>, <-0.699, 0.690, -0.185>, <-1.4367, 7.3789, 35.5200>, <-0.425, 0.905, 0.016> }
	smooth_triangle { <-2.3370, 6.3907, 38.8327>, <-0.973, 0.113, -0.200>, <-1.4367, 7.3789, 35.5200>, <-0.425, 0.905, 0.016>, <-2.3299, 6.4132, 38.8421>, <-0.924, 0.352, -0.146> }
	smooth_triangle { <-2.8599, 5.9307, 41.1676>, <-0.208, 0.965, 0.158>, <-2.3299, 6.4132, 38.8421>, <-0.221, 0.956, 0.196>, <-2.3053, 6.4178, 38.8467>, <0.290, 0.910, 0.295> }
	smooth_triangle { <-2.8599, 5.9307, 41.1676>, <0.721, 0.621, 0.307>, <-2.3053, 6.4178, 38.8467>, <0.535, 0.780, 0.325>, <-2.2879, 6.4000, 38.8421>, <0.950, 0.151, 0.274> }
	smooth_triangle { <-2.8599, 5.9307, 41.1676>, <0.923, -0.349, 0.161>, <-2.2879, 6.4000, 38.8421>, <0.972, -0.115, 0.206>, <-2.2950, 6.3775, 38.8327>, <0.656, -0.754, -0.019> }
	smooth_triangle { <-2.8599, 5.9307, 41.1676>, <0.203, -0.970, -0.132>, <-2.2950, 6.3775, 38.8327>, <0.436, -0.893, -0.116>, <-2.3195, 6.3728, 38.8280>, <-0.291, -0.911, -0.292> }
	smooth_triangle { <-2.8599, 5.9307, 41.1676>, <-0.725, -0.629, -0.282>, <-2.3195, 6.3728, 38.8280>, <-0.537, -0.781, -0.319>, <-2.3370, 6.3907, 38.8327>, <-0.951, -0.152, -0.271> }
	smooth_triangle { <-2.8599, 5.9307, 41.1676>, <-0.930, 0.343, -0.136>, <-2.3370, 6.3907, 38.8327>, <-0.973, 0.113, -0.200>, <-2.3299, 6.4132, 38.8421>, <-0.512, 0.855, 0.085> }

	texture { PSWL_BARK }
}

/* Object 'PWL0007F' */
union {
	smooth_triangle { <-0.5792, 6.7965, 34.8586>, <-0.757, -0.040, -0.652>, <-0.1934, 7.2262, 34.3898>, <-0.751, -0.045, -0.659>, <-0.1717, 7.9356, 34.3166>, <-0.757, -0.040, -0.652> }
	smooth_triangle { <-0.1717, 7.9356, 34.3166>, <-0.757, -0.040, -0.652>, <-0.5602, 7.4876, 34.7992>, <-0.763, -0.035, -0.646>, <-0.5792, 6.7965, 34.8586>, <-0.757, -0.040, -0.652> }
	smooth_triangle { <-1.4814, 7.3221, 35.4952>, <0.183, -0.627, 0.757>, <-1.6740, 6.9013, 35.2017>, <0.164, -0.614, 0.772>, <-2.1891, 6.6944, 35.1465>, <0.183, -0.627, 0.757> }
	smooth_triangle { <-2.1891, 6.6944, 35.1465>, <0.183, -0.627, 0.757>, <-1.9807, 7.1199, 35.4569>, <0.203, -0.640, 0.741>, <-1.4814, 7.3221, 35.4952>, <0.183, -0.627, 0.757> }
	smooth_triangle { <-2.2704, 8.1073, 36.0044>, <-0.654, -0.379, -0.654>, <-1.9677, 8.3590, 35.5584>, <-0.650, -0.382, -0.657>, <-2.0236, 8.9301, 35.2814>, <-0.654, -0.379, -0.654> }
	smooth_triangle { <-2.0236, 8.9301, 35.2814>, <-0.654, -0.379, -0.654>, <-2.3284, 8.6657, 35.7414>, <-0.658, -0.376, -0.652>, <-2.2704, 8.1073, 36.0044>, <-0.654, -0.379, -0.654> }
	smooth_triangle { <-3.1590, 8.7495, 36.5451>, <0.127, -0.619, 0.775>, <-3.3550, 8.3592, 36.2725>, <0.111, -0.606, 0.788>, <-3.8368, 8.1959, 36.2147>, <0.127, -0.619, 0.775> }
	smooth_triangle { <-3.8368, 8.1959, 36.2147>, <0.127, -0.619, 0.775>, <-3.6274, 8.5908, 36.5021>, <0.144, -0.631, 0.762>, <-3.1590, 8.7495, 36.5451>, <0.127, -0.619, 0.775> }
	smooth_triangle { <-3.6251, 9.2900, 36.9508>, <-0.585, -0.060, -0.809>, <-3.1279, 9.6702, 36.5394>, <-0.626, -0.024, -0.779>, <-3.0257, 10.4218, 36.4342>, <-0.585, -0.060, -0.809> }
	smooth_triangle { <-3.0257, 10.4218, 36.4342>, <-0.585, -0.060, -0.809>, <-3.5476, 10.0401, 36.8152>, <-0.541, -0.095, -0.836>, <-3.6251, 9.2900, 36.9508>, <-0.585, -0.060, -0.809> }
	smooth_triangle { <-4.2140, 9.6998, 37.3419>, <-0.317, -0.748, 0.583>, <-4.4583, 9.3589, 36.8144>, <-0.367, -0.694, 0.619>, <-5.1605, 9.4055, 36.4503>, <-0.317, -0.748, 0.583> }
	smooth_triangle { <-5.1605, 9.4055, 36.4503>, <-0.317, -0.748, 0.583>, <-4.8737, 9.7249, 37.0573>, <-0.265, -0.796, 0.544>, <-4.2140, 9.6998, 37.3419>, <-0.317, -0.748, 0.583> }
	smooth_triangle { <-4.5527, 10.4084, 37.6267>, <-0.908, -0.160, -0.387>, <-4.3797, 10.6378, 37.1131>, <-0.916, -0.147, -0.374>, <-4.3867, 11.2370, 36.8947>, <-0.908, -0.160, -0.387> }
	smooth_triangle { <-4.3867, 11.2370, 36.8947>, <-0.908, -0.160, -0.387>, <-4.5680, 11.0011, 37.4048>, <-0.900, -0.173, -0.400>, <-4.5527, 10.4084, 37.6267>, <-0.908, -0.160, -0.387> }
	smooth_triangle { <-4.9805, 10.9862, 37.9457>, <0.274, -0.242, 0.931>, <-5.2269, 10.3660, 37.8572>, <0.274, -0.242, 0.931>, <-5.7233, 10.1434, 37.9456>, <0.274, -0.242, 0.931> }
	smooth_triangle { <-5.7233, 10.1434, 37.9456>, <0.274, -0.242, 0.931>, <-5.4664, 10.7755, 38.0341>, <0.274, -0.242, 0.931>, <-4.9805, 10.9862, 37.9457>, <0.274, -0.242, 0.931> }
	smooth_triangle { <-1.6277, 7.9391, 35.5154>, <-0.773, -0.315, -0.551>, <-1.2285, 7.8270, 35.0183>, <-0.774, -0.314, -0.551>, <-1.0155, 8.2485, 34.4788>, <-0.773, -0.315, -0.551> }
	smooth_triangle { <-1.0155, 8.2485, 34.4788>, <-0.773, -0.315, -0.551>, <-1.4234, 8.3563, 34.9892>, <-0.773, -0.316, -0.551>, <-1.6277, 7.9391, 35.5154>, <-0.773, -0.315, -0.551> }
	smooth_triangle { <-1.8969, 8.4874, 35.5652>, <-0.708, -0.307, 0.635>, <-2.0945, 8.2323, 35.2260>, <-0.714, -0.293, 0.636>, <-2.4353, 8.3435, 34.8951>, <-0.708, -0.307, 0.635> }
	smooth_triangle { <-2.4353, 8.3435, 34.8951>, <-0.708, -0.307, 0.635>, <-2.2299, 8.6000, 35.2529>, <-0.703, -0.321, 0.634>, <-1.8969, 8.4874, 35.5652>, <-0.708, -0.307, 0.635> }
	smooth_triangle { <-1.9190, 9.7043, 35.4424>, <-0.685, -0.235, -0.689>, <-1.5564, 9.4787, 35.1597>, <-0.685, -0.238, -0.689>, <-1.2172, 9.6860, 34.7508>, <-0.685, -0.235, -0.689> }
	smooth_triangle { <-1.2172, 9.6860, 34.7508>, <-0.685, -0.235, -0.689>, <-1.5898, 9.9120, 35.0451>, <-0.686, -0.232, -0.690>, <-1.9190, 9.7043, 35.4424>, <-0.685, -0.235, -0.689> }
	smooth_triangle { <-2.0980, 10.9082, 35.3307>, <-0.440, 0.157, 0.884>, <-2.6518, 10.5473, 35.1167>, <-0.440, 0.150, 0.885>, <-3.2664, 10.7602, 34.7751>, <-0.440, 0.157, 0.884> }
	smooth_triangle { <-3.2664, 10.7602, 34.7751>, <-0.440, 0.157, 0.884>, <-2.6961, 11.1227, 34.9923>, <-0.440, 0.164, 0.883>, <-2.0980, 10.9082, 35.3307>, <-0.440, 0.157, 0.884> }
	smooth_triangle { <-1.9330, 11.9249, 35.3436>, <-0.357, -0.031, -0.933>, <-1.4381, 11.6422, 35.1871>, <-0.360, -0.117, -0.926>, <-0.8952, 11.8595, 34.9487>, <-0.357, -0.031, -0.933> }
	smooth_triangle { <-0.8952, 11.8595, 34.9487>, <-0.357, -0.031, -0.933>, <-1.4048, 12.1427, 35.1573>, <-0.352, 0.055, -0.934>, <-1.9330, 11.9249, 35.3436>, <-0.357, -0.031, -0.933> }
	smooth_triangle { <-1.9684, 12.9453, 35.3672>, <-0.085, 0.006, 0.996>, <-2.6274, 12.6949, 35.3063>, <-0.086, -0.016, 0.996>, <-3.2657, 13.0325, 35.2565>, <-0.085, 0.006, 0.996> }
	smooth_triangle { <-3.2657, 13.0325, 35.2565>, <-0.085, 0.006, 0.996>, <-2.5884, 13.2818, 35.3060>, <-0.083, 0.028, 0.996>, <-1.9684, 12.9453, 35.3672>, <-0.085, 0.006, 0.996> }
	smooth_triangle { <-2.3630, 13.8358, 35.3536>, <-0.796, -0.206, -0.569>, <-1.9220, 13.5977, 34.8141>, <-0.799, -0.183, -0.573>, <-1.7087, 13.8004, 34.4517>, <-0.796, -0.206, -0.569> }
	smooth_triangle { <-1.7087, 13.8004, 34.4517>, <-0.796, -0.206, -0.569>, <-2.1589, 14.0392, 34.9851>, <-0.792, -0.230, -0.566>, <-2.3630, 13.8358, 35.3536>, <-0.796, -0.206, -0.569> }
	smooth_triangle { <-2.9231, 14.7366, 35.4031>, <-0.353, -0.221, 0.909>, <-3.3515, 14.5357, 35.1825>, <-0.353, -0.240, 0.904>, <-4.0523, 14.8154, 34.9832>, <-0.353, -0.221, 0.909> }
	smooth_triangle { <-4.0523, 14.8154, 34.9832>, <-0.353, -0.221, 0.909>, <-3.6080, 15.0154, 35.1994>, <-0.354, -0.202, 0.913>, <-2.9231, 14.7366, 35.4031>, <-0.353, -0.221, 0.909> }
	smooth_triangle { <-2.0086, 7.2750, 35.7353>, <-0.206, -0.640, -0.740>, <-2.0204, 7.7718, 35.2809>, <-0.274, -0.653, -0.707>, <-2.5044, 8.1785, 35.0925>, <-0.206, -0.640, -0.740> }
	smooth_triangle { <-2.5044, 8.1785, 35.0925>, <-0.206, -0.640, -0.740>, <-2.5062, 7.6644, 35.5091>, <-0.138, -0.623, -0.770>, <-2.0086, 7.2750, 35.7353>, <-0.206, -0.640, -0.740> }
	smooth_triangle { <-2.5298, 7.0672, 35.9903>, <0.413, -0.396, 0.820>, <-2.3031, 6.6349, 35.6777>, <0.382, -0.402, 0.832>, <-2.5307, 6.0884, 35.5181>, <0.413, -0.396, 0.820> }
	smooth_triangle { <-2.5307, 6.0884, 35.5181>, <0.413, -0.396, 0.820>, <-2.7496, 6.5362, 35.8551>, <0.445, -0.389, 0.806>, <-2.5298, 7.0672, 35.9903>, <0.413, -0.396, 0.820> }
	smooth_triangle { <-3.4891, 6.9190, 36.7417>, <-0.274, -0.705, -0.654>, <-3.6206, 7.3419, 36.2939>, <-0.366, -0.728, -0.580>, <-4.1301, 7.6836, 36.1870>, <-0.274, -0.705, -0.654> }
	smooth_triangle { <-4.1301, 7.6836, 36.1870>, <-0.274, -0.705, -0.654>, <-4.0374, 7.2379, 36.5801>, <-0.179, -0.671, -0.719>, <-3.4891, 6.9190, 36.7417>, <-0.274, -0.705, -0.654> }
	smooth_triangle { <-4.4055, 6.6126, 37.4892>, <0.581, -0.659, 0.478>, <-4.3520, 6.2032, 36.9444>, <0.475, -0.681, 0.558>, <-4.8271, 5.6497, 36.6734>, <0.581, -0.659, 0.478> }
	smooth_triangle { <-4.8271, 5.6497, 36.6734>, <0.581, -0.659, 0.478>, <-4.7963, 6.0923, 37.3323>, <0.677, -0.625, 0.388>, <-4.4055, 6.6126, 37.4892>, <0.581, -0.659, 0.478> }
	smooth_triangle { <-5.3739, 6.5292, 37.7439>, <-0.070, -0.493, -0.867>, <-5.2539, 7.0915, 37.4556>, <0.052, -0.464, -0.884>, <-5.6974, 7.5723, 37.1771>, <-0.070, -0.493, -0.867> }
	smooth_triangle { <-5.6974, 7.5723, 37.1771>, <-0.070, -0.493, -0.867>, <-5.7936, 6.9986, 37.5515>, <-0.191, -0.514, -0.836>, <-5.3739, 6.5292, 37.7439>, <-0.070, -0.493, -0.867> }
	smooth_triangle { <-6.3360, 6.2835, 37.9737>, <0.395, -0.737, 0.548>, <-6.1115, 5.9127, 37.3408>, <0.349, -0.749, 0.563>, <-6.4579, 5.4320, 36.9160>, <0.395, -0.737, 0.548> }
	smooth_triangle { <-6.4579, 5.4320, 36.9160>, <0.395, -0.737, 0.548>, <-6.6684, 5.8169, 37.6140>, <0.440, -0.723, 0.532>, <-6.3360, 6.2835, 37.9737>, <0.395, -0.737, 0.548> }
	smooth_triangle { <-7.0005, 5.8253, 38.5513>, <-0.130, -0.531, -0.837>, <-6.9729, 6.4424, 38.1744>, <-0.062, -0.518, -0.853>, <-7.3105, 6.7927, 37.9860>, <-0.130, -0.531, -0.837> }
	smooth_triangle { <-7.3105, 6.7927, 37.9860>, <-0.130, -0.531, -0.837>, <-7.3250, 6.1635, 38.4061>, <-0.198, -0.541, -0.817>, <-7.0005, 5.8253, 38.5513>, <-0.130, -0.531, -0.837> }
	smooth_triangle { <-7.6352, 5.1932, 39.1279>, <0.696, -0.078, 0.714>, <-7.4048, 4.7686, 38.8313>, <0.744, -0.061, 0.666>, <-7.5027, 4.0498, 38.8744>, <0.696, -0.078, 0.714> }
	smooth_triangle { <-7.5027, 4.0498, 38.8744>, <0.696, -0.078, 0.714>, <-7.7449, 4.4888, 39.1345>, <0.645, -0.093, 0.758>, <-7.6352, 5.1932, 39.1279>, <0.696, -0.078, 0.714> }
	smooth_triangle { <-1.7760, 7.3440, 36.0275>, <-0.595, -0.677, -0.434>, <-2.0720, 7.8480, 35.5585>, <-0.655, -0.684, -0.322>, <-2.6152, 8.3262, 35.6469>, <-0.595, -0.677, -0.434> }
	smooth_triangle { <-2.6152, 8.3262, 35.6469>, <-0.595, -0.677, -0.434>, <-2.3880, 7.7948, 36.0745>, <-0.526, -0.658, -0.539>, <-1.7760, 7.3440, 36.0275>, <-0.595, -0.677, -0.434> }
	smooth_triangle { <-2.0415, 7.2018, 36.5665>, <0.860, -0.049, 0.509>, <-1.8893, 6.6167, 36.2737>, <0.839, -0.052, 0.541>, <-2.0425, 5.9628, 36.4483>, <0.860, -0.049, 0.509> }
	smooth_triangle { <-2.0425, 5.9628, 36.4483>, <0.860, -0.049, 0.509>, <-2.1761, 6.5685, 36.7536>, <0.878, -0.046, 0.476>, <-2.0415, 7.2018, 36.5665>, <0.860, -0.049, 0.509> }
	smooth_triangle { <-2.2248, 6.8054, 37.6913>, <0.433, -0.850, -0.301>, <-2.7870, 6.6534, 37.2420>, <0.425, -0.874, -0.235>, <-3.4235, 6.3123, 37.3609>, <0.433, -0.850, -0.301> }
	smooth_triangle { <-3.4235, 6.3123, 37.3609>, <0.433, -0.850, -0.301>, <-2.8605, 6.4203, 37.7936>, <0.439, -0.821, -0.366>, <-2.2248, 6.8054, 37.6913>, <0.433, -0.850, -0.301> }
	smooth_triangle { <-2.2668, 6.3681, 38.8325>, <0.499, 0.765, 0.407>, <-1.7475, 6.1750, 38.5404>, <0.503, 0.776, 0.382>, <-1.2761, 5.7775, 38.7269>, <0.499, 0.765, 0.407> }
	smooth_triangle { <-1.2761, 5.7775, 38.7269>, <0.499, 0.765, 0.407>, <-1.8134, 5.9659, 39.0150>, <0.495, 0.754, 0.431>, <-2.2668, 6.3681, 38.8325>, <0.499, 0.765, 0.407> }
	smooth_triangle { <-2.6342, 6.1438, 39.9895>, <0.389, -0.918, -0.081>, <-3.0382, 6.0266, 39.6480>, <0.405, -0.898, -0.172>, <-3.5762, 5.7673, 39.7340>, <0.389, -0.918, -0.081> }
	smooth_triangle { <-3.5762, 5.7673, 39.7340>, <0.389, -0.918, -0.081>, <-3.1419, 5.9436, 40.1015>, <0.369, -0.929, 0.010>, <-2.6342, 6.1438, 39.9895>, <0.389, -0.918, -0.081> }
	smooth_triangle { <-2.8298, 5.8885, 41.1552>, <0.824, 0.524, 0.214>, <-2.5500, 5.5197, 40.8341>, <0.821, 0.566, 0.065>, <-2.3199, 5.1732, 40.9449>, <0.824, 0.524, 0.214> }
	smooth_triangle { <-2.3199, 5.1732, 40.9449>, <0.824, 0.524, 0.214>, <-2.6294, 5.4804, 41.2391>, <0.807, 0.470, 0.358>, <-2.8298, 5.8885, 41.1552>, <0.824, 0.524, 0.214> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0008B' */
union {
	smooth_triangle { <0.6050, 5.9662, 28.5330>, <0.676, -0.354, 0.646>, <1.0489, 4.8377, 27.4503>, <0.667, -0.331, 0.668>, <1.0315, 4.8218, 27.4598>, <0.403, -0.513, 0.758> }
	smooth_triangle { <0.6050, 5.9662, 28.5330>, <0.676, -0.354, 0.646>, <1.0315, 4.8218, 27.4598>, <0.403, -0.513, 0.758>, <0.5877, 5.9502, 28.5425>, <0.064, -0.678, 0.732> }
	smooth_triangle { <0.5877, 5.9502, 28.5425>, <0.064, -0.678, 0.732>, <1.0315, 4.8218, 27.4598>, <0.403, -0.513, 0.758>, <1.0079, 4.8216, 27.4503>, <-0.553, -0.661, 0.506> }
	smooth_triangle { <0.5877, 5.9502, 28.5425>, <0.064, -0.678, 0.732>, <1.0079, 4.8216, 27.4503>, <-0.553, -0.661, 0.506>, <0.5641, 5.9501, 28.5330>, <-0.800, -0.549, 0.244> }
	smooth_triangle { <0.5641, 5.9501, 28.5330>, <-0.800, -0.549, 0.244>, <1.0079, 4.8216, 27.4503>, <-0.553, -0.661, 0.506>, <1.0017, 4.8374, 27.4313>, <-0.956, -0.149, -0.252> }
	smooth_triangle { <0.5641, 5.9501, 28.5330>, <-0.800, -0.549, 0.244>, <1.0017, 4.8374, 27.4313>, <-0.956, -0.149, -0.252>, <0.5579, 5.9658, 28.5140>, <-0.863, 0.129, -0.488> }
	smooth_triangle { <0.5579, 5.9658, 28.5140>, <-0.863, 0.129, -0.488>, <1.0017, 4.8374, 27.4313>, <-0.956, -0.149, -0.252>, <1.0191, 4.8533, 27.4219>, <-0.403, 0.513, -0.758> }
	smooth_triangle { <0.5579, 5.9658, 28.5140>, <-0.863, 0.129, -0.488>, <1.0191, 4.8533, 27.4219>, <-0.403, 0.513, -0.758>, <0.5753, 5.9817, 28.5046>, <-0.064, 0.678, -0.732> }
	smooth_triangle { <0.5753, 5.9817, 28.5046>, <-0.064, 0.678, -0.732>, <1.0191, 4.8533, 27.4219>, <-0.403, 0.513, -0.758>, <1.0427, 4.8535, 27.4313>, <0.553, 0.661, -0.506> }
	smooth_triangle { <0.5753, 5.9817, 28.5046>, <-0.064, 0.678, -0.732>, <1.0427, 4.8535, 27.4313>, <0.553, 0.661, -0.506>, <0.5988, 5.9819, 28.5140>, <0.800, 0.549, -0.244> }
	smooth_triangle { <0.5988, 5.9819, 28.5140>, <0.800, 0.549, -0.244>, <1.0427, 4.8535, 27.4313>, <0.553, 0.661, -0.506>, <1.0489, 4.8377, 27.4503>, <0.932, 0.362, -0.001> }
	smooth_triangle { <0.5988, 5.9819, 28.5140>, <0.800, 0.549, -0.244>, <1.0489, 4.8377, 27.4503>, <0.932, 0.362, -0.001>, <0.6050, 5.9662, 28.5330>, <0.931, 0.366, 0.000> }
	smooth_triangle { <-0.1056, 7.8588, 29.8989>, <0.670, -0.363, 0.648>, <1.0489, 4.8377, 27.4503>, <0.667, -0.331, 0.668>, <1.0315, 4.8218, 27.4598>, <0.403, -0.513, 0.758> }
	smooth_triangle { <-0.1056, 7.8588, 29.8989>, <0.670, -0.363, 0.648>, <1.0315, 4.8218, 27.4598>, <0.403, -0.513, 0.758>, <-0.1237, 7.8444, 29.9094>, <0.198, -0.631, 0.750> }
	smooth_triangle { <-0.1237, 7.8444, 29.9094>, <0.198, -0.631, 0.750>, <1.0315, 4.8218, 27.4598>, <0.403, -0.513, 0.758>, <1.0079, 4.8216, 27.4503>, <-0.553, -0.661, 0.506> }
	smooth_triangle { <-0.1237, 7.8444, 29.9094>, <0.198, -0.631, 0.750>, <1.0079, 4.8216, 27.4503>, <-0.553, -0.661, 0.506>, <-0.1468, 7.8433, 29.8989>, <-0.735, -0.543, 0.406> }
	smooth_triangle { <-0.1468, 7.8433, 29.8989>, <-0.735, -0.543, 0.406>, <1.0079, 4.8216, 27.4503>, <-0.553, -0.661, 0.506>, <1.0017, 4.8374, 27.4313>, <-0.956, -0.149, -0.252> }
	smooth_triangle { <-0.1468, 7.8433, 29.8989>, <-0.735, -0.543, 0.406>, <1.0017, 4.8374, 27.4313>, <-0.956, -0.149, -0.252>, <-0.1517, 7.8567, 29.8778>, <-0.934, 0.089, -0.347> }
	smooth_triangle { <-0.1517, 7.8567, 29.8778>, <-0.934, 0.089, -0.347>, <1.0017, 4.8374, 27.4313>, <-0.956, -0.149, -0.252>, <1.0191, 4.8533, 27.4219>, <-0.403, 0.513, -0.758> }
	smooth_triangle { <-0.1517, 7.8567, 29.8778>, <-0.934, 0.089, -0.347>, <1.0191, 4.8533, 27.4219>, <-0.403, 0.513, -0.758>, <-0.1337, 7.8710, 29.8673>, <-0.198, 0.630, -0.751> }
	smooth_triangle { <-0.1337, 7.8710, 29.8673>, <-0.198, 0.630, -0.751>, <1.0191, 4.8533, 27.4219>, <-0.403, 0.513, -0.758>, <1.0427, 4.8535, 27.4313>, <0.553, 0.661, -0.506> }
	smooth_triangle { <-0.1337, 7.8710, 29.8673>, <-0.198, 0.630, -0.751>, <1.0427, 4.8535, 27.4313>, <0.553, 0.661, -0.506>, <-0.1106, 7.8721, 29.8778>, <0.735, 0.543, -0.406> }
	smooth_triangle { <-0.1106, 7.8721, 29.8778>, <0.735, 0.543, -0.406>, <1.0427, 4.8535, 27.4313>, <0.553, 0.661, -0.506>, <1.0489, 4.8377, 27.4503>, <0.932, 0.362, -0.001> }
	smooth_triangle { <-0.1106, 7.8721, 29.8778>, <0.735, 0.543, -0.406>, <1.0489, 4.8377, 27.4503>, <0.932, 0.362, -0.001>, <-0.1056, 7.8588, 29.8989>, <0.978, 0.206, -0.038> }
	smooth_triangle { <-0.2421, 9.6335, 31.5557>, <0.596, -0.674, 0.436>, <-0.1056, 7.8588, 29.8989>, <0.670, -0.363, 0.648>, <-0.1237, 7.8444, 29.9094>, <0.198, -0.631, 0.750> }
	smooth_triangle { <-0.2421, 9.6335, 31.5557>, <0.596, -0.674, 0.436>, <-0.1237, 7.8444, 29.9094>, <0.198, -0.631, 0.750>, <-0.2634, 9.6232, 31.5650>, <-0.104, -0.840, 0.533> }
	smooth_triangle { <-0.2634, 9.6232, 31.5650>, <-0.104, -0.840, 0.533>, <-0.1237, 7.8444, 29.9094>, <0.198, -0.631, 0.750>, <-0.1468, 7.8433, 29.8989>, <-0.735, -0.543, 0.406> }
	smooth_triangle { <-0.2634, 9.6232, 31.5650>, <-0.104, -0.840, 0.533>, <-0.1468, 7.8433, 29.8989>, <-0.735, -0.543, 0.406>, <-0.2860, 9.6302, 31.5557>, <-0.895, -0.274, 0.353> }
	smooth_triangle { <-0.2860, 9.6302, 31.5557>, <-0.895, -0.274, 0.353>, <-0.1468, 7.8433, 29.8989>, <-0.735, -0.543, 0.406>, <-0.1517, 7.8567, 29.8778>, <-0.934, 0.089, -0.347> }
	smooth_triangle { <-0.2860, 9.6302, 31.5557>, <-0.895, -0.274, 0.353>, <-0.1517, 7.8567, 29.8778>, <-0.934, 0.089, -0.347>, <-0.2873, 9.6474, 31.5371>, <-0.802, 0.570, -0.181> }
	smooth_triangle { <-0.2873, 9.6474, 31.5371>, <-0.802, 0.570, -0.181>, <-0.1517, 7.8567, 29.8778>, <-0.934, 0.089, -0.347>, <-0.1337, 7.8710, 29.8673>, <-0.198, 0.630, -0.751> }
	smooth_triangle { <-0.2873, 9.6474, 31.5371>, <-0.802, 0.570, -0.181>, <-0.1337, 7.8710, 29.8673>, <-0.198, 0.630, -0.751>, <-0.2660, 9.6577, 31.5278>, <0.104, 0.839, -0.535> }
	smooth_triangle { <-0.2660, 9.6577, 31.5278>, <0.104, 0.839, -0.535>, <-0.1337, 7.8710, 29.8673>, <-0.198, 0.630, -0.751>, <-0.1106, 7.8721, 29.8778>, <0.735, 0.543, -0.406> }
	smooth_triangle { <-0.2660, 9.6577, 31.5278>, <0.104, 0.839, -0.535>, <-0.1106, 7.8721, 29.8778>, <0.735, 0.543, -0.406>, <-0.2434, 9.6507, 31.5371>, <0.895, 0.273, -0.354> }
	smooth_triangle { <-0.2434, 9.6507, 31.5371>, <0.895, 0.273, -0.354>, <-0.1106, 7.8721, 29.8778>, <0.735, 0.543, -0.406>, <-0.1056, 7.8588, 29.8989>, <0.978, 0.206, -0.038> }
	smooth_triangle { <-0.2434, 9.6507, 31.5371>, <0.895, 0.273, -0.354>, <-0.1056, 7.8588, 29.8989>, <0.978, 0.206, -0.038>, <-0.2421, 9.6335, 31.5557>, <0.913, -0.389, -0.119> }
	smooth_triangle { <0.3518, 10.0048, 33.0060>, <0.079, -0.951, 0.298>, <-0.2421, 9.6335, 31.5557>, <0.596, -0.674, 0.436>, <-0.2634, 9.6232, 31.5650>, <-0.104, -0.840, 0.533> }
	smooth_triangle { <0.3518, 10.0048, 33.0060>, <0.079, -0.951, 0.298>, <-0.2634, 9.6232, 31.5650>, <-0.104, -0.840, 0.533>, <0.3304, 10.0173, 33.0117>, <-0.725, -0.598, 0.341> }
	smooth_triangle { <0.3304, 10.0173, 33.0117>, <-0.725, -0.598, 0.341>, <-0.2634, 9.6232, 31.5650>, <-0.104, -0.840, 0.533>, <-0.2860, 9.6302, 31.5557>, <-0.855, -0.385, 0.348> }
	smooth_triangle { <0.3304, 10.0173, 33.0117>, <-0.725, -0.598, 0.341>, <-0.2860, 9.6302, 31.5557>, <-0.895, -0.274, 0.353>, <0.3282, 10.0420, 33.0060>, <-0.910, 0.402, 0.097> }
	smooth_triangle { <0.3282, 10.0420, 33.0060>, <-0.910, 0.402, 0.097>, <-0.2860, 9.6302, 31.5557>, <-0.938, -0.134, 0.319>, <-0.2873, 9.6474, 31.5371>, <-0.802, 0.570, -0.181> }
	smooth_triangle { <0.3282, 10.0420, 33.0060>, <-0.910, 0.402, 0.097>, <-0.2873, 9.6474, 31.5371>, <-0.802, 0.570, -0.181>, <0.3474, 10.0541, 32.9946>, <-0.183, 0.956, -0.228> }
	smooth_triangle { <0.3474, 10.0541, 32.9946>, <-0.183, 0.956, -0.228>, <-0.2873, 9.6474, 31.5371>, <-0.802, 0.570, -0.181>, <-0.2660, 9.6577, 31.5278>, <0.104, 0.839, -0.535> }
	smooth_triangle { <0.3474, 10.0541, 32.9946>, <-0.183, 0.956, -0.228>, <-0.2660, 9.6577, 31.5278>, <0.104, 0.839, -0.535>, <0.3688, 10.0416, 32.9890>, <0.728, 0.601, -0.330> }
	smooth_triangle { <0.3688, 10.0416, 32.9890>, <0.728, 0.601, -0.330>, <-0.2660, 9.6577, 31.5278>, <0.104, 0.839, -0.535>, <-0.2434, 9.6507, 31.5371>, <0.855, 0.385, -0.348> }
	smooth_triangle { <0.3688, 10.0416, 32.9890>, <0.728, 0.601, -0.330>, <-0.2434, 9.6507, 31.5371>, <0.895, 0.273, -0.354>, <0.3709, 10.0170, 32.9946>, <0.912, -0.400, -0.089> }
	smooth_triangle { <0.3709, 10.0170, 32.9946>, <0.912, -0.400, -0.089>, <-0.2434, 9.6507, 31.5371>, <0.938, 0.133, -0.320>, <-0.2421, 9.6335, 31.5557>, <0.913, -0.389, -0.119> }
	smooth_triangle { <0.3709, 10.0170, 32.9946>, <0.912, -0.400, -0.089>, <-0.2421, 9.6335, 31.5557>, <0.913, -0.389, -0.119>, <0.3518, 10.0048, 33.0060>, <0.534, -0.845, -0.002> }
	smooth_triangle { <0.2882, 10.5793, 34.5289>, <-0.406, -0.858, 0.314>, <0.3518, 10.0048, 33.0060>, <0.079, -0.951, 0.298>, <0.3304, 10.0173, 33.0117>, <-0.725, -0.598, 0.341> }
	smooth_triangle { <0.2882, 10.5793, 34.5289>, <-0.995, -0.103, 0.017>, <0.3304, 10.0173, 33.0117>, <-0.725, -0.598, 0.341>, <0.3282, 10.0420, 33.0060>, <-0.910, 0.402, 0.097> }
	smooth_triangle { <0.2882, 10.5793, 34.5289>, <-0.597, 0.754, -0.274>, <0.3282, 10.0420, 33.0060>, <-0.910, 0.402, 0.097>, <0.3474, 10.0541, 32.9946>, <-0.183, 0.956, -0.228> }
	smooth_triangle { <0.2882, 10.5793, 34.5289>, <0.413, 0.868, -0.275>, <0.3474, 10.0541, 32.9946>, <-0.183, 0.956, -0.228>, <0.3688, 10.0416, 32.9890>, <0.728, 0.601, -0.330> }
	smooth_triangle { <0.2882, 10.5793, 34.5289>, <0.993, 0.113, 0.019>, <0.3688, 10.0416, 32.9890>, <0.728, 0.601, -0.330>, <0.3709, 10.0170, 32.9946>, <0.912, -0.400, -0.089> }
	smooth_triangle { <0.2882, 10.5793, 34.5289>, <0.601, -0.737, 0.310>, <0.3709, 10.0170, 32.9946>, <0.912, -0.400, -0.089>, <0.3518, 10.0048, 33.0060>, <0.079, -0.951, 0.298> }
	smooth_triangle { <-0.9418, 8.7646, 29.8302>, <0.332, 0.377, 0.865>, <-0.1131, 7.8733, 29.9010>, <0.468, 0.215, 0.857>, <-0.1297, 7.8588, 29.9137>, <0.200, 0.018, 0.980> }
	smooth_triangle { <-0.9418, 8.7646, 29.8302>, <0.332, 0.377, 0.865>, <-0.1297, 7.8588, 29.9137>, <0.200, 0.018, 0.980>, <-0.9584, 8.7502, 29.8428>, <-0.177, -0.087, 0.980> }
	smooth_triangle { <-0.9584, 8.7502, 29.8428>, <-0.177, -0.087, 0.980>, <-0.1297, 7.8588, 29.9137>, <0.200, 0.018, 0.980>, <-0.1453, 7.8433, 29.9010>, <-0.597, -0.480, 0.643> }
	smooth_triangle { <-0.9584, 8.7502, 29.8428>, <-0.177, -0.087, 0.980>, <-0.1453, 7.8433, 29.9010>, <-0.597, -0.480, 0.643>, <-0.9740, 8.7347, 29.8302>, <-0.705, -0.629, 0.327> }
	smooth_triangle { <-0.9740, 8.7347, 29.8302>, <-0.705, -0.629, 0.327>, <-0.1453, 7.8433, 29.9010>, <-0.597, -0.480, 0.643>, <-0.1443, 7.8422, 29.8757>, <-0.799, -0.500, -0.335> }
	smooth_triangle { <-0.9740, 8.7347, 29.8302>, <-0.705, -0.629, 0.327>, <-0.1443, 7.8422, 29.8757>, <-0.799, -0.500, -0.335>, <-0.9730, 8.7336, 29.8048>, <-0.528, -0.543, -0.654> }
	smooth_triangle { <-0.9730, 8.7336, 29.8048>, <-0.528, -0.543, -0.654>, <-0.1443, 7.8422, 29.8757>, <-0.799, -0.500, -0.335>, <-0.1277, 7.8567, 29.8630>, <-0.199, -0.019, -0.980> }
	smooth_triangle { <-0.9730, 8.7336, 29.8048>, <-0.528, -0.543, -0.654>, <-0.1277, 7.8567, 29.8630>, <-0.199, -0.019, -0.980>, <-0.9564, 8.7480, 29.7921>, <0.177, 0.087, -0.980> }
	smooth_triangle { <-0.9564, 8.7480, 29.7921>, <0.177, 0.087, -0.980>, <-0.1277, 7.8567, 29.8630>, <-0.199, -0.019, -0.980>, <-0.1120, 7.8722, 29.8757>, <0.597, 0.479, -0.643> }
	smooth_triangle { <-0.9564, 8.7480, 29.7921>, <0.177, 0.087, -0.980>, <-0.1120, 7.8722, 29.8757>, <0.597, 0.479, -0.643>, <-0.9408, 8.7636, 29.8048>, <0.705, 0.629, -0.327> }
	smooth_triangle { <-0.9408, 8.7636, 29.8048>, <0.705, 0.629, -0.327>, <-0.1120, 7.8722, 29.8757>, <0.597, 0.479, -0.643>, <-0.1131, 7.8733, 29.9010>, <0.830, 0.557, 0.020> }
	smooth_triangle { <-0.9408, 8.7636, 29.8048>, <0.705, 0.629, -0.327>, <-0.1131, 7.8733, 29.9010>, <0.830, 0.557, 0.020>, <-0.9418, 8.7646, 29.8302>, <0.732, 0.681, 0.000> }
	smooth_triangle { <-1.5532, 10.9124, 30.7723>, <0.611, -0.210, 0.764>, <-0.1131, 7.8733, 29.9010>, <0.468, 0.215, 0.857>, <-0.1297, 7.8588, 29.9137>, <0.200, 0.018, 0.980> }
	smooth_triangle { <-1.5532, 10.9124, 30.7723>, <0.611, -0.210, 0.764>, <-0.1297, 7.8588, 29.9137>, <0.200, 0.018, 0.980>, <-1.5730, 10.9016, 30.7840>, <0.120, -0.569, 0.814> }
	smooth_triangle { <-1.5730, 10.9016, 30.7840>, <0.120, -0.569, 0.814>, <-0.1297, 7.8588, 29.9137>, <0.200, 0.018, 0.980>, <-0.1453, 7.8433, 29.9010>, <-0.597, -0.480, 0.643> }
	smooth_triangle { <-1.5730, 10.9016, 30.7840>, <0.120, -0.569, 0.814>, <-0.1453, 7.8433, 29.9010>, <-0.597, -0.480, 0.643>, <-1.5955, 10.9003, 30.7723>, <-0.767, -0.519, 0.377> }
	smooth_triangle { <-1.5955, 10.9003, 30.7723>, <-0.767, -0.519, 0.377>, <-0.1453, 7.8433, 29.9010>, <-0.597, -0.480, 0.643>, <-0.1443, 7.8422, 29.8757>, <-0.799, -0.500, -0.335> }
	smooth_triangle { <-1.5955, 10.9003, 30.7723>, <-0.767, -0.519, 0.377>, <-0.1443, 7.8422, 29.8757>, <-0.799, -0.500, -0.335>, <-1.5982, 10.9097, 30.7489>, <-0.920, -0.106, -0.379> }
	smooth_triangle { <-1.5982, 10.9097, 30.7489>, <-0.908, 0.032, -0.417>, <-0.1443, 7.8422, 29.8757>, <-0.799, -0.500, -0.335>, <-0.1277, 7.8567, 29.8630>, <-0.199, -0.019, -0.980> }
	smooth_triangle { <-1.5982, 10.9097, 30.7489>, <-0.908, 0.032, -0.417>, <-0.1277, 7.8567, 29.8630>, <-0.199, -0.019, -0.980>, <-1.5784, 10.9205, 30.7372>, <-0.120, 0.567, -0.815> }
	smooth_triangle { <-1.5784, 10.9205, 30.7372>, <-0.120, 0.567, -0.815>, <-0.1277, 7.8567, 29.8630>, <-0.199, -0.019, -0.980>, <-0.1120, 7.8722, 29.8757>, <0.597, 0.479, -0.643> }
	smooth_triangle { <-1.5784, 10.9205, 30.7372>, <-0.120, 0.567, -0.815>, <-0.1120, 7.8722, 29.8757>, <0.597, 0.479, -0.643>, <-1.5559, 10.9218, 30.7489>, <0.767, 0.519, -0.377> }
	smooth_triangle { <-1.5559, 10.9218, 30.7489>, <0.767, 0.519, -0.377>, <-0.1120, 7.8722, 29.8757>, <0.597, 0.479, -0.643>, <-0.1131, 7.8733, 29.9010>, <0.830, 0.557, 0.020> }
	smooth_triangle { <-1.5559, 10.9218, 30.7489>, <0.767, 0.519, -0.377>, <-0.1131, 7.8733, 29.9010>, <0.830, 0.557, 0.020>, <-1.5532, 10.9124, 30.7723>, <0.990, 0.142, -0.010> }
	smooth_triangle { <-1.4857, 12.1642, 32.3578>, <0.517, -0.685, 0.513>, <-1.5532, 10.9124, 30.7723>, <0.611, -0.210, 0.764>, <-1.5730, 10.9016, 30.7840>, <0.120, -0.569, 0.814> }
	smooth_triangle { <-1.4857, 12.1642, 32.3578>, <0.517, -0.685, 0.513>, <-1.5730, 10.9016, 30.7840>, <0.120, -0.569, 0.814>, <-1.5082, 12.1555, 32.3658>, <0.037, -0.801, 0.598> }
	smooth_triangle { <-1.5082, 12.1555, 32.3658>, <0.037, -0.801, 0.598>, <-1.5730, 10.9016, 30.7840>, <0.120, -0.569, 0.814>, <-1.5955, 10.9003, 30.7723>, <-0.767, -0.519, 0.377> }
	smooth_triangle { <-1.5082, 12.1555, 32.3658>, <-0.094, -0.799, 0.594>, <-1.5955, 10.9003, 30.7723>, <-0.767, -0.519, 0.377>, <-1.5297, 12.1666, 32.3578>, <-0.860, -0.426, 0.280> }
	smooth_triangle { <-1.5297, 12.1666, 32.3578>, <-0.860, -0.426, 0.280>, <-1.5955, 10.9003, 30.7723>, <-0.767, -0.519, 0.377>, <-1.5982, 10.9097, 30.7489>, <-0.908, 0.032, -0.417> }
	smooth_triangle { <-1.5297, 12.1666, 32.3578>, <-0.922, -0.319, 0.218>, <-1.5982, 10.9097, 30.7489>, <-0.908, 0.032, -0.417>, <-1.5286, 12.1864, 32.3420>, <-0.874, 0.370, -0.315> }
	smooth_triangle { <-1.5286, 12.1864, 32.3420>, <-0.874, 0.370, -0.315>, <-1.5982, 10.9097, 30.7489>, <-0.866, 0.135, -0.481>, <-1.5784, 10.9205, 30.7372>, <-0.120, 0.567, -0.815> }
	smooth_triangle { <-1.5286, 12.1864, 32.3420>, <-0.801, 0.471, -0.369>, <-1.5784, 10.9205, 30.7372>, <-0.120, 0.567, -0.815>, <-1.5061, 12.1951, 32.3341>, <-0.037, 0.801, -0.598> }
	smooth_triangle { <-1.5061, 12.1951, 32.3341>, <-0.037, 0.801, -0.598>, <-1.5784, 10.9205, 30.7372>, <-0.120, 0.567, -0.815>, <-1.5559, 10.9218, 30.7489>, <0.767, 0.519, -0.377> }
	smooth_triangle { <-1.5061, 12.1951, 32.3341>, <0.095, 0.799, -0.594>, <-1.5559, 10.9218, 30.7489>, <0.767, 0.519, -0.377>, <-1.4846, 12.1840, 32.3420>, <0.860, 0.426, -0.279> }
	smooth_triangle { <-1.4846, 12.1840, 32.3420>, <0.860, 0.426, -0.279>, <-1.5559, 10.9218, 30.7489>, <0.767, 0.519, -0.377>, <-1.5532, 10.9124, 30.7723>, <0.990, 0.142, -0.010> }
	smooth_triangle { <-1.4846, 12.1840, 32.3420>, <0.922, 0.320, -0.217>, <-1.5532, 10.9124, 30.7723>, <0.990, 0.142, -0.010>, <-1.4857, 12.1642, 32.3578>, <0.999, 0.044, 0.032> }
	smooth_triangle { <-1.6692, 13.2852, 34.0445>, <0.563, -0.659, 0.499>, <-1.4857, 12.1642, 32.3578>, <0.517, -0.685, 0.513>, <-1.5082, 12.1555, 32.3658>, <0.037, -0.801, 0.598> }
	smooth_triangle { <-1.6692, 13.2852, 34.0445>, <0.741, -0.593, 0.315>, <-1.5082, 12.1555, 32.3658>, <0.338, -0.746, 0.574>, <-1.6892, 13.2712, 34.0516>, <0.139, -0.731, 0.668> }
	smooth_triangle { <-1.6892, 13.2712, 34.0516>, <-0.442, -0.672, 0.594>, <-1.5082, 12.1555, 32.3658>, <-0.094, -0.799, 0.594>, <-1.5297, 12.1666, 32.3578>, <-0.860, -0.426, 0.280> }
	smooth_triangle { <-1.6892, 13.2712, 34.0516>, <-0.015, -0.766, 0.643>, <-1.5297, 12.1666, 32.3578>, <-0.789, -0.517, 0.331>, <-1.7126, 13.2780, 34.0445>, <-0.870, -0.308, 0.385> }
	smooth_triangle { <-1.7126, 13.2780, 34.0445>, <-0.942, -0.247, 0.227>, <-1.5297, 12.1666, 32.3578>, <-0.860, -0.426, 0.280>, <-1.5286, 12.1864, 32.3420>, <-0.874, 0.370, -0.315> }
	smooth_triangle { <-1.7126, 13.2780, 34.0445>, <-0.870, -0.308, 0.385>, <-1.5286, 12.1864, 32.3420>, <-0.979, 0.134, -0.155>, <-1.7161, 13.2988, 34.0304>, <-0.919, 0.361, -0.161> }
	smooth_triangle { <-1.7161, 13.2988, 34.0304>, <-0.564, 0.663, -0.492>, <-1.5286, 12.1864, 32.3420>, <-0.801, 0.471, -0.369>, <-1.5061, 12.1951, 32.3341>, <-0.037, 0.801, -0.598> }
	smooth_triangle { <-1.7161, 13.2988, 34.0304>, <-0.850, 0.461, -0.254>, <-1.5061, 12.1951, 32.3341>, <-0.337, 0.745, -0.575>, <-1.6961, 13.3128, 34.0233>, <-0.139, 0.738, -0.660> }
	smooth_triangle { <-1.6961, 13.3128, 34.0233>, <0.441, 0.677, -0.589>, <-1.5061, 12.1951, 32.3341>, <0.095, 0.799, -0.594>, <-1.4846, 12.1840, 32.3420>, <0.860, 0.426, -0.279> }
	smooth_triangle { <-1.6961, 13.3128, 34.0233>, <0.015, 0.772, -0.635>, <-1.4846, 12.1840, 32.3420>, <0.789, 0.517, -0.331>, <-1.6727, 13.3060, 34.0304>, <0.871, 0.314, -0.379> }
	smooth_triangle { <-1.6727, 13.3060, 34.0304>, <0.942, 0.249, -0.223>, <-1.4846, 12.1840, 32.3420>, <0.860, 0.426, -0.279>, <-1.4857, 12.1642, 32.3578>, <0.999, 0.044, 0.032> }
	smooth_triangle { <-1.6727, 13.3060, 34.0304>, <0.871, 0.314, -0.379>, <-1.4857, 12.1642, 32.3578>, <0.999, 0.044, 0.032>, <-1.6692, 13.2852, 34.0445>, <0.987, 0.163, -0.001> }
	smooth_triangle { <-1.0011, 14.8207, 35.1837>, <0.613, -0.622, 0.488>, <-1.6692, 13.2852, 34.0445>, <0.741, -0.593, 0.315>, <-1.6892, 13.2712, 34.0516>, <0.139, -0.731, 0.668> }
	smooth_triangle { <-1.0011, 14.8207, 35.1837>, <-0.326, -0.455, 0.829>, <-1.6892, 13.2712, 34.0516>, <-0.015, -0.766, 0.643>, <-1.7126, 13.2780, 34.0445>, <-0.780, -0.374, 0.502> }
	smooth_triangle { <-1.0011, 14.8207, 35.1837>, <-0.917, 0.159, 0.367>, <-1.7126, 13.2780, 34.0445>, <-0.870, -0.308, 0.385>, <-1.7161, 13.2988, 34.0304>, <-0.919, 0.361, -0.161> }
	smooth_triangle { <-1.0011, 14.8207, 35.1837>, <-0.609, 0.644, -0.464>, <-1.7161, 13.2988, 34.0304>, <-0.850, 0.461, -0.254>, <-1.6961, 13.3128, 34.0233>, <-0.139, 0.738, -0.660> }
	smooth_triangle { <-1.0011, 14.8207, 35.1837>, <0.332, 0.479, -0.813>, <-1.6961, 13.3128, 34.0233>, <0.015, 0.772, -0.635>, <-1.6727, 13.3060, 34.0304>, <0.781, 0.381, -0.495> }
	smooth_triangle { <-1.0011, 14.8207, 35.1837>, <0.927, -0.140, -0.347>, <-1.6727, 13.3060, 34.0304>, <0.871, 0.314, -0.379>, <-1.6692, 13.2852, 34.0445>, <0.822, -0.525, 0.223> }

	texture { PSWL_BARK }
}

/* Object 'PWL0008F' */
union {
	smooth_triangle { <0.2738, 6.9351, 29.1983>, <-0.353, 0.449, -0.821>, <0.7687, 6.9658, 29.0201>, <-0.333, 0.396, -0.856>, <1.1411, 7.3616, 29.0585>, <-0.353, 0.449, -0.821> }
	smooth_triangle { <1.1411, 7.3616, 29.0585>, <-0.353, 0.449, -0.821>, <0.6399, 7.3091, 29.2636>, <-0.372, 0.501, -0.782>, <0.2738, 6.9351, 29.1983>, <-0.353, 0.449, -0.821> }
	smooth_triangle { <-0.1781, 7.8533, 29.8687>, <-0.250, -0.595, 0.763>, <-0.6835, 7.5824, 29.4631>, <-0.229, -0.654, 0.722>, <-1.3700, 7.7476, 29.3951>, <-0.250, -0.595, 0.763> }
	smooth_triangle { <-1.3700, 7.7476, 29.3951>, <-0.250, -0.595, 0.763>, <-0.8573, 8.0455, 29.7671>, <-0.271, -0.534, 0.801>, <-0.1781, 7.8533, 29.8687>, <-0.250, -0.595, 0.763> }
	smooth_triangle { <-0.1495, 8.7679, 30.7010>, <-0.467, 0.636, -0.614>, <0.2700, 8.8025, 30.3866>, <-0.467, 0.694, -0.548>, <0.6816, 9.0999, 30.4122>, <-0.467, 0.636, -0.614> }
	smooth_triangle { <0.6816, 9.0999, 30.4122>, <-0.467, 0.636, -0.614>, <0.2482, 9.0888, 30.7003>, <-0.464, 0.573, -0.676>, <-0.1495, 8.7679, 30.7010>, <-0.467, 0.636, -0.614> }
	smooth_triangle { <-0.3169, 9.6456, 31.5366>, <-0.196, -0.726, 0.659>, <-0.8010, 9.5341, 31.2756>, <-0.197, -0.714, 0.672>, <-1.3238, 9.7454, 31.3467>, <-0.196, -0.726, 0.659> }
	smooth_triangle { <-1.3238, 9.7454, 31.3467>, <-0.196, -0.726, 0.659>, <-0.8251, 9.8500, 31.6164>, <-0.195, -0.738, 0.646>, <-0.3169, 9.6456, 31.5366>, <-0.196, -0.726, 0.659> }
	smooth_triangle { <0.0918, 9.8280, 32.2544>, <0.018, 0.953, -0.303>, <0.6263, 9.6941, 31.7272>, <0.069, 0.981, -0.179>, <1.3301, 9.6539, 31.7778>, <0.018, 0.953, -0.303> }
	smooth_triangle { <1.3301, 9.6539, 31.7778>, <0.018, 0.953, -0.303>, <0.8818, 9.8559, 32.2503>, <-0.034, 0.907, -0.420>, <0.0918, 9.8280, 32.2544>, <0.018, 0.953, -0.303> }
	smooth_triangle { <0.3211, 10.0746, 33.0003>, <-0.756, -0.478, 0.447>, <-0.0775, 10.4892, 32.7697>, <-0.756, -0.478, 0.447>, <-0.2901, 11.0408, 33.0000>, <-0.756, -0.478, 0.447> }
	smooth_triangle { <-0.2901, 11.0408, 33.0000>, <-0.756, -0.478, 0.447>, <0.1172, 10.6125, 33.2306>, <-0.756, -0.478, 0.447>, <0.3211, 10.0746, 33.0003>, <-0.756, -0.478, 0.447> }
	smooth_triangle { <0.3671, 10.2883, 33.7485>, <0.183, 0.913, -0.365>, <0.9442, 10.0240, 33.2944>, <0.227, 0.939, -0.259>, <1.4786, 9.9180, 33.3780>, <0.183, 0.913, -0.365> }
	smooth_triangle { <1.4786, 9.9180, 33.3780>, <0.183, 0.913, -0.365>, <0.9468, 10.2261, 33.8013>, <0.136, 0.875, -0.465>, <0.3671, 10.2883, 33.7485>, <0.183, 0.913, -0.365> }
	smooth_triangle { <0.2827, 10.6311, 34.5173>, <-0.988, -0.124, -0.092>, <0.2485, 11.0945, 34.1491>, <-0.992, -0.116, -0.054>, <0.1675, 11.7294, 34.2721>, <-0.988, -0.124, -0.092> }
	smooth_triangle { <0.1675, 11.7294, 34.2721>, <-0.988, -0.124, -0.092>, <0.1829, 11.2375, 34.6559>, <-0.983, -0.132, -0.130>, <0.2827, 10.6311, 34.5173>, <-0.988, -0.124, -0.092> }
	smooth_triangle { <-0.5187, 8.3226, 29.8095>, <-0.501, -0.652, -0.569>, <-0.1643, 8.3381, 29.5255>, <-0.410, -0.726, -0.551>, <-0.0870, 8.6628, 29.0400>, <-0.501, -0.652, -0.569> }
	smooth_triangle { <-0.0870, 8.6628, 29.0400>, <-0.501, -0.652, -0.569>, <-0.4510, 8.6464, 29.4237>, <-0.585, -0.568, -0.579>, <-0.5187, 8.3226, 29.8095>, <-0.501, -0.652, -0.569> }
	smooth_triangle { <-0.9964, 8.7127, 29.8150>, <-0.086, 0.024, 0.996>, <-1.2088, 8.1980, 29.8100>, <-0.089, 0.027, 0.996>, <-1.7463, 8.0117, 29.7671>, <-0.086, 0.024, 0.996> }
	smooth_triangle { <-1.7463, 8.0117, 29.7671>, <-0.086, 0.024, 0.996>, <-1.5233, 8.5363, 29.7745>, <-0.084, 0.022, 0.996>, <-0.9964, 8.7127, 29.8150>, <-0.086, 0.024, 0.996> }
	smooth_triangle { <-1.2178, 9.8487, 30.2783>, <-0.330, 0.363, -0.871>, <-0.7528, 9.8262, 30.1009>, <-0.322, 0.333, -0.886>, <-0.3792, 10.1690, 30.0939>, <-0.330, 0.363, -0.871> }
	smooth_triangle { <-0.3792, 10.1690, 30.0939>, <-0.330, 0.363, -0.871>, <-0.8544, 10.1815, 30.2875>, <-0.338, 0.393, -0.855>, <-1.2178, 9.8487, 30.2783>, <-0.330, 0.363, -0.871> }
	smooth_triangle { <-1.6214, 10.9100, 30.7330>, <-0.490, -0.291, 0.822>, <-2.0893, 10.6127, 30.3491>, <-0.490, -0.291, 0.822>, <-2.7359, 10.8848, 30.0603>, <-0.490, -0.291, 0.822> }
	smooth_triangle { <-2.7359, 10.8848, 30.0603>, <-0.490, -0.291, 0.822>, <-2.2523, 11.1825, 30.4535>, <-0.490, -0.290, 0.822>, <-1.6214, 10.9100, 30.7330>, <-0.490, -0.291, 0.822> }
	smooth_triangle { <-1.4882, 11.5404, 31.5551>, <0.039, 0.781, -0.623>, <-0.8398, 11.3188, 31.3181>, <0.039, 0.781, -0.624>, <-0.1522, 11.4718, 31.5521>, <0.039, 0.781, -0.623> }
	smooth_triangle { <-0.1522, 11.4718, 31.5521>, <0.039, 0.781, -0.623>, <-0.8194, 11.6939, 31.7896>, <0.039, 0.782, -0.622>, <-1.4882, 11.5404, 31.5551>, <0.039, 0.781, -0.623> }
	smooth_triangle { <-1.5596, 12.1838, 32.3454>, <-0.179, -0.782, 0.598>, <-2.0174, 12.1282, 32.1416>, <-0.178, -0.771, 0.611>, <-2.4740, 12.3326, 32.2666>, <-0.179, -0.782, 0.598> }
	smooth_triangle { <-2.4740, 12.3326, 32.2666>, <-0.179, -0.782, 0.598>, <-2.0037, 12.3807, 32.4759>, <-0.179, -0.791, 0.584>, <-1.5596, 12.1838, 32.3454>, <-0.179, -0.782, 0.598> }
	smooth_triangle { <-1.5475, 12.7437, 33.1928>, <-0.166, 0.813, -0.557>, <-0.9637, 12.7069, 32.9674>, <-0.166, 0.810, -0.562>, <-0.4119, 12.9625, 33.1728>, <-0.166, 0.813, -0.557> }
	smooth_triangle { <-0.4119, 12.9625, 33.1728>, <-0.166, 0.813, -0.557>, <-1.0113, 12.9938, 33.4001>, <-0.167, 0.816, -0.553>, <-1.5475, 12.7437, 33.1928>, <-0.166, 0.813, -0.557> }
	smooth_triangle { <-1.7305, 13.3213, 34.0139>, <-0.694, -0.655, 0.300>, <-2.0346, 13.5139, 33.6106>, <-0.661, -0.735, 0.148>, <-2.3640, 13.8121, 33.6195>, <-0.694, -0.655, 0.300> }
	smooth_triangle { <-2.3640, 13.8121, 33.6195>, <-0.694, -0.655, 0.300>, <-2.0669, 13.7087, 33.9629>, <-0.705, -0.554, 0.443>, <-1.7305, 13.3213, 34.0139>, <-0.694, -0.655, 0.300> }
	smooth_triangle { <-1.3006, 14.0805, 34.5996>, <-0.474, 0.628, -0.617>, <-0.8062, 14.1498, 34.2836>, <-0.476, 0.637, -0.606>, <-0.0811, 14.7182, 34.3117>, <-0.474, 0.628, -0.617> }
	smooth_triangle { <-0.0811, 14.7182, 34.3117>, <-0.474, 0.628, -0.617>, <-0.5939, 14.6471, 34.6270>, <-0.472, 0.619, -0.628>, <-1.3006, 14.0805, 34.5996>, <-0.474, 0.628, -0.617> }
	smooth_triangle { <-1.0433, 14.8457, 35.1625>, <-0.568, -0.313, 0.762>, <-1.4861, 14.8848, 34.8669>, <-0.552, -0.260, 0.792>, <-1.7992, 15.2938, 34.7829>, <-0.568, -0.313, 0.762> }
	smooth_triangle { <-1.7992, 15.2938, 34.7829>, <-0.568, -0.313, 0.762>, <-1.3396, 15.2115, 35.1089>, <-0.581, -0.364, 0.728>, <-1.0433, 14.8457, 35.1625>, <-0.568, -0.313, 0.762> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0009B' */
union {
	smooth_triangle { <1.6995, 5.7574, 28.5995>, <0.056, -0.789, 0.612>, <1.0381, 4.8175, 27.4498>, <0.040, -0.812, 0.583>, <1.0150, 4.8229, 27.4588>, <-0.288, -0.665, 0.689> }
	smooth_triangle { <1.6995, 5.7574, 28.5995>, <0.056, -0.789, 0.612>, <1.0150, 4.8229, 27.4588>, <-0.288, -0.665, 0.689>, <1.6764, 5.7627, 28.6085>, <-0.554, -0.459, 0.694> }
	smooth_triangle { <1.6764, 5.7627, 28.6085>, <-0.554, -0.459, 0.694>, <1.0150, 4.8229, 27.4588>, <-0.288, -0.665, 0.689>, <1.0022, 4.8429, 27.4498>, <-0.871, 0.119, 0.477> }
	smooth_triangle { <1.6764, 5.7627, 28.6085>, <-0.554, -0.459, 0.694>, <1.0022, 4.8429, 27.4498>, <-0.871, 0.119, 0.477>, <1.6636, 5.7827, 28.5995>, <-0.906, 0.354, 0.231> }
	smooth_triangle { <1.6636, 5.7827, 28.5995>, <-0.906, 0.354, 0.231>, <1.0022, 4.8429, 27.4498>, <-0.871, 0.119, 0.477>, <1.0125, 4.8575, 27.4318>, <-0.583, 0.784, -0.212> }
	smooth_triangle { <1.6636, 5.7827, 28.5995>, <-0.906, 0.354, 0.231>, <1.0125, 4.8575, 27.4318>, <-0.583, 0.784, -0.212>, <1.6739, 5.7974, 28.5815>, <-0.352, 0.814, -0.463> }
	smooth_triangle { <1.6739, 5.7974, 28.5815>, <-0.352, 0.814, -0.463>, <1.0125, 4.8575, 27.4318>, <-0.583, 0.784, -0.212>, <1.0356, 4.8522, 27.4229>, <0.288, 0.665, -0.689> }
	smooth_triangle { <1.6739, 5.7974, 28.5815>, <-0.352, 0.814, -0.463>, <1.0356, 4.8522, 27.4229>, <0.288, 0.665, -0.689>, <1.6971, 5.7921, 28.5725>, <0.554, 0.459, -0.694> }
	smooth_triangle { <1.6971, 5.7921, 28.5725>, <0.554, 0.459, -0.694>, <1.0356, 4.8522, 27.4229>, <0.288, 0.665, -0.689>, <1.0485, 4.8322, 27.4318>, <0.871, -0.119, -0.477> }
	smooth_triangle { <1.6971, 5.7921, 28.5725>, <0.554, 0.459, -0.694>, <1.0485, 4.8322, 27.4318>, <0.871, -0.119, -0.477>, <1.7099, 5.7721, 28.5815>, <0.906, -0.354, -0.231> }
	smooth_triangle { <1.7099, 5.7721, 28.5815>, <0.906, -0.354, -0.231>, <1.0485, 4.8322, 27.4318>, <0.871, -0.119, -0.477>, <1.0381, 4.8175, 27.4498>, <0.763, -0.646, -0.008> }
	smooth_triangle { <1.7099, 5.7721, 28.5815>, <0.906, -0.354, -0.231>, <1.0381, 4.8175, 27.4498>, <0.763, -0.646, -0.008>, <1.6995, 5.7574, 28.5995>, <0.818, -0.576, 0.000> }
	smooth_triangle { <3.0877, 6.7759, 30.3187>, <-0.082, -0.759, 0.646>, <1.0381, 4.8175, 27.4498>, <0.040, -0.812, 0.583>, <1.0150, 4.8229, 27.4588>, <-0.288, -0.665, 0.689> }
	smooth_triangle { <3.0877, 6.7759, 30.3187>, <-0.082, -0.759, 0.646>, <1.0150, 4.8229, 27.4588>, <-0.288, -0.665, 0.689>, <3.0675, 6.7883, 30.3277>, <-0.491, -0.412, 0.768> }
	smooth_triangle { <3.0675, 6.7883, 30.3277>, <-0.491, -0.412, 0.768>, <1.0150, 4.8229, 27.4588>, <-0.288, -0.665, 0.689>, <1.0022, 4.8429, 27.4498>, <-0.871, 0.119, 0.477> }
	smooth_triangle { <3.0675, 6.7883, 30.3277>, <-0.491, -0.412, 0.768>, <1.0022, 4.8429, 27.4498>, <-0.871, 0.119, 0.477>, <3.0617, 6.8114, 30.3187>, <-0.797, 0.464, 0.386> }
	smooth_triangle { <3.0617, 6.8114, 30.3187>, <-0.797, 0.464, 0.386>, <1.0022, 4.8429, 27.4498>, <-0.871, 0.119, 0.477>, <1.0125, 4.8575, 27.4318>, <-0.583, 0.784, -0.212> }
	smooth_triangle { <3.0617, 6.8114, 30.3187>, <-0.797, 0.464, 0.386>, <1.0125, 4.8575, 27.4318>, <-0.583, 0.784, -0.212>, <3.0762, 6.8220, 30.3007>, <-0.306, 0.873, -0.380> }
	smooth_triangle { <3.0762, 6.8220, 30.3007>, <-0.306, 0.873, -0.380>, <1.0125, 4.8575, 27.4318>, <-0.583, 0.784, -0.212>, <1.0356, 4.8522, 27.4229>, <0.288, 0.665, -0.689> }
	smooth_triangle { <3.0762, 6.8220, 30.3007>, <-0.306, 0.873, -0.380>, <1.0356, 4.8522, 27.4229>, <0.288, 0.665, -0.689>, <3.0964, 6.8095, 30.2917>, <0.491, 0.412, -0.767> }
	smooth_triangle { <3.0964, 6.8095, 30.2917>, <0.491, 0.412, -0.767>, <1.0356, 4.8522, 27.4229>, <0.288, 0.665, -0.689>, <1.0485, 4.8322, 27.4318>, <0.871, -0.119, -0.477> }
	smooth_triangle { <3.0964, 6.8095, 30.2917>, <0.491, 0.412, -0.767>, <1.0485, 4.8322, 27.4318>, <0.871, -0.119, -0.477>, <3.1022, 6.7865, 30.3007>, <0.797, -0.464, -0.386> }
	smooth_triangle { <3.1022, 6.7865, 30.3007>, <0.797, -0.464, -0.386>, <1.0485, 4.8322, 27.4318>, <0.871, -0.119, -0.477>, <1.0381, 4.8175, 27.4498>, <0.763, -0.646, -0.008> }
	smooth_triangle { <3.1022, 6.7865, 30.3007>, <0.797, -0.464, -0.386>, <1.0381, 4.8175, 27.4498>, <0.763, -0.646, -0.008>, <3.0877, 6.7759, 30.3187>, <0.620, -0.784, 0.027> }
	smooth_triangle { <4.6932, 8.0243, 31.6693>, <-0.057, -0.668, 0.742>, <3.0877, 6.7759, 30.3187>, <-0.082, -0.759, 0.646>, <3.0675, 6.7883, 30.3277>, <-0.491, -0.412, 0.768> }
	smooth_triangle { <4.6932, 8.0243, 31.6693>, <-0.057, -0.668, 0.742>, <3.0675, 6.7883, 30.3277>, <-0.491, -0.412, 0.768>, <4.6742, 8.0374, 31.6799>, <-0.404, -0.315, 0.859> }
	smooth_triangle { <4.6742, 8.0374, 31.6799>, <-0.404, -0.315, 0.859>, <3.0675, 6.7883, 30.3277>, <-0.491, -0.412, 0.768>, <3.0617, 6.8114, 30.3187>, <-0.797, 0.464, 0.386> }
	smooth_triangle { <4.6742, 8.0374, 31.6799>, <-0.404, -0.315, 0.859>, <3.0617, 6.8114, 30.3187>, <-0.797, 0.464, 0.386>, <4.6662, 8.0590, 31.6693>, <-0.737, 0.525, 0.426> }
	smooth_triangle { <4.6662, 8.0590, 31.6693>, <-0.737, 0.525, 0.426>, <3.0617, 6.8114, 30.3187>, <-0.797, 0.464, 0.386>, <3.0762, 6.8220, 30.3007>, <-0.306, 0.873, -0.380> }
	smooth_triangle { <4.6662, 8.0590, 31.6693>, <-0.737, 0.525, 0.426>, <3.0762, 6.8220, 30.3007>, <-0.306, 0.873, -0.380>, <4.6773, 8.0677, 31.6482>, <-0.332, 0.838, -0.433> }
	smooth_triangle { <4.6773, 8.0677, 31.6482>, <-0.332, 0.838, -0.433>, <3.0762, 6.8220, 30.3007>, <-0.306, 0.873, -0.380>, <3.0964, 6.8095, 30.2917>, <0.491, 0.412, -0.767> }
	smooth_triangle { <4.6773, 8.0677, 31.6482>, <-0.332, 0.838, -0.433>, <3.0964, 6.8095, 30.2917>, <0.491, 0.412, -0.767>, <4.6964, 8.0546, 31.6376>, <0.404, 0.315, -0.859> }
	smooth_triangle { <4.6964, 8.0546, 31.6376>, <0.404, 0.315, -0.859>, <3.0964, 6.8095, 30.2917>, <0.491, 0.412, -0.767>, <3.1022, 6.7865, 30.3007>, <0.797, -0.464, -0.386> }
	smooth_triangle { <4.6964, 8.0546, 31.6376>, <0.404, 0.315, -0.859>, <3.1022, 6.7865, 30.3007>, <0.797, -0.464, -0.386>, <4.7043, 8.0329, 31.6482>, <0.737, -0.525, -0.426> }
	smooth_triangle { <4.7043, 8.0329, 31.6482>, <0.737, -0.525, -0.426>, <3.1022, 6.7865, 30.3007>, <0.797, -0.464, -0.386>, <3.0877, 6.7759, 30.3187>, <0.620, -0.784, 0.027> }
	smooth_triangle { <4.7043, 8.0329, 31.6482>, <0.737, -0.525, -0.426>, <3.0877, 6.7759, 30.3187>, <0.620, -0.784, 0.027>, <4.6932, 8.0243, 31.6693>, <0.629, -0.778, 0.005> }
	smooth_triangle { <5.7950, 8.9405, 32.4408>, <0.213, -0.721, 0.660>, <4.6932, 8.0243, 31.6693>, <-0.057, -0.668, 0.742>, <4.6742, 8.0374, 31.6799>, <-0.404, -0.315, 0.859> }
	smooth_triangle { <5.7950, 8.9405, 32.4408>, <0.213, -0.721, 0.660>, <4.6742, 8.0374, 31.6799>, <-0.404, -0.315, 0.859>, <5.7763, 8.9536, 32.4520>, <-0.374, -0.158, 0.914> }
	smooth_triangle { <5.7763, 8.9536, 32.4520>, <-0.374, -0.158, 0.914>, <4.6742, 8.0374, 31.6799>, <-0.404, -0.315, 0.859>, <4.6662, 8.0590, 31.6693>, <-0.737, 0.525, 0.426> }
	smooth_triangle { <5.7763, 8.9536, 32.4520>, <-0.374, -0.158, 0.914>, <4.6662, 8.0590, 31.6693>, <-0.737, 0.525, 0.426>, <5.7668, 8.9743, 32.4408>, <-0.692, 0.619, 0.370> }
	smooth_triangle { <5.7668, 8.9743, 32.4408>, <-0.692, 0.619, 0.370>, <4.6662, 8.0590, 31.6693>, <-0.737, 0.525, 0.426>, <4.6773, 8.0677, 31.6482>, <-0.332, 0.838, -0.433> }
	smooth_triangle { <5.7668, 8.9743, 32.4408>, <-0.692, 0.619, 0.370>, <4.6773, 8.0677, 31.6482>, <-0.332, 0.838, -0.433>, <5.7761, 8.9820, 32.4184>, <-0.315, 0.780, -0.541> }
	smooth_triangle { <5.7761, 8.9820, 32.4184>, <-0.315, 0.780, -0.541>, <4.6773, 8.0677, 31.6482>, <-0.332, 0.838, -0.433>, <4.6964, 8.0546, 31.6376>, <0.404, 0.315, -0.859> }
	smooth_triangle { <5.7761, 8.9820, 32.4184>, <-0.315, 0.780, -0.541>, <4.6964, 8.0546, 31.6376>, <0.404, 0.315, -0.859>, <5.7948, 8.9690, 32.4072>, <0.382, 0.165, -0.909> }
	smooth_triangle { <5.7948, 8.9690, 32.4072>, <0.382, 0.165, -0.909>, <4.6964, 8.0546, 31.6376>, <0.404, 0.315, -0.859>, <4.7043, 8.0329, 31.6482>, <0.737, -0.525, -0.426> }
	smooth_triangle { <5.7948, 8.9690, 32.4072>, <0.382, 0.165, -0.909>, <4.7043, 8.0329, 31.6482>, <0.737, -0.525, -0.426>, <5.8042, 8.9482, 32.4184>, <0.701, -0.612, -0.365> }
	smooth_triangle { <5.8042, 8.9482, 32.4184>, <0.701, -0.612, -0.365>, <4.7043, 8.0329, 31.6482>, <0.737, -0.525, -0.426>, <4.6932, 8.0243, 31.6693>, <0.629, -0.778, 0.005> }
	smooth_triangle { <5.8042, 8.9482, 32.4184>, <0.701, -0.612, -0.365>, <4.6932, 8.0243, 31.6693>, <0.629, -0.778, 0.005>, <5.7950, 8.9405, 32.4408>, <0.639, -0.769, 0.000> }
	smooth_triangle { <7.0070, 9.9362, 32.8769>, <0.143, -0.530, 0.836>, <5.7950, 8.9405, 32.4408>, <0.213, -0.721, 0.660>, <5.7763, 8.9536, 32.4520>, <-0.374, -0.158, 0.914> }
	smooth_triangle { <7.0070, 9.9362, 32.8769>, <-0.478, 0.246, 0.843>, <5.7763, 8.9536, 32.4520>, <-0.374, -0.158, 0.914>, <5.7668, 8.9743, 32.4408>, <-0.692, 0.619, 0.370> }
	smooth_triangle { <7.0070, 9.9362, 32.8769>, <-0.611, 0.792, 0.016>, <5.7668, 8.9743, 32.4408>, <-0.692, 0.619, 0.370>, <5.7761, 8.9820, 32.4184>, <-0.315, 0.780, -0.541> }
	smooth_triangle { <7.0070, 9.9362, 32.8769>, <-0.115, 0.555, -0.824>, <5.7761, 8.9820, 32.4184>, <-0.315, 0.780, -0.541>, <5.7948, 8.9690, 32.4072>, <0.382, 0.165, -0.909> }
	smooth_triangle { <7.0070, 9.9362, 32.8769>, <0.509, -0.223, -0.831>, <5.7948, 8.9690, 32.4072>, <0.382, 0.165, -0.909>, <5.8042, 8.9482, 32.4184>, <0.701, -0.612, -0.365> }
	smooth_triangle { <7.0070, 9.9362, 32.8769>, <0.640, -0.768, 0.000>, <5.8042, 8.9482, 32.4184>, <0.701, -0.612, -0.365>, <5.7950, 8.9405, 32.4408>, <0.213, -0.721, 0.660> }

	texture { PSWL_BARK }
}

/* Object 'PWL0009F' */
union {
	smooth_triangle { <2.4193, 6.2481, 29.4455>, <0.512, 0.524, -0.681>, <2.6289, 5.7504, 29.2279>, <0.499, 0.515, -0.697>, <3.1226, 5.4421, 29.3537>, <0.512, 0.524, -0.681> }
	smooth_triangle { <3.1226, 5.4421, 29.3537>, <0.512, 0.524, -0.681>, <2.8968, 5.9466, 29.5803>, <0.524, 0.533, -0.664>, <2.4193, 6.2481, 29.4455>, <0.512, 0.524, -0.681> }
	smooth_triangle { <3.0514, 6.8426, 30.3085>, <-0.583, -0.389, 0.713>, <2.5490, 7.2186, 30.1036>, <-0.582, -0.388, 0.715>, <2.3536, 7.8406, 30.2818>, <-0.583, -0.389, 0.713> }
	smooth_triangle { <2.3536, 7.8406, 30.2818>, <-0.583, -0.389, 0.713>, <2.8650, 7.4500, 30.4882>, <-0.585, -0.390, 0.711>, <3.0514, 6.8426, 30.3085>, <-0.583, -0.389, 0.713> }
	smooth_triangle { <3.9232, 7.4056, 30.9527>, <-0.046, 0.856, -0.515>, <4.1749, 7.0981, 30.4721>, <-0.117, 0.808, -0.578>, <4.7721, 7.0450, 30.2772>, <-0.046, 0.856, -0.515> }
	smooth_triangle { <4.7721, 7.0450, 30.2772>, <-0.046, 0.856, -0.515>, <4.4740, 7.3308, 30.8330>, <0.024, 0.894, -0.447>, <3.9232, 7.4056, 30.9527>, <-0.046, 0.856, -0.515> }
	smooth_triangle { <4.6755, 8.0898, 31.6299>, <-0.761, 0.229, 0.607>, <4.4016, 8.4972, 31.0471>, <-0.857, 0.135, 0.497>, <4.4353, 9.1615, 30.9246>, <-0.761, 0.229, 0.607> }
	smooth_triangle { <4.4353, 9.1615, 30.9246>, <-0.761, 0.229, 0.607>, <4.7722, 8.7854, 31.4036>, <-0.641, 0.317, 0.699>, <4.6755, 8.0898, 31.6299>, <-0.761, 0.229, 0.607> }
	smooth_triangle { <5.2743, 8.4717, 32.0265>, <0.105, 0.576, -0.810>, <5.5062, 8.0298, 31.7125>, <0.172, 0.629, -0.758>, <6.0538, 7.8324, 31.6730>, <0.105, 0.576, -0.810> }
	smooth_triangle { <6.0538, 7.8324, 31.6730>, <0.105, 0.576, -0.810>, <5.8300, 8.2991, 31.9460>, <0.037, 0.518, -0.855>, <5.2743, 8.4717, 32.0265>, <0.105, 0.576, -0.810> }
	smooth_triangle { <5.7574, 9.0050, 32.4179>, <-0.529, -0.116, 0.841>, <5.1616, 9.3984, 32.1208>, <-0.487, -0.081, 0.870>, <5.0009, 10.1791, 32.1035>, <-0.529, -0.116, 0.841> }
	smooth_triangle { <5.0009, 10.1791, 32.1035>, <-0.529, -0.116, 0.841>, <5.5924, 9.7568, 32.4411>, <-0.569, -0.150, 0.809>, <5.7574, 9.0050, 32.4179>, <-0.529, -0.116, 0.841> }
	smooth_triangle { <6.4355, 9.4193, 32.6323>, <-0.081, 0.503, -0.861>, <6.6625, 8.9763, 32.3182>, <0.000, 0.578, -0.816>, <7.2526, 8.8043, 32.1962>, <-0.081, 0.503, -0.861> }
	smooth_triangle { <7.2526, 8.8043, 32.1962>, <-0.081, 0.503, -0.861>, <7.0389, 9.2766, 32.4565>, <-0.161, 0.419, -0.893>, <6.4355, 9.4193, 32.6323>, <-0.081, 0.503, -0.861> }
	smooth_triangle { <6.9971, 9.9765, 32.8433>, <-0.593, 0.425, 0.684>, <6.6227, 10.2835, 32.3804>, <-0.499, 0.480, 0.722>, <6.7434, 11.0043, 31.9849>, <-0.593, 0.425, 0.684> }
	smooth_triangle { <6.7434, 11.0043, 31.9849>, <-0.593, 0.425, 0.684>, <7.0841, 10.6518, 32.5499>, <-0.679, 0.364, 0.637>, <6.9971, 9.9765, 32.8433>, <-0.593, 0.425, 0.684> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0010B' */
union {
	smooth_triangle { <0.8486, 3.8597, 28.7276>, <-0.388, 0.751, 0.535>, <1.0051, 4.8508, 27.4487>, <-0.391, 0.723, 0.569>, <1.0284, 4.8573, 27.4565>, <-0.091, 0.770, 0.632> }
	smooth_triangle { <0.8486, 3.8597, 28.7276>, <-0.388, 0.751, 0.535>, <1.0284, 4.8573, 27.4565>, <-0.091, 0.770, 0.632>, <0.8719, 3.8661, 28.7354>, <0.307, 0.734, 0.606> }
	smooth_triangle { <0.8719, 3.8661, 28.7354>, <0.307, 0.734, 0.606>, <1.0284, 4.8573, 27.4565>, <-0.091, 0.770, 0.632>, <1.0486, 4.8440, 27.4487>, <0.815, 0.411, 0.409> }
	smooth_triangle { <0.8719, 3.8661, 28.7354>, <0.307, 0.734, 0.606>, <1.0486, 4.8440, 27.4487>, <0.815, 0.411, 0.409>, <0.8921, 3.8528, 28.7276>, <0.974, 0.107, 0.202> }
	smooth_triangle { <0.8921, 3.8528, 28.7276>, <0.974, 0.107, 0.202>, <1.0486, 4.8440, 27.4487>, <0.815, 0.411, 0.409>, <1.0455, 4.8242, 27.4330>, <0.906, -0.359, -0.223> }
	smooth_triangle { <0.8921, 3.8528, 28.7276>, <0.974, 0.107, 0.202>, <1.0455, 4.8242, 27.4330>, <0.906, -0.359, -0.223>, <0.8890, 3.8331, 28.7119>, <0.666, -0.627, -0.404> }
	smooth_triangle { <0.8890, 3.8331, 28.7119>, <0.666, -0.627, -0.404>, <1.0455, 4.8242, 27.4330>, <0.906, -0.359, -0.223>, <1.0222, 4.8178, 27.4251>, <0.091, -0.770, -0.632> }
	smooth_triangle { <0.8890, 3.8331, 28.7119>, <0.666, -0.627, -0.404>, <1.0222, 4.8178, 27.4251>, <0.091, -0.770, -0.632>, <0.8657, 3.8266, 28.7041>, <-0.307, -0.734, -0.606> }
	smooth_triangle { <0.8657, 3.8266, 28.7041>, <-0.307, -0.734, -0.606>, <1.0222, 4.8178, 27.4251>, <0.091, -0.770, -0.632>, <1.0020, 4.8311, 27.4330>, <-0.815, -0.411, -0.409> }
	smooth_triangle { <0.8657, 3.8266, 28.7041>, <-0.307, -0.734, -0.606>, <1.0020, 4.8311, 27.4330>, <-0.815, -0.411, -0.409>, <0.8455, 3.8399, 28.7119>, <-0.974, -0.107, -0.202> }
	smooth_triangle { <0.8455, 3.8399, 28.7119>, <-0.974, -0.107, -0.202>, <1.0020, 4.8311, 27.4330>, <-0.815, -0.411, -0.409>, <1.0051, 4.8508, 27.4487>, <-0.994, 0.109, 0.008> }
	smooth_triangle { <0.8455, 3.8399, 28.7119>, <-0.974, -0.107, -0.202>, <1.0051, 4.8508, 27.4487>, <-0.994, 0.109, 0.008>, <0.8486, 3.8597, 28.7276>, <-0.988, 0.156, 0.000> }
	smooth_triangle { <0.8728, 1.8861, 30.7815>, <-0.471, 0.681, 0.561>, <1.0051, 4.8508, 27.4487>, <-0.391, 0.723, 0.569>, <1.0284, 4.8573, 27.4565>, <-0.091, 0.770, 0.632> }
	smooth_triangle { <0.8728, 1.8861, 30.7815>, <-0.471, 0.681, 0.561>, <1.0284, 4.8573, 27.4565>, <-0.091, 0.770, 0.632>, <0.8946, 1.8955, 30.7903>, <0.003, 0.777, 0.629> }
	smooth_triangle { <0.8946, 1.8955, 30.7903>, <0.003, 0.777, 0.629>, <1.0284, 4.8573, 27.4565>, <-0.091, 0.770, 0.632>, <1.0486, 4.8440, 27.4487>, <0.815, 0.411, 0.409> }
	smooth_triangle { <0.8946, 1.8955, 30.7903>, <0.003, 0.777, 0.629>, <1.0486, 4.8440, 27.4487>, <0.815, 0.411, 0.409>, <0.9168, 1.8867, 30.7815>, <0.868, 0.394, 0.301> }
	smooth_triangle { <0.9168, 1.8867, 30.7815>, <0.924, 0.297, 0.240>, <1.0486, 4.8440, 27.4487>, <0.815, 0.411, 0.409>, <1.0455, 4.8242, 27.4330>, <0.906, -0.359, -0.223> }
	smooth_triangle { <0.9168, 1.8867, 30.7815>, <0.868, 0.394, 0.301>, <1.0455, 4.8242, 27.4330>, <0.906, -0.359, -0.223>, <0.9170, 1.8683, 30.7639>, <0.864, -0.383, -0.328> }
	smooth_triangle { <0.9170, 1.8683, 30.7639>, <0.864, -0.383, -0.328>, <1.0455, 4.8242, 27.4330>, <0.906, -0.359, -0.223>, <1.0222, 4.8178, 27.4251>, <0.091, -0.770, -0.632> }
	smooth_triangle { <0.9170, 1.8683, 30.7639>, <0.864, -0.383, -0.328>, <1.0222, 4.8178, 27.4251>, <0.091, -0.770, -0.632>, <0.8951, 1.8589, 30.7551>, <-0.004, -0.777, -0.629> }
	smooth_triangle { <0.8951, 1.8589, 30.7551>, <-0.004, -0.777, -0.629>, <1.0222, 4.8178, 27.4251>, <0.091, -0.770, -0.632>, <1.0020, 4.8311, 27.4330>, <-0.815, -0.411, -0.409> }
	smooth_triangle { <0.8951, 1.8589, 30.7551>, <-0.004, -0.777, -0.629>, <1.0020, 4.8311, 27.4330>, <-0.815, -0.411, -0.409>, <0.8730, 1.8678, 30.7639>, <-0.868, -0.394, -0.301> }
	smooth_triangle { <0.8730, 1.8678, 30.7639>, <-0.924, -0.297, -0.240>, <1.0020, 4.8311, 27.4330>, <-0.815, -0.411, -0.409>, <1.0051, 4.8508, 27.4487>, <-0.994, 0.109, 0.008> }
	smooth_triangle { <0.8730, 1.8678, 30.7639>, <-0.868, -0.394, -0.301>, <1.0051, 4.8508, 27.4487>, <-0.994, 0.109, 0.008>, <0.8728, 1.8861, 30.7815>, <-1.000, -0.028, -0.002> }
	smooth_triangle { <0.9629, 0.4690, 32.7623>, <-0.532, 0.679, 0.507>, <0.8728, 1.8861, 30.7815>, <-0.471, 0.681, 0.561>, <0.8946, 1.8955, 30.7903>, <0.003, 0.777, 0.629> }
	smooth_triangle { <0.9629, 0.4690, 32.7623>, <-0.532, 0.679, 0.507>, <0.8946, 1.8955, 30.7903>, <0.003, 0.777, 0.629>, <0.9842, 0.4807, 32.7697>, <-0.048, 0.815, 0.578> }
	smooth_triangle { <0.9842, 0.4807, 32.7697>, <-0.048, 0.815, 0.578>, <0.8946, 1.8955, 30.7903>, <0.003, 0.777, 0.629>, <0.9168, 1.8867, 30.7815>, <0.868, 0.394, 0.301> }
	smooth_triangle { <0.9842, 0.4807, 32.7697>, <-0.048, 0.815, 0.578>, <0.9168, 1.8867, 30.7815>, <0.791, 0.489, 0.367>, <1.0068, 0.4718, 32.7623>, <0.841, 0.461, 0.284> }
	smooth_triangle { <1.0068, 0.4718, 32.7623>, <0.841, 0.461, 0.284>, <0.9168, 1.8867, 30.7815>, <0.868, 0.394, 0.301>, <0.9170, 1.8683, 30.7639>, <0.864, -0.383, -0.328> }
	smooth_triangle { <1.0068, 0.4718, 32.7623>, <0.841, 0.461, 0.284>, <0.9170, 1.8683, 30.7639>, <0.864, -0.383, -0.328>, <1.0081, 0.4512, 32.7475>, <0.887, -0.354, -0.295> }
	smooth_triangle { <1.0081, 0.4512, 32.7475>, <0.887, -0.354, -0.295>, <0.9170, 1.8683, 30.7639>, <0.864, -0.383, -0.328>, <0.8951, 1.8589, 30.7551>, <-0.004, -0.777, -0.629> }
	smooth_triangle { <1.0081, 0.4512, 32.7475>, <0.887, -0.354, -0.295>, <0.8951, 1.8589, 30.7551>, <-0.004, -0.777, -0.629>, <0.9868, 0.4395, 32.7402>, <0.048, -0.814, -0.578> }
	smooth_triangle { <0.9868, 0.4395, 32.7402>, <0.048, -0.814, -0.578>, <0.8951, 1.8589, 30.7551>, <-0.004, -0.777, -0.629>, <0.8730, 1.8678, 30.7639>, <-0.868, -0.394, -0.301> }
	smooth_triangle { <0.9868, 0.4395, 32.7402>, <0.048, -0.814, -0.578>, <0.8730, 1.8678, 30.7639>, <-0.791, -0.489, -0.368>, <0.9642, 0.4484, 32.7475>, <-0.841, -0.461, -0.284> }
	smooth_triangle { <0.9642, 0.4484, 32.7475>, <-0.841, -0.461, -0.284>, <0.8730, 1.8678, 30.7639>, <-0.868, -0.394, -0.301>, <0.8728, 1.8861, 30.7815>, <-1.000, -0.028, -0.002> }
	smooth_triangle { <0.9642, 0.4484, 32.7475>, <-0.841, -0.461, -0.284>, <0.8728, 1.8861, 30.7815>, <-1.000, -0.028, -0.002>, <0.9629, 0.4690, 32.7623>, <-0.998, -0.069, 0.002> }
	smooth_triangle { <1.0670, -0.9248, 34.7604>, <-0.550, 0.698, 0.458>, <0.9629, 0.4690, 32.7623>, <-0.532, 0.679, 0.507>, <0.9842, 0.4807, 32.7697>, <-0.048, 0.815, 0.578> }
	smooth_triangle { <1.0670, -0.9248, 34.7604>, <-0.550, 0.698, 0.458>, <0.9842, 0.4807, 32.7697>, <-0.048, 0.815, 0.578>, <1.0881, -0.9128, 34.7677>, <-0.117, 0.863, 0.491> }
	smooth_triangle { <1.0881, -0.9128, 34.7677>, <0.049, 0.871, 0.488>, <0.9842, 0.4807, 32.7697>, <-0.048, 0.815, 0.578>, <1.0068, 0.4718, 32.7623>, <0.841, 0.461, 0.284> }
	smooth_triangle { <1.0881, -0.9128, 34.7677>, <0.049, 0.871, 0.488>, <1.0068, 0.4718, 32.7623>, <0.841, 0.461, 0.284>, <1.1108, -0.9216, 34.7604>, <0.795, 0.575, 0.193> }
	smooth_triangle { <1.1108, -0.9216, 34.7604>, <0.886, 0.441, 0.146>, <1.0068, 0.4718, 32.7623>, <0.841, 0.461, 0.284>, <1.0081, 0.4512, 32.7475>, <0.887, -0.354, -0.295> }
	smooth_triangle { <1.1108, -0.9216, 34.7604>, <0.886, 0.441, 0.146>, <1.0081, 0.4512, 32.7475>, <0.887, -0.354, -0.295>, <1.1124, -0.9423, 34.7458>, <0.910, -0.289, -0.297> }
	smooth_triangle { <1.1124, -0.9423, 34.7458>, <0.836, -0.430, -0.341>, <1.0081, 0.4512, 32.7475>, <0.887, -0.354, -0.295>, <0.9868, 0.4395, 32.7402>, <0.048, -0.814, -0.578> }
	smooth_triangle { <1.1124, -0.9423, 34.7458>, <0.836, -0.430, -0.341>, <0.9868, 0.4395, 32.7402>, <0.048, -0.814, -0.578>, <1.0912, -0.9543, 34.7385>, <0.117, -0.864, -0.490> }
	smooth_triangle { <1.0912, -0.9543, 34.7385>, <-0.049, -0.873, -0.486>, <0.9868, 0.4395, 32.7402>, <0.048, -0.814, -0.578>, <0.9642, 0.4484, 32.7475>, <-0.841, -0.461, -0.284> }
	smooth_triangle { <1.0912, -0.9543, 34.7385>, <-0.049, -0.873, -0.486>, <0.9642, 0.4484, 32.7475>, <-0.841, -0.461, -0.284>, <1.0685, -0.9456, 34.7458>, <-0.795, -0.575, -0.192> }
	smooth_triangle { <1.0685, -0.9456, 34.7458>, <-0.885, -0.442, -0.143>, <0.9642, 0.4484, 32.7475>, <-0.841, -0.461, -0.284>, <0.9629, 0.4690, 32.7623>, <-0.998, -0.069, 0.002> }
	smooth_triangle { <1.0685, -0.9456, 34.7458>, <-0.885, -0.442, -0.143>, <0.9629, 0.4690, 32.7623>, <-0.998, -0.069, 0.002>, <1.0670, -0.9248, 34.7604>, <-0.974, -0.222, 0.039> }
	smooth_triangle { <1.3285, -1.4882, 36.2626>, <-0.723, 0.594, 0.354>, <1.0670, -0.9248, 34.7604>, <-0.550, 0.698, 0.458>, <1.0881, -0.9128, 34.7677>, <-0.117, 0.863, 0.491> }
	smooth_triangle { <1.3285, -1.4882, 36.2626>, <-0.880, 0.421, 0.219>, <1.0881, -0.9128, 34.7677>, <-0.642, 0.651, 0.404>, <1.3434, -1.4682, 36.2674>, <-0.386, 0.792, 0.474> }
	smooth_triangle { <1.3434, -1.4682, 36.2674>, <0.233, 0.881, 0.412>, <1.0881, -0.9128, 34.7677>, <0.049, 0.871, 0.488>, <1.1108, -0.9216, 34.7604>, <0.795, 0.575, 0.193> }
	smooth_triangle { <1.3434, -1.4682, 36.2674>, <-0.218, 0.865, 0.452>, <1.1108, -0.9216, 34.7604>, <0.330, 0.870, 0.365>, <1.3683, -1.4693, 36.2626>, <0.605, 0.706, 0.368> }
	smooth_triangle { <1.3683, -1.4693, 36.2626>, <0.952, 0.297, 0.068>, <1.1108, -0.9216, 34.7604>, <0.886, 0.441, 0.146>, <1.1124, -0.9423, 34.7458>, <0.910, -0.289, -0.297> }
	smooth_triangle { <1.3683, -1.4693, 36.2626>, <0.735, 0.619, 0.277>, <1.1124, -0.9423, 34.7458>, <0.974, 0.222, -0.039>, <1.3784, -1.4906, 36.2530>, <0.991, -0.088, -0.100> }
	smooth_triangle { <1.3784, -1.4906, 36.2530>, <0.724, -0.597, -0.345>, <1.1124, -0.9423, 34.7458>, <0.836, -0.430, -0.341>, <1.0912, -0.9543, 34.7385>, <0.117, -0.864, -0.490> }
	smooth_triangle { <1.3784, -1.4906, 36.2530>, <0.952, -0.253, -0.171>, <1.0912, -0.9543, 34.7385>, <0.642, -0.651, -0.405>, <1.3635, -1.5106, 36.2482>, <0.387, -0.797, -0.463> }
	smooth_triangle { <1.3635, -1.5106, 36.2482>, <-0.232, -0.885, -0.405>, <1.0912, -0.9543, 34.7385>, <-0.049, -0.873, -0.486>, <1.0685, -0.9456, 34.7458>, <-0.795, -0.575, -0.192> }
	smooth_triangle { <1.3635, -1.5106, 36.2482>, <0.220, -0.869, -0.443>, <1.0685, -0.9456, 34.7458>, <-0.330, -0.870, -0.366>, <1.3386, -1.5094, 36.2530>, <-0.604, -0.711, -0.359> }
	smooth_triangle { <1.3386, -1.5094, 36.2530>, <-0.952, -0.301, -0.060>, <1.0685, -0.9456, 34.7458>, <-0.885, -0.442, -0.143>, <1.0670, -0.9248, 34.7604>, <-0.974, -0.222, 0.039> }
	smooth_triangle { <1.3386, -1.5094, 36.2530>, <-0.734, -0.624, -0.268>, <1.0670, -0.9248, 34.7604>, <-0.974, -0.222, 0.039>, <1.3285, -1.4882, 36.2626>, <-0.904, -0.428, -0.003> }
	smooth_triangle { <1.2527, -2.4913, 37.5340>, <-0.793, 0.496, 0.353>, <1.3285, -1.4882, 36.2626>, <-0.880, 0.421, 0.219>, <1.3434, -1.4682, 36.2674>, <-0.386, 0.792, 0.474> }
	smooth_triangle { <1.2527, -2.4913, 37.5340>, <0.133, 0.762, 0.633>, <1.3434, -1.4682, 36.2674>, <-0.218, 0.865, 0.452>, <1.3683, -1.4693, 36.2626>, <0.605, 0.706, 0.368> }
	smooth_triangle { <1.2527, -2.4913, 37.5340>, <0.915, 0.265, 0.305>, <1.3683, -1.4693, 36.2626>, <0.735, 0.619, 0.277>, <1.3784, -1.4906, 36.2530>, <0.991, -0.088, -0.100> }
	smooth_triangle { <1.2527, -2.4913, 37.5340>, <0.796, -0.516, -0.317>, <1.3784, -1.4906, 36.2530>, <0.952, -0.253, -0.171>, <1.3635, -1.5106, 36.2482>, <0.387, -0.797, -0.463> }
	smooth_triangle { <1.2527, -2.4913, 37.5340>, <-0.132, -0.787, -0.603>, <1.3635, -1.5106, 36.2482>, <0.220, -0.869, -0.443>, <1.3386, -1.5094, 36.2530>, <-0.604, -0.711, -0.359> }
	smooth_triangle { <1.2527, -2.4913, 37.5340>, <-0.919, -0.286, -0.272>, <1.3386, -1.5094, 36.2530>, <-0.734, -0.624, -0.268>, <1.3285, -1.4882, 36.2626>, <-0.951, 0.272, 0.146> }
	smooth_triangle { <0.6072, -0.6324, 33.1428>, <-0.393, 0.408, 0.824>, <0.9658, 0.4706, 32.7670>, <-0.347, 0.533, 0.772>, <0.9879, 0.4675, 32.7791>, <-0.023, 0.463, 0.886> }
	smooth_triangle { <0.6072, -0.6324, 33.1428>, <-0.393, 0.408, 0.824>, <0.9879, 0.4675, 32.7791>, <-0.023, 0.463, 0.886>, <0.6293, -0.6355, 33.1549>, <0.273, 0.229, 0.934> }
	smooth_triangle { <0.6293, -0.6355, 33.1549>, <0.273, 0.229, 0.934>, <0.9879, 0.4675, 32.7791>, <-0.023, 0.463, 0.886>, <1.0076, 0.4570, 32.7670>, <0.804, -0.018, 0.595> }
	smooth_triangle { <0.6293, -0.6355, 33.1549>, <0.273, 0.229, 0.934>, <1.0076, 0.4570, 32.7670>, <0.804, -0.018, 0.595>, <0.6490, -0.6460, 33.1428>, <0.930, -0.196, 0.311> }
	smooth_triangle { <0.6490, -0.6460, 33.1428>, <0.930, -0.196, 0.311>, <1.0076, 0.4570, 32.7670>, <0.804, -0.018, 0.595>, <1.0052, 0.4495, 32.7429>, <0.828, -0.481, -0.290> }
	smooth_triangle { <0.6490, -0.6460, 33.1428>, <0.930, -0.196, 0.311>, <1.0052, 0.4495, 32.7429>, <0.828, -0.481, -0.290>, <0.6466, -0.6535, 33.1186>, <0.657, -0.426, -0.623> }
	smooth_triangle { <0.6466, -0.6535, 33.1186>, <0.657, -0.426, -0.623>, <1.0052, 0.4495, 32.7429>, <0.828, -0.481, -0.290>, <0.9831, 0.4526, 32.7308>, <0.023, -0.463, -0.886> }
	smooth_triangle { <0.6466, -0.6535, 33.1186>, <0.657, -0.426, -0.623>, <0.9831, 0.4526, 32.7308>, <0.023, -0.463, -0.886>, <0.6244, -0.6504, 33.1065>, <-0.273, -0.229, -0.934> }
	smooth_triangle { <0.6244, -0.6504, 33.1065>, <-0.273, -0.229, -0.934>, <0.9831, 0.4526, 32.7308>, <0.023, -0.463, -0.886>, <0.9634, 0.4631, 32.7429>, <-0.804, 0.018, -0.595> }
	smooth_triangle { <0.6244, -0.6504, 33.1065>, <-0.273, -0.229, -0.934>, <0.9634, 0.4631, 32.7429>, <-0.804, 0.018, -0.595>, <0.6047, -0.6399, 33.1186>, <-0.930, 0.196, -0.311> }
	smooth_triangle { <0.6047, -0.6399, 33.1186>, <-0.930, 0.196, -0.311>, <0.9634, 0.4631, 32.7429>, <-0.804, 0.018, -0.595>, <0.9658, 0.4706, 32.7670>, <-0.927, 0.374, 0.002> }
	smooth_triangle { <0.6047, -0.6399, 33.1186>, <-0.930, 0.196, -0.311>, <0.9658, 0.4706, 32.7670>, <-0.927, 0.374, 0.002>, <0.6072, -0.6324, 33.1428>, <-0.951, 0.309, 0.000> }
	smooth_triangle { <-0.3412, -2.2350, 34.7039>, <-0.246, 0.609, 0.754>, <0.9658, 0.4706, 32.7670>, <-0.347, 0.533, 0.772>, <0.9879, 0.4675, 32.7791>, <-0.023, 0.463, 0.886> }
	smooth_triangle { <-0.3412, -2.2350, 34.7039>, <-0.246, 0.609, 0.754>, <0.9879, 0.4675, 32.7791>, <-0.023, 0.463, 0.886>, <-0.3181, -2.2392, 34.7136>, <0.226, 0.473, 0.852> }
	smooth_triangle { <-0.3181, -2.2392, 34.7136>, <0.226, 0.473, 0.852>, <0.9879, 0.4675, 32.7791>, <-0.023, 0.463, 0.886>, <1.0076, 0.4570, 32.7670>, <0.804, -0.018, 0.595> }
	smooth_triangle { <-0.3181, -2.2392, 34.7136>, <0.362, 0.431, 0.827>, <1.0076, 0.4570, 32.7670>, <0.804, -0.018, 0.595>, <-0.3033, -2.2574, 34.7039>, <0.931, -0.057, 0.360> }
	smooth_triangle { <-0.3033, -2.2574, 34.7039>, <0.931, -0.057, 0.360>, <1.0076, 0.4570, 32.7670>, <0.804, -0.018, 0.595>, <1.0052, 0.4495, 32.7429>, <0.828, -0.481, -0.290> }
	smooth_triangle { <-0.3033, -2.2574, 34.7039>, <0.955, -0.156, 0.251>, <1.0052, 0.4495, 32.7429>, <0.828, -0.481, -0.290>, <-0.3116, -2.2714, 34.6844>, <0.695, -0.525, -0.491> }
	smooth_triangle { <-0.3116, -2.2714, 34.6844>, <0.695, -0.525, -0.491>, <1.0052, 0.4495, 32.7429>, <0.828, -0.481, -0.290>, <0.9831, 0.4526, 32.7308>, <0.023, -0.463, -0.886> }
	smooth_triangle { <-0.3116, -2.2714, 34.6844>, <0.582, -0.579, -0.570>, <0.9831, 0.4526, 32.7308>, <0.023, -0.463, -0.886>, <-0.3347, -2.2672, 34.6746>, <-0.226, -0.473, -0.852> }
	smooth_triangle { <-0.3347, -2.2672, 34.6746>, <-0.226, -0.473, -0.852>, <0.9831, 0.4526, 32.7308>, <0.023, -0.463, -0.886>, <0.9634, 0.4631, 32.7429>, <-0.804, 0.018, -0.595> }
	smooth_triangle { <-0.3347, -2.2672, 34.6746>, <-0.363, -0.431, -0.826>, <0.9634, 0.4631, 32.7429>, <-0.804, 0.018, -0.595>, <-0.3495, -2.2490, 34.6844>, <-0.932, 0.057, -0.359> }
	smooth_triangle { <-0.3495, -2.2490, 34.6844>, <-0.932, 0.057, -0.359>, <0.9634, 0.4631, 32.7429>, <-0.804, 0.018, -0.595>, <0.9658, 0.4706, 32.7670>, <-0.927, 0.374, 0.002> }
	smooth_triangle { <-0.3495, -2.2490, 34.6844>, <-0.956, 0.156, -0.250>, <0.9658, 0.4706, 32.7670>, <-0.927, 0.374, 0.002>, <-0.3412, -2.2350, 34.7039>, <-0.953, 0.291, 0.087> }
	smooth_triangle { <-0.6272, -4.2845, 36.0093>, <-0.346, 0.658, 0.669>, <-0.3412, -2.2350, 34.7039>, <-0.246, 0.609, 0.754>, <-0.3181, -2.2392, 34.7136>, <0.226, 0.473, 0.852> }
	smooth_triangle { <-0.6272, -4.2845, 36.0093>, <-0.557, 0.646, 0.522>, <-0.3181, -2.2392, 34.7136>, <-0.075, 0.540, 0.838>, <-0.6045, -4.2808, 36.0200>, <0.105, 0.685, 0.721> }
	smooth_triangle { <-0.6045, -4.2808, 36.0200>, <0.633, 0.422, 0.649>, <-0.3181, -2.2392, 34.7136>, <0.362, 0.431, 0.827>, <-0.3033, -2.2574, 34.7039>, <0.931, -0.057, 0.360> }
	smooth_triangle { <-0.6045, -4.2808, 36.0200>, <0.264, 0.627, 0.733>, <-0.3033, -2.2574, 34.7039>, <0.806, 0.121, 0.579>, <-0.5837, -4.2905, 36.0093>, <0.893, 0.143, 0.426> }
	smooth_triangle { <-0.5837, -4.2905, 36.0093>, <0.967, -0.253, -0.025>, <-0.3033, -2.2574, 34.7039>, <0.955, -0.156, 0.251>, <-0.3116, -2.2714, 34.6844>, <0.695, -0.525, -0.491> }
	smooth_triangle { <-0.5837, -4.2905, 36.0093>, <0.953, 0.053, 0.297>, <-0.3116, -2.2714, 34.6844>, <0.867, -0.420, -0.268>, <-0.5855, -4.3039, 35.9878>, <0.786, -0.545, -0.292> }
	smooth_triangle { <-0.5855, -4.3039, 35.9878>, <0.345, -0.662, -0.666>, <-0.3116, -2.2714, 34.6844>, <0.582, -0.579, -0.570>, <-0.3347, -2.2672, 34.6746>, <-0.226, -0.473, -0.852> }
	smooth_triangle { <-0.5855, -4.3039, 35.9878>, <0.697, -0.574, -0.429>, <-0.3347, -2.2672, 34.6746>, <0.075, -0.539, -0.839>, <-0.6082, -4.3077, 35.9771>, <-0.107, -0.691, -0.715> }
	smooth_triangle { <-0.6082, -4.3077, 35.9771>, <-0.634, -0.427, -0.645>, <-0.3347, -2.2672, 34.6746>, <-0.363, -0.431, -0.826>, <-0.3495, -2.2490, 34.6844>, <-0.932, 0.057, -0.359> }
	smooth_triangle { <-0.6082, -4.3077, 35.9771>, <-0.266, -0.632, -0.728>, <-0.3495, -2.2490, 34.6844>, <-0.807, -0.121, -0.579>, <-0.6291, -4.2980, 35.9878>, <-0.895, -0.149, -0.421> }
	smooth_triangle { <-0.6291, -4.2980, 35.9878>, <-0.968, 0.248, 0.028>, <-0.3495, -2.2490, 34.6844>, <-0.956, 0.156, -0.250>, <-0.3412, -2.2350, 34.7039>, <-0.953, 0.291, 0.087> }
	smooth_triangle { <-0.6291, -4.2980, 35.9878>, <-0.954, -0.059, -0.292>, <-0.3412, -2.2350, 34.7039>, <-0.953, 0.291, 0.087>, <-0.6272, -4.2845, 36.0093>, <-0.990, 0.138, -0.001> }
	smooth_triangle { <-1.3417, -5.5316, 37.9668>, <-0.336, 0.843, 0.420>, <-0.6272, -4.2845, 36.0093>, <-0.557, 0.646, 0.522>, <-0.6045, -4.2808, 36.0200>, <0.105, 0.685, 0.721> }
	smooth_triangle { <-1.3417, -5.5316, 37.9668>, <0.596, 0.551, 0.585>, <-0.6045, -4.2808, 36.0200>, <0.264, 0.627, 0.733>, <-0.5837, -4.2905, 36.0093>, <0.893, 0.143, 0.426> }
	smooth_triangle { <-1.3417, -5.5316, 37.9668>, <0.933, -0.319, 0.164>, <-0.5837, -4.2905, 36.0093>, <0.953, 0.053, 0.297>, <-0.5855, -4.3039, 35.9878>, <0.786, -0.545, -0.292> }
	smooth_triangle { <-1.3417, -5.5316, 37.9668>, <0.329, -0.855, -0.400>, <-0.5855, -4.3039, 35.9878>, <0.697, -0.574, -0.429>, <-0.6082, -4.3077, 35.9771>, <-0.107, -0.691, -0.715> }
	smooth_triangle { <-1.3417, -5.5316, 37.9668>, <-0.599, -0.567, -0.565>, <-0.6082, -4.3077, 35.9771>, <-0.266, -0.632, -0.728>, <-0.6291, -4.2980, 35.9878>, <-0.895, -0.149, -0.421> }
	smooth_triangle { <-1.3417, -5.5316, 37.9668>, <-0.942, 0.302, -0.146>, <-0.6291, -4.2980, 35.9878>, <-0.954, -0.059, -0.292>, <-0.6272, -4.2845, 36.0093>, <-0.650, 0.652, 0.389> }
	smooth_triangle { <1.7578, -0.1731, 33.4547>, <-0.694, -0.091, 0.714>, <0.9663, 0.4472, 32.7654>, <-0.791, -0.007, 0.612>, <0.9742, 0.4689, 32.7759>, <-0.683, 0.256, 0.684> }
	smooth_triangle { <1.7578, -0.1731, 33.4547>, <-0.694, -0.091, 0.714>, <0.9742, 0.4689, 32.7759>, <-0.683, 0.256, 0.684>, <1.7657, -0.1514, 33.4652>, <-0.320, 0.491, 0.810> }
	smooth_triangle { <1.7657, -0.1514, 33.4652>, <-0.320, 0.491, 0.810>, <0.9742, 0.4689, 32.7759>, <-0.613, 0.331, 0.718>, <0.9934, 0.4818, 32.7654>, <0.062, 0.889, 0.454> }
	smooth_triangle { <1.7657, -0.1514, 33.4652>, <-0.320, 0.491, 0.810>, <0.9934, 0.4818, 32.7654>, <0.062, 0.889, 0.454>, <1.7849, -0.1385, 33.4547>, <0.437, 0.858, 0.270> }
	smooth_triangle { <1.7849, -0.1385, 33.4547>, <0.437, 0.858, 0.270>, <0.9934, 0.4818, 32.7654>, <0.062, 0.889, 0.454>, <1.0047, 0.4730, 32.7445>, <0.741, 0.631, -0.228> }
	smooth_triangle { <1.7849, -0.1385, 33.4547>, <0.437, 0.858, 0.270>, <1.0047, 0.4730, 32.7445>, <0.741, 0.631, -0.228>, <1.7962, -0.1474, 33.4338>, <0.758, 0.367, -0.540> }
	smooth_triangle { <1.7962, -0.1474, 33.4338>, <0.758, 0.367, -0.540>, <1.0047, 0.4730, 32.7445>, <0.741, 0.631, -0.228>, <0.9968, 0.4512, 32.7340>, <0.683, -0.256, -0.684> }
	smooth_triangle { <1.7962, -0.1474, 33.4338>, <0.758, 0.367, -0.540>, <0.9968, 0.4512, 32.7340>, <0.683, -0.256, -0.684>, <1.7883, -0.1691, 33.4233>, <0.320, -0.491, -0.810> }
	smooth_triangle { <1.7883, -0.1691, 33.4233>, <0.320, -0.491, -0.810>, <0.9968, 0.4512, 32.7340>, <0.613, -0.331, -0.717>, <0.9776, 0.4383, 32.7445>, <-0.062, -0.889, -0.454> }
	smooth_triangle { <1.7883, -0.1691, 33.4233>, <0.320, -0.491, -0.810>, <0.9776, 0.4383, 32.7445>, <-0.062, -0.889, -0.454>, <1.7691, -0.1820, 33.4338>, <-0.437, -0.858, -0.270> }
	smooth_triangle { <1.7691, -0.1820, 33.4338>, <-0.437, -0.858, -0.270>, <0.9776, 0.4383, 32.7445>, <-0.062, -0.889, -0.454>, <0.9663, 0.4472, 32.7654>, <-0.574, -0.819, -0.005> }
	smooth_triangle { <1.7691, -0.1820, 33.4338>, <-0.437, -0.858, -0.270>, <0.9663, 0.4472, 32.7654>, <-0.574, -0.819, -0.005>, <1.7578, -0.1731, 33.4547>, <-0.617, -0.787, 0.000> }
	smooth_triangle { <2.5528, -0.5830, 35.7171>, <-0.909, -0.032, 0.416>, <0.9663, 0.4472, 32.7654>, <-0.791, -0.007, 0.612>, <0.9742, 0.4689, 32.7759>, <-0.683, 0.256, 0.684> }
	smooth_triangle { <2.5528, -0.5830, 35.7171>, <-0.909, -0.032, 0.416>, <0.9742, 0.4689, 32.7759>, <-0.767, 0.140, 0.626>, <2.5523, -0.5580, 35.7218>, <-0.768, 0.444, 0.461> }
	smooth_triangle { <2.5523, -0.5580, 35.7218>, <-0.768, 0.444, 0.461>, <0.9742, 0.4689, 32.7759>, <-0.683, 0.256, 0.684>, <0.9934, 0.4818, 32.7654>, <0.062, 0.889, 0.454> }
	smooth_triangle { <2.5523, -0.5580, 35.7218>, <-0.768, 0.444, 0.461>, <0.9934, 0.4818, 32.7654>, <0.062, 0.889, 0.454>, <2.5729, -0.5439, 35.7171>, <0.058, 0.968, 0.245> }
	smooth_triangle { <2.5729, -0.5439, 35.7171>, <0.058, 0.968, 0.245>, <0.9934, 0.4818, 32.7654>, <0.062, 0.889, 0.454>, <1.0047, 0.4730, 32.7445>, <0.741, 0.631, -0.228> }
	smooth_triangle { <2.5729, -0.5439, 35.7171>, <0.058, 0.968, 0.245>, <1.0047, 0.4730, 32.7445>, <0.657, 0.739, -0.152>, <2.5939, -0.5546, 35.7078>, <0.770, 0.622, -0.145> }
	smooth_triangle { <2.5939, -0.5546, 35.7078>, <0.907, 0.247, -0.341>, <1.0047, 0.4730, 32.7445>, <0.781, 0.555, -0.286>, <0.9968, 0.4512, 32.7340>, <0.683, -0.256, -0.684> }
	smooth_triangle { <2.5939, -0.5546, 35.7078>, <0.827, 0.517, -0.220>, <0.9968, 0.4512, 32.7340>, <0.767, -0.140, -0.626>, <2.5943, -0.5796, 35.7031>, <0.768, -0.444, -0.462> }
	smooth_triangle { <2.5943, -0.5796, 35.7031>, <0.768, -0.444, -0.462>, <0.9968, 0.4512, 32.7340>, <0.683, -0.256, -0.684>, <0.9776, 0.4383, 32.7445>, <-0.062, -0.889, -0.454> }
	smooth_triangle { <2.5943, -0.5796, 35.7031>, <0.768, -0.444, -0.462>, <0.9776, 0.4383, 32.7445>, <-0.062, -0.889, -0.454>, <2.5738, -0.5938, 35.7078>, <-0.058, -0.968, -0.245> }
	smooth_triangle { <2.5738, -0.5938, 35.7078>, <-0.058, -0.968, -0.245>, <0.9776, 0.4383, 32.7445>, <-0.062, -0.889, -0.454>, <0.9663, 0.4472, 32.7654>, <-0.574, -0.819, -0.005> }
	smooth_triangle { <2.5738, -0.5938, 35.7078>, <-0.058, -0.968, -0.245>, <0.9663, 0.4472, 32.7654>, <-0.574, -0.819, -0.005>, <2.5528, -0.5830, 35.7171>, <-0.516, -0.856, -0.037> }
	smooth_triangle { <3.3135, -1.1437, 37.9637>, <-0.960, 0.035, 0.278>, <2.5528, -0.5830, 35.7171>, <-0.909, -0.032, 0.416>, <2.5523, -0.5580, 35.7218>, <-0.768, 0.444, 0.461> }
	smooth_triangle { <3.3135, -1.1437, 37.9637>, <-0.960, 0.035, 0.278>, <2.5523, -0.5580, 35.7218>, <-0.768, 0.444, 0.461>, <3.3172, -1.1190, 37.9686>, <-0.701, 0.611, 0.368> }
	smooth_triangle { <3.3172, -1.1190, 37.9686>, <-0.701, 0.611, 0.368>, <2.5523, -0.5580, 35.7218>, <-0.768, 0.444, 0.461>, <2.5729, -0.5439, 35.7171>, <0.058, 0.968, 0.245> }
	smooth_triangle { <3.3172, -1.1190, 37.9686>, <-0.701, 0.611, 0.368>, <2.5729, -0.5439, 35.7171>, <0.058, 0.968, 0.245>, <3.3397, -1.1083, 37.9637>, <0.236, 0.938, 0.254> }
	smooth_triangle { <3.3397, -1.1083, 37.9637>, <0.236, 0.938, 0.254>, <2.5729, -0.5439, 35.7171>, <0.058, 0.968, 0.245>, <2.5939, -0.5546, 35.7078>, <0.770, 0.622, -0.145> }
	smooth_triangle { <3.3397, -1.1083, 37.9637>, <0.236, 0.938, 0.254>, <2.5939, -0.5546, 35.7078>, <0.827, 0.517, -0.220>, <3.3585, -1.1222, 37.9538>, <0.938, 0.326, -0.115> }
	smooth_triangle { <3.3585, -1.1222, 37.9538>, <0.938, 0.326, -0.115>, <2.5939, -0.5546, 35.7078>, <0.827, 0.517, -0.220>, <2.5943, -0.5796, 35.7031>, <0.768, -0.444, -0.462> }
	smooth_triangle { <3.3585, -1.1222, 37.9538>, <0.938, 0.326, -0.115>, <2.5943, -0.5796, 35.7031>, <0.768, -0.444, -0.462>, <3.3548, -1.1469, 37.9489>, <0.701, -0.611, -0.369> }
	smooth_triangle { <3.3548, -1.1469, 37.9489>, <0.701, -0.611, -0.369>, <2.5943, -0.5796, 35.7031>, <0.768, -0.444, -0.462>, <2.5738, -0.5938, 35.7078>, <-0.058, -0.968, -0.245> }
	smooth_triangle { <3.3548, -1.1469, 37.9489>, <0.701, -0.611, -0.369>, <2.5738, -0.5938, 35.7078>, <-0.058, -0.968, -0.245>, <3.3324, -1.1576, 37.9538>, <-0.236, -0.938, -0.255> }
	smooth_triangle { <3.3324, -1.1576, 37.9538>, <-0.236, -0.938, -0.255>, <2.5738, -0.5938, 35.7078>, <-0.058, -0.968, -0.245>, <2.5528, -0.5830, 35.7171>, <-0.516, -0.856, -0.037> }
	smooth_triangle { <3.3324, -1.1576, 37.9538>, <-0.236, -0.938, -0.255>, <2.5528, -0.5830, 35.7171>, <-0.516, -0.856, -0.037>, <3.3135, -1.1437, 37.9637>, <-0.760, -0.646, -0.074> }
	smooth_triangle { <3.5852, -1.9151, 39.8177>, <-0.884, 0.195, 0.426>, <3.3135, -1.1437, 37.9637>, <-0.960, 0.035, 0.278>, <3.3172, -1.1190, 37.9686>, <-0.701, 0.611, 0.368> }
	smooth_triangle { <3.5852, -1.9151, 39.8177>, <-0.884, 0.195, 0.426>, <3.3172, -1.1190, 37.9686>, <-0.701, 0.611, 0.368>, <3.6022, -1.8969, 39.8229>, <-0.307, 0.864, 0.399> }
	smooth_triangle { <3.6022, -1.8969, 39.8229>, <-0.307, 0.864, 0.399>, <3.3172, -1.1190, 37.9686>, <-0.701, 0.611, 0.368>, <3.3397, -1.1083, 37.9637>, <0.236, 0.938, 0.254> }
	smooth_triangle { <3.6022, -1.8969, 39.8229>, <-0.307, 0.864, 0.399>, <3.3397, -1.1083, 37.9637>, <0.236, 0.938, 0.254>, <3.6267, -1.9006, 39.8177>, <0.627, 0.777, 0.055> }
	smooth_triangle { <3.6267, -1.9006, 39.8177>, <0.627, 0.777, 0.055>, <3.3397, -1.1083, 37.9637>, <0.236, 0.938, 0.254>, <3.3585, -1.1222, 37.9538>, <0.938, 0.326, -0.115> }
	smooth_triangle { <3.6267, -1.9006, 39.8177>, <0.627, 0.777, 0.055>, <3.3585, -1.1222, 37.9538>, <0.938, 0.326, -0.115>, <3.6344, -1.9225, 39.8073>, <0.937, -0.087, -0.338> }
	smooth_triangle { <3.6344, -1.9225, 39.8073>, <0.937, -0.087, -0.338>, <3.3585, -1.1222, 37.9538>, <0.938, 0.326, -0.115>, <3.3548, -1.1469, 37.9489>, <0.701, -0.611, -0.369> }
	smooth_triangle { <3.6344, -1.9225, 39.8073>, <0.937, -0.087, -0.338>, <3.3548, -1.1469, 37.9489>, <0.701, -0.611, -0.369>, <3.6174, -1.9407, 39.8021>, <0.310, -0.868, -0.389> }
	smooth_triangle { <3.6174, -1.9407, 39.8021>, <0.310, -0.868, -0.389>, <3.3548, -1.1469, 37.9489>, <0.701, -0.611, -0.369>, <3.3324, -1.1576, 37.9538>, <-0.236, -0.938, -0.255> }
	smooth_triangle { <3.6174, -1.9407, 39.8021>, <0.310, -0.868, -0.389>, <3.3324, -1.1576, 37.9538>, <-0.236, -0.938, -0.255>, <3.5928, -1.9370, 39.8073>, <-0.624, -0.780, -0.046> }
	smooth_triangle { <3.5928, -1.9370, 39.8073>, <-0.624, -0.780, -0.046>, <3.3324, -1.1576, 37.9538>, <-0.236, -0.938, -0.255>, <3.3135, -1.1437, 37.9637>, <-0.760, -0.646, -0.074> }
	smooth_triangle { <3.5928, -1.9370, 39.8073>, <-0.624, -0.780, -0.046>, <3.3135, -1.1437, 37.9637>, <-0.760, -0.646, -0.074>, <3.5852, -1.9151, 39.8177>, <-0.944, -0.329, 0.001> }
	smooth_triangle { <4.7099, -2.2325, 41.4919>, <-0.663, 0.510, 0.548>, <3.5852, -1.9151, 39.8177>, <-0.884, 0.195, 0.426>, <3.6022, -1.8969, 39.8229>, <-0.307, 0.864, 0.399> }
	smooth_triangle { <4.7099, -2.2325, 41.4919>, <0.135, 0.984, 0.114>, <3.6022, -1.8969, 39.8229>, <-0.307, 0.864, 0.399>, <3.6267, -1.9006, 39.8177>, <0.627, 0.777, 0.055> }
	smooth_triangle { <4.7099, -2.2325, 41.4919>, <0.787, 0.460, -0.411>, <3.6267, -1.9006, 39.8177>, <0.627, 0.777, 0.055>, <3.6344, -1.9225, 39.8073>, <0.937, -0.087, -0.338> }
	smooth_triangle { <4.7099, -2.2325, 41.4919>, <0.676, -0.521, -0.521>, <3.6344, -1.9225, 39.8073>, <0.937, -0.087, -0.338>, <3.6174, -1.9407, 39.8021>, <0.310, -0.868, -0.389> }
	smooth_triangle { <4.7099, -2.2325, 41.4919>, <-0.123, -0.989, -0.085>, <3.6174, -1.9407, 39.8021>, <0.310, -0.868, -0.389>, <3.5928, -1.9370, 39.8073>, <-0.624, -0.780, -0.046> }
	smooth_triangle { <4.7099, -2.2325, 41.4919>, <-0.771, -0.466, 0.435>, <3.5928, -1.9370, 39.8073>, <-0.624, -0.780, -0.046>, <3.5852, -1.9151, 39.8177>, <-0.884, 0.195, 0.426> }
	smooth_triangle { <0.3733, 0.3651, 31.0637>, <-0.428, 0.297, 0.853>, <0.8747, 1.8862, 30.7852>, <-0.459, 0.196, 0.867>, <0.8962, 1.8813, 30.7977>, <-0.153, 0.135, 0.979> }
	smooth_triangle { <0.3733, 0.3651, 31.0637>, <-0.428, 0.297, 0.853>, <0.8962, 1.8813, 30.7977>, <-0.153, 0.135, 0.979>, <0.3949, 0.3603, 31.0762>, <0.232, 0.101, 0.967> }
	smooth_triangle { <0.3949, 0.3603, 31.0762>, <0.232, 0.101, 0.967>, <0.8962, 1.8813, 30.7977>, <-0.153, 0.135, 0.979>, <0.9165, 1.8724, 30.7852>, <0.756, -0.112, 0.645> }
	smooth_triangle { <0.3949, 0.3603, 31.0762>, <0.232, 0.101, 0.967>, <0.9165, 1.8724, 30.7852>, <0.756, -0.112, 0.645>, <0.4151, 0.3513, 31.0637>, <0.915, -0.243, 0.323> }
	smooth_triangle { <0.4151, 0.3513, 31.0637>, <0.915, -0.243, 0.323>, <0.9165, 1.8724, 30.7852>, <0.756, -0.112, 0.645>, <0.9151, 1.8683, 30.7602>, <0.909, -0.247, -0.334> }
	smooth_triangle { <0.4151, 0.3513, 31.0637>, <0.915, -0.243, 0.323>, <0.9151, 1.8683, 30.7602>, <0.909, -0.247, -0.334>, <0.4137, 0.3472, 31.0386>, <0.683, -0.343, -0.645> }
	smooth_triangle { <0.4137, 0.3472, 31.0386>, <0.683, -0.343, -0.645>, <0.9151, 1.8683, 30.7602>, <0.909, -0.247, -0.334>, <0.8935, 1.8731, 30.7477>, <0.153, -0.135, -0.979> }
	smooth_triangle { <0.4137, 0.3472, 31.0386>, <0.683, -0.343, -0.645>, <0.8935, 1.8731, 30.7477>, <0.153, -0.135, -0.979>, <0.3922, 0.3520, 31.0261>, <-0.232, -0.101, -0.967> }
	smooth_triangle { <0.3922, 0.3520, 31.0261>, <-0.232, -0.101, -0.967>, <0.8935, 1.8731, 30.7477>, <0.153, -0.135, -0.979>, <0.8733, 1.8820, 30.7602>, <-0.756, 0.112, -0.645> }
	smooth_triangle { <0.3922, 0.3520, 31.0261>, <-0.232, -0.101, -0.967>, <0.8733, 1.8820, 30.7602>, <-0.756, 0.112, -0.645>, <0.3720, 0.3610, 31.0386>, <-0.915, 0.243, -0.323> }
	smooth_triangle { <0.3720, 0.3610, 31.0386>, <-0.915, 0.243, -0.323>, <0.8733, 1.8820, 30.7602>, <-0.756, 0.112, -0.645>, <0.8747, 1.8862, 30.7852>, <-0.973, 0.230, 0.010> }
	smooth_triangle { <0.3720, 0.3610, 31.0386>, <-0.915, 0.243, -0.323>, <0.8747, 1.8862, 30.7852>, <-0.973, 0.230, 0.010>, <0.3733, 0.3651, 31.0637>, <-0.950, 0.313, 0.000> }
	smooth_triangle { <0.2988, -2.0746, 30.8809>, <-0.475, 0.204, 0.856>, <0.8747, 1.8862, 30.7852>, <-0.459, 0.196, 0.867>, <0.8962, 1.8813, 30.7977>, <-0.153, 0.135, 0.979> }
	smooth_triangle { <0.2988, -2.0746, 30.8809>, <-0.475, 0.204, 0.856>, <0.8962, 1.8813, 30.7977>, <-0.153, 0.135, 0.979>, <0.3208, -2.0762, 30.8936>, <0.036, 0.185, 0.982> }
	smooth_triangle { <0.3208, -2.0762, 30.8936>, <0.036, 0.185, 0.982>, <0.8962, 1.8813, 30.7977>, <-0.153, 0.135, 0.979>, <0.9165, 1.8724, 30.7852>, <0.756, -0.112, 0.645> }
	smooth_triangle { <0.3208, -2.0762, 30.8936>, <0.036, 0.185, 0.982>, <0.9165, 1.8724, 30.7852>, <0.756, -0.112, 0.645>, <0.3428, -2.0759, 30.8809>, <0.871, -0.084, 0.484> }
	smooth_triangle { <0.3428, -2.0759, 30.8809>, <0.871, -0.084, 0.484>, <0.9165, 1.8724, 30.7852>, <0.756, -0.112, 0.645>, <0.9151, 1.8683, 30.7602>, <0.909, -0.247, -0.334> }
	smooth_triangle { <0.3428, -2.0759, 30.8809>, <0.871, -0.084, 0.484>, <0.9151, 1.8683, 30.7602>, <0.909, -0.247, -0.334>, <0.3428, -2.0740, 30.8556>, <0.827, -0.266, -0.495> }
	smooth_triangle { <0.3428, -2.0740, 30.8556>, <0.827, -0.266, -0.495>, <0.9151, 1.8683, 30.7602>, <0.909, -0.247, -0.334>, <0.8935, 1.8731, 30.7477>, <0.153, -0.135, -0.979> }
	smooth_triangle { <0.3428, -2.0740, 30.8556>, <0.827, -0.266, -0.495>, <0.8935, 1.8731, 30.7477>, <0.153, -0.135, -0.979>, <0.3209, -2.0724, 30.8429>, <-0.036, -0.184, -0.982> }
	smooth_triangle { <0.3209, -2.0724, 30.8429>, <-0.036, -0.184, -0.982>, <0.8935, 1.8731, 30.7477>, <0.153, -0.135, -0.979>, <0.8733, 1.8820, 30.7602>, <-0.756, 0.112, -0.645> }
	smooth_triangle { <0.3209, -2.0724, 30.8429>, <-0.036, -0.184, -0.982>, <0.8733, 1.8820, 30.7602>, <-0.756, 0.112, -0.645>, <0.2989, -2.0727, 30.8556>, <-0.871, 0.084, -0.484> }
	smooth_triangle { <0.2989, -2.0727, 30.8556>, <-0.871, 0.084, -0.484>, <0.8733, 1.8820, 30.7602>, <-0.756, 0.112, -0.645>, <0.8747, 1.8862, 30.7852>, <-0.973, 0.230, 0.010> }
	smooth_triangle { <0.2989, -2.0727, 30.8556>, <-0.871, 0.084, -0.484>, <0.8747, 1.8862, 30.7852>, <-0.973, 0.230, 0.010>, <0.2988, -2.0746, 30.8809>, <-0.965, 0.262, 0.010> }
	smooth_triangle { <-0.4290, -4.2628, 31.6394>, <-0.613, 0.336, 0.715>, <0.2988, -2.0746, 30.8809>, <-0.475, 0.204, 0.856>, <0.3208, -2.0762, 30.8936>, <0.036, 0.185, 0.982> }
	smooth_triangle { <-0.4290, -4.2628, 31.6394>, <-0.613, 0.336, 0.715>, <0.3208, -2.0762, 30.8936>, <0.036, 0.185, 0.982>, <-0.4068, -4.2660, 31.6514>, <0.209, 0.346, 0.914> }
	smooth_triangle { <-0.4068, -4.2660, 31.6514>, <0.209, 0.346, 0.914>, <0.3208, -2.0762, 30.8936>, <0.036, 0.185, 0.982>, <0.3428, -2.0759, 30.8809>, <0.871, -0.084, 0.484> }
	smooth_triangle { <-0.4068, -4.2660, 31.6514>, <0.209, 0.346, 0.914>, <0.3428, -2.0759, 30.8809>, <0.871, -0.084, 0.484>, <-0.3872, -4.2767, 31.6394>, <0.951, -0.015, 0.310> }
	smooth_triangle { <-0.3872, -4.2767, 31.6394>, <0.951, -0.015, 0.310>, <0.3428, -2.0759, 30.8809>, <0.871, -0.084, 0.484>, <0.3428, -2.0740, 30.8556>, <0.827, -0.266, -0.495> }
	smooth_triangle { <-0.3872, -4.2767, 31.6394>, <0.951, -0.015, 0.310>, <0.3428, -2.0740, 30.8556>, <0.827, -0.266, -0.495>, <-0.3897, -4.2842, 31.6152>, <0.725, -0.357, -0.589> }
	smooth_triangle { <-0.3897, -4.2842, 31.6152>, <0.725, -0.357, -0.589>, <0.3428, -2.0740, 30.8556>, <0.827, -0.266, -0.495>, <0.3209, -2.0724, 30.8429>, <-0.036, -0.184, -0.982> }
	smooth_triangle { <-0.3897, -4.2842, 31.6152>, <0.725, -0.357, -0.589>, <0.3209, -2.0724, 30.8429>, <-0.036, -0.184, -0.982>, <-0.4118, -4.2810, 31.6032>, <-0.211, -0.353, -0.911> }
	smooth_triangle { <-0.4118, -4.2810, 31.6032>, <-0.211, -0.353, -0.911>, <0.3209, -2.0724, 30.8429>, <-0.036, -0.184, -0.982>, <0.2989, -2.0727, 30.8556>, <-0.871, 0.084, -0.484> }
	smooth_triangle { <-0.4118, -4.2810, 31.6032>, <-0.211, -0.353, -0.911>, <0.2989, -2.0727, 30.8556>, <-0.871, 0.084, -0.484>, <-0.4315, -4.2703, 31.6152>, <-0.952, 0.009, -0.307> }
	smooth_triangle { <-0.4315, -4.2703, 31.6152>, <-0.952, 0.009, -0.307>, <0.2989, -2.0727, 30.8556>, <-0.871, 0.084, -0.484>, <0.2988, -2.0746, 30.8809>, <-0.965, 0.262, 0.010> }
	smooth_triangle { <-0.4315, -4.2703, 31.6152>, <-0.952, 0.009, -0.307>, <0.2988, -2.0746, 30.8809>, <-0.965, 0.262, 0.010>, <-0.4290, -4.2628, 31.6394>, <-0.949, 0.316, 0.000> }
	smooth_triangle { <-0.1705, -6.3720, 32.8460>, <-0.388, 0.418, 0.822>, <-0.4290, -4.2628, 31.6394>, <-0.613, 0.336, 0.715>, <-0.4068, -4.2660, 31.6514>, <0.209, 0.346, 0.914> }
	smooth_triangle { <-0.1705, -6.3720, 32.8460>, <0.608, 0.439, 0.662>, <-0.4068, -4.2660, 31.6514>, <0.209, 0.346, 0.914>, <-0.3872, -4.2767, 31.6394>, <0.951, -0.015, 0.310> }
	smooth_triangle { <-0.1705, -6.3720, 32.8460>, <0.990, 0.016, -0.141>, <-0.3872, -4.2767, 31.6394>, <0.951, -0.015, 0.310>, <-0.3897, -4.2842, 31.6152>, <0.725, -0.357, -0.589> }
	smooth_triangle { <-0.1705, -6.3720, 32.8460>, <0.385, -0.442, -0.810>, <-0.3897, -4.2842, 31.6152>, <0.725, -0.357, -0.589>, <-0.4118, -4.2810, 31.6032>, <-0.211, -0.353, -0.911> }
	smooth_triangle { <-0.1705, -6.3720, 32.8460>, <-0.607, -0.460, -0.648>, <-0.4118, -4.2810, 31.6032>, <-0.211, -0.353, -0.911>, <-0.4315, -4.2703, 31.6152>, <-0.952, 0.009, -0.307> }
	smooth_triangle { <-0.1705, -6.3720, 32.8460>, <-0.988, -0.039, 0.151>, <-0.4315, -4.2703, 31.6152>, <-0.952, 0.009, -0.307>, <-0.4290, -4.2628, 31.6394>, <-0.613, 0.336, 0.715> }
	smooth_triangle { <1.9867, 1.0347, 31.6336>, <-0.662, -0.130, 0.738>, <0.8764, 1.8636, 30.7835>, <-0.764, -0.045, 0.644>, <0.8842, 1.8852, 30.7943>, <-0.594, 0.282, 0.753> }
	smooth_triangle { <1.9867, 1.0347, 31.6336>, <-0.662, -0.130, 0.738>, <0.8842, 1.8852, 30.7943>, <-0.594, 0.282, 0.753>, <1.9946, 1.0563, 31.6445>, <-0.298, 0.459, 0.837> }
	smooth_triangle { <1.9946, 1.0563, 31.6445>, <-0.298, 0.459, 0.837>, <0.8842, 1.8852, 30.7943>, <-0.594, 0.282, 0.753>, <0.9027, 1.8988, 30.7835>, <0.198, 0.840, 0.505> }
	smooth_triangle { <1.9946, 1.0563, 31.6445>, <-0.298, 0.459, 0.837>, <0.9027, 1.8988, 30.7835>, <0.198, 0.840, 0.505>, <2.0131, 1.0699, 31.6336>, <0.428, 0.860, 0.279> }
	smooth_triangle { <2.0131, 1.0699, 31.6336>, <0.428, 0.860, 0.279>, <0.9027, 1.8988, 30.7835>, <0.198, 0.840, 0.505>, <0.9134, 1.8909, 30.7619>, <0.792, 0.558, -0.248> }
	smooth_triangle { <2.0131, 1.0699, 31.6336>, <0.428, 0.860, 0.279>, <0.9134, 1.8909, 30.7619>, <0.792, 0.558, -0.248>, <2.0237, 1.0620, 31.6120>, <0.727, 0.401, -0.558> }
	smooth_triangle { <2.0237, 1.0620, 31.6120>, <0.727, 0.401, -0.558>, <0.9134, 1.8909, 30.7619>, <0.792, 0.558, -0.248>, <0.9055, 1.8693, 30.7510>, <0.594, -0.282, -0.754> }
	smooth_triangle { <2.0237, 1.0620, 31.6120>, <0.727, 0.401, -0.558>, <0.9055, 1.8693, 30.7510>, <0.594, -0.282, -0.754>, <2.0159, 1.0404, 31.6012>, <0.298, -0.459, -0.837> }
	smooth_triangle { <2.0159, 1.0404, 31.6012>, <0.298, -0.459, -0.837>, <0.9055, 1.8693, 30.7510>, <0.594, -0.282, -0.754>, <0.8870, 1.8556, 30.7619>, <-0.198, -0.840, -0.505> }
	smooth_triangle { <2.0159, 1.0404, 31.6012>, <0.298, -0.459, -0.837>, <0.8870, 1.8556, 30.7619>, <-0.198, -0.840, -0.505>, <1.9974, 1.0267, 31.6120>, <-0.428, -0.860, -0.279> }
	smooth_triangle { <1.9974, 1.0267, 31.6120>, <-0.428, -0.860, -0.279>, <0.8870, 1.8556, 30.7619>, <-0.198, -0.840, -0.505>, <0.8764, 1.8636, 30.7835>, <-0.685, -0.728, 0.013> }
	smooth_triangle { <1.9974, 1.0267, 31.6120>, <-0.428, -0.860, -0.279>, <0.8764, 1.8636, 30.7835>, <-0.685, -0.728, 0.013>, <1.9867, 1.0347, 31.6336>, <-0.598, -0.801, 0.000> }
	smooth_triangle { <2.6182, -0.0808, 33.6954>, <-0.800, 0.243, 0.549>, <0.8764, 1.8636, 30.7835>, <-0.764, -0.045, 0.644>, <0.8842, 1.8852, 30.7943>, <-0.594, 0.282, 0.753> }
	smooth_triangle { <2.6182, -0.0808, 33.6954>, <-0.800, 0.243, 0.549>, <0.8842, 1.8852, 30.7943>, <-0.594, 0.282, 0.753>, <2.6321, -0.0606, 33.7022>, <-0.442, 0.671, 0.595> }
	smooth_triangle { <2.6321, -0.0606, 33.7022>, <-0.442, 0.671, 0.595>, <0.8842, 1.8852, 30.7943>, <-0.594, 0.282, 0.753>, <0.9027, 1.8988, 30.7835>, <0.198, 0.840, 0.505> }
	smooth_triangle { <2.6321, -0.0606, 33.7022>, <-0.442, 0.671, 0.595>, <0.9027, 1.8988, 30.7835>, <0.198, 0.840, 0.505>, <2.6565, -0.0591, 33.6954>, <0.495, 0.828, 0.263> }
	smooth_triangle { <2.6565, -0.0591, 33.6954>, <0.495, 0.828, 0.263>, <0.9027, 1.8988, 30.7835>, <0.198, 0.840, 0.505>, <0.9134, 1.8909, 30.7619>, <0.792, 0.558, -0.248> }
	smooth_triangle { <2.6565, -0.0591, 33.6954>, <0.495, 0.828, 0.263>, <0.9134, 1.8909, 30.7619>, <0.792, 0.558, -0.248>, <2.6671, -0.0779, 33.6819>, <0.931, 0.155, -0.330> }
	smooth_triangle { <2.6671, -0.0779, 33.6819>, <0.931, 0.155, -0.330>, <0.9134, 1.8909, 30.7619>, <0.792, 0.558, -0.248>, <0.9055, 1.8693, 30.7510>, <0.594, -0.282, -0.754> }
	smooth_triangle { <2.6671, -0.0779, 33.6819>, <0.931, 0.155, -0.330>, <0.9055, 1.8693, 30.7510>, <0.594, -0.282, -0.754>, <2.6533, -0.0981, 33.6752>, <0.442, -0.671, -0.595> }
	smooth_triangle { <2.6533, -0.0981, 33.6752>, <0.442, -0.671, -0.595>, <0.9055, 1.8693, 30.7510>, <0.594, -0.282, -0.754>, <0.8870, 1.8556, 30.7619>, <-0.198, -0.840, -0.505> }
	smooth_triangle { <2.6533, -0.0981, 33.6752>, <0.442, -0.671, -0.595>, <0.8870, 1.8556, 30.7619>, <-0.198, -0.840, -0.505>, <2.6288, -0.0995, 33.6819>, <-0.495, -0.828, -0.263> }
	smooth_triangle { <2.6288, -0.0995, 33.6819>, <-0.495, -0.828, -0.263>, <0.8870, 1.8556, 30.7619>, <-0.198, -0.840, -0.505>, <0.8764, 1.8636, 30.7835>, <-0.685, -0.728, 0.013> }
	smooth_triangle { <2.6288, -0.0995, 33.6819>, <-0.495, -0.828, -0.263>, <0.8764, 1.8636, 30.7835>, <-0.685, -0.728, 0.013>, <2.6182, -0.0808, 33.6954>, <-0.857, -0.514, 0.041> }
	smooth_triangle { <3.2608, -1.2150, 35.7562>, <-0.749, 0.319, 0.580>, <2.6182, -0.0808, 33.6954>, <-0.800, 0.243, 0.549>, <2.6321, -0.0606, 33.7022>, <-0.442, 0.671, 0.595> }
	smooth_triangle { <3.2608, -1.2150, 35.7562>, <-0.749, 0.319, 0.580>, <2.6321, -0.0606, 33.7022>, <-0.442, 0.671, 0.595>, <3.2747, -1.1948, 35.7630>, <-0.329, 0.590, 0.738> }
	smooth_triangle { <3.2747, -1.1948, 35.7630>, <-0.329, 0.590, 0.738>, <2.6321, -0.0606, 33.7022>, <-0.442, 0.671, 0.595>, <2.6565, -0.0591, 33.6954>, <0.495, 0.828, 0.263> }
	smooth_triangle { <3.2747, -1.1948, 35.7630>, <-0.329, 0.590, 0.738>, <2.6565, -0.0591, 33.6954>, <0.495, 0.828, 0.263>, <3.2991, -1.1933, 35.7562>, <0.621, 0.665, 0.415> }
	smooth_triangle { <3.2991, -1.1933, 35.7562>, <0.621, 0.665, 0.415>, <2.6565, -0.0591, 33.6954>, <0.495, 0.828, 0.263>, <2.6671, -0.0779, 33.6819>, <0.931, 0.155, -0.330> }
	smooth_triangle { <3.2991, -1.1933, 35.7562>, <0.621, 0.665, 0.415>, <2.6671, -0.0779, 33.6819>, <0.931, 0.155, -0.330>, <3.3097, -1.2119, 35.7426>, <0.945, 0.081, -0.316> }
	smooth_triangle { <3.3097, -1.2119, 35.7426>, <0.945, 0.081, -0.316>, <2.6671, -0.0779, 33.6819>, <0.931, 0.155, -0.330>, <2.6533, -0.0981, 33.6752>, <0.442, -0.671, -0.595> }
	smooth_triangle { <3.3097, -1.2119, 35.7426>, <0.945, 0.081, -0.316>, <2.6533, -0.0981, 33.6752>, <0.442, -0.671, -0.595>, <3.2958, -1.2321, 35.7359>, <0.329, -0.589, -0.739> }
	smooth_triangle { <3.2958, -1.2321, 35.7359>, <0.329, -0.589, -0.739>, <2.6533, -0.0981, 33.6752>, <0.442, -0.671, -0.595>, <2.6288, -0.0995, 33.6819>, <-0.495, -0.828, -0.263> }
	smooth_triangle { <3.2958, -1.2321, 35.7359>, <0.329, -0.589, -0.739>, <2.6288, -0.0995, 33.6819>, <-0.495, -0.828, -0.263>, <3.2714, -1.2336, 35.7426>, <-0.622, -0.664, -0.416> }
	smooth_triangle { <3.2714, -1.2336, 35.7426>, <-0.622, -0.664, -0.416>, <2.6288, -0.0995, 33.6819>, <-0.495, -0.828, -0.263>, <2.6182, -0.0808, 33.6954>, <-0.857, -0.514, 0.041> }
	smooth_triangle { <3.2714, -1.2336, 35.7426>, <-0.622, -0.664, -0.416>, <2.6182, -0.0808, 33.6954>, <-0.857, -0.514, 0.041>, <3.2608, -1.2150, 35.7562>, <-0.892, -0.451, -0.027> }
	smooth_triangle { <4.0111, -2.8710, 36.6742>, <-0.703, -0.093, 0.705>, <3.2608, -1.2150, 35.7562>, <-0.749, 0.319, 0.580>, <3.2747, -1.1948, 35.7630>, <-0.329, 0.590, 0.738> }
	smooth_triangle { <4.0111, -2.8710, 36.6742>, <-0.703, -0.093, 0.705>, <3.2747, -1.1948, 35.7630>, <-0.329, 0.590, 0.738>, <4.0288, -2.8568, 36.6856>, <-0.098, 0.440, 0.892> }
	smooth_triangle { <4.0288, -2.8568, 36.6856>, <-0.098, 0.440, 0.892>, <3.2747, -1.1948, 35.7630>, <-0.329, 0.590, 0.738>, <3.2991, -1.1933, 35.7562>, <0.621, 0.665, 0.415> }
	smooth_triangle { <4.0288, -2.8568, 36.6856>, <-0.098, 0.440, 0.892>, <3.2991, -1.1933, 35.7562>, <0.621, 0.665, 0.415>, <4.0512, -2.8529, 36.6742>, <0.711, 0.623, 0.327> }
	smooth_triangle { <4.0512, -2.8529, 36.6742>, <0.711, 0.623, 0.327>, <3.2991, -1.1933, 35.7562>, <0.621, 0.665, 0.415>, <3.3097, -1.2119, 35.7426>, <0.945, 0.081, -0.316> }
	smooth_triangle { <4.0512, -2.8529, 36.6742>, <0.711, 0.623, 0.327>, <3.3097, -1.2119, 35.7426>, <0.945, 0.081, -0.316>, <4.0559, -2.8633, 36.6515>, <0.797, 0.165, -0.581> }
	smooth_triangle { <4.0559, -2.8633, 36.6515>, <0.797, 0.165, -0.581>, <3.3097, -1.2119, 35.7426>, <0.945, 0.081, -0.316>, <3.2958, -1.2321, 35.7359>, <0.329, -0.589, -0.739> }
	smooth_triangle { <4.0559, -2.8633, 36.6515>, <0.797, 0.165, -0.581>, <3.2958, -1.2321, 35.7359>, <0.329, -0.589, -0.739>, <4.0382, -2.8776, 36.6402>, <0.102, -0.447, -0.889> }
	smooth_triangle { <4.0382, -2.8776, 36.6402>, <0.102, -0.447, -0.889>, <3.2958, -1.2321, 35.7359>, <0.329, -0.589, -0.739>, <3.2714, -1.2336, 35.7426>, <-0.622, -0.664, -0.416> }
	smooth_triangle { <4.0382, -2.8776, 36.6402>, <0.102, -0.447, -0.889>, <3.2714, -1.2336, 35.7426>, <-0.622, -0.664, -0.416>, <4.0158, -2.8814, 36.6515>, <-0.706, -0.630, -0.322> }
	smooth_triangle { <4.0158, -2.8814, 36.6515>, <-0.706, -0.630, -0.322>, <3.2714, -1.2336, 35.7426>, <-0.622, -0.664, -0.416>, <3.2608, -1.2150, 35.7562>, <-0.892, -0.451, -0.027> }
	smooth_triangle { <4.0158, -2.8814, 36.6515>, <-0.706, -0.630, -0.322>, <3.2608, -1.2150, 35.7562>, <-0.892, -0.451, -0.027>, <4.0111, -2.8710, 36.6742>, <-0.911, -0.413, 0.000> }
	smooth_triangle { <5.3050, -4.1982, 37.5235>, <-0.531, 0.016, 0.847>, <4.0111, -2.8710, 36.6742>, <-0.703, -0.093, 0.705>, <4.0288, -2.8568, 36.6856>, <-0.098, 0.440, 0.892> }
	smooth_triangle { <5.3050, -4.1982, 37.5235>, <0.234, 0.660, 0.714>, <4.0288, -2.8568, 36.6856>, <-0.098, 0.440, 0.892>, <4.0512, -2.8529, 36.6742>, <0.711, 0.623, 0.327> }
	smooth_triangle { <5.3050, -4.1982, 37.5235>, <0.768, 0.627, -0.128>, <4.0512, -2.8529, 36.6742>, <0.711, 0.623, 0.327>, <4.0559, -2.8633, 36.6515>, <0.797, 0.165, -0.581> }
	smooth_triangle { <5.3050, -4.1982, 37.5235>, <0.549, -0.040, -0.835>, <4.0559, -2.8633, 36.6515>, <0.797, 0.165, -0.581>, <4.0382, -2.8776, 36.6402>, <0.102, -0.447, -0.889> }
	smooth_triangle { <5.3050, -4.1982, 37.5235>, <-0.217, -0.683, -0.698>, <4.0382, -2.8776, 36.6402>, <0.102, -0.447, -0.889>, <4.0158, -2.8814, 36.6515>, <-0.706, -0.630, -0.322> }
	smooth_triangle { <5.3050, -4.1982, 37.5235>, <-0.749, -0.648, 0.141>, <4.0158, -2.8814, 36.6515>, <-0.706, -0.630, -0.322>, <4.0111, -2.8710, 36.6742>, <-0.703, -0.093, 0.705> }
	smooth_triangle { <1.6661, 1.5698, 32.1705>, <-0.868, -0.213, 0.448>, <0.8771, 1.8603, 30.7793>, <-0.945, -0.175, 0.277>, <0.8745, 1.8847, 30.7858>, <-0.919, 0.208, 0.334> }
	smooth_triangle { <1.6661, 1.5698, 32.1705>, <-0.868, -0.213, 0.448>, <0.8745, 1.8847, 30.7858>, <-0.919, 0.208, 0.334>, <1.6635, 1.5942, 32.1771>, <-0.723, 0.468, 0.508> }
	smooth_triangle { <1.6635, 1.5942, 32.1771>, <-0.723, 0.468, 0.508>, <0.8745, 1.8847, 30.7858>, <-0.919, 0.208, 0.334>, <0.8923, 1.9016, 30.7793>, <-0.258, 0.949, 0.184> }
	smooth_triangle { <1.6635, 1.5942, 32.1771>, <-0.723, 0.468, 0.508>, <0.8923, 1.9016, 30.7793>, <-0.258, 0.949, 0.184>, <1.6813, 1.6111, 32.1705>, <0.064, 0.984, 0.169> }
	smooth_triangle { <1.6813, 1.6111, 32.1705>, <0.064, 0.984, 0.169>, <0.8923, 1.9016, 30.7793>, <-0.258, 0.949, 0.184>, <0.9127, 1.8941, 30.7661>, <0.660, 0.737, -0.144> }
	smooth_triangle { <1.6813, 1.6111, 32.1705>, <0.064, 0.984, 0.169>, <0.9127, 1.8941, 30.7661>, <0.660, 0.737, -0.144>, <1.7017, 1.6036, 32.1574>, <0.787, 0.516, -0.339> }
	smooth_triangle { <1.7017, 1.6036, 32.1574>, <0.787, 0.516, -0.339>, <0.9127, 1.8941, 30.7661>, <0.660, 0.737, -0.144>, <0.9153, 1.8697, 30.7596>, <0.923, -0.209, -0.324> }
	smooth_triangle { <1.7017, 1.6036, 32.1574>, <0.787, 0.516, -0.339>, <0.9153, 1.8697, 30.7596>, <0.923, -0.209, -0.324>, <1.7043, 1.5792, 32.1508>, <0.723, -0.468, -0.508> }
	smooth_triangle { <1.7043, 1.5792, 32.1508>, <0.723, -0.468, -0.508>, <0.9153, 1.8697, 30.7596>, <0.923, -0.209, -0.324>, <0.8975, 1.8528, 30.7661>, <0.262, -0.949, -0.173> }
	smooth_triangle { <1.7043, 1.5792, 32.1508>, <0.723, -0.468, -0.508>, <0.8975, 1.8528, 30.7661>, <0.262, -0.949, -0.173>, <1.6865, 1.5623, 32.1574>, <-0.064, -0.984, -0.169> }
	smooth_triangle { <1.6865, 1.5623, 32.1574>, <-0.064, -0.984, -0.169>, <0.8975, 1.8528, 30.7661>, <0.262, -0.949, -0.173>, <0.8771, 1.8603, 30.7793>, <-0.321, -0.946, 0.042> }
	smooth_triangle { <1.6865, 1.5623, 32.1574>, <-0.064, -0.984, -0.169>, <0.8771, 1.8603, 30.7793>, <-0.321, -0.946, 0.042>, <1.6661, 1.5698, 32.1705>, <-0.345, -0.938, 0.000> }
	smooth_triangle { <1.1833, 2.2381, 34.4600>, <-0.987, -0.131, 0.096>, <0.8771, 1.8603, 30.7793>, <-0.945, -0.175, 0.277>, <0.8745, 1.8847, 30.7858>, <-0.919, 0.208, 0.334> }
	smooth_triangle { <1.1833, 2.2381, 34.4600>, <0.922, -0.386, -0.030>, <0.8745, 1.8847, 30.7858>, <0.921, -0.388, -0.040>, <1.1738, 2.2150, 34.4643>, <0.502, -0.863, 0.056> }
	smooth_triangle { <1.1738, 2.2150, 34.4643>, <-0.690, 0.724, -0.009>, <0.8745, 1.8847, 30.7858>, <-0.919, 0.208, 0.334>, <0.8923, 1.9016, 30.7793>, <-0.258, 0.949, 0.184> }
	smooth_triangle { <1.1738, 2.2150, 34.4643>, <0.502, -0.863, 0.056>, <0.8923, 1.9016, 30.7793>, <0.171, -0.983, 0.070>, <1.1492, 2.2104, 34.4600>, <-0.368, -0.922, 0.121> }
	smooth_triangle { <1.1492, 2.2104, 34.4600>, <0.286, 0.953, -0.100>, <0.8923, 1.9016, 30.7793>, <-0.258, 0.949, 0.184>, <0.9127, 1.8941, 30.7661>, <0.660, 0.737, -0.144> }
	smooth_triangle { <1.1492, 2.2104, 34.4600>, <-0.501, -0.856, 0.126>, <0.9127, 1.8941, 30.7661>, <-0.795, -0.598, 0.102>, <1.1342, 2.2289, 34.4513>, <-0.998, 0.022, 0.062> }
	smooth_triangle { <1.1342, 2.2289, 34.4513>, <0.990, 0.125, -0.071>, <0.9127, 1.8941, 30.7661>, <0.660, 0.737, -0.144>, <0.9153, 1.8697, 30.7596>, <0.923, -0.209, -0.324> }
	smooth_triangle { <1.1342, 2.2289, 34.4513>, <-0.998, 0.022, 0.062>, <0.9153, 1.8697, 30.7596>, <-0.923, 0.384, 0.017>, <1.1437, 2.2520, 34.4469>, <-0.502, 0.862, -0.067> }
	smooth_triangle { <1.1437, 2.2520, 34.4469>, <0.694, -0.719, 0.032>, <0.9153, 1.8697, 30.7596>, <0.923, -0.209, -0.324>, <0.8975, 1.8528, 30.7661>, <0.262, -0.949, -0.173> }
	smooth_triangle { <1.1437, 2.2520, 34.4469>, <-0.502, 0.862, -0.067>, <0.8975, 1.8528, 30.7661>, <-0.167, 0.981, -0.095>, <1.1683, 2.2566, 34.4513>, <0.371, 0.919, -0.134> }
	smooth_triangle { <1.1683, 2.2566, 34.4513>, <-0.271, -0.954, 0.125>, <0.8975, 1.8528, 30.7661>, <0.262, -0.949, -0.173>, <0.8771, 1.8603, 30.7793>, <-0.321, -0.946, 0.042> }
	smooth_triangle { <1.1683, 2.2566, 34.4513>, <0.503, 0.853, -0.137>, <0.8771, 1.8603, 30.7793>, <0.798, 0.589, -0.127>, <1.1833, 2.2381, 34.4600>, <0.960, 0.260, -0.101> }
	smooth_triangle { <1.3469, 2.5070, 36.8715>, <0.356, -0.931, 0.086>, <1.1833, 2.2381, 34.4600>, <0.922, -0.386, -0.030>, <1.1738, 2.2150, 34.4643>, <0.502, -0.863, 0.056> }
	smooth_triangle { <1.3469, 2.5070, 36.8715>, <0.356, -0.931, 0.086>, <1.1738, 2.2150, 34.4643>, <0.502, -0.863, 0.056>, <1.3216, 2.5074, 36.8732>, <-0.369, -0.927, 0.067> }
	smooth_triangle { <1.3216, 2.5074, 36.8732>, <-0.203, -0.970, 0.132>, <1.1738, 2.2150, 34.4643>, <0.502, -0.863, 0.056>, <1.1492, 2.2104, 34.4600>, <-0.501, -0.856, 0.126> }
	smooth_triangle { <1.3216, 2.5074, 36.8732>, <-0.369, -0.927, 0.067>, <1.1492, 2.2104, 34.4600>, <-0.650, -0.749, 0.131>, <1.3091, 2.5295, 36.8715>, <-0.989, -0.140, -0.050> }
	smooth_triangle { <1.3091, 2.5295, 36.8715>, <-0.989, -0.140, -0.050>, <1.1492, 2.2104, 34.4600>, <-0.501, -0.856, 0.126>, <1.1342, 2.2289, 34.4513>, <-0.998, 0.022, 0.062> }
	smooth_triangle { <1.3091, 2.5295, 36.8715>, <-0.989, -0.140, -0.050>, <1.1342, 2.2289, 34.4513>, <-0.998, 0.022, 0.062>, <1.3219, 2.5511, 36.8679>, <-0.612, 0.784, -0.109> }
	smooth_triangle { <1.3219, 2.5511, 36.8679>, <-0.612, 0.784, -0.109>, <1.1342, 2.2289, 34.4513>, <-0.998, 0.022, 0.062>, <1.1437, 2.2520, 34.4469>, <-0.502, 0.862, -0.067> }
	smooth_triangle { <1.3219, 2.5511, 36.8679>, <-0.612, 0.784, -0.109>, <1.1437, 2.2520, 34.4469>, <-0.502, 0.862, -0.067>, <1.3473, 2.5507, 36.8661>, <0.368, 0.928, -0.050> }
	smooth_triangle { <1.3473, 2.5507, 36.8661>, <0.204, 0.971, -0.122>, <1.1437, 2.2520, 34.4469>, <-0.502, 0.862, -0.067>, <1.1683, 2.2566, 34.4513>, <0.503, 0.853, -0.137> }
	smooth_triangle { <1.3473, 2.5507, 36.8661>, <0.368, 0.928, -0.050>, <1.1683, 2.2566, 34.4513>, <0.651, 0.747, -0.138>, <1.3598, 2.5286, 36.8679>, <0.988, 0.142, 0.066> }
	smooth_triangle { <1.3598, 2.5286, 36.8679>, <0.988, 0.142, 0.066>, <1.1683, 2.2566, 34.4513>, <0.503, 0.853, -0.137>, <1.1833, 2.2381, 34.4600>, <0.960, 0.260, -0.101> }
	smooth_triangle { <1.3598, 2.5286, 36.8679>, <0.988, 0.142, 0.066>, <1.1833, 2.2381, 34.4600>, <0.960, 0.260, -0.101>, <1.3469, 2.5070, 36.8715>, <0.860, -0.485, 0.159> }
	smooth_triangle { <0.7735, 2.7443, 38.8110>, <-0.009, -0.993, 0.119>, <1.3469, 2.5070, 36.8715>, <0.356, -0.931, 0.086>, <1.3216, 2.5074, 36.8732>, <-0.369, -0.927, 0.067> }
	smooth_triangle { <0.7735, 2.7443, 38.8110>, <0.875, 0.484, 0.005>, <1.3216, 2.5074, 36.8732>, <0.948, 0.204, 0.243>, <0.7779, 2.7196, 38.8148>, <0.927, -0.324, 0.187> }
	smooth_triangle { <0.7779, 2.7196, 38.8148>, <-0.849, -0.496, -0.184>, <1.3216, 2.5074, 36.8732>, <-0.504, -0.862, 0.052>, <1.3091, 2.5295, 36.8715>, <-0.989, -0.140, -0.050> }
	smooth_triangle { <0.7779, 2.7196, 38.8148>, <0.927, -0.324, 0.187>, <1.3091, 2.5295, 36.8715>, <0.624, -0.742, 0.243>, <0.7593, 2.7027, 38.8110>, <0.164, -0.969, 0.184> }
	smooth_triangle { <0.7593, 2.7027, 38.8110>, <-0.845, 0.456, -0.280>, <1.3091, 2.5295, 36.8715>, <-0.989, -0.140, -0.050>, <1.3219, 2.5511, 36.8679>, <-0.612, 0.784, -0.109> }
	smooth_triangle { <0.7593, 2.7027, 38.8110>, <0.164, -0.969, 0.184>, <1.3219, 2.5511, 36.8679>, <-0.318, -0.948, -0.018>, <0.7364, 2.7105, 38.8033>, <-0.764, -0.646, -0.008> }
	smooth_triangle { <0.7364, 2.7105, 38.8033>, <0.011, 0.997, -0.079>, <1.3219, 2.5511, 36.8679>, <-0.612, 0.784, -0.109>, <1.3473, 2.5507, 36.8661>, <0.368, 0.928, -0.050> }
	smooth_triangle { <0.7364, 2.7105, 38.8033>, <-0.764, -0.646, -0.008>, <1.3473, 2.5507, 36.8661>, <-0.938, -0.207, -0.279>, <0.7320, 2.7353, 38.7995>, <-0.926, 0.324, -0.196> }
	smooth_triangle { <0.7320, 2.7353, 38.7995>, <0.841, 0.494, 0.220>, <1.3473, 2.5507, 36.8661>, <0.503, 0.863, -0.030>, <1.3598, 2.5286, 36.8679>, <0.988, 0.142, 0.066> }
	smooth_triangle { <0.7320, 2.7353, 38.7995>, <-0.926, 0.324, -0.196>, <1.3598, 2.5286, 36.8679>, <-0.614, 0.739, -0.279>, <0.7506, 2.7522, 38.8033>, <-0.161, 0.968, -0.192> }
	smooth_triangle { <0.7506, 2.7522, 38.8033>, <0.838, -0.446, 0.315>, <1.3598, 2.5286, 36.8679>, <0.988, 0.142, 0.066>, <1.3469, 2.5070, 36.8715>, <0.860, -0.485, 0.159> }
	smooth_triangle { <0.7506, 2.7522, 38.8033>, <-0.161, 0.968, -0.192>, <1.3469, 2.5070, 36.8715>, <0.329, 0.944, -0.018>, <0.7735, 2.7443, 38.8110>, <0.329, 0.944, -0.018> }
	smooth_triangle { <0.7539, 3.1911, 40.7856>, <0.987, 0.161, -0.021>, <0.7735, 2.7443, 38.8110>, <0.875, 0.484, 0.005>, <0.7779, 2.7196, 38.8148>, <0.927, -0.324, 0.187> }
	smooth_triangle { <0.7539, 3.1911, 40.7856>, <0.632, -0.750, 0.193>, <0.7779, 2.7196, 38.8148>, <0.927, -0.324, 0.187>, <0.7593, 2.7027, 38.8110>, <0.164, -0.969, 0.184> }
	smooth_triangle { <0.7539, 3.1911, 40.7856>, <-0.363, -0.904, 0.228>, <0.7593, 2.7027, 38.8110>, <0.164, -0.969, 0.184>, <0.7364, 2.7105, 38.8033>, <-0.764, -0.646, -0.008> }
	smooth_triangle { <0.7539, 3.1911, 40.7856>, <-0.987, -0.155, 0.052>, <0.7364, 2.7105, 38.8033>, <-0.764, -0.646, -0.008>, <0.7320, 2.7353, 38.7995>, <-0.926, 0.324, -0.196> }
	smooth_triangle { <0.7539, 3.1911, 40.7856>, <-0.636, 0.754, -0.161>, <0.7320, 2.7353, 38.7995>, <-0.926, 0.324, -0.196>, <0.7506, 2.7522, 38.8033>, <-0.161, 0.968, -0.192> }
	smooth_triangle { <0.7539, 3.1911, 40.7856>, <0.360, 0.912, -0.197>, <0.7506, 2.7522, 38.8033>, <-0.161, 0.968, -0.192>, <0.7735, 2.7443, 38.8110>, <0.875, 0.484, 0.005> }

	texture { PSWL_BARK }
}

/* Object 'PWL0010F' */
union {
	smooth_triangle { <0.8428, 2.8354, 29.7214>, <0.676, -0.609, -0.415>, <0.4275, 2.7092, 29.2483>, <0.678, -0.591, -0.438>, <0.0045, 2.2682, 29.1880>, <0.676, -0.609, -0.415> }
	smooth_triangle { <0.0045, 2.2682, 29.1880>, <0.676, -0.609, -0.415>, <0.4314, 2.4177, 29.6832>, <0.673, -0.627, -0.391>, <0.8428, 2.8354, 29.7214>, <0.676, -0.609, -0.415> }
	smooth_triangle { <0.9391, 1.8560, 30.7517>, <0.555, 0.495, 0.669>, <1.3834, 1.8529, 30.4015>, <0.551, 0.461, 0.695>, <1.8462, 1.4199, 30.3220>, <0.555, 0.495, 0.669> }
	smooth_triangle { <1.8462, 1.4199, 30.3220>, <0.555, 0.495, 0.669>, <1.3888, 1.4482, 30.6967>, <0.557, 0.528, 0.641>, <0.9391, 1.8560, 30.7517>, <0.555, 0.495, 0.669> }
	smooth_triangle { <0.9125, 1.1310, 31.7382>, <0.854, -0.446, -0.267>, <0.6444, 0.8445, 31.2602>, <0.846, -0.505, -0.172>, <0.3779, 0.4039, 31.2428>, <0.854, -0.446, -0.267> }
	smooth_triangle { <0.3779, 0.4039, 31.2428>, <0.854, -0.446, -0.267>, <0.6584, 0.6247, 31.6732>, <0.852, -0.381, -0.359>, <0.9125, 1.1310, 31.7382>, <0.854, -0.446, -0.267> }
	smooth_triangle { <1.0326, 0.4409, 32.7391>, <0.467, 0.681, 0.564>, <1.6378, 0.4111, 32.2962>, <0.467, 0.655, 0.594>, <2.2891, -0.0708, 32.3158>, <0.467, 0.681, 0.564> }
	smooth_triangle { <2.2891, -0.0708, 32.3158>, <0.467, 0.681, 0.564>, <1.6647, -0.0094, 32.7822>, <0.467, 0.706, 0.532>, <1.0326, 0.4409, 32.7391>, <0.467, 0.681, 0.564> }
	smooth_triangle { <0.9896, -0.2569, 33.7425>, <0.434, -0.739, -0.515>, <0.4377, -0.3223, 33.3911>, <0.432, -0.718, -0.545>, <-0.1055, -0.7163, 33.4792>, <0.434, -0.739, -0.515> }
	smooth_triangle { <-0.1055, -0.7163, 33.4792>, <0.434, -0.739, -0.515>, <0.4604, -0.6263, 33.8469>, <0.435, -0.760, -0.484>, <0.9896, -0.2569, 33.7425>, <0.434, -0.739, -0.515> }
	smooth_triangle { <1.1378, -0.9512, 34.7383>, <0.430, 0.726, 0.537>, <1.6928, -1.0080, 34.3197>, <0.426, 0.780, 0.459>, <2.2865, -1.3708, 34.3857>, <0.430, 0.726, 0.537> }
	smooth_triangle { <2.2865, -1.3708, 34.3857>, <0.430, 0.726, 0.537>, <1.7191, -1.3592, 34.7735>, <0.430, 0.666, 0.610>, <1.1378, -0.9512, 34.7383>, <0.430, 0.726, 0.537> }
	smooth_triangle { <1.1783, -1.2424, 35.5016>, <0.565, -0.750, -0.343>, <0.7167, -1.4615, 35.2446>, <0.560, -0.738, -0.376>, <0.3212, -1.8539, 35.4260>, <0.565, -0.750, -0.343> }
	smooth_triangle { <0.3212, -1.8539, 35.4260>, <0.565, -0.750, -0.343>, <0.7879, -1.6116, 35.6907>, <0.570, -0.761, -0.309>, <1.1783, -1.2424, 35.5016>, <0.565, -0.750, -0.343> }
	smooth_triangle { <1.4045, -1.4985, 36.2455>, <0.252, 0.886, 0.389>, <1.8730, -1.4843, 35.9008>, <0.251, 0.892, 0.377>, <2.4580, -1.6869, 35.9912>, <0.252, 0.886, 0.389> }
	smooth_triangle { <2.4580, -1.6869, 35.9912>, <0.252, 0.886, 0.389>, <1.9779, -1.7053, 36.3364>, <0.254, 0.880, 0.400>, <1.4045, -1.4985, 36.2455>, <0.252, 0.886, 0.389> }
	smooth_triangle { <1.2908, -2.0397, 36.8798>, <0.963, -0.174, -0.204>, <1.1854, -2.3717, 36.5387>, <0.973, -0.213, -0.093>, <1.0481, -3.0106, 36.5637>, <0.963, -0.174, -0.204> }
	smooth_triangle { <1.0481, -3.0106, 36.5637>, <0.963, -0.174, -0.204>, <1.1908, -2.7364, 36.8769>, <0.941, -0.134, -0.312>, <1.2908, -2.0397, 36.8798>, <0.963, -0.174, -0.204> }
	smooth_triangle { <1.2962, -2.5170, 37.5169>, <0.576, 0.626, 0.525>, <1.8346, -2.6505, 37.0827>, <0.577, 0.629, 0.522>, <2.3453, -3.1366, 37.1041>, <0.576, 0.626, 0.525> }
	smooth_triangle { <2.3453, -3.1366, 37.1041>, <0.576, 0.626, 0.525>, <1.7945, -2.9991, 37.5419>, <0.576, 0.623, 0.529>, <1.2962, -2.5170, 37.5169>, <0.576, 0.626, 0.525> }
	smooth_triangle { <0.7586, -0.0837, 32.9200>, <0.328, -0.443, -0.834>, <0.2701, 0.2855, 32.5767>, <0.365, -0.328, -0.872>, <-0.4142, 0.1060, 32.3577>, <0.328, -0.443, -0.834> }
	smooth_triangle { <-0.4142, 0.1060, 32.3577>, <0.328, -0.443, -0.834>, <0.0989, -0.2410, 32.7898>, <0.286, -0.552, -0.783>, <0.7586, -0.0837, 32.9200>, <0.328, -0.443, -0.834> }
	smooth_triangle { <0.6757, -0.6621, 33.1211>, <0.277, 0.238, 0.931>, <1.1369, -0.6424, 32.9659>, <0.294, 0.292, 0.910>, <1.4939, -0.9830, 32.9598>, <0.277, 0.238, 0.931> }
	smooth_triangle { <1.4939, -0.9830, 32.9598>, <0.277, 0.238, 0.931>, <1.0188, -1.0055, 33.0937>, <0.259, 0.183, 0.948>, <0.6757, -0.6621, 33.1211>, <0.277, 0.238, 0.931> }
	smooth_triangle { <0.1016, -1.4282, 33.9032>, <-0.112, -0.630, -0.768>, <-0.4011, -0.9712, 33.5804>, <-0.132, -0.664, -0.736>, <-1.1619, -0.9127, 33.6638>, <-0.112, -0.630, -0.768> }
	smooth_triangle { <-1.1619, -0.9127, 33.6638>, <-0.112, -0.630, -0.768>, <-0.6522, -1.3952, 33.9645>, <-0.091, -0.594, -0.799>, <0.1016, -1.4282, 33.9032>, <-0.112, -0.630, -0.768> }
	smooth_triangle { <-0.2948, -2.2912, 34.6742>, <0.717, 0.256, 0.648>, <0.2327, -2.5903, 34.1929>, <0.729, 0.277, 0.626>, <0.5396, -3.2960, 34.1481>, <0.717, 0.256, 0.648> }
	smooth_triangle { <0.5396, -3.2960, 34.1481>, <0.717, 0.256, 0.648>, <-0.0074, -2.9959, 34.6186>, <0.705, 0.235, 0.670>, <-0.2948, -2.2912, 34.6742>, <0.717, 0.256, 0.648> }
	smooth_triangle { <-0.4979, -3.2937, 35.3083>, <0.806, -0.297, -0.512>, <-0.8326, -3.2592, 34.7534>, <0.806, -0.309, -0.505>, <-1.2520, -3.7718, 34.3983>, <0.806, -0.297, -0.512> }
	smooth_triangle { <-1.2520, -3.7718, 34.3983>, <0.806, -0.297, -0.512>, <-0.9079, -3.8080, 34.9526>, <0.806, -0.284, -0.519>, <-0.4979, -3.2937, 35.3083>, <0.806, -0.297, -0.512> }
	smooth_triangle { <-0.5738, -4.3201, 35.9651>, <0.761, 0.140, 0.633>, <-0.1026, -4.3566, 35.4077>, <0.761, 0.138, 0.634>, <0.2974, -5.0114, 35.0703>, <0.761, 0.140, 0.633> }
	smooth_triangle { <0.2974, -5.0114, 35.0703>, <0.761, 0.140, 0.633>, <-0.1859, -4.9639, 35.6423>, <0.762, 0.142, 0.632>, <-0.5738, -4.3201, 35.9651>, <0.761, 0.140, 0.633> }
	smooth_triangle { <-1.0270, -4.9062, 36.9818>, <-0.095, -0.823, -0.559>, <-1.5732, -4.6769, 36.7362>, <-0.095, -0.825, -0.558>, <-2.3142, -4.7431, 36.9607>, <-0.095, -0.823, -0.559> }
	smooth_triangle { <-2.3142, -4.7431, 36.9607>, <-0.095, -0.823, -0.559>, <-1.7499, -4.9754, 37.2056>, <-0.095, -0.822, -0.561>, <-1.0270, -4.9062, 36.9818>, <-0.095, -0.823, -0.559> }
	smooth_triangle { <-1.2991, -5.5528, 37.9427>, <0.598, 0.599, 0.532>, <-0.6472, -5.6785, 37.3550>, <0.599, 0.594, 0.537>, <-0.1689, -6.1154, 37.3051>, <0.598, 0.599, 0.532> }
	smooth_triangle { <-0.1689, -6.1154, 37.3051>, <0.598, 0.599, 0.532>, <-0.8363, -5.9792, 37.9058>, <0.598, 0.603, 0.528>, <-1.2991, -5.5528, 37.9427>, <0.598, 0.599, 0.532> }
	smooth_triangle { <1.3486, 0.1077, 33.0991>, <0.453, -0.340, -0.824>, <0.7985, -0.2306, 32.9366>, <0.452, -0.340, -0.825>, <0.5972, -0.8644, 33.0872>, <0.453, -0.340, -0.824> }
	smooth_triangle { <0.5972, -0.8644, 33.0872>, <0.453, -0.340, -0.824>, <1.1576, -0.5121, 33.2504>, <0.454, -0.341, -0.823>, <1.3486, 0.1077, 33.0991>, <0.453, -0.340, -0.824> }
	smooth_triangle { <1.8148, -0.1243, 33.4331>, <-0.250, 0.517, 0.819>, <2.1074, 0.5085, 33.0997>, <-0.288, 0.547, 0.786>, <2.8240, 0.8335, 33.1363>, <-0.250, 0.517, 0.819> }
	smooth_triangle { <2.8240, 0.8335, 33.1363>, <-0.250, 0.517, 0.819>, <2.5347, 0.1735, 33.4416>, <-0.211, 0.485, 0.849>, <1.8148, -0.1243, 33.4331>, <-0.250, 0.517, 0.819> }
	smooth_triangle { <2.1664, -0.4168, 34.5720>, <0.956, -0.128, -0.265>, <2.0206, -0.8661, 34.3001>, <0.944, -0.120, -0.307>, <2.0027, -1.3960, 34.4531>, <0.956, -0.128, -0.265> }
	smooth_triangle { <2.0027, -1.3960, 34.4531>, <0.956, -0.128, -0.265>, <2.1334, -0.9240, 34.7345>, <0.965, -0.134, -0.223>, <2.1664, -0.4168, 34.5720>, <0.956, -0.128, -0.265> }
	smooth_triangle { <2.6064, -0.5271, 35.7084>, <-0.724, 0.606, 0.328>, <2.9284, 0.0199, 35.3754>, <-0.735, 0.611, 0.293>, <3.4203, 0.5002, 35.6077>, <-0.724, 0.606, 0.328> }
	smooth_triangle { <3.4203, 0.5002, 35.6077>, <-0.724, 0.606, 0.328>, <3.1053, -0.0709, 35.9338>, <-0.713, 0.600, 0.363>, <2.6064, -0.5271, 35.7084>, <-0.724, 0.606, 0.328> }
	smooth_triangle { <2.9529, -0.9027, 36.8232>, <0.931, 0.054, -0.361>, <2.8442, -1.3600, 36.4776>, <0.929, 0.055, -0.365>, <2.9160, -1.9662, 36.5686>, <0.931, 0.054, -0.361> }
	smooth_triangle { <2.9160, -1.9662, 36.5686>, <0.931, 0.054, -0.361>, <3.0231, -1.4923, 36.9190>, <0.933, 0.053, -0.357>, <2.9529, -0.9027, 36.8232>, <0.931, 0.054, -0.361> }
	smooth_triangle { <3.3864, -1.1345, 37.9413>, <0.085, 0.984, 0.157>, <3.7455, -1.0842, 37.5976>, <0.123, 0.955, 0.269>, <4.2910, -1.1627, 37.6270>, <0.085, 0.984, 0.157> }
	smooth_triangle { <4.2910, -1.1627, 37.6270>, <0.085, 0.984, 0.157>, <3.8464, -1.1588, 38.0134>, <0.046, 0.998, 0.043>, <3.3864, -1.1345, 37.9413>, <0.085, 0.984, 0.157> }
	smooth_triangle { <3.4453, -1.5692, 38.8714>, <0.855, -0.499, -0.140>, <3.1326, -1.9757, 38.4609>, <0.856, -0.490, -0.166>, <2.8495, -2.5045, 38.5628>, <0.855, -0.499, -0.140> }
	smooth_triangle { <2.8495, -2.5045, 38.5628>, <0.855, -0.499, -0.140>, <3.1647, -2.0678, 38.9858>, <0.854, -0.507, -0.113>, <3.4453, -1.5692, 38.8714>, <0.855, -0.499, -0.140> }
	smooth_triangle { <3.6616, -1.9257, 39.8020>, <0.207, 0.868, 0.451>, <4.1951, -1.8662, 39.4487>, <0.209, 0.863, 0.460>, <4.8404, -2.0823, 39.5615>, <0.207, 0.868, 0.451> }
	smooth_triangle { <4.8404, -2.0823, 39.5615>, <0.207, 0.868, 0.451>, <4.2882, -2.1336, 39.9210>, <0.206, 0.874, 0.441>, <3.6616, -1.9257, 39.8020>, <0.207, 0.868, 0.451> }
	smooth_triangle { <4.1249, -2.1143, 40.6410>, <0.686, -0.457, -0.566>, <3.6079, -2.4945, 40.3012>, <0.700, -0.481, -0.527>, <3.3610, -2.9581, 40.3961>, <0.686, -0.457, -0.566> }
	smooth_triangle { <3.3610, -2.9581, 40.3961>, <0.686, -0.457, -0.566>, <3.8970, -2.5897, 40.7281>, <0.670, -0.432, -0.603>, <4.1249, -2.1143, 40.6410>, <0.686, -0.457, -0.566> }
	smooth_triangle { <4.7596, -2.2467, 41.4786>, <0.257, 0.964, -0.065>, <5.2104, -2.3787, 41.0639>, <0.271, 0.962, -0.012>, <6.0014, -2.6006, 41.1451>, <0.257, 0.964, -0.065> }
	smooth_triangle { <6.0014, -2.6006, 41.1451>, <0.257, 0.964, -0.065>, <5.5198, -2.4254, 41.5826>, <0.243, 0.963, -0.119>, <4.7596, -2.2467, 41.4786>, <0.257, 0.964, -0.065> }
	smooth_triangle { <0.5944, 1.1308, 30.8992>, <0.193, -0.186, -0.963>, <0.1095, 1.5575, 30.7233>, <0.197, -0.174, -0.965>, <-0.5663, 1.4592, 30.6034>, <0.193, -0.186, -0.963> }
	smooth_triangle { <-0.5663, 1.4592, 30.6034>, <0.193, -0.186, -0.963>, <-0.0648, 1.0289, 30.7902>, <0.189, -0.197, -0.962>, <0.5944, 1.1308, 30.8992>, <0.193, -0.186, -0.963> }
	smooth_triangle { <0.4441, 0.3392, 31.0495>, <0.083, 0.150, 0.985>, <1.0284, 0.3982, 30.9916>, <0.083, 0.150, 0.985>, <1.4758, -0.0071, 31.0157>, <0.083, 0.150, 0.985> }
	smooth_triangle { <1.4758, -0.0071, 31.0157>, <0.083, 0.150, 0.985>, <0.8769, -0.0612, 31.0742>, <0.083, 0.150, 0.985>, <0.4441, 0.3392, 31.0495>, <0.083, 0.150, 0.985> }
	smooth_triangle { <0.3294, -0.8548, 30.9144>, <0.847, 0.176, -0.502>, <0.0308, -0.5459, 30.5169>, <0.847, 0.173, -0.502>, <-0.2923, -0.7598, 29.8988>, <0.847, 0.176, -0.502> }
	smooth_triangle { <-0.2923, -0.7598, 29.8988>, <0.847, 0.176, -0.502>, <0.0151, -1.0698, 30.3068>, <0.846, 0.179, -0.501>, <0.3294, -0.8548, 30.9144>, <0.847, 0.176, -0.502> }
	smooth_triangle { <0.3476, -2.0717, 30.8222>, <0.861, -0.118, 0.495>, <0.6582, -1.7657, 30.2971>, <0.864, -0.014, 0.503>, <0.9609, -2.0108, 29.7700>, <0.861, -0.118, 0.495> }
	smooth_triangle { <0.9609, -2.0108, 29.7700>, <0.861, -0.118, 0.495>, <0.6420, -2.3090, 30.1956>, <0.848, -0.220, 0.482>, <0.3476, -2.0717, 30.8222>, <0.861, -0.118, 0.495> }
	smooth_triangle { <-0.0950, -3.1576, 31.2463>, <-0.066, -0.295, -0.953>, <-0.4433, -2.8497, 31.1750>, <-0.066, -0.296, -0.953>, <-0.9208, -2.8920, 31.2214>, <-0.066, -0.295, -0.953> }
	smooth_triangle { <-0.9208, -2.8920, 31.2214>, <-0.066, -0.295, -0.953>, <-0.5609, -3.2037, 31.2926>, <-0.066, -0.294, -0.954>, <-0.0950, -3.1576, 31.2463>, <-0.066, -0.295, -0.953> }
	smooth_triangle { <-0.3640, -4.2949, 31.6090>, <0.423, 0.128, 0.897>, <0.1892, -4.2891, 31.3338>, <0.437, 0.171, 0.883>, <0.6030, -4.7508, 31.2183>, <0.423, 0.128, 0.897> }
	smooth_triangle { <0.6030, -4.7508, 31.2183>, <0.423, 0.128, 0.897>, <0.0335, -4.7579, 31.4738>, <0.407, 0.084, 0.910>, <-0.3640, -4.2949, 31.6090>, <0.423, 0.128, 0.897> }
	smooth_triangle { <-0.3281, -5.3229, 32.1994>, <0.681, -0.224, -0.697>, <-0.6924, -5.1219, 31.7897>, <0.686, -0.188, -0.703>, <-1.0313, -5.3262, 31.5136>, <0.681, -0.224, -0.697> }
	smooth_triangle { <-1.0313, -5.3262, 31.5136>, <0.681, -0.224, -0.697>, <-0.6549, -5.5205, 31.9542>, <0.675, -0.259, -0.691>, <-0.3281, -5.3229, 32.1994>, <0.681, -0.224, -0.697> }
	smooth_triangle { <-0.1346, -6.3949, 32.8140>, <0.731, 0.504, 0.459>, <0.1961, -6.4337, 32.3102>, <0.727, 0.530, 0.437>, <0.5975, -6.8629, 32.1622>, <0.731, 0.504, 0.459> }
	smooth_triangle { <0.5975, -6.8629, 32.1622>, <0.731, 0.504, 0.459>, <0.2538, -6.8256, 32.6494>, <0.734, 0.478, 0.482>, <-0.1346, -6.3949, 32.8140>, <0.731, 0.504, 0.459> }
	smooth_triangle { <1.4231, 1.4176, 31.1890>, <0.508, -0.138, -0.850>, <0.8536, 0.9840, 30.8969>, <0.548, -0.169, -0.819>, <0.7031, 0.2131, 30.9549>, <0.508, -0.138, -0.850> }
	smooth_triangle { <0.7031, 0.2131, 30.9549>, <0.508, -0.138, -0.850>, <1.2990, 0.6515, 31.2170>, <0.465, -0.108, -0.879>, <1.4231, 1.4176, 31.1890>, <0.508, -0.138, -0.850> }
	smooth_triangle { <2.0421, 1.0601, 31.5861>, <0.261, 0.812, 0.523>, <2.2350, 1.2762, 31.1178>, <0.202, 0.855, 0.478>, <2.7274, 1.2790, 30.9044>, <0.261, 0.812, 0.523> }
	smooth_triangle { <2.7274, 1.2790, 30.9044>, <0.261, 0.812, 0.523>, <2.5520, 1.0395, 31.3271>, <0.317, 0.763, 0.564>, <2.0421, 1.0601, 31.5861>, <0.261, 0.812, 0.523> }
	smooth_triangle { <2.3156, 0.4372, 32.6325>, <0.971, -0.056, -0.233>, <2.1522, 0.0635, 32.1712>, <0.943, -0.002, -0.332>, <2.1354, -0.5885, 32.1282>, <0.971, -0.056, -0.233> }
	smooth_triangle { <2.1354, -0.5885, 32.1282>, <0.971, -0.056, -0.233>, <2.2569, -0.1217, 32.6533>, <0.985, -0.108, -0.132>, <2.3156, 0.4372, 32.6325>, <0.971, -0.056, -0.233> }
	smooth_triangle { <2.6900, -0.0548, 33.6875>, <-0.378, 0.756, 0.534>, <3.0994, 0.3034, 33.4690>, <-0.379, 0.757, 0.532>, <3.6500, 0.4427, 33.6628>, <-0.378, 0.756, 0.534> }
	smooth_triangle { <3.6500, 0.4427, 33.6628>, <-0.378, 0.756, 0.534>, <3.2275, 0.0768, 33.8811>, <-0.378, 0.756, 0.535>, <2.6900, -0.0548, 33.6875>, <-0.378, 0.756, 0.534> }
	smooth_triangle { <2.9197, -0.6760, 34.7166>, <0.485, -0.678, -0.553>, <2.3206, -0.8863, 34.4483>, <0.485, -0.679, -0.552>, <1.8632, -1.3830, 34.6569>, <0.485, -0.678, -0.553> }
	smooth_triangle { <1.8632, -1.3830, 34.6569>, <0.485, -0.678, -0.553>, <2.4776, -1.1635, 34.9254>, <0.484, -0.677, -0.555>, <2.9197, -0.6760, 34.7166>, <0.485, -0.678, -0.553> }
	smooth_triangle { <3.3352, -1.1956, 35.7437>, <-0.243, 0.837, 0.491>, <3.7851, -0.8924, 35.4715>, <-0.232, 0.817, 0.527>, <4.3838, -0.8205, 35.6231>, <-0.243, 0.837, 0.491> }
	smooth_triangle { <4.3838, -0.8205, 35.6231>, <-0.243, 0.837, 0.491>, <3.9099, -1.1128, 35.9087>, <-0.253, 0.854, 0.454>, <3.3352, -1.1956, 35.7437>, <-0.243, 0.837, 0.491> }
	smooth_triangle { <3.6228, -2.0704, 36.1816>, <0.627, -0.135, -0.767>, <3.1367, -2.1849, 35.7909>, <0.641, -0.167, -0.749>, <2.8279, -2.7253, 35.6472>, <0.627, -0.135, -0.767> }
	smooth_triangle { <2.8279, -2.7253, 35.6472>, <0.627, -0.135, -0.767>, <3.3297, -2.6115, 36.0237>, <0.612, -0.102, -0.784>, <3.6228, -2.0704, 36.1816>, <0.627, -0.135, -0.767> }
	smooth_triangle { <4.0830, -2.8488, 36.6554>, <-0.049, 0.486, 0.872>, <4.4177, -2.5339, 36.5039>, <-0.040, 0.468, 0.883>, <4.9123, -2.5424, 36.5310>, <-0.049, 0.486, 0.872> }
	smooth_triangle { <4.9123, -2.5424, 36.5310>, <-0.049, 0.486, 0.872>, <4.5642, -2.8578, 36.6926>, <-0.057, 0.504, 0.862>, <4.0830, -2.8488, 36.6554>, <-0.049, 0.486, 0.872> }
	smooth_triangle { <4.6207, -3.5547, 37.0930>, <0.186, -0.402, -0.896>, <4.0295, -3.6114, 36.9953>, <0.187, -0.403, -0.896>, <3.7081, -3.9696, 37.0896>, <0.186, -0.402, -0.896> }
	smooth_triangle { <3.7081, -3.9696, 37.0896>, <0.186, -0.402, -0.896>, <4.3122, -3.9073, 37.1869>, <0.186, -0.402, -0.897>, <4.6207, -3.5547, 37.0930>, <0.186, -0.402, -0.896> }
	smooth_triangle { <5.3387, -4.2054, 37.4828>, <0.602, 0.705, 0.374>, <5.5101, -4.0756, 37.0464>, <0.661, 0.607, 0.440>, <6.0407, -4.3556, 36.6358>, <0.602, 0.705, 0.374> }
	smooth_triangle { <6.0407, -4.3556, 36.6358>, <0.602, 0.705, 0.374>, <5.8359, -4.4314, 37.1972>, <0.533, 0.791, 0.301>, <5.3387, -4.2054, 37.4828>, <0.602, 0.705, 0.374> }
	smooth_triangle { <1.2719, 1.6816, 31.4678>, <0.812, -0.277, -0.513>, <0.9546, 1.1807, 31.2334>, <0.815, -0.278, -0.509>, <0.8854, 0.5708, 31.4550>, <0.812, -0.277, -0.513> }
	smooth_triangle { <0.8854, 0.5708, 31.4550>, <0.812, -0.277, -0.513>, <1.2099, 1.0867, 31.6884>, <0.810, -0.276, -0.517>, <1.2719, 1.6816, 31.4678>, <0.812, -0.277, -0.513> }
	smooth_triangle { <1.7146, 1.6295, 32.1555>, <-0.687, 0.580, 0.437>, <1.9229, 2.0839, 31.8524>, <-0.708, 0.587, 0.393>, <2.3265, 2.4816, 31.9864>, <-0.687, 0.580, 0.437> }
	smooth_triangle { <2.3265, 2.4816, 31.9864>, <-0.687, 0.580, 0.437>, <2.1298, 2.0078, 32.2788>, <-0.664, 0.572, 0.481>, <1.7146, 1.6295, 32.1555>, <-0.687, 0.580, 0.437> }
	smooth_triangle { <1.4159, 1.9608, 33.2942>, <-0.992, -0.118, -0.038>, <1.3694, 2.4672, 32.8759>, <-0.993, -0.116, -0.030>, <1.3030, 3.0109, 32.9720>, <-0.992, -0.118, -0.038> }
	smooth_triangle { <1.3030, 3.0109, 32.9720>, <-0.992, -0.118, -0.038>, <1.3466, 2.4953, 33.3923>, <-0.992, -0.120, -0.045>, <1.4159, 1.9608, 33.2942>, <-0.992, -0.118, -0.038> }
	smooth_triangle { <1.1075, 2.2394, 34.4422>, <-0.162, -0.968, 0.192>, <0.5009, 2.2832, 33.9722>, <-0.135, -0.987, 0.082>, <-0.1702, 2.3865, 34.1079>, <-0.162, -0.968, 0.192> }
	smooth_triangle { <-0.1702, 2.3865, 34.1079>, <-0.162, -0.968, 0.192>, <0.3939, 2.4151, 34.5477>, <-0.186, -0.936, 0.299>, <1.1075, 2.2394, 34.4422>, <-0.162, -0.968, 0.192> }
	smooth_triangle { <1.2954, 2.3597, 35.6617>, <0.400, 0.908, -0.123>, <1.8450, 2.0757, 35.3693>, <0.399, 0.908, -0.131>, <2.4493, 1.8493, 35.6402>, <0.400, 0.908, -0.123> }
	smooth_triangle { <2.4493, 1.8493, 35.6402>, <0.400, 0.908, -0.123>, <1.8810, 2.1364, 35.9337>, <0.400, 0.909, -0.115>, <1.2954, 2.3597, 35.6617>, <0.400, 0.908, -0.123> }
	smooth_triangle { <1.3134, 2.5779, 36.8652>, <-0.883, -0.352, 0.311>, <1.0106, 3.0475, 36.5434>, <-0.881, -0.351, 0.317>, <0.8173, 3.7293, 36.7604>, <-0.883, -0.352, 0.311> }
	smooth_triangle { <0.8173, 3.7293, 36.7604>, <-0.883, -0.352, 0.311>, <1.1248, 3.2396, 37.0843>, <-0.884, -0.353, 0.305>, <1.3134, 2.5779, 36.8652>, <-0.883, -0.352, 0.311> }
	smooth_triangle { <1.0290, 2.6783, 37.8286>, <-0.923, -0.329, -0.200>, <0.9682, 3.0943, 37.5414>, <-0.890, -0.339, -0.303>, <0.7467, 3.5768, 37.6522>, <-0.923, -0.329, -0.200> }
	smooth_triangle { <0.7467, 3.5768, 37.6522>, <-0.923, -0.329, -0.200>, <0.8654, 3.1295, 37.9599>, <-0.944, -0.315, -0.093>, <1.0290, 2.6783, 37.8286>, <-0.923, -0.329, -0.200> }
	smooth_triangle { <0.7090, 2.7027, 38.7959>, <0.391, -0.867, 0.308>, <0.2900, 2.3429, 38.3891>, <0.366, -0.851, 0.376>, <-0.4511, 2.0791, 38.5128>, <0.391, -0.867, 0.308> }
	smooth_triangle { <-0.4511, 2.0791, 38.5128>, <0.391, -0.867, 0.308>, <0.0415, 2.4280, 38.9428>, <0.414, -0.878, 0.239>, <0.7090, 2.7027, 38.7959>, <0.391, -0.867, 0.308> }
	smooth_triangle { <0.7656, 3.0114, 39.7944>, <-0.977, 0.210, -0.022>, <0.8826, 3.5079, 39.5196>, <-0.977, 0.209, -0.038>, <1.0082, 4.1368, 39.7517>, <-0.977, 0.210, -0.022> }
	smooth_triangle { <1.0082, 4.1368, 39.7517>, <-0.977, 0.210, -0.022>, <0.8954, 3.6218, 40.0296>, <-0.978, 0.210, -0.007>, <0.7656, 3.0114, 39.7944>, <-0.977, 0.210, -0.022> }
	smooth_triangle { <0.7081, 3.1661, 40.7744>, <0.369, -0.847, 0.383>, <0.3012, 2.8197, 40.4328>, <0.351, -0.833, 0.426>, <-0.2674, 2.6334, 40.5372>, <0.369, -0.847, 0.383> }
	smooth_triangle { <-0.2674, 2.6334, 40.5372>, <0.369, -0.847, 0.383>, <0.1838, 2.9767, 40.8924>, <0.386, -0.858, 0.339>, <0.7081, 3.1661, 40.7744>, <0.369, -0.847, 0.383> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0011B' */
union {
	smooth_triangle { <2.0229, 4.6332, 28.7082>, <-0.750, -0.372, 0.548>, <1.0117, 4.8177, 27.4488>, <-0.747, -0.372, 0.551>, <1.0059, 4.8411, 27.4569>, <-0.781, -0.055, 0.622> }
	smooth_triangle { <2.0229, 4.6332, 28.7082>, <-0.750, -0.372, 0.548>, <1.0059, 4.8411, 27.4569>, <-0.781, -0.055, 0.622>, <2.0171, 4.6566, 28.7162>, <-0.715, 0.322, 0.621> }
	smooth_triangle { <2.0171, 4.6566, 28.7162>, <-0.715, 0.322, 0.621>, <1.0059, 4.8411, 27.4569>, <-0.781, -0.055, 0.622>, <1.0196, 4.8609, 27.4488>, <-0.370, 0.833, 0.412> }
	smooth_triangle { <2.0171, 4.6566, 28.7162>, <-0.715, 0.322, 0.621>, <1.0196, 4.8609, 27.4488>, <-0.370, 0.833, 0.412>, <2.0308, 4.6765, 28.7082>, <-0.080, 0.975, 0.207> }
	smooth_triangle { <2.0308, 4.6765, 28.7082>, <-0.080, 0.975, 0.207>, <1.0196, 4.8609, 27.4488>, <-0.370, 0.833, 0.412>, <1.0389, 4.8574, 27.4328>, <0.411, 0.887, -0.210> }
	smooth_triangle { <2.0308, 4.6765, 28.7082>, <-0.080, 0.975, 0.207>, <1.0389, 4.8574, 27.4328>, <0.411, 0.887, -0.210>, <2.0501, 4.6730, 28.6922>, <0.635, 0.653, -0.414> }
	smooth_triangle { <2.0501, 4.6730, 28.6922>, <0.635, 0.653, -0.414>, <1.0389, 4.8574, 27.4328>, <0.411, 0.887, -0.210>, <1.0447, 4.8340, 27.4247>, <0.781, 0.055, -0.622> }
	smooth_triangle { <2.0501, 4.6730, 28.6922>, <0.635, 0.653, -0.414>, <1.0447, 4.8340, 27.4247>, <0.781, 0.055, -0.622>, <2.0559, 4.6496, 28.6841>, <0.715, -0.322, -0.621> }
	smooth_triangle { <2.0559, 4.6496, 28.6841>, <0.715, -0.322, -0.621>, <1.0447, 4.8340, 27.4247>, <0.781, 0.055, -0.622>, <1.0310, 4.8141, 27.4328>, <0.370, -0.833, -0.412> }
	smooth_triangle { <2.0559, 4.6496, 28.6841>, <0.715, -0.322, -0.621>, <1.0310, 4.8141, 27.4328>, <0.370, -0.833, -0.412>, <2.0422, 4.6297, 28.6922>, <0.080, -0.975, -0.207> }
	smooth_triangle { <2.0422, 4.6297, 28.6922>, <0.080, -0.975, -0.207>, <1.0310, 4.8141, 27.4328>, <0.370, -0.833, -0.412>, <1.0117, 4.8177, 27.4488>, <-0.170, -0.986, 0.001> }
	smooth_triangle { <2.0422, 4.6297, 28.6922>, <0.080, -0.975, -0.207>, <1.0117, 4.8177, 27.4488>, <-0.170, -0.986, 0.001>, <2.0229, 4.6332, 28.7082>, <-0.179, -0.984, 0.000> }
	smooth_triangle { <3.8091, 4.3735, 30.9077>, <-0.724, -0.392, 0.567>, <1.0117, 4.8177, 27.4488>, <-0.747, -0.372, 0.551>, <1.0059, 4.8411, 27.4569>, <-0.781, -0.055, 0.622> }
	smooth_triangle { <3.8091, 4.3735, 30.9077>, <-0.724, -0.392, 0.567>, <1.0059, 4.8411, 27.4569>, <-0.781, -0.055, 0.622>, <3.8025, 4.3967, 30.9158>, <-0.765, 0.075, 0.640> }
	smooth_triangle { <3.8025, 4.3967, 30.9158>, <-0.753, 0.231, 0.616>, <1.0059, 4.8411, 27.4569>, <-0.781, -0.055, 0.622>, <1.0196, 4.8609, 27.4488>, <-0.370, 0.833, 0.412> }
	smooth_triangle { <3.8025, 4.3967, 30.9158>, <-0.753, 0.231, 0.616>, <1.0196, 4.8609, 27.4488>, <-0.370, 0.833, 0.412>, <3.8154, 4.4170, 30.9077>, <-0.340, 0.901, 0.271> }
	smooth_triangle { <3.8154, 4.4170, 30.9077>, <-0.216, 0.958, 0.189>, <1.0196, 4.8609, 27.4488>, <-0.370, 0.833, 0.412>, <1.0389, 4.8574, 27.4328>, <0.411, 0.887, -0.210> }
	smooth_triangle { <3.8154, 4.4170, 30.9077>, <-0.216, 0.958, 0.189>, <1.0389, 4.8574, 27.4328>, <0.411, 0.887, -0.210>, <3.8349, 4.4142, 30.8916>, <0.426, 0.825, -0.370> }
	smooth_triangle { <3.8349, 4.4142, 30.8916>, <0.538, 0.727, -0.427>, <1.0389, 4.8574, 27.4328>, <0.411, 0.887, -0.210>, <1.0447, 4.8340, 27.4247>, <0.781, 0.055, -0.622> }
	smooth_triangle { <3.8349, 4.4142, 30.8916>, <0.538, 0.727, -0.427>, <1.0447, 4.8340, 27.4247>, <0.781, 0.055, -0.622>, <3.8414, 4.3910, 30.8836>, <0.765, -0.075, -0.640> }
	smooth_triangle { <3.8414, 4.3910, 30.8836>, <0.754, -0.231, -0.615>, <1.0447, 4.8340, 27.4247>, <0.781, 0.055, -0.622>, <1.0310, 4.8141, 27.4328>, <0.370, -0.833, -0.412> }
	smooth_triangle { <3.8414, 4.3910, 30.8836>, <0.754, -0.231, -0.615>, <1.0310, 4.8141, 27.4328>, <0.370, -0.833, -0.412>, <3.8285, 4.3707, 30.8916>, <0.340, -0.901, -0.270> }
	smooth_triangle { <3.8285, 4.3707, 30.8916>, <0.217, -0.958, -0.188>, <1.0310, 4.8141, 27.4328>, <0.370, -0.833, -0.412>, <1.0117, 4.8177, 27.4488>, <-0.170, -0.986, 0.001> }
	smooth_triangle { <3.8285, 4.3707, 30.8916>, <0.217, -0.958, -0.188>, <1.0117, 4.8177, 27.4488>, <-0.170, -0.986, 0.001>, <3.8091, 4.3735, 30.9077>, <0.013, -0.999, 0.052> }
	smooth_triangle { <5.2999, 4.6702, 32.8195>, <-0.621, -0.557, 0.552>, <3.8091, 4.3735, 30.9077>, <-0.724, -0.392, 0.567>, <3.8025, 4.3967, 30.9158>, <-0.765, 0.075, 0.640> }
	smooth_triangle { <5.2999, 4.6702, 32.8195>, <-0.621, -0.557, 0.552>, <3.8025, 4.3967, 30.9158>, <-0.671, -0.480, 0.566>, <5.2858, 4.6897, 32.8274>, <-0.754, -0.255, 0.606> }
	smooth_triangle { <5.2858, 4.6897, 32.8274>, <-0.739, 0.441, 0.510>, <3.8025, 4.3967, 30.9158>, <-0.753, 0.231, 0.616>, <3.8154, 4.4170, 30.9077>, <-0.340, 0.901, 0.271> }
	smooth_triangle { <5.2858, 4.6897, 32.8274>, <-0.786, -0.103, 0.610>, <3.8154, 4.4170, 30.9077>, <-0.684, 0.520, 0.512>, <5.2912, 4.7133, 32.8195>, <-0.600, 0.706, 0.376> }
	smooth_triangle { <5.2912, 4.7133, 32.8195>, <-0.120, 0.992, -0.041>, <3.8154, 4.4170, 30.9077>, <-0.216, 0.958, 0.189>, <3.8349, 4.4142, 30.8916>, <0.426, 0.825, -0.370> }
	smooth_triangle { <5.2912, 4.7133, 32.8195>, <-0.516, 0.805, 0.294>, <3.8349, 4.4142, 30.8916>, <-0.014, 0.999, -0.053>, <5.3107, 4.7172, 32.8038>, <0.154, 0.961, -0.230> }
	smooth_triangle { <5.3107, 4.7172, 32.8038>, <0.621, 0.557, -0.552>, <3.8349, 4.4142, 30.8916>, <0.538, 0.727, -0.427>, <3.8414, 4.3910, 30.8836>, <0.765, -0.075, -0.640> }
	smooth_triangle { <5.3107, 4.7172, 32.8038>, <0.269, 0.910, -0.316>, <3.8414, 4.3910, 30.8836>, <0.671, 0.480, -0.566>, <5.3249, 4.6976, 32.7959>, <0.753, 0.255, -0.607> }
	smooth_triangle { <5.3249, 4.6976, 32.7959>, <0.739, -0.441, -0.510>, <3.8414, 4.3910, 30.8836>, <0.754, -0.231, -0.615>, <3.8285, 4.3707, 30.8916>, <0.340, -0.901, -0.270> }
	smooth_triangle { <5.3249, 4.6976, 32.7959>, <0.785, 0.102, -0.610>, <3.8285, 4.3707, 30.8916>, <0.684, -0.520, -0.512>, <5.3194, 4.6741, 32.8038>, <0.599, -0.706, -0.378> }
	smooth_triangle { <5.3194, 4.6741, 32.8038>, <0.119, -0.992, 0.041>, <3.8285, 4.3707, 30.8916>, <0.217, -0.958, -0.188>, <3.8091, 4.3735, 30.9077>, <0.013, -0.999, 0.052> }
	smooth_triangle { <5.3194, 4.6741, 32.8038>, <0.515, -0.805, -0.294>, <3.8091, 4.3735, 30.9077>, <0.013, -0.999, 0.052>, <5.2999, 4.6702, 32.8195>, <0.160, -0.987, -0.014> }
	smooth_triangle { <6.7758, 4.8424, 34.7513>, <-0.663, -0.598, 0.451>, <5.2999, 4.6702, 32.8195>, <-0.621, -0.557, 0.552>, <5.2858, 4.6897, 32.8274>, <-0.754, -0.255, 0.606> }
	smooth_triangle { <6.7758, 4.8424, 34.7513>, <-0.663, -0.598, 0.451>, <5.2858, 4.6897, 32.8274>, <-0.754, -0.255, 0.606>, <6.7632, 4.8631, 34.7590>, <-0.828, -0.108, 0.550> }
	smooth_triangle { <6.7632, 4.8631, 34.7590>, <-0.915, -0.035, 0.402>, <5.2858, 4.6897, 32.8274>, <-0.786, -0.103, 0.610>, <5.2912, 4.7133, 32.8195>, <-0.600, 0.706, 0.376> }
	smooth_triangle { <6.7632, 4.8631, 34.7590>, <-0.915, -0.035, 0.402>, <5.2912, 4.7133, 32.8195>, <-0.600, 0.706, 0.376>, <6.7707, 4.8861, 34.7513>, <-0.588, 0.808, -0.038> }
	smooth_triangle { <6.7707, 4.8861, 34.7513>, <-0.588, 0.808, -0.038>, <5.2912, 4.7133, 32.8195>, <-0.516, 0.805, 0.294>, <5.3107, 4.7172, 32.8038>, <0.154, 0.961, -0.230> }
	smooth_triangle { <6.7707, 4.8861, 34.7513>, <-0.431, 0.902, 0.020>, <5.3107, 4.7172, 32.8038>, <0.154, 0.961, -0.230>, <6.7907, 4.8885, 34.7358>, <0.338, 0.838, -0.428> }
	smooth_triangle { <6.7907, 4.8885, 34.7358>, <0.338, 0.838, -0.428>, <5.3107, 4.7172, 32.8038>, <0.269, 0.910, -0.316>, <5.3249, 4.6976, 32.7959>, <0.753, 0.255, -0.607> }
	smooth_triangle { <6.7907, 4.8885, 34.7358>, <0.338, 0.838, -0.428>, <5.3249, 4.6976, 32.7959>, <0.753, 0.255, -0.607>, <6.8032, 4.8678, 34.7280>, <0.838, 0.107, -0.535> }
	smooth_triangle { <6.8032, 4.8678, 34.7280>, <0.923, 0.037, -0.383>, <5.3249, 4.6976, 32.7959>, <0.785, 0.102, -0.610>, <5.3194, 4.6741, 32.8038>, <0.599, -0.706, -0.378> }
	smooth_triangle { <6.8032, 4.8678, 34.7280>, <0.923, 0.037, -0.383>, <5.3194, 4.6741, 32.8038>, <0.599, -0.706, -0.378>, <6.7958, 4.8448, 34.7358>, <0.592, -0.804, 0.050> }
	smooth_triangle { <6.7958, 4.8448, 34.7358>, <0.592, -0.804, 0.050>, <5.3194, 4.6741, 32.8038>, <0.515, -0.805, -0.294>, <5.2999, 4.6702, 32.8195>, <0.160, -0.987, -0.014> }
	smooth_triangle { <6.7958, 4.8448, 34.7358>, <0.436, -0.900, -0.015>, <5.2999, 4.6702, 32.8195>, <0.160, -0.987, -0.014>, <6.7758, 4.8424, 34.7513>, <0.319, -0.907, 0.276> }
	smooth_triangle { <6.6574, 5.7257, 36.1173>, <-0.759, -0.574, 0.306>, <6.7758, 4.8424, 34.7513>, <-0.663, -0.598, 0.451>, <6.7632, 4.8631, 34.7590>, <-0.915, -0.035, 0.402> }
	smooth_triangle { <6.6574, 5.7257, 36.1173>, <0.835, -0.465, 0.294>, <6.7632, 4.8631, 34.7590>, <0.618, -0.641, 0.455>, <6.6375, 5.7115, 36.1242>, <0.140, -0.717, 0.683> }
	smooth_triangle { <6.6375, 5.7115, 36.1242>, <-0.946, 0.229, -0.230>, <6.7632, 4.8631, 34.7590>, <-0.934, 0.125, 0.336>, <6.7707, 4.8861, 34.7513>, <-0.701, 0.712, -0.048> }
	smooth_triangle { <6.6375, 5.7115, 36.1242>, <0.140, -0.717, 0.683>, <6.7707, 4.8861, 34.7513>, <-0.367, -0.812, 0.453>, <6.6140, 5.7183, 36.1173>, <-0.786, -0.412, 0.461> }
	smooth_triangle { <6.6140, 5.7183, 36.1173>, <-0.471, 0.729, -0.498>, <6.7707, 4.8861, 34.7513>, <-0.588, 0.808, -0.038>, <6.7907, 4.8885, 34.7358>, <0.187, 0.870, -0.456> }
	smooth_triangle { <6.6140, 5.7183, 36.1173>, <-0.786, -0.412, 0.461>, <6.7907, 4.8885, 34.7358>, <-0.983, -0.181, -0.017>, <6.6104, 5.7393, 36.1035>, <-0.925, 0.306, -0.224> }
	smooth_triangle { <6.6104, 5.7393, 36.1035>, <0.784, 0.569, -0.250>, <6.7907, 4.8885, 34.7358>, <0.525, 0.772, -0.359>, <6.8032, 4.8678, 34.7280>, <0.923, 0.037, -0.383> }
	smooth_triangle { <6.6104, 5.7393, 36.1035>, <-0.925, 0.306, -0.224>, <6.8032, 4.8678, 34.7280>, <-0.615, 0.624, -0.482>, <6.6302, 5.7536, 36.0967>, <-0.138, 0.714, -0.686> }
	smooth_triangle { <6.6302, 5.7536, 36.0967>, <0.941, -0.217, 0.260>, <6.8032, 4.8678, 34.7280>, <0.942, -0.124, -0.312>, <6.7958, 4.8448, 34.7358>, <0.706, -0.705, 0.063> }
	smooth_triangle { <6.6302, 5.7536, 36.0967>, <-0.138, 0.714, -0.686>, <6.7958, 4.8448, 34.7358>, <0.371, 0.793, -0.484>, <6.6537, 5.7468, 36.1035>, <0.785, 0.407, -0.467> }
	smooth_triangle { <6.6537, 5.7468, 36.1035>, <0.893, -0.333, 0.303>, <6.7958, 4.8448, 34.7358>, <0.592, -0.804, 0.050>, <6.7758, 4.8424, 34.7513>, <0.699, -0.680, 0.220> }
	smooth_triangle { <6.6537, 5.7468, 36.1035>, <0.927, 0.201, -0.316>, <6.7758, 4.8424, 34.7513>, <0.893, -0.333, 0.303>, <6.6574, 5.7257, 36.1173>, <0.987, 0.159, -0.017> }
	smooth_triangle { <6.9641, 7.0496, 37.0041>, <0.616, -0.527, 0.585>, <6.6574, 5.7257, 36.1173>, <0.835, -0.465, 0.294>, <6.6375, 5.7115, 36.1242>, <0.140, -0.717, 0.683> }
	smooth_triangle { <6.9641, 7.0496, 37.0041>, <-0.345, -0.450, 0.824>, <6.6375, 5.7115, 36.1242>, <0.140, -0.717, 0.683>, <6.6140, 5.7183, 36.1173>, <-0.786, -0.412, 0.461> }
	smooth_triangle { <6.9641, 7.0496, 37.0041>, <-0.958, 0.076, 0.277>, <6.6140, 5.7183, 36.1173>, <-0.786, -0.412, 0.461>, <6.6104, 5.7393, 36.1035>, <-0.925, 0.306, -0.224> }
	smooth_triangle { <6.9641, 7.0496, 37.0041>, <-0.616, 0.557, -0.557>, <6.6104, 5.7393, 36.1035>, <-0.925, 0.306, -0.224>, <6.6302, 5.7536, 36.0967>, <-0.138, 0.714, -0.686> }
	smooth_triangle { <6.9641, 7.0496, 37.0041>, <0.350, 0.480, -0.804>, <6.6302, 5.7536, 36.0967>, <-0.138, 0.714, -0.686>, <6.6537, 5.7468, 36.1035>, <0.785, 0.407, -0.467> }
	smooth_triangle { <6.9641, 7.0496, 37.0041>, <0.967, -0.049, -0.250>, <6.6537, 5.7468, 36.1035>, <0.785, 0.407, -0.467>, <6.6574, 5.7257, 36.1173>, <0.835, -0.465, 0.294> }
	smooth_triangle { <5.9207, 5.6401, 33.2729>, <0.256, -0.535, 0.805>, <5.3215, 4.6781, 32.8234>, <0.160, -0.672, 0.723>, <5.3004, 4.6857, 32.8353>, <-0.149, -0.458, 0.876> }
	smooth_triangle { <5.9207, 5.6401, 33.2729>, <0.256, -0.535, 0.805>, <5.3004, 4.6857, 32.8353>, <-0.149, -0.458, 0.876>, <5.8995, 5.6478, 33.2847>, <-0.352, -0.207, 0.913> }
	smooth_triangle { <5.8995, 5.6478, 33.2847>, <-0.352, -0.207, 0.913>, <5.3004, 4.6857, 32.8353>, <-0.149, -0.458, 0.876>, <5.2842, 4.7013, 32.8234>, <-0.729, 0.308, 0.612> }
	smooth_triangle { <5.8995, 5.6478, 33.2847>, <-0.352, -0.207, 0.913>, <5.2842, 4.7013, 32.8234>, <-0.729, 0.308, 0.612>, <5.8834, 5.6634, 33.2729>, <-0.866, 0.397, 0.304> }
	smooth_triangle { <5.8834, 5.6634, 33.2729>, <-0.866, 0.397, 0.304>, <5.2842, 4.7013, 32.8234>, <-0.729, 0.308, 0.612>, <5.2891, 4.7093, 32.7998>, <-0.583, 0.768, -0.264> }
	smooth_triangle { <5.8834, 5.6634, 33.2729>, <-0.866, 0.397, 0.304>, <5.2891, 4.7093, 32.7998>, <-0.583, 0.768, -0.264>, <5.8883, 5.6713, 33.2493>, <-0.514, 0.604, -0.609> }
	smooth_triangle { <5.8883, 5.6713, 33.2493>, <-0.514, 0.604, -0.609>, <5.2891, 4.7093, 32.7998>, <-0.583, 0.768, -0.264>, <5.3103, 4.7016, 32.7880>, <0.149, 0.458, -0.876> }
	smooth_triangle { <5.8883, 5.6713, 33.2493>, <-0.514, 0.604, -0.609>, <5.3103, 4.7016, 32.7880>, <0.149, 0.458, -0.876>, <5.9094, 5.6637, 33.2375>, <0.352, 0.207, -0.913> }
	smooth_triangle { <5.9094, 5.6637, 33.2375>, <0.352, 0.207, -0.913>, <5.3103, 4.7016, 32.7880>, <0.149, 0.458, -0.876>, <5.3265, 4.6860, 32.7998>, <0.728, -0.309, -0.612> }
	smooth_triangle { <5.9094, 5.6637, 33.2375>, <0.352, 0.207, -0.913>, <5.3265, 4.6860, 32.7998>, <0.728, -0.309, -0.612>, <5.9256, 5.6480, 33.2493>, <0.866, -0.397, -0.304> }
	smooth_triangle { <5.9256, 5.6480, 33.2493>, <0.866, -0.397, -0.304>, <5.3265, 4.6860, 32.7998>, <0.728, -0.309, -0.612>, <5.3215, 4.6781, 32.8234>, <0.710, -0.704, -0.007> }
	smooth_triangle { <5.9256, 5.6480, 33.2493>, <0.866, -0.397, -0.304>, <5.3215, 4.6781, 32.8234>, <0.710, -0.704, -0.007>, <5.9207, 5.6401, 33.2729>, <0.849, -0.529, 0.000> }
	smooth_triangle { <7.8573, 6.2542, 34.5933>, <-0.327, -0.739, 0.589>, <5.3215, 4.6781, 32.8234>, <0.160, -0.672, 0.723>, <5.3004, 4.6857, 32.8353>, <-0.149, -0.458, 0.876> }
	smooth_triangle { <7.8573, 6.2542, 34.5933>, <-0.327, -0.739, 0.589>, <5.3004, 4.6857, 32.8353>, <-0.149, -0.458, 0.876>, <7.8441, 6.2730, 34.6040>, <-0.753, -0.137, 0.644> }
	smooth_triangle { <7.8441, 6.2730, 34.6040>, <-0.753, -0.137, 0.644>, <5.3004, 4.6857, 32.8353>, <-0.149, -0.458, 0.876>, <5.2842, 4.7013, 32.8234>, <-0.729, 0.308, 0.612> }
	smooth_triangle { <7.8441, 6.2730, 34.6040>, <-0.753, -0.137, 0.644>, <5.2842, 4.7013, 32.8234>, <-0.729, 0.308, 0.612>, <7.8439, 6.2961, 34.5933>, <-0.551, 0.757, 0.351> }
	smooth_triangle { <7.8439, 6.2961, 34.5933>, <-0.551, 0.757, 0.351>, <5.2842, 4.7013, 32.8234>, <-0.729, 0.308, 0.612>, <5.2891, 4.7093, 32.7998>, <-0.583, 0.768, -0.264> }
	smooth_triangle { <7.8439, 6.2961, 34.5933>, <-0.551, 0.757, 0.351>, <5.2891, 4.7093, 32.7998>, <-0.583, 0.768, -0.264>, <7.8571, 6.3003, 34.5720>, <0.057, 0.952, -0.301> }
	smooth_triangle { <7.8571, 6.3003, 34.5720>, <0.197, 0.935, -0.294>, <5.2891, 4.7093, 32.7998>, <-0.583, 0.768, -0.264>, <5.3103, 4.7016, 32.7880>, <0.149, 0.458, -0.876> }
	smooth_triangle { <7.8571, 6.3003, 34.5720>, <0.197, 0.935, -0.294>, <5.3103, 4.7016, 32.7880>, <0.149, 0.458, -0.876>, <7.8703, 6.2814, 34.5613>, <0.751, 0.137, -0.645> }
	smooth_triangle { <7.8703, 6.2814, 34.5613>, <0.751, 0.137, -0.645>, <5.3103, 4.7016, 32.7880>, <0.149, 0.458, -0.876>, <5.3265, 4.6860, 32.7998>, <0.728, -0.309, -0.612> }
	smooth_triangle { <7.8703, 6.2814, 34.5613>, <0.751, 0.137, -0.645>, <5.3265, 4.6860, 32.7998>, <0.728, -0.309, -0.612>, <7.8704, 6.2583, 34.5720>, <0.550, -0.757, -0.352> }
	smooth_triangle { <7.8704, 6.2583, 34.5720>, <0.550, -0.757, -0.352>, <5.3265, 4.6860, 32.7998>, <0.728, -0.309, -0.612>, <5.3215, 4.6781, 32.8234>, <0.710, -0.704, -0.007> }
	smooth_triangle { <7.8704, 6.2583, 34.5720>, <0.550, -0.757, -0.352>, <5.3215, 4.6781, 32.8234>, <0.710, -0.704, -0.007>, <7.8573, 6.2542, 34.5933>, <-0.044, -0.998, -0.046> }
	smooth_triangle { <8.6988, 5.7605, 36.3587>, <-0.947, -0.224, 0.229>, <7.8573, 6.2542, 34.5933>, <-0.327, -0.739, 0.589>, <7.8441, 6.2730, 34.6040>, <-0.753, -0.137, 0.644> }
	smooth_triangle { <8.6988, 5.7605, 36.3587>, <-0.947, -0.224, 0.229>, <7.8441, 6.2730, 34.6040>, <-0.753, -0.137, 0.644>, <8.7003, 5.7851, 36.3650>, <-0.769, 0.493, 0.408> }
	smooth_triangle { <8.7003, 5.7851, 36.3650>, <-0.769, 0.493, 0.408>, <7.8441, 6.2730, 34.6040>, <-0.753, -0.137, 0.644>, <7.8439, 6.2961, 34.5933>, <-0.657, 0.665, 0.356> }
	smooth_triangle { <8.7003, 5.7851, 36.3650>, <-0.769, 0.493, 0.408>, <7.8439, 6.2961, 34.5933>, <-0.551, 0.757, 0.351>, <8.7210, 5.7985, 36.3587>, <0.167, 0.926, 0.338> }
	smooth_triangle { <8.7210, 5.7985, 36.3587>, <0.167, 0.926, 0.338>, <7.8439, 6.2961, 34.5933>, <-0.455, 0.837, 0.305>, <7.8571, 6.3003, 34.5720>, <0.197, 0.935, -0.294> }
	smooth_triangle { <8.7210, 5.7985, 36.3587>, <0.167, 0.926, 0.338>, <7.8571, 6.3003, 34.5720>, <0.197, 0.935, -0.294>, <8.7401, 5.7874, 36.3462>, <0.906, 0.418, -0.059> }
	smooth_triangle { <8.7401, 5.7874, 36.3462>, <0.906, 0.418, -0.059>, <7.8571, 6.3003, 34.5720>, <0.338, 0.887, -0.316>, <7.8703, 6.2814, 34.5613>, <0.751, 0.137, -0.645> }
	smooth_triangle { <8.7401, 5.7874, 36.3462>, <0.906, 0.418, -0.059>, <7.8703, 6.2814, 34.5613>, <0.751, 0.137, -0.645>, <8.7385, 5.7628, 36.3400>, <0.768, -0.493, -0.408> }
	smooth_triangle { <8.7385, 5.7628, 36.3400>, <0.768, -0.493, -0.408>, <7.8703, 6.2814, 34.5613>, <0.751, 0.137, -0.645>, <7.8704, 6.2583, 34.5720>, <0.656, -0.665, -0.356> }
	smooth_triangle { <8.7385, 5.7628, 36.3400>, <0.768, -0.493, -0.408>, <7.8704, 6.2583, 34.5720>, <0.550, -0.757, -0.352>, <8.7179, 5.7494, 36.3462>, <-0.169, -0.925, -0.339> }
	smooth_triangle { <8.7179, 5.7494, 36.3462>, <-0.169, -0.925, -0.339>, <7.8704, 6.2583, 34.5720>, <0.454, -0.837, -0.305>, <7.8573, 6.2542, 34.5933>, <-0.044, -0.998, -0.046> }
	smooth_triangle { <8.7179, 5.7494, 36.3462>, <-0.169, -0.925, -0.339>, <7.8573, 6.2542, 34.5933>, <-0.044, -0.998, -0.046>, <8.6988, 5.7605, 36.3587>, <-0.798, -0.588, -0.130> }
	smooth_triangle { <8.7109, 4.8747, 38.1748>, <-0.864, 0.456, 0.213>, <8.6988, 5.7605, 36.3587>, <-0.947, -0.224, 0.229>, <8.7003, 5.7851, 36.3650>, <-0.769, 0.493, 0.408> }
	smooth_triangle { <8.7109, 4.8747, 38.1748>, <-0.864, 0.456, 0.213>, <8.7003, 5.7851, 36.3650>, <-0.769, 0.493, 0.408>, <8.7328, 4.8863, 38.1805>, <-0.108, 0.937, 0.332> }
	smooth_triangle { <8.7328, 4.8863, 38.1805>, <-0.108, 0.937, 0.332>, <8.7003, 5.7851, 36.3650>, <-0.769, 0.493, 0.408>, <8.7210, 5.7985, 36.3587>, <0.167, 0.926, 0.338> }
	smooth_triangle { <8.7328, 4.8863, 38.1805>, <-0.108, 0.937, 0.332>, <8.7210, 5.7985, 36.3587>, <0.167, 0.926, 0.338>, <8.7549, 4.8753, 38.1748>, <0.814, 0.559, 0.158> }
	smooth_triangle { <8.7549, 4.8753, 38.1748>, <0.814, 0.559, 0.158>, <8.7210, 5.7985, 36.3587>, <0.167, 0.926, 0.338>, <8.7401, 5.7874, 36.3462>, <0.906, 0.418, -0.059> }
	smooth_triangle { <8.7549, 4.8753, 38.1748>, <0.814, 0.559, 0.158>, <8.7401, 5.7874, 36.3462>, <0.906, 0.418, -0.059>, <8.7553, 4.8526, 38.1634>, <0.918, -0.364, -0.161> }
	smooth_triangle { <8.7553, 4.8526, 38.1634>, <0.918, -0.364, -0.161>, <8.7401, 5.7874, 36.3462>, <0.906, 0.418, -0.059>, <8.7385, 5.7628, 36.3400>, <0.768, -0.493, -0.408> }
	smooth_triangle { <8.7553, 4.8526, 38.1634>, <0.918, -0.364, -0.161>, <8.7385, 5.7628, 36.3400>, <0.768, -0.493, -0.408>, <8.7335, 4.8409, 38.1577>, <0.108, -0.940, -0.323> }
	smooth_triangle { <8.7335, 4.8409, 38.1577>, <0.108, -0.940, -0.323>, <8.7385, 5.7628, 36.3400>, <0.768, -0.493, -0.408>, <8.7179, 5.7494, 36.3462>, <-0.169, -0.925, -0.339> }
	smooth_triangle { <8.7335, 4.8409, 38.1577>, <0.108, -0.940, -0.323>, <8.7179, 5.7494, 36.3462>, <-0.169, -0.925, -0.339>, <8.7113, 4.8520, 38.1634>, <-0.814, -0.562, -0.150> }
	smooth_triangle { <8.7113, 4.8520, 38.1634>, <-0.814, -0.562, -0.150>, <8.7179, 5.7494, 36.3462>, <-0.169, -0.925, -0.339>, <8.6988, 5.7605, 36.3587>, <-0.798, -0.588, -0.130> }
	smooth_triangle { <8.7113, 4.8520, 38.1634>, <-0.814, -0.562, -0.150>, <8.6988, 5.7605, 36.3587>, <-0.798, -0.588, -0.130>, <8.7109, 4.8747, 38.1748>, <-1.000, -0.015, -0.001> }
	smooth_triangle { <8.9916, 4.5915, 40.1661>, <-0.520, 0.831, 0.197>, <8.7109, 4.8747, 38.1748>, <-0.864, 0.456, 0.213>, <8.7328, 4.8863, 38.1805>, <-0.108, 0.937, 0.332> }
	smooth_triangle { <8.9916, 4.5915, 40.1661>, <0.465, 0.882, 0.076>, <8.7328, 4.8863, 38.1805>, <-0.108, 0.937, 0.332>, <8.7549, 4.8753, 38.1748>, <0.814, 0.559, 0.158> }
	smooth_triangle { <8.9916, 4.5915, 40.1661>, <0.993, 0.053, -0.105>, <8.7549, 4.8753, 38.1748>, <0.814, 0.559, 0.158>, <8.7553, 4.8526, 38.1634>, <0.918, -0.364, -0.161> }
	smooth_triangle { <8.9916, 4.5915, 40.1661>, <0.520, -0.838, -0.165>, <8.7553, 4.8526, 38.1634>, <0.918, -0.364, -0.161>, <8.7335, 4.8409, 38.1577>, <0.108, -0.940, -0.323> }
	smooth_triangle { <8.9916, 4.5915, 40.1661>, <-0.461, -0.886, -0.046>, <8.7335, 4.8409, 38.1577>, <0.108, -0.940, -0.323>, <8.7113, 4.8520, 38.1634>, <-0.814, -0.562, -0.150> }
	smooth_triangle { <8.9916, 4.5915, 40.1661>, <-0.989, -0.063, 0.136>, <8.7113, 4.8520, 38.1634>, <-0.814, -0.562, -0.150>, <8.7109, 4.8747, 38.1748>, <-0.864, 0.456, 0.213> }
	smooth_triangle { <6.4718, 4.5676, 33.1443>, <-0.271, -0.478, 0.836>, <5.3001, 4.6721, 32.8239>, <-0.498, -0.442, 0.746>, <5.2987, 4.6943, 32.8362>, <-0.500, -0.093, 0.861> }
	smooth_triangle { <6.4718, 4.5676, 33.1443>, <-0.271, -0.478, 0.836>, <5.2987, 4.6943, 32.8362>, <-0.500, -0.093, 0.861>, <6.4704, 4.5898, 33.1566>, <-0.240, 0.211, 0.947> }
	smooth_triangle { <6.4704, 4.5898, 33.1566>, <-0.240, 0.211, 0.947>, <5.2987, 4.6943, 32.8362>, <-0.500, -0.093, 0.861>, <5.3040, 4.7159, 32.8239>, <-0.162, 0.805, 0.571> }
	smooth_triangle { <6.4704, 4.5898, 33.1566>, <-0.240, 0.211, 0.947>, <5.3040, 4.7159, 32.8239>, <-0.162, 0.805, 0.571>, <6.4757, 4.6114, 33.1443>, <-0.002, 0.949, 0.316> }
	smooth_triangle { <6.4757, 4.6114, 33.1443>, <-0.002, 0.949, 0.316>, <5.3040, 4.7159, 32.8239>, <-0.162, 0.805, 0.571>, <5.3106, 4.7153, 32.7994>, <0.337, 0.897, -0.286> }
	smooth_triangle { <6.4757, 4.6114, 33.1443>, <-0.002, 0.949, 0.316>, <5.3106, 4.7153, 32.7994>, <0.337, 0.897, -0.286>, <6.4823, 4.6109, 33.1198>, <0.238, 0.738, -0.632> }
	smooth_triangle { <6.4823, 4.6109, 33.1198>, <0.238, 0.738, -0.632>, <5.3106, 4.7153, 32.7994>, <0.337, 0.897, -0.286>, <5.3120, 4.6931, 32.7871>, <0.500, 0.093, -0.861> }
	smooth_triangle { <6.4823, 4.6109, 33.1198>, <0.238, 0.738, -0.632>, <5.3120, 4.6931, 32.7871>, <0.500, 0.093, -0.861>, <6.4837, 4.5886, 33.1075>, <0.240, -0.211, -0.947> }
	smooth_triangle { <6.4837, 4.5886, 33.1075>, <0.240, -0.211, -0.947>, <5.3120, 4.6931, 32.7871>, <0.500, 0.093, -0.861>, <5.3067, 4.6715, 32.7994>, <0.161, -0.805, -0.571> }
	smooth_triangle { <6.4837, 4.5886, 33.1075>, <0.240, -0.211, -0.947>, <5.3067, 4.6715, 32.7994>, <0.161, -0.805, -0.571>, <6.4784, 4.5670, 33.1198>, <0.002, -0.949, -0.316> }
	smooth_triangle { <6.4784, 4.5670, 33.1198>, <0.002, -0.949, -0.316>, <5.3067, 4.6715, 32.7994>, <0.161, -0.805, -0.571>, <5.3001, 4.6721, 32.8239>, <-0.206, -0.978, 0.015> }
	smooth_triangle { <6.4784, 4.5670, 33.1198>, <0.002, -0.949, -0.316>, <5.3001, 4.6721, 32.8239>, <-0.206, -0.978, 0.015>, <6.4718, 4.5676, 33.1443>, <-0.089, -0.996, 0.000> }
	smooth_triangle { <7.7300, 3.9238, 35.1154>, <-0.559, -0.293, 0.775>, <5.3001, 4.6721, 32.8239>, <-0.498, -0.442, 0.746>, <5.2987, 4.6943, 32.8362>, <-0.500, -0.093, 0.861> }
	smooth_triangle { <7.7300, 3.9238, 35.1154>, <-0.559, -0.293, 0.775>, <5.2987, 4.6943, 32.8362>, <-0.500, -0.093, 0.861>, <7.7309, 3.9481, 35.1228>, <-0.426, 0.182, 0.886> }
	smooth_triangle { <7.7309, 3.9481, 35.1228>, <-0.426, 0.182, 0.886>, <5.2987, 4.6943, 32.8362>, <-0.500, -0.093, 0.861>, <5.3040, 4.7159, 32.8239>, <-0.162, 0.805, 0.571> }
	smooth_triangle { <7.7309, 3.9481, 35.1228>, <-0.451, 0.327, 0.831>, <5.3040, 4.7159, 32.8239>, <-0.162, 0.805, 0.571>, <7.7501, 3.9630, 35.1154>, <-0.039, 0.872, 0.489> }
	smooth_triangle { <7.7501, 3.9630, 35.1154>, <-0.022, 0.943, 0.331>, <5.3040, 4.7159, 32.8239>, <-0.162, 0.805, 0.571>, <5.3106, 4.7153, 32.7994>, <0.337, 0.897, -0.286> }
	smooth_triangle { <7.7501, 3.9630, 35.1154>, <0.033, 0.982, 0.186>, <5.3106, 4.7153, 32.7994>, <0.337, 0.897, -0.286>, <7.7684, 3.9536, 35.1005>, <0.395, 0.726, -0.563> }
	smooth_triangle { <7.7684, 3.9536, 35.1005>, <0.469, 0.604, -0.645>, <5.3106, 4.7153, 32.7994>, <0.337, 0.897, -0.286>, <5.3120, 4.6931, 32.7871>, <0.500, 0.093, -0.861> }
	smooth_triangle { <7.7684, 3.9536, 35.1005>, <0.469, 0.604, -0.645>, <5.3120, 4.6931, 32.7871>, <0.500, 0.093, -0.861>, <7.7675, 3.9293, 35.0931>, <0.424, -0.182, -0.887> }
	smooth_triangle { <7.7675, 3.9293, 35.0931>, <0.424, -0.182, -0.887>, <5.3120, 4.6931, 32.7871>, <0.500, 0.093, -0.861>, <5.3067, 4.6715, 32.7994>, <0.161, -0.805, -0.571> }
	smooth_triangle { <7.7675, 3.9293, 35.0931>, <0.450, -0.327, -0.831>, <5.3067, 4.6715, 32.7994>, <0.161, -0.805, -0.571>, <7.7484, 3.9144, 35.1005>, <0.038, -0.872, -0.488> }
	smooth_triangle { <7.7484, 3.9144, 35.1005>, <0.022, -0.944, -0.330>, <5.3067, 4.6715, 32.7994>, <0.161, -0.805, -0.571>, <5.3001, 4.6721, 32.8239>, <-0.206, -0.978, 0.015> }
	smooth_triangle { <7.7484, 3.9144, 35.1005>, <-0.032, -0.982, -0.184>, <5.3001, 4.6721, 32.8239>, <-0.206, -0.978, 0.015>, <7.7300, 3.9238, 35.1154>, <-0.130, -0.970, 0.204> }
	smooth_triangle { <10.1081, 4.0813, 35.7096>, <-0.017, -0.416, 0.909>, <7.7300, 3.9238, 35.1154>, <-0.559, -0.293, 0.775>, <7.7309, 3.9481, 35.1228>, <-0.426, 0.182, 0.886> }
	smooth_triangle { <10.1081, 4.0813, 35.7096>, <0.106, -0.610, 0.785>, <7.7309, 3.9481, 35.1228>, <-0.447, -0.129, 0.885>, <10.1035, 4.1031, 35.7219>, <-0.033, 0.015, 0.999> }
	smooth_triangle { <10.1035, 4.1031, 35.7219>, <-0.170, 0.546, 0.820>, <7.7309, 3.9481, 35.1228>, <-0.451, 0.327, 0.831>, <7.7501, 3.9630, 35.1154>, <-0.039, 0.872, 0.489> }
	smooth_triangle { <10.1035, 4.1031, 35.7219>, <-0.080, 0.168, 0.983>, <7.7501, 3.9630, 35.1154>, <-0.152, 0.780, 0.608>, <10.1050, 4.1252, 35.7096>, <-0.221, 0.849, 0.480> }
	smooth_triangle { <10.1050, 4.1252, 35.7096>, <-0.143, 0.970, -0.196>, <7.7501, 3.9630, 35.1154>, <0.241, 0.953, -0.186>, <7.7684, 3.9536, 35.1005>, <0.395, 0.726, -0.563> }
	smooth_triangle { <10.1050, 4.1252, 35.7096>, <-0.173, 0.942, 0.288>, <7.7684, 3.9536, 35.1005>, <0.129, 0.971, -0.203>, <10.1111, 4.1257, 35.6849>, <-0.186, 0.833, -0.521> }
	smooth_triangle { <10.1111, 4.1257, 35.6849>, <0.018, 0.417, -0.909>, <7.7684, 3.9536, 35.1005>, <0.469, 0.604, -0.645>, <7.7675, 3.9293, 35.0931>, <0.424, -0.182, -0.887> }
	smooth_triangle { <10.1111, 4.1257, 35.6849>, <-0.101, 0.750, -0.653>, <7.7675, 3.9293, 35.0931>, <0.443, 0.130, -0.887>, <10.1157, 4.1039, 35.6726>, <0.039, -0.014, -0.999> }
	smooth_triangle { <10.1157, 4.1039, 35.6726>, <0.176, -0.547, -0.819>, <7.7675, 3.9293, 35.0931>, <0.450, -0.327, -0.831>, <7.7484, 3.9144, 35.1005>, <0.038, -0.872, -0.488> }
	smooth_triangle { <10.1157, 4.1039, 35.6726>, <0.086, -0.167, -0.982>, <7.7484, 3.9144, 35.1005>, <0.151, -0.780, -0.607>, <10.1142, 4.0818, 35.6849>, <0.229, -0.847, -0.479> }
	smooth_triangle { <10.1142, 4.0818, 35.6849>, <0.148, -0.969, 0.198>, <7.7484, 3.9144, 35.1005>, <-0.240, -0.953, 0.187>, <7.7300, 3.9238, 35.1154>, <-0.130, -0.970, 0.204> }
	smooth_triangle { <10.1142, 4.0818, 35.6849>, <0.181, -0.941, -0.287>, <7.7300, 3.9238, 35.1154>, <-0.130, -0.970, 0.204>, <10.1081, 4.0813, 35.7096>, <0.066, -0.998, -0.001> }
	smooth_triangle { <12.3160, 5.0520, 35.2756>, <0.344, -0.390, 0.854>, <10.1081, 4.0813, 35.7096>, <0.106, -0.610, 0.785>, <10.1035, 4.1031, 35.7219>, <-0.033, 0.015, 0.999> }
	smooth_triangle { <12.3160, 5.0520, 35.2756>, <-0.045, 0.519, 0.854>, <10.1035, 4.1031, 35.7219>, <-0.080, 0.168, 0.983>, <10.1050, 4.1252, 35.7096>, <-0.221, 0.849, 0.480> }
	smooth_triangle { <12.3160, 5.0520, 35.2756>, <-0.388, 0.921, -0.030>, <10.1050, 4.1252, 35.7096>, <-0.173, 0.942, 0.288>, <10.1111, 4.1257, 35.6849>, <-0.186, 0.833, -0.521> }
	smooth_triangle { <12.3160, 5.0520, 35.2756>, <-0.322, 0.398, -0.859>, <10.1111, 4.1257, 35.6849>, <-0.101, 0.750, -0.653>, <10.1157, 4.1039, 35.6726>, <0.039, -0.014, -0.999> }
	smooth_triangle { <12.3160, 5.0520, 35.2756>, <0.072, -0.514, -0.855>, <10.1157, 4.1039, 35.6726>, <0.086, -0.167, -0.982>, <10.1142, 4.0818, 35.6849>, <0.229, -0.847, -0.479> }
	smooth_triangle { <12.3160, 5.0520, 35.2756>, <0.412, -0.911, 0.031>, <10.1142, 4.0818, 35.6849>, <0.181, -0.941, -0.287>, <10.1081, 4.0813, 35.7096>, <0.223, -0.699, 0.679> }
	smooth_triangle { <5.5033, 4.1300, 33.8747>, <-0.740, 0.516, 0.432>, <5.2808, 4.6959, 32.8180>, <-0.752, 0.550, 0.364>, <5.2973, 4.7142, 32.8243>, <-0.458, 0.812, 0.362> }
	smooth_triangle { <5.5033, 4.1300, 33.8747>, <-0.740, 0.516, 0.432>, <5.2973, 4.7142, 32.8243>, <-0.458, 0.812, 0.362>, <5.5197, 4.1483, 33.8811>, <-0.136, 0.861, 0.490> }
	smooth_triangle { <5.5197, 4.1483, 33.8811>, <-0.136, 0.861, 0.490>, <5.2973, 4.7142, 32.8243>, <-0.458, 0.812, 0.362>, <5.3218, 4.7120, 32.8180>, <0.514, 0.849, 0.122> }
	smooth_triangle { <5.5197, 4.1483, 33.8811>, <-0.136, 0.861, 0.490>, <5.3218, 4.7120, 32.8180>, <0.514, 0.849, 0.122>, <5.5442, 4.1461, 33.8747>, <0.776, 0.610, 0.163> }
	smooth_triangle { <5.5442, 4.1461, 33.8747>, <0.776, 0.610, 0.163>, <5.3218, 4.7120, 32.8180>, <0.514, 0.849, 0.122>, <5.3298, 4.6915, 32.8053>, <0.971, 0.031, -0.236> }
	smooth_triangle { <5.5442, 4.1461, 33.8747>, <0.776, 0.610, 0.163>, <5.3298, 4.6915, 32.8053>, <0.971, 0.031, -0.236>, <5.5523, 4.1256, 33.8620>, <0.911, -0.252, -0.327> }
	smooth_triangle { <5.5523, 4.1256, 33.8620>, <0.911, -0.252, -0.327>, <5.3298, 4.6915, 32.8053>, <0.971, 0.031, -0.236>, <5.3134, 4.6732, 32.7990>, <0.460, -0.815, -0.353> }
	smooth_triangle { <5.5523, 4.1256, 33.8620>, <0.911, -0.252, -0.327>, <5.3134, 4.6732, 32.7990>, <0.460, -0.815, -0.353>, <5.5359, 4.1073, 33.8557>, <0.136, -0.861, -0.490> }
	smooth_triangle { <5.5359, 4.1073, 33.8557>, <0.136, -0.861, -0.490>, <5.3134, 4.6732, 32.7990>, <0.460, -0.815, -0.353>, <5.2889, 4.6754, 32.8053>, <-0.511, -0.852, -0.114> }
	smooth_triangle { <5.5359, 4.1073, 33.8557>, <0.136, -0.861, -0.490>, <5.2889, 4.6754, 32.8053>, <-0.511, -0.852, -0.114>, <5.5114, 4.1095, 33.8620>, <-0.776, -0.610, -0.163> }
	smooth_triangle { <5.5114, 4.1095, 33.8620>, <-0.776, -0.610, -0.163>, <5.2889, 4.6754, 32.8053>, <-0.511, -0.852, -0.114>, <5.2808, 4.6959, 32.8180>, <-0.900, -0.422, 0.110> }
	smooth_triangle { <5.5114, 4.1095, 33.8620>, <-0.776, -0.610, -0.163>, <5.2808, 4.6959, 32.8180>, <-0.900, -0.422, 0.110>, <5.5033, 4.1300, 33.8747>, <-0.931, -0.366, 0.000> }
	smooth_triangle { <6.5332, 4.7179, 36.0102>, <-0.759, 0.581, 0.294>, <5.2808, 4.6959, 32.8180>, <-0.752, 0.550, 0.364>, <5.2973, 4.7142, 32.8243>, <-0.458, 0.812, 0.362> }
	smooth_triangle { <6.5332, 4.7179, 36.0102>, <-0.453, -0.854, 0.256>, <5.2973, 4.7142, 32.8243>, <-0.476, -0.860, 0.186>, <6.5122, 4.7309, 36.0163>, <-0.727, -0.597, 0.338> }
	smooth_triangle { <6.5122, 4.7309, 36.0163>, <0.080, 0.996, -0.036>, <5.2973, 4.7142, 32.8243>, <-0.458, 0.812, 0.362>, <5.3218, 4.7120, 32.8180>, <0.514, 0.849, 0.122> }
	smooth_triangle { <6.5122, 4.7309, 36.0163>, <-0.727, -0.597, 0.338>, <5.3218, 4.7120, 32.8180>, <-0.937, 0.010, 0.349>, <6.5102, 4.7554, 36.0102>, <-0.889, 0.384, 0.249> }
	smooth_triangle { <6.5102, 4.7554, 36.0102>, <0.806, 0.506, -0.307>, <5.3218, 4.7120, 32.8180>, <0.514, 0.849, 0.122>, <5.3298, 4.6915, 32.8053>, <0.971, 0.031, -0.236> }
	smooth_triangle { <6.5102, 4.7554, 36.0102>, <-0.889, 0.384, 0.249>, <5.3298, 4.6915, 32.8053>, <-0.446, 0.883, 0.147>, <6.5292, 4.7671, 35.9979>, <-0.159, 0.983, -0.095> }
	smooth_triangle { <6.5292, 4.7671, 35.9979>, <0.761, -0.590, -0.272>, <5.3298, 4.6915, 32.8053>, <0.971, 0.031, -0.236>, <5.3134, 4.6732, 32.7990>, <0.460, -0.815, -0.353> }
	smooth_triangle { <6.5292, 4.7671, 35.9979>, <-0.159, 0.983, -0.095>, <5.3134, 4.6732, 32.7990>, <0.470, 0.859, -0.204>, <6.5501, 4.7541, 35.9918>, <0.724, 0.596, -0.346> }
	smooth_triangle { <6.5501, 4.7541, 35.9918>, <-0.075, -0.996, 0.054>, <5.3134, 4.6732, 32.7990>, <0.460, -0.815, -0.353>, <5.2889, 4.6754, 32.8053>, <-0.511, -0.852, -0.114> }
	smooth_triangle { <6.5501, 4.7541, 35.9918>, <0.724, 0.596, -0.346>, <5.2889, 4.6754, 32.8053>, <0.930, -0.016, -0.368>, <6.5521, 4.7295, 35.9979>, <0.886, -0.386, -0.258> }
	smooth_triangle { <6.5521, 4.7295, 35.9979>, <-0.795, -0.513, 0.323>, <5.2889, 4.6754, 32.8053>, <-0.511, -0.852, -0.114>, <5.2808, 4.6959, 32.8180>, <-0.900, -0.422, 0.110> }
	smooth_triangle { <6.5521, 4.7295, 35.9979>, <0.886, -0.386, -0.258>, <5.2808, 4.6959, 32.8180>, <0.436, -0.885, -0.165>, <6.5332, 4.7179, 36.0102>, <0.527, -0.849, -0.046> }
	smooth_triangle { <7.1157, 5.1514, 37.9069>, <-0.420, -0.895, 0.147>, <6.5332, 4.7179, 36.0102>, <-0.453, -0.854, 0.256>, <6.5122, 4.7309, 36.0163>, <-0.727, -0.597, 0.338> }
	smooth_triangle { <7.1157, 5.1514, 37.9069>, <-0.420, -0.895, 0.147>, <6.5122, 4.7309, 36.0163>, <-0.727, -0.597, 0.338>, <7.0930, 5.1619, 37.9114>, <-0.807, -0.552, 0.211> }
	smooth_triangle { <7.0930, 5.1619, 37.9114>, <-0.863, -0.502, 0.052>, <6.5122, 4.7309, 36.0163>, <-0.727, -0.597, 0.338>, <6.5102, 4.7554, 36.0102>, <-0.889, 0.384, 0.249> }
	smooth_triangle { <7.0930, 5.1619, 37.9114>, <-0.863, -0.502, 0.052>, <6.5102, 4.7554, 36.0102>, <-0.889, 0.384, 0.249>, <7.0894, 5.1866, 37.9069>, <-0.867, 0.474, -0.155> }
	smooth_triangle { <7.0894, 5.1866, 37.9069>, <-0.783, 0.621, -0.042>, <6.5102, 4.7554, 36.0102>, <-0.889, 0.384, 0.249>, <6.5292, 4.7671, 35.9979>, <-0.159, 0.983, -0.095> }
	smooth_triangle { <7.0894, 5.1866, 37.9069>, <-0.783, 0.621, -0.042>, <6.5292, 4.7671, 35.9979>, <-0.159, 0.983, -0.095>, <7.1084, 5.2008, 37.8979>, <-0.009, 0.980, -0.197> }
	smooth_triangle { <7.1084, 5.2008, 37.8979>, <-0.009, 0.980, -0.197>, <6.5292, 4.7671, 35.9979>, <-0.159, 0.983, -0.095>, <6.5501, 4.7541, 35.9918>, <0.724, 0.596, -0.346> }
	smooth_triangle { <7.1084, 5.2008, 37.8979>, <-0.009, 0.980, -0.197>, <6.5501, 4.7541, 35.9918>, <0.724, 0.596, -0.346>, <7.1310, 5.1903, 37.8933>, <0.812, 0.549, -0.197> }
	smooth_triangle { <7.1310, 5.1903, 37.8933>, <0.864, 0.502, -0.031>, <6.5501, 4.7541, 35.9918>, <0.724, 0.596, -0.346>, <6.5521, 4.7295, 35.9979>, <0.886, -0.386, -0.258> }
	smooth_triangle { <7.1310, 5.1903, 37.8933>, <0.864, 0.502, -0.031>, <6.5521, 4.7295, 35.9979>, <0.886, -0.386, -0.258>, <7.1347, 5.1656, 37.8979>, <0.866, -0.468, 0.175> }
	smooth_triangle { <7.1347, 5.1656, 37.8979>, <0.786, -0.615, 0.055>, <6.5521, 4.7295, 35.9979>, <0.886, -0.386, -0.258>, <6.5332, 4.7179, 36.0102>, <0.527, -0.849, -0.046> }
	smooth_triangle { <7.1347, 5.1656, 37.8979>, <0.786, -0.615, 0.055>, <6.5332, 4.7179, 36.0102>, <0.527, -0.849, -0.046>, <7.1157, 5.1514, 37.9069>, <0.652, -0.717, 0.245> }
	smooth_triangle { <6.0443, 5.2960, 39.6273>, <-0.446, -0.872, -0.204>, <7.1157, 5.1514, 37.9069>, <-0.420, -0.895, 0.147>, <7.0930, 5.1619, 37.9114>, <-0.863, -0.502, 0.052> }
	smooth_triangle { <6.0443, 5.2960, 39.6273>, <0.625, 0.702, 0.342>, <7.0930, 5.1619, 37.9114>, <0.785, 0.430, 0.446>, <6.0530, 5.2731, 39.6341>, <0.840, -0.077, 0.538> }
	smooth_triangle { <6.0530, 5.2731, 39.6341>, <-0.842, -0.215, -0.495>, <7.0930, 5.1619, 37.9114>, <-0.938, -0.345, -0.028>, <7.0894, 5.1866, 37.9069>, <-0.963, 0.124, -0.241> }
	smooth_triangle { <6.0530, 5.2731, 39.6341>, <0.840, -0.077, 0.538>, <7.0894, 5.1866, 37.9069>, <0.694, -0.566, 0.445>, <6.0403, 5.2522, 39.6273>, <0.336, -0.900, 0.276> }
	smooth_triangle { <6.0403, 5.2522, 39.6273>, <-0.663, 0.615, -0.428>, <7.0894, 5.1866, 37.9069>, <-0.867, 0.474, -0.155>, <7.1084, 5.2008, 37.8979>, <-0.145, 0.938, -0.316> }
	smooth_triangle { <6.0403, 5.2522, 39.6273>, <0.336, -0.900, 0.276>, <7.1084, 5.2008, 37.8979>, <-0.079, -0.997, -0.019>, <6.0189, 5.2542, 39.6137>, <-0.501, -0.824, -0.266> }
	smooth_triangle { <6.0189, 5.2542, 39.6137>, <0.449, 0.855, 0.259>, <7.1084, 5.2008, 37.8979>, <0.181, 0.978, -0.108>, <7.1310, 5.1903, 37.8933>, <0.864, 0.502, -0.031> }
	smooth_triangle { <6.0189, 5.2542, 39.6137>, <-0.501, -0.824, -0.266>, <7.1310, 5.1903, 37.8933>, <-0.765, -0.432, -0.478>, <6.0102, 5.2771, 39.6069>, <-0.834, 0.076, -0.546> }
	smooth_triangle { <6.0102, 5.2771, 39.6069>, <0.822, 0.218, 0.526>, <7.1310, 5.1903, 37.8933>, <0.938, 0.343, 0.054>, <7.1347, 5.1656, 37.8979>, <0.956, -0.111, 0.271> }
	smooth_triangle { <6.0102, 5.2771, 39.6069>, <-0.834, 0.076, -0.546>, <7.1347, 5.1656, 37.8979>, <-0.673, 0.564, -0.479>, <6.0229, 5.2980, 39.6137>, <-0.330, 0.900, -0.286> }
	smooth_triangle { <6.0229, 5.2980, 39.6137>, <0.661, -0.583, 0.473>, <7.1347, 5.1656, 37.8979>, <0.866, -0.468, 0.175>, <7.1157, 5.1514, 37.9069>, <0.652, -0.717, 0.245> }
	smooth_triangle { <6.0229, 5.2980, 39.6137>, <-0.330, 0.900, -0.286>, <7.1157, 5.1514, 37.9069>, <0.103, 0.994, -0.019>, <6.0443, 5.2960, 39.6273>, <0.103, 0.994, -0.019> }
	smooth_triangle { <4.9244, 5.4326, 41.3171>, <0.765, 0.432, 0.478>, <6.0443, 5.2960, 39.6273>, <0.625, 0.702, 0.342>, <6.0530, 5.2731, 39.6341>, <0.840, -0.077, 0.538> }
	smooth_triangle { <4.9244, 5.4326, 41.3171>, <0.658, -0.562, 0.501>, <6.0530, 5.2731, 39.6341>, <0.840, -0.077, 0.538>, <6.0403, 5.2522, 39.6273>, <0.336, -0.900, 0.276> }
	smooth_triangle { <4.9244, 5.4326, 41.3171>, <-0.115, -0.993, 0.037>, <6.0403, 5.2522, 39.6273>, <0.336, -0.900, 0.276>, <6.0189, 5.2542, 39.6137>, <-0.501, -0.824, -0.266> }
	smooth_triangle { <4.9244, 5.4326, 41.3171>, <-0.782, -0.430, -0.451>, <6.0189, 5.2542, 39.6137>, <-0.501, -0.824, -0.266>, <6.0102, 5.2771, 39.6069>, <-0.834, 0.076, -0.546> }
	smooth_triangle { <4.9244, 5.4326, 41.3171>, <-0.676, 0.564, -0.474>, <6.0102, 5.2771, 39.6069>, <-0.834, 0.076, -0.546>, <6.0229, 5.2980, 39.6137>, <-0.330, 0.900, -0.286> }
	smooth_triangle { <4.9244, 5.4326, 41.3171>, <0.097, 0.995, -0.009>, <6.0229, 5.2980, 39.6137>, <-0.330, 0.900, -0.286>, <6.0443, 5.2960, 39.6273>, <0.625, 0.702, 0.342> }
	smooth_triangle { <4.3659, 3.2254, 31.8907>, <-0.678, 0.251, 0.691>, <3.7988, 4.3911, 30.9098>, <-0.634, 0.167, 0.755>, <3.8153, 4.4076, 30.9199>, <-0.390, 0.358, 0.848> }
	smooth_triangle { <4.3659, 3.2254, 31.8907>, <-0.678, 0.251, 0.691>, <3.8153, 4.4076, 30.9199>, <-0.390, 0.358, 0.848>, <4.3823, 3.2419, 31.9008>, <-0.089, 0.615, 0.783> }
	smooth_triangle { <4.3823, 3.2419, 31.9008>, <-0.089, 0.615, 0.783>, <3.8153, 4.4076, 30.9199>, <-0.390, 0.358, 0.848>, <3.8384, 4.4104, 30.9098>, <0.522, 0.645, 0.558> }
	smooth_triangle { <4.3823, 3.2419, 31.9008>, <-0.089, 0.615, 0.783>, <3.8384, 4.4104, 30.9098>, <0.522, 0.645, 0.558>, <4.4054, 3.2446, 31.8907>, <0.763, 0.591, 0.261> }
	smooth_triangle { <4.4054, 3.2446, 31.8907>, <0.763, 0.591, 0.261>, <3.8384, 4.4104, 30.9098>, <0.522, 0.645, 0.558>, <3.8451, 4.3966, 30.8896>, <0.913, 0.288, -0.290> }
	smooth_triangle { <4.4054, 3.2446, 31.8907>, <0.763, 0.591, 0.261>, <3.8451, 4.3966, 30.8896>, <0.913, 0.288, -0.290>, <4.4121, 3.2309, 31.8704>, <0.853, -0.025, -0.522> }
	smooth_triangle { <4.4121, 3.2309, 31.8704>, <0.853, -0.025, -0.522>, <3.8451, 4.3966, 30.8896>, <0.913, 0.288, -0.290>, <3.8287, 4.3801, 30.8794>, <0.390, -0.358, -0.848> }
	smooth_triangle { <4.4121, 3.2309, 31.8704>, <0.853, -0.025, -0.522>, <3.8287, 4.3801, 30.8794>, <0.390, -0.358, -0.848>, <4.3957, 3.2143, 31.8603>, <0.089, -0.615, -0.783> }
	smooth_triangle { <4.3957, 3.2143, 31.8603>, <0.089, -0.615, -0.783>, <3.8287, 4.3801, 30.8794>, <0.390, -0.358, -0.848>, <3.8056, 4.3774, 30.8896>, <-0.522, -0.645, -0.558> }
	smooth_triangle { <4.3957, 3.2143, 31.8603>, <0.089, -0.615, -0.783>, <3.8056, 4.3774, 30.8896>, <-0.522, -0.645, -0.558>, <4.3726, 3.2116, 31.8704>, <-0.763, -0.591, -0.261> }
	smooth_triangle { <4.3726, 3.2116, 31.8704>, <-0.763, -0.591, -0.261>, <3.8056, 4.3774, 30.8896>, <-0.522, -0.645, -0.558>, <3.7988, 4.3911, 30.9098>, <-0.887, -0.462, 0.007> }
	smooth_triangle { <4.3726, 3.2116, 31.8704>, <-0.763, -0.591, -0.261>, <3.7988, 4.3911, 30.9098>, <-0.887, -0.462, 0.007>, <4.3659, 3.2254, 31.8907>, <-0.899, -0.437, 0.000> }
	smooth_triangle { <5.5964, 1.2072, 32.5166>, <-0.566, -0.004, 0.824>, <3.7988, 4.3911, 30.9098>, <-0.634, 0.167, 0.755>, <3.8153, 4.4076, 30.9199>, <-0.390, 0.358, 0.848> }
	smooth_triangle { <5.5964, 1.2072, 32.5166>, <-0.566, -0.004, 0.824>, <3.8153, 4.4076, 30.9199>, <-0.390, 0.358, 0.848>, <5.6134, 1.2214, 32.5289>, <-0.113, 0.186, 0.976> }
	smooth_triangle { <5.6134, 1.2214, 32.5289>, <-0.113, 0.186, 0.976>, <3.8153, 4.4076, 30.9199>, <-0.390, 0.358, 0.848>, <3.8384, 4.4104, 30.9098>, <0.522, 0.645, 0.558> }
	smooth_triangle { <5.6134, 1.2214, 32.5289>, <-0.113, 0.186, 0.976>, <3.8384, 4.4104, 30.9098>, <0.522, 0.645, 0.558>, <5.6339, 1.2301, 32.5166>, <0.775, 0.376, 0.509> }
	smooth_triangle { <5.6339, 1.2301, 32.5166>, <0.775, 0.376, 0.509>, <3.8384, 4.4104, 30.9098>, <0.522, 0.645, 0.558>, <3.8451, 4.3966, 30.8896>, <0.913, 0.288, -0.290> }
	smooth_triangle { <5.6339, 1.2301, 32.5166>, <0.775, 0.376, 0.509>, <3.8451, 4.3966, 30.8896>, <0.913, 0.288, -0.290>, <5.6373, 1.2246, 32.4921>, <0.870, 0.185, -0.457> }
	smooth_triangle { <5.6373, 1.2246, 32.4921>, <0.870, 0.185, -0.457>, <3.8451, 4.3966, 30.8896>, <0.913, 0.288, -0.290>, <3.8287, 4.3801, 30.8794>, <0.390, -0.358, -0.848> }
	smooth_triangle { <5.6373, 1.2246, 32.4921>, <0.870, 0.185, -0.457>, <3.8287, 4.3801, 30.8794>, <0.390, -0.358, -0.848>, <5.6202, 1.2103, 32.4798>, <0.112, -0.186, -0.976> }
	smooth_triangle { <5.6202, 1.2103, 32.4798>, <0.112, -0.186, -0.976>, <3.8287, 4.3801, 30.8794>, <0.390, -0.358, -0.848>, <3.8056, 4.3774, 30.8896>, <-0.522, -0.645, -0.558> }
	smooth_triangle { <5.6202, 1.2103, 32.4798>, <0.112, -0.186, -0.976>, <3.8056, 4.3774, 30.8896>, <-0.522, -0.645, -0.558>, <5.5997, 1.2017, 32.4921>, <-0.775, -0.375, -0.509> }
	smooth_triangle { <5.5997, 1.2017, 32.4921>, <-0.775, -0.375, -0.509>, <3.8056, 4.3774, 30.8896>, <-0.522, -0.645, -0.558>, <3.7988, 4.3911, 30.9098>, <-0.887, -0.462, 0.007> }
	smooth_triangle { <5.5997, 1.2017, 32.4921>, <-0.775, -0.375, -0.509>, <3.7988, 4.3911, 30.9098>, <-0.887, -0.462, 0.007>, <5.5964, 1.2072, 32.5166>, <-0.947, -0.318, -0.031> }
	smooth_triangle { <6.1506, -1.1625, 32.4341>, <-0.664, -0.217, 0.716>, <5.5964, 1.2072, 32.5166>, <-0.566, -0.004, 0.824>, <5.6134, 1.2214, 32.5289>, <-0.113, 0.186, 0.976> }
	smooth_triangle { <6.1506, -1.1625, 32.4341>, <-0.664, -0.217, 0.716>, <5.6134, 1.2214, 32.5289>, <-0.113, 0.186, 0.976>, <6.1721, -1.1579, 32.4468>, <0.121, -0.020, 0.992> }
	smooth_triangle { <6.1721, -1.1579, 32.4468>, <0.121, -0.020, 0.992>, <5.6134, 1.2214, 32.5289>, <-0.113, 0.186, 0.976>, <5.6339, 1.2301, 32.5166>, <0.775, 0.376, 0.509> }
	smooth_triangle { <6.1721, -1.1579, 32.4468>, <0.121, -0.020, 0.992>, <5.6339, 1.2301, 32.5166>, <0.775, 0.376, 0.509>, <6.1935, -1.1524, 32.4341>, <0.887, 0.205, 0.414> }
	smooth_triangle { <6.1935, -1.1524, 32.4341>, <0.887, 0.205, 0.414>, <5.6339, 1.2301, 32.5166>, <0.775, 0.376, 0.509>, <5.6373, 1.2246, 32.4921>, <0.870, 0.185, -0.457> }
	smooth_triangle { <6.1935, -1.1524, 32.4341>, <0.887, 0.205, 0.414>, <5.6373, 1.2246, 32.4921>, <0.870, 0.185, -0.457>, <6.1933, -1.1516, 32.4087>, <0.774, 0.224, -0.592> }
	smooth_triangle { <6.1933, -1.1516, 32.4087>, <0.774, 0.224, -0.592>, <5.6373, 1.2246, 32.4921>, <0.870, 0.185, -0.457>, <5.6202, 1.2103, 32.4798>, <0.112, -0.186, -0.976> }
	smooth_triangle { <6.1933, -1.1516, 32.4087>, <0.774, 0.224, -0.592>, <5.6202, 1.2103, 32.4798>, <0.112, -0.186, -0.976>, <6.1718, -1.1562, 32.3960>, <-0.119, 0.013, -0.993> }
	smooth_triangle { <6.1718, -1.1562, 32.3960>, <-0.119, 0.013, -0.993>, <5.6202, 1.2103, 32.4798>, <0.112, -0.186, -0.976>, <5.5997, 1.2017, 32.4921>, <-0.775, -0.375, -0.509> }
	smooth_triangle { <6.1718, -1.1562, 32.3960>, <-0.119, 0.013, -0.993>, <5.5997, 1.2017, 32.4921>, <-0.775, -0.375, -0.509>, <6.1504, -1.1616, 32.4087>, <-0.885, -0.213, -0.414> }
	smooth_triangle { <6.1504, -1.1616, 32.4087>, <-0.885, -0.213, -0.414>, <5.5997, 1.2017, 32.4921>, <-0.775, -0.375, -0.509>, <5.5964, 1.2072, 32.5166>, <-0.947, -0.318, -0.031> }
	smooth_triangle { <6.1504, -1.1616, 32.4087>, <-0.885, -0.213, -0.414>, <5.5964, 1.2072, 32.5166>, <-0.947, -0.318, -0.031>, <6.1506, -1.1625, 32.4341>, <-0.974, -0.228, 0.000> }
	smooth_triangle { <6.8678, -3.4897, 32.2794>, <-0.464, -0.205, 0.862>, <6.1506, -1.1625, 32.4341>, <-0.664, -0.217, 0.716>, <6.1721, -1.1579, 32.4468>, <0.121, -0.020, 0.992> }
	smooth_triangle { <6.8678, -3.4897, 32.2794>, <0.495, 0.081, 0.865>, <6.1721, -1.1579, 32.4468>, <0.121, -0.020, 0.992>, <6.1935, -1.1524, 32.4341>, <0.887, 0.205, 0.414> }
	smooth_triangle { <6.8678, -3.4897, 32.2794>, <0.962, 0.273, 0.002>, <6.1935, -1.1524, 32.4341>, <0.887, 0.205, 0.414>, <6.1933, -1.1516, 32.4087>, <0.774, 0.224, -0.592> }
	smooth_triangle { <6.8678, -3.4897, 32.2794>, <0.471, 0.179, -0.864>, <6.1933, -1.1516, 32.4087>, <0.774, 0.224, -0.592>, <6.1718, -1.1562, 32.3960>, <-0.119, 0.013, -0.993> }
	smooth_triangle { <6.8678, -3.4897, 32.2794>, <-0.488, -0.107, -0.866>, <6.1718, -1.1562, 32.3960>, <-0.119, 0.013, -0.993>, <6.1504, -1.1616, 32.4087>, <-0.885, -0.213, -0.414> }
	smooth_triangle { <6.8678, -3.4897, 32.2794>, <-0.954, -0.299, -0.003>, <6.1504, -1.1616, 32.4087>, <-0.885, -0.213, -0.414>, <6.1506, -1.1625, 32.4341>, <-0.664, -0.217, 0.716> }
	smooth_triangle { <5.3723, 4.6589, 31.3115>, <-0.118, -0.530, 0.839>, <3.8229, 4.3717, 30.9120>, <-0.140, -0.534, 0.834>, <3.8158, 4.3927, 30.9243>, <-0.242, -0.251, 0.937> }
	smooth_triangle { <5.3723, 4.6589, 31.3115>, <-0.118, -0.530, 0.839>, <3.8158, 4.3927, 30.9243>, <-0.242, -0.251, 0.937>, <5.3652, 4.6800, 31.3238>, <-0.272, 0.142, 0.952> }
	smooth_triangle { <5.3652, 4.6800, 31.3238>, <-0.272, 0.142, 0.952>, <3.8158, 4.3927, 30.9243>, <-0.242, -0.251, 0.937>, <3.8149, 4.4149, 30.9120>, <-0.373, 0.689, 0.621> }
	smooth_triangle { <5.3652, 4.6800, 31.3238>, <-0.272, 0.142, 0.952>, <3.8149, 4.4149, 30.9120>, <-0.373, 0.689, 0.621>, <5.3642, 4.7022, 31.3115>, <-0.251, 0.914, 0.317> }
	smooth_triangle { <5.3642, 4.7022, 31.3115>, <-0.251, 0.914, 0.317>, <3.8149, 4.4149, 30.9120>, <-0.373, 0.689, 0.621>, <3.8210, 4.4161, 30.8874>, <-0.130, 0.940, -0.316> }
	smooth_triangle { <5.3642, 4.7022, 31.3115>, <-0.251, 0.914, 0.317>, <3.8210, 4.4161, 30.8874>, <-0.130, 0.940, -0.316>, <5.3704, 4.7033, 31.2868>, <0.020, 0.773, -0.635> }
	smooth_triangle { <5.3704, 4.7033, 31.2868>, <0.020, 0.773, -0.635>, <3.8210, 4.4161, 30.8874>, <-0.130, 0.940, -0.316>, <3.8281, 4.3950, 30.8751>, <0.242, 0.251, -0.937> }
	smooth_triangle { <5.3704, 4.7033, 31.2868>, <0.020, 0.773, -0.635>, <3.8281, 4.3950, 30.8751>, <0.242, 0.251, -0.937>, <5.3775, 4.6823, 31.2745>, <0.272, -0.142, -0.952> }
	smooth_triangle { <5.3775, 4.6823, 31.2745>, <0.272, -0.142, -0.952>, <3.8281, 4.3950, 30.8751>, <0.242, 0.251, -0.937>, <3.8291, 4.3728, 30.8874>, <0.373, -0.689, -0.621> }
	smooth_triangle { <5.3775, 4.6823, 31.2745>, <0.272, -0.142, -0.952>, <3.8291, 4.3728, 30.8874>, <0.373, -0.689, -0.621>, <5.3784, 4.6601, 31.2868>, <0.251, -0.914, -0.317> }
	smooth_triangle { <5.3784, 4.6601, 31.2868>, <0.251, -0.914, -0.317>, <3.8291, 4.3728, 30.8874>, <0.373, -0.689, -0.621>, <3.8229, 4.3717, 30.9120>, <0.242, -0.970, -0.002> }
	smooth_triangle { <5.3784, 4.6601, 31.2868>, <0.251, -0.914, -0.317>, <3.8229, 4.3717, 30.9120>, <0.242, -0.970, -0.002>, <5.3723, 4.6589, 31.3115>, <0.182, -0.983, 0.000> }
	smooth_triangle { <7.4180, 5.4977, 32.3437>, <-0.076, -0.546, 0.834>, <3.8229, 4.3717, 30.9120>, <-0.140, -0.534, 0.834>, <3.8158, 4.3927, 30.9243>, <-0.242, -0.251, 0.937> }
	smooth_triangle { <7.4180, 5.4977, 32.3437>, <-0.076, -0.546, 0.834>, <3.8158, 4.3927, 30.9243>, <-0.242, -0.251, 0.937>, <7.4046, 5.5160, 32.3552>, <-0.191, -0.071, 0.979> }
	smooth_triangle { <7.4046, 5.5160, 32.3552>, <-0.191, -0.071, 0.979>, <3.8158, 4.3927, 30.9243>, <-0.242, -0.251, 0.937>, <3.8149, 4.4149, 30.9120>, <-0.373, 0.689, 0.621> }
	smooth_triangle { <7.4046, 5.5160, 32.3552>, <-0.191, -0.071, 0.979>, <3.8149, 4.4149, 30.9120>, <-0.373, 0.689, 0.621>, <7.4012, 5.5383, 32.3437>, <-0.274, 0.809, 0.520> }
	smooth_triangle { <7.4012, 5.5383, 32.3437>, <-0.274, 0.809, 0.520>, <3.8149, 4.4149, 30.9120>, <-0.373, 0.689, 0.621>, <3.8210, 4.4161, 30.8874>, <-0.130, 0.940, -0.316> }
	smooth_triangle { <7.4012, 5.5383, 32.3437>, <-0.274, 0.809, 0.520>, <3.8210, 4.4161, 30.8874>, <-0.130, 0.940, -0.316>, <7.4112, 5.5424, 32.3207>, <-0.084, 0.885, -0.458> }
	smooth_triangle { <7.4112, 5.5424, 32.3207>, <-0.084, 0.885, -0.458>, <3.8210, 4.4161, 30.8874>, <-0.130, 0.940, -0.316>, <3.8281, 4.3950, 30.8751>, <0.242, 0.251, -0.937> }
	smooth_triangle { <7.4112, 5.5424, 32.3207>, <-0.084, 0.885, -0.458>, <3.8281, 4.3950, 30.8751>, <0.242, 0.251, -0.937>, <7.4245, 5.5241, 32.3092>, <0.190, 0.071, -0.979> }
	smooth_triangle { <7.4245, 5.5241, 32.3092>, <0.190, 0.071, -0.979>, <3.8281, 4.3950, 30.8751>, <0.242, 0.251, -0.937>, <3.8291, 4.3728, 30.8874>, <0.373, -0.689, -0.621> }
	smooth_triangle { <7.4245, 5.5241, 32.3092>, <0.190, 0.071, -0.979>, <3.8291, 4.3728, 30.8874>, <0.373, -0.689, -0.621>, <7.4279, 5.5017, 32.3207>, <0.273, -0.809, -0.520> }
	smooth_triangle { <7.4279, 5.5017, 32.3207>, <0.273, -0.809, -0.520>, <3.8291, 4.3728, 30.8874>, <0.373, -0.689, -0.621>, <3.8229, 4.3717, 30.9120>, <0.242, -0.970, -0.002> }
	smooth_triangle { <7.4279, 5.5017, 32.3207>, <0.273, -0.809, -0.520>, <3.8229, 4.3717, 30.9120>, <0.242, -0.970, -0.002>, <7.4180, 5.4977, 32.3437>, <0.218, -0.975, -0.045> }
	smooth_triangle { <9.8202, 5.9141, 32.3977>, <0.170, -0.675, 0.718>, <7.4180, 5.4977, 32.3437>, <-0.076, -0.546, 0.834>, <7.4046, 5.5160, 32.3552>, <-0.191, -0.071, 0.979> }
	smooth_triangle { <9.8202, 5.9141, 32.3977>, <0.170, -0.675, 0.718>, <7.4046, 5.5160, 32.3552>, <-0.191, -0.071, 0.979>, <9.8161, 5.9357, 32.4104>, <0.104, 0.122, 0.987> }
	smooth_triangle { <9.8161, 5.9357, 32.4104>, <0.104, 0.122, 0.987>, <7.4046, 5.5160, 32.3552>, <-0.191, -0.071, 0.979>, <7.4012, 5.5383, 32.3437>, <-0.274, 0.809, 0.520> }
	smooth_triangle { <9.8161, 5.9357, 32.4104>, <0.104, 0.122, 0.987>, <7.4012, 5.5383, 32.3437>, <-0.274, 0.809, 0.520>, <9.8127, 5.9575, 32.3977>, <-0.072, 0.909, 0.410> }
	smooth_triangle { <9.8127, 5.9575, 32.3977>, <-0.072, 0.909, 0.410>, <7.4012, 5.5383, 32.3437>, <-0.274, 0.809, 0.520>, <7.4112, 5.5424, 32.3207>, <-0.084, 0.885, -0.458> }
	smooth_triangle { <9.8127, 5.9575, 32.3977>, <-0.072, 0.909, 0.410>, <7.4112, 5.5424, 32.3207>, <-0.084, 0.885, -0.458>, <9.8132, 5.9576, 32.3723>, <-0.171, 0.786, -0.594> }
	smooth_triangle { <9.8132, 5.9576, 32.3723>, <-0.171, 0.786, -0.594>, <7.4112, 5.5424, 32.3207>, <-0.084, 0.885, -0.458>, <7.4245, 5.5241, 32.3092>, <0.190, 0.071, -0.979> }
	smooth_triangle { <9.8132, 5.9576, 32.3723>, <-0.171, 0.786, -0.594>, <7.4245, 5.5241, 32.3092>, <0.190, 0.071, -0.979>, <9.8172, 5.9359, 32.3596>, <-0.097, -0.121, -0.988> }
	smooth_triangle { <9.8172, 5.9359, 32.3596>, <-0.097, -0.121, -0.988>, <7.4245, 5.5241, 32.3092>, <0.190, 0.071, -0.979>, <7.4279, 5.5017, 32.3207>, <0.273, -0.809, -0.520> }
	smooth_triangle { <9.8172, 5.9359, 32.3596>, <-0.097, -0.121, -0.988>, <7.4279, 5.5017, 32.3207>, <0.273, -0.809, -0.520>, <9.8207, 5.9142, 32.3723>, <0.080, -0.908, -0.411> }
	smooth_triangle { <9.8207, 5.9142, 32.3723>, <0.080, -0.908, -0.411>, <7.4279, 5.5017, 32.3207>, <0.273, -0.809, -0.520>, <7.4180, 5.4977, 32.3437>, <0.218, -0.975, -0.045> }
	smooth_triangle { <9.8207, 5.9142, 32.3723>, <0.080, -0.908, -0.411>, <7.4180, 5.4977, 32.3437>, <0.218, -0.975, -0.045>, <9.8202, 5.9141, 32.3977>, <0.171, -0.985, 0.000> }
	smooth_triangle { <12.1050, 6.1987, 31.5848>, <0.353, -0.447, 0.822>, <9.8202, 5.9141, 32.3977>, <0.170, -0.675, 0.718>, <9.8161, 5.9357, 32.4104>, <0.104, 0.122, 0.987> }
	smooth_triangle { <12.1050, 6.1987, 31.5848>, <0.237, 0.533, 0.812>, <9.8161, 5.9357, 32.4104>, <0.104, 0.122, 0.987>, <9.8127, 5.9575, 32.3977>, <-0.072, 0.909, 0.410> }
	smooth_triangle { <12.1050, 6.1987, 31.5848>, <-0.103, 0.995, -0.008>, <9.8127, 5.9575, 32.3977>, <-0.072, 0.909, 0.410>, <9.8132, 5.9576, 32.3723>, <-0.171, 0.786, -0.594> }
	smooth_triangle { <12.1050, 6.1987, 31.5848>, <-0.328, 0.452, -0.829>, <9.8132, 5.9576, 32.3723>, <-0.171, 0.786, -0.594>, <9.8172, 5.9359, 32.3596>, <-0.097, -0.121, -0.988> }
	smooth_triangle { <12.1050, 6.1987, 31.5848>, <-0.212, -0.532, -0.820>, <9.8172, 5.9359, 32.3596>, <-0.097, -0.121, -0.988>, <9.8207, 5.9142, 32.3723>, <0.080, -0.908, -0.411> }
	smooth_triangle { <12.1050, 6.1987, 31.5848>, <0.130, -0.992, 0.004>, <9.8207, 5.9142, 32.3723>, <0.080, -0.908, -0.411>, <9.8202, 5.9141, 32.3977>, <0.170, -0.675, 0.718> }
	smooth_triangle { <4.4926, 5.4109, 31.9764>, <0.118, -0.748, 0.653>, <3.8361, 4.3751, 30.9093>, <0.090, -0.790, 0.606>, <3.8131, 4.3798, 30.9188>, <-0.247, -0.647, 0.722> }
	smooth_triangle { <4.4926, 5.4109, 31.9764>, <0.118, -0.748, 0.653>, <3.8131, 4.3798, 30.9188>, <-0.247, -0.647, 0.722>, <4.4695, 5.4156, 31.9859>, <-0.505, -0.443, 0.741> }
	smooth_triangle { <4.4695, 5.4156, 31.9859>, <-0.505, -0.443, 0.741>, <3.8131, 4.3798, 30.9188>, <-0.247, -0.647, 0.722>, <3.7989, 4.3986, 30.9093>, <-0.858, 0.113, 0.500> }
	smooth_triangle { <4.4695, 5.4156, 31.9859>, <-0.505, -0.443, 0.741>, <3.7989, 4.3986, 30.9093>, <-0.858, 0.113, 0.500>, <4.4554, 5.4344, 31.9764>, <-0.913, 0.324, 0.247> }
	smooth_triangle { <4.4554, 5.4344, 31.9764>, <-0.913, 0.324, 0.247>, <3.7989, 4.3986, 30.9093>, <-0.858, 0.113, 0.500>, <3.8079, 4.4127, 30.8901>, <-0.611, 0.760, -0.222> }
	smooth_triangle { <4.4554, 5.4344, 31.9764>, <-0.913, 0.324, 0.247>, <3.8079, 4.4127, 30.8901>, <-0.611, 0.760, -0.222>, <4.4643, 5.4485, 31.9572>, <-0.408, 0.768, -0.494> }
	smooth_triangle { <4.4643, 5.4485, 31.9572>, <-0.408, 0.768, -0.494>, <3.8079, 4.4127, 30.8901>, <-0.611, 0.760, -0.222>, <3.8309, 4.4079, 30.8805>, <0.247, 0.646, -0.722> }
	smooth_triangle { <4.4643, 5.4485, 31.9572>, <-0.408, 0.768, -0.494>, <3.8309, 4.4079, 30.8805>, <0.247, 0.646, -0.722>, <4.4874, 5.4438, 31.9476>, <0.505, 0.443, -0.741> }
	smooth_triangle { <4.4874, 5.4438, 31.9476>, <0.505, 0.443, -0.741>, <3.8309, 4.4079, 30.8805>, <0.247, 0.646, -0.722>, <3.8450, 4.3891, 30.8901>, <0.858, -0.113, -0.500> }
	smooth_triangle { <4.4874, 5.4438, 31.9476>, <0.505, 0.443, -0.741>, <3.8450, 4.3891, 30.8901>, <0.858, -0.113, -0.500>, <4.5015, 5.4250, 31.9572>, <0.913, -0.324, -0.247> }
	smooth_triangle { <4.5015, 5.4250, 31.9572>, <0.913, -0.324, -0.247>, <3.8450, 4.3891, 30.8901>, <0.858, -0.113, -0.500>, <3.8361, 4.3751, 30.9093>, <0.779, -0.626, -0.007> }
	smooth_triangle { <4.5015, 5.4250, 31.9572>, <0.913, -0.324, -0.247>, <3.8361, 4.3751, 30.9093>, <0.779, -0.626, -0.007>, <4.4926, 5.4109, 31.9764>, <0.845, -0.535, 0.000> }
	smooth_triangle { <5.9204, 6.3894, 33.6832>, <-0.116, -0.779, 0.616>, <3.8361, 4.3751, 30.9093>, <0.090, -0.790, 0.606>, <3.8131, 4.3798, 30.9188>, <-0.247, -0.647, 0.722> }
	smooth_triangle { <5.9204, 6.3894, 33.6832>, <-0.116, -0.779, 0.616>, <3.8131, 4.3798, 30.9188>, <-0.247, -0.647, 0.722>, <5.9007, 6.4025, 33.6922>, <-0.538, -0.501, 0.678> }
	smooth_triangle { <5.9007, 6.4025, 33.6922>, <-0.538, -0.501, 0.678>, <3.8131, 4.3798, 30.9188>, <-0.247, -0.647, 0.722>, <3.7989, 4.3986, 30.9093>, <-0.858, 0.113, 0.500> }
	smooth_triangle { <5.9007, 6.4025, 33.6922>, <-0.650, -0.384, 0.656>, <3.7989, 4.3986, 30.9093>, <-0.858, 0.113, 0.500>, <5.8956, 6.4257, 33.6832>, <-0.910, 0.327, 0.253> }
	smooth_triangle { <5.8956, 6.4257, 33.6832>, <-0.910, 0.327, 0.253>, <3.7989, 4.3986, 30.9093>, <-0.858, 0.113, 0.500>, <3.8079, 4.4127, 30.8901>, <-0.611, 0.760, -0.222> }
	smooth_triangle { <5.8956, 6.4257, 33.6832>, <-0.870, 0.464, 0.170>, <3.8079, 4.4127, 30.8901>, <-0.611, 0.760, -0.222>, <5.9103, 6.4358, 33.6650>, <-0.375, 0.826, -0.420> }
	smooth_triangle { <5.9103, 6.4358, 33.6650>, <-0.375, 0.826, -0.420>, <3.8079, 4.4127, 30.8901>, <-0.611, 0.760, -0.222>, <3.8309, 4.4079, 30.8805>, <0.247, 0.646, -0.722> }
	smooth_triangle { <5.9103, 6.4358, 33.6650>, <-0.227, 0.848, -0.480>, <3.8309, 4.4079, 30.8805>, <0.247, 0.646, -0.722>, <5.9300, 6.4226, 33.6560>, <0.539, 0.502, -0.677> }
	smooth_triangle { <5.9300, 6.4226, 33.6560>, <0.539, 0.502, -0.677>, <3.8309, 4.4079, 30.8805>, <0.247, 0.646, -0.722>, <3.8450, 4.3891, 30.8901>, <0.858, -0.113, -0.500> }
	smooth_triangle { <5.9300, 6.4226, 33.6560>, <0.651, 0.385, -0.654>, <3.8450, 4.3891, 30.8901>, <0.858, -0.113, -0.500>, <5.9351, 6.3994, 33.6650>, <0.911, -0.327, -0.253> }
	smooth_triangle { <5.9351, 6.3994, 33.6650>, <0.911, -0.327, -0.253>, <3.8450, 4.3891, 30.8901>, <0.858, -0.113, -0.500>, <3.8361, 4.3751, 30.9093>, <0.779, -0.626, -0.007> }
	smooth_triangle { <5.9351, 6.3994, 33.6650>, <0.870, -0.462, -0.168>, <3.8361, 4.3751, 30.9093>, <0.779, -0.626, -0.007>, <5.9204, 6.3894, 33.6832>, <0.765, -0.636, 0.102> }
	smooth_triangle { <6.5846, 7.7357, 35.6100>, <0.000, -0.868, 0.497>, <5.9204, 6.3894, 33.6832>, <-0.116, -0.779, 0.616>, <5.9007, 6.4025, 33.6922>, <-0.538, -0.501, 0.678> }
	smooth_triangle { <6.5846, 7.7357, 35.6100>, <0.205, -0.922, 0.327>, <5.9007, 6.4025, 33.6922>, <-0.265, -0.687, 0.677>, <6.5604, 7.7364, 35.6178>, <-0.351, -0.717, 0.602> }
	smooth_triangle { <6.5604, 7.7364, 35.6178>, <-0.805, -0.250, 0.538>, <5.9007, 6.4025, 33.6922>, <-0.650, -0.384, 0.656>, <5.8956, 6.4257, 33.6832>, <-0.910, 0.327, 0.253> }
	smooth_triangle { <6.5604, 7.7364, 35.6178>, <-0.521, -0.615, 0.592>, <5.8956, 6.4257, 33.6832>, <-0.898, 0.062, 0.436>, <6.5450, 7.7550, 35.6100>, <-0.883, 0.117, 0.454> }
	smooth_triangle { <6.5450, 7.7550, 35.6100>, <-0.800, 0.599, 0.044>, <5.8956, 6.4257, 33.6832>, <-0.870, 0.464, 0.170>, <5.9103, 6.4358, 33.6650>, <-0.375, 0.826, -0.420> }
	smooth_triangle { <6.5450, 7.7550, 35.6100>, <-0.909, 0.258, 0.326>, <5.9103, 6.4358, 33.6650>, <-0.632, 0.738, -0.235>, <6.5538, 7.7731, 35.5945>, <-0.531, 0.835, -0.144> }
	smooth_triangle { <6.5538, 7.7731, 35.5945>, <0.002, 0.871, -0.492>, <5.9103, 6.4358, 33.6650>, <-0.227, 0.848, -0.480>, <5.9300, 6.4226, 33.6560>, <0.539, 0.502, -0.677> }
	smooth_triangle { <6.5538, 7.7731, 35.5945>, <-0.387, 0.882, -0.268>, <5.9300, 6.4226, 33.6560>, <0.265, 0.687, -0.677>, <6.5780, 7.7725, 35.5867>, <0.354, 0.721, -0.596> }
	smooth_triangle { <6.5780, 7.7725, 35.5867>, <0.807, 0.253, -0.533>, <5.9300, 6.4226, 33.6560>, <0.651, 0.385, -0.654>, <5.9351, 6.3994, 33.6650>, <0.911, -0.327, -0.253> }
	smooth_triangle { <6.5780, 7.7725, 35.5867>, <0.524, 0.618, -0.586>, <5.9351, 6.3994, 33.6650>, <0.898, -0.062, -0.436>, <6.5934, 7.7538, 35.5945>, <0.886, -0.114, -0.449> }
	smooth_triangle { <6.5934, 7.7538, 35.5945>, <0.802, -0.596, -0.040>, <5.9351, 6.3994, 33.6650>, <0.870, -0.462, -0.168>, <5.9204, 6.3894, 33.6832>, <0.765, -0.636, 0.102> }
	smooth_triangle { <6.5934, 7.7538, 35.5945>, <0.912, -0.255, -0.321>, <5.9204, 6.3894, 33.6832>, <0.765, -0.636, 0.102>, <6.5846, 7.7357, 35.6100>, <0.898, -0.440, -0.002> }
	smooth_triangle { <8.0681, 8.4580, 37.3923>, <0.054, -0.938, 0.341>, <6.5846, 7.7357, 35.6100>, <0.205, -0.922, 0.327>, <6.5604, 7.7364, 35.6178>, <-0.351, -0.717, 0.602> }
	smooth_triangle { <8.0681, 8.4580, 37.3923>, <-0.661, -0.299, 0.689>, <6.5604, 7.7364, 35.6178>, <-0.521, -0.615, 0.592>, <6.5450, 7.7550, 35.6100>, <-0.883, 0.117, 0.454> }
	smooth_triangle { <8.0681, 8.4580, 37.3923>, <-0.693, 0.631, 0.349>, <6.5450, 7.7550, 35.6100>, <-0.909, 0.258, 0.326>, <6.5538, 7.7731, 35.5945>, <-0.531, 0.835, -0.144> }
	smooth_triangle { <8.0681, 8.4580, 37.3923>, <-0.042, 0.947, -0.319>, <6.5538, 7.7731, 35.5945>, <-0.387, 0.882, -0.268>, <6.5780, 7.7725, 35.5867>, <0.354, 0.721, -0.596> }
	smooth_triangle { <8.0681, 8.4580, 37.3923>, <0.675, 0.311, -0.669>, <6.5780, 7.7725, 35.5867>, <0.524, 0.618, -0.586>, <6.5934, 7.7538, 35.5945>, <0.886, -0.114, -0.449> }
	smooth_triangle { <8.0681, 8.4580, 37.3923>, <0.708, -0.623, -0.331>, <6.5934, 7.7538, 35.5945>, <0.912, -0.255, -0.321>, <6.5846, 7.7357, 35.6100>, <0.354, -0.915, 0.195> }

	texture { PSWL_BARK }
}

/* Object 'PWL0011F' */
union {
	smooth_triangle { <2.9484, 4.4783, 29.7791>, <0.708, 0.520, -0.478>, <3.0327, 3.9068, 29.2277>, <0.755, 0.510, -0.413>, <3.4596, 3.2695, 29.2216>, <0.708, 0.520, -0.478> }
	smooth_triangle { <3.4596, 3.2695, 29.2216>, <0.708, 0.520, -0.478>, <3.4191, 3.8507, 29.7386>, <0.656, 0.527, -0.541>, <2.9484, 4.4783, 29.7791>, <0.708, 0.520, -0.478> }
	smooth_triangle { <3.8419, 4.4422, 30.8892>, <-0.652, 0.407, 0.640>, <3.9033, 5.0249, 30.5440>, <-0.705, 0.415, 0.575>, <4.3084, 5.5745, 30.6440>, <-0.652, 0.407, 0.640> }
	smooth_triangle { <4.3084, 5.5745, 30.6440>, <-0.652, 0.407, 0.640>, <4.2789, 4.9703, 30.9607>, <-0.593, 0.396, 0.701>, <3.8419, 4.4422, 30.8892>, <-0.652, 0.407, 0.640> }
	smooth_triangle { <4.5840, 4.4952, 31.8475>, <0.668, 0.386, -0.635>, <4.6265, 4.0474, 31.6157>, <0.676, 0.388, -0.626>, <4.9413, 3.6416, 31.7042>, <0.668, 0.386, -0.635> }
	smooth_triangle { <4.9413, 3.6416, 31.7042>, <0.668, 0.386, -0.635>, <4.8980, 4.1023, 31.9346>, <0.660, 0.385, -0.645>, <4.5840, 4.4952, 31.8475>, <0.668, 0.386, -0.635> }
	smooth_triangle { <5.3336, 4.7296, 32.7841>, <-0.528, 0.737, 0.422>, <5.4359, 5.0491, 32.3471>, <-0.535, 0.737, 0.414>, <5.8996, 5.4502, 32.2320>, <-0.528, 0.737, 0.422> }
	smooth_triangle { <5.8996, 5.4502, 32.2320>, <-0.528, 0.737, 0.422>, <5.7964, 5.1220, 32.6709>, <-0.521, 0.738, 0.429>, <5.3336, 4.7296, 32.7841>, <-0.528, 0.737, 0.422> }
	smooth_triangle { <6.0689, 4.7347, 33.7627>, <0.697, 0.539, -0.473>, <6.2123, 4.2595, 33.3784>, <0.749, 0.538, -0.386>, <6.5833, 3.7967, 33.4526>, <0.697, 0.539, -0.473> }
	smooth_triangle { <6.5833, 3.7967, 33.4526>, <0.697, 0.539, -0.473>, <6.4778, 4.2903, 33.8062>, <0.639, 0.534, -0.554>, <6.0689, 4.7347, 33.7627>, <0.697, 0.539, -0.473> }
	smooth_triangle { <6.7964, 4.9151, 34.7290>, <-0.745, 0.362, 0.560>, <6.7495, 5.3493, 34.4447>, <-0.646, 0.368, 0.669>, <7.0416, 5.8355, 34.4596>, <-0.745, 0.362, 0.560> }
	smooth_triangle { <7.0416, 5.8355, 34.4596>, <-0.745, 0.362, 0.560>, <7.0271, 5.3816, 34.7926>, <-0.827, 0.349, 0.440>, <6.7964, 4.9151, 34.7290>, <-0.745, 0.362, 0.560> }
	smooth_triangle { <6.7476, 5.3315, 35.4106>, <-0.672, 0.566, -0.479>, <7.1056, 5.5232, 35.0740>, <-0.681, 0.636, -0.362>, <7.4413, 5.9092, 35.1200>, <-0.672, 0.566, -0.479> }
	smooth_triangle { <7.4413, 5.9092, 35.1200>, <-0.672, 0.566, -0.479>, <7.0633, 5.7683, 35.4222>, <-0.649, 0.485, -0.586>, <6.7476, 5.3315, 35.4106>, <-0.672, 0.566, -0.479> }
	smooth_triangle { <6.5997, 5.7653, 36.0859>, <-0.750, -0.631, 0.200>, <6.1751, 6.0292, 35.4866>, <-0.762, -0.581, 0.284>, <5.6782, 6.6500, 35.4240>, <-0.750, -0.631, 0.200> }
	smooth_triangle { <5.6782, 6.6500, 35.4240>, <-0.750, -0.631, 0.200>, <6.1332, 6.2725, 36.0988>, <-0.730, -0.674, 0.115>, <6.5997, 5.7653, 36.0859>, <-0.750, -0.631, 0.200> }
	smooth_triangle { <6.8421, 6.4196, 36.5439>, <-0.579, 0.642, -0.502>, <7.1999, 6.5335, 36.2689>, <-0.581, 0.652, -0.486>, <7.6744, 6.9692, 36.2862>, <-0.579, 0.642, -0.502> }
	smooth_triangle { <7.6744, 6.9692, 36.2862>, <-0.579, 0.642, -0.502>, <7.3036, 6.8549, 36.5600>, <-0.577, 0.631, -0.518>, <6.8421, 6.4196, 36.5439>, <-0.579, 0.642, -0.502> }
	smooth_triangle { <6.9112, 7.0432, 37.0024>, <0.043, -0.569, 0.821>, <6.1479, 6.6942, 36.8052>, <0.041, -0.558, 0.829>, <5.4943, 6.8710, 36.9568>, <0.043, -0.569, 0.821> }
	smooth_triangle { <5.4943, 6.8710, 36.9568>, <0.043, -0.569, 0.821>, <6.2788, 7.2150, 37.1595>, <0.044, -0.580, 0.813>, <6.9112, 7.0432, 37.0024>, <0.043, -0.569, 0.821> }
	smooth_triangle { <5.6469, 5.1629, 33.0057>, <-0.387, 0.547, -0.742>, <6.0216, 4.7761, 32.5093>, <-0.369, 0.577, -0.728>, <6.7093, 4.8636, 32.2300>, <-0.387, 0.547, -0.742> }
	smooth_triangle { <6.7093, 4.8636, 32.2300>, <-0.387, 0.547, -0.742>, <6.3252, 5.2636, 32.7104>, <-0.405, 0.517, -0.754>, <5.6469, 5.1629, 33.0057>, <-0.387, 0.547, -0.742> }
	smooth_triangle { <5.8595, 5.6844, 33.2596>, <-0.222, -0.301, 0.927>, <5.3458, 5.7701, 33.1638>, <-0.224, -0.304, 0.926>, <5.0361, 6.2095, 33.2335>, <-0.222, -0.301, 0.927> }
	smooth_triangle { <5.0361, 6.2095, 33.2335>, <-0.222, -0.301, 0.927>, <5.5618, 6.1169, 33.3281>, <-0.220, -0.298, 0.929>, <5.8595, 5.6844, 33.2596>, <-0.222, -0.301, 0.927> }
	smooth_triangle { <6.9106, 5.9318, 33.8942>, <0.335, 0.746, -0.575>, <7.0305, 5.5666, 33.4770>, <0.360, 0.751, -0.554>, <7.4623, 5.2891, 33.3813>, <0.335, 0.746, -0.575> }
	smooth_triangle { <7.4623, 5.2891, 33.3813>, <0.335, 0.746, -0.575>, <7.3445, 5.6665, 33.7896>, <0.309, 0.741, -0.596>, <6.9106, 5.9318, 33.8942>, <0.335, 0.746, -0.575> }
	smooth_triangle { <7.8617, 6.3224, 34.5547>, <-0.540, 0.481, 0.690>, <7.7269, 6.6974, 34.1480>, <-0.635, 0.451, 0.627>, <7.9495, 7.1980, 34.0132>, <-0.540, 0.481, 0.690> }
	smooth_triangle { <7.9495, 7.1980, 34.0132>, <-0.540, 0.481, 0.690>, <8.1198, 6.8224, 34.3678>, <-0.438, 0.504, 0.744>, <7.8617, 6.3224, 34.5547>, <-0.540, 0.481, 0.690> }
	smooth_triangle { <8.3089, 5.9818, 35.4451>, <0.820, 0.515, -0.250>, <8.3729, 5.6567, 35.0677>, <0.778, 0.535, -0.329>, <8.6878, 5.1770, 35.0317>, <0.820, 0.515, -0.250> }
	smooth_triangle { <8.6878, 5.1770, 35.0317>, <0.820, 0.515, -0.250>, <8.5586, 5.5483, 35.4540>, <0.856, 0.489, -0.169>, <8.3089, 5.9818, 35.4451>, <0.820, 0.515, -0.250> }
	smooth_triangle { <8.7677, 5.7778, 36.3300>, <-0.008, 0.989, 0.151>, <9.2619, 5.8932, 35.7682>, <0.028, 0.974, 0.225>, <10.0051, 5.8749, 35.7548>, <-0.008, 0.989, 0.151> }
	smooth_triangle { <10.0051, 5.8749, 35.7548>, <-0.008, 0.989, 0.151>, <9.4171, 5.8026, 36.3747>, <-0.043, 0.996, 0.075>, <8.7677, 5.7778, 36.3300>, <-0.008, 0.989, 0.151> }
	smooth_triangle { <8.6731, 5.3153, 37.2594>, <0.071, -0.890, -0.450>, <8.1721, 5.3840, 37.0416>, <0.071, -0.893, -0.445>, <7.6600, 5.2479, 37.2333>, <0.071, -0.890, -0.450> }
	smooth_triangle { <7.6600, 5.2479, 37.2333>, <0.071, -0.890, -0.450>, <8.1752, 5.1777, 37.4503>, <0.071, -0.888, -0.455>, <8.6731, 5.3153, 37.2594>, <0.071, -0.890, -0.450> }
	smooth_triangle { <8.7762, 4.8357, 38.1548>, <0.588, 0.690, 0.422>, <9.2137, 4.6418, 37.7765>, <0.587, 0.755, 0.293>, <9.6665, 4.2576, 37.8584>, <0.588, 0.690, 0.422> }
	smooth_triangle { <9.6665, 4.2576, 37.8584>, <0.588, 0.690, 0.422>, <9.2177, 4.3782, 38.2000>, <0.577, 0.610, 0.543>, <8.7762, 4.8357, 38.1548>, <0.588, 0.690, 0.422> }
	smooth_triangle { <8.8160, 4.7039, 39.1561>, <0.483, -0.855, -0.188>, <8.2470, 4.4358, 38.7312>, <0.467, -0.881, -0.070>, <7.7332, 4.1509, 38.8872>, <0.483, -0.855, -0.188> }
	smooth_triangle { <7.7332, 4.1509, 38.8872>, <0.483, -0.855, -0.188>, <8.3184, 4.3576, 39.2812>, <0.492, -0.816, -0.303>, <8.8160, 4.7039, 39.1561>, <0.483, -0.855, -0.188> }
	smooth_triangle { <9.0263, 4.5553, 40.1478>, <0.698, 0.711, -0.080>, <9.4277, 4.0525, 39.5683>, <0.667, 0.726, -0.168>, <9.9175, 3.6274, 39.6761>, <0.698, 0.711, -0.080> }
	smooth_triangle { <9.9175, 3.6274, 39.6761>, <0.698, 0.711, -0.080>, <9.5050, 4.0526, 40.2168>, <0.724, 0.690, 0.009>, <9.0263, 4.5553, 40.1478>, <0.698, 0.711, -0.080> }
	smooth_triangle { <5.8996, 4.6088, 32.9305>, <0.238, 0.785, -0.571>, <5.7811, 4.3428, 32.4721>, <0.348, 0.769, -0.536>, <6.0474, 4.0346, 32.2029>, <0.238, 0.785, -0.571> }
	smooth_triangle { <6.0474, 4.0346, 32.2029>, <0.238, 0.785, -0.571>, <6.1855, 4.3068, 32.5914>, <0.126, 0.791, -0.599>, <5.8996, 4.6088, 32.9305>, <0.238, 0.785, -0.571> }
	smooth_triangle { <6.4884, 4.6339, 33.1052>, <-0.094, 0.530, 0.843>, <6.3798, 5.0169, 32.8690>, <-0.025, 0.520, 0.854>, <6.6761, 5.3745, 32.6602>, <-0.094, 0.530, 0.843> }
	smooth_triangle { <6.6761, 5.3745, 32.6602>, <-0.094, 0.530, 0.843>, <6.7733, 4.9818, 32.9347>, <-0.162, 0.538, 0.827>, <6.4884, 4.6339, 33.1052>, <-0.094, 0.530, 0.843> }
	smooth_triangle { <7.0906, 4.2156, 34.1186>, <0.738, -0.327, -0.590>, <6.6278, 3.6740, 33.8469>, <0.731, -0.324, -0.600>, <6.4960, 2.9408, 34.0817>, <0.738, -0.327, -0.590> }
	smooth_triangle { <6.4960, 2.9408, 34.0817>, <0.738, -0.327, -0.590>, <6.9613, 3.5035, 34.3587>, <0.745, -0.331, -0.580>, <7.0906, 4.2156, 34.1186>, <0.738, -0.327, -0.590> }
	smooth_triangle { <7.7864, 3.9750, 35.0959>, <-0.450, 0.660, 0.602>, <8.0355, 4.4850, 34.7568>, <-0.408, 0.635, 0.656>, <8.6560, 4.8233, 34.8153>, <-0.450, 0.660, 0.602> }
	smooth_triangle { <8.6560, 4.8233, 34.8153>, <-0.450, 0.660, 0.602>, <8.3625, 4.3177, 35.1846>, <-0.489, 0.681, 0.544>, <7.7864, 3.9750, 35.0959>, <-0.450, 0.660, 0.602> }
	smooth_triangle { <8.9357, 3.9692, 35.3918>, <0.243, 0.226, -0.944>, <8.7612, 3.4333, 35.2300>, <0.201, 0.223, -0.954>, <9.0639, 2.9156, 35.1729>, <0.243, 0.226, -0.944> }
	smooth_triangle { <9.0639, 2.9156, 35.1729>, <0.243, 0.226, -0.944>, <9.2314, 3.4661, 35.3588>, <0.284, 0.228, -0.931>, <8.9357, 3.9692, 35.3918>, <0.243, 0.226, -0.944> }
	smooth_triangle { <10.1130, 4.1497, 35.6707>, <-0.351, 0.486, 0.801>, <9.9043, 4.6206, 35.3079>, <-0.309, 0.491, 0.815>, <10.1859, 5.1397, 35.1019>, <-0.351, 0.486, 0.801> }
	smooth_triangle { <10.1859, 5.1397, 35.1019>, <-0.351, 0.486, 0.801>, <10.3870, 4.6543, 35.4991>, <-0.392, 0.480, 0.785>, <10.1130, 4.1497, 35.6707>, <-0.351, 0.486, 0.801> }
	smooth_triangle { <11.2218, 4.5304, 35.4636>, <-0.197, 0.394, -0.898>, <11.0819, 3.8837, 35.2167>, <-0.217, 0.389, -0.895>, <11.4294, 3.4363, 34.9381>, <-0.197, 0.394, -0.898> }
	smooth_triangle { <11.4294, 3.4363, 34.9381>, <-0.197, 0.394, -0.898>, <11.5631, 4.0981, 35.2052>, <-0.176, 0.399, -0.900>, <11.2218, 4.5304, 35.4636>, <-0.197, 0.394, -0.898> }
	smooth_triangle { <12.3189, 5.0992, 35.2509>, <-0.031, 0.465, 0.885>, <12.0942, 5.5418, 35.0083>, <-0.039, 0.465, 0.884>, <12.3872, 6.2228, 34.6630>, <-0.031, 0.465, 0.885> }
	smooth_triangle { <12.3872, 6.2228, 34.6630>, <-0.031, 0.465, 0.885>, <12.6121, 5.7645, 34.9093>, <-0.023, 0.465, 0.885>, <12.3189, 5.0992, 35.2509>, <-0.031, 0.465, 0.885> }
	smooth_triangle { <5.3904, 4.3677, 33.3225>, <0.843, -0.343, -0.415>, <5.0764, 4.0142, 32.9035>, <0.863, -0.398, -0.311>, <4.8324, 3.4498, 32.9484>, <0.843, -0.343, -0.415> }
	smooth_triangle { <4.8324, 3.4498, 32.9484>, <0.843, -0.343, -0.415>, <5.1801, 3.7503, 33.3319>, <0.810, -0.284, -0.512>, <5.3904, 4.3677, 33.3225>, <0.843, -0.343, -0.415> }
	smooth_triangle { <5.5798, 4.1384, 33.8631>, <-0.138, 0.889, 0.436>, <6.1994, 4.4147, 33.5161>, <-0.134, 0.878, 0.460>, <6.9468, 4.4186, 33.7254>, <-0.138, 0.889, 0.436> }
	smooth_triangle { <6.9468, 4.4186, 33.7254>, <-0.138, 0.889, 0.436>, <6.3024, 4.1526, 34.0832>, <-0.143, 0.900, 0.412>, <5.5798, 4.1384, 33.8631>, <-0.138, 0.889, 0.436> }
	smooth_triangle { <6.0613, 4.3924, 34.9336>, <0.679, 0.537, -0.500>, <6.3276, 3.7841, 34.6384>, <0.682, 0.539, -0.494>, <6.8613, 3.3177, 34.8670>, <0.679, 0.537, -0.500> }
	smooth_triangle { <6.8613, 3.3177, 34.8670>, <0.679, 0.537, -0.500>, <6.5869, 3.9430, 35.1612>, <0.677, 0.535, -0.506>, <6.0613, 4.3924, 34.9336>, <0.679, 0.537, -0.500> }
	smooth_triangle { <6.5049, 4.7889, 36.0031>, <-0.765, -0.423, 0.486>, <6.0464, 5.2971, 35.7207>, <-0.767, -0.423, 0.483>, <5.8321, 5.9773, 35.9771>, <-0.765, -0.423, 0.486> }
	smooth_triangle { <5.8321, 5.9773, 35.9771>, <-0.765, -0.423, 0.486>, <6.3015, 5.4533, 36.2588>, <-0.764, -0.422, 0.489>, <6.5049, 4.7889, 36.0031>, <-0.765, -0.423, 0.486> }
	smooth_triangle { <6.8722, 4.9632, 36.9369>, <-0.101, 0.992, -0.079>, <7.3505, 4.9882, 36.5293>, <-0.090, 0.995, -0.045>, <7.8771, 5.0398, 36.6119>, <-0.101, 0.992, -0.079> }
	smooth_triangle { <7.8771, 5.0398, 36.6119>, <-0.101, 0.992, -0.079>, <7.4102, 5.0328, 37.0118>, <-0.112, 0.987, -0.113>, <6.8722, 4.9632, 36.9369>, <-0.101, 0.992, -0.079> }
	smooth_triangle { <7.1024, 5.2278, 37.8935>, <-0.939, -0.119, 0.322>, <6.9403, 5.7822, 37.5171>, <-0.968, -0.144, 0.204>, <6.8793, 6.4314, 37.6869>, <-0.939, -0.119, 0.322> }
	smooth_triangle { <6.8793, 6.4314, 37.6869>, <-0.939, -0.119, 0.322>, <7.1035, 5.9040, 38.0382>, <-0.896, -0.092, 0.434>, <7.1024, 5.2278, 37.8935>, <-0.939, -0.119, 0.322> }
	smooth_triangle { <6.5358, 5.2565, 38.7370>, <-0.532, -0.812, -0.241>, <6.2826, 5.6465, 38.1715>, <-0.456, -0.815, -0.358>, <5.5636, 6.0897, 38.0776>, <-0.532, -0.812, -0.241> }
	smooth_triangle { <5.5636, 6.0897, 38.0776>, <-0.532, -0.812, -0.241>, <5.9798, 5.6742, 38.7472>, <-0.598, -0.793, -0.120>, <6.5358, 5.2565, 38.7370>, <-0.532, -0.812, -0.241> }
	smooth_triangle { <6.0198, 5.2233, 39.6161>, <0.829, -0.232, 0.509>, <6.0167, 4.7338, 39.3754>, <0.854, -0.234, 0.465>, <5.7982, 4.2501, 39.5328>, <0.829, -0.232, 0.509> }
	smooth_triangle { <5.7982, 4.2501, 39.5328>, <0.829, -0.232, 0.509>, <5.7852, 4.7550, 39.7624>, <0.802, -0.230, 0.551>, <6.0198, 5.2233, 39.6161>, <0.829, -0.232, 0.509> }
	smooth_triangle { <5.4454, 5.3896, 40.4462>, <-0.567, -0.742, -0.358>, <5.1778, 5.8389, 39.8703>, <-0.607, -0.739, -0.294>, <4.5705, 6.3496, 39.8407>, <-0.567, -0.742, -0.358> }
	smooth_triangle { <4.5705, 6.3496, 39.8407>, <-0.567, -0.742, -0.358>, <4.7831, 5.8929, 40.3825>, <-0.523, -0.742, -0.420>, <5.4454, 5.3896, 40.4462>, <-0.567, -0.742, -0.358> }
	smooth_triangle { <4.9090, 5.3820, 41.3103>, <0.766, -0.309, 0.563>, <4.8705, 4.7479, 40.9739>, <0.809, -0.313, 0.497>, <4.5308, 4.1397, 41.1440>, <0.766, -0.309, 0.563> }
	smooth_triangle { <4.5308, 4.1397, 41.1440>, <0.766, -0.309, 0.563>, <4.5340, 4.7950, 41.4571>, <0.719, -0.303, 0.626>, <4.9090, 5.3820, 41.3103>, <0.766, -0.309, 0.563> }
	smooth_triangle { <4.0818, 3.7740, 31.3598>, <0.820, -0.057, -0.570>, <3.7257, 3.5864, 30.9087>, <0.783, 0.008, -0.622>, <3.5662, 2.9680, 30.7000>, <0.820, -0.057, -0.570> }
	smooth_triangle { <3.5662, 2.9680, 30.7000>, <0.820, -0.057, -0.570>, <3.9118, 3.2038, 31.2146>, <0.849, -0.122, -0.514>, <4.0818, 3.7740, 31.3598>, <0.820, -0.057, -0.570> }
	smooth_triangle { <4.4384, 3.2368, 31.8623>, <0.118, 0.734, 0.669>, <4.8668, 3.4899, 31.4997>, <0.109, 0.750, 0.652>, <5.4690, 3.4181, 31.4820>, <0.118, 0.734, 0.669> }
	smooth_triangle { <5.4690, 3.4181, 31.4820>, <0.118, 0.734, 0.669>, <5.0299, 3.1546, 31.8385>, <0.127, 0.716, 0.686>, <4.4384, 3.2368, 31.8623>, <0.118, 0.734, 0.669> }
	smooth_triangle { <4.9762, 2.1943, 32.1555>, <0.684, 0.253, -0.685>, <4.5038, 2.1056, 31.6493>, <0.686, 0.250, -0.684>, <4.3224, 1.5152, 31.2520>, <0.684, 0.253, -0.685> }
	smooth_triangle { <4.3224, 1.5152, 31.2520>, <0.684, 0.253, -0.685>, <4.8045, 1.6127, 31.7677>, <0.682, 0.256, -0.685>, <4.9762, 2.1943, 32.1555>, <0.684, 0.253, -0.685> }
	smooth_triangle { <5.6627, 1.2401, 32.4922>, <0.071, 0.339, 0.938>, <6.0675, 1.7752, 32.2733>, <0.078, 0.326, 0.942>, <6.7848, 1.8324, 32.1941>, <0.071, 0.339, 0.938> }
	smooth_triangle { <6.7848, 1.8324, 32.1941>, <0.071, 0.339, 0.938>, <6.3630, 1.2909, 32.4258>, <0.063, 0.351, 0.934>, <5.6627, 1.2401, 32.4922>, <0.071, 0.339, 0.938> }
	smooth_triangle { <5.8428, 0.0176, 32.4564>, <0.111, 0.063, -0.992>, <5.3032, 0.1294, 32.4145>, <0.100, 0.111, -0.989>, <4.8543, -0.2093, 32.3313>, <0.111, 0.063, -0.992> }
	smooth_triangle { <4.8543, -0.2093, 32.3313>, <0.111, 0.063, -0.992>, <5.4080, -0.3187, 32.3979>, <0.122, 0.014, -0.992>, <5.8428, 0.0176, 32.4564>, <0.111, 0.063, -0.992> }
	smooth_triangle { <6.1996, -1.1490, 32.3765>, <0.807, 0.238, 0.540>, <6.3869, -0.8813, 32.0314>, <0.838, 0.104, 0.536>, <6.6743, -1.0111, 31.6069>, <0.807, 0.238, 0.540> }
	smooth_triangle { <6.6743, -1.0111, 31.6069>, <0.807, 0.238, 0.540>, <6.4812, -1.2842, 32.0690>, <0.761, 0.367, 0.535>, <6.1996, -1.1490, 32.3765>, <0.807, 0.238, 0.540> }
	smooth_triangle { <6.4692, -2.3348, 32.3382>, <0.202, 0.143, -0.969>, <5.8045, -2.1972, 32.2061>, <0.213, 0.096, -0.972>, <5.2837, -2.6021, 32.0518>, <0.202, 0.143, -0.969> }
	smooth_triangle { <5.2837, -2.6021, 32.0518>, <0.202, 0.143, -0.969>, <5.9649, -2.7351, 32.1603>, <0.190, 0.188, -0.963>, <6.4692, -2.3348, 32.3382>, <0.202, 0.143, -0.969> }
	smooth_triangle { <6.9184, -3.4775, 32.2679>, <0.219, 0.012, 0.976>, <7.4580, -3.0367, 32.1133>, <0.198, 0.100, 0.975>, <8.1881, -3.1703, 31.9787>, <0.219, 0.012, 0.976> }
	smooth_triangle { <8.1881, -3.1703, 31.9787>, <0.219, 0.012, 0.976>, <7.6301, -3.6137, 32.0817>, <0.239, -0.076, 0.968>, <6.9184, -3.4775, 32.2679>, <0.219, 0.012, 0.976> }
	smooth_triangle { <4.6119, 4.4951, 31.0709>, <0.210, 0.596, -0.775>, <4.5459, 4.0887, 30.7548>, <0.161, 0.590, -0.792>, <4.8808, 3.7453, 30.5670>, <0.210, 0.596, -0.775> }
	smooth_triangle { <4.8808, 3.7453, 30.5670>, <0.210, 0.596, -0.775>, <4.9365, 4.1611, 30.9165>, <0.259, 0.601, -0.756>, <4.6119, 4.4951, 31.0709>, <0.210, 0.596, -0.775> }
	smooth_triangle { <5.3653, 4.7324, 31.2858>, <-0.347, 0.199, 0.917>, <5.0922, 5.1768, 31.0880>, <-0.340, 0.200, 0.919>, <5.2493, 5.7151, 31.0289>, <-0.347, 0.199, 0.917> }
	smooth_triangle { <5.2493, 5.7151, 31.0289>, <-0.347, 0.199, 0.917>, <5.5232, 5.2567, 31.2338>, <-0.354, 0.197, 0.914>, <5.3653, 4.7324, 31.2858>, <-0.347, 0.199, 0.917> }
	smooth_triangle { <6.4187, 5.0563, 31.8008>, <0.225, 0.425, -0.877>, <6.4713, 4.4532, 31.5310>, <0.201, 0.415, -0.888>, <7.0126, 4.0329, 31.4571>, <0.225, 0.425, -0.877> }
	smooth_triangle { <7.0126, 4.0329, 31.4571>, <0.225, 0.425, -0.877>, <6.9450, 4.6477, 31.7471>, <0.250, 0.435, -0.865>, <6.4187, 5.0563, 31.8008>, <0.225, 0.425, -0.877> }
	smooth_triangle { <7.4006, 5.5699, 32.3193>, <-0.519, 0.075, 0.852>, <7.0835, 5.9621, 32.0868>, <-0.533, 0.069, 0.844>, <7.1347, 6.5205, 32.0733>, <-0.519, 0.075, 0.852> }
	smooth_triangle { <7.1347, 6.5205, 32.0733>, <-0.519, 0.075, 0.852>, <7.4587, 6.1162, 32.3019>, <-0.505, 0.081, 0.859>, <7.4006, 5.5699, 32.3193>, <-0.519, 0.075, 0.852> }
	smooth_triangle { <8.6247, 5.6778, 32.3427>, <0.007, 0.304, -0.953>, <8.4432, 5.0196, 32.1176>, <0.049, 0.311, -0.949>, <8.8467, 4.4447, 31.9502>, <0.007, 0.304, -0.953> }
	smooth_triangle { <8.8467, 4.4447, 31.9502>, <0.007, 0.304, -0.953>, <9.0256, 5.1204, 32.1539>, <-0.036, 0.297, -0.954>, <8.6247, 5.6778, 32.3427>, <0.007, 0.304, -0.953> }
	smooth_triangle { <9.8125, 5.9654, 32.3408>, <-0.145, 0.817, 0.559>, <9.5684, 6.1850, 31.9712>, <-0.107, 0.822, 0.559>, <9.7399, 6.4840, 31.5642>, <-0.145, 0.817, 0.559> }
	smooth_triangle { <9.7399, 6.4840, 31.5642>, <-0.145, 0.817, 0.559>, <9.9844, 6.2570, 31.9737>, <-0.182, 0.810, 0.558>, <9.8125, 5.9654, 32.3408>, <-0.145, 0.817, 0.559> }
	smooth_triangle { <10.9682, 6.0294, 31.9480>, <-0.418, 0.591, -0.690>, <10.7610, 5.4934, 31.6406>, <-0.467, 0.569, -0.677>, <11.1659, 5.0132, 30.9575>, <-0.418, 0.591, -0.690> }
	smooth_triangle { <11.1659, 5.0132, 30.9575>, <-0.418, 0.591, -0.690>, <11.3691, 5.5634, 31.3309>, <-0.368, 0.611, -0.701>, <10.9682, 6.0294, 31.9480>, <-0.418, 0.591, -0.690> }
	smooth_triangle { <12.1014, 6.2254, 31.5387>, <-0.044, 0.863, 0.503>, <11.8446, 6.4595, 31.1211>, <-0.029, 0.864, 0.502>, <12.0303, 6.7518, 30.6292>, <-0.044, 0.863, 0.503> }
	smooth_triangle { <12.0303, 6.7518, 30.6292>, <-0.044, 0.863, 0.503>, <12.2878, 6.5102, 31.0725>, <-0.058, 0.862, 0.503>, <12.1014, 6.2254, 31.5387>, <-0.044, 0.863, 0.503> }
	smooth_triangle { <4.1905, 4.9209, 31.3995>, <-0.567, 0.654, -0.501>, <4.5158, 4.8131, 30.8809>, <-0.561, 0.667, -0.490>, <5.1229, 5.1321, 30.6210>, <-0.567, 0.654, -0.501> }
	smooth_triangle { <5.1229, 5.1321, 30.6210>, <-0.567, 0.654, -0.501>, <4.7912, 5.2475, 31.1363>, <-0.573, 0.640, -0.512>, <4.1905, 4.9209, 31.3995>, <-0.567, 0.654, -0.501> }
	smooth_triangle { <4.4436, 5.4672, 31.9518>, <-0.651, -0.330, 0.684>, <4.0076, 5.6754, 31.6579>, <-0.626, -0.292, 0.723>, <3.7592, 6.2052, 31.6565>, <-0.651, -0.330, 0.684> }
	smooth_triangle { <3.7592, 6.2052, 31.6565>, <-0.651, -0.330, 0.684>, <4.1941, 5.9697, 31.9775>, <-0.673, -0.367, 0.642>, <4.4436, 5.4672, 31.9518>, <-0.651, -0.330, 0.684> }
	smooth_triangle { <5.2377, 5.8913, 32.8033>, <0.199, 0.680, -0.706>, <5.4864, 5.4515, 32.4789>, <0.151, 0.641, -0.753>, <6.1123, 5.2522, 32.4351>, <0.199, 0.680, -0.706> }
	smooth_triangle { <6.1123, 5.2522, 32.4351>, <0.199, 0.680, -0.706>, <5.8250, 5.6831, 32.7970>, <0.246, 0.714, -0.655>, <5.2377, 5.8913, 32.8033>, <0.199, 0.680, -0.706> }
	smooth_triangle { <5.9211, 6.4563, 33.6441>, <-0.728, 0.450, 0.517>, <5.8279, 6.7387, 33.2573>, <-0.744, 0.441, 0.501>, <6.0218, 7.2274, 33.1155>, <-0.728, 0.450, 0.517> }
	smooth_triangle { <6.0218, 7.2274, 33.1155>, <-0.728, 0.450, 0.517>, <6.1234, 6.9409, 33.4975>, <-0.711, 0.458, 0.533>, <5.9211, 6.4563, 33.6441>, <-0.728, 0.450, 0.517> }
	smooth_triangle { <6.2831, 7.1036, 34.6104>, <-0.625, 0.631, -0.461>, <6.6326, 7.1077, 34.1436>, <-0.625, 0.629, -0.463>, <7.2107, 7.5605, 33.9779>, <-0.625, 0.631, -0.461> }
	smooth_triangle { <7.2107, 7.5605, 33.9779>, <-0.625, 0.631, -0.461>, <6.8471, 7.5479, 34.4553>, <-0.624, 0.632, -0.459>, <6.2831, 7.1036, 34.6104>, <-0.625, 0.631, -0.461> }
	smooth_triangle { <6.5522, 7.7984, 35.5774>, <-0.890, -0.092, 0.446>, <6.3490, 8.0305, 35.2311>, <-0.882, -0.077, 0.466>, <6.2686, 8.5330, 35.1624>, <-0.890, -0.092, 0.446> }
	smooth_triangle { <6.2686, 8.5330, 35.1624>, <-0.890, -0.092, 0.446>, <6.4702, 8.2792, 35.5243>, <-0.898, -0.106, 0.426>, <6.5522, 7.7984, 35.5774>, <-0.890, -0.092, 0.446> }
	smooth_triangle { <7.3661, 8.1155, 36.4747>, <-0.315, 0.904, -0.290>, <7.6274, 8.1089, 36.1555>, <-0.307, 0.913, -0.270>, <8.1779, 8.2743, 36.0889>, <-0.315, 0.904, -0.290> }
	smooth_triangle { <8.1779, 8.2743, 36.0889>, <-0.315, 0.904, -0.290>, <7.9094, 8.2873, 36.4061>, <-0.322, 0.895, -0.309>, <7.3661, 8.1155, 36.4747>, <-0.315, 0.904, -0.290> }
	smooth_triangle { <8.0338, 8.4960, 37.3774>, <-0.588, -0.228, 0.776>, <7.4881, 8.7940, 37.0561>, <-0.581, -0.218, 0.784>, <7.2872, 9.3238, 37.0545>, <-0.588, -0.228, 0.776> }
	smooth_triangle { <7.2872, 9.3238, 37.0545>, <-0.588, -0.228, 0.776>, <7.8402, 9.0076, 37.3860>, <-0.596, -0.238, 0.767>, <8.0338, 8.4960, 37.3774>, <-0.588, -0.228, 0.776> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0012B' */
union {
	smooth_triangle { <0.1472, 3.8351, 23.1161>, <0.504, 0.692, 0.517>, <1.0685, 4.1383, 21.8115>, <0.534, 0.701, 0.472>, <1.0900, 4.1153, 21.8213>, <0.731, 0.376, 0.570> }
	smooth_triangle { <0.1472, 3.8351, 23.1161>, <0.504, 0.692, 0.517>, <1.0900, 4.1153, 21.8213>, <0.731, 0.376, 0.570>, <0.1687, 3.8121, 23.1259>, <0.808, 0.067, 0.586> }
	smooth_triangle { <0.1687, 3.8121, 23.1259>, <0.808, 0.067, 0.586>, <1.0900, 4.1153, 21.8213>, <0.731, 0.376, 0.570>, <1.0863, 4.0841, 21.8115>, <0.684, -0.608, 0.402> }
	smooth_triangle { <0.1687, 3.8121, 23.1259>, <0.808, 0.067, 0.586>, <1.0863, 4.0841, 21.8115>, <0.684, -0.608, 0.402>, <0.1651, 3.7809, 23.1161>, <0.545, -0.815, 0.195> }
	smooth_triangle { <0.1651, 3.7809, 23.1161>, <0.545, -0.815, 0.195>, <1.0863, 4.0841, 21.8115>, <0.684, -0.608, 0.402>, <1.0612, 4.0758, 21.7919>, <-0.047, -0.985, -0.167> }
	smooth_triangle { <0.1651, 3.7809, 23.1161>, <0.545, -0.815, 0.195>, <1.0612, 4.0758, 21.7919>, <-0.047, -0.985, -0.167>, <0.1400, 3.7726, 23.0964>, <-0.263, -0.882, -0.391> }
	smooth_triangle { <0.1400, 3.7726, 23.0964>, <-0.263, -0.882, -0.391>, <1.0612, 4.0758, 21.7919>, <-0.047, -0.985, -0.167>, <1.0398, 4.0988, 21.7820>, <-0.731, -0.376, -0.569> }
	smooth_triangle { <0.1400, 3.7726, 23.0964>, <-0.263, -0.882, -0.391>, <1.0398, 4.0988, 21.7820>, <-0.731, -0.376, -0.569>, <0.1185, 3.7956, 23.0866>, <-0.808, -0.067, -0.586> }
	smooth_triangle { <0.1185, 3.7956, 23.0866>, <-0.808, -0.067, -0.586>, <1.0398, 4.0988, 21.7820>, <-0.731, -0.376, -0.569>, <1.0434, 4.1300, 21.7919>, <-0.685, 0.608, -0.401> }
	smooth_triangle { <0.1185, 3.7956, 23.0866>, <-0.808, -0.067, -0.586>, <1.0434, 4.1300, 21.7919>, <-0.685, 0.608, -0.401>, <0.1221, 3.8268, 23.0964>, <-0.545, 0.815, -0.195> }
	smooth_triangle { <0.1221, 3.8268, 23.0964>, <-0.545, 0.815, -0.195>, <1.0434, 4.1300, 21.7919>, <-0.685, 0.608, -0.401>, <1.0685, 4.1383, 21.8115>, <-0.208, 0.978, -0.011> }
	smooth_triangle { <0.1221, 3.8268, 23.0964>, <-0.545, 0.815, -0.195>, <1.0685, 4.1383, 21.8115>, <-0.208, 0.978, -0.011>, <0.1472, 3.8351, 23.1161>, <-0.313, 0.950, 0.000> }
	smooth_triangle { <-1.4625, 3.9606, 25.4492>, <0.709, 0.535, 0.460>, <1.0685, 4.1383, 21.8115>, <0.534, 0.701, 0.472>, <1.0900, 4.1153, 21.8213>, <0.731, 0.376, 0.570> }
	smooth_triangle { <-1.4625, 3.9606, 25.4492>, <0.709, 0.535, 0.460>, <1.0900, 4.1153, 21.8213>, <0.731, 0.376, 0.570>, <-1.4540, 3.9378, 25.4564>, <0.862, 0.010, 0.507> }
	smooth_triangle { <-1.4540, 3.9378, 25.4564>, <0.862, 0.010, 0.507>, <1.0900, 4.1153, 21.8213>, <0.731, 0.376, 0.570>, <1.0863, 4.0841, 21.8115>, <0.684, -0.608, 0.402> }
	smooth_triangle { <-1.4540, 3.9378, 25.4564>, <0.862, 0.010, 0.507>, <1.0863, 4.0841, 21.8115>, <0.684, -0.608, 0.402>, <-1.4662, 3.9168, 25.4492>, <0.460, -0.860, 0.222> }
	smooth_triangle { <-1.4662, 3.9168, 25.4492>, <0.460, -0.860, 0.222>, <1.0863, 4.0841, 21.8115>, <0.684, -0.608, 0.402>, <1.0612, 4.0758, 21.7919>, <-0.047, -0.985, -0.167> }
	smooth_triangle { <-1.4662, 3.9168, 25.4492>, <0.460, -0.860, 0.222>, <1.0612, 4.0758, 21.7919>, <-0.047, -0.985, -0.167>, <-1.4870, 3.9185, 25.4347>, <-0.400, -0.872, -0.282> }
	smooth_triangle { <-1.4870, 3.9185, 25.4347>, <-0.400, -0.872, -0.282>, <1.0612, 4.0758, 21.7919>, <-0.047, -0.985, -0.167>, <1.0398, 4.0988, 21.7820>, <-0.731, -0.376, -0.569> }
	smooth_triangle { <-1.4870, 3.9185, 25.4347>, <-0.400, -0.872, -0.282>, <1.0398, 4.0988, 21.7820>, <-0.731, -0.376, -0.569>, <-1.4955, 3.9413, 25.4274>, <-0.863, -0.010, -0.505> }
	smooth_triangle { <-1.4955, 3.9413, 25.4274>, <-0.863, -0.010, -0.505>, <1.0398, 4.0988, 21.7820>, <-0.731, -0.376, -0.569>, <1.0434, 4.1300, 21.7919>, <-0.685, 0.608, -0.401> }
	smooth_triangle { <-1.4955, 3.9413, 25.4274>, <-0.863, -0.010, -0.505>, <1.0434, 4.1300, 21.7919>, <-0.685, 0.608, -0.401>, <-1.4833, 3.9623, 25.4347>, <-0.461, 0.860, -0.220> }
	smooth_triangle { <-1.4833, 3.9623, 25.4347>, <-0.461, 0.860, -0.220>, <1.0434, 4.1300, 21.7919>, <-0.685, 0.608, -0.401>, <1.0685, 4.1383, 21.8115>, <-0.208, 0.978, -0.011> }
	smooth_triangle { <-1.4833, 3.9623, 25.4347>, <-0.461, 0.860, -0.220>, <1.0685, 4.1383, 21.8115>, <-0.208, 0.978, -0.011>, <-1.4625, 3.9606, 25.4492>, <-0.001, 0.999, 0.044> }
	smooth_triangle { <-2.6977, 3.8643, 28.0095>, <0.762, 0.519, 0.388>, <-1.4625, 3.9606, 25.4492>, <0.709, 0.535, 0.460>, <-1.4540, 3.9378, 25.4564>, <0.862, 0.010, 0.507> }
	smooth_triangle { <-2.6977, 3.8643, 28.0095>, <0.762, 0.519, 0.388>, <-1.4540, 3.9378, 25.4564>, <0.862, 0.010, 0.507>, <-2.6846, 3.8433, 28.0150>, <0.894, 0.031, 0.448> }
	smooth_triangle { <-2.6846, 3.8433, 28.0150>, <0.894, 0.031, 0.448>, <-1.4540, 3.9378, 25.4564>, <0.862, 0.010, 0.507>, <-1.4662, 3.9168, 25.4492>, <0.460, -0.860, 0.222> }
	smooth_triangle { <-2.6846, 3.8433, 28.0150>, <0.894, 0.031, 0.448>, <-1.4662, 3.9168, 25.4492>, <0.460, -0.860, 0.222>, <-2.6942, 3.8204, 28.0095>, <0.473, -0.850, 0.233> }
	smooth_triangle { <-2.6942, 3.8204, 28.0095>, <0.473, -0.850, 0.233>, <-1.4662, 3.9168, 25.4492>, <0.460, -0.860, 0.222>, <-1.4870, 3.9185, 25.4347>, <-0.400, -0.872, -0.282> }
	smooth_triangle { <-2.6942, 3.8204, 28.0095>, <0.473, -0.850, 0.233>, <-1.4870, 3.9185, 25.4347>, <-0.400, -0.872, -0.282>, <-2.7170, 3.8186, 27.9984>, <-0.422, -0.880, -0.216> }
	smooth_triangle { <-2.7170, 3.8186, 27.9984>, <-0.422, -0.880, -0.216>, <-1.4870, 3.9185, 25.4347>, <-0.400, -0.872, -0.282>, <-1.4955, 3.9413, 25.4274>, <-0.863, -0.010, -0.505> }
	smooth_triangle { <-2.7170, 3.8186, 27.9984>, <-0.422, -0.880, -0.216>, <-1.4955, 3.9413, 25.4274>, <-0.863, -0.010, -0.505>, <-2.7302, 3.8396, 27.9929>, <-0.893, -0.031, -0.448> }
	smooth_triangle { <-2.7302, 3.8396, 27.9929>, <-0.893, -0.031, -0.448>, <-1.4955, 3.9413, 25.4274>, <-0.863, -0.010, -0.505>, <-1.4833, 3.9623, 25.4347>, <-0.461, 0.860, -0.220> }
	smooth_triangle { <-2.7302, 3.8396, 27.9929>, <-0.893, -0.031, -0.448>, <-1.4833, 3.9623, 25.4347>, <-0.461, 0.860, -0.220>, <-2.7205, 3.8625, 27.9984>, <-0.473, 0.850, -0.233> }
	smooth_triangle { <-2.7205, 3.8625, 27.9984>, <-0.473, 0.850, -0.233>, <-1.4833, 3.9623, 25.4347>, <-0.461, 0.860, -0.220>, <-1.4625, 3.9606, 25.4492>, <-0.001, 0.999, 0.044> }
	smooth_triangle { <-2.7205, 3.8625, 27.9984>, <-0.473, 0.850, -0.233>, <-1.4625, 3.9606, 25.4492>, <-0.001, 0.999, 0.044>, <-2.6977, 3.8643, 28.0095>, <-0.033, 0.999, -0.017> }
	smooth_triangle { <-3.8429, 3.9052, 30.1610>, <0.817, 0.497, 0.292>, <-2.6977, 3.8643, 28.0095>, <0.762, 0.519, 0.388>, <-2.6846, 3.8433, 28.0150>, <0.894, 0.031, 0.448> }
	smooth_triangle { <-3.8429, 3.9052, 30.1610>, <0.817, 0.497, 0.292>, <-2.6846, 3.8433, 28.0150>, <0.894, 0.031, 0.448>, <-3.8325, 3.8828, 30.1670>, <0.876, -0.170, 0.452> }
	smooth_triangle { <-3.8325, 3.8828, 30.1670>, <0.876, -0.170, 0.452>, <-2.6846, 3.8433, 28.0150>, <0.894, 0.031, 0.448>, <-2.6942, 3.8204, 28.0095>, <0.473, -0.850, 0.233> }
	smooth_triangle { <-3.8325, 3.8828, 30.1670>, <0.876, -0.170, 0.452>, <-2.6942, 3.8204, 28.0095>, <0.473, -0.850, 0.233>, <-3.8445, 3.8612, 30.1610>, <0.207, -0.904, 0.374> }
	smooth_triangle { <-3.8445, 3.8612, 30.1610>, <0.207, -0.904, 0.374>, <-2.6942, 3.8204, 28.0095>, <0.473, -0.850, 0.233>, <-2.7170, 3.8186, 27.9984>, <-0.422, -0.880, -0.216> }
	smooth_triangle { <-3.8445, 3.8612, 30.1610>, <0.207, -0.904, 0.374>, <-2.7170, 3.8186, 27.9984>, <-0.422, -0.880, -0.216>, <-3.8669, 3.8620, 30.1491>, <-0.676, -0.732, -0.082> }
	smooth_triangle { <-3.8669, 3.8620, 30.1491>, <-0.676, -0.732, -0.082>, <-2.7170, 3.8186, 27.9984>, <-0.422, -0.880, -0.216>, <-2.7302, 3.8396, 27.9929>, <-0.893, -0.031, -0.448> }
	smooth_triangle { <-3.8669, 3.8620, 30.1491>, <-0.676, -0.732, -0.082>, <-2.7302, 3.8396, 27.9929>, <-0.893, -0.031, -0.448>, <-3.8773, 3.8844, 30.1431>, <-0.875, 0.170, -0.453> }
	smooth_triangle { <-3.8773, 3.8844, 30.1431>, <-0.875, 0.170, -0.453>, <-2.7302, 3.8396, 27.9929>, <-0.893, -0.031, -0.448>, <-2.7205, 3.8625, 27.9984>, <-0.473, 0.850, -0.233> }
	smooth_triangle { <-3.8773, 3.8844, 30.1431>, <-0.875, 0.170, -0.453>, <-2.7205, 3.8625, 27.9984>, <-0.473, 0.850, -0.233>, <-3.8653, 3.9060, 30.1491>, <-0.206, 0.904, -0.376> }
	smooth_triangle { <-3.8653, 3.9060, 30.1491>, <-0.206, 0.904, -0.376>, <-2.7205, 3.8625, 27.9984>, <-0.473, 0.850, -0.233>, <-2.6977, 3.8643, 28.0095>, <-0.033, 0.999, -0.017> }
	smooth_triangle { <-3.8653, 3.9060, 30.1491>, <-0.206, 0.904, -0.376>, <-2.6977, 3.8643, 28.0095>, <-0.033, 0.999, -0.017>, <-3.8429, 3.9052, 30.1610>, <0.429, 0.889, -0.163> }
	smooth_triangle { <-4.3387, 4.7038, 31.4728>, <0.929, 0.111, 0.353>, <-3.8429, 3.9052, 30.1610>, <0.817, 0.497, 0.292>, <-3.8325, 3.8828, 30.1670>, <0.876, -0.170, 0.452> }
	smooth_triangle { <-4.3387, 4.7038, 31.4728>, <0.929, 0.111, 0.353>, <-3.8325, 3.8828, 30.1670>, <0.876, -0.170, 0.452>, <-4.3520, 4.6835, 31.4803>, <0.480, -0.655, 0.584> }
	smooth_triangle { <-4.3520, 4.6835, 31.4803>, <0.480, -0.655, 0.584>, <-3.8325, 3.8828, 30.1670>, <0.876, -0.170, 0.452>, <-3.8445, 3.8612, 30.1610>, <0.207, -0.904, 0.374> }
	smooth_triangle { <-4.3520, 4.6835, 31.4803>, <0.480, -0.655, 0.584>, <-3.8445, 3.8612, 30.1610>, <0.207, -0.904, 0.374>, <-4.3761, 4.6806, 31.4728>, <-0.454, -0.840, 0.295> }
	smooth_triangle { <-4.3761, 4.6806, 31.4728>, <-0.454, -0.840, 0.295>, <-3.8445, 3.8612, 30.1610>, <0.207, -0.904, 0.374>, <-3.8669, 3.8620, 30.1491>, <-0.676, -0.732, -0.082> }
	smooth_triangle { <-4.3761, 4.6806, 31.4728>, <-0.454, -0.840, 0.295>, <-3.8669, 3.8620, 30.1491>, <-0.676, -0.732, -0.082>, <-4.3869, 4.6980, 31.4577>, <-0.940, -0.203, -0.273> }
	smooth_triangle { <-4.3869, 4.6980, 31.4577>, <-0.940, -0.203, -0.273>, <-3.8669, 3.8620, 30.1491>, <-0.676, -0.732, -0.082>, <-3.8773, 3.8844, 30.1431>, <-0.875, 0.170, -0.453> }
	smooth_triangle { <-4.3869, 4.6980, 31.4577>, <-0.940, -0.203, -0.273>, <-3.8773, 3.8844, 30.1431>, <-0.875, 0.170, -0.453>, <-4.3736, 4.7183, 31.4502>, <-0.483, 0.661, -0.574> }
	smooth_triangle { <-4.3736, 4.7183, 31.4502>, <-0.483, 0.661, -0.574>, <-3.8773, 3.8844, 30.1431>, <-0.875, 0.170, -0.453>, <-3.8653, 3.9060, 30.1491>, <-0.206, 0.904, -0.376> }
	smooth_triangle { <-4.3736, 4.7183, 31.4502>, <-0.483, 0.661, -0.574>, <-3.8653, 3.9060, 30.1491>, <-0.206, 0.904, -0.376>, <-4.3495, 4.7212, 31.4577>, <0.451, 0.845, -0.287> }
	smooth_triangle { <-4.3495, 4.7212, 31.4577>, <0.451, 0.845, -0.287>, <-3.8653, 3.9060, 30.1491>, <-0.206, 0.904, -0.376>, <-3.8429, 3.9052, 30.1610>, <0.429, 0.889, -0.163> }
	smooth_triangle { <-4.3495, 4.7212, 31.4577>, <0.451, 0.845, -0.287>, <-3.8429, 3.9052, 30.1610>, <0.429, 0.889, -0.163>, <-4.3387, 4.7038, 31.4728>, <0.849, 0.528, 0.000> }
	smooth_triangle { <-5.0076, 5.3684, 32.7999>, <0.775, -0.306, 0.552>, <-4.3387, 4.7038, 31.4728>, <0.929, 0.111, 0.353>, <-4.3520, 4.6835, 31.4803>, <0.480, -0.655, 0.584> }
	smooth_triangle { <-5.0076, 5.3684, 32.7999>, <-0.032, -0.890, 0.454>, <-4.3520, 4.6835, 31.4803>, <0.480, -0.655, 0.584>, <-4.3761, 4.6806, 31.4728>, <-0.454, -0.840, 0.295> }
	smooth_triangle { <-5.0076, 5.3684, 32.7999>, <-0.814, -0.575, -0.081>, <-4.3761, 4.6806, 31.4728>, <-0.454, -0.840, 0.295>, <-4.3869, 4.6980, 31.4577>, <-0.940, -0.203, -0.273> }
	smooth_triangle { <-5.0076, 5.3684, 32.7999>, <-0.790, 0.325, -0.520>, <-4.3869, 4.6980, 31.4577>, <-0.940, -0.203, -0.273>, <-4.3736, 4.7183, 31.4502>, <-0.483, 0.661, -0.574> }
	smooth_triangle { <-5.0076, 5.3684, 32.7999>, <0.017, 0.907, -0.421>, <-4.3736, 4.7183, 31.4502>, <-0.483, 0.661, -0.574>, <-4.3495, 4.7212, 31.4577>, <0.451, 0.845, -0.287> }
	smooth_triangle { <-5.0076, 5.3684, 32.7999>, <0.798, 0.592, 0.114>, <-4.3495, 4.7212, 31.4577>, <0.451, 0.845, -0.287>, <-4.3387, 4.7038, 31.4728>, <0.929, 0.111, 0.353> }
	smooth_triangle { <-2.2954, 4.3041, 29.5071>, <-0.124, -0.934, 0.336>, <-2.6979, 3.8184, 28.0089>, <-0.112, -0.918, 0.380>, <-2.7223, 3.8234, 28.0138>, <-0.312, -0.861, 0.402> }
	smooth_triangle { <-2.2954, 4.3041, 29.5071>, <-0.124, -0.934, 0.336>, <-2.7223, 3.8234, 28.0138>, <-0.312, -0.861, 0.402>, <-2.3198, 4.3091, 29.5120>, <-0.723, -0.576, 0.381> }
	smooth_triangle { <-2.3198, 4.3091, 29.5120>, <-0.723, -0.576, 0.381>, <-2.7223, 3.8234, 28.0138>, <-0.498, -0.783, 0.371>, <-2.7318, 3.8465, 28.0089>, <-0.967, -0.131, 0.218> }
	smooth_triangle { <-2.3198, 4.3091, 29.5120>, <-0.723, -0.576, 0.381>, <-2.7318, 3.8465, 28.0089>, <-0.967, -0.131, 0.218>, <-2.3293, 4.3321, 29.5071>, <-0.920, 0.371, 0.127> }
	smooth_triangle { <-2.3293, 4.3321, 29.5071>, <-0.920, 0.371, 0.127>, <-2.7318, 3.8465, 28.0089>, <-0.988, 0.058, 0.144>, <-2.7168, 3.8645, 27.9990>, <-0.655, 0.732, -0.184> }
	smooth_triangle { <-2.3293, 4.3321, 29.5071>, <-0.920, 0.371, 0.127>, <-2.7168, 3.8645, 27.9990>, <-0.655, 0.732, -0.184>, <-2.3144, 4.3502, 29.4973>, <-0.197, 0.947, -0.254> }
	smooth_triangle { <-2.3144, 4.3502, 29.4973>, <-0.197, 0.947, -0.254>, <-2.7168, 3.8645, 27.9990>, <-0.489, 0.843, -0.226>, <-2.6924, 3.8595, 27.9941>, <0.313, 0.861, -0.400> }
	smooth_triangle { <-2.3144, 4.3502, 29.4973>, <-0.197, 0.947, -0.254>, <-2.6924, 3.8595, 27.9941>, <0.313, 0.861, -0.400>, <-2.2899, 4.3451, 29.4923>, <0.723, 0.576, -0.381> }
	smooth_triangle { <-2.2899, 4.3451, 29.4923>, <0.723, 0.576, -0.381>, <-2.6924, 3.8595, 27.9941>, <0.499, 0.785, -0.367>, <-2.6830, 3.8364, 27.9990>, <0.967, 0.132, -0.216> }
	smooth_triangle { <-2.2899, 4.3451, 29.4923>, <0.723, 0.576, -0.381>, <-2.6830, 3.8364, 27.9990>, <0.967, 0.132, -0.216>, <-2.2805, 4.3221, 29.4973>, <0.920, -0.371, -0.127> }
	smooth_triangle { <-2.2805, 4.3221, 29.4973>, <0.920, -0.371, -0.127>, <-2.6830, 3.8364, 27.9990>, <0.988, -0.056, -0.140>, <-2.6979, 3.8184, 28.0089>, <0.898, -0.438, 0.032> }
	smooth_triangle { <-2.2805, 4.3221, 29.4973>, <0.920, -0.371, -0.127>, <-2.6979, 3.8184, 28.0089>, <0.898, -0.438, 0.032>, <-2.2954, 4.3041, 29.5071>, <0.770, -0.638, 0.000> }
	smooth_triangle { <-2.6035, 5.5023, 31.6179>, <0.442, -0.728, 0.524>, <-2.6979, 3.8184, 28.0089>, <-0.112, -0.918, 0.380>, <-2.7223, 3.8234, 28.0138>, <-0.312, -0.861, 0.402> }
	smooth_triangle { <-2.6035, 5.5023, 31.6179>, <0.442, -0.728, 0.524>, <-2.7223, 3.8234, 28.0138>, <0.093, -0.924, 0.372>, <-2.6218, 5.4859, 31.6243>, <0.409, -0.663, 0.628> }
	smooth_triangle { <-2.6218, 5.4859, 31.6243>, <-0.578, -0.576, 0.578>, <-2.7223, 3.8234, 28.0138>, <-0.498, -0.783, 0.371>, <-2.7318, 3.8465, 28.0089>, <-0.967, -0.131, 0.218> }
	smooth_triangle { <-2.6218, 5.4859, 31.6243>, <0.048, -0.666, 0.745>, <-2.7318, 3.8465, 28.0089>, <-0.806, -0.486, 0.339>, <-2.6459, 5.4907, 31.6179>, <-0.697, -0.353, 0.624> }
	smooth_triangle { <-2.6459, 5.4907, 31.6179>, <-0.984, 0.135, 0.120>, <-2.7318, 3.8465, 28.0089>, <-0.988, 0.058, 0.144>, <-2.7168, 3.8645, 27.9990>, <-0.655, 0.732, -0.184> }
	smooth_triangle { <-2.6459, 5.4907, 31.6179>, <-0.821, -0.210, 0.530>, <-2.7168, 3.8645, 27.9990>, <-0.898, 0.438, -0.032>, <-2.6517, 5.5119, 31.6052>, <-0.962, 0.253, -0.102> }
	smooth_triangle { <-2.6517, 5.5119, 31.6052>, <-0.441, 0.728, -0.525>, <-2.7168, 3.8645, 27.9990>, <-0.489, 0.843, -0.226>, <-2.6924, 3.8595, 27.9941>, <0.313, 0.861, -0.400> }
	smooth_triangle { <-2.6517, 5.5119, 31.6052>, <-0.881, 0.435, -0.187>, <-2.6924, 3.8595, 27.9941>, <-0.092, 0.924, -0.372>, <-2.6334, 5.5283, 31.5988>, <-0.407, 0.659, -0.632> }
	smooth_triangle { <-2.6334, 5.5283, 31.5988>, <0.580, 0.573, -0.579>, <-2.6924, 3.8595, 27.9941>, <0.499, 0.785, -0.367>, <-2.6830, 3.8364, 27.9990>, <0.967, 0.132, -0.216> }
	smooth_triangle { <-2.6334, 5.5283, 31.5988>, <-0.048, 0.663, -0.748>, <-2.6830, 3.8364, 27.9990>, <0.806, 0.485, -0.339>, <-2.6093, 5.5235, 31.6052>, <0.696, 0.347, -0.629> }
	smooth_triangle { <-2.6093, 5.5235, 31.6052>, <0.983, -0.137, -0.122>, <-2.6830, 3.8364, 27.9990>, <0.988, -0.056, -0.140>, <-2.6979, 3.8184, 28.0089>, <0.898, -0.438, 0.032> }
	smooth_triangle { <-2.6093, 5.5235, 31.6052>, <0.820, 0.206, -0.533>, <-2.6979, 3.8184, 28.0089>, <0.898, -0.438, 0.032>, <-2.6035, 5.5023, 31.6179>, <0.981, -0.015, -0.196> }
	smooth_triangle { <-2.1210, 7.7350, 32.4637>, <0.471, -0.458, 0.754>, <-2.6035, 5.5023, 31.6179>, <0.442, -0.728, 0.524>, <-2.6218, 5.4859, 31.6243>, <0.270, -0.618, 0.738> }
	smooth_triangle { <-2.1210, 7.7350, 32.4637>, <0.471, -0.458, 0.754>, <-2.6218, 5.4859, 31.6243>, <0.270, -0.618, 0.738>, <-2.1434, 7.7354, 32.4756>, <-0.056, -0.364, 0.930> }
	smooth_triangle { <-2.1434, 7.7354, 32.4756>, <-0.056, -0.364, 0.930>, <-2.6218, 5.4859, 31.6243>, <-0.126, -0.600, 0.790>, <-2.6459, 5.4907, 31.6179>, <-0.697, -0.353, 0.624> }
	smooth_triangle { <-2.1434, 7.7354, 32.4756>, <-0.056, -0.364, 0.930>, <-2.6459, 5.4907, 31.6179>, <-0.697, -0.353, 0.624>, <-2.1640, 7.7443, 32.4637>, <-0.808, 0.125, 0.576> }
	smooth_triangle { <-2.1640, 7.7443, 32.4637>, <-0.808, 0.125, 0.576>, <-2.6459, 5.4907, 31.6179>, <-0.821, -0.210, 0.530>, <-2.6517, 5.5119, 31.6052>, <-0.979, 0.192, 0.073> }
	smooth_triangle { <-2.1640, 7.7443, 32.4637>, <-0.808, 0.125, 0.576>, <-2.6517, 5.5119, 31.6052>, <-0.962, 0.253, -0.102>, <-2.1621, 7.7529, 32.4398>, <-0.761, 0.510, -0.401> }
	smooth_triangle { <-2.1621, 7.7529, 32.4398>, <-0.761, 0.510, -0.401>, <-2.6517, 5.5119, 31.6052>, <-0.799, 0.501, -0.332>, <-2.6334, 5.5283, 31.5988>, <-0.269, 0.614, -0.743> }
	smooth_triangle { <-2.1621, 7.7529, 32.4398>, <-0.761, 0.510, -0.401>, <-2.6334, 5.5283, 31.5988>, <-0.269, 0.614, -0.743>, <-2.1397, 7.7525, 32.4279>, <0.055, 0.362, -0.931> }
	smooth_triangle { <-2.1397, 7.7525, 32.4279>, <0.055, 0.362, -0.931>, <-2.6334, 5.5283, 31.5988>, <0.126, 0.597, -0.792>, <-2.6093, 5.5235, 31.6052>, <0.696, 0.347, -0.629> }
	smooth_triangle { <-2.1397, 7.7525, 32.4279>, <0.055, 0.362, -0.931>, <-2.6093, 5.5235, 31.6052>, <0.696, 0.347, -0.629>, <-2.1191, 7.7436, 32.4398>, <0.807, -0.127, -0.577> }
	smooth_triangle { <-2.1191, 7.7436, 32.4398>, <0.807, -0.127, -0.577>, <-2.6093, 5.5235, 31.6052>, <0.820, 0.206, -0.533>, <-2.6035, 5.5023, 31.6179>, <0.981, -0.015, -0.196> }
	smooth_triangle { <-2.1191, 7.7436, 32.4398>, <0.807, -0.127, -0.577>, <-2.6035, 5.5023, 31.6179>, <0.981, -0.015, -0.196>, <-2.1210, 7.7350, 32.4637>, <0.890, -0.455, -0.044> }
	smooth_triangle { <-1.0009, 9.2955, 33.1009>, <0.398, -0.674, 0.622>, <-2.1210, 7.7350, 32.4637>, <0.471, -0.458, 0.754>, <-2.1434, 7.7354, 32.4756>, <-0.056, -0.364, 0.930> }
	smooth_triangle { <-1.0009, 9.2955, 33.1009>, <0.398, -0.674, 0.622>, <-2.1434, 7.7354, 32.4756>, <-0.056, -0.364, 0.930>, <-1.0210, 9.3050, 33.1129>, <-0.240, -0.178, 0.954> }
	smooth_triangle { <-1.0210, 9.3050, 33.1129>, <-0.240, -0.178, 0.954>, <-2.1434, 7.7354, 32.4756>, <-0.056, -0.364, 0.930>, <-2.1640, 7.7443, 32.4637>, <-0.808, 0.125, 0.576> }
	smooth_triangle { <-1.0210, 9.3050, 33.1129>, <-0.240, -0.178, 0.954>, <-2.1640, 7.7443, 32.4637>, <-0.808, 0.125, 0.576>, <-1.0366, 9.3211, 33.1009>, <-0.741, 0.508, 0.439> }
	smooth_triangle { <-1.0366, 9.3211, 33.1009>, <-0.741, 0.508, 0.439>, <-2.1640, 7.7443, 32.4637>, <-0.808, 0.125, 0.576>, <-2.1621, 7.7529, 32.4398>, <-0.761, 0.510, -0.401> }
	smooth_triangle { <-1.0366, 9.3211, 33.1009>, <-0.741, 0.508, 0.439>, <-2.1621, 7.7529, 32.4398>, <-0.761, 0.510, -0.401>, <-1.0320, 9.3276, 33.0767>, <-0.507, 0.695, -0.510> }
	smooth_triangle { <-1.0320, 9.3276, 33.0767>, <-0.507, 0.695, -0.510>, <-2.1621, 7.7529, 32.4398>, <-0.761, 0.510, -0.401>, <-2.1397, 7.7525, 32.4279>, <0.055, 0.362, -0.931> }
	smooth_triangle { <-1.0320, 9.3276, 33.0767>, <-0.507, 0.695, -0.510>, <-2.1397, 7.7525, 32.4279>, <0.055, 0.362, -0.931>, <-1.0118, 9.3180, 33.0647>, <0.246, 0.185, -0.951> }
	smooth_triangle { <-1.0118, 9.3180, 33.0647>, <0.246, 0.185, -0.951>, <-2.1397, 7.7525, 32.4279>, <0.055, 0.362, -0.931>, <-2.1191, 7.7436, 32.4398>, <0.807, -0.127, -0.577> }
	smooth_triangle { <-1.0118, 9.3180, 33.0647>, <0.246, 0.185, -0.951>, <-2.1191, 7.7436, 32.4398>, <0.807, -0.127, -0.577>, <-0.9962, 9.3019, 33.0767>, <0.747, -0.502, -0.436> }
	smooth_triangle { <-0.9962, 9.3019, 33.0767>, <0.747, -0.502, -0.436>, <-2.1191, 7.7436, 32.4398>, <0.807, -0.127, -0.577>, <-2.1210, 7.7350, 32.4637>, <0.890, -0.455, -0.044> }
	smooth_triangle { <-0.9962, 9.3019, 33.0767>, <0.747, -0.502, -0.436>, <-2.1210, 7.7350, 32.4637>, <0.890, -0.455, -0.044>, <-1.0009, 9.2955, 33.1009>, <0.812, -0.583, 0.000> }
	smooth_triangle { <0.5686, 10.4847, 33.5791>, <0.196, -0.570, 0.798>, <-1.0009, 9.2955, 33.1009>, <0.398, -0.674, 0.622>, <-1.0210, 9.3050, 33.1129>, <-0.240, -0.178, 0.954> }
	smooth_triangle { <0.5686, 10.4847, 33.5791>, <-0.418, 0.225, 0.880>, <-1.0210, 9.3050, 33.1129>, <-0.240, -0.178, 0.954>, <-1.0366, 9.3211, 33.1009>, <-0.741, 0.508, 0.439> }
	smooth_triangle { <0.5686, 10.4847, 33.5791>, <-0.598, 0.797, 0.091>, <-1.0366, 9.3211, 33.1009>, <-0.741, 0.508, 0.439>, <-1.0320, 9.3276, 33.0767>, <-0.507, 0.695, -0.510> }
	smooth_triangle { <0.5686, 10.4847, 33.5791>, <-0.173, 0.591, -0.788>, <-1.0320, 9.3276, 33.0767>, <-0.507, 0.695, -0.510>, <-1.0118, 9.3180, 33.0647>, <0.246, 0.185, -0.951> }
	smooth_triangle { <0.5686, 10.4847, 33.5791>, <0.442, -0.204, -0.874>, <-1.0118, 9.3180, 33.0647>, <0.246, 0.185, -0.951>, <-0.9962, 9.3019, 33.0767>, <0.747, -0.502, -0.436> }
	smooth_triangle { <0.5686, 10.4847, 33.5791>, <0.622, -0.779, -0.082>, <-0.9962, 9.3019, 33.0767>, <0.747, -0.502, -0.436>, <-1.0009, 9.2955, 33.1009>, <0.398, -0.674, 0.622> }
	smooth_triangle { <-2.2392, 3.4701, 29.5159>, <-0.943, 0.073, 0.324>, <-2.7299, 3.8307, 28.0087>, <-0.965, 0.091, 0.246>, <-2.7263, 3.8554, 28.0135>, <-0.918, 0.277, 0.283> }
	smooth_triangle { <-2.2392, 3.4701, 29.5159>, <-0.943, 0.073, 0.324>, <-2.7263, 3.8554, 28.0135>, <-0.918, 0.277, 0.283>, <-2.2356, 3.4948, 29.5207>, <-0.622, 0.691, 0.368> }
	smooth_triangle { <-2.2356, 3.4948, 29.5207>, <-0.622, 0.691, 0.368>, <-2.7263, 3.8554, 28.0135>, <-0.833, 0.469, 0.295>, <-2.7038, 3.8661, 28.0087>, <-0.191, 0.961, 0.200> }
	smooth_triangle { <-2.2356, 3.4948, 29.5207>, <-0.622, 0.691, 0.368>, <-2.7038, 3.8661, 28.0087>, <-0.191, 0.961, 0.200>, <-2.2131, 3.5055, 29.5159>, <0.315, 0.941, 0.123> }
	smooth_triangle { <-2.2131, 3.5055, 29.5159>, <0.315, 0.941, 0.123>, <-2.7038, 3.8661, 28.0087>, <0.017, 0.984, 0.177>, <-2.6848, 3.8522, 27.9992>, <0.726, 0.682, -0.082> }
	smooth_triangle { <-2.2131, 3.5055, 29.5159>, <0.315, 0.941, 0.123>, <-2.6848, 3.8522, 27.9992>, <0.726, 0.682, -0.082>, <-2.1942, 3.4916, 29.5064>, <0.937, 0.250, -0.245> }
	smooth_triangle { <-2.1942, 3.4916, 29.5064>, <0.937, 0.250, -0.245>, <-2.6848, 3.8522, 27.9992>, <0.849, 0.515, -0.116>, <-2.6884, 3.8275, 27.9944>, <0.919, -0.277, -0.281> }
	smooth_triangle { <-2.1942, 3.4916, 29.5064>, <0.937, 0.250, -0.245>, <-2.6884, 3.8275, 27.9944>, <0.919, -0.277, -0.281>, <-2.1977, 3.4669, 29.5017>, <0.622, -0.691, -0.368> }
	smooth_triangle { <-2.1977, 3.4669, 29.5017>, <0.622, -0.691, -0.368>, <-2.6884, 3.8275, 27.9944>, <0.834, -0.469, -0.291>, <-2.7109, 3.8168, 27.9992>, <0.192, -0.961, -0.198> }
	smooth_triangle { <-2.1977, 3.4669, 29.5017>, <0.622, -0.691, -0.368>, <-2.7109, 3.8168, 27.9992>, <0.192, -0.961, -0.198>, <-2.2202, 3.4561, 29.5064>, <-0.315, -0.941, -0.123> }
	smooth_triangle { <-2.2202, 3.4561, 29.5064>, <-0.315, -0.941, -0.123>, <-2.7109, 3.8168, 27.9992>, <-0.016, -0.985, -0.173>, <-2.7299, 3.8307, 28.0087>, <-0.398, -0.917, -0.027> }
	smooth_triangle { <-2.2202, 3.4561, 29.5064>, <-0.315, -0.941, -0.123>, <-2.7299, 3.8307, 28.0087>, <-0.398, -0.917, -0.027>, <-2.2392, 3.4701, 29.5159>, <-0.592, -0.806, 0.000> }
	smooth_triangle { <-2.0967, 3.4972, 31.9467>, <-0.858, -0.512, 0.042>, <-2.7299, 3.8307, 28.0087>, <-0.965, 0.091, 0.246>, <-2.7263, 3.8554, 28.0135>, <-0.918, 0.277, 0.283> }
	smooth_triangle { <-2.0967, 3.4972, 31.9467>, <-0.858, -0.512, 0.042>, <-2.7263, 3.8554, 28.0135>, <-0.963, -0.134, 0.233>, <-2.1156, 3.5141, 31.9474>, <-0.945, -0.322, -0.061> }
	smooth_triangle { <-2.1156, 3.5141, 31.9474>, <-0.871, 0.491, -0.005>, <-2.7263, 3.8554, 28.0135>, <-0.833, 0.469, 0.295>, <-2.7038, 3.8661, 28.0087>, <-0.191, 0.961, 0.200> }
	smooth_triangle { <-2.1156, 3.5141, 31.9474>, <-0.998, -0.053, -0.018>, <-2.7038, 3.8661, 28.0087>, <-0.565, 0.783, 0.260>, <-2.1105, 3.5390, 31.9467>, <-0.742, 0.666, -0.075> }
	smooth_triangle { <-2.1105, 3.5390, 31.9467>, <-0.014, 0.999, -0.045>, <-2.7038, 3.8661, 28.0087>, <0.017, 0.984, 0.177>, <-2.6848, 3.8522, 27.9992>, <0.726, 0.682, -0.082> }
	smooth_triangle { <-2.1105, 3.5390, 31.9467>, <-0.531, 0.844, -0.076>, <-2.6848, 3.8522, 27.9992>, <0.399, 0.917, 0.027>, <-2.0864, 3.5469, 31.9453>, <0.206, 0.979, -0.002> }
	smooth_triangle { <-2.0864, 3.5469, 31.9453>, <0.860, 0.510, -0.025>, <-2.6848, 3.8522, 27.9992>, <0.849, 0.515, -0.116>, <-2.6884, 3.8275, 27.9944>, <0.919, -0.277, -0.281> }
	smooth_triangle { <-2.0864, 3.5469, 31.9453>, <0.462, 0.886, -0.045>, <-2.6884, 3.8275, 27.9944>, <0.963, 0.134, -0.233>, <-2.0675, 3.5300, 31.9447>, <0.943, 0.323, 0.082> }
	smooth_triangle { <-2.0675, 3.5300, 31.9447>, <0.871, -0.492, 0.021>, <-2.6884, 3.8275, 27.9944>, <0.834, -0.469, -0.291>, <-2.7109, 3.8168, 27.9992>, <0.192, -0.961, -0.198> }
	smooth_triangle { <-2.0675, 3.5300, 31.9447>, <0.998, 0.053, 0.041>, <-2.7109, 3.8168, 27.9992>, <0.565, -0.783, -0.260>, <-2.0726, 3.5052, 31.9453>, <0.741, -0.664, 0.096> }
	smooth_triangle { <-2.0726, 3.5052, 31.9453>, <0.014, -0.998, 0.062>, <-2.7109, 3.8168, 27.9992>, <-0.016, -0.985, -0.173>, <-2.7299, 3.8307, 28.0087>, <-0.398, -0.917, -0.027> }
	smooth_triangle { <-2.0726, 3.5052, 31.9453>, <0.529, -0.843, 0.097>, <-2.7299, 3.8307, 28.0087>, <-0.398, -0.917, -0.027>, <-2.0967, 3.4972, 31.9467>, <0.316, -0.946, 0.069> }
	smooth_triangle { <-2.7154, 3.8183, 33.8573>, <-0.665, -0.741, -0.091>, <-2.0967, 3.4972, 31.9467>, <-0.858, -0.512, 0.042>, <-2.1156, 3.5141, 31.9474>, <-0.945, -0.322, -0.061> }
	smooth_triangle { <-2.7154, 3.8183, 33.8573>, <0.913, 0.145, 0.381>, <-2.1156, 3.5141, 31.9474>, <0.952, 0.130, 0.278>, <-2.7132, 3.7934, 33.8616>, <0.834, -0.266, 0.484> }
	smooth_triangle { <-2.7132, 3.7934, 33.8616>, <-0.930, 0.184, -0.317>, <-2.1156, 3.5141, 31.9474>, <-0.998, -0.053, -0.018>, <-2.1105, 3.5390, 31.9467>, <-0.742, 0.666, -0.075> }
	smooth_triangle { <-2.7132, 3.7934, 33.8616>, <0.834, -0.266, 0.484>, <-2.1105, 3.5390, 31.9467>, <0.552, -0.786, 0.278>, <-2.7330, 3.7780, 33.8573>, <0.107, -0.939, 0.327> }
	smooth_triangle { <-2.7330, 3.7780, 33.8573>, <-0.317, 0.923, -0.219>, <-2.1105, 3.5390, 31.9467>, <-0.531, 0.844, -0.076>, <-2.0864, 3.5469, 31.9453>, <0.206, 0.979, -0.002> }
	smooth_triangle { <-2.7330, 3.7780, 33.8573>, <0.107, -0.939, 0.327>, <-2.0864, 3.5469, 31.9453>, <-0.393, -0.919, -0.022>, <-2.7548, 3.7876, 33.8485>, <-0.721, -0.672, -0.166> }
	smooth_triangle { <-2.7548, 3.7876, 33.8485>, <0.663, 0.736, 0.140>, <-2.0864, 3.5469, 31.9453>, <0.462, 0.886, -0.045>, <-2.0675, 3.5300, 31.9447>, <0.943, 0.323, 0.082> }
	smooth_triangle { <-2.7548, 3.7876, 33.8485>, <-0.721, -0.672, -0.166>, <-2.0675, 3.5300, 31.9447>, <-0.938, -0.136, -0.320>, <-2.7569, 3.8125, 33.8441>, <-0.824, 0.262, -0.502> }
	smooth_triangle { <-2.7569, 3.8125, 33.8441>, <0.916, -0.180, 0.359>, <-2.0675, 3.5300, 31.9447>, <0.998, 0.053, 0.041>, <-2.0726, 3.5052, 31.9453>, <0.741, -0.664, 0.096> }
	smooth_triangle { <-2.7569, 3.8125, 33.8441>, <-0.824, 0.262, -0.502>, <-2.0726, 3.5052, 31.9453>, <-0.538, 0.780, -0.320>, <-2.7372, 3.8279, 33.8485>, <-0.099, 0.933, -0.346> }
	smooth_triangle { <-2.7372, 3.8279, 33.8485>, <0.315, -0.911, 0.265>, <-2.0726, 3.5052, 31.9453>, <0.529, -0.843, 0.097>, <-2.0967, 3.4972, 31.9467>, <0.316, -0.946, 0.069> }
	smooth_triangle { <-2.7372, 3.8279, 33.8485>, <-0.099, 0.933, -0.346>, <-2.0967, 3.4972, 31.9467>, <0.407, 0.913, -0.022>, <-2.7154, 3.8183, 33.8573>, <0.462, 0.886, -0.039> }
	smooth_triangle { <-3.7405, 4.4803, 35.4838>, <0.958, 0.000, 0.286>, <-2.7154, 3.8183, 33.8573>, <0.913, 0.145, 0.381>, <-2.7132, 3.7934, 33.8616>, <0.834, -0.266, 0.484> }
	smooth_triangle { <-3.7405, 4.4803, 35.4838>, <0.958, 0.000, 0.286>, <-2.7132, 3.7934, 33.8616>, <0.834, -0.266, 0.484>, <-3.7439, 4.4563, 35.4915>, <0.718, -0.595, 0.362> }
	smooth_triangle { <-3.7439, 4.4563, 35.4915>, <0.591, -0.710, 0.383>, <-2.7132, 3.7934, 33.8616>, <0.834, -0.266, 0.484>, <-2.7330, 3.7780, 33.8573>, <0.107, -0.939, 0.327> }
	smooth_triangle { <-3.7439, 4.4563, 35.4915>, <0.591, -0.710, 0.383>, <-2.7330, 3.7780, 33.8573>, <0.107, -0.939, 0.327>, <-3.7644, 4.4434, 35.4838>, <-0.211, -0.940, 0.268> }
	smooth_triangle { <-3.7644, 4.4434, 35.4838>, <-0.373, -0.877, 0.302>, <-2.7330, 3.7780, 33.8573>, <0.107, -0.939, 0.327>, <-2.7548, 3.7876, 33.8485>, <-0.721, -0.672, -0.166> }
	smooth_triangle { <-3.7644, 4.4434, 35.4838>, <-0.373, -0.877, 0.302>, <-2.7548, 3.7876, 33.8485>, <-0.721, -0.672, -0.166>, <-3.7814, 4.4544, 35.4685>, <-0.936, -0.338, -0.099> }
	smooth_triangle { <-3.7814, 4.4544, 35.4685>, <-0.983, -0.158, -0.089>, <-2.7548, 3.7876, 33.8485>, <-0.721, -0.672, -0.166>, <-2.7569, 3.8125, 33.8441>, <-0.824, 0.262, -0.502> }
	smooth_triangle { <-3.7814, 4.4544, 35.4685>, <-0.983, -0.158, -0.089>, <-2.7569, 3.8125, 33.8441>, <-0.824, 0.262, -0.502>, <-3.7780, 4.4784, 35.4609>, <-0.719, 0.595, -0.358> }
	smooth_triangle { <-3.7780, 4.4784, 35.4609>, <-0.593, 0.709, -0.381>, <-2.7569, 3.8125, 33.8441>, <-0.824, 0.262, -0.502>, <-2.7372, 3.8279, 33.8485>, <-0.099, 0.933, -0.346> }
	smooth_triangle { <-3.7780, 4.4784, 35.4609>, <-0.593, 0.709, -0.381>, <-2.7372, 3.8279, 33.8485>, <-0.099, 0.933, -0.346>, <-3.7575, 4.4913, 35.4685>, <0.209, 0.942, -0.264> }
	smooth_triangle { <-3.7575, 4.4913, 35.4685>, <0.371, 0.878, -0.301>, <-2.7372, 3.8279, 33.8485>, <-0.099, 0.933, -0.346>, <-2.7154, 3.8183, 33.8573>, <0.462, 0.886, -0.039> }
	smooth_triangle { <-3.7575, 4.4913, 35.4685>, <0.371, 0.878, -0.301>, <-2.7154, 3.8183, 33.8573>, <0.462, 0.886, -0.039>, <-3.7405, 4.4803, 35.4838>, <0.650, 0.734, -0.194> }
	smooth_triangle { <-3.2313, 5.0231, 37.3577>, <0.958, -0.202, -0.202>, <-3.7405, 4.4803, 35.4838>, <0.958, 0.000, 0.286>, <-3.7439, 4.4563, 35.4915>, <0.718, -0.595, 0.362> }
	smooth_triangle { <-3.2313, 5.0231, 37.3577>, <-0.081, -0.805, 0.588>, <-3.7439, 4.4563, 35.4915>, <0.281, -0.869, 0.407>, <-3.2555, 5.0291, 37.3626>, <-0.230, -0.743, 0.628> }
	smooth_triangle { <-3.2555, 5.0291, 37.3626>, <0.162, -0.830, 0.534>, <-3.7439, 4.4563, 35.4915>, <0.591, -0.710, 0.383>, <-3.7644, 4.4434, 35.4838>, <-0.049, -0.975, 0.216> }
	smooth_triangle { <-3.2555, 5.0291, 37.3626>, <-0.539, -0.575, 0.615>, <-3.7644, 4.4434, 35.4838>, <-0.693, -0.688, 0.214>, <-3.2640, 5.0525, 37.3577>, <-0.933, -0.004, 0.361> }
	smooth_triangle { <-3.2640, 5.0525, 37.3577>, <-0.786, -0.321, 0.529>, <-3.7644, 4.4434, 35.4838>, <-0.534, -0.787, 0.309>, <-3.7814, 4.4544, 35.4685>, <-0.936, -0.338, -0.099> }
	smooth_triangle { <-3.2640, 5.0525, 37.3577>, <-0.949, 0.242, 0.202>, <-3.7814, 4.4544, 35.4685>, <-0.956, 0.187, -0.225>, <-3.2483, 5.0699, 37.3480>, <-0.674, 0.696, -0.250> }
	smooth_triangle { <-3.2483, 5.0699, 37.3480>, <-0.881, 0.472, -0.020>, <-3.7814, 4.4544, 35.4685>, <-0.983, -0.158, -0.089>, <-3.7780, 4.4784, 35.4609>, <-0.719, 0.595, -0.358> }
	smooth_triangle { <-3.2483, 5.0699, 37.3480>, <-0.407, 0.813, -0.416>, <-3.7780, 4.4784, 35.4609>, <-0.283, 0.869, -0.406>, <-3.2241, 5.0639, 37.3431>, <0.228, 0.742, -0.631> }
	smooth_triangle { <-3.2241, 5.0639, 37.3431>, <-0.165, 0.829, -0.535>, <-3.7780, 4.4784, 35.4609>, <-0.593, 0.709, -0.381>, <-3.7575, 4.4913, 35.4685>, <0.048, 0.976, -0.212> }
	smooth_triangle { <-3.2241, 5.0639, 37.3431>, <0.537, 0.572, -0.619>, <-3.7575, 4.4913, 35.4685>, <0.693, 0.688, -0.216>, <-3.2156, 5.0405, 37.3480>, <0.931, 0.003, -0.364> }
	smooth_triangle { <-3.2156, 5.0405, 37.3480>, <0.785, 0.320, -0.531>, <-3.7575, 4.4913, 35.4685>, <0.533, 0.787, -0.310>, <-3.7405, 4.4803, 35.4838>, <0.650, 0.734, -0.194> }
	smooth_triangle { <-3.2156, 5.0405, 37.3480>, <0.948, -0.243, -0.206>, <-3.7405, 4.4803, 35.4838>, <0.741, -0.671, -0.007>, <-3.2313, 5.0231, 37.3577>, <0.829, -0.552, 0.092> }
	smooth_triangle { <-2.6869, 6.2537, 38.2910>, <0.207, -0.568, 0.796>, <-3.2313, 5.0231, 37.3577>, <-0.081, -0.805, 0.588>, <-3.2555, 5.0291, 37.3626>, <-0.230, -0.743, 0.628> }
	smooth_triangle { <-2.6869, 6.2537, 38.2910>, <0.452, -0.487, 0.747>, <-3.2555, 5.0291, 37.3626>, <-0.040, -0.776, 0.630>, <-2.7100, 6.2559, 38.3015>, <-0.360, -0.439, 0.823> }
	smooth_triangle { <-2.7100, 6.2559, 38.3015>, <-0.527, -0.408, 0.746>, <-3.2555, 5.0291, 37.3626>, <-0.380, -0.631, 0.677>, <-3.2640, 5.0525, 37.3577>, <-0.933, -0.004, 0.361> }
	smooth_triangle { <-2.7100, 6.2559, 38.3015>, <-0.360, -0.439, 0.823>, <-3.2640, 5.0525, 37.3577>, <-0.786, -0.321, 0.529>, <-2.7272, 6.2714, 38.2910>, <-0.949, -0.059, 0.308> }
	smooth_triangle { <-2.7272, 6.2714, 38.2910>, <-0.922, 0.343, -0.179>, <-3.2640, 5.0525, 37.3577>, <-0.949, 0.242, 0.202>, <-3.2483, 5.0699, 37.3480>, <-0.674, 0.696, -0.250> }
	smooth_triangle { <-2.7272, 6.2714, 38.2910>, <-0.978, 0.085, 0.190>, <-3.2483, 5.0699, 37.3480>, <-0.881, 0.472, -0.020>, <-2.7214, 6.2847, 38.2702>, <-0.725, 0.446, -0.524> }
	smooth_triangle { <-2.7214, 6.2847, 38.2702>, <-0.205, 0.574, -0.793>, <-3.2483, 5.0699, 37.3480>, <-0.407, 0.813, -0.416>, <-3.2241, 5.0639, 37.3431>, <0.228, 0.742, -0.631> }
	smooth_triangle { <-2.7214, 6.2847, 38.2702>, <-0.596, 0.511, -0.619>, <-3.2241, 5.0639, 37.3431>, <0.038, 0.775, -0.631>, <-2.6983, 6.2825, 38.2597>, <0.362, 0.447, -0.818> }
	smooth_triangle { <-2.6983, 6.2825, 38.2597>, <0.528, 0.411, -0.743>, <-3.2241, 5.0639, 37.3431>, <0.378, 0.627, -0.681>, <-3.2156, 5.0405, 37.3480>, <0.931, 0.003, -0.364> }
	smooth_triangle { <-2.6983, 6.2825, 38.2597>, <0.362, 0.447, -0.818>, <-3.2156, 5.0405, 37.3480>, <0.785, 0.320, -0.531>, <-2.6811, 6.2670, 38.2702>, <0.951, 0.069, -0.301> }
	smooth_triangle { <-2.6811, 6.2670, 38.2702>, <0.923, -0.338, 0.184>, <-3.2156, 5.0405, 37.3480>, <0.948, -0.243, -0.206>, <-3.2313, 5.0231, 37.3577>, <0.829, -0.552, 0.092> }
	smooth_triangle { <-2.6811, 6.2670, 38.2702>, <0.980, -0.077, -0.182>, <-3.2313, 5.0231, 37.3577>, <0.829, -0.552, 0.092>, <-2.6869, 6.2537, 38.2910>, <0.915, -0.403, -0.002> }
	smooth_triangle { <-2.8608, 7.6866, 39.0610>, <0.305, -0.416, 0.857>, <-2.6869, 6.2537, 38.2910>, <0.452, -0.487, 0.747>, <-2.7100, 6.2559, 38.3015>, <-0.223, -0.501, 0.836> }
	smooth_triangle { <-2.8608, 7.6866, 39.0610>, <-0.686, -0.391, 0.614>, <-2.7100, 6.2559, 38.3015>, <-0.360, -0.439, 0.823>, <-2.7272, 6.2714, 38.2910>, <-0.949, -0.059, 0.308> }
	smooth_triangle { <-2.8608, 7.6866, 39.0610>, <-0.971, 0.043, -0.235>, <-2.7272, 6.2714, 38.2910>, <-0.978, 0.085, 0.190>, <-2.7214, 6.2847, 38.2702>, <-0.725, 0.446, -0.524> }
	smooth_triangle { <-2.8608, 7.6866, 39.0610>, <-0.302, 0.451, -0.840>, <-2.7214, 6.2847, 38.2702>, <-0.596, 0.511, -0.619>, <-2.6983, 6.2825, 38.2597>, <0.226, 0.511, -0.829> }
	smooth_triangle { <-2.8608, 7.6866, 39.0610>, <0.688, 0.423, -0.589>, <-2.6983, 6.2825, 38.2597>, <0.362, 0.447, -0.818>, <-2.6811, 6.2670, 38.2702>, <0.951, 0.069, -0.301> }
	smooth_triangle { <-2.8608, 7.6866, 39.0610>, <0.967, -0.012, 0.253>, <-2.6811, 6.2670, 38.2702>, <0.980, -0.077, -0.182>, <-2.6869, 6.2537, 38.2910>, <0.596, -0.414, 0.688> }
	smooth_triangle { <-2.1213, 2.9149, 26.5261>, <-0.131, 0.749, 0.650>, <-1.4892, 3.9581, 25.4515>, <-0.123, 0.761, 0.637>, <-1.4661, 3.9539, 25.4610>, <0.190, 0.658, 0.729> }
	smooth_triangle { <-2.1213, 2.9149, 26.5261>, <-0.131, 0.749, 0.650>, <-1.4661, 3.9539, 25.4610>, <0.190, 0.658, 0.729>, <-2.0981, 2.9107, 26.5356>, <0.498, 0.457, 0.737> }
	smooth_triangle { <-2.0981, 2.9107, 26.5356>, <0.498, 0.457, 0.737>, <-1.4661, 3.9539, 25.4610>, <0.190, 0.658, 0.729>, <-1.4516, 3.9353, 25.4515>, <0.870, -0.035, 0.491> }
	smooth_triangle { <-2.0981, 2.9107, 26.5356>, <0.498, 0.457, 0.737>, <-1.4516, 3.9353, 25.4515>, <0.870, -0.035, 0.491>, <-2.0837, 2.8922, 26.5261>, <0.920, -0.305, 0.246> }
	smooth_triangle { <-2.0837, 2.8922, 26.5261>, <0.920, -0.305, 0.246>, <-1.4516, 3.9353, 25.4515>, <0.870, -0.035, 0.491>, <-1.4603, 3.9210, 25.4324>, <0.680, -0.693, -0.238> }
	smooth_triangle { <-2.0837, 2.8922, 26.5261>, <0.920, -0.305, 0.246>, <-1.4603, 3.9210, 25.4324>, <0.680, -0.693, -0.238>, <-2.0924, 2.8778, 26.5070>, <0.422, -0.762, -0.491> }
	smooth_triangle { <-2.0924, 2.8778, 26.5070>, <0.422, -0.762, -0.491>, <-1.4603, 3.9210, 25.4324>, <0.680, -0.693, -0.238>, <-1.4835, 3.9252, 25.4229>, <-0.190, -0.658, -0.729> }
	smooth_triangle { <-2.0924, 2.8778, 26.5070>, <0.422, -0.762, -0.491>, <-1.4835, 3.9252, 25.4229>, <-0.190, -0.658, -0.729>, <-2.1155, 2.8820, 26.4975>, <-0.498, -0.457, -0.737> }
	smooth_triangle { <-2.1155, 2.8820, 26.4975>, <-0.498, -0.457, -0.737>, <-1.4835, 3.9252, 25.4229>, <-0.190, -0.658, -0.729>, <-1.4979, 3.9438, 25.4324>, <-0.870, 0.035, -0.491> }
	smooth_triangle { <-2.1155, 2.8820, 26.4975>, <-0.498, -0.457, -0.737>, <-1.4979, 3.9438, 25.4324>, <-0.870, 0.035, -0.491>, <-2.1300, 2.9006, 26.5070>, <-0.920, 0.305, -0.246> }
	smooth_triangle { <-2.1300, 2.9006, 26.5070>, <-0.920, 0.305, -0.246>, <-1.4979, 3.9438, 25.4324>, <-0.870, 0.035, -0.491>, <-1.4892, 3.9581, 25.4515>, <-0.842, 0.540, -0.003> }
	smooth_triangle { <-2.1300, 2.9006, 26.5070>, <-0.920, 0.305, -0.246>, <-1.4892, 3.9581, 25.4515>, <-0.842, 0.540, -0.003>, <-2.1213, 2.9149, 26.5261>, <-0.855, 0.518, 0.000> }
	smooth_triangle { <-3.3465, 1.2452, 28.4737>, <0.036, 0.900, 0.435>, <-1.4892, 3.9581, 25.4515>, <-0.123, 0.761, 0.637>, <-1.4661, 3.9539, 25.4610>, <0.190, 0.658, 0.729> }
	smooth_triangle { <-3.3465, 1.2452, 28.4737>, <0.036, 0.900, 0.435>, <-1.4661, 3.9539, 25.4610>, <0.190, 0.658, 0.729>, <-3.3236, 1.2392, 28.4829>, <0.609, 0.603, 0.516> }
	smooth_triangle { <-3.3236, 1.2392, 28.4829>, <0.685, 0.529, 0.502>, <-1.4661, 3.9539, 25.4610>, <0.190, 0.658, 0.729>, <-1.4516, 3.9353, 25.4515>, <0.870, -0.035, 0.491> }
	smooth_triangle { <-3.3236, 1.2392, 28.4829>, <0.685, 0.529, 0.502>, <-1.4516, 3.9353, 25.4515>, <0.870, -0.035, 0.491>, <-3.3111, 1.2191, 28.4737>, <0.843, -0.421, 0.334> }
	smooth_triangle { <-3.3111, 1.2191, 28.4737>, <0.843, -0.421, 0.334>, <-1.4516, 3.9353, 25.4515>, <0.870, -0.035, 0.491>, <-1.4603, 3.9210, 25.4324>, <0.680, -0.693, -0.238> }
	smooth_triangle { <-3.3111, 1.2191, 28.4737>, <0.843, -0.421, 0.334>, <-1.4603, 3.9210, 25.4324>, <0.680, -0.693, -0.238>, <-3.3213, 1.2051, 28.4552>, <0.428, -0.861, -0.273> }
	smooth_triangle { <-3.3213, 1.2051, 28.4552>, <0.158, -0.972, -0.176>, <-1.4603, 3.9210, 25.4324>, <0.680, -0.693, -0.238>, <-1.4835, 3.9252, 25.4229>, <-0.190, -0.658, -0.729> }
	smooth_triangle { <-3.3213, 1.2051, 28.4552>, <0.158, -0.972, -0.176>, <-1.4835, 3.9252, 25.4229>, <-0.190, -0.658, -0.729>, <-3.3442, 1.2111, 28.4459>, <-0.608, -0.603, -0.516> }
	smooth_triangle { <-3.3442, 1.2111, 28.4459>, <-0.684, -0.529, -0.502>, <-1.4835, 3.9252, 25.4229>, <-0.190, -0.658, -0.729>, <-1.4979, 3.9438, 25.4324>, <-0.870, 0.035, -0.491> }
	smooth_triangle { <-3.3442, 1.2111, 28.4459>, <-0.684, -0.529, -0.502>, <-1.4979, 3.9438, 25.4324>, <-0.870, 0.035, -0.491>, <-3.3568, 1.2311, 28.4552>, <-0.843, 0.421, -0.335> }
	smooth_triangle { <-3.3568, 1.2311, 28.4552>, <-0.843, 0.421, -0.335>, <-1.4979, 3.9438, 25.4324>, <-0.870, 0.035, -0.491>, <-1.4892, 3.9581, 25.4515>, <-0.842, 0.540, -0.003> }
	smooth_triangle { <-3.3568, 1.2311, 28.4552>, <-0.843, 0.421, -0.335>, <-1.4892, 3.9581, 25.4515>, <-0.842, 0.540, -0.003>, <-3.3465, 1.2452, 28.4737>, <-0.664, 0.725, -0.180> }
	smooth_triangle { <-4.2892, 1.6641, 30.6647>, <0.796, 0.506, 0.333>, <-3.3465, 1.2452, 28.4737>, <0.036, 0.900, 0.435>, <-3.3236, 1.2392, 28.4829>, <0.685, 0.529, 0.502> }
	smooth_triangle { <-4.2892, 1.6641, 30.6647>, <0.796, 0.506, 0.333>, <-3.3236, 1.2392, 28.4829>, <0.795, 0.432, 0.427>, <-4.2875, 1.6394, 30.6702>, <0.886, -0.003, 0.464> }
	smooth_triangle { <-4.2875, 1.6394, 30.6702>, <0.789, 0.414, 0.454>, <-3.3236, 1.2392, 28.4829>, <0.685, 0.529, 0.502>, <-3.3111, 1.2191, 28.4737>, <0.949, -0.156, 0.275> }
	smooth_triangle { <-4.2875, 1.6394, 30.6702>, <0.844, -0.361, 0.397>, <-3.3111, 1.2191, 28.4737>, <0.763, -0.568, 0.310>, <-4.3068, 1.6238, 30.6647>, <0.407, -0.895, 0.183> }
	smooth_triangle { <-4.3068, 1.6238, 30.6647>, <0.407, -0.895, 0.183>, <-3.3111, 1.2191, 28.4737>, <0.763, -0.568, 0.310>, <-3.3213, 1.2051, 28.4552>, <0.158, -0.972, -0.176> }
	smooth_triangle { <-4.3068, 1.6238, 30.6647>, <0.238, -0.967, 0.089>, <-3.3213, 1.2051, 28.4552>, <-0.008, -0.980, -0.198>, <-4.3277, 1.6329, 30.6536>, <-0.443, -0.853, -0.274> }
	smooth_triangle { <-4.3277, 1.6329, 30.6536>, <-0.443, -0.853, -0.274>, <-3.3213, 1.2051, 28.4552>, <-0.008, -0.980, -0.198>, <-3.3442, 1.2111, 28.4459>, <-0.684, -0.529, -0.502> }
	smooth_triangle { <-4.3277, 1.6329, 30.6536>, <-0.613, -0.732, -0.297>, <-3.3442, 1.2111, 28.4459>, <-0.794, -0.432, -0.428>, <-4.3294, 1.6576, 30.6481>, <-0.887, 0.003, -0.461> }
	smooth_triangle { <-4.3294, 1.6576, 30.6481>, <-0.790, -0.413, -0.454>, <-3.3442, 1.2111, 28.4459>, <-0.684, -0.529, -0.502>, <-3.3568, 1.2311, 28.4552>, <-0.949, 0.155, -0.274> }
	smooth_triangle { <-4.3294, 1.6576, 30.6481>, <-0.847, 0.361, -0.390>, <-3.3568, 1.2311, 28.4552>, <-0.762, 0.568, -0.311>, <-4.3102, 1.6732, 30.6536>, <-0.406, 0.895, -0.183> }
	smooth_triangle { <-4.3102, 1.6732, 30.6536>, <-0.406, 0.895, -0.183>, <-3.3568, 1.2311, 28.4552>, <-0.762, 0.568, -0.311>, <-3.3465, 1.2452, 28.4737>, <-0.351, 0.926, -0.140> }
	smooth_triangle { <-4.3102, 1.6732, 30.6536>, <-0.239, 0.967, -0.086>, <-3.3465, 1.2452, 28.4737>, <-0.032, 0.978, -0.206>, <-4.2892, 1.6641, 30.6647>, <0.007, 0.988, 0.154> }
	smooth_triangle { <-5.4405, 0.9324, 32.6969>, <0.572, 0.671, 0.473>, <-4.2892, 1.6641, 30.6647>, <0.796, 0.506, 0.333>, <-4.2875, 1.6394, 30.6702>, <0.886, -0.003, 0.464> }
	smooth_triangle { <-5.4405, 0.9324, 32.6969>, <0.286, 0.802, 0.525>, <-4.2875, 1.6394, 30.6702>, <0.789, 0.414, 0.454>, <-5.4196, 0.9198, 32.7039>, <0.771, 0.529, 0.355> }
	smooth_triangle { <-5.4196, 0.9198, 32.7039>, <0.949, -0.252, 0.191>, <-4.2875, 1.6394, 30.6702>, <0.844, -0.361, 0.397>, <-4.3068, 1.6238, 30.6647>, <0.407, -0.895, 0.183> }
	smooth_triangle { <-5.4196, 0.9198, 32.7039>, <0.894, 0.280, 0.351>, <-4.3068, 1.6238, 30.6647>, <0.675, -0.651, 0.348>, <-5.4163, 0.8957, 32.6969>, <0.915, -0.403, 0.032> }
	smooth_triangle { <-5.4163, 0.8957, 32.6969>, <0.392, -0.879, -0.271>, <-4.3068, 1.6238, 30.6647>, <0.238, -0.967, 0.089>, <-4.3277, 1.6329, 30.6536>, <-0.443, -0.853, -0.274> }
	smooth_triangle { <-5.4163, 0.8957, 32.6969>, <0.789, -0.609, -0.082>, <-4.3277, 1.6329, 30.6536>, <-0.080, -0.992, -0.100>, <-5.4340, 0.8841, 32.6828>, <0.143, -0.936, -0.322> }
	smooth_triangle { <-5.4340, 0.8841, 32.6828>, <-0.576, -0.671, -0.467>, <-4.3277, 1.6329, 30.6536>, <-0.613, -0.732, -0.297>, <-4.3294, 1.6576, 30.6481>, <-0.887, 0.003, -0.461> }
	smooth_triangle { <-5.4340, 0.8841, 32.6828>, <-0.094, -0.897, -0.432>, <-4.3294, 1.6576, 30.6481>, <-0.790, -0.413, -0.454>, <-5.4549, 0.8966, 32.6758>, <-0.771, -0.530, -0.353> }
	smooth_triangle { <-5.4549, 0.8966, 32.6758>, <-0.950, 0.253, -0.184>, <-4.3294, 1.6576, 30.6481>, <-0.847, 0.361, -0.390>, <-4.3102, 1.6732, 30.6536>, <-0.406, 0.895, -0.183> }
	smooth_triangle { <-5.4549, 0.8966, 32.6758>, <-0.896, -0.281, -0.345>, <-4.3102, 1.6732, 30.6536>, <-0.673, 0.652, -0.348>, <-5.4582, 0.9208, 32.6828>, <-0.915, 0.403, -0.031> }
	smooth_triangle { <-5.4582, 0.9208, 32.6828>, <-0.394, 0.877, 0.276>, <-4.3102, 1.6732, 30.6536>, <-0.239, 0.967, -0.086>, <-4.2892, 1.6641, 30.6647>, <0.007, 0.988, 0.154> }
	smooth_triangle { <-5.4582, 0.9208, 32.6828>, <-0.790, 0.608, 0.085>, <-4.2892, 1.6641, 30.6647>, <0.007, 0.988, 0.154>, <-5.4405, 0.9324, 32.6969>, <-0.545, 0.839, -0.007> }
	smooth_triangle { <-5.2000, 0.0333, 34.9534>, <0.380, 0.871, 0.311>, <-5.4405, 0.9324, 32.6969>, <0.286, 0.802, 0.525>, <-5.4196, 0.9198, 32.7039>, <0.771, 0.529, 0.355> }
	smooth_triangle { <-5.2000, 0.0333, 34.9534>, <0.986, 0.162, -0.028>, <-5.4196, 0.9198, 32.7039>, <0.894, 0.280, 0.351>, <-5.4163, 0.8957, 32.6969>, <0.915, -0.403, 0.032> }
	smooth_triangle { <-5.2000, 0.0333, 34.9534>, <0.635, -0.701, -0.324>, <-5.4163, 0.8957, 32.6969>, <0.789, -0.609, -0.082>, <-5.4340, 0.8841, 32.6828>, <0.143, -0.936, -0.322> }
	smooth_triangle { <-5.2000, 0.0333, 34.9534>, <-0.384, -0.878, -0.285>, <-5.4340, 0.8841, 32.6828>, <-0.094, -0.897, -0.432>, <-5.4549, 0.8966, 32.6758>, <-0.771, -0.530, -0.353> }
	smooth_triangle { <-5.2000, 0.0333, 34.9534>, <-0.984, -0.170, 0.050>, <-5.4549, 0.8966, 32.6758>, <-0.896, -0.281, -0.345>, <-5.4582, 0.9208, 32.6828>, <-0.915, 0.403, -0.031> }
	smooth_triangle { <-5.2000, 0.0333, 34.9534>, <-0.637, 0.688, 0.346>, <-5.4582, 0.9208, 32.6828>, <-0.790, 0.608, 0.085>, <-5.4405, 0.9324, 32.6969>, <0.024, 0.903, 0.429> }
	smooth_triangle { <-2.0643, 5.1689, 26.3276>, <0.656, -0.193, 0.730>, <-1.4520, 3.9433, 25.4526>, <0.663, -0.207, 0.720>, <-1.4687, 3.9273, 25.4633>, <0.447, -0.402, 0.799> }
	smooth_triangle { <-2.0643, 5.1689, 26.3276>, <0.656, -0.193, 0.730>, <-1.4687, 3.9273, 25.4633>, <0.447, -0.402, 0.799>, <-2.0810, 5.1529, 26.3383>, <0.067, -0.557, 0.828> }
	smooth_triangle { <-2.0810, 5.1529, 26.3383>, <0.067, -0.557, 0.828>, <-1.4687, 3.9273, 25.4633>, <0.447, -0.402, 0.799>, <-1.4914, 3.9236, 25.4526>, <-0.460, -0.719, 0.521> }
	smooth_triangle { <-2.0810, 5.1529, 26.3383>, <0.067, -0.557, 0.828>, <-1.4914, 3.9236, 25.4526>, <-0.460, -0.719, 0.521>, <-2.1037, 5.1492, 26.3276>, <-0.767, -0.580, 0.276> }
	smooth_triangle { <-2.1037, 5.1492, 26.3276>, <-0.767, -0.580, 0.276>, <-1.4914, 3.9236, 25.4526>, <-0.548, -0.696, 0.464>, <-1.4975, 3.9358, 25.4312>, <-0.907, -0.316, -0.279> }
	smooth_triangle { <-2.1037, 5.1492, 26.3276>, <-0.767, -0.580, 0.276>, <-1.4975, 3.9358, 25.4312>, <-0.907, -0.316, -0.279>, <-2.1098, 5.1614, 26.3062>, <-0.834, -0.023, -0.552> }
	smooth_triangle { <-2.1098, 5.1614, 26.3062>, <-0.834, -0.023, -0.552>, <-1.4975, 3.9358, 25.4312>, <-0.907, -0.316, -0.279>, <-1.4809, 3.9518, 25.4205>, <-0.447, 0.402, -0.799> }
	smooth_triangle { <-2.1098, 5.1614, 26.3062>, <-0.834, -0.023, -0.552>, <-1.4809, 3.9518, 25.4205>, <-0.447, 0.402, -0.799>, <-2.0932, 5.1774, 26.2955>, <-0.067, 0.557, -0.828> }
	smooth_triangle { <-2.0932, 5.1774, 26.2955>, <-0.067, 0.557, -0.828>, <-1.4809, 3.9518, 25.4205>, <-0.447, 0.402, -0.799>, <-1.4581, 3.9555, 25.4312>, <0.460, 0.719, -0.521> }
	smooth_triangle { <-2.0932, 5.1774, 26.2955>, <-0.067, 0.557, -0.828>, <-1.4581, 3.9555, 25.4312>, <0.460, 0.719, -0.521>, <-2.0705, 5.1811, 26.3062>, <0.767, 0.580, -0.276> }
	smooth_triangle { <-2.0705, 5.1811, 26.3062>, <0.767, 0.580, -0.276>, <-1.4581, 3.9555, 25.4312>, <0.547, 0.697, -0.464>, <-1.4520, 3.9433, 25.4526>, <0.855, 0.519, 0.003> }
	smooth_triangle { <-2.0705, 5.1811, 26.3062>, <0.767, 0.580, -0.276>, <-1.4520, 3.9433, 25.4526>, <0.855, 0.519, 0.003>, <-2.0643, 5.1689, 26.3276>, <0.895, 0.447, 0.000> }
	smooth_triangle { <-3.4901, 6.7207, 28.2418>, <0.708, -0.108, 0.698>, <-1.4520, 3.9433, 25.4526>, <0.663, -0.207, 0.720>, <-1.4687, 3.9273, 25.4633>, <0.447, -0.402, 0.799> }
	smooth_triangle { <-3.4901, 6.7207, 28.2418>, <0.708, -0.108, 0.698>, <-1.4687, 3.9273, 25.4633>, <0.551, -0.295, 0.780>, <-3.5005, 6.6995, 28.2512>, <0.485, -0.348, 0.802> }
	smooth_triangle { <-3.5005, 6.6995, 28.2512>, <0.133, -0.618, 0.775>, <-1.4687, 3.9273, 25.4633>, <0.361, -0.461, 0.811>, <-1.4914, 3.9236, 25.4526>, <-0.460, -0.719, 0.521> }
	smooth_triangle { <-3.5005, 6.6995, 28.2512>, <0.381, -0.446, 0.810>, <-1.4914, 3.9236, 25.4526>, <-0.332, -0.728, 0.599>, <-3.5225, 6.6909, 28.2418>, <-0.463, -0.788, 0.406> }
	smooth_triangle { <-3.5225, 6.6909, 28.2418>, <-0.551, -0.772, 0.316>, <-1.4914, 3.9236, 25.4526>, <-0.460, -0.719, 0.521>, <-1.4975, 3.9358, 25.4312>, <-0.907, -0.316, -0.279> }
	smooth_triangle { <-3.5225, 6.6909, 28.2418>, <-0.463, -0.788, 0.406>, <-1.4975, 3.9358, 25.4312>, <-0.896, -0.413, -0.164>, <-3.5341, 6.7034, 28.2230>, <-0.837, -0.451, -0.311> }
	smooth_triangle { <-3.5341, 6.7034, 28.2230>, <-0.796, -0.108, -0.596>, <-1.4975, 3.9358, 25.4312>, <-0.908, -0.235, -0.347>, <-1.4809, 3.9518, 25.4205>, <-0.447, 0.402, -0.799> }
	smooth_triangle { <-3.5341, 6.7034, 28.2230>, <-0.848, -0.342, -0.406>, <-1.4809, 3.9518, 25.4205>, <-0.551, 0.295, -0.780>, <-3.5237, 6.7246, 28.2136>, <-0.485, 0.347, -0.803> }
	smooth_triangle { <-3.5237, 6.7246, 28.2136>, <-0.133, 0.618, -0.775>, <-1.4809, 3.9518, 25.4205>, <-0.361, 0.462, -0.810>, <-1.4581, 3.9555, 25.4312>, <0.460, 0.719, -0.521> }
	smooth_triangle { <-3.5237, 6.7246, 28.2136>, <-0.381, 0.446, -0.810>, <-1.4581, 3.9555, 25.4312>, <0.332, 0.728, -0.599>, <-3.5017, 6.7332, 28.2230>, <0.463, 0.788, -0.407> }
	smooth_triangle { <-3.5017, 6.7332, 28.2230>, <0.551, 0.772, -0.316>, <-1.4581, 3.9555, 25.4312>, <0.460, 0.719, -0.521>, <-1.4520, 3.9433, 25.4526>, <0.855, 0.519, 0.003> }
	smooth_triangle { <-3.5017, 6.7332, 28.2230>, <0.463, 0.788, -0.407>, <-1.4520, 3.9433, 25.4526>, <0.855, 0.519, 0.003>, <-3.4901, 6.7207, 28.2418>, <0.728, 0.685, -0.008> }
	smooth_triangle { <-4.9394, 8.1181, 29.6225>, <0.753, 0.226, 0.617>, <-3.4901, 6.7207, 28.2418>, <0.708, -0.108, 0.698>, <-3.5005, 6.6995, 28.2512>, <0.381, -0.446, 0.810> }
	smooth_triangle { <-4.9394, 8.1181, 29.6225>, <0.753, 0.226, 0.617>, <-3.5005, 6.6995, 28.2512>, <0.485, -0.348, 0.802>, <-4.9495, 8.0973, 29.6329>, <0.289, -0.447, 0.846> }
	smooth_triangle { <-4.9495, 8.0973, 29.6329>, <0.289, -0.447, 0.846>, <-3.5005, 6.6995, 28.2512>, <0.381, -0.446, 0.810>, <-3.5225, 6.6909, 28.2418>, <-0.463, -0.788, 0.406> }
	smooth_triangle { <-4.9495, 8.0973, 29.6329>, <0.289, -0.447, 0.846>, <-3.5225, 6.6909, 28.2418>, <-0.349, -0.797, 0.492>, <-4.9699, 8.0865, 29.6225>, <-0.498, -0.799, 0.337> }
	smooth_triangle { <-4.9699, 8.0865, 29.6225>, <-0.498, -0.799, 0.337>, <-3.5225, 6.6909, 28.2418>, <-0.463, -0.788, 0.406>, <-3.5341, 6.7034, 28.2230>, <-0.848, -0.342, -0.406> }
	smooth_triangle { <-4.9699, 8.0865, 29.6225>, <-0.498, -0.799, 0.337>, <-3.5341, 6.7034, 28.2230>, <-0.837, -0.451, -0.311>, <-4.9803, 8.0964, 29.6015>, <-0.789, -0.349, -0.507> }
	smooth_triangle { <-4.9803, 8.0964, 29.6015>, <-0.789, -0.349, -0.507>, <-3.5341, 6.7034, 28.2230>, <-0.848, -0.342, -0.406>, <-3.5237, 6.7246, 28.2136>, <-0.381, 0.446, -0.810> }
	smooth_triangle { <-4.9803, 8.0964, 29.6015>, <-0.789, -0.349, -0.507>, <-3.5237, 6.7246, 28.2136>, <-0.485, 0.347, -0.803>, <-4.9702, 8.1173, 29.5911>, <-0.294, 0.452, -0.842> }
	smooth_triangle { <-4.9702, 8.1173, 29.5911>, <-0.294, 0.452, -0.842>, <-3.5237, 6.7246, 28.2136>, <-0.381, 0.446, -0.810>, <-3.5017, 6.7332, 28.2230>, <0.463, 0.788, -0.407> }
	smooth_triangle { <-4.9702, 8.1173, 29.5911>, <-0.294, 0.452, -0.842>, <-3.5017, 6.7332, 28.2230>, <0.350, 0.797, -0.492>, <-4.9497, 8.1281, 29.6015>, <0.493, 0.804, -0.333> }
	smooth_triangle { <-4.9497, 8.1281, 29.6015>, <0.493, 0.804, -0.333>, <-3.5017, 6.7332, 28.2230>, <0.463, 0.788, -0.407>, <-3.4901, 6.7207, 28.2418>, <0.728, 0.685, -0.008> }
	smooth_triangle { <-4.9497, 8.1281, 29.6015>, <0.493, 0.804, -0.333>, <-3.4901, 6.7207, 28.2418>, <0.728, 0.685, -0.008>, <-4.9394, 8.1181, 29.6225>, <0.694, 0.720, 0.000> }
	smooth_triangle { <-6.5065, 9.6136, 30.7453>, <0.629, 0.087, 0.772>, <-4.9394, 8.1181, 29.6225>, <0.753, 0.226, 0.617>, <-4.9495, 8.0973, 29.6329>, <0.289, -0.447, 0.846> }
	smooth_triangle { <-6.5065, 9.6136, 30.7453>, <-0.066, -0.629, 0.775>, <-4.9495, 8.0973, 29.6329>, <0.289, -0.447, 0.846>, <-4.9699, 8.0865, 29.6225>, <-0.498, -0.799, 0.337> }
	smooth_triangle { <-6.5065, 9.6136, 30.7453>, <-0.705, -0.709, 0.009>, <-4.9699, 8.0865, 29.6225>, <-0.498, -0.799, 0.337>, <-4.9803, 8.0964, 29.6015>, <-0.789, -0.349, -0.507> }
	smooth_triangle { <-6.5065, 9.6136, 30.7453>, <-0.647, -0.071, -0.759>, <-4.9803, 8.0964, 29.6015>, <-0.789, -0.349, -0.507>, <-4.9702, 8.1173, 29.5911>, <-0.294, 0.452, -0.842> }
	smooth_triangle { <-6.5065, 9.6136, 30.7453>, <0.050, 0.646, -0.762>, <-4.9702, 8.1173, 29.5911>, <-0.294, 0.452, -0.842>, <-4.9497, 8.1281, 29.6015>, <0.493, 0.804, -0.333> }
	smooth_triangle { <-6.5065, 9.6136, 30.7453>, <0.688, 0.725, 0.005>, <-4.9497, 8.1281, 29.6015>, <0.493, 0.804, -0.333>, <-4.9394, 8.1181, 29.6225>, <0.753, 0.226, 0.617> }

	texture { PSWL_BARK }
}

/* Object 'PWL0012F' */
union {
	smooth_triangle { <-0.6956, 3.9093, 24.2511>, <-0.588, -0.708, -0.392>, <-0.8066, 4.2084, 23.9118>, <-0.548, -0.708, -0.445>, <-1.1977, 4.5393, 23.8666>, <-0.588, -0.708, -0.392> }
	smooth_triangle { <-1.1977, 4.5393, 23.8666>, <-0.588, -0.708, -0.392>, <-1.0463, 4.2285, 24.2346>, <-0.625, -0.704, -0.337>, <-0.6956, 3.9093, 24.2511>, <-0.588, -0.708, -0.392> }
	smooth_triangle { <-1.4822, 3.8868, 25.4399>, <0.799, -0.135, 0.587>, <-1.3949, 3.2134, 25.1690>, <0.795, -0.135, 0.591>, <-1.6697, 2.5513, 25.3875>, <0.799, -0.135, 0.587> }
	smooth_triangle { <-1.6697, 2.5513, 25.3875>, <0.799, -0.135, 0.587>, <-1.7513, 3.2433, 25.6612>, <0.802, -0.135, 0.582>, <-1.4822, 3.8868, 25.4399>, <0.799, -0.135, 0.587> }
	smooth_triangle { <-2.1004, 3.9430, 26.7205>, <-0.890, -0.177, -0.420>, <-2.0843, 4.4260, 26.5015>, <-0.874, -0.176, -0.452>, <-2.2710, 4.9067, 26.6753>, <-0.890, -0.177, -0.420> }
	smooth_triangle { <-2.2710, 4.9067, 26.6753>, <-0.890, -0.177, -0.420>, <-2.2702, 4.4112, 26.9019>, <-0.905, -0.178, -0.387>, <-2.1004, 3.9430, 26.7205>, <-0.890, -0.177, -0.420> }
	smooth_triangle { <-2.7331, 3.7969, 27.9899>, <0.735, -0.550, 0.396>, <-2.8552, 3.4325, 27.6911>, <0.752, -0.550, 0.364>, <-3.1693, 3.0427, 27.7511>, <0.735, -0.550, 0.396> }
	smooth_triangle { <-3.1693, 3.0427, 27.7511>, <0.735, -0.550, 0.396>, <-3.0581, 3.4164, 28.0450>, <0.717, -0.550, 0.428>, <-2.7331, 3.7969, 27.9899>, <0.735, -0.550, 0.396> }
	smooth_triangle { <-3.3123, 3.9021, 29.0621>, <-0.644, -0.670, -0.371>, <-3.5924, 4.3794, 28.5678>, <-0.710, -0.663, -0.238>, <-4.0802, 4.8777, 28.6333>, <-0.644, -0.670, -0.371> }
	smooth_triangle { <-4.0802, 4.8777, 28.6333>, <-0.644, -0.670, -0.371>, <-3.8974, 4.3906, 29.0759>, <-0.564, -0.661, -0.495>, <-3.3123, 3.9021, 29.0621>, <-0.644, -0.670, -0.371> }
	smooth_triangle { <-3.8868, 3.8440, 30.1388>, <0.646, -0.671, 0.364>, <-4.1353, 3.3996, 29.7069>, <0.678, -0.671, 0.300>, <-4.6081, 2.9504, 29.7715>, <0.646, -0.671, 0.364> }
	smooth_triangle { <-4.6081, 2.9504, 29.7715>, <0.646, -0.671, 0.364>, <-4.3949, 3.4091, 30.1843>, <0.610, -0.668, 0.427>, <-3.8868, 3.8440, 30.1388>, <0.646, -0.671, 0.364> }
	smooth_triangle { <-4.0977, 4.3383, 30.7857>, <-0.917, 0.011, -0.398>, <-3.9351, 4.6204, 30.4160>, <-0.919, 0.014, -0.393>, <-3.9056, 5.1320, 30.3651>, <-0.917, 0.011, -0.398> }
	smooth_triangle { <-3.9056, 5.1320, 30.3651>, <-0.917, 0.011, -0.398>, <-4.0725, 4.8414, 30.7385>, <-0.915, 0.008, -0.403>, <-4.0977, 4.3383, 30.7857>, <-0.917, 0.011, -0.398> }
	smooth_triangle { <-4.4085, 4.6734, 31.4646>, <0.409, -0.693, 0.593>, <-4.9148, 4.1466, 31.1954>, <0.410, -0.696, 0.590>, <-5.6398, 3.9336, 31.4488>, <0.409, -0.693, 0.593> }
	smooth_triangle { <-5.6398, 3.9336, 31.4488>, <0.409, -0.693, 0.593>, <-5.1176, 4.4730, 31.7164>, <0.407, -0.691, 0.597>, <-4.4085, 4.6734, 31.4646>, <0.409, -0.693, 0.593> }
	smooth_triangle { <-4.6638, 5.0794, 32.1130>, <-0.880, 0.242, -0.407>, <-4.3915, 5.3962, 31.7534>, <-0.859, 0.205, -0.470>, <-4.2770, 5.8882, 31.7584>, <-0.880, 0.242, -0.407> }
	smooth_triangle { <-4.2770, 5.8882, 31.7584>, <-0.880, 0.242, -0.407>, <-4.5367, 5.5310, 32.1479>, <-0.897, 0.279, -0.342>, <-4.6638, 5.0794, 32.1130>, <-0.880, 0.242, -0.407> }
	smooth_triangle { <-5.0558, 5.3461, 32.7951>, <0.299, -0.770, 0.563>, <-5.4013, 5.0464, 32.5758>, <0.293, -0.761, 0.578>, <-5.9435, 4.9366, 32.7064>, <0.299, -0.770, 0.563> }
	smooth_triangle { <-5.9435, 4.9366, 32.7064>, <0.299, -0.770, 0.563>, <-5.5821, 5.2366, 32.9317>, <0.304, -0.779, 0.549>, <-5.0558, 5.3461, 32.7951>, <0.299, -0.770, 0.563> }
	smooth_triangle { <-2.4590, 4.0598, 28.7483>, <0.396, 0.837, -0.378>, <-1.9531, 3.6616, 28.4136>, <0.391, 0.830, -0.397>, <-1.2733, 3.4444, 28.6293>, <0.396, 0.837, -0.378> }
	smooth_triangle { <-1.2733, 3.4444, 28.6293>, <0.396, 0.837, -0.378>, <-1.8031, 3.8426, 28.9705>, <0.401, 0.842, -0.360>, <-2.4590, 4.0598, 28.7483>, <0.396, 0.837, -0.378> }
	smooth_triangle { <-2.3286, 4.3741, 29.4933>, <-0.820, -0.325, 0.470>, <-2.6437, 4.7479, 29.1927>, <-0.827, -0.331, 0.455>, <-2.8082, 5.3249, 29.3139>, <-0.820, -0.325, 0.470> }
	smooth_triangle { <-2.8082, 5.3249, 29.3139>, <-0.820, -0.325, 0.470>, <-2.4805, 4.9448, 29.6132>, <-0.814, -0.319, 0.486>, <-2.3286, 4.3741, 29.4933>, <-0.820, -0.325, 0.470> }
	smooth_triangle { <-2.4186, 4.9404, 30.5511>, <-0.431, 0.764, -0.479>, <-1.9762, 5.0552, 30.3073>, <-0.439, 0.793, -0.422>, <-1.5707, 5.3549, 30.4490>, <-0.431, 0.764, -0.479> }
	smooth_triangle { <-1.5707, 5.3549, 30.4490>, <-0.431, 0.764, -0.479>, <-2.0316, 5.2578, 30.6801>, <-0.422, 0.732, -0.535>, <-2.4186, 4.9404, 30.5511>, <-0.431, 0.764, -0.479> }
	smooth_triangle { <-2.6731, 5.5278, 31.5930>, <-0.518, -0.714, 0.471>, <-3.0384, 5.5795, 31.2597>, <-0.516, -0.727, 0.453>, <-3.4868, 5.8988, 31.2609>, <-0.518, -0.714, 0.471> }
	smooth_triangle { <-3.4868, 5.8988, 31.2609>, <-0.518, -0.714, 0.471>, <-3.1131, 5.8529, 31.5923>, <-0.519, -0.702, 0.488>, <-2.6731, 5.5278, 31.5930>, <-0.518, -0.714, 0.471> }
	smooth_triangle { <-2.3325, 6.6173, 32.0233>, <-0.103, 0.306, -0.947>, <-1.8259, 6.2815, 31.8622>, <-0.104, 0.298, -0.949>, <-1.1956, 6.4383, 31.8422>, <-0.103, 0.306, -0.947> }
	smooth_triangle { <-1.1956, 6.4383, 31.8422>, <-0.103, 0.306, -0.947>, <-1.7186, 6.7751, 32.0100>, <-0.101, 0.313, -0.944>, <-2.3325, 6.6173, 32.0233>, <-0.103, 0.306, -0.947> }
	smooth_triangle { <-2.1817, 7.7636, 32.4226>, <-0.609, -0.073, 0.790>, <-2.7764, 7.7298, 31.9205>, <-0.631, -0.165, 0.758>, <-3.2586, 8.2912, 31.6411>, <-0.609, -0.073, 0.790> }
	smooth_triangle { <-3.2586, 8.2912, 31.6411>, <-0.609, -0.073, 0.790>, <-2.6429, 8.3444, 32.0793>, <-0.581, 0.020, 0.814>, <-2.1817, 7.7636, 32.4226>, <-0.609, -0.073, 0.790> }
	smooth_triangle { <-1.5431, 8.5174, 32.7322>, <-0.425, 0.688, -0.588>, <-1.3173, 8.2643, 32.2248>, <-0.350, 0.767, -0.538>, <-0.8578, 8.3206, 32.0062>, <-0.425, 0.688, -0.588> }
	smooth_triangle { <-0.8578, 8.3206, 32.0062>, <-0.425, 0.688, -0.588>, <-1.0778, 8.5980, 32.4436>, <-0.494, 0.600, -0.629>, <-1.5431, 8.5174, 32.7322>, <-0.425, 0.688, -0.588> }
	smooth_triangle { <-1.0555, 9.3451, 33.0751>, <-0.356, -0.033, 0.934>, <-1.5062, 9.4641, 32.9187>, <-0.326, 0.007, 0.945>, <-1.7277, 9.9237, 32.8388>, <-0.356, -0.033, 0.934> }
	smooth_triangle { <-1.7277, 9.9237, 32.8388>, <-0.356, -0.033, 0.934>, <-1.2716, 9.7910, 33.0195>, <-0.386, -0.072, 0.920>, <-1.0555, 9.3451, 33.0751>, <-0.356, -0.033, 0.934> }
	smooth_triangle { <-0.1804, 9.8672, 33.3332>, <0.138, 0.218, -0.966>, <0.1191, 9.3151, 33.2536>, <0.134, 0.212, -0.968>, <0.9011, 9.0985, 33.3144>, <0.138, 0.218, -0.966> }
	smooth_triangle { <0.9011, 9.0985, 33.3144>, <0.138, 0.218, -0.966>, <0.5857, 9.6604, 33.3979>, <0.142, 0.223, -0.965>, <-0.1804, 9.8672, 33.3332>, <0.138, 0.218, -0.966> }
	smooth_triangle { <0.5269, 10.5172, 33.5727>, <-0.241, -0.118, 0.963>, <-0.1956, 10.7405, 33.4157>, <-0.248, -0.129, 0.960>, <-0.4827, 11.3051, 33.4171>, <-0.241, -0.118, 0.963> }
	smooth_triangle { <-0.4827, 11.3051, 33.4171>, <-0.241, -0.118, 0.963>, <0.2554, 11.0727, 33.5691>, <-0.233, -0.107, 0.967>, <0.5269, 10.5172, 33.5727>, <-0.241, -0.118, 0.963> }
	smooth_triangle { <-2.4872, 3.6142, 28.7546>, <0.812, -0.409, -0.416>, <-2.7961, 3.2354, 28.5210>, <0.814, -0.411, -0.410>, <-2.9606, 2.7331, 28.6978>, <0.812, -0.409, -0.416> }
	smooth_triangle { <-2.9606, 2.7331, 28.6978>, <0.812, -0.409, -0.416>, <-2.6428, 3.1227, 28.9311>, <0.810, -0.408, -0.422>, <-2.4872, 3.6142, 28.7546>, <0.812, -0.409, -0.416> }
	smooth_triangle { <-2.1663, 3.4913, 29.4973>, <-0.108, 0.942, 0.319>, <-1.8529, 3.6505, 29.2180>, <-0.067, 0.897, 0.436>, <-1.3289, 3.6659, 29.2664>, <-0.108, 0.942, 0.319> }
	smooth_triangle { <-1.3289, 3.6659, 29.2664>, <-0.108, 0.942, 0.319>, <-1.7095, 3.5451, 29.5768>, <-0.148, 0.969, 0.196>, <-2.1663, 3.4913, 29.4973>, <-0.108, 0.942, 0.319> }
	smooth_triangle { <-2.1152, 3.4650, 30.7272>, <0.682, 0.729, -0.058>, <-1.7142, 3.1008, 30.4669>, <0.685, 0.728, 0.036>, <-1.3211, 2.7198, 30.6990>, <0.682, 0.729, -0.058> }
	smooth_triangle { <-1.3211, 2.7198, 30.6990>, <0.682, 0.729, -0.058>, <-1.6835, 3.1109, 30.9569>, <0.674, 0.724, -0.151>, <-2.1152, 3.4650, 30.7272>, <0.682, 0.729, -0.058> }
	smooth_triangle { <-2.0690, 3.5704, 31.9440>, <-0.905, 0.424, 0.046>, <-1.7662, 4.1425, 31.6366>, <-0.902, 0.416, -0.114>, <-1.5407, 4.7027, 31.8977>, <-0.905, 0.424, 0.046> }
	smooth_triangle { <-1.5407, 4.7027, 31.8977>, <-0.905, 0.424, 0.046>, <-1.7320, 4.1538, 32.1990>, <-0.884, 0.421, 0.205>, <-2.0690, 3.5704, 31.9440>, <-0.905, 0.424, 0.046> }
	smooth_triangle { <-2.4151, 3.7152, 32.8911>, <-0.980, -0.063, -0.190>, <-2.4020, 4.2026, 32.5767>, <-0.991, -0.053, -0.123>, <-2.4492, 4.7305, 32.7300>, <-0.980, -0.063, -0.190> }
	smooth_triangle { <-2.4492, 4.7305, 32.7300>, <-0.980, -0.063, -0.190>, <-2.4928, 4.2423, 33.0343>, <-0.964, -0.073, -0.255>, <-2.4151, 3.7152, 32.8911>, <-0.980, -0.063, -0.190> }
	smooth_triangle { <-2.7766, 3.7708, 33.8436>, <0.564, -0.794, 0.227>, <-3.1747, 3.4092, 33.4858>, <0.582, -0.798, 0.159>, <-3.6740, 3.0765, 33.6430>, <0.564, -0.794, 0.227> }
	smooth_triangle { <-3.6740, 3.0765, 33.6430>, <0.564, -0.794, 0.227>, <-3.2998, 3.4638, 33.9889>, <0.543, -0.787, 0.293>, <-2.7766, 3.7708, 33.8436>, <0.564, -0.794, 0.227> }
	smooth_triangle { <-3.2569, 4.1816, 34.6399>, <-0.908, -0.318, -0.274>, <-3.2818, 4.5964, 34.1557>, <-0.940, -0.282, -0.193>, <-3.4330, 5.1043, 34.1510>, <-0.908, -0.318, -0.274> }
	smooth_triangle { <-3.4330, 5.1043, 34.1510>, <-0.908, -0.318, -0.274>, <-3.4540, 4.7079, 34.5987>, <-0.867, -0.352, -0.353>, <-3.2569, 4.1816, 34.6399>, <-0.908, -0.318, -0.274> }
	smooth_triangle { <-3.7984, 4.4303, 35.4677>, <0.488, -0.630, 0.604>, <-4.0032, 4.0278, 35.2366>, <0.453, -0.606, 0.654>, <-4.4605, 3.7736, 35.3180>, <0.488, -0.630, 0.604> }
	smooth_triangle { <-4.4605, 3.7736, 35.3180>, <0.488, -0.630, 0.604>, <-4.2271, 4.1728, 35.5686>, <0.521, -0.651, 0.552>, <-3.7984, 4.4303, 35.4677>, <0.488, -0.630, 0.604> }
	smooth_triangle { <-3.4490, 4.7569, 36.4003>, <-0.086, 0.946, -0.313>, <-3.1033, 4.6744, 36.1143>, <-0.108, 0.913, -0.394>, <-2.5981, 4.7561, 36.1642>, <-0.086, 0.946, -0.313> }
	smooth_triangle { <-2.5981, 4.7561, 36.1642>, <-0.086, 0.946, -0.313>, <-2.9868, 4.8040, 36.4728>, <-0.063, 0.971, -0.230>, <-3.4490, 4.7569, 36.4003>, <-0.086, 0.946, -0.313> }
	smooth_triangle { <-3.2771, 5.0846, 37.3515>, <-0.668, -0.639, 0.382>, <-3.8008, 5.4557, 37.0661>, <-0.665, -0.635, 0.393>, <-4.1832, 6.0111, 37.3172>, <-0.668, -0.639, 0.382> }
	smooth_triangle { <-4.1832, 6.0111, 37.3172>, <-0.668, -0.639, 0.382>, <-3.6511, 5.6221, 37.6058>, <-0.671, -0.642, 0.371>, <-3.2771, 5.0846, 37.3515>, <-0.668, -0.639, 0.382> }
	smooth_triangle { <-2.9363, 5.6707, 37.7792>, <-0.705, 0.502, -0.500>, <-2.6318, 5.5663, 37.2437>, <-0.705, 0.504, -0.499>, <-2.0934, 5.9731, 36.8940>, <-0.705, 0.502, -0.500> }
	smooth_triangle { <-2.0934, 5.9731, 36.8940>, <-0.705, 0.502, -0.500>, <-2.4092, 6.0745, 37.4399>, <-0.706, 0.500, -0.501>, <-2.9363, 5.6707, 37.7792>, <-0.705, 0.502, -0.500> }
	smooth_triangle { <-2.7328, 6.3037, 38.2517>, <-0.762, -0.095, 0.641>, <-3.1806, 6.4756, 37.7726>, <-0.738, -0.049, 0.673>, <-3.4275, 7.1404, 37.5500>, <-0.762, -0.095, 0.641> }
	smooth_triangle { <-3.4275, 7.1404, 37.5500>, <-0.762, -0.095, 0.641>, <-2.9807, 6.9319, 38.0779>, <-0.782, -0.141, 0.607>, <-2.7328, 6.3037, 38.2517>, <-0.762, -0.095, 0.641> }
	smooth_triangle { <-2.7427, 6.9866, 38.6364>, <-0.654, 0.360, -0.665>, <-2.2662, 6.8989, 38.0624>, <-0.625, 0.504, -0.596>, <-1.8703, 7.1769, 37.8820>, <-0.654, 0.360, -0.665> }
	smooth_triangle { <-1.8703, 7.1769, 37.8820>, <-0.654, 0.360, -0.665>, <-2.3269, 7.3354, 38.3512>, <-0.665, 0.207, -0.717>, <-2.7427, 6.9866, 38.6364>, <-0.654, 0.360, -0.665> }
	smooth_triangle { <-2.8927, 7.7204, 39.0349>, <-0.801, -0.455, 0.389>, <-3.1889, 7.8636, 38.6244>, <-0.799, -0.422, 0.429>, <-3.5554, 8.4225, 38.4921>, <-0.801, -0.455, 0.389> }
	smooth_triangle { <-3.5554, 8.4225, 38.4921>, <-0.801, -0.455, 0.389>, <-3.2576, 8.2517, 38.9381>, <-0.801, -0.487, 0.348>, <-2.8927, 7.7204, 39.0349>, <-0.801, -0.455, 0.389> }
	smooth_triangle { <-1.8376, 3.4199, 25.9537>, <0.312, -0.716, -0.624>, <-2.2866, 3.6239, 25.4471>, <0.272, -0.785, -0.557>, <-2.9702, 3.4676, 25.3337>, <0.312, -0.716, -0.624> }
	smooth_triangle { <-2.9702, 3.4676, 25.3337>, <0.312, -0.716, -0.624>, <-2.5325, 3.2180, 25.7894>, <0.348, -0.640, -0.685>, <-1.8376, 3.4199, 25.9537>, <0.312, -0.716, -0.624> }
	smooth_triangle { <-2.0643, 2.8647, 26.5108>, <0.453, 0.471, 0.757>, <-1.4020, 2.6573, 26.2281>, <0.468, 0.494, 0.733>, <-0.9631, 2.0440, 26.3619>, <0.453, 0.471, 0.757> }
	smooth_triangle { <-0.9631, 2.0440, 26.3619>, <0.453, 0.471, 0.757>, <-1.6488, 2.2499, 26.6294>, <0.438, 0.447, 0.780>, <-2.0643, 2.8647, 26.5108>, <0.453, 0.471, 0.757> }
	smooth_triangle { <-2.7677, 2.0829, 27.4797>, <-0.173, -0.706, -0.687>, <-3.2408, 2.5457, 27.1232>, <-0.173, -0.706, -0.687>, <-3.9953, 2.6569, 27.1987>, <-0.173, -0.706, -0.687> }
	smooth_triangle { <-3.9953, 2.6569, 27.1987>, <-0.173, -0.706, -0.687>, <-3.5050, 2.1858, 27.5590>, <-0.172, -0.705, -0.688>, <-2.7677, 2.0829, 27.4797>, <-0.173, -0.706, -0.687> }
	smooth_triangle { <-3.3207, 1.1821, 28.4358>, <0.856, -0.077, 0.512>, <-3.0562, 0.8490, 27.9123>, <0.880, -0.043, 0.472>, <-3.0161, 0.1906, 27.7770>, <0.856, -0.077, 0.512> }
	smooth_triangle { <-3.0161, 0.1906, 27.7770>, <0.856, -0.077, 0.512>, <-3.3040, 0.5115, 28.2754>, <0.828, -0.111, 0.550>, <-3.3207, 1.1821, 28.4358>, <0.856, -0.077, 0.512> }
	smooth_triangle { <-3.8107, 1.4889, 29.5564>, <-0.869, 0.125, -0.479>, <-3.6310, 1.9032, 29.3204>, <-0.887, 0.133, -0.442>, <-3.6259, 2.4074, 29.4613>, <-0.869, 0.125, -0.479> }
	smooth_triangle { <-3.6259, 2.4074, 29.4613>, <-0.869, 0.125, -0.479>, <-3.8230, 1.9866, 29.6907>, <-0.850, 0.118, -0.514>, <-3.8107, 1.4889, 29.5564>, <-0.869, 0.125, -0.479> }
	smooth_triangle { <-4.3379, 1.6043, 30.6546>, <0.714, -0.523, 0.466>, <-4.5187, 1.1100, 30.3976>, <0.696, -0.515, 0.501>, <-4.9382, 0.7031, 30.5619>, <0.714, -0.523, 0.466> }
	smooth_triangle { <-4.9382, 0.7031, 30.5619>, <0.714, -0.523, 0.466>, <-4.7322, 1.2027, 30.8291>, <0.731, -0.531, 0.429>, <-4.3379, 1.6043, 30.6546>, <0.714, -0.523, 0.466> }
	smooth_triangle { <-4.9198, 1.2926, 31.6535>, <-0.033, -0.860, -0.510>, <-5.3186, 1.5815, 31.1791>, <-0.043, -0.869, -0.493>, <-6.0850, 1.6450, 31.1343>, <-0.033, -0.860, -0.510> }
	smooth_triangle { <-6.0850, 1.6450, 31.1343>, <-0.033, -0.860, -0.510>, <-5.6832, 1.3423, 31.6055>, <-0.022, -0.850, -0.527>, <-4.9198, 1.2926, 31.6535>, <-0.033, -0.860, -0.510> }
	smooth_triangle { <-5.4108, 0.8620, 32.6877>, <0.738, 0.397, 0.545>, <-5.0123, 0.4533, 32.4518>, <0.732, 0.394, 0.556>, <-4.8450, -0.1263, 32.6419>, <0.738, 0.397, 0.545> }
	smooth_triangle { <-4.8450, -0.1263, 32.6419>, <0.738, 0.397, 0.545>, <-5.2469, 0.2994, 32.8821>, <0.744, 0.401, 0.534>, <-5.4108, 0.8620, 32.6877>, <0.738, 0.397, 0.545> }
	smooth_triangle { <-5.3655, 0.4857, 33.8010>, <-0.162, -0.937, -0.310>, <-5.8977, 0.7101, 33.3359>, <-0.204, -0.952, -0.227>, <-6.3397, 0.7958, 33.3726>, <-0.162, -0.937, -0.310> }
	smooth_triangle { <-6.3397, 0.7958, 33.3726>, <-0.162, -0.937, -0.310>, <-5.8327, 0.5415, 33.8127>, <-0.119, -0.913, -0.391>, <-5.3655, 0.4857, 33.8010>, <-0.162, -0.937, -0.310> }
	smooth_triangle { <-5.1809, -0.0160, 34.9461>, <0.931, 0.364, -0.018>, <-5.0336, -0.4178, 34.6442>, <0.930, 0.366, -0.033>, <-4.8054, -0.9833, 34.8022>, <0.931, 0.364, -0.018> }
	smooth_triangle { <-4.8054, -0.9833, 34.8022>, <0.931, 0.364, -0.018>, <-4.9643, -0.5720, 35.1010>, <0.932, 0.362, -0.003>, <-5.1809, -0.0160, 34.9461>, <0.931, 0.364, -0.018> }
	smooth_triangle { <-1.7370, 4.5810, 25.8700>, <-0.434, 0.400, -0.807>, <-1.1271, 4.7031, 25.6044>, <-0.432, 0.396, -0.810>, <-0.7107, 5.2509, 25.6499>, <-0.434, 0.400, -0.807> }
	smooth_triangle { <-0.7107, 5.2509, 25.6499>, <-0.434, 0.400, -0.807>, <-1.3343, 5.1178, 25.9212>, <-0.436, 0.404, -0.804>, <-1.7370, 4.5810, 25.8700>, <-0.434, 0.400, -0.807> }
	smooth_triangle { <-2.1258, 5.1716, 26.2808>, <-0.628, -0.516, 0.582>, <-2.4118, 5.0300, 25.8241>, <-0.612, -0.561, 0.557>, <-2.9148, 5.3023, 25.5455>, <-0.628, -0.516, 0.582> }
	smooth_triangle { <-2.9148, 5.3023, 25.5455>, <-0.628, -0.516, 0.582>, <-2.6285, 5.4637, 25.9746>, <-0.642, -0.470, 0.605>, <-2.1258, 5.1716, 26.2808>, <-0.628, -0.516, 0.582> }
	smooth_triangle { <-2.7991, 5.9803, 27.2414>, <-0.924, -0.231, -0.304>, <-2.6778, 6.3337, 26.6305>, <-0.913, -0.248, -0.324>, <-2.7870, 6.9510, 26.4665>, <-0.924, -0.231, -0.304> }
	smooth_triangle { <-2.7870, 6.9510, 26.4665>, <-0.924, -0.231, -0.304>, <-2.8947, 6.5691, 27.1104>, <-0.934, -0.215, -0.284>, <-2.7991, 5.9803, 27.2414>, <-0.924, -0.231, -0.304> }
	smooth_triangle { <-3.5580, 6.6998, 28.2082>, <-0.119, -0.777, 0.619>, <-3.8387, 6.4425, 27.8794>, <-0.184, -0.692, 0.698>, <-4.4008, 6.4746, 27.7631>, <-0.119, -0.777, 0.619> }
	smooth_triangle { <-4.4008, 6.4746, 27.7631>, <-0.119, -0.777, 0.619>, <-4.0738, 6.6977, 28.1539>, <-0.052, -0.848, 0.528>, <-3.5580, 6.6998, 28.2082>, <-0.119, -0.777, 0.619> }
	smooth_triangle { <-4.2083, 7.4529, 28.9076>, <-0.662, 0.177, -0.728>, <-3.7377, 7.7936, 28.5668>, <-0.656, 0.172, -0.735>, <-3.5698, 8.4489, 28.5702>, <-0.662, 0.177, -0.728> }
	smooth_triangle { <-3.5698, 8.4489, 28.5702>, <-0.662, 0.177, -0.728>, <-4.0471, 8.0918, 28.9206>, <-0.667, 0.183, -0.722>, <-4.2083, 7.4529, 28.9076>, <-0.662, 0.177, -0.728> }
	smooth_triangle { <-4.9994, 8.0721, 29.6060>, <0.305, -0.482, 0.821>, <-5.2266, 7.6386, 29.4229>, <0.334, -0.510, 0.793>, <-5.7139, 7.4371, 29.4984>, <0.305, -0.482, 0.821> }
	smooth_triangle { <-5.7139, 7.4371, 29.4984>, <0.305, -0.482, 0.821>, <-5.4853, 7.8879, 29.6655>, <0.276, -0.454, 0.847>, <-4.9994, 8.0721, 29.6060>, <0.305, -0.482, 0.821> }
	smooth_triangle { <-5.7281, 8.9004, 30.1436>, <-0.742, -0.387, -0.547>, <-5.5100, 9.0897, 29.7978>, <-0.593, -0.488, -0.641>, <-5.6362, 9.6250, 29.5072>, <-0.742, -0.387, -0.547> }
	smooth_triangle { <-5.6362, 9.6250, 29.5072>, <-0.742, -0.387, -0.547>, <-5.7948, 9.3669, 29.9850>, <-0.861, -0.270, -0.431>, <-5.7281, 8.9004, 30.1436>, <-0.742, -0.387, -0.547> }
	smooth_triangle { <-6.5494, 9.5929, 30.7213>, <-0.012, -0.745, 0.667>, <-6.8094, 9.3018, 30.3705>, <0.027, -0.779, 0.626>, <-7.3062, 9.2263, 30.2979>, <-0.012, -0.745, 0.667> }
	smooth_triangle { <-7.3062, 9.2263, 30.2979>, <-0.012, -0.745, 0.667>, <-7.0492, 9.5356, 30.6272>, <-0.052, -0.707, 0.705>, <-6.5494, 9.5929, 30.7213>, <-0.012, -0.745, 0.667> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0013B' */
union {
	smooth_triangle { <1.4211, 5.3133, 22.8321>, <0.341, -0.654, 0.675>, <1.0900, 4.0895, 21.8147>, <0.338, -0.663, 0.667>, <1.0594, 4.0869, 21.8276>, <0.006, -0.640, 0.768> }
	smooth_triangle { <1.4211, 5.3133, 22.8321>, <0.341, -0.654, 0.675>, <1.0594, 4.0869, 21.8276>, <0.006, -0.640, 0.768>, <1.3905, 5.3108, 22.8450>, <-0.343, -0.544, 0.766> }
	smooth_triangle { <1.3905, 5.3108, 22.8450>, <-0.343, -0.544, 0.766>, <1.0594, 4.0869, 21.8276>, <0.006, -0.640, 0.768>, <1.0343, 4.1045, 21.8147>, <-0.837, -0.163, 0.521> }
	smooth_triangle { <1.3905, 5.3108, 22.8450>, <-0.343, -0.544, 0.766>, <1.0343, 4.1045, 21.8147>, <-0.837, -0.163, 0.521>, <1.3654, 5.3284, 22.8321>, <-0.966, 0.049, 0.255> }
	smooth_triangle { <1.3654, 5.3284, 22.8321>, <-0.966, 0.049, 0.255>, <1.0343, 4.1045, 21.8147>, <-0.837, -0.163, 0.521>, <1.0398, 4.1246, 21.7887>, <-0.844, 0.477, -0.246> }
	smooth_triangle { <1.3654, 5.3284, 22.8321>, <-0.966, 0.049, 0.255>, <1.0398, 4.1246, 21.7887>, <-0.844, 0.477, -0.246>, <1.3709, 5.3485, 22.8061>, <-0.623, 0.593, -0.511> }
	smooth_triangle { <1.3709, 5.3485, 22.8061>, <-0.623, 0.593, -0.511>, <1.0398, 4.1246, 21.7887>, <-0.844, 0.477, -0.246>, <1.0703, 4.1271, 21.7757>, <-0.006, 0.641, -0.767> }
	smooth_triangle { <1.3709, 5.3485, 22.8061>, <-0.623, 0.593, -0.511>, <1.0703, 4.1271, 21.7757>, <-0.006, 0.641, -0.767>, <1.4014, 5.3510, 22.7931>, <0.343, 0.544, -0.766> }
	smooth_triangle { <1.4014, 5.3510, 22.7931>, <0.343, 0.544, -0.766>, <1.0703, 4.1271, 21.7757>, <-0.006, 0.641, -0.767>, <1.0954, 4.1096, 21.7887>, <0.838, 0.165, -0.520> }
	smooth_triangle { <1.4014, 5.3510, 22.7931>, <0.343, 0.544, -0.766>, <1.0954, 4.1096, 21.7887>, <0.838, 0.165, -0.520>, <1.4265, 5.3334, 22.8061>, <0.966, -0.049, -0.255> }
	smooth_triangle { <1.4265, 5.3334, 22.8061>, <0.966, -0.049, -0.255>, <1.0954, 4.1096, 21.7887>, <0.838, 0.165, -0.520>, <1.0900, 4.0895, 21.8147>, <0.954, -0.301, -0.005> }
	smooth_triangle { <1.4265, 5.3334, 22.8061>, <0.966, -0.049, -0.255>, <1.0900, 4.0895, 21.8147>, <0.954, -0.301, -0.005>, <1.4211, 5.3133, 22.8321>, <0.965, -0.261, 0.000> }
	smooth_triangle { <2.3105, 7.3866, 24.5602>, <0.266, -0.707, 0.655>, <1.0900, 4.0895, 21.8147>, <0.338, -0.663, 0.667>, <1.0594, 4.0869, 21.8276>, <0.006, -0.640, 0.768> }
	smooth_triangle { <2.3105, 7.3866, 24.5602>, <0.266, -0.707, 0.655>, <1.0594, 4.0869, 21.8276>, <0.006, -0.640, 0.768>, <2.2872, 7.3883, 24.5702>, <-0.251, -0.623, 0.741> }
	smooth_triangle { <2.2872, 7.3883, 24.5702>, <-0.251, -0.623, 0.741>, <1.0594, 4.0869, 21.8276>, <0.006, -0.640, 0.768>, <1.0343, 4.1045, 21.8147>, <-0.837, -0.163, 0.521> }
	smooth_triangle { <2.2872, 7.3883, 24.5702>, <-0.251, -0.623, 0.741>, <1.0343, 4.1045, 21.8147>, <-0.837, -0.163, 0.521>, <2.2701, 7.4041, 24.5602>, <-0.933, 0.000, 0.360> }
	smooth_triangle { <2.2701, 7.4041, 24.5602>, <-0.933, 0.000, 0.360>, <1.0343, 4.1045, 21.8147>, <-0.837, -0.163, 0.521>, <1.0398, 4.1246, 21.7887>, <-0.844, 0.477, -0.246> }
	smooth_triangle { <2.2701, 7.4041, 24.5602>, <-0.933, 0.000, 0.360>, <1.0398, 4.1246, 21.7887>, <-0.844, 0.477, -0.246>, <2.2763, 7.4183, 24.5400>, <-0.683, 0.624, -0.380> }
	smooth_triangle { <2.2763, 7.4183, 24.5400>, <-0.683, 0.624, -0.380>, <1.0398, 4.1246, 21.7887>, <-0.844, 0.477, -0.246>, <1.0703, 4.1271, 21.7757>, <-0.006, 0.641, -0.767> }
	smooth_triangle { <2.2763, 7.4183, 24.5400>, <-0.683, 0.624, -0.380>, <1.0703, 4.1271, 21.7757>, <-0.006, 0.641, -0.767>, <2.2995, 7.4166, 24.5299>, <0.252, 0.624, -0.740> }
	smooth_triangle { <2.2995, 7.4166, 24.5299>, <0.252, 0.624, -0.740>, <1.0703, 4.1271, 21.7757>, <-0.006, 0.641, -0.767>, <1.0954, 4.1096, 21.7887>, <0.838, 0.165, -0.520> }
	smooth_triangle { <2.2995, 7.4166, 24.5299>, <0.252, 0.624, -0.740>, <1.0954, 4.1096, 21.7887>, <0.838, 0.165, -0.520>, <2.3166, 7.4008, 24.5400>, <0.934, 0.001, -0.358> }
	smooth_triangle { <2.3166, 7.4008, 24.5400>, <0.934, 0.001, -0.358>, <1.0954, 4.1096, 21.7887>, <0.838, 0.165, -0.520>, <1.0900, 4.0895, 21.8147>, <0.954, -0.301, -0.005> }
	smooth_triangle { <2.3166, 7.4008, 24.5400>, <0.934, 0.001, -0.358>, <1.0900, 4.0895, 21.8147>, <0.954, -0.301, -0.005>, <2.3105, 7.3866, 24.5602>, <0.925, -0.379, 0.011> }
	smooth_triangle { <2.9545, 8.9438, 26.3203>, <0.207, -0.795, 0.570>, <2.3105, 7.3866, 24.5602>, <0.266, -0.707, 0.655>, <2.2872, 7.3883, 24.5702>, <-0.251, -0.623, 0.741> }
	smooth_triangle { <2.9545, 8.9438, 26.3203>, <0.207, -0.795, 0.570>, <2.2872, 7.3883, 24.5702>, <-0.251, -0.623, 0.741>, <2.9306, 8.9437, 26.3291>, <-0.322, -0.644, 0.694> }
	smooth_triangle { <2.9306, 8.9437, 26.3291>, <-0.322, -0.644, 0.694>, <2.2872, 7.3883, 24.5702>, <-0.251, -0.623, 0.741>, <2.2701, 7.4041, 24.5602>, <-0.933, 0.000, 0.360> }
	smooth_triangle { <2.9306, 8.9437, 26.3291>, <-0.322, -0.644, 0.694>, <2.2701, 7.4041, 24.5602>, <-0.933, 0.000, 0.360>, <2.9138, 8.9606, 26.3203>, <-0.902, 0.122, 0.414> }
	smooth_triangle { <2.9138, 8.9606, 26.3203>, <-0.902, 0.122, 0.414>, <2.2701, 7.4041, 24.5602>, <-0.933, 0.000, 0.360>, <2.2763, 7.4183, 24.5400>, <-0.683, 0.624, -0.380> }
	smooth_triangle { <2.9138, 8.9606, 26.3203>, <-0.902, 0.122, 0.414>, <2.2763, 7.4183, 24.5400>, <-0.683, 0.624, -0.380>, <2.9208, 8.9776, 26.3027>, <-0.577, 0.766, -0.284> }
	smooth_triangle { <2.9208, 8.9776, 26.3027>, <-0.577, 0.766, -0.284>, <2.2763, 7.4183, 24.5400>, <-0.683, 0.624, -0.380>, <2.2995, 7.4166, 24.5299>, <0.252, 0.624, -0.740> }
	smooth_triangle { <2.9208, 8.9776, 26.3027>, <-0.577, 0.766, -0.284>, <2.2995, 7.4166, 24.5299>, <0.252, 0.624, -0.740>, <2.9447, 8.9776, 26.2939>, <0.322, 0.643, -0.695> }
	smooth_triangle { <2.9447, 8.9776, 26.2939>, <0.322, 0.643, -0.695>, <2.2995, 7.4166, 24.5299>, <0.252, 0.624, -0.740>, <2.3166, 7.4008, 24.5400>, <0.934, 0.001, -0.358> }
	smooth_triangle { <2.9447, 8.9776, 26.2939>, <0.322, 0.643, -0.695>, <2.3166, 7.4008, 24.5400>, <0.934, 0.001, -0.358>, <2.9615, 8.9608, 26.3027>, <0.902, -0.122, -0.415> }
	smooth_triangle { <2.9615, 8.9608, 26.3027>, <0.902, -0.122, -0.415>, <2.3166, 7.4008, 24.5400>, <0.934, 0.001, -0.358>, <2.3105, 7.3866, 24.5602>, <0.925, -0.379, 0.011> }
	smooth_triangle { <2.9615, 8.9608, 26.3027>, <0.902, -0.122, -0.415>, <2.3105, 7.3866, 24.5602>, <0.925, -0.379, 0.011>, <2.9545, 8.9438, 26.3203>, <0.822, -0.564, -0.074> }
	smooth_triangle { <3.8236, 9.7825, 27.3991>, <0.249, -0.802, 0.543>, <2.9545, 8.9438, 26.3203>, <0.207, -0.795, 0.570>, <2.9306, 8.9437, 26.3291>, <-0.322, -0.644, 0.694> }
	smooth_triangle { <3.8236, 9.7825, 27.3991>, <0.249, -0.802, 0.543>, <2.9306, 8.9437, 26.3291>, <-0.322, -0.644, 0.694>, <3.8022, 9.7926, 27.4086>, <-0.455, -0.357, 0.816> }
	smooth_triangle { <3.8022, 9.7926, 27.4086>, <-0.455, -0.357, 0.816>, <2.9306, 8.9437, 26.3291>, <-0.322, -0.644, 0.694>, <2.9138, 8.9606, 26.3203>, <-0.902, 0.122, 0.414> }
	smooth_triangle { <3.8022, 9.7926, 27.4086>, <-0.455, -0.357, 0.816>, <2.9138, 8.9606, 26.3203>, <-0.902, 0.122, 0.414>, <3.7931, 9.8142, 27.3991>, <-0.805, 0.462, 0.373> }
	smooth_triangle { <3.7931, 9.8142, 27.3991>, <-0.805, 0.462, 0.373>, <2.9138, 8.9606, 26.3203>, <-0.902, 0.122, 0.414>, <2.9208, 8.9776, 26.3027>, <-0.577, 0.766, -0.284> }
	smooth_triangle { <3.7931, 9.8142, 27.3991>, <-0.805, 0.462, 0.373>, <2.9208, 8.9776, 26.3027>, <-0.577, 0.766, -0.284>, <3.8052, 9.8259, 27.3801>, <-0.354, 0.827, -0.437> }
	smooth_triangle { <3.8052, 9.8259, 27.3801>, <-0.354, 0.827, -0.437>, <2.9208, 8.9776, 26.3027>, <-0.577, 0.766, -0.284>, <2.9447, 8.9776, 26.2939>, <0.322, 0.643, -0.695> }
	smooth_triangle { <3.8052, 9.8259, 27.3801>, <-0.354, 0.827, -0.437>, <2.9447, 8.9776, 26.2939>, <0.322, 0.643, -0.695>, <3.8265, 9.8159, 27.3706>, <0.462, 0.364, -0.809> }
	smooth_triangle { <3.8265, 9.8159, 27.3706>, <0.462, 0.364, -0.809>, <2.9447, 8.9776, 26.2939>, <0.322, 0.643, -0.695>, <2.9615, 8.9608, 26.3027>, <0.902, -0.122, -0.415> }
	smooth_triangle { <3.8265, 9.8159, 27.3706>, <0.462, 0.364, -0.809>, <2.9615, 8.9608, 26.3027>, <0.902, -0.122, -0.415>, <3.8357, 9.7942, 27.3801>, <0.812, -0.455, -0.365> }
	smooth_triangle { <3.8357, 9.7942, 27.3801>, <0.812, -0.455, -0.365>, <2.9615, 8.9608, 26.3027>, <0.902, -0.122, -0.415>, <2.9545, 8.9438, 26.3203>, <0.822, -0.564, -0.074> }
	smooth_triangle { <3.8357, 9.7942, 27.3801>, <0.812, -0.455, -0.365>, <2.9545, 8.9438, 26.3203>, <0.822, -0.564, -0.074>, <3.8236, 9.7825, 27.3991>, <0.694, -0.720, 0.001> }
	smooth_triangle { <4.8472, 10.8347, 28.1067>, <0.084, -0.604, 0.792>, <3.8236, 9.7825, 27.3991>, <0.249, -0.802, 0.543>, <3.8022, 9.7926, 27.4086>, <-0.455, -0.357, 0.816> }
	smooth_triangle { <4.8472, 10.8347, 28.1067>, <-0.613, 0.100, 0.784>, <3.8022, 9.7926, 27.4086>, <-0.455, -0.357, 0.816>, <3.7931, 9.8142, 27.3991>, <-0.805, 0.462, 0.373> }
	smooth_triangle { <4.8472, 10.8347, 28.1067>, <-0.691, 0.723, 0.002>, <3.7931, 9.8142, 27.3991>, <-0.805, 0.462, 0.373>, <3.8052, 9.8259, 27.3801>, <-0.354, 0.827, -0.437> }
	smooth_triangle { <4.8472, 10.8347, 28.1067>, <-0.060, 0.630, -0.774>, <3.8052, 9.8259, 27.3801>, <-0.354, 0.827, -0.437>, <3.8265, 9.8159, 27.3706>, <0.462, 0.364, -0.809> }
	smooth_triangle { <4.8472, 10.8347, 28.1067>, <0.640, -0.077, -0.765>, <3.8265, 9.8159, 27.3706>, <0.462, 0.364, -0.809>, <3.8357, 9.7942, 27.3801>, <0.812, -0.455, -0.365> }
	smooth_triangle { <4.8472, 10.8347, 28.1067>, <0.715, -0.699, 0.021>, <3.8357, 9.7942, 27.3801>, <0.812, -0.455, -0.365>, <3.8236, 9.7825, 27.3991>, <0.249, -0.802, 0.543> }
	smooth_triangle { <3.2235, 7.4804, 25.8813>, <-0.648, -0.573, 0.503>, <2.2855, 7.3795, 24.5574>, <-0.647, -0.573, 0.504>, <2.2728, 7.4002, 24.5648>, <-0.757, -0.216, 0.617> }
	smooth_triangle { <3.2235, 7.4804, 25.8813>, <-0.648, -0.573, 0.503>, <2.2728, 7.4002, 24.5648>, <-0.757, -0.216, 0.617>, <3.2109, 7.5012, 25.8886>, <-0.815, 0.102, 0.570> }
	smooth_triangle { <3.2109, 7.5012, 25.8886>, <-0.815, 0.102, 0.570>, <2.2728, 7.4002, 24.5648>, <-0.757, -0.216, 0.617>, <2.2808, 7.4232, 24.5574>, <-0.508, 0.737, 0.446> }
	smooth_triangle { <3.2109, 7.5012, 25.8886>, <-0.815, 0.102, 0.570>, <2.2808, 7.4232, 24.5574>, <-0.508, 0.737, 0.446>, <3.2188, 7.5242, 25.8813>, <-0.366, 0.911, 0.190> }
	smooth_triangle { <3.2188, 7.5242, 25.8813>, <-0.366, 0.911, 0.190>, <2.2808, 7.4232, 24.5574>, <-0.508, 0.737, 0.446>, <2.3013, 7.4254, 24.5427>, <0.249, 0.953, -0.171> }
	smooth_triangle { <3.2188, 7.5242, 25.8813>, <-0.366, 0.911, 0.190>, <2.3013, 7.4254, 24.5427>, <0.249, 0.953, -0.171>, <3.2394, 7.5264, 25.8665>, <0.449, 0.809, -0.380> }
	smooth_triangle { <3.2394, 7.5264, 25.8665>, <0.449, 0.809, -0.380>, <2.3013, 7.4254, 24.5427>, <0.249, 0.953, -0.171>, <2.3140, 7.4046, 24.5353>, <0.757, 0.216, -0.617> }
	smooth_triangle { <3.2394, 7.5264, 25.8665>, <0.449, 0.809, -0.380>, <2.3140, 7.4046, 24.5353>, <0.757, 0.216, -0.617>, <3.2520, 7.5056, 25.8591>, <0.815, -0.102, -0.570> }
	smooth_triangle { <3.2520, 7.5056, 25.8591>, <0.815, -0.102, -0.570>, <2.3140, 7.4046, 24.5353>, <0.757, 0.216, -0.617>, <2.3060, 7.3817, 24.5427>, <0.508, -0.737, -0.446> }
	smooth_triangle { <3.2520, 7.5056, 25.8591>, <0.815, -0.102, -0.570>, <2.3060, 7.3817, 24.5427>, <0.508, -0.737, -0.446>, <3.2441, 7.4826, 25.8665>, <0.366, -0.911, -0.190> }
	smooth_triangle { <3.2441, 7.4826, 25.8665>, <0.366, -0.911, -0.190>, <2.3060, 7.3817, 24.5427>, <0.508, -0.737, -0.446>, <2.2855, 7.3795, 24.5574>, <-0.010, -1.000, -0.024> }
	smooth_triangle { <3.2441, 7.4826, 25.8665>, <0.366, -0.911, -0.190>, <2.2855, 7.3795, 24.5574>, <-0.010, -1.000, -0.024>, <3.2235, 7.4804, 25.8813>, <0.107, -0.994, 0.000> }
	smooth_triangle { <4.9813, 6.8934, 27.4589>, <-0.621, -0.413, 0.666>, <2.2855, 7.3795, 24.5574>, <-0.647, -0.573, 0.504>, <2.2728, 7.4002, 24.5648>, <-0.757, -0.216, 0.617> }
	smooth_triangle { <4.9813, 6.8934, 27.4589>, <-0.621, -0.413, 0.666>, <2.2728, 7.4002, 24.5648>, <-0.757, -0.216, 0.617>, <4.9805, 6.9168, 27.4686>, <-0.534, 0.121, 0.837> }
	smooth_triangle { <4.9805, 6.9168, 27.4686>, <-0.534, 0.121, 0.837>, <2.2728, 7.4002, 24.5648>, <-0.757, -0.216, 0.617>, <2.2808, 7.4232, 24.5574>, <-0.508, 0.737, 0.446> }
	smooth_triangle { <4.9805, 6.9168, 27.4686>, <-0.534, 0.121, 0.837>, <2.2808, 7.4232, 24.5574>, <-0.508, 0.737, 0.446>, <4.9953, 6.9351, 27.4589>, <0.023, 0.885, 0.466> }
	smooth_triangle { <4.9953, 6.9351, 27.4589>, <0.023, 0.885, 0.466>, <2.2808, 7.4232, 24.5574>, <-0.508, 0.737, 0.446>, <2.3013, 7.4254, 24.5427>, <0.249, 0.953, -0.171> }
	smooth_triangle { <4.9953, 6.9351, 27.4589>, <0.023, 0.885, 0.466>, <2.3013, 7.4254, 24.5427>, <0.249, 0.953, -0.171>, <5.0109, 6.9299, 27.4395>, <0.548, 0.752, -0.365> }
	smooth_triangle { <5.0109, 6.9299, 27.4395>, <0.548, 0.752, -0.365>, <2.3013, 7.4254, 24.5427>, <0.249, 0.953, -0.171>, <2.3140, 7.4046, 24.5353>, <0.757, 0.216, -0.617> }
	smooth_triangle { <5.0109, 6.9299, 27.4395>, <0.548, 0.752, -0.365>, <2.3140, 7.4046, 24.5353>, <0.757, 0.216, -0.617>, <5.0116, 6.9064, 27.4298>, <0.533, -0.121, -0.837> }
	smooth_triangle { <5.0116, 6.9064, 27.4298>, <0.533, -0.121, -0.837>, <2.3140, 7.4046, 24.5353>, <0.757, 0.216, -0.617>, <2.3060, 7.3817, 24.5427>, <0.508, -0.737, -0.446> }
	smooth_triangle { <5.0116, 6.9064, 27.4298>, <0.533, -0.121, -0.837>, <2.3060, 7.3817, 24.5427>, <0.508, -0.737, -0.446>, <4.9969, 6.8882, 27.4395>, <-0.023, -0.884, -0.466> }
	smooth_triangle { <4.9969, 6.8882, 27.4395>, <-0.023, -0.884, -0.466>, <2.3060, 7.3817, 24.5427>, <0.508, -0.737, -0.446>, <2.2855, 7.3795, 24.5574>, <-0.010, -1.000, -0.024> }
	smooth_triangle { <4.9969, 6.8882, 27.4395>, <-0.023, -0.884, -0.466>, <2.2855, 7.3795, 24.5574>, <-0.010, -1.000, -0.024>, <4.9813, 6.8934, 27.4589>, <-0.364, -0.931, -0.006> }
	smooth_triangle { <7.0847, 5.8850, 28.1773>, <-0.668, -0.425, 0.611>, <4.9813, 6.8934, 27.4589>, <-0.621, -0.413, 0.666>, <4.9805, 6.9168, 27.4686>, <-0.534, 0.121, 0.837> }
	smooth_triangle { <7.0847, 5.8850, 28.1773>, <-0.668, -0.425, 0.611>, <4.9805, 6.9168, 27.4686>, <-0.534, 0.121, 0.837>, <7.0909, 5.9064, 28.1894>, <-0.294, 0.261, 0.919> }
	smooth_triangle { <7.0909, 5.9064, 28.1894>, <-0.294, 0.261, 0.919>, <4.9805, 6.9168, 27.4686>, <-0.534, 0.121, 0.837>, <4.9953, 6.9351, 27.4589>, <0.023, 0.885, 0.466> }
	smooth_triangle { <7.0909, 5.9064, 28.1894>, <-0.294, 0.261, 0.919>, <4.9953, 6.9351, 27.4589>, <0.023, 0.885, 0.466>, <7.1037, 5.9246, 28.1773>, <0.360, 0.829, 0.429> }
	smooth_triangle { <7.1037, 5.9246, 28.1773>, <0.360, 0.829, 0.429>, <4.9953, 6.9351, 27.4589>, <0.023, 0.885, 0.466>, <5.0109, 6.9299, 27.4395>, <0.548, 0.752, -0.365> }
	smooth_triangle { <7.1037, 5.9246, 28.1773>, <0.360, 0.829, 0.429>, <5.0109, 6.9299, 27.4395>, <0.548, 0.752, -0.365>, <7.1105, 5.9214, 28.1530>, <0.660, 0.558, -0.504> }
	smooth_triangle { <7.1105, 5.9214, 28.1530>, <0.660, 0.558, -0.504>, <5.0109, 6.9299, 27.4395>, <0.548, 0.752, -0.365>, <5.0116, 6.9064, 27.4298>, <0.533, -0.121, -0.837> }
	smooth_triangle { <7.1105, 5.9214, 28.1530>, <0.660, 0.558, -0.504>, <5.0116, 6.9064, 27.4298>, <0.533, -0.121, -0.837>, <7.1043, 5.9000, 28.1409>, <0.300, -0.265, -0.916> }
	smooth_triangle { <7.1043, 5.9000, 28.1409>, <0.300, -0.265, -0.916>, <5.0116, 6.9064, 27.4298>, <0.533, -0.121, -0.837>, <4.9969, 6.8882, 27.4395>, <-0.023, -0.884, -0.466> }
	smooth_triangle { <7.1043, 5.9000, 28.1409>, <0.300, -0.265, -0.916>, <4.9969, 6.8882, 27.4395>, <-0.023, -0.884, -0.466>, <7.0914, 5.8817, 28.1530>, <-0.353, -0.833, -0.426> }
	smooth_triangle { <7.0914, 5.8817, 28.1530>, <-0.353, -0.833, -0.426>, <4.9969, 6.8882, 27.4395>, <-0.023, -0.884, -0.466>, <4.9813, 6.8934, 27.4589>, <-0.364, -0.931, -0.006> }
	smooth_triangle { <7.0914, 5.8817, 28.1530>, <-0.353, -0.833, -0.426>, <4.9813, 6.8934, 27.4589>, <-0.364, -0.931, -0.006>, <7.0847, 5.8850, 28.1773>, <-0.432, -0.902, 0.000> }
	smooth_triangle { <8.4166, 4.2272, 29.3470>, <-0.735, -0.127, 0.666>, <7.0847, 5.8850, 28.1773>, <-0.668, -0.425, 0.611>, <7.0909, 5.9064, 28.1894>, <-0.294, 0.261, 0.919> }
	smooth_triangle { <8.4166, 4.2272, 29.3470>, <-0.010, 0.558, 0.830>, <7.0909, 5.9064, 28.1894>, <-0.294, 0.261, 0.919>, <7.1037, 5.9246, 28.1773>, <0.360, 0.829, 0.429> }
	smooth_triangle { <8.4166, 4.2272, 29.3470>, <0.731, 0.665, 0.153>, <7.1037, 5.9246, 28.1773>, <0.360, 0.829, 0.429>, <7.1105, 5.9214, 28.1530>, <0.660, 0.558, -0.504> }
	smooth_triangle { <8.4166, 4.2272, 29.3470>, <0.750, 0.112, -0.653>, <7.1105, 5.9214, 28.1530>, <0.660, 0.558, -0.504>, <7.1043, 5.9000, 28.1409>, <0.300, -0.265, -0.916> }
	smooth_triangle { <8.4166, 4.2272, 29.3470>, <0.030, -0.573, -0.819>, <7.1043, 5.9000, 28.1409>, <0.300, -0.265, -0.916>, <7.0914, 5.8817, 28.1530>, <-0.353, -0.833, -0.426> }
	smooth_triangle { <8.4166, 4.2272, 29.3470>, <-0.716, -0.683, -0.144>, <7.0914, 5.8817, 28.1530>, <-0.353, -0.833, -0.426>, <7.0847, 5.8850, 28.1773>, <-0.668, -0.425, 0.611> }

	texture { PSWL_BARK }
}

/* Object 'PWL0013F' */
union {
	smooth_triangle { <1.8865, 6.3752, 23.6526>, <-0.506, 0.723, -0.469>, <2.2462, 6.2953, 23.1475>, <-0.510, 0.716, -0.477>, <2.7641, 6.5548, 22.9828>, <-0.506, 0.723, -0.469> }
	smooth_triangle { <2.7641, 6.5548, 22.9828>, <-0.506, 0.723, -0.469>, <2.3900, 6.6274, 23.5041>, <-0.502, 0.731, -0.462>, <1.8865, 6.3752, 23.6526>, <-0.506, 0.723, -0.469> }
	smooth_triangle { <2.2540, 7.4340, 24.5327>, <-0.576, -0.299, 0.761>, <1.8132, 7.5527, 24.2471>, <-0.574, -0.296, 0.763>, <1.5130, 8.0285, 24.2055>, <-0.576, -0.299, 0.761> }
	smooth_triangle { <1.5130, 8.0285, 24.2055>, <-0.576, -0.299, 0.761>, <1.9638, 7.9003, 24.4973>, <-0.577, -0.301, 0.759>, <2.2540, 7.4340, 24.5327>, <-0.576, -0.299, 0.761> }
	smooth_triangle { <2.6534, 8.2017, 25.3991>, <-0.635, 0.710, -0.306>, <2.9223, 8.2776, 24.9619>, <-0.606, 0.758, -0.241>, <3.2715, 8.5313, 24.8815>, <-0.635, 0.710, -0.306> }
	smooth_triangle { <3.2715, 8.5313, 24.8815>, <-0.635, 0.710, -0.306>, <3.0122, 8.4950, 25.2801>, <-0.659, 0.656, -0.369>, <2.6534, 8.2017, 25.3991>, <-0.635, 0.710, -0.306> }
	smooth_triangle { <2.9152, 9.0007, 26.2843>, <-0.901, -0.280, 0.332>, <2.6128, 9.3274, 25.7271>, <-0.902, -0.288, 0.321>, <2.4043, 9.9117, 25.6652>, <-0.901, -0.280, 0.332> }
	smooth_triangle { <2.4043, 9.9117, 25.6652>, <-0.901, -0.280, 0.332>, <2.7172, 9.5799, 26.2231>, <-0.899, -0.271, 0.343>, <2.9152, 9.0007, 26.2843>, <-0.901, -0.280, 0.332> }
	smooth_triangle { <3.4185, 9.3793, 26.8184>, <-0.265, 0.861, -0.434>, <3.7093, 9.2662, 26.3420>, <-0.183, 0.926, -0.331>, <4.1885, 9.3229, 26.2365>, <-0.265, 0.861, -0.434> }
	smooth_triangle { <4.1885, 9.3229, 26.2365>, <-0.265, 0.861, -0.434>, <3.9387, 9.4868, 26.6398>, <-0.342, 0.778, -0.528>, <3.4185, 9.3793, 26.8184>, <-0.265, 0.861, -0.434> }
	smooth_triangle { <3.8138, 9.8465, 27.3571>, <-0.838, 0.325, 0.438>, <3.7184, 10.1114, 26.9212>, <-0.898, 0.260, 0.355>, <3.8034, 10.5600, 26.8072>, <-0.838, 0.325, 0.438> }
	smooth_triangle { <3.8034, 10.5600, 26.8072>, <-0.838, 0.325, 0.438>, <3.9399, 10.3245, 27.1866>, <-0.766, 0.386, 0.515>, <3.8138, 9.8465, 27.3571>, <-0.838, 0.325, 0.438> }
	smooth_triangle { <4.3740, 10.2911, 27.7351>, <0.062, 0.494, -0.867>, <4.6786, 9.8108, 27.4746>, <0.079, 0.513, -0.855>, <5.3369, 9.6610, 27.4452>, <0.062, 0.494, -0.867> }
	smooth_triangle { <5.3369, 9.6610, 27.4452>, <0.062, 0.494, -0.867>, <5.0269, 10.1580, 27.6971>, <0.046, 0.474, -0.879>, <4.3740, 10.2911, 27.7351>, <0.062, 0.494, -0.867> }
	smooth_triangle { <4.8107, 10.8736, 28.1058>, <-0.333, -0.292, 0.897>, <4.3830, 11.0685, 28.0085>, <-0.338, -0.296, 0.893>, <4.2008, 11.5261, 28.0913>, <-0.333, -0.292, 0.897> }
	smooth_triangle { <4.2008, 11.5261, 28.0913>, <-0.333, -0.292, 0.897>, <4.6386, 11.3235, 28.1864>, <-0.328, -0.287, 0.900>, <4.8107, 10.8736, 28.1058>, <-0.333, -0.292, 0.897> }
	smooth_triangle { <2.7958, 7.4170, 25.1911>, <0.429, 0.718, -0.548>, <2.9696, 6.9635, 24.7450>, <0.415, 0.714, -0.564>, <3.6047, 6.5462, 24.6843>, <0.429, 0.718, -0.548> }
	smooth_triangle { <3.6047, 6.5462, 24.6843>, <0.429, 0.718, -0.548>, <3.4052, 7.0104, 25.1478>, <0.444, 0.721, -0.532>, <2.7958, 7.4170, 25.1911>, <0.429, 0.718, -0.548> }
	smooth_triangle { <3.2540, 7.5477, 25.8545>, <-0.701, 0.554, 0.449>, <3.3750, 8.0200, 25.4042>, <-0.753, 0.545, 0.369>, <3.7560, 8.5334, 25.4236>, <-0.701, 0.554, 0.449> }
	smooth_triangle { <3.7560, 8.5334, 25.4236>, <-0.701, 0.554, 0.449>, <3.6814, 8.0530, 25.8416>, <-0.643, 0.557, 0.526>, <3.2540, 7.5477, 25.8545>, <-0.701, 0.554, 0.449> }
	smooth_triangle { <4.1100, 7.1565, 26.6466>, <0.704, 0.151, -0.693>, <3.9314, 6.7472, 26.3544>, <0.750, 0.135, -0.647>, <4.0417, 6.2277, 26.3742>, <0.704, 0.151, -0.693> }
	smooth_triangle { <4.0417, 6.2277, 26.3742>, <0.704, 0.151, -0.693>, <4.2407, 6.6435, 26.6460>, <0.655, 0.168, -0.737>, <4.1100, 7.1565, 26.6466>, <0.704, 0.151, -0.693> }
	smooth_triangle { <5.0223, 6.9564, 27.4367>, <-0.449, 0.474, 0.757>, <5.1275, 7.5762, 27.0897>, <-0.488, 0.488, 0.724>, <5.6722, 8.0675, 27.1261>, <-0.449, 0.474, 0.757> }
	smooth_triangle { <5.6722, 8.0675, 27.1261>, <-0.449, 0.474, 0.757>, <5.5782, 7.4251, 27.4519>, <-0.409, 0.460, 0.788>, <5.0223, 6.9564, 27.4367>, <-0.449, 0.474, 0.757> }
	smooth_triangle { <6.0262, 6.3588, 27.7993>, <0.338, 0.008, -0.941>, <5.5537, 5.9268, 27.6420>, <0.290, 0.031, -0.957>, <5.5545, 5.2488, 27.6202>, <0.338, 0.008, -0.941> }
	smooth_triangle { <5.5545, 5.2488, 27.6202>, <0.338, 0.008, -0.941>, <6.0255, 5.7004, 27.8098>, <0.386, -0.015, -0.922>, <6.0262, 6.3588, 27.7993>, <0.338, 0.008, -0.941> }
	smooth_triangle { <7.1236, 5.9476, 28.1511>, <-0.145, 0.374, 0.916>, <7.1642, 6.4310, 27.9789>, <-0.077, 0.340, 0.937>, <7.5910, 6.7434, 27.9004>, <-0.145, 0.374, 0.916> }
	smooth_triangle { <7.5910, 6.7434, 27.9004>, <-0.145, 0.374, 0.916>, <7.5345, 6.2533, 28.1100>, <-0.212, 0.405, 0.889>, <7.1236, 5.9476, 28.1511>, <-0.145, 0.374, 0.916> }
	smooth_triangle { <7.7556, 5.0323, 28.7142>, <0.879, 0.359, -0.314>, <7.5917, 4.8182, 27.9594>, <0.901, 0.325, -0.288>, <7.7168, 4.1904, 27.6421>, <0.879, 0.359, -0.314> }
	smooth_triangle { <7.7168, 4.1904, 27.6421>, <0.879, 0.359, -0.314>, <7.8979, 4.4084, 28.3520>, <0.856, 0.392, -0.338>, <7.7556, 5.0323, 28.7142>, <0.879, 0.359, -0.314> }
	smooth_triangle { <8.4408, 4.2745, 29.3428>, <-0.399, 0.283, 0.872>, <8.5452, 4.8839, 29.1899>, <-0.410, 0.287, 0.866>, <8.9070, 5.1875, 29.2602>, <-0.399, 0.283, 0.872> }
	smooth_triangle { <8.9070, 5.1875, 29.2602>, <-0.399, 0.283, 0.872>, <8.7976, 4.5645, 29.4087>, <-0.388, 0.278, 0.879>, <8.4408, 4.2745, 29.3428>, <-0.399, 0.283, 0.872> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0014B' */
union {
	smooth_triangle { <2.0253, 3.7219, 23.0557>, <-0.796, -0.236, 0.557>, <1.0461, 4.0879, 21.8108>, <-0.816, -0.229, 0.531>, <1.0445, 4.1146, 21.8199>, <-0.804, 0.067, 0.591> }
	smooth_triangle { <2.0253, 3.7219, 23.0557>, <-0.796, -0.236, 0.557>, <1.0445, 4.1146, 21.8199>, <-0.804, 0.067, 0.591>, <2.0238, 3.7487, 23.0648>, <-0.638, 0.440, 0.631> }
	smooth_triangle { <2.0238, 3.7487, 23.0648>, <-0.638, 0.440, 0.631>, <1.0445, 4.1146, 21.8199>, <-0.804, 0.067, 0.591>, <1.0633, 4.1338, 21.8108>, <-0.264, 0.884, 0.386> }
	smooth_triangle { <2.0238, 3.7487, 23.0648>, <-0.638, 0.440, 0.631>, <1.0633, 4.1338, 21.8108>, <-0.264, 0.884, 0.386>, <2.0425, 3.7679, 23.0557>, <0.096, 0.973, 0.210> }
	smooth_triangle { <2.0425, 3.7679, 23.0557>, <0.096, 0.973, 0.210>, <1.0633, 4.1338, 21.8108>, <-0.264, 0.884, 0.386>, <1.0836, 4.1262, 21.7926>, <0.540, 0.816, -0.204> }
	smooth_triangle { <2.0425, 3.7679, 23.0557>, <0.096, 0.973, 0.210>, <1.0836, 4.1262, 21.7926>, <0.540, 0.816, -0.204>, <2.0628, 3.7603, 23.0375>, <0.734, 0.533, -0.421> }
	smooth_triangle { <2.0628, 3.7603, 23.0375>, <0.734, 0.533, -0.421>, <1.0836, 4.1262, 21.7926>, <0.540, 0.816, -0.204>, <1.0852, 4.0995, 21.7835>, <0.805, -0.068, -0.590> }
	smooth_triangle { <2.0628, 3.7603, 23.0375>, <0.734, 0.533, -0.421>, <1.0852, 4.0995, 21.7835>, <0.805, -0.068, -0.590>, <2.0644, 3.7335, 23.0284>, <0.638, -0.440, -0.631> }
	smooth_triangle { <2.0644, 3.7335, 23.0284>, <0.638, -0.440, -0.631>, <1.0852, 4.0995, 21.7835>, <0.805, -0.068, -0.590>, <1.0664, 4.0803, 21.7926>, <0.264, -0.884, -0.385> }
	smooth_triangle { <2.0644, 3.7335, 23.0284>, <0.638, -0.440, -0.631>, <1.0664, 4.0803, 21.7926>, <0.264, -0.884, -0.385>, <2.0456, 3.7143, 23.0375>, <-0.096, -0.973, -0.210> }
	smooth_triangle { <2.0456, 3.7143, 23.0375>, <-0.096, -0.973, -0.210>, <1.0664, 4.0803, 21.7926>, <0.264, -0.884, -0.385>, <1.0461, 4.0879, 21.8108>, <-0.298, -0.955, 0.002> }
	smooth_triangle { <2.0456, 3.7143, 23.0375>, <-0.096, -0.973, -0.210>, <1.0461, 4.0879, 21.8108>, <-0.298, -0.955, 0.002>, <2.0253, 3.7219, 23.0557>, <-0.350, -0.937, 0.000> }
	smooth_triangle { <3.4378, 3.4997, 25.5150>, <-0.829, -0.326, 0.454>, <1.0461, 4.0879, 21.8108>, <-0.816, -0.229, 0.531>, <1.0445, 4.1146, 21.8199>, <-0.804, 0.067, 0.591> }
	smooth_triangle { <3.4378, 3.4997, 25.5150>, <-0.829, -0.326, 0.454>, <1.0445, 4.1146, 21.8199>, <-0.804, 0.067, 0.591>, <3.4303, 3.5232, 25.5213>, <-0.846, 0.159, 0.509> }
	smooth_triangle { <3.4303, 3.5232, 25.5213>, <-0.846, 0.159, 0.509>, <1.0445, 4.1146, 21.8199>, <-0.804, 0.067, 0.591>, <1.0633, 4.1338, 21.8108>, <-0.264, 0.884, 0.386> }
	smooth_triangle { <3.4303, 3.5232, 25.5213>, <-0.846, 0.159, 0.509>, <1.0633, 4.1338, 21.8108>, <-0.264, 0.884, 0.386>, <3.4446, 3.5432, 25.5150>, <-0.264, 0.931, 0.251> }
	smooth_triangle { <3.4446, 3.5432, 25.5150>, <-0.264, 0.931, 0.251>, <1.0633, 4.1338, 21.8108>, <-0.264, 0.884, 0.386>, <1.0836, 4.1262, 21.7926>, <0.540, 0.816, -0.204> }
	smooth_triangle { <3.4446, 3.5432, 25.5150>, <-0.264, 0.931, 0.251>, <1.0836, 4.1262, 21.7926>, <0.540, 0.816, -0.204>, <3.4663, 3.5398, 25.5023>, <0.582, 0.771, -0.258> }
	smooth_triangle { <3.4663, 3.5398, 25.5023>, <0.582, 0.771, -0.258>, <1.0836, 4.1262, 21.7926>, <0.540, 0.816, -0.204>, <1.0852, 4.0995, 21.7835>, <0.805, -0.068, -0.590> }
	smooth_triangle { <3.4663, 3.5398, 25.5023>, <0.582, 0.771, -0.258>, <1.0852, 4.0995, 21.7835>, <0.805, -0.068, -0.590>, <3.4737, 3.5164, 25.4959>, <0.846, -0.159, -0.508> }
	smooth_triangle { <3.4737, 3.5164, 25.4959>, <0.846, -0.159, -0.508>, <1.0852, 4.0995, 21.7835>, <0.805, -0.068, -0.590>, <1.0664, 4.0803, 21.7926>, <0.264, -0.884, -0.385> }
	smooth_triangle { <3.4737, 3.5164, 25.4959>, <0.846, -0.159, -0.508>, <1.0664, 4.0803, 21.7926>, <0.264, -0.884, -0.385>, <3.4595, 3.4963, 25.5023>, <0.265, -0.931, -0.250> }
	smooth_triangle { <3.4595, 3.4963, 25.5023>, <0.265, -0.931, -0.250>, <1.0664, 4.0803, 21.7926>, <0.264, -0.884, -0.385>, <1.0461, 4.0879, 21.8108>, <-0.298, -0.955, 0.002> }
	smooth_triangle { <3.4595, 3.4963, 25.5023>, <0.265, -0.931, -0.250>, <1.0461, 4.0879, 21.8108>, <-0.298, -0.955, 0.002>, <3.4378, 3.4997, 25.5150>, <-0.163, -0.987, -0.013> }
	smooth_triangle { <4.7196, 3.2996, 28.0460>, <-0.857, -0.371, 0.357>, <3.4378, 3.4997, 25.5150>, <-0.829, -0.326, 0.454>, <3.4303, 3.5232, 25.5213>, <-0.846, 0.159, 0.509> }
	smooth_triangle { <4.7196, 3.2996, 28.0460>, <-0.857, -0.371, 0.357>, <3.4303, 3.5232, 25.5213>, <-0.846, 0.159, 0.509>, <4.7118, 3.3231, 28.0518>, <-0.866, 0.215, 0.451> }
	smooth_triangle { <4.7118, 3.3231, 28.0518>, <-0.866, 0.215, 0.451>, <3.4303, 3.5232, 25.5213>, <-0.846, 0.159, 0.509>, <3.4446, 3.5432, 25.5150>, <-0.264, 0.931, 0.251> }
	smooth_triangle { <4.7118, 3.3231, 28.0518>, <-0.866, 0.215, 0.451>, <3.4446, 3.5432, 25.5150>, <-0.264, 0.931, 0.251>, <4.7264, 3.3431, 28.0460>, <-0.193, 0.937, 0.291> }
	smooth_triangle { <4.7264, 3.3431, 28.0460>, <-0.193, 0.937, 0.291>, <3.4446, 3.5432, 25.5150>, <-0.264, 0.931, 0.251>, <3.4663, 3.5398, 25.5023>, <0.582, 0.771, -0.258> }
	smooth_triangle { <4.7264, 3.3431, 28.0460>, <-0.193, 0.937, 0.291>, <3.4663, 3.5398, 25.5023>, <0.582, 0.771, -0.258>, <4.7487, 3.3396, 28.0344>, <0.675, 0.720, -0.161> }
	smooth_triangle { <4.7487, 3.3396, 28.0344>, <0.675, 0.720, -0.161>, <3.4663, 3.5398, 25.5023>, <0.582, 0.771, -0.258>, <3.4737, 3.5164, 25.4959>, <0.846, -0.159, -0.508> }
	smooth_triangle { <4.7487, 3.3396, 28.0344>, <0.675, 0.720, -0.161>, <3.4737, 3.5164, 25.4959>, <0.846, -0.159, -0.508>, <4.7565, 3.3161, 28.0286>, <0.866, -0.215, -0.451> }
	smooth_triangle { <4.7565, 3.3161, 28.0286>, <0.866, -0.215, -0.451>, <3.4737, 3.5164, 25.4959>, <0.846, -0.159, -0.508>, <3.4595, 3.4963, 25.5023>, <0.265, -0.931, -0.250> }
	smooth_triangle { <4.7565, 3.3161, 28.0286>, <0.866, -0.215, -0.451>, <3.4595, 3.4963, 25.5023>, <0.265, -0.931, -0.250>, <4.7419, 3.2961, 28.0344>, <0.193, -0.937, -0.292> }
	smooth_triangle { <4.7419, 3.2961, 28.0344>, <0.193, -0.937, -0.292>, <3.4595, 3.4963, 25.5023>, <0.265, -0.931, -0.250>, <3.4378, 3.4997, 25.5150>, <-0.163, -0.987, -0.013> }
	smooth_triangle { <4.7419, 3.2961, 28.0344>, <0.193, -0.937, -0.292>, <3.4378, 3.4997, 25.5150>, <-0.163, -0.987, -0.013>, <4.7196, 3.2996, 28.0460>, <-0.352, -0.933, -0.074> }
	smooth_triangle { <5.6852, 2.5574, 30.1523>, <-0.949, -0.055, 0.311>, <4.7196, 3.2996, 28.0460>, <-0.857, -0.371, 0.357>, <4.7118, 3.3231, 28.0518>, <-0.866, 0.215, 0.451> }
	smooth_triangle { <5.6852, 2.5574, 30.1523>, <-0.949, -0.055, 0.311>, <4.7118, 3.3231, 28.0518>, <-0.866, 0.215, 0.451>, <5.6900, 2.5815, 30.1587>, <-0.697, 0.576, 0.427> }
	smooth_triangle { <5.6900, 2.5815, 30.1587>, <-0.697, 0.576, 0.427>, <4.7118, 3.3231, 28.0518>, <-0.866, 0.215, 0.451>, <4.7264, 3.3431, 28.0460>, <-0.193, 0.937, 0.291> }
	smooth_triangle { <5.6900, 2.5815, 30.1587>, <-0.697, 0.576, 0.427>, <4.7264, 3.3431, 28.0460>, <-0.193, 0.937, 0.291>, <5.7121, 2.5922, 30.1523>, <0.224, 0.928, 0.297> }
	smooth_triangle { <5.7121, 2.5922, 30.1523>, <0.224, 0.928, 0.297>, <4.7264, 3.3431, 28.0460>, <-0.193, 0.937, 0.291>, <4.7487, 3.3396, 28.0344>, <0.675, 0.720, -0.161> }
	smooth_triangle { <5.7121, 2.5922, 30.1523>, <0.224, 0.928, 0.297>, <4.7487, 3.3396, 28.0344>, <0.675, 0.720, -0.161>, <5.7295, 2.5788, 30.1395>, <0.925, 0.358, -0.129> }
	smooth_triangle { <5.7295, 2.5788, 30.1395>, <0.925, 0.358, -0.129>, <4.7487, 3.3396, 28.0344>, <0.675, 0.720, -0.161>, <4.7565, 3.3161, 28.0286>, <0.866, -0.215, -0.451> }
	smooth_triangle { <5.7295, 2.5788, 30.1395>, <0.925, 0.358, -0.129>, <4.7565, 3.3161, 28.0286>, <0.866, -0.215, -0.451>, <5.7247, 2.5547, 30.1331>, <0.697, -0.576, -0.427> }
	smooth_triangle { <5.7247, 2.5547, 30.1331>, <0.697, -0.576, -0.427>, <4.7565, 3.3161, 28.0286>, <0.866, -0.215, -0.451>, <4.7419, 3.2961, 28.0344>, <0.193, -0.937, -0.292> }
	smooth_triangle { <5.7247, 2.5547, 30.1331>, <0.697, -0.576, -0.427>, <4.7419, 3.2961, 28.0344>, <0.193, -0.937, -0.292>, <5.7026, 2.5440, 30.1395>, <-0.224, -0.928, -0.297> }
	smooth_triangle { <5.7026, 2.5440, 30.1395>, <-0.224, -0.928, -0.297>, <4.7419, 3.2961, 28.0344>, <0.193, -0.937, -0.292>, <4.7196, 3.2996, 28.0460>, <-0.352, -0.933, -0.074> }
	smooth_triangle { <5.7026, 2.5440, 30.1395>, <-0.224, -0.928, -0.297>, <4.7196, 3.2996, 28.0460>, <-0.352, -0.933, -0.074>, <5.6852, 2.5574, 30.1523>, <-0.783, -0.618, -0.071> }
	smooth_triangle { <5.9739, 1.6256, 32.3791>, <-0.838, 0.512, 0.191>, <5.6852, 2.5574, 30.1523>, <-0.949, -0.055, 0.311>, <5.6900, 2.5815, 30.1587>, <-0.697, 0.576, 0.427> }
	smooth_triangle { <5.9739, 1.6256, 32.3791>, <-0.838, 0.512, 0.191>, <5.6900, 2.5815, 30.1587>, <-0.697, 0.576, 0.427>, <5.9915, 1.6431, 32.3842>, <-0.314, 0.931, 0.187> }
	smooth_triangle { <5.9915, 1.6431, 32.3842>, <-0.314, 0.931, 0.187>, <5.6900, 2.5815, 30.1587>, <-0.697, 0.576, 0.427>, <5.7121, 2.5922, 30.1523>, <0.224, 0.928, 0.297> }
	smooth_triangle { <5.9915, 1.6431, 32.3842>, <-0.314, 0.931, 0.187>, <5.7121, 2.5922, 30.1523>, <0.224, 0.928, 0.297>, <6.0160, 1.6385, 32.3791>, <0.658, 0.753, -0.022> }
	smooth_triangle { <6.0160, 1.6385, 32.3791>, <0.658, 0.753, -0.022>, <5.7121, 2.5922, 30.1523>, <0.224, 0.928, 0.297>, <5.7295, 2.5788, 30.1395>, <0.925, 0.358, -0.129> }
	smooth_triangle { <6.0160, 1.6385, 32.3791>, <0.658, 0.753, -0.022>, <5.7295, 2.5788, 30.1395>, <0.925, 0.358, -0.129>, <6.0228, 1.6163, 32.3688>, <0.966, -0.175, -0.191> }
	smooth_triangle { <6.0228, 1.6163, 32.3688>, <0.966, -0.175, -0.191>, <5.7295, 2.5788, 30.1395>, <0.925, 0.358, -0.129>, <5.7247, 2.5547, 30.1331>, <0.697, -0.576, -0.427> }
	smooth_triangle { <6.0228, 1.6163, 32.3688>, <0.966, -0.175, -0.191>, <5.7247, 2.5547, 30.1331>, <0.697, -0.576, -0.427>, <6.0052, 1.5987, 32.3636>, <0.316, -0.935, -0.163> }
	smooth_triangle { <6.0052, 1.5987, 32.3636>, <0.316, -0.935, -0.163>, <5.7247, 2.5547, 30.1331>, <0.697, -0.576, -0.427>, <5.7026, 2.5440, 30.1395>, <-0.224, -0.928, -0.297> }
	smooth_triangle { <6.0052, 1.5987, 32.3636>, <0.316, -0.935, -0.163>, <5.7026, 2.5440, 30.1395>, <-0.224, -0.928, -0.297>, <5.9807, 1.6034, 32.3688>, <-0.652, -0.757, 0.044> }
	smooth_triangle { <5.9807, 1.6034, 32.3688>, <-0.652, -0.757, 0.044>, <5.7026, 2.5440, 30.1395>, <-0.224, -0.928, -0.297>, <5.6852, 2.5574, 30.1523>, <-0.783, -0.618, -0.071> }
	smooth_triangle { <5.9807, 1.6034, 32.3688>, <-0.652, -0.757, 0.044>, <5.6852, 2.5574, 30.1523>, <-0.783, -0.618, -0.071>, <5.9739, 1.6256, 32.3791>, <-0.906, -0.373, 0.203> }
	smooth_triangle { <6.4334, 2.0730, 33.8738>, <-0.707, 0.708, 0.005>, <5.9739, 1.6256, 32.3791>, <-0.838, 0.512, 0.191>, <5.9915, 1.6431, 32.3842>, <-0.314, 0.931, 0.187> }
	smooth_triangle { <6.4334, 2.0730, 33.8738>, <0.125, -0.986, 0.109>, <5.9915, 1.6431, 32.3842>, <-0.166, -0.933, 0.318>, <6.4092, 2.0790, 33.8788>, <-0.655, -0.727, 0.207> }
	smooth_triangle { <6.4092, 2.0790, 33.8788>, <0.114, 0.945, -0.307>, <5.9915, 1.6431, 32.3842>, <-0.314, 0.931, 0.187>, <6.0160, 1.6385, 32.3791>, <0.658, 0.753, -0.022> }
	smooth_triangle { <6.4092, 2.0790, 33.8788>, <-0.655, -0.727, 0.207>, <6.0160, 1.6385, 32.3791>, <-0.910, -0.266, 0.317>, <6.4006, 2.1024, 33.8738>, <-0.968, 0.219, 0.125> }
	smooth_triangle { <6.4006, 2.1024, 33.8738>, <0.840, 0.419, -0.346>, <6.0160, 1.6385, 32.3791>, <0.658, 0.753, -0.022>, <6.0228, 1.6163, 32.3688>, <0.969, -0.011, -0.247> }
	smooth_triangle { <6.4006, 2.1024, 33.8738>, <-0.968, 0.219, 0.125>, <6.0228, 1.6163, 32.3688>, <-0.751, 0.660, -0.024>, <6.4162, 2.1198, 33.8638>, <-0.314, 0.945, -0.088> }
	smooth_triangle { <6.4162, 2.1198, 33.8638>, <0.696, -0.716, 0.058>, <6.0228, 1.6163, 32.3688>, <0.935, -0.329, -0.135>, <6.0052, 1.5987, 32.3636>, <0.316, -0.935, -0.163> }
	smooth_triangle { <6.4162, 2.1198, 33.8638>, <-0.314, 0.945, -0.088>, <6.0052, 1.5987, 32.3636>, <0.153, 0.920, -0.361>, <6.4404, 2.1138, 33.8588>, <0.653, 0.724, -0.220> }
	smooth_triangle { <6.4404, 2.1138, 33.8588>, <-0.102, -0.931, 0.350>, <6.0052, 1.5987, 32.3636>, <0.316, -0.935, -0.163>, <5.9807, 1.6034, 32.3688>, <-0.652, -0.757, 0.044> }
	smooth_triangle { <6.4404, 2.1138, 33.8588>, <0.653, 0.724, -0.220>, <5.9807, 1.6034, 32.3688>, <0.897, 0.252, -0.363>, <6.4490, 2.0904, 33.8638>, <0.965, -0.224, -0.138> }
	smooth_triangle { <6.4490, 2.0904, 33.8638>, <-0.811, -0.433, 0.395>, <5.9807, 1.6034, 32.3688>, <-0.652, -0.757, 0.044>, <5.9739, 1.6256, 32.3791>, <-0.906, -0.373, 0.203> }
	smooth_triangle { <6.4490, 2.0904, 33.8638>, <0.965, -0.224, -0.138>, <5.9739, 1.6256, 32.3791>, <0.737, -0.675, -0.024>, <6.4334, 2.0730, 33.8738>, <0.737, -0.675, -0.024> }
	smooth_triangle { <6.5280, 2.0689, 35.4909>, <-0.221, -0.975, 0.017>, <6.4334, 2.0730, 33.8738>, <0.125, -0.986, 0.109>, <6.4092, 2.0790, 33.8788>, <-0.655, -0.727, 0.207> }
	smooth_triangle { <6.5280, 2.0689, 35.4909>, <-0.949, -0.306, 0.075>, <6.4092, 2.0790, 33.8788>, <-0.655, -0.727, 0.207>, <6.4006, 2.1024, 33.8738>, <-0.968, 0.219, 0.125> }
	smooth_triangle { <6.5280, 2.0689, 35.4909>, <-0.728, 0.681, 0.078>, <6.4006, 2.1024, 33.8738>, <-0.968, 0.219, 0.125>, <6.4162, 2.1198, 33.8638>, <-0.314, 0.945, -0.088> }
	smooth_triangle { <6.5280, 2.0689, 35.4909>, <0.226, 0.974, 0.021>, <6.4162, 2.1198, 33.8638>, <-0.314, 0.945, -0.088>, <6.4404, 2.1138, 33.8588>, <0.653, 0.724, -0.220> }
	smooth_triangle { <6.5280, 2.0689, 35.4909>, <0.950, 0.310, -0.036>, <6.4404, 2.1138, 33.8588>, <0.653, 0.724, -0.220>, <6.4490, 2.0904, 33.8638>, <0.965, -0.224, -0.138> }
	smooth_triangle { <6.5280, 2.0689, 35.4909>, <0.736, -0.676, -0.038>, <6.4490, 2.0904, 33.8638>, <0.965, -0.224, -0.138>, <6.4334, 2.0730, 33.8738>, <0.125, -0.986, 0.109> }
	smooth_triangle { <4.6192, 2.3622, 29.3491>, <-0.431, 0.738, 0.519>, <4.7133, 3.3319, 28.0478>, <-0.432, 0.719, 0.545>, <4.7361, 3.3399, 28.0554>, <-0.187, 0.786, 0.589> }
	smooth_triangle { <4.6192, 2.3622, 29.3491>, <-0.431, 0.738, 0.519>, <4.7361, 3.3399, 28.0554>, <-0.187, 0.786, 0.589>, <4.6420, 2.3702, 29.3567>, <0.264, 0.764, 0.589> }
	smooth_triangle { <4.6420, 2.3702, 29.3567>, <0.264, 0.764, 0.589>, <4.7361, 3.3399, 28.0554>, <-0.038, 0.812, 0.582>, <4.7570, 3.3276, 28.0478>, <0.756, 0.544, 0.364> }
	smooth_triangle { <4.6420, 2.3702, 29.3567>, <0.264, 0.764, 0.589>, <4.7570, 3.3276, 28.0478>, <0.756, 0.544, 0.364>, <4.6630, 2.3579, 29.3491>, <0.966, 0.170, 0.196> }
	smooth_triangle { <4.6630, 2.3579, 29.3491>, <0.966, 0.170, 0.196>, <4.7570, 3.3276, 28.0478>, <0.846, 0.443, 0.296>, <4.7551, 3.3074, 28.0326>, <0.943, -0.244, -0.226> }
	smooth_triangle { <4.6630, 2.3579, 29.3491>, <0.966, 0.170, 0.196>, <4.7551, 3.3074, 28.0326>, <0.943, -0.244, -0.226>, <4.6610, 2.3377, 29.3339>, <0.702, -0.595, -0.392> }
	smooth_triangle { <4.6610, 2.3377, 29.3339>, <0.702, -0.595, -0.392>, <4.7551, 3.3074, 28.0326>, <0.884, -0.370, -0.286>, <4.7322, 3.2994, 28.0250>, <0.187, -0.787, -0.589> }
	smooth_triangle { <4.6610, 2.3377, 29.3339>, <0.702, -0.595, -0.392>, <4.7322, 3.2994, 28.0250>, <0.187, -0.787, -0.589>, <4.6381, 2.3297, 29.3263>, <-0.264, -0.764, -0.589> }
	smooth_triangle { <4.6381, 2.3297, 29.3263>, <-0.264, -0.764, -0.589>, <4.7322, 3.2994, 28.0250>, <0.037, -0.813, -0.581>, <4.7113, 3.3116, 28.0326>, <-0.756, -0.544, -0.363> }
	smooth_triangle { <4.6381, 2.3297, 29.3263>, <-0.264, -0.764, -0.589>, <4.7113, 3.3116, 28.0326>, <-0.756, -0.544, -0.363>, <4.6172, 2.3419, 29.3339>, <-0.966, -0.170, -0.196> }
	smooth_triangle { <4.6172, 2.3419, 29.3339>, <-0.966, -0.170, -0.196>, <4.7113, 3.3116, 28.0326>, <-0.846, -0.444, -0.295>, <4.7133, 3.3319, 28.0478>, <-0.998, -0.053, 0.014> }
	smooth_triangle { <4.6172, 2.3419, 29.3339>, <-0.966, -0.170, -0.196>, <4.7133, 3.3319, 28.0478>, <-0.998, -0.053, 0.014>, <4.6192, 2.3622, 29.3491>, <-0.995, 0.097, 0.000> }
	smooth_triangle { <5.2819, 1.0364, 31.2933>, <-0.670, 0.513, 0.537>, <4.7133, 3.3319, 28.0478>, <-0.432, 0.719, 0.545>, <4.7361, 3.3399, 28.0554>, <-0.187, 0.786, 0.589> }
	smooth_triangle { <5.2819, 1.0364, 31.2933>, <-0.670, 0.513, 0.537>, <4.7361, 3.3399, 28.0554>, <-0.530, 0.667, 0.524>, <5.2969, 1.0554, 31.3009>, <-0.449, 0.645, 0.619> }
	smooth_triangle { <5.2969, 1.0554, 31.3009>, <0.295, 0.799, 0.524>, <4.7361, 3.3399, 28.0554>, <-0.038, 0.812, 0.582>, <4.7570, 3.3276, 28.0478>, <0.756, 0.544, 0.364> }
	smooth_triangle { <5.2969, 1.0554, 31.3009>, <-0.284, 0.720, 0.633>, <4.7570, 3.3276, 28.0478>, <0.470, 0.721, 0.510>, <5.3211, 1.0563, 31.2933>, <0.525, 0.743, 0.416> }
	smooth_triangle { <5.3211, 1.0563, 31.2933>, <0.958, 0.287, -0.012>, <4.7570, 3.3276, 28.0478>, <0.846, 0.443, 0.296>, <4.7551, 3.3074, 28.0326>, <0.943, -0.244, -0.226> }
	smooth_triangle { <5.3211, 1.0563, 31.2933>, <0.667, 0.664, 0.338>, <4.7551, 3.3074, 28.0326>, <0.998, 0.053, -0.014>, <5.3303, 1.0383, 31.2779>, <0.974, 0.100, -0.202> }
	smooth_triangle { <5.3303, 1.0383, 31.2779>, <0.669, -0.513, -0.537>, <4.7551, 3.3074, 28.0326>, <0.884, -0.370, -0.286>, <4.7322, 3.2994, 28.0250>, <0.187, -0.787, -0.589> }
	smooth_triangle { <5.3303, 1.0383, 31.2779>, <0.954, -0.054, -0.295>, <4.7322, 3.2994, 28.0250>, <0.530, -0.667, -0.524>, <5.3153, 1.0193, 31.2703>, <0.448, -0.644, -0.620> }
	smooth_triangle { <5.3153, 1.0193, 31.2703>, <-0.295, -0.799, -0.524>, <4.7322, 3.2994, 28.0250>, <0.037, -0.813, -0.581>, <4.7113, 3.3116, 28.0326>, <-0.756, -0.544, -0.363> }
	smooth_triangle { <5.3153, 1.0193, 31.2703>, <0.283, -0.720, -0.634>, <4.7113, 3.3116, 28.0326>, <-0.470, -0.721, -0.509>, <5.2911, 1.0184, 31.2779>, <-0.525, -0.742, -0.417> }
	smooth_triangle { <5.2911, 1.0184, 31.2779>, <-0.958, -0.287, 0.012>, <4.7113, 3.3116, 28.0326>, <-0.846, -0.444, -0.295>, <4.7133, 3.3319, 28.0478>, <-0.998, -0.053, 0.014> }
	smooth_triangle { <5.2911, 1.0184, 31.2779>, <-0.667, -0.664, -0.338>, <4.7133, 3.3319, 28.0478>, <-0.998, -0.053, 0.014>, <5.2819, 1.0364, 31.2933>, <-0.910, -0.412, -0.042> }
	smooth_triangle { <5.9512, -0.4154, 33.1349>, <-0.724, 0.359, 0.589>, <5.2819, 1.0364, 31.2933>, <-0.670, 0.513, 0.537>, <5.2969, 1.0554, 31.3009>, <-0.449, 0.645, 0.619> }
	smooth_triangle { <5.9512, -0.4154, 33.1349>, <-0.724, 0.359, 0.589>, <5.2969, 1.0554, 31.3009>, <-0.449, 0.645, 0.619>, <5.9671, -0.3974, 33.1432>, <-0.237, 0.554, 0.798> }
	smooth_triangle { <5.9671, -0.3974, 33.1432>, <-0.237, 0.554, 0.798>, <5.2969, 1.0554, 31.3009>, <-0.284, 0.720, 0.633>, <5.3211, 1.0563, 31.2933>, <0.525, 0.743, 0.416> }
	smooth_triangle { <5.9671, -0.3974, 33.1432>, <-0.237, 0.554, 0.798>, <5.3211, 1.0563, 31.2933>, <0.525, 0.743, 0.416>, <5.9911, -0.3969, 33.1349>, <0.735, 0.389, 0.554> }
	smooth_triangle { <5.9911, -0.3969, 33.1349>, <0.735, 0.389, 0.554>, <5.3211, 1.0563, 31.2933>, <0.667, 0.664, 0.338>, <5.3303, 1.0383, 31.2779>, <0.974, 0.100, -0.202> }
	smooth_triangle { <5.9911, -0.3969, 33.1349>, <0.735, 0.389, 0.554>, <5.3303, 1.0383, 31.2779>, <0.974, 0.100, -0.202>, <5.9992, -0.4144, 33.1182>, <0.953, -0.170, -0.251> }
	smooth_triangle { <5.9992, -0.4144, 33.1182>, <0.953, -0.170, -0.251>, <5.3303, 1.0383, 31.2779>, <0.954, -0.054, -0.295>, <5.3153, 1.0193, 31.2703>, <0.448, -0.644, -0.620> }
	smooth_triangle { <5.9992, -0.4144, 33.1182>, <0.953, -0.170, -0.251>, <5.3153, 1.0193, 31.2703>, <0.448, -0.644, -0.620>, <5.9832, -0.4323, 33.1099>, <0.237, -0.553, -0.799> }
	smooth_triangle { <5.9832, -0.4323, 33.1099>, <0.237, -0.553, -0.799>, <5.3153, 1.0193, 31.2703>, <0.283, -0.720, -0.634>, <5.2911, 1.0184, 31.2779>, <-0.525, -0.742, -0.417> }
	smooth_triangle { <5.9832, -0.4323, 33.1099>, <0.237, -0.553, -0.799>, <5.2911, 1.0184, 31.2779>, <-0.525, -0.742, -0.417>, <5.9592, -0.4328, 33.1182>, <-0.736, -0.386, -0.557> }
	smooth_triangle { <5.9592, -0.4328, 33.1182>, <-0.736, -0.386, -0.557>, <5.2911, 1.0184, 31.2779>, <-0.667, -0.664, -0.338>, <5.2819, 1.0364, 31.2933>, <-0.910, -0.412, -0.042> }
	smooth_triangle { <5.9592, -0.4328, 33.1182>, <-0.736, -0.386, -0.557>, <5.2819, 1.0364, 31.2933>, <-0.910, -0.412, -0.042>, <5.9512, -0.4154, 33.1349>, <-0.984, -0.065, -0.166> }
	smooth_triangle { <5.5750, -2.3240, 33.6965>, <-0.677, 0.434, 0.594>, <5.9512, -0.4154, 33.1349>, <-0.724, 0.359, 0.589>, <5.9671, -0.3974, 33.1432>, <-0.237, 0.554, 0.798> }
	smooth_triangle { <5.5750, -2.3240, 33.6965>, <-0.677, 0.434, 0.594>, <5.9671, -0.3974, 33.1432>, <-0.237, 0.554, 0.798>, <5.5973, -2.3248, 33.7087>, <0.131, 0.330, 0.935> }
	smooth_triangle { <5.5973, -2.3248, 33.7087>, <0.131, 0.330, 0.935>, <5.9671, -0.3974, 33.1432>, <-0.237, 0.554, 0.798>, <5.9911, -0.3969, 33.1349>, <0.735, 0.389, 0.554> }
	smooth_triangle { <5.5973, -2.3248, 33.7087>, <0.131, 0.330, 0.935>, <5.9911, -0.3969, 33.1349>, <0.735, 0.389, 0.554>, <5.6182, -2.3325, 33.6965>, <0.872, -0.058, 0.485> }
	smooth_triangle { <5.6182, -2.3325, 33.6965>, <0.872, -0.058, 0.485>, <5.9911, -0.3969, 33.1349>, <0.735, 0.389, 0.554>, <5.9992, -0.4144, 33.1182>, <0.980, -0.130, -0.153> }
	smooth_triangle { <5.6182, -2.3325, 33.6965>, <0.872, -0.058, 0.485>, <5.9992, -0.4144, 33.1182>, <0.953, -0.170, -0.251>, <5.6168, -2.3394, 33.6721>, <0.774, -0.408, -0.484> }
	smooth_triangle { <5.6168, -2.3394, 33.6721>, <0.774, -0.408, -0.484>, <5.9992, -0.4144, 33.1182>, <0.900, -0.188, -0.392>, <5.9832, -0.4323, 33.1099>, <0.237, -0.553, -0.799> }
	smooth_triangle { <5.6168, -2.3394, 33.6721>, <0.774, -0.408, -0.484>, <5.9832, -0.4323, 33.1099>, <0.237, -0.553, -0.799>, <5.5946, -2.3385, 33.6598>, <-0.133, -0.336, -0.932> }
	smooth_triangle { <5.5946, -2.3385, 33.6598>, <-0.133, -0.336, -0.932>, <5.9832, -0.4323, 33.1099>, <0.237, -0.553, -0.799>, <5.9592, -0.4328, 33.1182>, <-0.736, -0.386, -0.557> }
	smooth_triangle { <5.5946, -2.3385, 33.6598>, <-0.133, -0.336, -0.932>, <5.9592, -0.4328, 33.1182>, <-0.736, -0.386, -0.557>, <5.5736, -2.3308, 33.6721>, <-0.874, 0.050, -0.484> }
	smooth_triangle { <5.5736, -2.3308, 33.6721>, <-0.874, 0.050, -0.484>, <5.9592, -0.4328, 33.1182>, <-0.736, -0.386, -0.557>, <5.9512, -0.4154, 33.1349>, <-0.984, -0.065, -0.166> }
	smooth_triangle { <5.5736, -2.3308, 33.6721>, <-0.874, 0.050, -0.484>, <5.9512, -0.4154, 33.1349>, <-0.984, -0.065, -0.166>, <5.5750, -2.3240, 33.6965>, <-0.981, 0.193, 0.000> }
	smooth_triangle { <4.8920, -3.9886, 34.6267>, <-0.377, 0.560, 0.737>, <5.5750, -2.3240, 33.6965>, <-0.677, 0.434, 0.594>, <5.5973, -2.3248, 33.7087>, <0.131, 0.330, 0.935> }
	smooth_triangle { <4.8920, -3.9886, 34.6267>, <0.554, 0.204, 0.807>, <5.5973, -2.3248, 33.7087>, <0.131, 0.330, 0.935>, <5.6182, -2.3325, 33.6965>, <0.872, -0.058, 0.485> }
	smooth_triangle { <4.8920, -3.9886, 34.6267>, <0.925, -0.373, 0.070>, <5.6182, -2.3325, 33.6965>, <0.872, -0.058, 0.485>, <5.6168, -2.3394, 33.6721>, <0.774, -0.408, -0.484> }
	smooth_triangle { <4.8920, -3.9886, 34.6267>, <0.367, -0.586, -0.722>, <5.6168, -2.3394, 33.6721>, <0.774, -0.408, -0.484>, <5.5946, -2.3385, 33.6598>, <-0.133, -0.336, -0.932> }
	smooth_triangle { <4.8920, -3.9886, 34.6267>, <-0.562, -0.232, -0.794>, <5.5946, -2.3385, 33.6598>, <-0.133, -0.336, -0.932>, <5.5736, -2.3308, 33.6721>, <-0.874, 0.050, -0.484> }
	smooth_triangle { <4.8920, -3.9886, 34.6267>, <-0.937, 0.345, -0.058>, <5.5736, -2.3308, 33.6721>, <-0.874, 0.050, -0.484>, <5.5750, -2.3240, 33.6965>, <-0.677, 0.434, 0.594> }
	smooth_triangle { <5.8044, 2.3373, 28.7702>, <-0.618, -0.119, 0.777>, <4.7153, 3.3069, 28.0516>, <-0.626, -0.112, 0.772>, <4.7258, 3.3271, 28.0630>, <-0.453, 0.155, 0.878> }
	smooth_triangle { <5.8044, 2.3373, 28.7702>, <-0.618, -0.119, 0.777>, <4.7258, 3.3271, 28.0630>, <-0.453, 0.155, 0.878>, <5.8148, 2.3575, 28.7816>, <-0.199, 0.430, 0.881> }
	smooth_triangle { <5.8148, 2.3575, 28.7816>, <-0.199, 0.430, 0.881>, <4.7258, 3.3271, 28.0630>, <-0.453, 0.155, 0.878>, <4.7446, 3.3398, 28.0516>, <0.292, 0.755, 0.587> }
	smooth_triangle { <5.8148, 2.3575, 28.7816>, <-0.199, 0.430, 0.881>, <4.7446, 3.3398, 28.0516>, <0.292, 0.755, 0.587>, <5.8336, 2.3702, 28.7702>, <0.520, 0.802, 0.294> }
	smooth_triangle { <5.8336, 2.3702, 28.7702>, <0.520, 0.802, 0.294>, <4.7446, 3.3398, 28.0516>, <0.292, 0.755, 0.587>, <4.7530, 3.3323, 28.0288>, <0.745, 0.600, -0.291> }
	smooth_triangle { <5.8336, 2.3702, 28.7702>, <0.520, 0.802, 0.294>, <4.7530, 3.3323, 28.0288>, <0.745, 0.600, -0.291>, <5.8420, 2.3627, 28.7474>, <0.719, 0.372, -0.587> }
	smooth_triangle { <5.8420, 2.3627, 28.7474>, <0.719, 0.372, -0.587>, <4.7530, 3.3323, 28.0288>, <0.745, 0.600, -0.291>, <4.7425, 3.3122, 28.0174>, <0.453, -0.155, -0.878> }
	smooth_triangle { <5.8420, 2.3627, 28.7474>, <0.719, 0.372, -0.587>, <4.7425, 3.3122, 28.0174>, <0.453, -0.155, -0.878>, <5.8316, 2.3426, 28.7360>, <0.199, -0.430, -0.881> }
	smooth_triangle { <5.8316, 2.3426, 28.7360>, <0.199, -0.430, -0.881>, <4.7425, 3.3122, 28.0174>, <0.453, -0.155, -0.878>, <4.7237, 3.2995, 28.0288>, <-0.292, -0.755, -0.587> }
	smooth_triangle { <5.8316, 2.3426, 28.7360>, <0.199, -0.430, -0.881>, <4.7237, 3.2995, 28.0288>, <-0.292, -0.755, -0.587>, <5.8128, 2.3299, 28.7474>, <-0.520, -0.802, -0.294> }
	smooth_triangle { <5.8128, 2.3299, 28.7474>, <-0.520, -0.802, -0.294>, <4.7237, 3.2995, 28.0288>, <-0.292, -0.755, -0.587>, <4.7153, 3.3069, 28.0516>, <-0.674, -0.739, -0.001> }
	smooth_triangle { <5.8128, 2.3299, 28.7474>, <-0.520, -0.802, -0.294>, <4.7153, 3.3069, 28.0516>, <-0.674, -0.739, -0.001>, <5.8044, 2.3373, 28.7702>, <-0.665, -0.747, 0.000> }
	smooth_triangle { <7.3613, 0.8338, 29.8910>, <-0.686, -0.038, 0.727>, <4.7153, 3.3069, 28.0516>, <-0.626, -0.112, 0.772>, <4.7258, 3.3271, 28.0630>, <-0.453, 0.155, 0.878> }
	smooth_triangle { <7.3613, 0.8338, 29.8910>, <-0.686, -0.038, 0.727>, <4.7258, 3.3271, 28.0630>, <-0.453, 0.155, 0.878>, <7.3723, 0.8536, 29.9023>, <-0.438, 0.405, 0.803> }
	smooth_triangle { <7.3723, 0.8536, 29.9023>, <-0.438, 0.405, 0.803>, <4.7258, 3.3271, 28.0630>, <-0.453, 0.155, 0.878>, <4.7446, 3.3398, 28.0516>, <0.292, 0.755, 0.587> }
	smooth_triangle { <7.3723, 0.8536, 29.9023>, <-0.438, 0.405, 0.803>, <4.7446, 3.3398, 28.0516>, <0.292, 0.755, 0.587>, <7.3918, 0.8654, 29.8910>, <0.345, 0.861, 0.374> }
	smooth_triangle { <7.3918, 0.8654, 29.8910>, <0.345, 0.861, 0.374>, <4.7446, 3.3398, 28.0516>, <0.292, 0.755, 0.587>, <4.7530, 3.3323, 28.0288>, <0.745, 0.600, -0.291> }
	smooth_triangle { <7.3918, 0.8654, 29.8910>, <0.345, 0.861, 0.374>, <4.7530, 3.3323, 28.0288>, <0.745, 0.600, -0.291>, <7.4002, 0.8573, 29.8684>, <0.780, 0.458, -0.425> }
	smooth_triangle { <7.4002, 0.8573, 29.8684>, <0.780, 0.458, -0.425>, <4.7530, 3.3323, 28.0288>, <0.745, 0.600, -0.291>, <4.7425, 3.3122, 28.0174>, <0.453, -0.155, -0.878> }
	smooth_triangle { <7.4002, 0.8573, 29.8684>, <0.780, 0.458, -0.425>, <4.7425, 3.3122, 28.0174>, <0.453, -0.155, -0.878>, <7.3891, 0.8374, 29.8572>, <0.438, -0.404, -0.803> }
	smooth_triangle { <7.3891, 0.8374, 29.8572>, <0.438, -0.404, -0.803>, <4.7425, 3.3122, 28.0174>, <0.453, -0.155, -0.878>, <4.7237, 3.2995, 28.0288>, <-0.292, -0.755, -0.587> }
	smooth_triangle { <7.3891, 0.8374, 29.8572>, <0.438, -0.404, -0.803>, <4.7237, 3.2995, 28.0288>, <-0.292, -0.755, -0.587>, <7.3697, 0.8257, 29.8684>, <-0.345, -0.861, -0.374> }
	smooth_triangle { <7.3697, 0.8257, 29.8684>, <-0.345, -0.861, -0.374>, <4.7237, 3.2995, 28.0288>, <-0.292, -0.755, -0.587>, <4.7153, 3.3069, 28.0516>, <-0.674, -0.739, -0.001> }
	smooth_triangle { <7.3697, 0.8257, 29.8684>, <-0.345, -0.861, -0.374>, <4.7153, 3.3069, 28.0516>, <-0.674, -0.739, -0.001>, <7.3613, 0.8338, 29.8910>, <-0.661, -0.750, 0.011> }
	smooth_triangle { <8.6459, -0.2336, 31.6633>, <-0.887, -0.145, 0.439>, <7.3613, 0.8338, 29.8910>, <-0.686, -0.038, 0.727>, <7.3723, 0.8536, 29.9023>, <-0.438, 0.405, 0.803> }
	smooth_triangle { <8.6459, -0.2336, 31.6633>, <-0.887, -0.145, 0.439>, <7.3723, 0.8536, 29.9023>, <-0.438, 0.405, 0.803>, <8.6528, -0.2108, 31.6721>, <-0.544, 0.609, 0.577> }
	smooth_triangle { <8.6528, -0.2108, 31.6721>, <-0.544, 0.609, 0.577>, <7.3723, 0.8536, 29.9023>, <-0.438, 0.405, 0.803>, <7.3918, 0.8654, 29.8910>, <0.345, 0.861, 0.374> }
	smooth_triangle { <8.6528, -0.2108, 31.6721>, <-0.544, 0.609, 0.577>, <7.3918, 0.8654, 29.8910>, <0.345, 0.861, 0.374>, <8.6740, -0.1998, 31.6633>, <0.342, 0.913, 0.221> }
	smooth_triangle { <8.6740, -0.1998, 31.6633>, <0.342, 0.913, 0.221>, <7.3918, 0.8654, 29.8910>, <0.345, 0.861, 0.374>, <7.4002, 0.8573, 29.8684>, <0.780, 0.458, -0.425> }
	smooth_triangle { <8.6740, -0.1998, 31.6633>, <0.342, 0.913, 0.221>, <7.4002, 0.8573, 29.8684>, <0.780, 0.458, -0.425>, <8.6882, -0.2116, 31.6459>, <0.886, 0.296, -0.356> }
	smooth_triangle { <8.6882, -0.2116, 31.6459>, <0.886, 0.296, -0.356>, <7.4002, 0.8573, 29.8684>, <0.780, 0.458, -0.425>, <7.3891, 0.8374, 29.8572>, <0.438, -0.404, -0.803> }
	smooth_triangle { <8.6882, -0.2116, 31.6459>, <0.886, 0.296, -0.356>, <7.3891, 0.8374, 29.8572>, <0.438, -0.404, -0.803>, <8.6813, -0.2344, 31.6372>, <0.547, -0.612, -0.571> }
	smooth_triangle { <8.6813, -0.2344, 31.6372>, <0.547, -0.612, -0.571>, <7.3891, 0.8374, 29.8572>, <0.438, -0.404, -0.803>, <7.3697, 0.8257, 29.8684>, <-0.345, -0.861, -0.374> }
	smooth_triangle { <8.6813, -0.2344, 31.6372>, <0.547, -0.612, -0.571>, <7.3697, 0.8257, 29.8684>, <-0.345, -0.861, -0.374>, <8.6601, -0.2454, 31.6459>, <-0.338, -0.916, -0.214> }
	smooth_triangle { <8.6601, -0.2454, 31.6459>, <-0.338, -0.916, -0.214>, <7.3697, 0.8257, 29.8684>, <-0.345, -0.861, -0.374>, <7.3613, 0.8338, 29.8910>, <-0.661, -0.750, 0.011> }
	smooth_triangle { <8.6601, -0.2454, 31.6459>, <-0.338, -0.916, -0.214>, <7.3613, 0.8338, 29.8910>, <-0.661, -0.750, 0.011>, <8.6459, -0.2336, 31.6633>, <-0.639, -0.769, 0.000> }
	smooth_triangle { <9.3940, -0.8760, 33.8886>, <-0.927, 0.128, 0.353>, <8.6459, -0.2336, 31.6633>, <-0.887, -0.145, 0.439>, <8.6528, -0.2108, 31.6721>, <-0.544, 0.609, 0.577> }
	smooth_triangle { <9.3940, -0.8760, 33.8886>, <-0.287, 0.885, 0.367>, <8.6528, -0.2108, 31.6721>, <-0.544, 0.609, 0.577>, <8.6740, -0.1998, 31.6633>, <0.342, 0.913, 0.221> }
	smooth_triangle { <9.3940, -0.8760, 33.8886>, <0.652, 0.758, 0.024>, <8.6740, -0.1998, 31.6633>, <0.342, 0.913, 0.221>, <8.6882, -0.2116, 31.6459>, <0.886, 0.296, -0.356> }
	smooth_triangle { <9.3940, -0.8760, 33.8886>, <0.934, -0.137, -0.330>, <8.6882, -0.2116, 31.6459>, <0.886, 0.296, -0.356>, <8.6813, -0.2344, 31.6372>, <0.547, -0.612, -0.571> }
	smooth_triangle { <9.3940, -0.8760, 33.8886>, <0.297, -0.891, -0.343>, <8.6813, -0.2344, 31.6372>, <0.547, -0.612, -0.571>, <8.6601, -0.2454, 31.6459>, <-0.338, -0.916, -0.214> }
	smooth_triangle { <9.3940, -0.8760, 33.8886>, <-0.640, -0.768, -0.002>, <8.6601, -0.2454, 31.6459>, <-0.338, -0.916, -0.214>, <8.6459, -0.2336, 31.6633>, <-0.887, -0.145, 0.439> }
	smooth_triangle { <4.7993, 4.2232, 29.3902>, <0.465, -0.738, 0.488>, <4.7556, 3.3081, 28.0474>, <0.465, -0.749, 0.472>, <4.7332, 3.2987, 28.0545>, <0.177, -0.832, 0.526> }
	smooth_triangle { <4.7993, 4.2232, 29.3902>, <0.465, -0.738, 0.488>, <4.7332, 3.2987, 28.0545>, <0.177, -0.832, 0.526>, <4.7768, 4.2138, 29.3974>, <-0.227, -0.801, 0.553> }
	smooth_triangle { <4.7768, 4.2138, 29.3974>, <-0.227, -0.801, 0.553>, <4.7332, 3.2987, 28.0545>, <0.177, -0.832, 0.526>, <4.7117, 3.3102, 28.0474>, <-0.764, -0.546, 0.344> }
	smooth_triangle { <4.7768, 4.2138, 29.3974>, <-0.227, -0.801, 0.553>, <4.7117, 3.3102, 28.0474>, <-0.764, -0.546, 0.344>, <4.7553, 4.2253, 29.3902>, <-0.957, -0.225, 0.184> }
	smooth_triangle { <4.7553, 4.2253, 29.3902>, <-0.957, -0.225, 0.184>, <4.7117, 3.3102, 28.0474>, <-0.764, -0.546, 0.344>, <4.7127, 3.3312, 28.0330>, <-0.941, 0.286, -0.182> }
	smooth_triangle { <4.7553, 4.2253, 29.3902>, <-0.957, -0.225, 0.184>, <4.7127, 3.3312, 28.0330>, <-0.941, 0.286, -0.182>, <4.7563, 4.2463, 29.3759>, <-0.729, 0.576, -0.369> }
	smooth_triangle { <4.7563, 4.2463, 29.3759>, <-0.729, 0.576, -0.369>, <4.7127, 3.3312, 28.0330>, <-0.941, 0.286, -0.182>, <4.7352, 3.3406, 28.0259>, <-0.177, 0.832, -0.526> }
	smooth_triangle { <4.7563, 4.2463, 29.3759>, <-0.729, 0.576, -0.369>, <4.7352, 3.3406, 28.0259>, <-0.177, 0.832, -0.526>, <4.7788, 4.2557, 29.3687>, <0.227, 0.801, -0.553> }
	smooth_triangle { <4.7788, 4.2557, 29.3687>, <0.227, 0.801, -0.553>, <4.7352, 3.3406, 28.0259>, <-0.177, 0.832, -0.526>, <4.7566, 3.3291, 28.0330>, <0.764, 0.546, -0.344> }
	smooth_triangle { <4.7788, 4.2557, 29.3687>, <0.227, 0.801, -0.553>, <4.7566, 3.3291, 28.0330>, <0.764, 0.546, -0.344>, <4.8003, 4.2442, 29.3759>, <0.957, 0.225, -0.184> }
	smooth_triangle { <4.8003, 4.2442, 29.3759>, <0.957, 0.225, -0.184>, <4.7566, 3.3291, 28.0330>, <0.764, 0.546, -0.344>, <4.7556, 3.3081, 28.0474>, <1.000, 0.000, 0.001> }
	smooth_triangle { <4.8003, 4.2442, 29.3759>, <0.957, 0.225, -0.184>, <4.7556, 3.3081, 28.0474>, <1.000, 0.000, 0.001>, <4.7993, 4.2232, 29.3902>, <0.999, -0.048, 0.000> }
	smooth_triangle { <4.6488, 5.3482, 31.5487>, <0.556, -0.723, 0.410>, <4.7556, 3.3081, 28.0474>, <0.465, -0.749, 0.472>, <4.7332, 3.2987, 28.0545>, <0.177, -0.832, 0.526> }
	smooth_triangle { <4.6488, 5.3482, 31.5487>, <0.556, -0.723, 0.410>, <4.7332, 3.2987, 28.0545>, <0.177, -0.832, 0.526>, <4.6285, 5.3341, 31.5546>, <0.065, -0.877, 0.475> }
	smooth_triangle { <4.6285, 5.3341, 31.5546>, <0.065, -0.877, 0.475>, <4.7332, 3.2987, 28.0545>, <0.177, -0.832, 0.526>, <4.7117, 3.3102, 28.0474>, <-0.764, -0.546, 0.344> }
	smooth_triangle { <4.6285, 5.3341, 31.5546>, <0.065, -0.877, 0.475>, <4.7117, 3.3102, 28.0474>, <-0.764, -0.546, 0.344>, <4.6052, 5.3423, 31.5487>, <-0.831, -0.491, 0.260> }
	smooth_triangle { <4.6052, 5.3423, 31.5487>, <-0.831, -0.491, 0.260>, <4.7117, 3.3102, 28.0474>, <-0.764, -0.546, 0.344>, <4.7127, 3.3312, 28.0330>, <-0.941, 0.286, -0.182> }
	smooth_triangle { <4.6052, 5.3423, 31.5487>, <-0.831, -0.491, 0.260>, <4.7127, 3.3312, 28.0330>, <-0.941, 0.286, -0.182>, <4.6022, 5.3646, 31.5369>, <-0.897, 0.386, -0.216> }
	smooth_triangle { <4.6022, 5.3646, 31.5369>, <-0.897, 0.386, -0.216>, <4.7127, 3.3312, 28.0330>, <-0.941, 0.286, -0.182>, <4.7352, 3.3406, 28.0259>, <-0.177, 0.832, -0.526> }
	smooth_triangle { <4.6022, 5.3646, 31.5369>, <-0.897, 0.386, -0.216>, <4.7352, 3.3406, 28.0259>, <-0.177, 0.832, -0.526>, <4.6225, 5.3787, 31.5310>, <-0.065, 0.877, -0.476> }
	smooth_triangle { <4.6225, 5.3787, 31.5310>, <-0.065, 0.877, -0.476>, <4.7352, 3.3406, 28.0259>, <-0.177, 0.832, -0.526>, <4.7566, 3.3291, 28.0330>, <0.764, 0.546, -0.344> }
	smooth_triangle { <4.6225, 5.3787, 31.5310>, <-0.065, 0.877, -0.476>, <4.7566, 3.3291, 28.0330>, <0.764, 0.546, -0.344>, <4.6458, 5.3705, 31.5369>, <0.831, 0.491, -0.260> }
	smooth_triangle { <4.6458, 5.3705, 31.5369>, <0.831, 0.491, -0.260>, <4.7566, 3.3291, 28.0330>, <0.764, 0.546, -0.344>, <4.7556, 3.3081, 28.0474>, <1.000, 0.000, 0.001> }
	smooth_triangle { <4.6458, 5.3705, 31.5369>, <0.831, 0.491, -0.260>, <4.7556, 3.3081, 28.0474>, <1.000, 0.000, 0.001>, <4.6488, 5.3482, 31.5487>, <0.998, 0.054, -0.037> }
	smooth_triangle { <4.7031, 6.4626, 33.7146>, <0.496, -0.849, 0.183>, <4.6488, 5.3482, 31.5487>, <0.556, -0.723, 0.410>, <4.6285, 5.3341, 31.5546>, <0.065, -0.877, 0.475> }
	smooth_triangle { <4.7031, 6.4626, 33.7146>, <0.496, -0.849, 0.183>, <4.6285, 5.3341, 31.5546>, <0.065, -0.877, 0.475>, <4.6806, 6.4524, 33.7205>, <-0.130, -0.976, 0.173> }
	smooth_triangle { <4.6806, 6.4524, 33.7205>, <-0.130, -0.976, 0.173>, <4.6285, 5.3341, 31.5546>, <0.065, -0.877, 0.475>, <4.6052, 5.3423, 31.5487>, <-0.831, -0.491, 0.260> }
	smooth_triangle { <4.6806, 6.4524, 33.7205>, <-0.130, -0.976, 0.173>, <4.6052, 5.3423, 31.5487>, <-0.831, -0.491, 0.260>, <4.6592, 6.4648, 33.7146>, <-0.925, -0.378, 0.042> }
	smooth_triangle { <4.6592, 6.4648, 33.7146>, <-0.925, -0.378, 0.042>, <4.6052, 5.3423, 31.5487>, <-0.831, -0.491, 0.260>, <4.6022, 5.3646, 31.5369>, <-0.897, 0.386, -0.216> }
	smooth_triangle { <4.6592, 6.4648, 33.7146>, <-0.925, -0.378, 0.042>, <4.6022, 5.3646, 31.5369>, <-0.897, 0.386, -0.216>, <4.6603, 6.4873, 33.7030>, <-0.800, 0.588, -0.121> }
	smooth_triangle { <4.6603, 6.4873, 33.7030>, <-0.800, 0.588, -0.121>, <4.6022, 5.3646, 31.5369>, <-0.897, 0.386, -0.216>, <4.6225, 5.3787, 31.5310>, <-0.065, 0.877, -0.476> }
	smooth_triangle { <4.6603, 6.4873, 33.7030>, <-0.800, 0.588, -0.121>, <4.6225, 5.3787, 31.5310>, <-0.065, 0.877, -0.476>, <4.6828, 6.4975, 33.6971>, <0.130, 0.979, -0.155> }
	smooth_triangle { <4.6828, 6.4975, 33.6971>, <0.130, 0.979, -0.155>, <4.6225, 5.3787, 31.5310>, <-0.065, 0.877, -0.476>, <4.6458, 5.3705, 31.5369>, <0.831, 0.491, -0.260> }
	smooth_triangle { <4.6828, 6.4975, 33.6971>, <0.130, 0.979, -0.155>, <4.6458, 5.3705, 31.5369>, <0.831, 0.491, -0.260>, <4.7042, 6.4851, 33.7030>, <0.923, 0.385, -0.019> }
	smooth_triangle { <4.7042, 6.4851, 33.7030>, <0.923, 0.385, -0.019>, <4.6458, 5.3705, 31.5369>, <0.831, 0.491, -0.260>, <4.6488, 5.3482, 31.5487>, <0.998, 0.054, -0.037> }
	smooth_triangle { <4.7042, 6.4851, 33.7030>, <0.923, 0.385, -0.019>, <4.6488, 5.3482, 31.5487>, <0.998, 0.054, -0.037>, <4.7031, 6.4626, 33.7146>, <0.999, -0.028, 0.043> }
	smooth_triangle { <4.5383, 5.9084, 35.6551>, <0.350, -0.908, -0.230>, <4.7031, 6.4626, 33.7146>, <0.496, -0.849, 0.183>, <4.6806, 6.4524, 33.7205>, <-0.130, -0.976, 0.173> }
	smooth_triangle { <4.5383, 5.9084, 35.6551>, <-0.305, 0.944, 0.127>, <4.6806, 6.4524, 33.7205>, <-0.315, 0.919, 0.235>, <4.5623, 5.9157, 35.6588>, <0.302, 0.924, 0.236> }
	smooth_triangle { <4.5623, 5.9157, 35.6588>, <-0.427, -0.864, -0.265>, <4.6806, 6.4524, 33.7205>, <-0.130, -0.976, 0.173>, <4.6592, 6.4648, 33.7146>, <-0.925, -0.378, 0.042> }
	smooth_triangle { <4.5623, 5.9157, 35.6588>, <0.302, 0.924, 0.236>, <4.6592, 6.4648, 33.7146>, <0.663, 0.711, 0.234>, <4.5813, 5.8992, 35.6551>, <0.958, 0.171, 0.231> }
	smooth_triangle { <4.5813, 5.8992, 35.6551>, <-0.999, 0.035, -0.030>, <4.6592, 6.4648, 33.7146>, <-0.925, -0.378, 0.042>, <4.6603, 6.4873, 33.7030>, <-0.800, 0.588, -0.121> }
	smooth_triangle { <4.5813, 5.8992, 35.6551>, <0.958, 0.171, 0.231>, <4.6603, 6.4873, 33.7030>, <0.979, -0.202, -0.021>, <4.5763, 5.8755, 35.6477>, <0.657, -0.754, -0.014> }
	smooth_triangle { <4.5763, 5.8755, 35.6477>, <-0.337, 0.902, 0.269>, <4.6603, 6.4873, 33.7030>, <-0.800, 0.588, -0.121>, <4.6828, 6.4975, 33.6971>, <0.130, 0.979, -0.155> }
	smooth_triangle { <4.5763, 5.8755, 35.6477>, <0.657, -0.754, -0.014>, <4.6828, 6.4975, 33.6971>, <0.317, -0.908, -0.272>, <4.5522, 5.8682, 35.6439>, <-0.301, -0.919, -0.254> }
	smooth_triangle { <4.5522, 5.8682, 35.6439>, <0.413, 0.858, 0.305>, <4.6828, 6.4975, 33.6971>, <0.130, 0.979, -0.155>, <4.7042, 6.4851, 33.7030>, <0.923, 0.385, -0.019> }
	smooth_triangle { <4.5522, 5.8682, 35.6439>, <-0.301, -0.919, -0.254>, <4.7042, 6.4851, 33.7030>, <-0.660, -0.699, -0.274>, <4.5332, 5.8846, 35.6477>, <-0.954, -0.164, -0.250> }
	smooth_triangle { <4.5332, 5.8846, 35.6477>, <0.996, -0.006, 0.086>, <4.7042, 6.4851, 33.7030>, <0.923, 0.385, -0.019>, <4.7031, 6.4626, 33.7146>, <0.999, -0.028, 0.043> }
	smooth_triangle { <4.5332, 5.8846, 35.6477>, <-0.954, -0.164, -0.250>, <4.7031, 6.4626, 33.7146>, <-0.976, 0.215, -0.021>, <4.5383, 5.9084, 35.6551>, <-0.839, 0.534, -0.102> }
	smooth_triangle { <3.9748, 5.7023, 37.5890>, <0.352, 0.922, 0.162>, <4.5383, 5.9084, 35.6551>, <-0.305, 0.944, 0.127>, <4.5623, 5.9157, 35.6588>, <0.302, 0.924, 0.236> }
	smooth_triangle { <3.9748, 5.7023, 37.5890>, <0.352, 0.922, 0.162>, <4.5623, 5.9157, 35.6588>, <0.302, 0.924, 0.236>, <3.9937, 5.6858, 37.5929>, <0.878, 0.431, 0.209> }
	smooth_triangle { <3.9937, 5.6858, 37.5929>, <0.878, 0.431, 0.209>, <4.5623, 5.9157, 35.6588>, <0.302, 0.924, 0.236>, <4.5813, 5.8992, 35.6551>, <0.958, 0.171, 0.231> }
	smooth_triangle { <3.9937, 5.6858, 37.5929>, <0.878, 0.431, 0.209>, <4.5813, 5.8992, 35.6551>, <0.958, 0.171, 0.231>, <3.9899, 5.6610, 37.5890>, <0.825, -0.561, 0.065> }
	smooth_triangle { <3.9899, 5.6610, 37.5890>, <0.825, -0.561, 0.065>, <4.5813, 5.8992, 35.6551>, <0.958, 0.171, 0.231>, <4.5763, 5.8755, 35.6477>, <0.657, -0.754, -0.014> }
	smooth_triangle { <3.9899, 5.6610, 37.5890>, <0.825, -0.561, 0.065>, <4.5763, 5.8755, 35.6477>, <0.657, -0.754, -0.014>, <3.9672, 5.6527, 37.5812>, <-0.049, -0.990, -0.132> }
	smooth_triangle { <3.9672, 5.6527, 37.5812>, <-0.049, -0.990, -0.132>, <4.5763, 5.8755, 35.6477>, <0.657, -0.754, -0.014>, <4.5522, 5.8682, 35.6439>, <-0.301, -0.919, -0.254> }
	smooth_triangle { <3.9672, 5.6527, 37.5812>, <-0.049, -0.990, -0.132>, <4.5522, 5.8682, 35.6439>, <-0.301, -0.919, -0.254>, <3.9483, 5.6692, 37.5773>, <-0.881, -0.433, -0.192> }
	smooth_triangle { <3.9483, 5.6692, 37.5773>, <-0.881, -0.433, -0.192>, <4.5522, 5.8682, 35.6439>, <-0.301, -0.919, -0.254>, <4.5332, 5.8846, 35.6477>, <-0.954, -0.164, -0.250> }
	smooth_triangle { <3.9483, 5.6692, 37.5773>, <-0.881, -0.433, -0.192>, <4.5332, 5.8846, 35.6477>, <-0.954, -0.164, -0.250>, <3.9521, 5.6940, 37.5812>, <-0.828, 0.559, -0.050> }
	smooth_triangle { <3.9521, 5.6940, 37.5812>, <-0.828, 0.559, -0.050>, <4.5332, 5.8846, 35.6477>, <-0.954, -0.164, -0.250>, <4.5383, 5.9084, 35.6551>, <-0.839, 0.534, -0.102> }
	smooth_triangle { <3.9521, 5.6940, 37.5812>, <-0.828, 0.559, -0.050>, <4.5383, 5.9084, 35.6551>, <-0.839, 0.534, -0.102>, <3.9748, 5.7023, 37.5890>, <-0.374, 0.921, 0.109> }
	smooth_triangle { <4.0095, 5.3599, 39.1791>, <0.633, 0.760, 0.150>, <3.9748, 5.7023, 37.5890>, <0.352, 0.922, 0.162>, <3.9937, 5.6858, 37.5929>, <0.878, 0.431, 0.209> }
	smooth_triangle { <4.0095, 5.3599, 39.1791>, <-0.862, 0.479, 0.165>, <3.9937, 5.6858, 37.5929>, <-0.651, 0.742, 0.159>, <4.0287, 5.3762, 39.1817>, <-0.181, 0.924, 0.337> }
	smooth_triangle { <4.0287, 5.3762, 39.1817>, <0.988, -0.143, -0.050>, <3.9937, 5.6858, 37.5929>, <0.878, 0.431, 0.209>, <3.9899, 5.6610, 37.5890>, <0.825, -0.561, 0.065> }
	smooth_triangle { <4.0287, 5.3762, 39.1817>, <-0.181, 0.924, 0.337>, <3.9899, 5.6610, 37.5890>, <0.331, 0.930, 0.158>, <4.0527, 5.3681, 39.1791>, <0.762, 0.612, 0.213> }
	smooth_triangle { <4.0527, 5.3681, 39.1791>, <0.392, -0.902, -0.182>, <3.9899, 5.6610, 37.5890>, <0.825, -0.561, 0.065>, <3.9672, 5.6527, 37.5812>, <-0.049, -0.990, -0.132> }
	smooth_triangle { <4.0527, 5.3681, 39.1791>, <0.762, 0.612, 0.213>, <3.9672, 5.6527, 37.5812>, <0.981, 0.192, -0.018>, <4.0574, 5.3437, 39.1739>, <0.942, -0.312, -0.126> }
	smooth_triangle { <4.0574, 5.3437, 39.1739>, <-0.641, -0.760, -0.111>, <3.9672, 5.6527, 37.5812>, <-0.049, -0.990, -0.132>, <3.9483, 5.6692, 37.5773>, <-0.881, -0.433, -0.192> }
	smooth_triangle { <4.0574, 5.3437, 39.1739>, <0.942, -0.312, -0.126>, <3.9483, 5.6692, 37.5773>, <0.650, -0.735, -0.194>, <4.0381, 5.3274, 39.1714>, <0.180, -0.922, -0.342> }
	smooth_triangle { <4.0381, 5.3274, 39.1714>, <-0.987, 0.138, 0.085>, <3.9483, 5.6692, 37.5773>, <-0.881, -0.433, -0.192>, <3.9521, 5.6940, 37.5812>, <-0.828, 0.559, -0.050> }
	smooth_triangle { <4.0381, 5.3274, 39.1714>, <0.180, -0.922, -0.342>, <3.9521, 5.6940, 37.5812>, <-0.332, -0.923, -0.195>, <4.0141, 5.3354, 39.1739>, <-0.761, -0.611, -0.219> }
	smooth_triangle { <4.0141, 5.3354, 39.1739>, <-0.400, 0.891, 0.216>, <3.9521, 5.6940, 37.5812>, <-0.828, 0.559, -0.050>, <3.9748, 5.7023, 37.5890>, <-0.374, 0.921, 0.109> }
	smooth_triangle { <4.0141, 5.3354, 39.1739>, <-0.761, -0.611, -0.219>, <3.9748, 5.7023, 37.5890>, <-0.983, -0.184, -0.018>, <4.0095, 5.3599, 39.1791>, <-0.983, -0.184, -0.018> }
	smooth_triangle { <4.0019, 4.5754, 40.6044>, <-0.643, 0.669, 0.372>, <4.0095, 5.3599, 39.1791>, <-0.862, 0.479, 0.165>, <4.0287, 5.3762, 39.1817>, <-0.181, 0.924, 0.337> }
	smooth_triangle { <4.0019, 4.5754, 40.6044>, <0.332, 0.816, 0.473>, <4.0287, 5.3762, 39.1817>, <-0.181, 0.924, 0.337>, <4.0527, 5.3681, 39.1791>, <0.762, 0.612, 0.213> }
	smooth_triangle { <4.0019, 4.5754, 40.6044>, <0.981, 0.147, 0.124>, <4.0527, 5.3681, 39.1791>, <0.762, 0.612, 0.213>, <4.0574, 5.3437, 39.1739>, <0.942, -0.312, -0.126> }
	smooth_triangle { <4.0019, 4.5754, 40.6044>, <0.646, -0.686, -0.336>, <4.0574, 5.3437, 39.1739>, <0.942, -0.312, -0.126>, <4.0381, 5.3274, 39.1714>, <0.180, -0.922, -0.342> }
	smooth_triangle { <4.0019, 4.5754, 40.6044>, <-0.334, -0.834, -0.439>, <4.0381, 5.3274, 39.1714>, <0.180, -0.922, -0.342>, <4.0141, 5.3354, 39.1739>, <-0.761, -0.611, -0.219> }
	smooth_triangle { <4.0019, 4.5754, 40.6044>, <-0.983, -0.161, -0.086>, <4.0141, 5.3354, 39.1739>, <-0.761, -0.611, -0.219>, <4.0095, 5.3599, 39.1791>, <-0.862, 0.479, 0.165> }
	smooth_triangle { <4.7979, 2.7295, 25.9641>, <-0.452, -0.318, 0.833>, <3.4381, 3.5024, 25.5208>, <-0.413, -0.340, 0.845>, <3.4460, 3.5232, 25.5331>, <-0.263, -0.066, 0.963> }
	smooth_triangle { <4.7979, 2.7295, 25.9641>, <-0.452, -0.318, 0.833>, <3.4460, 3.5232, 25.5331>, <-0.263, -0.066, 0.963>, <4.8057, 2.7503, 25.9763>, <-0.139, 0.297, 0.945> }
	smooth_triangle { <4.8057, 2.7503, 25.9763>, <-0.139, 0.297, 0.945>, <3.4460, 3.5232, 25.5331>, <-0.263, -0.066, 0.963>, <3.4599, 3.5406, 25.5208>, <0.302, 0.698, 0.649> }
	smooth_triangle { <4.8057, 2.7503, 25.9763>, <-0.139, 0.297, 0.945>, <3.4599, 3.5406, 25.5208>, <0.302, 0.698, 0.649>, <4.8196, 2.7677, 25.9641>, <0.389, 0.866, 0.315> }
	smooth_triangle { <4.8196, 2.7677, 25.9641>, <0.389, 0.866, 0.315>, <3.4599, 3.5406, 25.5208>, <0.302, 0.698, 0.649>, <3.4659, 3.5372, 25.4964>, <0.564, 0.764, -0.314> }
	smooth_triangle { <4.8196, 2.7677, 25.9641>, <0.389, 0.866, 0.315>, <3.4659, 3.5372, 25.4964>, <0.564, 0.764, -0.314>, <4.8256, 2.7643, 25.9396>, <0.529, 0.569, -0.630> }
	smooth_triangle { <4.8256, 2.7643, 25.9396>, <0.529, 0.569, -0.630>, <3.4659, 3.5372, 25.4964>, <0.564, 0.764, -0.314>, <3.4580, 3.5164, 25.4842>, <0.263, 0.066, -0.963> }
	smooth_triangle { <4.8256, 2.7643, 25.9396>, <0.529, 0.569, -0.630>, <3.4580, 3.5164, 25.4842>, <0.263, 0.066, -0.963>, <4.8178, 2.7435, 25.9274>, <0.139, -0.297, -0.945> }
	smooth_triangle { <4.8178, 2.7435, 25.9274>, <0.139, -0.297, -0.945>, <3.4580, 3.5164, 25.4842>, <0.263, 0.066, -0.963>, <3.4442, 3.4989, 25.4964>, <-0.302, -0.698, -0.649> }
	smooth_triangle { <4.8178, 2.7435, 25.9274>, <0.139, -0.297, -0.945>, <3.4442, 3.4989, 25.4964>, <-0.302, -0.698, -0.649>, <4.8039, 2.7261, 25.9396>, <-0.389, -0.866, -0.315> }
	smooth_triangle { <4.8039, 2.7261, 25.9396>, <-0.389, -0.866, -0.315>, <3.4442, 3.4989, 25.4964>, <-0.302, -0.698, -0.649>, <3.4381, 3.5024, 25.5208>, <-0.540, -0.841, -0.007> }
	smooth_triangle { <4.8039, 2.7261, 25.9396>, <-0.389, -0.866, -0.315>, <3.4381, 3.5024, 25.5208>, <-0.540, -0.841, -0.007>, <4.7979, 2.7295, 25.9641>, <-0.494, -0.869, 0.000> }
	smooth_triangle { <6.9969, 0.9254, 25.9813>, <-0.327, -0.386, 0.863>, <3.4381, 3.5024, 25.5208>, <-0.413, -0.340, 0.845>, <3.4460, 3.5232, 25.5331>, <-0.263, -0.066, 0.963> }
	smooth_triangle { <6.9969, 0.9254, 25.9813>, <-0.327, -0.386, 0.863>, <3.4460, 3.5232, 25.5331>, <-0.263, -0.066, 0.963>, <7.0108, 0.9425, 25.9940>, <-0.035, 0.024, 0.999> }
	smooth_triangle { <7.0108, 0.9425, 25.9940>, <-0.035, 0.024, 0.999>, <3.4460, 3.5232, 25.5331>, <-0.263, -0.066, 0.963>, <3.4599, 3.5406, 25.5208>, <0.302, 0.698, 0.649> }
	smooth_triangle { <7.0108, 0.9425, 25.9940>, <-0.035, 0.024, 0.999>, <3.4599, 3.5406, 25.5208>, <0.302, 0.698, 0.649>, <7.0248, 0.9595, 25.9813>, <0.445, 0.742, 0.502> }
	smooth_triangle { <7.0248, 0.9595, 25.9813>, <0.445, 0.742, 0.502>, <3.4599, 3.5406, 25.5208>, <0.302, 0.698, 0.649>, <3.4659, 3.5372, 25.4964>, <0.564, 0.764, -0.314> }
	smooth_triangle { <7.0248, 0.9595, 25.9813>, <0.445, 0.742, 0.502>, <3.4659, 3.5372, 25.4964>, <0.564, 0.764, -0.314>, <7.0249, 0.9594, 25.9559>, <0.482, 0.721, -0.499> }
	smooth_triangle { <7.0249, 0.9594, 25.9559>, <0.482, 0.721, -0.499>, <3.4659, 3.5372, 25.4964>, <0.564, 0.764, -0.314>, <3.4580, 3.5164, 25.4842>, <0.263, 0.066, -0.963> }
	smooth_triangle { <7.0249, 0.9594, 25.9559>, <0.482, 0.721, -0.499>, <3.4580, 3.5164, 25.4842>, <0.263, 0.066, -0.963>, <7.0110, 0.9423, 25.9432>, <0.035, -0.024, -0.999> }
	smooth_triangle { <7.0110, 0.9423, 25.9432>, <0.035, -0.024, -0.999>, <3.4580, 3.5164, 25.4842>, <0.263, 0.066, -0.963>, <3.4442, 3.4989, 25.4964>, <-0.302, -0.698, -0.649> }
	smooth_triangle { <7.0110, 0.9423, 25.9432>, <0.035, -0.024, -0.999>, <3.4442, 3.4989, 25.4964>, <-0.302, -0.698, -0.649>, <6.9970, 0.9253, 25.9559>, <-0.445, -0.741, -0.502> }
	smooth_triangle { <6.9970, 0.9253, 25.9559>, <-0.445, -0.741, -0.502>, <3.4442, 3.4989, 25.4964>, <-0.302, -0.698, -0.649>, <3.4381, 3.5024, 25.5208>, <-0.540, -0.841, -0.007> }
	smooth_triangle { <6.9970, 0.9253, 25.9559>, <-0.445, -0.741, -0.502>, <3.4381, 3.5024, 25.5208>, <-0.540, -0.841, -0.007>, <6.9969, 0.9254, 25.9813>, <-0.508, -0.861, 0.001> }
	smooth_triangle { <9.1571, -0.2150, 25.9975>, <-0.310, -0.622, 0.719>, <6.9969, 0.9254, 25.9813>, <-0.327, -0.386, 0.863>, <7.0108, 0.9425, 25.9940>, <-0.035, 0.024, 0.999> }
	smooth_triangle { <9.1571, -0.2150, 25.9975>, <-0.310, -0.622, 0.719>, <7.0108, 0.9425, 25.9940>, <-0.035, 0.024, 0.999>, <9.1673, -0.1955, 26.0102>, <0.052, 0.105, 0.993> }
	smooth_triangle { <9.1673, -0.1955, 26.0102>, <0.052, 0.105, 0.993>, <7.0108, 0.9425, 25.9940>, <-0.035, 0.024, 0.999>, <7.0248, 0.9595, 25.9813>, <0.445, 0.742, 0.502> }
	smooth_triangle { <9.1673, -0.1955, 26.0102>, <0.052, 0.105, 0.993>, <7.0248, 0.9595, 25.9813>, <0.445, 0.742, 0.502>, <9.1776, -0.1761, 25.9975>, <0.417, 0.817, 0.397> }
	smooth_triangle { <9.1776, -0.1761, 25.9975>, <0.417, 0.817, 0.397>, <7.0248, 0.9595, 25.9813>, <0.445, 0.742, 0.502>, <7.0249, 0.9594, 25.9559>, <0.482, 0.721, -0.499> }
	smooth_triangle { <9.1776, -0.1761, 25.9975>, <0.417, 0.817, 0.397>, <7.0249, 0.9594, 25.9559>, <0.482, 0.721, -0.499>, <9.1777, -0.1762, 25.9721>, <0.370, 0.713, -0.595> }
	smooth_triangle { <9.1777, -0.1762, 25.9721>, <0.370, 0.713, -0.595>, <7.0249, 0.9594, 25.9559>, <0.482, 0.721, -0.499>, <7.0110, 0.9423, 25.9432>, <0.035, -0.024, -0.999> }
	smooth_triangle { <9.1777, -0.1762, 25.9721>, <0.370, 0.713, -0.595>, <7.0110, 0.9423, 25.9432>, <0.035, -0.024, -0.999>, <9.1676, -0.1957, 25.9594>, <-0.045, -0.109, -0.993> }
	smooth_triangle { <9.1676, -0.1957, 25.9594>, <-0.045, -0.109, -0.993>, <7.0110, 0.9423, 25.9432>, <0.035, -0.024, -0.999>, <6.9970, 0.9253, 25.9559>, <-0.445, -0.741, -0.502> }
	smooth_triangle { <9.1676, -0.1957, 25.9594>, <-0.045, -0.109, -0.993>, <6.9970, 0.9253, 25.9559>, <-0.445, -0.741, -0.502>, <9.1572, -0.2151, 25.9721>, <-0.410, -0.821, -0.397> }
	smooth_triangle { <9.1572, -0.2151, 25.9721>, <-0.410, -0.821, -0.397>, <6.9970, 0.9253, 25.9559>, <-0.445, -0.741, -0.502>, <6.9969, 0.9254, 25.9813>, <-0.508, -0.861, 0.001> }
	smooth_triangle { <9.1572, -0.2151, 25.9721>, <-0.410, -0.821, -0.397>, <6.9969, 0.9254, 25.9813>, <-0.508, -0.861, 0.001>, <9.1571, -0.2150, 25.9975>, <-0.467, -0.884, 0.000> }
	smooth_triangle { <11.3673, -1.2471, 26.0037>, <-0.209, -0.454, 0.866>, <9.1571, -0.2150, 25.9975>, <-0.310, -0.622, 0.719>, <9.1673, -0.1955, 26.0102>, <0.052, 0.105, 0.993> }
	smooth_triangle { <11.3673, -1.2471, 26.0037>, <0.222, 0.448, 0.866>, <9.1673, -0.1955, 26.0102>, <0.052, 0.105, 0.993>, <9.1776, -0.1761, 25.9975>, <0.417, 0.817, 0.397> }
	smooth_triangle { <11.3673, -1.2471, 26.0037>, <0.443, 0.896, 0.000>, <9.1776, -0.1761, 25.9975>, <0.417, 0.817, 0.397>, <9.1777, -0.1762, 25.9721>, <0.370, 0.713, -0.595> }
	smooth_triangle { <11.3673, -1.2471, 26.0037>, <0.234, 0.442, -0.866>, <9.1777, -0.1762, 25.9721>, <0.370, 0.713, -0.595>, <9.1676, -0.1957, 25.9594>, <-0.045, -0.109, -0.993> }
	smooth_triangle { <11.3673, -1.2471, 26.0037>, <-0.198, -0.460, -0.866>, <9.1676, -0.1957, 25.9594>, <-0.045, -0.109, -0.993>, <9.1572, -0.2151, 25.9721>, <-0.410, -0.821, -0.397> }
	smooth_triangle { <11.3673, -1.2471, 26.0037>, <-0.419, -0.908, 0.000>, <9.1572, -0.2151, 25.9721>, <-0.410, -0.821, -0.397>, <9.1571, -0.2150, 25.9975>, <-0.310, -0.622, 0.719> }
	smooth_triangle { <4.0340, 2.2803, 26.3851>, <-0.652, 0.194, 0.733>, <3.4293, 3.5162, 25.5194>, <-0.574, 0.055, 0.817>, <3.4461, 3.5319, 25.5301>, <-0.324, 0.229, 0.918> }
	smooth_triangle { <4.0340, 2.2803, 26.3851>, <-0.652, 0.194, 0.733>, <3.4461, 3.5319, 25.5301>, <-0.324, 0.229, 0.918>, <4.0508, 2.2960, 26.3958>, <-0.060, 0.553, 0.831> }
	smooth_triangle { <4.0508, 2.2960, 26.3958>, <-0.060, 0.553, 0.831>, <3.4461, 3.5319, 25.5301>, <-0.324, 0.229, 0.918>, <3.4688, 3.5355, 25.5194>, <0.570, 0.557, 0.605> }
	smooth_triangle { <4.0508, 2.2960, 26.3958>, <-0.060, 0.553, 0.831>, <3.4688, 3.5355, 25.5194>, <0.570, 0.557, 0.605>, <4.0735, 2.2996, 26.3851>, <0.772, 0.572, 0.277> }
	smooth_triangle { <4.0735, 2.2996, 26.3851>, <0.772, 0.572, 0.277>, <3.4688, 3.5355, 25.5194>, <0.570, 0.557, 0.605>, <3.4748, 3.5234, 25.4979>, <0.892, 0.328, -0.311> }
	smooth_triangle { <4.0735, 2.2996, 26.3851>, <0.772, 0.572, 0.277>, <3.4748, 3.5234, 25.4979>, <0.892, 0.328, -0.311>, <4.0795, 2.2875, 26.3636>, <0.832, 0.019, -0.554> }
	smooth_triangle { <4.0795, 2.2875, 26.3636>, <0.832, 0.019, -0.554>, <3.4748, 3.5234, 25.4979>, <0.892, 0.328, -0.311>, <3.4580, 3.5076, 25.4871>, <0.324, -0.229, -0.918> }
	smooth_triangle { <4.0795, 2.2875, 26.3636>, <0.832, 0.019, -0.554>, <3.4580, 3.5076, 25.4871>, <0.324, -0.229, -0.918>, <4.0627, 2.2717, 26.3528>, <0.060, -0.553, -0.831> }
	smooth_triangle { <4.0627, 2.2717, 26.3528>, <0.060, -0.553, -0.831>, <3.4580, 3.5076, 25.4871>, <0.324, -0.229, -0.918>, <3.4352, 3.5040, 25.4979>, <-0.570, -0.556, -0.605> }
	smooth_triangle { <4.0627, 2.2717, 26.3528>, <0.060, -0.553, -0.831>, <3.4352, 3.5040, 25.4979>, <-0.570, -0.556, -0.605>, <4.0400, 2.2681, 26.3636>, <-0.772, -0.572, -0.277> }
	smooth_triangle { <4.0400, 2.2681, 26.3636>, <-0.772, -0.572, -0.277>, <3.4352, 3.5040, 25.4979>, <-0.570, -0.556, -0.605>, <3.4293, 3.5162, 25.5194>, <-0.889, -0.458, 0.006> }
	smooth_triangle { <4.0400, 2.2681, 26.3636>, <-0.772, -0.572, -0.277>, <3.4293, 3.5162, 25.5194>, <-0.889, -0.458, 0.006>, <4.0340, 2.2803, 26.3851>, <-0.898, -0.440, 0.000> }
	smooth_triangle { <5.4505, -0.1935, 26.2580>, <-0.474, -0.146, 0.868>, <3.4293, 3.5162, 25.5194>, <-0.574, 0.055, 0.817>, <3.4461, 3.5319, 25.5301>, <-0.324, 0.229, 0.918> }
	smooth_triangle { <5.4505, -0.1935, 26.2580>, <-0.474, -0.146, 0.868>, <3.4461, 3.5319, 25.5301>, <-0.324, 0.229, 0.918>, <5.4699, -0.1830, 26.2707>, <-0.046, 0.076, 0.996> }
	smooth_triangle { <5.4699, -0.1830, 26.2707>, <-0.046, 0.076, 0.996>, <3.4461, 3.5319, 25.5301>, <-0.324, 0.229, 0.918>, <3.4688, 3.5355, 25.5194>, <0.570, 0.557, 0.605> }
	smooth_triangle { <5.4699, -0.1830, 26.2707>, <-0.046, 0.076, 0.996>, <3.4688, 3.5355, 25.5194>, <0.570, 0.557, 0.605>, <5.4887, -0.1716, 26.2580>, <0.741, 0.452, 0.496> }
	smooth_triangle { <5.4887, -0.1716, 26.2580>, <0.741, 0.452, 0.496>, <3.4688, 3.5355, 25.5194>, <0.570, 0.557, 0.605>, <3.4748, 3.5234, 25.4979>, <0.892, 0.328, -0.311> }
	smooth_triangle { <5.4887, -0.1716, 26.2580>, <0.741, 0.452, 0.496>, <3.4748, 3.5234, 25.4979>, <0.892, 0.328, -0.311>, <5.4881, -0.1706, 26.2326>, <0.780, 0.373, -0.503> }
	smooth_triangle { <5.4881, -0.1706, 26.2326>, <0.780, 0.373, -0.503>, <3.4748, 3.5234, 25.4979>, <0.892, 0.328, -0.311>, <3.4580, 3.5076, 25.4871>, <0.324, -0.229, -0.918> }
	smooth_triangle { <5.4881, -0.1706, 26.2326>, <0.780, 0.373, -0.503>, <3.4580, 3.5076, 25.4871>, <0.324, -0.229, -0.918>, <5.4688, -0.1810, 26.2199>, <0.046, -0.076, -0.996> }
	smooth_triangle { <5.4688, -0.1810, 26.2199>, <0.046, -0.076, -0.996>, <3.4580, 3.5076, 25.4871>, <0.324, -0.229, -0.918>, <3.4352, 3.5040, 25.4979>, <-0.570, -0.556, -0.605> }
	smooth_triangle { <5.4688, -0.1810, 26.2199>, <0.046, -0.076, -0.996>, <3.4352, 3.5040, 25.4979>, <-0.570, -0.556, -0.605>, <5.4500, -0.1925, 26.2326>, <-0.741, -0.452, -0.496> }
	smooth_triangle { <5.4500, -0.1925, 26.2326>, <-0.741, -0.452, -0.496>, <3.4352, 3.5040, 25.4979>, <-0.570, -0.556, -0.605>, <3.4293, 3.5162, 25.5194>, <-0.889, -0.458, 0.006> }
	smooth_triangle { <5.4500, -0.1925, 26.2326>, <-0.741, -0.452, -0.496>, <3.4293, 3.5162, 25.5194>, <-0.889, -0.458, 0.006>, <5.4505, -0.1935, 26.2580>, <-0.869, -0.495, 0.000> }
	smooth_triangle { <6.6791, -2.2990, 26.2808>, <-0.449, -0.554, 0.701>, <5.4505, -0.1935, 26.2580>, <-0.474, -0.146, 0.868>, <5.4699, -0.1830, 26.2707>, <-0.046, 0.076, 0.996> }
	smooth_triangle { <6.6791, -2.2990, 26.2808>, <-0.449, -0.554, 0.701>, <5.4699, -0.1830, 26.2707>, <-0.046, 0.076, 0.996>, <6.6980, -2.2879, 26.2935>, <0.204, -0.089, 0.975> }
	smooth_triangle { <6.6980, -2.2879, 26.2935>, <0.204, -0.089, 0.975>, <5.4699, -0.1830, 26.2707>, <-0.046, 0.076, 0.996>, <5.4887, -0.1716, 26.2580>, <0.741, 0.452, 0.496> }
	smooth_triangle { <6.6980, -2.2879, 26.2935>, <0.204, -0.089, 0.975>, <5.4887, -0.1716, 26.2580>, <0.741, 0.452, 0.496>, <6.7171, -2.2769, 26.2808>, <0.780, 0.483, 0.398> }
	smooth_triangle { <6.7171, -2.2769, 26.2808>, <0.780, 0.483, 0.398>, <5.4887, -0.1716, 26.2580>, <0.741, 0.452, 0.496>, <5.4881, -0.1706, 26.2326>, <0.780, 0.373, -0.503> }
	smooth_triangle { <6.7171, -2.2769, 26.2808>, <0.780, 0.483, 0.398>, <5.4881, -0.1706, 26.2326>, <0.780, 0.373, -0.503>, <6.7172, -2.2771, 26.2554>, <0.580, 0.572, -0.581> }
	smooth_triangle { <6.7172, -2.2771, 26.2554>, <0.580, 0.572, -0.581>, <5.4881, -0.1706, 26.2326>, <0.780, 0.373, -0.503>, <5.4688, -0.1810, 26.2199>, <0.046, -0.076, -0.996> }
	smooth_triangle { <6.7172, -2.2771, 26.2554>, <0.580, 0.572, -0.581>, <5.4688, -0.1810, 26.2199>, <0.046, -0.076, -0.996>, <6.6983, -2.2883, 26.2427>, <-0.200, 0.082, -0.976> }
	smooth_triangle { <6.6983, -2.2883, 26.2427>, <-0.200, 0.082, -0.976>, <5.4688, -0.1810, 26.2199>, <0.046, -0.076, -0.996>, <5.4500, -0.1925, 26.2326>, <-0.741, -0.452, -0.496> }
	smooth_triangle { <6.6983, -2.2883, 26.2427>, <-0.200, 0.082, -0.976>, <5.4500, -0.1925, 26.2326>, <-0.741, -0.452, -0.496>, <6.6792, -2.2992, 26.2554>, <-0.775, -0.490, -0.399> }
	smooth_triangle { <6.6792, -2.2992, 26.2554>, <-0.775, -0.490, -0.399>, <5.4500, -0.1925, 26.2326>, <-0.741, -0.452, -0.496>, <5.4505, -0.1935, 26.2580>, <-0.869, -0.495, 0.000> }
	smooth_triangle { <6.6792, -2.2992, 26.2554>, <-0.775, -0.490, -0.399>, <5.4505, -0.1935, 26.2580>, <-0.869, -0.495, 0.000>, <6.6791, -2.2990, 26.2808>, <-0.864, -0.504, 0.000> }
	smooth_triangle { <8.4118, -3.6718, 25.2219>, <-0.077, -0.673, 0.736>, <6.6791, -2.2990, 26.2808>, <-0.449, -0.554, 0.701>, <6.6980, -2.2879, 26.2935>, <0.204, -0.089, 0.975> }
	smooth_triangle { <8.4118, -3.6718, 25.2219>, <0.570, 0.063, 0.819>, <6.6980, -2.2879, 26.2935>, <0.204, -0.089, 0.975>, <6.7171, -2.2769, 26.2808>, <0.780, 0.483, 0.398> }
	smooth_triangle { <8.4118, -3.6718, 25.2219>, <0.657, 0.753, 0.050>, <6.7171, -2.2769, 26.2808>, <0.780, 0.483, 0.398>, <6.7172, -2.2771, 26.2554>, <0.580, 0.572, -0.581> }
	smooth_triangle { <8.4118, -3.6718, 25.2219>, <0.093, 0.659, -0.746>, <6.7172, -2.2771, 26.2554>, <0.580, 0.572, -0.581>, <6.6983, -2.2883, 26.2427>, <-0.200, 0.082, -0.976> }
	smooth_triangle { <8.4118, -3.6718, 25.2219>, <-0.555, -0.084, -0.828>, <6.6983, -2.2883, 26.2427>, <-0.200, 0.082, -0.976>, <6.6792, -2.2992, 26.2554>, <-0.775, -0.490, -0.399> }
	smooth_triangle { <8.4118, -3.6718, 25.2219>, <-0.637, -0.769, -0.056>, <6.6792, -2.2992, 26.2554>, <-0.775, -0.490, -0.399>, <6.6791, -2.2990, 26.2808>, <-0.449, -0.554, 0.701> }

	texture { PSWL_BARK }
}

/* Object 'PWL0014F' */
union {
	smooth_triangle { <2.7803, 3.5940, 24.2559>, <0.680, 0.710, -0.183>, <3.0359, 3.2581, 23.8142>, <0.706, 0.697, -0.122>, <3.3968, 2.8972, 23.8407>, <0.680, 0.710, -0.183> }
	smooth_triangle { <3.3968, 2.8972, 23.8407>, <0.680, 0.710, -0.183>, <3.1790, 3.2356, 24.2609>, <0.650, 0.720, -0.243>, <2.7803, 3.5940, 24.2559>, <0.680, 0.710, -0.183> }
	smooth_triangle { <3.4807, 3.5629, 25.4961>, <-0.720, 0.587, 0.370>, <3.6526, 3.9505, 25.1877>, <-0.741, 0.588, 0.326>, <3.9874, 4.3243, 25.2748>, <-0.720, 0.587, 0.370> }
	smooth_triangle { <3.9874, 4.3243, 25.2748>, <-0.720, 0.587, 0.370>, <3.8287, 3.9228, 25.5744>, <-0.698, 0.585, 0.414>, <3.4807, 3.5629, 25.4961>, <-0.720, 0.587, 0.370> }
	smooth_triangle { <4.1021, 3.3678, 26.7658>, <0.822, 0.229, -0.521>, <4.0699, 2.9611, 26.5263>, <0.836, 0.228, -0.499>, <4.2505, 2.5094, 26.6227>, <0.822, 0.229, -0.521> }
	smooth_triangle { <4.2505, 2.5094, 26.6227>, <0.822, 0.229, -0.521>, <4.2904, 2.9267, 26.8591>, <0.808, 0.230, -0.543>, <4.1021, 3.3678, 26.7658>, <0.822, 0.229, -0.521> }
	smooth_triangle { <4.7789, 3.3397, 28.0192>, <-0.325, 0.926, 0.191>, <5.1593, 3.5534, 27.5666>, <-0.347, 0.926, 0.146>, <5.6950, 3.7508, 27.5877>, <-0.325, 0.926, 0.191> }
	smooth_triangle { <5.6950, 3.7508, 27.5877>, <-0.325, 0.926, 0.191>, <5.3451, 3.5244, 28.0238>, <-0.303, 0.923, 0.236>, <4.7789, 3.3397, 28.0192>, <-0.325, 0.926, 0.191> }
	smooth_triangle { <5.2156, 2.8932, 29.0773>, <0.901, 0.043, -0.431>, <5.0806, 2.5209, 28.7607>, <0.899, 0.044, -0.435>, <5.1251, 1.9964, 28.7991>, <0.901, 0.043, -0.431> }
	smooth_triangle { <5.1251, 1.9964, 28.7991>, <0.901, 0.043, -0.431>, <5.2596, 2.3827, 29.1210>, <0.903, 0.041, -0.427>, <5.2156, 2.8932, 29.0773>, <0.901, 0.043, -0.431> }
	smooth_triangle { <5.7539, 2.5904, 30.1324>, <-0.277, 0.851, 0.446>, <6.1447, 2.9144, 29.7637>, <-0.273, 0.847, 0.455>, <6.7688, 3.0761, 29.8366>, <-0.277, 0.851, 0.446> }
	smooth_triangle { <6.7688, 3.0761, 29.8366>, <-0.277, 0.851, 0.446>, <6.3591, 2.7488, 30.2128>, <-0.282, 0.854, 0.437>, <5.7539, 2.5904, 30.1324>, <-0.277, 0.851, 0.446> }
	smooth_triangle { <5.8391, 2.0465, 31.2413>, <0.947, -0.163, -0.278>, <5.6067, 1.6229, 30.7521>, <0.936, -0.143, -0.321>, <5.4847, 0.8065, 30.7604>, <0.947, -0.163, -0.278> }
	smooth_triangle { <5.4847, 0.8065, 30.7604>, <0.947, -0.163, -0.278>, <5.7064, 1.2984, 31.2801>, <0.955, -0.182, -0.235>, <5.8391, 2.0465, 31.2413>, <0.947, -0.163, -0.278> }
	smooth_triangle { <6.0497, 1.6353, 32.3733>, <-0.242, 0.879, 0.410>, <6.4884, 1.8508, 32.1661>, <-0.243, 0.882, 0.404>, <6.9926, 1.8997, 32.3626>, <-0.242, 0.879, 0.410> }
	smooth_triangle { <6.9926, 1.8997, 32.3626>, <-0.242, 0.879, 0.410>, <6.5415, 1.6778, 32.5687>, <-0.241, 0.877, 0.416>, <6.0497, 1.6353, 32.3733>, <-0.242, 0.879, 0.410> }
	smooth_triangle { <6.2628, 1.8593, 33.1065>, <-0.109, 0.935, -0.336>, <6.8111, 1.7567, 32.6476>, <-0.110, 0.934, -0.340>, <7.5764, 1.8755, 32.7266>, <-0.109, 0.935, -0.336> }
	smooth_triangle { <7.5764, 1.8755, 32.7266>, <-0.109, 0.935, -0.336>, <7.0074, 1.9755, 33.1923>, <-0.108, 0.937, -0.333>, <6.2628, 1.8593, 33.1065>, <-0.109, 0.935, -0.336> }
	smooth_triangle { <6.4168, 2.1472, 33.8549>, <-0.922, -0.039, 0.386>, <6.2434, 2.5896, 33.4818>, <-0.924, -0.041, 0.380>, <6.2442, 3.2444, 33.5552>, <-0.922, -0.039, 0.386> }
	smooth_triangle { <6.2442, 3.2444, 33.5552>, <-0.922, -0.039, 0.386>, <6.4229, 2.7897, 33.9307>, <-0.919, -0.038, 0.392>, <6.4168, 2.1472, 33.8549>, <-0.922, -0.039, 0.386> }
	smooth_triangle { <6.5231, 2.0575, 34.6745>, <0.471, 0.882, -0.020>, <6.9092, 1.8552, 34.4211>, <0.474, 0.880, 0.020>, <7.3225, 1.6287, 34.5828>, <0.471, 0.882, -0.020> }
	smooth_triangle { <7.3225, 1.6287, 34.5828>, <0.471, 0.882, -0.020>, <6.9364, 1.8495, 34.8304>, <0.467, 0.882, -0.059>, <6.5231, 2.0575, 34.6745>, <0.471, 0.882, -0.020> }
	smooth_triangle { <6.4938, 2.1097, 35.4876>, <-0.768, -0.636, 0.071>, <6.1748, 2.4562, 35.2550>, <-0.767, -0.632, 0.110>, <5.8937, 2.8275, 35.4305>, <-0.768, -0.636, 0.071> }
	smooth_triangle { <5.8937, 2.8275, 35.4305>, <-0.768, -0.636, 0.071>, <6.2106, 2.4591, 35.6707>, <-0.768, -0.640, 0.033>, <6.4938, 2.1097, 35.4876>, <-0.768, -0.636, 0.071> }
	smooth_triangle { <4.6357, 2.8255, 28.6802>, <0.255, -0.816, -0.519>, <3.9839, 2.8722, 28.2722>, <0.253, -0.828, -0.500>, <3.2805, 2.5801, 28.3994>, <0.255, -0.816, -0.519> }
	smooth_triangle { <3.2805, 2.5801, 28.3994>, <0.255, -0.816, -0.519>, <3.9501, 2.5243, 28.8019>, <0.257, -0.802, -0.539>, <4.6357, 2.8255, 28.6802>, <0.255, -0.816, -0.519> }
	smooth_triangle { <4.6902, 2.3338, 29.3331>, <0.331, 0.699, 0.634>, <5.1997, 2.3357, 29.0714>, <0.329, 0.689, 0.646>, <5.6921, 2.0119, 29.1657>, <0.331, 0.699, 0.634> }
	smooth_triangle { <5.6921, 2.0119, 29.1657>, <0.331, 0.699, 0.634>, <5.1691, 2.0210, 29.4346>, <0.332, 0.710, 0.621>, <4.6902, 2.3338, 29.3331>, <0.331, 0.699, 0.634> }
	smooth_triangle { <4.9568, 1.6491, 30.2891>, <0.878, -0.061, -0.475>, <4.6561, 1.3411, 29.8250>, <0.844, -0.015, -0.537>, <4.5677, 0.5891, 29.7067>, <0.878, -0.061, -0.475> }
	smooth_triangle { <4.5677, 0.5891, 29.7067>, <0.878, -0.061, -0.475>, <4.8467, 0.9654, 30.2243>, <0.906, -0.107, -0.411>, <4.9568, 1.6491, 30.2891>, <0.878, -0.061, -0.475> }
	smooth_triangle { <5.3572, 1.0497, 31.2764>, <-0.104, 0.834, 0.542>, <5.7714, 1.2867, 31.0094>, <-0.091, 0.811, 0.578>, <6.3232, 1.2825, 31.1026>, <-0.104, 0.834, 0.542> }
	smooth_triangle { <6.3232, 1.2825, 31.1026>, <-0.104, 0.834, 0.542>, <5.8877, 1.0574, 31.3850>, <-0.116, 0.856, 0.504>, <5.3572, 1.0497, 31.2764>, <-0.104, 0.834, 0.542> }
	smooth_triangle { <5.5948, 0.2843, 32.2015>, <0.427, -0.611, -0.667>, <5.1410, 0.1784, 32.0040>, <0.430, -0.618, -0.658>, <4.7927, -0.1879, 32.1205>, <0.427, -0.611, -0.667> }
	smooth_triangle { <4.7927, -0.1879, 32.1205>, <0.427, -0.611, -0.667>, <5.2596, -0.0791, 32.3155>, <0.423, -0.603, -0.677>, <5.5948, 0.2843, 32.2015>, <0.427, -0.611, -0.667> }
	smooth_triangle { <6.0151, -0.4340, 33.0969>, <0.575, 0.770, 0.276>, <6.3342, -0.5035, 32.6283>, <0.575, 0.769, 0.278>, <6.7629, -0.7929, 32.5420>, <0.575, 0.770, 0.276> }
	smooth_triangle { <6.7629, -0.7929, 32.5420>, <0.575, 0.770, 0.276>, <6.4327, -0.7171, 33.0197>, <0.574, 0.772, 0.274>, <6.0151, -0.4340, 33.0969>, <0.575, 0.770, 0.276> }
	smooth_triangle { <5.7367, -1.3698, 33.3842>, <0.362, -0.301, -0.882>, <5.3345, -1.1366, 33.1074>, <0.336, -0.420, -0.843>, <4.8399, -1.3058, 32.9942>, <0.362, -0.301, -0.882> }
	smooth_triangle { <4.8399, -1.3058, 32.9942>, <0.362, -0.301, -0.882>, <5.2514, -1.5567, 33.2163>, <0.382, -0.177, -0.907>, <5.7367, -1.3698, 33.3842>, <0.362, -0.301, -0.882> }
	smooth_triangle { <5.6431, -2.3467, 33.6646>, <0.435, 0.220, 0.873>, <6.1557, -2.2758, 33.3745>, <0.444, 0.277, 0.852>, <6.5944, -2.6505, 33.2676>, <0.435, 0.220, 0.873> }
	smooth_triangle { <6.5944, -2.6505, 33.2676>, <0.435, 0.220, 0.873>, <6.0667, -2.7258, 33.5321>, <0.424, 0.162, 0.891>, <5.6431, -2.3467, 33.6646>, <0.435, 0.220, 0.873> }
	smooth_triangle { <5.1993, -3.1598, 34.1264>, <0.419, -0.631, -0.653>, <4.8111, -2.9374, 33.7102>, <0.458, -0.532, -0.712>, <4.2260, -3.1514, 33.4934>, <0.419, -0.631, -0.653> }
	smooth_triangle { <4.2260, -3.1514, 33.4934>, <0.419, -0.631, -0.653>, <4.6324, -3.3509, 34.0001>, <0.373, -0.721, -0.583>, <5.1993, -3.1598, 34.1264>, <0.419, -0.631, -0.653> }
	smooth_triangle { <4.9320, -4.0055, 34.5957>, <0.647, 0.158, 0.746>, <5.5508, -3.9477, 34.1306>, <0.603, -0.039, 0.797>, <5.9615, -4.4419, 33.7960>, <0.647, 0.158, 0.746> }
	smooth_triangle { <5.9615, -4.4419, 33.7960>, <0.647, 0.158, 0.746>, <5.3366, -4.4509, 34.4250>, <0.663, 0.348, 0.663>, <4.9320, -4.0055, 34.5957>, <0.647, 0.158, 0.746> }
	smooth_triangle { <5.2726, 2.7990, 28.3605>, <0.604, 0.538, -0.588>, <5.0661, 2.6443, 28.0124>, <0.592, 0.546, -0.593>, <5.1706, 2.2031, 27.7110>, <0.604, 0.538, -0.588> }
	smooth_triangle { <5.1706, 2.2031, 27.7110>, <0.604, 0.538, -0.588>, <5.3750, 2.3693, 28.0777>, <0.615, 0.530, -0.583>, <5.2726, 2.7990, 28.3605>, <0.604, 0.538, -0.588> }
	smooth_triangle { <5.8591, 2.3894, 28.7576>, <-0.314, 0.315, 0.896>, <6.0735, 2.9827, 28.6274>, <-0.308, 0.309, 0.900>, <6.6592, 3.2676, 28.7299>, <-0.314, 0.315, 0.896> }
	smooth_triangle { <6.6592, 3.2676, 28.7299>, <-0.314, 0.315, 0.896>, <6.4319, 2.6636, 28.8652>, <-0.321, 0.320, 0.891>, <5.8591, 2.3894, 28.7576>, <-0.314, 0.315, 0.896> }
	smooth_triangle { <6.5757, 1.5558, 29.2994>, <0.613, -0.010, -0.790>, <6.2375, 1.3413, 29.0550>, <0.574, 0.028, -0.819>, <6.1476, 0.8714, 28.9758>, <0.613, -0.010, -0.790> }
	smooth_triangle { <6.1476, 0.8714, 28.9758>, <0.613, -0.010, -0.790>, <6.4829, 1.1042, 29.2485>, <0.650, -0.048, -0.758>, <6.5757, 1.5558, 29.2994>, <0.613, -0.010, -0.790> }
	smooth_triangle { <7.4212, 0.8777, 29.8667>, <-0.110, 0.489, 0.865>, <7.6628, 1.3303, 29.6280>, <-0.142, 0.520, 0.842>, <8.2114, 1.5059, 29.6118>, <-0.110, 0.489, 0.865> }
	smooth_triangle { <8.2114, 1.5059, 29.6118>, <-0.110, 0.489, 0.865>, <7.9667, 1.0367, 29.8325>, <-0.078, 0.457, 0.886>, <7.4212, 0.8777, 29.8667>, <-0.110, 0.489, 0.865> }
	smooth_triangle { <8.0160, 0.2639, 30.7443>, <0.817, 0.133, -0.561>, <7.8263, -0.0978, 30.3429>, <0.866, 0.092, -0.492>, <7.8614, -0.6610, 30.2997>, <0.817, 0.133, -0.561> }
	smooth_triangle { <7.8614, -0.6610, 30.2997>, <0.817, 0.133, -0.561>, <8.0849, -0.3125, 30.6688>, <0.762, 0.173, -0.624>, <8.0160, 0.2639, 30.7443>, <0.817, 0.133, -0.561> }
	smooth_triangle { <8.7114, -0.2180, 31.6253>, <0.216, 0.861, 0.461>, <8.9749, -0.0672, 31.2261>, <0.222, 0.855, 0.469>, <9.5136, -0.1344, 31.0942>, <0.216, 0.861, 0.461> }
	smooth_triangle { <9.5136, -0.1344, 31.0942>, <0.216, 0.861, 0.461>, <9.2342, -0.2826, 31.5065>, <0.210, 0.866, 0.453>, <8.7114, -0.2180, 31.6253>, <0.216, 0.861, 0.461> }
	smooth_triangle { <9.0056, -0.5955, 32.7618>, <0.808, -0.333, -0.486>, <8.6552, -0.9919, 32.4503>, <0.808, -0.333, -0.485>, <8.4825, -1.5661, 32.5569>, <0.808, -0.333, -0.486> }
	smooth_triangle { <8.4825, -1.5661, 32.5569>, <0.808, -0.333, -0.486>, <8.8406, -1.1562, 32.8709>, <0.808, -0.333, -0.487>, <9.0056, -0.5955, 32.7618>, <0.808, -0.333, -0.486> }
	smooth_triangle { <9.4385, -0.8535, 33.8698>, <-0.283, 0.879, 0.384>, <9.9125, -0.4831, 33.3478>, <-0.296, 0.885, 0.359>, <10.5893, -0.2722, 33.3857>, <-0.283, 0.879, 0.384> }
	smooth_triangle { <10.5893, -0.2722, 33.3857>, <-0.283, 0.879, 0.384>, <10.1107, -0.6603, 33.9004>, <-0.269, 0.873, 0.407>, <9.4385, -0.8535, 33.8698>, <-0.283, 0.879, 0.384> }
	smooth_triangle { <4.8092, 3.7796, 28.7082>, <-0.074, 0.821, -0.566>, <5.5053, 3.6256, 28.3992>, <-0.075, 0.815, -0.575>, <6.2394, 3.8460, 28.6165>, <-0.074, 0.821, -0.566> }
	smooth_triangle { <6.2394, 3.8460, 28.6165>, <-0.074, 0.821, -0.566>, <5.5229, 3.9936, 28.9306>, <-0.074, 0.827, -0.558>, <4.8092, 3.7796, 28.7082>, <-0.074, 0.821, -0.566> }
	smooth_triangle { <4.7347, 4.2614, 29.3663>, <-0.589, -0.660, 0.466>, <4.2344, 4.4328, 28.9272>, <-0.590, -0.703, 0.397>, <3.7328, 4.8811, 28.9766>, <-0.589, -0.660, 0.466> }
	smooth_triangle { <3.7328, 4.8811, 28.9766>, <-0.589, -0.660, 0.466>, <4.2494, 4.7460, 29.3903>, <-0.585, -0.613, 0.531>, <4.7347, 4.2614, 29.3663>, <-0.589, -0.660, 0.466> }
	smooth_triangle { <4.7272, 4.8378, 30.4428>, <-0.875, 0.463, -0.140>, <5.0112, 5.1956, 29.9845>, <-0.878, 0.433, -0.206>, <5.2781, 5.7487, 30.0086>, <-0.875, 0.463, -0.140> }
	smooth_triangle { <5.2781, 5.7487, 30.0086>, <-0.875, 0.463, -0.140>, <4.9943, 5.3201, 30.5037>, <-0.869, 0.490, -0.074>, <4.7272, 4.8378, 30.4428>, <-0.875, 0.463, -0.140> }
	smooth_triangle { <4.5729, 5.3623, 31.5360>, <-0.160, -0.852, 0.499>, <4.0087, 5.2981, 31.2249>, <-0.158, -0.871, 0.466>, <3.3926, 5.4946, 31.3841>, <-0.160, -0.852, 0.499> }
	smooth_triangle { <3.3926, 5.4946, 31.3841>, <-0.160, -0.852, 0.499>, <3.9709, 5.5763, 31.6871>, <-0.162, -0.831, 0.533>, <4.5729, 5.3623, 31.5360>, <-0.160, -0.852, 0.499> }
	smooth_triangle { <4.7069, 5.9165, 32.6240>, <-0.029, 0.895, -0.446>, <5.2073, 5.8165, 32.4022>, <-0.029, 0.885, -0.465>, <5.7330, 5.9320, 32.5894>, <-0.029, 0.895, -0.446> }
	smooth_triangle { <5.7330, 5.9320, 32.5894>, <-0.029, 0.895, -0.446>, <5.2177, 6.0231, 32.8162>, <-0.028, 0.904, -0.427>, <4.7069, 5.9165, 32.6240>, <-0.029, 0.895, -0.446> }
	smooth_triangle { <4.6380, 6.5026, 33.6957>, <-0.574, -0.738, 0.355>, <4.2364, 6.6804, 33.3643>, <-0.572, -0.771, 0.279>, <3.8309, 7.0131, 33.4530>, <-0.574, -0.738, 0.355> }
	smooth_triangle { <3.8309, 7.0131, 33.4530>, <-0.574, -0.738, 0.355>, <4.2458, 6.8670, 33.7676>, <-0.572, -0.700, 0.429>, <4.6380, 6.5026, 33.6957>, <-0.574, -0.738, 0.355> }
	smooth_triangle { <4.5666, 6.1785, 34.6752>, <0.109, -0.971, -0.213>, <4.1410, 6.1868, 34.4402>, <0.111, -0.966, -0.234>, <3.6822, 6.0969, 34.5941>, <0.109, -0.971, -0.213> }
	smooth_triangle { <3.6822, 6.0969, 34.5941>, <0.109, -0.971, -0.213>, <4.1221, 6.0985, 34.8330>, <0.108, -0.976, -0.192>, <4.5666, 6.1785, 34.6752>, <0.109, -0.971, -0.213> }
	smooth_triangle { <4.6046, 5.8676, 35.6471>, <0.459, 0.842, 0.284>, <5.0860, 5.6680, 35.3633>, <0.463, 0.869, 0.174>, <5.5625, 5.3746, 35.5605>, <0.459, 0.842, 0.284> }
	smooth_triangle { <5.5625, 5.3746, 35.5605>, <0.459, 0.842, 0.284>, <5.0560, 5.5271, 35.8286>, <0.449, 0.804, 0.391>, <4.6046, 5.8676, 35.6471>, <0.459, 0.842, 0.284> }
	smooth_triangle { <4.2439, 5.8341, 36.6176>, <-0.882, -0.365, -0.296>, <4.1271, 6.2862, 36.4089>, <-0.882, -0.365, -0.298>, <3.8862, 6.7072, 36.6060>, <-0.882, -0.365, -0.296> }
	smooth_triangle { <3.8862, 6.7072, 36.6060>, <-0.882, -0.365, -0.296>, <4.0088, 6.2430, 36.8151>, <-0.883, -0.366, -0.294>, <4.2439, 5.8341, 36.6176>, <-0.882, -0.365, -0.296> }
	smooth_triangle { <3.9478, 5.6311, 37.5729>, <0.834, -0.486, 0.262>, <3.8494, 5.2879, 37.2975>, <0.810, -0.490, 0.321>, <3.5658, 4.8682, 37.3725>, <0.834, -0.486, 0.262> }
	smooth_triangle { <3.5658, 4.8682, 37.3725>, <0.834, -0.486, 0.262>, <3.7033, 5.2345, 37.6624>, <0.853, -0.480, 0.202>, <3.9478, 5.6311, 37.5729>, <0.834, -0.486, 0.262> }
	smooth_triangle { <3.9522, 5.4963, 38.3790>, <0.341, -0.903, -0.261>, <3.3843, 5.3636, 38.0983>, <0.341, -0.902, -0.264>, <2.8279, 5.0830, 38.3385>, <0.341, -0.903, -0.261> }
	smooth_triangle { <2.8279, 5.0830, 38.3385>, <0.341, -0.903, -0.261>, <3.4113, 5.2229, 38.6202>, <0.341, -0.904, -0.258>, <3.9522, 5.4963, 38.3790>, <0.341, -0.903, -0.261> }
	smooth_triangle { <4.0844, 5.3370, 39.1715>, <0.293, 0.904, 0.312>, <4.5821, 5.2892, 38.8896>, <0.292, 0.884, 0.366>, <5.1337, 5.0329, 39.0681>, <0.293, 0.904, 0.312> }
	smooth_triangle { <5.1337, 5.0329, 39.0681>, <0.293, 0.904, 0.312>, <4.6151, 5.1167, 39.3582>, <0.292, 0.921, 0.256>, <4.0844, 5.3370, 39.1715>, <0.293, 0.904, 0.312> }
	smooth_triangle { <3.9920, 4.9176, 39.8821>, <0.844, -0.409, -0.347>, <3.6613, 4.4909, 39.4994>, <0.862, -0.435, -0.261>, <3.3159, 3.7086, 39.6611>, <0.844, -0.409, -0.347> }
	smooth_triangle { <3.3159, 3.7086, 39.6611>, <0.844, -0.409, -0.347>, <3.6731, 4.0636, 40.0281>, <0.819, -0.379, -0.430>, <3.9920, 4.9176, 39.8821>, <0.844, -0.409, -0.347> }
	smooth_triangle { <4.0394, 4.5386, 40.5954>, <0.705, 0.647, 0.292>, <4.4009, 4.2361, 40.3016>, <0.711, 0.682, 0.173>, <4.7360, 3.8546, 40.4281>, <0.705, 0.647, 0.292> }
	smooth_triangle { <4.7360, 3.8546, 40.4281>, <0.705, 0.647, 0.292>, <4.3828, 4.0723, 40.7042>, <0.688, 0.601, 0.406>, <4.0394, 4.5386, 40.5954>, <0.705, 0.647, 0.292> }
	smooth_triangle { <4.1145, 3.0890, 25.7062>, <0.460, 0.276, -0.844>, <3.7672, 2.7925, 25.4399>, <0.395, 0.313, -0.864>, <3.7933, 2.2696, 25.2626>, <0.460, 0.276, -0.844> }
	smooth_triangle { <3.7933, 2.2696, 25.2626>, <0.460, 0.276, -0.844>, <4.1359, 2.5829, 25.5725>, <0.523, 0.238, -0.819>, <4.1145, 3.0890, 25.7062>, <0.460, 0.276, -0.844> }
	smooth_triangle { <4.8394, 2.7750, 25.9159>, <0.177, 0.705, 0.687>, <4.9147, 3.1659, 25.4814>, <0.143, 0.723, 0.676>, <5.3952, 3.3390, 25.1944>, <0.177, 0.705, 0.687> }
	smooth_triangle { <5.3952, 3.3390, 25.1944>, <0.177, 0.705, 0.687>, <5.3186, 2.9364, 25.6127>, <0.211, 0.685, 0.698>, <4.8394, 2.7750, 25.9159>, <0.177, 0.705, 0.687> }
	smooth_triangle { <5.8807, 1.8072, 25.9378>, <0.296, 0.302, -0.906>, <5.4060, 1.5957, 25.7130>, <0.294, 0.303, -0.906>, <5.2848, 1.0768, 25.5003>, <0.296, 0.302, -0.906> }
	smooth_triangle { <5.2848, 1.0768, 25.5003>, <0.296, 0.302, -0.906>, <5.7680, 1.2986, 25.7323>, <0.297, 0.300, -0.906>, <5.8807, 1.8072, 25.9378>, <0.296, 0.302, -0.906> }
	smooth_triangle { <7.0438, 0.9824, 25.9557>, <0.183, 0.162, 0.970>, <7.2264, 1.7040, 25.8053>, <0.195, 0.153, 0.969>, <7.9123, 2.0376, 25.6145>, <0.183, 0.162, 0.970> }
	smooth_triangle { <7.9123, 2.0376, 25.6145>, <0.183, 0.162, 0.970>, <7.7174, 1.3012, 25.7798>, <0.172, 0.172, 0.970>, <7.0438, 0.9824, 25.9557>, <0.183, 0.162, 0.970> }
	smooth_triangle { <8.0643, 0.3262, 25.9759>, <0.015, 0.009, -1.000>, <7.5585, -0.0635, 25.9657>, <0.011, 0.012, -1.000>, <7.5146, -0.7157, 25.9577>, <0.015, 0.009, -1.000> }
	smooth_triangle { <7.5146, -0.7157, 25.9577>, <0.015, 0.009, -1.000>, <8.0281, -0.3113, 25.9705>, <0.019, 0.007, -1.000>, <8.0643, 0.3262, 25.9759>, <0.015, 0.009, -1.000> }
	smooth_triangle { <9.1888, -0.1555, 25.9568>, <0.143, 0.514, 0.846>, <9.1870, 0.2969, 25.6986>, <0.202, 0.486, 0.850>, <9.5697, 0.5593, 25.4574>, <0.143, 0.514, 0.846> }
	smooth_triangle { <9.5697, 0.5593, 25.4574>, <0.143, 0.514, 0.846>, <9.5659, 0.0969, 25.7562>, <0.083, 0.540, 0.837>, <9.1888, -0.1555, 25.9568>, <0.143, 0.514, 0.846> }
	smooth_triangle { <10.2438, -0.7663, 25.9777>, <0.217, 0.236, -0.947>, <9.7576, -1.1332, 25.7712>, <0.229, 0.229, -0.946>, <9.7336, -1.7382, 25.6188>, <0.217, 0.236, -0.947> }
	smooth_triangle { <9.7336, -1.7382, 25.6188>, <0.217, 0.236, -0.947>, <10.2270, -1.3576, 25.8226>, <0.204, 0.243, -0.948>, <10.2438, -0.7663, 25.9777>, <0.217, 0.236, -0.947> }
	smooth_triangle { <11.3850, -1.2141, 25.9658>, <0.161, 0.706, 0.689>, <11.3487, -0.8441, 25.6048>, <0.192, 0.695, 0.693>, <11.6905, -0.6446, 25.3104>, <0.161, 0.706, 0.689> }
	smooth_triangle { <11.6905, -0.6446, 25.3104>, <0.161, 0.706, 0.689>, <11.7224, -1.0227, 25.7005>, <0.131, 0.717, 0.684>, <11.3850, -1.2141, 25.9658>, <0.161, 0.706, 0.689> }
	smooth_triangle { <3.7136, 2.8711, 25.9261>, <0.556, -0.362, -0.748>, <3.0714, 2.7007, 25.5362>, <0.552, -0.353, -0.755>, <2.6385, 2.0601, 25.5193>, <0.556, -0.362, -0.748> }
	smooth_triangle { <2.6385, 2.0601, 25.5193>, <0.556, -0.362, -0.748>, <3.2940, 2.2457, 25.9216>, <0.560, -0.370, -0.741>, <3.7136, 2.8711, 25.9261>, <0.556, -0.362, -0.748> }
	smooth_triangle { <4.1052, 2.3061, 26.3723>, <-0.198, 0.509, 0.837>, <4.4994, 2.7112, 26.2180>, <-0.200, 0.512, 0.835>, <5.0863, 2.7568, 26.3303>, <-0.198, 0.509, 0.837> }
	smooth_triangle { <5.0863, 2.7568, 26.3303>, <-0.198, 0.509, 0.837>, <4.6788, 2.3444, 26.4835>, <-0.197, 0.506, 0.840>, <4.1052, 2.3061, 26.3723>, <-0.198, 0.509, 0.837> }
	smooth_triangle { <4.7176, 1.0255, 26.2984>, <0.183, 0.111, -0.977>, <4.0115, 0.9724, 26.1776>, <0.155, 0.160, -0.975>, <3.5863, 0.3923, 26.0150>, <0.183, 0.111, -0.977> }
	smooth_triangle { <3.5863, 0.3923, 26.0150>, <0.183, 0.111, -0.977>, <4.3091, 0.4530, 26.1745>, <0.210, 0.061, -0.976>, <4.7176, 1.0255, 26.2984>, <0.183, 0.111, -0.977> }
	smooth_triangle { <5.5031, -0.1608, 26.2099>, <0.684, 0.112, 0.721>, <5.6898, 0.1983, 25.9820>, <0.691, 0.096, 0.717>, <6.0887, 0.2067, 25.5966>, <0.684, 0.112, 0.721> }
	smooth_triangle { <6.0887, 0.2067, 25.5966>, <0.684, 0.112, 0.721>, <5.8940, -0.1580, 25.8436>, <0.678, 0.129, 0.724>, <5.5031, -0.1608, 26.2099>, <0.684, 0.112, 0.721> }
	smooth_triangle { <6.0409, -1.2602, 26.2372>, <0.289, 0.228, -0.930>, <5.3912, -1.3090, 25.9982>, <0.331, 0.157, -0.931>, <5.0168, -1.8628, 25.7716>, <0.289, 0.228, -0.930> }
	smooth_triangle { <5.0168, -1.8628, 25.7716>, <0.289, 0.228, -0.930>, <5.6812, -1.8060, 25.9665>, <0.245, 0.296, -0.923>, <6.0409, -1.2602, 26.2372>, <0.289, 0.228, -0.930> }
	smooth_triangle { <6.7296, -2.2701, 26.2289>, <0.628, 0.382, 0.678>, <6.9621, -1.7968, 25.7562>, <0.638, 0.364, 0.678>, <7.5039, -1.8288, 25.2637>, <0.628, 0.382, 0.678> }
	smooth_triangle { <7.5039, -1.8288, 25.2637>, <0.628, 0.382, 0.678>, <7.2604, -2.3082, 25.7679>, <0.617, 0.399, 0.678>, <6.7296, -2.2701, 26.2289>, <0.628, 0.382, 0.678> }
	smooth_triangle { <7.5093, -3.0066, 25.7378>, <-0.135, 0.465, -0.875>, <6.7705, -3.1580, 25.7805>, <-0.149, 0.485, -0.861>, <6.4198, -3.6442, 25.5673>, <-0.135, 0.465, -0.875> }
	smooth_triangle { <6.4198, -3.6442, 25.5673>, <-0.135, 0.465, -0.875>, <7.1739, -3.4837, 25.5447>, <-0.121, 0.445, -0.888>, <7.5093, -3.0066, 25.7378>, <-0.135, 0.465, -0.875> }
	smooth_triangle { <8.4537, -3.6476, 25.1994>, <0.444, 0.062, 0.894>, <8.7412, -3.2062, 25.0376>, <0.461, 0.025, 0.887>, <9.4401, -3.0777, 24.6706>, <0.444, 0.062, 0.894> }
	smooth_triangle { <9.4401, -3.0777, 24.6706>, <0.444, 0.062, 0.894>, <9.1387, -3.5269, 24.8623>, <0.425, 0.098, 0.900>, <8.4537, -3.6476, 25.1994>, <0.444, 0.062, 0.894> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0015B' */
union {
	smooth_triangle { <0.9745, 1.4694, 13.6288>, <-0.659, 0.603, 0.450>, <0.7778, 2.2905, 12.2397>, <-0.658, 0.599, 0.457>, <0.8044, 2.3125, 12.2490>, <-0.374, 0.767, 0.521> }
	smooth_triangle { <0.9745, 1.4694, 13.6288>, <-0.659, 0.603, 0.450>, <0.8044, 2.3125, 12.2490>, <-0.374, 0.767, 0.521>, <1.0010, 1.4914, 13.6381>, <-0.012, 0.860, 0.510> }
	smooth_triangle { <1.0010, 1.4914, 13.6381>, <-0.012, 0.860, 0.510>, <0.8044, 2.3125, 12.2490>, <-0.374, 0.767, 0.521>, <0.8380, 2.3049, 12.2397>, <0.610, 0.712, 0.349> }
	smooth_triangle { <1.0010, 1.4914, 13.6381>, <-0.012, 0.860, 0.510>, <0.8380, 2.3049, 12.2397>, <0.610, 0.712, 0.349>, <1.0347, 1.4838, 13.6288>, <0.854, 0.492, 0.170> }
	smooth_triangle { <1.0347, 1.4838, 13.6288>, <0.854, 0.492, 0.170>, <0.8380, 2.3049, 12.2397>, <0.610, 0.712, 0.349>, <0.8451, 2.2752, 12.2211>, <0.984, -0.056, -0.171> }
	smooth_triangle { <1.0347, 1.4838, 13.6288>, <0.854, 0.492, 0.170>, <0.8451, 2.2752, 12.2211>, <0.984, -0.056, -0.171>, <1.0418, 1.4541, 13.6103>, <0.865, -0.368, -0.340> }
	smooth_triangle { <1.0418, 1.4541, 13.6103>, <0.865, -0.368, -0.340>, <0.8451, 2.2752, 12.2211>, <0.984, -0.056, -0.171>, <0.8186, 2.2531, 12.2119>, <0.374, -0.768, -0.519> }
	smooth_triangle { <1.0418, 1.4541, 13.6103>, <0.865, -0.368, -0.340>, <0.8186, 2.2531, 12.2119>, <0.374, -0.768, -0.519>, <1.0153, 1.4320, 13.6010>, <0.012, -0.860, -0.510> }
	smooth_triangle { <1.0153, 1.4320, 13.6010>, <0.012, -0.860, -0.510>, <0.8186, 2.2531, 12.2119>, <0.374, -0.768, -0.519>, <0.7849, 2.2608, 12.2211>, <-0.609, -0.713, -0.347> }
	smooth_triangle { <1.0153, 1.4320, 13.6010>, <0.012, -0.860, -0.510>, <0.7849, 2.2608, 12.2211>, <-0.609, -0.713, -0.347>, <0.9816, 1.4397, 13.6103>, <-0.854, -0.492, -0.170> }
	smooth_triangle { <0.9816, 1.4397, 13.6103>, <-0.854, -0.492, -0.170>, <0.7849, 2.2608, 12.2211>, <-0.609, -0.713, -0.347>, <0.7778, 2.2905, 12.2397>, <-0.974, -0.226, 0.000> }
	smooth_triangle { <0.9816, 1.4397, 13.6103>, <-0.854, -0.492, -0.170>, <0.7778, 2.2905, 12.2397>, <-0.974, -0.226, 0.000>, <0.9745, 1.4694, 13.6288>, <-0.972, -0.233, 0.000> }
	smooth_triangle { <1.3545, -0.2827, 16.3413>, <-0.651, 0.640, 0.408>, <0.7778, 2.2905, 12.2397>, <-0.658, 0.599, 0.457>, <0.8044, 2.3125, 12.2490>, <-0.374, 0.767, 0.521> }
	smooth_triangle { <1.3545, -0.2827, 16.3413>, <-0.651, 0.640, 0.408>, <0.8044, 2.3125, 12.2490>, <-0.374, 0.767, 0.521>, <1.3738, -0.2677, 16.3483>, <-0.150, 0.880, 0.451> }
	smooth_triangle { <1.3738, -0.2677, 16.3483>, <-0.150, 0.880, 0.451>, <0.8044, 2.3125, 12.2490>, <-0.374, 0.767, 0.521>, <0.8380, 2.3049, 12.2397>, <0.610, 0.712, 0.349> }
	smooth_triangle { <1.3738, -0.2677, 16.3483>, <-0.150, 0.880, 0.451>, <0.8380, 2.3049, 12.2397>, <0.610, 0.712, 0.349>, <1.3976, -0.2736, 16.3413>, <0.779, 0.582, 0.234> }
	smooth_triangle { <1.3976, -0.2736, 16.3413>, <0.779, 0.582, 0.234>, <0.8380, 2.3049, 12.2397>, <0.610, 0.712, 0.349>, <0.8451, 2.2752, 12.2211>, <0.984, -0.056, -0.171> }
	smooth_triangle { <1.3976, -0.2736, 16.3413>, <0.779, 0.582, 0.234>, <0.8451, 2.2752, 12.2211>, <0.984, -0.056, -0.171>, <1.4019, -0.2943, 16.3274>, <0.930, -0.298, -0.216> }
	smooth_triangle { <1.4019, -0.2943, 16.3274>, <0.930, -0.298, -0.216>, <0.8451, 2.2752, 12.2211>, <0.984, -0.056, -0.171>, <0.8186, 2.2531, 12.2119>, <0.374, -0.768, -0.519> }
	smooth_triangle { <1.4019, -0.2943, 16.3274>, <0.930, -0.298, -0.216>, <0.8186, 2.2531, 12.2119>, <0.374, -0.768, -0.519>, <1.3826, -0.3092, 16.3204>, <0.150, -0.881, -0.450> }
	smooth_triangle { <1.3826, -0.3092, 16.3204>, <0.150, -0.881, -0.450>, <0.8186, 2.2531, 12.2119>, <0.374, -0.768, -0.519>, <0.7849, 2.2608, 12.2211>, <-0.609, -0.713, -0.347> }
	smooth_triangle { <1.3826, -0.3092, 16.3204>, <0.150, -0.881, -0.450>, <0.7849, 2.2608, 12.2211>, <-0.609, -0.713, -0.347>, <1.3589, -0.3034, 16.3274>, <-0.779, -0.583, -0.233> }
	smooth_triangle { <1.3589, -0.3034, 16.3274>, <-0.779, -0.583, -0.233>, <0.7849, 2.2608, 12.2211>, <-0.609, -0.713, -0.347>, <0.7778, 2.2905, 12.2397>, <-0.974, -0.226, 0.000> }
	smooth_triangle { <1.3589, -0.3034, 16.3274>, <-0.779, -0.583, -0.233>, <0.7778, 2.2905, 12.2397>, <-0.974, -0.226, 0.000>, <1.3545, -0.2827, 16.3413>, <-0.993, -0.115, -0.023> }
	smooth_triangle { <1.3282, -1.3513, 18.9728>, <-0.537, 0.791, 0.292>, <1.3545, -0.2827, 16.3413>, <-0.651, 0.640, 0.408>, <1.3738, -0.2677, 16.3483>, <-0.150, 0.880, 0.451> }
	smooth_triangle { <1.3282, -1.3513, 18.9728>, <-0.537, 0.791, 0.292>, <1.3738, -0.2677, 16.3483>, <-0.150, 0.880, 0.451>, <1.3505, -1.3402, 18.9776>, <0.001, 0.938, 0.347> }
	smooth_triangle { <1.3505, -1.3402, 18.9776>, <0.001, 0.938, 0.347>, <1.3738, -0.2677, 16.3483>, <-0.150, 0.880, 0.451>, <1.3976, -0.2736, 16.3413>, <0.779, 0.582, 0.234> }
	smooth_triangle { <1.3505, -1.3402, 18.9776>, <0.001, 0.938, 0.347>, <1.3976, -0.2736, 16.3413>, <0.779, 0.582, 0.234>, <1.3722, -1.3525, 18.9728>, <0.868, 0.460, 0.187> }
	smooth_triangle { <1.3722, -1.3525, 18.9728>, <0.868, 0.460, 0.187>, <1.3976, -0.2736, 16.3413>, <0.779, 0.582, 0.234>, <1.4019, -0.2943, 16.3274>, <0.930, -0.298, -0.216> }
	smooth_triangle { <1.3722, -1.3525, 18.9728>, <0.868, 0.460, 0.187>, <1.4019, -0.2943, 16.3274>, <0.930, -0.298, -0.216>, <1.3716, -1.3760, 18.9632>, <0.864, -0.477, -0.159> }
	smooth_triangle { <1.3716, -1.3760, 18.9632>, <0.864, -0.477, -0.159>, <1.4019, -0.2943, 16.3274>, <0.930, -0.298, -0.216>, <1.3826, -0.3092, 16.3204>, <0.150, -0.881, -0.450> }
	smooth_triangle { <1.3716, -1.3760, 18.9632>, <0.864, -0.477, -0.159>, <1.3826, -0.3092, 16.3204>, <0.150, -0.881, -0.450>, <1.3493, -1.3872, 18.9584>, <-0.001, -0.938, -0.347> }
	smooth_triangle { <1.3493, -1.3872, 18.9584>, <-0.001, -0.938, -0.347>, <1.3826, -0.3092, 16.3204>, <0.150, -0.881, -0.450>, <1.3589, -0.3034, 16.3274>, <-0.779, -0.583, -0.233> }
	smooth_triangle { <1.3493, -1.3872, 18.9584>, <-0.001, -0.938, -0.347>, <1.3589, -0.3034, 16.3274>, <-0.779, -0.583, -0.233>, <1.3276, -1.3749, 18.9632>, <-0.868, -0.460, -0.187> }
	smooth_triangle { <1.3276, -1.3749, 18.9632>, <-0.868, -0.460, -0.187>, <1.3589, -0.3034, 16.3274>, <-0.779, -0.583, -0.233>, <1.3545, -0.2827, 16.3413>, <-0.993, -0.115, -0.023> }
	smooth_triangle { <1.3276, -1.3749, 18.9632>, <-0.868, -0.460, -0.187>, <1.3545, -0.2827, 16.3413>, <-0.993, -0.115, -0.023>, <1.3282, -1.3513, 18.9728>, <-0.998, 0.059, -0.008> }
	smooth_triangle { <1.2265, -2.2527, 21.6676>, <-0.428, 0.867, 0.255>, <1.3282, -1.3513, 18.9728>, <-0.537, 0.791, 0.292>, <1.3505, -1.3402, 18.9776>, <0.001, 0.938, 0.347> }
	smooth_triangle { <1.2265, -2.2527, 21.6676>, <-0.428, 0.867, 0.255>, <1.3505, -1.3402, 18.9776>, <0.001, 0.938, 0.347>, <1.2497, -2.2433, 21.6717>, <0.116, 0.947, 0.298> }
	smooth_triangle { <1.2497, -2.2433, 21.6717>, <0.116, 0.947, 0.298>, <1.3505, -1.3402, 18.9776>, <0.001, 0.938, 0.347>, <1.3722, -1.3525, 18.9728>, <0.868, 0.460, 0.187> }
	smooth_triangle { <1.2497, -2.2433, 21.6717>, <0.116, 0.947, 0.298>, <1.3722, -1.3525, 18.9728>, <0.868, 0.460, 0.187>, <1.2702, -2.2577, 21.6676>, <0.917, 0.365, 0.160> }
	smooth_triangle { <1.2702, -2.2577, 21.6676>, <0.917, 0.365, 0.160>, <1.3722, -1.3525, 18.9728>, <0.868, 0.460, 0.187>, <1.3716, -1.3760, 18.9632>, <0.864, -0.477, -0.159> }
	smooth_triangle { <1.2702, -2.2577, 21.6676>, <0.917, 0.365, 0.160>, <1.3716, -1.3760, 18.9632>, <0.864, -0.477, -0.159>, <1.2675, -2.2816, 21.6595>, <0.801, -0.582, -0.138> }
	smooth_triangle { <1.2675, -2.2816, 21.6595>, <0.801, -0.582, -0.138>, <1.3716, -1.3760, 18.9632>, <0.864, -0.477, -0.159>, <1.3493, -1.3872, 18.9584>, <-0.001, -0.938, -0.347> }
	smooth_triangle { <1.2675, -2.2816, 21.6595>, <0.801, -0.582, -0.138>, <1.3493, -1.3872, 18.9584>, <-0.001, -0.938, -0.347>, <1.2443, -2.2911, 21.6554>, <-0.116, -0.947, -0.298> }
	smooth_triangle { <1.2443, -2.2911, 21.6554>, <-0.116, -0.947, -0.298>, <1.3493, -1.3872, 18.9584>, <-0.001, -0.938, -0.347>, <1.3276, -1.3749, 18.9632>, <-0.868, -0.460, -0.187> }
	smooth_triangle { <1.2443, -2.2911, 21.6554>, <-0.116, -0.947, -0.298>, <1.3276, -1.3749, 18.9632>, <-0.868, -0.460, -0.187>, <1.2238, -2.2766, 21.6595>, <-0.917, -0.365, -0.160> }
	smooth_triangle { <1.2238, -2.2766, 21.6595>, <-0.917, -0.365, -0.160>, <1.3276, -1.3749, 18.9632>, <-0.868, -0.460, -0.187>, <1.3282, -1.3513, 18.9728>, <-0.998, 0.059, -0.008> }
	smooth_triangle { <1.2238, -2.2766, 21.6595>, <-0.917, -0.365, -0.160>, <1.3282, -1.3513, 18.9728>, <-0.998, 0.059, -0.008>, <1.2265, -2.2527, 21.6676>, <-0.987, 0.161, -0.012> }
	smooth_triangle { <1.0593, -2.9226, 24.0048>, <-0.327, 0.892, 0.311>, <1.2265, -2.2527, 21.6676>, <-0.428, 0.867, 0.255>, <1.2497, -2.2433, 21.6717>, <0.116, 0.947, 0.298> }
	smooth_triangle { <1.0593, -2.9226, 24.0048>, <-0.327, 0.892, 0.311>, <1.2497, -2.2433, 21.6717>, <0.116, 0.947, 0.298>, <1.0836, -2.9162, 24.0084>, <0.310, 0.928, 0.206> }
	smooth_triangle { <1.0836, -2.9162, 24.0084>, <0.310, 0.928, 0.206>, <1.2497, -2.2433, 21.6717>, <0.116, 0.947, 0.298>, <1.2702, -2.2577, 21.6676>, <0.917, 0.365, 0.160> }
	smooth_triangle { <1.0836, -2.9162, 24.0084>, <0.310, 0.928, 0.206>, <1.2702, -2.2577, 21.6676>, <0.917, 0.365, 0.160>, <1.1020, -2.9334, 24.0048>, <0.956, 0.245, -0.162> }
	smooth_triangle { <1.1020, -2.9334, 24.0048>, <0.956, 0.245, -0.162>, <1.2702, -2.2577, 21.6676>, <0.917, 0.365, 0.160>, <1.2675, -2.2816, 21.6595>, <0.801, -0.582, -0.138> }
	smooth_triangle { <1.1020, -2.9334, 24.0048>, <0.956, 0.245, -0.162>, <1.2675, -2.2816, 21.6595>, <0.801, -0.582, -0.138>, <1.0960, -2.9570, 23.9976>, <0.636, -0.685, -0.355> }
	smooth_triangle { <1.0960, -2.9570, 23.9976>, <0.636, -0.685, -0.355>, <1.2675, -2.2816, 21.6595>, <0.801, -0.582, -0.138>, <1.2443, -2.2911, 21.6554>, <-0.116, -0.947, -0.298> }
	smooth_triangle { <1.0960, -2.9570, 23.9976>, <0.636, -0.685, -0.355>, <1.2443, -2.2911, 21.6554>, <-0.116, -0.947, -0.298>, <1.0717, -2.9634, 23.9940>, <-0.307, -0.933, -0.186> }
	smooth_triangle { <1.0717, -2.9634, 23.9940>, <-0.307, -0.933, -0.186>, <1.2443, -2.2911, 21.6554>, <-0.116, -0.947, -0.298>, <1.2238, -2.2766, 21.6595>, <-0.917, -0.365, -0.160> }
	smooth_triangle { <1.0717, -2.9634, 23.9940>, <-0.307, -0.933, -0.186>, <1.2238, -2.2766, 21.6595>, <-0.917, -0.365, -0.160>, <1.0534, -2.9462, 23.9976>, <-0.952, -0.247, 0.178> }
	smooth_triangle { <1.0534, -2.9462, 23.9976>, <-0.952, -0.247, 0.178>, <1.2238, -2.2766, 21.6595>, <-0.917, -0.365, -0.160>, <1.2265, -2.2527, 21.6676>, <-0.987, 0.161, -0.012> }
	smooth_triangle { <1.0534, -2.9462, 23.9976>, <-0.952, -0.247, 0.178>, <1.2265, -2.2527, 21.6676>, <-0.987, 0.161, -0.012>, <1.0593, -2.9226, 24.0048>, <-0.927, 0.125, 0.353> }
	smooth_triangle { <2.0984, -3.2244, 25.2343>, <-0.290, 0.843, 0.452>, <1.0593, -2.9226, 24.0048>, <-0.327, 0.892, 0.311>, <1.0836, -2.9162, 24.0084>, <0.201, 0.917, 0.344> }
	smooth_triangle { <2.0984, -3.2244, 25.2343>, <-0.567, -0.622, 0.540>, <1.0836, -2.9162, 24.0084>, <-0.768, -0.319, 0.555>, <2.0946, -3.2007, 25.2426>, <-0.726, 0.187, 0.662> }
	smooth_triangle { <2.0946, -3.2007, 25.2426>, <0.609, 0.720, -0.332>, <1.0836, -2.9162, 24.0084>, <0.457, 0.881, 0.121>, <1.1020, -2.9334, 24.0048>, <0.956, 0.245, -0.162> }
	smooth_triangle { <2.0946, -3.2007, 25.2426>, <-0.726, 0.187, 0.662>, <1.1020, -2.9334, 24.0048>, <-0.519, 0.649, 0.556>, <2.1093, -3.1818, 25.2343>, <-0.218, 0.943, 0.249> }
	smooth_triangle { <2.1093, -3.1818, 25.2343>, <0.773, -0.001, -0.634>, <1.1020, -2.9334, 24.0048>, <0.956, 0.245, -0.162>, <1.0960, -2.9570, 23.9976>, <0.636, -0.685, -0.355> }
	smooth_triangle { <2.1093, -3.1818, 25.2343>, <-0.218, 0.943, 0.249>, <1.0960, -2.9570, 23.9976>, <0.235, 0.972, -0.016>, <2.1278, -3.1865, 25.2176>, <0.505, 0.757, -0.414> }
	smooth_triangle { <2.1278, -3.1865, 25.2176>, <0.290, -0.866, -0.408>, <1.0960, -2.9570, 23.9976>, <0.636, -0.685, -0.355>, <1.0717, -2.9634, 23.9940>, <-0.201, -0.922, -0.331> }
	smooth_triangle { <2.1278, -3.1865, 25.2176>, <0.505, 0.757, -0.414>, <1.0717, -2.9634, 23.9940>, <0.744, 0.325, -0.583>, <2.1316, -3.2102, 25.2092>, <0.723, -0.185, -0.666> }
	smooth_triangle { <2.1316, -3.2102, 25.2092>, <-0.594, -0.713, 0.373>, <1.0717, -2.9634, 23.9940>, <-0.455, -0.884, -0.109>, <1.0534, -2.9462, 23.9976>, <-0.952, -0.247, 0.178> }
	smooth_triangle { <2.1316, -3.2102, 25.2092>, <0.723, -0.185, -0.666>, <1.0534, -2.9462, 23.9976>, <0.497, -0.644, -0.582>, <2.1169, -3.2292, 25.2176>, <0.215, -0.943, -0.255> }
	smooth_triangle { <2.1169, -3.2292, 25.2176>, <-0.755, -0.011, 0.656>, <1.0534, -2.9462, 23.9976>, <-0.952, -0.247, 0.178>, <1.0593, -2.9226, 24.0048>, <-0.927, 0.125, 0.353> }
	smooth_triangle { <2.1169, -3.2292, 25.2176>, <0.215, -0.943, -0.255>, <1.0593, -2.9226, 24.0048>, <-0.262, -0.965, -0.016>, <2.0984, -3.2244, 25.2343>, <-0.262, -0.965, -0.016> }
	smooth_triangle { <3.2358, -3.0862, 26.3954>, <-0.649, -0.332, 0.685>, <2.0984, -3.2244, 25.2343>, <-0.567, -0.622, 0.540>, <2.0946, -3.2007, 25.2426>, <-0.726, 0.187, 0.662> }
	smooth_triangle { <3.2358, -3.0862, 26.3954>, <-0.565, 0.653, 0.504>, <2.0946, -3.2007, 25.2426>, <-0.726, 0.187, 0.662>, <2.1093, -3.1818, 25.2343>, <-0.218, 0.943, 0.249> }
	smooth_triangle { <3.2358, -3.0862, 26.3954>, <0.099, 0.981, -0.167>, <2.1093, -3.1818, 25.2343>, <-0.218, 0.943, 0.249>, <2.1278, -3.1865, 25.2176>, <0.505, 0.757, -0.414> }
	smooth_triangle { <3.2358, -3.0862, 26.3954>, <0.678, 0.331, -0.656>, <2.1278, -3.1865, 25.2176>, <0.505, 0.757, -0.414>, <2.1316, -3.2102, 25.2092>, <0.723, -0.185, -0.666> }
	smooth_triangle { <3.2358, -3.0862, 26.3954>, <0.591, -0.654, -0.473>, <2.1316, -3.2102, 25.2092>, <0.723, -0.185, -0.666>, <2.1169, -3.2292, 25.2176>, <0.215, -0.943, -0.255> }
	smooth_triangle { <3.2358, -3.0862, 26.3954>, <-0.072, -0.978, 0.196>, <2.1169, -3.2292, 25.2176>, <0.215, -0.943, -0.255>, <2.0984, -3.2244, 25.2343>, <-0.567, -0.622, 0.540> }
	smooth_triangle { <1.4356, -3.6466, 22.5031>, <-0.561, 0.361, 0.745>, <1.2243, -2.2641, 21.6745>, <-0.530, 0.206, 0.823>, <1.2451, -2.2544, 21.6854>, <-0.234, 0.274, 0.933> }
	smooth_triangle { <1.4356, -3.6466, 22.5031>, <-0.561, 0.361, 0.745>, <1.2451, -2.2544, 21.6854>, <-0.234, 0.274, 0.933>, <1.4563, -3.6369, 22.5140>, <0.111, 0.523, 0.845> }
	smooth_triangle { <1.4563, -3.6369, 22.5140>, <0.111, 0.523, 0.845>, <1.2451, -2.2544, 21.6854>, <-0.234, 0.274, 0.933>, <1.2678, -2.2575, 21.6745>, <0.721, 0.282, 0.633> }
	smooth_triangle { <1.4563, -3.6369, 22.5140>, <0.111, 0.523, 0.845>, <1.2678, -2.2575, 21.6745>, <0.721, 0.282, 0.633>, <1.4791, -3.6400, 22.5031>, <0.909, 0.308, 0.282> }
	smooth_triangle { <1.4791, -3.6400, 22.5031>, <0.909, 0.308, 0.282>, <1.2678, -2.2575, 21.6745>, <0.721, 0.282, 0.633>, <1.2697, -2.2703, 21.6526>, <0.955, 0.007, -0.298> }
	smooth_triangle { <1.4791, -3.6400, 22.5031>, <0.909, 0.308, 0.282>, <1.2697, -2.2703, 21.6526>, <0.955, 0.007, -0.298>, <1.4810, -3.6528, 22.4813>, <0.798, -0.216, -0.563> }
	smooth_triangle { <1.4810, -3.6528, 22.4813>, <0.798, -0.216, -0.563>, <1.2697, -2.2703, 21.6526>, <0.955, 0.007, -0.298>, <1.2490, -2.2800, 21.6417>, <0.234, -0.274, -0.933> }
	smooth_triangle { <1.4810, -3.6528, 22.4813>, <0.798, -0.216, -0.563>, <1.2490, -2.2800, 21.6417>, <0.234, -0.274, -0.933>, <1.4602, -3.6625, 22.4703>, <-0.111, -0.523, -0.845> }
	smooth_triangle { <1.4602, -3.6625, 22.4703>, <-0.111, -0.523, -0.845>, <1.2490, -2.2800, 21.6417>, <0.234, -0.274, -0.933>, <1.2263, -2.2769, 21.6526>, <-0.722, -0.281, -0.633> }
	smooth_triangle { <1.4602, -3.6625, 22.4703>, <-0.111, -0.523, -0.845>, <1.2263, -2.2769, 21.6526>, <-0.722, -0.281, -0.633>, <1.4375, -3.6594, 22.4813>, <-0.909, -0.308, -0.282> }
	smooth_triangle { <1.4375, -3.6594, 22.4813>, <-0.909, -0.308, -0.282>, <1.2263, -2.2769, 21.6526>, <-0.722, -0.281, -0.633>, <1.2243, -2.2641, 21.6745>, <-0.994, -0.111, -0.014> }
	smooth_triangle { <1.4375, -3.6594, 22.4813>, <-0.909, -0.308, -0.282>, <1.2243, -2.2641, 21.6745>, <-0.994, -0.111, -0.014>, <1.4356, -3.6466, 22.5031>, <-0.989, -0.151, 0.000> }
	smooth_triangle { <1.4842, -6.0404, 22.0124>, <-0.495, -0.142, 0.857>, <1.2243, -2.2641, 21.6745>, <-0.530, 0.206, 0.823>, <1.2451, -2.2544, 21.6854>, <-0.234, 0.274, 0.933> }
	smooth_triangle { <1.4842, -6.0404, 22.0124>, <-0.495, -0.142, 0.857>, <1.2451, -2.2544, 21.6854>, <-0.234, 0.274, 0.933>, <1.5062, -6.0425, 22.0249>, <-0.190, -0.097, 0.977> }
	smooth_triangle { <1.5062, -6.0425, 22.0249>, <0.086, -0.262, 0.961>, <1.2451, -2.2544, 21.6854>, <-0.234, 0.274, 0.933>, <1.2678, -2.2575, 21.6745>, <0.721, 0.282, 0.633> }
	smooth_triangle { <1.5062, -6.0425, 22.0249>, <0.086, -0.262, 0.961>, <1.2678, -2.2575, 21.6745>, <0.721, 0.282, 0.633>, <1.5282, -6.0395, 22.0124>, <0.767, -0.351, 0.538> }
	smooth_triangle { <1.5282, -6.0395, 22.0124>, <0.968, -0.077, 0.238>, <1.2678, -2.2575, 21.6745>, <0.721, 0.282, 0.633>, <1.2697, -2.2703, 21.6526>, <0.955, 0.007, -0.298> }
	smooth_triangle { <1.5282, -6.0395, 22.0124>, <0.968, -0.077, 0.238>, <1.2697, -2.2703, 21.6526>, <0.955, 0.007, -0.298>, <1.5281, -6.0344, 21.9876>, <0.837, -0.133, -0.530> }
	smooth_triangle { <1.5281, -6.0344, 21.9876>, <0.837, -0.133, -0.530>, <1.2697, -2.2703, 21.6526>, <0.955, 0.007, -0.298>, <1.2490, -2.2800, 21.6417>, <0.234, -0.274, -0.933> }
	smooth_triangle { <1.5281, -6.0344, 21.9876>, <0.837, -0.133, -0.530>, <1.2490, -2.2800, 21.6417>, <0.234, -0.274, -0.933>, <1.5060, -6.0323, 21.9751>, <0.191, 0.096, -0.977> }
	smooth_triangle { <1.5060, -6.0323, 21.9751>, <-0.086, 0.261, -0.962>, <1.2490, -2.2800, 21.6417>, <0.234, -0.274, -0.933>, <1.2263, -2.2769, 21.6526>, <-0.722, -0.281, -0.633> }
	smooth_triangle { <1.5060, -6.0323, 21.9751>, <-0.086, 0.261, -0.962>, <1.2263, -2.2769, 21.6526>, <-0.722, -0.281, -0.633>, <1.4841, -6.0353, 21.9876>, <-0.766, 0.353, -0.537> }
	smooth_triangle { <1.4841, -6.0353, 21.9876>, <-0.968, 0.077, -0.238>, <1.2263, -2.2769, 21.6526>, <-0.722, -0.281, -0.633>, <1.2243, -2.2641, 21.6745>, <-0.994, -0.111, -0.014> }
	smooth_triangle { <1.4841, -6.0353, 21.9876>, <-0.968, 0.077, -0.238>, <1.2243, -2.2641, 21.6745>, <-0.994, -0.111, -0.014>, <1.4842, -6.0404, 22.0124>, <-0.928, 0.370, 0.036> }
	smooth_triangle { <0.3979, -7.4620, 20.3602>, <-0.669, -0.280, 0.689>, <1.4842, -6.0404, 22.0124>, <-0.495, -0.142, 0.857>, <1.5062, -6.0425, 22.0249>, <-0.088, -0.260, 0.962> }
	smooth_triangle { <0.3979, -7.4620, 20.3602>, <-0.841, -0.133, 0.525>, <1.5062, -6.0425, 22.0249>, <-0.590, -0.214, 0.778>, <0.4103, -7.4821, 20.3696>, <-0.366, -0.468, 0.804> }
	smooth_triangle { <0.4103, -7.4821, 20.3696>, <0.210, -0.718, 0.663>, <1.5062, -6.0425, 22.0249>, <0.255, -0.334, 0.907>, <1.5282, -6.0395, 22.0124>, <0.540, -0.613, 0.576> }
	smooth_triangle { <0.4103, -7.4821, 20.3696>, <-0.215, -0.586, 0.781>, <1.5282, -6.0395, 22.0124>, <0.540, -0.613, 0.576>, <0.4330, -7.4886, 20.3602>, <0.657, -0.655, 0.374> }
	smooth_triangle { <0.4330, -7.4886, 20.3602>, <0.657, -0.655, 0.374>, <1.5282, -6.0395, 22.0124>, <0.828, -0.495, 0.265>, <1.5281, -6.0344, 21.9876>, <0.857, -0.270, -0.438> }
	smooth_triangle { <0.4330, -7.4886, 20.3602>, <0.657, -0.655, 0.374>, <1.5281, -6.0344, 21.9876>, <0.857, -0.270, -0.438>, <0.4434, -7.4749, 20.3415>, <0.930, -0.195, -0.313> }
	smooth_triangle { <0.4434, -7.4749, 20.3415>, <0.667, 0.274, -0.693>, <1.5281, -6.0344, 21.9876>, <0.694, 0.135, -0.707>, <1.5060, -6.0323, 21.9751>, <0.089, 0.259, -0.962> }
	smooth_triangle { <0.4434, -7.4749, 20.3415>, <0.895, -0.043, -0.444>, <1.5060, -6.0323, 21.9751>, <0.591, 0.213, -0.778>, <0.4310, -7.4548, 20.3321>, <0.364, 0.463, -0.808> }
	smooth_triangle { <0.4310, -7.4548, 20.3321>, <-0.212, 0.717, -0.664>, <1.5060, -6.0323, 21.9751>, <-0.255, 0.332, -0.908>, <1.4841, -6.0353, 21.9876>, <-0.539, 0.616, -0.574> }
	smooth_triangle { <0.4310, -7.4548, 20.3321>, <0.213, 0.582, -0.785>, <1.4841, -6.0353, 21.9876>, <-0.539, 0.616, -0.574>, <0.4083, -7.4483, 20.3415>, <-0.658, 0.652, -0.376> }
	smooth_triangle { <0.4083, -7.4483, 20.3415>, <-0.736, 0.643, -0.215>, <1.4841, -6.0353, 21.9876>, <-0.827, 0.497, -0.264>, <1.4842, -6.0404, 22.0124>, <-0.928, 0.370, 0.036> }
	smooth_triangle { <0.4083, -7.4483, 20.3415>, <-0.658, 0.652, -0.376>, <1.4842, -6.0404, 22.0124>, <-0.928, 0.370, 0.036>, <0.3979, -7.4620, 20.3602>, <-0.796, 0.606, 0.002> }
	smooth_triangle { <-0.1533, -9.5489, 19.2159>, <-0.749, -0.160, 0.643>, <0.3979, -7.4620, 20.3602>, <-0.841, -0.133, 0.525>, <0.4103, -7.4821, 20.3696>, <-0.366, -0.468, 0.804> }
	smooth_triangle { <-0.1533, -9.5489, 19.2159>, <0.171, -0.519, 0.837>, <0.4103, -7.4821, 20.3696>, <-0.215, -0.586, 0.781>, <0.4330, -7.4886, 20.3602>, <0.657, -0.655, 0.374> }
	smooth_triangle { <-0.1533, -9.5489, 19.2159>, <0.907, -0.372, 0.196>, <0.4330, -7.4886, 20.3602>, <0.657, -0.655, 0.374>, <0.4434, -7.4749, 20.3415>, <0.930, -0.195, -0.313> }
	smooth_triangle { <-0.1533, -9.5489, 19.2159>, <0.739, 0.140, -0.659>, <0.4434, -7.4749, 20.3415>, <0.895, -0.043, -0.444>, <0.4310, -7.4548, 20.3321>, <0.364, 0.463, -0.808> }
	smooth_triangle { <-0.1533, -9.5489, 19.2159>, <-0.179, 0.498, -0.849>, <0.4310, -7.4548, 20.3321>, <0.213, 0.582, -0.785>, <0.4083, -7.4483, 20.3415>, <-0.567, 0.656, -0.498> }
	smooth_triangle { <-0.1533, -9.5489, 19.2159>, <-0.912, 0.351, -0.210>, <0.4083, -7.4483, 20.3415>, <-0.658, 0.652, -0.376>, <0.3979, -7.4620, 20.3602>, <-0.916, 0.017, 0.402> }
	smooth_triangle { <0.2183, -2.2292, 22.9219>, <0.674, 0.490, 0.553>, <1.2571, -2.2453, 21.6717>, <0.662, 0.490, 0.568>, <1.2666, -2.2675, 21.6798>, <0.748, 0.196, 0.634> }
	smooth_triangle { <0.2183, -2.2292, 22.9219>, <0.674, 0.490, 0.553>, <1.2666, -2.2675, 21.6798>, <0.748, 0.196, 0.634>, <0.2277, -2.2513, 22.9300>, <0.752, -0.201, 0.628> }
	smooth_triangle { <0.2277, -2.2513, 22.9300>, <0.752, -0.201, 0.628>, <1.2666, -2.2675, 21.6798>, <0.748, 0.196, 0.634>, <1.2564, -2.2893, 21.6717>, <0.514, -0.751, 0.415> }
	smooth_triangle { <0.2277, -2.2513, 22.9300>, <0.752, -0.201, 0.628>, <1.2564, -2.2893, 21.6717>, <0.514, -0.751, 0.415>, <0.2176, -2.2732, 22.9219>, <0.237, -0.949, 0.209> }
	smooth_triangle { <0.2176, -2.2732, 22.9219>, <0.237, -0.949, 0.209>, <1.2564, -2.2893, 21.6717>, <0.514, -0.751, 0.415>, <1.2369, -2.2890, 21.6554>, <-0.234, -0.947, -0.219> }
	smooth_triangle { <0.2176, -2.2732, 22.9219>, <0.237, -0.949, 0.209>, <1.2369, -2.2890, 21.6554>, <-0.234, -0.947, -0.219>, <0.1981, -2.2729, 22.9057>, <-0.515, -0.748, -0.418> }
	smooth_triangle { <0.1981, -2.2729, 22.9057>, <-0.515, -0.748, -0.418>, <1.2369, -2.2890, 21.6554>, <-0.234, -0.947, -0.219>, <1.2275, -2.2669, 21.6473>, <-0.748, -0.196, -0.634> }
	smooth_triangle { <0.1981, -2.2729, 22.9057>, <-0.515, -0.748, -0.418>, <1.2275, -2.2669, 21.6473>, <-0.748, -0.196, -0.634>, <0.1887, -2.2507, 22.8976>, <-0.752, 0.201, -0.628> }
	smooth_triangle { <0.1887, -2.2507, 22.8976>, <-0.752, 0.201, -0.628>, <1.2275, -2.2669, 21.6473>, <-0.748, -0.196, -0.634>, <1.2376, -2.2450, 21.6554>, <-0.514, 0.751, -0.414> }
	smooth_triangle { <0.1887, -2.2507, 22.8976>, <-0.752, 0.201, -0.628>, <1.2376, -2.2450, 21.6554>, <-0.514, 0.751, -0.414>, <0.1988, -2.2289, 22.9057>, <-0.237, 0.949, -0.209> }
	smooth_triangle { <0.1988, -2.2289, 22.9057>, <-0.237, 0.949, -0.209>, <1.2376, -2.2450, 21.6554>, <-0.514, 0.751, -0.414>, <1.2571, -2.2453, 21.6717>, <-0.023, 1.000, 0.004> }
	smooth_triangle { <0.1988, -2.2289, 22.9057>, <-0.237, 0.949, -0.209>, <1.2571, -2.2453, 21.6717>, <-0.023, 1.000, 0.004>, <0.2183, -2.2292, 22.9219>, <0.016, 1.000, 0.000> }
	smooth_triangle { <-1.3702, -2.4327, 24.7637>, <0.597, 0.549, 0.585>, <1.2571, -2.2453, 21.6717>, <0.662, 0.490, 0.568>, <1.2666, -2.2675, 21.6798>, <0.748, 0.196, 0.634> }
	smooth_triangle { <-1.3702, -2.4327, 24.7637>, <0.597, 0.549, 0.585>, <1.2666, -2.2675, 21.6798>, <0.748, 0.196, 0.634>, <-1.3579, -2.4533, 24.7720>, <0.679, 0.127, 0.723> }
	smooth_triangle { <-1.3579, -2.4533, 24.7720>, <0.589, 0.040, 0.807>, <1.2666, -2.2675, 21.6798>, <0.748, 0.196, 0.634>, <1.2564, -2.2893, 21.6717>, <0.514, -0.751, 0.415> }
	smooth_triangle { <-1.3579, -2.4533, 24.7720>, <0.589, 0.040, 0.807>, <1.2564, -2.2893, 21.6717>, <0.514, -0.751, 0.415>, <-1.3646, -2.4763, 24.7637>, <0.079, -0.814, 0.575> }
	smooth_triangle { <-1.3646, -2.4763, 24.7637>, <0.087, -0.884, 0.460>, <1.2564, -2.2893, 21.6717>, <0.514, -0.751, 0.415>, <1.2369, -2.2890, 21.6554>, <-0.234, -0.947, -0.219> }
	smooth_triangle { <-1.3646, -2.4763, 24.7637>, <0.079, -0.814, 0.575>, <1.2369, -2.2890, 21.6554>, <-0.234, -0.947, -0.219>, <-1.3836, -2.4788, 24.7470>, <-0.504, -0.831, -0.236> }
	smooth_triangle { <-1.3836, -2.4788, 24.7470>, <-0.496, -0.778, -0.386>, <1.2369, -2.2890, 21.6554>, <-0.234, -0.947, -0.219>, <1.2275, -2.2669, 21.6473>, <-0.748, -0.196, -0.634> }
	smooth_triangle { <-1.3836, -2.4788, 24.7470>, <-0.504, -0.831, -0.236>, <1.2275, -2.2669, 21.6473>, <-0.748, -0.196, -0.634>, <-1.3960, -2.4582, 24.7387>, <-0.679, -0.127, -0.723> }
	smooth_triangle { <-1.3960, -2.4582, 24.7387>, <-0.588, -0.040, -0.808>, <1.2275, -2.2669, 21.6473>, <-0.748, -0.196, -0.634>, <1.2376, -2.2450, 21.6554>, <-0.514, 0.751, -0.414> }
	smooth_triangle { <-1.3960, -2.4582, 24.7387>, <-0.588, -0.040, -0.808>, <1.2376, -2.2450, 21.6554>, <-0.514, 0.751, -0.414>, <-1.3893, -2.4352, 24.7470>, <-0.075, 0.813, -0.577> }
	smooth_triangle { <-1.3893, -2.4352, 24.7470>, <-0.085, 0.883, -0.462>, <1.2376, -2.2450, 21.6554>, <-0.514, 0.751, -0.414>, <1.2571, -2.2453, 21.6717>, <-0.023, 1.000, 0.004> }
	smooth_triangle { <-1.3893, -2.4352, 24.7470>, <-0.075, 0.813, -0.577>, <1.2571, -2.2453, 21.6717>, <-0.023, 1.000, 0.004>, <-1.3702, -2.4327, 24.7637>, <0.287, 0.937, -0.199> }
	smooth_triangle { <-3.3648, -1.1503, 25.2943>, <0.656, 0.278, 0.701>, <-1.3702, -2.4327, 24.7637>, <0.597, 0.549, 0.585>, <-1.3579, -2.4533, 24.7720>, <0.589, 0.040, 0.807> }
	smooth_triangle { <-3.3648, -1.1503, 25.2943>, <0.656, 0.278, 0.701>, <-1.3579, -2.4533, 24.7720>, <0.589, 0.040, 0.807>, <-3.3744, -1.1702, 25.3067>, <0.378, -0.316, 0.870> }
	smooth_triangle { <-3.3744, -1.1702, 25.3067>, <0.378, -0.316, 0.870>, <-1.3579, -2.4533, 24.7720>, <0.556, -0.089, 0.827>, <-1.3646, -2.4763, 24.7637>, <0.088, -0.721, 0.687> }
	smooth_triangle { <-3.3744, -1.1702, 25.3067>, <0.378, -0.316, 0.870>, <-1.3646, -2.4763, 24.7637>, <0.079, -0.814, 0.575>, <-3.3886, -1.1873, 25.2943>, <-0.393, -0.737, 0.550> }
	smooth_triangle { <-3.3886, -1.1873, 25.2943>, <-0.393, -0.737, 0.550>, <-1.3646, -2.4763, 24.7637>, <0.079, -0.814, 0.575>, <-1.3836, -2.4788, 24.7470>, <-0.401, -0.916, 0.001> }
	smooth_triangle { <-3.3886, -1.1873, 25.2943>, <-0.393, -0.737, 0.550>, <-1.3836, -2.4788, 24.7470>, <-0.504, -0.831, -0.236>, <-3.3932, -1.1843, 25.2695>, <-0.811, -0.464, -0.357> }
	smooth_triangle { <-3.3932, -1.1843, 25.2695>, <-0.811, -0.464, -0.357>, <-1.3836, -2.4788, 24.7470>, <-0.496, -0.778, -0.386>, <-1.3960, -2.4582, 24.7387>, <-0.588, -0.040, -0.808> }
	smooth_triangle { <-3.3932, -1.1843, 25.2695>, <-0.811, -0.464, -0.357>, <-1.3960, -2.4582, 24.7387>, <-0.588, -0.040, -0.808>, <-3.3836, -1.1643, 25.2571>, <-0.374, 0.314, -0.872> }
	smooth_triangle { <-3.3836, -1.1643, 25.2571>, <-0.374, 0.314, -0.872>, <-1.3960, -2.4582, 24.7387>, <-0.554, 0.089, -0.828>, <-1.3893, -2.4352, 24.7470>, <-0.084, 0.720, -0.689> }
	smooth_triangle { <-3.3836, -1.1643, 25.2571>, <-0.374, 0.314, -0.872>, <-1.3893, -2.4352, 24.7470>, <-0.075, 0.813, -0.577>, <-3.3694, -1.1473, 25.2695>, <0.396, 0.735, -0.551> }
	smooth_triangle { <-3.3694, -1.1473, 25.2695>, <0.396, 0.735, -0.551>, <-1.3893, -2.4352, 24.7470>, <-0.075, 0.813, -0.577>, <-1.3702, -2.4327, 24.7637>, <0.287, 0.937, -0.199> }
	smooth_triangle { <-3.3694, -1.1473, 25.2695>, <0.396, 0.735, -0.551>, <-1.3702, -2.4327, 24.7637>, <0.287, 0.937, -0.199>, <-3.3648, -1.1503, 25.2943>, <0.827, 0.561, -0.040> }
	smooth_triangle { <-3.8955, 0.3007, 26.5888>, <0.879, -0.216, 0.424>, <-3.3648, -1.1503, 25.2943>, <0.656, 0.278, 0.701>, <-3.3744, -1.1702, 25.3067>, <0.378, -0.316, 0.870> }
	smooth_triangle { <-3.8955, 0.3007, 26.5888>, <0.879, -0.216, 0.424>, <-3.3744, -1.1702, 25.3067>, <0.378, -0.316, 0.870>, <-3.9133, 0.2855, 26.5986>, <0.191, -0.600, 0.776> }
	smooth_triangle { <-3.9133, 0.2855, 26.5986>, <0.191, -0.600, 0.776>, <-3.3744, -1.1702, 25.3067>, <0.378, -0.316, 0.870>, <-3.3886, -1.1873, 25.2943>, <-0.258, -0.752, 0.607> }
	smooth_triangle { <-3.9133, 0.2855, 26.5986>, <0.191, -0.600, 0.776>, <-3.3886, -1.1873, 25.2943>, <-0.393, -0.737, 0.550>, <-3.9368, 0.2855, 26.5888>, <-0.778, -0.484, 0.400> }
	smooth_triangle { <-3.9368, 0.2855, 26.5888>, <-0.778, -0.484, 0.400>, <-3.3886, -1.1873, 25.2943>, <-0.488, -0.729, 0.480>, <-3.3932, -1.1843, 25.2695>, <-0.811, -0.464, -0.357> }
	smooth_triangle { <-3.9368, 0.2855, 26.5888>, <-0.778, -0.484, 0.400>, <-3.3932, -1.1843, 25.2695>, <-0.811, -0.464, -0.357>, <-3.9424, 0.3008, 26.5692>, <-0.933, 0.104, -0.344> }
	smooth_triangle { <-3.9424, 0.3008, 26.5692>, <-0.933, 0.104, -0.344>, <-3.3932, -1.1843, 25.2695>, <-0.811, -0.464, -0.357>, <-3.3836, -1.1643, 25.2571>, <-0.374, 0.314, -0.872> }
	smooth_triangle { <-3.9424, 0.3008, 26.5692>, <-0.933, 0.104, -0.344>, <-3.3836, -1.1643, 25.2571>, <-0.374, 0.314, -0.872>, <-3.9245, 0.3160, 26.5595>, <-0.192, 0.608, -0.771> }
	smooth_triangle { <-3.9245, 0.3160, 26.5595>, <-0.192, 0.608, -0.771>, <-3.3836, -1.1643, 25.2571>, <-0.374, 0.314, -0.872>, <-3.3694, -1.1473, 25.2695>, <0.260, 0.750, -0.608> }
	smooth_triangle { <-3.9245, 0.3160, 26.5595>, <-0.192, 0.608, -0.771>, <-3.3694, -1.1473, 25.2695>, <0.396, 0.735, -0.551>, <-3.9011, 0.3160, 26.5692>, <0.777, 0.490, -0.395> }
	smooth_triangle { <-3.9011, 0.3160, 26.5692>, <0.777, 0.490, -0.395>, <-3.3694, -1.1473, 25.2695>, <0.490, 0.727, -0.481>, <-3.3648, -1.1503, 25.2943>, <0.827, 0.561, -0.040> }
	smooth_triangle { <-3.9011, 0.3160, 26.5692>, <0.777, 0.490, -0.395>, <-3.3648, -1.1503, 25.2943>, <0.827, 0.561, -0.040>, <-3.8955, 0.3007, 26.5888>, <0.939, 0.344, -0.001> }
	smooth_triangle { <-3.8628, 1.9319, 27.7895>, <0.679, -0.439, 0.588>, <-3.8955, 0.3007, 26.5888>, <0.879, -0.216, 0.424>, <-3.9133, 0.2855, 26.5986>, <0.191, -0.600, 0.776> }
	smooth_triangle { <-3.8628, 1.9319, 27.7895>, <-0.306, -0.548, 0.779>, <-3.9133, 0.2855, 26.5986>, <0.191, -0.600, 0.776>, <-3.9368, 0.2855, 26.5888>, <-0.778, -0.484, 0.400> }
	smooth_triangle { <-3.8628, 1.9319, 27.7895>, <-0.975, -0.097, 0.201>, <-3.9368, 0.2855, 26.5888>, <-0.778, -0.484, 0.400>, <-3.9424, 0.3008, 26.5692>, <-0.933, 0.104, -0.344> }
	smooth_triangle { <-3.8628, 1.9319, 27.7895>, <-0.682, 0.463, -0.566>, <-3.9424, 0.3008, 26.5692>, <-0.933, 0.104, -0.344>, <-3.9245, 0.3160, 26.5595>, <-0.192, 0.608, -0.771> }
	smooth_triangle { <-3.8628, 1.9319, 27.7895>, <0.302, 0.574, -0.761>, <-3.9245, 0.3160, 26.5595>, <-0.192, 0.608, -0.771>, <-3.9011, 0.3160, 26.5692>, <0.777, 0.490, -0.395> }
	smooth_triangle { <-3.8628, 1.9319, 27.7895>, <0.976, 0.121, -0.183>, <-3.9011, 0.3160, 26.5692>, <0.777, 0.490, -0.395>, <-3.8955, 0.3007, 26.5888>, <0.879, -0.216, 0.424> }
	smooth_triangle { <0.3046, -1.5522, 20.1989>, <0.540, 0.619, 0.571>, <1.3549, -1.3402, 18.9764>, <0.501, 0.610, 0.614>, <1.3686, -1.3599, 18.9847>, <0.630, 0.297, 0.718> }
	smooth_triangle { <0.3046, -1.5522, 20.1989>, <0.540, 0.619, 0.571>, <1.3686, -1.3599, 18.9847>, <0.630, 0.297, 0.718>, <0.3184, -1.5719, 20.2073>, <0.761, -0.039, 0.647> }
	smooth_triangle { <0.3184, -1.5719, 20.2073>, <0.761, -0.039, 0.647>, <1.3686, -1.3599, 18.9847>, <0.630, 0.297, 0.718>, <1.3636, -1.3834, 18.9764>, <0.542, -0.675, 0.500> }
	smooth_triangle { <0.3184, -1.5719, 20.2073>, <0.761, -0.039, 0.647>, <1.3636, -1.3834, 18.9764>, <0.542, -0.675, 0.500>, <0.3133, -1.5953, 20.1989>, <0.428, -0.878, 0.216> }
	smooth_triangle { <0.3133, -1.5953, 20.1989>, <0.428, -0.878, 0.216>, <1.3636, -1.3834, 18.9764>, <0.542, -0.675, 0.500>, <1.3449, -1.3871, 18.9596>, <-0.088, -0.972, -0.218> }
	smooth_triangle { <0.3133, -1.5953, 20.1989>, <0.428, -0.878, 0.216>, <1.3449, -1.3871, 18.9596>, <-0.088, -0.972, -0.218>, <0.2946, -1.5991, 20.1821>, <-0.333, -0.838, -0.431> }
	smooth_triangle { <0.2946, -1.5991, 20.1821>, <-0.333, -0.838, -0.431>, <1.3449, -1.3871, 18.9596>, <-0.088, -0.972, -0.218>, <1.3312, -1.3675, 18.9512>, <-0.629, -0.297, -0.718> }
	smooth_triangle { <0.2946, -1.5991, 20.1821>, <-0.333, -0.838, -0.431>, <1.3312, -1.3675, 18.9512>, <-0.629, -0.297, -0.718>, <0.2809, -1.5794, 20.1738>, <-0.761, 0.039, -0.647> }
	smooth_triangle { <0.2809, -1.5794, 20.1738>, <-0.761, 0.039, -0.647>, <1.3312, -1.3675, 18.9512>, <-0.629, -0.297, -0.718>, <1.3362, -1.3440, 18.9596>, <-0.542, 0.675, -0.500> }
	smooth_triangle { <0.2809, -1.5794, 20.1738>, <-0.761, 0.039, -0.647>, <1.3362, -1.3440, 18.9596>, <-0.542, 0.675, -0.500>, <0.2859, -1.5560, 20.1821>, <-0.428, 0.878, -0.216> }
	smooth_triangle { <0.2859, -1.5560, 20.1821>, <-0.428, 0.878, -0.216>, <1.3362, -1.3440, 18.9596>, <-0.542, 0.675, -0.500>, <1.3549, -1.3402, 18.9764>, <-0.133, 0.991, -0.018> }
	smooth_triangle { <0.2859, -1.5560, 20.1821>, <-0.428, 0.878, -0.216>, <1.3549, -1.3402, 18.9764>, <-0.133, 0.991, -0.018>, <0.3046, -1.5522, 20.1989>, <-0.198, 0.980, 0.000> }
	smooth_triangle { <-2.1729, -1.4913, 21.5951>, <0.450, 0.527, 0.721>, <1.3549, -1.3402, 18.9764>, <0.501, 0.610, 0.614>, <1.3686, -1.3599, 18.9847>, <0.630, 0.297, 0.718> }
	smooth_triangle { <-2.1729, -1.4913, 21.5951>, <0.450, 0.527, 0.721>, <1.3686, -1.3599, 18.9847>, <0.630, 0.297, 0.718>, <-2.1672, -1.5134, 21.6062>, <0.583, 0.089, 0.808> }
	smooth_triangle { <-2.1672, -1.5134, 21.6062>, <0.672, -0.072, 0.737>, <1.3686, -1.3599, 18.9847>, <0.630, 0.297, 0.718>, <1.3636, -1.3834, 18.9764>, <0.542, -0.675, 0.500> }
	smooth_triangle { <-2.1672, -1.5134, 21.6062>, <0.672, -0.072, 0.737>, <1.3636, -1.3834, 18.9764>, <0.542, -0.675, 0.500>, <-2.1740, -1.5353, 21.5951>, <0.613, -0.738, 0.280> }
	smooth_triangle { <-2.1740, -1.5353, 21.5951>, <0.504, -0.850, 0.149>, <1.3636, -1.3834, 18.9764>, <0.542, -0.675, 0.500>, <1.3449, -1.3871, 18.9596>, <-0.088, -0.972, -0.218> }
	smooth_triangle { <-2.1740, -1.5353, 21.5951>, <0.504, -0.850, 0.149>, <1.3449, -1.3871, 18.9596>, <-0.088, -0.972, -0.218>, <-2.1864, -1.5349, 21.5730>, <0.019, -0.837, -0.547> }
	smooth_triangle { <-2.1864, -1.5349, 21.5730>, <-0.176, -0.783, -0.597>, <1.3449, -1.3871, 18.9596>, <-0.088, -0.972, -0.218>, <1.3312, -1.3675, 18.9512>, <-0.629, -0.297, -0.718> }
	smooth_triangle { <-2.1864, -1.5349, 21.5730>, <-0.368, -0.710, -0.600>, <1.3312, -1.3675, 18.9512>, <-0.629, -0.297, -0.718>, <-2.1921, -1.5128, 21.5619>, <-0.585, -0.089, -0.806> }
	smooth_triangle { <-2.1921, -1.5128, 21.5619>, <-0.675, 0.071, -0.734>, <1.3312, -1.3675, 18.9512>, <-0.629, -0.297, -0.718>, <1.3362, -1.3440, 18.9596>, <-0.542, 0.675, -0.500> }
	smooth_triangle { <-2.1921, -1.5128, 21.5619>, <-0.675, 0.071, -0.734>, <1.3362, -1.3440, 18.9596>, <-0.542, 0.675, -0.500>, <-2.1853, -1.4910, 21.5730>, <-0.613, 0.739, -0.280> }
	smooth_triangle { <-2.1853, -1.4910, 21.5730>, <-0.506, 0.850, -0.147>, <1.3362, -1.3440, 18.9596>, <-0.542, 0.675, -0.500>, <1.3549, -1.3402, 18.9764>, <-0.133, 0.991, -0.018> }
	smooth_triangle { <-2.1853, -1.4910, 21.5730>, <-0.506, 0.850, -0.147>, <1.3549, -1.3402, 18.9764>, <-0.133, 0.991, -0.018>, <-2.1729, -1.4913, 21.5951>, <-0.527, 0.839, 0.134> }
	smooth_triangle { <-3.2637, -3.0771, 23.1090>, <-0.001, 0.577, 0.817>, <-2.1729, -1.4913, 21.5951>, <0.450, 0.527, 0.721>, <-2.1672, -1.5134, 21.6062>, <0.451, 0.197, 0.870> }
	smooth_triangle { <-3.2637, -3.0771, 23.1090>, <-0.280, 0.583, 0.763>, <-2.1672, -1.5134, 21.6062>, <0.270, 0.594, 0.758>, <-3.2411, -3.0829, 23.1189>, <0.301, 0.426, 0.853> }
	smooth_triangle { <-3.2411, -3.0829, 23.1189>, <0.819, -0.031, 0.572>, <-2.1672, -1.5134, 21.6062>, <0.707, -0.227, 0.670>, <-2.1740, -1.5353, 21.5951>, <0.613, -0.738, 0.280> }
	smooth_triangle { <-3.2411, -3.0829, 23.1189>, <0.500, 0.278, 0.820>, <-2.1740, -1.5353, 21.5951>, <0.775, -0.265, 0.574>, <-3.2273, -3.1017, 23.1090>, <0.925, -0.165, 0.342> }
	smooth_triangle { <-3.2273, -3.1017, 23.1090>, <0.812, -0.552, -0.191>, <-2.1740, -1.5353, 21.5951>, <0.504, -0.850, 0.149>, <-2.1864, -1.5349, 21.5730>, <0.154, -0.871, -0.467> }
	smooth_triangle { <-3.2273, -3.1017, 23.1090>, <0.926, -0.319, 0.204>, <-2.1864, -1.5349, 21.5730>, <0.530, -0.837, -0.137>, <-3.2361, -3.1148, 23.0891>, <0.623, -0.593, -0.510> }
	smooth_triangle { <-3.2361, -3.1148, 23.0891>, <-0.004, -0.581, -0.814>, <-2.1864, -1.5349, 21.5730>, <-0.176, -0.783, -0.597>, <-2.1921, -1.5128, 21.5619>, <-0.453, -0.196, -0.870> }
	smooth_triangle { <-3.2361, -3.1148, 23.0891>, <0.439, -0.634, -0.636>, <-2.1921, -1.5128, 21.5619>, <-0.273, -0.593, -0.758>, <-3.2587, -3.1090, 23.0791>, <-0.303, -0.430, -0.851> }
	smooth_triangle { <-3.2587, -3.1090, 23.0791>, <-0.822, 0.028, -0.568>, <-2.1921, -1.5128, 21.5619>, <-0.709, 0.226, -0.668>, <-2.1853, -1.4910, 21.5730>, <-0.613, 0.739, -0.280> }
	smooth_triangle { <-3.2587, -3.1090, 23.0791>, <-0.503, -0.282, -0.817>, <-2.1853, -1.4910, 21.5730>, <-0.774, 0.267, -0.574>, <-3.2725, -3.0902, 23.0891>, <-0.926, 0.162, -0.340> }
	smooth_triangle { <-3.2725, -3.0902, 23.0891>, <-0.812, 0.551, 0.192>, <-2.1853, -1.4910, 21.5730>, <-0.506, 0.850, -0.147>, <-2.1729, -1.4913, 21.5951>, <-0.527, 0.839, 0.134> }
	smooth_triangle { <-3.2725, -3.0902, 23.0891>, <-0.927, 0.316, -0.202>, <-2.1729, -1.4913, 21.5951>, <-0.527, 0.839, 0.134>, <-3.2637, -3.0771, 23.1090>, <-0.826, 0.564, -0.004> }
	smooth_triangle { <-3.7570, -5.2859, 24.0439>, <-0.247, 0.420, 0.873>, <-3.2637, -3.0771, 23.1090>, <-0.280, 0.583, 0.763>, <-3.2411, -3.0829, 23.1189>, <0.301, 0.426, 0.853> }
	smooth_triangle { <-3.7570, -5.2859, 24.0439>, <0.698, 0.128, 0.705>, <-3.2411, -3.0829, 23.1189>, <0.500, 0.278, 0.820>, <-3.2273, -3.1017, 23.1090>, <0.925, -0.165, 0.342> }
	smooth_triangle { <-3.7570, -5.2859, 24.0439>, <0.935, -0.307, -0.177>, <-3.2273, -3.1017, 23.1090>, <0.926, -0.319, 0.204>, <-3.2361, -3.1148, 23.0891>, <0.623, -0.593, -0.510> }
	smooth_triangle { <-3.7570, -5.2859, 24.0439>, <0.240, -0.443, -0.864>, <-3.2361, -3.1148, 23.0891>, <0.439, -0.634, -0.636>, <-3.2587, -3.1090, 23.0791>, <-0.303, -0.430, -0.851> }
	smooth_triangle { <-3.7570, -5.2859, 24.0439>, <-0.707, -0.149, -0.691>, <-3.2587, -3.1090, 23.0791>, <-0.503, -0.282, -0.817>, <-3.2725, -3.0902, 23.0891>, <-0.926, 0.162, -0.340> }
	smooth_triangle { <-3.7570, -5.2859, 24.0439>, <-0.940, 0.285, 0.190>, <-3.2725, -3.0902, 23.0891>, <-0.927, 0.316, -0.202>, <-3.2637, -3.0771, 23.1090>, <-0.499, 0.553, 0.668> }
	smooth_triangle { <2.2704, -1.3902, 20.3078>, <-0.712, -0.496, 0.496>, <1.3394, -1.3856, 18.9753>, <-0.729, -0.496, 0.472>, <1.3291, -1.3636, 18.9825>, <-0.816, -0.140, 0.561> }
	smooth_triangle { <2.2704, -1.3902, 20.3078>, <-0.712, -0.496, 0.496>, <1.3291, -1.3636, 18.9825>, <-0.816, -0.140, 0.561>, <2.2601, -1.3682, 20.3151>, <-0.804, 0.193, 0.562> }
	smooth_triangle { <2.2601, -1.3682, 20.3151>, <-0.804, 0.193, 0.562>, <1.3291, -1.3636, 18.9825>, <-0.816, -0.140, 0.561>, <1.3396, -1.3416, 18.9753>, <-0.478, 0.786, 0.393> }
	smooth_triangle { <2.2601, -1.3682, 20.3151>, <-0.804, 0.193, 0.562>, <1.3396, -1.3416, 18.9753>, <-0.478, 0.786, 0.393>, <2.2707, -1.3463, 20.3078>, <-0.264, 0.946, 0.187> }
	smooth_triangle { <2.2707, -1.3463, 20.3078>, <-0.264, 0.946, 0.187>, <1.3396, -1.3416, 18.9753>, <-0.478, 0.786, 0.393>, <1.3604, -1.3417, 18.9607>, <0.338, 0.926, -0.169> }
	smooth_triangle { <2.2707, -1.3463, 20.3078>, <-0.264, 0.946, 0.187>, <1.3604, -1.3417, 18.9607>, <0.338, 0.926, -0.169>, <2.2915, -1.3464, 20.2933>, <0.540, 0.753, -0.375> }
	smooth_triangle { <2.2915, -1.3464, 20.2933>, <0.540, 0.753, -0.375>, <1.3604, -1.3417, 18.9607>, <0.338, 0.926, -0.169>, <1.3707, -1.3638, 18.9534>, <0.816, 0.140, -0.561> }
	smooth_triangle { <2.2915, -1.3464, 20.2933>, <0.540, 0.753, -0.375>, <1.3707, -1.3638, 18.9534>, <0.816, 0.140, -0.561>, <2.3018, -1.3684, 20.2860>, <0.804, -0.193, -0.562> }
	smooth_triangle { <2.3018, -1.3684, 20.2860>, <0.804, -0.193, -0.562>, <1.3707, -1.3638, 18.9534>, <0.816, 0.140, -0.561>, <1.3602, -1.3857, 18.9607>, <0.478, -0.786, -0.393> }
	smooth_triangle { <2.3018, -1.3684, 20.2860>, <0.804, -0.193, -0.562>, <1.3602, -1.3857, 18.9607>, <0.478, -0.786, -0.393>, <2.2913, -1.3903, 20.2933>, <0.264, -0.946, -0.187> }
	smooth_triangle { <2.2913, -1.3903, 20.2933>, <0.264, -0.946, -0.187>, <1.3602, -1.3857, 18.9607>, <0.478, -0.786, -0.393>, <1.3394, -1.3856, 18.9753>, <-0.088, -0.996, -0.011> }
	smooth_triangle { <2.2913, -1.3903, 20.2933>, <0.264, -0.946, -0.187>, <1.3394, -1.3856, 18.9753>, <-0.088, -0.996, -0.011>, <2.2704, -1.3902, 20.3078>, <-0.005, -1.000, 0.000> }
	smooth_triangle { <3.8594, -1.8964, 22.6077>, <-0.912, -0.298, 0.282>, <1.3394, -1.3856, 18.9753>, <-0.729, -0.496, 0.472>, <1.3291, -1.3636, 18.9825>, <-0.816, -0.140, 0.561> }
	smooth_triangle { <3.8594, -1.8964, 22.6077>, <-0.912, -0.298, 0.282>, <1.3291, -1.3636, 18.9825>, <-0.816, -0.140, 0.561>, <3.8563, -1.8723, 22.6152>, <-0.847, 0.368, 0.383> }
	smooth_triangle { <3.8563, -1.8723, 22.6152>, <-0.774, 0.483, 0.410>, <1.3291, -1.3636, 18.9825>, <-0.816, -0.140, 0.561>, <1.3396, -1.3416, 18.9753>, <-0.478, 0.786, 0.393> }
	smooth_triangle { <3.8563, -1.8723, 22.6152>, <-0.774, 0.483, 0.410>, <1.3396, -1.3416, 18.9753>, <-0.478, 0.786, 0.393>, <3.8728, -1.8545, 22.6077>, <-0.063, 0.952, 0.300> }
	smooth_triangle { <3.8728, -1.8545, 22.6077>, <0.085, 0.935, 0.344>, <1.3396, -1.3416, 18.9753>, <-0.478, 0.786, 0.393>, <1.3604, -1.3417, 18.9607>, <0.338, 0.926, -0.169> }
	smooth_triangle { <3.8728, -1.8545, 22.6077>, <0.085, 0.935, 0.344>, <1.3604, -1.3417, 18.9607>, <0.338, 0.926, -0.169>, <3.8924, -1.8607, 22.5928>, <0.696, 0.699, -0.163> }
	smooth_triangle { <3.8924, -1.8607, 22.5928>, <0.890, 0.450, -0.077>, <1.3604, -1.3417, 18.9607>, <0.338, 0.926, -0.169>, <1.3707, -1.3638, 18.9534>, <0.816, 0.140, -0.561> }
	smooth_triangle { <3.8924, -1.8607, 22.5928>, <0.890, 0.450, -0.077>, <1.3707, -1.3638, 18.9534>, <0.816, 0.140, -0.561>, <3.8955, -1.8848, 22.5853>, <0.848, -0.368, -0.381> }
	smooth_triangle { <3.8955, -1.8848, 22.5853>, <0.775, -0.482, -0.409>, <1.3707, -1.3638, 18.9534>, <0.816, 0.140, -0.561>, <1.3602, -1.3857, 18.9607>, <0.478, -0.786, -0.393> }
	smooth_triangle { <3.8955, -1.8848, 22.5853>, <0.775, -0.482, -0.409>, <1.3602, -1.3857, 18.9607>, <0.478, -0.786, -0.393>, <3.8790, -1.9026, 22.5928>, <0.063, -0.952, -0.299> }
	smooth_triangle { <3.8790, -1.9026, 22.5928>, <-0.084, -0.935, -0.344>, <1.3602, -1.3857, 18.9607>, <0.478, -0.786, -0.393>, <1.3394, -1.3856, 18.9753>, <-0.088, -0.996, -0.011> }
	smooth_triangle { <3.8790, -1.9026, 22.5928>, <-0.084, -0.935, -0.344>, <1.3394, -1.3856, 18.9753>, <-0.088, -0.996, -0.011>, <3.8594, -1.8964, 22.6077>, <-0.445, -0.868, -0.219> }
	smooth_triangle { <3.5251, -3.0279, 24.7222>, <-0.980, -0.066, -0.190>, <3.8594, -1.8964, 22.6077>, <-0.912, -0.298, 0.282>, <3.8563, -1.8723, 22.6152>, <-0.847, 0.368, 0.383> }
	smooth_triangle { <3.5251, -3.0279, 24.7222>, <-0.305, 0.634, 0.711>, <3.8563, -1.8723, 22.6152>, <-0.544, 0.711, 0.446>, <3.5493, -3.0234, 24.7285>, <-0.099, 0.697, 0.711> }
	smooth_triangle { <3.5493, -3.0234, 24.7285>, <-0.506, 0.549, 0.665>, <3.8563, -1.8723, 22.6152>, <-0.774, 0.483, 0.410>, <3.8728, -1.8545, 22.6077>, <-0.235, 0.945, 0.228> }
	smooth_triangle { <3.5493, -3.0234, 24.7285>, <0.244, 0.717, 0.653>, <3.8728, -1.8545, 22.6077>, <0.430, 0.867, 0.251>, <3.5674, -3.0400, 24.7222>, <0.824, 0.475, 0.308> }
	smooth_triangle { <3.5674, -3.0400, 24.7222>, <0.726, 0.497, 0.475>, <3.8728, -1.8545, 22.6077>, <0.246, 0.912, 0.328>, <3.8924, -1.8607, 22.5928>, <0.890, 0.450, -0.077> }
	smooth_triangle { <3.5674, -3.0400, 24.7222>, <0.895, 0.414, 0.169>, <3.8924, -1.8607, 22.5928>, <0.954, 0.290, -0.076>, <3.5614, -3.0612, 24.7095>, <0.910, -0.169, -0.378> }
	smooth_triangle { <3.5614, -3.0612, 24.7095>, <0.988, 0.112, -0.111>, <3.8924, -1.8607, 22.5928>, <0.954, 0.290, -0.076>, <3.8955, -1.8848, 22.5853>, <0.848, -0.368, -0.381> }
	smooth_triangle { <3.5614, -3.0612, 24.7095>, <0.706, -0.404, -0.582>, <3.8955, -1.8848, 22.5853>, <0.545, -0.710, -0.445>, <3.5372, -3.0657, 24.7032>, <0.098, -0.696, -0.711> }
	smooth_triangle { <3.5372, -3.0657, 24.7032>, <0.506, -0.547, -0.667>, <3.8955, -1.8848, 22.5853>, <0.775, -0.482, -0.409>, <3.8790, -1.9026, 22.5928>, <0.236, -0.945, -0.226> }
	smooth_triangle { <3.5372, -3.0657, 24.7032>, <-0.244, -0.718, -0.652>, <3.8790, -1.9026, 22.5928>, <-0.430, -0.867, -0.253>, <3.5191, -3.0491, 24.7095>, <-0.824, -0.475, -0.308> }
	smooth_triangle { <3.5191, -3.0491, 24.7095>, <-0.727, -0.495, -0.476>, <3.8790, -1.9026, 22.5928>, <-0.246, -0.912, -0.329>, <3.8594, -1.8964, 22.6077>, <-0.784, -0.593, -0.181> }
	smooth_triangle { <3.5191, -3.0491, 24.7095>, <-0.894, -0.414, -0.169>, <3.8594, -1.8964, 22.6077>, <-0.928, -0.243, -0.283>, <3.5251, -3.0279, 24.7222>, <-0.969, -0.123, 0.216> }
	smooth_triangle { <4.5966, -4.9721, 25.7749>, <-0.573, 0.272, 0.773>, <3.5251, -3.0279, 24.7222>, <-0.305, 0.634, 0.711>, <3.5493, -3.0234, 24.7285>, <-0.099, 0.697, 0.711> }
	smooth_triangle { <4.5966, -4.9721, 25.7749>, <-0.573, 0.272, 0.773>, <3.5493, -3.0234, 24.7285>, <-0.506, 0.549, 0.665>, <4.6131, -4.9566, 25.7863>, <-0.252, 0.330, 0.910> }
	smooth_triangle { <4.6131, -4.9566, 25.7863>, <0.504, 0.435, 0.746>, <3.5493, -3.0234, 24.7285>, <0.244, 0.717, 0.653>, <3.5674, -3.0400, 24.7222>, <0.824, 0.475, 0.308> }
	smooth_triangle { <4.6131, -4.9566, 25.7863>, <-0.080, 0.423, 0.902>, <3.5674, -3.0400, 24.7222>, <0.567, 0.627, 0.534>, <4.6350, -4.9506, 25.7749>, <0.609, 0.319, 0.726> }
	smooth_triangle { <4.6350, -4.9506, 25.7749>, <0.984, 0.142, -0.105>, <3.5674, -3.0400, 24.7222>, <0.947, 0.313, 0.072>, <3.5614, -3.0612, 24.7095>, <0.910, -0.169, -0.378> }
	smooth_triangle { <4.6350, -4.9506, 25.7749>, <0.842, 0.217, 0.493>, <3.5614, -3.0612, 24.7095>, <0.988, 0.112, -0.111>, <4.6403, -4.9601, 25.7519>, <0.962, -0.123, -0.243> }
	smooth_triangle { <4.6403, -4.9601, 25.7519>, <0.721, -0.305, -0.623>, <3.5614, -3.0612, 24.7095>, <0.706, -0.404, -0.582>, <3.5372, -3.0657, 24.7032>, <0.098, -0.696, -0.711> }
	smooth_triangle { <4.6403, -4.9601, 25.7519>, <0.830, -0.145, -0.538>, <3.5372, -3.0657, 24.7032>, <0.506, -0.547, -0.667>, <4.6237, -4.9756, 25.7405>, <0.249, -0.325, -0.912> }
	smooth_triangle { <4.6237, -4.9756, 25.7405>, <-0.507, -0.435, -0.744>, <3.5372, -3.0657, 24.7032>, <-0.244, -0.718, -0.652>, <3.5191, -3.0491, 24.7095>, <-0.824, -0.475, -0.308> }
	smooth_triangle { <4.6237, -4.9756, 25.7405>, <0.077, -0.421, -0.904>, <3.5191, -3.0491, 24.7095>, <-0.568, -0.627, -0.533>, <4.6019, -4.9816, 25.7519>, <-0.611, -0.312, -0.728> }
	smooth_triangle { <4.6019, -4.9816, 25.7519>, <-0.985, -0.137, 0.104>, <3.5191, -3.0491, 24.7095>, <-0.947, -0.314, -0.071>, <3.5251, -3.0279, 24.7222>, <-0.969, -0.123, 0.216> }
	smooth_triangle { <4.6019, -4.9816, 25.7519>, <-0.843, -0.211, -0.495>, <3.5251, -3.0279, 24.7222>, <-0.969, -0.123, 0.216>, <4.5966, -4.9721, 25.7749>, <-0.993, 0.034, -0.116> }
	smooth_triangle { <3.8215, -7.2156, 26.2643>, <-0.705, 0.331, 0.627>, <4.5966, -4.9721, 25.7749>, <-0.573, 0.272, 0.773>, <4.6131, -4.9566, 25.7863>, <-0.423, 0.378, 0.824> }
	smooth_triangle { <3.8215, -7.2156, 26.2643>, <-0.705, 0.331, 0.627>, <4.6131, -4.9566, 25.7863>, <-0.252, 0.330, 0.910>, <3.8431, -7.2204, 26.2768>, <0.149, 0.137, 0.979> }
	smooth_triangle { <3.8431, -7.2204, 26.2768>, <0.149, 0.137, 0.979>, <4.6131, -4.9566, 25.7863>, <0.090, 0.399, 0.912>, <4.6350, -4.9506, 25.7749>, <0.715, 0.204, 0.669> }
	smooth_triangle { <3.8431, -7.2204, 26.2768>, <0.149, 0.137, 0.979>, <4.6350, -4.9506, 25.7749>, <0.715, 0.204, 0.669>, <3.8631, -7.2299, 26.2643>, <0.872, -0.190, 0.450> }
	smooth_triangle { <3.8631, -7.2299, 26.2643>, <0.872, -0.190, 0.450>, <4.6350, -4.9506, 25.7749>, <0.920, 0.106, 0.376>, <4.6403, -4.9601, 25.7519>, <0.989, -0.128, -0.071> }
	smooth_triangle { <3.8631, -7.2299, 26.2643>, <0.872, -0.190, 0.450>, <4.6403, -4.9601, 25.7519>, <0.901, -0.174, -0.397>, <3.8614, -7.2348, 26.2394>, <0.785, -0.350, -0.511> }
	smooth_triangle { <3.8614, -7.2348, 26.2394>, <0.785, -0.350, -0.511>, <4.6403, -4.9601, 25.7519>, <0.901, -0.174, -0.397>, <4.6237, -4.9756, 25.7405>, <0.421, -0.373, -0.827> }
	smooth_triangle { <3.8614, -7.2348, 26.2394>, <0.785, -0.350, -0.511>, <4.6237, -4.9756, 25.7405>, <0.249, -0.325, -0.912>, <3.8398, -7.2300, 26.2270>, <-0.151, -0.144, -0.978> }
	smooth_triangle { <3.8398, -7.2300, 26.2270>, <-0.151, -0.144, -0.978>, <4.6237, -4.9756, 25.7405>, <-0.092, -0.397, -0.913>, <4.6019, -4.9816, 25.7519>, <-0.716, -0.196, -0.670> }
	smooth_triangle { <3.8398, -7.2300, 26.2270>, <-0.151, -0.144, -0.978>, <4.6019, -4.9816, 25.7519>, <-0.716, -0.196, -0.670>, <3.8198, -7.2204, 26.2394>, <-0.874, 0.186, -0.449> }
	smooth_triangle { <3.8198, -7.2204, 26.2394>, <-0.874, 0.186, -0.449>, <4.6019, -4.9816, 25.7519>, <-0.921, -0.101, -0.377>, <4.5966, -4.9721, 25.7749>, <-0.993, 0.034, -0.116> }
	smooth_triangle { <3.8198, -7.2204, 26.2394>, <-0.874, 0.186, -0.449>, <4.5966, -4.9721, 25.7749>, <-0.993, 0.034, -0.116>, <3.8215, -7.2156, 26.2643>, <-0.945, 0.326, 0.000> }
	smooth_triangle { <3.2156, -9.5513, 26.6302>, <-0.441, 0.245, 0.863>, <3.8215, -7.2156, 26.2643>, <-0.705, 0.331, 0.627>, <3.8431, -7.2204, 26.2768>, <0.149, 0.137, 0.979> }
	smooth_triangle { <3.2156, -9.5513, 26.6302>, <0.524, -0.017, 0.852>, <3.8431, -7.2204, 26.2768>, <0.149, 0.137, 0.979>, <3.8631, -7.2299, 26.2643>, <0.872, -0.190, 0.450> }
	smooth_triangle { <3.2156, -9.5513, 26.6302>, <0.962, -0.275, -0.010>, <3.8631, -7.2299, 26.2643>, <0.872, -0.190, 0.450>, <3.8614, -7.2348, 26.2394>, <0.785, -0.350, -0.511> }
	smooth_triangle { <3.2156, -9.5513, 26.6302>, <0.434, -0.271, -0.859>, <3.8614, -7.2348, 26.2394>, <0.785, -0.350, -0.511>, <3.8398, -7.2300, 26.2270>, <-0.151, -0.144, -0.978> }
	smooth_triangle { <3.2156, -9.5513, 26.6302>, <-0.531, -0.009, -0.847>, <3.8398, -7.2300, 26.2270>, <-0.151, -0.144, -0.978>, <3.8198, -7.2204, 26.2394>, <-0.874, 0.186, -0.449> }
	smooth_triangle { <3.2156, -9.5513, 26.6302>, <-0.968, 0.249, 0.015>, <3.8198, -7.2204, 26.2394>, <-0.874, 0.186, -0.449>, <3.8215, -7.2156, 26.2643>, <-0.705, 0.331, 0.627> }
	smooth_triangle { <1.9788, -0.8804, 20.3872>, <-0.268, -0.863, 0.428>, <1.3552, -1.3877, 18.9743>, <-0.327, -0.902, 0.282>, <1.3328, -1.3776, 18.9806>, <-0.698, -0.551, 0.458> }
	smooth_triangle { <1.9788, -0.8804, 20.3872>, <-0.268, -0.863, 0.428>, <1.3328, -1.3776, 18.9806>, <-0.698, -0.551, 0.458>, <1.9563, -0.8703, 20.3935>, <-0.781, -0.392, 0.486> }
	smooth_triangle { <1.9563, -0.8703, 20.3935>, <-0.781, -0.392, 0.486>, <1.3328, -1.3776, 18.9806>, <-0.698, -0.551, 0.458>, <1.3275, -1.3536, 18.9743>, <-0.819, 0.434, 0.376> }
	smooth_triangle { <1.9563, -0.8703, 20.3935>, <-0.781, -0.392, 0.486>, <1.3275, -1.3536, 18.9743>, <-0.819, 0.434, 0.376>, <1.9510, -0.8463, 20.3872>, <-0.817, 0.553, 0.162> }
	smooth_triangle { <1.9510, -0.8463, 20.3872>, <-0.817, 0.553, 0.162>, <1.3275, -1.3536, 18.9743>, <-0.819, 0.434, 0.376>, <1.3446, -1.3396, 18.9617>, <-0.124, 0.989, -0.081> }
	smooth_triangle { <1.9510, -0.8463, 20.3872>, <-0.817, 0.553, 0.162>, <1.3446, -1.3396, 18.9617>, <-0.124, 0.989, -0.081>, <1.9681, -0.8323, 20.3746>, <-0.036, 0.945, -0.324> }
	smooth_triangle { <1.9681, -0.8323, 20.3746>, <-0.036, 0.945, -0.324>, <1.3446, -1.3396, 18.9617>, <-0.124, 0.989, -0.081>, <1.3670, -1.3497, 18.9554>, <0.698, 0.551, -0.458> }
	smooth_triangle { <1.9681, -0.8323, 20.3746>, <-0.036, 0.945, -0.324>, <1.3670, -1.3497, 18.9554>, <0.698, 0.551, -0.458>, <1.9906, -0.8424, 20.3684>, <0.781, 0.392, -0.486> }
	smooth_triangle { <1.9906, -0.8424, 20.3684>, <0.781, 0.392, -0.486>, <1.3670, -1.3497, 18.9554>, <0.698, 0.551, -0.458>, <1.3724, -1.3738, 18.9617>, <0.819, -0.434, -0.376> }
	smooth_triangle { <1.9906, -0.8424, 20.3684>, <0.781, 0.392, -0.486>, <1.3724, -1.3738, 18.9617>, <0.819, -0.434, -0.376>, <1.9959, -0.8664, 20.3746>, <0.817, -0.553, -0.162> }
	smooth_triangle { <1.9959, -0.8664, 20.3746>, <0.817, -0.553, -0.162>, <1.3724, -1.3738, 18.9617>, <0.819, -0.434, -0.376>, <1.3552, -1.3877, 18.9743>, <0.363, -0.931, -0.041> }
	smooth_triangle { <1.9959, -0.8664, 20.3746>, <0.817, -0.553, -0.162>, <1.3552, -1.3877, 18.9743>, <0.363, -0.931, -0.041>, <1.9788, -0.8804, 20.3872>, <0.631, -0.776, 0.000> }
	smooth_triangle { <3.1398, -1.6461, 22.3715>, <-0.659, -0.461, 0.594>, <1.3552, -1.3877, 18.9743>, <-0.327, -0.902, 0.282>, <1.3328, -1.3776, 18.9806>, <-0.698, -0.551, 0.458> }
	smooth_triangle { <3.1398, -1.6461, 22.3715>, <-0.659, -0.461, 0.594>, <1.3328, -1.3776, 18.9806>, <-0.698, -0.551, 0.458>, <3.1433, -1.6220, 22.3789>, <-0.686, 0.173, 0.707> }
	smooth_triangle { <3.1433, -1.6220, 22.3789>, <-0.686, 0.173, 0.707>, <1.3328, -1.3776, 18.9806>, <-0.698, -0.551, 0.458>, <1.3275, -1.3536, 18.9743>, <-0.819, 0.434, 0.376> }
	smooth_triangle { <3.1433, -1.6220, 22.3789>, <-0.744, 0.465, 0.480>, <1.3275, -1.3536, 18.9743>, <-0.819, 0.434, 0.376>, <3.1639, -1.6093, 22.3715>, <-0.237, 0.945, 0.224> }
	smooth_triangle { <3.1639, -1.6093, 22.3715>, <-0.237, 0.945, 0.224>, <1.3275, -1.3536, 18.9743>, <-0.819, 0.434, 0.376>, <1.3446, -1.3396, 18.9617>, <-0.124, 0.989, -0.081> }
	smooth_triangle { <3.1639, -1.6093, 22.3715>, <-0.163, 0.984, 0.076>, <1.3446, -1.3396, 18.9617>, <-0.124, 0.989, -0.081>, <3.1812, -1.6206, 22.3567>, <0.410, 0.794, -0.449> }
	smooth_triangle { <3.1812, -1.6206, 22.3567>, <0.410, 0.794, -0.449>, <1.3446, -1.3396, 18.9617>, <-0.124, 0.989, -0.081>, <1.3670, -1.3497, 18.9554>, <0.698, 0.551, -0.458> }
	smooth_triangle { <3.1812, -1.6206, 22.3567>, <0.518, 0.682, -0.517>, <1.3670, -1.3497, 18.9554>, <0.698, 0.551, -0.458>, <3.1778, -1.6446, 22.3493>, <0.686, -0.174, -0.707> }
	smooth_triangle { <3.1778, -1.6446, 22.3493>, <0.686, -0.174, -0.707>, <1.3670, -1.3497, 18.9554>, <0.698, 0.551, -0.458>, <1.3724, -1.3738, 18.9617>, <0.819, -0.434, -0.376> }
	smooth_triangle { <3.1778, -1.6446, 22.3493>, <0.745, -0.466, -0.478>, <1.3724, -1.3738, 18.9617>, <0.819, -0.434, -0.376>, <3.1571, -1.6574, 22.3567>, <0.237, -0.946, -0.222> }
	smooth_triangle { <3.1571, -1.6574, 22.3567>, <0.237, -0.946, -0.222>, <1.3724, -1.3738, 18.9617>, <0.819, -0.434, -0.376>, <1.3552, -1.3877, 18.9743>, <0.363, -0.931, -0.041> }
	smooth_triangle { <3.1571, -1.6574, 22.3567>, <0.165, -0.984, -0.073>, <1.3552, -1.3877, 18.9743>, <0.363, -0.931, -0.041>, <3.1398, -1.6461, 22.3715>, <-0.123, -0.961, 0.247> }
	smooth_triangle { <5.3180, -1.2359, 23.4289>, <-0.490, -0.474, 0.732>, <3.1398, -1.6461, 22.3715>, <-0.659, -0.461, 0.594>, <3.1433, -1.6220, 22.3789>, <-0.663, -0.238, 0.710> }
	smooth_triangle { <5.3180, -1.2359, 23.4289>, <-0.490, -0.474, 0.732>, <3.1433, -1.6220, 22.3789>, <-0.663, -0.238, 0.710>, <5.3084, -1.2154, 23.4404>, <-0.607, -0.099, 0.788> }
	smooth_triangle { <5.3084, -1.2154, 23.4404>, <-0.547, 0.416, 0.727>, <3.1433, -1.6220, 22.3789>, <-0.744, 0.465, 0.480>, <3.1639, -1.6093, 22.3715>, <-0.237, 0.945, 0.224> }
	smooth_triangle { <5.3084, -1.2154, 23.4404>, <-0.613, 0.082, 0.786>, <3.1639, -1.6093, 22.3715>, <-0.443, 0.765, 0.468>, <5.3096, -1.1927, 23.4289>, <-0.225, 0.790, 0.571> }
	smooth_triangle { <5.3096, -1.1927, 23.4289>, <0.086, 0.991, -0.106>, <3.1639, -1.6093, 22.3715>, <-0.163, 0.984, 0.076>, <3.1812, -1.6206, 22.3567>, <0.410, 0.794, -0.449> }
	smooth_triangle { <5.3096, -1.1927, 23.4289>, <-0.184, 0.894, 0.408>, <3.1812, -1.6206, 22.3567>, <0.189, 0.957, -0.218>, <5.3204, -1.1906, 23.4060>, <0.383, 0.897, -0.221> }
	smooth_triangle { <5.3204, -1.1906, 23.4060>, <0.532, 0.614, -0.583>, <3.1812, -1.6206, 22.3567>, <0.518, 0.682, -0.517>, <3.1778, -1.6446, 22.3493>, <0.661, 0.238, -0.711> }
	smooth_triangle { <5.3204, -1.1906, 23.4060>, <0.415, 0.829, -0.375>, <3.1778, -1.6446, 22.3493>, <0.661, 0.238, -0.711>, <5.3299, -1.2112, 23.3946>, <0.603, 0.099, -0.792> }
	smooth_triangle { <5.3299, -1.2112, 23.3946>, <0.547, -0.418, -0.726>, <3.1778, -1.6446, 22.3493>, <0.745, -0.466, -0.478>, <3.1571, -1.6574, 22.3567>, <0.237, -0.946, -0.222> }
	smooth_triangle { <5.3299, -1.2112, 23.3946>, <0.611, -0.083, -0.787>, <3.1571, -1.6574, 22.3567>, <0.443, -0.766, -0.466>, <5.3288, -1.2338, 23.4060>, <0.219, -0.790, -0.573> }
	smooth_triangle { <5.3288, -1.2338, 23.4060>, <-0.090, -0.990, 0.104>, <3.1571, -1.6574, 22.3567>, <0.165, -0.984, -0.073>, <3.1398, -1.6461, 22.3715>, <-0.123, -0.961, 0.247> }
	smooth_triangle { <5.3288, -1.2338, 23.4060>, <0.180, -0.894, -0.410>, <3.1398, -1.6461, 22.3715>, <-0.123, -0.961, 0.247>, <5.3180, -1.2359, 23.4289>, <-0.240, -0.967, -0.087> }
	smooth_triangle { <6.6639, -2.0686, 24.6784>, <-0.859, -0.368, 0.356>, <5.3180, -1.2359, 23.4289>, <-0.490, -0.474, 0.732>, <5.3084, -1.2154, 23.4404>, <-0.607, -0.099, 0.788> }
	smooth_triangle { <6.6639, -2.0686, 24.6784>, <-0.859, -0.368, 0.356>, <5.3084, -1.2154, 23.4404>, <-0.613, 0.082, 0.786>, <6.6687, -2.0458, 24.6884>, <-0.540, 0.371, 0.755> }
	smooth_triangle { <6.6687, -2.0458, 24.6884>, <-0.540, 0.371, 0.755>, <5.3084, -1.2154, 23.4404>, <-0.613, 0.082, 0.786>, <5.3096, -1.1927, 23.4289>, <-0.225, 0.790, 0.571> }
	smooth_triangle { <6.6687, -2.0458, 24.6884>, <-0.540, 0.371, 0.755>, <5.3096, -1.1927, 23.4289>, <-0.225, 0.790, 0.571>, <6.6870, -2.0312, 24.6784>, <0.298, 0.848, 0.439> }
	smooth_triangle { <6.6870, -2.0312, 24.6784>, <0.298, 0.848, 0.439>, <5.3096, -1.1927, 23.4289>, <-0.184, 0.894, 0.408>, <5.3204, -1.1906, 23.4060>, <0.383, 0.897, -0.221> }
	smooth_triangle { <6.6870, -2.0312, 24.6784>, <0.298, 0.848, 0.439>, <5.3204, -1.1906, 23.4060>, <0.415, 0.829, -0.375>, <6.7003, -2.0394, 24.6584>, <0.824, 0.489, -0.286> }
	smooth_triangle { <6.7003, -2.0394, 24.6584>, <0.824, 0.489, -0.286>, <5.3204, -1.1906, 23.4060>, <0.415, 0.829, -0.375>, <5.3299, -1.2112, 23.3946>, <0.603, 0.099, -0.792> }
	smooth_triangle { <6.7003, -2.0394, 24.6584>, <0.824, 0.489, -0.286>, <5.3299, -1.2112, 23.3946>, <0.611, -0.083, -0.787>, <6.6954, -2.0622, 24.6483>, <0.546, -0.376, -0.749> }
	smooth_triangle { <6.6954, -2.0622, 24.6483>, <0.546, -0.376, -0.749>, <5.3299, -1.2112, 23.3946>, <0.611, -0.083, -0.787>, <5.3288, -1.2338, 23.4060>, <0.219, -0.790, -0.573> }
	smooth_triangle { <6.6954, -2.0622, 24.6483>, <0.546, -0.376, -0.749>, <5.3288, -1.2338, 23.4060>, <0.219, -0.790, -0.573>, <6.6772, -2.0768, 24.6584>, <-0.293, -0.852, -0.433> }
	smooth_triangle { <6.6772, -2.0768, 24.6584>, <-0.293, -0.852, -0.433>, <5.3288, -1.2338, 23.4060>, <0.180, -0.894, -0.410>, <5.3180, -1.2359, 23.4289>, <-0.240, -0.967, -0.087> }
	smooth_triangle { <6.6772, -2.0768, 24.6584>, <-0.293, -0.852, -0.433>, <5.3180, -1.2359, 23.4289>, <-0.240, -0.967, -0.087>, <6.6639, -2.0686, 24.6784>, <-0.526, -0.851, -0.001> }
	smooth_triangle { <7.3269, -3.4276, 26.0199>, <-0.884, 0.023, 0.468>, <6.6639, -2.0686, 24.6784>, <-0.859, -0.368, 0.356>, <6.6687, -2.0458, 24.6884>, <-0.540, 0.371, 0.755> }
	smooth_triangle { <7.3269, -3.4276, 26.0199>, <-0.134, 0.650, 0.748>, <6.6687, -2.0458, 24.6884>, <-0.540, 0.371, 0.755>, <6.6870, -2.0312, 24.6784>, <0.298, 0.848, 0.439> }
	smooth_triangle { <7.3269, -3.4276, 26.0199>, <0.747, 0.604, 0.279>, <6.6870, -2.0312, 24.6784>, <0.298, 0.848, 0.439>, <6.7003, -2.0394, 24.6584>, <0.824, 0.489, -0.286> }
	smooth_triangle { <7.3269, -3.4276, 26.0199>, <0.895, -0.040, -0.445>, <6.7003, -2.0394, 24.6584>, <0.824, 0.489, -0.286>, <6.6954, -2.0622, 24.6483>, <0.546, -0.376, -0.749> }
	smooth_triangle { <7.3269, -3.4276, 26.0199>, <0.151, -0.669, -0.728>, <6.6954, -2.0622, 24.6483>, <0.546, -0.376, -0.749>, <6.6772, -2.0768, 24.6584>, <-0.293, -0.852, -0.433> }
	smooth_triangle { <7.3269, -3.4276, 26.0199>, <-0.736, -0.625, -0.261>, <6.6772, -2.0768, 24.6584>, <-0.293, -0.852, -0.433>, <6.6639, -2.0686, 24.6784>, <-0.859, -0.368, 0.356> }
	smooth_triangle { <2.4834, -0.6704, 17.4640>, <-0.722, -0.291, 0.627>, <1.3631, -0.3067, 16.3436>, <-0.694, -0.300, 0.655>, <1.3616, -0.2831, 16.3528>, <-0.687, -0.001, 0.727> }
	smooth_triangle { <2.4834, -0.6704, 17.4640>, <-0.722, -0.291, 0.627>, <1.3616, -0.2831, 16.3528>, <-0.687, -0.001, 0.727>, <2.4818, -0.6468, 17.4732>, <-0.585, 0.389, 0.711> }
	smooth_triangle { <2.4818, -0.6468, 17.4732>, <-0.585, 0.389, 0.711>, <1.3616, -0.2831, 16.3528>, <-0.687, -0.001, 0.727>, <1.3767, -0.2649, 16.3436>, <-0.231, 0.852, 0.470> }
	smooth_triangle { <2.4818, -0.6468, 17.4732>, <-0.585, 0.389, 0.711>, <1.3767, -0.2649, 16.3436>, <-0.231, 0.852, 0.470>, <2.4969, -0.6286, 17.4640>, <0.077, 0.968, 0.237> }
	smooth_triangle { <2.4969, -0.6286, 17.4640>, <0.077, 0.968, 0.237>, <1.3767, -0.2649, 16.3436>, <-0.231, 0.852, 0.470>, <1.3933, -0.2703, 16.3252>, <0.455, 0.852, -0.257> }
	smooth_triangle { <2.4969, -0.6286, 17.4640>, <0.077, 0.968, 0.237>, <1.3933, -0.2703, 16.3252>, <0.455, 0.852, -0.257>, <2.5136, -0.6340, 17.4456>, <0.663, 0.580, -0.474> }
	smooth_triangle { <2.5136, -0.6340, 17.4456>, <0.663, 0.580, -0.474>, <1.3933, -0.2703, 16.3252>, <0.455, 0.852, -0.257>, <1.3949, -0.2939, 16.3160>, <0.687, 0.001, -0.727> }
	smooth_triangle { <2.5136, -0.6340, 17.4456>, <0.663, 0.580, -0.474>, <1.3949, -0.2939, 16.3160>, <0.687, 0.001, -0.727>, <2.5151, -0.6576, 17.4364>, <0.585, -0.389, -0.711> }
	smooth_triangle { <2.5151, -0.6576, 17.4364>, <0.585, -0.389, -0.711>, <1.3949, -0.2939, 16.3160>, <0.687, 0.001, -0.727>, <1.3798, -0.3121, 16.3252>, <0.232, -0.852, -0.470> }
	smooth_triangle { <2.5151, -0.6576, 17.4364>, <0.585, -0.389, -0.711>, <1.3798, -0.3121, 16.3252>, <0.232, -0.852, -0.470>, <2.5000, -0.6758, 17.4456>, <-0.077, -0.968, -0.237> }
	smooth_triangle { <2.5000, -0.6758, 17.4456>, <-0.077, -0.968, -0.237>, <1.3798, -0.3121, 16.3252>, <0.232, -0.852, -0.470>, <1.3631, -0.3067, 16.3436>, <-0.250, -0.968, 0.009> }
	smooth_triangle { <2.5000, -0.6758, 17.4456>, <-0.077, -0.968, -0.237>, <1.3631, -0.3067, 16.3436>, <-0.250, -0.968, 0.009>, <2.4834, -0.6704, 17.4640>, <-0.309, -0.951, 0.000> }
	smooth_triangle { <4.6581, -0.8908, 19.2912>, <-0.708, -0.386, 0.592>, <1.3631, -0.3067, 16.3436>, <-0.694, -0.300, 0.655>, <1.3616, -0.2831, 16.3528>, <-0.687, -0.001, 0.727> }
	smooth_triangle { <4.6581, -0.8908, 19.2912>, <-0.708, -0.386, 0.592>, <1.3616, -0.2831, 16.3528>, <-0.687, -0.001, 0.727>, <4.6522, -0.8681, 19.3009>, <-0.770, 0.005, 0.638> }
	smooth_triangle { <4.6522, -0.8681, 19.3009>, <-0.765, 0.210, 0.608>, <1.3616, -0.2831, 16.3528>, <-0.687, -0.001, 0.727>, <1.3767, -0.2649, 16.3436>, <-0.231, 0.852, 0.470> }
	smooth_triangle { <4.6522, -0.8681, 19.3009>, <-0.765, 0.210, 0.608>, <1.3767, -0.2649, 16.3436>, <-0.231, 0.852, 0.470>, <4.6625, -0.8470, 19.2912>, <-0.451, 0.865, 0.220> }
	smooth_triangle { <4.6625, -0.8470, 19.2912>, <-0.081, 0.990, 0.119>, <1.3767, -0.2649, 16.3436>, <-0.231, 0.852, 0.470>, <1.3933, -0.2703, 16.3252>, <0.455, 0.852, -0.257> }
	smooth_triangle { <4.6625, -0.8470, 19.2912>, <-0.269, 0.952, 0.147>, <1.3933, -0.2703, 16.3252>, <0.455, 0.852, -0.257>, <4.6788, -0.8487, 19.2717>, <0.326, 0.847, -0.419> }
	smooth_triangle { <4.6788, -0.8487, 19.2717>, <0.636, 0.602, -0.484>, <1.3933, -0.2703, 16.3252>, <0.455, 0.852, -0.257>, <1.3949, -0.2939, 16.3160>, <0.687, 0.001, -0.727> }
	smooth_triangle { <4.6788, -0.8487, 19.2717>, <0.498, 0.736, -0.459>, <1.3949, -0.2939, 16.3160>, <0.687, 0.001, -0.727>, <4.6847, -0.8714, 19.2620>, <0.771, -0.006, -0.637> }
	smooth_triangle { <4.6847, -0.8714, 19.2620>, <0.768, -0.211, -0.605>, <1.3949, -0.2939, 16.3160>, <0.687, 0.001, -0.727>, <1.3798, -0.3121, 16.3252>, <0.232, -0.852, -0.470> }
	smooth_triangle { <4.6847, -0.8714, 19.2620>, <0.768, -0.211, -0.605>, <1.3798, -0.3121, 16.3252>, <0.232, -0.852, -0.470>, <4.6744, -0.8924, 19.2717>, <0.451, -0.865, -0.220> }
	smooth_triangle { <4.6744, -0.8924, 19.2717>, <0.082, -0.990, -0.118>, <1.3798, -0.3121, 16.3252>, <0.232, -0.852, -0.470>, <1.3631, -0.3067, 16.3436>, <-0.250, -0.968, 0.009> }
	smooth_triangle { <4.6744, -0.8924, 19.2717>, <0.271, -0.952, -0.145>, <1.3631, -0.3067, 16.3436>, <-0.250, -0.968, 0.009>, <4.6581, -0.8908, 19.2912>, <0.214, -0.975, 0.063> }
	smooth_triangle { <5.5584, -0.2532, 21.4665>, <-0.483, -0.715, 0.505>, <4.6581, -0.8908, 19.2912>, <-0.708, -0.386, 0.592>, <4.6522, -0.8681, 19.3009>, <-0.770, 0.005, 0.638> }
	smooth_triangle { <5.5584, -0.2532, 21.4665>, <-0.483, -0.715, 0.505>, <4.6522, -0.8681, 19.3009>, <-0.621, -0.594, 0.511>, <5.5364, -0.2420, 21.4722>, <-0.579, -0.573, 0.581> }
	smooth_triangle { <5.5364, -0.2420, 21.4722>, <-0.903, 0.160, 0.398>, <4.6522, -0.8681, 19.3009>, <-0.765, 0.210, 0.608>, <4.6625, -0.8470, 19.2912>, <-0.587, 0.761, 0.275> }
	smooth_triangle { <5.5364, -0.2420, 21.4722>, <-0.707, -0.416, 0.572>, <4.6625, -0.8470, 19.2912>, <-0.816, 0.363, 0.450>, <5.5327, -0.2176, 21.4665>, <-0.870, 0.355, 0.342> }
	smooth_triangle { <5.5327, -0.2176, 21.4665>, <-0.464, 0.882, -0.090>, <4.6625, -0.8470, 19.2912>, <-0.269, 0.952, 0.147>, <4.6788, -0.8487, 19.2717>, <0.215, 0.922, -0.321> }
	smooth_triangle { <5.5327, -0.2176, 21.4665>, <-0.814, 0.518, 0.262>, <4.6788, -0.8487, 19.2717>, <-0.214, 0.975, -0.064>, <5.5511, -0.2043, 21.4551>, <-0.293, 0.926, -0.240> }
	smooth_triangle { <5.5511, -0.2043, 21.4551>, <0.484, 0.714, -0.505>, <4.6788, -0.8487, 19.2717>, <0.498, 0.736, -0.459>, <4.6847, -0.8714, 19.2620>, <0.771, -0.006, -0.637> }
	smooth_triangle { <5.5511, -0.2043, 21.4551>, <-0.099, 0.943, -0.317>, <4.6847, -0.8714, 19.2620>, <0.622, 0.592, -0.511>, <5.5731, -0.2154, 21.4494>, <0.576, 0.571, -0.585> }
	smooth_triangle { <5.5731, -0.2154, 21.4494>, <0.902, -0.161, -0.400>, <4.6847, -0.8714, 19.2620>, <0.768, -0.211, -0.605>, <4.6744, -0.8924, 19.2717>, <0.588, -0.761, -0.275> }
	smooth_triangle { <5.5731, -0.2154, 21.4494>, <0.705, 0.415, -0.575>, <4.6744, -0.8924, 19.2717>, <0.815, -0.363, -0.452>, <5.5768, -0.2399, 21.4551>, <0.868, -0.356, -0.346> }
	smooth_triangle { <5.5768, -0.2399, 21.4551>, <0.464, -0.881, 0.088>, <4.6744, -0.8924, 19.2717>, <0.271, -0.952, -0.145>, <4.6581, -0.8908, 19.2912>, <0.214, -0.975, 0.063> }
	smooth_triangle { <5.5768, -0.2399, 21.4551>, <0.813, -0.519, -0.265>, <4.6581, -0.8908, 19.2912>, <0.214, -0.975, 0.063>, <5.5584, -0.2532, 21.4665>, <0.610, -0.792, 0.013> }
	smooth_triangle { <6.8066, 0.7881, 23.2898>, <-0.029, -0.910, 0.414>, <5.5584, -0.2532, 21.4665>, <-0.483, -0.715, 0.505>, <5.5364, -0.2420, 21.4722>, <-0.579, -0.573, 0.581> }
	smooth_triangle { <6.8066, 0.7881, 23.2898>, <-0.029, -0.910, 0.414>, <5.5364, -0.2420, 21.4722>, <-0.579, -0.573, 0.581>, <6.7852, 0.7989, 23.2983>, <-0.725, -0.444, 0.527> }
	smooth_triangle { <6.7852, 0.7989, 23.2983>, <-0.725, -0.444, 0.527>, <5.5364, -0.2420, 21.4722>, <-0.707, -0.416, 0.572>, <5.5327, -0.2176, 21.4665>, <-0.870, 0.355, 0.342> }
	smooth_triangle { <6.7852, 0.7989, 23.2983>, <-0.725, -0.444, 0.527>, <5.5327, -0.2176, 21.4665>, <-0.870, 0.355, 0.342>, <6.7784, 0.8219, 23.2898>, <-0.850, 0.493, 0.186> }
	smooth_triangle { <6.7784, 0.8219, 23.2898>, <-0.850, 0.493, 0.186>, <5.5327, -0.2176, 21.4665>, <-0.814, 0.518, 0.262>, <5.5511, -0.2043, 21.4551>, <-0.293, 0.926, -0.240> }
	smooth_triangle { <6.7784, 0.8219, 23.2898>, <-0.850, 0.493, 0.186>, <5.5511, -0.2043, 21.4551>, <-0.293, 0.926, -0.240>, <6.7929, 0.8340, 23.2729>, <-0.122, 0.934, -0.336> }
	smooth_triangle { <6.7929, 0.8340, 23.2729>, <-0.122, 0.934, -0.336>, <5.5511, -0.2043, 21.4551>, <-0.099, 0.943, -0.317>, <5.5731, -0.2154, 21.4494>, <0.576, 0.571, -0.585> }
	smooth_triangle { <6.7929, 0.8340, 23.2729>, <-0.122, 0.934, -0.336>, <5.5731, -0.2154, 21.4494>, <0.576, 0.571, -0.585>, <6.8143, 0.8232, 23.2645>, <0.728, 0.446, -0.521> }
	smooth_triangle { <6.8143, 0.8232, 23.2645>, <0.728, 0.446, -0.521>, <5.5731, -0.2154, 21.4494>, <0.705, 0.415, -0.575>, <5.5768, -0.2399, 21.4551>, <0.868, -0.356, -0.346> }
	smooth_triangle { <6.8143, 0.8232, 23.2645>, <0.728, 0.446, -0.521>, <5.5768, -0.2399, 21.4551>, <0.868, -0.356, -0.346>, <6.8211, 0.8003, 23.2729>, <0.853, -0.490, -0.180> }
	smooth_triangle { <6.8211, 0.8003, 23.2729>, <0.853, -0.490, -0.180>, <5.5768, -0.2399, 21.4551>, <0.813, -0.519, -0.265>, <5.5584, -0.2532, 21.4665>, <0.610, -0.792, 0.013> }
	smooth_triangle { <6.8211, 0.8003, 23.2729>, <0.853, -0.490, -0.180>, <5.5584, -0.2532, 21.4665>, <0.610, -0.792, 0.013>, <6.8066, 0.7881, 23.2898>, <0.641, -0.768, 0.000> }
	smooth_triangle { <7.3454, 1.2999, 25.6071>, <-0.315, -0.907, 0.278>, <6.8066, 0.7881, 23.2898>, <-0.029, -0.910, 0.414>, <6.7852, 0.7989, 23.2983>, <-0.725, -0.444, 0.527> }
	smooth_triangle { <7.3454, 1.2999, 25.6071>, <-0.951, -0.154, 0.269>, <6.7852, 0.7989, 23.2983>, <-0.725, -0.444, 0.527>, <6.7784, 0.8219, 23.2898>, <-0.850, 0.493, 0.186> }
	smooth_triangle { <7.3454, 1.2999, 25.6071>, <-0.640, 0.768, 0.003>, <6.7784, 0.8219, 23.2898>, <-0.850, 0.493, 0.186>, <6.7929, 0.8340, 23.2729>, <-0.122, 0.934, -0.336> }
	smooth_triangle { <7.3454, 1.2999, 25.6071>, <0.323, 0.912, -0.254>, <6.7929, 0.8340, 23.2729>, <-0.122, 0.934, -0.336>, <6.8143, 0.8232, 23.2645>, <0.728, 0.446, -0.521> }
	smooth_triangle { <7.3454, 1.2999, 25.6071>, <0.956, 0.161, -0.245>, <6.8143, 0.8232, 23.2645>, <0.728, 0.446, -0.521>, <6.8211, 0.8003, 23.2729>, <0.853, -0.490, -0.180> }
	smooth_triangle { <7.3454, 1.2999, 25.6071>, <0.651, -0.759, 0.021>, <6.8211, 0.8003, 23.2729>, <0.853, -0.490, -0.180>, <6.8066, 0.7881, 23.2898>, <-0.029, -0.910, 0.414> }

	texture { PSWL_BARK }
}

/* Object 'PWL0015F' */
union {
	smooth_triangle { <1.1454, 0.5643, 14.9691>, <0.434, -0.764, -0.478>, <0.6564, 0.4508, 14.6775>, <0.438, -0.791, -0.427>, <0.1980, 0.1232, 14.8139>, <0.434, -0.764, -0.478> }
	smooth_triangle { <0.1980, 0.1232, 14.8139>, <0.434, -0.764, -0.478>, <0.7053, 0.2194, 15.0919>, <0.428, -0.734, -0.527>, <1.1454, 0.5643, 14.9691>, <0.434, -0.764, -0.478> }
	smooth_triangle { <1.4292, -0.2975, 16.3216>, <0.261, 0.864, 0.431>, <1.9680, -0.2518, 15.9514>, <0.270, 0.826, 0.495>, <2.5850, -0.5019, 16.0322>, <0.261, 0.864, 0.431> }
	smooth_triangle { <2.5850, -0.5019, 16.0322>, <0.261, 0.864, 0.431>, <2.0220, -0.5073, 16.4318>, <0.250, 0.897, 0.364>, <1.4292, -0.2975, 16.3216>, <0.261, 0.864, 0.431> }
	smooth_triangle { <1.3307, -0.8645, 17.6351>, <0.770, -0.632, -0.087>, <1.0262, -1.1582, 17.2701>, <0.778, -0.608, -0.160>, <0.7099, -1.5802, 17.3363>, <0.770, -0.632, -0.087> }
	smooth_triangle { <0.7099, -1.5802, 17.3363>, <0.770, -0.632, -0.087>, <1.0245, -1.2225, 17.7275>, <0.758, -0.652, -0.014>, <1.3307, -0.8645, 17.6351>, <0.770, -0.632, -0.087> }
	smooth_triangle { <1.3992, -1.3828, 18.9607>, <0.382, 0.833, 0.401>, <1.8733, -1.4763, 18.6755>, <0.383, 0.852, 0.356>, <2.3562, -1.7533, 18.8197>, <0.382, 0.833, 0.401> }
	smooth_triangle { <2.3562, -1.7533, 18.8197>, <0.382, 0.833, 0.401>, <1.8680, -1.6775, 19.0976>, <0.380, 0.811, 0.446>, <1.3992, -1.3828, 18.9607>, <0.382, 0.833, 0.401> }
	smooth_triangle { <1.2545, -1.8435, 20.3047>, <0.549, -0.832, -0.076>, <0.7014, -2.1549, 19.8528>, <0.553, -0.826, -0.108>, <0.1223, -2.5646, 20.0198>, <0.549, -0.832, -0.076> }
	smooth_triangle { <0.1223, -2.5646, 20.0198>, <0.549, -0.832, -0.076>, <0.6943, -2.2170, 20.4844>, <0.545, -0.838, -0.044>, <1.2545, -1.8435, 20.3047>, <0.549, -0.832, -0.076> }
	smooth_triangle { <1.2911, -2.2961, 21.6555>, <0.560, 0.763, 0.322>, <1.8419, -2.4922, 21.2995>, <0.545, 0.704, 0.456>, <2.3729, -3.0064, 21.4587>, <0.560, 0.763, 0.322> }
	smooth_triangle { <2.3729, -3.0064, 21.4587>, <0.560, 0.763, 0.322>, <1.8175, -2.7068, 21.8493>, <0.563, 0.807, 0.181>, <1.2911, -2.2961, 21.6555>, <0.560, 0.763, 0.322> }
	smooth_triangle { <1.1126, -2.6208, 22.8238>, <0.361, -0.871, -0.334>, <0.6900, -2.7140, 22.5425>, <0.355, -0.905, -0.234>, <0.2251, -2.9298, 22.6706>, <0.361, -0.871, -0.334> }
	smooth_triangle { <0.2251, -2.9298, 22.6706>, <0.361, -0.871, -0.334>, <0.6472, -2.8842, 22.9381>, <0.362, -0.827, -0.431>, <1.1126, -2.6208, 22.8238>, <0.361, -0.871, -0.334> }
	smooth_triangle { <1.1261, -2.9619, 23.9984>, <0.413, 0.874, 0.257>, <1.5755, -3.1083, 23.7599>, <0.414, 0.878, 0.240>, <2.0111, -3.3645, 23.9466>, <0.413, 0.874, 0.257> }
	smooth_triangle { <2.0111, -3.3645, 23.9466>, <0.413, 0.874, 0.257>, <1.5475, -3.2195, 24.1836>, <0.412, 0.869, 0.273>, <1.1261, -2.9619, 23.9984>, <0.413, 0.874, 0.257> }
	smooth_triangle { <1.6024, -3.1228, 24.5967>, <0.719, 0.310, -0.622>, <1.5283, -3.5694, 24.2505>, <0.784, 0.294, -0.547>, <1.7404, -4.1028, 24.2675>, <0.719, 0.310, -0.622> }
	smooth_triangle { <1.7404, -4.1028, 24.2675>, <0.719, 0.310, -0.622>, <1.8522, -3.6525, 24.5826>, <0.646, 0.323, -0.691>, <1.6024, -3.1228, 24.5967>, <0.719, 0.310, -0.622> }
	smooth_triangle { <2.1523, -3.1830, 25.1976>, <-0.298, 0.905, 0.303>, <2.3929, -2.9555, 24.7555>, <-0.298, 0.905, 0.304>, <2.8610, -2.7781, 24.6863>, <-0.298, 0.905, 0.303> }
	smooth_triangle { <2.8610, -2.7781, 24.6863>, <-0.298, 0.905, 0.303>, <2.6101, -3.0112, 25.1359>, <-0.299, 0.905, 0.303>, <2.1523, -3.1830, 25.1976>, <-0.298, 0.905, 0.303> }
	smooth_triangle { <2.6886, -3.1923, 25.7886>, <0.562, 0.488, -0.668>, <2.6519, -3.7954, 25.2961>, <0.598, 0.485, -0.638>, <3.0475, -4.3718, 25.2293>, <0.562, 0.488, -0.668> }
	smooth_triangle { <3.0475, -4.3718, 25.2293>, <0.562, 0.488, -0.668>, <3.1067, -3.7592, 25.7050>, <0.525, 0.490, -0.696>, <2.6886, -3.1923, 25.7886>, <0.562, 0.488, -0.668> }
	smooth_triangle { <3.2608, -3.0404, 26.3843>, <-0.675, 0.500, 0.543>, <3.3892, -2.5051, 26.0049>, <-0.720, 0.508, 0.473>, <3.8850, -1.8950, 26.1050>, <-0.675, 0.500, 0.543> }
	smooth_triangle { <3.8850, -1.8950, 26.1050>, <-0.675, 0.500, 0.543>, <3.7861, -2.4562, 26.4539>, <-0.624, 0.489, 0.609>, <3.2608, -3.0404, 26.3843>, <-0.675, 0.500, 0.543> }
	smooth_triangle { <1.3074, -2.9777, 22.0572>, <0.513, -0.380, -0.770>, <0.8008, -2.9395, 21.7531>, <0.486, -0.242, -0.840>, <0.3536, -3.3840, 21.6226>, <0.513, -0.380, -0.770> }
	smooth_triangle { <0.3536, -3.3840, 21.6226>, <0.513, -0.380, -0.770>, <0.8667, -3.3711, 22.0102>, <0.527, -0.509, -0.681>, <1.3074, -2.9777, 22.0572>, <0.513, -0.380, -0.770> }
	smooth_triangle { <1.4905, -3.6678, 22.4537>, <0.795, 0.317, 0.517>, <1.8225, -3.5937, 21.9352>, <0.797, 0.257, 0.547>, <2.2524, -4.0962, 21.5448>, <0.795, 0.317, 0.517> }
	smooth_triangle { <2.2524, -4.0962, 21.5448>, <0.795, 0.317, 0.517>, <1.9043, -4.1288, 22.1365>, <0.790, 0.375, 0.485>, <1.4905, -3.6678, 22.4537>, <0.795, 0.317, 0.517> }
	smooth_triangle { <1.4521, -4.8352, 22.2029>, <0.825, 0.133, -0.550>, <1.1143, -4.4602, 21.6819>, <0.811, -0.075, -0.580>, <0.7783, -4.6496, 21.2367>, <0.825, 0.133, -0.550> }
	smooth_triangle { <0.7783, -4.6496, 21.2367>, <0.825, 0.133, -0.550>, <1.1248, -4.9858, 21.5704>, <0.802, 0.335, -0.495>, <1.4521, -4.8352, 22.2029>, <0.825, 0.133, -0.550> }
	smooth_triangle { <1.5579, -6.0338, 21.9877>, <0.237, -0.137, 0.962>, <2.1597, -5.7117, 21.9000>, <0.239, -0.187, 0.953>, <2.7900, -5.9489, 21.6956>, <0.237, -0.137, 0.962> }
	smooth_triangle { <2.7900, -5.9489, 21.6956>, <0.237, -0.137, 0.962>, <2.1710, -6.2784, 21.8167>, <0.236, -0.087, 0.968>, <1.5579, -6.0338, 21.9877>, <0.237, -0.137, 0.962> }
	smooth_triangle { <0.9234, -6.7179, 21.1714>, <0.501, 0.489, -0.714>, <0.6047, -6.1897, 21.3123>, <0.504, 0.493, -0.709>, <0.0465, -5.9502, 21.0824>, <0.501, 0.489, -0.714> }
	smooth_triangle { <0.0465, -5.9502, 21.0824>, <0.501, 0.489, -0.714>, <0.3760, -6.4911, 20.9454>, <0.498, 0.485, -0.719>, <0.9234, -6.7179, 21.1714>, <0.501, 0.489, -0.714> }
	smooth_triangle { <0.4683, -7.4872, 20.3358>, <-0.071, -0.726, 0.684>, <1.2528, -7.5219, 20.3221>, <-0.015, -0.648, 0.762>, <1.7340, -7.9869, 19.9363>, <-0.071, -0.726, 0.684> }
	smooth_triangle { <1.7340, -7.9869, 19.9363>, <-0.071, -0.726, 0.684>, <0.9667, -7.8990, 19.8924>, <-0.125, -0.793, 0.596>, <0.4683, -7.4872, 20.3358>, <-0.071, -0.726, 0.684> }
	smooth_triangle { <0.1211, -8.4657, 19.7544>, <0.938, 0.042, -0.345>, <0.0606, -7.9198, 19.6055>, <0.910, -0.012, -0.413>, <-0.0985, -7.7168, 19.2491>, <0.938, 0.042, -0.345> }
	smooth_triangle { <-0.0985, -7.7168, 19.2491>, <0.938, 0.042, -0.345>, <-0.0127, -8.2439, 19.3649>, <0.957, 0.096, -0.274>, <0.1211, -8.4657, 19.7544>, <0.938, 0.042, -0.345> }
	smooth_triangle { <-0.1078, -9.5759, 19.2094>, <-0.138, -0.447, 0.884>, <0.4813, -9.6540, 19.2737>, <-0.157, -0.475, 0.866>, <0.9620, -10.2105, 19.0559>, <-0.138, -0.447, 0.884> }
	smooth_triangle { <0.9620, -10.2105, 19.0559>, <-0.138, -0.447, 0.884>, <0.3488, -10.1354, 19.0100>, <-0.118, -0.418, 0.901>, <-0.1078, -9.5759, 19.2094>, <-0.138, -0.447, 0.884> }
	smooth_triangle { <0.7185, -2.2072, 22.2804>, <-0.776, -0.229, -0.588>, <0.7797, -1.7160, 22.0236>, <-0.752, -0.229, -0.618>, <0.5433, -1.2062, 22.1219>, <-0.776, -0.229, -0.588> }
	smooth_triangle { <0.5433, -1.2062, 22.1219>, <-0.776, -0.229, -0.588>, <0.4988, -1.7117, 22.3928>, <-0.799, -0.228, -0.557>, <0.7185, -2.2072, 22.2804>, <-0.776, -0.229, -0.588> }
	smooth_triangle { <0.1743, -2.2813, 22.8860>, <0.326, -0.811, 0.486>, <0.0441, -2.6042, 22.4481>, <0.308, -0.807, 0.504>, <-0.5511, -2.9291, 22.2917>, <0.326, -0.811, 0.486> }
	smooth_triangle { <-0.5511, -2.9291, 22.2917>, <0.326, -0.811, 0.486>, <-0.3932, -2.5974, 22.7525>, <0.343, -0.814, 0.468>, <0.1743, -2.2813, 22.8860>, <0.326, -0.811, 0.486> }
	smooth_triangle { <-0.6025, -2.3043, 23.8244>, <-0.704, -0.383, -0.599>, <-0.6514, -1.6729, 23.4526>, <-0.734, -0.386, -0.559>, <-1.0578, -1.0695, 23.5698>, <-0.704, -0.383, -0.599> }
	smooth_triangle { <-1.0578, -1.0695, 23.5698>, <-0.704, -0.383, -0.599>, <-1.0264, -1.7213, 23.9243>, <-0.671, -0.379, -0.637>, <-0.6025, -2.3043, 23.8244>, <-0.704, -0.383, -0.599> }
	smooth_triangle { <-1.4013, -2.4959, 24.7299>, <0.620, -0.652, 0.436>, <-1.5430, -2.9504, 24.1762>, <0.688, -0.637, 0.347>, <-1.9840, -3.4560, 24.1216>, <0.620, -0.652, 0.436> }
	smooth_triangle { <-1.9840, -3.4560, 24.1216>, <0.620, -0.652, 0.436>, <-1.9055, -2.9972, 24.6213>, <0.543, -0.659, 0.520>, <-1.4013, -2.4959, 24.7299>, <0.620, -0.652, 0.436> }
	smooth_triangle { <-2.3628, -1.7738, 24.9841>, <-0.649, -0.355, -0.673>, <-2.0545, -1.5422, 24.5666>, <-0.645, -0.359, -0.675>, <-2.0839, -1.0811, 24.3495>, <-0.649, -0.355, -0.673> }
	smooth_triangle { <-2.0839, -1.0811, 24.3495>, <-0.649, -0.355, -0.673>, <-2.3954, -1.3228, 24.7792>, <-0.653, -0.352, -0.671>, <-2.3628, -1.7738, 24.9841>, <-0.649, -0.355, -0.673> }
	smooth_triangle { <-3.4093, -1.2098, 25.2709>, <0.100, -0.316, 0.943>, <-3.5410, -1.8898, 25.0407>, <0.141, -0.342, 0.929>, <-4.1667, -2.2737, 24.9944>, <0.100, -0.316, 0.943> }
	smooth_triangle { <-4.1667, -2.2737, 24.9944>, <0.100, -0.316, 0.943>, <-4.0299, -1.5751, 25.1982>, <0.059, -0.290, 0.955>, <-3.4093, -1.2098, 25.2709>, <0.100, -0.316, 0.943> }
	smooth_triangle { <-3.6060, -0.4050, 25.9164>, <-0.492, 0.352, -0.796>, <-3.0678, -0.3135, 25.6277>, <-0.489, 0.344, -0.802>, <-2.6717, 0.2088, 25.6106>, <-0.492, 0.352, -0.796> }
	smooth_triangle { <-2.6717, 0.2088, 25.6106>, <-0.492, 0.352, -0.796>, <-3.2218, 0.1054, 25.9078>, <-0.495, 0.359, -0.791>, <-3.6060, -0.4050, 25.9164>, <-0.492, 0.352, -0.796> }
	smooth_triangle { <-3.9553, 0.3182, 26.5441>, <-0.707, -0.524, 0.475>, <-4.2432, 0.3094, 26.0634>, <-0.688, -0.590, 0.423>, <-4.6721, 0.6614, 25.8573>, <-0.707, -0.524, 0.475> }
	smooth_triangle { <-4.6721, 0.6614, 25.8573>, <-0.707, -0.524, 0.475>, <-4.3915, 0.7127, 26.2869>, <-0.720, -0.454, 0.524>, <-3.9553, 0.3182, 26.5441>, <-0.707, -0.524, 0.475> }
	smooth_triangle { <-3.8556, 1.1493, 27.1616>, <-0.732, 0.411, -0.543>, <-3.4389, 1.3145, 26.7086>, <-0.737, 0.431, -0.521>, <-2.9913, 1.9571, 26.6071>, <-0.732, 0.411, -0.543> }
	smooth_triangle { <-2.9913, 1.9571, 26.6071>, <-0.732, 0.411, -0.543>, <-3.4247, 1.7928, 27.0522>, <-0.727, 0.391, -0.564>, <-3.8556, 1.1493, 27.1616>, <-0.732, 0.411, -0.543> }
	smooth_triangle { <-3.9141, 1.9187, 27.7830>, <0.060, -0.621, 0.782>, <-4.4467, 1.5949, 27.5571>, <0.069, -0.645, 0.761>, <-4.9736, 1.6473, 27.6493>, <0.060, -0.621, 0.782> }
	smooth_triangle { <-4.9736, 1.6473, 27.6493>, <0.060, -0.621, 0.782>, <-4.4296, 1.9844, 27.8648>, <0.051, -0.596, 0.802>, <-3.9141, 1.9187, 27.7830>, <0.060, -0.621, 0.782> }
	smooth_triangle { <0.8047, -1.4210, 19.5704>, <-0.684, -0.395, -0.613>, <0.7477, -0.7874, 19.2342>, <-0.674, -0.393, -0.626>, <0.3051, -0.2132, 19.3506>, <-0.684, -0.395, -0.613> }
	smooth_triangle { <0.3051, -0.2132, 19.3506>, <-0.684, -0.395, -0.613>, <0.3765, -0.8623, 19.6966>, <-0.694, -0.396, -0.601>, <0.8047, -1.4210, 19.5704>, <-0.684, -0.395, -0.613> }
	smooth_triangle { <0.2936, -1.6267, 20.1765>, <0.789, -0.248, 0.562>, <0.4217, -2.1993, 19.7983>, <0.722, -0.261, 0.640>, <0.1466, -2.8702, 19.8346>, <0.789, -0.248, 0.562> }
	smooth_triangle { <0.1466, -2.8702, 19.8346>, <0.789, -0.248, 0.562>, <0.0697, -2.2703, 20.2615>, <0.847, -0.232, 0.478>, <0.2936, -1.6267, 20.1765>, <0.789, -0.248, 0.562> }
	smooth_triangle { <-0.9462, -1.4931, 20.8741>, <-0.505, -0.271, -0.819>, <-0.7678, -0.8622, 20.5449>, <-0.529, -0.270, -0.804>, <-1.1006, -0.2004, 20.5413>, <-0.505, -0.271, -0.819> }
	smooth_triangle { <-1.1006, -0.2004, 20.5413>, <-0.505, -0.271, -0.819>, <-1.2853, -0.8492, 20.8599>, <-0.482, -0.272, -0.833>, <-0.9462, -1.4931, 20.8741>, <-0.505, -0.271, -0.819> }
	smooth_triangle { <-2.1941, -1.5587, 21.5604>, <0.466, -0.519, 0.716>, <-2.1426, -1.9677, 21.2287>, <0.471, -0.519, 0.713>, <-2.4540, -2.3792, 21.1348>, <0.466, -0.519, 0.716> }
	smooth_triangle { <-2.4540, -2.3792, 21.1348>, <0.466, -0.519, 0.716>, <-2.5034, -1.9586, 21.4699>, <0.461, -0.519, 0.720>, <-2.1941, -1.5587, 21.5604>, <0.466, -0.519, 0.716> }
	smooth_triangle { <-2.7579, -2.3055, 22.3101>, <0.391, -0.765, -0.512>, <-3.0889, -2.1107, 21.8517>, <0.457, -0.650, -0.607>, <-3.7110, -2.3267, 21.6146>, <0.391, -0.765, -0.512> }
	smooth_triangle { <-3.7110, -2.3267, 21.6146>, <0.391, -0.765, -0.512>, <-3.3203, -2.4528, 22.1869>, <0.314, -0.859, -0.404>, <-2.7579, -2.3055, 22.3101>, <0.391, -0.765, -0.512> }
	smooth_triangle { <-3.2309, -3.1365, 23.0701>, <0.855, 0.030, 0.518>, <-2.9771, -3.3539, 22.6834>, <0.836, -0.001, 0.549>, <-2.8983, -3.8469, 22.5628>, <0.855, 0.030, 0.518> }
	smooth_triangle { <-2.8983, -3.8469, 22.5628>, <0.855, 0.030, 0.518>, <-3.1471, -3.6053, 22.9783>, <0.871, 0.060, 0.487>, <-3.2309, -3.1365, 23.0701>, <0.855, 0.030, 0.518> }
	smooth_triangle { <-3.5463, -4.1922, 23.5398>, <0.529, -0.483, -0.697>, <-3.8808, -4.0191, 23.1711>, <0.534, -0.468, -0.704>, <-4.3055, -4.2153, 22.9794>, <0.529, -0.483, -0.697> }
	smooth_triangle { <-4.3055, -4.2153, 22.9794>, <0.529, -0.483, -0.697>, <-3.9563, -4.3820, 23.3651>, <0.525, -0.498, -0.690>, <-3.5463, -4.1922, 23.5398>, <0.529, -0.483, -0.697> }
	smooth_triangle { <-3.7484, -5.3252, 24.0088>, <0.939, -0.092, 0.332>, <-3.6147, -5.4304, 23.7036>, <0.865, -0.216, 0.453>, <-3.6086, -5.9687, 23.4353>, <0.939, -0.092, 0.332> }
	smooth_triangle { <-3.6086, -5.9687, 23.4353>, <0.939, -0.092, 0.332>, <-3.6992, -5.7878, 23.8500>, <0.979, 0.036, 0.198>, <-3.7484, -5.3252, 24.0088>, <0.939, -0.092, 0.332> }
	smooth_triangle { <1.8523, -1.3945, 19.6084>, <0.395, 0.842, -0.367>, <2.0710, -1.7630, 19.0691>, <0.344, 0.834, -0.431>, <2.8213, -2.1446, 18.9288>, <0.395, 0.842, -0.367> }
	smooth_triangle { <2.8213, -2.1446, 18.9288>, <0.395, 0.842, -0.367>, <2.5085, -1.7652, 19.5338>, <0.443, 0.845, -0.301>, <1.8523, -1.3945, 19.6084>, <0.395, 0.842, -0.367> }
	smooth_triangle { <2.3162, -1.3367, 20.2760>, <-0.456, 0.805, 0.380>, <2.4907, -1.0384, 19.8750>, <-0.435, 0.803, 0.408>, <2.9902, -0.7332, 19.8072>, <-0.456, 0.805, 0.380> }
	smooth_triangle { <2.9902, -0.7332, 19.8072>, <-0.456, 0.805, 0.380>, <2.7845, -1.0399, 20.2300>, <-0.476, 0.806, 0.353>, <2.3162, -1.3367, 20.2760>, <-0.456, 0.805, 0.380> }
	smooth_triangle { <3.0810, -1.6750, 21.4372>, <0.790, 0.188, -0.583>, <2.8874, -2.2791, 21.0420>, <0.717, 0.206, -0.666>, <3.1488, -3.0477, 21.0856>, <0.790, 0.188, -0.583> }
	smooth_triangle { <3.1488, -3.0477, 21.0856>, <0.790, 0.188, -0.583>, <3.2799, -2.4046, 21.5328>, <0.854, 0.168, -0.492>, <3.0810, -1.6750, 21.4372>, <0.790, 0.188, -0.583> }
	smooth_triangle { <3.8990, -1.8308, 22.5949>, <-0.685, 0.400, 0.609>, <3.9795, -1.3917, 22.3823>, <-0.711, 0.408, 0.573>, <4.2933, -1.0140, 22.5026>, <-0.685, 0.400, 0.609> }
	smooth_triangle { <4.2933, -1.0140, 22.5026>, <-0.685, 0.400, 0.609>, <4.2218, -1.4693, 22.7053>, <-0.658, 0.390, 0.644>, <3.8990, -1.8308, 22.5949>, <-0.685, 0.400, 0.609> }
	smooth_triangle { <3.6567, -2.4569, 23.6523>, <-0.032, -0.897, -0.440>, <3.1680, -2.3161, 23.3787>, <-0.038, -0.914, -0.403>, <2.6104, -2.3639, 23.5391>, <-0.032, -0.897, -0.440> }
	smooth_triangle { <2.6104, -2.3639, 23.5391>, <-0.032, -0.897, -0.440>, <3.1090, -2.5229, 23.8043>, <-0.026, -0.879, -0.477>, <3.6567, -2.4569, 23.6523>, <-0.032, -0.897, -0.440> }
	smooth_triangle { <3.5683, -3.0873, 24.6962>, <0.855, 0.311, 0.416>, <3.9165, -3.4117, 24.2403>, <0.849, 0.298, 0.436>, <4.1700, -4.1121, 24.2260>, <0.855, 0.311, 0.416> }
	smooth_triangle { <4.1700, -4.1121, 24.2260>, <0.855, 0.311, 0.416>, <3.8183, -3.7558, 24.6990>, <0.860, 0.323, 0.396>, <3.5683, -3.0873, 24.6962>, <0.855, 0.311, 0.416> }
	smooth_triangle { <4.0632, -4.0367, 25.2002>, <0.853, 0.150, -0.501>, <3.8393, -4.1557, 24.7428>, <0.889, 0.070, -0.453>, <3.7678, -4.5619, 24.5399>, <0.853, 0.150, -0.501> }
	smooth_triangle { <3.7678, -4.5619, 24.5399>, <0.853, 0.150, -0.501>, <4.0106, -4.4619, 24.9432>, <0.808, 0.228, -0.543>, <4.0632, -4.0367, 25.2002>, <0.853, 0.150, -0.501> }
	smooth_triangle { <4.6629, -4.9564, 25.7356>, <0.402, 0.446, 0.799>, <5.0711, -4.5636, 25.3227>, <0.414, 0.419, 0.808>, <5.7981, -4.7083, 25.0255>, <0.402, 0.446, 0.799> }
	smooth_triangle { <5.7981, -4.7083, 25.0255>, <0.402, 0.446, 0.799>, <5.3689, -5.0957, 25.4697>, <0.391, 0.473, 0.790>, <4.6629, -4.9564, 25.7356>, <0.402, 0.446, 0.799> }
	smooth_triangle { <4.1794, -6.0790, 26.0041>, <0.004, -0.197, -0.980>, <3.7918, -5.7239, 25.9275>, <-0.001, -0.211, -0.977>, <3.2504, -5.7737, 25.9386>, <0.004, -0.197, -0.980> }
	smooth_triangle { <3.2504, -5.7737, 25.9386>, <0.004, -0.197, -0.980>, <3.6506, -6.1344, 26.0096>, <0.009, -0.183, -0.983>, <4.1794, -6.0790, 26.0041>, <0.004, -0.197, -0.980> }
	smooth_triangle { <3.8816, -7.2452, 26.2231>, <0.556, -0.074, 0.828>, <4.4403, -7.2025, 25.9031>, <0.498, -0.210, 0.841>, <4.8235, -7.7151, 25.5484>, <0.556, -0.074, 0.828> }
	smooth_triangle { <4.8235, -7.7151, 25.5484>, <0.556, -0.074, 0.828>, <4.2582, -7.7320, 25.9771>, <0.602, 0.063, 0.796>, <3.8816, -7.2452, 26.2231>, <0.556, -0.074, 0.828> }
	smooth_triangle { <3.4827, -8.3780, 26.4158>, <0.443, -0.184, -0.878>, <3.0384, -7.9966, 26.1072>, <0.439, -0.198, -0.876>, <2.4360, -8.1429, 25.8383>, <0.443, -0.184, -0.878> }
	smooth_triangle { <2.4360, -8.1429, 25.8383>, <0.443, -0.184, -0.878>, <2.8944, -8.5293, 26.1463>, <0.446, -0.171, -0.878>, <3.4827, -8.3780, 26.4158>, <0.443, -0.184, -0.878> }
	smooth_triangle { <3.2544, -9.5713, 26.5996>, <0.612, -0.024, 0.791>, <3.8371, -9.5208, 26.2001>, <0.568, -0.139, 0.811>, <4.2675, -10.0925, 25.8006>, <0.612, -0.024, 0.791> }
	smooth_triangle { <4.2675, -10.0925, 25.8006>, <0.612, -0.024, 0.791>, <3.6768, -10.1174, 26.3062>, <0.645, 0.092, 0.758>, <3.2544, -9.5713, 26.5996>, <0.612, -0.024, 0.791> }
	smooth_triangle { <1.7097, -1.1279, 19.6597>, <0.199, 0.884, -0.423>, <2.0536, -1.4094, 19.3327>, <0.131, 0.815, -0.564>, <2.6692, -1.4858, 19.3648>, <0.199, 0.884, -0.423> }
	smooth_triangle { <2.6692, -1.4858, 19.3648>, <0.199, 0.884, -0.423>, <2.2442, -1.2543, 19.7455>, <0.262, 0.926, -0.270>, <1.7097, -1.1279, 19.6597>, <0.199, 0.884, -0.423> }
	smooth_triangle { <1.9444, -0.8117, 20.3777>, <-0.753, -0.457, 0.474>, <1.4605, -0.3471, 20.0717>, <-0.744, -0.450, 0.494>, <1.2028, 0.3263, 20.2964>, <-0.753, -0.457, 0.474> }
	smooth_triangle { <1.2028, 0.3263, 20.2964>, <-0.753, -0.457, 0.474>, <1.6879, -0.1620, 20.6105>, <-0.761, -0.463, 0.455>, <1.9444, -0.8117, 20.3777>, <-0.753, -0.457, 0.474> }
	smooth_triangle { <2.5677, -1.2943, 21.3527>, <0.818, 0.224, -0.530>, <2.4646, -1.6598, 21.0065>, <0.861, 0.200, -0.468>, <2.5809, -2.1811, 20.9974>, <0.818, 0.224, -0.530> }
	smooth_triangle { <2.5809, -2.1811, 20.9974>, <0.818, 0.224, -0.530>, <2.7144, -1.8232, 21.3224>, <0.770, 0.247, -0.588>, <2.5677, -1.2943, 21.3527>, <0.818, 0.224, -0.530> }
	smooth_triangle { <3.2071, -1.6229, 22.3403>, <-0.087, 0.964, 0.251>, <3.5492, -1.4648, 21.9173>, <-0.052, 0.948, 0.313>, <4.0902, -1.4259, 21.8889>, <-0.087, 0.964, 0.251> }
	smooth_triangle { <4.0902, -1.4259, 21.8889>, <-0.087, 0.964, 0.251>, <3.6999, -1.5634, 22.3488>, <-0.121, 0.975, 0.189>, <3.2071, -1.6229, 22.3403>, <-0.087, 0.964, 0.251> }
	smooth_triangle { <4.2622, -1.4606, 22.8599>, <0.112, 0.673, -0.731>, <4.2388, -1.9850, 22.4123>, <0.030, 0.648, -0.761>, <4.8278, -2.4050, 22.0775>, <0.112, 0.673, -0.731> }
	smooth_triangle { <4.8278, -2.4050, 22.0775>, <0.112, 0.673, -0.731>, <4.8122, -1.8734, 22.6019>, <0.193, 0.692, -0.696>, <4.2622, -1.4606, 22.8599>, <0.112, 0.673, -0.731> }
	smooth_triangle { <5.3230, -1.1670, 23.3912>, <-0.287, 0.490, 0.823>, <5.1227, -0.7560, 23.0799>, <-0.276, 0.491, 0.826>, <5.3993, -0.2393, 22.8649>, <-0.287, 0.490, 0.823> }
	smooth_triangle { <5.3993, -0.2393, 22.8649>, <-0.287, 0.490, 0.823>, <5.5954, -0.6640, 23.1902>, <-0.299, 0.489, 0.819>, <5.3230, -1.1670, 23.3912>, <-0.287, 0.490, 0.823> }
	smooth_triangle { <5.9815, -1.6820, 24.0312>, <0.633, -0.064, -0.772>, <5.6210, -2.0475, 23.7916>, <0.574, -0.029, -0.818>, <5.6024, -2.6408, 23.7999>, <0.633, -0.064, -0.772> }
	smooth_triangle { <5.6024, -2.6408, 23.7999>, <0.633, -0.064, -0.772>, <5.9467, -2.2485, 24.0752>, <0.687, -0.098, -0.720>, <5.9815, -1.6820, 24.0312>, <0.633, -0.064, -0.772> }
	smooth_triangle { <6.7213, -2.0394, 24.6354>, <0.000, 0.915, 0.405>, <7.0107, -1.7716, 24.0450>, <0.014, 0.908, 0.419>, <7.6369, -1.6989, 23.8667>, <0.000, 0.915, 0.405> }
	smooth_triangle { <7.6369, -1.6989, 23.8667>, <0.000, 0.915, 0.405>, <7.3245, -1.9652, 24.4831>, <-0.015, 0.921, 0.390>, <6.7213, -2.0394, 24.6354>, <0.000, 0.915, 0.405> }
	smooth_triangle { <6.9783, -2.7872, 25.3415>, <0.678, -0.347, -0.648>, <6.6238, -3.1046, 25.1376>, <0.682, -0.350, -0.642>, <6.4175, -3.7792, 25.2857>, <0.678, -0.347, -0.648> }
	smooth_triangle { <6.4175, -3.7792, 25.2857>, <0.678, -0.347, -0.648>, <6.7819, -3.4490, 25.4874>, <0.674, -0.344, -0.654>, <6.9783, -2.7872, 25.3415>, <0.678, -0.347, -0.648> }
	smooth_triangle { <7.3562, -3.3831, 26.0178>, <-0.578, 0.413, 0.704>, <7.5694, -2.7722, 25.8392>, <-0.567, 0.407, 0.716>, <7.9509, -2.4812, 25.9761>, <-0.578, 0.413, 0.704> }
	smooth_triangle { <7.9509, -2.4812, 25.9761>, <-0.578, 0.413, 0.704>, <7.7254, -3.1024, 26.1611>, <-0.587, 0.419, 0.692>, <7.3562, -3.3831, 26.0178>, <-0.578, 0.413, 0.704> }
	smooth_triangle { <1.9381, -0.5211, 16.8783>, <0.701, 0.214, -0.680>, <1.7808, -0.9238, 16.5895>, <0.702, 0.214, -0.680>, <1.9335, -1.4400, 16.5847>, <0.701, 0.214, -0.680> }
	smooth_triangle { <1.9335, -1.4400, 16.5847>, <0.701, 0.214, -0.680>, <2.0909, -1.0244, 16.8776>, <0.701, 0.214, -0.680>, <1.9381, -0.5211, 16.8783>, <0.701, 0.214, -0.680> }
	smooth_triangle { <2.5234, -0.6061, 17.4448>, <-0.577, 0.459, 0.675>, <2.6182, 0.0096, 17.1278>, <-0.545, 0.449, 0.708>, <3.1273, 0.5093, 17.2031>, <-0.577, 0.459, 0.675> }
	smooth_triangle { <3.1273, 0.5093, 17.2031>, <-0.577, 0.459, 0.675>, <3.0052, -0.1160, 17.5443>, <-0.609, 0.468, 0.640>, <2.5234, -0.6061, 17.4448>, <-0.577, 0.459, 0.675> }
	smooth_triangle { <3.5903, -0.8119, 18.3539>, <0.663, 0.283, -0.693>, <3.4475, -1.4225, 17.9787>, <0.644, 0.285, -0.710>, <3.7640, -2.0969, 17.9946>, <0.663, 0.283, -0.693> }
	smooth_triangle { <3.7640, -2.0969, 17.9946>, <0.663, 0.283, -0.693>, <3.8938, -1.4672, 18.3875>, <0.682, 0.281, -0.676>, <3.5903, -0.8119, 18.3539>, <0.663, 0.283, -0.693> }
	smooth_triangle { <4.6796, -0.8181, 19.2743>, <-0.617, 0.237, 0.750>, <4.6070, -0.2048, 18.9977>, <-0.663, 0.241, 0.708>, <4.9397, 0.3852, 19.1087>, <-0.617, 0.237, 0.750> }
	smooth_triangle { <4.9397, 0.3852, 19.1087>, <-0.617, 0.237, 0.750>, <5.0313, -0.2473, 19.3605>, <-0.569, 0.232, 0.789>, <4.6796, -0.8181, 19.2743>, <-0.617, 0.237, 0.750> }
	smooth_triangle { <5.1438, -0.5918, 20.3705>, <0.706, 0.541, -0.457>, <5.3403, -1.0076, 20.1816>, <0.707, 0.541, -0.456>, <5.6975, -1.3232, 20.3605>, <0.706, 0.541, -0.457> }
	smooth_triangle { <5.6975, -1.3232, 20.3605>, <0.706, 0.541, -0.457>, <5.4935, -0.8968, 20.5493>, <0.706, 0.540, -0.458>, <5.1438, -0.5918, 20.3705>, <0.706, 0.541, -0.457> }
	smooth_triangle { <5.5314, -0.1810, 21.4562>, <-0.817, -0.356, 0.453>, <5.2233, 0.2260, 21.1959>, <-0.834, -0.368, 0.411>, <5.0701, 0.7630, 21.3662>, <-0.817, -0.356, 0.453> }
	smooth_triangle { <5.0701, 0.7630, 21.3662>, <-0.817, -0.356, 0.453>, <5.4012, 0.3547, 21.6175>, <-0.799, -0.343, 0.495>, <5.5314, -0.1810, 21.4562>, <-0.817, -0.356, 0.453> }
	smooth_triangle { <6.2203, 0.2626, 22.3579>, <0.337, 0.761, -0.554>, <6.5867, -0.1596, 21.9802>, <0.356, 0.776, -0.521>, <7.2057, -0.3917, 22.0577>, <0.337, 0.761, -0.554> }
	smooth_triangle { <7.2057, -0.3917, 22.0577>, <0.337, 0.761, -0.554>, <6.8393, 0.0513, 22.4237>, <0.317, 0.746, -0.586>, <6.2203, 0.2626, 22.3579>, <0.337, 0.761, -0.554> }
	smooth_triangle { <6.8069, 0.8547, 23.2515>, <-0.764, 0.445, 0.468>, <6.6926, 1.2161, 22.7273>, <-0.758, 0.448, 0.474>, <6.9829, 1.9285, 22.5179>, <-0.764, 0.445, 0.468> }
	smooth_triangle { <6.9829, 1.9285, 22.5179>, <-0.764, 0.445, 0.468>, <7.0886, 1.5468, 23.0598>, <-0.770, 0.441, 0.461>, <6.8069, 0.8547, 23.2515>, <-0.764, 0.445, 0.468> }
	smooth_triangle { <7.1129, 1.0215, 24.4360>, <0.582, 0.761, -0.287>, <7.3980, 0.7137, 24.1776>, <0.591, 0.764, -0.259>, <7.7702, 0.4683, 24.3025>, <0.582, 0.761, -0.287> }
	smooth_triangle { <7.7702, 0.4683, 24.3025>, <0.582, 0.761, -0.287>, <7.4832, 0.7902, 24.5542>, <0.573, 0.757, -0.314>, <7.1129, 1.0215, 24.4360>, <0.582, 0.761, -0.287> }
	smooth_triangle { <7.3157, 1.3440, 25.6022>, <-0.811, -0.514, 0.281>, <6.9096, 1.8037, 25.2700>, <-0.811, -0.514, 0.280>, <6.6146, 2.3869, 25.4860>, <-0.811, -0.514, 0.281> }
	smooth_triangle { <6.6146, 2.3869, 25.4860>, <-0.811, -0.514, 0.281>, <7.0309, 1.9128, 25.8195>, <-0.811, -0.513, 0.282>, <7.3157, 1.3440, 25.6022>, <-0.811, -0.514, 0.281> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0016B' */
union {
	smooth_triangle { <-0.0094, 1.7984, 13.5485>, <0.302, 0.799, 0.519>, <0.8034, 2.3358, 12.2473>, <0.300, 0.798, 0.523>, <0.8490, 2.3076, 12.2641>, <0.548, 0.590, 0.592> }
	smooth_triangle { <-0.0094, 1.7984, 13.5485>, <0.302, 0.799, 0.519>, <0.8490, 2.3076, 12.2641>, <0.548, 0.590, 0.592>, <0.0362, 1.7702, 13.5653>, <0.760, 0.276, 0.589> }
	smooth_triangle { <0.0362, 1.7702, 13.5653>, <0.760, 0.276, 0.589>, <0.8490, 2.3076, 12.2641>, <0.548, 0.590, 0.592>, <0.8571, 2.2546, 12.2473>, <0.853, -0.341, 0.395> }
	smooth_triangle { <0.0362, 1.7702, 13.5653>, <0.760, 0.276, 0.589>, <0.8571, 2.2546, 12.2473>, <0.853, -0.341, 0.395>, <0.0443, 1.7172, 13.5485>, <0.740, -0.644, 0.196> }
	smooth_triangle { <0.0443, 1.7172, 13.5485>, <0.740, -0.644, 0.196>, <0.8571, 2.2546, 12.2473>, <0.853, -0.341, 0.395>, <0.8196, 2.2298, 12.2136>, <0.303, -0.933, -0.195> }
	smooth_triangle { <0.0443, 1.7172, 13.5485>, <0.740, -0.644, 0.196>, <0.8196, 2.2298, 12.2136>, <0.303, -0.933, -0.195>, <0.0068, 1.6924, 13.5148>, <-0.020, -0.920, -0.392> }
	smooth_triangle { <0.0068, 1.6924, 13.5148>, <-0.020, -0.920, -0.392>, <0.8196, 2.2298, 12.2136>, <0.303, -0.933, -0.195>, <0.7740, 2.2580, 12.1967>, <-0.551, -0.592, -0.587> }
	smooth_triangle { <0.0068, 1.6924, 13.5148>, <-0.020, -0.920, -0.392>, <0.7740, 2.2580, 12.1967>, <-0.551, -0.592, -0.587>, <-0.0388, 1.7205, 13.4979>, <-0.760, -0.276, -0.589> }
	smooth_triangle { <-0.0388, 1.7205, 13.4979>, <-0.760, -0.276, -0.589>, <0.7740, 2.2580, 12.1967>, <-0.551, -0.592, -0.587>, <0.7659, 2.3110, 12.2136>, <-0.856, 0.339, -0.390> }
	smooth_triangle { <-0.0388, 1.7205, 13.4979>, <-0.760, -0.276, -0.589>, <0.7659, 2.3110, 12.2136>, <-0.856, 0.339, -0.390>, <-0.0469, 1.7736, 13.5148>, <-0.740, 0.644, -0.196> }
	smooth_triangle { <-0.0469, 1.7736, 13.5148>, <-0.740, 0.644, -0.196>, <0.7659, 2.3110, 12.2136>, <-0.856, 0.339, -0.390>, <0.8034, 2.3358, 12.2473>, <-0.555, 0.832, 0.002> }
	smooth_triangle { <-0.0469, 1.7736, 13.5148>, <-0.740, 0.644, -0.196>, <0.8034, 2.3358, 12.2473>, <-0.555, 0.832, 0.002>, <-0.0094, 1.7984, 13.5485>, <-0.552, 0.834, 0.000> }
	smooth_triangle { <-1.6312, 0.6761, 16.1337>, <0.304, 0.805, 0.510>, <0.8034, 2.3358, 12.2473>, <0.300, 0.798, 0.523>, <0.8490, 2.3076, 12.2641>, <0.548, 0.590, 0.592> }
	smooth_triangle { <-1.6312, 0.6761, 16.1337>, <0.304, 0.805, 0.510>, <0.8490, 2.3076, 12.2641>, <0.548, 0.590, 0.592>, <-1.6105, 0.6635, 16.1414>, <0.672, 0.473, 0.570> }
	smooth_triangle { <-1.6105, 0.6635, 16.1414>, <0.672, 0.473, 0.570>, <0.8490, 2.3076, 12.2641>, <0.548, 0.590, 0.592>, <0.8571, 2.2546, 12.2473>, <0.853, -0.341, 0.395> }
	smooth_triangle { <-1.6105, 0.6635, 16.1414>, <0.672, 0.473, 0.570>, <0.8571, 2.2546, 12.2473>, <0.853, -0.341, 0.395>, <-1.6067, 0.6395, 16.1337>, <0.846, -0.464, 0.263> }
	smooth_triangle { <-1.6067, 0.6395, 16.1337>, <0.846, -0.464, 0.263>, <0.8571, 2.2546, 12.2473>, <0.853, -0.341, 0.395>, <0.8196, 2.2298, 12.2136>, <0.303, -0.933, -0.195> }
	smooth_triangle { <-1.6067, 0.6395, 16.1337>, <0.846, -0.464, 0.263>, <0.8196, 2.2298, 12.2136>, <0.303, -0.933, -0.195>, <-1.6235, 0.6282, 16.1184>, <0.172, -0.937, -0.304> }
	smooth_triangle { <-1.6235, 0.6282, 16.1184>, <0.172, -0.937, -0.304>, <0.8196, 2.2298, 12.2136>, <0.303, -0.933, -0.195>, <0.7740, 2.2580, 12.1967>, <-0.551, -0.592, -0.587> }
	smooth_triangle { <-1.6235, 0.6282, 16.1184>, <0.172, -0.937, -0.304>, <0.7740, 2.2580, 12.1967>, <-0.551, -0.592, -0.587>, <-1.6442, 0.6408, 16.1108>, <-0.675, -0.475, -0.565> }
	smooth_triangle { <-1.6442, 0.6408, 16.1108>, <-0.675, -0.475, -0.565>, <0.7740, 2.2580, 12.1967>, <-0.551, -0.592, -0.587>, <0.7659, 2.3110, 12.2136>, <-0.856, 0.339, -0.390> }
	smooth_triangle { <-1.6442, 0.6408, 16.1108>, <-0.675, -0.475, -0.565>, <0.7659, 2.3110, 12.2136>, <-0.856, 0.339, -0.390>, <-1.6480, 0.6647, 16.1184>, <-0.849, 0.461, -0.258> }
	smooth_triangle { <-1.6480, 0.6647, 16.1184>, <-0.849, 0.461, -0.258>, <0.7659, 2.3110, 12.2136>, <-0.856, 0.339, -0.390>, <0.8034, 2.3358, 12.2473>, <-0.555, 0.832, 0.002> }
	smooth_triangle { <-1.6480, 0.6647, 16.1184>, <-0.849, 0.461, -0.258>, <0.8034, 2.3358, 12.2473>, <-0.555, 0.832, 0.002>, <-1.6312, 0.6761, 16.1337>, <-0.605, 0.796, 0.019> }
	smooth_triangle { <-2.7453, -0.3059, 18.5604>, <0.272, 0.863, 0.425>, <-1.6312, 0.6761, 16.1337>, <0.304, 0.805, 0.510>, <-1.6105, 0.6635, 16.1414>, <0.672, 0.473, 0.570> }
	smooth_triangle { <-2.7453, -0.3059, 18.5604>, <0.272, 0.863, 0.425>, <-1.6105, 0.6635, 16.1414>, <0.672, 0.473, 0.570>, <-2.7227, -0.3152, 18.5670>, <0.662, 0.600, 0.449> }
	smooth_triangle { <-2.7227, -0.3152, 18.5670>, <0.751, 0.481, 0.452>, <-1.6105, 0.6635, 16.1414>, <0.672, 0.473, 0.570>, <-1.6067, 0.6395, 16.1337>, <0.846, -0.464, 0.263> }
	smooth_triangle { <-2.7227, -0.3152, 18.5670>, <0.751, 0.481, 0.452>, <-1.6067, 0.6395, 16.1337>, <0.846, -0.464, 0.263>, <-2.7162, -0.3389, 18.5604>, <0.927, -0.328, 0.184> }
	smooth_triangle { <-2.7162, -0.3389, 18.5604>, <0.876, -0.461, 0.143>, <-1.6067, 0.6395, 16.1337>, <0.846, -0.464, 0.263>, <-1.6235, 0.6282, 16.1184>, <0.172, -0.937, -0.304> }
	smooth_triangle { <-2.7162, -0.3389, 18.5604>, <0.876, -0.461, 0.143>, <-1.6235, 0.6282, 16.1184>, <0.172, -0.937, -0.304>, <-2.7325, -0.3532, 18.5471>, <0.264, -0.928, -0.264> }
	smooth_triangle { <-2.7325, -0.3532, 18.5471>, <0.124, -0.943, -0.309>, <-1.6235, 0.6282, 16.1184>, <0.172, -0.937, -0.304>, <-1.6442, 0.6408, 16.1108>, <-0.675, -0.475, -0.565> }
	smooth_triangle { <-2.7325, -0.3532, 18.5471>, <0.264, -0.928, -0.264>, <-1.6442, 0.6408, 16.1108>, <-0.675, -0.475, -0.565>, <-2.7551, -0.3439, 18.5405>, <-0.662, -0.600, -0.449> }
	smooth_triangle { <-2.7551, -0.3439, 18.5405>, <-0.751, -0.482, -0.451>, <-1.6442, 0.6408, 16.1108>, <-0.675, -0.475, -0.565>, <-1.6480, 0.6647, 16.1184>, <-0.849, 0.461, -0.258> }
	smooth_triangle { <-2.7551, -0.3439, 18.5405>, <-0.751, -0.482, -0.451>, <-1.6480, 0.6647, 16.1184>, <-0.849, 0.461, -0.258>, <-2.7616, -0.3202, 18.5471>, <-0.927, 0.328, -0.184> }
	smooth_triangle { <-2.7616, -0.3202, 18.5471>, <-0.876, 0.461, -0.142>, <-1.6480, 0.6647, 16.1184>, <-0.849, 0.461, -0.258>, <-1.6312, 0.6761, 16.1337>, <-0.605, 0.796, 0.019> }
	smooth_triangle { <-2.7616, -0.3202, 18.5471>, <-0.876, 0.461, -0.142>, <-1.6312, 0.6761, 16.1337>, <-0.605, 0.796, 0.019>, <-2.7453, -0.3059, 18.5604>, <-0.717, 0.697, 0.020> }
	smooth_triangle { <-3.2853, -1.0052, 20.8322>, <0.153, 0.932, 0.327>, <-2.7453, -0.3059, 18.5604>, <0.272, 0.863, 0.425>, <-2.7227, -0.3152, 18.5670>, <0.662, 0.600, 0.449> }
	smooth_triangle { <-3.2853, -1.0052, 20.8322>, <0.153, 0.932, 0.327>, <-2.7227, -0.3152, 18.5670>, <0.432, 0.814, 0.389>, <-3.2607, -1.0092, 20.8368>, <0.567, 0.742, 0.358> }
	smooth_triangle { <-3.2607, -1.0092, 20.8368>, <0.682, 0.643, 0.348>, <-2.7227, -0.3152, 18.5670>, <0.662, 0.600, 0.449>, <-2.7162, -0.3389, 18.5604>, <0.927, -0.328, 0.184> }
	smooth_triangle { <-3.2607, -1.0092, 20.8368>, <0.682, 0.643, 0.348>, <-2.7162, -0.3389, 18.5604>, <0.961, -0.026, 0.277>, <-3.2504, -1.0320, 20.8322>, <0.978, -0.145, 0.150> }
	smooth_triangle { <-3.2504, -1.0320, 20.8322>, <0.952, -0.288, 0.106>, <-2.7162, -0.3389, 18.5604>, <0.927, -0.328, 0.184>, <-2.7325, -0.3532, 18.5471>, <0.264, -0.928, -0.264> }
	smooth_triangle { <-3.2504, -1.0320, 20.8322>, <0.952, -0.288, 0.106>, <-2.7325, -0.3532, 18.5471>, <0.540, -0.829, -0.144>, <-3.2648, -1.0508, 20.8230>, <0.541, -0.825, -0.164> }
	smooth_triangle { <-3.2648, -1.0508, 20.8230>, <-0.153, -0.933, -0.327>, <-2.7325, -0.3532, 18.5471>, <0.124, -0.943, -0.309>, <-2.7551, -0.3439, 18.5405>, <-0.662, -0.600, -0.449> }
	smooth_triangle { <-3.2648, -1.0508, 20.8230>, <0.267, -0.933, -0.243>, <-2.7551, -0.3439, 18.5405>, <-0.432, -0.814, -0.389>, <-3.2895, -1.0468, 20.8184>, <-0.567, -0.742, -0.358> }
	smooth_triangle { <-3.2895, -1.0468, 20.8184>, <-0.682, -0.643, -0.347>, <-2.7551, -0.3439, 18.5405>, <-0.662, -0.600, -0.449>, <-2.7616, -0.3202, 18.5471>, <-0.927, 0.328, -0.184> }
	smooth_triangle { <-3.2895, -1.0468, 20.8184>, <-0.682, -0.643, -0.347>, <-2.7616, -0.3202, 18.5471>, <-0.961, 0.026, -0.277>, <-3.2997, -1.0240, 20.8230>, <-0.978, 0.145, -0.150> }
	smooth_triangle { <-3.2997, -1.0240, 20.8230>, <-0.952, 0.288, -0.105>, <-2.7616, -0.3202, 18.5471>, <-0.927, 0.328, -0.184>, <-2.7453, -0.3059, 18.5604>, <-0.717, 0.697, 0.020> }
	smooth_triangle { <-3.2997, -1.0240, 20.8230>, <-0.952, 0.288, -0.105>, <-2.7453, -0.3059, 18.5604>, <-0.717, 0.697, 0.020>, <-3.2853, -1.0052, 20.8322>, <-0.836, 0.549, 0.021> }
	smooth_triangle { <-3.5361, -1.5091, 22.3585>, <-0.025, 0.959, 0.283>, <-3.2853, -1.0052, 20.8322>, <0.153, 0.932, 0.327>, <-3.2607, -1.0092, 20.8368>, <0.567, 0.742, 0.358> }
	smooth_triangle { <-3.5361, -1.5091, 22.3585>, <-0.274, 0.932, 0.239>, <-3.2607, -1.0092, 20.8368>, <0.033, 0.949, 0.312>, <-3.5111, -1.5081, 22.3629>, <0.420, 0.855, 0.303> }
	smooth_triangle { <-3.5111, -1.5081, 22.3629>, <0.844, 0.465, 0.266>, <-3.2607, -1.0092, 20.8368>, <0.682, 0.643, 0.348>, <-3.2504, -1.0320, 20.8322>, <0.978, -0.145, 0.150> }
	smooth_triangle { <-3.5111, -1.5081, 22.3629>, <0.551, 0.776, 0.307>, <-3.2504, -1.0320, 20.8322>, <0.869, 0.401, 0.291>, <-3.4966, -1.5285, 22.3585>, <0.986, 0.043, 0.160> }
	smooth_triangle { <-3.4966, -1.5285, 22.3585>, <0.869, -0.495, -0.013>, <-3.2504, -1.0320, 20.8322>, <0.952, -0.288, 0.106>, <-3.2648, -1.0508, 20.8230>, <0.541, -0.825, -0.164> }
	smooth_triangle { <-3.4966, -1.5285, 22.3585>, <0.988, -0.103, 0.115>, <-3.2648, -1.0508, 20.8230>, <0.836, -0.548, -0.021>, <-3.5071, -1.5500, 22.3498>, <0.565, -0.814, -0.137> }
	smooth_triangle { <-3.5071, -1.5500, 22.3498>, <0.024, -0.961, -0.274>, <-3.2648, -1.0508, 20.8230>, <0.267, -0.933, -0.243>, <-3.2895, -1.0468, 20.8184>, <-0.567, -0.742, -0.358> }
	smooth_triangle { <-3.5071, -1.5500, 22.3498>, <0.436, -0.880, -0.186>, <-3.2895, -1.0468, 20.8184>, <-0.033, -0.949, -0.313>, <-3.5321, -1.5510, 22.3454>, <-0.422, -0.859, -0.290> }
	smooth_triangle { <-3.5321, -1.5510, 22.3454>, <-0.846, -0.468, -0.257>, <-3.2895, -1.0468, 20.8184>, <-0.682, -0.643, -0.347>, <-3.2997, -1.0240, 20.8230>, <-0.978, 0.145, -0.150> }
	smooth_triangle { <-3.5321, -1.5510, 22.3454>, <-0.553, -0.779, -0.296>, <-3.2997, -1.0240, 20.8230>, <-0.869, -0.401, -0.292>, <-3.5466, -1.5305, 22.3498>, <-0.988, -0.047, -0.147> }
	smooth_triangle { <-3.5466, -1.5305, 22.3498>, <-0.870, 0.492, 0.021>, <-3.2997, -1.0240, 20.8230>, <-0.952, 0.288, -0.105>, <-3.2853, -1.0052, 20.8322>, <-0.836, 0.549, 0.021> }
	smooth_triangle { <-3.5466, -1.5305, 22.3498>, <-0.990, 0.100, -0.104>, <-3.2853, -1.0052, 20.8322>, <-0.836, 0.549, 0.021>, <-3.5361, -1.5091, 22.3585>, <-0.897, 0.442, -0.002> }
	smooth_triangle { <-3.7188, -1.8845, 23.9282>, <-0.080, 0.970, 0.230>, <-3.5361, -1.5091, 22.3585>, <-0.274, 0.932, 0.239>, <-3.5111, -1.5081, 22.3629>, <0.420, 0.855, 0.303> }
	smooth_triangle { <-3.7188, -1.8845, 23.9282>, <0.816, 0.526, 0.242>, <-3.5111, -1.5081, 22.3629>, <0.551, 0.776, 0.307>, <-3.4966, -1.5285, 22.3585>, <0.986, 0.043, 0.160> }
	smooth_triangle { <-3.7188, -1.8845, 23.9282>, <0.893, -0.450, 0.031>, <-3.4966, -1.5285, 22.3585>, <0.988, -0.103, 0.115>, <-3.5071, -1.5500, 22.3498>, <0.565, -0.814, -0.137> }
	smooth_triangle { <-3.7188, -1.8845, 23.9282>, <0.074, -0.979, -0.191>, <-3.5071, -1.5500, 22.3498>, <0.436, -0.880, -0.186>, <-3.5321, -1.5510, 22.3454>, <-0.422, -0.859, -0.290> }
	smooth_triangle { <-3.7188, -1.8845, 23.9282>, <-0.820, -0.535, -0.203>, <-3.5321, -1.5510, 22.3454>, <-0.553, -0.779, -0.296>, <-3.5466, -1.5305, 22.3498>, <-0.988, -0.047, -0.147> }
	smooth_triangle { <-3.7188, -1.8845, 23.9282>, <-0.898, 0.439, 0.007>, <-3.5466, -1.5305, 22.3498>, <-0.990, 0.100, -0.104>, <-3.5361, -1.5091, 22.3585>, <-0.403, 0.894, 0.197> }
	smooth_triangle { <-2.2235, -0.5550, 20.0791>, <-0.937, -0.170, 0.306>, <-2.7580, -0.3457, 18.5582>, <-0.967, -0.155, 0.201>, <-2.7610, -0.3209, 18.5627>, <-0.877, 0.369, 0.307> }
	smooth_triangle { <-2.2235, -0.5550, 20.0791>, <-0.937, -0.170, 0.306>, <-2.7610, -0.3209, 18.5627>, <-0.877, 0.369, 0.307>, <-2.2265, -0.5302, 20.0836>, <-0.787, 0.511, 0.347> }
	smooth_triangle { <-2.2265, -0.5302, 20.0836>, <-0.787, 0.511, 0.347>, <-2.7610, -0.3209, 18.5627>, <-0.877, 0.369, 0.307>, <-2.7419, -0.3047, 18.5582>, <-0.081, 0.968, 0.237> }
	smooth_triangle { <-2.2265, -0.5302, 20.0836>, <-0.787, 0.511, 0.347>, <-2.7419, -0.3047, 18.5582>, <-0.081, 0.968, 0.237>, <-2.2075, -0.5141, 20.0791>, <0.059, 0.992, 0.116> }
	smooth_triangle { <-2.2075, -0.5141, 20.0791>, <0.059, 0.992, 0.116>, <-2.7419, -0.3047, 18.5582>, <-0.081, 0.968, 0.237>, <-2.7198, -0.3134, 18.5493>, <0.797, 0.601, -0.069> }
	smooth_triangle { <-2.2075, -0.5141, 20.0791>, <0.059, 0.992, 0.116>, <-2.7198, -0.3134, 18.5493>, <0.797, 0.601, -0.069>, <-2.1853, -0.5227, 20.0701>, <0.846, 0.481, -0.231> }
	smooth_triangle { <-2.1853, -0.5227, 20.0701>, <0.846, 0.481, -0.231>, <-2.7198, -0.3134, 18.5493>, <0.797, 0.601, -0.069>, <-2.7168, -0.3382, 18.5448>, <0.877, -0.369, -0.307> }
	smooth_triangle { <-2.1853, -0.5227, 20.0701>, <0.846, 0.481, -0.231>, <-2.7168, -0.3382, 18.5448>, <0.877, -0.369, -0.307>, <-2.1823, -0.5476, 20.0657>, <0.787, -0.511, -0.347> }
	smooth_triangle { <-2.1823, -0.5476, 20.0657>, <0.787, -0.511, -0.347>, <-2.7168, -0.3382, 18.5448>, <0.877, -0.369, -0.307>, <-2.7359, -0.3544, 18.5493>, <0.081, -0.968, -0.237> }
	smooth_triangle { <-2.1823, -0.5476, 20.0657>, <0.787, -0.511, -0.347>, <-2.7359, -0.3544, 18.5493>, <0.081, -0.968, -0.237>, <-2.2014, -0.5637, 20.0701>, <-0.059, -0.992, -0.116> }
	smooth_triangle { <-2.2014, -0.5637, 20.0701>, <-0.059, -0.992, -0.116>, <-2.7359, -0.3544, 18.5493>, <0.081, -0.968, -0.237>, <-2.7580, -0.3457, 18.5582>, <-0.613, -0.790, -0.014> }
	smooth_triangle { <-2.2014, -0.5637, 20.0701>, <-0.059, -0.992, -0.116>, <-2.7580, -0.3457, 18.5582>, <-0.613, -0.790, -0.014>, <-2.2235, -0.5550, 20.0791>, <-0.365, -0.931, 0.000> }
	smooth_triangle { <-2.2574, -1.3145, 22.3859>, <-0.748, 0.541, 0.385>, <-2.7580, -0.3457, 18.5582>, <-0.967, -0.155, 0.201>, <-2.7610, -0.3209, 18.5627>, <-0.877, 0.369, 0.307> }
	smooth_triangle { <-2.2574, -1.3145, 22.3859>, <-0.748, 0.541, 0.385>, <-2.7610, -0.3209, 18.5627>, <-0.877, 0.369, 0.307>, <-2.2349, -1.3034, 22.3900>, <-0.168, 0.845, 0.508> }
	smooth_triangle { <-2.2349, -1.3034, 22.3900>, <-0.168, 0.845, 0.508>, <-2.7610, -0.3209, 18.5627>, <-0.877, 0.369, 0.307>, <-2.7419, -0.3047, 18.5582>, <-0.081, 0.968, 0.237> }
	smooth_triangle { <-2.2349, -1.3034, 22.3900>, <-0.168, 0.845, 0.508>, <-2.7419, -0.3047, 18.5582>, <-0.081, 0.968, 0.237>, <-2.2134, -1.3163, 22.3859>, <0.786, 0.529, 0.320> }
	smooth_triangle { <-2.2134, -1.3163, 22.3859>, <0.786, 0.529, 0.320>, <-2.7419, -0.3047, 18.5582>, <-0.081, 0.968, 0.237>, <-2.7198, -0.3134, 18.5493>, <0.797, 0.601, -0.069> }
	smooth_triangle { <-2.2134, -1.3163, 22.3859>, <0.786, 0.529, 0.320>, <-2.7198, -0.3134, 18.5493>, <0.797, 0.601, -0.069>, <-2.2144, -1.3403, 22.3777>, <0.930, -0.315, -0.188> }
	smooth_triangle { <-2.2144, -1.3403, 22.3777>, <0.930, -0.315, -0.188>, <-2.7198, -0.3134, 18.5493>, <0.797, 0.601, -0.069>, <-2.7168, -0.3382, 18.5448>, <0.877, -0.369, -0.307> }
	smooth_triangle { <-2.2144, -1.3403, 22.3777>, <0.930, -0.315, -0.188>, <-2.7168, -0.3382, 18.5448>, <0.877, -0.369, -0.307>, <-2.2369, -1.3514, 22.3736>, <0.168, -0.844, -0.509> }
	smooth_triangle { <-2.2369, -1.3514, 22.3736>, <0.168, -0.844, -0.509>, <-2.7168, -0.3382, 18.5448>, <0.877, -0.369, -0.307>, <-2.7359, -0.3544, 18.5493>, <0.081, -0.968, -0.237> }
	smooth_triangle { <-2.2369, -1.3514, 22.3736>, <0.168, -0.844, -0.509>, <-2.7359, -0.3544, 18.5493>, <0.081, -0.968, -0.237>, <-2.2584, -1.3385, 22.3777>, <-0.786, -0.528, -0.321> }
	smooth_triangle { <-2.2584, -1.3385, 22.3777>, <-0.786, -0.528, -0.321>, <-2.7359, -0.3544, 18.5493>, <0.081, -0.968, -0.237>, <-2.7580, -0.3457, 18.5582>, <-0.613, -0.790, -0.014> }
	smooth_triangle { <-2.2584, -1.3385, 22.3777>, <-0.786, -0.528, -0.321>, <-2.7580, -0.3457, 18.5582>, <-0.613, -0.790, -0.014>, <-2.2574, -1.3145, 22.3859>, <-0.996, 0.092, 0.002> }
	smooth_triangle { <-2.6070, -3.0548, 24.0626>, <-0.392, 0.694, 0.604>, <-2.2574, -1.3145, 22.3859>, <-0.748, 0.541, 0.385>, <-2.2349, -1.3034, 22.3900>, <-0.168, 0.845, 0.508> }
	smooth_triangle { <-2.6070, -3.0548, 24.0626>, <-0.392, 0.694, 0.604>, <-2.2349, -1.3034, 22.3900>, <-0.168, 0.845, 0.508>, <-2.5837, -3.0506, 24.0718>, <0.103, 0.716, 0.691> }
	smooth_triangle { <-2.5837, -3.0506, 24.0718>, <0.103, 0.716, 0.691>, <-2.2349, -1.3034, 22.3900>, <-0.168, 0.845, 0.508>, <-2.2134, -1.3163, 22.3859>, <0.786, 0.529, 0.320> }
	smooth_triangle { <-2.5837, -3.0506, 24.0718>, <0.103, 0.716, 0.691>, <-2.2134, -1.3163, 22.3859>, <0.786, 0.529, 0.320>, <-2.5639, -3.0635, 24.0626>, <0.909, 0.233, 0.345> }
	smooth_triangle { <-2.5639, -3.0635, 24.0626>, <0.909, 0.233, 0.345>, <-2.2134, -1.3163, 22.3859>, <0.786, 0.529, 0.320>, <-2.2144, -1.3403, 22.3777>, <0.930, -0.315, -0.188> }
	smooth_triangle { <-2.5639, -3.0635, 24.0626>, <0.909, 0.233, 0.345>, <-2.2144, -1.3403, 22.3777>, <0.930, -0.315, -0.188>, <-2.5673, -3.0805, 24.0441>, <0.796, -0.490, -0.356> }
	smooth_triangle { <-2.5673, -3.0805, 24.0441>, <0.796, -0.490, -0.356>, <-2.2144, -1.3403, 22.3777>, <0.930, -0.315, -0.188>, <-2.2369, -1.3514, 22.3736>, <0.168, -0.844, -0.509> }
	smooth_triangle { <-2.5673, -3.0805, 24.0441>, <0.796, -0.490, -0.356>, <-2.2369, -1.3514, 22.3736>, <0.168, -0.844, -0.509>, <-2.5906, -3.0847, 24.0348>, <-0.103, -0.715, -0.691> }
	smooth_triangle { <-2.5906, -3.0847, 24.0348>, <-0.103, -0.715, -0.691>, <-2.2369, -1.3514, 22.3736>, <0.168, -0.844, -0.509>, <-2.2584, -1.3385, 22.3777>, <-0.786, -0.528, -0.321> }
	smooth_triangle { <-2.5906, -3.0847, 24.0348>, <-0.103, -0.715, -0.691>, <-2.2584, -1.3385, 22.3777>, <-0.786, -0.528, -0.321>, <-2.6105, -3.0718, 24.0441>, <-0.909, -0.234, -0.346> }
	smooth_triangle { <-2.6105, -3.0718, 24.0441>, <-0.909, -0.234, -0.346>, <-2.2584, -1.3385, 22.3777>, <-0.786, -0.528, -0.321>, <-2.2574, -1.3145, 22.3859>, <-0.996, 0.092, 0.002> }
	smooth_triangle { <-2.6105, -3.0718, 24.0441>, <-0.909, -0.234, -0.346>, <-2.2574, -1.3145, 22.3859>, <-0.996, 0.092, 0.002>, <-2.6070, -3.0548, 24.0626>, <-0.988, 0.155, 0.013> }
	smooth_triangle { <-2.7820, -4.6153, 25.9276>, <-0.403, 0.722, 0.563>, <-2.6070, -3.0548, 24.0626>, <-0.392, 0.694, 0.604>, <-2.5837, -3.0506, 24.0718>, <0.103, 0.716, 0.691> }
	smooth_triangle { <-2.7820, -4.6153, 25.9276>, <-0.403, 0.722, 0.563>, <-2.5837, -3.0506, 24.0718>, <0.103, 0.716, 0.691>, <-2.7590, -4.6081, 25.9358>, <0.064, 0.780, 0.623> }
	smooth_triangle { <-2.7590, -4.6081, 25.9358>, <0.213, 0.764, 0.610>, <-2.5837, -3.0506, 24.0718>, <0.103, 0.716, 0.691>, <-2.5639, -3.0635, 24.0626>, <0.909, 0.233, 0.345> }
	smooth_triangle { <-2.7590, -4.6081, 25.9358>, <0.213, 0.764, 0.610>, <-2.5639, -3.0635, 24.0626>, <0.909, 0.233, 0.345>, <-2.7382, -4.6202, 25.9276>, <0.896, 0.354, 0.267> }
	smooth_triangle { <-2.7382, -4.6202, 25.9276>, <0.953, 0.234, 0.194>, <-2.5639, -3.0635, 24.0626>, <0.909, 0.233, 0.345>, <-2.5673, -3.0805, 24.0441>, <0.796, -0.490, -0.356> }
	smooth_triangle { <-2.7382, -4.6202, 25.9276>, <0.953, 0.234, 0.194>, <-2.5673, -3.0805, 24.0441>, <0.796, -0.490, -0.356>, <-2.7404, -4.6395, 25.9113>, <0.831, -0.427, -0.357> }
	smooth_triangle { <-2.7404, -4.6395, 25.9113>, <0.739, -0.531, -0.415>, <-2.5673, -3.0805, 24.0441>, <0.796, -0.490, -0.356>, <-2.5906, -3.0847, 24.0348>, <-0.103, -0.715, -0.691> }
	smooth_triangle { <-2.7404, -4.6395, 25.9113>, <0.739, -0.531, -0.415>, <-2.5906, -3.0847, 24.0348>, <-0.103, -0.715, -0.691>, <-2.7633, -4.6468, 25.9031>, <-0.065, -0.780, -0.622> }
	smooth_triangle { <-2.7633, -4.6468, 25.9031>, <-0.213, -0.764, -0.609>, <-2.5906, -3.0847, 24.0348>, <-0.103, -0.715, -0.691>, <-2.6105, -3.0718, 24.0441>, <-0.909, -0.234, -0.346> }
	smooth_triangle { <-2.7633, -4.6468, 25.9031>, <-0.213, -0.764, -0.609>, <-2.6105, -3.0718, 24.0441>, <-0.909, -0.234, -0.346>, <-2.7841, -4.6347, 25.9113>, <-0.896, -0.354, -0.266> }
	smooth_triangle { <-2.7841, -4.6347, 25.9113>, <-0.953, -0.235, -0.194>, <-2.6105, -3.0718, 24.0441>, <-0.909, -0.234, -0.346>, <-2.6070, -3.0548, 24.0626>, <-0.988, 0.155, 0.013> }
	smooth_triangle { <-2.7841, -4.6347, 25.9113>, <-0.953, -0.235, -0.194>, <-2.6070, -3.0548, 24.0626>, <-0.988, 0.155, 0.013>, <-2.7820, -4.6153, 25.9276>, <-0.999, -0.005, 0.037> }
	smooth_triangle { <-2.6173, -5.7889, 27.5808>, <-0.545, 0.715, 0.439>, <-2.7820, -4.6153, 25.9276>, <-0.403, 0.722, 0.563>, <-2.7590, -4.6081, 25.9358>, <0.064, 0.780, 0.623> }
	smooth_triangle { <-2.6173, -5.7889, 27.5808>, <-0.732, 0.612, 0.298>, <-2.7590, -4.6081, 25.9358>, <-0.483, 0.690, 0.539>, <-2.5970, -5.7755, 27.5882>, <-0.115, 0.849, 0.516> }
	smooth_triangle { <-2.5970, -5.7755, 27.5882>, <0.458, 0.742, 0.490>, <-2.7590, -4.6081, 25.9358>, <0.213, 0.764, 0.610>, <-2.7382, -4.6202, 25.9276>, <0.896, 0.354, 0.267> }
	smooth_triangle { <-2.5970, -5.7755, 27.5882>, <0.042, 0.852, 0.521>, <-2.7382, -4.6202, 25.9276>, <0.517, 0.694, 0.501>, <-2.5737, -5.7826, 27.5808>, <0.799, 0.469, 0.376> }
	smooth_triangle { <-2.5737, -5.7826, 27.5808>, <0.998, 0.024, 0.052>, <-2.7382, -4.6202, 25.9276>, <0.953, 0.234, 0.194>, <-2.7404, -4.6395, 25.9113>, <0.831, -0.427, -0.357> }
	smooth_triangle { <-2.5737, -5.7826, 27.5808>, <0.883, 0.377, 0.279>, <-2.7404, -4.6395, 25.9113>, <0.999, 0.005, -0.038>, <-2.5708, -5.8031, 27.5661>, <0.914, -0.382, -0.136> }
	smooth_triangle { <-2.5708, -5.8031, 27.5661>, <0.545, -0.718, -0.433>, <-2.7404, -4.6395, 25.9113>, <0.739, -0.531, -0.415>, <-2.7633, -4.6468, 25.9031>, <-0.065, -0.780, -0.622> }
	smooth_triangle { <-2.5708, -5.8031, 27.5661>, <0.843, -0.481, -0.240>, <-2.7633, -4.6468, 25.9031>, <0.482, -0.690, -0.540>, <-2.5911, -5.8165, 27.5587>, <0.115, -0.854, -0.507> }
	smooth_triangle { <-2.5911, -5.8165, 27.5587>, <-0.457, -0.746, -0.483>, <-2.7633, -4.6468, 25.9031>, <-0.213, -0.764, -0.609>, <-2.7841, -4.6347, 25.9113>, <-0.896, -0.354, -0.266> }
	smooth_triangle { <-2.5911, -5.8165, 27.5587>, <-0.043, -0.857, -0.513>, <-2.7841, -4.6347, 25.9113>, <-0.517, -0.694, -0.501>, <-2.6144, -5.8093, 27.5661>, <-0.800, -0.475, -0.367> }
	smooth_triangle { <-2.6144, -5.8093, 27.5661>, <-0.999, -0.029, -0.046>, <-2.7841, -4.6347, 25.9113>, <-0.953, -0.235, -0.194>, <-2.7820, -4.6153, 25.9276>, <-0.999, -0.005, 0.037> }
	smooth_triangle { <-2.6144, -5.8093, 27.5661>, <-0.883, -0.382, -0.271>, <-2.7820, -4.6153, 25.9276>, <-0.999, -0.005, 0.037>, <-2.6173, -5.7889, 27.5808>, <-0.990, -0.141, -0.001> }
	smooth_triangle { <-3.1019, -6.7150, 29.3131>, <-0.577, 0.774, 0.259>, <-2.6173, -5.7889, 27.5808>, <-0.732, 0.612, 0.298>, <-2.5970, -5.7755, 27.5882>, <-0.115, 0.849, 0.516> }
	smooth_triangle { <-3.1019, -6.7150, 29.3131>, <0.393, 0.751, 0.530>, <-2.5970, -5.7755, 27.5882>, <0.042, 0.852, 0.521>, <-2.5737, -5.7826, 27.5808>, <0.799, 0.469, 0.376> }
	smooth_triangle { <-3.1019, -6.7150, 29.3131>, <0.960, -0.037, 0.278>, <-2.5737, -5.7826, 27.5808>, <0.883, 0.377, 0.279>, <-2.5708, -5.8031, 27.5661>, <0.914, -0.382, -0.136> }
	smooth_triangle { <-3.1019, -6.7150, 29.3131>, <0.572, -0.787, -0.231>, <-2.5708, -5.8031, 27.5661>, <0.843, -0.481, -0.240>, <-2.5911, -5.8165, 27.5587>, <0.115, -0.854, -0.507> }
	smooth_triangle { <-3.1019, -6.7150, 29.3131>, <-0.396, -0.768, -0.503>, <-2.5911, -5.8165, 27.5587>, <-0.043, -0.857, -0.513>, <-2.6144, -5.8093, 27.5661>, <-0.800, -0.475, -0.367> }
	smooth_triangle { <-3.1019, -6.7150, 29.3131>, <-0.967, 0.021, -0.253>, <-2.6144, -5.8093, 27.5661>, <-0.883, -0.382, -0.271>, <-2.6173, -5.7889, 27.5808>, <-0.817, 0.544, 0.189> }
	smooth_triangle { <-2.3112, -1.4393, 19.6622>, <-0.684, 0.354, 0.638>, <-2.7625, -0.3299, 18.5631>, <-0.677, 0.337, 0.655>, <-2.7454, -0.3136, 18.5725>, <-0.438, 0.524, 0.731> }
	smooth_triangle { <-2.3112, -1.4393, 19.6622>, <-0.684, 0.354, 0.638>, <-2.7454, -0.3136, 18.5725>, <-0.438, 0.524, 0.731>, <-2.2940, -1.4231, 19.6715>, <-0.075, 0.686, 0.724> }
	smooth_triangle { <-2.2940, -1.4231, 19.6715>, <-0.075, 0.686, 0.724>, <-2.7454, -0.3136, 18.5725>, <-0.438, 0.524, 0.731>, <-2.7218, -0.3133, 18.5631>, <0.510, 0.715, 0.478> }
	smooth_triangle { <-2.2940, -1.4231, 19.6715>, <-0.075, 0.686, 0.724>, <-2.7218, -0.3133, 18.5631>, <0.510, 0.715, 0.478>, <-2.2704, -1.4228, 19.6622>, <0.792, 0.561, 0.241> }
	smooth_triangle { <-2.2704, -1.4228, 19.6622>, <0.792, 0.561, 0.241>, <-2.7218, -0.3133, 18.5631>, <0.510, 0.715, 0.478>, <-2.7153, -0.3292, 18.5444>, <0.948, 0.192, -0.253> }
	smooth_triangle { <-2.2704, -1.4228, 19.6622>, <0.792, 0.561, 0.241>, <-2.7153, -0.3292, 18.5444>, <0.948, 0.192, -0.253>, <-2.2639, -1.4387, 19.6435>, <0.867, -0.125, -0.482> }
	smooth_triangle { <-2.2639, -1.4387, 19.6435>, <0.867, -0.125, -0.482>, <-2.7153, -0.3292, 18.5444>, <0.948, 0.192, -0.253>, <-2.7324, -0.3455, 18.5350>, <0.438, -0.524, -0.731> }
	smooth_triangle { <-2.2639, -1.4387, 19.6435>, <0.867, -0.125, -0.482>, <-2.7324, -0.3455, 18.5350>, <0.438, -0.524, -0.731>, <-2.2811, -1.4549, 19.6341>, <0.075, -0.686, -0.724> }
	smooth_triangle { <-2.2811, -1.4549, 19.6341>, <0.075, -0.686, -0.724>, <-2.7324, -0.3455, 18.5350>, <0.438, -0.524, -0.731>, <-2.7560, -0.3458, 18.5444>, <-0.510, -0.715, -0.478> }
	smooth_triangle { <-2.2811, -1.4549, 19.6341>, <0.075, -0.686, -0.724>, <-2.7560, -0.3458, 18.5444>, <-0.510, -0.715, -0.478>, <-2.3047, -1.4552, 19.6435>, <-0.792, -0.561, -0.241> }
	smooth_triangle { <-2.3047, -1.4552, 19.6435>, <-0.792, -0.561, -0.241>, <-2.7560, -0.3458, 18.5444>, <-0.510, -0.715, -0.478>, <-2.7625, -0.3299, 18.5631>, <-0.907, -0.420, 0.005> }
	smooth_triangle { <-2.3047, -1.4552, 19.6435>, <-0.792, -0.561, -0.241>, <-2.7625, -0.3299, 18.5631>, <-0.907, -0.420, 0.005>, <-2.3112, -1.4393, 19.6622>, <-0.926, -0.377, 0.000> }
	smooth_triangle { <-1.3350, -3.0085, 21.2578>, <-0.574, 0.076, 0.815>, <-2.7625, -0.3299, 18.5631>, <-0.677, 0.337, 0.655>, <-2.7454, -0.3136, 18.5725>, <-0.438, 0.524, 0.731> }
	smooth_triangle { <-1.3350, -3.0085, 21.2578>, <-0.574, 0.076, 0.815>, <-2.7454, -0.3136, 18.5725>, <-0.438, 0.524, 0.731>, <-1.3208, -2.9898, 21.2674>, <-0.103, 0.294, 0.950> }
	smooth_triangle { <-1.3208, -2.9898, 21.2674>, <-0.034, 0.626, 0.779>, <-2.7454, -0.3136, 18.5725>, <-0.438, 0.524, 0.731>, <-2.7218, -0.3133, 18.5631>, <0.510, 0.715, 0.478> }
	smooth_triangle { <-1.3208, -2.9898, 21.2674>, <-0.034, 0.626, 0.779>, <-2.7218, -0.3133, 18.5631>, <0.510, 0.715, 0.478>, <-1.2977, -2.9852, 21.2578>, <0.580, 0.709, 0.402> }
	smooth_triangle { <-1.2977, -2.9852, 21.2578>, <0.580, 0.709, 0.402>, <-2.7218, -0.3133, 18.5631>, <0.510, 0.715, 0.478>, <-2.7153, -0.3292, 18.5444>, <0.948, 0.192, -0.253> }
	smooth_triangle { <-1.2977, -2.9852, 21.2578>, <0.580, 0.709, 0.402>, <-2.7153, -0.3292, 18.5444>, <0.948, 0.192, -0.253>, <-1.2889, -2.9993, 21.2386>, <0.797, 0.423, -0.432> }
	smooth_triangle { <-1.2889, -2.9993, 21.2386>, <0.740, 0.089, -0.667>, <-2.7153, -0.3292, 18.5444>, <0.948, 0.192, -0.253>, <-2.7324, -0.3455, 18.5350>, <0.438, -0.524, -0.731> }
	smooth_triangle { <-1.2889, -2.9993, 21.2386>, <0.706, 0.277, -0.652>, <-2.7324, -0.3455, 18.5350>, <0.438, -0.524, -0.731>, <-1.3032, -3.0180, 21.2290>, <0.100, -0.292, -0.951> }
	smooth_triangle { <-1.3032, -3.0180, 21.2290>, <0.034, -0.625, -0.780>, <-2.7324, -0.3455, 18.5350>, <0.438, -0.524, -0.731>, <-2.7560, -0.3458, 18.5444>, <-0.510, -0.715, -0.478> }
	smooth_triangle { <-1.3032, -3.0180, 21.2290>, <0.034, -0.625, -0.780>, <-2.7560, -0.3458, 18.5444>, <-0.510, -0.715, -0.478>, <-1.3262, -3.0226, 21.2386>, <-0.580, -0.708, -0.402> }
	smooth_triangle { <-1.3262, -3.0226, 21.2386>, <-0.580, -0.708, -0.402>, <-2.7560, -0.3458, 18.5444>, <-0.510, -0.715, -0.478>, <-2.7625, -0.3299, 18.5631>, <-0.907, -0.420, 0.005> }
	smooth_triangle { <-1.3262, -3.0226, 21.2386>, <-0.580, -0.708, -0.402>, <-2.7625, -0.3299, 18.5631>, <-0.907, -0.420, 0.005>, <-1.3350, -3.0085, 21.2578>, <-0.606, -0.783, 0.137> }
	smooth_triangle { <0.8641, -4.1040, 21.2178>, <-0.140, -0.446, 0.884>, <-1.3350, -3.0085, 21.2578>, <-0.574, 0.076, 0.815>, <-1.3208, -2.9898, 21.2674>, <-0.254, -0.025, 0.967> }
	smooth_triangle { <0.8641, -4.1040, 21.2178>, <-0.112, -0.659, 0.743>, <-1.3208, -2.9898, 21.2674>, <-0.254, -0.025, 0.967>, <0.8740, -4.0844, 21.2305>, <0.041, 0.117, 0.992> }
	smooth_triangle { <0.8740, -4.0844, 21.2305>, <0.041, 0.117, 0.992>, <-1.3208, -2.9898, 21.2674>, <-0.103, 0.294, 0.950>, <-1.2977, -2.9852, 21.2578>, <0.564, 0.611, 0.555> }
	smooth_triangle { <0.8740, -4.0844, 21.2305>, <0.041, 0.117, 0.992>, <-1.2977, -2.9852, 21.2578>, <0.564, 0.611, 0.555>, <0.8836, -4.0646, 21.2178>, <0.180, 0.848, 0.498> }
	smooth_triangle { <0.8836, -4.0646, 21.2178>, <0.291, 0.946, -0.143>, <-1.2977, -2.9852, 21.2578>, <0.678, 0.732, 0.066>, <-1.2889, -2.9993, 21.2386>, <0.651, 0.583, -0.486> }
	smooth_triangle { <0.8836, -4.0646, 21.2178>, <0.249, 0.915, 0.316>, <-1.2889, -2.9993, 21.2386>, <0.542, 0.749, -0.381>, <0.8832, -4.0644, 21.1924>, <0.202, 0.759, -0.619> }
	smooth_triangle { <0.8832, -4.0644, 21.1924>, <0.202, 0.759, -0.619>, <-1.2889, -2.9993, 21.2386>, <0.619, 0.390, -0.682>, <-1.3032, -3.0180, 21.2290>, <0.251, 0.027, -0.968> }
	smooth_triangle { <0.8832, -4.0644, 21.1924>, <0.202, 0.759, -0.619>, <-1.3032, -3.0180, 21.2290>, <0.251, 0.027, -0.968>, <0.8732, -4.0840, 21.1797>, <-0.035, -0.119, -0.992> }
	smooth_triangle { <0.8732, -4.0840, 21.1797>, <-0.035, -0.119, -0.992>, <-1.3032, -3.0180, 21.2290>, <0.100, -0.292, -0.951>, <-1.3262, -3.0226, 21.2386>, <-0.565, -0.610, -0.555> }
	smooth_triangle { <0.8732, -4.0840, 21.1797>, <-0.035, -0.119, -0.992>, <-1.3262, -3.0226, 21.2386>, <-0.565, -0.610, -0.555>, <0.8637, -4.1038, 21.1924>, <-0.173, -0.850, -0.498> }
	smooth_triangle { <0.8637, -4.1038, 21.1924>, <-0.287, -0.947, 0.144>, <-1.3262, -3.0226, 21.2386>, <-0.678, -0.732, -0.066>, <-1.3350, -3.0085, 21.2578>, <-0.606, -0.783, 0.137> }
	smooth_triangle { <0.8637, -4.1038, 21.1924>, <-0.243, -0.917, -0.315>, <-1.3350, -3.0085, 21.2578>, <-0.606, -0.783, 0.137>, <0.8641, -4.1040, 21.2178>, <-0.446, -0.895, 0.000> }
	smooth_triangle { <3.3057, -4.0588, 21.3784>, <-0.043, -0.501, 0.864>, <0.8641, -4.1040, 21.2178>, <-0.112, -0.659, 0.743>, <0.8740, -4.0844, 21.2305>, <0.041, 0.117, 0.992> }
	smooth_triangle { <3.3057, -4.0588, 21.3784>, <-0.053, 0.521, 0.852>, <0.8740, -4.0844, 21.2305>, <0.041, 0.117, 0.992>, <0.8836, -4.0646, 21.2178>, <0.180, 0.848, 0.498> }
	smooth_triangle { <3.3057, -4.0588, 21.3784>, <0.002, 1.000, -0.008>, <0.8836, -4.0646, 21.2178>, <0.249, 0.915, 0.316>, <0.8832, -4.0644, 21.1924>, <0.202, 0.759, -0.619> }
	smooth_triangle { <3.3057, -4.0588, 21.3784>, <0.070, 0.496, -0.865>, <0.8832, -4.0644, 21.1924>, <0.202, 0.759, -0.619>, <0.8732, -4.0840, 21.1797>, <-0.035, -0.119, -0.992> }
	smooth_triangle { <3.3057, -4.0588, 21.3784>, <0.079, -0.525, -0.847>, <0.8732, -4.0840, 21.1797>, <-0.035, -0.119, -0.992>, <0.8637, -4.1038, 21.1924>, <-0.173, -0.850, -0.498> }
	smooth_triangle { <3.3057, -4.0588, 21.3784>, <0.022, -1.000, 0.008>, <0.8637, -4.1038, 21.1924>, <-0.243, -0.917, -0.315>, <0.8641, -4.1040, 21.2178>, <-0.091, -0.754, 0.650> }
	smooth_triangle { <-4.1904, -0.9247, 18.9805>, <0.007, 0.547, 0.837>, <-2.7446, -0.3080, 18.5660>, <0.055, 0.566, 0.822>, <-2.7329, -0.3270, 18.5783>, <0.219, 0.324, 0.920> }
	smooth_triangle { <-4.1904, -0.9247, 18.9805>, <0.007, 0.547, 0.837>, <-2.7329, -0.3270, 18.5783>, <0.219, 0.324, 0.920>, <-4.1788, -0.9437, 18.9928>, <0.304, -0.076, 0.950> }
	smooth_triangle { <-4.1788, -0.9437, 18.9928>, <0.304, -0.076, 0.950>, <-2.7329, -0.3270, 18.5783>, <0.219, 0.324, 0.920>, <-2.7273, -0.3485, 18.5660>, <0.552, -0.568, 0.611> }
	smooth_triangle { <-4.1788, -0.9437, 18.9928>, <0.304, -0.076, 0.950>, <-2.7273, -0.3485, 18.5660>, <0.552, -0.568, 0.611>, <-4.1731, -0.9652, 18.9805>, <0.447, -0.836, 0.317> }
	smooth_triangle { <-4.1731, -0.9652, 18.9805>, <0.447, -0.836, 0.317>, <-2.7273, -0.3485, 18.5660>, <0.552, -0.568, 0.611>, <-2.7333, -0.3511, 18.5415>, <0.332, -0.891, -0.309> }
	smooth_triangle { <-4.1731, -0.9652, 18.9805>, <0.447, -0.836, 0.317>, <-2.7333, -0.3511, 18.5415>, <0.332, -0.891, -0.309>, <-4.1791, -0.9677, 18.9560>, <0.143, -0.761, -0.633> }
	smooth_triangle { <-4.1791, -0.9677, 18.9560>, <0.143, -0.761, -0.633>, <-2.7333, -0.3511, 18.5415>, <0.332, -0.891, -0.309>, <-2.7449, -0.3321, 18.5292>, <-0.219, -0.324, -0.920> }
	smooth_triangle { <-4.1791, -0.9677, 18.9560>, <0.143, -0.761, -0.633>, <-2.7449, -0.3321, 18.5292>, <-0.219, -0.324, -0.920>, <-4.1907, -0.9487, 18.9437>, <-0.304, 0.076, -0.950> }
	smooth_triangle { <-4.1907, -0.9487, 18.9437>, <-0.304, 0.076, -0.950>, <-2.7449, -0.3321, 18.5292>, <-0.219, -0.324, -0.920>, <-2.7505, -0.3106, 18.5415>, <-0.552, 0.568, -0.611> }
	smooth_triangle { <-4.1907, -0.9487, 18.9437>, <-0.304, 0.076, -0.950>, <-2.7505, -0.3106, 18.5415>, <-0.552, 0.568, -0.611>, <-4.1964, -0.9272, 18.9560>, <-0.447, 0.836, -0.316> }
	smooth_triangle { <-4.1964, -0.9272, 18.9560>, <-0.447, 0.836, -0.316>, <-2.7505, -0.3106, 18.5415>, <-0.552, 0.568, -0.611>, <-2.7446, -0.3080, 18.5660>, <-0.464, 0.886, -0.006> }
	smooth_triangle { <-4.1964, -0.9272, 18.9560>, <-0.447, 0.836, -0.316>, <-2.7446, -0.3080, 18.5660>, <-0.464, 0.886, -0.006>, <-4.1904, -0.9247, 18.9805>, <-0.392, 0.920, 0.000> }
	smooth_triangle { <-5.7789, -2.1944, 20.3273>, <0.151, 0.713, 0.685>, <-2.7446, -0.3080, 18.5660>, <0.055, 0.566, 0.822>, <-2.7329, -0.3270, 18.5783>, <0.219, 0.324, 0.920> }
	smooth_triangle { <-5.7789, -2.1944, 20.3273>, <0.151, 0.713, 0.685>, <-2.7329, -0.3270, 18.5783>, <0.219, 0.324, 0.920>, <-5.7597, -2.2072, 20.3379>, <0.541, 0.323, 0.776> }
	smooth_triangle { <-5.7597, -2.2072, 20.3379>, <0.562, 0.187, 0.806>, <-2.7329, -0.3270, 18.5783>, <0.219, 0.324, 0.920>, <-2.7273, -0.3485, 18.5660>, <0.552, -0.568, 0.611> }
	smooth_triangle { <-5.7597, -2.2072, 20.3379>, <0.541, 0.323, 0.776>, <-2.7273, -0.3485, 18.5660>, <0.552, -0.568, 0.611>, <-5.7514, -2.2288, 20.3273>, <0.677, -0.600, 0.426> }
	smooth_triangle { <-5.7514, -2.2288, 20.3273>, <0.677, -0.600, 0.426>, <-2.7273, -0.3485, 18.5660>, <0.552, -0.568, 0.611>, <-2.7333, -0.3511, 18.5415>, <0.332, -0.891, -0.309> }
	smooth_triangle { <-5.7514, -2.2288, 20.3273>, <0.677, -0.600, 0.426>, <-2.7333, -0.3511, 18.5415>, <0.332, -0.891, -0.309>, <-5.7624, -2.2375, 20.3061>, <0.145, -0.927, -0.345> }
	smooth_triangle { <-5.7624, -2.2375, 20.3061>, <0.145, -0.927, -0.345>, <-2.7333, -0.3511, 18.5415>, <0.332, -0.891, -0.309>, <-2.7449, -0.3321, 18.5292>, <-0.219, -0.324, -0.920> }
	smooth_triangle { <-5.7624, -2.2375, 20.3061>, <0.145, -0.927, -0.345>, <-2.7449, -0.3321, 18.5292>, <-0.219, -0.324, -0.920>, <-5.7816, -2.2248, 20.2956>, <-0.540, -0.323, -0.777> }
	smooth_triangle { <-5.7816, -2.2248, 20.2956>, <-0.561, -0.187, -0.806>, <-2.7449, -0.3321, 18.5292>, <-0.219, -0.324, -0.920>, <-2.7505, -0.3106, 18.5415>, <-0.552, 0.568, -0.611> }
	smooth_triangle { <-5.7816, -2.2248, 20.2956>, <-0.540, -0.323, -0.777>, <-2.7505, -0.3106, 18.5415>, <-0.552, 0.568, -0.611>, <-5.7899, -2.2032, 20.3061>, <-0.677, 0.600, -0.426> }
	smooth_triangle { <-5.7899, -2.2032, 20.3061>, <-0.677, 0.600, -0.426>, <-2.7505, -0.3106, 18.5415>, <-0.552, 0.568, -0.611>, <-2.7446, -0.3080, 18.5660>, <-0.464, 0.886, -0.006> }
	smooth_triangle { <-5.7899, -2.2032, 20.3061>, <-0.677, 0.600, -0.426>, <-2.7446, -0.3080, 18.5660>, <-0.464, 0.886, -0.006>, <-5.7789, -2.1944, 20.3273>, <-0.400, 0.913, -0.076> }
	smooth_triangle { <-7.3571, -2.5731, 22.1339>, <0.234, 0.819, 0.524>, <-5.7789, -2.1944, 20.3273>, <0.151, 0.713, 0.685>, <-5.7597, -2.2072, 20.3379>, <0.500, 0.444, 0.744> }
	smooth_triangle { <-7.3571, -2.5731, 22.1339>, <0.234, 0.819, 0.524>, <-5.7597, -2.2072, 20.3379>, <0.541, 0.323, 0.776>, <-7.3428, -2.5923, 22.1424>, <0.751, 0.134, 0.647> }
	smooth_triangle { <-7.3428, -2.5923, 22.1424>, <0.751, 0.134, 0.647>, <-5.7597, -2.2072, 20.3379>, <0.541, 0.323, 0.776>, <-5.7514, -2.2288, 20.3273>, <0.677, -0.600, 0.426> }
	smooth_triangle { <-7.3428, -2.5923, 22.1424>, <0.751, 0.134, 0.647>, <-5.7514, -2.2288, 20.3273>, <0.677, -0.600, 0.426>, <-7.3469, -2.6158, 22.1339>, <0.603, -0.769, 0.211> }
	smooth_triangle { <-7.3469, -2.6158, 22.1339>, <0.603, -0.769, 0.211>, <-5.7514, -2.2288, 20.3273>, <0.677, -0.600, 0.426>, <-5.7624, -2.2375, 20.3061>, <0.145, -0.927, -0.345> }
	smooth_triangle { <-7.3469, -2.6158, 22.1339>, <0.603, -0.769, 0.211>, <-5.7624, -2.2375, 20.3061>, <0.145, -0.927, -0.345>, <-7.3652, -2.6202, 22.1169>, <-0.144, -0.894, -0.424> }
	smooth_triangle { <-7.3652, -2.6202, 22.1169>, <-0.144, -0.894, -0.424>, <-5.7624, -2.2375, 20.3061>, <0.145, -0.927, -0.345>, <-5.7816, -2.2248, 20.2956>, <-0.499, -0.443, -0.745> }
	smooth_triangle { <-7.3652, -2.6202, 22.1169>, <-0.144, -0.894, -0.424>, <-5.7816, -2.2248, 20.2956>, <-0.540, -0.323, -0.777>, <-7.3795, -2.6010, 22.1084>, <-0.756, -0.136, -0.640> }
	smooth_triangle { <-7.3795, -2.6010, 22.1084>, <-0.756, -0.136, -0.640>, <-5.7816, -2.2248, 20.2956>, <-0.540, -0.323, -0.777>, <-5.7899, -2.2032, 20.3061>, <-0.677, 0.600, -0.426> }
	smooth_triangle { <-7.3795, -2.6010, 22.1084>, <-0.756, -0.136, -0.640>, <-5.7899, -2.2032, 20.3061>, <-0.677, 0.600, -0.426>, <-7.3754, -2.5774, 22.1169>, <-0.608, 0.767, -0.205> }
	smooth_triangle { <-7.3754, -2.5774, 22.1169>, <-0.608, 0.767, -0.205>, <-5.7899, -2.2032, 20.3061>, <-0.677, 0.600, -0.426>, <-5.7789, -2.1944, 20.3273>, <-0.400, 0.913, -0.076> }
	smooth_triangle { <-7.3754, -2.5774, 22.1169>, <-0.608, 0.767, -0.205>, <-5.7789, -2.1944, 20.3273>, <-0.400, 0.913, -0.076>, <-7.3571, -2.5731, 22.1339>, <-0.233, 0.972, 0.000> }
	smooth_triangle { <-8.5471, -3.6294, 23.9889>, <0.456, 0.612, 0.647>, <-7.3571, -2.5731, 22.1339>, <0.234, 0.819, 0.524>, <-7.3428, -2.5923, 22.1424>, <0.751, 0.134, 0.647> }
	smooth_triangle { <-8.5471, -3.6294, 23.9889>, <0.866, -0.279, 0.414>, <-7.3428, -2.5923, 22.1424>, <0.751, 0.134, 0.647>, <-7.3469, -2.6158, 22.1339>, <0.603, -0.769, 0.211> }
	smooth_triangle { <-8.5471, -3.6294, 23.9889>, <0.403, -0.889, -0.219>, <-7.3469, -2.6158, 22.1339>, <0.603, -0.769, 0.211>, <-7.3652, -2.6202, 22.1169>, <-0.144, -0.894, -0.424> }
	smooth_triangle { <-8.5471, -3.6294, 23.9889>, <-0.472, -0.621, -0.626>, <-7.3652, -2.6202, 22.1169>, <-0.144, -0.894, -0.424>, <-7.3795, -2.6010, 22.1084>, <-0.756, -0.136, -0.640> }
	smooth_triangle { <-8.5471, -3.6294, 23.9889>, <-0.879, 0.271, -0.392>, <-7.3795, -2.6010, 22.1084>, <-0.756, -0.136, -0.640>, <-7.3754, -2.5774, 22.1169>, <-0.608, 0.767, -0.205> }
	smooth_triangle { <-8.5471, -3.6294, 23.9889>, <-0.416, 0.877, 0.238>, <-7.3754, -2.5774, 22.1169>, <-0.608, 0.767, -0.205>, <-7.3571, -2.5731, 22.1339>, <0.234, 0.819, 0.524> }
	smooth_triangle { <-2.1697, 1.3217, 17.5047>, <0.855, -0.231, 0.465>, <-1.6037, 0.6583, 16.1329>, <0.823, -0.197, 0.533>, <-1.6134, 0.6358, 16.1397>, <0.653, -0.464, 0.599> }
	smooth_triangle { <-2.1697, 1.3217, 17.5047>, <0.855, -0.231, 0.465>, <-1.6134, 0.6358, 16.1397>, <0.653, -0.464, 0.599>, <-2.1795, 1.2993, 17.5116>, <0.394, -0.753, 0.527> }
	smooth_triangle { <-2.1795, 1.2993, 17.5116>, <0.394, -0.753, 0.527>, <-1.6134, 0.6358, 16.1397>, <0.653, -0.464, 0.599>, <-1.6371, 0.6297, 16.1329>, <-0.229, -0.890, 0.394> }
	smooth_triangle { <-2.1795, 1.2993, 17.5116>, <0.394, -0.753, 0.527>, <-1.6371, 0.6297, 16.1329>, <-0.229, -0.890, 0.394>, <-2.2031, 1.2932, 17.5047>, <-0.540, -0.823, 0.176> }
	smooth_triangle { <-2.2031, 1.2932, 17.5047>, <-0.540, -0.823, 0.176>, <-1.6371, 0.6297, 16.1329>, <-0.229, -0.890, 0.394>, <-1.6510, 0.6460, 16.1193>, <-0.881, -0.427, -0.204> }
	smooth_triangle { <-2.2031, 1.2932, 17.5047>, <-0.540, -0.823, 0.176>, <-1.6510, 0.6460, 16.1193>, <-0.881, -0.427, -0.204>, <-2.2171, 1.3095, 17.4911>, <-0.934, -0.070, -0.351> }
	smooth_triangle { <-2.2171, 1.3095, 17.4911>, <-0.934, -0.070, -0.351>, <-1.6510, 0.6460, 16.1193>, <-0.881, -0.427, -0.204>, <-1.6413, 0.6685, 16.1124>, <-0.653, 0.464, -0.599> }
	smooth_triangle { <-2.2171, 1.3095, 17.4911>, <-0.934, -0.070, -0.351>, <-1.6413, 0.6685, 16.1124>, <-0.653, 0.464, -0.599>, <-2.2073, 1.3319, 17.4843>, <-0.394, 0.753, -0.527> }
	smooth_triangle { <-2.2073, 1.3319, 17.4843>, <-0.394, 0.753, -0.527>, <-1.6413, 0.6685, 16.1124>, <-0.653, 0.464, -0.599>, <-1.6176, 0.6746, 16.1193>, <0.229, 0.890, -0.394> }
	smooth_triangle { <-2.2073, 1.3319, 17.4843>, <-0.394, 0.753, -0.527>, <-1.6176, 0.6746, 16.1193>, <0.229, 0.890, -0.394>, <-2.1836, 1.3381, 17.4911>, <0.540, 0.823, -0.176> }
	smooth_triangle { <-2.1836, 1.3381, 17.4911>, <0.540, 0.823, -0.176>, <-1.6176, 0.6746, 16.1193>, <0.229, 0.890, -0.394>, <-1.6037, 0.6583, 16.1329>, <0.751, 0.660, 0.004> }
	smooth_triangle { <-2.1836, 1.3381, 17.4911>, <0.540, 0.823, -0.176>, <-1.6037, 0.6583, 16.1329>, <0.751, 0.660, 0.004>, <-2.1697, 1.3217, 17.5047>, <0.761, 0.649, 0.000> }
	smooth_triangle { <-3.6361, 2.8659, 19.3976>, <0.882, -0.265, 0.390>, <-1.6037, 0.6583, 16.1329>, <0.823, -0.197, 0.533>, <-1.6134, 0.6358, 16.1397>, <0.653, -0.464, 0.599> }
	smooth_triangle { <-3.6361, 2.8659, 19.3976>, <0.882, -0.265, 0.390>, <-1.6134, 0.6358, 16.1397>, <0.653, -0.464, 0.599>, <-3.6463, 2.8446, 19.4071>, <0.390, -0.778, 0.493> }
	smooth_triangle { <-3.6463, 2.8446, 19.4071>, <0.390, -0.778, 0.493>, <-1.6134, 0.6358, 16.1397>, <0.653, -0.464, 0.599>, <-1.6371, 0.6297, 16.1329>, <-0.229, -0.890, 0.394> }
	smooth_triangle { <-3.6463, 2.8446, 19.4071>, <0.390, -0.778, 0.493>, <-1.6371, 0.6297, 16.1329>, <-0.229, -0.890, 0.394>, <-3.6680, 2.8356, 19.3976>, <-0.487, -0.803, 0.343> }
	smooth_triangle { <-3.6680, 2.8356, 19.3976>, <-0.590, -0.715, 0.374>, <-1.6371, 0.6297, 16.1329>, <-0.229, -0.890, 0.394>, <-1.6510, 0.6460, 16.1193>, <-0.881, -0.427, -0.204> }
	smooth_triangle { <-3.6680, 2.8356, 19.3976>, <-0.590, -0.715, 0.374>, <-1.6510, 0.6460, 16.1193>, <-0.881, -0.427, -0.204>, <-3.6796, 2.8478, 19.3786>, <-0.958, -0.176, -0.225> }
	smooth_triangle { <-3.6796, 2.8478, 19.3786>, <-0.987, 0.089, -0.135>, <-1.6510, 0.6460, 16.1193>, <-0.881, -0.427, -0.204>, <-1.6413, 0.6685, 16.1124>, <-0.653, 0.464, -0.599> }
	smooth_triangle { <-3.6796, 2.8478, 19.3786>, <-0.987, 0.089, -0.135>, <-1.6413, 0.6685, 16.1124>, <-0.653, 0.464, -0.599>, <-3.6695, 2.8691, 19.3691>, <-0.390, 0.777, -0.493> }
	smooth_triangle { <-3.6695, 2.8691, 19.3691>, <-0.390, 0.777, -0.493>, <-1.6413, 0.6685, 16.1124>, <-0.653, 0.464, -0.599>, <-1.6176, 0.6746, 16.1193>, <0.229, 0.890, -0.394> }
	smooth_triangle { <-3.6695, 2.8691, 19.3691>, <-0.390, 0.777, -0.493>, <-1.6176, 0.6746, 16.1193>, <0.229, 0.890, -0.394>, <-3.6478, 2.8781, 19.3786>, <0.487, 0.803, -0.343> }
	smooth_triangle { <-3.6478, 2.8781, 19.3786>, <0.590, 0.715, -0.375>, <-1.6176, 0.6746, 16.1193>, <0.229, 0.890, -0.394>, <-1.6037, 0.6583, 16.1329>, <0.751, 0.660, 0.004> }
	smooth_triangle { <-3.6478, 2.8781, 19.3786>, <0.590, 0.715, -0.375>, <-1.6037, 0.6583, 16.1329>, <0.751, 0.660, 0.004>, <-3.6361, 2.8659, 19.3976>, <0.858, 0.460, -0.229> }
	smooth_triangle { <-2.8920, 3.9057, 21.4520>, <0.331, -0.891, 0.311>, <-3.6361, 2.8659, 19.3976>, <0.882, -0.265, 0.390>, <-3.6463, 2.8446, 19.4071>, <0.390, -0.778, 0.493> }
	smooth_triangle { <-2.8920, 3.9057, 21.4520>, <0.331, -0.891, 0.311>, <-3.6463, 2.8446, 19.4071>, <0.390, -0.778, 0.493>, <-2.9162, 3.9096, 21.4588>, <-0.261, -0.842, 0.472> }
	smooth_triangle { <-2.9162, 3.9096, 21.4588>, <0.093, -0.907, 0.412>, <-3.6463, 2.8446, 19.4071>, <0.390, -0.778, 0.493>, <-3.6680, 2.8356, 19.3976>, <-0.353, -0.891, 0.284> }
	smooth_triangle { <-2.9162, 3.9096, 21.4588>, <-0.505, -0.720, 0.476>, <-3.6680, 2.8356, 19.3976>, <-0.719, -0.609, 0.336>, <-2.9280, 3.9310, 21.4520>, <-0.958, -0.070, 0.280> }
	smooth_triangle { <-2.9280, 3.9310, 21.4520>, <-0.958, -0.070, 0.280>, <-3.6680, 2.8356, 19.3976>, <-0.843, -0.486, 0.229>, <-3.6796, 2.8478, 19.3786>, <-0.987, 0.089, -0.135> }
	smooth_triangle { <-2.9280, 3.9310, 21.4520>, <-0.968, 0.048, 0.248>, <-3.6796, 2.8478, 19.3786>, <-0.954, 0.257, -0.155>, <-2.9156, 3.9485, 21.4384>, <-0.673, 0.718, -0.174> }
	smooth_triangle { <-2.9156, 3.9485, 21.4384>, <-0.673, 0.718, -0.174>, <-3.6796, 2.8478, 19.3786>, <-0.954, 0.257, -0.155>, <-3.6695, 2.8691, 19.3691>, <-0.390, 0.777, -0.493> }
	smooth_triangle { <-2.9156, 3.9485, 21.4384>, <-0.586, 0.783, -0.208>, <-3.6695, 2.8691, 19.3691>, <-0.390, 0.777, -0.493>, <-2.8915, 3.9446, 21.4316>, <0.261, 0.842, -0.472> }
	smooth_triangle { <-2.8915, 3.9446, 21.4316>, <-0.093, 0.907, -0.411>, <-3.6695, 2.8691, 19.3691>, <-0.390, 0.777, -0.493>, <-3.6478, 2.8781, 19.3786>, <0.353, 0.892, -0.283> }
	smooth_triangle { <-2.8915, 3.9446, 21.4316>, <0.505, 0.720, -0.475>, <-3.6478, 2.8781, 19.3786>, <0.719, 0.608, -0.337>, <-2.8797, 3.9232, 21.4384>, <0.957, 0.068, -0.282> }
	smooth_triangle { <-2.8797, 3.9232, 21.4384>, <0.957, 0.068, -0.282>, <-3.6478, 2.8781, 19.3786>, <0.844, 0.484, -0.231>, <-3.6361, 2.8659, 19.3976>, <0.978, 0.116, -0.175> }
	smooth_triangle { <-2.8797, 3.9232, 21.4384>, <0.967, -0.050, -0.249>, <-3.6361, 2.8659, 19.3976>, <0.946, -0.219, -0.238>, <-2.8920, 3.9057, 21.4520>, <0.877, -0.480, 0.032> }
	smooth_triangle { <-2.5449, 4.8857, 23.6585>, <0.155, -0.768, 0.622>, <-2.8920, 3.9057, 21.4520>, <0.331, -0.891, 0.311>, <-2.9162, 3.9096, 21.4588>, <-0.261, -0.842, 0.472> }
	smooth_triangle { <-2.5449, 4.8857, 23.6585>, <0.155, -0.768, 0.622>, <-2.9162, 3.9096, 21.4588>, <0.093, -0.907, 0.412>, <-2.5695, 4.8821, 23.6639>, <-0.082, -0.580, 0.811> }
	smooth_triangle { <-2.5695, 4.8821, 23.6639>, <-0.752, -0.441, 0.490>, <-2.9162, 3.9096, 21.4588>, <-0.505, -0.720, 0.476>, <-2.9280, 3.9310, 21.4520>, <-0.958, -0.070, 0.280> }
	smooth_triangle { <-2.5695, 4.8821, 23.6639>, <-0.572, -0.635, 0.519>, <-2.9280, 3.9310, 21.4520>, <-0.841, -0.370, 0.395>, <-2.5864, 4.9002, 23.6585>, <-0.907, -0.210, 0.366> }
	smooth_triangle { <-2.5864, 4.9002, 23.6585>, <-0.926, 0.319, -0.202>, <-2.9280, 3.9310, 21.4520>, <-0.968, 0.048, 0.248>, <-2.9156, 3.9485, 21.4384>, <-0.673, 0.718, -0.174> }
	smooth_triangle { <-2.5864, 4.9002, 23.6585>, <-0.991, 0.005, 0.133>, <-2.9156, 3.9485, 21.4384>, <-0.880, 0.474, -0.005>, <-2.5788, 4.9219, 23.6477>, <-0.901, 0.352, -0.255> }
	smooth_triangle { <-2.5788, 4.9219, 23.6477>, <-0.155, 0.767, -0.622>, <-2.9156, 3.9485, 21.4384>, <-0.586, 0.783, -0.208>, <-2.8915, 3.9446, 21.4316>, <0.261, 0.842, -0.472> }
	smooth_triangle { <-2.5788, 4.9219, 23.6477>, <-0.560, 0.623, -0.546>, <-2.8915, 3.9446, 21.4316>, <-0.093, 0.907, -0.411>, <-2.5543, 4.9255, 23.6423>, <0.082, 0.576, -0.814> }
	smooth_triangle { <-2.5543, 4.9255, 23.6423>, <0.752, 0.440, -0.490>, <-2.8915, 3.9446, 21.4316>, <0.505, 0.720, -0.475>, <-2.8797, 3.9232, 21.4384>, <0.957, 0.068, -0.282> }
	smooth_triangle { <-2.5543, 4.9255, 23.6423>, <0.572, 0.634, -0.520>, <-2.8797, 3.9232, 21.4384>, <0.841, 0.368, -0.396>, <-2.5373, 4.9074, 23.6477>, <0.906, 0.209, -0.367> }
	smooth_triangle { <-2.5373, 4.9074, 23.6477>, <0.926, -0.317, 0.204>, <-2.8797, 3.9232, 21.4384>, <0.967, -0.050, -0.249>, <-2.8920, 3.9057, 21.4520>, <0.877, -0.480, 0.032> }
	smooth_triangle { <-2.5373, 4.9074, 23.6477>, <0.991, -0.005, -0.133>, <-2.8920, 3.9057, 21.4520>, <0.877, -0.480, 0.032>, <-2.5449, 4.8857, 23.6585>, <0.981, -0.098, 0.170> }
	smooth_triangle { <-2.7596, 6.8165, 24.3107>, <0.443, -0.285, 0.850>, <-2.5449, 4.8857, 23.6585>, <0.155, -0.768, 0.622>, <-2.5695, 4.8821, 23.6639>, <0.121, -0.514, 0.849> }
	smooth_triangle { <-2.7596, 6.8165, 24.3107>, <0.651, -0.324, 0.687>, <-2.5695, 4.8821, 23.6639>, <0.121, -0.514, 0.849>, <-2.7810, 6.8100, 24.3227>, <-0.107, -0.289, 0.951> }
	smooth_triangle { <-2.7810, 6.8100, 24.3227>, <-0.107, -0.289, 0.951>, <-2.5695, 4.8821, 23.6639>, <-0.260, -0.585, 0.768>, <-2.5864, 4.9002, 23.6585>, <-0.787, -0.260, 0.560> }
	smooth_triangle { <-2.7810, 6.8100, 24.3227>, <-0.107, -0.289, 0.951>, <-2.5864, 4.9002, 23.6585>, <-0.612, -0.423, 0.668>, <-2.8033, 6.8114, 24.3107>, <-0.842, -0.050, 0.537> }
	smooth_triangle { <-2.8033, 6.8114, 24.3107>, <-0.989, 0.087, -0.123>, <-2.5864, 4.9002, 23.6585>, <-0.993, 0.100, -0.063>, <-2.5788, 4.9219, 23.6477>, <-0.817, 0.366, -0.445> }
	smooth_triangle { <-2.8033, 6.8114, 24.3107>, <-0.941, -0.026, 0.339>, <-2.5788, 4.9219, 23.6477>, <-0.981, 0.097, -0.169>, <-2.8042, 6.8195, 24.2866>, <-0.878, 0.219, -0.425> }
	smooth_triangle { <-2.8042, 6.8195, 24.2866>, <-0.443, 0.288, -0.849>, <-2.5788, 4.9219, 23.6477>, <-0.389, 0.649, -0.655>, <-2.5543, 4.9255, 23.6423>, <-0.121, 0.510, -0.852> }
	smooth_triangle { <-2.8042, 6.8195, 24.2866>, <-0.781, 0.248, -0.572>, <-2.5543, 4.9255, 23.6423>, <-0.121, 0.510, -0.852>, <-2.7828, 6.8260, 24.2745>, <0.107, 0.295, -0.949> }
	smooth_triangle { <-2.7828, 6.8260, 24.2745>, <0.107, 0.295, -0.949>, <-2.5543, 4.9255, 23.6423>, <0.260, 0.582, -0.770>, <-2.5373, 4.9074, 23.6477>, <0.786, 0.257, -0.562> }
	smooth_triangle { <-2.7828, 6.8260, 24.2745>, <0.107, 0.295, -0.949>, <-2.5373, 4.9074, 23.6477>, <0.612, 0.421, -0.669>, <-2.7605, 6.8245, 24.2866>, <0.843, 0.058, -0.535> }
	smooth_triangle { <-2.7605, 6.8245, 24.2866>, <0.989, -0.082, 0.126>, <-2.5373, 4.9074, 23.6477>, <0.993, -0.099, 0.064>, <-2.5449, 4.8857, 23.6585>, <0.981, -0.098, 0.170> }
	smooth_triangle { <-2.7605, 6.8245, 24.2866>, <0.941, 0.034, -0.336>, <-2.5449, 4.8857, 23.6585>, <0.981, -0.098, 0.170>, <-2.7596, 6.8165, 24.3107>, <0.994, 0.111, -0.001> }
	smooth_triangle { <-2.1468, 8.7046, 24.7065>, <0.523, -0.329, 0.786>, <-2.7596, 6.8165, 24.3107>, <0.651, -0.324, 0.687>, <-2.7810, 6.8100, 24.3227>, <-0.107, -0.289, 0.951> }
	smooth_triangle { <-2.1468, 8.7046, 24.7065>, <-0.442, -0.028, 0.896>, <-2.7810, 6.8100, 24.3227>, <-0.107, -0.289, 0.951>, <-2.8033, 6.8114, 24.3107>, <-0.842, -0.050, 0.537> }
	smooth_triangle { <-2.1468, 8.7046, 24.7065>, <-0.944, 0.307, 0.121>, <-2.8033, 6.8114, 24.3107>, <-0.941, -0.026, 0.339>, <-2.8042, 6.8195, 24.2866>, <-0.878, 0.219, -0.425> }
	smooth_triangle { <-2.1468, 8.7046, 24.7065>, <-0.519, 0.359, -0.776>, <-2.8042, 6.8195, 24.2866>, <-0.781, 0.248, -0.572>, <-2.7828, 6.8260, 24.2745>, <0.107, 0.295, -0.949> }
	smooth_triangle { <-2.1468, 8.7046, 24.7065>, <0.448, 0.059, -0.892>, <-2.7828, 6.8260, 24.2745>, <0.107, 0.295, -0.949>, <-2.7605, 6.8245, 24.2866>, <0.843, 0.058, -0.535> }
	smooth_triangle { <-2.1468, 8.7046, 24.7065>, <0.953, -0.280, -0.114>, <-2.7605, 6.8245, 24.2866>, <0.941, 0.034, -0.336>, <-2.7596, 6.8165, 24.3107>, <0.767, -0.319, 0.556> }
	smooth_triangle { <-1.3830, -0.5121, 17.2343>, <-0.618, 0.459, 0.638>, <-1.6507, 0.6556, 16.1354>, <-0.640, 0.632, 0.438>, <-1.6312, 0.6689, 16.1448>, <-0.285, 0.760, 0.584> }
	smooth_triangle { <-1.3830, -0.5121, 17.2343>, <-0.618, 0.459, 0.638>, <-1.6312, 0.6689, 16.1448>, <-0.285, 0.760, 0.584>, <-1.3635, -0.4988, 17.2437>, <0.036, 0.689, 0.724> }
	smooth_triangle { <-1.3635, -0.4988, 17.2437>, <0.036, 0.689, 0.724>, <-1.6312, 0.6689, 16.1448>, <-0.130, 0.807, 0.577>, <-1.6078, 0.6654, 16.1354>, <0.689, 0.590, 0.420> }
	smooth_triangle { <-1.3635, -0.4988, 17.2437>, <0.036, 0.689, 0.724>, <-1.6078, 0.6654, 16.1354>, <0.689, 0.590, 0.420>, <-1.3401, -0.5022, 17.2343>, <0.872, 0.427, 0.241> }
	smooth_triangle { <-1.3401, -0.5022, 17.2343>, <0.872, 0.427, 0.241>, <-1.6078, 0.6654, 16.1354>, <0.794, 0.477, 0.376>, <-1.6040, 0.6487, 16.1167>, <0.973, -0.167, -0.162> }
	smooth_triangle { <-1.3401, -0.5022, 17.2343>, <0.872, 0.427, 0.241>, <-1.6040, 0.6487, 16.1167>, <0.973, -0.167, -0.162>, <-1.3363, -0.5190, 17.2156>, <0.836, -0.262, -0.482> }
	smooth_triangle { <-1.3363, -0.5190, 17.2156>, <0.836, -0.262, -0.482>, <-1.6040, 0.6487, 16.1167>, <0.926, -0.321, -0.197>, <-1.6235, 0.6354, 16.1074>, <0.285, -0.760, -0.584> }
	smooth_triangle { <-1.3363, -0.5190, 17.2156>, <0.836, -0.262, -0.482>, <-1.6235, 0.6354, 16.1074>, <0.285, -0.760, -0.584>, <-1.3558, -0.5322, 17.2062>, <-0.036, -0.689, -0.724> }
	smooth_triangle { <-1.3558, -0.5322, 17.2062>, <-0.036, -0.689, -0.724>, <-1.6235, 0.6354, 16.1074>, <0.130, -0.807, -0.577>, <-1.6469, 0.6389, 16.1167>, <-0.689, -0.591, -0.419> }
	smooth_triangle { <-1.3558, -0.5322, 17.2062>, <-0.036, -0.689, -0.724>, <-1.6469, 0.6389, 16.1167>, <-0.689, -0.591, -0.419>, <-1.3792, -0.5288, 17.2156>, <-0.872, -0.427, -0.241> }
	smooth_triangle { <-1.3792, -0.5288, 17.2156>, <-0.872, -0.427, -0.241>, <-1.6469, 0.6389, 16.1167>, <-0.794, -0.477, -0.376>, <-1.6507, 0.6556, 16.1354>, <-0.984, -0.169, -0.050> }
	smooth_triangle { <-1.3792, -0.5288, 17.2156>, <-0.872, -0.427, -0.241>, <-1.6507, 0.6556, 16.1354>, <-0.984, -0.169, -0.050>, <-1.3830, -0.5121, 17.2343>, <-0.975, -0.223, 0.000> }
	smooth_triangle { <-2.1256, -0.7701, 19.9530>, <-0.616, 0.760, 0.207>, <-1.6507, 0.6556, 16.1354>, <-0.640, 0.632, 0.438>, <-1.6312, 0.6689, 16.1448>, <-0.285, 0.760, 0.584> }
	smooth_triangle { <-2.1256, -0.7701, 19.9530>, <0.586, 0.743, 0.325>, <-1.6312, 0.6689, 16.1448>, <0.412, 0.784, 0.464>, <-2.1066, -0.7866, 19.9566>, <0.756, 0.575, 0.314> }
	smooth_triangle { <-2.1066, -0.7866, 19.9566>, <0.471, 0.820, 0.326>, <-1.6312, 0.6689, 16.1448>, <-0.130, 0.807, 0.577>, <-1.6078, 0.6654, 16.1354>, <0.689, 0.590, 0.420> }
	smooth_triangle { <-2.1066, -0.7866, 19.9566>, <0.904, 0.330, 0.273>, <-1.6078, 0.6654, 16.1354>, <0.997, 0.039, 0.074>, <-2.1106, -0.8114, 19.9530>, <0.912, -0.403, 0.071> }
	smooth_triangle { <-2.1106, -0.8114, 19.9530>, <0.982, -0.064, 0.179>, <-1.6078, 0.6654, 16.1354>, <0.794, 0.477, 0.376>, <-1.6040, 0.6487, 16.1167>, <0.973, -0.167, -0.162> }
	smooth_triangle { <-2.1106, -0.8114, 19.9530>, <0.782, -0.622, -0.016>, <-1.6040, 0.6487, 16.1167>, <0.568, -0.725, -0.389>, <-2.1334, -0.8197, 19.9457>, <0.150, -0.960, -0.237> }
	smooth_triangle { <-2.1334, -0.8197, 19.9457>, <0.490, -0.860, -0.140>, <-1.6040, 0.6487, 16.1167>, <0.926, -0.321, -0.197>, <-1.6235, 0.6354, 16.1074>, <0.285, -0.760, -0.584> }
	smooth_triangle { <-2.1334, -0.8197, 19.9457>, <-0.117, -0.950, -0.288>, <-1.6235, 0.6354, 16.1074>, <-0.412, -0.784, -0.464>, <-2.1524, -0.8032, 19.9420>, <-0.756, -0.575, -0.314> }
	smooth_triangle { <-2.1524, -0.8032, 19.9420>, <-0.471, -0.820, -0.326>, <-1.6235, 0.6354, 16.1074>, <0.130, -0.807, -0.577>, <-1.6469, 0.6389, 16.1167>, <-0.689, -0.591, -0.419> }
	smooth_triangle { <-2.1524, -0.8032, 19.9420>, <-0.904, -0.330, -0.273>, <-1.6469, 0.6389, 16.1167>, <-0.997, -0.039, -0.074>, <-2.1484, -0.7784, 19.9457>, <-0.912, 0.403, -0.071> }
	smooth_triangle { <-2.1484, -0.7784, 19.9457>, <-0.982, 0.064, -0.179>, <-1.6469, 0.6389, 16.1167>, <-0.794, -0.477, -0.376>, <-1.6507, 0.6556, 16.1354>, <-0.984, -0.169, -0.050> }
	smooth_triangle { <-2.1484, -0.7784, 19.9457>, <-0.782, 0.622, 0.016>, <-1.6507, 0.6556, 16.1354>, <-0.405, 0.872, 0.275>, <-2.1256, -0.7701, 19.9530>, <-0.444, 0.889, 0.116> }
	smooth_triangle { <-2.7578, -1.1846, 22.2731>, <0.480, 0.838, 0.258>, <-2.1256, -0.7701, 19.9530>, <0.586, 0.743, 0.325>, <-2.1066, -0.7866, 19.9566>, <0.756, 0.575, 0.314> }
	smooth_triangle { <-2.7578, -1.1846, 22.2731>, <0.480, 0.838, 0.258>, <-2.1066, -0.7866, 19.9566>, <0.471, 0.820, 0.326>, <-2.7356, -1.1963, 22.2770>, <0.778, 0.504, 0.374> }
	smooth_triangle { <-2.7356, -1.1963, 22.2770>, <0.927, 0.078, 0.367>, <-2.1066, -0.7866, 19.9566>, <0.904, 0.330, 0.273>, <-2.1106, -0.8114, 19.9530>, <0.912, -0.403, 0.071> }
	smooth_triangle { <-2.7356, -1.1963, 22.2770>, <0.845, 0.393, 0.362>, <-2.1106, -0.8114, 19.9530>, <0.982, -0.064, 0.179>, <-2.7335, -1.2213, 22.2731>, <0.803, -0.495, 0.332> }
	smooth_triangle { <-2.7335, -1.2213, 22.2731>, <0.543, -0.823, 0.168>, <-2.1106, -0.8114, 19.9530>, <0.782, -0.622, -0.016>, <-2.1334, -0.8197, 19.9457>, <0.150, -0.960, -0.237> }
	smooth_triangle { <-2.7335, -1.2213, 22.2731>, <0.753, -0.601, 0.270>, <-2.1334, -0.8197, 19.9457>, <0.490, -0.860, -0.140>, <-2.7536, -1.2346, 22.2652>, <0.023, -0.999, -0.044> }
	smooth_triangle { <-2.7536, -1.2346, 22.2652>, <-0.385, -0.901, -0.199>, <-2.1334, -0.8197, 19.9457>, <-0.117, -0.950, -0.288>, <-2.1524, -0.8032, 19.9420>, <-0.756, -0.575, -0.314> }
	smooth_triangle { <-2.7536, -1.2346, 22.2652>, <-0.094, -0.991, -0.094>, <-2.1524, -0.8032, 19.9420>, <-0.471, -0.820, -0.326>, <-2.7759, -1.2230, 22.2613>, <-0.777, -0.504, -0.376> }
	smooth_triangle { <-2.7759, -1.2230, 22.2613>, <-0.927, -0.078, -0.367>, <-2.1524, -0.8032, 19.9420>, <-0.904, -0.330, -0.273>, <-2.1484, -0.7784, 19.9457>, <-0.912, 0.403, -0.071> }
	smooth_triangle { <-2.7759, -1.2230, 22.2613>, <-0.845, -0.393, -0.363>, <-2.1484, -0.7784, 19.9457>, <-0.982, 0.064, -0.179>, <-2.7779, -1.1980, 22.2652>, <-0.802, 0.495, -0.334> }
	smooth_triangle { <-2.7779, -1.1980, 22.2652>, <-0.542, 0.823, -0.168>, <-2.1484, -0.7784, 19.9457>, <-0.782, 0.622, 0.016>, <-2.1256, -0.7701, 19.9530>, <-0.444, 0.889, 0.116> }
	smooth_triangle { <-2.7779, -1.1980, 22.2652>, <-0.752, 0.601, -0.271>, <-2.1256, -0.7701, 19.9530>, <-0.444, 0.889, 0.116>, <-2.7578, -1.1846, 22.2731>, <-0.329, 0.939, -0.101> }
	smooth_triangle { <-3.9471, -1.1123, 24.3946>, <0.656, 0.622, 0.429>, <-2.7578, -1.1846, 22.2731>, <0.480, 0.838, 0.258>, <-2.7356, -1.1963, 22.2770>, <0.778, 0.504, 0.374> }
	smooth_triangle { <-3.9471, -1.1123, 24.3946>, <0.656, 0.622, 0.429>, <-2.7356, -1.1963, 22.2770>, <0.845, 0.393, 0.362>, <-3.9375, -1.1349, 24.4009>, <0.820, 0.070, 0.569> }
	smooth_triangle { <-3.9375, -1.1349, 24.4009>, <0.820, 0.070, 0.569>, <-2.7356, -1.1963, 22.2770>, <0.845, 0.393, 0.362>, <-2.7335, -1.2213, 22.2731>, <0.803, -0.495, 0.332> }
	smooth_triangle { <-3.9375, -1.1349, 24.4009>, <0.820, 0.070, 0.569>, <-2.7335, -1.2213, 22.2731>, <0.753, -0.601, 0.270>, <-3.9499, -1.1562, 24.3946>, <0.468, -0.824, 0.319> }
	smooth_triangle { <-3.9499, -1.1562, 24.3946>, <0.468, -0.824, 0.319>, <-2.7335, -1.2213, 22.2731>, <0.753, -0.601, 0.270>, <-2.7536, -1.2346, 22.2652>, <0.023, -0.999, -0.044> }
	smooth_triangle { <-3.9499, -1.1562, 24.3946>, <0.468, -0.824, 0.319>, <-2.7536, -1.2346, 22.2652>, <-0.094, -0.991, -0.094>, <-3.9719, -1.1548, 24.3820>, <-0.352, -0.902, -0.249> }
	smooth_triangle { <-3.9719, -1.1548, 24.3820>, <-0.352, -0.902, -0.249>, <-2.7536, -1.2346, 22.2652>, <-0.094, -0.991, -0.094>, <-2.7759, -1.2230, 22.2613>, <-0.777, -0.504, -0.376> }
	smooth_triangle { <-3.9719, -1.1548, 24.3820>, <-0.352, -0.902, -0.249>, <-2.7759, -1.2230, 22.2613>, <-0.845, -0.393, -0.363>, <-3.9815, -1.1322, 24.3757>, <-0.820, -0.070, -0.568> }
	smooth_triangle { <-3.9815, -1.1322, 24.3757>, <-0.820, -0.070, -0.568>, <-2.7759, -1.2230, 22.2613>, <-0.845, -0.393, -0.363>, <-2.7779, -1.1980, 22.2652>, <-0.802, 0.495, -0.334> }
	smooth_triangle { <-3.9815, -1.1322, 24.3757>, <-0.820, -0.070, -0.568>, <-2.7779, -1.1980, 22.2652>, <-0.752, 0.601, -0.271>, <-3.9691, -1.1109, 24.3820>, <-0.468, 0.824, -0.319> }
	smooth_triangle { <-3.9691, -1.1109, 24.3820>, <-0.468, 0.824, -0.319>, <-2.7779, -1.1980, 22.2652>, <-0.752, 0.601, -0.271>, <-2.7578, -1.1846, 22.2731>, <-0.329, 0.939, -0.101> }
	smooth_triangle { <-3.9691, -1.1109, 24.3820>, <-0.468, 0.824, -0.319>, <-2.7578, -1.1846, 22.2731>, <-0.329, 0.939, -0.101>, <-3.9471, -1.1123, 24.3946>, <-0.007, 1.000, 0.030> }
	smooth_triangle { <-5.2423, -1.2355, 25.9612>, <0.774, 0.521, 0.360>, <-3.9471, -1.1123, 24.3946>, <0.656, 0.622, 0.429>, <-3.9375, -1.1349, 24.4009>, <0.820, 0.070, 0.569> }
	smooth_triangle { <-5.2423, -1.2355, 25.9612>, <0.774, 0.521, 0.360>, <-3.9375, -1.1349, 24.4009>, <0.820, 0.070, 0.569>, <-5.2304, -1.2565, 25.9693>, <0.851, -0.177, 0.494> }
	smooth_triangle { <-5.2304, -1.2565, 25.9693>, <0.757, -0.297, 0.582>, <-3.9375, -1.1349, 24.4009>, <0.820, 0.070, 0.569>, <-3.9499, -1.1562, 24.3946>, <0.468, -0.824, 0.319> }
	smooth_triangle { <-5.2304, -1.2565, 25.9693>, <0.851, -0.177, 0.494>, <-3.9499, -1.1562, 24.3946>, <0.468, -0.824, 0.319>, <-5.2380, -1.2793, 25.9612>, <0.189, -0.896, 0.402> }
	smooth_triangle { <-5.2380, -1.2793, 25.9612>, <0.189, -0.896, 0.402>, <-3.9499, -1.1562, 24.3946>, <0.468, -0.824, 0.319>, <-3.9719, -1.1548, 24.3820>, <-0.352, -0.902, -0.249> }
	smooth_triangle { <-5.2380, -1.2793, 25.9612>, <0.189, -0.896, 0.402>, <-3.9719, -1.1548, 24.3820>, <-0.352, -0.902, -0.249>, <-5.2575, -1.2812, 25.9450>, <-0.592, -0.796, -0.125> }
	smooth_triangle { <-5.2575, -1.2812, 25.9450>, <-0.718, -0.653, -0.241>, <-3.9719, -1.1548, 24.3820>, <-0.352, -0.902, -0.249>, <-3.9815, -1.1322, 24.3757>, <-0.820, -0.070, -0.568> }
	smooth_triangle { <-5.2575, -1.2812, 25.9450>, <-0.685, -0.721, -0.104>, <-3.9815, -1.1322, 24.3757>, <-0.820, -0.070, -0.568>, <-5.2693, -1.2603, 25.9369>, <-0.851, 0.176, -0.495> }
	smooth_triangle { <-5.2693, -1.2603, 25.9369>, <-0.757, 0.296, -0.582>, <-3.9815, -1.1322, 24.3757>, <-0.820, -0.070, -0.568>, <-3.9691, -1.1109, 24.3820>, <-0.468, 0.824, -0.319> }
	smooth_triangle { <-5.2693, -1.2603, 25.9369>, <-0.851, 0.176, -0.495>, <-3.9691, -1.1109, 24.3820>, <-0.468, 0.824, -0.319>, <-5.2617, -1.2374, 25.9450>, <-0.188, 0.896, -0.403> }
	smooth_triangle { <-5.2617, -1.2374, 25.9450>, <-0.188, 0.896, -0.403>, <-3.9691, -1.1109, 24.3820>, <-0.468, 0.824, -0.319>, <-3.9471, -1.1123, 24.3946>, <-0.007, 1.000, 0.030> }
	smooth_triangle { <-5.2617, -1.2374, 25.9450>, <-0.188, 0.896, -0.403>, <-3.9471, -1.1123, 24.3946>, <-0.007, 1.000, 0.030>, <-5.2423, -1.2355, 25.9612>, <0.135, 0.953, -0.273> }
	smooth_triangle { <-5.5956, -0.0691, 27.5642>, <0.938, 0.220, -0.267>, <-5.2423, -1.2355, 25.9612>, <0.774, 0.521, 0.360>, <-5.2304, -1.2565, 25.9693>, <0.896, 0.045, 0.442> }
	smooth_triangle { <-5.5956, -0.0691, 27.5642>, <0.876, -0.462, 0.136>, <-5.2304, -1.2565, 25.9693>, <0.757, -0.297, 0.582>, <-5.6137, -0.0852, 27.5720>, <0.368, -0.733, 0.573> }
	smooth_triangle { <-5.6137, -0.0852, 27.5720>, <0.368, -0.733, 0.573>, <-5.2304, -1.2565, 25.9693>, <0.851, -0.177, 0.494>, <-5.2380, -1.2793, 25.9612>, <0.308, -0.881, 0.358> }
	smooth_triangle { <-5.6137, -0.0852, 27.5720>, <0.368, -0.733, 0.573>, <-5.2380, -1.2793, 25.9612>, <0.189, -0.896, 0.402>, <-5.6377, -0.0822, 27.5642>, <-0.647, -0.588, 0.485> }
	smooth_triangle { <-5.6377, -0.0822, 27.5642>, <-0.647, -0.588, 0.485>, <-5.2380, -1.2793, 25.9612>, <0.042, -0.936, 0.349>, <-5.2575, -1.2812, 25.9450>, <-0.657, -0.754, 0.019> }
	smooth_triangle { <-5.6377, -0.0822, 27.5642>, <-0.647, -0.588, 0.485>, <-5.2575, -1.2812, 25.9450>, <-0.800, -0.588, -0.118>, <-5.6436, -0.0630, 27.5486>, <-0.992, 0.116, -0.048> }
	smooth_triangle { <-5.6436, -0.0630, 27.5486>, <-0.952, -0.245, 0.181>, <-5.2575, -1.2812, 25.9450>, <-0.685, -0.721, -0.104>, <-5.2693, -1.2603, 25.9369>, <-0.895, -0.045, -0.443> }
	smooth_triangle { <-5.6436, -0.0630, 27.5486>, <-0.956, 0.275, -0.097>, <-5.2693, -1.2603, 25.9369>, <-0.757, 0.296, -0.582>, <-5.6256, -0.0469, 27.5408>, <-0.369, 0.738, -0.565> }
	smooth_triangle { <-5.6256, -0.0469, 27.5408>, <-0.369, 0.738, -0.565>, <-5.2693, -1.2603, 25.9369>, <-0.851, 0.176, -0.495>, <-5.2617, -1.2374, 25.9450>, <-0.308, 0.881, -0.359> }
	smooth_triangle { <-5.6256, -0.0469, 27.5408>, <-0.369, 0.738, -0.565>, <-5.2617, -1.2374, 25.9450>, <-0.188, 0.896, -0.403>, <-5.6016, -0.0500, 27.5486>, <0.648, 0.592, -0.480> }
	smooth_triangle { <-5.6016, -0.0500, 27.5486>, <0.648, 0.592, -0.480>, <-5.2617, -1.2374, 25.9450>, <-0.040, 0.935, -0.351>, <-5.2423, -1.2355, 25.9612>, <0.492, 0.845, -0.209> }
	smooth_triangle { <-5.6016, -0.0500, 27.5486>, <0.648, 0.592, -0.480>, <-5.2423, -1.2355, 25.9612>, <0.737, 0.611, -0.290>, <-5.5956, -0.0691, 27.5642>, <0.956, 0.294, -0.003> }
	smooth_triangle { <-4.9306, 1.0773, 29.0884>, <0.666, -0.704, 0.246>, <-5.5956, -0.0691, 27.5642>, <0.876, -0.462, 0.136>, <-5.6137, -0.0852, 27.5720>, <0.368, -0.733, 0.573> }
	smooth_triangle { <-4.9306, 1.0773, 29.0884>, <-0.273, -0.697, 0.664>, <-5.6137, -0.0852, 27.5720>, <0.368, -0.733, 0.573>, <-5.6377, -0.0822, 27.5642>, <-0.647, -0.588, 0.485> }
	smooth_triangle { <-4.9306, 1.0773, 29.0884>, <-0.911, 0.021, 0.413>, <-5.6377, -0.0822, 27.5642>, <-0.647, -0.588, 0.485>, <-5.6436, -0.0630, 27.5486>, <-0.992, 0.116, -0.048> }
	smooth_triangle { <-4.9306, 1.0773, 29.0884>, <-0.660, 0.719, -0.219>, <-5.6436, -0.0630, 27.5486>, <-0.956, 0.275, -0.097>, <-5.6256, -0.0469, 27.5408>, <-0.369, 0.738, -0.565> }
	smooth_triangle { <-4.9306, 1.0773, 29.0884>, <0.276, 0.718, -0.639>, <-5.6256, -0.0469, 27.5408>, <-0.369, 0.738, -0.565>, <-5.6016, -0.0500, 27.5486>, <0.648, 0.592, -0.480> }
	smooth_triangle { <-4.9306, 1.0773, 29.0884>, <0.920, -0.003, -0.392>, <-5.6016, -0.0500, 27.5486>, <0.648, 0.592, -0.480>, <-5.5956, -0.0691, 27.5642>, <0.970, -0.233, 0.069> }
	smooth_triangle { <-2.8856, 1.1959, 17.0003>, <0.616, 0.286, 0.734>, <-1.6127, 0.6699, 16.1368>, <0.443, 0.347, 0.827>, <-1.6149, 0.6470, 16.1476>, <0.401, 0.045, 0.915> }
	smooth_triangle { <-2.8856, 1.1959, 17.0003>, <0.616, 0.286, 0.734>, <-1.6149, 0.6470, 16.1476>, <0.401, 0.045, 0.915>, <-2.8878, 1.1730, 17.0110>, <0.410, -0.374, 0.832> }
	smooth_triangle { <-2.8878, 1.1730, 17.0110>, <0.410, -0.374, 0.832>, <-1.6149, 0.6470, 16.1476>, <0.401, 0.045, 0.915>, <-1.6295, 0.6292, 16.1368>, <0.030, -0.817, 0.576> }
	smooth_triangle { <-2.8878, 1.1730, 17.0110>, <0.410, -0.374, 0.832>, <-1.6295, 0.6292, 16.1368>, <0.030, -0.817, 0.576>, <-2.9024, 1.1553, 17.0003>, <-0.200, -0.940, 0.277> }
	smooth_triangle { <-2.9024, 1.1553, 17.0003>, <-0.200, -0.940, 0.277>, <-1.6295, 0.6292, 16.1368>, <0.030, -0.817, 0.576>, <-1.6420, 0.6344, 16.1153>, <-0.370, -0.865, -0.338> }
	smooth_triangle { <-2.9024, 1.1553, 17.0003>, <-0.200, -0.940, 0.277>, <-1.6420, 0.6344, 16.1153>, <-0.370, -0.865, -0.338>, <-2.9149, 1.1604, 16.9788>, <-0.610, -0.566, -0.555> }
	smooth_triangle { <-2.9149, 1.1604, 16.9788>, <-0.610, -0.566, -0.555>, <-1.6420, 0.6344, 16.1153>, <-0.370, -0.865, -0.338>, <-1.6398, 0.6573, 16.1045>, <-0.401, -0.045, -0.915> }
	smooth_triangle { <-2.9149, 1.1604, 16.9788>, <-0.610, -0.566, -0.555>, <-1.6398, 0.6573, 16.1045>, <-0.401, -0.045, -0.915>, <-2.9127, 1.1833, 16.9680>, <-0.410, 0.374, -0.832> }
	smooth_triangle { <-2.9127, 1.1833, 16.9680>, <-0.410, 0.374, -0.832>, <-1.6398, 0.6573, 16.1045>, <-0.401, -0.045, -0.915>, <-1.6252, 0.6751, 16.1153>, <-0.030, 0.817, -0.575> }
	smooth_triangle { <-2.9127, 1.1833, 16.9680>, <-0.410, 0.374, -0.832>, <-1.6252, 0.6751, 16.1153>, <-0.030, 0.817, -0.575>, <-2.8981, 1.2011, 16.9788>, <0.200, 0.940, -0.277> }
	smooth_triangle { <-2.8981, 1.2011, 16.9788>, <0.200, 0.940, -0.277>, <-1.6252, 0.6751, 16.1153>, <-0.030, 0.817, -0.575>, <-1.6127, 0.6699, 16.1368>, <0.266, 0.963, 0.035> }
	smooth_triangle { <-2.8981, 1.2011, 16.9788>, <0.200, 0.940, -0.277>, <-1.6127, 0.6699, 16.1368>, <0.266, 0.963, 0.035>, <-2.8856, 1.1959, 17.0003>, <0.382, 0.924, 0.000> }
	smooth_triangle { <-5.7439, 1.2179, 17.0638>, <-0.086, 0.463, 0.882>, <-1.6127, 0.6699, 16.1368>, <0.443, 0.347, 0.827>, <-1.6149, 0.6470, 16.1476>, <0.401, 0.045, 0.915> }
	smooth_triangle { <-5.7439, 1.2179, 17.0638>, <-0.086, 0.463, 0.882>, <-1.6149, 0.6470, 16.1476>, <0.401, 0.045, 0.915>, <-5.7438, 1.1959, 17.0765>, <-0.249, -0.014, 0.968> }
	smooth_triangle { <-5.7438, 1.1959, 17.0765>, <-0.180, -0.201, 0.963>, <-1.6149, 0.6470, 16.1476>, <0.401, 0.045, 0.915>, <-1.6295, 0.6292, 16.1368>, <0.030, -0.817, 0.576> }
	smooth_triangle { <-5.7438, 1.1959, 17.0765>, <-0.180, -0.201, 0.963>, <-1.6295, 0.6292, 16.1368>, <0.030, -0.817, 0.576>, <-5.7442, 1.1739, 17.0638>, <-0.096, -0.899, 0.427> }
	smooth_triangle { <-5.7442, 1.1739, 17.0638>, <-0.096, -0.899, 0.427>, <-1.6295, 0.6292, 16.1368>, <0.030, -0.817, 0.576>, <-1.6420, 0.6344, 16.1153>, <-0.370, -0.865, -0.338> }
	smooth_triangle { <-5.7442, 1.1739, 17.0638>, <-0.096, -0.899, 0.427>, <-1.6420, 0.6344, 16.1153>, <-0.370, -0.865, -0.338>, <-5.7447, 1.1739, 17.0384>, <0.068, -0.902, -0.427> }
	smooth_triangle { <-5.7447, 1.1739, 17.0384>, <0.032, -0.690, -0.723>, <-1.6420, 0.6344, 16.1153>, <-0.370, -0.865, -0.338>, <-1.6398, 0.6573, 16.1045>, <-0.401, -0.045, -0.915> }
	smooth_triangle { <-5.7447, 1.1739, 17.0384>, <0.032, -0.690, -0.723>, <-1.6398, 0.6573, 16.1045>, <-0.401, -0.045, -0.915>, <-5.7449, 1.1959, 17.0258>, <0.252, 0.015, -0.968> }
	smooth_triangle { <-5.7449, 1.1959, 17.0258>, <0.183, 0.202, -0.962>, <-1.6398, 0.6573, 16.1045>, <-0.401, -0.045, -0.915>, <-1.6252, 0.6751, 16.1153>, <-0.030, 0.817, -0.575> }
	smooth_triangle { <-5.7449, 1.1959, 17.0258>, <0.183, 0.202, -0.962>, <-1.6252, 0.6751, 16.1153>, <-0.030, 0.817, -0.575>, <-5.7445, 1.2179, 17.0384>, <0.098, 0.899, -0.426> }
	smooth_triangle { <-5.7445, 1.2179, 17.0384>, <0.098, 0.899, -0.426>, <-1.6252, 0.6751, 16.1153>, <-0.030, 0.817, -0.575>, <-1.6127, 0.6699, 16.1368>, <0.266, 0.963, 0.035> }
	smooth_triangle { <-5.7445, 1.2179, 17.0384>, <0.098, 0.899, -0.426>, <-1.6127, 0.6699, 16.1368>, <0.266, 0.963, 0.035>, <-5.7439, 1.2179, 17.0638>, <-0.268, 0.963, 0.003> }
	smooth_triangle { <-7.4240, 0.3763, 15.4848>, <-0.671, 0.471, 0.573>, <-5.7439, 1.2179, 17.0638>, <-0.086, 0.463, 0.882>, <-5.7438, 1.1959, 17.0765>, <-0.504, 0.176, 0.846> }
	smooth_triangle { <-7.4240, 0.3763, 15.4848>, <-0.671, 0.471, 0.573>, <-5.7438, 1.1959, 17.0765>, <-0.307, -0.101, 0.946>, <-7.4215, 0.3530, 15.4945>, <-0.525, -0.305, 0.795> }
	smooth_triangle { <-7.4215, 0.3530, 15.4945>, <-0.525, -0.305, 0.795>, <-5.7438, 1.1959, 17.0765>, <-0.411, -0.232, 0.882>, <-5.7442, 1.1739, 17.0638>, <-0.219, -0.839, 0.499> }
	smooth_triangle { <-7.4215, 0.3530, 15.4945>, <-0.525, -0.305, 0.795>, <-5.7442, 1.1739, 17.0638>, <-0.096, -0.899, 0.427>, <-7.4043, 0.3370, 15.4848>, <0.175, -0.940, 0.293> }
	smooth_triangle { <-7.4043, 0.3370, 15.4848>, <0.175, -0.940, 0.293>, <-5.7442, 1.1739, 17.0638>, <0.004, -0.947, 0.320>, <-5.7447, 1.1739, 17.0384>, <0.431, -0.886, -0.170> }
	smooth_triangle { <-7.4043, 0.3370, 15.4848>, <0.175, -0.940, 0.293>, <-5.7447, 1.1739, 17.0384>, <0.431, -0.886, -0.170>, <-7.3896, 0.3444, 15.4654>, <0.651, -0.592, -0.475> }
	smooth_triangle { <-7.3896, 0.3444, 15.4654>, <0.651, -0.592, -0.475>, <-5.7447, 1.1739, 17.0384>, <0.288, -0.757, -0.587>, <-5.7449, 1.1959, 17.0258>, <0.508, -0.175, -0.843> }
	smooth_triangle { <-7.3896, 0.3444, 15.4654>, <0.651, -0.592, -0.475>, <-5.7449, 1.1959, 17.0258>, <0.310, 0.102, -0.945>, <-7.3921, 0.3677, 15.4557>, <0.521, 0.302, -0.798> }
	smooth_triangle { <-7.3921, 0.3677, 15.4557>, <0.521, 0.302, -0.798>, <-5.7449, 1.1959, 17.0258>, <0.415, 0.232, -0.880>, <-5.7445, 1.2179, 17.0384>, <0.220, 0.838, -0.498> }
	smooth_triangle { <-7.3921, 0.3677, 15.4557>, <0.521, 0.302, -0.798>, <-5.7445, 1.2179, 17.0384>, <0.098, 0.899, -0.426>, <-7.4094, 0.3837, 15.4654>, <-0.181, 0.937, -0.298> }
	smooth_triangle { <-7.4094, 0.3837, 15.4654>, <-0.181, 0.937, -0.298>, <-5.7445, 1.2179, 17.0384>, <-0.004, 0.947, -0.320>, <-5.7439, 1.2179, 17.0638>, <-0.268, 0.963, 0.003> }
	smooth_triangle { <-7.4094, 0.3837, 15.4654>, <-0.181, 0.937, -0.298>, <-5.7439, 1.2179, 17.0638>, <-0.268, 0.963, 0.003>, <-7.4240, 0.3763, 15.4848>, <-0.448, 0.894, 0.001> }
	smooth_triangle { <-9.3559, -0.3274, 14.1813>, <-0.606, 0.247, 0.756>, <-7.4240, 0.3763, 15.4848>, <-0.671, 0.471, 0.573>, <-7.4215, 0.3530, 15.4945>, <-0.525, -0.305, 0.795> }
	smooth_triangle { <-9.3559, -0.3274, 14.1813>, <-0.237, -0.681, 0.693>, <-7.4215, 0.3530, 15.4945>, <-0.525, -0.305, 0.795>, <-7.4043, 0.3370, 15.4848>, <0.175, -0.940, 0.293> }
	smooth_triangle { <-9.3559, -0.3274, 14.1813>, <0.360, -0.930, -0.073>, <-7.4043, 0.3370, 15.4848>, <0.175, -0.940, 0.293>, <-7.3896, 0.3444, 15.4654>, <0.651, -0.592, -0.475> }
	smooth_triangle { <-9.3559, -0.3274, 14.1813>, <0.585, -0.254, -0.770>, <-7.3896, 0.3444, 15.4654>, <0.651, -0.592, -0.475>, <-7.3921, 0.3677, 15.4557>, <0.521, 0.302, -0.798> }
	smooth_triangle { <-9.3559, -0.3274, 14.1813>, <0.217, 0.672, -0.709>, <-7.3921, 0.3677, 15.4557>, <0.521, 0.302, -0.798>, <-7.4094, 0.3837, 15.4654>, <-0.181, 0.937, -0.298> }
	smooth_triangle { <-9.3559, -0.3274, 14.1813>, <-0.380, 0.923, 0.057>, <-7.4094, 0.3837, 15.4654>, <-0.181, 0.937, -0.298>, <-7.4240, 0.3763, 15.4848>, <-0.671, 0.471, 0.573> }

	texture { PSWL_BARK }
}

/* Object 'PWL0016F' */
union {
	smooth_triangle { <-0.8604, 1.2052, 14.8027>, <-0.006, -0.974, -0.228>, <-1.2017, 1.2983, 14.3641>, <-0.033, -0.983, -0.183>, <-1.6670, 1.3174, 14.3445>, <-0.006, -0.974, -0.228> }
	smooth_triangle { <-1.6670, 1.3174, 14.3445>, <-0.006, -0.974, -0.228>, <-1.3400, 1.2054, 14.7661>, <0.020, -0.962, -0.271>, <-0.8604, 1.2052, 14.8027>, <-0.006, -0.974, -0.228> }
	smooth_triangle { <-1.6232, 0.6023, 16.1076>, <0.933, -0.054, 0.355>, <-1.4884, 0.1750, 15.7116>, <0.921, -0.066, 0.385>, <-1.5408, -0.3929, 15.7400>, <0.933, -0.054, 0.355> }
	smooth_triangle { <-1.5408, -0.3929, 15.7400>, <0.933, -0.054, 0.355>, <-1.6631, 0.0575, 16.1536>, <0.945, -0.042, 0.325>, <-1.6232, 0.6023, 16.1076>, <0.933, -0.054, 0.355> }
	smooth_triangle { <-2.2282, 0.1880, 17.3300>, <-0.407, -0.829, -0.384>, <-2.6581, 0.5767, 16.9604>, <-0.400, -0.824, -0.402>, <-3.2850, 0.8133, 17.0991>, <-0.407, -0.829, -0.384> }
	smooth_triangle { <-3.2850, 0.8133, 17.0991>, <-0.407, -0.829, -0.384>, <-2.8327, 0.4225, 17.4781>, <-0.413, -0.834, -0.367>, <-2.2282, 0.1880, 17.3300>, <-0.407, -0.829, -0.384> }
	smooth_triangle { <-2.7080, -0.3729, 18.5504>, <0.722, 0.475, 0.503>, <-2.2598, -0.7746, 18.2705>, <0.733, 0.485, 0.478>, <-2.0005, -1.3659, 18.4728>, <0.722, 0.475, 0.503> }
	smooth_triangle { <-2.0005, -1.3659, 18.4728>, <0.722, 0.475, 0.503>, <-2.4691, -0.9594, 18.7452>, <0.710, 0.465, 0.528>, <-2.7080, -0.3729, 18.5504>, <0.722, 0.475, 0.503> }
	smooth_triangle { <-3.0575, -0.6878, 19.6760>, <0.236, -0.943, -0.233>, <-3.5996, -0.6591, 19.2185>, <0.266, -0.889, -0.371>, <-4.3831, -0.9240, 19.2908>, <0.236, -0.943, -0.233> }
	smooth_triangle { <-4.3831, -0.9240, 19.2908>, <0.236, -0.943, -0.233>, <-3.7380, -0.8395, 19.8074>, <0.200, -0.976, -0.090>, <-3.0575, -0.6878, 19.6760>, <0.236, -0.943, -0.233> }
	smooth_triangle { <-3.2667, -1.0789, 20.8140>, <0.973, 0.105, 0.206>, <-3.1625, -1.4895, 20.4813>, <0.980, 0.118, 0.161>, <-3.1163, -1.9911, 20.5692>, <0.973, 0.105, 0.206> }
	smooth_triangle { <-3.1163, -1.9911, 20.5692>, <0.973, 0.105, 0.206>, <-3.2391, -1.5893, 20.8948>, <0.964, 0.092, 0.251>, <-3.2667, -1.0789, 20.8140>, <0.973, 0.105, 0.206> }
	smooth_triangle { <-3.4478, -1.2940, 21.5779>, <0.363, -0.842, -0.399>, <-3.9889, -1.3291, 21.1550>, <0.363, -0.844, -0.394>, <-4.6995, -1.6786, 21.2494>, <0.363, -0.842, -0.399> }
	smooth_triangle { <-4.6995, -1.6786, 21.2494>, <0.363, -0.842, -0.399>, <-4.1426, -1.6418, 21.6754>, <0.364, -0.840, -0.403>, <-3.4478, -1.2940, 21.5779>, <0.363, -0.842, -0.399> }
	smooth_triangle { <-3.4784, -1.5607, 22.3509>, <0.566, 0.748, 0.347>, <-2.9309, -1.8188, 22.0551>, <0.557, 0.731, 0.394>, <-2.4687, -2.2898, 22.2744>, <0.566, 0.748, 0.347> }
	smooth_triangle { <-2.4687, -2.2898, 22.2744>, <0.566, 0.748, 0.347>, <-3.0183, -1.9967, 22.5814>, <0.573, 0.763, 0.298>, <-3.4784, -1.5607, 22.3509>, <0.566, 0.748, 0.347> }
	smooth_triangle { <-3.6716, -1.7156, 23.1300>, <0.168, -0.986, -0.016>, <-4.2072, -1.7997, 22.7435>, <0.169, -0.985, -0.020>, <-4.7721, -1.8998, 22.8918>, <0.168, -0.986, -0.016> }
	smooth_triangle { <-4.7721, -1.8998, 22.8918>, <0.168, -0.986, -0.016>, <-4.2197, -1.8104, 23.2829>, <0.167, -0.986, -0.011>, <-3.6716, -1.7156, 23.1300>, <0.168, -0.986, -0.016> }
	smooth_triangle { <-3.6893, -1.9279, 23.9187>, <0.831, 0.523, 0.190>, <-3.3754, -2.2652, 23.6164>, <0.818, 0.489, 0.303>, <-3.1284, -2.7532, 23.7381>, <0.831, 0.523, 0.190> }
	smooth_triangle { <-3.1284, -2.7532, 23.7381>, <0.831, 0.523, 0.190>, <-3.4236, -2.3502, 24.0650>, <0.832, 0.549, 0.074>, <-3.6893, -1.9279, 23.9187>, <0.831, 0.523, 0.190> }
	smooth_triangle { <-2.4487, -0.4802, 19.2998>, <0.825, 0.496, -0.270>, <-2.2159, -1.0633, 18.7911>, <0.864, 0.479, -0.153>, <-1.8305, -1.7202, 18.9119>, <0.825, 0.496, -0.270> }
	smooth_triangle { <-1.8305, -1.7202, 18.9119>, <0.825, 0.496, -0.270>, <-1.9630, -1.1623, 19.3818>, <0.774, 0.505, -0.382>, <-2.4487, -0.4802, 19.2998>, <0.825, 0.496, -0.270> }
	smooth_triangle { <-2.1625, -0.5076, 20.0642>, <-0.572, 0.809, 0.131>, <-1.8084, -0.1934, 19.7357>, <-0.564, 0.809, 0.166>, <-1.3560, 0.0953, 19.8638>, <-0.572, 0.809, 0.131> }
	smooth_triangle { <-1.3560, 0.0953, 19.8638>, <-0.572, 0.809, 0.131>, <-1.7396, -0.2203, 20.2024>, <-0.581, 0.809, 0.096>, <-2.1625, -0.5076, 20.0642>, <-0.572, 0.809, 0.131> }
	smooth_triangle { <-2.2625, -0.9637, 21.2172>, <0.605, -0.701, -0.378>, <-2.8194, -1.2160, 20.7804>, <0.606, -0.708, -0.364>, <-3.4048, -1.7886, 20.9197>, <0.605, -0.701, -0.378> }
	smooth_triangle { <-3.4048, -1.7886, 20.9197>, <0.605, -0.701, -0.378>, <-2.8323, -1.5374, 21.3563>, <0.604, -0.694, -0.392>, <-2.2625, -0.9637, 21.2172>, <0.605, -0.701, -0.378> }
	smooth_triangle { <-2.1985, -1.3636, 22.3699>, <0.709, 0.625, 0.328>, <-1.7424, -1.7107, 21.9455>, <0.714, 0.664, 0.224>, <-1.2807, -2.2520, 22.0788>, <0.709, 0.625, 0.328> }
	smooth_triangle { <-1.2807, -2.2520, 22.0788>, <0.709, 0.625, 0.328>, <-1.7532, -1.9792, 22.4776>, <0.695, 0.578, 0.428>, <-2.1985, -1.3636, 22.3699>, <0.709, 0.625, 0.328> }
	smooth_triangle { <-2.4602, -2.2068, 23.1977>, <0.397, -0.605, -0.690>, <-2.9650, -2.0831, 22.8173>, <0.402, -0.569, -0.718>, <-3.5780, -2.4197, 22.7411>, <0.397, -0.605, -0.690> }
	smooth_triangle { <-3.5780, -2.4197, 22.7411>, <0.397, -0.605, -0.690>, <-3.0533, -2.5202, 23.1499>, <0.392, -0.641, -0.660>, <-2.4602, -2.2068, 23.1977>, <0.397, -0.605, -0.690> }
	smooth_triangle { <-2.5350, -3.0786, 24.0529>, <0.147, 0.669, 0.729>, <-2.0357, -3.0201, 23.9000>, <0.146, 0.666, 0.732>, <-1.5864, -3.2778, 24.0449>, <0.147, 0.669, 0.729> }
	smooth_triangle { <-1.5864, -3.2778, 24.0449>, <0.147, 0.669, 0.729>, <-2.0987, -3.3321, 24.1993>, <0.147, 0.672, 0.725>, <-2.5350, -3.0786, 24.0529>, <0.147, 0.669, 0.729> }
	smooth_triangle { <-2.7065, -3.8785, 24.9575>, <0.781, -0.562, -0.272>, <-3.0895, -4.0762, 24.3585>, <0.791, -0.510, -0.337>, <-3.5264, -4.6644, 24.2242>, <0.781, -0.562, -0.272> }
	smooth_triangle { <-3.5264, -4.6644, 24.2242>, <0.781, -0.562, -0.272>, <-3.1238, -4.3829, 24.8950>, <0.767, -0.609, -0.205>, <-2.7065, -3.8785, 24.9575>, <0.781, -0.562, -0.272> }
	smooth_triangle { <-2.7169, -4.6522, 25.9029>, <0.556, 0.649, 0.519>, <-2.2470, -4.7660, 25.5248>, <0.557, 0.670, 0.490>, <-1.7953, -5.1664, 25.5591>, <0.556, 0.649, 0.519> }
	smooth_triangle { <-1.7953, -5.1664, 25.5591>, <0.556, 0.649, 0.519>, <-2.2799, -5.0609, 25.9289>, <0.554, 0.627, 0.547>, <-2.7169, -4.6522, 25.9029>, <0.556, 0.649, 0.519> }
	smooth_triangle { <-2.7207, -5.2393, 26.7313>, <0.582, -0.628, -0.516>, <-3.1822, -5.3865, 26.3667>, <0.586, -0.655, -0.477>, <-3.6176, -5.8124, 26.4171>, <0.582, -0.628, -0.516> }
	smooth_triangle { <-3.6176, -5.8124, 26.4171>, <0.582, -0.628, -0.516>, <-3.1403, -5.6791, 26.7703>, <0.577, -0.600, -0.554>, <-2.7207, -5.2393, 26.7313>, <0.582, -0.628, -0.516> }
	smooth_triangle { <-2.5572, -5.8257, 27.5488>, <0.723, 0.535, 0.437>, <-2.1031, -6.0217, 26.9726>, <0.720, 0.588, 0.368>, <-1.5802, -6.6126, 26.8940>, <0.723, 0.535, 0.437> }
	smooth_triangle { <-1.5802, -6.6126, 26.8940>, <0.723, 0.535, 0.437>, <-2.0373, -6.4813, 27.4248>, <0.721, 0.477, 0.503>, <-2.5572, -5.8257, 27.5488>, <0.723, 0.535, 0.437> }
	smooth_triangle { <-2.9007, -6.2636, 28.4429>, <0.139, -0.892, -0.430>, <-3.3197, -6.2370, 28.2520>, <0.139, -0.892, -0.429>, <-3.8619, -6.4101, 28.4365>, <0.139, -0.892, -0.430> }
	smooth_triangle { <-3.8619, -6.4101, 28.4365>, <0.139, -0.892, -0.430>, <-3.4293, -6.4349, 28.6274>, <0.139, -0.892, -0.430>, <-2.9007, -6.2636, 28.4429>, <0.139, -0.892, -0.430> }
	smooth_triangle { <-3.0512, -6.7259, 29.3003>, <0.297, 0.828, 0.476>, <-2.3126, -6.7709, 28.8320>, <0.281, 0.891, 0.357>, <-1.7262, -7.0096, 28.9660>, <0.297, 0.828, 0.476> }
	smooth_triangle { <-1.7262, -7.0096, 28.9660>, <0.297, 0.828, 0.476>, <-2.4733, -7.0317, 29.3877>, <0.308, 0.750, 0.585>, <-3.0512, -6.7259, 29.3003>, <0.297, 0.828, 0.476> }
	smooth_triangle { <-2.5514, -0.9172, 19.0857>, <0.649, -0.411, -0.640>, <-3.0676, -1.1071, 18.6906>, <0.645, -0.401, -0.650>, <-3.4425, -1.6860, 18.6756>, <0.649, -0.411, -0.640> }
	smooth_triangle { <-3.4425, -1.6860, 18.6756>, <0.649, -0.411, -0.640>, <-2.9161, -1.4794, 19.0833>, <0.653, -0.421, -0.630>, <-2.5514, -0.9172, 19.0857>, <0.649, -0.411, -0.640> }
	smooth_triangle { <-2.2408, -1.4447, 19.6278>, <0.344, 0.822, 0.455>, <-1.8336, -1.3558, 19.1906>, <0.363, 0.788, 0.498>, <-1.2942, -1.5608, 19.1220>, <0.344, 0.822, 0.455> }
	smooth_triangle { <-1.2942, -1.5608, 19.1220>, <0.344, 0.822, 0.455>, <-1.7244, -1.6244, 19.5942>, <0.323, 0.853, 0.410>, <-2.2408, -1.4447, 19.6278>, <0.344, 0.822, 0.455> }
	smooth_triangle { <-1.8134, -2.2622, 20.4189>, <0.880, 0.071, -0.470>, <-2.0854, -2.5118, 19.9316>, <0.833, 0.138, -0.536>, <-2.1160, -3.1684, 19.7150>, <0.880, 0.071, -0.470> }
	smooth_triangle { <-2.1160, -3.1684, 19.7150>, <0.880, 0.071, -0.470>, <-1.8710, -2.8557, 20.2806>, <0.917, 0.004, -0.399>, <-1.8134, -2.2622, 20.4189>, <0.880, 0.071, -0.470> }
	smooth_triangle { <-1.2636, -2.9834, 21.2387>, <-0.133, 0.656, 0.743>, <-0.7766, -2.5003, 20.9341>, <-0.100, 0.601, 0.793>, <0.0008, -2.4469, 20.9918>, <-0.133, 0.656, 0.743> }
	smooth_triangle { <0.0008, -2.4469, 20.9918>, <-0.133, 0.656, 0.743>, <-0.5223, -2.9082, 21.3399>, <-0.166, 0.707, 0.688>, <-1.2636, -2.9834, 21.2387>, <-0.133, 0.656, 0.743> }
	smooth_triangle { <-0.2411, -3.5875, 21.2048>, <0.124, 0.396, -0.910>, <-0.6219, -3.8720, 21.0400>, <0.082, 0.415, -0.906>, <-0.6281, -4.3552, 20.8182>, <0.124, 0.396, -0.910> }
	smooth_triangle { <-0.6281, -4.3552, 20.8182>, <0.124, 0.396, -0.910>, <-0.2415, -4.0600, 21.0098>, <0.165, 0.376, -0.912>, <-0.2411, -3.5875, 21.2048>, <0.124, 0.396, -0.910> }
	smooth_triangle { <0.8927, -4.0445, 21.1751>, <0.290, 0.484, 0.825>, <0.8612, -3.4800, 20.8265>, <0.212, 0.522, 0.826>, <1.3242, -3.1443, 20.4955>, <0.290, 0.484, 0.825> }
	smooth_triangle { <1.3242, -3.1443, 20.4955>, <0.290, 0.484, 0.825>, <1.3487, -3.7210, 20.7965>, <0.366, 0.443, 0.819>, <0.8927, -4.0445, 21.1751>, <0.290, 0.484, 0.825> }
	smooth_triangle { <2.0733, -4.1032, 21.2521>, <0.007, 0.780, -0.625>, <1.5305, -4.5280, 20.6909>, <0.057, 0.769, -0.637>, <1.6295, -4.9582, 20.1804>, <0.007, 0.780, -0.625> }
	smooth_triangle { <1.6295, -4.9582, 20.1804>, <0.007, 0.780, -0.625>, <2.1778, -4.5210, 20.7057>, <-0.043, 0.790, -0.612>, <2.0733, -4.1032, 21.2521>, <0.007, 0.780, -0.625> }
	smooth_triangle { <3.3227, -4.0231, 21.3426>, <-0.047, 0.718, 0.694>, <3.2381, -3.6157, 20.9172>, <-0.042, 0.717, 0.695>, <3.7177, -3.1906, 20.5080>, <-0.047, 0.718, 0.694> }
	smooth_triangle { <3.7177, -3.1906, 20.5080>, <-0.047, 0.718, 0.694>, <3.7968, -3.6098, 20.9488>, <-0.051, 0.719, 0.693>, <3.3227, -4.0231, 21.3426>, <-0.047, 0.718, 0.694> }
	smooth_triangle { <-3.4861, -0.5957, 18.7390>, <-0.049, -0.483, -0.874>, <-3.5057, -0.1496, 18.5062>, <-0.001, -0.463, -0.887>, <-3.9123, 0.1444, 18.3534>, <-0.049, -0.483, -0.874> }
	smooth_triangle { <-3.9123, 0.1444, 18.3534>, <-0.049, -0.483, -0.874>, <-3.8809, -0.3097, 18.6157>, <-0.096, -0.503, -0.859>, <-3.4861, -0.5957, 18.7390>, <-0.049, -0.483, -0.874> }
	smooth_triangle { <-4.1660, -0.9955, 18.9605>, <0.283, -0.043, 0.958>, <-3.6940, -1.4616, 18.8000>, <0.283, -0.044, 0.958>, <-3.7220, -2.1600, 18.7765>, <0.283, -0.043, 0.958> }
	smooth_triangle { <-3.7220, -2.1600, 18.7765>, <0.283, -0.043, 0.958>, <-4.2002, -1.6775, 18.9399>, <0.284, -0.043, 0.958>, <-4.1660, -0.9955, 18.9605>, <0.283, -0.043, 0.958> }
	smooth_triangle { <-5.0136, -1.5420, 19.6370>, <-0.378, -0.461, -0.803>, <-5.2551, -0.9393, 19.4030>, <-0.382, -0.463, -0.800>, <-5.8691, -0.6121, 19.5066>, <-0.378, -0.461, -0.803> }
	smooth_triangle { <-5.8691, -0.6121, 19.5066>, <-0.378, -0.461, -0.803>, <-5.6170, -1.2291, 19.7397>, <-0.375, -0.458, -0.806>, <-5.0136, -1.5420, 19.6370>, <-0.378, -0.461, -0.803> }
	smooth_triangle { <-5.7398, -2.2593, 20.3123>, <0.474, 0.250, 0.844>, <-5.1126, -2.6632, 20.0819>, <0.471, 0.248, 0.847>, <-4.9056, -3.4294, 20.1915>, <0.474, 0.250, 0.844> }
	smooth_triangle { <-4.9056, -3.4294, 20.1915>, <0.474, 0.250, 0.844>, <-5.5434, -3.0081, 20.4258>, <0.476, 0.253, 0.842>, <-5.7398, -2.2593, 20.3123>, <0.474, 0.250, 0.844> }
	smooth_triangle { <-6.5862, -2.3576, 21.2135>, <-0.631, -0.369, -0.683>, <-6.6257, -1.8988, 20.9881>, <-0.660, -0.376, -0.650>, <-6.9458, -1.4938, 21.0790>, <-0.631, -0.369, -0.683> }
	smooth_triangle { <-6.9458, -1.4938, 21.0790>, <-0.631, -0.369, -0.683>, <-6.9153, -1.9681, 21.2932>, <-0.600, -0.361, -0.714>, <-6.5862, -2.3576, 21.2135>, <-0.631, -0.369, -0.683> }
	smooth_triangle { <-7.3674, -2.6471, 22.1093>, <0.764, -0.280, 0.581>, <-7.2841, -3.2514, 21.6363>, <0.842, -0.255, 0.475>, <-7.5285, -3.9519, 21.6929>, <0.764, -0.280, 0.581> }
	smooth_triangle { <-7.5285, -3.9519, 21.6929>, <0.764, -0.280, 0.581>, <-7.6774, -3.3455, 22.1087>, <0.672, -0.299, 0.677>, <-7.3674, -2.6471, 22.1093>, <0.764, -0.280, 0.581> }
	smooth_triangle { <-7.9830, -3.0714, 23.0405>, <-0.384, -0.559, -0.735>, <-8.1365, -2.5083, 22.6898>, <-0.388, -0.561, -0.731>, <-8.6100, -2.1673, 22.6795>, <-0.384, -0.559, -0.735> }
	smooth_triangle { <-8.6100, -2.1673, 22.6795>, <-0.384, -0.559, -0.735>, <-8.4503, -2.7437, 23.0328>, <-0.379, -0.558, -0.739>, <-7.9830, -3.0714, 23.0405>, <-0.384, -0.559, -0.735> }
	smooth_triangle { <-8.5588, -3.6773, 23.9686>, <0.870, -0.357, 0.340>, <-8.5388, -4.0875, 23.5551>, <0.827, -0.378, 0.415>, <-8.8202, -4.7492, 23.5130>, <0.870, -0.357, 0.340> }
	smooth_triangle { <-8.8202, -4.7492, 23.5130>, <0.870, -0.357, 0.340>, <-8.7936, -4.3137, 23.9728>, <0.906, -0.332, 0.262>, <-8.5588, -3.6773, 23.9686>, <0.870, -0.357, 0.340> }
	smooth_triangle { <-1.8796, 1.0267, 16.8039>, <-0.759, 0.457, -0.464>, <-1.4202, 1.4200, 16.4619>, <-0.748, 0.442, -0.496>, <-1.1436, 2.0541, 16.6107>, <-0.759, 0.457, -0.464> }
	smooth_triangle { <-1.1436, 2.0541, 16.6107>, <-0.759, 0.457, -0.464>, <-1.6014, 1.6323, 16.9673>, <-0.770, 0.470, -0.432>, <-1.8796, 1.0267, 16.8039>, <-0.759, 0.457, -0.464> }
	smooth_triangle { <-2.2434, 1.3079, 17.4810>, <-0.048, -0.847, 0.530>, <-2.6815, 1.0591, 17.0884>, <-0.077, -0.801, 0.594>, <-3.4093, 1.1280, 17.0870>, <-0.048, -0.847, 0.530> }
	smooth_triangle { <-3.4093, 1.1280, 17.0870>, <-0.048, -0.847, 0.530>, <-2.9224, 1.3414, 17.5168>, <-0.019, -0.887, 0.462>, <-2.2434, 1.3079, 17.4810>, <-0.048, -0.847, 0.530> }
	smooth_triangle { <-2.9220, 2.1288, 18.4111>, <-0.760, -0.347, -0.550>, <-2.7110, 2.3983, 17.9662>, <-0.737, -0.364, -0.570>, <-2.8440, 3.0437, 17.7255>, <-0.760, -0.347, -0.550> }
	smooth_triangle { <-2.8440, 3.0437, 17.7255>, <-0.760, -0.347, -0.550>, <-3.0419, 2.7465, 18.2032>, <-0.782, -0.330, -0.529>, <-2.9220, 2.1288, 18.4111>, <-0.760, -0.347, -0.550> }
	smooth_triangle { <-3.7034, 2.8352, 19.3705>, <0.099, -0.743, 0.662>, <-4.0310, 2.4769, 19.0379>, <0.071, -0.713, 0.698>, <-4.6357, 2.3901, 19.0111>, <0.099, -0.743, 0.662> }
	smooth_triangle { <-4.6357, 2.3901, 19.0111>, <0.099, -0.743, 0.662>, <-4.2815, 2.7405, 19.3708>, <0.126, -0.770, 0.625>, <-3.7034, 2.8352, 19.3705>, <0.099, -0.743, 0.662> }
	smooth_triangle { <-3.2314, 3.3738, 20.4080>, <0.212, 0.827, -0.521>, <-2.6909, 2.9785, 20.0348>, <0.195, 0.801, -0.566>, <-1.9115, 2.8891, 20.1763>, <0.212, 0.827, -0.521> }
	smooth_triangle { <-1.9115, 2.8891, 20.1763>, <0.212, 0.827, -0.521>, <-2.4887, 3.2656, 20.5726>, <0.229, 0.850, -0.474>, <-3.2314, 3.3738, 20.4080>, <0.212, 0.827, -0.521> }
	smooth_triangle { <-2.9423, 3.9637, 21.4403>, <-0.600, -0.554, 0.577>, <-3.3849, 4.1945, 21.2103>, <-0.593, -0.544, 0.594>, <-3.6778, 4.6625, 21.3463>, <-0.600, -0.554, 0.577> }
	smooth_triangle { <-3.6778, 4.6625, 21.3463>, <-0.600, -0.554, 0.577>, <-3.2296, 4.4149, 21.5830>, <-0.607, -0.564, 0.560>, <-2.9423, 3.9637, 21.4403>, <-0.600, -0.554, 0.577> }
	smooth_triangle { <-2.6826, 4.4277, 22.5360>, <-0.325, 0.818, -0.476>, <-2.2980, 4.4123, 22.2545>, <-0.326, 0.809, -0.490>, <-1.8175, 4.6388, 22.3086>, <-0.325, 0.818, -0.476> }
	smooth_triangle { <-1.8175, 4.6388, 22.3086>, <-0.325, 0.818, -0.476>, <-2.2170, 4.6436, 22.5970>, <-0.323, 0.827, -0.461>, <-2.6826, 4.4277, 22.5360>, <-0.325, 0.818, -0.476> }
	smooth_triangle { <-2.5767, 4.9515, 23.6343>, <-0.958, -0.235, 0.163>, <-2.8043, 5.3924, 23.1487>, <-0.944, -0.188, 0.272>, <-2.9420, 6.1211, 23.1735>, <-0.958, -0.235, 0.163> }
	smooth_triangle { <-2.9420, 6.1211, 23.1735>, <-0.958, -0.235, 0.163>, <-2.7475, 5.5547, 23.7197>, <-0.959, -0.279, 0.052>, <-2.5767, 4.9515, 23.6343>, <-0.958, -0.235, 0.163> }
	smooth_triangle { <-2.6391, 5.8777, 23.9372>, <-0.773, 0.054, -0.632>, <-2.2538, 5.8101, 23.4330>, <-0.782, 0.115, -0.613>, <-1.9159, 6.2486, 23.0840>, <-0.773, 0.054, -0.632> }
	smooth_triangle { <-1.9159, 6.2486, 23.0840>, <-0.773, 0.054, -0.632>, <-2.3133, 6.3278, 23.5495>, <-0.761, -0.008, -0.649>, <-2.6391, 5.8777, 23.9372>, <-0.773, 0.054, -0.632> }
	smooth_triangle { <-2.8313, 6.8191, 24.2785>, <-0.359, -0.352, 0.864>, <-3.3404, 6.5821, 23.9723>, <-0.360, -0.347, 0.866>, <-3.9220, 6.8431, 23.8354>, <-0.359, -0.352, 0.864> }
	smooth_triangle { <-3.9220, 6.8431, 23.8354>, <-0.359, -0.352, 0.864>, <-3.3974, 7.0786, 24.1511>, <-0.358, -0.358, 0.862>, <-2.8313, 6.8191, 24.2785>, <-0.359, -0.352, 0.864> }
	smooth_triangle { <-2.4119, 7.7692, 24.4968>, <-0.144, 0.257, -0.956>, <-1.8660, 7.5866, 24.3792>, <-0.138, 0.211, -0.968>, <-1.1173, 7.9658, 24.3551>, <-0.144, 0.257, -0.956> }
	smooth_triangle { <-1.1173, 7.9658, 24.3551>, <-0.144, 0.257, -0.956>, <-1.6804, 8.1375, 24.4993>, <-0.149, 0.302, -0.942>, <-2.4119, 7.7692, 24.4968>, <-0.144, 0.257, -0.956> }
	smooth_triangle { <-2.1884, 8.7108, 24.6738>, <-0.615, 0.026, 0.788>, <-2.8400, 8.4950, 24.1737>, <-0.615, 0.029, 0.788>, <-3.3056, 8.8782, 23.7965>, <-0.615, 0.026, 0.788> }
	smooth_triangle { <-3.3056, 8.8782, 23.7965>, <-0.615, 0.026, 0.788>, <-2.6382, 9.0907, 24.3119>, <-0.615, 0.022, 0.788>, <-2.1884, 8.7108, 24.6738>, <-0.615, 0.026, 0.788> }
	smooth_triangle { <-1.5454, 0.0562, 16.6752>, <0.158, -0.657, -0.737>, <-2.2670, 0.1255, 16.4595>, <0.158, -0.656, -0.738>, <-2.9040, -0.2621, 16.6680>, <0.158, -0.657, -0.737> }
	smooth_triangle { <-2.9040, -0.2621, 16.6680>, <0.158, -0.657, -0.737>, <-2.1634, -0.3265, 16.8843>, <0.158, -0.658, -0.737>, <-1.5454, 0.0562, 16.6752>, <0.158, -0.657, -0.737> }
	smooth_triangle { <-1.3081, -0.5166, 17.2112>, <0.188, 0.743, 0.642>, <-0.7123, -0.3174, 16.8264>, <0.195, 0.715, 0.672>, <-0.0002, -0.5452, 16.8622>, <0.188, 0.743, 0.642> }
	smooth_triangle { <-0.0002, -0.5452, 16.8622>, <0.188, 0.743, 0.642>, <-0.6186, -0.7262, 17.2719>, <0.180, 0.770, 0.612>, <-1.3081, -0.5166, 17.2112>, <0.188, 0.743, 0.642> }
	smooth_triangle { <-1.7904, -0.6300, 18.5768>, <-0.445, -0.879, -0.171>, <-2.1346, -0.4063, 18.2905>, <-0.452, -0.880, -0.144>, <-2.5645, -0.2037, 18.4017>, <-0.445, -0.879, -0.171> }
	smooth_triangle { <-2.5645, -0.2037, 18.4017>, <-0.445, -0.879, -0.171>, <-2.2232, -0.4384, 18.6861>, <-0.438, -0.877, -0.198>, <-1.7904, -0.6300, 18.5768>, <-0.445, -0.879, -0.171> }
	smooth_triangle { <-2.1515, -0.8422, 19.9382>, <0.868, -0.452, 0.206>, <-2.2467, -1.3160, 19.5785>, <0.793, -0.462, 0.398>, <-2.6495, -1.9140, 19.6876>, <0.868, -0.452, 0.206> }
	smooth_triangle { <-2.6495, -1.9140, 19.6876>, <0.868, -0.452, 0.206>, <-2.3988, -1.3712, 20.0984>, <0.906, -0.422, 0.005>, <-2.1515, -0.8422, 19.9382>, <0.868, -0.452, 0.206> }
	smooth_triangle { <-2.4770, -0.9616, 21.1072>, <-0.726, -0.628, -0.279>, <-2.7982, -0.4735, 20.8249>, <-0.731, -0.631, -0.260>, <-3.2481, -0.0507, 21.0619>, <-0.726, -0.628, -0.279> }
	smooth_triangle { <-3.2481, -0.0507, 21.0619>, <-0.726, -0.628, -0.279>, <-2.9246, -0.5572, 21.3416>, <-0.721, -0.625, -0.298>, <-2.4770, -0.9616, 21.1072>, <-0.726, -0.628, -0.279> }
	smooth_triangle { <-2.7742, -1.2578, 22.2555>, <0.922, -0.379, 0.084>, <-2.9243, -1.7552, 21.8416>, <0.911, -0.389, 0.138>, <-3.1913, -2.3416, 21.9492>, <0.922, -0.379, 0.084> }
	smooth_triangle { <-3.1913, -2.3416, 21.9492>, <0.922, -0.379, 0.084>, <-2.9924, -1.8003, 22.3841>, <0.930, -0.367, 0.031>, <-2.7742, -1.2578, 22.2555>, <0.922, -0.379, 0.084> }
	smooth_triangle { <-3.3796, -1.1251, 23.3146>, <-0.783, -0.487, -0.387>, <-3.4640, -0.5810, 22.9121>, <-0.705, -0.489, -0.514>, <-3.9117, 0.0015, 22.9719>, <-0.783, -0.487, -0.387> }
	smooth_triangle { <-3.9117, 0.0015, 22.9719>, <-0.783, -0.487, -0.387>, <-3.7303, -0.5641, 23.4303>, <-0.843, -0.475, -0.252>, <-3.3796, -1.1251, 23.3146>, <-0.783, -0.487, -0.387> }
	smooth_triangle { <-3.9831, -1.1799, 24.3766>, <0.763, -0.494, 0.416>, <-4.0814, -1.6281, 24.0704>, <0.722, -0.491, 0.488>, <-4.4381, -2.0730, 24.1502>, <0.763, -0.494, 0.416> }
	smooth_triangle { <-4.4381, -2.0730, 24.1502>, <0.763, -0.494, 0.416>, <-4.2960, -1.6146, 24.4809>, <0.800, -0.494, 0.341>, <-3.9831, -1.1799, 24.3766>, <0.763, -0.494, 0.416> }
	smooth_triangle { <-4.6350, -1.1580, 25.1487>, <-0.506, -0.698, -0.507>, <-4.7602, -0.7823, 24.7753>, <-0.479, -0.694, -0.538>, <-5.2184, -0.4278, 24.7259>, <-0.506, -0.698, -0.507> }
	smooth_triangle { <-5.2184, -0.4278, 24.7259>, <-0.506, -0.698, -0.507>, <-5.0657, -0.8119, 25.1214>, <-0.533, -0.701, -0.474>, <-4.6350, -1.1580, 25.1487>, <-0.506, -0.698, -0.507> }
	smooth_triangle { <-5.2693, -1.3040, 25.9334>, <0.719, -0.511, 0.472>, <-5.3446, -1.7087, 25.5511>, <0.786, -0.495, 0.369>, <-5.6283, -2.1450, 25.5703>, <0.719, -0.511, 0.472> }
	smooth_triangle { <-5.6283, -2.1450, 25.5703>, <0.719, -0.511, 0.472>, <-5.6000, -1.7334, 25.9144>, <0.640, -0.518, 0.567>, <-5.2693, -1.3040, 25.9334>, <0.719, -0.511, 0.472> }
	smooth_triangle { <-5.3850, -0.6432, 26.7520>, <-0.311, 0.722, -0.618>, <-4.8944, -0.6028, 26.5558>, <-0.309, 0.717, -0.625>, <-4.4729, -0.2934, 26.7023>, <-0.311, 0.722, -0.618> }
	smooth_triangle { <-4.4729, -0.2934, 26.7023>, <-0.311, 0.722, -0.618>, <-4.9754, -0.3415, 26.9015>, <-0.312, 0.727, -0.612>, <-5.3850, -0.6432, 26.7520>, <-0.311, 0.722, -0.618> }
	smooth_triangle { <-5.6635, -0.0475, 27.5325>, <-0.540, -0.722, 0.432>, <-6.1247, -0.0364, 27.0473>, <-0.556, -0.654, 0.513>, <-6.7319, 0.4036, 26.9507>, <-0.540, -0.722, 0.432> }
	smooth_triangle { <-6.7319, 0.4036, 26.9507>, <-0.540, -0.722, 0.432>, <-6.2342, 0.3169, 27.5004>, <-0.519, -0.782, 0.346>, <-5.6635, -0.0475, 27.5325>, <-0.540, -0.722, 0.432> }
	smooth_triangle { <-5.2458, 0.5444, 28.3003>, <-0.792, 0.611, 0.022>, <-4.9934, 0.9004, 27.7573>, <-0.786, 0.616, 0.039>, <-4.4968, 1.5354, 27.7361>, <-0.792, 0.611, 0.022> }
	smooth_triangle { <-4.4968, 1.5354, 27.7361>, <-0.792, 0.611, 0.022>, <-4.7640, 1.1791, 28.2758>, <-0.796, 0.605, 0.005>, <-5.2458, 0.5444, 28.3003>, <-0.792, 0.611, 0.022> }
	smooth_triangle { <-4.9825, 1.0659, 29.0849>, <0.150, -0.839, 0.522>, <-5.6167, 0.8109, 28.8486>, <0.154, -0.850, 0.504>, <-6.0877, 0.8222, 29.0112>, <0.150, -0.839, 0.522> }
	smooth_triangle { <-6.0877, 0.8222, 29.0112>, <0.150, -0.839, 0.522>, <-5.4401, 1.0877, 29.2427>, <0.147, -0.829, 0.540>, <-4.9825, 1.0659, 29.0849>, <0.150, -0.839, 0.522> }
	smooth_triangle { <-2.2685, 0.9571, 16.5252>, <-0.697, -0.487, -0.526>, <-2.1487, 1.3382, 15.9757>, <-0.749, -0.457, -0.480>, <-2.3721, 1.8735, 15.8143>, <-0.697, -0.487, -0.526> }
	smooth_triangle { <-2.3721, 1.8735, 15.8143>, <-0.697, -0.487, -0.526>, <-2.5186, 1.4911, 16.3253>, <-0.642, -0.514, -0.569>, <-2.2685, 0.9571, 16.5252>, <-0.697, -0.487, -0.526> }
	smooth_triangle { <-2.9280, 1.1350, 16.9749>, <0.280, -0.465, 0.840>, <-3.0197, 0.5403, 16.6702>, <0.294, -0.471, 0.832>, <-3.5804, 0.1213, 16.6307>, <0.280, -0.465, 0.840> }
	smooth_triangle { <-3.5804, 0.1213, 16.6307>, <0.280, -0.465, 0.840>, <-3.4846, 0.7324, 16.9315>, <0.266, -0.459, 0.848>, <-2.9280, 1.1350, 16.9749>, <0.280, -0.465, 0.840> }
	smooth_triangle { <-4.3230, 1.2198, 16.9782>, <-0.228, -0.771, -0.595>, <-4.0193, 1.6411, 16.3136>, <-0.233, -0.770, -0.594>, <-4.3416, 2.0784, 15.8733>, <-0.228, -0.771, -0.595> }
	smooth_triangle { <-4.3416, 2.0784, 15.8733>, <-0.228, -0.771, -0.595>, <-4.6451, 1.6450, 16.5488>, <-0.224, -0.771, -0.596>, <-4.3230, 1.2198, 16.9782>, <-0.228, -0.771, -0.595> }
	smooth_triangle { <-5.7455, 1.1691, 17.0050>, <0.055, -0.865, 0.499>, <-5.4462, 0.8230, 16.4160>, <-0.014, -0.865, 0.501>, <-5.7760, 0.4710, 15.7990>, <0.055, -0.865, 0.499> }
	smooth_triangle { <-5.7760, 0.4710, 15.7990>, <0.055, -0.865, 0.499>, <-6.0729, 0.8269, 16.4924>, <0.124, -0.860, 0.495>, <-5.7455, 1.1691, 17.0050>, <0.055, -0.865, 0.499> }
	smooth_triangle { <-6.5726, 0.8238, 16.2357>, <0.778, -0.360, -0.515>, <-6.3500, 1.4581, 16.1111>, <0.758, -0.371, -0.536>, <-6.5002, 1.9200, 15.5783>, <0.778, -0.360, -0.515> }
	smooth_triangle { <-6.5002, 1.9200, 15.5783>, <0.778, -0.360, -0.515>, <-6.7098, 1.2773, 15.6937>, <0.797, -0.348, -0.493>, <-6.5726, 0.8238, 16.2357>, <0.778, -0.360, -0.515> }
	smooth_triangle { <-7.3751, 0.3191, 15.4635>, <-0.394, -0.517, 0.760>, <-6.9594, 0.0335, 15.5024>, <-0.438, -0.539, 0.720>, <-6.8187, -0.4043, 15.2601>, <-0.394, -0.517, 0.760> }
	smooth_triangle { <-6.8187, -0.4043, 15.2601>, <-0.394, -0.517, 0.760>, <-7.2582, -0.1167, 15.2453>, <-0.349, -0.493, 0.797>, <-7.3751, 0.3191, 15.4635>, <-0.394, -0.517, 0.760> }
	smooth_triangle { <-8.4050, 0.0643, 14.8278>, <0.481, 0.232, -0.846>, <-8.4390, 0.5017, 14.9291>, <0.483, 0.233, -0.844>, <-8.7895, 0.8404, 14.8219>, <0.481, 0.232, -0.846> }
	smooth_triangle { <-8.7895, 0.8404, 14.8219>, <0.481, 0.232, -0.846>, <-8.7508, 0.3917, 14.7216>, <0.479, 0.231, -0.847>, <-8.4050, 0.0643, 14.8278>, <0.481, 0.232, -0.846> }
	smooth_triangle { <-9.3191, -0.3594, 14.1595>, <-0.265, -0.732, 0.627>, <-8.7981, -0.5959, 14.0824>, <-0.224, -0.711, 0.666>, <-8.6232, -0.9654, 13.7466>, <-0.265, -0.732, 0.627> }
	smooth_triangle { <-8.6232, -0.9654, 13.7466>, <-0.265, -0.732, 0.627>, <-9.1356, -0.7110, 13.8052>, <-0.305, -0.750, 0.586>, <-9.3191, -0.3594, 14.1595>, <-0.265, -0.732, 0.627> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0017B' */
union {
	smooth_triangle { <1.5989, 3.1522, 13.3577>, <0.012, -0.772, 0.636>, <0.8400, 2.2315, 12.2536>, <0.005, -0.779, 0.626>, <0.7842, 2.2497, 12.2768>, <-0.291, -0.633, 0.718> }
	smooth_triangle { <1.5989, 3.1522, 13.3577>, <0.012, -0.772, 0.636>, <0.7842, 2.2497, 12.2768>, <-0.291, -0.633, 0.718>, <1.5431, 3.1704, 13.3809>, <-0.570, -0.394, 0.721> }
	smooth_triangle { <1.5431, 3.1704, 13.3809>, <-0.570, -0.394, 0.721>, <0.7842, 2.2497, 12.2768>, <-0.291, -0.633, 0.718>, <0.7556, 2.3011, 12.2536>, <-0.861, 0.156, 0.485> }
	smooth_triangle { <1.5431, 3.1704, 13.3809>, <-0.570, -0.394, 0.721>, <0.7556, 2.3011, 12.2536>, <-0.861, 0.156, 0.485>, <1.5145, 3.2217, 13.3577>, <-0.871, 0.429, 0.240> }
	smooth_triangle { <1.5145, 3.2217, 13.3577>, <-0.871, 0.429, 0.240>, <0.7556, 2.3011, 12.2536>, <-0.861, 0.156, 0.485>, <0.7829, 2.3342, 12.2072>, <-0.568, 0.791, -0.230> }
	smooth_triangle { <1.5145, 3.2217, 13.3577>, <-0.871, 0.429, 0.240>, <0.7829, 2.3342, 12.2072>, <-0.568, 0.791, -0.230>, <1.5418, 3.2548, 13.3113>, <-0.301, 0.824, -0.480> }
	smooth_triangle { <1.5418, 3.2548, 13.3113>, <-0.301, 0.824, -0.480>, <0.7829, 2.3342, 12.2072>, <-0.568, 0.791, -0.230>, <0.8388, 2.3159, 12.1841>, <0.295, 0.637, -0.712> }
	smooth_triangle { <1.5418, 3.2548, 13.3113>, <-0.301, 0.824, -0.480>, <0.8388, 2.3159, 12.1841>, <0.295, 0.637, -0.712>, <1.5977, 3.2366, 13.2882>, <0.570, 0.394, -0.721> }
	smooth_triangle { <1.5977, 3.2366, 13.2882>, <0.570, 0.394, -0.721>, <0.8388, 2.3159, 12.1841>, <0.295, 0.637, -0.712>, <0.8673, 2.2646, 12.2072>, <0.865, -0.151, -0.479> }
	smooth_triangle { <1.5977, 3.2366, 13.2882>, <0.570, 0.394, -0.721>, <0.8673, 2.2646, 12.2072>, <0.865, -0.151, -0.479>, <1.6262, 3.1853, 13.3113>, <0.871, -0.429, -0.240> }
	smooth_triangle { <1.6262, 3.1853, 13.3113>, <0.871, -0.429, -0.240>, <0.8673, 2.2646, 12.2072>, <0.865, -0.151, -0.479>, <0.8400, 2.2315, 12.2536>, <0.756, -0.654, 0.000> }
	smooth_triangle { <1.6262, 3.1853, 13.3113>, <0.871, -0.429, -0.240>, <0.8400, 2.2315, 12.2536>, <0.756, -0.654, 0.000>, <1.5989, 3.1522, 13.3577>, <0.772, -0.636, 0.000> }
	smooth_triangle { <3.0207, 4.6347, 15.3199>, <-0.010, -0.744, 0.668>, <0.8400, 2.2315, 12.2536>, <0.005, -0.779, 0.626>, <0.7842, 2.2497, 12.2768>, <-0.291, -0.633, 0.718> }
	smooth_triangle { <3.0207, 4.6347, 15.3199>, <-0.010, -0.744, 0.668>, <0.7842, 2.2497, 12.2768>, <-0.291, -0.633, 0.718>, <2.9989, 4.6440, 15.3290>, <-0.425, -0.482, 0.766> }
	smooth_triangle { <2.9989, 4.6440, 15.3290>, <-0.425, -0.482, 0.766>, <0.7842, 2.2497, 12.2768>, <-0.291, -0.633, 0.718>, <0.7556, 2.3011, 12.2536>, <-0.861, 0.156, 0.485> }
	smooth_triangle { <2.9989, 4.6440, 15.3290>, <-0.542, -0.400, 0.739>, <0.7556, 2.3011, 12.2536>, <-0.861, 0.156, 0.485>, <2.9895, 4.6657, 15.3199>, <-0.894, 0.291, 0.340> }
	smooth_triangle { <2.9895, 4.6657, 15.3199>, <-0.894, 0.291, 0.340>, <0.7556, 2.3011, 12.2536>, <-0.861, 0.156, 0.485>, <0.7829, 2.3342, 12.2072>, <-0.568, 0.791, -0.230> }
	smooth_triangle { <2.9895, 4.6657, 15.3199>, <-0.885, 0.398, 0.242>, <0.7829, 2.3342, 12.2072>, <-0.568, 0.791, -0.230>, <3.0019, 4.6782, 15.3016>, <-0.467, 0.776, -0.424> }
	smooth_triangle { <3.0019, 4.6782, 15.3016>, <-0.467, 0.776, -0.424>, <0.7829, 2.3342, 12.2072>, <-0.568, 0.791, -0.230>, <0.8388, 2.3159, 12.1841>, <0.295, 0.637, -0.712> }
	smooth_triangle { <3.0019, 4.6782, 15.3016>, <-0.340, 0.801, -0.493>, <0.8388, 2.3159, 12.1841>, <0.295, 0.637, -0.712>, <3.0237, 4.6690, 15.2924>, <0.430, 0.487, -0.760> }
	smooth_triangle { <3.0237, 4.6690, 15.2924>, <0.430, 0.487, -0.760>, <0.8388, 2.3159, 12.1841>, <0.295, 0.637, -0.712>, <0.8673, 2.2646, 12.2072>, <0.865, -0.151, -0.479> }
	smooth_triangle { <3.0237, 4.6690, 15.2924>, <0.548, 0.406, -0.731>, <0.8673, 2.2646, 12.2072>, <0.865, -0.151, -0.479>, <3.0331, 4.6473, 15.3016>, <0.898, -0.286, -0.334> }
	smooth_triangle { <3.0331, 4.6473, 15.3016>, <0.898, -0.286, -0.334>, <0.8673, 2.2646, 12.2072>, <0.865, -0.151, -0.479>, <0.8400, 2.2315, 12.2536>, <0.756, -0.654, 0.000> }
	smooth_triangle { <3.0331, 4.6473, 15.3016>, <0.890, -0.392, -0.234>, <0.8400, 2.2315, 12.2536>, <0.756, -0.654, 0.000>, <3.0207, 4.6347, 15.3199>, <0.818, -0.572, 0.064> }
	smooth_triangle { <4.0293, 6.6245, 17.0951>, <0.142, -0.703, 0.697>, <3.0207, 4.6347, 15.3199>, <-0.010, -0.744, 0.668>, <2.9989, 4.6440, 15.3290>, <-0.425, -0.482, 0.766> }
	smooth_triangle { <4.0293, 6.6245, 17.0951>, <0.142, -0.703, 0.697>, <2.9989, 4.6440, 15.3290>, <-0.162, -0.635, 0.755>, <4.0061, 6.6273, 17.1051>, <-0.177, -0.622, 0.763> }
	smooth_triangle { <4.0061, 6.6273, 17.1051>, <-0.740, -0.221, 0.636>, <2.9989, 4.6440, 15.3290>, <-0.542, -0.400, 0.739>, <2.9895, 4.6657, 15.3199>, <-0.894, 0.291, 0.340> }
	smooth_triangle { <4.0061, 6.6273, 17.1051>, <-0.313, -0.556, 0.770>, <2.9895, 4.6657, 15.3199>, <-0.844, 0.063, 0.533>, <3.9901, 6.6443, 17.0951>, <-0.894, 0.001, 0.448> }
	smooth_triangle { <3.9901, 6.6443, 17.0951>, <-0.875, 0.481, -0.064>, <2.9895, 4.6657, 15.3199>, <-0.885, 0.398, 0.242>, <3.0019, 4.6782, 15.3016>, <-0.467, 0.776, -0.424> }
	smooth_triangle { <3.9901, 6.6443, 17.0951>, <-0.929, 0.112, 0.352>, <3.0019, 4.6782, 15.3016>, <-0.678, 0.701, -0.221>, <3.9972, 6.6585, 17.0753>, <-0.717, 0.622, -0.315> }
	smooth_triangle { <3.9972, 6.6585, 17.0753>, <-0.142, 0.703, -0.697>, <3.0019, 4.6782, 15.3016>, <-0.340, 0.801, -0.493>, <3.0237, 4.6690, 15.2924>, <0.430, 0.487, -0.760> }
	smooth_triangle { <3.9972, 6.6585, 17.0753>, <-0.619, 0.666, -0.416>, <3.0237, 4.6690, 15.2924>, <0.166, 0.640, -0.750>, <4.0204, 6.6556, 17.0654>, <0.177, 0.621, -0.764> }
	smooth_triangle { <4.0204, 6.6556, 17.0654>, <0.740, 0.221, -0.635>, <3.0237, 4.6690, 15.2924>, <0.548, 0.406, -0.731>, <3.0331, 4.6473, 15.3016>, <0.898, -0.286, -0.334> }
	smooth_triangle { <4.0204, 6.6556, 17.0654>, <0.313, 0.555, -0.771>, <3.0331, 4.6473, 15.3016>, <0.848, -0.058, -0.527>, <4.0365, 6.6386, 17.0753>, <0.894, -0.002, -0.449> }
	smooth_triangle { <4.0365, 6.6386, 17.0753>, <0.875, -0.481, 0.064>, <3.0331, 4.6473, 15.3016>, <0.890, -0.392, -0.234>, <3.0207, 4.6347, 15.3199>, <0.818, -0.572, 0.064> }
	smooth_triangle { <4.0365, 6.6386, 17.0753>, <0.929, -0.112, -0.353>, <3.0207, 4.6347, 15.3199>, <0.818, -0.572, 0.064>, <4.0293, 6.6245, 17.0951>, <0.904, -0.427, 0.008> }
	smooth_triangle { <4.6518, 8.0288, 18.4258>, <0.329, -0.873, 0.361>, <4.0293, 6.6245, 17.0951>, <0.142, -0.703, 0.697>, <4.0061, 6.6273, 17.1051>, <-0.177, -0.622, 0.763> }
	smooth_triangle { <4.6518, 8.0288, 18.4258>, <0.329, -0.873, 0.361>, <4.0061, 6.6273, 17.1051>, <-0.177, -0.622, 0.763>, <4.6283, 8.0301, 18.4354>, <-0.430, -0.628, 0.649> }
	smooth_triangle { <4.6283, 8.0301, 18.4354>, <-0.430, -0.628, 0.649>, <4.0061, 6.6273, 17.1051>, <-0.313, -0.556, 0.770>, <3.9901, 6.6443, 17.0951>, <-0.894, 0.001, 0.448> }
	smooth_triangle { <4.6283, 8.0301, 18.4354>, <-0.430, -0.628, 0.649>, <3.9901, 6.6443, 17.0951>, <-0.894, 0.001, 0.448>, <4.6116, 8.0466, 18.4258>, <-0.915, 0.189, 0.356> }
	smooth_triangle { <4.6116, 8.0466, 18.4258>, <-0.915, 0.189, 0.356>, <3.9901, 6.6443, 17.0951>, <-0.929, 0.112, 0.352>, <3.9972, 6.6585, 17.0753>, <-0.717, 0.622, -0.315> }
	smooth_triangle { <4.6116, 8.0466, 18.4258>, <-0.915, 0.189, 0.356>, <3.9972, 6.6585, 17.0753>, <-0.717, 0.622, -0.315>, <4.6183, 8.0618, 18.4066>, <-0.484, 0.824, -0.293> }
	smooth_triangle { <4.6183, 8.0618, 18.4066>, <-0.484, 0.824, -0.293>, <3.9972, 6.6585, 17.0753>, <-0.619, 0.666, -0.416>, <4.0204, 6.6556, 17.0654>, <0.177, 0.621, -0.764> }
	smooth_triangle { <4.6183, 8.0618, 18.4066>, <-0.484, 0.824, -0.293>, <4.0204, 6.6556, 17.0654>, <0.177, 0.621, -0.764>, <4.6418, 8.0605, 18.3970>, <0.434, 0.633, -0.641> }
	smooth_triangle { <4.6418, 8.0605, 18.3970>, <0.434, 0.633, -0.641>, <4.0204, 6.6556, 17.0654>, <0.313, 0.555, -0.771>, <4.0365, 6.6386, 17.0753>, <0.894, -0.002, -0.449> }
	smooth_triangle { <4.6418, 8.0605, 18.3970>, <0.434, 0.633, -0.641>, <4.0365, 6.6386, 17.0753>, <0.894, -0.002, -0.449>, <4.6585, 8.0440, 18.4066>, <0.919, -0.183, -0.348> }
	smooth_triangle { <4.6585, 8.0440, 18.4066>, <0.919, -0.183, -0.348>, <4.0365, 6.6386, 17.0753>, <0.929, -0.112, -0.353>, <4.0293, 6.6245, 17.0951>, <0.904, -0.427, 0.008> }
	smooth_triangle { <4.6585, 8.0440, 18.4066>, <0.919, -0.183, -0.348>, <4.0293, 6.6245, 17.0951>, <0.904, -0.427, 0.008>, <4.6518, 8.0288, 18.4258>, <0.914, -0.405, 0.000> }
	smooth_triangle { <5.7431, 8.4694, 20.0659>, <0.010, -0.966, 0.259>, <4.6518, 8.0288, 18.4258>, <0.329, -0.873, 0.361>, <4.6283, 8.0301, 18.4354>, <-0.430, -0.628, 0.649> }
	smooth_triangle { <5.7431, 8.4694, 20.0659>, <-0.718, -0.361, 0.595>, <4.6283, 8.0301, 18.4354>, <-0.430, -0.628, 0.649>, <4.6116, 8.0466, 18.4258>, <-0.915, 0.189, 0.356> }
	smooth_triangle { <5.7431, 8.4694, 20.0659>, <-0.705, 0.627, 0.330>, <4.6116, 8.0466, 18.4258>, <-0.915, 0.189, 0.356>, <4.6183, 8.0618, 18.4066>, <-0.484, 0.824, -0.293> }
	smooth_triangle { <5.7431, 8.4694, 20.0659>, <0.003, 0.972, -0.234>, <4.6183, 8.0618, 18.4066>, <-0.484, 0.824, -0.293>, <4.6418, 8.0605, 18.3970>, <0.434, 0.633, -0.641> }
	smooth_triangle { <5.7431, 8.4694, 20.0659>, <0.731, 0.376, -0.569>, <4.6418, 8.0605, 18.3970>, <0.434, 0.633, -0.641>, <4.6585, 8.0440, 18.4066>, <0.919, -0.183, -0.348> }
	smooth_triangle { <5.7431, 8.4694, 20.0659>, <0.724, -0.617, -0.309>, <4.6585, 8.0440, 18.4066>, <0.919, -0.183, -0.348>, <4.6518, 8.0288, 18.4258>, <0.329, -0.873, 0.361> }
	smooth_triangle { <3.2089, 4.4729, 16.9140>, <-0.979, 0.135, 0.150>, <2.9879, 4.6469, 15.3129>, <-0.988, 0.146, 0.040>, <2.9917, 4.6720, 15.3151>, <-0.860, 0.510, -0.003> }
	smooth_triangle { <3.2089, 4.4729, 16.9140>, <-0.979, 0.135, 0.150>, <2.9917, 4.6720, 15.3151>, <-0.860, 0.510, -0.003>, <3.2127, 4.4979, 16.9162>, <-0.643, 0.747, 0.170> }
	smooth_triangle { <3.2127, 4.4979, 16.9162>, <-0.643, 0.747, 0.170>, <2.9917, 4.6720, 15.3151>, <-0.860, 0.510, -0.003>, <3.0151, 4.6815, 15.3129>, <0.012, 0.995, -0.104> }
	smooth_triangle { <3.2127, 4.4979, 16.9162>, <-0.643, 0.747, 0.170>, <3.0151, 4.6815, 15.3129>, <0.012, 0.995, -0.104>, <3.2361, 4.5074, 16.9140>, <0.331, 0.942, 0.057> }
	smooth_triangle { <3.2361, 4.5074, 16.9140>, <0.331, 0.942, 0.057>, <3.0151, 4.6815, 15.3129>, <0.012, 0.995, -0.104>, <3.0348, 4.6660, 15.3085>, <0.872, 0.480, -0.094> }
	smooth_triangle { <3.2361, 4.5074, 16.9140>, <0.331, 0.942, 0.057>, <3.0348, 4.6660, 15.3085>, <0.872, 0.480, -0.094>, <3.2558, 4.4919, 16.9096>, <0.974, 0.195, -0.113> }
	smooth_triangle { <3.2558, 4.4919, 16.9096>, <0.974, 0.195, -0.113>, <3.0348, 4.6660, 15.3085>, <0.872, 0.480, -0.094>, <3.0310, 4.6410, 15.3063>, <0.860, -0.509, 0.014> }
	smooth_triangle { <3.2558, 4.4919, 16.9096>, <0.974, 0.195, -0.113>, <3.0310, 4.6410, 15.3063>, <0.860, -0.509, 0.014>, <3.2520, 4.4669, 16.9074>, <0.643, -0.747, -0.170> }
	smooth_triangle { <3.2520, 4.4669, 16.9074>, <0.643, -0.747, -0.170>, <3.0310, 4.6410, 15.3063>, <0.860, -0.509, 0.014>, <3.0075, 4.6315, 15.3085>, <-0.010, -0.993, 0.114> }
	smooth_triangle { <3.2520, 4.4669, 16.9074>, <0.643, -0.747, -0.170>, <3.0075, 4.6315, 15.3085>, <-0.010, -0.993, 0.114>, <3.2285, 4.4574, 16.9096>, <-0.331, -0.942, -0.057> }
	smooth_triangle { <3.2285, 4.4574, 16.9096>, <-0.331, -0.942, -0.057>, <3.0075, 4.6315, 15.3085>, <-0.010, -0.993, 0.114>, <2.9879, 4.6469, 15.3129>, <-0.596, -0.793, 0.126> }
	smooth_triangle { <3.2285, 4.4574, 16.9096>, <-0.331, -0.942, -0.057>, <2.9879, 4.6469, 15.3129>, <-0.596, -0.793, 0.126>, <3.2089, 4.4729, 16.9140>, <-0.619, -0.786, 0.000> }
	smooth_triangle { <2.9978, 6.4015, 18.9988>, <-0.985, 0.155, -0.071>, <2.9879, 4.6469, 15.3129>, <-0.988, 0.146, 0.040>, <2.9917, 4.6720, 15.3151>, <-0.860, 0.510, -0.003> }
	smooth_triangle { <2.9978, 6.4015, 18.9988>, <0.557, -0.809, 0.191>, <2.9917, 4.6720, 15.3151>, <0.580, -0.738, 0.345>, <2.9772, 6.3894, 19.0075>, <0.148, -0.974, 0.173> }
	smooth_triangle { <2.9772, 6.3894, 19.0075>, <0.074, 0.992, -0.106>, <2.9917, 4.6720, 15.3151>, <-0.860, 0.510, -0.003>, <3.0151, 4.6815, 15.3129>, <0.012, 0.995, -0.104> }
	smooth_triangle { <2.9772, 6.3894, 19.0075>, <0.148, -0.974, 0.173>, <3.0151, 4.6815, 15.3129>, <-0.375, -0.843, 0.386>, <2.9542, 6.3957, 18.9988>, <-0.738, -0.675, 0.003> }
	smooth_triangle { <2.9542, 6.3957, 18.9988>, <0.897, 0.434, -0.084>, <3.0151, 4.6815, 15.3129>, <0.012, 0.995, -0.104>, <3.0348, 4.6660, 15.3085>, <0.872, 0.480, -0.094> }
	smooth_triangle { <2.9542, 6.3957, 18.9988>, <-0.866, -0.496, 0.065>, <3.0348, 4.6660, 15.3085>, <-0.994, -0.106, 0.028>, <2.9517, 6.4141, 18.9814>, <-0.920, 0.349, -0.177> }
	smooth_triangle { <2.9517, 6.4141, 18.9814>, <0.814, -0.579, 0.046>, <3.0348, 4.6660, 15.3085>, <0.872, 0.480, -0.094>, <3.0310, 4.6410, 15.3063>, <0.860, -0.509, 0.014> }
	smooth_triangle { <2.9517, 6.4141, 18.9814>, <-0.920, 0.349, -0.177>, <3.0310, 4.6410, 15.3063>, <-0.582, 0.728, -0.364>, <2.9723, 6.4262, 18.9728>, <-0.148, 0.975, -0.167> }
	smooth_triangle { <2.9723, 6.4262, 18.9728>, <-0.072, -0.992, 0.102>, <3.0310, 4.6410, 15.3063>, <0.860, -0.509, 0.014>, <3.0075, 4.6315, 15.3085>, <-0.010, -0.993, 0.114> }
	smooth_triangle { <2.9723, 6.4262, 18.9728>, <-0.148, 0.975, -0.167>, <3.0075, 4.6315, 15.3085>, <0.379, 0.832, -0.404>, <2.9953, 6.4199, 18.9814>, <0.735, 0.678, 0.002> }
	smooth_triangle { <2.9953, 6.4199, 18.9814>, <-0.898, -0.434, 0.079>, <3.0075, 4.6315, 15.3085>, <-0.010, -0.993, 0.114>, <2.9879, 4.6469, 15.3129>, <-0.596, -0.793, 0.126> }
	smooth_triangle { <2.9953, 6.4199, 18.9814>, <0.865, 0.497, -0.067>, <2.9879, 4.6469, 15.3129>, <0.995, 0.090, -0.046>, <2.9978, 6.4015, 18.9988>, <0.964, 0.239, 0.117> }
	smooth_triangle { <2.4148, 6.1326, 21.3475>, <0.517, -0.856, 0.030>, <2.9978, 6.4015, 18.9988>, <0.557, -0.809, 0.191>, <2.9772, 6.3894, 19.0075>, <0.148, -0.974, 0.173> }
	smooth_triangle { <2.4148, 6.1326, 21.3475>, <0.458, 0.806, 0.375>, <2.9772, 6.3894, 19.0075>, <0.074, 0.992, -0.106>, <2.4360, 6.1190, 21.3508>, <0.714, 0.468, 0.520> }
	smooth_triangle { <2.4360, 6.1190, 21.3508>, <-0.204, -0.966, -0.159>, <2.9772, 6.3894, 19.0075>, <0.148, -0.974, 0.173>, <2.9542, 6.3957, 18.9988>, <-0.566, -0.825, -0.007> }
	smooth_triangle { <2.4360, 6.1190, 21.3508>, <0.714, 0.468, 0.520>, <2.9542, 6.3957, 18.9988>, <0.897, 0.434, -0.084>, <2.4356, 6.0938, 21.3475>, <0.746, -0.529, 0.403> }
	smooth_triangle { <2.4356, 6.0938, 21.3475>, <-0.904, -0.352, -0.245>, <2.9542, 6.3957, 18.9988>, <-0.738, -0.675, 0.003>, <2.9517, 6.4141, 18.9814>, <-0.968, 0.105, -0.227> }
	smooth_triangle { <2.4356, 6.0938, 21.3475>, <0.746, -0.529, 0.403>, <2.9517, 6.4141, 18.9814>, <0.814, -0.579, 0.046>, <2.4139, 6.0822, 21.3408>, <0.033, -0.992, -0.123> }
	smooth_triangle { <2.4139, 6.0822, 21.3408>, <-0.505, 0.863, 0.006>, <2.9517, 6.4141, 18.9814>, <-0.808, 0.576, -0.128>, <2.9723, 6.4262, 18.9728>, <-0.148, 0.975, -0.167> }
	smooth_triangle { <2.4139, 6.0822, 21.3408>, <0.033, -0.992, -0.123>, <2.9723, 6.4262, 18.9728>, <-0.072, -0.992, 0.102>, <2.3927, 6.0958, 21.3375>, <-0.707, -0.464, -0.533> }
	smooth_triangle { <2.3927, 6.0958, 21.3375>, <0.194, 0.964, 0.182>, <2.9723, 6.4262, 18.9728>, <-0.148, 0.975, -0.167>, <2.9953, 6.4199, 18.9814>, <0.557, 0.830, 0.020> }
	smooth_triangle { <2.3927, 6.0958, 21.3375>, <-0.707, -0.464, -0.533>, <2.9953, 6.4199, 18.9814>, <-0.898, -0.434, 0.079>, <2.3932, 6.1210, 21.3408>, <-0.739, 0.529, -0.418> }
	smooth_triangle { <2.3932, 6.1210, 21.3408>, <0.885, 0.376, 0.274>, <2.9953, 6.4199, 18.9814>, <0.735, 0.678, 0.002>, <2.9978, 6.4015, 18.9988>, <0.964, 0.239, 0.117> }
	smooth_triangle { <2.3932, 6.1210, 21.3408>, <-0.739, 0.529, -0.418>, <2.9978, 6.4015, 18.9988>, <-0.469, 0.883, -0.015>, <2.4148, 6.1326, 21.3475>, <-0.350, 0.932, -0.090> }
	smooth_triangle { <0.7038, 5.8389, 23.0612>, <0.525, 0.657, 0.542>, <2.4148, 6.1326, 21.3475>, <0.458, 0.806, 0.375>, <2.4360, 6.1190, 21.3508>, <0.714, 0.468, 0.520> }
	smooth_triangle { <0.7038, 5.8389, 23.0612>, <0.525, 0.657, 0.542>, <2.4360, 6.1190, 21.3508>, <0.714, 0.468, 0.520>, <0.7162, 5.8187, 23.0703>, <0.754, 0.169, 0.635> }
	smooth_triangle { <0.7162, 5.8187, 23.0703>, <0.754, 0.169, 0.635>, <2.4360, 6.1190, 21.3508>, <0.714, 0.468, 0.520>, <2.4356, 6.0938, 21.3475>, <0.746, -0.529, 0.403> }
	smooth_triangle { <0.7162, 5.8187, 23.0703>, <0.754, 0.169, 0.635>, <2.4356, 6.0938, 21.3475>, <0.746, -0.529, 0.403>, <0.7112, 5.7955, 23.0612>, <0.547, -0.759, 0.352> }
	smooth_triangle { <0.7112, 5.7955, 23.0612>, <0.547, -0.759, 0.352>, <2.4356, 6.0938, 21.3475>, <0.746, -0.529, 0.403>, <2.4139, 6.0822, 21.3408>, <0.033, -0.992, -0.123> }
	smooth_triangle { <0.7112, 5.7955, 23.0612>, <0.547, -0.759, 0.352>, <2.4139, 6.0822, 21.3408>, <0.033, -0.992, -0.123>, <0.6936, 5.7925, 23.0431>, <-0.221, -0.929, -0.298> }
	smooth_triangle { <0.6936, 5.7925, 23.0431>, <-0.221, -0.929, -0.298>, <2.4139, 6.0822, 21.3408>, <0.033, -0.992, -0.123>, <2.3927, 6.0958, 21.3375>, <-0.707, -0.464, -0.533> }
	smooth_triangle { <0.6936, 5.7925, 23.0431>, <-0.221, -0.929, -0.298>, <2.3927, 6.0958, 21.3375>, <-0.707, -0.464, -0.533>, <0.6812, 5.8127, 23.0340>, <-0.753, -0.169, -0.636> }
	smooth_triangle { <0.6812, 5.8127, 23.0340>, <-0.753, -0.169, -0.636>, <2.3927, 6.0958, 21.3375>, <-0.707, -0.464, -0.533>, <2.3932, 6.1210, 21.3408>, <-0.739, 0.529, -0.418> }
	smooth_triangle { <0.6812, 5.8127, 23.0340>, <-0.753, -0.169, -0.636>, <2.3932, 6.1210, 21.3408>, <-0.739, 0.529, -0.418>, <0.6863, 5.8359, 23.0431>, <-0.547, 0.759, -0.353> }
	smooth_triangle { <0.6863, 5.8359, 23.0431>, <-0.547, 0.759, -0.353>, <2.3932, 6.1210, 21.3408>, <-0.739, 0.529, -0.418>, <2.4148, 6.1326, 21.3475>, <-0.350, 0.932, -0.090> }
	smooth_triangle { <0.6863, 5.8359, 23.0431>, <-0.547, 0.759, -0.353>, <2.4148, 6.1326, 21.3475>, <-0.350, 0.932, -0.090>, <0.7038, 5.8389, 23.0612>, <-0.129, 0.992, -0.011> }
	smooth_triangle { <-0.4183, 5.7421, 24.7482>, <0.690, 0.577, 0.436>, <0.7038, 5.8389, 23.0612>, <0.525, 0.657, 0.542>, <0.7162, 5.8187, 23.0703>, <0.754, 0.169, 0.635> }
	smooth_triangle { <-0.4183, 5.7421, 24.7482>, <0.690, 0.577, 0.436>, <0.7162, 5.8187, 23.0703>, <0.754, 0.169, 0.635>, <-0.4059, 5.7211, 24.7552>, <0.857, 0.044, 0.514> }
	smooth_triangle { <-0.4059, 5.7211, 24.7552>, <0.857, 0.044, 0.514>, <0.7162, 5.8187, 23.0703>, <0.754, 0.169, 0.635>, <0.7112, 5.7955, 23.0612>, <0.547, -0.759, 0.352> }
	smooth_triangle { <-0.4059, 5.7211, 24.7552>, <0.857, 0.044, 0.514>, <0.7112, 5.7955, 23.0612>, <0.547, -0.759, 0.352>, <-0.4146, 5.6983, 24.7482>, <0.452, -0.844, 0.288> }
	smooth_triangle { <-0.4146, 5.6983, 24.7482>, <0.452, -0.844, 0.288>, <0.7112, 5.7955, 23.0612>, <0.547, -0.759, 0.352>, <0.6936, 5.7925, 23.0431>, <-0.221, -0.929, -0.298> }
	smooth_triangle { <-0.4146, 5.6983, 24.7482>, <0.452, -0.844, 0.288>, <0.6936, 5.7925, 23.0431>, <-0.221, -0.929, -0.298>, <-0.4356, 5.6965, 24.7340>, <-0.406, -0.886, -0.226> }
	smooth_triangle { <-0.4356, 5.6965, 24.7340>, <-0.406, -0.886, -0.226>, <0.6936, 5.7925, 23.0431>, <-0.221, -0.929, -0.298>, <0.6812, 5.8127, 23.0340>, <-0.753, -0.169, -0.636> }
	smooth_triangle { <-0.4356, 5.6965, 24.7340>, <-0.406, -0.886, -0.226>, <0.6812, 5.8127, 23.0340>, <-0.753, -0.169, -0.636>, <-0.4480, 5.7175, 24.7270>, <-0.857, -0.044, -0.514> }
	smooth_triangle { <-0.4480, 5.7175, 24.7270>, <-0.857, -0.044, -0.514>, <0.6812, 5.8127, 23.0340>, <-0.753, -0.169, -0.636>, <0.6863, 5.8359, 23.0431>, <-0.547, 0.759, -0.353> }
	smooth_triangle { <-0.4480, 5.7175, 24.7270>, <-0.857, -0.044, -0.514>, <0.6863, 5.8359, 23.0431>, <-0.547, 0.759, -0.353>, <-0.4394, 5.7403, 24.7340>, <-0.452, 0.844, -0.289> }
	smooth_triangle { <-0.4394, 5.7403, 24.7340>, <-0.452, 0.844, -0.289>, <0.6863, 5.8359, 23.0431>, <-0.547, 0.759, -0.353>, <0.7038, 5.8389, 23.0612>, <-0.129, 0.992, -0.011> }
	smooth_triangle { <-0.4394, 5.7403, 24.7340>, <-0.452, 0.844, -0.289>, <0.7038, 5.8389, 23.0612>, <-0.129, 0.992, -0.011>, <-0.4183, 5.7421, 24.7482>, <0.030, 0.999, -0.037> }
	smooth_triangle { <-1.4062, 5.9250, 26.5099>, <0.565, 0.624, 0.540>, <-0.4183, 5.7421, 24.7482>, <0.690, 0.577, 0.436>, <-0.4059, 5.7211, 24.7552>, <0.857, 0.044, 0.514> }
	smooth_triangle { <-1.4062, 5.9250, 26.5099>, <0.565, 0.624, 0.540>, <-0.4059, 5.7211, 24.7552>, <0.857, 0.044, 0.514>, <-1.3994, 5.9013, 26.5162>, <0.721, -0.216, 0.659> }
	smooth_triangle { <-1.3994, 5.9013, 26.5162>, <0.721, -0.216, 0.659>, <-0.4059, 5.7211, 24.7552>, <0.857, 0.044, 0.514>, <-0.4146, 5.6983, 24.7482>, <0.452, -0.844, 0.288> }
	smooth_triangle { <-1.3994, 5.9013, 26.5162>, <0.721, -0.216, 0.659>, <-0.4146, 5.6983, 24.7482>, <0.452, -0.844, 0.288>, <-1.4142, 5.8817, 26.5099>, <0.210, -0.953, 0.219> }
	smooth_triangle { <-1.4142, 5.8817, 26.5099>, <0.210, -0.953, 0.219>, <-0.4146, 5.6983, 24.7482>, <0.452, -0.844, 0.288>, <-0.4356, 5.6965, 24.7340>, <-0.406, -0.886, -0.226> }
	smooth_triangle { <-1.4142, 5.8817, 26.5099>, <0.210, -0.953, 0.219>, <-0.4356, 5.6965, 24.7340>, <-0.406, -0.886, -0.226>, <-1.4359, 5.8858, 26.4972>, <-0.512, -0.740, -0.436> }
	smooth_triangle { <-1.4359, 5.8858, 26.4972>, <-0.512, -0.740, -0.436>, <-0.4356, 5.6965, 24.7340>, <-0.406, -0.886, -0.226>, <-0.4480, 5.7175, 24.7270>, <-0.857, -0.044, -0.514> }
	smooth_triangle { <-1.4359, 5.8858, 26.4972>, <-0.512, -0.740, -0.436>, <-0.4480, 5.7175, 24.7270>, <-0.857, -0.044, -0.514>, <-1.4427, 5.9094, 26.4909>, <-0.727, 0.217, -0.651> }
	smooth_triangle { <-1.4427, 5.9094, 26.4909>, <-0.727, 0.217, -0.651>, <-0.4480, 5.7175, 24.7270>, <-0.857, -0.044, -0.514>, <-0.4394, 5.7403, 24.7340>, <-0.452, 0.844, -0.289> }
	smooth_triangle { <-1.4427, 5.9094, 26.4909>, <-0.727, 0.217, -0.651>, <-0.4394, 5.7403, 24.7340>, <-0.452, 0.844, -0.289>, <-1.4278, 5.9290, 26.4972>, <-0.217, 0.953, -0.210> }
	smooth_triangle { <-1.4278, 5.9290, 26.4972>, <-0.217, 0.953, -0.210>, <-0.4394, 5.7403, 24.7340>, <-0.452, 0.844, -0.289>, <-0.4183, 5.7421, 24.7482>, <0.030, 0.999, -0.037> }
	smooth_triangle { <-1.4278, 5.9290, 26.4972>, <-0.217, 0.953, -0.210>, <-0.4183, 5.7421, 24.7482>, <0.030, 0.999, -0.037>, <-1.4062, 5.9250, 26.5099>, <0.184, 0.983, 0.001> }
	smooth_triangle { <-3.1664, 5.6438, 27.5106>, <0.418, 0.341, 0.842>, <-1.4062, 5.9250, 26.5099>, <0.565, 0.624, 0.540>, <-1.3994, 5.9013, 26.5162>, <0.721, -0.216, 0.659> }
	smooth_triangle { <-3.1664, 5.6438, 27.5106>, <0.448, -0.617, 0.647>, <-1.3994, 5.9013, 26.5162>, <0.721, -0.216, 0.659>, <-1.4142, 5.8817, 26.5099>, <0.210, -0.953, 0.219> }
	smooth_triangle { <-3.1664, 5.6438, 27.5106>, <0.002, -0.976, -0.219>, <-1.4142, 5.8817, 26.5099>, <0.210, -0.953, 0.219>, <-1.4359, 5.8858, 26.4972>, <-0.512, -0.740, -0.436> }
	smooth_triangle { <-3.1664, 5.6438, 27.5106>, <-0.442, -0.345, -0.828>, <-1.4359, 5.8858, 26.4972>, <-0.512, -0.740, -0.436>, <-1.4427, 5.9094, 26.4909>, <-0.727, 0.217, -0.651> }
	smooth_triangle { <-3.1664, 5.6438, 27.5106>, <-0.473, 0.619, -0.627>, <-1.4427, 5.9094, 26.4909>, <-0.727, 0.217, -0.651>, <-1.4278, 5.9290, 26.4972>, <-0.217, 0.953, -0.210> }
	smooth_triangle { <-3.1664, 5.6438, 27.5106>, <-0.024, 0.970, 0.241>, <-1.4278, 5.9290, 26.4972>, <-0.217, 0.953, -0.210>, <-1.4062, 5.9250, 26.5099>, <0.565, 0.624, 0.540> }
	smooth_triangle { <4.3205, 4.4547, 16.2533>, <-0.560, -0.428, 0.709>, <3.0011, 4.6357, 15.3211>, <-0.590, -0.423, 0.688>, <2.9969, 4.6585, 15.3315>, <-0.595, -0.084, 0.799> }
	smooth_triangle { <4.3205, 4.4547, 16.2533>, <-0.560, -0.428, 0.709>, <2.9969, 4.6585, 15.3315>, <-0.595, -0.084, 0.799>, <4.3163, 4.4775, 16.2637>, <-0.532, 0.264, 0.804> }
	smooth_triangle { <4.3163, 4.4775, 16.2637>, <-0.532, 0.264, 0.804>, <2.9969, 4.6585, 15.3315>, <-0.595, -0.084, 0.799>, <3.0071, 4.6793, 15.3211>, <-0.220, 0.808, 0.547> }
	smooth_triangle { <4.3163, 4.4775, 16.2637>, <-0.532, 0.264, 0.804>, <3.0071, 4.6793, 15.3211>, <-0.220, 0.808, 0.547>, <4.3265, 4.4983, 16.2533>, <-0.058, 0.962, 0.268> }
	smooth_triangle { <4.3265, 4.4983, 16.2533>, <-0.058, 0.962, 0.268>, <3.0071, 4.6793, 15.3211>, <-0.220, 0.808, 0.547>, <3.0215, 4.6773, 15.3003>, <0.376, 0.892, -0.253> }
	smooth_triangle { <4.3265, 4.4983, 16.2533>, <-0.058, 0.962, 0.268>, <3.0215, 4.6773, 15.3003>, <0.376, 0.892, -0.253>, <4.3410, 4.4964, 16.2325>, <0.475, 0.698, -0.536> }
	smooth_triangle { <4.3410, 4.4964, 16.2325>, <0.475, 0.698, -0.536>, <3.0215, 4.6773, 15.3003>, <0.376, 0.892, -0.253>, <3.0257, 4.6545, 15.2899>, <0.595, 0.084, -0.799> }
	smooth_triangle { <4.3410, 4.4964, 16.2325>, <0.475, 0.698, -0.536>, <3.0257, 4.6545, 15.2899>, <0.595, 0.084, -0.799>, <4.3452, 4.4736, 16.2221>, <0.532, -0.264, -0.804> }
	smooth_triangle { <4.3452, 4.4736, 16.2221>, <0.532, -0.264, -0.804>, <3.0257, 4.6545, 15.2899>, <0.595, 0.084, -0.799>, <3.0155, 4.6337, 15.3003>, <0.219, -0.808, -0.547> }
	smooth_triangle { <4.3452, 4.4736, 16.2221>, <0.532, -0.264, -0.804>, <3.0155, 4.6337, 15.3003>, <0.219, -0.808, -0.547>, <4.3350, 4.4528, 16.2325>, <0.058, -0.962, -0.268> }
	smooth_triangle { <4.3350, 4.4528, 16.2325>, <0.058, -0.962, -0.268>, <3.0155, 4.6337, 15.3003>, <0.219, -0.808, -0.547>, <3.0011, 4.6357, 15.3211>, <-0.206, -0.978, -0.008> }
	smooth_triangle { <4.3350, 4.4528, 16.2325>, <0.058, -0.962, -0.268>, <3.0011, 4.6357, 15.3211>, <-0.206, -0.978, -0.008>, <4.3205, 4.4547, 16.2533>, <-0.136, -0.991, 0.000> }
	smooth_triangle { <6.4714, 3.6025, 17.9009>, <-0.640, -0.328, 0.695>, <3.0011, 4.6357, 15.3211>, <-0.590, -0.423, 0.688>, <2.9969, 4.6585, 15.3315>, <-0.595, -0.084, 0.799> }
	smooth_triangle { <6.4714, 3.6025, 17.9009>, <-0.640, -0.328, 0.695>, <2.9969, 4.6585, 15.3315>, <-0.595, -0.084, 0.799>, <6.4727, 3.6257, 17.9113>, <-0.561, 0.198, 0.803> }
	smooth_triangle { <6.4727, 3.6257, 17.9113>, <-0.561, 0.198, 0.803>, <2.9969, 4.6585, 15.3315>, <-0.595, -0.084, 0.799>, <3.0071, 4.6793, 15.3211>, <-0.220, 0.808, 0.547> }
	smooth_triangle { <6.4727, 3.6257, 17.9113>, <-0.561, 0.198, 0.803>, <3.0071, 4.6793, 15.3211>, <-0.220, 0.808, 0.547>, <6.4876, 3.6434, 17.9009>, <0.005, 0.916, 0.400> }
	smooth_triangle { <6.4876, 3.6434, 17.9009>, <0.005, 0.916, 0.400>, <3.0071, 4.6793, 15.3211>, <-0.220, 0.808, 0.547>, <3.0215, 4.6773, 15.3003>, <0.376, 0.892, -0.253> }
	smooth_triangle { <6.4876, 3.6434, 17.9009>, <0.005, 0.916, 0.400>, <3.0215, 4.6773, 15.3003>, <0.376, 0.892, -0.253>, <6.5013, 3.6380, 17.8802>, <0.566, 0.719, -0.403> }
	smooth_triangle { <6.5013, 3.6380, 17.8802>, <0.566, 0.719, -0.403>, <3.0215, 4.6773, 15.3003>, <0.376, 0.892, -0.253>, <3.0257, 4.6545, 15.2899>, <0.595, 0.084, -0.799> }
	smooth_triangle { <6.5013, 3.6380, 17.8802>, <0.566, 0.719, -0.403>, <3.0257, 4.6545, 15.2899>, <0.595, 0.084, -0.799>, <6.5000, 3.6148, 17.8699>, <0.561, -0.198, -0.803> }
	smooth_triangle { <6.5000, 3.6148, 17.8699>, <0.561, -0.198, -0.803>, <3.0257, 4.6545, 15.2899>, <0.595, 0.084, -0.799>, <3.0155, 4.6337, 15.3003>, <0.219, -0.808, -0.547> }
	smooth_triangle { <6.5000, 3.6148, 17.8699>, <0.561, -0.198, -0.803>, <3.0155, 4.6337, 15.3003>, <0.219, -0.808, -0.547>, <6.4851, 3.5971, 17.8802>, <-0.005, -0.916, -0.400> }
	smooth_triangle { <6.4851, 3.5971, 17.8802>, <-0.005, -0.916, -0.400>, <3.0155, 4.6337, 15.3003>, <0.219, -0.808, -0.547>, <3.0011, 4.6357, 15.3211>, <-0.206, -0.978, -0.008> }
	smooth_triangle { <6.4851, 3.5971, 17.8802>, <-0.005, -0.916, -0.400>, <3.0011, 4.6357, 15.3211>, <-0.206, -0.978, -0.008>, <6.4714, 3.6025, 17.9009>, <-0.355, -0.935, 0.012> }
	smooth_triangle { <8.2775, 2.8661, 19.3635>, <-0.751, -0.444, 0.489>, <6.4714, 3.6025, 17.9009>, <-0.640, -0.328, 0.695>, <6.4727, 3.6257, 17.9113>, <-0.561, 0.198, 0.803> }
	smooth_triangle { <8.2775, 2.8661, 19.3635>, <-0.751, -0.444, 0.489>, <6.4727, 3.6257, 17.9113>, <-0.561, 0.198, 0.803>, <8.2787, 2.8894, 19.3737>, <-0.660, 0.394, 0.640> }
	smooth_triangle { <8.2787, 2.8894, 19.3737>, <-0.660, 0.394, 0.640>, <6.4727, 3.6257, 17.9113>, <-0.561, 0.198, 0.803>, <6.4876, 3.6434, 17.9009>, <0.005, 0.916, 0.400> }
	smooth_triangle { <8.2787, 2.8894, 19.3737>, <-0.660, 0.394, 0.640>, <6.4876, 3.6434, 17.9009>, <0.005, 0.916, 0.400>, <8.2941, 2.9069, 19.3635>, <0.053, 0.970, 0.237> }
	smooth_triangle { <8.2941, 2.9069, 19.3635>, <0.053, 0.970, 0.237>, <6.4876, 3.6434, 17.9009>, <0.005, 0.916, 0.400>, <6.5013, 3.6380, 17.8802>, <0.566, 0.719, -0.403> }
	smooth_triangle { <8.2941, 2.9069, 19.3635>, <0.053, 0.970, 0.237>, <6.5013, 3.6380, 17.8802>, <0.566, 0.719, -0.403>, <8.3082, 2.9011, 19.3432>, <0.712, 0.579, -0.396> }
	smooth_triangle { <8.3082, 2.9011, 19.3432>, <0.712, 0.579, -0.396>, <6.5013, 3.6380, 17.8802>, <0.566, 0.719, -0.403>, <6.5000, 3.6148, 17.8699>, <0.561, -0.198, -0.803> }
	smooth_triangle { <8.3082, 2.9011, 19.3432>, <0.712, 0.579, -0.396>, <6.5000, 3.6148, 17.8699>, <0.561, -0.198, -0.803>, <8.3069, 2.8779, 19.3330>, <0.664, -0.396, -0.634> }
	smooth_triangle { <8.3069, 2.8779, 19.3330>, <0.664, -0.396, -0.634>, <6.5000, 3.6148, 17.8699>, <0.561, -0.198, -0.803>, <6.4851, 3.5971, 17.8802>, <-0.005, -0.916, -0.400> }
	smooth_triangle { <8.3069, 2.8779, 19.3330>, <0.664, -0.396, -0.634>, <6.4851, 3.5971, 17.8802>, <-0.005, -0.916, -0.400>, <8.2916, 2.8604, 19.3432>, <-0.047, -0.972, -0.231> }
	smooth_triangle { <8.2916, 2.8604, 19.3432>, <-0.047, -0.972, -0.231>, <6.4851, 3.5971, 17.8802>, <-0.005, -0.916, -0.400>, <6.4714, 3.6025, 17.9009>, <-0.355, -0.935, 0.012> }
	smooth_triangle { <8.2916, 2.8604, 19.3432>, <-0.047, -0.972, -0.231>, <6.4714, 3.6025, 17.9009>, <-0.355, -0.935, 0.012>, <8.2775, 2.8661, 19.3635>, <-0.378, -0.926, 0.000> }
	smooth_triangle { <9.0903, 2.5781, 21.6373>, <-0.936, -0.146, 0.320>, <8.2775, 2.8661, 19.3635>, <-0.751, -0.444, 0.489>, <8.2787, 2.8894, 19.3737>, <-0.660, 0.394, 0.640> }
	smooth_triangle { <9.0903, 2.5781, 21.6373>, <-0.572, 0.758, 0.314>, <8.2787, 2.8894, 19.3737>, <-0.660, 0.394, 0.640>, <8.2941, 2.9069, 19.3635>, <0.053, 0.970, 0.237> }
	smooth_triangle { <9.0903, 2.5781, 21.6373>, <0.380, 0.925, 0.005>, <8.2941, 2.9069, 19.3635>, <0.053, 0.970, 0.237>, <8.3082, 2.9011, 19.3432>, <0.712, 0.579, -0.396> }
	smooth_triangle { <9.0903, 2.5781, 21.6373>, <0.944, 0.140, -0.298>, <8.3082, 2.9011, 19.3432>, <0.712, 0.579, -0.396>, <8.3069, 2.8779, 19.3330>, <0.664, -0.396, -0.634> }
	smooth_triangle { <9.0903, 2.5781, 21.6373>, <0.582, -0.759, -0.292>, <8.3069, 2.8779, 19.3330>, <0.664, -0.396, -0.634>, <8.2916, 2.8604, 19.3432>, <-0.047, -0.972, -0.231> }
	smooth_triangle { <9.0903, 2.5781, 21.6373>, <-0.365, -0.931, 0.017>, <8.2916, 2.8604, 19.3432>, <-0.047, -0.972, -0.231>, <8.2775, 2.8661, 19.3635>, <-0.751, -0.444, 0.489> }
	smooth_triangle { <4.5567, 4.7796, 15.8006>, <-0.207, -0.522, 0.828>, <3.0097, 4.6342, 15.3229>, <-0.253, -0.525, 0.812>, <3.0039, 4.6558, 15.3350>, <-0.329, -0.228, 0.916> }
	smooth_triangle { <4.5567, 4.7796, 15.8006>, <-0.207, -0.522, 0.828>, <3.0039, 4.6558, 15.3350>, <-0.329, -0.228, 0.916>, <4.5509, 4.8012, 15.8127>, <-0.305, 0.161, 0.939> }
	smooth_triangle { <4.5509, 4.8012, 15.8127>, <-0.305, 0.161, 0.939>, <3.0039, 4.6558, 15.3350>, <-0.329, -0.228, 0.916>, <3.0055, 4.6780, 15.3229>, <-0.325, 0.724, 0.609> }
	smooth_triangle { <4.5509, 4.8012, 15.8127>, <-0.305, 0.161, 0.939>, <3.0055, 4.6780, 15.3229>, <-0.325, 0.724, 0.609>, <4.5525, 4.8234, 15.8006>, <-0.184, 0.932, 0.313> }
	smooth_triangle { <4.5525, 4.8234, 15.8006>, <-0.184, 0.932, 0.313>, <3.0055, 4.6780, 15.3229>, <-0.325, 0.724, 0.609>, <3.0130, 4.6787, 15.2986>, <0.004, 0.952, -0.308> }
	smooth_triangle { <4.5525, 4.8234, 15.8006>, <-0.184, 0.932, 0.313>, <3.0130, 4.6787, 15.2986>, <0.004, 0.952, -0.308>, <4.5600, 4.8241, 15.7763>, <0.121, 0.771, -0.626> }
	smooth_triangle { <4.5600, 4.8241, 15.7763>, <0.121, 0.771, -0.626>, <3.0130, 4.6787, 15.2986>, <0.004, 0.952, -0.308>, <3.0188, 4.6572, 15.2864>, <0.329, 0.228, -0.916> }
	smooth_triangle { <4.5600, 4.8241, 15.7763>, <0.121, 0.771, -0.626>, <3.0188, 4.6572, 15.2864>, <0.329, 0.228, -0.916>, <4.5658, 4.8026, 15.7642>, <0.305, -0.161, -0.939> }
	smooth_triangle { <4.5658, 4.8026, 15.7642>, <0.305, -0.161, -0.939>, <3.0188, 4.6572, 15.2864>, <0.329, 0.228, -0.916>, <3.0171, 4.6349, 15.2986>, <0.325, -0.724, -0.609> }
	smooth_triangle { <4.5658, 4.8026, 15.7642>, <0.305, -0.161, -0.939>, <3.0171, 4.6349, 15.2986>, <0.325, -0.724, -0.609>, <4.5641, 4.7803, 15.7763>, <0.184, -0.932, -0.313> }
	smooth_triangle { <4.5641, 4.7803, 15.7763>, <0.184, -0.932, -0.313>, <3.0171, 4.6349, 15.2986>, <0.325, -0.724, -0.609>, <3.0097, 4.6342, 15.3229>, <0.122, -0.993, 0.000> }
	smooth_triangle { <4.5641, 4.7803, 15.7763>, <0.184, -0.932, -0.313>, <3.0097, 4.6342, 15.3229>, <0.122, -0.993, 0.000>, <4.5567, 4.7796, 15.8006>, <0.094, -0.996, 0.000> }
	smooth_triangle { <6.9817, 5.2330, 17.2149>, <-0.076, -0.489, 0.869>, <3.0097, 4.6342, 15.3229>, <-0.253, -0.525, 0.812>, <3.0039, 4.6558, 15.3350>, <-0.329, -0.228, 0.916> }
	smooth_triangle { <6.9817, 5.2330, 17.2149>, <-0.076, -0.489, 0.869>, <3.0039, 4.6558, 15.3350>, <-0.329, -0.228, 0.916>, <6.9715, 5.2534, 17.2259>, <-0.071, 0.018, 0.997> }
	smooth_triangle { <6.9715, 5.2534, 17.2259>, <-0.177, 0.109, 0.978>, <3.0039, 4.6558, 15.3350>, <-0.329, -0.228, 0.916>, <3.0055, 4.6780, 15.3229>, <-0.325, 0.724, 0.609> }
	smooth_triangle { <6.9715, 5.2534, 17.2259>, <-0.177, 0.109, 0.978>, <3.0055, 4.6780, 15.3229>, <-0.325, 0.724, 0.609>, <6.9736, 5.2762, 17.2149>, <-0.230, 0.850, 0.474> }
	smooth_triangle { <6.9736, 5.2762, 17.2149>, <-0.230, 0.850, 0.474>, <3.0055, 4.6780, 15.3229>, <-0.325, 0.724, 0.609>, <3.0130, 4.6787, 15.2986>, <0.004, 0.952, -0.308> }
	smooth_triangle { <6.9736, 5.2762, 17.2149>, <-0.230, 0.850, 0.474>, <3.0130, 4.6787, 15.2986>, <0.004, 0.952, -0.308>, <6.9861, 5.2786, 17.1929>, <-0.101, 0.910, -0.403> }
	smooth_triangle { <6.9861, 5.2786, 17.1929>, <-0.162, 0.837, -0.522>, <3.0130, 4.6787, 15.2986>, <0.004, 0.952, -0.308>, <3.0188, 4.6572, 15.2864>, <0.329, 0.228, -0.916> }
	smooth_triangle { <6.9861, 5.2786, 17.1929>, <-0.162, 0.837, -0.522>, <3.0188, 4.6572, 15.2864>, <0.329, 0.228, -0.916>, <6.9963, 5.2581, 17.1818>, <0.068, -0.019, -0.997> }
	smooth_triangle { <6.9963, 5.2581, 17.1818>, <0.175, -0.109, -0.978>, <3.0188, 4.6572, 15.2864>, <0.329, 0.228, -0.916>, <3.0171, 4.6349, 15.2986>, <0.325, -0.724, -0.609> }
	smooth_triangle { <6.9963, 5.2581, 17.1818>, <0.175, -0.109, -0.978>, <3.0171, 4.6349, 15.2986>, <0.325, -0.724, -0.609>, <6.9942, 5.2353, 17.1929>, <0.229, -0.850, -0.474> }
	smooth_triangle { <6.9942, 5.2353, 17.1929>, <0.229, -0.850, -0.474>, <3.0171, 4.6349, 15.2986>, <0.325, -0.724, -0.609>, <3.0097, 4.6342, 15.3229>, <0.122, -0.993, 0.000> }
	smooth_triangle { <6.9942, 5.2353, 17.1929>, <0.229, -0.850, -0.474>, <3.0097, 4.6342, 15.3229>, <0.122, -0.993, 0.000>, <6.9817, 5.2330, 17.2149>, <0.342, -0.938, 0.048> }
	smooth_triangle { <9.1506, 6.2161, 16.6299>, <0.498, -0.513, 0.699>, <6.9817, 5.2330, 17.2149>, <-0.076, -0.489, 0.869>, <6.9715, 5.2534, 17.2259>, <-0.071, 0.018, 0.997> }
	smooth_triangle { <9.1506, 6.2161, 16.6299>, <0.498, -0.513, 0.699>, <6.9715, 5.2534, 17.2259>, <0.148, -0.224, 0.963>, <9.1443, 6.2374, 16.6422>, <0.213, 0.191, 0.958> }
	smooth_triangle { <9.1443, 6.2374, 16.6422>, <0.213, 0.191, 0.958>, <6.9715, 5.2534, 17.2259>, <-0.071, 0.018, 0.997>, <6.9736, 5.2762, 17.2149>, <-0.166, 0.789, 0.592> }
	smooth_triangle { <9.1443, 6.2374, 16.6422>, <0.213, 0.191, 0.958>, <6.9736, 5.2762, 17.2149>, <-0.230, 0.850, 0.474>, <9.1324, 6.2562, 16.6299>, <-0.318, 0.877, 0.360> }
	smooth_triangle { <9.1324, 6.2562, 16.6299>, <-0.318, 0.877, 0.360>, <6.9736, 5.2762, 17.2149>, <-0.281, 0.895, 0.345>, <6.9861, 5.2786, 17.1929>, <-0.162, 0.837, -0.522> }
	smooth_triangle { <9.1324, 6.2562, 16.6299>, <-0.318, 0.877, 0.360>, <6.9861, 5.2786, 17.1929>, <-0.162, 0.837, -0.522>, <9.1269, 6.2536, 16.6053>, <-0.504, 0.639, -0.581> }
	smooth_triangle { <9.1269, 6.2536, 16.6053>, <-0.504, 0.639, -0.581>, <6.9861, 5.2786, 17.1929>, <-0.155, 0.763, -0.628>, <6.9963, 5.2581, 17.1818>, <0.068, -0.019, -0.997> }
	smooth_triangle { <9.1269, 6.2536, 16.6053>, <-0.504, 0.639, -0.581>, <6.9963, 5.2581, 17.1818>, <-0.153, 0.223, -0.963>, <9.1332, 6.2323, 16.5929>, <-0.209, -0.188, -0.960> }
	smooth_triangle { <9.1332, 6.2323, 16.5929>, <-0.209, -0.188, -0.960>, <6.9963, 5.2581, 17.1818>, <0.068, -0.019, -0.997>, <6.9942, 5.2353, 17.1929>, <0.165, -0.789, -0.592> }
	smooth_triangle { <9.1332, 6.2323, 16.5929>, <-0.209, -0.188, -0.960>, <6.9942, 5.2353, 17.1929>, <0.229, -0.850, -0.474>, <9.1451, 6.2136, 16.6053>, <0.325, -0.874, -0.362> }
	smooth_triangle { <9.1451, 6.2136, 16.6053>, <0.325, -0.874, -0.362>, <6.9942, 5.2353, 17.1929>, <0.281, -0.895, -0.345>, <6.9817, 5.2330, 17.2149>, <0.342, -0.938, 0.048> }
	smooth_triangle { <9.1451, 6.2136, 16.6053>, <0.325, -0.874, -0.362>, <6.9817, 5.2330, 17.2149>, <0.342, -0.938, 0.048>, <9.1506, 6.2161, 16.6299>, <0.413, -0.911, 0.000> }
	smooth_triangle { <11.1301, 7.4106, 15.8442>, <0.511, -0.310, 0.802>, <9.1506, 6.2161, 16.6299>, <0.498, -0.513, 0.699>, <9.1443, 6.2374, 16.6422>, <0.213, 0.191, 0.958> }
	smooth_triangle { <11.1301, 7.4106, 15.8442>, <0.011, 0.556, 0.831>, <9.1443, 6.2374, 16.6422>, <0.213, 0.191, 0.958>, <9.1324, 6.2562, 16.6299>, <-0.318, 0.877, 0.360> }
	smooth_triangle { <11.1301, 7.4106, 15.8442>, <-0.489, 0.872, 0.024>, <9.1324, 6.2562, 16.6299>, <-0.318, 0.877, 0.360>, <9.1269, 6.2536, 16.6053>, <-0.504, 0.639, -0.581> }
	smooth_triangle { <11.1301, 7.4106, 15.8442>, <-0.489, 0.322, -0.811>, <9.1269, 6.2536, 16.6053>, <-0.504, 0.639, -0.581>, <9.1332, 6.2323, 16.5929>, <-0.209, -0.188, -0.960> }
	smooth_triangle { <11.1301, 7.4106, 15.8442>, <0.012, -0.544, -0.839>, <9.1332, 6.2323, 16.5929>, <-0.209, -0.188, -0.960>, <9.1451, 6.2136, 16.6053>, <0.325, -0.874, -0.362> }
	smooth_triangle { <11.1301, 7.4106, 15.8442>, <0.511, -0.859, -0.031>, <9.1451, 6.2136, 16.6053>, <0.325, -0.874, -0.362>, <9.1506, 6.2161, 16.6299>, <0.498, -0.513, 0.699> }

	texture { PSWL_BARK }
}

/* Object 'PWL0017F' */
union {
	smooth_triangle { <2.3330, 3.8982, 14.3153>, <0.329, 0.605, -0.725>, <2.6252, 3.4449, 14.0824>, <0.310, 0.585, -0.750>, <3.1939, 3.2490, 14.1649>, <0.329, 0.605, -0.725> }
	smooth_triangle { <3.1939, 3.2490, 14.1649>, <0.329, 0.605, -0.725>, <2.8805, 3.7024, 14.4131>, <0.348, 0.624, -0.700>, <2.3330, 3.8982, 14.3153>, <0.329, 0.605, -0.725> }
	smooth_triangle { <3.0005, 4.7020, 15.2851>, <-0.869, 0.068, 0.489>, <2.7786, 5.1085, 14.7561>, <-0.923, -0.003, 0.385>, <2.7554, 5.7334, 14.7055>, <-0.869, 0.068, 0.489> }
	smooth_triangle { <2.7554, 5.7334, 14.7055>, <-0.869, 0.068, 0.489>, <3.0306, 5.3626, 15.1695>, <-0.799, 0.139, 0.585>, <3.0005, 4.7020, 15.2851>, <-0.869, 0.068, 0.489> }
	smooth_triangle { <3.5610, 5.6432, 16.1769>, <-0.222, 0.680, -0.698>, <3.8957, 5.4725, 15.8599>, <-0.166, 0.784, -0.598>, <4.3668, 5.5482, 15.8283>, <-0.222, 0.680, -0.698> }
	smooth_triangle { <4.3668, 5.5482, 15.8283>, <-0.222, 0.680, -0.698>, <4.0410, 5.7605, 16.0937>, <-0.272, 0.560, -0.782>, <3.5610, 5.6432, 16.1769>, <-0.222, 0.680, -0.698> }
	smooth_triangle { <3.9734, 6.6741, 17.0712>, <-0.522, -0.295, 0.801>, <3.4836, 6.8121, 16.8049>, <-0.519, -0.289, 0.804>, <3.1702, 7.3313, 16.7896>, <-0.522, -0.295, 0.801> }
	smooth_triangle { <3.1702, 7.3313, 16.7896>, <-0.522, -0.295, 0.801>, <3.6703, 7.1820, 17.0628>, <-0.525, -0.300, 0.797>, <3.9734, 6.6741, 17.0712>, <-0.522, -0.295, 0.801> }
	smooth_triangle { <4.3622, 7.3588, 17.7167>, <-0.634, 0.655, -0.412>, <4.7277, 7.3420, 17.1192>, <-0.630, 0.663, -0.404>, <5.2841, 7.7321, 16.8924>, <-0.634, 0.655, -0.412> }
	smooth_triangle { <5.2841, 7.7321, 16.8924>, <-0.634, 0.655, -0.412>, <4.9093, 7.7519, 17.4910>, <-0.637, 0.646, -0.420>, <4.3622, 7.3588, 17.7167>, <-0.634, 0.655, -0.412> }
	smooth_triangle { <4.5870, 8.0683, 18.4144>, <-0.303, -0.575, 0.760>, <3.8871, 8.1428, 18.1947>, <-0.301, -0.569, 0.765>, <3.3601, 8.6550, 18.3688>, <-0.303, -0.575, 0.760> }
	smooth_triangle { <3.3601, 8.6550, 18.3688>, <-0.303, -0.575, 0.760>, <4.0759, 8.5692, 18.5930>, <-0.306, -0.581, 0.754>, <4.5870, 8.0683, 18.4144>, <-0.303, -0.575, 0.760> }
	smooth_triangle { <5.2377, 8.2566, 19.2191>, <-0.042, 0.991, -0.126>, <5.6160, 8.2331, 18.7451>, <-0.012, 0.998, -0.060>, <6.2499, 8.2419, 18.7618>, <-0.042, 0.991, -0.126> }
	smooth_triangle { <6.2499, 8.2419, 18.7618>, <-0.042, 0.991, -0.126>, <5.8722, 8.2996, 19.1995>, <-0.072, 0.979, -0.191>, <5.2377, 8.2566, 19.2191>, <-0.042, 0.991, -0.126> }
	smooth_triangle { <5.7091, 8.5046, 20.0447>, <-0.732, -0.355, 0.582>, <5.0874, 8.8551, 19.5633>, <-0.672, -0.223, 0.706>, <4.8255, 9.4196, 19.4923>, <-0.732, -0.355, 0.582> }
	smooth_triangle { <4.8255, 9.4196, 19.4923>, <-0.732, -0.355, 0.582>, <5.4275, 8.9839, 20.0727>, <-0.764, -0.474, 0.437>, <5.7091, 8.5046, 20.0447>, <-0.732, -0.355, 0.582> }
	smooth_triangle { <3.1007, 4.5205, 16.1088>, <0.905, -0.381, -0.189>, <2.7885, 3.9138, 15.7640>, <0.911, -0.386, -0.146>, <2.5437, 3.2297, 16.0454>, <0.905, -0.381, -0.189> }
	smooth_triangle { <2.5437, 3.2297, 16.0454>, <0.905, -0.381, -0.189>, <2.8861, 3.8370, 16.3861>, <0.897, -0.376, -0.232>, <3.1007, 4.5205, 16.1088>, <0.905, -0.381, -0.189> }
	smooth_triangle { <3.2852, 4.4831, 16.9046>, <0.004, 0.992, 0.123>, <3.7374, 4.5261, 16.6132>, <0.009, 0.987, 0.160>, <4.2966, 4.4962, 16.7664>, <0.004, 0.992, 0.123> }
	smooth_triangle { <4.2966, 4.4962, 16.7664>, <0.004, 0.992, 0.123>, <3.8088, 4.4698, 17.0644>, <-0.001, 0.996, 0.086>, <3.2852, 4.4831, 16.9046>, <0.004, 0.992, 0.123> }
	smooth_triangle { <3.1276, 5.4815, 17.9202>, <-0.891, 0.374, -0.256>, <3.4612, 5.8036, 17.2287>, <-0.891, 0.374, -0.256>, <3.7633, 6.4418, 17.1093>, <-0.891, 0.374, -0.256> }
	smooth_triangle { <3.7633, 6.4418, 17.1093>, <-0.891, 0.374, -0.256>, <3.4208, 6.1059, 17.8126>, <-0.891, 0.374, -0.255>, <3.1276, 5.4815, 17.9202>, <-0.891, 0.374, -0.256> }
	smooth_triangle { <2.9264, 6.4210, 18.9719>, <-0.398, -0.770, 0.498>, <2.3795, 6.4280, 18.5065>, <-0.388, -0.808, 0.444>, <1.7768, 6.7350, 18.5385>, <-0.398, -0.770, 0.498> }
	smooth_triangle { <1.7768, 6.7350, 18.5385>, <-0.398, -0.770, 0.498>, <2.3355, 6.7563, 18.9792>, <-0.407, -0.729, 0.551>, <2.9264, 6.4210, 18.9719>, <-0.398, -0.770, 0.498> }
	smooth_triangle { <2.6565, 6.2947, 20.1628>, <-0.653, -0.703, -0.281>, <2.3846, 6.6716, 19.9166>, <-0.630, -0.689, -0.359>, <1.9543, 6.9786, 20.0829>, <-0.653, -0.703, -0.281> }
	smooth_triangle { <1.9543, 6.9786, 20.0829>, <-0.653, -0.703, -0.281>, <2.2690, 6.6097, 20.3403>, <-0.672, -0.713, -0.201>, <2.6565, 6.2947, 20.1628>, <-0.653, -0.703, -0.281> }
	smooth_triangle { <2.3912, 6.0607, 21.3327>, <0.860, -0.474, 0.189>, <2.2894, 5.6699, 21.0103>, <0.810, -0.484, 0.331>, <1.9288, 5.1306, 21.1039>, <0.860, -0.474, 0.189> }
	smooth_triangle { <1.9288, 5.1306, 21.1039>, <0.860, -0.474, 0.189>, <2.1473, 5.5936, 21.4633>, <0.890, -0.453, 0.043>, <2.3912, 6.0607, 21.3327>, <0.860, -0.474, 0.189> }
	smooth_triangle { <1.5274, 6.0000, 22.1755>, <-0.507, -0.689, -0.518>, <1.3851, 6.5432, 21.6706>, <-0.417, -0.675, -0.608>, <0.7553, 7.0197, 21.5740>, <-0.507, -0.689, -0.518> }
	smooth_triangle { <0.7553, 7.0197, 21.5740>, <-0.507, -0.689, -0.518>, <0.9793, 6.4742, 22.1606>, <-0.587, -0.692, -0.419>, <1.5274, 6.0000, 22.1755>, <-0.507, -0.689, -0.518> }
	smooth_triangle { <0.6920, 5.7651, 23.0368>, <0.616, -0.302, 0.727>, <0.8084, 5.2942, 22.7283>, <0.649, -0.298, 0.700>, <0.5574, 4.7469, 22.7277>, <0.616, -0.302, 0.727> }
	smooth_triangle { <0.5574, 4.7469, 22.7277>, <0.616, -0.302, 0.727>, <0.4270, 5.2294, 23.0242>, <0.582, -0.306, 0.754>, <0.6920, 5.7651, 23.0368>, <0.616, -0.302, 0.727> }
	smooth_triangle { <0.0987, 5.7980, 23.8736>, <-0.513, -0.819, -0.259>, <-0.1818, 6.1212, 23.4031>, <-0.514, -0.819, -0.256>, <-0.6776, 6.4358, 23.3926>, <-0.513, -0.819, -0.259> }
	smooth_triangle { <-0.6776, 6.4358, 23.3926>, <-0.513, -0.819, -0.259>, <-0.3883, 6.1035, 23.8685>, <-0.511, -0.819, -0.261>, <0.0987, 5.7980, 23.8736>, <-0.513, -0.819, -0.259> }
	smooth_triangle { <-0.4480, 5.6732, 24.7245>, <0.767, -0.497, 0.406>, <-0.5600, 5.2528, 24.3538>, <0.822, -0.484, 0.300>, <-0.8437, 4.8060, 24.4112>, <0.767, -0.497, 0.406> }
	smooth_triangle { <-0.8437, 4.8060, 24.4112>, <0.767, -0.497, 0.406>, <-0.7809, 5.2339, 24.7495>, <0.701, -0.503, 0.505>, <-0.4480, 5.6732, 24.7245>, <0.767, -0.497, 0.406> }
	smooth_triangle { <-0.9478, 5.8565, 25.6042>, <-0.802, -0.538, -0.260>, <-1.0544, 6.2149, 25.2668>, <-0.760, -0.550, -0.344>, <-1.3590, 6.6200, 25.2917>, <-0.802, -0.538, -0.260> }
	smooth_triangle { <-1.3590, 6.6200, 25.2917>, <-0.802, -0.538, -0.260>, <-1.2001, 6.2422, 25.6607>, <-0.835, -0.521, -0.174>, <-0.9478, 5.8565, 25.6042>, <-0.802, -0.538, -0.260> }
	smooth_triangle { <-1.4648, 5.8847, 26.4811>, <0.227, -0.896, 0.382>, <-1.6997, 5.6580, 26.1088>, <0.210, -0.888, 0.408>, <-2.2970, 5.4915, 26.0532>, <0.227, -0.896, 0.382> }
	smooth_triangle { <-2.2970, 5.4915, 26.0532>, <0.227, -0.896, 0.382>, <-2.0262, 5.7192, 26.4456>, <0.244, -0.902, 0.355>, <-1.4648, 5.8847, 26.4811>, <0.227, -0.896, 0.382> }
	smooth_triangle { <-2.2857, 5.8273, 27.0060>, <-0.507, 0.060, -0.860>, <-1.9078, 6.5521, 26.8367>, <-0.499, 0.059, -0.864>, <-2.0750, 7.2158, 26.9783>, <-0.507, 0.060, -0.860> }
	smooth_triangle { <-2.0750, 7.2158, 26.9783>, <-0.507, 0.060, -0.860>, <-2.4506, 6.4704, 27.1510>, <-0.514, 0.061, -0.855>, <-2.2857, 5.8273, 27.0060>, <-0.507, 0.060, -0.860> }
	smooth_triangle { <-3.2012, 5.6065, 27.4949>, <0.528, -0.696, 0.486>, <-3.4030, 5.1604, 27.1179>, <0.485, -0.682, 0.547>, <-4.1297, 4.6102, 27.0764>, <0.528, -0.696, 0.486> }
	smooth_triangle { <-4.1297, 4.6102, 27.0764>, <0.528, -0.696, 0.486>, <-3.8714, 5.0622, 27.4847>, <0.567, -0.707, 0.423>, <-3.2012, 5.6065, 27.4949>, <0.528, -0.696, 0.486> }
	smooth_triangle { <3.6644, 4.5131, 15.7759>, <0.574, -0.058, -0.817>, <3.3635, 3.9387, 15.6039>, <0.578, -0.059, -0.814>, <3.5105, 3.2852, 15.7555>, <0.574, -0.058, -0.817> }
	smooth_triangle { <3.5105, 3.2852, 15.7555>, <0.574, -0.058, -0.817>, <3.8149, 3.8768, 15.9257>, <0.571, -0.058, -0.819>, <3.6644, 4.5131, 15.7759>, <0.574, -0.058, -0.817> }
	smooth_triangle { <4.3516, 4.5200, 16.2220>, <-0.443, 0.543, 0.714>, <4.3368, 4.9530, 15.9395>, <-0.293, 0.515, 0.805>, <4.7368, 5.3415, 15.8363>, <-0.443, 0.543, 0.714> }
	smooth_triangle { <4.7368, 5.3415, 15.8363>, <-0.443, 0.543, 0.714>, <4.6945, 4.9040, 16.1987>, <-0.578, 0.553, 0.600>, <4.3516, 4.5200, 16.2220>, <-0.443, 0.543, 0.714> }
	smooth_triangle { <5.3997, 3.9974, 17.0521>, <0.673, 0.095, -0.733>, <5.1416, 3.5972, 16.7903>, <0.608, 0.121, -0.785>, <5.2328, 3.0441, 16.7756>, <0.673, 0.095, -0.733> }
	smooth_triangle { <5.2328, 3.0441, 16.7756>, <0.673, 0.095, -0.733>, <5.4704, 3.4668, 17.0757>, <0.734, 0.068, -0.676>, <5.3997, 3.9974, 17.0521>, <0.673, 0.095, -0.733> }
	smooth_triangle { <6.5174, 3.6583, 17.8697>, <-0.237, 0.608, 0.758>, <6.6176, 4.0544, 17.5799>, <-0.246, 0.612, 0.751>, <7.0621, 4.3264, 17.5039>, <-0.237, 0.608, 0.758> }
	smooth_triangle { <7.0621, 4.3264, 17.5039>, <-0.237, 0.608, 0.758>, <6.9572, 3.9197, 17.7944>, <-0.228, 0.604, 0.764>, <6.5174, 3.6583, 17.8697>, <-0.237, 0.608, 0.758> }
	smooth_triangle { <7.3979, 3.2097, 18.5905>, <0.712, 0.504, -0.489>, <7.3276, 2.8707, 18.1220>, <0.735, 0.492, -0.466>, <7.5568, 2.3992, 17.9859>, <0.712, 0.504, -0.489> }
	smooth_triangle { <7.5568, 2.3992, 17.9859>, <0.712, 0.504, -0.489>, <7.6382, 2.7441, 18.4437>, <0.688, 0.516, -0.511>, <7.3979, 3.2097, 18.5905>, <0.712, 0.504, -0.489> }
	smooth_triangle { <8.3164, 2.9312, 19.3482>, <-0.536, 0.349, 0.769>, <8.3722, 3.4389, 19.1578>, <-0.532, 0.348, 0.772>, <8.7602, 3.8263, 19.2509>, <-0.536, 0.349, 0.769> }
	smooth_triangle { <8.7602, 3.8263, 19.2509>, <-0.536, 0.349, 0.769>, <8.6969, 3.3065, 19.4444>, <-0.539, 0.351, 0.766>, <8.3164, 2.9312, 19.3482>, <-0.536, 0.349, 0.769> }
	smooth_triangle { <8.7001, 2.6889, 20.4636>, <0.848, 0.418, -0.326>, <8.6670, 2.3044, 19.9594>, <0.785, 0.467, -0.408>, <8.8782, 1.8132, 19.8028>, <0.848, 0.418, -0.326> }
	smooth_triangle { <8.8782, 1.8132, 19.8028>, <0.848, 0.418, -0.326>, <8.8643, 2.2281, 20.3804>, <0.900, 0.364, -0.240>, <8.7001, 2.6889, 20.4636>, <0.848, 0.418, -0.326> }
	smooth_triangle { <9.1198, 2.6199, 21.6220>, <-0.677, 0.622, 0.393>, <9.3809, 3.1664, 21.1574>, <-0.708, 0.622, 0.333>, <9.8479, 3.6525, 21.2428>, <-0.677, 0.622, 0.393> }
	smooth_triangle { <9.8479, 3.6525, 21.2428>, <-0.677, 0.622, 0.393>, <9.6018, 3.0811, 21.6763>, <-0.643, 0.619, 0.451>, <9.1198, 2.6199, 21.6220>, <-0.677, 0.622, 0.393> }
	smooth_triangle { <3.7941, 4.6788, 15.5347>, <0.257, 0.317, -0.913>, <3.6160, 4.0163, 15.2676>, <0.220, 0.313, -0.924>, <4.0324, 3.3913, 15.1550>, <0.257, 0.317, -0.913> }
	smooth_triangle { <4.0324, 3.3913, 15.1550>, <0.257, 0.317, -0.913>, <4.2000, 4.0712, 15.4507>, <0.292, 0.320, -0.901>, <3.7941, 4.6788, 15.5347>, <0.257, 0.317, -0.913> }
	smooth_triangle { <4.5547, 4.8549, 15.7841>, <-0.310, 0.058, 0.949>, <4.2541, 5.4302, 15.6443>, <-0.332, 0.056, 0.942>, <4.4716, 6.0714, 15.6831>, <-0.310, 0.058, 0.949> }
	smooth_triangle { <4.4716, 6.0714, 15.6831>, <-0.310, 0.058, 0.949>, <4.7771, 5.4794, 15.8121>, <-0.288, 0.060, 0.956>, <4.5547, 4.8549, 15.7841>, <-0.310, 0.058, 0.949> }
	smooth_triangle { <5.7985, 5.0053, 16.4568>, <0.013, 0.862, -0.506>, <5.8843, 4.6448, 15.7798>, <0.100, 0.883, -0.458>, <6.5291, 4.3781, 15.4059>, <0.013, 0.862, -0.506> }
	smooth_triangle { <6.5291, 4.3781, 15.4059>, <0.013, 0.862, -0.506>, <6.4946, 4.7590, 15.9884>, <-0.075, 0.833, -0.549>, <5.7985, 5.0053, 16.4568>, <0.013, 0.862, -0.506> }
	smooth_triangle { <6.9867, 5.3049, 17.1833>, <-0.565, 0.347, 0.749>, <6.7939, 5.8398, 16.7662>, <-0.615, 0.335, 0.714>, <7.0544, 6.4758, 16.6918>, <-0.565, 0.347, 0.749> }
	smooth_triangle { <7.0544, 6.4758, 16.6918>, <-0.565, 0.347, 0.749>, <7.2657, 5.9281, 17.0814>, <-0.513, 0.357, 0.781>, <6.9867, 5.3049, 17.1833>, <-0.565, 0.347, 0.749> }
	smooth_triangle { <8.0828, 5.6965, 16.9081>, <-0.245, -0.055, -0.968>, <8.0822, 5.2048, 16.9366>, <-0.248, -0.056, -0.967>, <8.4480, 4.8656, 16.8626>, <-0.245, -0.055, -0.968> }
	smooth_triangle { <8.4480, 4.8656, 16.8626>, <-0.245, -0.055, -0.968>, <8.4437, 5.3691, 16.8359>, <-0.242, -0.053, -0.969>, <8.0828, 5.6965, 16.9081>, <-0.245, -0.055, -0.968> }
	smooth_triangle { <9.1155, 6.2624, 16.5783>, <-0.064, 0.799, 0.598>, <8.5624, 6.4864, 16.1839>, <-0.127, 0.775, 0.618>, <8.5281, 6.9596, 15.5835>, <-0.064, 0.799, 0.598> }
	smooth_triangle { <8.5281, 6.9596, 15.5835>, <-0.064, 0.799, 0.598>, <9.0749, 6.7192, 15.9273>, <-0.001, 0.819, 0.574>, <9.1155, 6.2624, 16.5783>, <-0.064, 0.799, 0.598> }
	smooth_triangle { <10.1428, 6.7833, 16.1959>, <-0.464, 0.531, -0.709>, <10.0072, 6.1900, 15.8718>, <-0.532, 0.496, -0.686>, <10.3396, 5.8578, 15.3736>, <-0.464, 0.531, -0.709> }
	smooth_triangle { <10.3396, 5.8578, 15.3736>, <-0.464, 0.531, -0.709>, <10.4858, 6.4702, 15.7686>, <-0.392, 0.563, -0.727>, <10.1428, 6.7833, 16.1959>, <-0.464, 0.531, -0.709> }
	smooth_triangle { <11.1056, 7.4453, 15.8120>, <0.028, 0.691, 0.723>, <10.5634, 7.7424, 15.5823>, <0.097, 0.713, 0.694>, <10.4786, 8.3320, 14.9882>, <0.028, 0.691, 0.723> }
	smooth_triangle { <10.4786, 8.3320, 14.9882>, <0.028, 0.691, 0.723>, <11.0431, 8.0285, 15.2898>, <-0.042, 0.664, 0.747>, <11.1056, 7.4453, 15.8120>, <0.028, 0.691, 0.723> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0018B' */
union {
	smooth_triangle { <0.7229, 3.5198, 10.1358>, <0.497, -0.476, 0.725>, <0.7129, 1.8183, 9.0249>, <0.497, -0.462, 0.734>, <0.6899, 1.8112, 9.0360>, <0.175, -0.511, 0.842> }
	smooth_triangle { <0.7229, 3.5198, 10.1358>, <0.497, -0.476, 0.725>, <0.6899, 1.8112, 9.0360>, <0.175, -0.511, 0.842>, <0.6999, 3.5127, 10.1469>, <-0.192, -0.536, 0.822> }
	smooth_triangle { <0.6999, 3.5127, 10.1469>, <-0.192, -0.536, 0.822>, <0.6899, 1.8112, 9.0360>, <0.175, -0.511, 0.842>, <0.6670, 1.8186, 9.0249>, <-0.764, -0.303, 0.569> }
	smooth_triangle { <0.6999, 3.5127, 10.1469>, <-0.192, -0.536, 0.822>, <0.6670, 1.8186, 9.0249>, <-0.764, -0.303, 0.569>, <0.6769, 3.5200, 10.1358>, <-0.946, -0.173, 0.274> }
	smooth_triangle { <0.6769, 3.5200, 10.1358>, <-0.946, -0.173, 0.274>, <0.6670, 1.8186, 9.0249>, <-0.764, -0.303, 0.569>, <0.6671, 1.8331, 9.0027>, <-0.940, 0.207, -0.273> }
	smooth_triangle { <0.6769, 3.5200, 10.1358>, <-0.946, -0.173, 0.274>, <0.6671, 1.8331, 9.0027>, <-0.940, 0.207, -0.273>, <0.6770, 3.5346, 10.1135>, <-0.754, 0.362, -0.548> }
	smooth_triangle { <0.6770, 3.5346, 10.1135>, <-0.754, 0.362, -0.548>, <0.6671, 1.8331, 9.0027>, <-0.940, 0.207, -0.273>, <0.6901, 1.8402, 8.9916>, <-0.175, 0.511, -0.842> }
	smooth_triangle { <0.6770, 3.5346, 10.1135>, <-0.754, 0.362, -0.548>, <0.6901, 1.8402, 8.9916>, <-0.175, 0.511, -0.842>, <0.7000, 3.5417, 10.1024>, <0.192, 0.536, -0.822> }
	smooth_triangle { <0.7000, 3.5417, 10.1024>, <0.192, 0.536, -0.822>, <0.6901, 1.8402, 8.9916>, <-0.175, 0.511, -0.842>, <0.7130, 1.8328, 9.0027>, <0.764, 0.304, -0.569> }
	smooth_triangle { <0.7000, 3.5417, 10.1024>, <0.192, 0.536, -0.822>, <0.7130, 1.8328, 9.0027>, <0.764, 0.304, -0.569>, <0.7230, 3.5343, 10.1135>, <0.946, 0.173, -0.274> }
	smooth_triangle { <0.7230, 3.5343, 10.1135>, <0.946, 0.173, -0.274>, <0.7130, 1.8328, 9.0027>, <0.764, 0.304, -0.569>, <0.7129, 1.8183, 9.0249>, <0.999, -0.044, -0.005> }
	smooth_triangle { <0.7230, 3.5343, 10.1135>, <0.946, 0.173, -0.274>, <0.7129, 1.8183, 9.0249>, <0.999, -0.044, -0.005>, <0.7229, 3.5198, 10.1358>, <1.000, -0.006, 0.000> }
	smooth_triangle { <1.1157, 6.4259, 11.5372>, <0.461, -0.453, 0.763>, <0.7129, 1.8183, 9.0249>, <0.497, -0.462, 0.734>, <0.6899, 1.8112, 9.0360>, <0.175, -0.511, 0.842> }
	smooth_triangle { <1.1157, 6.4259, 11.5372>, <0.461, -0.453, 0.763>, <0.6899, 1.8112, 9.0360>, <0.175, -0.511, 0.842>, <1.0932, 6.4235, 11.5486>, <-0.053, -0.462, 0.885> }
	smooth_triangle { <1.0932, 6.4235, 11.5486>, <-0.053, -0.462, 0.885>, <0.6899, 1.8112, 9.0360>, <0.175, -0.511, 0.842>, <0.6670, 1.8186, 9.0249>, <-0.764, -0.303, 0.569> }
	smooth_triangle { <1.0932, 6.4235, 11.5486>, <-0.053, -0.462, 0.885>, <0.6670, 1.8186, 9.0249>, <-0.764, -0.303, 0.569>, <1.0721, 6.4318, 11.5372>, <-0.886, -0.128, 0.446> }
	smooth_triangle { <1.0721, 6.4318, 11.5372>, <-0.886, -0.128, 0.446>, <0.6670, 1.8186, 9.0249>, <-0.764, -0.303, 0.569>, <0.6671, 1.8331, 9.0027>, <-0.940, 0.207, -0.273> }
	smooth_triangle { <1.0721, 6.4318, 11.5372>, <-0.886, -0.128, 0.446>, <0.6671, 1.8331, 9.0027>, <-0.940, 0.207, -0.273>, <1.0736, 6.4427, 11.5143>, <-0.833, 0.334, -0.440> }
	smooth_triangle { <1.0736, 6.4427, 11.5143>, <-0.833, 0.334, -0.440>, <0.6671, 1.8331, 9.0027>, <-0.940, 0.207, -0.273>, <0.6901, 1.8402, 8.9916>, <-0.175, 0.511, -0.842> }
	smooth_triangle { <1.0736, 6.4427, 11.5143>, <-0.833, 0.334, -0.440>, <0.6901, 1.8402, 8.9916>, <-0.175, 0.511, -0.842>, <1.0961, 6.4452, 11.5028>, <0.053, 0.462, -0.885> }
	smooth_triangle { <1.0961, 6.4452, 11.5028>, <0.053, 0.462, -0.885>, <0.6901, 1.8402, 8.9916>, <-0.175, 0.511, -0.842>, <0.7130, 1.8328, 9.0027>, <0.764, 0.304, -0.569> }
	smooth_triangle { <1.0961, 6.4452, 11.5028>, <0.053, 0.462, -0.885>, <0.7130, 1.8328, 9.0027>, <0.764, 0.304, -0.569>, <1.1172, 6.4368, 11.5143>, <0.886, 0.128, -0.446> }
	smooth_triangle { <1.1172, 6.4368, 11.5143>, <0.886, 0.128, -0.446>, <0.7130, 1.8328, 9.0027>, <0.764, 0.304, -0.569>, <0.7129, 1.8183, 9.0249>, <0.999, -0.044, -0.005> }
	smooth_triangle { <1.1172, 6.4368, 11.5143>, <0.886, 0.128, -0.446>, <0.7129, 1.8183, 9.0249>, <0.999, -0.044, -0.005>, <1.1157, 6.4259, 11.5372>, <0.992, -0.129, 0.005> }
	smooth_triangle { <1.4872, 8.9480, 12.7989>, <0.438, -0.466, 0.769>, <1.1157, 6.4259, 11.5372>, <0.461, -0.453, 0.763>, <1.0932, 6.4235, 11.5486>, <-0.053, -0.462, 0.885> }
	smooth_triangle { <1.4872, 8.9480, 12.7989>, <0.438, -0.466, 0.769>, <1.0932, 6.4235, 11.5486>, <-0.053, -0.462, 0.885>, <1.4646, 8.9456, 12.8102>, <-0.035, -0.299, 0.953> }
	smooth_triangle { <1.4646, 8.9456, 12.8102>, <-0.035, -0.299, 0.953>, <1.0932, 6.4235, 11.5486>, <-0.053, -0.462, 0.885>, <1.0721, 6.4318, 11.5372>, <-0.886, -0.128, 0.446> }
	smooth_triangle { <1.4646, 8.9456, 12.8102>, <-0.035, -0.299, 0.953>, <1.0721, 6.4318, 11.5372>, <-0.886, -0.128, 0.446>, <1.4437, 8.9544, 12.7989>, <-0.753, 0.317, 0.577> }
	smooth_triangle { <1.4437, 8.9544, 12.7989>, <-0.753, 0.317, 0.577>, <1.0721, 6.4318, 11.5372>, <-0.886, -0.128, 0.446>, <1.0736, 6.4427, 11.5143>, <-0.833, 0.334, -0.440> }
	smooth_triangle { <1.4437, 8.9544, 12.7989>, <-0.753, 0.317, 0.577>, <1.0736, 6.4427, 11.5143>, <-0.833, 0.334, -0.440>, <1.4453, 8.9655, 12.7761>, <-0.693, 0.605, -0.392> }
	smooth_triangle { <1.4453, 8.9655, 12.7761>, <-0.693, 0.605, -0.392>, <1.0736, 6.4427, 11.5143>, <-0.833, 0.334, -0.440>, <1.0961, 6.4452, 11.5028>, <0.053, 0.462, -0.885> }
	smooth_triangle { <1.4453, 8.9655, 12.7761>, <-0.693, 0.605, -0.392>, <1.0961, 6.4452, 11.5028>, <0.053, 0.462, -0.885>, <1.4679, 8.9679, 12.7647>, <0.035, 0.298, -0.954> }
	smooth_triangle { <1.4679, 8.9679, 12.7647>, <0.035, 0.298, -0.954>, <1.0961, 6.4452, 11.5028>, <0.053, 0.462, -0.885>, <1.1172, 6.4368, 11.5143>, <0.886, 0.128, -0.446> }
	smooth_triangle { <1.4679, 8.9679, 12.7647>, <0.035, 0.298, -0.954>, <1.1172, 6.4368, 11.5143>, <0.886, 0.128, -0.446>, <1.4889, 8.9591, 12.7761>, <0.762, -0.202, -0.615> }
	smooth_triangle { <1.4889, 8.9591, 12.7761>, <0.830, -0.283, -0.481>, <1.1172, 6.4368, 11.5143>, <0.886, 0.128, -0.446>, <1.1157, 6.4259, 11.5372>, <0.992, -0.129, 0.005> }
	smooth_triangle { <1.4889, 8.9591, 12.7761>, <0.830, -0.283, -0.481>, <1.1157, 6.4259, 11.5372>, <0.992, -0.129, 0.005>, <1.4872, 8.9480, 12.7989>, <0.788, -0.604, -0.117> }
	smooth_triangle { <3.0667, 10.2070, 12.7160>, <0.556, -0.472, 0.685>, <1.4872, 8.9480, 12.7989>, <0.438, -0.466, 0.769>, <1.4646, 8.9456, 12.8102>, <0.026, -0.439, 0.898> }
	smooth_triangle { <3.0667, 10.2070, 12.7160>, <0.556, -0.472, 0.685>, <1.4646, 8.9456, 12.8102>, <-0.035, -0.299, 0.953>, <3.0534, 10.2245, 12.7286>, <-0.099, 0.063, 0.993> }
	smooth_triangle { <3.0534, 10.2245, 12.7286>, <-0.099, 0.063, 0.993>, <1.4646, 8.9456, 12.8102>, <-0.144, -0.241, 0.960>, <1.4437, 8.9544, 12.7989>, <-0.753, 0.317, 0.577> }
	smooth_triangle { <3.0534, 10.2245, 12.7286>, <-0.099, 0.063, 0.993>, <1.4437, 8.9544, 12.7989>, <-0.753, 0.317, 0.577>, <3.0393, 10.2414, 12.7160>, <-0.661, 0.592, 0.461> }
	smooth_triangle { <3.0393, 10.2414, 12.7160>, <-0.661, 0.592, 0.461>, <1.4437, 8.9544, 12.7989>, <-0.753, 0.317, 0.577>, <1.4453, 8.9655, 12.7761>, <-0.693, 0.605, -0.392> }
	smooth_triangle { <3.0393, 10.2414, 12.7160>, <-0.661, 0.592, 0.461>, <1.4453, 8.9655, 12.7761>, <-0.693, 0.605, -0.392>, <3.0384, 10.2407, 12.6906>, <-0.594, 0.574, -0.565> }
	smooth_triangle { <3.0384, 10.2407, 12.6906>, <-0.594, 0.574, -0.565>, <1.4453, 8.9655, 12.7761>, <-0.693, 0.605, -0.392>, <1.4679, 8.9679, 12.7647>, <-0.026, 0.438, -0.899> }
	smooth_triangle { <3.0384, 10.2407, 12.6906>, <-0.594, 0.574, -0.565>, <1.4679, 8.9679, 12.7647>, <0.035, 0.298, -0.954>, <3.0518, 10.2232, 12.6779>, <0.104, -0.058, -0.993> }
	smooth_triangle { <3.0518, 10.2232, 12.6779>, <0.104, -0.058, -0.993>, <1.4679, 8.9679, 12.7647>, <0.144, 0.240, -0.960>, <1.4889, 8.9591, 12.7761>, <0.750, -0.321, -0.578> }
	smooth_triangle { <3.0518, 10.2232, 12.6779>, <0.104, -0.058, -0.993>, <1.4889, 8.9591, 12.7761>, <0.480, -0.363, -0.799>, <3.0659, 10.2064, 12.6906>, <0.664, -0.589, -0.462> }
	smooth_triangle { <3.0659, 10.2064, 12.6906>, <0.664, -0.589, -0.462>, <1.4889, 8.9591, 12.7761>, <0.747, -0.449, -0.491>, <1.4872, 8.9480, 12.7989>, <0.788, -0.604, -0.117> }
	smooth_triangle { <3.0659, 10.2064, 12.6906>, <0.664, -0.589, -0.462>, <1.4872, 8.9480, 12.7989>, <0.788, -0.604, -0.117>, <3.0667, 10.2070, 12.7160>, <0.623, -0.782, 0.000> }
	smooth_triangle { <4.0463, 11.9650, 13.0348>, <0.357, -0.350, 0.866>, <3.0667, 10.2070, 12.7160>, <0.556, -0.472, 0.685>, <3.0534, 10.2245, 12.7286>, <-0.099, 0.063, 0.993> }
	smooth_triangle { <4.0463, 11.9650, 13.0348>, <-0.519, 0.154, 0.841>, <3.0534, 10.2245, 12.7286>, <-0.099, 0.063, 0.993>, <3.0393, 10.2414, 12.7160>, <-0.661, 0.592, 0.461> }
	smooth_triangle { <4.0463, 11.9650, 13.0348>, <-0.860, 0.511, -0.013>, <3.0393, 10.2414, 12.7160>, <-0.661, 0.592, 0.461>, <3.0384, 10.2407, 12.6906>, <-0.594, 0.574, -0.565> }
	smooth_triangle { <4.0463, 11.9650, 13.0348>, <-0.335, 0.375, -0.865>, <3.0384, 10.2407, 12.6906>, <-0.594, 0.574, -0.565>, <3.0518, 10.2232, 12.6779>, <0.104, -0.058, -0.993> }
	smooth_triangle { <4.0463, 11.9650, 13.0348>, <0.536, -0.130, -0.834>, <3.0518, 10.2232, 12.6779>, <0.104, -0.058, -0.993>, <3.0659, 10.2064, 12.6906>, <0.664, -0.589, -0.462> }
	smooth_triangle { <4.0463, 11.9650, 13.0348>, <0.875, -0.484, 0.015>, <3.0659, 10.2064, 12.6906>, <0.664, -0.589, -0.462>, <3.0667, 10.2070, 12.7160>, <0.556, -0.472, 0.685> }
	smooth_triangle { <2.3874, 7.3015, 11.9949>, <0.084, -0.550, 0.831>, <1.1042, 6.4142, 11.5379>, <0.090, -0.545, 0.833>, <1.0888, 6.4303, 11.5501>, <-0.113, -0.308, 0.945> }
	smooth_triangle { <2.3874, 7.3015, 11.9949>, <0.084, -0.550, 0.831>, <1.0888, 6.4303, 11.5501>, <-0.113, -0.308, 0.945>, <2.3719, 7.3175, 12.0071>, <-0.335, -0.002, 0.942> }
	smooth_triangle { <2.3719, 7.3175, 12.0071>, <-0.335, -0.002, 0.942>, <1.0888, 6.4303, 11.5501>, <-0.113, -0.308, 0.945>, <1.0792, 6.4504, 11.5379>, <-0.578, 0.520, 0.630> }
	smooth_triangle { <2.3719, 7.3175, 12.0071>, <-0.335, -0.002, 0.942>, <1.0792, 6.4504, 11.5379>, <-0.578, 0.520, 0.630>, <2.3624, 7.3377, 11.9949>, <-0.613, 0.725, 0.314> }
	smooth_triangle { <2.3624, 7.3377, 11.9949>, <-0.613, 0.725, 0.314>, <1.0792, 6.4504, 11.5379>, <-0.578, 0.520, 0.630>, <1.0851, 6.4544, 11.5135>, <-0.465, 0.827, -0.315> }
	smooth_triangle { <2.3624, 7.3377, 11.9949>, <-0.613, 0.725, 0.314>, <1.0851, 6.4544, 11.5135>, <-0.465, 0.827, -0.315>, <2.3682, 7.3417, 11.9705>, <-0.279, 0.726, -0.628> }
	smooth_triangle { <2.3682, 7.3417, 11.9705>, <-0.279, 0.726, -0.628>, <1.0851, 6.4544, 11.5135>, <-0.465, 0.827, -0.315>, <1.1005, 6.4384, 11.5014>, <0.113, 0.308, -0.945> }
	smooth_triangle { <2.3682, 7.3417, 11.9705>, <-0.279, 0.726, -0.628>, <1.1005, 6.4384, 11.5014>, <0.113, 0.308, -0.945>, <2.3837, 7.3257, 11.9584>, <0.335, 0.002, -0.942> }
	smooth_triangle { <2.3837, 7.3257, 11.9584>, <0.335, 0.002, -0.942>, <1.1005, 6.4384, 11.5014>, <0.113, 0.308, -0.945>, <1.1101, 6.4183, 11.5135>, <0.578, -0.519, -0.630> }
	smooth_triangle { <2.3837, 7.3257, 11.9584>, <0.335, 0.002, -0.942>, <1.1101, 6.4183, 11.5135>, <0.578, -0.519, -0.630>, <2.3932, 7.3055, 11.9705>, <0.613, -0.725, -0.314> }
	smooth_triangle { <2.3932, 7.3055, 11.9705>, <0.613, -0.725, -0.314>, <1.1101, 6.4183, 11.5135>, <0.578, -0.519, -0.630>, <1.1042, 6.4142, 11.5379>, <0.570, -0.822, 0.000> }
	smooth_triangle { <2.3932, 7.3055, 11.9705>, <0.613, -0.725, -0.314>, <1.1042, 6.4142, 11.5379>, <0.570, -0.822, 0.000>, <2.3874, 7.3015, 11.9949>, <0.569, -0.822, 0.000> }
	smooth_triangle { <4.6439, 8.8745, 12.7222>, <0.116, -0.528, 0.841>, <1.1042, 6.4142, 11.5379>, <0.090, -0.545, 0.833>, <1.0888, 6.4303, 11.5501>, <-0.113, -0.308, 0.945> }
	smooth_triangle { <4.6439, 8.8745, 12.7222>, <0.116, -0.528, 0.841>, <1.0888, 6.4303, 11.5501>, <-0.113, -0.308, 0.945>, <4.6286, 8.8907, 12.7345>, <-0.182, -0.126, 0.975> }
	smooth_triangle { <4.6286, 8.8907, 12.7345>, <-0.182, -0.126, 0.975>, <1.0888, 6.4303, 11.5501>, <-0.113, -0.308, 0.945>, <1.0792, 6.4504, 11.5379>, <-0.578, 0.520, 0.630> }
	smooth_triangle { <4.6286, 8.8907, 12.7345>, <-0.182, -0.126, 0.975>, <1.0792, 6.4504, 11.5379>, <-0.578, 0.520, 0.630>, <4.6187, 8.9106, 12.7222>, <-0.574, 0.656, 0.490> }
	smooth_triangle { <4.6187, 8.9106, 12.7222>, <-0.574, 0.656, 0.490>, <1.0792, 6.4504, 11.5379>, <-0.578, 0.520, 0.630>, <1.0851, 6.4544, 11.5135>, <-0.465, 0.827, -0.315> }
	smooth_triangle { <4.6187, 8.9106, 12.7222>, <-0.574, 0.656, 0.490>, <1.0851, 6.4544, 11.5135>, <-0.465, 0.827, -0.315>, <4.6240, 8.9143, 12.6976>, <-0.391, 0.782, -0.484> }
	smooth_triangle { <4.6240, 8.9143, 12.6976>, <-0.391, 0.782, -0.484>, <1.0851, 6.4544, 11.5135>, <-0.465, 0.827, -0.315>, <1.1005, 6.4384, 11.5014>, <0.113, 0.308, -0.945> }
	smooth_triangle { <4.6240, 8.9143, 12.6976>, <-0.391, 0.782, -0.484>, <1.1005, 6.4384, 11.5014>, <0.113, 0.308, -0.945>, <4.6393, 8.8982, 12.6854>, <0.182, 0.126, -0.975> }
	smooth_triangle { <4.6393, 8.8982, 12.6854>, <0.182, 0.126, -0.975>, <1.1005, 6.4384, 11.5014>, <0.113, 0.308, -0.945>, <1.1101, 6.4183, 11.5135>, <0.578, -0.519, -0.630> }
	smooth_triangle { <4.6393, 8.8982, 12.6854>, <0.182, 0.126, -0.975>, <1.1101, 6.4183, 11.5135>, <0.578, -0.519, -0.630>, <4.6492, 8.8783, 12.6976>, <0.574, -0.656, -0.490> }
	smooth_triangle { <4.6492, 8.8783, 12.6976>, <0.574, -0.656, -0.490>, <1.1101, 6.4183, 11.5135>, <0.578, -0.519, -0.630>, <1.1042, 6.4142, 11.5379>, <0.570, -0.822, 0.000> }
	smooth_triangle { <4.6492, 8.8783, 12.6976>, <0.574, -0.656, -0.490>, <1.1042, 6.4142, 11.5379>, <0.570, -0.822, 0.000>, <4.6439, 8.8745, 12.7222>, <0.562, -0.827, -0.002> }
	smooth_triangle { <6.9701, 10.4356, 13.2207>, <0.355, -0.585, 0.729>, <4.6439, 8.8745, 12.7222>, <0.116, -0.528, 0.841>, <4.6286, 8.8907, 12.7345>, <-0.182, -0.126, 0.975> }
	smooth_triangle { <6.9701, 10.4356, 13.2207>, <0.355, -0.585, 0.729>, <4.6286, 8.8907, 12.7345>, <-0.182, -0.126, 0.975>, <6.9560, 10.4526, 13.2332>, <-0.251, -0.036, 0.967> }
	smooth_triangle { <6.9560, 10.4526, 13.2332>, <-0.251, -0.036, 0.967>, <4.6286, 8.8907, 12.7345>, <-0.182, -0.126, 0.975>, <4.6187, 8.9106, 12.7222>, <-0.574, 0.656, 0.490> }
	smooth_triangle { <6.9560, 10.4526, 13.2332>, <-0.251, -0.036, 0.967>, <4.6187, 8.9106, 12.7222>, <-0.574, 0.656, 0.490>, <6.9456, 10.4721, 13.2207>, <-0.672, 0.645, 0.365> }
	smooth_triangle { <6.9456, 10.4721, 13.2207>, <-0.672, 0.645, 0.365>, <4.6187, 8.9106, 12.7222>, <-0.574, 0.656, 0.490>, <4.6240, 8.9143, 12.6976>, <-0.391, 0.782, -0.484> }
	smooth_triangle { <6.9456, 10.4721, 13.2207>, <-0.672, 0.645, 0.365>, <4.6240, 8.9143, 12.6976>, <-0.391, 0.782, -0.484>, <6.9493, 10.4746, 13.1957>, <-0.417, 0.681, -0.603> }
	smooth_triangle { <6.9493, 10.4746, 13.1957>, <-0.417, 0.681, -0.603>, <4.6240, 8.9143, 12.6976>, <-0.391, 0.782, -0.484>, <4.6393, 8.8982, 12.6854>, <0.182, 0.126, -0.975> }
	smooth_triangle { <6.9493, 10.4746, 13.1957>, <-0.417, 0.681, -0.603>, <4.6393, 8.8982, 12.6854>, <0.182, 0.126, -0.975>, <6.9634, 10.4576, 13.1832>, <0.256, 0.040, -0.966> }
	smooth_triangle { <6.9634, 10.4576, 13.1832>, <0.256, 0.040, -0.966>, <4.6393, 8.8982, 12.6854>, <0.182, 0.126, -0.975>, <4.6492, 8.8783, 12.6976>, <0.574, -0.656, -0.490> }
	smooth_triangle { <6.9634, 10.4576, 13.1832>, <0.256, 0.040, -0.966>, <4.6492, 8.8783, 12.6976>, <0.574, -0.656, -0.490>, <6.9738, 10.4381, 13.1957>, <0.677, -0.640, -0.363> }
	smooth_triangle { <6.9738, 10.4381, 13.1957>, <0.677, -0.640, -0.363>, <4.6492, 8.8783, 12.6976>, <0.574, -0.656, -0.490>, <4.6439, 8.8745, 12.7222>, <0.562, -0.827, -0.002> }
	smooth_triangle { <6.9738, 10.4381, 13.1957>, <0.677, -0.640, -0.363>, <4.6439, 8.8745, 12.7222>, <0.562, -0.827, -0.002>, <6.9701, 10.4356, 13.2207>, <0.557, -0.830, 0.000> }
	smooth_triangle { <8.6140, 12.5979, 14.0825>, <0.180, -0.475, 0.861>, <6.9701, 10.4356, 13.2207>, <0.355, -0.585, 0.729>, <6.9560, 10.4526, 13.2332>, <-0.251, -0.036, 0.967> }
	smooth_triangle { <8.6140, 12.5979, 14.0825>, <-0.600, 0.158, 0.785>, <6.9560, 10.4526, 13.2332>, <-0.251, -0.036, 0.967>, <6.9456, 10.4721, 13.2207>, <-0.672, 0.645, 0.365> }
	smooth_triangle { <8.6140, 12.5979, 14.0825>, <-0.769, 0.636, -0.067>, <6.9456, 10.4721, 13.2207>, <-0.672, 0.645, 0.365>, <6.9493, 10.4746, 13.1957>, <-0.417, 0.681, -0.603> }
	smooth_triangle { <8.6140, 12.5979, 14.0825>, <-0.164, 0.491, -0.856>, <6.9493, 10.4746, 13.1957>, <-0.417, 0.681, -0.603>, <6.9634, 10.4576, 13.1832>, <0.256, 0.040, -0.966> }
	smooth_triangle { <8.6140, 12.5979, 14.0825>, <0.614, -0.142, -0.776>, <6.9634, 10.4576, 13.1832>, <0.256, 0.040, -0.966>, <6.9738, 10.4381, 13.1957>, <0.677, -0.640, -0.363> }
	smooth_triangle { <8.6140, 12.5979, 14.0825>, <0.782, -0.619, 0.072>, <6.9738, 10.4381, 13.1957>, <0.677, -0.640, -0.363>, <6.9701, 10.4356, 13.2207>, <0.355, -0.585, 0.729> }
	smooth_triangle { <2.0749, 7.0822, 12.6494>, <-0.206, -0.748, 0.631>, <1.1000, 6.4113, 11.5350>, <-0.145, -0.704, 0.695>, <1.0803, 6.4244, 11.5442>, <-0.378, -0.498, 0.780> }
	smooth_triangle { <2.0749, 7.0822, 12.6494>, <-0.206, -0.748, 0.631>, <1.0803, 6.4244, 11.5442>, <-0.378, -0.498, 0.780>, <2.0552, 7.0954, 12.6586>, <-0.662, -0.226, 0.715> }
	smooth_triangle { <2.0552, 7.0954, 12.6586>, <-0.662, -0.226, 0.715>, <1.0803, 6.4244, 11.5442>, <-0.378, -0.498, 0.780>, <1.0750, 6.4475, 11.5350>, <-0.769, 0.383, 0.512> }
	smooth_triangle { <2.0552, 7.0954, 12.6586>, <-0.662, -0.226, 0.715>, <1.0750, 6.4475, 11.5350>, <-0.769, 0.383, 0.512>, <2.0499, 7.1185, 12.6494>, <-0.721, 0.651, 0.238> }
	smooth_triangle { <2.0499, 7.1185, 12.6494>, <-0.721, 0.651, 0.238>, <1.0750, 6.4475, 11.5350>, <-0.769, 0.383, 0.512>, <1.0894, 6.4574, 11.5165>, <-0.391, 0.881, -0.267> }
	smooth_triangle { <2.0499, 7.1185, 12.6494>, <-0.721, 0.651, 0.238>, <1.0894, 6.4574, 11.5165>, <-0.391, 0.881, -0.267>, <2.0643, 7.1284, 12.6309>, <-0.059, 0.877, -0.477> }
	smooth_triangle { <2.0643, 7.1284, 12.6309>, <-0.059, 0.877, -0.477>, <1.0894, 6.4574, 11.5165>, <-0.391, 0.881, -0.267>, <1.1090, 6.4442, 11.5072>, <0.378, 0.498, -0.780> }
	smooth_triangle { <2.0643, 7.1284, 12.6309>, <-0.059, 0.877, -0.477>, <1.1090, 6.4442, 11.5072>, <0.378, 0.498, -0.780>, <2.0839, 7.1152, 12.6216>, <0.662, 0.226, -0.715> }
	smooth_triangle { <2.0839, 7.1152, 12.6216>, <0.662, 0.226, -0.715>, <1.1090, 6.4442, 11.5072>, <0.378, 0.498, -0.780>, <1.1143, 6.4211, 11.5165>, <0.769, -0.383, -0.512> }
	smooth_triangle { <2.0839, 7.1152, 12.6216>, <0.662, 0.226, -0.715>, <1.1143, 6.4211, 11.5165>, <0.769, -0.383, -0.512>, <2.0892, 7.0921, 12.6309>, <0.721, -0.651, -0.238> }
	smooth_triangle { <2.0892, 7.0921, 12.6309>, <0.721, -0.651, -0.238>, <1.1143, 6.4211, 11.5165>, <0.769, -0.383, -0.512>, <1.1000, 6.4113, 11.5350>, <0.587, -0.809, 0.006> }
	smooth_triangle { <2.0892, 7.0921, 12.6309>, <0.721, -0.651, -0.238>, <1.1000, 6.4113, 11.5350>, <0.587, -0.809, 0.006>, <2.0749, 7.0822, 12.6494>, <0.567, -0.824, 0.000> }
	smooth_triangle { <4.0692, 8.7182, 13.8624>, <-0.012, -0.636, 0.771>, <1.1000, 6.4113, 11.5350>, <-0.145, -0.704, 0.695>, <1.0803, 6.4244, 11.5442>, <-0.378, -0.498, 0.780> }
	smooth_triangle { <4.0692, 8.7182, 13.8624>, <-0.012, -0.636, 0.771>, <1.0803, 6.4244, 11.5442>, <-0.378, -0.498, 0.780>, <4.0510, 8.7317, 13.8739>, <-0.315, -0.243, 0.918> }
	smooth_triangle { <4.0510, 8.7317, 13.8739>, <-0.315, -0.243, 0.918>, <1.0803, 6.4244, 11.5442>, <-0.378, -0.498, 0.780>, <1.0750, 6.4475, 11.5350>, <-0.769, 0.383, 0.512> }
	smooth_triangle { <4.0510, 8.7317, 13.8739>, <-0.315, -0.243, 0.918>, <1.0750, 6.4475, 11.5350>, <-0.769, 0.383, 0.512>, <4.0413, 8.7522, 13.8624>, <-0.621, 0.616, 0.484> }
	smooth_triangle { <4.0413, 8.7522, 13.8624>, <-0.621, 0.616, 0.484>, <1.0750, 6.4475, 11.5350>, <-0.769, 0.383, 0.512>, <1.0894, 6.4574, 11.5165>, <-0.391, 0.881, -0.267> }
	smooth_triangle { <4.0413, 8.7522, 13.8624>, <-0.621, 0.616, 0.484>, <1.0894, 6.4574, 11.5165>, <-0.391, 0.881, -0.267>, <4.0496, 8.7590, 13.8394>, <-0.304, 0.851, -0.428> }
	smooth_triangle { <4.0496, 8.7590, 13.8394>, <-0.304, 0.851, -0.428>, <1.0894, 6.4574, 11.5165>, <-0.391, 0.881, -0.267>, <1.1090, 6.4442, 11.5072>, <0.378, 0.498, -0.780> }
	smooth_triangle { <4.0496, 8.7590, 13.8394>, <-0.304, 0.851, -0.428>, <1.1090, 6.4442, 11.5072>, <0.378, 0.498, -0.780>, <4.0677, 8.7454, 13.8279>, <0.315, 0.243, -0.918> }
	smooth_triangle { <4.0677, 8.7454, 13.8279>, <0.315, 0.243, -0.918>, <1.1090, 6.4442, 11.5072>, <0.378, 0.498, -0.780>, <1.1143, 6.4211, 11.5165>, <0.769, -0.383, -0.512> }
	smooth_triangle { <4.0677, 8.7454, 13.8279>, <0.315, 0.243, -0.918>, <1.1143, 6.4211, 11.5165>, <0.769, -0.383, -0.512>, <4.0775, 8.7250, 13.8394>, <0.621, -0.616, -0.484> }
	smooth_triangle { <4.0775, 8.7250, 13.8394>, <0.621, -0.616, -0.484>, <1.1143, 6.4211, 11.5165>, <0.769, -0.383, -0.512>, <1.1000, 6.4113, 11.5350>, <0.587, -0.809, 0.006> }
	smooth_triangle { <4.0775, 8.7250, 13.8394>, <0.621, -0.616, -0.484>, <1.1000, 6.4113, 11.5350>, <0.587, -0.809, 0.006>, <4.0692, 8.7182, 13.8624>, <0.539, -0.842, -0.028> }
	smooth_triangle { <6.4776, 10.0761, 14.5267>, <0.075, -0.753, 0.654>, <4.0692, 8.7182, 13.8624>, <-0.012, -0.636, 0.771>, <4.0510, 8.7317, 13.8739>, <-0.315, -0.243, 0.918> }
	smooth_triangle { <6.4776, 10.0761, 14.5267>, <0.075, -0.753, 0.654>, <4.0510, 8.7317, 13.8739>, <-0.315, -0.243, 0.918>, <6.4643, 10.0938, 14.5391>, <-0.310, -0.050, 0.950> }
	smooth_triangle { <6.4643, 10.0938, 14.5391>, <-0.310, -0.050, 0.950>, <4.0510, 8.7317, 13.8739>, <-0.315, -0.243, 0.918>, <4.0413, 8.7522, 13.8624>, <-0.621, 0.616, 0.484> }
	smooth_triangle { <6.4643, 10.0938, 14.5391>, <-0.310, -0.050, 0.950>, <4.0413, 8.7522, 13.8624>, <-0.621, 0.616, 0.484>, <6.4561, 10.1144, 14.5267>, <-0.482, 0.771, 0.416> }
	smooth_triangle { <6.4561, 10.1144, 14.5267>, <-0.482, 0.771, 0.416>, <4.0413, 8.7522, 13.8624>, <-0.621, 0.616, 0.484>, <4.0496, 8.7590, 13.8394>, <-0.304, 0.851, -0.428> }
	smooth_triangle { <6.4561, 10.1144, 14.5267>, <-0.482, 0.771, 0.416>, <4.0496, 8.7590, 13.8394>, <-0.304, 0.851, -0.428>, <6.4612, 10.1173, 14.5020>, <-0.169, 0.825, -0.539> }
	smooth_triangle { <6.4612, 10.1173, 14.5020>, <-0.169, 0.825, -0.539>, <4.0496, 8.7590, 13.8394>, <-0.304, 0.851, -0.428>, <4.0677, 8.7454, 13.8279>, <0.315, 0.243, -0.918> }
	smooth_triangle { <6.4612, 10.1173, 14.5020>, <-0.169, 0.825, -0.539>, <4.0677, 8.7454, 13.8279>, <0.315, 0.243, -0.918>, <6.4746, 10.0996, 14.4897>, <0.316, 0.053, -0.947> }
	smooth_triangle { <6.4746, 10.0996, 14.4897>, <0.316, 0.053, -0.947>, <4.0677, 8.7454, 13.8279>, <0.315, 0.243, -0.918>, <4.0775, 8.7250, 13.8394>, <0.621, -0.616, -0.484> }
	smooth_triangle { <6.4746, 10.0996, 14.4897>, <0.316, 0.053, -0.947>, <4.0775, 8.7250, 13.8394>, <0.621, -0.616, -0.484>, <6.4828, 10.0790, 14.5020>, <0.488, -0.768, -0.414> }
	smooth_triangle { <6.4828, 10.0790, 14.5020>, <0.488, -0.768, -0.414>, <4.0775, 8.7250, 13.8394>, <0.621, -0.616, -0.484>, <4.0692, 8.7182, 13.8624>, <0.539, -0.842, -0.028> }
	smooth_triangle { <6.4828, 10.0790, 14.5020>, <0.488, -0.768, -0.414>, <4.0692, 8.7182, 13.8624>, <0.539, -0.842, -0.028>, <6.4776, 10.0761, 14.5267>, <0.491, -0.871, 0.000> }
	smooth_triangle { <9.0187, 10.7150, 15.6152>, <-0.162, -0.632, 0.758>, <6.4776, 10.0761, 14.5267>, <0.075, -0.753, 0.654>, <6.4643, 10.0938, 14.5391>, <-0.310, -0.050, 0.950> }
	smooth_triangle { <9.0187, 10.7150, 15.6152>, <-0.430, 0.332, 0.839>, <6.4643, 10.0938, 14.5391>, <-0.310, -0.050, 0.950>, <6.4561, 10.1144, 14.5267>, <-0.482, 0.771, 0.416> }
	smooth_triangle { <9.0187, 10.7150, 15.6152>, <-0.255, 0.964, 0.078>, <6.4561, 10.1144, 14.5267>, <-0.482, 0.771, 0.416>, <6.4612, 10.1173, 14.5020>, <-0.169, 0.825, -0.539> }
	smooth_triangle { <9.0187, 10.7150, 15.6152>, <0.181, 0.638, -0.749>, <6.4612, 10.1173, 14.5020>, <-0.169, 0.825, -0.539>, <6.4746, 10.0996, 14.4897>, <0.316, 0.053, -0.947> }
	smooth_triangle { <9.0187, 10.7150, 15.6152>, <0.451, -0.324, -0.832>, <6.4746, 10.0996, 14.4897>, <0.316, 0.053, -0.947>, <6.4828, 10.0790, 14.5020>, <0.488, -0.768, -0.414> }
	smooth_triangle { <9.0187, 10.7150, 15.6152>, <0.276, -0.959, -0.071>, <6.4828, 10.0790, 14.5020>, <0.488, -0.768, -0.414>, <6.4776, 10.0761, 14.5267>, <0.075, -0.753, 0.654> }
	smooth_triangle { <0.2778, 7.4921, 12.4515>, <0.695, -0.069, 0.716>, <1.1163, 6.4425, 11.5362>, <0.683, -0.054, 0.729>, <1.1036, 6.4231, 11.5467>, <0.413, -0.252, 0.875> }
	smooth_triangle { <0.2778, 7.4921, 12.4515>, <0.695, -0.069, 0.716>, <1.1036, 6.4231, 11.5467>, <0.413, -0.252, 0.875>, <0.2651, 7.4728, 12.4620>, <0.197, -0.550, 0.812> }
	smooth_triangle { <0.2651, 7.4728, 12.4620>, <0.197, -0.550, 0.812>, <1.1036, 6.4231, 11.5467>, <0.413, -0.252, 0.875>, <1.0819, 6.4150, 11.5362>, <-0.502, -0.582, 0.640> }
	smooth_triangle { <0.2651, 7.4728, 12.4620>, <0.197, -0.550, 0.812>, <1.0819, 6.4150, 11.5362>, <-0.502, -0.582, 0.640>, <0.2435, 7.4646, 12.4515>, <-0.623, -0.734, 0.271> }
	smooth_triangle { <0.2435, 7.4646, 12.4515>, <-0.623, -0.734, 0.271>, <1.0819, 6.4150, 11.5362>, <-0.502, -0.582, 0.640>, <1.0730, 6.4262, 11.5152>, <-0.914, -0.328, -0.238> }
	smooth_triangle { <0.2435, 7.4646, 12.4515>, <-0.623, -0.734, 0.271>, <1.0730, 6.4262, 11.5152>, <-0.914, -0.328, -0.238>, <0.2345, 7.4758, 12.4306>, <-0.821, -0.184, -0.541> }
	smooth_triangle { <0.2345, 7.4758, 12.4306>, <-0.821, -0.184, -0.541>, <1.0730, 6.4262, 11.5152>, <-0.914, -0.328, -0.238>, <1.0857, 6.4455, 11.5047>, <-0.413, 0.252, -0.875> }
	smooth_triangle { <0.2345, 7.4758, 12.4306>, <-0.821, -0.184, -0.541>, <1.0857, 6.4455, 11.5047>, <-0.413, 0.252, -0.875>, <0.2473, 7.4951, 12.4201>, <-0.197, 0.550, -0.812> }
	smooth_triangle { <0.2473, 7.4951, 12.4201>, <-0.197, 0.550, -0.812>, <1.0857, 6.4455, 11.5047>, <-0.413, 0.252, -0.875>, <1.1074, 6.4536, 11.5152>, <0.502, 0.582, -0.640> }
	smooth_triangle { <0.2473, 7.4951, 12.4201>, <-0.197, 0.550, -0.812>, <1.1074, 6.4536, 11.5152>, <0.502, 0.582, -0.640>, <0.2689, 7.5033, 12.4306>, <0.623, 0.734, -0.271> }
	smooth_triangle { <0.2689, 7.5033, 12.4306>, <0.623, 0.734, -0.271>, <1.1074, 6.4536, 11.5152>, <0.502, 0.582, -0.640>, <1.1163, 6.4425, 11.5362>, <0.882, 0.468, -0.053> }
	smooth_triangle { <0.2689, 7.5033, 12.4306>, <0.623, 0.734, -0.271>, <1.1163, 6.4425, 11.5362>, <0.882, 0.468, -0.053>, <0.2778, 7.4921, 12.4515>, <0.781, 0.624, 0.000> }
	smooth_triangle { <0.0454, 10.3091, 12.7016>, <0.562, -0.034, 0.826>, <1.1163, 6.4425, 11.5362>, <0.683, -0.054, 0.729>, <1.1036, 6.4231, 11.5467>, <0.413, -0.252, 0.875> }
	smooth_triangle { <0.0454, 10.3091, 12.7016>, <0.562, -0.034, 0.826>, <1.1036, 6.4231, 11.5467>, <0.413, -0.252, 0.875>, <0.0236, 10.3062, 12.7142>, <0.064, -0.217, 0.974> }
	smooth_triangle { <0.0236, 10.3062, 12.7142>, <0.064, -0.217, 0.974>, <1.1036, 6.4231, 11.5467>, <0.413, -0.252, 0.875>, <1.0819, 6.4150, 11.5362>, <-0.502, -0.582, 0.640> }
	smooth_triangle { <0.0236, 10.3062, 12.7142>, <0.064, -0.217, 0.974>, <1.0819, 6.4150, 11.5362>, <-0.502, -0.582, 0.640>, <0.0016, 10.3054, 12.7016>, <-0.762, -0.416, 0.495> }
	smooth_triangle { <0.0016, 10.3054, 12.7016>, <-0.762, -0.416, 0.495>, <1.0819, 6.4150, 11.5362>, <-0.502, -0.582, 0.640>, <1.0730, 6.4262, 11.5152>, <-0.914, -0.328, -0.238> }
	smooth_triangle { <0.0016, 10.3054, 12.7016>, <-0.762, -0.416, 0.495>, <1.0730, 6.4262, 11.5152>, <-0.914, -0.328, -0.238>, <0.0014, 10.3077, 12.6763>, <-0.851, -0.206, -0.483> }
	smooth_triangle { <0.0014, 10.3077, 12.6763>, <-0.851, -0.206, -0.483>, <1.0730, 6.4262, 11.5152>, <-0.914, -0.328, -0.238>, <1.0857, 6.4455, 11.5047>, <-0.413, 0.252, -0.875> }
	smooth_triangle { <0.0014, 10.3077, 12.6763>, <-0.851, -0.206, -0.483>, <1.0857, 6.4455, 11.5047>, <-0.413, 0.252, -0.875>, <0.0232, 10.3106, 12.6636>, <-0.064, 0.217, -0.974> }
	smooth_triangle { <0.0232, 10.3106, 12.6636>, <-0.064, 0.217, -0.974>, <1.0857, 6.4455, 11.5047>, <-0.413, 0.252, -0.875>, <1.1074, 6.4536, 11.5152>, <0.502, 0.582, -0.640> }
	smooth_triangle { <0.0232, 10.3106, 12.6636>, <-0.064, 0.217, -0.974>, <1.1074, 6.4536, 11.5152>, <0.502, 0.582, -0.640>, <0.0452, 10.3113, 12.6763>, <0.763, 0.416, -0.496> }
	smooth_triangle { <0.0452, 10.3113, 12.6763>, <0.763, 0.416, -0.496>, <1.1074, 6.4536, 11.5152>, <0.502, 0.582, -0.640>, <1.1163, 6.4425, 11.5362>, <0.882, 0.468, -0.053> }
	smooth_triangle { <0.0452, 10.3113, 12.6763>, <0.763, 0.416, -0.496>, <1.1163, 6.4425, 11.5362>, <0.882, 0.468, -0.053>, <0.0454, 10.3091, 12.7016>, <0.920, 0.392, 0.016> }
	smooth_triangle { <-1.2286, 12.7929, 13.2832>, <0.697, 0.142, 0.703>, <0.0454, 10.3091, 12.7016>, <0.562, -0.034, 0.826>, <0.0236, 10.3062, 12.7142>, <0.064, -0.217, 0.974> }
	smooth_triangle { <-1.2286, 12.7929, 13.2832>, <0.697, 0.142, 0.703>, <0.0236, 10.3062, 12.7142>, <0.064, -0.217, 0.974>, <-1.2470, 12.7805, 13.2956>, <-0.009, -0.279, 0.960> }
	smooth_triangle { <-1.2470, 12.7805, 13.2956>, <-0.009, -0.279, 0.960>, <0.0236, 10.3062, 12.7142>, <0.064, -0.217, 0.974>, <0.0016, 10.3054, 12.7016>, <-0.762, -0.416, 0.495> }
	smooth_triangle { <-1.2470, 12.7805, 13.2956>, <-0.009, -0.279, 0.960>, <0.0016, 10.3054, 12.7016>, <-0.762, -0.416, 0.495>, <-1.2677, 12.7728, 13.2832>, <-0.781, -0.494, 0.382> }
	smooth_triangle { <-1.2677, 12.7728, 13.2832>, <-0.781, -0.494, 0.382>, <0.0016, 10.3054, 12.7016>, <-0.762, -0.416, 0.495>, <0.0014, 10.3077, 12.6763>, <-0.851, -0.206, -0.483> }
	smooth_triangle { <-1.2677, 12.7728, 13.2832>, <-0.781, -0.494, 0.382>, <0.0014, 10.3077, 12.6763>, <-0.851, -0.206, -0.483>, <-1.2701, 12.7774, 13.2583>, <-0.785, -0.217, -0.580> }
	smooth_triangle { <-1.2701, 12.7774, 13.2583>, <-0.785, -0.217, -0.580>, <0.0014, 10.3077, 12.6763>, <-0.851, -0.206, -0.483>, <0.0232, 10.3106, 12.6636>, <-0.064, 0.217, -0.974> }
	smooth_triangle { <-1.2701, 12.7774, 13.2583>, <-0.785, -0.217, -0.580>, <0.0232, 10.3106, 12.6636>, <-0.064, 0.217, -0.974>, <-1.2517, 12.7898, 13.2459>, <0.007, 0.285, -0.959> }
	smooth_triangle { <-1.2517, 12.7898, 13.2459>, <0.007, 0.285, -0.959>, <0.0232, 10.3106, 12.6636>, <-0.064, 0.217, -0.974>, <0.0452, 10.3113, 12.6763>, <0.763, 0.416, -0.496> }
	smooth_triangle { <-1.2517, 12.7898, 13.2459>, <0.007, 0.285, -0.959>, <0.0452, 10.3113, 12.6763>, <0.763, 0.416, -0.496>, <-1.2310, 12.7975, 13.2583>, <0.778, 0.499, -0.380> }
	smooth_triangle { <-1.2310, 12.7975, 13.2583>, <0.778, 0.499, -0.380>, <0.0452, 10.3113, 12.6763>, <0.763, 0.416, -0.496>, <0.0454, 10.3091, 12.7016>, <0.920, 0.392, 0.016> }
	smooth_triangle { <-1.2310, 12.7975, 13.2583>, <0.778, 0.499, -0.380>, <0.0454, 10.3091, 12.7016>, <0.920, 0.392, 0.016>, <-1.2286, 12.7929, 13.2832>, <0.890, 0.456, 0.000> }
	smooth_triangle { <-2.3563, 15.2487, 14.1644>, <0.573, -0.026, 0.819>, <-1.2286, 12.7929, 13.2832>, <0.697, 0.142, 0.703>, <-1.2470, 12.7805, 13.2956>, <-0.009, -0.279, 0.960> }
	smooth_triangle { <-2.3563, 15.2487, 14.1644>, <-0.337, -0.440, 0.832>, <-1.2470, 12.7805, 13.2956>, <-0.009, -0.279, 0.960>, <-1.2677, 12.7728, 13.2832>, <-0.781, -0.494, 0.382> }
	smooth_triangle { <-2.3563, 15.2487, 14.1644>, <-0.915, -0.403, 0.015>, <-1.2677, 12.7728, 13.2832>, <-0.781, -0.494, 0.382>, <-1.2701, 12.7774, 13.2583>, <-0.785, -0.217, -0.580> }
	smooth_triangle { <-2.3563, 15.2487, 14.1644>, <-0.582, 0.047, -0.812>, <-1.2701, 12.7774, 13.2583>, <-0.785, -0.217, -0.580>, <-1.2517, 12.7898, 13.2459>, <0.007, 0.285, -0.959> }
	smooth_triangle { <-2.3563, 15.2487, 14.1644>, <0.327, 0.460, -0.826>, <-1.2517, 12.7898, 13.2459>, <0.007, 0.285, -0.959>, <-1.2310, 12.7975, 13.2583>, <0.778, 0.499, -0.380> }
	smooth_triangle { <-2.3563, 15.2487, 14.1644>, <0.906, 0.424, -0.009>, <-1.2310, 12.7975, 13.2583>, <0.778, 0.499, -0.380>, <-1.2286, 12.7929, 13.2832>, <0.697, 0.142, 0.703> }

	texture { PSWL_BARK }
}

/* Object 'PWL0018F' */
union {
	smooth_triangle { <0.9449, 4.9857, 10.8015>, <-0.443, 0.382, -0.811>, <1.3350, 4.8217, 10.5342>, <-0.449, 0.302, -0.841>, <1.7935, 5.0737, 10.3798>, <-0.443, 0.382, -0.811> }
	smooth_triangle { <1.7935, 5.0737, 10.3798>, <-0.443, 0.382, -0.811>, <1.3889, 5.2183, 10.6915>, <-0.433, 0.460, -0.775>, <0.9449, 4.9857, 10.8015>, <-0.443, 0.382, -0.811> }
	smooth_triangle { <1.0521, 6.4528, 11.4994>, <-0.586, -0.259, 0.767>, <0.5951, 6.4028, 11.1667>, <-0.569, -0.164, 0.806>, <0.1895, 6.8265, 10.9669>, <-0.586, -0.259, 0.767> }
	smooth_triangle { <0.1895, 6.8265, 10.9669>, <-0.586, -0.259, 0.767>, <0.6551, 6.8452, 11.3619>, <-0.597, -0.352, 0.721>, <1.0521, 6.4528, 11.4994>, <-0.586, -0.259, 0.767> }
	smooth_triangle { <1.3327, 7.6931, 12.1461>, <-0.161, 0.416, -0.895>, <1.8510, 7.4296, 11.9378>, <-0.165, 0.392, -0.905>, <2.4552, 7.6411, 11.9194>, <-0.161, 0.416, -0.895> }
	smooth_triangle { <2.4552, 7.6411, 11.9194>, <-0.161, 0.416, -0.895>, <1.9202, 7.8991, 12.1437>, <-0.158, 0.440, -0.884>, <1.3327, 7.6931, 12.1461>, <-0.161, 0.416, -0.895> }
	smooth_triangle { <1.4139, 8.9663, 12.7839>, <-0.142, -0.445, 0.885>, <0.8302, 8.8422, 12.6257>, <-0.143, -0.451, 0.881>, <0.2968, 9.1693, 12.7071>, <-0.142, -0.445, 0.885> }
	smooth_triangle { <0.2968, 9.1693, 12.7071>, <-0.142, -0.445, 0.885>, <0.8965, 9.2923, 12.8626>, <-0.141, -0.438, 0.888>, <1.4139, 8.9663, 12.7839>, <-0.142, -0.445, 0.885> }
	smooth_triangle { <2.2818, 9.5599, 12.7077>, <-0.454, 0.542, -0.707>, <2.3090, 9.1875, 12.4233>, <-0.506, 0.500, -0.703>, <2.6514, 9.0556, 12.0834>, <-0.454, 0.542, -0.707> }
	smooth_triangle { <2.6514, 9.0556, 12.0834>, <-0.454, 0.542, -0.707>, <2.6201, 9.4360, 12.4140>, <-0.401, 0.582, -0.707>, <2.2818, 9.5599, 12.7077>, <-0.454, 0.542, -0.707> }
	smooth_triangle { <3.0193, 10.2655, 12.7018>, <0.022, 0.052, 0.998>, <2.5992, 10.4775, 12.6992>, <0.019, 0.050, 0.999>, <2.4769, 10.9430, 12.6782>, <0.022, 0.052, 0.998> }
	smooth_triangle { <2.4769, 10.9430, 12.6782>, <0.022, 0.052, 0.998>, <2.9045, 10.7214, 12.6798>, <0.024, 0.054, 0.998>, <3.0193, 10.2655, 12.7018>, <0.022, 0.052, 0.998> }
	smooth_triangle { <3.5701, 11.0660, 12.8289>, <-0.639, 0.434, -0.635>, <3.6832, 10.4338, 12.3170>, <-0.685, 0.380, -0.621>, <4.1066, 10.3249, 11.7833>, <-0.639, 0.434, -0.635> }
	smooth_triangle { <4.1066, 10.3249, 11.7833>, <-0.639, 0.434, -0.635>, <3.9880, 10.9692, 12.3749>, <-0.589, 0.485, -0.646>, <3.5701, 11.0660, 12.8289>, <-0.639, 0.434, -0.635> }
	smooth_triangle { <4.0150, 12.0028, 13.0138>, <-0.519, 0.043, 0.854>, <3.4623, 12.2186, 12.6876>, <-0.482, 0.083, 0.872>, <3.2036, 12.9827, 12.4717>, <-0.519, 0.043, 0.854> }
	smooth_triangle { <3.2036, 12.9827, 12.4717>, <-0.519, 0.043, 0.854>, <3.7691, 12.7542, 12.8480>, <-0.553, 0.003, 0.833>, <4.0150, 12.0028, 13.0138>, <-0.519, 0.043, 0.854> }
	smooth_triangle { <1.7688, 6.8382, 11.7400>, <-0.006, 0.332, -0.943>, <1.9136, 6.2275, 11.5296>, <-0.020, 0.321, -0.947>, <2.5225, 5.9175, 11.4114>, <-0.006, 0.332, -0.943> }
	smooth_triangle { <2.5225, 5.9175, 11.4114>, <-0.006, 0.332, -0.943>, <2.3646, 6.5394, 11.6365>, <0.008, 0.342, -0.940>, <1.7688, 6.8382, 11.7400>, <-0.006, 0.332, -0.943> }
	smooth_triangle { <2.3546, 7.3653, 11.9628>, <-0.553, 0.085, 0.829>, <2.0059, 7.6283, 11.6996>, <-0.563, 0.077, 0.823>, <1.9584, 8.1139, 11.6219>, <-0.553, 0.085, 0.829> }
	smooth_triangle { <1.9584, 8.1139, 11.6219>, <-0.553, 0.085, 0.829>, <2.3142, 7.8415, 11.8837>, <-0.543, 0.092, 0.834>, <2.3546, 7.3653, 11.9628>, <-0.553, 0.085, 0.829> }
	smooth_triangle { <3.5329, 8.0885, 12.3047>, <-0.323, 0.759, -0.565>, <3.5939, 7.7716, 11.9067>, <-0.442, 0.668, -0.599>, <4.0467, 7.7176, 11.5129>, <-0.323, 0.759, -0.565> }
	smooth_triangle { <4.0467, 7.7176, 11.5129>, <-0.323, 0.759, -0.565>, <3.9532, 8.0221, 12.0384>, <-0.196, 0.833, -0.518>, <3.5329, 8.0885, 12.3047>, <-0.323, 0.759, -0.565> }
	smooth_triangle { <4.6142, 8.9356, 12.6823>, <-0.508, 0.299, 0.808>, <4.2360, 9.2200, 12.2876>, <-0.631, 0.201, 0.749>, <4.2142, 9.7685, 12.1218>, <-0.508, 0.299, 0.808> }
	smooth_triangle { <4.2142, 9.7685, 12.1218>, <-0.508, 0.299, 0.808>, <4.6185, 9.4866, 12.4298>, <-0.371, 0.389, 0.843>, <4.6142, 8.9356, 12.6823>, <-0.508, 0.299, 0.808> }
	smooth_triangle { <5.8272, 9.6362, 12.9382>, <-0.120, 0.398, -0.909>, <5.9325, 9.0826, 12.7058>, <-0.188, 0.350, -0.918>, <6.4794, 8.8075, 12.4892>, <-0.120, 0.398, -0.909> }
	smooth_triangle { <6.4794, 8.8075, 12.4892>, <-0.120, 0.398, -0.909>, <6.3580, 9.3682, 12.7746>, <-0.051, 0.444, -0.894>, <5.8272, 9.6362, 12.9382>, <-0.120, 0.398, -0.909> }
	smooth_triangle { <6.9422, 10.4921, 13.1740>, <-0.493, 0.453, 0.742>, <6.6349, 10.6878, 12.8469>, <-0.504, 0.446, 0.740>, <6.6495, 11.1110, 12.6016>, <-0.493, 0.453, 0.742> }
	smooth_triangle { <6.6495, 11.1110, 12.6016>, <-0.493, 0.453, 0.742>, <6.9618, 10.9072, 12.9303>, <-0.483, 0.460, 0.745>, <6.9422, 10.4921, 13.1740>, <-0.493, 0.453, 0.742> }
	smooth_triangle { <7.8101, 11.5057, 13.6021>, <-0.500, 0.645, -0.578>, <7.8826, 11.1729, 13.1987>, <-0.565, 0.584, -0.583>, <8.2076, 11.1500, 12.8609>, <-0.500, 0.645, -0.578> }
	smooth_triangle { <8.2076, 11.1500, 12.8609>, <-0.500, 0.645, -0.578>, <8.1202, 11.4817, 13.3371>, <-0.431, 0.702, -0.568>, <7.8101, 11.5057, 13.6021>, <-0.500, 0.645, -0.578> }
	smooth_triangle { <8.5912, 12.6397, 14.0584>, <-0.595, 0.132, 0.793>, <8.2341, 12.8575, 13.7976>, <-0.481, 0.226, 0.847>, <8.1515, 13.4430, 13.5944>, <-0.595, 0.132, 0.793> }
	smooth_triangle { <8.1515, 13.4430, 13.5944>, <-0.595, 0.132, 0.793>, <8.5024, 13.2055, 13.9452>, <-0.695, 0.035, 0.718>, <8.5912, 12.6397, 14.0584>, <-0.595, 0.132, 0.793> }
	smooth_triangle { <1.6234, 6.7423, 12.0634>, <0.179, 0.733, -0.656>, <1.8490, 6.4419, 11.7572>, <0.241, 0.776, -0.583>, <2.3054, 6.2874, 11.7406>, <0.179, 0.733, -0.656> }
	smooth_triangle { <2.3054, 6.2874, 11.7406>, <0.179, 0.733, -0.656>, <2.0976, 6.6130, 12.0160>, <0.114, 0.683, -0.721>, <1.6234, 6.7423, 12.0634>, <0.179, 0.733, -0.656> }
	smooth_triangle { <2.0468, 7.1528, 12.6315>, <-0.711, -0.219, 0.668>, <1.6375, 7.5684, 12.3463>, <-0.691, -0.205, 0.693>, <1.5368, 8.2163, 12.4373>, <-0.711, -0.219, 0.668> }
	smooth_triangle { <1.5368, 8.2163, 12.4373>, <-0.711, -0.219, 0.668>, <1.9423, 7.7781, 12.7393>, <-0.730, -0.233, 0.642>, <2.0468, 7.1528, 12.6315>, <-0.711, -0.219, 0.668> }
	smooth_triangle { <3.0989, 7.9086, 13.2070>, <-0.296, 0.789, -0.538>, <3.2507, 7.6484, 12.7787>, <-0.356, 0.737, -0.574>, <3.7442, 7.6579, 12.4846>, <-0.296, 0.789, -0.538> }
	smooth_triangle { <3.7442, 7.6579, 12.4846>, <-0.296, 0.789, -0.538>, <3.5618, 7.9039, 12.9823>, <-0.233, 0.835, -0.498>, <3.0989, 7.9086, 13.2070>, <-0.296, 0.789, -0.538> }
	smooth_triangle { <4.0256, 8.7799, 13.8507>, <-0.331, -0.267, 0.905>, <3.5181, 9.0520, 13.7459>, <-0.330, -0.267, 0.906>, <3.3417, 9.6155, 13.8475>, <-0.331, -0.267, 0.905> }
	smooth_triangle { <3.3417, 9.6155, 13.8475>, <-0.331, -0.267, 0.905>, <3.8586, 9.3315, 13.9528>, <-0.331, -0.268, 0.905>, <4.0256, 8.7799, 13.8507>, <-0.331, -0.267, 0.905> }
	smooth_triangle { <5.2915, 9.3719, 14.1778>, <0.147, 0.189, -0.971>, <5.3697, 8.6592, 14.0547>, <0.137, 0.183, -0.973>, <5.9733, 8.2210, 14.0572>, <0.147, 0.189, -0.971> }
	smooth_triangle { <5.9733, 8.2210, 14.0572>, <0.147, 0.189, -0.971>, <5.8840, 8.9490, 14.1891>, <0.157, 0.195, -0.968>, <5.2915, 9.3719, 14.1778>, <0.147, 0.189, -0.971> }
	smooth_triangle { <6.4436, 10.1433, 14.5128>, <-0.216, -0.088, 0.972>, <5.9125, 10.5433, 14.4287>, <-0.223, -0.092, 0.970>, <5.8442, 11.2241, 14.4778>, <-0.216, -0.088, 0.972> }
	smooth_triangle { <5.8442, 11.2241, 14.4778>, <-0.216, -0.088, 0.972>, <6.3847, 10.8094, 14.5577>, <-0.208, -0.084, 0.974>, <6.4436, 10.1433, 14.5128>, <-0.216, -0.088, 0.972> }
	smooth_triangle { <7.7706, 10.3596, 15.0632>, <0.338, 0.225, -0.914>, <7.8284, 9.7186, 14.9264>, <0.339, 0.225, -0.914>, <8.4390, 9.1930, 15.0230>, <0.338, 0.225, -0.914> }
	smooth_triangle { <8.4390, 9.1930, 15.0230>, <0.338, 0.225, -0.914>, <8.3719, 9.8505, 15.1599>, <0.337, 0.225, -0.914>, <7.7706, 10.3596, 15.0632>, <0.338, 0.225, -0.914> }
	smooth_triangle { <8.9994, 10.7598, 15.5936>, <-0.481, 0.204, 0.852>, <8.6594, 11.0970, 15.2979>, <-0.557, 0.153, 0.816>, <8.6692, 11.5264, 15.2239>, <-0.481, 0.204, 0.852> }
	smooth_triangle { <8.6692, 11.5264, 15.2239>, <-0.481, 0.204, 0.852>, <9.0226, 11.1833, 15.4829>, <-0.401, 0.252, 0.881>, <8.9994, 10.7598, 15.5936>, <-0.481, 0.204, 0.852> }
	smooth_triangle { <0.6818, 6.9967, 11.9461>, <-0.898, -0.222, -0.379>, <0.8689, 7.2217, 11.4239>, <-0.861, -0.277, -0.428>, <0.8127, 7.7644, 11.1857>, <-0.898, -0.222, -0.379> }
	smooth_triangle { <0.8127, 7.7644, 11.1857>, <-0.898, -0.222, -0.379>, <0.6508, 7.4948, 11.7822>, <-0.930, -0.166, -0.327>, <0.6818, 6.9967, 11.9461>, <-0.898, -0.222, -0.379> }
	smooth_triangle { <0.2142, 7.4511, 12.4402>, <0.338, -0.456, 0.823>, <-0.1097, 6.9179, 12.2793>, <0.336, -0.453, 0.826>, <-0.7228, 6.7200, 12.4203>, <0.338, -0.456, 0.823> }
	smooth_triangle { <-0.7228, 6.7200, 12.4203>, <0.338, -0.456, 0.823>, <-0.3850, 7.2626, 12.5832>, <0.340, -0.458, 0.821>, <0.2142, 7.4511, 12.4402>, <0.338, -0.456, 0.823> }
	smooth_triangle { <0.1789, 8.9025, 12.5293>, <-0.674, -0.007, -0.739>, <0.5913, 8.7282, 12.0913>, <-0.679, 0.180, -0.711>, <0.9757, 9.0321, 11.8010>, <-0.674, -0.007, -0.739> }
	smooth_triangle { <0.9757, 9.0321, 11.8010>, <-0.674, -0.007, -0.739>, <0.5512, 9.2156, 12.1228>, <-0.644, -0.194, -0.740>, <0.1789, 8.9025, 12.5293>, <-0.674, -0.007, -0.739> }
	smooth_triangle { <-0.0297, 10.3042, 12.6869>, <-0.032, -0.085, 0.996>, <-0.6425, 9.9634, 12.6408>, <-0.033, -0.076, 0.997>, <-1.3214, 10.2021, 12.6367>, <-0.032, -0.085, 0.996> }
	smooth_triangle { <-1.3214, 10.2021, 12.6367>, <-0.032, -0.085, 0.996>, <-0.6904, 10.5438, 12.6890>, <-0.031, -0.095, 0.995>, <-0.0297, 10.3042, 12.6869>, <-0.032, -0.085, 0.996> }
	smooth_triangle { <-0.5660, 11.5718, 12.9760>, <-0.157, 0.146, -0.977>, <-0.0630, 11.6052, 12.8971>, <-0.163, 0.157, -0.974>, <0.2623, 12.0133, 12.9084>, <-0.157, 0.146, -0.977> }
	smooth_triangle { <0.2623, 12.0133, 12.9084>, <-0.157, 0.146, -0.977>, <-0.2529, 11.9747, 12.9828>, <-0.152, 0.134, -0.979>, <-0.5660, 11.5718, 12.9760>, <-0.157, 0.146, -0.977> }
	smooth_triangle { <-1.2779, 12.7810, 13.2259>, <-0.660, -0.584, 0.474>, <-1.5226, 12.4685, 12.4462>, <-0.616, -0.645, 0.452>, <-2.0431, 12.6702, 12.0240>, <-0.660, -0.584, 0.474> }
	smooth_triangle { <-2.0431, 12.6702, 12.0240>, <-0.660, -0.584, 0.474>, <-1.7969, 13.0024, 12.7228>, <-0.699, -0.519, 0.493>, <-1.2779, 12.7810, 13.2259>, <-0.660, -0.584, 0.474> }
	smooth_triangle { <-1.7561, 14.0421, 13.7123>, <-0.232, 0.233, -0.944>, <-1.1273, 14.0888, 13.5646>, <-0.239, 0.246, -0.939>, <-0.6954, 14.6152, 13.5929>, <-0.232, 0.233, -0.944> }
	smooth_triangle { <-0.6954, 14.6152, 13.5929>, <-0.232, 0.233, -0.944>, <-1.3400, 14.5621, 13.7336>, <-0.225, 0.219, -0.949>, <-1.7561, 14.0421, 13.7123>, <-0.232, 0.233, -0.944> }
	smooth_triangle { <-2.3969, 15.2353, 14.1325>, <-0.418, -0.514, 0.749>, <-2.7714, 14.8167, 13.6679>, <-0.457, -0.446, 0.770>, <-3.3913, 14.9075, 13.3528>, <-0.418, -0.514, 0.749> }
	smooth_triangle { <-3.3913, 14.9075, 13.3528>, <-0.418, -0.514, 0.749>, <-2.9970, 15.3196, 13.8881>, <-0.376, -0.579, 0.723>, <-2.3969, 15.2353, 14.1325>, <-0.418, -0.514, 0.749> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0019B' */
union {
	smooth_triangle { <-0.0198, 3.2984, 10.2210>, <0.675, -0.231, 0.701>, <0.7180, 1.8296, 9.0263>, <0.651, -0.185, 0.736>, <0.6982, 1.8095, 9.0388>, <0.403, -0.379, 0.833> }
	smooth_triangle { <-0.0198, 3.2984, 10.2210>, <0.675, -0.231, 0.701>, <0.6982, 1.8095, 9.0388>, <0.403, -0.379, 0.833>, <-0.0397, 3.2783, 10.2335>, <0.090, -0.601, 0.794> }
	smooth_triangle { <-0.0397, 3.2783, 10.2335>, <0.090, -0.601, 0.794>, <0.6982, 1.8095, 9.0388>, <0.403, -0.379, 0.833>, <0.6702, 1.8056, 9.0263>, <-0.518, -0.651, 0.555> }
	smooth_triangle { <-0.0397, 3.2783, 10.2335>, <0.090, -0.601, 0.794>, <0.6702, 1.8056, 9.0263>, <-0.518, -0.651, 0.555>, <-0.0677, 3.2744, 10.2210>, <-0.758, -0.596, 0.265> }
	smooth_triangle { <-0.0677, 3.2744, 10.2210>, <-0.758, -0.596, 0.265>, <0.6702, 1.8056, 9.0263>, <-0.518, -0.651, 0.555>, <0.6620, 1.8218, 9.0013>, <-0.921, -0.272, -0.278> }
	smooth_triangle { <-0.0677, 3.2744, 10.2210>, <-0.758, -0.596, 0.265>, <0.6620, 1.8218, 9.0013>, <-0.921, -0.272, -0.278>, <-0.0758, 3.2906, 10.1960>, <-0.848, 0.005, -0.530> }
	smooth_triangle { <-0.0758, 3.2906, 10.1960>, <-0.848, 0.005, -0.530>, <0.6620, 1.8218, 9.0013>, <-0.921, -0.272, -0.278>, <0.6818, 1.8419, 8.9888>, <-0.403, 0.380, -0.833> }
	smooth_triangle { <-0.0758, 3.2906, 10.1960>, <-0.848, 0.005, -0.530>, <0.6818, 1.8419, 8.9888>, <-0.403, 0.380, -0.833>, <-0.0560, 3.3108, 10.1835>, <-0.090, 0.601, -0.794> }
	smooth_triangle { <-0.0560, 3.3108, 10.1835>, <-0.090, 0.601, -0.794>, <0.6818, 1.8419, 8.9888>, <-0.403, 0.380, -0.833>, <0.7098, 1.8458, 9.0013>, <0.518, 0.652, -0.554> }
	smooth_triangle { <-0.0560, 3.3108, 10.1835>, <-0.090, 0.601, -0.794>, <0.7098, 1.8458, 9.0013>, <0.518, 0.652, -0.554>, <-0.0280, 3.3147, 10.1960>, <0.758, 0.596, -0.265> }
	smooth_triangle { <-0.0280, 3.3147, 10.1960>, <0.758, 0.596, -0.265>, <0.7098, 1.8458, 9.0013>, <0.518, 0.652, -0.554>, <0.7180, 1.8296, 9.0263>, <0.892, 0.452, 0.001> }
	smooth_triangle { <-0.0280, 3.3147, 10.1960>, <0.758, 0.596, -0.265>, <0.7180, 1.8296, 9.0263>, <0.892, 0.452, 0.001>, <-0.0198, 3.2984, 10.2210>, <0.894, 0.449, 0.000> }
	smooth_triangle { <-1.3992, 5.9585, 11.4921>, <0.615, -0.106, 0.782>, <0.7180, 1.8296, 9.0263>, <0.651, -0.185, 0.736>, <0.6982, 1.8095, 9.0388>, <0.403, -0.379, 0.833> }
	smooth_triangle { <-1.3992, 5.9585, 11.4921>, <0.615, -0.106, 0.782>, <0.6982, 1.8095, 9.0388>, <0.403, -0.379, 0.833>, <-1.4164, 5.9440, 11.5038>, <0.183, -0.361, 0.914> }
	smooth_triangle { <-1.4164, 5.9440, 11.5038>, <0.183, -0.361, 0.914>, <0.6982, 1.8095, 9.0388>, <0.403, -0.379, 0.833>, <0.6702, 1.8056, 9.0263>, <-0.518, -0.651, 0.555> }
	smooth_triangle { <-1.4164, 5.9440, 11.5038>, <0.183, -0.361, 0.914>, <0.6702, 1.8056, 9.0263>, <-0.518, -0.651, 0.555>, <-1.4383, 5.9384, 11.4921>, <-0.694, -0.548, 0.467> }
	smooth_triangle { <-1.4383, 5.9384, 11.4921>, <-0.694, -0.548, 0.467>, <0.6702, 1.8056, 9.0263>, <-0.518, -0.651, 0.555>, <0.6620, 1.8218, 9.0013>, <-0.921, -0.272, -0.278> }
	smooth_triangle { <-1.4383, 5.9384, 11.4921>, <-0.694, -0.548, 0.467>, <0.6620, 1.8218, 9.0013>, <-0.921, -0.272, -0.278>, <-1.4428, 5.9472, 11.4688>, <-0.876, -0.186, -0.446> }
	smooth_triangle { <-1.4428, 5.9472, 11.4688>, <-0.876, -0.186, -0.446>, <0.6620, 1.8218, 9.0013>, <-0.921, -0.272, -0.278>, <0.6818, 1.8419, 8.9888>, <-0.403, 0.380, -0.833> }
	smooth_triangle { <-1.4428, 5.9472, 11.4688>, <-0.876, -0.186, -0.446>, <0.6818, 1.8419, 8.9888>, <-0.403, 0.380, -0.833>, <-1.4256, 5.9617, 11.4571>, <-0.184, 0.362, -0.914> }
	smooth_triangle { <-1.4256, 5.9617, 11.4571>, <-0.184, 0.362, -0.914>, <0.6818, 1.8419, 8.9888>, <-0.403, 0.380, -0.833>, <0.7098, 1.8458, 9.0013>, <0.518, 0.652, -0.554> }
	smooth_triangle { <-1.4256, 5.9617, 11.4571>, <-0.184, 0.362, -0.914>, <0.7098, 1.8458, 9.0013>, <0.518, 0.652, -0.554>, <-1.4037, 5.9674, 11.4688>, <0.694, 0.549, -0.467> }
	smooth_triangle { <-1.4037, 5.9674, 11.4688>, <0.694, 0.549, -0.467>, <0.7098, 1.8458, 9.0013>, <0.518, 0.652, -0.554>, <0.7180, 1.8296, 9.0263>, <0.892, 0.452, 0.001> }
	smooth_triangle { <-1.4037, 5.9674, 11.4688>, <0.694, 0.549, -0.467>, <0.7180, 1.8296, 9.0263>, <0.892, 0.452, 0.001>, <-1.3992, 5.9585, 11.4921>, <0.903, 0.429, -0.007> }
	smooth_triangle { <-2.5062, 8.4031, 12.4356>, <0.657, -0.263, 0.707>, <-1.3992, 5.9585, 11.4921>, <0.615, -0.106, 0.782>, <-1.4164, 5.9440, 11.5038>, <0.183, -0.361, 0.914> }
	smooth_triangle { <-2.5062, 8.4031, 12.4356>, <0.657, -0.263, 0.707>, <-1.4164, 5.9440, 11.5038>, <0.183, -0.361, 0.914>, <-2.5245, 8.3902, 12.4476>, <0.277, -0.636, 0.720> }
	smooth_triangle { <-2.5245, 8.3902, 12.4476>, <0.149, -0.617, 0.773>, <-1.4164, 5.9440, 11.5038>, <0.183, -0.361, 0.914>, <-1.4383, 5.9384, 11.4921>, <-0.694, -0.548, 0.467> }
	smooth_triangle { <-2.5245, 8.3902, 12.4476>, <0.149, -0.617, 0.773>, <-1.4383, 5.9384, 11.4921>, <-0.694, -0.548, 0.467>, <-2.5463, 8.3849, 12.4356>, <-0.646, -0.697, 0.311> }
	smooth_triangle { <-2.5463, 8.3849, 12.4356>, <-0.646, -0.697, 0.311>, <-1.4383, 5.9384, 11.4921>, <-0.694, -0.548, 0.467>, <-1.4428, 5.9472, 11.4688>, <-0.876, -0.186, -0.446> }
	smooth_triangle { <-2.5463, 8.3849, 12.4356>, <-0.646, -0.697, 0.311>, <-1.4428, 5.9472, 11.4688>, <-0.876, -0.186, -0.446>, <-2.5498, 8.3926, 12.4117>, <-0.917, -0.079, -0.392> }
	smooth_triangle { <-2.5498, 8.3926, 12.4117>, <-0.917, -0.079, -0.392>, <-1.4428, 5.9472, 11.4688>, <-0.876, -0.186, -0.446>, <-1.4256, 5.9617, 11.4571>, <-0.184, 0.362, -0.914> }
	smooth_triangle { <-2.5498, 8.3926, 12.4117>, <-0.917, -0.079, -0.392>, <-1.4256, 5.9617, 11.4571>, <-0.184, 0.362, -0.914>, <-2.5315, 8.4055, 12.3997>, <-0.275, 0.634, -0.723> }
	smooth_triangle { <-2.5315, 8.4055, 12.3997>, <-0.148, 0.615, -0.775>, <-1.4256, 5.9617, 11.4571>, <-0.184, 0.362, -0.914>, <-1.4037, 5.9674, 11.4688>, <0.694, 0.549, -0.467> }
	smooth_triangle { <-2.5315, 8.4055, 12.3997>, <-0.148, 0.615, -0.775>, <-1.4037, 5.9674, 11.4688>, <0.694, 0.549, -0.467>, <-2.5097, 8.4107, 12.4117>, <0.647, 0.696, -0.313> }
	smooth_triangle { <-2.5097, 8.4107, 12.4117>, <0.647, 0.696, -0.313>, <-1.4037, 5.9674, 11.4688>, <0.694, 0.549, -0.467>, <-1.3992, 5.9585, 11.4921>, <0.903, 0.429, -0.007> }
	smooth_triangle { <-2.5097, 8.4107, 12.4117>, <0.647, 0.696, -0.313>, <-1.3992, 5.9585, 11.4921>, <0.903, 0.429, -0.007>, <-2.5062, 8.4031, 12.4356>, <0.926, 0.378, -0.005> }
	smooth_triangle { <-2.7832, 9.1548, 14.2922>, <0.869, -0.464, 0.174>, <-2.5062, 8.4031, 12.4356>, <0.657, -0.263, 0.707>, <-2.5245, 8.3902, 12.4476>, <0.277, -0.636, 0.720> }
	smooth_triangle { <-2.7832, 9.1548, 14.2922>, <0.869, -0.464, 0.174>, <-2.5245, 8.3902, 12.4476>, <0.571, -0.621, 0.537>, <-2.7998, 9.1363, 14.2973>, <0.247, -0.844, 0.476> }
	smooth_triangle { <-2.7998, 9.1363, 14.2973>, <0.247, -0.844, 0.476>, <-2.5245, 8.3902, 12.4476>, <0.277, -0.636, 0.720>, <-2.5463, 8.3849, 12.4356>, <-0.554, -0.746, 0.369> }
	smooth_triangle { <-2.7998, 9.1363, 14.2973>, <0.247, -0.844, 0.476>, <-2.5463, 8.3849, 12.4356>, <-0.646, -0.697, 0.311>, <-2.8245, 9.1396, 14.2922>, <-0.745, -0.572, 0.343> }
	smooth_triangle { <-2.8245, 9.1396, 14.2922>, <-0.745, -0.572, 0.343>, <-2.5463, 8.3849, 12.4356>, <-0.754, -0.597, 0.275>, <-2.5498, 8.3926, 12.4117>, <-0.917, -0.079, -0.392> }
	smooth_triangle { <-2.8245, 9.1396, 14.2922>, <-0.745, -0.572, 0.343>, <-2.5498, 8.3926, 12.4117>, <-0.917, -0.079, -0.392>, <-2.8325, 9.1615, 14.2821>, <-0.941, 0.308, -0.138> }
	smooth_triangle { <-2.8325, 9.1615, 14.2821>, <-0.941, 0.308, -0.138>, <-2.5498, 8.3926, 12.4117>, <-0.917, -0.079, -0.392>, <-2.5315, 8.4055, 12.3997>, <-0.275, 0.634, -0.723> }
	smooth_triangle { <-2.8325, 9.1615, 14.2821>, <-0.941, 0.308, -0.138>, <-2.5315, 8.4055, 12.3997>, <-0.570, 0.618, -0.541>, <-2.8159, 9.1800, 14.2770>, <-0.247, 0.847, -0.471> }
	smooth_triangle { <-2.8159, 9.1800, 14.2770>, <-0.247, 0.847, -0.471>, <-2.5315, 8.4055, 12.3997>, <-0.275, 0.634, -0.723>, <-2.5097, 8.4107, 12.4117>, <0.555, 0.745, -0.371> }
	smooth_triangle { <-2.8159, 9.1800, 14.2770>, <-0.247, 0.847, -0.471>, <-2.5097, 8.4107, 12.4117>, <0.647, 0.696, -0.313>, <-2.7912, 9.1767, 14.2821>, <0.745, 0.577, -0.336> }
	smooth_triangle { <-2.7912, 9.1767, 14.2821>, <0.745, 0.577, -0.336>, <-2.5097, 8.4107, 12.4117>, <0.754, 0.596, -0.275>, <-2.5062, 8.4031, 12.4356>, <0.926, 0.378, -0.005> }
	smooth_triangle { <-2.7912, 9.1767, 14.2821>, <0.745, 0.577, -0.336>, <-2.5062, 8.4031, 12.4356>, <0.926, 0.378, -0.005>, <-2.7832, 9.1548, 14.2922>, <0.938, 0.345, 0.000> }
	smooth_triangle { <-2.3560, 10.4887, 15.7550>, <0.745, -0.584, 0.323>, <-2.7832, 9.1548, 14.2922>, <0.869, -0.464, 0.174>, <-2.7998, 9.1363, 14.2973>, <0.247, -0.844, 0.476> }
	smooth_triangle { <-2.3560, 10.4887, 15.7550>, <-0.189, -0.687, 0.702>, <-2.7998, 9.1363, 14.2973>, <0.247, -0.844, 0.476>, <-2.8245, 9.1396, 14.2922>, <-0.745, -0.572, 0.343> }
	smooth_triangle { <-2.3560, 10.4887, 15.7550>, <-0.911, -0.107, 0.398>, <-2.8245, 9.1396, 14.2922>, <-0.745, -0.572, 0.343>, <-2.8325, 9.1615, 14.2821>, <-0.941, 0.308, -0.138> }
	smooth_triangle { <-2.3560, 10.4887, 15.7550>, <-0.743, 0.601, -0.294>, <-2.8325, 9.1615, 14.2821>, <-0.941, 0.308, -0.138>, <-2.8159, 9.1800, 14.2770>, <-0.247, 0.847, -0.471> }
	smooth_triangle { <-2.3560, 10.4887, 15.7550>, <0.192, 0.708, -0.680>, <-2.8159, 9.1800, 14.2770>, <-0.247, 0.847, -0.471>, <-2.7912, 9.1767, 14.2821>, <0.745, 0.577, -0.336> }
	smooth_triangle { <-2.3560, 10.4887, 15.7550>, <0.919, 0.124, -0.375>, <-2.7912, 9.1767, 14.2821>, <0.745, 0.577, -0.336>, <-2.7832, 9.1548, 14.2922>, <0.869, -0.464, 0.174> }

	texture { PSWL_BARK }
}

/* Object 'PWL0019F' */
union {
	smooth_triangle { <-0.6916, 4.6524, 10.8306>, <-0.435, 0.229, -0.871>, <-0.0096, 4.7770, 10.4988>, <-0.461, 0.281, -0.842>, <0.4327, 5.4071, 10.4671>, <-0.435, 0.229, -0.871> }
	smooth_triangle { <0.4327, 5.4071, 10.4671>, <-0.435, 0.229, -0.871>, <-0.2729, 5.2867, 10.7647>, <-0.408, 0.176, -0.896>, <-0.6916, 4.6524, 10.8306>, <-0.435, 0.229, -0.871> }
	smooth_triangle { <-1.4626, 5.9471, 11.4476>, <-0.499, -0.487, 0.717>, <-1.7644, 5.6679, 11.0819>, <-0.533, -0.400, 0.745>, <-2.3069, 5.8301, 10.7806>, <-0.499, -0.487, 0.717> }
	smooth_triangle { <-2.3069, 5.8301, 10.7806>, <-0.499, -0.487, 0.717>, <-1.9815, 6.0883, 11.2158>, <-0.459, -0.570, 0.682>, <-1.4626, 5.9471, 11.4476>, <-0.499, -0.487, 0.717> }
	smooth_triangle { <-1.9456, 7.2023, 11.9162>, <-0.752, -0.068, -0.656>, <-1.5574, 7.2436, 11.5359>, <-0.669, -0.225, -0.708>, <-1.3651, 7.7433, 11.1951>, <-0.752, -0.068, -0.656> }
	smooth_triangle { <-1.3651, 7.7433, 11.1951>, <-0.752, -0.068, -0.656>, <-1.7438, 7.6554, 11.7072>, <-0.808, 0.091, -0.582>, <-1.9456, 7.2023, 11.9162>, <-0.752, -0.068, -0.656> }
	smooth_triangle { <-2.5704, 8.3908, 12.3921>, <-0.498, -0.417, 0.761>, <-2.9929, 8.0252, 11.8949>, <-0.480, -0.460, 0.747>, <-3.6803, 8.2074, 11.5649>, <-0.498, -0.417, 0.761> }
	smooth_triangle { <-3.6803, 8.2074, 11.5649>, <-0.498, -0.417, 0.761>, <-3.2475, 8.5876, 12.0362>, <-0.514, -0.372, 0.773>, <-2.5704, 8.3908, 12.3921>, <-0.498, -0.417, 0.761> }
	smooth_triangle { <-2.6431, 8.8229, 13.3408>, <-0.879, 0.403, -0.254>, <-2.3182, 9.2269, 12.9201>, <-0.872, 0.382, -0.307>, <-2.0665, 9.8668, 13.0015>, <-0.879, 0.403, -0.254> }
	smooth_triangle { <-2.0665, 9.8668, 13.0015>, <-0.879, 0.403, -0.254>, <-2.3856, 9.4101, 13.4446>, <-0.884, 0.423, -0.201>, <-2.6431, 8.8229, 13.3408>, <-0.879, 0.403, -0.254> }
	smooth_triangle { <-2.8606, 9.1578, 14.2794>, <-0.045, -0.938, 0.344>, <-3.3530, 9.0482, 13.9822>, <-0.058, -0.901, 0.429>, <-3.9390, 9.1516, 14.1199>, <-0.045, -0.938, 0.344> }
	smooth_triangle { <-3.9390, 9.1516, 14.1199>, <-0.045, -0.938, 0.344>, <-3.4158, 9.2187, 14.4390>, <-0.032, -0.966, 0.256>, <-2.8606, 9.1578, 14.2794>, <-0.045, -0.938, 0.344> }
	smooth_triangle { <-2.5489, 9.8637, 15.0096>, <-0.778, 0.554, -0.295>, <-2.2824, 10.1491, 14.6962>, <-0.784, 0.612, -0.110>, <-1.8678, 10.6941, 14.7731>, <-0.778, 0.554, -0.295> }
	smooth_triangle { <-1.8678, 10.6941, 14.7731>, <-0.778, 0.554, -0.295>, <-2.1761, 10.4844, 15.0493>, <-0.744, 0.477, -0.469>, <-2.5489, 9.8637, 15.0096>, <-0.778, 0.554, -0.295> }
	smooth_triangle { <-2.4019, 10.5107, 15.7391>, <-0.481, -0.467, 0.742>, <-2.9764, 10.5440, 15.3722>, <-0.487, -0.497, 0.718>, <-3.4685, 11.0228, 15.3700>, <-0.481, -0.467, 0.742> }
	smooth_triangle { <-3.4685, 11.0228, 15.3700>, <-0.481, -0.467, 0.742>, <-2.8925, 11.0191, 15.7250>, <-0.474, -0.436, 0.765>, <-2.4019, 10.5107, 15.7391>, <-0.481, -0.467, 0.742> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0020B' */
union {
	smooth_triangle { <1.9596, 1.8275, 10.6013>, <-0.649, -0.526, 0.550>, <0.6704, 1.7765, 9.0316>, <-0.599, -0.523, 0.607>, <0.6469, 1.8240, 9.0493>, <-0.699, -0.232, 0.677> }
	smooth_triangle { <1.9596, 1.8275, 10.6013>, <-0.649, -0.526, 0.550>, <0.6469, 1.8240, 9.0493>, <-0.699, -0.232, 0.677>, <1.9362, 1.8750, 10.6191>, <-0.765, 0.159, 0.624> }
	smooth_triangle { <1.9362, 1.8750, 10.6191>, <-0.765, 0.159, 0.624>, <0.6469, 1.8240, 9.0493>, <-0.699, -0.232, 0.677>, <0.6665, 1.8732, 9.0316>, <-0.529, 0.725, 0.441> }
	smooth_triangle { <1.9362, 1.8750, 10.6191>, <-0.765, 0.159, 0.624>, <0.6665, 1.8732, 9.0316>, <-0.529, 0.725, 0.441>, <1.9558, 1.9242, 10.6013>, <-0.290, 0.934, 0.208> }
	smooth_triangle { <1.9558, 1.9242, 10.6013>, <-0.290, 0.934, 0.208>, <0.6665, 1.8732, 9.0316>, <-0.529, 0.725, 0.441>, <0.7096, 1.8749, 8.9961>, <0.172, 0.957, -0.234> }
	smooth_triangle { <1.9558, 1.9242, 10.6013>, <-0.290, 0.934, 0.208>, <0.7096, 1.8749, 8.9961>, <0.172, 0.957, -0.234>, <1.9989, 1.9259, 10.5659>, <0.475, 0.775, -0.416> }
	smooth_triangle { <1.9989, 1.9259, 10.5659>, <0.475, 0.775, -0.416>, <0.7096, 1.8749, 8.9961>, <0.172, 0.957, -0.234>, <0.7331, 1.8274, 8.9784>, <0.703, 0.232, -0.673> }
	smooth_triangle { <1.9989, 1.9259, 10.5659>, <0.475, 0.775, -0.416>, <0.7331, 1.8274, 8.9784>, <0.703, 0.232, -0.673>, <2.0224, 1.8784, 10.5481>, <0.765, -0.159, -0.624> }
	smooth_triangle { <2.0224, 1.8784, 10.5481>, <0.765, -0.159, -0.624>, <0.7331, 1.8274, 8.9784>, <0.703, 0.232, -0.673>, <0.7135, 1.7782, 8.9961>, <0.533, -0.725, -0.437> }
	smooth_triangle { <2.0224, 1.8784, 10.5481>, <0.765, -0.159, -0.624>, <0.7135, 1.7782, 8.9961>, <0.533, -0.725, -0.437>, <2.0027, 1.8292, 10.5659>, <0.290, -0.934, -0.208> }
	smooth_triangle { <2.0027, 1.8292, 10.5659>, <0.290, -0.934, -0.208>, <0.7135, 1.7782, 8.9961>, <0.533, -0.725, -0.437>, <0.6704, 1.7765, 9.0316>, <0.079, -0.997, 0.009> }
	smooth_triangle { <2.0027, 1.8292, 10.5659>, <0.290, -0.934, -0.208>, <0.6704, 1.7765, 9.0316>, <0.079, -0.997, 0.009>, <1.9596, 1.8275, 10.6013>, <0.040, -0.999, 0.000> }
	smooth_triangle { <4.4958, 2.2967, 12.5990>, <-0.547, -0.572, 0.611>, <0.6704, 1.7765, 9.0316>, <-0.599, -0.523, 0.607>, <0.6469, 1.8240, 9.0493>, <-0.699, -0.232, 0.677> }
	smooth_triangle { <4.4958, 2.2967, 12.5990>, <-0.547, -0.572, 0.611>, <0.6469, 1.8240, 9.0493>, <-0.699, -0.232, 0.677>, <4.4843, 2.3171, 12.6089>, <-0.715, -0.095, 0.693> }
	smooth_triangle { <4.4843, 2.3171, 12.6089>, <-0.715, -0.095, 0.693>, <0.6469, 1.8240, 9.0493>, <-0.699, -0.232, 0.677>, <0.6665, 1.8732, 9.0316>, <-0.529, 0.725, 0.441> }
	smooth_triangle { <4.4843, 2.3171, 12.6089>, <-0.715, -0.095, 0.693>, <0.6665, 1.8732, 9.0316>, <-0.529, 0.725, 0.441>, <4.4882, 2.3401, 12.5990>, <-0.462, 0.813, 0.354> }
	smooth_triangle { <4.4882, 2.3401, 12.5990>, <-0.462, 0.813, 0.354>, <0.6665, 1.8732, 9.0316>, <-0.529, 0.725, 0.441>, <0.7096, 1.8749, 8.9961>, <0.172, 0.957, -0.234> }
	smooth_triangle { <4.4882, 2.3401, 12.5990>, <-0.462, 0.813, 0.354>, <0.7096, 1.8749, 8.9961>, <0.172, 0.957, -0.234>, <4.5036, 2.3428, 12.5790>, <0.256, 0.906, -0.338> }
	smooth_triangle { <4.5036, 2.3428, 12.5790>, <0.256, 0.906, -0.338>, <0.7096, 1.8749, 8.9961>, <0.172, 0.957, -0.234>, <0.7331, 1.8274, 8.9784>, <0.703, 0.232, -0.673> }
	smooth_triangle { <4.5036, 2.3428, 12.5790>, <0.256, 0.906, -0.338>, <0.7331, 1.8274, 8.9784>, <0.703, 0.232, -0.673>, <4.5151, 2.3225, 12.5690>, <0.718, 0.095, -0.689> }
	smooth_triangle { <4.5151, 2.3225, 12.5690>, <0.718, 0.095, -0.689>, <0.7331, 1.8274, 8.9784>, <0.703, 0.232, -0.673>, <0.7135, 1.7782, 8.9961>, <0.533, -0.725, -0.437> }
	smooth_triangle { <4.5151, 2.3225, 12.5690>, <0.718, 0.095, -0.689>, <0.7135, 1.7782, 8.9961>, <0.533, -0.725, -0.437>, <4.5112, 2.2995, 12.5790>, <0.466, -0.813, -0.350> }
	smooth_triangle { <4.5112, 2.2995, 12.5790>, <0.466, -0.813, -0.350>, <0.7135, 1.7782, 8.9961>, <0.533, -0.725, -0.437>, <0.6704, 1.7765, 9.0316>, <0.079, -0.997, 0.009> }
	smooth_triangle { <4.5112, 2.2995, 12.5790>, <0.466, -0.813, -0.350>, <0.6704, 1.7765, 9.0316>, <0.079, -0.997, 0.009>, <4.4958, 2.2967, 12.5990>, <0.111, -0.994, -0.021> }
	smooth_triangle { <6.3523, 2.4200, 14.7457>, <-0.555, -0.557, 0.618>, <4.4958, 2.2967, 12.5990>, <-0.547, -0.572, 0.611>, <4.4843, 2.3171, 12.6089>, <-0.715, -0.095, 0.693> }
	smooth_triangle { <6.3523, 2.4200, 14.7457>, <-0.555, -0.557, 0.618>, <4.4843, 2.3171, 12.6089>, <-0.715, -0.095, 0.693>, <6.3413, 2.4414, 14.7540>, <-0.653, -0.056, 0.755> }
	smooth_triangle { <6.3413, 2.4414, 14.7540>, <-0.653, -0.056, 0.755>, <4.4843, 2.3171, 12.6089>, <-0.715, -0.095, 0.693>, <4.4882, 2.3401, 12.5990>, <-0.462, 0.813, 0.354> }
	smooth_triangle { <6.3413, 2.4414, 14.7540>, <-0.653, -0.056, 0.755>, <4.4882, 2.3401, 12.5990>, <-0.462, 0.813, 0.354>, <6.3494, 2.4639, 14.7457>, <-0.364, 0.840, 0.403> }
	smooth_triangle { <6.3494, 2.4639, 14.7457>, <-0.364, 0.840, 0.403>, <4.4882, 2.3401, 12.5990>, <-0.462, 0.813, 0.354>, <4.5036, 2.3428, 12.5790>, <0.256, 0.906, -0.338> }
	smooth_triangle { <6.3494, 2.4639, 14.7457>, <-0.364, 0.840, 0.403>, <4.5036, 2.3428, 12.5790>, <0.256, 0.906, -0.338>, <6.3685, 2.4652, 14.7290>, <0.287, 0.892, -0.349> }
	smooth_triangle { <6.3685, 2.4652, 14.7290>, <0.287, 0.892, -0.349>, <4.5036, 2.3428, 12.5790>, <0.256, 0.906, -0.338>, <4.5151, 2.3225, 12.5690>, <0.718, 0.095, -0.689> }
	smooth_triangle { <6.3685, 2.4652, 14.7290>, <0.287, 0.892, -0.349>, <4.5151, 2.3225, 12.5690>, <0.718, 0.095, -0.689>, <6.3795, 2.4439, 14.7207>, <0.653, 0.056, -0.755> }
	smooth_triangle { <6.3795, 2.4439, 14.7207>, <0.653, 0.056, -0.755>, <4.5151, 2.3225, 12.5690>, <0.718, 0.095, -0.689>, <4.5112, 2.2995, 12.5790>, <0.466, -0.813, -0.350> }
	smooth_triangle { <6.3795, 2.4439, 14.7207>, <0.653, 0.056, -0.755>, <4.5112, 2.2995, 12.5790>, <0.466, -0.813, -0.350>, <6.3714, 2.4213, 14.7290>, <0.364, -0.840, -0.403> }
	smooth_triangle { <6.3714, 2.4213, 14.7290>, <0.364, -0.840, -0.403>, <4.5112, 2.2995, 12.5790>, <0.466, -0.813, -0.350>, <4.4958, 2.2967, 12.5990>, <0.111, -0.994, -0.021> }
	smooth_triangle { <6.3714, 2.4213, 14.7290>, <0.364, -0.840, -0.403>, <4.4958, 2.2967, 12.5990>, <0.111, -0.994, -0.021>, <6.3523, 2.4200, 14.7457>, <0.052, -0.999, -0.006> }
	smooth_triangle { <8.0655, 2.4875, 15.8420>, <-0.325, -0.705, 0.630>, <6.3523, 2.4200, 14.7457>, <-0.555, -0.557, 0.618>, <6.3413, 2.4414, 14.7540>, <-0.653, -0.056, 0.755> }
	smooth_triangle { <8.0655, 2.4875, 15.8420>, <-0.325, -0.705, 0.630>, <6.3413, 2.4414, 14.7540>, <-0.653, -0.056, 0.755>, <8.0578, 2.5092, 15.8527>, <-0.525, 0.087, 0.847> }
	smooth_triangle { <8.0578, 2.5092, 15.8527>, <-0.525, 0.087, 0.847>, <6.3413, 2.4414, 14.7540>, <-0.653, -0.056, 0.755>, <6.3494, 2.4639, 14.7457>, <-0.364, 0.840, 0.403> }
	smooth_triangle { <8.0578, 2.5092, 15.8527>, <-0.525, 0.087, 0.847>, <6.3494, 2.4639, 14.7457>, <-0.364, 0.840, 0.403>, <8.0638, 2.5315, 15.8420>, <-0.263, 0.906, 0.331> }
	smooth_triangle { <8.0638, 2.5315, 15.8420>, <-0.263, 0.906, 0.331>, <6.3494, 2.4639, 14.7457>, <-0.364, 0.840, 0.403>, <6.3685, 2.4652, 14.7290>, <0.287, 0.892, -0.349> }
	smooth_triangle { <8.0638, 2.5315, 15.8420>, <-0.263, 0.906, 0.331>, <6.3685, 2.4652, 14.7290>, <0.287, 0.892, -0.349>, <8.0774, 2.5320, 15.8206>, <0.268, 0.813, -0.516> }
	smooth_triangle { <8.0774, 2.5320, 15.8206>, <0.268, 0.813, -0.516>, <6.3685, 2.4652, 14.7290>, <0.287, 0.892, -0.349>, <6.3795, 2.4439, 14.7207>, <0.653, 0.056, -0.755> }
	smooth_triangle { <8.0774, 2.5320, 15.8206>, <0.268, 0.813, -0.516>, <6.3795, 2.4439, 14.7207>, <0.653, 0.056, -0.755>, <8.0851, 2.5103, 15.8099>, <0.533, -0.087, -0.842> }
	smooth_triangle { <8.0851, 2.5103, 15.8099>, <0.533, -0.087, -0.842>, <6.3795, 2.4439, 14.7207>, <0.653, 0.056, -0.755>, <6.3714, 2.4213, 14.7290>, <0.364, -0.840, -0.403> }
	smooth_triangle { <8.0851, 2.5103, 15.8099>, <0.533, -0.087, -0.842>, <6.3714, 2.4213, 14.7290>, <0.364, -0.840, -0.403>, <8.0792, 2.4881, 15.8206>, <0.272, -0.906, -0.326> }
	smooth_triangle { <8.0792, 2.4881, 15.8206>, <0.272, -0.906, -0.326>, <6.3714, 2.4213, 14.7290>, <0.364, -0.840, -0.403>, <6.3523, 2.4200, 14.7457>, <0.052, -0.999, -0.006> }
	smooth_triangle { <8.0792, 2.4881, 15.8206>, <0.272, -0.906, -0.326>, <6.3523, 2.4200, 14.7457>, <0.052, -0.999, -0.006>, <8.0655, 2.4875, 15.8420>, <0.039, -0.999, 0.000> }
	smooth_triangle { <9.8049, 2.7226, 16.8701>, <-0.380, -0.512, 0.770>, <8.0655, 2.4875, 15.8420>, <-0.325, -0.705, 0.630>, <8.0578, 2.5092, 15.8527>, <-0.525, 0.087, 0.847> }
	smooth_triangle { <9.8049, 2.7226, 16.8701>, <-0.480, 0.482, 0.733>, <8.0578, 2.5092, 15.8527>, <-0.525, 0.087, 0.847>, <8.0638, 2.5315, 15.8420>, <-0.263, 0.906, 0.331> }
	smooth_triangle { <9.8049, 2.7226, 16.8701>, <-0.086, 0.996, -0.029>, <8.0638, 2.5315, 15.8420>, <-0.263, 0.906, 0.331>, <8.0774, 2.5320, 15.8206>, <0.268, 0.813, -0.516> }
	smooth_triangle { <9.8049, 2.7226, 16.8701>, <0.408, 0.515, -0.754>, <8.0774, 2.5320, 15.8206>, <0.268, 0.813, -0.516>, <8.0851, 2.5103, 15.8099>, <0.533, -0.087, -0.842> }
	smooth_triangle { <9.8049, 2.7226, 16.8701>, <0.507, -0.480, -0.716>, <8.0851, 2.5103, 15.8099>, <0.533, -0.087, -0.842>, <8.0792, 2.4881, 15.8206>, <0.272, -0.906, -0.326> }
	smooth_triangle { <9.8049, 2.7226, 16.8701>, <0.113, -0.993, 0.046>, <8.0792, 2.4881, 15.8206>, <0.272, -0.906, -0.326>, <8.0655, 2.4875, 15.8420>, <-0.325, -0.705, 0.630> }
	smooth_triangle { <5.9111, 1.6155, 12.9828>, <-0.400, -0.362, 0.842>, <4.4875, 2.3012, 12.6013>, <-0.440, -0.342, 0.830>, <4.4943, 2.3224, 12.6136>, <-0.379, -0.070, 0.923> }
	smooth_triangle { <5.9111, 1.6155, 12.9828>, <-0.400, -0.362, 0.842>, <4.4943, 2.3224, 12.6136>, <-0.379, -0.070, 0.923>, <5.9180, 1.6366, 12.9951>, <-0.126, 0.270, 0.955> }
	smooth_triangle { <5.9180, 1.6366, 12.9951>, <-0.126, 0.270, 0.955>, <4.4943, 2.3224, 12.6136>, <-0.346, 0.032, 0.938>, <4.5066, 2.3409, 12.6013>, <0.024, 0.792, 0.610> }
	smooth_triangle { <5.9180, 1.6366, 12.9951>, <-0.126, 0.270, 0.955>, <4.5066, 2.3409, 12.6013>, <0.024, 0.792, 0.610>, <5.9302, 1.6552, 12.9828>, <0.341, 0.885, 0.318> }
	smooth_triangle { <5.9302, 1.6552, 12.9828>, <0.341, 0.885, 0.318>, <4.5066, 2.3409, 12.6013>, <0.105, 0.834, 0.542>, <4.5119, 2.3383, 12.5766>, <0.403, 0.860, -0.314> }
	smooth_triangle { <5.9302, 1.6552, 12.9828>, <0.341, 0.885, 0.318>, <4.5119, 2.3383, 12.5766>, <0.403, 0.860, -0.314>, <5.9356, 1.6526, 12.9581>, <0.466, 0.614, -0.636> }
	smooth_triangle { <5.9356, 1.6526, 12.9581>, <0.466, 0.614, -0.636>, <4.5119, 2.3383, 12.5766>, <0.451, 0.800, -0.396>, <4.5051, 2.3172, 12.5643>, <0.379, 0.070, -0.923> }
	smooth_triangle { <5.9356, 1.6526, 12.9581>, <0.466, 0.614, -0.636>, <4.5051, 2.3172, 12.5643>, <0.379, 0.070, -0.923>, <5.9287, 1.6315, 12.9457>, <0.126, -0.270, -0.955> }
	smooth_triangle { <5.9287, 1.6315, 12.9457>, <0.126, -0.270, -0.955>, <4.5051, 2.3172, 12.5643>, <0.347, -0.032, -0.937>, <4.4928, 2.2987, 12.5766>, <-0.024, -0.792, -0.610> }
	smooth_triangle { <5.9287, 1.6315, 12.9457>, <0.126, -0.270, -0.955>, <4.4928, 2.2987, 12.5766>, <-0.024, -0.792, -0.610>, <5.9165, 1.6129, 12.9581>, <-0.341, -0.885, -0.318> }
	smooth_triangle { <5.9165, 1.6129, 12.9581>, <-0.341, -0.885, -0.318>, <4.4928, 2.2987, 12.5766>, <-0.104, -0.834, -0.542>, <4.4875, 2.3012, 12.6013>, <-0.304, -0.953, -0.008> }
	smooth_triangle { <5.9165, 1.6129, 12.9581>, <-0.341, -0.885, -0.318>, <4.4875, 2.3012, 12.6013>, <-0.304, -0.953, -0.008>, <5.9111, 1.6155, 12.9828>, <-0.434, -0.901, 0.000> }
	smooth_triangle { <8.2827, 1.6189, 14.5601>, <-0.595, -0.439, 0.673>, <4.4875, 2.3012, 12.6013>, <-0.440, -0.342, 0.830>, <4.4943, 2.3224, 12.6136>, <-0.379, -0.070, 0.923> }
	smooth_triangle { <8.2827, 1.6189, 14.5601>, <-0.595, -0.439, 0.673>, <4.4943, 2.3224, 12.6136>, <-0.438, -0.389, 0.810>, <8.2756, 1.6409, 14.5706>, <-0.739, -0.098, 0.667> }
	smooth_triangle { <8.2756, 1.6409, 14.5706>, <-0.467, 0.555, 0.688>, <4.4943, 2.3224, 12.6136>, <-0.346, 0.032, 0.938>, <4.5066, 2.3409, 12.6013>, <0.024, 0.792, 0.610> }
	smooth_triangle { <8.2756, 1.6409, 14.5706>, <-0.690, 0.046, 0.722>, <4.5066, 2.3409, 12.6013>, <-0.069, 0.710, 0.701>, <8.2826, 1.6629, 14.5601>, <-0.278, 0.894, 0.350> }
	smooth_triangle { <8.2826, 1.6629, 14.5601>, <-0.149, 0.941, 0.304>, <4.5066, 2.3409, 12.6013>, <0.024, 0.792, 0.610>, <4.5119, 2.3383, 12.5766>, <0.403, 0.860, -0.314> }
	smooth_triangle { <8.2826, 1.6629, 14.5601>, <-0.278, 0.894, 0.350>, <4.5119, 2.3383, 12.5766>, <0.304, 0.953, 0.008>, <8.2967, 1.6630, 14.5389>, <0.354, 0.905, -0.236> }
	smooth_triangle { <8.2967, 1.6630, 14.5389>, <0.523, 0.645, -0.557>, <4.5119, 2.3383, 12.5766>, <0.451, 0.800, -0.396>, <4.5051, 2.3172, 12.5643>, <0.379, 0.070, -0.923> }
	smooth_triangle { <8.2967, 1.6630, 14.5389>, <0.399, 0.842, -0.364>, <4.5051, 2.3172, 12.5643>, <0.438, 0.388, -0.811>, <8.3038, 1.6410, 14.5284>, <0.737, 0.098, -0.668> }
	smooth_triangle { <8.3038, 1.6410, 14.5284>, <0.466, -0.555, -0.689>, <4.5051, 2.3172, 12.5643>, <0.347, -0.032, -0.937>, <4.4928, 2.2987, 12.5766>, <-0.024, -0.792, -0.610> }
	smooth_triangle { <8.3038, 1.6410, 14.5284>, <0.689, -0.046, -0.723>, <4.4928, 2.2987, 12.5766>, <0.069, -0.710, -0.701>, <8.2968, 1.6190, 14.5389>, <0.277, -0.894, -0.351> }
	smooth_triangle { <8.2968, 1.6190, 14.5389>, <0.148, -0.941, -0.304>, <4.4928, 2.2987, 12.5766>, <-0.024, -0.792, -0.610>, <4.4875, 2.3012, 12.6013>, <-0.304, -0.953, -0.008> }
	smooth_triangle { <8.2968, 1.6190, 14.5389>, <0.277, -0.894, -0.351>, <4.4875, 2.3012, 12.6013>, <-0.304, -0.953, -0.008>, <8.2827, 1.6189, 14.5601>, <-0.097, -0.994, -0.041> }
	smooth_triangle { <9.6792, 1.4661, 17.0258>, <-0.732, -0.623, 0.274>, <8.2827, 1.6189, 14.5601>, <-0.595, -0.439, 0.673>, <8.2756, 1.6409, 14.5706>, <-0.739, -0.098, 0.667> }
	smooth_triangle { <9.6792, 1.4661, 17.0258>, <-0.732, -0.623, 0.274>, <8.2756, 1.6409, 14.5706>, <-0.739, -0.098, 0.667>, <9.6707, 1.4892, 17.0321>, <-0.884, 0.185, 0.429> }
	smooth_triangle { <9.6707, 1.4892, 17.0321>, <-0.884, 0.185, 0.429>, <8.2756, 1.6409, 14.5706>, <-0.690, 0.046, 0.722>, <8.2826, 1.6629, 14.5601>, <-0.375, 0.823, 0.426> }
	smooth_triangle { <9.6707, 1.4892, 17.0321>, <-0.884, 0.185, 0.429>, <8.2826, 1.6629, 14.5601>, <-0.278, 0.894, 0.350>, <9.6840, 1.5099, 17.0258>, <-0.254, 0.945, 0.206> }
	smooth_triangle { <9.6840, 1.5099, 17.0258>, <-0.254, 0.945, 0.206>, <8.2826, 1.6629, 14.5601>, <-0.278, 0.894, 0.350>, <8.2967, 1.6630, 14.5389>, <0.354, 0.905, -0.236> }
	smooth_triangle { <9.6840, 1.5099, 17.0258>, <-0.254, 0.945, 0.206>, <8.2967, 1.6630, 14.5389>, <0.399, 0.842, -0.364>, <9.7060, 1.5074, 17.0132>, <0.633, 0.742, -0.221> }
	smooth_triangle { <9.7060, 1.5074, 17.0132>, <0.633, 0.742, -0.221>, <8.2967, 1.6630, 14.5389>, <0.399, 0.842, -0.364>, <8.3038, 1.6410, 14.5284>, <0.737, 0.098, -0.668> }
	smooth_triangle { <9.7060, 1.5074, 17.0132>, <0.633, 0.742, -0.221>, <8.3038, 1.6410, 14.5284>, <0.737, 0.098, -0.668>, <9.7145, 1.4844, 17.0069>, <0.887, -0.186, -0.423> }
	smooth_triangle { <9.7145, 1.4844, 17.0069>, <0.887, -0.186, -0.423>, <8.3038, 1.6410, 14.5284>, <0.689, -0.046, -0.723>, <8.2968, 1.6190, 14.5389>, <0.374, -0.823, -0.426> }
	smooth_triangle { <9.7145, 1.4844, 17.0069>, <0.887, -0.186, -0.423>, <8.2968, 1.6190, 14.5389>, <0.277, -0.894, -0.351>, <9.7011, 1.4637, 17.0132>, <0.257, -0.946, -0.200> }
	smooth_triangle { <9.7011, 1.4637, 17.0132>, <0.257, -0.946, -0.200>, <8.2968, 1.6190, 14.5389>, <0.277, -0.894, -0.351>, <8.2827, 1.6189, 14.5601>, <-0.097, -0.994, -0.041> }
	smooth_triangle { <9.7011, 1.4637, 17.0132>, <0.257, -0.946, -0.200>, <8.2827, 1.6189, 14.5601>, <-0.097, -0.994, -0.041>, <9.6792, 1.4661, 17.0258>, <-0.109, -0.994, 0.000> }
	smooth_triangle { <10.5499, 1.0777, 19.7010>, <-0.888, -0.394, 0.236>, <9.6792, 1.4661, 17.0258>, <-0.732, -0.623, 0.274>, <9.6707, 1.4892, 17.0321>, <-0.884, 0.185, 0.429> }
	smooth_triangle { <10.5499, 1.0777, 19.7010>, <-0.736, 0.587, 0.337>, <9.6707, 1.4892, 17.0321>, <-0.884, 0.185, 0.429>, <9.6840, 1.5099, 17.0258>, <-0.254, 0.945, 0.206> }
	smooth_triangle { <10.5499, 1.0777, 19.7010>, <0.161, 0.981, 0.110>, <9.6840, 1.5099, 17.0258>, <-0.254, 0.945, 0.206>, <9.7060, 1.5074, 17.0132>, <0.633, 0.742, -0.221> }
	smooth_triangle { <10.5499, 1.0777, 19.7010>, <0.895, 0.391, -0.215>, <9.7060, 1.5074, 17.0132>, <0.633, 0.742, -0.221>, <9.7145, 1.4844, 17.0069>, <0.887, -0.186, -0.423> }
	smooth_triangle { <10.5499, 1.0777, 19.7010>, <0.744, -0.589, -0.316>, <9.7145, 1.4844, 17.0069>, <0.887, -0.186, -0.423>, <9.7011, 1.4637, 17.0132>, <0.257, -0.946, -0.200> }
	smooth_triangle { <10.5499, 1.0777, 19.7010>, <-0.152, -0.984, -0.090>, <9.7011, 1.4637, 17.0132>, <0.257, -0.946, -0.200>, <9.6792, 1.4661, 17.0258>, <-0.732, -0.623, 0.274> }
	smooth_triangle { <5.9134, 3.1216, 12.6290>, <0.240, -0.439, 0.866>, <4.5106, 2.3007, 12.6017>, <0.203, -0.460, 0.864>, <4.4993, 2.3195, 12.6144>, <0.037, -0.198, 0.979> }
	smooth_triangle { <5.9134, 3.1216, 12.6290>, <0.240, -0.439, 0.866>, <4.4993, 2.3195, 12.6144>, <0.037, -0.198, 0.979>, <5.9021, 3.1405, 12.6417>, <-0.110, 0.155, 0.982> }
	smooth_triangle { <5.9021, 3.1405, 12.6417>, <-0.110, 0.155, 0.982>, <4.4993, 2.3195, 12.6144>, <0.037, -0.198, 0.979>, <4.4884, 2.3386, 12.6017>, <-0.427, 0.626, 0.653> }
	smooth_triangle { <5.9021, 3.1405, 12.6417>, <-0.110, 0.155, 0.982>, <4.4884, 2.3386, 12.6017>, <-0.427, 0.626, 0.653>, <5.8912, 3.1596, 12.6290>, <-0.482, 0.813, 0.327> }
	smooth_triangle { <5.8912, 3.1596, 12.6290>, <-0.482, 0.813, 0.327>, <4.4884, 2.3386, 12.6017>, <-0.427, 0.626, 0.653>, <4.4888, 2.3389, 12.5763>, <-0.464, 0.824, -0.326> }
	smooth_triangle { <5.8912, 3.1596, 12.6290>, <-0.482, 0.813, 0.327>, <4.4888, 2.3389, 12.5763>, <-0.464, 0.824, -0.326>, <5.8916, 3.1598, 12.6036>, <-0.372, 0.658, -0.655> }
	smooth_triangle { <5.8916, 3.1598, 12.6036>, <-0.372, 0.658, -0.655>, <4.4888, 2.3389, 12.5763>, <-0.464, 0.824, -0.326>, <4.5001, 2.3200, 12.5636>, <-0.037, 0.198, -0.979> }
	smooth_triangle { <5.8916, 3.1598, 12.6036>, <-0.372, 0.658, -0.655>, <4.5001, 2.3200, 12.5636>, <-0.037, 0.198, -0.979>, <5.9029, 3.1409, 12.5909>, <0.110, -0.155, -0.982> }
	smooth_triangle { <5.9029, 3.1409, 12.5909>, <0.110, -0.155, -0.982>, <4.5001, 2.3200, 12.5636>, <-0.037, 0.198, -0.979>, <4.5110, 2.3009, 12.5763>, <0.427, -0.626, -0.653> }
	smooth_triangle { <5.9029, 3.1409, 12.5909>, <0.110, -0.155, -0.982>, <4.5110, 2.3009, 12.5763>, <0.427, -0.626, -0.653>, <5.9138, 3.1218, 12.6036>, <0.482, -0.813, -0.327> }
	smooth_triangle { <5.9138, 3.1218, 12.6036>, <0.482, -0.813, -0.327>, <4.5110, 2.3009, 12.5763>, <0.427, -0.626, -0.653>, <4.5106, 2.3007, 12.6017>, <0.512, -0.859, 0.000> }
	smooth_triangle { <5.9138, 3.1218, 12.6036>, <0.482, -0.813, -0.327>, <4.5106, 2.3007, 12.6017>, <0.512, -0.859, 0.000>, <5.9134, 3.1216, 12.6290>, <0.505, -0.863, 0.000> }
	smooth_triangle { <8.2877, 4.5943, 13.1562>, <0.238, -0.433, 0.869>, <4.5106, 2.3007, 12.6017>, <0.203, -0.460, 0.864>, <4.4993, 2.3195, 12.6144>, <0.037, -0.198, 0.979> }
	smooth_triangle { <8.2877, 4.5943, 13.1562>, <0.238, -0.433, 0.869>, <4.4993, 2.3195, 12.6144>, <0.037, -0.198, 0.979>, <8.2741, 4.6118, 13.1687>, <0.008, 0.009, 1.000> }
	smooth_triangle { <8.2741, 4.6118, 13.1687>, <0.008, 0.009, 1.000>, <4.4993, 2.3195, 12.6144>, <0.037, -0.198, 0.979>, <4.4884, 2.3386, 12.6017>, <-0.427, 0.626, 0.653> }
	smooth_triangle { <8.2741, 4.6118, 13.1687>, <0.008, 0.009, 1.000>, <4.4884, 2.3386, 12.6017>, <-0.427, 0.626, 0.653>, <8.2645, 4.6317, 13.1562>, <-0.456, 0.738, 0.498> }
	smooth_triangle { <8.2645, 4.6317, 13.1562>, <-0.456, 0.738, 0.498>, <4.4884, 2.3386, 12.6017>, <-0.427, 0.626, 0.653>, <4.4888, 2.3389, 12.5763>, <-0.464, 0.824, -0.326> }
	smooth_triangle { <8.2645, 4.6317, 13.1562>, <-0.456, 0.738, 0.498>, <4.4888, 2.3389, 12.5763>, <-0.464, 0.824, -0.326>, <8.2685, 4.6342, 13.1312>, <-0.464, 0.729, -0.503> }
	smooth_triangle { <8.2685, 4.6342, 13.1312>, <-0.464, 0.729, -0.503>, <4.4888, 2.3389, 12.5763>, <-0.464, 0.824, -0.326>, <4.5001, 2.3200, 12.5636>, <-0.037, 0.198, -0.979> }
	smooth_triangle { <8.2685, 4.6342, 13.1312>, <-0.464, 0.729, -0.503>, <4.5001, 2.3200, 12.5636>, <-0.037, 0.198, -0.979>, <8.2821, 4.6168, 13.1188>, <-0.008, -0.009, -1.000> }
	smooth_triangle { <8.2821, 4.6168, 13.1188>, <-0.008, -0.009, -1.000>, <4.5001, 2.3200, 12.5636>, <-0.037, 0.198, -0.979>, <4.5110, 2.3009, 12.5763>, <0.427, -0.626, -0.653> }
	smooth_triangle { <8.2821, 4.6168, 13.1188>, <-0.008, -0.009, -1.000>, <4.5110, 2.3009, 12.5763>, <0.427, -0.626, -0.653>, <8.2917, 4.5968, 13.1312>, <0.456, -0.738, -0.498> }
	smooth_triangle { <8.2917, 4.5968, 13.1312>, <0.456, -0.738, -0.498>, <4.5110, 2.3009, 12.5763>, <0.427, -0.626, -0.653>, <4.5106, 2.3007, 12.6017>, <0.512, -0.859, 0.000> }
	smooth_triangle { <8.2917, 4.5968, 13.1312>, <0.456, -0.738, -0.498>, <4.5106, 2.3007, 12.6017>, <0.512, -0.859, 0.000>, <8.2877, 4.5943, 13.1562>, <0.563, -0.826, 0.004> }
	smooth_triangle { <10.5809, 6.2448, 12.7805>, <0.508, -0.485, 0.712>, <8.2877, 4.5943, 13.1562>, <0.238, -0.433, 0.869>, <8.2741, 4.6118, 13.1687>, <0.008, 0.009, 1.000> }
	smooth_triangle { <10.5809, 6.2448, 12.7805>, <0.508, -0.485, 0.712>, <8.2741, 4.6118, 13.1687>, <0.008, 0.009, 1.000>, <10.5694, 6.2636, 12.7931>, <0.101, 0.207, 0.973> }
	smooth_triangle { <10.5694, 6.2636, 12.7931>, <0.101, 0.207, 0.973>, <8.2741, 4.6118, 13.1687>, <0.008, 0.009, 1.000>, <8.2645, 4.6317, 13.1562>, <-0.456, 0.738, 0.498> }
	smooth_triangle { <10.5694, 6.2636, 12.7931>, <0.101, 0.207, 0.973>, <8.2645, 4.6317, 13.1562>, <-0.456, 0.738, 0.498>, <10.5552, 6.2805, 12.7805>, <-0.456, 0.804, 0.383> }
	smooth_triangle { <10.5552, 6.2805, 12.7805>, <-0.456, 0.804, 0.383>, <8.2645, 4.6317, 13.1562>, <-0.456, 0.738, 0.498>, <8.2685, 4.6342, 13.1312>, <-0.464, 0.729, -0.503> }
	smooth_triangle { <10.5552, 6.2805, 12.7805>, <-0.456, 0.804, 0.383>, <8.2685, 4.6342, 13.1312>, <-0.464, 0.729, -0.503>, <10.5525, 6.2785, 12.7553>, <-0.549, 0.592, -0.590> }
	smooth_triangle { <10.5525, 6.2785, 12.7553>, <-0.549, 0.592, -0.590>, <8.2685, 4.6342, 13.1312>, <-0.464, 0.729, -0.503>, <8.2821, 4.6168, 13.1188>, <-0.008, -0.009, -1.000> }
	smooth_triangle { <10.5525, 6.2785, 12.7553>, <-0.549, 0.592, -0.590>, <8.2821, 4.6168, 13.1188>, <-0.008, -0.009, -1.000>, <10.5640, 6.2597, 12.7427>, <-0.095, -0.203, -0.974> }
	smooth_triangle { <10.5640, 6.2597, 12.7427>, <-0.095, -0.203, -0.974>, <8.2821, 4.6168, 13.1188>, <-0.008, -0.009, -1.000>, <8.2917, 4.5968, 13.1312>, <0.456, -0.738, -0.498> }
	smooth_triangle { <10.5640, 6.2597, 12.7427>, <-0.095, -0.203, -0.974>, <8.2917, 4.5968, 13.1312>, <0.456, -0.738, -0.498>, <10.5782, 6.2428, 12.7553>, <0.462, -0.800, -0.384> }
	smooth_triangle { <10.5782, 6.2428, 12.7553>, <0.462, -0.800, -0.384>, <8.2917, 4.5968, 13.1312>, <0.456, -0.738, -0.498>, <8.2877, 4.5943, 13.1562>, <0.563, -0.826, 0.004> }
	smooth_triangle { <10.5782, 6.2428, 12.7553>, <0.462, -0.800, -0.384>, <8.2877, 4.5943, 13.1562>, <0.563, -0.826, 0.004>, <10.5809, 6.2448, 12.7805>, <0.584, -0.812, 0.000> }
	smooth_triangle { <12.8150, 7.7792, 11.9104>, <0.502, -0.255, 0.827>, <10.5809, 6.2448, 12.7805>, <0.508, -0.485, 0.712>, <10.5694, 6.2636, 12.7931>, <0.101, 0.207, 0.973> }
	smooth_triangle { <12.8150, 7.7792, 11.9104>, <-0.057, 0.570, 0.820>, <10.5694, 6.2636, 12.7931>, <0.101, 0.207, 0.973>, <10.5552, 6.2805, 12.7805>, <-0.456, 0.804, 0.383> }
	smooth_triangle { <12.8150, 7.7792, 11.9104>, <-0.551, 0.834, -0.008>, <10.5552, 6.2805, 12.7805>, <-0.456, 0.804, 0.383>, <10.5525, 6.2785, 12.7553>, <-0.549, 0.592, -0.590> }
	smooth_triangle { <12.8150, 7.7792, 11.9104>, <-0.484, 0.268, -0.833>, <10.5525, 6.2785, 12.7553>, <-0.549, 0.592, -0.590>, <10.5640, 6.2597, 12.7427>, <-0.095, -0.203, -0.974> }
	smooth_triangle { <12.8150, 7.7792, 11.9104>, <0.076, -0.558, -0.826>, <10.5640, 6.2597, 12.7427>, <-0.095, -0.203, -0.974>, <10.5782, 6.2428, 12.7553>, <0.462, -0.800, -0.384> }
	smooth_triangle { <12.8150, 7.7792, 11.9104>, <0.570, -0.821, 0.003>, <10.5782, 6.2428, 12.7553>, <0.462, -0.800, -0.384>, <10.5809, 6.2448, 12.7805>, <0.508, -0.485, 0.712> }
	smooth_triangle { <4.8681, 2.0751, 14.1535>, <-0.970, -0.005, 0.242>, <4.4780, 2.3071, 12.5925>, <-0.919, -0.028, 0.393>, <4.4787, 2.3322, 12.5960>, <-0.869, 0.258, 0.422> }
	smooth_triangle { <4.8681, 2.0751, 14.1535>, <-0.970, -0.005, 0.242>, <4.4787, 2.3322, 12.5960>, <-0.869, 0.258, 0.422>, <4.8688, 2.1002, 14.1570>, <-0.714, 0.644, 0.274> }
	smooth_triangle { <4.8688, 2.1002, 14.1570>, <-0.714, 0.644, 0.274>, <4.4787, 2.3322, 12.5960>, <-0.842, 0.370, 0.392>, <4.5005, 2.3449, 12.5925>, <-0.170, 0.953, 0.252> }
	smooth_triangle { <4.8688, 2.1002, 14.1570>, <-0.714, 0.644, 0.274>, <4.5005, 2.3449, 12.5925>, <-0.170, 0.953, 0.252>, <4.8906, 2.1129, 14.1535>, <0.213, 0.973, 0.091> }
	smooth_triangle { <4.8906, 2.1129, 14.1535>, <0.213, 0.973, 0.091>, <4.5005, 2.3449, 12.5925>, <-0.076, 0.980, 0.185>, <4.5214, 2.3324, 12.5854>, <0.698, 0.696, -0.169> }
	smooth_triangle { <4.8906, 2.1129, 14.1535>, <0.213, 0.973, 0.091>, <4.5214, 2.3324, 12.5854>, <0.698, 0.696, -0.169>, <4.9115, 2.1005, 14.1464>, <0.927, 0.328, -0.183> }
	smooth_triangle { <4.9115, 2.1005, 14.1464>, <0.927, 0.328, -0.183>, <4.5214, 2.3324, 12.5854>, <0.765, 0.610, -0.206>, <4.5207, 2.3073, 12.5819>, <0.869, -0.258, -0.422> }
	smooth_triangle { <4.9115, 2.1005, 14.1464>, <0.927, 0.328, -0.183>, <4.5207, 2.3073, 12.5819>, <0.869, -0.258, -0.422>, <4.9108, 2.0753, 14.1428>, <0.714, -0.644, -0.274> }
	smooth_triangle { <4.9108, 2.0753, 14.1428>, <0.714, -0.644, -0.274>, <4.5207, 2.3073, 12.5819>, <0.842, -0.371, -0.391>, <4.4989, 2.2946, 12.5854>, <0.170, -0.953, -0.252> }
	smooth_triangle { <4.9108, 2.0753, 14.1428>, <0.714, -0.644, -0.274>, <4.4989, 2.2946, 12.5854>, <0.170, -0.953, -0.252>, <4.8890, 2.0626, 14.1464>, <-0.213, -0.973, -0.091> }
	smooth_triangle { <4.8890, 2.0626, 14.1464>, <-0.213, -0.973, -0.091>, <4.4989, 2.2946, 12.5854>, <0.076, -0.980, -0.184>, <4.4780, 2.3071, 12.5925>, <-0.451, -0.892, 0.025> }
	smooth_triangle { <4.8890, 2.0626, 14.1464>, <-0.213, -0.973, -0.091>, <4.4780, 2.3071, 12.5925>, <-0.451, -0.892, 0.025>, <4.8681, 2.0751, 14.1535>, <-0.511, -0.860, 0.000> }
	smooth_triangle { <6.7994, 1.5190, 16.1805>, <-0.819, -0.210, 0.534>, <4.4780, 2.3071, 12.5925>, <-0.919, -0.028, 0.393>, <4.4787, 2.3322, 12.5960>, <-0.869, 0.258, 0.422> }
	smooth_triangle { <6.7994, 1.5190, 16.1805>, <-0.819, -0.210, 0.534>, <4.4787, 2.3322, 12.5960>, <-0.921, -0.085, 0.381>, <6.7968, 1.5427, 16.1895>, <-0.717, 0.133, 0.684> }
	smooth_triangle { <6.7968, 1.5427, 16.1895>, <-0.535, 0.538, 0.652>, <4.4787, 2.3322, 12.5960>, <-0.842, 0.370, 0.392>, <4.5005, 2.3449, 12.5925>, <-0.170, 0.953, 0.252> }
	smooth_triangle { <6.7968, 1.5427, 16.1895>, <-0.691, 0.271, 0.670>, <4.5005, 2.3449, 12.5925>, <-0.472, 0.806, 0.358>, <6.8115, 1.5613, 16.1805>, <-0.053, 0.869, 0.492> }
	smooth_triangle { <6.8115, 1.5613, 16.1805>, <0.295, 0.931, 0.213>, <4.5005, 2.3449, 12.5925>, <-0.076, 0.980, 0.185>, <4.5214, 2.3324, 12.5854>, <0.698, 0.696, -0.169> }
	smooth_triangle { <6.8115, 1.5613, 16.1805>, <0.048, 0.916, 0.399>, <4.5214, 2.3324, 12.5854>, <0.451, 0.892, -0.025>, <6.8289, 1.5564, 16.1627>, <0.658, 0.728, -0.192> }
	smooth_triangle { <6.8289, 1.5564, 16.1627>, <0.815, 0.389, -0.430>, <4.5214, 2.3324, 12.5854>, <0.765, 0.610, -0.206>, <4.5207, 2.3073, 12.5819>, <0.869, -0.258, -0.422> }
	smooth_triangle { <6.8289, 1.5564, 16.1627>, <0.727, 0.633, -0.267>, <4.5207, 2.3073, 12.5819>, <0.921, 0.085, -0.381>, <6.8315, 1.5328, 16.1537>, <0.716, -0.132, -0.685> }
	smooth_triangle { <6.8315, 1.5328, 16.1537>, <0.534, -0.538, -0.652>, <4.5207, 2.3073, 12.5819>, <0.842, -0.371, -0.391>, <4.4989, 2.2946, 12.5854>, <0.170, -0.953, -0.252> }
	smooth_triangle { <6.8315, 1.5328, 16.1537>, <0.691, -0.271, -0.670>, <4.4989, 2.2946, 12.5854>, <0.471, -0.806, -0.358>, <6.8168, 1.5141, 16.1627>, <0.052, -0.868, -0.493> }
	smooth_triangle { <6.8168, 1.5141, 16.1627>, <-0.296, -0.931, -0.213>, <4.4989, 2.2946, 12.5854>, <0.076, -0.980, -0.184>, <4.4780, 2.3071, 12.5925>, <-0.451, -0.892, 0.025> }
	smooth_triangle { <6.8168, 1.5141, 16.1627>, <-0.049, -0.915, -0.400>, <4.4780, 2.3071, 12.5925>, <-0.451, -0.892, 0.025>, <6.7994, 1.5190, 16.1805>, <-0.447, -0.892, -0.071> }
	smooth_triangle { <8.6347, 0.2061, 17.9053>, <-0.780, -0.136, 0.610>, <6.7994, 1.5190, 16.1805>, <-0.819, -0.210, 0.534>, <6.7968, 1.5427, 16.1895>, <-0.717, 0.133, 0.684> }
	smooth_triangle { <8.6347, 0.2061, 17.9053>, <-0.780, -0.136, 0.610>, <6.7968, 1.5427, 16.1895>, <-0.691, 0.271, 0.670>, <8.6413, 0.2284, 17.9154>, <-0.619, 0.353, 0.701> }
	smooth_triangle { <8.6413, 0.2284, 17.9154>, <-0.619, 0.353, 0.701>, <6.7968, 1.5427, 16.1895>, <-0.691, 0.271, 0.670>, <6.8115, 1.5613, 16.1805>, <-0.053, 0.869, 0.492> }
	smooth_triangle { <8.6413, 0.2284, 17.9154>, <-0.532, 0.463, 0.709>, <6.8115, 1.5613, 16.1805>, <0.048, 0.916, 0.399>, <8.6603, 0.2418, 17.9053>, <0.100, 0.938, 0.332> }
	smooth_triangle { <8.6603, 0.2418, 17.9053>, <0.100, 0.938, 0.332>, <6.8115, 1.5613, 16.1805>, <0.048, 0.916, 0.399>, <6.8289, 1.5564, 16.1627>, <0.658, 0.728, -0.192> }
	smooth_triangle { <8.6603, 0.2418, 17.9053>, <0.230, 0.933, 0.276>, <6.8289, 1.5564, 16.1627>, <0.727, 0.633, -0.267>, <8.6729, 0.2329, 17.8851>, <0.721, 0.587, -0.369> }
	smooth_triangle { <8.6729, 0.2329, 17.8851>, <0.721, 0.587, -0.369>, <6.8289, 1.5564, 16.1627>, <0.727, 0.633, -0.267>, <6.8315, 1.5328, 16.1537>, <0.716, -0.132, -0.685> }
	smooth_triangle { <8.6729, 0.2329, 17.8851>, <0.721, 0.587, -0.369>, <6.8315, 1.5328, 16.1537>, <0.691, -0.271, -0.670>, <8.6663, 0.2105, 17.8750>, <0.619, -0.353, -0.701> }
	smooth_triangle { <8.6663, 0.2105, 17.8750>, <0.619, -0.353, -0.701>, <6.8315, 1.5328, 16.1537>, <0.691, -0.271, -0.670>, <6.8168, 1.5141, 16.1627>, <0.052, -0.868, -0.493> }
	smooth_triangle { <8.6663, 0.2105, 17.8750>, <0.533, -0.463, -0.708>, <6.8168, 1.5141, 16.1627>, <-0.049, -0.915, -0.400>, <8.6472, 0.1971, 17.8851>, <-0.100, -0.938, -0.332> }
	smooth_triangle { <8.6472, 0.1971, 17.8851>, <-0.100, -0.938, -0.332>, <6.8168, 1.5141, 16.1627>, <-0.049, -0.915, -0.400>, <6.7994, 1.5190, 16.1805>, <-0.447, -0.892, -0.071> }
	smooth_triangle { <8.6472, 0.1971, 17.8851>, <-0.230, -0.933, -0.276>, <6.7994, 1.5190, 16.1805>, <-0.447, -0.892, -0.071>, <8.6347, 0.2061, 17.9053>, <-0.471, -0.882, 0.032> }
	smooth_triangle { <9.9343, -0.2788, 19.9098>, <-0.844, -0.149, 0.516>, <8.6347, 0.2061, 17.9053>, <-0.780, -0.136, 0.610>, <8.6413, 0.2284, 17.9154>, <-0.619, 0.353, 0.701> }
	smooth_triangle { <9.9343, -0.2788, 19.9098>, <-0.810, -0.391, 0.436>, <8.6413, 0.2284, 17.9154>, <-0.733, 0.073, 0.676>, <9.9321, -0.2545, 19.9170>, <-0.767, 0.284, 0.575> }
	smooth_triangle { <9.9321, -0.2545, 19.9170>, <-0.447, 0.756, 0.478>, <8.6413, 0.2284, 17.9154>, <-0.532, 0.463, 0.709>, <8.6603, 0.2418, 17.9053>, <0.100, 0.938, 0.332> }
	smooth_triangle { <9.9321, -0.2545, 19.9170>, <-0.705, 0.425, 0.567>, <8.6603, 0.2418, 17.9053>, <-0.015, 0.920, 0.391>, <9.9496, -0.2375, 19.9098>, <0.046, 0.976, 0.214> }
	smooth_triangle { <9.9496, -0.2375, 19.9098>, <0.046, 0.976, 0.214>, <8.6603, 0.2418, 17.9053>, <0.100, 0.938, 0.332>, <8.6729, 0.2329, 17.8851>, <0.721, 0.587, -0.369> }
	smooth_triangle { <9.9496, -0.2375, 19.9098>, <0.046, 0.976, 0.214>, <8.6729, 0.2329, 17.8851>, <0.655, 0.689, -0.310>, <9.9692, -0.2448, 19.8954>, <0.689, 0.668, -0.280> }
	smooth_triangle { <9.9692, -0.2448, 19.8954>, <0.847, 0.148, -0.511>, <8.6729, 0.2329, 17.8851>, <0.766, 0.475, -0.433>, <8.6663, 0.2105, 17.8750>, <0.619, -0.353, -0.701> }
	smooth_triangle { <9.9692, -0.2448, 19.8954>, <0.760, 0.544, -0.356>, <8.6663, 0.2105, 17.8750>, <0.733, -0.073, -0.677>, <9.9713, -0.2691, 19.8881>, <0.771, -0.286, -0.568> }
	smooth_triangle { <9.9713, -0.2691, 19.8881>, <0.450, -0.757, -0.474>, <8.6663, 0.2105, 17.8750>, <0.533, -0.463, -0.708>, <8.6472, 0.1971, 17.8851>, <-0.100, -0.938, -0.332> }
	smooth_triangle { <9.9713, -0.2691, 19.8881>, <0.709, -0.426, -0.561>, <8.6472, 0.1971, 17.8851>, <0.015, -0.920, -0.392>, <9.9539, -0.2861, 19.8954>, <-0.042, -0.977, -0.208> }
	smooth_triangle { <9.9539, -0.2861, 19.8954>, <-0.042, -0.977, -0.208>, <8.6472, 0.1971, 17.8851>, <-0.100, -0.938, -0.332>, <8.6347, 0.2061, 17.9053>, <-0.471, -0.882, 0.032> }
	smooth_triangle { <9.9539, -0.2861, 19.8954>, <-0.042, -0.977, -0.208>, <8.6347, 0.2061, 17.9053>, <-0.471, -0.882, 0.032>, <9.9343, -0.2788, 19.9098>, <-0.348, -0.937, -0.001> }
	smooth_triangle { <11.2637, -0.7628, 21.8959>, <-0.832, -0.225, 0.508>, <9.9343, -0.2788, 19.9098>, <-0.810, -0.391, 0.436>, <9.9321, -0.2545, 19.9170>, <-0.767, 0.284, 0.575> }
	smooth_triangle { <11.2637, -0.7628, 21.8959>, <-0.481, 0.712, 0.512>, <9.9321, -0.2545, 19.9170>, <-0.705, 0.425, 0.567>, <9.9496, -0.2375, 19.9098>, <0.046, 0.976, 0.214> }
	smooth_triangle { <11.2637, -0.7628, 21.8959>, <0.358, 0.934, 0.016>, <9.9496, -0.2375, 19.9098>, <0.046, 0.976, 0.214>, <9.9692, -0.2448, 19.8954>, <0.689, 0.668, -0.280> }
	smooth_triangle { <11.2637, -0.7628, 21.8959>, <0.846, 0.219, -0.485>, <9.9692, -0.2448, 19.8954>, <0.760, 0.544, -0.356>, <9.9713, -0.2691, 19.8881>, <0.771, -0.286, -0.568> }
	smooth_triangle { <11.2637, -0.7628, 21.8959>, <0.496, -0.717, -0.490>, <9.9713, -0.2691, 19.8881>, <0.709, -0.426, -0.561>, <9.9539, -0.2861, 19.8954>, <-0.042, -0.977, -0.208> }
	smooth_triangle { <11.2637, -0.7628, 21.8959>, <-0.343, -0.939, 0.007>, <9.9539, -0.2861, 19.8954>, <-0.042, -0.977, -0.208>, <9.9343, -0.2788, 19.9098>, <-0.765, -0.523, 0.377> }

	texture { PSWL_BARK }
}

/* Object 'PWL0020F' */
union {
	smooth_triangle { <3.2652, 2.0577, 11.5630>, <0.511, 0.648, -0.564>, <3.3435, 1.7001, 11.2176>, <0.522, 0.649, -0.554>, <3.6945, 1.3798, 11.1730>, <0.511, 0.648, -0.564> }
	smooth_triangle { <3.6945, 1.3798, 11.1730>, <0.511, 0.648, -0.564>, <3.6148, 1.7478, 11.5179>, <0.500, 0.647, -0.575>, <3.2652, 2.0577, 11.5630>, <0.511, 0.648, -0.564> }
	smooth_triangle { <4.5196, 2.3565, 12.5558>, <-0.414, 0.724, 0.552>, <4.5144, 2.6322, 12.1720>, <-0.455, 0.720, 0.524>, <4.8568, 2.9770, 11.9950>, <-0.414, 0.724, 0.552> }
	smooth_triangle { <4.8568, 2.9770, 11.9950>, <-0.414, 0.724, 0.552>, <4.8776, 2.6961, 12.3603>, <-0.372, 0.725, 0.579>, <4.5196, 2.3565, 12.5558>, <-0.414, 0.724, 0.552> }
	smooth_triangle { <5.4569, 2.3402, 13.6422>, <0.545, 0.636, -0.546>, <5.6034, 1.8425, 13.1613>, <0.604, 0.639, -0.477>, <6.1030, 1.3536, 13.1390>, <0.545, 0.636, -0.546> }
	smooth_triangle { <6.1030, 1.3536, 13.1390>, <0.545, 0.636, -0.546>, <5.9969, 1.8684, 13.5841>, <0.482, 0.628, -0.611>, <5.4569, 2.3402, 13.6422>, <0.545, 0.636, -0.546> }
	smooth_triangle { <6.3817, 2.4868, 14.7164>, <-0.569, 0.560, 0.602>, <6.4396, 3.0113, 14.2431>, <-0.625, 0.560, 0.544>, <6.9078, 3.5779, 14.1983>, <-0.569, 0.560, 0.602> }
	smooth_triangle { <6.9078, 3.5779, 14.1983>, <-0.569, 0.560, 0.602>, <6.8882, 3.0410, 14.6391>, <-0.509, 0.557, 0.656>, <6.3817, 2.4868, 14.7164>, <-0.569, 0.560, 0.602> }
	smooth_triangle { <7.2363, 2.4367, 15.2549>, <0.259, 0.660, -0.705>, <7.1997, 1.9823, 14.8311>, <0.226, 0.655, -0.721>, <7.7011, 1.5362, 14.5832>, <0.259, 0.660, -0.705> }
	smooth_triangle { <7.7011, 1.5362, 14.5832>, <0.259, 0.660, -0.705>, <7.7163, 2.0026, 15.0397>, <0.292, 0.664, -0.688>, <7.2363, 2.4367, 15.2549>, <0.259, 0.660, -0.705> }
	smooth_triangle { <8.0900, 2.5488, 15.8000>, <-0.306, 0.681, 0.666>, <8.0241, 3.0287, 15.3023>, <-0.262, 0.677, 0.688>, <8.5636, 3.5462, 14.9979>, <-0.306, 0.681, 0.666> }
	smooth_triangle { <8.5636, 3.5462, 14.9979>, <-0.306, 0.681, 0.666>, <8.5997, 3.0513, 15.5431>, <-0.349, 0.682, 0.642>, <8.0900, 2.5488, 15.8000>, <-0.306, 0.681, 0.666> }
	smooth_triangle { <8.9638, 2.5895, 16.3123>, <0.228, 0.864, -0.449>, <9.0258, 2.3194, 15.8140>, <0.245, 0.865, -0.438>, <9.4444, 2.0881, 15.5913>, <0.228, 0.864, -0.449> }
	smooth_triangle { <9.4444, 2.0881, 15.5913>, <0.228, 0.864, -0.449>, <9.3849, 2.3656, 16.0852>, <0.211, 0.863, -0.459>, <8.9638, 2.5895, 16.3123>, <0.228, 0.864, -0.449> }
	smooth_triangle { <9.8028, 2.7759, 16.8700>, <-0.512, -0.019, 0.859>, <9.5257, 3.3907, 16.7185>, <-0.512, -0.019, 0.859>, <9.7521, 4.0859, 16.8689>, <-0.512, -0.019, 0.859> }
	smooth_triangle { <9.7521, 4.0859, 16.8689>, <-0.512, -0.019, 0.859>, <10.0299, 3.4526, 17.0204>, <-0.512, -0.019, 0.859>, <9.8028, 2.7759, 16.8700>, <-0.512, -0.019, 0.859> }
	smooth_triangle { <5.2037, 1.9397, 12.7423>, <0.487, 0.566, -0.665>, <4.9620, 1.7077, 12.3436>, <0.552, 0.530, -0.643>, <5.0677, 1.2984, 12.0969>, <0.487, 0.566, -0.665> }
	smooth_triangle { <5.0677, 1.2984, 12.0969>, <0.487, 0.566, -0.665>, <5.3211, 1.5348, 12.4596>, <0.419, 0.598, -0.683>, <5.2037, 1.9397, 12.7423>, <0.487, 0.566, -0.665> }
	smooth_triangle { <5.9452, 1.6548, 12.9264>, <0.285, 0.805, 0.520>, <5.9576, 1.9666, 12.3832>, <0.186, 0.850, 0.492>, <6.3949, 2.0827, 12.0171>, <0.285, 0.805, 0.520> }
	smooth_triangle { <6.3949, 2.0827, 12.0171>, <0.285, 0.805, 0.520>, <6.3987, 1.7541, 12.4696>, <0.381, 0.750, 0.541>, <5.9452, 1.6548, 12.9264>, <0.285, 0.805, 0.520> }
	smooth_triangle { <7.1256, 1.5966, 13.7315>, <0.281, 0.632, -0.722>, <7.0842, 1.2407, 13.4136>, <0.251, 0.628, -0.736>, <7.4618, 0.8758, 13.2309>, <0.281, 0.632, -0.722> }
	smooth_triangle { <7.4618, 0.8758, 13.2309>, <0.281, 0.632, -0.722>, <7.4878, 1.2419, 13.5719>, <0.311, 0.636, -0.706>, <7.1256, 1.5966, 13.7315>, <0.281, 0.632, -0.722> }
	smooth_triangle { <8.2943, 1.6936, 14.5423>, <-0.542, 0.160, 0.825>, <8.1368, 2.1928, 14.3591>, <-0.490, 0.160, 0.857>, <8.3836, 2.7075, 14.4041>, <-0.542, 0.160, 0.825> }
	smooth_triangle { <8.3836, 2.7075, 14.4041>, <-0.542, 0.160, 0.825>, <8.5237, 2.1940, 14.6134>, <-0.593, 0.160, 0.789>, <8.2943, 1.6936, 14.5423>, <-0.542, 0.160, 0.825> }
	smooth_triangle { <9.0071, 1.5144, 15.7723>, <0.834, 0.370, -0.410>, <9.0438, 0.9833, 15.4078>, <0.804, 0.373, -0.463>, <9.3650, 0.4058, 15.4999>, <0.834, 0.370, -0.410> }
	smooth_triangle { <9.3650, 0.4058, 15.4999>, <0.834, 0.370, -0.410>, <9.2910, 0.9561, 15.8868>, <0.861, 0.365, -0.355>, <9.0071, 1.5144, 15.7723>, <0.834, 0.370, -0.410> }
	smooth_triangle { <9.7114, 1.5361, 17.0119>, <-0.826, 0.379, 0.418>, <9.8061, 2.1038, 16.6777>, <-0.830, 0.379, 0.409>, <10.1405, 2.6616, 16.8384>, <-0.826, 0.379, 0.418> }
	smooth_triangle { <10.1405, 2.6616, 16.8384>, <-0.826, 0.379, 0.418>, <10.0445, 2.0776, 17.1723>, <-0.821, 0.379, 0.427>, <9.7114, 1.5361, 17.0119>, <-0.826, 0.379, 0.418> }
	smooth_triangle { <10.1558, 1.2480, 18.3385>, <0.609, 0.760, -0.228>, <10.3969, 0.8827, 17.8446>, <0.579, 0.765, -0.283>, <11.0124, 0.3998, 17.7991>, <0.609, 0.760, -0.228> }
	smooth_triangle { <11.0124, 0.3998, 17.7991>, <0.609, 0.760, -0.228>, <10.7031, 0.7832, 18.3328>, <0.637, 0.752, -0.171>, <10.1558, 1.2480, 18.3385>, <0.609, 0.760, -0.228> }
	smooth_triangle { <10.5578, 1.1304, 19.6998>, <-0.932, 0.148, 0.330>, <10.5601, 1.7444, 19.4382>, <-0.929, 0.148, 0.339>, <10.7338, 2.2974, 19.6727>, <-0.932, 0.148, 0.330> }
	smooth_triangle { <10.7338, 2.2974, 19.6727>, <-0.932, 0.148, 0.330>, <10.7247, 1.6674, 19.9372>, <-0.935, 0.148, 0.321>, <10.5578, 1.1304, 19.6998>, <-0.932, 0.148, 0.330> }
	smooth_triangle { <5.2159, 2.7065, 12.5572>, <-0.402, 0.752, -0.523>, <5.1389, 2.2560, 11.8780>, <-0.263, 0.818, -0.512>, <5.5912, 2.1037, 11.4031>, <-0.402, 0.752, -0.523> }
	smooth_triangle { <5.5912, 2.1037, 11.4031>, <-0.402, 0.752, -0.523>, <5.6655, 2.5642, 11.9173>, <-0.531, 0.668, -0.522>, <5.2159, 2.7065, 12.5572>, <-0.402, 0.752, -0.523> }
	smooth_triangle { <5.8835, 3.1743, 12.5795>, <-0.302, 0.621, 0.723>, <5.4484, 3.4064, 12.1654>, <-0.381, 0.576, 0.723>, <5.4649, 3.9168, 11.7674>, <-0.302, 0.621, 0.723> }
	smooth_triangle { <5.4649, 3.9168, 11.7674>, <-0.302, 0.621, 0.723>, <5.9069, 3.6748, 12.1260>, <-0.221, 0.661, 0.718>, <5.8835, 3.1743, 12.5795>, <-0.302, 0.621, 0.723> }
	smooth_triangle { <7.1130, 3.8565, 12.8365>, <-0.408, 0.720, -0.561>, <7.1370, 3.4323, 12.2683>, <-0.398, 0.727, -0.559>, <7.6888, 3.3230, 11.7337>, <-0.408, 0.720, -0.561> }
	smooth_triangle { <7.6888, 3.3230, 11.7337>, <-0.408, 0.720, -0.561>, <7.6587, 3.7559, 12.3048>, <-0.417, 0.714, -0.563>, <7.1130, 3.8565, 12.8365>, <-0.408, 0.720, -0.561> }
	smooth_triangle { <8.2570, 4.6569, 13.1195>, <-0.277, 0.368, 0.887>, <7.8081, 4.9759, 12.8381>, <-0.303, 0.354, 0.885>, <7.7988, 5.5847, 12.5911>, <-0.277, 0.368, 0.887> }
	smooth_triangle { <7.7988, 5.5847, 12.5911>, <-0.277, 0.368, 0.887>, <8.2570, 5.2543, 12.8627>, <-0.251, 0.382, 0.889>, <8.2570, 4.6569, 13.1195>, <-0.277, 0.368, 0.887> }
	smooth_triangle { <9.4458, 5.3991, 12.9277>, <-0.395, 0.369, -0.841>, <9.4993, 4.7528, 12.6903>, <-0.547, 0.248, -0.800>, <10.0288, 4.4294, 12.2278>, <-0.395, 0.369, -0.841> }
	smooth_triangle { <10.0288, 4.4294, 12.2278>, <-0.395, 0.369, -0.841>, <9.9823, 5.1004, 12.6162>, <-0.228, 0.476, -0.849>, <9.4458, 5.3991, 12.9277>, <-0.395, 0.369, -0.841> }
	smooth_triangle { <10.5396, 6.2912, 12.7327>, <-0.232, 0.649, 0.724>, <9.9857, 6.4752, 12.3593>, <-0.295, 0.608, 0.737>, <9.8874, 7.0038, 11.8841>, <-0.232, 0.649, 0.724> }
	smooth_triangle { <9.8874, 7.0038, 11.8841>, <-0.232, 0.649, 0.724>, <10.4441, 6.8051, 12.2100>, <-0.168, 0.687, 0.707>, <10.5396, 6.2912, 12.7327>, <-0.232, 0.649, 0.724> }
	smooth_triangle { <11.7167, 6.9794, 12.3170>, <-0.558, 0.093, -0.824>, <11.7795, 6.4950, 12.2126>, <-0.540, 0.110, -0.835>, <12.1898, 6.2298, 11.9123>, <-0.558, 0.093, -0.824> }
	smooth_triangle { <12.1898, 6.2298, 11.9123>, <-0.558, 0.093, -0.824>, <12.1188, 6.7237, 12.0083>, <-0.577, 0.075, -0.814>, <11.7167, 6.9794, 12.3170>, <-0.558, 0.093, -0.824> }
	smooth_triangle { <12.7862, 7.8123, 11.8801>, <-0.088, 0.629, 0.772>, <12.3880, 7.9821, 11.7155>, <-0.028, 0.662, 0.749>, <12.2986, 8.3727, 11.3673>, <-0.088, 0.629, 0.772> }
	smooth_triangle { <12.2986, 8.3727, 11.3673>, <-0.088, 0.629, 0.772>, <12.7076, 8.1978, 11.5757>, <-0.149, 0.594, 0.791>, <12.7862, 7.8123, 11.8801>, <-0.088, 0.629, 0.772> }
	smooth_triangle { <4.6773, 2.1535, 13.3663>, <0.925, -0.308, -0.224>, <4.3893, 1.5518, 13.0255>, <0.922, -0.306, -0.239>, <4.2256, 0.8541, 13.2861>, <0.925, -0.308, -0.224> }
	smooth_triangle { <4.2256, 0.8541, 13.2861>, <0.925, -0.308, -0.224>, <4.5117, 1.4790, 13.6308>, <0.928, -0.310, -0.209>, <4.6773, 2.1535, 13.3663>, <0.925, -0.308, -0.224> }
	smooth_triangle { <4.9298, 2.1227, 14.1451>, <-0.629, 0.750, 0.205>, <5.3991, 2.6037, 13.7706>, <-0.636, 0.753, 0.170>, <5.9813, 3.0394, 14.0186>, <-0.629, 0.750, 0.205> }
	smooth_triangle { <5.9813, 3.0394, 14.0186>, <-0.629, 0.750, 0.205>, <5.5171, 2.5336, 14.3881>, <-0.621, 0.746, 0.240>, <4.9298, 2.1227, 14.1451>, <-0.629, 0.750, 0.205> }
	smooth_triangle { <5.8701, 1.7714, 15.1323>, <0.664, 0.599, -0.448>, <5.8520, 1.4226, 14.7186>, <0.558, 0.622, -0.549>, <6.2295, 0.9506, 14.5668>, <0.664, 0.599, -0.448> }
	smooth_triangle { <6.2295, 0.9506, 14.5668>, <0.664, 0.599, -0.448>, <6.1675, 1.3324, 15.0658>, <0.755, 0.563, -0.337>, <5.8701, 1.7714, 15.1323>, <0.664, 0.599, -0.448> }
	smooth_triangle { <6.8527, 1.5569, 16.1401>, <-0.267, 0.933, 0.241>, <7.2252, 1.8442, 15.4162>, <-0.279, 0.933, 0.227>, <7.8726, 2.0642, 15.3073>, <-0.267, 0.933, 0.241> }
	smooth_triangle { <7.8726, 2.0642, 15.3073>, <-0.267, 0.933, 0.241>, <7.5010, 1.7654, 16.0273>, <-0.256, 0.933, 0.255>, <6.8527, 1.5569, 16.1401>, <-0.267, 0.933, 0.241> }
	smooth_triangle { <7.7099, 0.8320, 17.0235>, <0.652, -0.180, -0.736>, <7.3351, 0.4969, 16.7864>, <0.626, -0.161, -0.763>, <7.2481, -0.0617, 16.8328>, <0.652, -0.180, -0.736> }
	smooth_triangle { <7.2481, -0.0617, 16.8328>, <0.652, -0.180, -0.736>, <7.6196, 0.2931, 17.0885>, <0.677, -0.199, -0.708>, <7.7099, 0.8320, 17.0235>, <0.652, -0.180, -0.736> }
	smooth_triangle { <8.6944, 0.2388, 17.8666>, <-0.088, 0.879, 0.469>, <8.9166, 0.4784, 17.4816>, <-0.055, 0.862, 0.505>, <9.3731, 0.5615, 17.3890>, <-0.088, 0.879, 0.469> }
	smooth_triangle { <9.3731, 0.5615, 17.3890>, <-0.088, 0.879, 0.469>, <9.1269, 0.3277, 17.8041>, <-0.121, 0.894, 0.431>, <8.6944, 0.2388, 17.8666>, <-0.088, 0.879, 0.469> }
	smooth_triangle { <9.3256, -0.0626, 18.8742>, <0.774, 0.579, -0.256>, <9.4481, -0.4554, 18.3884>, <0.758, 0.587, -0.283>, <9.8139, -0.9483, 18.3461>, <0.774, 0.579, -0.256> }
	smooth_triangle { <9.8139, -0.9483, 18.3461>, <0.774, 0.579, -0.256>, <9.6625, -0.5349, 18.8555>, <0.788, 0.571, -0.229>, <9.3256, -0.0626, 18.8742>, <0.774, 0.579, -0.256> }
	smooth_triangle { <9.9932, -0.2352, 19.8821>, <-0.354, 0.850, 0.391>, <10.3776, 0.0987, 19.3778>, <-0.439, 0.866, 0.239>, <10.9467, 0.3776, 19.4125>, <-0.354, 0.850, 0.391> }
	smooth_triangle { <10.9467, 0.3776, 19.4125>, <-0.354, 0.850, 0.391>, <10.6515, -0.0029, 19.8480>, <-0.257, 0.807, 0.531>, <9.9932, -0.2352, 19.8821>, <-0.354, 0.850, 0.391> }
	smooth_triangle { <10.5962, -0.5641, 20.8943>, <0.816, -0.127, -0.564>, <10.3811, -0.9499, 20.6945>, <0.777, -0.113, -0.619>, <10.4019, -1.4390, 20.8101>, <0.816, -0.127, -0.564> }
	smooth_triangle { <10.4019, -1.4390, 20.8101>, <0.816, -0.127, -0.564>, <10.5980, -1.0328, 21.0272>, <0.851, -0.140, -0.506>, <10.5962, -0.5641, 20.8943>, <0.816, -0.127, -0.564> }
	smooth_triangle { <11.2980, -0.7239, 21.8831>, <-0.550, 0.655, 0.518>, <11.6120, -0.1846, 21.4335>, <-0.631, 0.680, 0.375>, <12.1792, 0.2760, 21.5530>, <-0.550, 0.655, 0.518> }
	smooth_triangle { <12.1792, 0.2760, 21.5530>, <-0.550, 0.655, 0.518>, <11.9416, -0.3104, 21.9419>, <-0.453, 0.613, 0.647>, <11.2980, -0.7239, 21.8831>, <-0.550, 0.655, 0.518> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0021B' */
union {
	smooth_triangle { <1.9001, 0.7939, 6.9564>, <-0.749, -0.326, 0.577>, <0.5879, 1.1266, 5.4410>, <-0.753, -0.325, 0.572>, <0.5750, 1.2078, 5.4700>, <-0.754, 0.011, 0.657> }
	smooth_triangle { <1.9001, 0.7939, 6.9564>, <-0.749, -0.326, 0.577>, <0.5750, 1.2078, 5.4700>, <-0.754, 0.011, 0.657>, <1.8871, 0.8751, 6.9855>, <-0.663, 0.363, 0.654> }
	smooth_triangle { <1.8871, 0.8751, 6.9855>, <-0.663, 0.363, 0.654>, <0.5750, 1.2078, 5.4700>, <-0.754, 0.011, 0.657>, <0.6250, 1.2730, 5.4410>, <-0.263, 0.856, 0.445> }
	smooth_triangle { <1.8871, 0.8751, 6.9855>, <-0.663, 0.363, 0.654>, <0.6250, 1.2730, 5.4410>, <-0.263, 0.856, 0.445>, <1.9372, 0.9403, 6.9564>, <-0.004, 0.976, 0.218> }
	smooth_triangle { <1.9372, 0.9403, 6.9564>, <-0.004, 0.976, 0.218>, <0.6250, 1.2730, 5.4410>, <-0.263, 0.856, 0.445>, <0.6881, 1.2570, 5.3829>, <0.494, 0.844, -0.208> }
	smooth_triangle { <1.9372, 0.9403, 6.9564>, <-0.004, 0.976, 0.218>, <0.6881, 1.2570, 5.3829>, <0.494, 0.844, -0.208>, <2.0002, 0.9243, 6.8984>, <0.659, 0.613, -0.436> }
	smooth_triangle { <2.0002, 0.9243, 6.8984>, <0.659, 0.613, -0.436>, <0.6881, 1.2570, 5.3829>, <0.494, 0.844, -0.208>, <0.7010, 1.1758, 5.3539>, <0.760, -0.012, -0.650> }
	smooth_triangle { <2.0002, 0.9243, 6.8984>, <0.659, 0.613, -0.436>, <0.7010, 1.1758, 5.3539>, <0.760, -0.012, -0.650>, <2.0132, 0.8432, 6.8693>, <0.663, -0.363, -0.654> }
	smooth_triangle { <2.0132, 0.8432, 6.8693>, <0.663, -0.363, -0.654>, <0.7010, 1.1758, 5.3539>, <0.760, -0.012, -0.650>, <0.6510, 1.1106, 5.3829>, <0.269, -0.858, -0.438> }
	smooth_triangle { <2.0132, 0.8432, 6.8693>, <0.663, -0.363, -0.654>, <0.6510, 1.1106, 5.3829>, <0.269, -0.858, -0.438>, <1.9631, 0.7779, 6.8984>, <0.004, -0.976, -0.218> }
	smooth_triangle { <1.9631, 0.7779, 6.8984>, <0.004, -0.976, -0.218>, <0.6510, 1.1106, 5.3829>, <0.269, -0.858, -0.438>, <0.5879, 1.1266, 5.4410>, <-0.272, -0.962, 0.000> }
	smooth_triangle { <1.9631, 0.7779, 6.8984>, <0.004, -0.976, -0.218>, <0.5879, 1.1266, 5.4410>, <-0.272, -0.962, 0.000>, <1.9001, 0.7939, 6.9564>, <-0.246, -0.969, 0.000> }
	smooth_triangle { <3.9671, 0.0773, 9.3548>, <-0.800, -0.260, 0.541>, <0.5879, 1.1266, 5.4410>, <-0.753, -0.325, 0.572>, <0.5750, 1.2078, 5.4700>, <-0.754, 0.011, 0.657> }
	smooth_triangle { <3.9671, 0.0773, 9.3548>, <-0.800, -0.260, 0.541>, <0.5750, 1.2078, 5.4700>, <-0.754, 0.011, 0.657>, <3.9655, 0.1108, 9.3667>, <-0.731, 0.289, 0.618> }
	smooth_triangle { <3.9655, 0.1108, 9.3667>, <-0.731, 0.289, 0.618>, <0.5750, 1.2078, 5.4700>, <-0.754, 0.011, 0.657>, <0.6250, 1.2730, 5.4410>, <-0.263, 0.856, 0.445> }
	smooth_triangle { <3.9655, 0.1108, 9.3667>, <-0.731, 0.289, 0.618>, <0.6250, 1.2730, 5.4410>, <-0.263, 0.856, 0.445>, <3.9886, 0.1350, 9.3548>, <-0.036, 0.944, 0.328> }
	smooth_triangle { <3.9886, 0.1350, 9.3548>, <-0.036, 0.944, 0.328>, <0.6250, 1.2730, 5.4410>, <-0.263, 0.856, 0.445>, <0.6881, 1.2570, 5.3829>, <0.494, 0.844, -0.208> }
	smooth_triangle { <3.9886, 0.1350, 9.3548>, <-0.036, 0.944, 0.328>, <0.6881, 1.2570, 5.3829>, <0.494, 0.844, -0.208>, <4.0133, 0.1258, 9.3310>, <0.699, 0.655, -0.285> }
	smooth_triangle { <4.0133, 0.1258, 9.3310>, <0.699, 0.655, -0.285>, <0.6881, 1.2570, 5.3829>, <0.494, 0.844, -0.208>, <0.7010, 1.1758, 5.3539>, <0.760, -0.012, -0.650> }
	smooth_triangle { <4.0133, 0.1258, 9.3310>, <0.699, 0.655, -0.285>, <0.7010, 1.1758, 5.3539>, <0.760, -0.012, -0.650>, <4.0150, 0.0924, 9.3191>, <0.738, -0.291, -0.608> }
	smooth_triangle { <4.0150, 0.0924, 9.3191>, <0.738, -0.291, -0.608>, <0.7010, 1.1758, 5.3539>, <0.760, -0.012, -0.650>, <0.6510, 1.1106, 5.3829>, <0.269, -0.858, -0.438> }
	smooth_triangle { <4.0150, 0.0924, 9.3191>, <0.738, -0.291, -0.608>, <0.6510, 1.1106, 5.3829>, <0.269, -0.858, -0.438>, <3.9919, 0.0681, 9.3310>, <0.044, -0.947, -0.319> }
	smooth_triangle { <3.9919, 0.0681, 9.3310>, <0.044, -0.947, -0.319>, <0.6510, 1.1106, 5.3829>, <0.269, -0.858, -0.438>, <0.5879, 1.1266, 5.4410>, <-0.272, -0.962, 0.000> }
	smooth_triangle { <3.9919, 0.0681, 9.3310>, <0.044, -0.947, -0.319>, <0.5879, 1.1266, 5.4410>, <-0.272, -0.962, 0.000>, <3.9671, 0.0773, 9.3548>, <-0.424, -0.905, -0.018> }
	smooth_triangle { <5.5757, -0.9056, 11.9967>, <-0.812, -0.136, 0.568>, <3.9671, 0.0773, 9.3548>, <-0.800, -0.260, 0.541>, <3.9655, 0.1108, 9.3667>, <-0.731, 0.289, 0.618> }
	smooth_triangle { <5.5757, -0.9056, 11.9967>, <-0.812, -0.136, 0.568>, <3.9655, 0.1108, 9.3667>, <-0.731, 0.289, 0.618>, <5.5785, -0.8815, 12.0041>, <-0.630, 0.343, 0.696> }
	smooth_triangle { <5.5785, -0.8815, 12.0041>, <-0.630, 0.343, 0.696>, <3.9655, 0.1108, 9.3667>, <-0.731, 0.289, 0.618>, <3.9886, 0.1350, 9.3548>, <-0.036, 0.944, 0.328> }
	smooth_triangle { <5.5785, -0.8815, 12.0041>, <-0.630, 0.343, 0.696>, <3.9886, 0.1350, 9.3548>, <-0.036, 0.944, 0.328>, <5.5989, -0.8682, 11.9967>, <0.102, 0.931, 0.350> }
	smooth_triangle { <5.5989, -0.8682, 11.9967>, <0.102, 0.931, 0.350>, <3.9886, 0.1350, 9.3548>, <-0.036, 0.944, 0.328>, <4.0133, 0.1258, 9.3310>, <0.699, 0.655, -0.285> }
	smooth_triangle { <5.5989, -0.8682, 11.9967>, <0.102, 0.931, 0.350>, <4.0133, 0.1258, 9.3310>, <0.699, 0.655, -0.285>, <5.6164, -0.8791, 11.9819>, <0.731, 0.590, -0.343> }
	smooth_triangle { <5.6164, -0.8791, 11.9819>, <0.731, 0.590, -0.343>, <4.0133, 0.1258, 9.3310>, <0.699, 0.655, -0.285>, <4.0150, 0.0924, 9.3191>, <0.738, -0.291, -0.608> }
	smooth_triangle { <5.6164, -0.8791, 11.9819>, <0.731, 0.590, -0.343>, <4.0150, 0.0924, 9.3191>, <0.738, -0.291, -0.608>, <5.6137, -0.9033, 11.9746>, <0.632, -0.344, -0.694> }
	smooth_triangle { <5.6137, -0.9033, 11.9746>, <0.632, -0.344, -0.694>, <4.0150, 0.0924, 9.3191>, <0.738, -0.291, -0.608>, <3.9919, 0.0681, 9.3310>, <0.044, -0.947, -0.319> }
	smooth_triangle { <5.6137, -0.9033, 11.9746>, <0.632, -0.344, -0.694>, <3.9919, 0.0681, 9.3310>, <0.044, -0.947, -0.319>, <5.5933, -0.9165, 11.9819>, <-0.100, -0.932, -0.347> }
	smooth_triangle { <5.5933, -0.9165, 11.9819>, <-0.100, -0.932, -0.347>, <3.9919, 0.0681, 9.3310>, <0.044, -0.947, -0.319>, <3.9671, 0.0773, 9.3548>, <-0.424, -0.905, -0.018> }
	smooth_triangle { <5.5933, -0.9165, 11.9819>, <-0.100, -0.932, -0.347>, <3.9671, 0.0773, 9.3548>, <-0.424, -0.905, -0.018>, <5.5757, -0.9056, 11.9967>, <-0.458, -0.888, 0.036> }
	smooth_triangle { <7.0536, -1.5264, 13.2555>, <-0.750, -0.411, 0.518>, <5.5757, -0.9056, 11.9967>, <-0.812, -0.136, 0.568>, <5.5785, -0.8815, 12.0041>, <-0.630, 0.343, 0.696> }
	smooth_triangle { <7.0536, -1.5264, 13.2555>, <-0.750, -0.411, 0.518>, <5.5785, -0.8815, 12.0041>, <-0.630, 0.343, 0.696>, <7.0549, -1.5031, 13.2654>, <-0.609, 0.403, 0.684> }
	smooth_triangle { <7.0549, -1.5031, 13.2654>, <-0.609, 0.403, 0.684>, <5.5785, -0.8815, 12.0041>, <-0.630, 0.343, 0.696>, <5.5989, -0.8682, 11.9967>, <0.102, 0.931, 0.350> }
	smooth_triangle { <7.0549, -1.5031, 13.2654>, <-0.609, 0.403, 0.684>, <5.5989, -0.8682, 11.9967>, <0.102, 0.931, 0.350>, <7.0706, -1.4859, 13.2555>, <0.111, 0.961, 0.255> }
	smooth_triangle { <7.0706, -1.4859, 13.2555>, <0.111, 0.961, 0.255>, <5.5989, -0.8682, 11.9967>, <0.102, 0.931, 0.350>, <5.6164, -0.8791, 11.9819>, <0.731, 0.590, -0.343> }
	smooth_triangle { <7.0706, -1.4859, 13.2555>, <0.111, 0.961, 0.255>, <5.6164, -0.8791, 11.9819>, <0.731, 0.590, -0.343>, <7.0851, -1.4919, 13.2355>, <0.718, 0.553, -0.422> }
	smooth_triangle { <7.0851, -1.4919, 13.2355>, <0.718, 0.553, -0.422>, <5.6164, -0.8791, 11.9819>, <0.731, 0.590, -0.343>, <5.6137, -0.9033, 11.9746>, <0.632, -0.344, -0.694> }
	smooth_triangle { <7.0851, -1.4919, 13.2355>, <0.718, 0.553, -0.422>, <5.6137, -0.9033, 11.9746>, <0.632, -0.344, -0.694>, <7.0839, -1.5153, 13.2255>, <0.614, -0.405, -0.677> }
	smooth_triangle { <7.0839, -1.5153, 13.2255>, <0.614, -0.405, -0.677>, <5.6137, -0.9033, 11.9746>, <0.632, -0.344, -0.694>, <5.5933, -0.9165, 11.9819>, <-0.100, -0.932, -0.347> }
	smooth_triangle { <7.0839, -1.5153, 13.2255>, <0.614, -0.405, -0.677>, <5.5933, -0.9165, 11.9819>, <-0.100, -0.932, -0.347>, <7.0681, -1.5325, 13.2355>, <-0.105, -0.963, -0.248> }
	smooth_triangle { <7.0681, -1.5325, 13.2355>, <-0.105, -0.963, -0.248>, <5.5933, -0.9165, 11.9819>, <-0.100, -0.932, -0.347>, <5.5757, -0.9056, 11.9967>, <-0.458, -0.888, 0.036> }
	smooth_triangle { <7.0681, -1.5325, 13.2355>, <-0.105, -0.963, -0.248>, <5.5757, -0.9056, 11.9967>, <-0.458, -0.888, 0.036>, <7.0536, -1.5264, 13.2555>, <-0.387, -0.922, -0.001> }
	smooth_triangle { <8.0058, -1.9887, 14.9839>, <-0.880, -0.163, 0.447>, <7.0536, -1.5264, 13.2555>, <-0.750, -0.411, 0.518>, <7.0549, -1.5031, 13.2654>, <-0.609, 0.403, 0.684> }
	smooth_triangle { <8.0058, -1.9887, 14.9839>, <-0.473, 0.740, 0.477>, <7.0549, -1.5031, 13.2654>, <-0.609, 0.403, 0.684>, <7.0706, -1.4859, 13.2555>, <0.111, 0.961, 0.255> }
	smooth_triangle { <8.0058, -1.9887, 14.9839>, <0.422, 0.906, 0.041>, <7.0706, -1.4859, 13.2555>, <0.111, 0.961, 0.255>, <7.0851, -1.4919, 13.2355>, <0.718, 0.553, -0.422> }
	smooth_triangle { <8.0058, -1.9887, 14.9839>, <0.894, 0.153, -0.421>, <7.0851, -1.4919, 13.2355>, <0.718, 0.553, -0.422>, <7.0839, -1.5153, 13.2255>, <0.614, -0.405, -0.677> }
	smooth_triangle { <8.0058, -1.9887, 14.9839>, <0.490, -0.745, -0.452>, <7.0839, -1.5153, 13.2255>, <0.614, -0.405, -0.677>, <7.0681, -1.5325, 13.2355>, <-0.105, -0.963, -0.248> }
	smooth_triangle { <8.0058, -1.9887, 14.9839>, <-0.402, -0.915, -0.017>, <7.0681, -1.5325, 13.2355>, <-0.105, -0.963, -0.248>, <7.0536, -1.5264, 13.2555>, <-0.750, -0.411, 0.518> }
	smooth_triangle { <4.3189, 0.4643, 10.8932>, <-0.140, -0.954, 0.267>, <3.9995, 0.0782, 9.3468>, <-0.126, -0.935, 0.330>, <3.9748, 0.0830, 9.3507>, <-0.366, -0.863, 0.349> }
	smooth_triangle { <4.3189, 0.4643, 10.8932>, <-0.140, -0.954, 0.267>, <3.9748, 0.0830, 9.3507>, <-0.366, -0.863, 0.349>, <4.2942, 0.4690, 10.8972>, <-0.741, -0.599, 0.303> }
	smooth_triangle { <4.2942, 0.4690, 10.8972>, <-0.741, -0.599, 0.303>, <3.9748, 0.0830, 9.3507>, <-0.510, -0.795, 0.330>, <3.9656, 0.1063, 9.3468>, <-0.977, -0.087, 0.197> }
	smooth_triangle { <4.2942, 0.4690, 10.8972>, <-0.741, -0.599, 0.303>, <3.9656, 0.1063, 9.3468>, <-0.977, -0.087, 0.197>, <4.2850, 0.4924, 10.8932>, <-0.927, 0.362, 0.101> }
	smooth_triangle { <4.2850, 0.4924, 10.8932>, <-0.927, 0.362, 0.101>, <3.9656, 0.1063, 9.3468>, <-0.988, 0.063, 0.144>, <3.9810, 0.1249, 9.3390>, <-0.612, 0.777, -0.151> }
	smooth_triangle { <4.2850, 0.4924, 10.8932>, <-0.927, 0.362, 0.101>, <3.9810, 0.1249, 9.3390>, <-0.612, 0.777, -0.151>, <4.3004, 0.5110, 10.8854>, <-0.185, 0.962, -0.202> }
	smooth_triangle { <4.3004, 0.5110, 10.8854>, <-0.185, 0.962, -0.202>, <3.9810, 0.1249, 9.3390>, <-0.478, 0.858, -0.185>, <4.0056, 0.1202, 9.3351>, <0.366, 0.863, -0.348> }
	smooth_triangle { <4.3004, 0.5110, 10.8854>, <-0.185, 0.962, -0.202>, <4.0056, 0.1202, 9.3351>, <0.366, 0.863, -0.348>, <4.3250, 0.5063, 10.8815>, <0.741, 0.599, -0.303> }
	smooth_triangle { <4.3250, 0.5063, 10.8815>, <0.741, 0.599, -0.303>, <4.0056, 0.1202, 9.3351>, <0.510, 0.795, -0.328>, <4.0149, 0.0969, 9.3390>, <0.977, 0.087, -0.196> }
	smooth_triangle { <4.3250, 0.5063, 10.8815>, <0.741, 0.599, -0.303>, <4.0149, 0.0969, 9.3390>, <0.977, 0.087, -0.196>, <4.3343, 0.4829, 10.8854>, <0.927, -0.362, -0.101> }
	smooth_triangle { <4.3343, 0.4829, 10.8854>, <0.927, -0.362, -0.101>, <4.0149, 0.0969, 9.3390>, <0.988, -0.063, -0.142>, <3.9995, 0.0782, 9.3468>, <0.853, -0.521, 0.027> }
	smooth_triangle { <4.3343, 0.4829, 10.8854>, <0.927, -0.362, -0.101>, <3.9995, 0.0782, 9.3468>, <0.853, -0.521, 0.027>, <4.3189, 0.4643, 10.8932>, <0.770, -0.637, 0.000> }
	smooth_triangle { <4.5287, 1.9261, 13.7969>, <0.224, -0.912, 0.343>, <3.9995, 0.0782, 9.3468>, <-0.126, -0.935, 0.330>, <3.9748, 0.0830, 9.3507>, <-0.366, -0.863, 0.349> }
	smooth_triangle { <4.5287, 1.9261, 13.7969>, <0.224, -0.912, 0.343>, <3.9748, 0.0830, 9.3507>, <-0.002, -0.948, 0.318>, <4.5053, 1.9179, 13.8026>, <0.093, -0.937, 0.338> }
	smooth_triangle { <4.5053, 1.9179, 13.8026>, <-0.731, -0.631, 0.259>, <3.9748, 0.0830, 9.3507>, <-0.510, -0.795, 0.330>, <3.9656, 0.1063, 9.3468>, <-0.977, -0.087, 0.197> }
	smooth_triangle { <4.5053, 1.9179, 13.8026>, <-0.333, -0.882, 0.335>, <3.9656, 0.1063, 9.3468>, <-0.856, -0.427, 0.292>, <4.4851, 1.9321, 13.7969>, <-0.813, -0.559, 0.164> }
	smooth_triangle { <4.4851, 1.9321, 13.7969>, <-0.956, 0.281, -0.085>, <3.9656, 0.1063, 9.3468>, <-0.988, 0.063, 0.144>, <3.9810, 0.1249, 9.3390>, <-0.612, 0.777, -0.151> }
	smooth_triangle { <4.4851, 1.9321, 13.7969>, <-0.983, -0.171, 0.064>, <3.9810, 0.1249, 9.3390>, <-0.853, 0.521, -0.027>, <4.4881, 1.9545, 13.7854>, <-0.907, 0.382, -0.176> }
	smooth_triangle { <4.4881, 1.9545, 13.7854>, <-0.224, 0.913, -0.341>, <3.9810, 0.1249, 9.3390>, <-0.478, 0.858, -0.185>, <4.0056, 0.1202, 9.3351>, <0.366, 0.863, -0.348> }
	smooth_triangle { <4.4881, 1.9545, 13.7854>, <-0.649, 0.712, -0.269>, <4.0056, 0.1202, 9.3351>, <0.002, 0.948, -0.318>, <4.5115, 1.9628, 13.7797>, <-0.093, 0.936, -0.338> }
	smooth_triangle { <4.5115, 1.9628, 13.7797>, <0.731, 0.632, -0.257>, <4.0056, 0.1202, 9.3351>, <0.510, 0.795, -0.328>, <4.0149, 0.0969, 9.3390>, <0.977, 0.087, -0.196> }
	smooth_triangle { <4.5115, 1.9628, 13.7797>, <0.333, 0.882, -0.333>, <4.0149, 0.0969, 9.3390>, <0.856, 0.427, -0.292>, <4.5317, 1.9486, 13.7854>, <0.813, 0.559, -0.164> }
	smooth_triangle { <4.5317, 1.9486, 13.7854>, <0.956, -0.280, 0.087>, <4.0149, 0.0969, 9.3390>, <0.988, -0.063, -0.142>, <3.9995, 0.0782, 9.3468>, <0.853, -0.521, 0.027> }
	smooth_triangle { <4.5317, 1.9486, 13.7854>, <0.983, 0.172, -0.062>, <3.9995, 0.0782, 9.3468>, <0.853, -0.521, 0.027>, <4.5287, 1.9261, 13.7969>, <0.997, 0.073, 0.033> }
	smooth_triangle { <4.1751, 2.6900, 16.5152>, <0.695, -0.684, 0.222>, <4.5287, 1.9261, 13.7969>, <0.224, -0.912, 0.343>, <4.5053, 1.9179, 13.8026>, <0.093, -0.937, 0.338> }
	smooth_triangle { <4.1751, 2.6900, 16.5152>, <0.695, -0.684, 0.222>, <4.5053, 1.9179, 13.8026>, <0.543, -0.786, 0.296>, <4.1604, 2.6696, 16.5189>, <0.383, -0.889, 0.251> }
	smooth_triangle { <4.1604, 2.6696, 16.5189>, <-0.137, -0.961, 0.241>, <4.5053, 1.9179, 13.8026>, <-0.333, -0.882, 0.335>, <4.4851, 1.9321, 13.7969>, <-0.813, -0.559, 0.164> }
	smooth_triangle { <4.1604, 2.6696, 16.5189>, <0.220, -0.943, 0.250>, <4.4851, 1.9321, 13.7969>, <-0.448, -0.855, 0.262>, <4.1354, 2.6711, 16.5152>, <-0.608, -0.765, 0.211> }
	smooth_triangle { <4.1354, 2.6711, 16.5152>, <-0.924, -0.375, 0.071>, <4.4851, 1.9321, 13.7969>, <-0.983, -0.171, 0.064>, <4.4881, 1.9545, 13.7854>, <-0.907, 0.382, -0.176> }
	smooth_triangle { <4.1354, 2.6711, 16.5152>, <-0.732, -0.662, 0.158>, <4.4881, 1.9545, 13.7854>, <-0.997, -0.073, -0.035>, <4.1249, 2.6930, 16.5078>, <-0.991, 0.124, -0.042> }
	smooth_triangle { <4.1249, 2.6930, 16.5078>, <-0.787, 0.592, -0.171>, <4.4881, 1.9545, 13.7854>, <-0.649, 0.712, -0.269>, <4.5115, 1.9628, 13.7797>, <-0.093, 0.936, -0.338> }
	smooth_triangle { <4.1249, 2.6930, 16.5078>, <-0.954, 0.285, -0.094>, <4.5115, 1.9628, 13.7797>, <-0.543, 0.786, -0.297>, <4.1395, 2.7134, 16.5040>, <-0.382, 0.888, -0.255> }
	smooth_triangle { <4.1395, 2.7134, 16.5040>, <0.137, 0.961, -0.241>, <4.5115, 1.9628, 13.7797>, <0.333, 0.882, -0.333>, <4.5317, 1.9486, 13.7854>, <0.813, 0.559, -0.164> }
	smooth_triangle { <4.1395, 2.7134, 16.5040>, <-0.220, 0.942, -0.252>, <4.5317, 1.9486, 13.7854>, <0.448, 0.854, -0.263>, <4.1646, 2.7119, 16.5078>, <0.609, 0.764, -0.215> }
	smooth_triangle { <4.1646, 2.7119, 16.5078>, <0.924, 0.375, -0.072>, <4.5317, 1.9486, 13.7854>, <0.983, 0.172, -0.062>, <4.5287, 1.9261, 13.7969>, <0.997, 0.073, 0.033> }
	smooth_triangle { <4.1646, 2.7119, 16.5078>, <0.732, 0.662, -0.160>, <4.5287, 1.9261, 13.7969>, <0.997, 0.073, 0.033>, <4.1751, 2.6900, 16.5152>, <0.979, 0.192, -0.063> }
	smooth_triangle { <4.3455, 3.3334, 18.8559>, <0.474, -0.859, 0.192>, <4.1751, 2.6900, 16.5152>, <0.695, -0.684, 0.222>, <4.1604, 2.6696, 16.5189>, <0.383, -0.889, 0.251> }
	smooth_triangle { <4.3455, 3.3334, 18.8559>, <0.474, -0.859, 0.192>, <4.1604, 2.6696, 16.5189>, <0.220, -0.943, 0.250>, <4.3210, 3.3273, 18.8594>, <-0.195, -0.973, 0.121> }
	smooth_triangle { <4.3210, 3.3273, 18.8594>, <-0.195, -0.973, 0.121>, <4.1604, 2.6696, 16.5189>, <0.220, -0.943, 0.250>, <4.1354, 2.6711, 16.5152>, <-0.608, -0.765, 0.211> }
	smooth_triangle { <4.3210, 3.3273, 18.8594>, <-0.195, -0.973, 0.121>, <4.1354, 2.6711, 16.5152>, <-0.732, -0.662, 0.158>, <4.3030, 3.3448, 18.8559>, <-0.928, -0.340, -0.150> }
	smooth_triangle { <4.3030, 3.3448, 18.8559>, <-0.928, -0.340, -0.150>, <4.1354, 2.6711, 16.5152>, <-0.732, -0.662, 0.158>, <4.1249, 2.6930, 16.5078>, <-0.991, 0.124, -0.042> }
	smooth_triangle { <4.3030, 3.3448, 18.8559>, <-0.928, -0.340, -0.150>, <4.1249, 2.6930, 16.5078>, <-0.954, 0.285, -0.094>, <4.3093, 3.3683, 18.8488>, <-0.724, 0.640, -0.259> }
	smooth_triangle { <4.3093, 3.3683, 18.8488>, <-0.724, 0.640, -0.259>, <4.1249, 2.6930, 16.5078>, <-0.954, 0.285, -0.094>, <4.1395, 2.7134, 16.5040>, <-0.382, 0.888, -0.255> }
	smooth_triangle { <4.3093, 3.3683, 18.8488>, <-0.724, 0.640, -0.259>, <4.1395, 2.7134, 16.5040>, <-0.220, 0.942, -0.252>, <4.3337, 3.3744, 18.8452>, <0.194, 0.976, -0.104> }
	smooth_triangle { <4.3337, 3.3744, 18.8452>, <0.194, 0.976, -0.104>, <4.1395, 2.7134, 16.5040>, <-0.220, 0.942, -0.252>, <4.1646, 2.7119, 16.5078>, <0.609, 0.764, -0.215> }
	smooth_triangle { <4.3337, 3.3744, 18.8452>, <0.194, 0.976, -0.104>, <4.1646, 2.7119, 16.5078>, <0.732, 0.662, -0.160>, <4.3518, 3.3569, 18.8488>, <0.926, 0.342, 0.162> }
	smooth_triangle { <4.3518, 3.3569, 18.8488>, <0.926, 0.342, 0.162>, <4.1646, 2.7119, 16.5078>, <0.732, 0.662, -0.160>, <4.1751, 2.6900, 16.5152>, <0.979, 0.192, -0.063> }
	smooth_triangle { <4.3518, 3.3569, 18.8488>, <0.926, 0.342, 0.162>, <4.1751, 2.6900, 16.5152>, <0.979, 0.192, -0.063>, <4.3455, 3.3334, 18.8559>, <0.930, -0.149, 0.335> }
	smooth_triangle { <2.8302, 3.3303, 20.7770>, <0.264, -0.942, 0.207>, <4.3455, 3.3334, 18.8559>, <0.474, -0.859, 0.192>, <4.3210, 3.3273, 18.8594>, <-0.195, -0.973, 0.121> }
	smooth_triangle { <2.8302, 3.3303, 20.7770>, <0.680, 0.519, 0.517>, <4.3210, 3.3273, 18.8594>, <0.675, 0.519, 0.524>, <2.8408, 3.3086, 20.7848>, <0.780, 0.109, 0.616> }
	smooth_triangle { <2.8408, 3.3086, 20.7848>, <-0.574, -0.685, -0.448>, <4.3210, 3.3273, 18.8594>, <-0.195, -0.973, 0.121>, <4.3030, 3.3448, 18.8559>, <-0.928, -0.340, -0.150> }
	smooth_triangle { <2.8408, 3.3086, 20.7848>, <0.780, 0.109, 0.616>, <4.3030, 3.3448, 18.8559>, <0.703, -0.480, 0.524>, <2.8314, 3.2863, 20.7770>, <0.439, -0.806, 0.398> }
	smooth_triangle { <2.8314, 3.2863, 20.7770>, <-0.794, 0.030, -0.607>, <4.3030, 3.3448, 18.8559>, <-0.928, -0.340, -0.150>, <4.3093, 3.3683, 18.8488>, <-0.815, 0.513, -0.271> }
	smooth_triangle { <2.8314, 3.2863, 20.7770>, <0.439, -0.806, 0.398>, <4.3093, 3.3683, 18.8488>, <0.039, -0.999, -0.013>, <2.8115, 3.2858, 20.7613>, <-0.338, -0.914, -0.224> }
	smooth_triangle { <2.8115, 3.2858, 20.7613>, <-0.260, 0.952, -0.162>, <4.3093, 3.3683, 18.8488>, <-0.642, 0.754, -0.140>, <4.3337, 3.3744, 18.8452>, <0.194, 0.976, -0.104> }
	smooth_triangle { <2.8115, 3.2858, 20.7613>, <-0.338, -0.914, -0.224>, <4.3337, 3.3744, 18.8452>, <-0.658, -0.519, -0.546>, <2.8008, 3.3075, 20.7534>, <-0.772, -0.109, -0.626> }
	smooth_triangle { <2.8008, 3.3075, 20.7534>, <0.562, 0.677, 0.475>, <4.3337, 3.3744, 18.8452>, <0.194, 0.976, -0.104>, <4.3518, 3.3569, 18.8488>, <0.926, 0.342, 0.162> }
	smooth_triangle { <2.8008, 3.3075, 20.7534>, <-0.772, -0.109, -0.626>, <4.3518, 3.3569, 18.8488>, <-0.686, 0.481, -0.546>, <2.8102, 3.3297, 20.7613>, <-0.430, 0.805, -0.409> }
	smooth_triangle { <2.8102, 3.3297, 20.7613>, <0.779, -0.020, 0.627>, <4.3518, 3.3569, 18.8488>, <0.926, 0.342, 0.162>, <4.3455, 3.3334, 18.8559>, <0.930, -0.149, 0.335> }
	smooth_triangle { <2.8102, 3.3297, 20.7613>, <-0.430, 0.805, -0.409>, <4.3455, 3.3334, 18.8559>, <-0.018, 1.000, -0.013>, <2.8302, 3.3303, 20.7770>, <0.055, 0.998, -0.033> }
	smooth_triangle { <1.2766, 3.5519, 22.6406>, <0.672, 0.627, 0.395>, <2.8302, 3.3303, 20.7770>, <0.680, 0.519, 0.517>, <2.8408, 3.3086, 20.7848>, <0.780, 0.109, 0.616> }
	smooth_triangle { <1.2766, 3.5519, 22.6406>, <0.672, 0.627, 0.395>, <2.8408, 3.3086, 20.7848>, <0.780, 0.109, 0.616>, <1.2831, 3.5288, 22.6488>, <0.741, -0.195, 0.643> }
	smooth_triangle { <1.2831, 3.5288, 22.6488>, <0.741, -0.195, 0.643>, <2.8408, 3.3086, 20.7848>, <0.780, 0.109, 0.616>, <2.8314, 3.2863, 20.7770>, <0.439, -0.806, 0.398> }
	smooth_triangle { <1.2831, 3.5288, 22.6488>, <0.741, -0.195, 0.643>, <2.8314, 3.2863, 20.7770>, <0.439, -0.806, 0.398>, <1.2703, 3.5084, 22.6406>, <0.153, -0.935, 0.320> }
	smooth_triangle { <1.2703, 3.5084, 22.6406>, <0.153, -0.935, 0.320>, <2.8314, 3.2863, 20.7770>, <0.439, -0.806, 0.398>, <2.8115, 3.2858, 20.7613>, <-0.338, -0.914, -0.224> }
	smooth_triangle { <1.2703, 3.5084, 22.6406>, <0.153, -0.935, 0.320>, <2.8115, 3.2858, 20.7613>, <-0.338, -0.914, -0.224>, <1.2511, 3.5112, 22.6242>, <-0.591, -0.741, -0.319> }
	smooth_triangle { <1.2511, 3.5112, 22.6242>, <-0.591, -0.741, -0.319>, <2.8115, 3.2858, 20.7613>, <-0.338, -0.914, -0.224>, <2.8008, 3.3075, 20.7534>, <-0.772, -0.109, -0.626> }
	smooth_triangle { <1.2511, 3.5112, 22.6242>, <-0.591, -0.741, -0.319>, <2.8008, 3.3075, 20.7534>, <-0.772, -0.109, -0.626>, <1.2446, 3.5343, 22.6160>, <-0.746, 0.196, -0.636> }
	smooth_triangle { <1.2446, 3.5343, 22.6160>, <-0.746, 0.196, -0.636>, <2.8008, 3.3075, 20.7534>, <-0.772, -0.109, -0.626>, <2.8102, 3.3297, 20.7613>, <-0.430, 0.805, -0.409> }
	smooth_triangle { <1.2446, 3.5343, 22.6160>, <-0.746, 0.196, -0.636>, <2.8102, 3.3297, 20.7613>, <-0.430, 0.805, -0.409>, <1.2574, 3.5547, 22.6242>, <-0.158, 0.936, -0.314> }
	smooth_triangle { <1.2574, 3.5547, 22.6242>, <-0.158, 0.936, -0.314>, <2.8102, 3.3297, 20.7613>, <-0.430, 0.805, -0.409>, <2.8302, 3.3303, 20.7770>, <0.055, 0.998, -0.033> }
	smooth_triangle { <1.2574, 3.5547, 22.6242>, <-0.158, 0.936, -0.314>, <2.8302, 3.3303, 20.7770>, <0.055, 0.998, -0.033>, <1.2766, 3.5519, 22.6406>, <0.142, 0.990, 0.000> }
	smooth_triangle { <-0.1900, 4.1689, 24.4833>, <0.778, 0.388, 0.495>, <1.2766, 3.5519, 22.6406>, <0.672, 0.627, 0.395>, <1.2831, 3.5288, 22.6488>, <0.741, -0.195, 0.643> }
	smooth_triangle { <-0.1900, 4.1689, 24.4833>, <0.526, -0.574, 0.628>, <1.2831, 3.5288, 22.6488>, <0.741, -0.195, 0.643>, <1.2703, 3.5084, 22.6406>, <0.153, -0.935, 0.320> }
	smooth_triangle { <-0.1900, 4.1689, 24.4833>, <-0.258, -0.955, 0.143>, <1.2703, 3.5084, 22.6406>, <0.153, -0.935, 0.320>, <1.2511, 3.5112, 22.6242>, <-0.591, -0.741, -0.319> }
	smooth_triangle { <-0.1900, 4.1689, 24.4833>, <-0.793, -0.383, -0.474>, <1.2511, 3.5112, 22.6242>, <-0.591, -0.741, -0.319>, <1.2446, 3.5343, 22.6160>, <-0.746, 0.196, -0.636> }
	smooth_triangle { <-0.1900, 4.1689, 24.4833>, <-0.543, 0.579, -0.608>, <1.2446, 3.5343, 22.6160>, <-0.746, 0.196, -0.636>, <1.2574, 3.5547, 22.6242>, <-0.158, 0.936, -0.314> }
	smooth_triangle { <-0.1900, 4.1689, 24.4833>, <0.242, 0.962, -0.123>, <1.2574, 3.5547, 22.6242>, <-0.158, 0.936, -0.314>, <1.2766, 3.5519, 22.6406>, <0.672, 0.627, 0.395> }
	smooth_triangle { <5.3993, -0.6990, 9.4725>, <-0.296, -0.408, 0.864>, <3.9788, 0.0827, 9.3555>, <-0.224, -0.446, 0.867>, <3.9886, 0.1025, 9.3682>, <-0.117, -0.151, 0.982> }
	smooth_triangle { <5.3993, -0.6990, 9.4725>, <-0.296, -0.408, 0.864>, <3.9886, 0.1025, 9.3682>, <-0.117, -0.151, 0.982>, <5.4091, -0.6793, 9.4852>, <0.029, 0.200, 0.979> }
	smooth_triangle { <5.4091, -0.6793, 9.4852>, <0.029, 0.200, 0.979>, <3.9886, 0.1025, 9.3682>, <-0.117, -0.151, 0.982>, <4.0000, 0.1213, 9.3555>, <0.240, 0.721, 0.650> }
	smooth_triangle { <5.4091, -0.6793, 9.4852>, <0.029, 0.200, 0.979>, <4.0000, 0.1213, 9.3555>, <0.240, 0.721, 0.650>, <5.4205, -0.6605, 9.4725>, <0.435, 0.839, 0.326> }
	smooth_triangle { <5.4205, -0.6605, 9.4725>, <0.435, 0.839, 0.326>, <4.0000, 0.1213, 9.3555>, <0.240, 0.721, 0.650>, <4.0016, 0.1204, 9.3302>, <0.358, 0.873, -0.332> }
	smooth_triangle { <5.4205, -0.6605, 9.4725>, <0.435, 0.839, 0.326>, <4.0016, 0.1204, 9.3302>, <0.358, 0.873, -0.332>, <5.4221, -0.6614, 9.4472>, <0.406, 0.640, -0.653> }
	smooth_triangle { <5.4221, -0.6614, 9.4472>, <0.406, 0.640, -0.653>, <4.0016, 0.1204, 9.3302>, <0.358, 0.873, -0.332>, <3.9918, 0.1007, 9.3175>, <0.117, 0.151, -0.982> }
	smooth_triangle { <5.4221, -0.6614, 9.4472>, <0.406, 0.640, -0.653>, <3.9918, 0.1007, 9.3175>, <0.117, 0.151, -0.982>, <5.4123, -0.6811, 9.4345>, <-0.029, -0.200, -0.979> }
	smooth_triangle { <5.4123, -0.6811, 9.4345>, <-0.029, -0.200, -0.979>, <3.9918, 0.1007, 9.3175>, <0.117, 0.151, -0.982>, <3.9804, 0.0819, 9.3302>, <-0.240, -0.721, -0.650> }
	smooth_triangle { <5.4123, -0.6811, 9.4345>, <-0.029, -0.200, -0.979>, <3.9804, 0.0819, 9.3302>, <-0.240, -0.721, -0.650>, <5.4009, -0.6999, 9.4472>, <-0.435, -0.839, -0.326> }
	smooth_triangle { <5.4009, -0.6999, 9.4472>, <-0.435, -0.839, -0.326>, <3.9804, 0.0819, 9.3302>, <-0.240, -0.721, -0.650>, <3.9788, 0.0827, 9.3555>, <-0.362, -0.932, 0.004> }
	smooth_triangle { <5.4009, -0.6999, 9.4472>, <-0.435, -0.839, -0.326>, <3.9788, 0.0827, 9.3555>, <-0.362, -0.932, 0.004>, <5.3993, -0.6990, 9.4725>, <-0.482, -0.876, 0.000> }
	smooth_triangle { <8.6408, -1.0421, 9.5399>, <0.051, -0.503, 0.863>, <3.9788, 0.0827, 9.3555>, <-0.224, -0.446, 0.867>, <3.9886, 0.1025, 9.3682>, <-0.117, -0.151, 0.982> }
	smooth_triangle { <8.6408, -1.0421, 9.5399>, <0.051, -0.503, 0.863>, <3.9886, 0.1025, 9.3682>, <-0.117, -0.151, 0.982>, <8.6428, -1.0202, 9.5526>, <0.191, -0.148, 0.970> }
	smooth_triangle { <8.6428, -1.0202, 9.5526>, <0.276, 0.085, 0.957>, <3.9886, 0.1025, 9.3682>, <-0.117, -0.151, 0.982>, <4.0000, 0.1213, 9.3555>, <0.240, 0.721, 0.650> }
	smooth_triangle { <8.6428, -1.0202, 9.5526>, <0.276, 0.085, 0.957>, <4.0000, 0.1213, 9.3555>, <0.240, 0.721, 0.650>, <8.6454, -0.9983, 9.5399>, <0.450, 0.780, 0.435> }
	smooth_triangle { <8.6454, -0.9983, 9.5399>, <0.450, 0.780, 0.435>, <4.0000, 0.1213, 9.3555>, <0.240, 0.721, 0.650>, <4.0016, 0.1204, 9.3302>, <0.358, 0.873, -0.332> }
	smooth_triangle { <8.6454, -0.9983, 9.5399>, <0.450, 0.780, 0.435>, <4.0016, 0.1204, 9.3302>, <0.358, 0.873, -0.332>, <8.6459, -0.9984, 9.5145>, <0.163, 0.854, -0.493> }
	smooth_triangle { <8.6459, -0.9984, 9.5145>, <0.163, 0.854, -0.493>, <4.0016, 0.1204, 9.3302>, <0.358, 0.873, -0.332>, <3.9918, 0.1007, 9.3175>, <0.117, 0.151, -0.982> }
	smooth_triangle { <8.6459, -0.9984, 9.5145>, <0.163, 0.854, -0.493>, <3.9918, 0.1007, 9.3175>, <0.117, 0.151, -0.982>, <8.6439, -1.0203, 9.5018>, <-0.191, 0.149, -0.970> }
	smooth_triangle { <8.6439, -1.0203, 9.5018>, <-0.276, -0.084, -0.957>, <3.9918, 0.1007, 9.3175>, <0.117, 0.151, -0.982>, <3.9804, 0.0819, 9.3302>, <-0.240, -0.721, -0.650> }
	smooth_triangle { <8.6439, -1.0203, 9.5018>, <-0.276, -0.084, -0.957>, <3.9804, 0.0819, 9.3302>, <-0.240, -0.721, -0.650>, <8.6413, -1.0421, 9.5145>, <-0.451, -0.779, -0.435> }
	smooth_triangle { <8.6413, -1.0421, 9.5145>, <-0.451, -0.779, -0.435>, <3.9804, 0.0819, 9.3302>, <-0.240, -0.721, -0.650>, <3.9788, 0.0827, 9.3555>, <-0.362, -0.932, 0.004> }
	smooth_triangle { <8.6413, -1.0421, 9.5145>, <-0.451, -0.779, -0.435>, <3.9788, 0.0827, 9.3555>, <-0.362, -0.932, 0.004>, <8.6408, -1.0421, 9.5399>, <-0.322, -0.947, -0.003> }
	smooth_triangle { <10.7283, -1.8558, 7.7813>, <0.460, -0.635, 0.621>, <8.6408, -1.0421, 9.5399>, <0.051, -0.503, 0.863>, <8.6428, -1.0202, 9.5526>, <0.299, -0.062, 0.952> }
	smooth_triangle { <10.7283, -1.8558, 7.7813>, <0.278, -0.802, 0.529>, <8.6428, -1.0202, 9.5526>, <0.370, -0.377, 0.849>, <10.7436, -1.8381, 7.7913>, <0.745, -0.158, 0.648> }
	smooth_triangle { <10.7436, -1.8381, 7.7913>, <0.745, -0.158, 0.648>, <8.6428, -1.0202, 9.5526>, <0.390, 0.043, 0.920>, <8.6454, -0.9983, 9.5399>, <0.450, 0.780, 0.435> }
	smooth_triangle { <10.7436, -1.8381, 7.7913>, <0.745, -0.158, 0.648>, <8.6454, -0.9983, 9.5399>, <0.450, 0.780, 0.435>, <10.7443, -1.8148, 7.7813>, <0.633, 0.737, 0.236> }
	smooth_triangle { <10.7443, -1.8148, 7.7813>, <0.633, 0.737, 0.236>, <8.6454, -0.9983, 9.5399>, <0.450, 0.780, 0.435>, <8.6459, -0.9984, 9.5145>, <0.290, 0.872, -0.394> }
	smooth_triangle { <10.7443, -1.8148, 7.7813>, <0.633, 0.737, 0.236>, <8.6459, -0.9984, 9.5145>, <0.290, 0.872, -0.394>, <10.7297, -1.8091, 7.7613>, <-0.039, 0.946, -0.322> }
	smooth_triangle { <10.7297, -1.8091, 7.7613>, <-0.457, 0.634, -0.624>, <8.6459, -0.9984, 9.5145>, <0.025, 0.698, -0.715>, <8.6439, -1.0203, 9.5018>, <-0.300, 0.063, -0.952> }
	smooth_triangle { <10.7297, -1.8091, 7.7613>, <-0.139, 0.886, -0.443>, <8.6439, -1.0203, 9.5018>, <-0.371, 0.378, -0.848>, <10.7144, -1.8267, 7.7513>, <-0.742, 0.157, -0.651> }
	smooth_triangle { <10.7144, -1.8267, 7.7513>, <-0.742, 0.157, -0.651>, <8.6439, -1.0203, 9.5018>, <-0.391, -0.043, -0.919>, <8.6413, -1.0421, 9.5145>, <-0.451, -0.779, -0.435> }
	smooth_triangle { <10.7144, -1.8267, 7.7513>, <-0.742, 0.157, -0.651>, <8.6413, -1.0421, 9.5145>, <-0.451, -0.779, -0.435>, <10.7137, -1.8501, 7.7613>, <-0.629, -0.739, -0.240> }
	smooth_triangle { <10.7137, -1.8501, 7.7613>, <-0.629, -0.739, -0.240>, <8.6413, -1.0421, 9.5145>, <-0.451, -0.779, -0.435>, <8.6408, -1.0421, 9.5399>, <-0.322, -0.947, -0.003> }
	smooth_triangle { <10.7137, -1.8501, 7.7613>, <-0.629, -0.739, -0.240>, <8.6408, -1.0421, 9.5399>, <-0.322, -0.947, -0.003>, <10.7283, -1.8558, 7.7813>, <-0.363, -0.932, 0.000> }
	smooth_triangle { <11.8108, -2.3504, 5.1917>, <0.553, -0.746, 0.370>, <10.7283, -1.8558, 7.7813>, <0.278, -0.802, 0.529>, <10.7436, -1.8381, 7.7913>, <0.745, -0.158, 0.648> }
	smooth_triangle { <11.8108, -2.3504, 5.1917>, <0.925, 0.158, 0.345>, <10.7436, -1.8381, 7.7913>, <0.745, -0.158, 0.648>, <10.7443, -1.8148, 7.7813>, <0.633, 0.737, 0.236> }
	smooth_triangle { <11.8108, -2.3504, 5.1917>, <0.390, 0.920, -0.034>, <10.7443, -1.8148, 7.7813>, <0.633, 0.737, 0.236>, <10.7297, -1.8091, 7.7613>, <-0.039, 0.946, -0.322> }
	smooth_triangle { <11.8108, -2.3504, 5.1917>, <-0.543, 0.744, -0.389>, <10.7297, -1.8091, 7.7613>, <-0.139, 0.886, -0.443>, <10.7144, -1.8267, 7.7513>, <-0.742, 0.157, -0.651> }
	smooth_triangle { <11.8108, -2.3504, 5.1917>, <-0.917, -0.164, -0.363>, <10.7144, -1.8267, 7.7513>, <-0.742, 0.157, -0.651>, <10.7137, -1.8501, 7.7613>, <-0.629, -0.739, -0.240> }
	smooth_triangle { <11.8108, -2.3504, 5.1917>, <-0.377, -0.926, 0.015>, <10.7137, -1.8501, 7.7613>, <-0.629, -0.739, -0.240>, <10.7283, -1.8558, 7.7813>, <0.198, -0.887, 0.416> }
	smooth_triangle { <4.0863, -0.9757, 10.5568>, <-0.567, 0.584, 0.581>, <3.9673, 0.1085, 9.3514>, <-0.559, 0.528, 0.639>, <3.9882, 0.1203, 9.3599>, <-0.262, 0.639, 0.723> }
	smooth_triangle { <4.0863, -0.9757, 10.5568>, <-0.567, 0.584, 0.581>, <3.9882, 0.1203, 9.3599>, <-0.262, 0.639, 0.723>, <4.1072, -0.9639, 10.5653>, <0.108, 0.744, 0.659> }
	smooth_triangle { <4.1072, -0.9639, 10.5653>, <0.108, 0.744, 0.659>, <3.9882, 0.1203, 9.3599>, <-0.262, 0.639, 0.723>, <4.0111, 0.1133, 9.3514>, <0.702, 0.525, 0.481> }
	smooth_triangle { <4.1072, -0.9639, 10.5653>, <0.108, 0.744, 0.659>, <4.0111, 0.1133, 9.3514>, <0.702, 0.525, 0.481>, <4.1300, -0.9709, 10.5568>, <0.913, 0.344, 0.220> }
	smooth_triangle { <4.1300, -0.9709, 10.5568>, <0.913, 0.344, 0.220>, <4.0111, 0.1133, 9.3514>, <0.702, 0.525, 0.481>, <4.0131, 0.0946, 9.3344>, <0.964, -0.114, -0.242> }
	smooth_triangle { <4.1300, -0.9709, 10.5568>, <0.913, 0.344, 0.220>, <4.0131, 0.0946, 9.3344>, <0.964, -0.114, -0.242>, <4.1321, -0.9896, 10.5397>, <0.804, -0.400, -0.439> }
	smooth_triangle { <4.1321, -0.9896, 10.5397>, <0.804, -0.400, -0.439>, <4.0131, 0.0946, 9.3344>, <0.964, -0.114, -0.242>, <3.9923, 0.0828, 9.3258>, <0.262, -0.639, -0.723> }
	smooth_triangle { <4.1321, -0.9896, 10.5397>, <0.804, -0.400, -0.439>, <3.9923, 0.0828, 9.3258>, <0.262, -0.639, -0.723>, <4.1113, -1.0013, 10.5312>, <-0.108, -0.744, -0.659> }
	smooth_triangle { <4.1113, -1.0013, 10.5312>, <-0.108, -0.744, -0.659>, <3.9923, 0.0828, 9.3258>, <0.262, -0.639, -0.723>, <3.9694, 0.0898, 9.3344>, <-0.702, -0.525, -0.481> }
	smooth_triangle { <4.1113, -1.0013, 10.5312>, <-0.108, -0.744, -0.659>, <3.9694, 0.0898, 9.3344>, <-0.702, -0.525, -0.481>, <4.0884, -0.9944, 10.5397>, <-0.913, -0.344, -0.220> }
	smooth_triangle { <4.0884, -0.9944, 10.5397>, <-0.913, -0.344, -0.220>, <3.9694, 0.0898, 9.3344>, <-0.702, -0.525, -0.481>, <3.9673, 0.1085, 9.3514>, <-0.994, -0.113, 0.001> }
	smooth_triangle { <4.0884, -0.9944, 10.5397>, <-0.913, -0.344, -0.220>, <3.9673, 0.1085, 9.3514>, <-0.994, -0.113, 0.001>, <4.0863, -0.9757, 10.5568>, <-0.994, -0.109, 0.000> }
	smooth_triangle { <4.4230, -3.7117, 12.2874>, <-0.557, 0.598, 0.576>, <3.9673, 0.1085, 9.3514>, <-0.559, 0.528, 0.639>, <3.9882, 0.1203, 9.3599>, <-0.262, 0.639, 0.723> }
	smooth_triangle { <4.4230, -3.7117, 12.2874>, <-0.557, 0.598, 0.576>, <3.9882, 0.1203, 9.3599>, <-0.262, 0.639, 0.723>, <4.4440, -3.7023, 12.2982>, <0.047, 0.676, 0.736> }
	smooth_triangle { <4.4440, -3.7023, 12.2982>, <0.047, 0.676, 0.736>, <3.9882, 0.1203, 9.3599>, <-0.262, 0.639, 0.723>, <4.0111, 0.1133, 9.3514>, <0.702, 0.525, 0.481> }
	smooth_triangle { <4.4440, -3.7023, 12.2982>, <0.047, 0.676, 0.736>, <4.0111, 0.1133, 9.3514>, <0.702, 0.525, 0.481>, <4.4667, -3.7063, 12.2874>, <0.820, 0.280, 0.500> }
	smooth_triangle { <4.4667, -3.7063, 12.2874>, <0.858, 0.151, 0.492>, <4.0111, 0.1133, 9.3514>, <0.702, 0.525, 0.481>, <4.0131, 0.0946, 9.3344>, <0.964, -0.114, -0.242> }
	smooth_triangle { <4.4667, -3.7063, 12.2874>, <0.858, 0.151, 0.492>, <4.0131, 0.0946, 9.3344>, <0.964, -0.114, -0.242>, <4.4683, -3.7197, 12.2659>, <0.804, -0.535, -0.259> }
	smooth_triangle { <4.4683, -3.7197, 12.2659>, <0.804, -0.535, -0.259>, <4.0131, 0.0946, 9.3344>, <0.964, -0.114, -0.242>, <3.9923, 0.0828, 9.3258>, <0.262, -0.639, -0.723> }
	smooth_triangle { <4.4683, -3.7197, 12.2659>, <0.804, -0.535, -0.259>, <3.9923, 0.0828, 9.3258>, <0.262, -0.639, -0.723>, <4.4473, -3.7291, 12.2552>, <-0.047, -0.675, -0.737> }
	smooth_triangle { <4.4473, -3.7291, 12.2552>, <-0.047, -0.675, -0.737>, <3.9923, 0.0828, 9.3258>, <0.262, -0.639, -0.723>, <3.9694, 0.0898, 9.3344>, <-0.702, -0.525, -0.481> }
	smooth_triangle { <4.4473, -3.7291, 12.2552>, <-0.047, -0.675, -0.737>, <3.9694, 0.0898, 9.3344>, <-0.702, -0.525, -0.481>, <4.4246, -3.7251, 12.2659>, <-0.820, -0.280, -0.500> }
	smooth_triangle { <4.4246, -3.7251, 12.2659>, <-0.857, -0.150, -0.492>, <3.9694, 0.0898, 9.3344>, <-0.702, -0.525, -0.481>, <3.9673, 0.1085, 9.3514>, <-0.994, -0.113, 0.001> }
	smooth_triangle { <4.4246, -3.7251, 12.2659>, <-0.857, -0.150, -0.492>, <3.9673, 0.1085, 9.3514>, <-0.994, -0.113, 0.001>, <4.4230, -3.7117, 12.2874>, <-0.918, 0.375, -0.126> }
	smooth_triangle { <2.8346, -5.3283, 13.9789>, <-0.318, 0.838, 0.443>, <4.4230, -3.7117, 12.2874>, <-0.557, 0.598, 0.576>, <4.4440, -3.7023, 12.2982>, <-0.046, 0.717, 0.696> }
	smooth_triangle { <2.8346, -5.3283, 13.9789>, <-0.318, 0.838, 0.443>, <4.4440, -3.7023, 12.2982>, <0.047, 0.676, 0.736>, <2.8556, -5.3383, 13.9891>, <0.489, 0.487, 0.724> }
	smooth_triangle { <2.8556, -5.3383, 13.9891>, <0.489, 0.487, 0.724>, <4.4440, -3.7023, 12.2982>, <0.166, 0.600, 0.782>, <4.4667, -3.7063, 12.2874>, <0.858, 0.151, 0.492> }
	smooth_triangle { <2.8556, -5.3383, 13.9891>, <0.489, 0.487, 0.724>, <4.4667, -3.7063, 12.2874>, <0.858, 0.151, 0.492>, <2.8660, -5.3591, 13.9789>, <0.874, -0.357, 0.330> }
	smooth_triangle { <2.8660, -5.3591, 13.9789>, <0.874, -0.357, 0.330>, <4.4667, -3.7063, 12.2874>, <0.907, 0.044, 0.419>, <4.4683, -3.7197, 12.2659>, <0.804, -0.535, -0.259> }
	smooth_triangle { <2.8660, -5.3591, 13.9789>, <0.874, -0.357, 0.330>, <4.4683, -3.7197, 12.2659>, <0.804, -0.535, -0.259>, <2.8554, -5.3699, 13.9585>, <0.415, -0.838, -0.354> }
	smooth_triangle { <2.8554, -5.3699, 13.9585>, <0.415, -0.838, -0.354>, <4.4683, -3.7197, 12.2659>, <0.804, -0.535, -0.259>, <4.4473, -3.7291, 12.2552>, <0.046, -0.716, -0.696> }
	smooth_triangle { <2.8554, -5.3699, 13.9585>, <0.415, -0.838, -0.354>, <4.4473, -3.7291, 12.2552>, <-0.047, -0.675, -0.737>, <2.8344, -5.3599, 13.9483>, <-0.492, -0.490, -0.719> }
	smooth_triangle { <2.8344, -5.3599, 13.9483>, <-0.492, -0.490, -0.719>, <4.4473, -3.7291, 12.2552>, <-0.167, -0.600, -0.783>, <4.4246, -3.7251, 12.2659>, <-0.857, -0.150, -0.492> }
	smooth_triangle { <2.8344, -5.3599, 13.9483>, <-0.492, -0.490, -0.719>, <4.4246, -3.7251, 12.2659>, <-0.857, -0.150, -0.492>, <2.8240, -5.3391, 13.9585>, <-0.876, 0.355, -0.326> }
	smooth_triangle { <2.8240, -5.3391, 13.9585>, <-0.876, 0.355, -0.326>, <4.4246, -3.7251, 12.2659>, <-0.907, -0.043, -0.420>, <4.4230, -3.7117, 12.2874>, <-0.918, 0.375, -0.126> }
	smooth_triangle { <2.8240, -5.3391, 13.9585>, <-0.876, 0.355, -0.326>, <4.4230, -3.7117, 12.2874>, <-0.918, 0.375, -0.126>, <2.8346, -5.3283, 13.9789>, <-0.714, 0.701, -0.001> }
	smooth_triangle { <1.8867, -6.6703, 16.2987>, <0.114, 0.837, 0.535>, <2.8346, -5.3283, 13.9789>, <-0.318, 0.838, 0.443>, <2.8556, -5.3383, 13.9891>, <0.489, 0.487, 0.724> }
	smooth_triangle { <1.8867, -6.6703, 16.2987>, <0.861, 0.186, 0.473>, <2.8556, -5.3383, 13.9891>, <0.489, 0.487, 0.724>, <2.8660, -5.3591, 13.9789>, <0.874, -0.357, 0.330> }
	smooth_triangle { <1.8867, -6.6703, 16.2987>, <0.751, -0.659, -0.051>, <2.8660, -5.3591, 13.9789>, <0.874, -0.357, 0.330>, <2.8554, -5.3699, 13.9585>, <0.415, -0.838, -0.354> }
	smooth_triangle { <1.8867, -6.6703, 16.2987>, <-0.124, -0.847, -0.517>, <2.8554, -5.3699, 13.9585>, <0.415, -0.838, -0.354>, <2.8344, -5.3599, 13.9483>, <-0.492, -0.490, -0.719> }
	smooth_triangle { <1.8867, -6.6703, 16.2987>, <-0.868, -0.198, -0.456>, <2.8344, -5.3599, 13.9483>, <-0.492, -0.490, -0.719>, <2.8240, -5.3391, 13.9585>, <-0.876, 0.355, -0.326> }
	smooth_triangle { <1.8867, -6.6703, 16.2987>, <-0.760, 0.646, 0.068>, <2.8240, -5.3391, 13.9585>, <-0.876, 0.355, -0.326>, <2.8346, -5.3283, 13.9789>, <-0.318, 0.838, 0.443> }

	texture { PSWL_BARK }
}

/* Object 'PWL0021F' */
union {
	smooth_triangle { <2.9765, 0.4267, 8.1130>, <0.737, 0.331, -0.589>, <2.9086, 0.0319, 7.7522>, <0.826, 0.296, -0.479>, <3.0819, -0.4645, 7.7444>, <0.737, 0.331, -0.589> }
	smooth_triangle { <3.0819, -0.4645, 7.7444>, <0.737, 0.331, -0.589>, <3.2027, -0.0773, 8.0581>, <0.633, 0.359, -0.686>, <2.9765, 0.4267, 8.1130>, <0.737, 0.331, -0.589> }
	smooth_triangle { <4.0299, 0.1383, 9.3209>, <-0.391, 0.746, 0.539>, <4.2364, 0.4774, 8.9625>, <-0.449, 0.764, 0.464>, <4.6808, 0.7401, 8.9599>, <-0.391, 0.746, 0.539> }
	smooth_triangle { <4.6808, 0.7401, 8.9599>, <-0.391, 0.746, 0.539>, <4.5001, 0.3795, 9.2897>, <-0.330, 0.722, 0.608>, <4.0299, 0.1383, 9.3209>, <-0.391, 0.746, 0.539> }
	smooth_triangle { <4.7653, -0.4409, 10.6659>, <0.695, -0.423, -0.581>, <4.4439, -0.7472, 10.5046>, <0.695, -0.423, -0.582>, <4.3103, -1.1842, 10.6628>, <0.695, -0.423, -0.581> }
	smooth_triangle { <4.3103, -1.1842, 10.6628>, <0.695, -0.423, -0.581>, <4.6381, -0.8674, 10.8242>, <0.695, -0.423, -0.581>, <4.7653, -0.4409, 10.6659>, <0.695, -0.423, -0.581> }
	smooth_triangle { <5.6347, -0.8570, 11.9792>, <-0.438, 0.655, 0.616>, <5.8443, -0.5094, 11.7413>, <-0.466, 0.674, 0.574>, <6.2656, -0.2793, 11.8133>, <-0.438, 0.655, 0.616> }
	smooth_triangle { <6.2656, -0.2793, 11.8133>, <-0.438, 0.655, 0.616>, <6.0628, -0.6447, 12.0404>, <-0.409, 0.635, 0.656>, <5.6347, -0.8570, 11.9792>, <-0.438, 0.655, 0.616> }
	smooth_triangle { <6.3146, -1.2508, 12.6141>, <0.604, -0.167, -0.779>, <5.9411, -1.6974, 12.4203>, <0.604, -0.167, -0.780>, <5.9302, -2.3131, 12.5433>, <0.604, -0.167, -0.779> }
	smooth_triangle { <5.9302, -2.3131, 12.5433>, <0.604, -0.167, -0.779>, <6.3090, -1.8515, 12.7383>, <0.604, -0.167, -0.779>, <6.3146, -1.2508, 12.6141>, <0.604, -0.167, -0.779> }
	smooth_triangle { <7.1056, -1.4841, 13.2153>, <-0.167, 0.847, 0.504>, <7.2941, -1.1139, 12.7353>, <-0.060, 0.802, 0.595>, <7.9256, -0.9163, 12.5323>, <-0.167, 0.847, 0.504> }
	smooth_triangle { <7.9256, -0.9163, 12.5323>, <-0.167, 0.847, 0.504>, <7.6588, -1.2666, 13.1139>, <-0.270, 0.875, 0.403>, <7.1056, -1.4841, 13.2153>, <-0.167, 0.847, 0.504> }
	smooth_triangle { <7.5413, -1.7948, 14.0878>, <0.877, 0.294, -0.379>, <7.4360, -2.1835, 13.6518>, <0.778, 0.364, -0.513>, <7.6173, -2.7258, 13.5415>, <0.877, 0.294, -0.379> }
	smooth_triangle { <7.6173, -2.7258, 13.5415>, <0.877, 0.294, -0.379>, <7.6524, -2.2951, 14.0805>, <0.949, 0.214, -0.233>, <7.5413, -1.7948, 14.0878>, <0.877, 0.294, -0.379> }
	smooth_triangle { <8.0425, -1.9690, 14.9506>, <-0.164, 0.917, 0.362>, <8.3145, -1.6526, 14.3479>, <-0.093, 0.898, 0.430>, <8.9284, -1.4925, 14.1455>, <-0.164, 0.917, 0.362> }
	smooth_triangle { <8.9284, -1.4925, 14.1455>, <-0.164, 0.917, 0.362>, <8.5911, -1.7934, 14.8323>, <-0.234, 0.928, 0.292>, <8.0425, -1.9690, 14.9506>, <-0.164, 0.917, 0.362> }
	smooth_triangle { <4.2018, 0.2855, 10.1077>, <0.133, 0.965, -0.225>, <4.6457, 0.1473, 9.8097>, <0.127, 0.958, -0.256>, <5.1905, 0.1119, 9.9468>, <0.133, 0.965, -0.225> }
	smooth_triangle { <5.1905, 0.1119, 9.9468>, <0.133, 0.965, -0.225>, <4.7222, 0.2398, 10.2524>, <0.139, 0.971, -0.193>, <4.2018, 0.2855, 10.1077>, <0.133, 0.965, -0.225> }
	smooth_triangle { <4.2767, 0.5295, 10.8857>, <-0.749, -0.558, 0.358>, <3.7932, 0.9724, 10.5522>, <-0.752, -0.561, 0.345>, <3.4366, 1.5982, 10.7924>, <-0.749, -0.558, 0.358> }
	smooth_triangle { <3.4366, 1.5982, 10.7924>, <-0.749, -0.558, 0.358>, <3.9372, 1.1464, 11.1246>, <-0.746, -0.554, 0.370>, <4.2767, 0.5295, 10.8857>, <-0.749, -0.558, 0.358> }
	smooth_triangle { <4.4502, 1.2431, 12.3229>, <-0.621, 0.755, -0.211>, <4.8748, 1.4784, 11.8880>, <-0.618, 0.762, -0.191>, <5.3312, 1.8646, 11.9514>, <-0.621, 0.755, -0.211> }
	smooth_triangle { <5.3312, 1.8646, 11.9514>, <-0.621, 0.755, -0.211>, <4.8962, 1.6347, 12.3841>, <-0.624, 0.747, -0.231>, <4.4502, 1.2431, 12.3229>, <-0.621, 0.755, -0.211> }
	smooth_triangle { <4.4724, 1.9764, 13.7755>, <-0.732, -0.566, 0.379>, <4.1096, 2.2107, 13.4196>, <-0.733, -0.570, 0.372>, <3.7680, 2.6831, 13.4700>, <-0.732, -0.566, 0.379> }
	smooth_triangle { <3.7680, 2.6831, 13.4700>, <-0.732, -0.566, 0.379>, <4.1413, 2.4428, 13.8282>, <-0.732, -0.563, 0.385>, <4.4724, 1.9764, 13.7755>, <-0.732, -0.566, 0.379> }
	smooth_triangle { <4.3525, 2.3629, 15.1414>, <-0.895, 0.404, -0.190>, <4.5768, 2.6787, 14.8744>, <-0.879, 0.373, -0.297>, <4.7402, 3.1448, 14.9766>, <-0.895, 0.404, -0.190> }
	smooth_triangle { <4.7402, 3.1448, 14.9766>, <-0.895, 0.404, -0.190>, <4.5345, 2.7675, 15.2630>, <-0.900, 0.429, -0.081>, <4.3525, 2.3629, 15.1414>, <-0.895, 0.404, -0.190> }
	smooth_triangle { <4.1006, 2.6714, 16.5105>, <0.357, -0.891, 0.280>, <3.5659, 2.3700, 16.2300>, <0.357, -0.892, 0.277>, <2.9480, 2.2026, 16.4881>, <0.357, -0.891, 0.280> }
	smooth_triangle { <2.9480, 2.2026, 16.4881>, <0.357, -0.891, 0.280>, <3.4981, 2.5121, 16.7684>, <0.357, -0.890, 0.283>, <4.1006, 2.6714, 16.5105>, <0.357, -0.891, 0.280> }
	smooth_triangle { <4.2910, 3.0111, 17.6808>, <0.175, 0.943, -0.284>, <4.8007, 2.8364, 17.4346>, <0.174, 0.936, -0.305>, <5.3647, 2.8044, 17.6576>, <0.175, 0.943, -0.284> }
	smooth_triangle { <5.3647, 2.8044, 17.6576>, <0.175, 0.943, -0.284>, <4.8372, 2.9719, 17.9071>, <0.177, 0.949, -0.263>, <4.2910, 3.0111, 17.6808>, <0.175, 0.943, -0.284> }
	smooth_triangle { <4.3113, 3.4001, 18.8397>, <-0.929, -0.228, 0.293>, <4.1048, 3.8071, 18.4670>, <-0.936, -0.239, 0.257>, <3.9600, 4.4768, 18.5630>, <-0.929, -0.228, 0.293> }
	smooth_triangle { <3.9600, 4.4768, 18.5630>, <-0.929, -0.228, 0.293>, <4.1810, 4.0902, 18.9288>, <-0.920, -0.216, 0.328>, <4.3113, 3.4001, 18.8397>, <-0.929, -0.228, 0.293> }
	smooth_triangle { <3.5531, 3.3760, 19.7953>, <-0.696, -0.488, -0.527>, <3.4821, 3.8770, 19.4198>, <-0.703, -0.488, -0.518>, <3.0999, 4.3836, 19.4615>, <-0.696, -0.488, -0.527> }
	smooth_triangle { <3.0999, 4.3836, 19.4615>, <-0.696, -0.488, -0.527>, <3.1720, 3.8682, 19.8376>, <-0.689, -0.488, -0.536>, <3.5531, 3.3760, 19.7953>, <-0.696, -0.488, -0.527> }
	smooth_triangle { <2.8030, 3.2601, 20.7541>, <0.669, -0.437, 0.602>, <2.7723, 2.8765, 20.4714>, <0.742, -0.435, 0.510>, <2.5123, 2.4755, 20.5080>, <0.669, -0.437, 0.602> }
	smooth_triangle { <2.5123, 2.4755, 20.5080>, <0.669, -0.437, 0.602>, <2.5056, 2.8689, 20.7616>, <0.586, -0.432, 0.686>, <2.8030, 3.2601, 20.7541>, <0.669, -0.437, 0.602> }
	smooth_triangle { <2.0335, 3.4706, 21.6873>, <-0.822, -0.276, -0.499>, <2.0910, 4.1051, 21.2454>, <-0.819, -0.276, -0.503>, <1.8005, 4.8079, 21.3322>, <-0.822, -0.276, -0.499> }
	smooth_triangle { <1.8005, 4.8079, 21.3322>, <-0.822, -0.276, -0.499>, <1.7491, 4.1542, 21.7814>, <-0.825, -0.275, -0.495>, <2.0335, 3.4706, 21.6873>, <-0.822, -0.276, -0.499> }
	smooth_triangle { <1.2286, 3.5008, 22.6067>, <0.399, -0.813, 0.424>, <1.1027, 3.1999, 22.2528>, <0.264, -0.779, 0.569>, <0.5916, 2.9451, 22.1410>, <0.399, -0.813, 0.424> }
	smooth_triangle { <0.5916, 2.9451, 22.1410>, <0.399, -0.813, 0.424>, <0.8276, 3.2394, 22.5876>, <0.518, -0.814, 0.262>, <1.2286, 3.5008, 22.6067>, <0.399, -0.813, 0.424> }
	smooth_triangle { <0.5121, 3.8900, 23.5324>, <-0.658, -0.652, -0.377>, <0.3742, 4.3218, 22.9597>, <-0.703, -0.639, -0.312>, <-0.1371, 4.9313, 22.8650>, <-0.658, -0.652, -0.377> }
	smooth_triangle { <-0.1371, 4.9313, 22.8650>, <-0.658, -0.652, -0.377>, <-0.0466, 4.4929, 23.3988>, <-0.608, -0.661, -0.440>, <0.5121, 3.8900, 23.5324>, <-0.658, -0.652, -0.377> }
	smooth_triangle { <-0.2275, 4.1434, 24.4551>, <0.111, -0.807, 0.579>, <-0.4076, 3.8393, 24.0455>, <0.147, -0.824, 0.547>, <-0.9418, 3.6584, 23.9163>, <0.111, -0.807, 0.579> }
	smooth_triangle { <-0.9418, 3.6584, 23.9163>, <0.111, -0.807, 0.579>, <-0.7848, 3.9741, 24.3052>, <0.076, -0.789, 0.610>, <-0.2275, 4.1434, 24.4551>, <0.111, -0.807, 0.579> }
	smooth_triangle { <4.6796, -0.3310, 9.3754>, <0.417, 0.321, -0.850>, <4.1362, -0.7220, 8.9613>, <0.416, 0.322, -0.850>, <4.1315, -1.4293, 8.6914>, <0.417, 0.321, -0.850> }
	smooth_triangle { <4.1315, -1.4293, 8.6914>, <0.417, 0.321, -0.850>, <4.6827, -1.0228, 9.1159>, <0.418, 0.321, -0.850>, <4.6796, -0.3310, 9.3754>, <0.417, 0.321, -0.850> }
	smooth_triangle { <5.4361, -0.6367, 9.4422>, <0.135, 0.304, 0.943>, <5.4705, -0.1792, 9.2703>, <0.055, 0.348, 0.936>, <5.8631, 0.0948, 9.1456>, <0.135, 0.304, 0.943> }
	smooth_triangle { <5.8631, 0.0948, 9.1456>, <0.135, 0.304, 0.943>, <5.8251, -0.3744, 9.2823>, <0.214, 0.257, 0.942>, <5.4361, -0.6367, 9.4422>, <0.135, 0.304, 0.943> }
	smooth_triangle { <7.0243, -0.8845, 9.4527>, <0.154, 0.752, -0.641>, <6.6737, -1.2990, 8.8026>, <0.308, 0.718, -0.624>, <6.9513, -1.7925, 8.3713>, <0.154, 0.752, -0.641> }
	smooth_triangle { <6.9513, -1.7925, 8.3713>, <0.154, 0.752, -0.641>, <7.3061, -1.3655, 8.8776>, <-0.004, 0.766, -0.643>, <7.0243, -0.8845, 9.4527>, <0.154, 0.752, -0.641> }
	smooth_triangle { <8.6479, -0.9853, 9.4871>, <0.159, 0.735, 0.659>, <8.4128, -0.5425, 9.1021>, <0.273, 0.710, 0.649>, <8.7559, -0.1486, 8.5271>, <0.159, 0.735, 0.659> }
	smooth_triangle { <8.7559, -0.1486, 8.5271>, <0.159, 0.735, 0.659>, <8.9873, -0.6029, 9.0299>, <0.042, 0.751, 0.659>, <8.6479, -0.9853, 9.4871>, <0.159, 0.735, 0.659> }
	smooth_triangle { <9.6526, -1.4597, 8.6247>, <-0.347, 0.757, -0.553>, <9.2226, -1.6865, 8.5543>, <-0.291, 0.740, -0.607>, <9.0734, -2.0339, 8.2024>, <-0.347, 0.757, -0.553> }
	smooth_triangle { <9.0734, -2.0339, 8.2024>, <-0.347, 0.757, -0.553>, <9.4877, -1.7897, 8.2462>, <-0.401, 0.770, -0.496>, <9.6526, -1.4597, 8.6247>, <-0.347, 0.757, -0.553> }
	smooth_triangle { <10.7466, -1.7821, 7.7690>, <0.596, -0.173, 0.784>, <10.7458, -1.2773, 7.8831>, <0.602, -0.175, 0.779>, <11.0623, -0.8817, 7.7273>, <0.596, -0.173, 0.784> }
	smooth_triangle { <11.0623, -0.8817, 7.7273>, <0.596, -0.173, 0.784>, <11.0608, -1.4000, 7.6167>, <0.590, -0.170, 0.790>, <10.7466, -1.7821, 7.7690>, <0.596, -0.173, 0.784> }
	smooth_triangle { <11.2393, -2.1312, 6.4635>, <-0.579, 0.661, -0.478>, <10.8166, -2.4764, 6.4734>, <-0.548, 0.656, -0.520>, <10.6172, -2.9399, 6.0987>, <-0.579, 0.661, -0.478> }
	smooth_triangle { <10.6172, -2.9399, 6.0987>, <-0.579, 0.661, -0.478>, <11.0325, -2.5770, 6.0718>, <-0.608, 0.664, -0.435>, <11.2393, -2.1312, 6.4635>, <-0.579, 0.661, -0.478> }
	smooth_triangle { <11.8249, -2.2994, 5.1848>, <0.886, -0.187, 0.424>, <11.8655, -1.8011, 5.3182>, <0.885, -0.187, 0.427>, <12.0810, -1.3714, 5.0598>, <0.886, -0.187, 0.424> }
	smooth_triangle { <12.0810, -1.3714, 5.0598>, <0.886, -0.187, 0.424>, <12.0357, -1.8823, 4.9266>, <0.888, -0.188, 0.420>, <11.8249, -2.2994, 5.1848>, <0.886, -0.187, 0.424> }
	smooth_triangle { <4.0028, -0.4615, 9.9314>, <0.463, -0.588, -0.663>, <3.5878, -0.4909, 9.6666>, <0.464, -0.590, -0.661>, <3.1941, -0.8226, 9.6864>, <0.463, -0.588, -0.663> }
	smooth_triangle { <3.1941, -0.8226, 9.6864>, <0.463, -0.588, -0.663>, <3.6205, -0.7889, 9.9539>, <0.463, -0.586, -0.664>, <4.0028, -0.4615, 9.9314>, <0.463, -0.588, -0.663> }
	smooth_triangle { <4.1506, -1.0055, 10.5236>, <0.626, 0.619, 0.474>, <4.6691, -1.1381, 9.9266>, <0.610, 0.698, 0.375>, <5.2391, -1.6083, 9.8740>, <0.626, 0.619, 0.474> }
	smooth_triangle { <5.2391, -1.6083, 9.8740>, <0.626, 0.619, 0.474>, <4.7143, -1.5498, 10.4050>, <0.631, 0.531, 0.566>, <4.1506, -1.0055, 10.5236>, <0.626, 0.619, 0.474> }
	smooth_triangle { <4.2468, -2.3751, 11.3774>, <0.797, -0.148, -0.586>, <3.8714, -2.4396, 10.8284>, <0.813, -0.246, -0.527>, <3.5427, -2.9725, 10.5698>, <0.797, -0.148, -0.586> }
	smooth_triangle { <3.5427, -2.9725, 10.5698>, <0.797, -0.148, -0.586>, <3.9347, -2.9539, 11.0429>, <0.770, -0.048, -0.636>, <4.2468, -2.3751, 11.3774>, <0.797, -0.148, -0.586> }
	smooth_triangle { <4.4986, -3.7098, 12.2757>, <-0.044, 0.532, 0.845>, <4.9399, -3.4786, 12.1544>, <-0.044, 0.528, 0.848>, <5.4386, -3.6048, 12.2587>, <-0.044, 0.532, 0.845> }
	smooth_triangle { <5.4386, -3.6048, 12.2587>, <-0.044, 0.532, 0.845>, <4.9840, -3.8364, 12.3821>, <-0.045, 0.537, 0.843>, <4.4986, -3.7098, 12.2757>, <-0.044, 0.532, 0.845> }
	smooth_triangle { <3.6029, -4.5227, 13.0919>, <0.283, -0.730, -0.622>, <3.2782, -4.1994, 12.5910>, <0.312, -0.693, -0.650>, <2.5400, -4.2794, 12.3213>, <0.283, -0.730, -0.622> }
	smooth_triangle { <2.5400, -4.2794, 12.3213>, <0.283, -0.730, -0.622>, <2.8997, -4.5856, 12.8718>, <0.254, -0.765, -0.591>, <3.6029, -4.5227, 13.0919>, <0.283, -0.730, -0.622> }
	smooth_triangle { <2.8747, -5.3915, 13.9558>, <0.571, 0.155, 0.806>, <3.4284, -5.7271, 13.6477>, <0.538, 0.123, 0.834>, <3.6202, -6.4577, 13.6317>, <0.571, 0.155, 0.806> }
	smooth_triangle { <3.6202, -6.4577, 13.6317>, <0.571, 0.155, 0.806>, <3.0701, -6.0927, 13.9718>, <0.603, 0.186, 0.776>, <2.8747, -5.3915, 13.9558>, <0.571, 0.155, 0.806> }
	smooth_triangle { <2.3234, -5.9792, 15.1230>, <-0.345, -0.700, -0.626>, <2.0383, -5.6170, 14.8738>, <-0.348, -0.702, -0.622>, <1.5909, -5.4525, 14.9384>, <-0.345, -0.700, -0.626> }
	smooth_triangle { <1.5909, -5.4525, 14.9384>, <-0.345, -0.700, -0.626>, <1.8855, -5.8230, 15.1886>, <-0.343, -0.698, -0.629>, <2.3234, -5.9792, 15.1230>, <-0.345, -0.700, -0.626> }
	smooth_triangle { <1.8997, -6.7132, 16.2697>, <0.914, 0.004, 0.405>, <2.1521, -7.1398, 15.5990>, <0.949, 0.083, 0.304>, <2.2400, -7.8306, 15.5128>, <0.914, 0.004, 0.405> }
	smooth_triangle { <2.2400, -7.8306, 15.5128>, <0.914, 0.004, 0.405>, <1.9347, -7.4373, 16.1012>, <0.864, -0.074, 0.498>, <1.8997, -6.7132, 16.2697>, <0.914, 0.004, 0.405> }

	texture { PSWL_FOLG }
}

/* Object 'PWL0022B' */
union {
	smooth_triangle { <0.1718, 0.1538, 7.0971>, <-0.213, 0.841, 0.497>, <0.5892, 1.2428, 5.4331>, <-0.212, 0.843, 0.495>, <0.6596, 1.2481, 5.4542>, <0.127, 0.812, 0.570> }
	smooth_triangle { <0.1718, 0.1538, 7.0971>, <-0.213, 0.841, 0.497>, <0.6596, 1.2481, 5.4542>, <0.127, 0.812, 0.570>, <0.2422, 0.1591, 7.1182>, <0.464, 0.683, 0.564> }
	smooth_triangle { <0.2422, 0.1591, 7.1182>, <0.464, 0.683, 0.564>, <0.6596, 1.2481, 5.4542>, <0.127, 0.812, 0.570>, <0.7083, 1.1971, 5.4331>, <0.899, 0.203, 0.388> }
	smooth_triangle { <0.2422, 0.1591, 7.1182>, <0.464, 0.683, 0.564>, <0.7083, 1.1971, 5.4331>, <0.899, 0.203, 0.388>, <0.2909, 0.1082, 7.0971>, <0.978, -0.088, 0.188> }
	smooth_triangle { <0.2909, 0.1082, 7.0971>, <0.978, -0.088, 0.188>, <0.7083, 1.1971, 5.4331>, <0.899, 0.203, 0.388>, <0.6867, 1.1408, 5.3908>, <0.771, -0.611, -0.179> }
	smooth_triangle { <0.2909, 0.1082, 7.0971>, <0.978, -0.088, 0.188>, <0.6867, 1.1408, 5.3908>, <0.771, -0.611, -0.179>, <0.2693, 0.0519, 7.0548>, <0.514, -0.771, -0.376> }
	smooth_triangle { <0.2693, 0.0519, 7.0548>, <0.514, -0.771, -0.376>, <0.6867, 1.1408, 5.3908>, <0.771, -0.611, -0.179>, <0.6164, 1.1355, 5.3697>, <-0.129, -0.817, -0.563> }
	smooth_triangle { <0.2693, 0.0519, 7.0548>, <0.514, -0.771, -0.376>, <0.6164, 1.1355, 5.3697>, <-0.129, -0.817, -0.563>, <0.1990, 0.0465, 7.0337>, <-0.464, -0.683, -0.564> }
	smooth_triangle { <0.1990, 0.0465, 7.0337>, <-0.464, -0.683, -0.564>, <0.6164, 1.1355, 5.3697>, <-0.129, -0.817, -0.563>, <0.5677, 1.1865, 5.3908>, <-0.901, -0.208, -0.380> }
	smooth_triangle { <0.1990, 0.0465, 7.0337>, <-0.464, -0.683, -0.564>, <0.5677, 1.1865, 5.3908>, <-0.901, -0.208, -0.380>, <0.1503, 0.0975, 7.0548>, <-0.978, 0.088, -0.188> }
	smooth_triangle { <0.1503, 0.0975, 7.0548>, <-0.978, 0.088, -0.188>, <0.5677, 1.1865, 5.3908>, <-0.901, -0.208, -0.380>, <0.5892, 1.2428, 5.4331>, <-0.923, 0.385, 0.000> }
	smooth_triangle { <0.1503, 0.0975, 7.0548>, <-0.978, 0.088, -0.188>, <0.5892, 1.2428, 5.4331>, <-0.923, 0.385, 0.000>, <0.1718, 0.1538, 7.0971>, <-0.934, 0.358, 0.000> }
	smooth_triangle { <-0.6823, -1.5721, 9.7123>, <-0.143, 0.862, 0.486>, <0.5892, 1.2428, 5.4331>, <-0.212, 0.843, 0.495>, <0.6596, 1.2481, 5.4542>, <0.127, 0.812, 0.570> }
	smooth_triangle { <-0.6823, -1.5721, 9.7123>, <-0.143, 0.862, 0.486>, <0.6596, 1.2481, 5.4542>, <0.127, 0.812, 0.570>, <-0.6581, -1.5732, 9.7198>, <0.320, 0.785, 0.530> }
	smooth_triangle { <-0.6581, -1.5732, 9.7198>, <0.476, 0.713, 0.515>, <0.6596, 1.2481, 5.4542>, <0.127, 0.812, 0.570>, <0.7083, 1.1971, 5.4331>, <0.899, 0.203, 0.388> }
	smooth_triangle { <-0.6581, -1.5732, 9.7198>, <0.476, 0.713, 0.515>, <0.7083, 1.1971, 5.4331>, <0.899, 0.203, 0.388>, <-