#version unofficial Megapov 0.7

////////////////////////////////////////////////////////
// Tree
////////////////////////////////////////////////////////

// Include the leaf definition and splinetree files
#include "leafdefs4.inc"
#include "splinetree.inc"

#declare recursionmax = 6; // Defines the complexity of the tree
#declare divisions = array[7] {7,4,3,3,3,2,3}//{5,4,3,3,2,3}
init_rand (692,945,157)     // Supply seeds to initialize the random variable

// Variables modeled exponentially
// Use: init_variable (start_size, end_size, base)
init_tdev (0.5, 0.9, 0.9)
init_rdev (75, 50, 1)
init_twigprob (0.2, 0.9, 0.5)
init_branchl (3.2, 0.16, 0.5)
init_branchw (0.32, 0.003, 0.45)

// Odd variables
init_roots (2)			// Use: init_roots (rootrecursionmax)
init_splinedev (0.1,0.3)	// Use: init_splinedev (min_dev, max_dev)
init_simplify (2,2)		// Use: init_simplify (num_simplify_levels, num_segments)

// Add some gravity
#declare tendancy = <0.05,-0.3,0>;

// Variables for leaves
#declare leafarray = array[5] {maple3,maple2,maple1,maple2,maple1}
#declare leafprob = array[5] {0.23,0.2,0.18,0.15,0.15}
#declare leafscale = array[5] {0.12,0.115,0.13,0.12,0.11}//{0.1325,0.125,0.14,0.13,0.12}
#declare leafnoise = array[5] {1,1,1,1,1}

// Assign the branch texture
#declare branchtexture = texture    
   {   
         normal { bump_map { png "rinde3bump.png" interpolate 2 bump_size 14 } rotate <-5,-12,86> scale 0.21 }  
         pigment { image_map { png "rinde3c.png" interpolate 2 } rotate <-5,-12,86> scale 0.21 }  
         finish { ambient 0.2  diffuse 0.6  }   
       //scale  <10.0, 10.0, 40.0>
   }


// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <1,1,1>
	rotate <0.5,12,9> 
	translate <-4,0.1,-4.0>
}

// Provide feedback in the first 2 recursion levels
#declare feedback = 2;

// Call the macro
splinetree(0,0)        

