#version unofficial Megapov 0.7;


// ----------------          worship   28.Feb.2001           ------------------------
// ----------------     norbert-werner.kern@t-online.de      ------------------------



global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 200  //100
  number_of_waves 10 
  radiosity{ 
    pretrace_start 0.08
    pretrace_end   0.02   
    count 80             
    nearest_count 5      
    error_bound 1 
    recursion_limit 4    
    low_error_factor 0.5 
    gray_threshold 0.0   
    minimum_reuse 0.015  
    brightness 1         
    adc_bailout 0.009091     
  }  
}


camera {
	location <0.4, 0, -14>
	up <0,600/856,0>
	right <1,0,0> 
        look_at <0.6, 5.3, 0> angle 64
       }

light_source {<1000, 8000, 300> rgb 8 }
light_source { <0.4, 0.1, -14> rgb <0.6,0.59,0.51> shadowless }  


#include "colors.inc"
#include "textures.inc"
#declare Grey60 = color rgb 0.6

#declare moostex = texture {
	    pigment { image_map { png "grass5b.png"      
	    #declare n=0;
      #while (n<256)
        transmit n,pow(1-n/255,1)
      #declare n=n+1;
      #end}scale 9 rotate <90,30,0>}
            normal { average normal_map {
             [ bumps 1.4 warp {turbulence 1} scale 1]
             [ bumps 1 warp {turbulence 0.5} scale 0.005]}}
            finish {ambient 0.2 diffuse 0.55}
	}

#declare moostex2 = texture {
	    pigment { image_map { png "pflanzentex4.png"}scale 0.1 rotate <90,30,0>}
            normal { average normal_map {
             [ bumps 0.7 warp {turbulence 1} scale 0.1]
             [ bumps 0.5 warp {turbulence 0.5} scale 0.001]}}
            finish {ambient 0.3 diffuse 0.75 specular 1.6 roughness 0.015}
	}
	


////////////////////////////////////////////////////////


#include "sky2.inc" 

#include "tree1.inc"  
#include "GTtrees.inc"
#include "strauch1.inc" 
#include "baumtot.inc"
#include "nadel2.inc" 
#include "busch4.inc"

#declare figur1 =  union {#include "pferd.inc" scale 0.75 translate  <0.6,0,-3.3>}
#declare figur2 =  union {#include "reiter3a.inc" scale 0.75 translate  <0.6,0,-3.3>}
#declare figur =  union {object {figur1} object {figur2}}
object {figur scale 0.8 translate  <0.38,-0.2,-2.18-1.15>}

#include "beauvais6.inc"   
#include "kran.inc"
#include "gerst.inc"
#include "mauerhf.inc"
#include "steinmauer.inc" 
#include "stadttor.inc"  
 
#include "grasnarbe.inc"
#include "marienkaefer.inc" 
#include "loewenzahn.inc" 
#include "moewe.inc"

    
