#version unofficial MegaPov 0.7;


#declare RAND1=function{noise3d(x*40,y,z*40)}
#declare FUNC1=function{ y+abs(x+2)*0.15-0.2-noise3d(x*2,0,z)*0.5
               -noise3d(x*12,0,z*12)*0.03-RAND1*0.012-noise3d(x*125,y*5,z*125)*0.005
               -noise3d(x*300,y*100,z*300)*0.002-noise3d(x*1000,y*400,z*1000)*0.0005}
object {
 isosurface {
     function{ FUNC1 }
     contained_by{ box {<-8, -0.2, -8>, <8, 0.9, 8>}}  
     method 2
     max_gradient 2.6     
  pigment { image_map { png "erdetex.png" interpolate 2}scale 1.15 rotate <90,30,0>}
     normal { 
        function  {noise3d(x*345,y*345,z*345)*0.4}
        slope_map { [0 <1, 1>]  [0.4 <0, 1>] } scale 0.1 }              
     finish {ambient 0.1 diffuse 0.5}
 } scale <5,3,5> rotate <-3,90,-3> translate <0,-2,-1>
}     





// ======================================
// Example of use of the Makegrass macro
// Gilles Tran - March 1999
// --------------------------------------
// Long grass, yellowish
// --------------------------------------
#include "colors.inc"
#include "mgrass.pov"

#declare PdV=<0,55,-80>;
#declare PdA=<0,12,10>;
//camera{location PdV direction 2*z up y sky y right x*4/3  look_at PdA}

//light_source{0 White*2 translate <-200, 400, -300>}
//light_source{PdA White*0.5 shadowless}

#declare Blanc1=rgb<0.90,0.81,0.81>;

#declare Green1=rgb<230,170,50>/255;
#declare Green2=rgb<110,160,8>/255;
// --------------------------------------
// Grass texture
// --------------------------------------
#declare pigSpotted =pigment {
spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.4]
        [0.2, 0.3   color Tan*0.4 color Green1]
        [0.3, 1.01   color Green1 color Green1*1.2]
    }
}

#declare pigEarth =pigment {
    spotted
    color_map {
        [0 color Tan*0.3]
        [0.6 color Tan*0.3]
        [0.6 color Green1*0.4]
        [1   color Green1*0.4]
    }
}
#declare pigGreen=pigment{Green2*1.3}
//#declare pigSpotted=pigment{Red}
//#declare pigEarth=pigment{Blue}
#declare txtGrass=texture {                  

                pigment {
                        gradient y
                        turbulence 0.2
                                pigment_map {                                
                                    [0.0 pigEarth]
                                    [0.3 pigGreen]
                                    [0.9 pigSpotted]
                                    [1.00 pigEarth]
                                }
                        }
        normal {ripples}
        finish{ambient 0.35 diffuse 0.5 specular 0.1 roughness 0.015}
        scale <0.001,1,0.001>
 
} 
// --------------------------------------
// Patch parameters
// --------------------------------------
// Final number of triangles = nBlade x nBlade x segBlade x 2 (or 4 if dofold = true)
// --------------------------------------
#declare lPatch=70;               // size of patch
//#declare nBlade=4;                // number of blades per line (there will be nBlade x nBlade blades)
#declare nBlade=10;                // number of blades per line (there will be nBlade x nBlade blades)
#declare ryBlade = 0;            // initial y rotation of blade
#declare segBlade= 15;            // number of blade segments
#declare lBlade = 25;             // length of blade
#declare wBlade = 1;              // width of blade at start
#declare wBladeEnd = 0.3;         // width of blade at the end
#declare doSmooth=true;          // true makes smooth triangles
#declare startBend = <0,1,0.3>;   // bending of blade at start (<0,1,0>=no bending)
#declare vBend = <0,-0.5,0>;         // force bending the blade (<0,1,1> = 45)
#declare pwBend = 3;              // bending power (how slowly the curve bends)
#declare rd = 459;                // seed
#declare stdposBlade = 1;         // standard deviation of blade position 0..1
#declare stdrotBlade = 360;       // standard deviation of rotation
#declare stdBlade = 1.5;           // standard deviation of blade scale;
#declare stdBend = 2;            // standard deviation of blade bending;
#declare dofold = true;          // true creates a central fold in the blade (twice more triangles)
#declare dofile = true;          // true creates a mesh file
#declare fname = "fgrass1.inc"     // name of the mesh file to create

// --------------------------------------
// Prairie parameters
// --------------------------------------
#declare nxPrairie=4;             // number of patches for the first line
#declare addPatches=2;            // number of patches to add at each line
#declare nzPrairie=6;            // number of lines of patches
#declare rd=seed(779);            // random seed
#declare stdscale=1.5;            // stddev of scale
#declare hstdscale=1;              
#declare stdrotate=1;             // stddev of rotation
#declare doTest=false;            // replaces the patch with a sphere

// --------------------------------------
// Create the patch and the prairie
// --------------------------------------
#if (dofile=true) // if the patch is already created, turn off the next line
        MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)
        #declare objectPatch=#include fname
#else        
        #declare objectPatch=object{MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)}
#end 
       
union {
object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
texture{moostex2}}
scale 0.003 rotate <-15,0,0> translate <0.4,-0.32,-12.6>}

union {
object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
texture{moostex2}}
scale 0.003 rotate <-10,-40,6> translate <3.3,-0.15,-9.5>}     

union {
object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
texture{moostex2}}
scale 0.003 rotate <-4,-10,-9> translate <0.5,-0.15,-11.2>} 

union {
object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
texture{moostex2}}
scale 0.003 rotate <-1,-10,7> translate <-2.0,-0.1,-11.1>} 

union {
object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
texture{moostex2}}
scale 0.003 rotate <-5,-20,0> translate <1.1,-0.1,-9.5>}    


